use strict;
use warnings FATAL => 'all';

use Apache::Test;
use Apache::TestRequest;
use Apache::TestUtil;


plan tests => 221, need 'include', need_min_apache_version('2.2');

Apache::TestRequest::module('mod_include'); #use this module's port

my $r;
my $body;

### Test #1, context: Options None : AllowOverride Options=IncludesNoExec : Options +Includes

$r = GET("/modules/include/ssi-exec/1/exec.shtml");
ok t_cmp($r->code, 500, "Options should not be allowed for script #1; 500 response expected");

### Test #2, context: Options None : AllowOverride Options=IncludesNoExec : Options +IncludesNoExec

$r = GET("/modules/include/ssi-exec/2/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #2; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, '[an error occurred while processing this directive]', "SSI should be evaluated but exec not permitted for script #2");

### Test #3, context: Options None : AllowOverride Options=IncludesNoExec : Options Includes

$r = GET("/modules/include/ssi-exec/3/exec.shtml");
ok t_cmp($r->code, 500, "Options should not be allowed for script #3; 500 response expected");

### Test #4, context: Options None : AllowOverride Options=IncludesNoExec : Options IncludesNoExec

$r = GET("/modules/include/ssi-exec/4/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #4; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, '[an error occurred while processing this directive]', "SSI should be evaluated but exec not permitted for script #4");

### Test #5, context: Options None : AllowOverride Options=IncludesNoExec : Options -Includes

$r = GET("/modules/include/ssi-exec/5/exec.shtml");
ok t_cmp($r->code, 500, "Options should not be allowed for script #5; 500 response expected");

### Test #6, context: Options None : AllowOverride Options=IncludesNoExec : Options -IncludesNoExec

$r = GET("/modules/include/ssi-exec/6/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #6; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #6");

### Test #7, context: Options None : AllowOverride Options=IncludesNoExec : Options -Includes +IncludesNoExec

$r = GET("/modules/include/ssi-exec/7/exec.shtml");
ok t_cmp($r->code, 500, "Options should not be allowed for script #7; 500 response expected");

### Test #8, context: Options None : AllowOverride Options=IncludesNoExec : Options +Includes -IncludesNoExec

$r = GET("/modules/include/ssi-exec/8/exec.shtml");
ok t_cmp($r->code, 500, "Options should not be allowed for script #8; 500 response expected");

### Test #9, context: Options None : AllowOverride Options=IncludesNoExec : Options -IncludesNoExec +Includes

$r = GET("/modules/include/ssi-exec/9/exec.shtml");
ok t_cmp($r->code, 500, "Options should not be allowed for script #9; 500 response expected");

### Test #10, context: Options None : AllowOverride Options=IncludesNoExec : Options +IncludesNoExec -Includes

$r = GET("/modules/include/ssi-exec/10/exec.shtml");
ok t_cmp($r->code, 500, "Options should not be allowed for script #10; 500 response expected");

### Test #11, context: Options None : AllowOverride Options=Includes : Options +Includes

$r = GET("/modules/include/ssi-exec/11/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #11; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, 'perl cgi', "SSI should be evaluated with exec allowed for script #11");

### Test #12, context: Options None : AllowOverride Options=Includes : Options +IncludesNoExec

$r = GET("/modules/include/ssi-exec/12/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #12; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, '[an error occurred while processing this directive]', "SSI should be evaluated but exec not permitted for script #12");

### Test #13, context: Options None : AllowOverride Options=Includes : Options Includes

$r = GET("/modules/include/ssi-exec/13/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #13; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, 'perl cgi', "SSI should be evaluated with exec allowed for script #13");

### Test #14, context: Options None : AllowOverride Options=Includes : Options IncludesNoExec

$r = GET("/modules/include/ssi-exec/14/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #14; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, '[an error occurred while processing this directive]', "SSI should be evaluated but exec not permitted for script #14");

### Test #15, context: Options None : AllowOverride Options=Includes : Options -Includes

$r = GET("/modules/include/ssi-exec/15/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #15; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #15");

### Test #16, context: Options None : AllowOverride Options=Includes : Options -IncludesNoExec

$r = GET("/modules/include/ssi-exec/16/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #16; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #16");

### Test #17, context: Options None : AllowOverride Options=Includes : Options -Includes +IncludesNoExec

$r = GET("/modules/include/ssi-exec/17/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #17; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, '[an error occurred while processing this directive]', "SSI should be evaluated but exec not permitted for script #17");

### Test #18, context: Options None : AllowOverride Options=Includes : Options +Includes -IncludesNoExec

$r = GET("/modules/include/ssi-exec/18/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #18; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #18");

### Test #19, context: Options None : AllowOverride Options=Includes : Options -IncludesNoExec +Includes

$r = GET("/modules/include/ssi-exec/19/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #19; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, 'perl cgi', "SSI should be evaluated with exec allowed for script #19");

### Test #20, context: Options None : AllowOverride Options=Includes : Options +IncludesNoExec -Includes

$r = GET("/modules/include/ssi-exec/20/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #20; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #20");

### Test #21, context: Options None : AllowOverride All : Options +Includes

$r = GET("/modules/include/ssi-exec/21/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #21; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, 'perl cgi', "SSI should be evaluated with exec allowed for script #21");

### Test #22, context: Options None : AllowOverride All : Options +IncludesNoExec

$r = GET("/modules/include/ssi-exec/22/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #22; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, '[an error occurred while processing this directive]', "SSI should be evaluated but exec not permitted for script #22");

### Test #23, context: Options None : AllowOverride All : Options Includes

$r = GET("/modules/include/ssi-exec/23/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #23; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, 'perl cgi', "SSI should be evaluated with exec allowed for script #23");

### Test #24, context: Options None : AllowOverride All : Options IncludesNoExec

$r = GET("/modules/include/ssi-exec/24/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #24; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, '[an error occurred while processing this directive]', "SSI should be evaluated but exec not permitted for script #24");

### Test #25, context: Options None : AllowOverride All : Options -Includes

$r = GET("/modules/include/ssi-exec/25/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #25; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #25");

### Test #26, context: Options None : AllowOverride All : Options -IncludesNoExec

$r = GET("/modules/include/ssi-exec/26/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #26; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #26");

### Test #27, context: Options None : AllowOverride All : Options -Includes +IncludesNoExec

$r = GET("/modules/include/ssi-exec/27/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #27; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, '[an error occurred while processing this directive]', "SSI should be evaluated but exec not permitted for script #27");

### Test #28, context: Options None : AllowOverride All : Options +Includes -IncludesNoExec

$r = GET("/modules/include/ssi-exec/28/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #28; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #28");

### Test #29, context: Options None : AllowOverride All : Options -IncludesNoExec +Includes

$r = GET("/modules/include/ssi-exec/29/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #29; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, 'perl cgi', "SSI should be evaluated with exec allowed for script #29");

### Test #30, context: Options None : AllowOverride All : Options +IncludesNoExec -Includes

$r = GET("/modules/include/ssi-exec/30/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #30; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #30");

### Test #31, context: Options None : AllowOverride None : Options +Includes

$r = GET("/modules/include/ssi-exec/31/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #31; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #31");

### Test #32, context: Options None : AllowOverride None : Options +IncludesNoExec

$r = GET("/modules/include/ssi-exec/32/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #32; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #32");

### Test #33, context: Options None : AllowOverride None : Options Includes

$r = GET("/modules/include/ssi-exec/33/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #33; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #33");

### Test #34, context: Options None : AllowOverride None : Options IncludesNoExec

$r = GET("/modules/include/ssi-exec/34/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #34; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #34");

### Test #35, context: Options None : AllowOverride None : Options -Includes

$r = GET("/modules/include/ssi-exec/35/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #35; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #35");

### Test #36, context: Options None : AllowOverride None : Options -IncludesNoExec

$r = GET("/modules/include/ssi-exec/36/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #36; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #36");

### Test #37, context: Options None : AllowOverride None : Options -Includes +IncludesNoExec

$r = GET("/modules/include/ssi-exec/37/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #37; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #37");

### Test #38, context: Options None : AllowOverride None : Options +Includes -IncludesNoExec

$r = GET("/modules/include/ssi-exec/38/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #38; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #38");

### Test #39, context: Options None : AllowOverride None : Options -IncludesNoExec +Includes

$r = GET("/modules/include/ssi-exec/39/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #39; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #39");

### Test #40, context: Options None : AllowOverride None : Options +IncludesNoExec -Includes

$r = GET("/modules/include/ssi-exec/40/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #40; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #40");

### Test #41, context: Options IncludesNoExec : AllowOverride Options=IncludesNoExec : Options +Includes

$r = GET("/modules/include/ssi-exec/41/exec.shtml");
ok t_cmp($r->code, 500, "Options should not be allowed for script #41; 500 response expected");

### Test #42, context: Options IncludesNoExec : AllowOverride Options=IncludesNoExec : Options +IncludesNoExec

$r = GET("/modules/include/ssi-exec/42/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #42; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, '[an error occurred while processing this directive]', "SSI should be evaluated but exec not permitted for script #42");

### Test #43, context: Options IncludesNoExec : AllowOverride Options=IncludesNoExec : Options Includes

$r = GET("/modules/include/ssi-exec/43/exec.shtml");
ok t_cmp($r->code, 500, "Options should not be allowed for script #43; 500 response expected");

### Test #44, context: Options IncludesNoExec : AllowOverride Options=IncludesNoExec : Options IncludesNoExec

$r = GET("/modules/include/ssi-exec/44/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #44; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, '[an error occurred while processing this directive]', "SSI should be evaluated but exec not permitted for script #44");

### Test #45, context: Options IncludesNoExec : AllowOverride Options=IncludesNoExec : Options -Includes

$r = GET("/modules/include/ssi-exec/45/exec.shtml");
ok t_cmp($r->code, 500, "Options should not be allowed for script #45; 500 response expected");

### Test #46, context: Options IncludesNoExec : AllowOverride Options=IncludesNoExec : Options -IncludesNoExec

$r = GET("/modules/include/ssi-exec/46/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #46; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #46");

### Test #47, context: Options IncludesNoExec : AllowOverride Options=IncludesNoExec : Options -Includes +IncludesNoExec

$r = GET("/modules/include/ssi-exec/47/exec.shtml");
ok t_cmp($r->code, 500, "Options should not be allowed for script #47; 500 response expected");

### Test #48, context: Options IncludesNoExec : AllowOverride Options=IncludesNoExec : Options +Includes -IncludesNoExec

$r = GET("/modules/include/ssi-exec/48/exec.shtml");
ok t_cmp($r->code, 500, "Options should not be allowed for script #48; 500 response expected");

### Test #49, context: Options IncludesNoExec : AllowOverride Options=IncludesNoExec : Options -IncludesNoExec +Includes

$r = GET("/modules/include/ssi-exec/49/exec.shtml");
ok t_cmp($r->code, 500, "Options should not be allowed for script #49; 500 response expected");

### Test #50, context: Options IncludesNoExec : AllowOverride Options=IncludesNoExec : Options +IncludesNoExec -Includes

$r = GET("/modules/include/ssi-exec/50/exec.shtml");
ok t_cmp($r->code, 500, "Options should not be allowed for script #50; 500 response expected");

### Test #51, context: Options IncludesNoExec : AllowOverride Options=Includes : Options +Includes

$r = GET("/modules/include/ssi-exec/51/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #51; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, 'perl cgi', "SSI should be evaluated with exec allowed for script #51");

### Test #52, context: Options IncludesNoExec : AllowOverride Options=Includes : Options +IncludesNoExec

$r = GET("/modules/include/ssi-exec/52/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #52; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, '[an error occurred while processing this directive]', "SSI should be evaluated but exec not permitted for script #52");

### Test #53, context: Options IncludesNoExec : AllowOverride Options=Includes : Options Includes

$r = GET("/modules/include/ssi-exec/53/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #53; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, 'perl cgi', "SSI should be evaluated with exec allowed for script #53");

### Test #54, context: Options IncludesNoExec : AllowOverride Options=Includes : Options IncludesNoExec

$r = GET("/modules/include/ssi-exec/54/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #54; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, '[an error occurred while processing this directive]', "SSI should be evaluated but exec not permitted for script #54");

### Test #55, context: Options IncludesNoExec : AllowOverride Options=Includes : Options -Includes

$r = GET("/modules/include/ssi-exec/55/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #55; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #55");

### Test #56, context: Options IncludesNoExec : AllowOverride Options=Includes : Options -IncludesNoExec

$r = GET("/modules/include/ssi-exec/56/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #56; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #56");

### Test #57, context: Options IncludesNoExec : AllowOverride Options=Includes : Options -Includes +IncludesNoExec

$r = GET("/modules/include/ssi-exec/57/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #57; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, '[an error occurred while processing this directive]', "SSI should be evaluated but exec not permitted for script #57");

### Test #58, context: Options IncludesNoExec : AllowOverride Options=Includes : Options +Includes -IncludesNoExec

$r = GET("/modules/include/ssi-exec/58/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #58; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #58");

### Test #59, context: Options IncludesNoExec : AllowOverride Options=Includes : Options -IncludesNoExec +Includes

$r = GET("/modules/include/ssi-exec/59/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #59; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, 'perl cgi', "SSI should be evaluated with exec allowed for script #59");

### Test #60, context: Options IncludesNoExec : AllowOverride Options=Includes : Options +IncludesNoExec -Includes

$r = GET("/modules/include/ssi-exec/60/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #60; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #60");

### Test #61, context: Options IncludesNoExec : AllowOverride All : Options +Includes

$r = GET("/modules/include/ssi-exec/61/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #61; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, 'perl cgi', "SSI should be evaluated with exec allowed for script #61");

### Test #62, context: Options IncludesNoExec : AllowOverride All : Options +IncludesNoExec

$r = GET("/modules/include/ssi-exec/62/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #62; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, '[an error occurred while processing this directive]', "SSI should be evaluated but exec not permitted for script #62");

### Test #63, context: Options IncludesNoExec : AllowOverride All : Options Includes

$r = GET("/modules/include/ssi-exec/63/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #63; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, 'perl cgi', "SSI should be evaluated with exec allowed for script #63");

### Test #64, context: Options IncludesNoExec : AllowOverride All : Options IncludesNoExec

$r = GET("/modules/include/ssi-exec/64/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #64; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, '[an error occurred while processing this directive]', "SSI should be evaluated but exec not permitted for script #64");

### Test #65, context: Options IncludesNoExec : AllowOverride All : Options -Includes

$r = GET("/modules/include/ssi-exec/65/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #65; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #65");

### Test #66, context: Options IncludesNoExec : AllowOverride All : Options -IncludesNoExec

$r = GET("/modules/include/ssi-exec/66/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #66; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #66");

### Test #67, context: Options IncludesNoExec : AllowOverride All : Options -Includes +IncludesNoExec

$r = GET("/modules/include/ssi-exec/67/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #67; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, '[an error occurred while processing this directive]', "SSI should be evaluated but exec not permitted for script #67");

### Test #68, context: Options IncludesNoExec : AllowOverride All : Options +Includes -IncludesNoExec

$r = GET("/modules/include/ssi-exec/68/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #68; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #68");

### Test #69, context: Options IncludesNoExec : AllowOverride All : Options -IncludesNoExec +Includes

$r = GET("/modules/include/ssi-exec/69/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #69; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, 'perl cgi', "SSI should be evaluated with exec allowed for script #69");

### Test #70, context: Options IncludesNoExec : AllowOverride All : Options +IncludesNoExec -Includes

$r = GET("/modules/include/ssi-exec/70/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #70; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #70");

### Test #71, context: Options IncludesNoExec : AllowOverride None : Options +Includes

$r = GET("/modules/include/ssi-exec/71/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #71; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, '[an error occurred while processing this directive]', "SSI should be evaluated but exec not permitted for script #71");

### Test #72, context: Options IncludesNoExec : AllowOverride None : Options +IncludesNoExec

$r = GET("/modules/include/ssi-exec/72/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #72; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, '[an error occurred while processing this directive]', "SSI should be evaluated but exec not permitted for script #72");

### Test #73, context: Options IncludesNoExec : AllowOverride None : Options Includes

$r = GET("/modules/include/ssi-exec/73/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #73; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, '[an error occurred while processing this directive]', "SSI should be evaluated but exec not permitted for script #73");

### Test #74, context: Options IncludesNoExec : AllowOverride None : Options IncludesNoExec

$r = GET("/modules/include/ssi-exec/74/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #74; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, '[an error occurred while processing this directive]', "SSI should be evaluated but exec not permitted for script #74");

### Test #75, context: Options IncludesNoExec : AllowOverride None : Options -Includes

$r = GET("/modules/include/ssi-exec/75/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #75; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, '[an error occurred while processing this directive]', "SSI should be evaluated but exec not permitted for script #75");

### Test #76, context: Options IncludesNoExec : AllowOverride None : Options -IncludesNoExec

$r = GET("/modules/include/ssi-exec/76/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #76; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, '[an error occurred while processing this directive]', "SSI should be evaluated but exec not permitted for script #76");

### Test #77, context: Options IncludesNoExec : AllowOverride None : Options -Includes +IncludesNoExec

$r = GET("/modules/include/ssi-exec/77/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #77; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, '[an error occurred while processing this directive]', "SSI should be evaluated but exec not permitted for script #77");

### Test #78, context: Options IncludesNoExec : AllowOverride None : Options +Includes -IncludesNoExec

$r = GET("/modules/include/ssi-exec/78/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #78; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, '[an error occurred while processing this directive]', "SSI should be evaluated but exec not permitted for script #78");

### Test #79, context: Options IncludesNoExec : AllowOverride None : Options -IncludesNoExec +Includes

$r = GET("/modules/include/ssi-exec/79/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #79; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, '[an error occurred while processing this directive]', "SSI should be evaluated but exec not permitted for script #79");

### Test #80, context: Options IncludesNoExec : AllowOverride None : Options +IncludesNoExec -Includes

$r = GET("/modules/include/ssi-exec/80/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #80; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, '[an error occurred while processing this directive]', "SSI should be evaluated but exec not permitted for script #80");

### Test #81, context: Options Includes : AllowOverride Options=IncludesNoExec : Options +Includes

$r = GET("/modules/include/ssi-exec/81/exec.shtml");
ok t_cmp($r->code, 500, "Options should not be allowed for script #81; 500 response expected");

### Test #82, context: Options Includes : AllowOverride Options=IncludesNoExec : Options +IncludesNoExec

$r = GET("/modules/include/ssi-exec/82/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #82; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, '[an error occurred while processing this directive]', "SSI should be evaluated but exec not permitted for script #82");

### Test #83, context: Options Includes : AllowOverride Options=IncludesNoExec : Options Includes

$r = GET("/modules/include/ssi-exec/83/exec.shtml");
ok t_cmp($r->code, 500, "Options should not be allowed for script #83; 500 response expected");

### Test #84, context: Options Includes : AllowOverride Options=IncludesNoExec : Options IncludesNoExec

$r = GET("/modules/include/ssi-exec/84/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #84; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, '[an error occurred while processing this directive]', "SSI should be evaluated but exec not permitted for script #84");

### Test #85, context: Options Includes : AllowOverride Options=IncludesNoExec : Options -Includes

$r = GET("/modules/include/ssi-exec/85/exec.shtml");
ok t_cmp($r->code, 500, "Options should not be allowed for script #85; 500 response expected");

### Test #86, context: Options Includes : AllowOverride Options=IncludesNoExec : Options -IncludesNoExec

$r = GET("/modules/include/ssi-exec/86/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #86; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #86");

### Test #87, context: Options Includes : AllowOverride Options=IncludesNoExec : Options -Includes +IncludesNoExec

$r = GET("/modules/include/ssi-exec/87/exec.shtml");
ok t_cmp($r->code, 500, "Options should not be allowed for script #87; 500 response expected");

### Test #88, context: Options Includes : AllowOverride Options=IncludesNoExec : Options +Includes -IncludesNoExec

$r = GET("/modules/include/ssi-exec/88/exec.shtml");
ok t_cmp($r->code, 500, "Options should not be allowed for script #88; 500 response expected");

### Test #89, context: Options Includes : AllowOverride Options=IncludesNoExec : Options -IncludesNoExec +Includes

$r = GET("/modules/include/ssi-exec/89/exec.shtml");
ok t_cmp($r->code, 500, "Options should not be allowed for script #89; 500 response expected");

### Test #90, context: Options Includes : AllowOverride Options=IncludesNoExec : Options +IncludesNoExec -Includes

$r = GET("/modules/include/ssi-exec/90/exec.shtml");
ok t_cmp($r->code, 500, "Options should not be allowed for script #90; 500 response expected");

### Test #91, context: Options Includes : AllowOverride Options=Includes : Options +Includes

$r = GET("/modules/include/ssi-exec/91/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #91; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, 'perl cgi', "SSI should be evaluated with exec allowed for script #91");

### Test #92, context: Options Includes : AllowOverride Options=Includes : Options +IncludesNoExec

$r = GET("/modules/include/ssi-exec/92/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #92; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, '[an error occurred while processing this directive]', "SSI should be evaluated but exec not permitted for script #92");

### Test #93, context: Options Includes : AllowOverride Options=Includes : Options Includes

$r = GET("/modules/include/ssi-exec/93/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #93; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, 'perl cgi', "SSI should be evaluated with exec allowed for script #93");

### Test #94, context: Options Includes : AllowOverride Options=Includes : Options IncludesNoExec

$r = GET("/modules/include/ssi-exec/94/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #94; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, '[an error occurred while processing this directive]', "SSI should be evaluated but exec not permitted for script #94");

### Test #95, context: Options Includes : AllowOverride Options=Includes : Options -Includes

$r = GET("/modules/include/ssi-exec/95/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #95; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #95");

### Test #96, context: Options Includes : AllowOverride Options=Includes : Options -IncludesNoExec

$r = GET("/modules/include/ssi-exec/96/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #96; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #96");

### Test #97, context: Options Includes : AllowOverride Options=Includes : Options -Includes +IncludesNoExec

$r = GET("/modules/include/ssi-exec/97/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #97; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, '[an error occurred while processing this directive]', "SSI should be evaluated but exec not permitted for script #97");

### Test #98, context: Options Includes : AllowOverride Options=Includes : Options +Includes -IncludesNoExec

$r = GET("/modules/include/ssi-exec/98/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #98; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #98");

### Test #99, context: Options Includes : AllowOverride Options=Includes : Options -IncludesNoExec +Includes

$r = GET("/modules/include/ssi-exec/99/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #99; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, 'perl cgi', "SSI should be evaluated with exec allowed for script #99");

### Test #100, context: Options Includes : AllowOverride Options=Includes : Options +IncludesNoExec -Includes

$r = GET("/modules/include/ssi-exec/100/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #100; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #100");

### Test #101, context: Options Includes : AllowOverride All : Options +Includes

$r = GET("/modules/include/ssi-exec/101/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #101; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, 'perl cgi', "SSI should be evaluated with exec allowed for script #101");

### Test #102, context: Options Includes : AllowOverride All : Options +IncludesNoExec

$r = GET("/modules/include/ssi-exec/102/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #102; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, '[an error occurred while processing this directive]', "SSI should be evaluated but exec not permitted for script #102");

### Test #103, context: Options Includes : AllowOverride All : Options Includes

$r = GET("/modules/include/ssi-exec/103/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #103; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, 'perl cgi', "SSI should be evaluated with exec allowed for script #103");

### Test #104, context: Options Includes : AllowOverride All : Options IncludesNoExec

$r = GET("/modules/include/ssi-exec/104/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #104; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, '[an error occurred while processing this directive]', "SSI should be evaluated but exec not permitted for script #104");

### Test #105, context: Options Includes : AllowOverride All : Options -Includes

$r = GET("/modules/include/ssi-exec/105/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #105; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #105");

### Test #106, context: Options Includes : AllowOverride All : Options -IncludesNoExec

$r = GET("/modules/include/ssi-exec/106/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #106; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #106");

### Test #107, context: Options Includes : AllowOverride All : Options -Includes +IncludesNoExec

$r = GET("/modules/include/ssi-exec/107/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #107; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, '[an error occurred while processing this directive]', "SSI should be evaluated but exec not permitted for script #107");

### Test #108, context: Options Includes : AllowOverride All : Options +Includes -IncludesNoExec

$r = GET("/modules/include/ssi-exec/108/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #108; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #108");

### Test #109, context: Options Includes : AllowOverride All : Options -IncludesNoExec +Includes

$r = GET("/modules/include/ssi-exec/109/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #109; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, 'perl cgi', "SSI should be evaluated with exec allowed for script #109");

### Test #110, context: Options Includes : AllowOverride All : Options +IncludesNoExec -Includes

$r = GET("/modules/include/ssi-exec/110/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #110; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, qr/--\#exec cgi=/, "SSI should not be evaluated for script #110");

### Test #111, context: Options Includes : AllowOverride None : Options +Includes

$r = GET("/modules/include/ssi-exec/111/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #111; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, 'perl cgi', "SSI should be evaluated with exec allowed for script #111");

### Test #112, context: Options Includes : AllowOverride None : Options +IncludesNoExec

$r = GET("/modules/include/ssi-exec/112/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #112; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, 'perl cgi', "SSI should be evaluated with exec allowed for script #112");

### Test #113, context: Options Includes : AllowOverride None : Options Includes

$r = GET("/modules/include/ssi-exec/113/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #113; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, 'perl cgi', "SSI should be evaluated with exec allowed for script #113");

### Test #114, context: Options Includes : AllowOverride None : Options IncludesNoExec

$r = GET("/modules/include/ssi-exec/114/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #114; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, 'perl cgi', "SSI should be evaluated with exec allowed for script #114");

### Test #115, context: Options Includes : AllowOverride None : Options -Includes

$r = GET("/modules/include/ssi-exec/115/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #115; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, 'perl cgi', "SSI should be evaluated with exec allowed for script #115");

### Test #116, context: Options Includes : AllowOverride None : Options -IncludesNoExec

$r = GET("/modules/include/ssi-exec/116/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #116; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, 'perl cgi', "SSI should be evaluated with exec allowed for script #116");

### Test #117, context: Options Includes : AllowOverride None : Options -Includes +IncludesNoExec

$r = GET("/modules/include/ssi-exec/117/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #117; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, 'perl cgi', "SSI should be evaluated with exec allowed for script #117");

### Test #118, context: Options Includes : AllowOverride None : Options +Includes -IncludesNoExec

$r = GET("/modules/include/ssi-exec/118/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #118; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, 'perl cgi', "SSI should be evaluated with exec allowed for script #118");

### Test #119, context: Options Includes : AllowOverride None : Options -IncludesNoExec +Includes

$r = GET("/modules/include/ssi-exec/119/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #119; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, 'perl cgi', "SSI should be evaluated with exec allowed for script #119");

### Test #120, context: Options Includes : AllowOverride None : Options +IncludesNoExec -Includes

$r = GET("/modules/include/ssi-exec/120/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #120; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, 'perl cgi', "SSI should be evaluated with exec allowed for script #120");

### Test #121, context: Options Includes : AllowOverride None : No options in subdir, no .htaccess

$r = GET("/modules/include/ssi-exec/121/subdir/exec.shtml");
ok t_cmp($r->code, 200, "Options should be allowed for script #121; 200 response expected");

$body = $r->content;
chomp $body;

ok t_cmp($body, 'perl cgi', "SSI should be evaluated with exec allowed for script #121");

