//! DO NOT EDIT! This file is generated by `xtask`.
//! Contains tests for the `event!` macro.
#![deny(warnings)]
#![no_implicit_prelude]

extern crate tracing;

// We call all macros in this module with `no_implicit_prelude` to ensure they do not depend on the standard prelude.
#[cfg(target_arch = "wasm32")]
extern crate wasm_bindgen_test;

struct Disp {
    val: u64,
}

impl ::std::fmt::Display for Disp {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        ::std::write!(f, "Disp.val={val}", val = self.val)
    }
}

struct Deb {
    val: u64,
}

/// Manual implementation because otherwise `val` is unused.
impl ::std::fmt::Debug for Deb {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        f.debug_struct("Deb").field("val", &self.val).finish()
    }
}

struct Sub {
    field: u64,
}
#[cfg_attr(target_arch = "wasm32", wasm_bindgen_test::wasm_bindgen_test)]
#[test]
fn event() {
    const CONST_VAR: &str = "const-field";

    let var = true;
    let sub = Sub { field: 4, };
    let disp = Disp { val: 61, };
    let deb = Deb { val: 102, };

    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = 3); // DEBUG:event,ntp,-,-,-,"ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = 3); // DEBUG:event,ntp,-,p,-,"ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = 3, qux = 3); // DEBUG:event,ntp,-,f,-,"ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = 3, qux = 3); // DEBUG:event,ntp,-,pf,-,"ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = 3, "msg without args"); // DEBUG:event,ntp,-,-,m,"ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = 3, "msg without args"); // DEBUG:event,ntp,-,p,m,"ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = 3, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = 3, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = 3 }, "msg without args"); // DEBUG:event,ntp,{},-,m,"ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = 3 }, "msg without args"); // DEBUG:event,ntp,{},p,m,"ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = 3, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = 3, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = false); // DEBUG:event,ntp,-,-,-,"ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = false); // DEBUG:event,ntp,-,p,-,"ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = false, qux = 3); // DEBUG:event,ntp,-,f,-,"ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = false, qux = 3); // DEBUG:event,ntp,-,pf,-,"ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = false, "msg without args"); // DEBUG:event,ntp,-,-,m,"ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = false, "msg without args"); // DEBUG:event,ntp,-,p,m,"ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = false, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = false, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = false }, "msg without args"); // DEBUG:event,ntp,{},-,m,"ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = false }, "msg without args"); // DEBUG:event,ntp,{},p,m,"ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = false, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = false, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = false, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = false, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = false }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = false }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?3); // DEBUG:event,ntp,-,-,-,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?3); // DEBUG:event,ntp,-,p,-,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?3, qux = 3); // DEBUG:event,ntp,-,f,-,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?3, qux = 3); // DEBUG:event,ntp,-,pf,-,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?3, "msg without args"); // DEBUG:event,ntp,-,-,m,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?3, "msg without args"); // DEBUG:event,ntp,-,p,m,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?3, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?3, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?3 }, "msg without args"); // DEBUG:event,ntp,{},-,m,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?3 }, "msg without args"); // DEBUG:event,ntp,{},p,m,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?3, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?3, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %3); // DEBUG:event,ntp,-,-,-,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %3); // DEBUG:event,ntp,-,p,-,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %3, qux = 3); // DEBUG:event,ntp,-,f,-,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %3, qux = 3); // DEBUG:event,ntp,-,pf,-,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %3, "msg without args"); // DEBUG:event,ntp,-,-,m,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %3, "msg without args"); // DEBUG:event,ntp,-,p,m,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %3, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %3, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %3 }, "msg without args"); // DEBUG:event,ntp,{},-,m,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %3 }, "msg without args"); // DEBUG:event,ntp,{},p,m,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %3, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %3, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?deb); // DEBUG:event,ntp,-,-,-,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?deb); // DEBUG:event,ntp,-,p,-,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?deb, qux = 3); // DEBUG:event,ntp,-,f,-,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?deb, qux = 3); // DEBUG:event,ntp,-,pf,-,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?deb, "msg without args"); // DEBUG:event,ntp,-,-,m,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?deb, "msg without args"); // DEBUG:event,ntp,-,p,m,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?deb, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?deb, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?deb }, "msg without args"); // DEBUG:event,ntp,{},-,m,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?deb }, "msg without args"); // DEBUG:event,ntp,{},p,m,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %disp); // DEBUG:event,ntp,-,-,-,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %disp); // DEBUG:event,ntp,-,p,-,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %disp, qux = 3); // DEBUG:event,ntp,-,f,-,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %disp, qux = 3); // DEBUG:event,ntp,-,pf,-,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %disp, "msg without args"); // DEBUG:event,ntp,-,-,m,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %disp, "msg without args"); // DEBUG:event,ntp,-,p,m,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %disp, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %disp, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %disp }, "msg without args"); // DEBUG:event,ntp,{},-,m,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %disp }, "msg without args"); // DEBUG:event,ntp,{},p,m,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %disp, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %disp, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %disp, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %disp, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?sub.field); // DEBUG:event,ntp,-,-,-,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?sub.field); // DEBUG:event,ntp,-,p,-,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?sub.field, qux = 3); // DEBUG:event,ntp,-,f,-,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?sub.field, qux = 3); // DEBUG:event,ntp,-,pf,-,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?sub.field, "msg without args"); // DEBUG:event,ntp,-,-,m,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?sub.field, "msg without args"); // DEBUG:event,ntp,-,p,m,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?sub.field }, "msg without args"); // DEBUG:event,ntp,{},-,m,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?sub.field }, "msg without args"); // DEBUG:event,ntp,{},p,m,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %sub.field); // DEBUG:event,ntp,-,-,-,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %sub.field); // DEBUG:event,ntp,-,p,-,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %sub.field, qux = 3); // DEBUG:event,ntp,-,f,-,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %sub.field, qux = 3); // DEBUG:event,ntp,-,pf,-,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %sub.field, "msg without args"); // DEBUG:event,ntp,-,-,m,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %sub.field, "msg without args"); // DEBUG:event,ntp,-,p,m,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %sub.field, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %sub.field, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %sub.field }, "msg without args"); // DEBUG:event,ntp,{},-,m,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %sub.field }, "msg without args"); // DEBUG:event,ntp,{},p,m,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = debug(&deb)); // DEBUG:event,ntp,-,-,-,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = debug(&deb)); // DEBUG:event,ntp,-,p,-,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = debug(&deb), qux = 3); // DEBUG:event,ntp,-,f,-,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = debug(&deb), qux = 3); // DEBUG:event,ntp,-,pf,-,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = debug(&deb), "msg without args"); // DEBUG:event,ntp,-,-,m,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = debug(&deb), "msg without args"); // DEBUG:event,ntp,-,p,m,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = debug(&deb) }, "msg without args"); // DEBUG:event,ntp,{},-,m,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = debug(&deb) }, "msg without args"); // DEBUG:event,ntp,{},p,m,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = display(&disp)); // DEBUG:event,ntp,-,-,-,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = display(&disp)); // DEBUG:event,ntp,-,p,-,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = display(&disp), qux = 3); // DEBUG:event,ntp,-,f,-,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = display(&disp), qux = 3); // DEBUG:event,ntp,-,pf,-,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = display(&disp), "msg without args"); // DEBUG:event,ntp,-,-,m,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = display(&disp), "msg without args"); // DEBUG:event,ntp,-,p,m,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = display(&disp), qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = display(&disp), qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = display(&disp) }, "msg without args"); // DEBUG:event,ntp,{},-,m,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = display(&disp) }, "msg without args"); // DEBUG:event,ntp,{},p,m,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = tracing::field::Empty); // DEBUG:event,ntp,-,-,-,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = tracing::field::Empty); // DEBUG:event,ntp,-,p,-,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = tracing::field::Empty, qux = 3); // DEBUG:event,ntp,-,f,-,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = tracing::field::Empty, qux = 3); // DEBUG:event,ntp,-,pf,-,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = tracing::field::Empty, "msg without args"); // DEBUG:event,ntp,-,-,m,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = tracing::field::Empty, "msg without args"); // DEBUG:event,ntp,-,p,m,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = tracing::field::Empty }, "msg without args"); // DEBUG:event,ntp,{},-,m,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = tracing::field::Empty }, "msg without args"); // DEBUG:event,ntp,{},p,m,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = 3); // DEBUG:event,ntp,-,-,-,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = 3); // DEBUG:event,ntp,-,p,-,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = 3, qux = 3); // DEBUG:event,ntp,-,f,-,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = 3, qux = 3); // DEBUG:event,ntp,-,pf,-,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = 3, "msg without args"); // DEBUG:event,ntp,-,-,m,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = 3, "msg without args"); // DEBUG:event,ntp,-,p,m,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = 3 }, "msg without args"); // DEBUG:event,ntp,{},-,m,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = 3 }, "msg without args"); // DEBUG:event,ntp,{},p,m,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = false); // DEBUG:event,ntp,-,-,-,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = false); // DEBUG:event,ntp,-,p,-,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = false, qux = 3); // DEBUG:event,ntp,-,f,-,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = false, qux = 3); // DEBUG:event,ntp,-,pf,-,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = false, "msg without args"); // DEBUG:event,ntp,-,-,m,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = false, "msg without args"); // DEBUG:event,ntp,-,p,m,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = false, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = false, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = false }, "msg without args"); // DEBUG:event,ntp,{},-,m,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = false }, "msg without args"); // DEBUG:event,ntp,{},p,m,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?3); // DEBUG:event,ntp,-,-,-,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?3); // DEBUG:event,ntp,-,p,-,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?3, qux = 3); // DEBUG:event,ntp,-,f,-,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?3, qux = 3); // DEBUG:event,ntp,-,pf,-,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?3, "msg without args"); // DEBUG:event,ntp,-,-,m,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?3, "msg without args"); // DEBUG:event,ntp,-,p,m,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?3 }, "msg without args"); // DEBUG:event,ntp,{},-,m,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?3 }, "msg without args"); // DEBUG:event,ntp,{},p,m,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %3); // DEBUG:event,ntp,-,-,-,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %3); // DEBUG:event,ntp,-,p,-,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %3, qux = 3); // DEBUG:event,ntp,-,f,-,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %3, qux = 3); // DEBUG:event,ntp,-,pf,-,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %3, "msg without args"); // DEBUG:event,ntp,-,-,m,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %3, "msg without args"); // DEBUG:event,ntp,-,p,m,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %3 }, "msg without args"); // DEBUG:event,ntp,{},-,m,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %3 }, "msg without args"); // DEBUG:event,ntp,{},p,m,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?deb); // DEBUG:event,ntp,-,-,-,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?deb); // DEBUG:event,ntp,-,p,-,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?deb, qux = 3); // DEBUG:event,ntp,-,f,-,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?deb, qux = 3); // DEBUG:event,ntp,-,pf,-,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?deb, "msg without args"); // DEBUG:event,ntp,-,-,m,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?deb, "msg without args"); // DEBUG:event,ntp,-,p,m,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?deb }, "msg without args"); // DEBUG:event,ntp,{},-,m,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?deb }, "msg without args"); // DEBUG:event,ntp,{},p,m,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %disp); // DEBUG:event,ntp,-,-,-,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %disp); // DEBUG:event,ntp,-,p,-,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %disp, qux = 3); // DEBUG:event,ntp,-,f,-,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %disp, qux = 3); // DEBUG:event,ntp,-,pf,-,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %disp, "msg without args"); // DEBUG:event,ntp,-,-,m,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %disp, "msg without args"); // DEBUG:event,ntp,-,p,m,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %disp }, "msg without args"); // DEBUG:event,ntp,{},-,m,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %disp }, "msg without args"); // DEBUG:event,ntp,{},p,m,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?sub.field); // DEBUG:event,ntp,-,-,-,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?sub.field); // DEBUG:event,ntp,-,p,-,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?sub.field, qux = 3); // DEBUG:event,ntp,-,f,-,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?sub.field, qux = 3); // DEBUG:event,ntp,-,pf,-,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?sub.field, "msg without args"); // DEBUG:event,ntp,-,-,m,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?sub.field, "msg without args"); // DEBUG:event,ntp,-,p,m,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?sub.field }, "msg without args"); // DEBUG:event,ntp,{},-,m,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?sub.field }, "msg without args"); // DEBUG:event,ntp,{},p,m,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %sub.field); // DEBUG:event,ntp,-,-,-,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %sub.field); // DEBUG:event,ntp,-,p,-,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %sub.field, qux = 3); // DEBUG:event,ntp,-,f,-,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %sub.field, qux = 3); // DEBUG:event,ntp,-,pf,-,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %sub.field, "msg without args"); // DEBUG:event,ntp,-,-,m,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %sub.field, "msg without args"); // DEBUG:event,ntp,-,p,m,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %sub.field }, "msg without args"); // DEBUG:event,ntp,{},-,m,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %sub.field }, "msg without args"); // DEBUG:event,ntp,{},p,m,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = debug(&deb)); // DEBUG:event,ntp,-,-,-,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = debug(&deb)); // DEBUG:event,ntp,-,p,-,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = debug(&deb), qux = 3); // DEBUG:event,ntp,-,f,-,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = debug(&deb), qux = 3); // DEBUG:event,ntp,-,pf,-,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = debug(&deb), "msg without args"); // DEBUG:event,ntp,-,-,m,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = debug(&deb), "msg without args"); // DEBUG:event,ntp,-,p,m,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:event,ntp,{},-,m,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:event,ntp,{},p,m,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = display(&disp)); // DEBUG:event,ntp,-,-,-,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = display(&disp)); // DEBUG:event,ntp,-,p,-,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = display(&disp), qux = 3); // DEBUG:event,ntp,-,f,-,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = display(&disp), qux = 3); // DEBUG:event,ntp,-,pf,-,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = display(&disp), "msg without args"); // DEBUG:event,ntp,-,-,m,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = display(&disp), "msg without args"); // DEBUG:event,ntp,-,p,m,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = display(&disp) }, "msg without args"); // DEBUG:event,ntp,{},-,m,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = display(&disp) }, "msg without args"); // DEBUG:event,ntp,{},p,m,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = tracing::field::Empty); // DEBUG:event,ntp,-,-,-,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty); // DEBUG:event,ntp,-,p,-,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:event,ntp,-,f,-,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:event,ntp,-,pf,-,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:event,ntp,-,-,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:event,ntp,-,p,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:event,ntp,{},-,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:event,ntp,{},p,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = 3); // DEBUG:event,ntp,-,-,-,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = 3); // DEBUG:event,ntp,-,p,-,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = 3, qux = 3); // DEBUG:event,ntp,-,f,-,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = 3, qux = 3); // DEBUG:event,ntp,-,pf,-,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = 3, "msg without args"); // DEBUG:event,ntp,-,-,m,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = 3, "msg without args"); // DEBUG:event,ntp,-,p,m,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = 3, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = 3, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = 3 }, "msg without args"); // DEBUG:event,ntp,{},-,m,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = 3 }, "msg without args"); // DEBUG:event,ntp,{},p,m,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = false); // DEBUG:event,ntp,-,-,-,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = false); // DEBUG:event,ntp,-,p,-,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = false, qux = 3); // DEBUG:event,ntp,-,f,-,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = false, qux = 3); // DEBUG:event,ntp,-,pf,-,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = false, "msg without args"); // DEBUG:event,ntp,-,-,m,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = false, "msg without args"); // DEBUG:event,ntp,-,p,m,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = false, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = false, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = false }, "msg without args"); // DEBUG:event,ntp,{},-,m,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = false }, "msg without args"); // DEBUG:event,ntp,{},p,m,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = false, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = false, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = false, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = false, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?3); // DEBUG:event,ntp,-,-,-,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?3); // DEBUG:event,ntp,-,p,-,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?3, qux = 3); // DEBUG:event,ntp,-,f,-,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?3, qux = 3); // DEBUG:event,ntp,-,pf,-,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?3, "msg without args"); // DEBUG:event,ntp,-,-,m,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?3, "msg without args"); // DEBUG:event,ntp,-,p,m,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?3, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?3, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?3 }, "msg without args"); // DEBUG:event,ntp,{},-,m,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?3 }, "msg without args"); // DEBUG:event,ntp,{},p,m,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %3); // DEBUG:event,ntp,-,-,-,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %3); // DEBUG:event,ntp,-,p,-,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %3, qux = 3); // DEBUG:event,ntp,-,f,-,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %3, qux = 3); // DEBUG:event,ntp,-,pf,-,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %3, "msg without args"); // DEBUG:event,ntp,-,-,m,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %3, "msg without args"); // DEBUG:event,ntp,-,p,m,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %3, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %3, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %3 }, "msg without args"); // DEBUG:event,ntp,{},-,m,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %3 }, "msg without args"); // DEBUG:event,ntp,{},p,m,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?deb); // DEBUG:event,ntp,-,-,-,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?deb); // DEBUG:event,ntp,-,p,-,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?deb, qux = 3); // DEBUG:event,ntp,-,f,-,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?deb, qux = 3); // DEBUG:event,ntp,-,pf,-,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?deb, "msg without args"); // DEBUG:event,ntp,-,-,m,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?deb, "msg without args"); // DEBUG:event,ntp,-,p,m,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?deb, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?deb, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?deb }, "msg without args"); // DEBUG:event,ntp,{},-,m,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?deb }, "msg without args"); // DEBUG:event,ntp,{},p,m,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %disp); // DEBUG:event,ntp,-,-,-,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %disp); // DEBUG:event,ntp,-,p,-,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %disp, qux = 3); // DEBUG:event,ntp,-,f,-,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %disp, qux = 3); // DEBUG:event,ntp,-,pf,-,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %disp, "msg without args"); // DEBUG:event,ntp,-,-,m,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %disp, "msg without args"); // DEBUG:event,ntp,-,p,m,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %disp, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %disp, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %disp }, "msg without args"); // DEBUG:event,ntp,{},-,m,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %disp }, "msg without args"); // DEBUG:event,ntp,{},p,m,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?sub.field); // DEBUG:event,ntp,-,-,-,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?sub.field); // DEBUG:event,ntp,-,p,-,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?sub.field, qux = 3); // DEBUG:event,ntp,-,f,-,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?sub.field, qux = 3); // DEBUG:event,ntp,-,pf,-,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?sub.field, "msg without args"); // DEBUG:event,ntp,-,-,m,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?sub.field, "msg without args"); // DEBUG:event,ntp,-,p,m,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?sub.field }, "msg without args"); // DEBUG:event,ntp,{},-,m,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?sub.field }, "msg without args"); // DEBUG:event,ntp,{},p,m,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %sub.field); // DEBUG:event,ntp,-,-,-,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %sub.field); // DEBUG:event,ntp,-,p,-,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %sub.field, qux = 3); // DEBUG:event,ntp,-,f,-,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %sub.field, qux = 3); // DEBUG:event,ntp,-,pf,-,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %sub.field, "msg without args"); // DEBUG:event,ntp,-,-,m,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %sub.field, "msg without args"); // DEBUG:event,ntp,-,p,m,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %sub.field }, "msg without args"); // DEBUG:event,ntp,{},-,m,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %sub.field }, "msg without args"); // DEBUG:event,ntp,{},p,m,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = debug(&deb)); // DEBUG:event,ntp,-,-,-,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = debug(&deb)); // DEBUG:event,ntp,-,p,-,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = debug(&deb), qux = 3); // DEBUG:event,ntp,-,f,-,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = debug(&deb), qux = 3); // DEBUG:event,ntp,-,pf,-,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = debug(&deb), "msg without args"); // DEBUG:event,ntp,-,-,m,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = debug(&deb), "msg without args"); // DEBUG:event,ntp,-,p,m,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = debug(&deb) }, "msg without args"); // DEBUG:event,ntp,{},-,m,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = debug(&deb) }, "msg without args"); // DEBUG:event,ntp,{},p,m,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = display(&disp)); // DEBUG:event,ntp,-,-,-,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = display(&disp)); // DEBUG:event,ntp,-,p,-,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = display(&disp), qux = 3); // DEBUG:event,ntp,-,f,-,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = display(&disp), qux = 3); // DEBUG:event,ntp,-,pf,-,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = display(&disp), "msg without args"); // DEBUG:event,ntp,-,-,m,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = display(&disp), "msg without args"); // DEBUG:event,ntp,-,p,m,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = display(&disp) }, "msg without args"); // DEBUG:event,ntp,{},-,m,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = display(&disp) }, "msg without args"); // DEBUG:event,ntp,{},p,m,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = tracing::field::Empty); // DEBUG:event,ntp,-,-,-,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty); // DEBUG:event,ntp,-,p,-,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = tracing::field::Empty, qux = 3); // DEBUG:event,ntp,-,f,-,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty, qux = 3); // DEBUG:event,ntp,-,pf,-,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = tracing::field::Empty, "msg without args"); // DEBUG:event,ntp,-,-,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty, "msg without args"); // DEBUG:event,ntp,-,p,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:event,ntp,{},-,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:event,ntp,{},p,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = 3); // DEBUG:event,ntp,-,-,-,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = 3); // DEBUG:event,ntp,-,p,-,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = 3, qux = 3); // DEBUG:event,ntp,-,f,-,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = 3, qux = 3); // DEBUG:event,ntp,-,pf,-,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = 3, "msg without args"); // DEBUG:event,ntp,-,-,m,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = 3, "msg without args"); // DEBUG:event,ntp,-,p,m,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = 3 }, "msg without args"); // DEBUG:event,ntp,{},-,m,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = 3 }, "msg without args"); // DEBUG:event,ntp,{},p,m,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = false); // DEBUG:event,ntp,-,-,-,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = false); // DEBUG:event,ntp,-,p,-,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = false, qux = 3); // DEBUG:event,ntp,-,f,-,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = false, qux = 3); // DEBUG:event,ntp,-,pf,-,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = false, "msg without args"); // DEBUG:event,ntp,-,-,m,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = false, "msg without args"); // DEBUG:event,ntp,-,p,m,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = false }, "msg without args"); // DEBUG:event,ntp,{},-,m,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = false }, "msg without args"); // DEBUG:event,ntp,{},p,m,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?3); // DEBUG:event,ntp,-,-,-,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?3); // DEBUG:event,ntp,-,p,-,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?3, qux = 3); // DEBUG:event,ntp,-,f,-,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?3, qux = 3); // DEBUG:event,ntp,-,pf,-,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?3, "msg without args"); // DEBUG:event,ntp,-,-,m,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?3, "msg without args"); // DEBUG:event,ntp,-,p,m,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:event,ntp,{},-,m,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:event,ntp,{},p,m,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %3); // DEBUG:event,ntp,-,-,-,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %3); // DEBUG:event,ntp,-,p,-,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %3, qux = 3); // DEBUG:event,ntp,-,f,-,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %3, qux = 3); // DEBUG:event,ntp,-,pf,-,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %3, "msg without args"); // DEBUG:event,ntp,-,-,m,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %3, "msg without args"); // DEBUG:event,ntp,-,p,m,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %3 }, "msg without args"); // DEBUG:event,ntp,{},-,m,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %3 }, "msg without args"); // DEBUG:event,ntp,{},p,m,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?deb); // DEBUG:event,ntp,-,-,-,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb); // DEBUG:event,ntp,-,p,-,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?deb, qux = 3); // DEBUG:event,ntp,-,f,-,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb, qux = 3); // DEBUG:event,ntp,-,pf,-,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?deb, "msg without args"); // DEBUG:event,ntp,-,-,m,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb, "msg without args"); // DEBUG:event,ntp,-,p,m,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:event,ntp,{},-,m,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:event,ntp,{},p,m,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %disp); // DEBUG:event,ntp,-,-,-,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %disp); // DEBUG:event,ntp,-,p,-,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %disp, qux = 3); // DEBUG:event,ntp,-,f,-,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %disp, qux = 3); // DEBUG:event,ntp,-,pf,-,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %disp, "msg without args"); // DEBUG:event,ntp,-,-,m,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %disp, "msg without args"); // DEBUG:event,ntp,-,p,m,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %disp }, "msg without args"); // DEBUG:event,ntp,{},-,m,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %disp }, "msg without args"); // DEBUG:event,ntp,{},p,m,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?sub.field); // DEBUG:event,ntp,-,-,-,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field); // DEBUG:event,ntp,-,p,-,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?sub.field, qux = 3); // DEBUG:event,ntp,-,f,-,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field, qux = 3); // DEBUG:event,ntp,-,pf,-,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:event,ntp,-,-,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:event,ntp,-,p,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:event,ntp,{},-,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:event,ntp,{},p,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %sub.field); // DEBUG:event,ntp,-,-,-,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field); // DEBUG:event,ntp,-,p,-,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %sub.field, qux = 3); // DEBUG:event,ntp,-,f,-,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field, qux = 3); // DEBUG:event,ntp,-,pf,-,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %sub.field, "msg without args"); // DEBUG:event,ntp,-,-,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field, "msg without args"); // DEBUG:event,ntp,-,p,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:event,ntp,{},-,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:event,ntp,{},p,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = debug(&deb)); // DEBUG:event,ntp,-,-,-,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb)); // DEBUG:event,ntp,-,p,-,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = debug(&deb), qux = 3); // DEBUG:event,ntp,-,f,-,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb), qux = 3); // DEBUG:event,ntp,-,pf,-,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:event,ntp,-,-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:event,ntp,-,p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:event,ntp,{},-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:event,ntp,{},p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = display(&disp)); // DEBUG:event,ntp,-,-,-,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp)); // DEBUG:event,ntp,-,p,-,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = display(&disp), qux = 3); // DEBUG:event,ntp,-,f,-,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp), qux = 3); // DEBUG:event,ntp,-,pf,-,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = display(&disp), "msg without args"); // DEBUG:event,ntp,-,-,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp), "msg without args"); // DEBUG:event,ntp,-,p,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:event,ntp,{},-,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:event,ntp,{},p,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty); // DEBUG:event,ntp,-,-,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty); // DEBUG:event,ntp,-,p,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:event,ntp,-,f,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:event,ntp,-,pf,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:event,ntp,-,-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:event,ntp,-,p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:event,ntp,{},-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:event,ntp,{},p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = 3); // DEBUG:event,ntp,-,-,-,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = 3); // DEBUG:event,ntp,-,p,-,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = 3, qux = 3); // DEBUG:event,ntp,-,f,-,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = 3, qux = 3); // DEBUG:event,ntp,-,pf,-,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = 3, "msg without args"); // DEBUG:event,ntp,-,-,m,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = 3, "msg without args"); // DEBUG:event,ntp,-,p,m,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = 3, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = 3, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = 3 }, "msg without args"); // DEBUG:event,ntp,{},-,m,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = 3 }, "msg without args"); // DEBUG:event,ntp,{},p,m,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = 3, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = 3, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = false); // DEBUG:event,ntp,-,-,-,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = false); // DEBUG:event,ntp,-,p,-,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = false, qux = 3); // DEBUG:event,ntp,-,f,-,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = false, qux = 3); // DEBUG:event,ntp,-,pf,-,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = false, "msg without args"); // DEBUG:event,ntp,-,-,m,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = false, "msg without args"); // DEBUG:event,ntp,-,p,m,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = false, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = false, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = false }, "msg without args"); // DEBUG:event,ntp,{},-,m,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = false }, "msg without args"); // DEBUG:event,ntp,{},p,m,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = false, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = false, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = false, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = false, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = false }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = false }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?3); // DEBUG:event,ntp,-,-,-,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?3); // DEBUG:event,ntp,-,p,-,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?3, qux = 3); // DEBUG:event,ntp,-,f,-,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?3, qux = 3); // DEBUG:event,ntp,-,pf,-,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?3, "msg without args"); // DEBUG:event,ntp,-,-,m,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?3, "msg without args"); // DEBUG:event,ntp,-,p,m,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?3, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?3, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?3 }, "msg without args"); // DEBUG:event,ntp,{},-,m,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?3 }, "msg without args"); // DEBUG:event,ntp,{},p,m,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %3); // DEBUG:event,ntp,-,-,-,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %3); // DEBUG:event,ntp,-,p,-,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %3, qux = 3); // DEBUG:event,ntp,-,f,-,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %3, qux = 3); // DEBUG:event,ntp,-,pf,-,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %3, "msg without args"); // DEBUG:event,ntp,-,-,m,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %3, "msg without args"); // DEBUG:event,ntp,-,p,m,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %3, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %3, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %3 }, "msg without args"); // DEBUG:event,ntp,{},-,m,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %3 }, "msg without args"); // DEBUG:event,ntp,{},p,m,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %3, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %3, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?deb); // DEBUG:event,ntp,-,-,-,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?deb); // DEBUG:event,ntp,-,p,-,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?deb, qux = 3); // DEBUG:event,ntp,-,f,-,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?deb, qux = 3); // DEBUG:event,ntp,-,pf,-,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?deb, "msg without args"); // DEBUG:event,ntp,-,-,m,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?deb, "msg without args"); // DEBUG:event,ntp,-,p,m,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?deb, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?deb, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?deb }, "msg without args"); // DEBUG:event,ntp,{},-,m,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?deb }, "msg without args"); // DEBUG:event,ntp,{},p,m,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %disp); // DEBUG:event,ntp,-,-,-,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %disp); // DEBUG:event,ntp,-,p,-,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %disp, qux = 3); // DEBUG:event,ntp,-,f,-,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %disp, qux = 3); // DEBUG:event,ntp,-,pf,-,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %disp, "msg without args"); // DEBUG:event,ntp,-,-,m,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %disp, "msg without args"); // DEBUG:event,ntp,-,p,m,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %disp, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %disp, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %disp }, "msg without args"); // DEBUG:event,ntp,{},-,m,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %disp }, "msg without args"); // DEBUG:event,ntp,{},p,m,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?sub.field); // DEBUG:event,ntp,-,-,-,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?sub.field); // DEBUG:event,ntp,-,p,-,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?sub.field, qux = 3); // DEBUG:event,ntp,-,f,-,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?sub.field, qux = 3); // DEBUG:event,ntp,-,pf,-,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?sub.field, "msg without args"); // DEBUG:event,ntp,-,-,m,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?sub.field, "msg without args"); // DEBUG:event,ntp,-,p,m,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?sub.field }, "msg without args"); // DEBUG:event,ntp,{},-,m,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?sub.field }, "msg without args"); // DEBUG:event,ntp,{},p,m,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %sub.field); // DEBUG:event,ntp,-,-,-,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %sub.field); // DEBUG:event,ntp,-,p,-,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %sub.field, qux = 3); // DEBUG:event,ntp,-,f,-,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %sub.field, qux = 3); // DEBUG:event,ntp,-,pf,-,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %sub.field, "msg without args"); // DEBUG:event,ntp,-,-,m,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %sub.field, "msg without args"); // DEBUG:event,ntp,-,p,m,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %sub.field }, "msg without args"); // DEBUG:event,ntp,{},-,m,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %sub.field }, "msg without args"); // DEBUG:event,ntp,{},p,m,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = debug(&deb)); // DEBUG:event,ntp,-,-,-,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = debug(&deb)); // DEBUG:event,ntp,-,p,-,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = debug(&deb), qux = 3); // DEBUG:event,ntp,-,f,-,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = debug(&deb), qux = 3); // DEBUG:event,ntp,-,pf,-,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = debug(&deb), "msg without args"); // DEBUG:event,ntp,-,-,m,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = debug(&deb), "msg without args"); // DEBUG:event,ntp,-,p,m,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = debug(&deb) }, "msg without args"); // DEBUG:event,ntp,{},-,m,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = debug(&deb) }, "msg without args"); // DEBUG:event,ntp,{},p,m,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = display(&disp)); // DEBUG:event,ntp,-,-,-,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = display(&disp)); // DEBUG:event,ntp,-,p,-,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = display(&disp), qux = 3); // DEBUG:event,ntp,-,f,-,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = display(&disp), qux = 3); // DEBUG:event,ntp,-,pf,-,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = display(&disp), "msg without args"); // DEBUG:event,ntp,-,-,m,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = display(&disp), "msg without args"); // DEBUG:event,ntp,-,p,m,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = display(&disp) }, "msg without args"); // DEBUG:event,ntp,{},-,m,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = display(&disp) }, "msg without args"); // DEBUG:event,ntp,{},p,m,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = tracing::field::Empty); // DEBUG:event,ntp,-,-,-,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = tracing::field::Empty); // DEBUG:event,ntp,-,p,-,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = tracing::field::Empty, qux = 3); // DEBUG:event,ntp,-,f,-,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = tracing::field::Empty, qux = 3); // DEBUG:event,ntp,-,pf,-,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = tracing::field::Empty, "msg without args"); // DEBUG:event,ntp,-,-,m,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = tracing::field::Empty, "msg without args"); // DEBUG:event,ntp,-,p,m,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = tracing::field::Empty }, "msg without args"); // DEBUG:event,ntp,{},-,m,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = tracing::field::Empty }, "msg without args"); // DEBUG:event,ntp,{},p,m,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, var); // DEBUG:event,ntp,-,-,-,-,"var"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, var); // DEBUG:event,ntp,-,p,-,-,"var"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, var, qux = 3); // DEBUG:event,ntp,-,f,-,-,"var"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, var, qux = 3); // DEBUG:event,ntp,-,pf,-,-,"var"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, var, "msg without args"); // DEBUG:event,ntp,-,-,m,-,"var"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, var, "msg without args"); // DEBUG:event,ntp,-,p,m,-,"var"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, var, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,-,"var"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, var, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,-,"var"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { var }, "msg without args"); // DEBUG:event,ntp,{},-,m,-,"var"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, var }, "msg without args"); // DEBUG:event,ntp,{},p,m,-,"var"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { var, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,-,"var"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, var, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,-,"var"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, var, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,-,"var"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, var, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,-,"var"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,-,"var"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,-,"var"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { var }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,-,"var"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, var }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,-,"var"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,-,"var"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,-,"var"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, sub.field); // DEBUG:event,ntp,-,-,-,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, sub.field); // DEBUG:event,ntp,-,p,-,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, sub.field, qux = 3); // DEBUG:event,ntp,-,f,-,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, sub.field, qux = 3); // DEBUG:event,ntp,-,pf,-,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, sub.field, "msg without args"); // DEBUG:event,ntp,-,-,m,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, sub.field, "msg without args"); // DEBUG:event,ntp,-,p,m,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, sub.field, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, sub.field, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { sub.field }, "msg without args"); // DEBUG:event,ntp,{},-,m,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, sub.field }, "msg without args"); // DEBUG:event,ntp,{},p,m,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { sub.field, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, sub.field, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, sub.field, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, sub.field, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, %disp); // DEBUG:event,ntp,-,-,-,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %disp); // DEBUG:event,ntp,-,p,-,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, %disp, qux = 3); // DEBUG:event,ntp,-,f,-,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %disp, qux = 3); // DEBUG:event,ntp,-,pf,-,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, %disp, "msg without args"); // DEBUG:event,ntp,-,-,m,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %disp, "msg without args"); // DEBUG:event,ntp,-,p,m,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, %disp, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %disp, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { %disp }, "msg without args"); // DEBUG:event,ntp,{},-,m,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, %disp }, "msg without args"); // DEBUG:event,ntp,{},p,m,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { %disp, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, %disp, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, %disp, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %disp, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { %disp }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, %disp }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ?deb); // DEBUG:event,ntp,-,-,-,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?deb); // DEBUG:event,ntp,-,p,-,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ?deb, qux = 3); // DEBUG:event,ntp,-,f,-,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?deb, qux = 3); // DEBUG:event,ntp,-,pf,-,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ?deb, "msg without args"); // DEBUG:event,ntp,-,-,m,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?deb, "msg without args"); // DEBUG:event,ntp,-,p,m,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ?deb, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?deb, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ?deb }, "msg without args"); // DEBUG:event,ntp,{},-,m,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ?deb }, "msg without args"); // DEBUG:event,ntp,{},p,m,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ?deb, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ?deb, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ?deb, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?deb, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, %sub.field); // DEBUG:event,ntp,-,-,-,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %sub.field); // DEBUG:event,ntp,-,p,-,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, %sub.field, qux = 3); // DEBUG:event,ntp,-,f,-,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %sub.field, qux = 3); // DEBUG:event,ntp,-,pf,-,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, %sub.field, "msg without args"); // DEBUG:event,ntp,-,-,m,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %sub.field, "msg without args"); // DEBUG:event,ntp,-,p,m,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, %sub.field, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %sub.field, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { %sub.field }, "msg without args"); // DEBUG:event,ntp,{},-,m,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, %sub.field }, "msg without args"); // DEBUG:event,ntp,{},p,m,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ?sub.field); // DEBUG:event,ntp,-,-,-,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?sub.field); // DEBUG:event,ntp,-,p,-,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ?sub.field, qux = 3); // DEBUG:event,ntp,-,f,-,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?sub.field, qux = 3); // DEBUG:event,ntp,-,pf,-,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ?sub.field, "msg without args"); // DEBUG:event,ntp,-,-,m,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?sub.field, "msg without args"); // DEBUG:event,ntp,-,p,m,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ?sub.field, qux = 3, "msg without args"); // DEBUG:event,ntp,-,f,m,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?sub.field, qux = 3, "msg without args"); // DEBUG:event,ntp,-,pf,m,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ?sub.field }, "msg without args"); // DEBUG:event,ntp,{},-,m,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ?sub.field }, "msg without args"); // DEBUG:event,ntp,{},p,m,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},f,m,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,ntp,{},pf,m,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,-,ma,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,p,ma,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,f,ma,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,ntp,-,pf,ma,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},-,ma,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},p,ma,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},f,ma,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,ntp,{},pf,ma,-,"?sub.field"
}
