/* -----------------------------------------------------------------------------
Software License for The Fraunhofer FDK AAC Codec Library for Android

© Copyright  1995 - 2019 Fraunhofer-Gesellschaft zur Förderung der angewandten
Forschung e.V. All rights reserved.

 1.    INTRODUCTION
The Fraunhofer FDK AAC Codec Library for Android ("FDK AAC Codec") is software
that implements the MPEG Advanced Audio Coding ("AAC") encoding and decoding
scheme for digital audio. This FDK AAC Codec software is intended to be used on
a wide variety of Android devices.

AAC's HE-AAC and HE-AAC v2 versions are regarded as today's most efficient
general perceptual audio codecs. AAC-ELD is considered the best-performing
full-bandwidth communications codec by independent studies and is widely
deployed. AAC has been standardized by ISO and IEC as part of the MPEG
specifications.

Patent licenses for necessary patent claims for the FDK AAC Codec (including
those of Fraunhofer) may be obtained through Via Licensing
(www.vialicensing.com) or through the respective patent owners individually for
the purpose of encoding or decoding bit streams in products that are compliant
with the ISO/IEC MPEG audio standards. Please note that most manufacturers of
Android devices already license these patent claims through Via Licensing or
directly from the patent owners, and therefore FDK AAC Codec software may
already be covered under those patent licenses when it is used for those
licensed purposes only.

Commercially-licensed AAC software libraries, including floating-point versions
with enhanced sound quality, are also available from Fraunhofer. Users are
encouraged to check the Fraunhofer website for additional applications
information and documentation.

2.    COPYRIGHT LICENSE

Redistribution and use in source and binary forms, with or without modification,
are permitted without payment of copyright license fees provided that you
satisfy the following conditions:

You must retain the complete text of this software license in redistributions of
the FDK AAC Codec or your modifications thereto in source code form.

You must retain the complete text of this software license in the documentation
and/or other materials provided with redistributions of the FDK AAC Codec or
your modifications thereto in binary form. You must make available free of
charge copies of the complete source code of the FDK AAC Codec and your
modifications thereto to recipients of copies in binary form.

The name of Fraunhofer may not be used to endorse or promote products derived
from this library without prior written permission.

You may not charge copyright license fees for anyone to use, copy or distribute
the FDK AAC Codec software or your modifications thereto.

Your modified versions of the FDK AAC Codec must carry prominent notices stating
that you changed the software and the date of any change. For modified versions
of the FDK AAC Codec, the term "Fraunhofer FDK AAC Codec Library for Android"
must be replaced by the term "Third-Party Modified Version of the Fraunhofer FDK
AAC Codec Library for Android."

3.    NO PATENT LICENSE

NO EXPRESS OR IMPLIED LICENSES TO ANY PATENT CLAIMS, including without
limitation the patents of Fraunhofer, ARE GRANTED BY THIS SOFTWARE LICENSE.
Fraunhofer provides no warranty of patent non-infringement with respect to this
software.

You may use this FDK AAC Codec software or modifications thereto only for
purposes that are authorized by appropriate patent licenses.

4.    DISCLAIMER

This FDK AAC Codec software is provided by Fraunhofer on behalf of the copyright
holders and contributors "AS IS" and WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
including but not limited to the implied warranties of merchantability and
fitness for a particular purpose. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
CONTRIBUTORS BE LIABLE for any direct, indirect, incidental, special, exemplary,
or consequential damages, including but not limited to procurement of substitute
goods or services; loss of use, data, or profits, or business interruption,
however caused and on any theory of liability, whether in contract, strict
liability, or tort (including negligence), arising in any way out of the use of
this software, even if advised of the possibility of such damage.

5.    CONTACT INFORMATION

Fraunhofer Institute for Integrated Circuits IIS
Attention: Audio and Multimedia Departments - FDK AAC LL
Am Wolfsmantel 33
91058 Erlangen, Germany

www.iis.fraunhofer.de/amm
amm-info@iis.fraunhofer.de
----------------------------------------------------------------------------- */

/*********************** MPEG surround decoder library *************************

   Author(s):

   Description: SAC Dec tables

*******************************************************************************/

#include "sac_rom.h"
#include "sac_calcM1andM2.h"

#define SCALE_CPC(a) (FL2FXCONST_CFG(a / (float)(1 << SCALE_PARAM_M1)))
const FIXP_CFG dequantCPC__FDK[] = {
    SCALE_CPC(-2.0f), SCALE_CPC(-1.9f), SCALE_CPC(-1.8f), SCALE_CPC(-1.7f),
    SCALE_CPC(-1.6f), SCALE_CPC(-1.5f), SCALE_CPC(-1.4f), SCALE_CPC(-1.3f),
    SCALE_CPC(-1.2f), SCALE_CPC(-1.1f), SCALE_CPC(-1.0f), SCALE_CPC(-0.9f),
    SCALE_CPC(-0.8f), SCALE_CPC(-0.7f), SCALE_CPC(-0.6f), SCALE_CPC(-0.5f),
    SCALE_CPC(-0.4f), SCALE_CPC(-0.3f), SCALE_CPC(-0.2f), SCALE_CPC(-0.1f),
    SCALE_CPC(0.0f),  SCALE_CPC(0.1f),  SCALE_CPC(0.2f),  SCALE_CPC(0.3f),
    SCALE_CPC(0.4f),  SCALE_CPC(0.5f),  SCALE_CPC(0.6f),  SCALE_CPC(0.7f),
    SCALE_CPC(0.8f),  SCALE_CPC(0.9f),  SCALE_CPC(1.0f),  SCALE_CPC(1.1f),
    SCALE_CPC(1.2f),  SCALE_CPC(1.3f),  SCALE_CPC(1.4f),  SCALE_CPC(1.5f),
    SCALE_CPC(1.6f),  SCALE_CPC(1.7f),  SCALE_CPC(1.8f),  SCALE_CPC(1.9f),
    SCALE_CPC(2.0f),  SCALE_CPC(2.1f),  SCALE_CPC(2.2f),  SCALE_CPC(2.3f),
    SCALE_CPC(2.4f),  SCALE_CPC(2.5f),  SCALE_CPC(2.6f),  SCALE_CPC(2.7f),
    SCALE_CPC(2.8f),  SCALE_CPC(2.9f),  SCALE_CPC(3.0f)};

#define SCALE_ICC(a) (FL2FXCONST_CFG(a))
const FIXP_CFG dequantICC__FDK[8] = {
    /*SCALE_ICC(1.00000f)*/ FX_DBL2FX_CFG(MAXVAL_DBL),
    SCALE_ICC(0.9370f),
    SCALE_ICC(0.84118f),
    SCALE_ICC(0.60092f),
    SCALE_ICC(0.36764f),
    SCALE_ICC(0.0000f),
    SCALE_ICC(-0.58900f),
    SCALE_ICC(-0.9900f)};

#define SCALE_CLD2(a) (FL2FXCONST_CFG(a / (float)(1 << 8)))
const FIXP_CFG dequantCLD__FDK[31] = {
    SCALE_CLD2(-150.0f), SCALE_CLD2(-45.0f), SCALE_CLD2(-40.0f),
    SCALE_CLD2(-35.0f),  SCALE_CLD2(-30.0f), SCALE_CLD2(-25.0f),
    SCALE_CLD2(-22.0f),  SCALE_CLD2(-19.0f), SCALE_CLD2(-16.0f),
    SCALE_CLD2(-13.0f),  SCALE_CLD2(-10.0f), SCALE_CLD2(-8.0f),
    SCALE_CLD2(-6.0f),   SCALE_CLD2(-4.0f),  SCALE_CLD2(-2.0f),
    SCALE_CLD2(0.0f),    SCALE_CLD2(2.0f),   SCALE_CLD2(4.0f),
    SCALE_CLD2(6.0f),    SCALE_CLD2(8.0f),   SCALE_CLD2(10.0f),
    SCALE_CLD2(13.0f),   SCALE_CLD2(16.0f),  SCALE_CLD2(19.0f),
    SCALE_CLD2(22.0f),   SCALE_CLD2(25.0f),  SCALE_CLD2(30.0f),
    SCALE_CLD2(35.0f),   SCALE_CLD2(40.0f),  SCALE_CLD2(45.0f),
    SCALE_CLD2(150.0f)};

#define SCALE_IPD(a) (FL2FXCONST_CFG(a / (float)(1 << IPD_SCALE)))
const FIXP_CFG dequantIPD__FDK[16] = {
    /* SCALE_IPD(0.000000000f), SCALE_IPD(0.392699082f),
       SCALE_IPD(0.785398163f), SCALE_IPD(1.178097245f),
       SCALE_IPD(1.570796327f), SCALE_IPD(1.963495408f),
       SCALE_IPD(2.356194490f), SCALE_IPD(2.748893572f),
       SCALE_IPD(3.141592654f), SCALE_IPD(3.534291735f),
       SCALE_IPD(3.926990817f), SCALE_IPD(4.319689899f),
       SCALE_IPD(4.712388980f), SCALE_IPD(5.105088062f),
       SCALE_IPD(5.497787144f), SCALE_IPD(5.890486225f) */
    SCALE_IPD(0.00000000000000f), SCALE_IPD(0.392699082f),
    SCALE_IPD(0.78539816339745f), SCALE_IPD(1.178097245f),
    SCALE_IPD(1.57079632679490f), SCALE_IPD(1.963495408f),
    SCALE_IPD(2.35619449019234f), SCALE_IPD(2.748893572f),
    SCALE_IPD(3.14159265358979f), SCALE_IPD(3.534291735f),
    SCALE_IPD(3.92699081698724f), SCALE_IPD(4.319689899f),
    SCALE_IPD(4.71238898038469f), SCALE_IPD(5.105088062f),
    SCALE_IPD(5.49778714378214f), SCALE_IPD(5.890486225f)};

#define SCALE_SPLIT_ANGLE(a) (FL2FXCONST_DBL(a / (float)(1 << IPD_SCALE)))
/*
  Generate table dequantIPD_CLD_ICC_splitAngle__FDK[16][31][8]:

  #define ABS_THR                         ( 1e-9f * 32768 * 32768 )

  float dequantICC[] =
  {1.0000f,0.9370f,0.84118f,0.60092f,0.36764f,0.0f,-0.5890f,-0.9900f}; float
  dequantCLD[] =
  {-150.0,-45.0,-40.0,-35.0,-30.0,-25.0,-22.0,-19.0,-16.0,-13.0,-10.0, -8.0,
                          -6.0, -4.0, -2.0,  0.0,  2.0,  4.0,  6.0,  8.0,
  10.0, 13.0, 16.0, 19.0, 22.0, 25.0, 30.0, 35.0, 40.0, 45.0, 150.0 }; float
  dequantIPD[] =
  {0.f,0.392699082f,0.785398163f,1.178097245f,1.570796327f,1.963495408f,
                        2.35619449f,2.748893572f,3.141592654f,3.534291735f,3.926990817f,
                        4.319689899f,4.71238898f,5.105088062f,5.497787144f,5.890486225f};

  for (ipdIdx=0; ipdIdx<16; ipdIdx++)
    for (cldIdx=0; cldIdx<31; cldIdx++)
      for (iccIdx=0; iccIdx<8; iccIdx++) {
        ipd = dequantIPD[ipdIdx];
        cld = dequantCLD[cldIdx];
        icc = dequantICC[iccIdx];
        iidLin = (float) pow(10.0f, cld / 20.0f);
        iidLin2 = iidLin * iidLin;
        iidLin21 = iidLin2 + 1.0f;
        sinIpd = (float) sin(ipd);
        cosIpd = (float) cos(ipd);
        temp1 = 2.0f * icc * iidLin;
        temp1c = temp1 * cosIpd;
        ratio = (iidLin21 + temp1c) / (iidLin21 + temp1) + ABS_THR;
        w2 = (float) pow(ratio, 0.25f);
        w1 = 2.0f - w2;
        dequantIPD_CLD_ICC_splitAngle__FDK[ipdIdx][cldIdx][iccIdx] = (float)
  atan2(w2 * sinIpd, w1 * iidLin + w2 * cosIpd);
      }
*/
const FIXP_DBL dequantIPD_CLD_ICC_splitAngle__FDK[15][31][8] = {
    {
        {SCALE_SPLIT_ANGLE(0.39269909262657),
         SCALE_SPLIT_ANGLE(0.39269909262657),
         SCALE_SPLIT_ANGLE(0.39269909262657),
         SCALE_SPLIT_ANGLE(0.39269909262657),
         SCALE_SPLIT_ANGLE(0.39269909262657),
         SCALE_SPLIT_ANGLE(0.39269909262657),
         SCALE_SPLIT_ANGLE(0.39269909262657),
         SCALE_SPLIT_ANGLE(0.39269909262657)},
        {SCALE_SPLIT_ANGLE(0.39055734872818),
         SCALE_SPLIT_ANGLE(0.39055740833282),
         SCALE_SPLIT_ANGLE(0.39055749773979),
         SCALE_SPLIT_ANGLE(0.39055770635605),
         SCALE_SPLIT_ANGLE(0.39055791497231),
         SCALE_SPLIT_ANGLE(0.39055824279785),
         SCALE_SPLIT_ANGLE(0.39055877923965),
         SCALE_SPLIT_ANGLE(0.39055916666985)},
        {SCALE_SPLIT_ANGLE(0.38890451192856),
         SCALE_SPLIT_ANGLE(0.38890469074249),
         SCALE_SPLIT_ANGLE(0.38890495896339),
         SCALE_SPLIT_ANGLE(0.38890564441681),
         SCALE_SPLIT_ANGLE(0.38890630006790),
         SCALE_SPLIT_ANGLE(0.38890734314919),
         SCALE_SPLIT_ANGLE(0.38890904188156),
         SCALE_SPLIT_ANGLE(0.38891020417213)},
        {SCALE_SPLIT_ANGLE(0.38599541783333),
         SCALE_SPLIT_ANGLE(0.38599592447281),
         SCALE_SPLIT_ANGLE(0.38599672913551),
         SCALE_SPLIT_ANGLE(0.38599878549576),
         SCALE_SPLIT_ANGLE(0.38600078225136),
         SCALE_SPLIT_ANGLE(0.38600403070450),
         SCALE_SPLIT_ANGLE(0.38600939512253),
         SCALE_SPLIT_ANGLE(0.38601315021515)},
        {SCALE_SPLIT_ANGLE(0.38091576099396),
         SCALE_SPLIT_ANGLE(0.38091731071472),
         SCALE_SPLIT_ANGLE(0.38091966509819),
         SCALE_SPLIT_ANGLE(0.38092571496964),
         SCALE_SPLIT_ANGLE(0.38093179464340),
         SCALE_SPLIT_ANGLE(0.38094165921211),
         SCALE_SPLIT_ANGLE(0.38095843791962),
         SCALE_SPLIT_ANGLE(0.38097056746483)},
        {SCALE_SPLIT_ANGLE(0.37216997146606),
         SCALE_SPLIT_ANGLE(0.37217426300049),
         SCALE_SPLIT_ANGLE(0.37218090891838),
         SCALE_SPLIT_ANGLE(0.37219807505608),
         SCALE_SPLIT_ANGLE(0.37221556901932),
         SCALE_SPLIT_ANGLE(0.37224492430687),
         SCALE_SPLIT_ANGLE(0.37229704856873),
         SCALE_SPLIT_ANGLE(0.37233674526215)},
        {SCALE_SPLIT_ANGLE(0.36424967646599),
         SCALE_SPLIT_ANGLE(0.36425727605820),
         SCALE_SPLIT_ANGLE(0.36426907777786),
         SCALE_SPLIT_ANGLE(0.36430004239082),
         SCALE_SPLIT_ANGLE(0.36433213949203),
         SCALE_SPLIT_ANGLE(0.36438730359077),
         SCALE_SPLIT_ANGLE(0.36448970437050),
         SCALE_SPLIT_ANGLE(0.36457163095474)},
        {SCALE_SPLIT_ANGLE(0.35356888175011),
         SCALE_SPLIT_ANGLE(0.35358175635338),
         SCALE_SPLIT_ANGLE(0.35360190272331),
         SCALE_SPLIT_ANGLE(0.35365560650826),
         SCALE_SPLIT_ANGLE(0.35371258854866),
         SCALE_SPLIT_ANGLE(0.35381385684013),
         SCALE_SPLIT_ANGLE(0.35401365160942),
         SCALE_SPLIT_ANGLE(0.35418578982353)},
        {SCALE_SPLIT_ANGLE(0.33942583203316),
         SCALE_SPLIT_ANGLE(0.33944645524025),
         SCALE_SPLIT_ANGLE(0.33947896957397),
         SCALE_SPLIT_ANGLE(0.33956742286682),
         SCALE_SPLIT_ANGLE(0.33966416120529),
         SCALE_SPLIT_ANGLE(0.33984372019768),
         SCALE_SPLIT_ANGLE(0.34023007750511),
         SCALE_SPLIT_ANGLE(0.34060221910477)},
        {SCALE_SPLIT_ANGLE(0.32115450501442),
         SCALE_SPLIT_ANGLE(0.32118520140648),
         SCALE_SPLIT_ANGLE(0.32123416662216),
         SCALE_SPLIT_ANGLE(0.32137048244476),
         SCALE_SPLIT_ANGLE(0.32152509689331),
         SCALE_SPLIT_ANGLE(0.32182863354683),
         SCALE_SPLIT_ANGLE(0.32256561517715),
         SCALE_SPLIT_ANGLE(0.32340893149376)},
        {SCALE_SPLIT_ANGLE(0.29830521345139),
         SCALE_SPLIT_ANGLE(0.29834723472595),
         SCALE_SPLIT_ANGLE(0.29841500520706),
         SCALE_SPLIT_ANGLE(0.29860860109329),
         SCALE_SPLIT_ANGLE(0.29883742332458),
         SCALE_SPLIT_ANGLE(0.29931786656380),
         SCALE_SPLIT_ANGLE(0.30069106817245),
         SCALE_SPLIT_ANGLE(0.30275771021843)},
        {SCALE_SPLIT_ANGLE(0.28050789237022),
         SCALE_SPLIT_ANGLE(0.28055712580681),
         SCALE_SPLIT_ANGLE(0.28063708543777),
         SCALE_SPLIT_ANGLE(0.28086942434311),
         SCALE_SPLIT_ANGLE(0.28115189075470),
         SCALE_SPLIT_ANGLE(0.28177404403687),
         SCALE_SPLIT_ANGLE(0.28380545973778),
         SCALE_SPLIT_ANGLE(0.28782638907433)},
        {SCALE_SPLIT_ANGLE(0.26083287596703),
         SCALE_SPLIT_ANGLE(0.26088824868202),
         SCALE_SPLIT_ANGLE(0.26097872853279),
         SCALE_SPLIT_ANGLE(0.26124578714371),
         SCALE_SPLIT_ANGLE(0.26157897710800),
         SCALE_SPLIT_ANGLE(0.26234793663025),
         SCALE_SPLIT_ANGLE(0.26525345444679),
         SCALE_SPLIT_ANGLE(0.27373576164246)},
        {SCALE_SPLIT_ANGLE(0.23960022628307),
         SCALE_SPLIT_ANGLE(0.23966011404991),
         SCALE_SPLIT_ANGLE(0.23975846171379),
         SCALE_SPLIT_ANGLE(0.24005253612995),
         SCALE_SPLIT_ANGLE(0.24042735993862),
         SCALE_SPLIT_ANGLE(0.24132782220840),
         SCALE_SPLIT_ANGLE(0.24525125324726),
         SCALE_SPLIT_ANGLE(0.26534587144852)},
        {SCALE_SPLIT_ANGLE(0.21727463603020),
         SCALE_SPLIT_ANGLE(0.21733720600605),
         SCALE_SPLIT_ANGLE(0.21744030714035),
         SCALE_SPLIT_ANGLE(0.21775111556053),
         SCALE_SPLIT_ANGLE(0.21815299987793),
         SCALE_SPLIT_ANGLE(0.21914559602737),
         SCALE_SPLIT_ANGLE(0.22397418320179),
         SCALE_SPLIT_ANGLE(0.27997341752052)},
        {SCALE_SPLIT_ANGLE(0.19442924857140),
         SCALE_SPLIT_ANGLE(0.19449260830879),
         SCALE_SPLIT_ANGLE(0.19459712505341),
         SCALE_SPLIT_ANGLE(0.19491320848465),
         SCALE_SPLIT_ANGLE(0.19532410800457),
         SCALE_SPLIT_ANGLE(0.19634956121445),
         SCALE_SPLIT_ANGLE(0.20156545937061),
         SCALE_SPLIT_ANGLE(0.33650875091553)},
        {SCALE_SPLIT_ANGLE(0.17168679833412),
         SCALE_SPLIT_ANGLE(0.17174908518791),
         SCALE_SPLIT_ANGLE(0.17185173928738),
         SCALE_SPLIT_ANGLE(0.17216140031815),
         SCALE_SPLIT_ANGLE(0.17256212234497),
         SCALE_SPLIT_ANGLE(0.17355351150036),
         SCALE_SPLIT_ANGLE(0.17841057479382),
         SCALE_SPLIT_ANGLE(0.23922468721867)},
        {SCALE_SPLIT_ANGLE(0.14965108036995),
         SCALE_SPLIT_ANGLE(0.14971046149731),
         SCALE_SPLIT_ANGLE(0.14980803430080),
         SCALE_SPLIT_ANGLE(0.15010002255440),
         SCALE_SPLIT_ANGLE(0.15047283470631),
         SCALE_SPLIT_ANGLE(0.15137128531933),
         SCALE_SPLIT_ANGLE(0.15533345937729),
         SCALE_SPLIT_ANGLE(0.17691856622696)},
        {SCALE_SPLIT_ANGLE(0.12884500622749),
         SCALE_SPLIT_ANGLE(0.12889973819256),
         SCALE_SPLIT_ANGLE(0.12898921966553),
         SCALE_SPLIT_ANGLE(0.12925371527672),
         SCALE_SPLIT_ANGLE(0.12958450615406),
         SCALE_SPLIT_ANGLE(0.13035117089748),
         SCALE_SPLIT_ANGLE(0.13329000771046),
         SCALE_SPLIT_ANGLE(0.14226883649826)},
        {SCALE_SPLIT_ANGLE(0.10966771841049),
         SCALE_SPLIT_ANGLE(0.10971628874540),
         SCALE_SPLIT_ANGLE(0.10979522019625),
         SCALE_SPLIT_ANGLE(0.11002497375011),
         SCALE_SPLIT_ANGLE(0.11030506342649),
         SCALE_SPLIT_ANGLE(0.11092507839203),
         SCALE_SPLIT_ANGLE(0.11297956109047),
         SCALE_SPLIT_ANGLE(0.11718676239252)},
        {SCALE_SPLIT_ANGLE(0.09237616509199),
         SCALE_SPLIT_ANGLE(0.09241759032011),
         SCALE_SPLIT_ANGLE(0.09248441457748),
         SCALE_SPLIT_ANGLE(0.09267570823431),
         SCALE_SPLIT_ANGLE(0.09290253371000),
         SCALE_SPLIT_ANGLE(0.09338124841452),
         SCALE_SPLIT_ANGLE(0.09476862102747),
         SCALE_SPLIT_ANGLE(0.09691140055656)},
        {SCALE_SPLIT_ANGLE(0.07020132243633),
         SCALE_SPLIT_ANGLE(0.07023159414530),
         SCALE_SPLIT_ANGLE(0.07027988880873),
         SCALE_SPLIT_ANGLE(0.07041462510824),
         SCALE_SPLIT_ANGLE(0.07056795060635),
         SCALE_SPLIT_ANGLE(0.07087047398090),
         SCALE_SPLIT_ANGLE(0.07161350548267),
         SCALE_SPLIT_ANGLE(0.07247893512249)},
        {SCALE_SPLIT_ANGLE(0.05244029685855),
         SCALE_SPLIT_ANGLE(0.05246063694358),
         SCALE_SPLIT_ANGLE(0.05249277502298),
         SCALE_SPLIT_ANGLE(0.05258031934500),
         SCALE_SPLIT_ANGLE(0.05267634987831),
         SCALE_SPLIT_ANGLE(0.05285539478064),
         SCALE_SPLIT_ANGLE(0.05324416980147),
         SCALE_SPLIT_ANGLE(0.05362326279283)},
        {SCALE_SPLIT_ANGLE(0.03864165768027),
         SCALE_SPLIT_ANGLE(0.03865439072251),
         SCALE_SPLIT_ANGLE(0.03867433592677),
         SCALE_SPLIT_ANGLE(0.03872758522630),
         SCALE_SPLIT_ANGLE(0.03878424316645),
         SCALE_SPLIT_ANGLE(0.03888526186347),
         SCALE_SPLIT_ANGLE(0.03908598423004),
         SCALE_SPLIT_ANGLE(0.03926040604711)},
        {SCALE_SPLIT_ANGLE(0.02817477472126),
         SCALE_SPLIT_ANGLE(0.02818230912089),
         SCALE_SPLIT_ANGLE(0.02819401398301),
         SCALE_SPLIT_ANGLE(0.02822477556765),
         SCALE_SPLIT_ANGLE(0.02825673110783),
         SCALE_SPLIT_ANGLE(0.02831180393696),
         SCALE_SPLIT_ANGLE(0.02841453813016),
         SCALE_SPLIT_ANGLE(0.02849725075066)},
        {SCALE_SPLIT_ANGLE(0.02037953026593),
         SCALE_SPLIT_ANGLE(0.02038379199803),
         SCALE_SPLIT_ANGLE(0.02039037831128),
         SCALE_SPLIT_ANGLE(0.02040746994317),
         SCALE_SPLIT_ANGLE(0.02042490243912),
         SCALE_SPLIT_ANGLE(0.02045420184731),
         SCALE_SPLIT_ANGLE(0.02050646767020),
         SCALE_SPLIT_ANGLE(0.02054644003510)},
        {SCALE_SPLIT_ANGLE(0.01173160225153),
         SCALE_SPLIT_ANGLE(0.01173313986510),
         SCALE_SPLIT_ANGLE(0.01173550263047),
         SCALE_SPLIT_ANGLE(0.01174154505134),
         SCALE_SPLIT_ANGLE(0.01174758374691),
         SCALE_SPLIT_ANGLE(0.01175745483488),
         SCALE_SPLIT_ANGLE(0.01177425310016),
         SCALE_SPLIT_ANGLE(0.01178644131869)},
        {SCALE_SPLIT_ANGLE(0.00668647512794),
         SCALE_SPLIT_ANGLE(0.00668699946254),
         SCALE_SPLIT_ANGLE(0.00668780272827),
         SCALE_SPLIT_ANGLE(0.00668983906507),
         SCALE_SPLIT_ANGLE(0.00669185025617),
         SCALE_SPLIT_ANGLE(0.00669508520514),
         SCALE_SPLIT_ANGLE(0.00670044543222),
         SCALE_SPLIT_ANGLE(0.00670422753319)},
        {SCALE_SPLIT_ANGLE(0.00378898042254),
         SCALE_SPLIT_ANGLE(0.00378915388137),
         SCALE_SPLIT_ANGLE(0.00378941884264),
         SCALE_SPLIT_ANGLE(0.00379008660093),
         SCALE_SPLIT_ANGLE(0.00379074062221),
         SCALE_SPLIT_ANGLE(0.00379178463481),
         SCALE_SPLIT_ANGLE(0.00379348872229),
         SCALE_SPLIT_ANGLE(0.00379467196763)},
        {SCALE_SPLIT_ANGLE(0.00213995971717),
         SCALE_SPLIT_ANGLE(0.00214001606219),
         SCALE_SPLIT_ANGLE(0.00214010174386),
         SCALE_SPLIT_ANGLE(0.00214031711221),
         SCALE_SPLIT_ANGLE(0.00214052735828),
         SCALE_SPLIT_ANGLE(0.00214086147025),
         SCALE_SPLIT_ANGLE(0.00214140163735),
         SCALE_SPLIT_ANGLE(0.00214177416638)},
        {SCALE_SPLIT_ANGLE(0.00000001210151),
         SCALE_SPLIT_ANGLE(0.00000001210151),
         SCALE_SPLIT_ANGLE(0.00000001210151),
         SCALE_SPLIT_ANGLE(0.00000001210151),
         SCALE_SPLIT_ANGLE(0.00000001210151),
         SCALE_SPLIT_ANGLE(0.00000001210151),
         SCALE_SPLIT_ANGLE(0.00000001210151),
         SCALE_SPLIT_ANGLE(0.00000001210151)},
    },
    {
        {SCALE_SPLIT_ANGLE(0.78539812564850),
         SCALE_SPLIT_ANGLE(0.78539812564850),
         SCALE_SPLIT_ANGLE(0.78539812564850),
         SCALE_SPLIT_ANGLE(0.78539812564850),
         SCALE_SPLIT_ANGLE(0.78539812564850),
         SCALE_SPLIT_ANGLE(0.78539812564850),
         SCALE_SPLIT_ANGLE(0.78539812564850),
         SCALE_SPLIT_ANGLE(0.78539812564850)},
        {SCALE_SPLIT_ANGLE(0.78143113851547),
         SCALE_SPLIT_ANGLE(0.78143155574799),
         SCALE_SPLIT_ANGLE(0.78143215179443),
         SCALE_SPLIT_ANGLE(0.78143370151520),
         SCALE_SPLIT_ANGLE(0.78143519163132),
         SCALE_SPLIT_ANGLE(0.78143757581711),
         SCALE_SPLIT_ANGLE(0.78144145011902),
         SCALE_SPLIT_ANGLE(0.78144407272339)},
        {SCALE_SPLIT_ANGLE(0.77835679054260),
         SCALE_SPLIT_ANGLE(0.77835804224014),
         SCALE_SPLIT_ANGLE(0.77835988998413),
         SCALE_SPLIT_ANGLE(0.77836471796036),
         SCALE_SPLIT_ANGLE(0.77836942672729),
         SCALE_SPLIT_ANGLE(0.77837687730789),
         SCALE_SPLIT_ANGLE(0.77838897705078),
         SCALE_SPLIT_ANGLE(0.77839738130569)},
        {SCALE_SPLIT_ANGLE(0.77291858196259),
         SCALE_SPLIT_ANGLE(0.77292239665985),
         SCALE_SPLIT_ANGLE(0.77292817831039),
         SCALE_SPLIT_ANGLE(0.77294290065765),
         SCALE_SPLIT_ANGLE(0.77295738458633),
         SCALE_SPLIT_ANGLE(0.77298063039780),
         SCALE_SPLIT_ANGLE(0.77301889657974),
         SCALE_SPLIT_ANGLE(0.77304571866989)},
        {SCALE_SPLIT_ANGLE(0.76334190368652),
         SCALE_SPLIT_ANGLE(0.76335322856903),
         SCALE_SPLIT_ANGLE(0.76337057352066),
         SCALE_SPLIT_ANGLE(0.76341474056244),
         SCALE_SPLIT_ANGLE(0.76345866918564),
         SCALE_SPLIT_ANGLE(0.76353001594543),
         SCALE_SPLIT_ANGLE(0.76365023851395),
         SCALE_SPLIT_ANGLE(0.76373648643494)},
        {SCALE_SPLIT_ANGLE(0.74662178754807),
         SCALE_SPLIT_ANGLE(0.74665385484695),
         SCALE_SPLIT_ANGLE(0.74670320749283),
         SCALE_SPLIT_ANGLE(0.74683058261871),
         SCALE_SPLIT_ANGLE(0.74695950746536),
         SCALE_SPLIT_ANGLE(0.74717390537262),
         SCALE_SPLIT_ANGLE(0.74754953384399),
         SCALE_SPLIT_ANGLE(0.74783092737198)},
        {SCALE_SPLIT_ANGLE(0.73124057054520),
         SCALE_SPLIT_ANGLE(0.73129826784134),
         SCALE_SPLIT_ANGLE(0.73138761520386),
         SCALE_SPLIT_ANGLE(0.73162078857422),
         SCALE_SPLIT_ANGLE(0.73186045885086),
         SCALE_SPLIT_ANGLE(0.73226773738861),
         SCALE_SPLIT_ANGLE(0.73300832509995),
         SCALE_SPLIT_ANGLE(0.73358738422394)},
        {SCALE_SPLIT_ANGLE(0.71016556024551),
         SCALE_SPLIT_ANGLE(0.71026545763016),
         SCALE_SPLIT_ANGLE(0.71042120456696),
         SCALE_SPLIT_ANGLE(0.71083343029022),
         SCALE_SPLIT_ANGLE(0.71126621961594),
         SCALE_SPLIT_ANGLE(0.71202337741852),
         SCALE_SPLIT_ANGLE(0.71347540616989),
         SCALE_SPLIT_ANGLE(0.71468448638916)},
        {SCALE_SPLIT_ANGLE(0.68173062801361),
         SCALE_SPLIT_ANGLE(0.68189471960068),
         SCALE_SPLIT_ANGLE(0.68215268850327),
         SCALE_SPLIT_ANGLE(0.68284785747528),
         SCALE_SPLIT_ANGLE(0.68359774351120),
         SCALE_SPLIT_ANGLE(0.68496215343475),
         SCALE_SPLIT_ANGLE(0.68778359889984),
         SCALE_SPLIT_ANGLE(0.69036644697189)},
        {SCALE_SPLIT_ANGLE(0.64424294233322),
         SCALE_SPLIT_ANGLE(0.64449471235275),
         SCALE_SPLIT_ANGLE(0.64489430189133),
         SCALE_SPLIT_ANGLE(0.64599478244781),
         SCALE_SPLIT_ANGLE(0.64722269773483),
         SCALE_SPLIT_ANGLE(0.64957273006439),
         SCALE_SPLIT_ANGLE(0.65497380495071),
         SCALE_SPLIT_ANGLE(0.66069257259369)},
        {SCALE_SPLIT_ANGLE(0.59645885229111),
         SCALE_SPLIT_ANGLE(0.59681373834610),
         SCALE_SPLIT_ANGLE(0.59738290309906),
         SCALE_SPLIT_ANGLE(0.59898978471756),
         SCALE_SPLIT_ANGLE(0.60085380077362),
         SCALE_SPLIT_ANGLE(0.60464859008789),
         SCALE_SPLIT_ANGLE(0.61471658945084),
         SCALE_SPLIT_ANGLE(0.62811440229416)},
        {SCALE_SPLIT_ANGLE(0.55878311395645),
         SCALE_SPLIT_ANGLE(0.55920600891113),
         SCALE_SPLIT_ANGLE(0.55988913774490),
         SCALE_SPLIT_ANGLE(0.56185030937195),
         SCALE_SPLIT_ANGLE(0.56418746709824),
         SCALE_SPLIT_ANGLE(0.56916546821594),
         SCALE_SPLIT_ANGLE(0.58402228355408),
         SCALE_SPLIT_ANGLE(0.60877442359924)},
        {SCALE_SPLIT_ANGLE(0.51690864562988),
         SCALE_SPLIT_ANGLE(0.51739054918289),
         SCALE_SPLIT_ANGLE(0.51817405223846),
         SCALE_SPLIT_ANGLE(0.52045875787735),
         SCALE_SPLIT_ANGLE(0.52325224876404),
         SCALE_SPLIT_ANGLE(0.52947413921356),
         SCALE_SPLIT_ANGLE(0.55062562227249),
         SCALE_SPLIT_ANGLE(0.59875661134720)},
        {SCALE_SPLIT_ANGLE(0.47171193361282),
         SCALE_SPLIT_ANGLE(0.47223743796349),
         SCALE_SPLIT_ANGLE(0.47309640049934),
         SCALE_SPLIT_ANGLE(0.47563400864601),
         SCALE_SPLIT_ANGLE(0.47880488634109),
         SCALE_SPLIT_ANGLE(0.48615166544914),
         SCALE_SPLIT_ANGLE(0.51456981897354),
         SCALE_SPLIT_ANGLE(0.61478358507156)},
        {SCALE_SPLIT_ANGLE(0.42445337772369),
         SCALE_SPLIT_ANGLE(0.42500329017639),
         SCALE_SPLIT_ANGLE(0.42590543627739),
         SCALE_SPLIT_ANGLE(0.42859473824501),
         SCALE_SPLIT_ANGLE(0.43200695514679),
         SCALE_SPLIT_ANGLE(0.44014197587967),
         SCALE_SPLIT_ANGLE(0.47505444288254),
         SCALE_SPLIT_ANGLE(0.70435541868210)},
        {SCALE_SPLIT_ANGLE(0.37662339210510),
         SCALE_SPLIT_ANGLE(0.37717753648758),
         SCALE_SPLIT_ANGLE(0.37808802723885),
         SCALE_SPLIT_ANGLE(0.38081303238869),
         SCALE_SPLIT_ANGLE(0.38429373502731),
         SCALE_SPLIT_ANGLE(0.39269909262657),
         SCALE_SPLIT_ANGLE(0.43061128258705),
         SCALE_SPLIT_ANGLE(0.89949643611908)},
        {SCALE_SPLIT_ANGLE(0.32972764968872),
         SCALE_SPLIT_ANGLE(0.33026659488678),
         SCALE_SPLIT_ANGLE(0.33115157485008),
         SCALE_SPLIT_ANGLE(0.33379590511322),
         SCALE_SPLIT_ANGLE(0.33716440200806),
         SCALE_SPLIT_ANGLE(0.34525617957115),
         SCALE_SPLIT_ANGLE(0.38098797202110),
         SCALE_SPLIT_ANGLE(0.66312330961227)},
        {SCALE_SPLIT_ANGLE(0.28508263826370),
         SCALE_SPLIT_ANGLE(0.28558859229088),
         SCALE_SPLIT_ANGLE(0.28641715645790),
         SCALE_SPLIT_ANGLE(0.28887593746185),
         SCALE_SPLIT_ANGLE(0.29197177290916),
         SCALE_SPLIT_ANGLE(0.29924646019936),
         SCALE_SPLIT_ANGLE(0.32879719138145),
         SCALE_SPLIT_ANGLE(0.45467028021812)},
        {SCALE_SPLIT_ANGLE(0.24368345737457),
         SCALE_SPLIT_ANGLE(0.24414120614529),
         SCALE_SPLIT_ANGLE(0.24488738179207),
         SCALE_SPLIT_ANGLE(0.24707712233067),
         SCALE_SPLIT_ANGLE(0.24978286027908),
         SCALE_SPLIT_ANGLE(0.25592401623726),
         SCALE_SPLIT_ANGLE(0.27806487679482),
         SCALE_SPLIT_ANGLE(0.33706206083298)},
        {SCALE_SPLIT_ANGLE(0.20616286993027),
         SCALE_SPLIT_ANGLE(0.20656119287014),
         SCALE_SPLIT_ANGLE(0.20720668137074),
         SCALE_SPLIT_ANGLE(0.20907410979271),
         SCALE_SPLIT_ANGLE(0.21132774651051),
         SCALE_SPLIT_ANGLE(0.21623271703720),
         SCALE_SPLIT_ANGLE(0.23177997767925),
         SCALE_SPLIT_ANGLE(0.26115790009499)},
        {SCALE_SPLIT_ANGLE(0.17282110452652),
         SCALE_SPLIT_ANGLE(0.17315416038036),
         SCALE_SPLIT_ANGLE(0.17369024455547),
         SCALE_SPLIT_ANGLE(0.17521673440933),
         SCALE_SPLIT_ANGLE(0.17701178789139),
         SCALE_SPLIT_ANGLE(0.18074953556061),
         SCALE_SPLIT_ANGLE(0.19124270975590),
         SCALE_SPLIT_ANGLE(0.20666223764420)},
        {SCALE_SPLIT_ANGLE(0.13066084682941),
         SCALE_SPLIT_ANGLE(0.13089758157730),
         SCALE_SPLIT_ANGLE(0.13127475976944),
         SCALE_SPLIT_ANGLE(0.13232271373272),
         SCALE_SPLIT_ANGLE(0.13350808620453),
         SCALE_SPLIT_ANGLE(0.13582544028759),
         SCALE_SPLIT_ANGLE(0.14140741527081),
         SCALE_SPLIT_ANGLE(0.14774028956890)},
        {SCALE_SPLIT_ANGLE(0.09729286283255),
         SCALE_SPLIT_ANGLE(0.09744835644960),
         SCALE_SPLIT_ANGLE(0.09769364446402),
         SCALE_SPLIT_ANGLE(0.09835994243622),
         SCALE_SPLIT_ANGLE(0.09908767789602),
         SCALE_SPLIT_ANGLE(0.10043603181839),
         SCALE_SPLIT_ANGLE(0.10332850366831),
         SCALE_SPLIT_ANGLE(0.10610697418451)},
        {SCALE_SPLIT_ANGLE(0.07155895978212),
         SCALE_SPLIT_ANGLE(0.07165451347828),
         SCALE_SPLIT_ANGLE(0.07180397957563),
         SCALE_SPLIT_ANGLE(0.07220225036144),
         SCALE_SPLIT_ANGLE(0.07262472063303),
         SCALE_SPLIT_ANGLE(0.07337479293346),
         SCALE_SPLIT_ANGLE(0.07485356926918),
         SCALE_SPLIT_ANGLE(0.07612708956003)},
        {SCALE_SPLIT_ANGLE(0.05212157219648),
         SCALE_SPLIT_ANGLE(0.05217727646232),
         SCALE_SPLIT_ANGLE(0.05226379260421),
         SCALE_SPLIT_ANGLE(0.05249078199267),
         SCALE_SPLIT_ANGLE(0.05272606015205),
         SCALE_SPLIT_ANGLE(0.05313042178750),
         SCALE_SPLIT_ANGLE(0.05388085916638),
         SCALE_SPLIT_ANGLE(0.05448162183166)},
        {SCALE_SPLIT_ANGLE(0.03767965734005),
         SCALE_SPLIT_ANGLE(0.03771083429456),
         SCALE_SPLIT_ANGLE(0.03775899112225),
         SCALE_SPLIT_ANGLE(0.03788382932544),
         SCALE_SPLIT_ANGLE(0.03801096230745),
         SCALE_SPLIT_ANGLE(0.03822423517704),
         SCALE_SPLIT_ANGLE(0.03860339149833),
         SCALE_SPLIT_ANGLE(0.03889226913452)},
        {SCALE_SPLIT_ANGLE(0.02168158628047),
         SCALE_SPLIT_ANGLE(0.02169270813465),
         SCALE_SPLIT_ANGLE(0.02170977368951),
         SCALE_SPLIT_ANGLE(0.02175341546535),
         SCALE_SPLIT_ANGLE(0.02179697528481),
         SCALE_SPLIT_ANGLE(0.02186812832952),
         SCALE_SPLIT_ANGLE(0.02198898419738),
         SCALE_SPLIT_ANGLE(0.02207652665675)},
        {SCALE_SPLIT_ANGLE(0.01235581003129),
         SCALE_SPLIT_ANGLE(0.01235957816243),
         SCALE_SPLIT_ANGLE(0.01236534118652),
         SCALE_SPLIT_ANGLE(0.01237995270640),
         SCALE_SPLIT_ANGLE(0.01239436585456),
         SCALE_SPLIT_ANGLE(0.01241754554212),
         SCALE_SPLIT_ANGLE(0.01245592255145),
         SCALE_SPLIT_ANGLE(0.01248296815902)},
        {SCALE_SPLIT_ANGLE(0.00700127054006),
         SCALE_SPLIT_ANGLE(0.00700251059607),
         SCALE_SPLIT_ANGLE(0.00700440211222),
         SCALE_SPLIT_ANGLE(0.00700917327777),
         SCALE_SPLIT_ANGLE(0.00701385037974),
         SCALE_SPLIT_ANGLE(0.00702130328864),
         SCALE_SPLIT_ANGLE(0.00703346775845),
         SCALE_SPLIT_ANGLE(0.00704190973192)},
        {SCALE_SPLIT_ANGLE(0.00395415630192),
         SCALE_SPLIT_ANGLE(0.00395455770195),
         SCALE_SPLIT_ANGLE(0.00395516818389),
         SCALE_SPLIT_ANGLE(0.00395670533180),
         SCALE_SPLIT_ANGLE(0.00395820522681),
         SCALE_SPLIT_ANGLE(0.00396058429033),
         SCALE_SPLIT_ANGLE(0.00396443530917),
         SCALE_SPLIT_ANGLE(0.00396708538756)},
        {SCALE_SPLIT_ANGLE(0.00000002236068),
         SCALE_SPLIT_ANGLE(0.00000002236068),
         SCALE_SPLIT_ANGLE(0.00000002236068),
         SCALE_SPLIT_ANGLE(0.00000002236068),
         SCALE_SPLIT_ANGLE(0.00000002236068),
         SCALE_SPLIT_ANGLE(0.00000002236068),
         SCALE_SPLIT_ANGLE(0.00000002236068),
         SCALE_SPLIT_ANGLE(0.00000002236068)},
    },
    {
        {SCALE_SPLIT_ANGLE(1.17809724807739),
         SCALE_SPLIT_ANGLE(1.17809724807739),
         SCALE_SPLIT_ANGLE(1.17809724807739),
         SCALE_SPLIT_ANGLE(1.17809724807739),
         SCALE_SPLIT_ANGLE(1.17809724807739),
         SCALE_SPLIT_ANGLE(1.17809724807739),
         SCALE_SPLIT_ANGLE(1.17809724807739),
         SCALE_SPLIT_ANGLE(1.17809724807739)},
        {SCALE_SPLIT_ANGLE(1.17289519309998),
         SCALE_SPLIT_ANGLE(1.17289638519287),
         SCALE_SPLIT_ANGLE(1.17289805412292),
         SCALE_SPLIT_ANGLE(1.17290234565735),
         SCALE_SPLIT_ANGLE(1.17290651798248),
         SCALE_SPLIT_ANGLE(1.17291307449341),
         SCALE_SPLIT_ANGLE(1.17292368412018),
         SCALE_SPLIT_ANGLE(1.17293095588684)},
        {SCALE_SPLIT_ANGLE(1.16883802413940),
         SCALE_SPLIT_ANGLE(1.16884148120880),
         SCALE_SPLIT_ANGLE(1.16884684562683),
         SCALE_SPLIT_ANGLE(1.16886019706726),
         SCALE_SPLIT_ANGLE(1.16887319087982),
         SCALE_SPLIT_ANGLE(1.16889393329620),
         SCALE_SPLIT_ANGLE(1.16892755031586),
         SCALE_SPLIT_ANGLE(1.16895067691803)},
        {SCALE_SPLIT_ANGLE(1.16160655021667),
         SCALE_SPLIT_ANGLE(1.16161727905273),
         SCALE_SPLIT_ANGLE(1.16163372993469),
         SCALE_SPLIT_ANGLE(1.16167509555817),
         SCALE_SPLIT_ANGLE(1.16171574592590),
         SCALE_SPLIT_ANGLE(1.16178059577942),
         SCALE_SPLIT_ANGLE(1.16188669204712),
         SCALE_SPLIT_ANGLE(1.16196048259735)},
        {SCALE_SPLIT_ANGLE(1.14870405197144),
         SCALE_SPLIT_ANGLE(1.14873659610748),
         SCALE_SPLIT_ANGLE(1.14878630638123),
         SCALE_SPLIT_ANGLE(1.14891266822815),
         SCALE_SPLIT_ANGLE(1.14903748035431),
         SCALE_SPLIT_ANGLE(1.14923894405365),
         SCALE_SPLIT_ANGLE(1.14957404136658),
         SCALE_SPLIT_ANGLE(1.14981138706207)},
        {SCALE_SPLIT_ANGLE(1.12567496299744),
         SCALE_SPLIT_ANGLE(1.12576997280121),
         SCALE_SPLIT_ANGLE(1.12591612339020),
         SCALE_SPLIT_ANGLE(1.12629067897797),
         SCALE_SPLIT_ANGLE(1.12666594982147),
         SCALE_SPLIT_ANGLE(1.12728190422058),
         SCALE_SPLIT_ANGLE(1.12833762168884),
         SCALE_SPLIT_ANGLE(1.12910997867584)},
        {SCALE_SPLIT_ANGLE(1.10394382476807),
         SCALE_SPLIT_ANGLE(1.10412001609802),
         SCALE_SPLIT_ANGLE(1.10439181327820),
         SCALE_SPLIT_ANGLE(1.10509443283081),
         SCALE_SPLIT_ANGLE(1.10580694675446),
         SCALE_SPLIT_ANGLE(1.10699594020844),
         SCALE_SPLIT_ANGLE(1.10909199714661),
         SCALE_SPLIT_ANGLE(1.11067581176758)},
        {SCALE_SPLIT_ANGLE(1.07335853576660),
         SCALE_SPLIT_ANGLE(1.07367515563965),
         SCALE_SPLIT_ANGLE(1.07416594028473),
         SCALE_SPLIT_ANGLE(1.07544887065887),
         SCALE_SPLIT_ANGLE(1.07677161693573),
         SCALE_SPLIT_ANGLE(1.07902932167053),
         SCALE_SPLIT_ANGLE(1.08317446708679),
         SCALE_SPLIT_ANGLE(1.08645892143250)},
        {SCALE_SPLIT_ANGLE(1.03070926666260),
         SCALE_SPLIT_ANGLE(1.03125381469727),
         SCALE_SPLIT_ANGLE(1.03210365772247),
         SCALE_SPLIT_ANGLE(1.03435742855072),
         SCALE_SPLIT_ANGLE(1.03673219680786),
         SCALE_SPLIT_ANGLE(1.04091238975525),
         SCALE_SPLIT_ANGLE(1.04904520511627),
         SCALE_SPLIT_ANGLE(1.05597066879272)},
        {SCALE_SPLIT_ANGLE(0.97233027219772),
         SCALE_SPLIT_ANGLE(0.97321176528931),
         SCALE_SPLIT_ANGLE(0.97459858655930),
         SCALE_SPLIT_ANGLE(0.97834444046021),
         SCALE_SPLIT_ANGLE(0.98240250349045),
         SCALE_SPLIT_ANGLE(0.98984360694885),
         SCALE_SPLIT_ANGLE(1.00556409358978),
         SCALE_SPLIT_ANGLE(1.02053046226501)},
        {SCALE_SPLIT_ANGLE(0.89506644010544),
         SCALE_SPLIT_ANGLE(0.89638090133667),
         SCALE_SPLIT_ANGLE(0.89846849441528),
         SCALE_SPLIT_ANGLE(0.90423041582108),
         SCALE_SPLIT_ANGLE(0.91068577766418),
         SCALE_SPLIT_ANGLE(0.92315071821213),
         SCALE_SPLIT_ANGLE(0.95268243551254),
         SCALE_SPLIT_ANGLE(0.98626506328583)},
        {SCALE_SPLIT_ANGLE(0.83257329463959),
         SCALE_SPLIT_ANGLE(0.83419400453568),
         SCALE_SPLIT_ANGLE(0.83678525686264),
         SCALE_SPLIT_ANGLE(0.84404885768890),
         SCALE_SPLIT_ANGLE(0.85238879919052),
         SCALE_SPLIT_ANGLE(0.86914122104645),
         SCALE_SPLIT_ANGLE(0.91285765171051),
         SCALE_SPLIT_ANGLE(0.97222852706909)},
        {SCALE_SPLIT_ANGLE(0.76227337121964),
         SCALE_SPLIT_ANGLE(0.76417022943497),
         SCALE_SPLIT_ANGLE(0.76722234487534),
         SCALE_SPLIT_ANGLE(0.77590966224670),
         SCALE_SPLIT_ANGLE(0.78613227605820),
         SCALE_SPLIT_ANGLE(0.80752640962601),
         SCALE_SPLIT_ANGLE(0.86987829208374),
         SCALE_SPLIT_ANGLE(0.97863066196442)},
        {SCALE_SPLIT_ANGLE(0.68631619215012),
         SCALE_SPLIT_ANGLE(0.68841683864594),
         SCALE_SPLIT_ANGLE(0.69181632995605),
         SCALE_SPLIT_ANGLE(0.70162522792816),
         SCALE_SPLIT_ANGLE(0.71342813968658),
         SCALE_SPLIT_ANGLE(0.73910331726074),
         SCALE_SPLIT_ANGLE(0.82307606935501),
         SCALE_SPLIT_ANGLE(1.03223013877869)},
        {SCALE_SPLIT_ANGLE(0.60781323909760),
         SCALE_SPLIT_ANGLE(0.61001545190811),
         SCALE_SPLIT_ANGLE(0.61359488964081),
         SCALE_SPLIT_ANGLE(0.62403196096420),
         SCALE_SPLIT_ANGLE(0.63681113719940),
         SCALE_SPLIT_ANGLE(0.66548818349838),
         SCALE_SPLIT_ANGLE(0.76931142807007),
         SCALE_SPLIT_ANGLE(1.19638144969940)},
        {SCALE_SPLIT_ANGLE(0.53021633625031),
         SCALE_SPLIT_ANGLE(0.53240889310837),
         SCALE_SPLIT_ANGLE(0.53598147630692),
         SCALE_SPLIT_ANGLE(0.54646170139313),
         SCALE_SPLIT_ANGLE(0.55942362546921),
         SCALE_SPLIT_ANGLE(0.58904862403870),
         SCALE_SPLIT_ANGLE(0.70326197147369),
         SCALE_SPLIT_ANGLE(1.46822571754456)},
        {SCALE_SPLIT_ANGLE(0.45655798912048),
         SCALE_SPLIT_ANGLE(0.45864027738571),
         SCALE_SPLIT_ANGLE(0.46203431487083),
         SCALE_SPLIT_ANGLE(0.47199890017509),
         SCALE_SPLIT_ANGLE(0.48433950543404),
         SCALE_SPLIT_ANGLE(0.51260900497437),
         SCALE_SPLIT_ANGLE(0.62212866544724),
         SCALE_SPLIT_ANGLE(1.20720028877258)},
        {SCALE_SPLIT_ANGLE(0.38893291354179),
         SCALE_SPLIT_ANGLE(0.39082619547844),
         SCALE_SPLIT_ANGLE(0.39390671253204),
         SCALE_SPLIT_ANGLE(0.40291145443916),
         SCALE_SPLIT_ANGLE(0.41398161649704),
         SCALE_SPLIT_ANGLE(0.43899387121201),
         SCALE_SPLIT_ANGLE(0.53091615438461),
         SCALE_SPLIT_ANGLE(0.85221332311630)},
        {SCALE_SPLIT_ANGLE(0.32840186357498),
         SCALE_SPLIT_ANGLE(0.33005380630493),
         SCALE_SPLIT_ANGLE(0.33273181319237),
         SCALE_SPLIT_ANGLE(0.34049156308174),
         SCALE_SPLIT_ANGLE(0.34989202022552),
         SCALE_SPLIT_ANGLE(0.37057083845139),
         SCALE_SPLIT_ANGLE(0.43990376591682),
         SCALE_SPLIT_ANGLE(0.60593068599701)},
        {SCALE_SPLIT_ANGLE(0.27521029114723),
         SCALE_SPLIT_ANGLE(0.27659532427788),
         SCALE_SPLIT_ANGLE(0.27882957458496),
         SCALE_SPLIT_ANGLE(0.28522574901581),
         SCALE_SPLIT_ANGLE(0.29282194375992),
         SCALE_SPLIT_ANGLE(0.30895602703094),
         SCALE_SPLIT_ANGLE(0.35752716660500),
         SCALE_SPLIT_ANGLE(0.44366976618767)},
        {SCALE_SPLIT_ANGLE(0.22909799218178),
         SCALE_SPLIT_ANGLE(0.23021572828293),
         SCALE_SPLIT_ANGLE(0.23200811445713),
         SCALE_SPLIT_ANGLE(0.23706816136837),
         SCALE_SPLIT_ANGLE(0.24294251203537),
         SCALE_SPLIT_ANGLE(0.25494652986526),
         SCALE_SPLIT_ANGLE(0.28743273019791),
         SCALE_SPLIT_ANGLE(0.33326253294945)},
        {SCALE_SPLIT_ANGLE(0.17204397916794),
         SCALE_SPLIT_ANGLE(0.17280195653439),
         SCALE_SPLIT_ANGLE(0.17400608956814),
         SCALE_SPLIT_ANGLE(0.17733128368855),
         SCALE_SPLIT_ANGLE(0.18105845153332),
         SCALE_SPLIT_ANGLE(0.18825364112854),
         SCALE_SPLIT_ANGLE(0.20519739389420),
         SCALE_SPLIT_ANGLE(0.22397252917290)},
        {SCALE_SPLIT_ANGLE(0.12763081490994),
         SCALE_SPLIT_ANGLE(0.12810991704464),
         SCALE_SPLIT_ANGLE(0.12886413931847),
         SCALE_SPLIT_ANGLE(0.13090407848358),
         SCALE_SPLIT_ANGLE(0.13311788439751),
         SCALE_SPLIT_ANGLE(0.13718488812447),
         SCALE_SPLIT_ANGLE(0.14578336477280),
         SCALE_SPLIT_ANGLE(0.15392093360424)},
        {SCALE_SPLIT_ANGLE(0.09368771314621),
         SCALE_SPLIT_ANGLE(0.09397350251675),
         SCALE_SPLIT_ANGLE(0.09441984444857),
         SCALE_SPLIT_ANGLE(0.09560553729534),
         SCALE_SPLIT_ANGLE(0.09685769677162),
         SCALE_SPLIT_ANGLE(0.09906788915396),
         SCALE_SPLIT_ANGLE(0.10338338464499),
         SCALE_SPLIT_ANGLE(0.10706327855587)},
        {SCALE_SPLIT_ANGLE(0.06817039847374),
         SCALE_SPLIT_ANGLE(0.06833326816559),
         SCALE_SPLIT_ANGLE(0.06858598440886),
         SCALE_SPLIT_ANGLE(0.06924756616354),
         SCALE_SPLIT_ANGLE(0.06993119418621),
         SCALE_SPLIT_ANGLE(0.07110133767128),
         SCALE_SPLIT_ANGLE(0.07325870543718),
         SCALE_SPLIT_ANGLE(0.07497421652079)},
        {SCALE_SPLIT_ANGLE(0.04925633221865),
         SCALE_SPLIT_ANGLE(0.04934597760439),
         SCALE_SPLIT_ANGLE(0.04948436096311),
         SCALE_SPLIT_ANGLE(0.04984252527356),
         SCALE_SPLIT_ANGLE(0.05020647495985),
         SCALE_SPLIT_ANGLE(0.05081529542804),
         SCALE_SPLIT_ANGLE(0.05189275369048),
         SCALE_SPLIT_ANGLE(0.05270983651280)},
        {SCALE_SPLIT_ANGLE(0.02833298407495),
         SCALE_SPLIT_ANGLE(0.02836437709630),
         SCALE_SPLIT_ANGLE(0.02841254509985),
         SCALE_SPLIT_ANGLE(0.02853557839990),
         SCALE_SPLIT_ANGLE(0.02865825034678),
         SCALE_SPLIT_ANGLE(0.02885829657316),
         SCALE_SPLIT_ANGLE(0.02919724024832),
         SCALE_SPLIT_ANGLE(0.02944211289287)},
        {SCALE_SPLIT_ANGLE(0.01614447496831),
         SCALE_SPLIT_ANGLE(0.01615499891341),
         SCALE_SPLIT_ANGLE(0.01617109030485),
         SCALE_SPLIT_ANGLE(0.01621186546981),
         SCALE_SPLIT_ANGLE(0.01625206694007),
         SCALE_SPLIT_ANGLE(0.01631666347384),
         SCALE_SPLIT_ANGLE(0.01642346009612),
         SCALE_SPLIT_ANGLE(0.01649860665202)},
        {SCALE_SPLIT_ANGLE(0.00914775021374),
         SCALE_SPLIT_ANGLE(0.00915119145066),
         SCALE_SPLIT_ANGLE(0.00915644038469),
         SCALE_SPLIT_ANGLE(0.00916968286037),
         SCALE_SPLIT_ANGLE(0.00918265152723),
         SCALE_SPLIT_ANGLE(0.00920331478119),
         SCALE_SPLIT_ANGLE(0.00923701003194),
         SCALE_SPLIT_ANGLE(0.00926037877798)},
        {SCALE_SPLIT_ANGLE(0.00516638066620),
         SCALE_SPLIT_ANGLE(0.00516748987138),
         SCALE_SPLIT_ANGLE(0.00516917929053),
         SCALE_SPLIT_ANGLE(0.00517342984676),
         SCALE_SPLIT_ANGLE(0.00517757656053),
         SCALE_SPLIT_ANGLE(0.00518415356055),
         SCALE_SPLIT_ANGLE(0.00519479578361),
         SCALE_SPLIT_ANGLE(0.00520211551338)},
        {SCALE_SPLIT_ANGLE(0.00000002921564),
         SCALE_SPLIT_ANGLE(0.00000002921564),
         SCALE_SPLIT_ANGLE(0.00000002921564),
         SCALE_SPLIT_ANGLE(0.00000002921564),
         SCALE_SPLIT_ANGLE(0.00000002921564),
         SCALE_SPLIT_ANGLE(0.00000002921564),
         SCALE_SPLIT_ANGLE(0.00000002921564),
         SCALE_SPLIT_ANGLE(0.00000002921564)},
    },
    {
        {SCALE_SPLIT_ANGLE(1.57079637050629),
         SCALE_SPLIT_ANGLE(1.57079637050629),
         SCALE_SPLIT_ANGLE(1.57079637050629),
         SCALE_SPLIT_ANGLE(1.57079637050629),
         SCALE_SPLIT_ANGLE(1.57079637050629),
         SCALE_SPLIT_ANGLE(1.57079637050629),
         SCALE_SPLIT_ANGLE(1.57079637050629),
         SCALE_SPLIT_ANGLE(1.57079637050629)},
        {SCALE_SPLIT_ANGLE(1.56514155864716),
         SCALE_SPLIT_ANGLE(1.56514346599579),
         SCALE_SPLIT_ANGLE(1.56514656543732),
         SCALE_SPLIT_ANGLE(1.56515407562256),
         SCALE_SPLIT_ANGLE(1.56516146659851),
         SCALE_SPLIT_ANGLE(1.56517302989960),
         SCALE_SPLIT_ANGLE(1.56519174575806),
         SCALE_SPLIT_ANGLE(1.56520450115204)},
        {SCALE_SPLIT_ANGLE(1.56069743633270),
         SCALE_SPLIT_ANGLE(1.56070363521576),
         SCALE_SPLIT_ANGLE(1.56071317195892),
         SCALE_SPLIT_ANGLE(1.56073689460754),
         SCALE_SPLIT_ANGLE(1.56076002120972),
         SCALE_SPLIT_ANGLE(1.56079673767090),
         SCALE_SPLIT_ANGLE(1.56085586547852),
         SCALE_SPLIT_ANGLE(1.56089639663696)},
        {SCALE_SPLIT_ANGLE(1.55270349979401),
         SCALE_SPLIT_ANGLE(1.55272293090820),
         SCALE_SPLIT_ANGLE(1.55275249481201),
         SCALE_SPLIT_ANGLE(1.55282700061798),
         SCALE_SPLIT_ANGLE(1.55289983749390),
         SCALE_SPLIT_ANGLE(1.55301547050476),
         SCALE_SPLIT_ANGLE(1.55320310592651),
         SCALE_SPLIT_ANGLE(1.55333256721497)},
        {SCALE_SPLIT_ANGLE(1.53820896148682),
         SCALE_SPLIT_ANGLE(1.53826904296875),
         SCALE_SPLIT_ANGLE(1.53836083412170),
         SCALE_SPLIT_ANGLE(1.53859281539917),
         SCALE_SPLIT_ANGLE(1.53882038593292),
         SCALE_SPLIT_ANGLE(1.53918409347534),
         SCALE_SPLIT_ANGLE(1.53978037834167),
         SCALE_SPLIT_ANGLE(1.54019629955292)},
        {SCALE_SPLIT_ANGLE(1.51160359382629),
         SCALE_SPLIT_ANGLE(1.51178681850433),
         SCALE_SPLIT_ANGLE(1.51206707954407),
         SCALE_SPLIT_ANGLE(1.51277923583984),
         SCALE_SPLIT_ANGLE(1.51348364353180),
         SCALE_SPLIT_ANGLE(1.51462137699127),
         SCALE_SPLIT_ANGLE(1.51652014255524),
         SCALE_SPLIT_ANGLE(1.51787149906158)},
        {SCALE_SPLIT_ANGLE(1.48564028739929),
         SCALE_SPLIT_ANGLE(1.48599278926849),
         SCALE_SPLIT_ANGLE(1.48653328418732),
         SCALE_SPLIT_ANGLE(1.48791313171387),
         SCALE_SPLIT_ANGLE(1.48928797245026),
         SCALE_SPLIT_ANGLE(1.49152994155884),
         SCALE_SPLIT_ANGLE(1.49533641338348),
         SCALE_SPLIT_ANGLE(1.49810016155243)},
        {SCALE_SPLIT_ANGLE(1.44770443439484),
         SCALE_SPLIT_ANGLE(1.44837117195129),
         SCALE_SPLIT_ANGLE(1.44939684867859),
         SCALE_SPLIT_ANGLE(1.45203149318695),
         SCALE_SPLIT_ANGLE(1.45468175411224),
         SCALE_SPLIT_ANGLE(1.45906186103821),
         SCALE_SPLIT_ANGLE(1.46668362617493),
         SCALE_SPLIT_ANGLE(1.47238755226135)},
        {SCALE_SPLIT_ANGLE(1.39214622974396),
         SCALE_SPLIT_ANGLE(1.39337480068207),
         SCALE_SPLIT_ANGLE(1.39527153968811),
         SCALE_SPLIT_ANGLE(1.40018463134766),
         SCALE_SPLIT_ANGLE(1.40518975257874),
         SCALE_SPLIT_ANGLE(1.41361439228058),
         SCALE_SPLIT_ANGLE(1.42880713939667),
         SCALE_SPLIT_ANGLE(1.44072246551514)},
        {SCALE_SPLIT_ANGLE(1.31133699417114),
         SCALE_SPLIT_ANGLE(1.31350564956665),
         SCALE_SPLIT_ANGLE(1.31686961650848),
         SCALE_SPLIT_ANGLE(1.32567906379700),
         SCALE_SPLIT_ANGLE(1.33480501174927),
         SCALE_SPLIT_ANGLE(1.35055577754974),
         SCALE_SPLIT_ANGLE(1.38048458099365),
         SCALE_SPLIT_ANGLE(1.40579915046692)},
        {SCALE_SPLIT_ANGLE(1.19695901870728),
         SCALE_SPLIT_ANGLE(1.20052528381348),
         SCALE_SPLIT_ANGLE(1.20609176158905),
         SCALE_SPLIT_ANGLE(1.22087836265564),
         SCALE_SPLIT_ANGLE(1.23654139041901),
         SCALE_SPLIT_ANGLE(1.26451897621155),
         SCALE_SPLIT_ANGLE(1.32194638252258),
         SCALE_SPLIT_ANGLE(1.37709856033325)},
        {SCALE_SPLIT_ANGLE(1.09969496726990),
         SCALE_SPLIT_ANGLE(1.10437381267548),
         SCALE_SPLIT_ANGLE(1.11171460151672),
         SCALE_SPLIT_ANGLE(1.13144767284393),
         SCALE_SPLIT_ANGLE(1.15274536609650),
         SCALE_SPLIT_ANGLE(1.19192278385162),
         SCALE_SPLIT_ANGLE(1.27820122241974),
         SCALE_SPLIT_ANGLE(1.37287366390228)},
        {SCALE_SPLIT_ANGLE(0.98739641904831),
         SCALE_SPLIT_ANGLE(0.99314504861832),
         SCALE_SPLIT_ANGLE(1.00221848487854),
         SCALE_SPLIT_ANGLE(1.02694928646088),
         SCALE_SPLIT_ANGLE(1.05423069000244),
         SCALE_SPLIT_ANGLE(1.10619938373566),
         SCALE_SPLIT_ANGLE(1.23116791248322),
         SCALE_SPLIT_ANGLE(1.39771795272827)},
        {SCALE_SPLIT_ANGLE(0.86566168069839),
         SCALE_SPLIT_ANGLE(0.87219274044037),
         SCALE_SPLIT_ANGLE(0.88256764411926),
         SCALE_SPLIT_ANGLE(0.91127204895020),
         SCALE_SPLIT_ANGLE(0.94370108842850),
         SCALE_SPLIT_ANGLE(1.00792455673218),
         SCALE_SPLIT_ANGLE(1.17914211750031),
         SCALE_SPLIT_ANGLE(1.48121190071106)},
        {SCALE_SPLIT_ANGLE(0.74293035268784),
         SCALE_SPLIT_ANGLE(0.74975663423538),
         SCALE_SPLIT_ANGLE(0.76066619157791),
         SCALE_SPLIT_ANGLE(0.79128372669220),
         SCALE_SPLIT_ANGLE(0.82667875289917),
         SCALE_SPLIT_ANGLE(0.89952337741852),
         SCALE_SPLIT_ANGLE(1.11571300029755),
         SCALE_SPLIT_ANGLE(1.67431199550629)},
        {SCALE_SPLIT_ANGLE(0.62761706113815),
         SCALE_SPLIT_ANGLE(0.63421267271042),
         SCALE_SPLIT_ANGLE(0.64480352401733),
         SCALE_SPLIT_ANGLE(0.67486244440079),
         SCALE_SPLIT_ANGLE(0.71025311946869),
         SCALE_SPLIT_ANGLE(0.78539818525314),
         SCALE_SPLIT_ANGLE(1.02937340736389),
         SCALE_SPLIT_ANGLE(1.92301487922668)},
        {SCALE_SPLIT_ANGLE(0.52522456645966),
         SCALE_SPLIT_ANGLE(0.53118568658829),
         SCALE_SPLIT_ANGLE(0.54078328609467),
         SCALE_SPLIT_ANGLE(0.56819748878479),
         SCALE_SPLIT_ANGLE(0.60080903768539),
         SCALE_SPLIT_ANGLE(0.67127299308777),
         SCALE_SPLIT_ANGLE(0.91114157438278),
         SCALE_SPLIT_ANGLE(1.73398244380951)},
        {SCALE_SPLIT_ANGLE(0.43751955032349),
         SCALE_SPLIT_ANGLE(0.44262495636940),
         SCALE_SPLIT_ANGLE(0.45084837079048),
         SCALE_SPLIT_ANGLE(0.47435709834099),
         SCALE_SPLIT_ANGLE(0.50235128402710),
         SCALE_SPLIT_ANGLE(0.56287181377411),
         SCALE_SPLIT_ANGLE(0.76705121994019),
         SCALE_SPLIT_ANGLE(1.34888231754303)},
        {SCALE_SPLIT_ANGLE(0.36364197731018),
         SCALE_SPLIT_ANGLE(0.36782836914063),
         SCALE_SPLIT_ANGLE(0.37456014752388),
         SCALE_SPLIT_ANGLE(0.39372295141220),
         SCALE_SPLIT_ANGLE(0.41636970639229),
         SCALE_SPLIT_ANGLE(0.46459695696831),
         SCALE_SPLIT_ANGLE(0.61803084611893),
         SCALE_SPLIT_ANGLE(0.96275907754898)},
        {SCALE_SPLIT_ANGLE(0.30166232585907),
         SCALE_SPLIT_ANGLE(0.30497136712074),
         SCALE_SPLIT_ANGLE(0.31027451157570),
         SCALE_SPLIT_ANGLE(0.32524627447128),
         SCALE_SPLIT_ANGLE(0.34269109368324),
         SCALE_SPLIT_ANGLE(0.37887358665466),
         SCALE_SPLIT_ANGLE(0.48432540893555),
         SCALE_SPLIT_ANGLE(0.66878592967987)},
        {SCALE_SPLIT_ANGLE(0.24960109591484),
         SCALE_SPLIT_ANGLE(0.25213342905045),
         SCALE_SPLIT_ANGLE(0.25617361068726),
         SCALE_SPLIT_ANGLE(0.26745575666428),
         SCALE_SPLIT_ANGLE(0.28036275506020),
         SCALE_SPLIT_ANGLE(0.30627736449242),
         SCALE_SPLIT_ANGLE(0.37490701675415),
         SCALE_SPLIT_ANGLE(0.47145301103592)},
        {SCALE_SPLIT_ANGLE(0.18661488592625),
         SCALE_SPLIT_ANGLE(0.18822197616100),
         SCALE_SPLIT_ANGLE(0.19076596200466),
         SCALE_SPLIT_ANGLE(0.19773863255978),
         SCALE_SPLIT_ANGLE(0.20547652244568),
         SCALE_SPLIT_ANGLE(0.22024063766003),
         SCALE_SPLIT_ANGLE(0.25452125072479),
         SCALE_SPLIT_ANGLE(0.29236793518066)},
        {SCALE_SPLIT_ANGLE(0.13821771740913),
         SCALE_SPLIT_ANGLE(0.13918289542198),
         SCALE_SPLIT_ANGLE(0.14069861173630),
         SCALE_SPLIT_ANGLE(0.14477686583996),
         SCALE_SPLIT_ANGLE(0.14917233586311),
         SCALE_SPLIT_ANGLE(0.15718193352222),
         SCALE_SPLIT_ANGLE(0.17394064366817),
         SCALE_SPLIT_ANGLE(0.18971265852451)},
        {SCALE_SPLIT_ANGLE(0.10140904784203),
         SCALE_SPLIT_ANGLE(0.10196315497160),
         SCALE_SPLIT_ANGLE(0.10282710194588),
         SCALE_SPLIT_ANGLE(0.10511382669210),
         SCALE_SPLIT_ANGLE(0.10751703381538),
         SCALE_SPLIT_ANGLE(0.11173453181982),
         SCALE_SPLIT_ANGLE(0.11990433931351),
         SCALE_SPLIT_ANGLE(0.12683042883873)},
        {SCALE_SPLIT_ANGLE(0.07378087192774),
         SCALE_SPLIT_ANGLE(0.07408788800240),
         SCALE_SPLIT_ANGLE(0.07456368207932),
         SCALE_SPLIT_ANGLE(0.07580613344908),
         SCALE_SPLIT_ANGLE(0.07708553224802),
         SCALE_SPLIT_ANGLE(0.07926639169455),
         SCALE_SPLIT_ANGLE(0.08326309919357),
         SCALE_SPLIT_ANGLE(0.08642497658730)},
        {SCALE_SPLIT_ANGLE(0.05331044271588),
         SCALE_SPLIT_ANGLE(0.05347600579262),
         SCALE_SPLIT_ANGLE(0.05373133346438),
         SCALE_SPLIT_ANGLE(0.05439101532102),
         SCALE_SPLIT_ANGLE(0.05505970120430),
         SCALE_SPLIT_ANGLE(0.05617496743798),
         SCALE_SPLIT_ANGLE(0.05813983827829),
         SCALE_SPLIT_ANGLE(0.05962376296520)},
        {SCALE_SPLIT_ANGLE(0.03066622652113),
         SCALE_SPLIT_ANGLE(0.03072291985154),
         SCALE_SPLIT_ANGLE(0.03080986253917),
         SCALE_SPLIT_ANGLE(0.03103173524141),
         SCALE_SPLIT_ANGLE(0.03125262632966),
         SCALE_SPLIT_ANGLE(0.03161224350333),
         SCALE_SPLIT_ANGLE(0.03221991285682),
         SCALE_SPLIT_ANGLE(0.03265778720379)},
        {SCALE_SPLIT_ANGLE(0.01747439615428),
         SCALE_SPLIT_ANGLE(0.01749316416681),
         SCALE_SPLIT_ANGLE(0.01752184517682),
         SCALE_SPLIT_ANGLE(0.01759449020028),
         SCALE_SPLIT_ANGLE(0.01766604930162),
         SCALE_SPLIT_ANGLE(0.01778092049062),
         SCALE_SPLIT_ANGLE(0.01797054335475),
         SCALE_SPLIT_ANGLE(0.01810375973582)},
        {SCALE_SPLIT_ANGLE(0.00990140344948),
         SCALE_SPLIT_ANGLE(0.00990749336779),
         SCALE_SPLIT_ANGLE(0.00991678331047),
         SCALE_SPLIT_ANGLE(0.00994021166116),
         SCALE_SPLIT_ANGLE(0.00996314454824),
         SCALE_SPLIT_ANGLE(0.00999966636300),
         SCALE_SPLIT_ANGLE(0.01005917042494),
         SCALE_SPLIT_ANGLE(0.01010039448738)},
        {SCALE_SPLIT_ANGLE(0.00559204118326),
         SCALE_SPLIT_ANGLE(0.00559399509802),
         SCALE_SPLIT_ANGLE(0.00559697346762),
         SCALE_SPLIT_ANGLE(0.00560446362942),
         SCALE_SPLIT_ANGLE(0.00561177125201),
         SCALE_SPLIT_ANGLE(0.00562335411087),
         SCALE_SPLIT_ANGLE(0.00564208766446),
         SCALE_SPLIT_ANGLE(0.00565496599302)},
        {SCALE_SPLIT_ANGLE(0.00000003162278),
         SCALE_SPLIT_ANGLE(0.00000003162278),
         SCALE_SPLIT_ANGLE(0.00000003162278),
         SCALE_SPLIT_ANGLE(0.00000003162278),
         SCALE_SPLIT_ANGLE(0.00000003162278),
         SCALE_SPLIT_ANGLE(0.00000003162278),
         SCALE_SPLIT_ANGLE(0.00000003162278),
         SCALE_SPLIT_ANGLE(0.00000003162278)},
    },
    {
        {SCALE_SPLIT_ANGLE(1.96349537372589),
         SCALE_SPLIT_ANGLE(1.96349537372589),
         SCALE_SPLIT_ANGLE(1.96349537372589),
         SCALE_SPLIT_ANGLE(1.96349537372589),
         SCALE_SPLIT_ANGLE(1.96349537372589),
         SCALE_SPLIT_ANGLE(1.96349537372589),
         SCALE_SPLIT_ANGLE(1.96349537372589),
         SCALE_SPLIT_ANGLE(1.96349537372589)},
        {SCALE_SPLIT_ANGLE(1.95824837684631),
         SCALE_SPLIT_ANGLE(1.95825088024139),
         SCALE_SPLIT_ANGLE(1.95825481414795),
         SCALE_SPLIT_ANGLE(1.95826447010040),
         SCALE_SPLIT_ANGLE(1.95827388763428),
         SCALE_SPLIT_ANGLE(1.95828890800476),
         SCALE_SPLIT_ANGLE(1.95831274986267),
         SCALE_SPLIT_ANGLE(1.95832908153534)},
        {SCALE_SPLIT_ANGLE(1.95409297943115),
         SCALE_SPLIT_ANGLE(1.95410108566284),
         SCALE_SPLIT_ANGLE(1.95411336421967),
         SCALE_SPLIT_ANGLE(1.95414412021637),
         SCALE_SPLIT_ANGLE(1.95417404174805),
         SCALE_SPLIT_ANGLE(1.95422136783600),
         SCALE_SPLIT_ANGLE(1.95429730415344),
         SCALE_SPLIT_ANGLE(1.95434916019440)},
        {SCALE_SPLIT_ANGLE(1.94654774665833),
         SCALE_SPLIT_ANGLE(1.94657325744629),
         SCALE_SPLIT_ANGLE(1.94661211967468),
         SCALE_SPLIT_ANGLE(1.94670987129211),
         SCALE_SPLIT_ANGLE(1.94680488109589),
         SCALE_SPLIT_ANGLE(1.94695508480072),
         SCALE_SPLIT_ANGLE(1.94719684123993),
         SCALE_SPLIT_ANGLE(1.94736230373383)},
        {SCALE_SPLIT_ANGLE(1.93263375759125),
         SCALE_SPLIT_ANGLE(1.93271493911743),
         SCALE_SPLIT_ANGLE(1.93283843994141),
         SCALE_SPLIT_ANGLE(1.93314898014069),
         SCALE_SPLIT_ANGLE(1.93345153331757),
         SCALE_SPLIT_ANGLE(1.93393051624298),
         SCALE_SPLIT_ANGLE(1.93470382690430),
         SCALE_SPLIT_ANGLE(1.93523514270782)},
        {SCALE_SPLIT_ANGLE(1.90630435943604),
         SCALE_SPLIT_ANGLE(1.90656292438507),
         SCALE_SPLIT_ANGLE(1.90695691108704),
         SCALE_SPLIT_ANGLE(1.90794765949249),
         SCALE_SPLIT_ANGLE(1.90891444683075),
         SCALE_SPLIT_ANGLE(1.91044902801514),
         SCALE_SPLIT_ANGLE(1.91294109821320),
         SCALE_SPLIT_ANGLE(1.91466653347015)},
        {SCALE_SPLIT_ANGLE(1.87960743904114),
         SCALE_SPLIT_ANGLE(1.88012742996216),
         SCALE_SPLIT_ANGLE(1.88091933727264),
         SCALE_SPLIT_ANGLE(1.88291192054749),
         SCALE_SPLIT_ANGLE(1.88485777378082),
         SCALE_SPLIT_ANGLE(1.88795232772827),
         SCALE_SPLIT_ANGLE(1.89300394058228),
         SCALE_SPLIT_ANGLE(1.89652991294861)},
        {SCALE_SPLIT_ANGLE(1.83877396583557),
         SCALE_SPLIT_ANGLE(1.83982229232788),
         SCALE_SPLIT_ANGLE(1.84141862392426),
         SCALE_SPLIT_ANGLE(1.84543347358704),
         SCALE_SPLIT_ANGLE(1.84935534000397),
         SCALE_SPLIT_ANGLE(1.85560429096222),
         SCALE_SPLIT_ANGLE(1.86587727069855),
         SCALE_SPLIT_ANGLE(1.87314081192017)},
        {SCALE_SPLIT_ANGLE(1.77493417263031),
         SCALE_SPLIT_ANGLE(1.77705264091492),
         SCALE_SPLIT_ANGLE(1.78027474880219),
         SCALE_SPLIT_ANGLE(1.78836548328400),
         SCALE_SPLIT_ANGLE(1.79626095294952),
         SCALE_SPLIT_ANGLE(1.80886054039001),
         SCALE_SPLIT_ANGLE(1.82978034019470),
         SCALE_SPLIT_ANGLE(1.84489548206329)},
        {SCALE_SPLIT_ANGLE(1.67321813106537),
         SCALE_SPLIT_ANGLE(1.67747652530670),
         SCALE_SPLIT_ANGLE(1.68394017219543),
         SCALE_SPLIT_ANGLE(1.70011746883392),
         SCALE_SPLIT_ANGLE(1.71586501598358),
         SCALE_SPLIT_ANGLE(1.74102878570557),
         SCALE_SPLIT_ANGLE(1.78345441818237),
         SCALE_SPLIT_ANGLE(1.81531298160553)},
        {SCALE_SPLIT_ANGLE(1.51132118701935),
         SCALE_SPLIT_ANGLE(1.51959395408630),
         SCALE_SPLIT_ANGLE(1.53212559223175),
         SCALE_SPLIT_ANGLE(1.56339788436890),
         SCALE_SPLIT_ANGLE(1.59380054473877),
         SCALE_SPLIT_ANGLE(1.64260375499725),
         SCALE_SPLIT_ANGLE(1.72719120979309),
         SCALE_SPLIT_ANGLE(1.79549276828766)},
        {SCALE_SPLIT_ANGLE(1.35904061794281),
         SCALE_SPLIT_ANGLE(1.37121617794037),
         SCALE_SPLIT_ANGLE(1.38967239856720),
         SCALE_SPLIT_ANGLE(1.43583393096924),
         SCALE_SPLIT_ANGLE(1.48093688488007),
         SCALE_SPLIT_ANGLE(1.55410325527191),
         SCALE_SPLIT_ANGLE(1.68521773815155),
         SCALE_SPLIT_ANGLE(1.80024886131287)},
        {SCALE_SPLIT_ANGLE(1.17258906364441),
         SCALE_SPLIT_ANGLE(1.18893885612488),
         SCALE_SPLIT_ANGLE(1.21383893489838),
         SCALE_SPLIT_ANGLE(1.27678310871124),
         SCALE_SPLIT_ANGLE(1.33930420875549),
         SCALE_SPLIT_ANGLE(1.44322526454926),
         SCALE_SPLIT_ANGLE(1.64006817340851),
         SCALE_SPLIT_ANGLE(1.83627605438232)},
        {SCALE_SPLIT_ANGLE(0.96933782100677),
         SCALE_SPLIT_ANGLE(0.98854482173920),
         SCALE_SPLIT_ANGLE(1.01807177066803),
         SCALE_SPLIT_ANGLE(1.09429967403412),
         SCALE_SPLIT_ANGLE(1.17245352268219),
         SCALE_SPLIT_ANGLE(1.30826878547668),
         SCALE_SPLIT_ANGLE(1.58911180496216),
         SCALE_SPLIT_ANGLE(1.92719435691834)},
        {SCALE_SPLIT_ANGLE(0.77729862928391),
         SCALE_SPLIT_ANGLE(0.79675698280334),
         SCALE_SPLIT_ANGLE(0.82701611518860),
         SCALE_SPLIT_ANGLE(0.90724968910217),
         SCALE_SPLIT_ANGLE(0.99302649497986),
         SCALE_SPLIT_ANGLE(1.15163993835449),
         SCALE_SPLIT_ANGLE(1.52265202999115),
         SCALE_SPLIT_ANGLE(2.09869623184204)},
        {SCALE_SPLIT_ANGLE(0.61765128374100),
         SCALE_SPLIT_ANGLE(0.63503885269165),
         SCALE_SPLIT_ANGLE(0.66235077381134),
         SCALE_SPLIT_ANGLE(0.73653638362885),
         SCALE_SPLIT_ANGLE(0.81904613971710),
         SCALE_SPLIT_ANGLE(0.98174768686295),
         SCALE_SPLIT_ANGLE(1.42110538482666),
         SCALE_SPLIT_ANGLE(2.28386068344116)},
        {SCALE_SPLIT_ANGLE(0.49486333131790),
         SCALE_SPLIT_ANGLE(0.50909578800201),
         SCALE_SPLIT_ANGLE(0.53160983324051),
         SCALE_SPLIT_ANGLE(0.59379214048386),
         SCALE_SPLIT_ANGLE(0.66487491130829),
         SCALE_SPLIT_ANGLE(0.81185549497604),
         SCALE_SPLIT_ANGLE(1.26233386993408),
         SCALE_SPLIT_ANGLE(2.16925764083862)},
        {SCALE_SPLIT_ANGLE(0.40230560302734),
         SCALE_SPLIT_ANGLE(0.41332274675369),
         SCALE_SPLIT_ANGLE(0.43082228302956),
         SCALE_SPLIT_ANGLE(0.47957953810692),
         SCALE_SPLIT_ANGLE(0.53603589534760),
         SCALE_SPLIT_ANGLE(0.65522658824921),
         SCALE_SPLIT_ANGLE(1.04503858089447),
         SCALE_SPLIT_ANGLE(1.87041807174683)},
        {SCALE_SPLIT_ANGLE(0.33104607462883),
         SCALE_SPLIT_ANGLE(0.33927726745605),
         SCALE_SPLIT_ANGLE(0.35237133502960),
         SCALE_SPLIT_ANGLE(0.38892474770546),
         SCALE_SPLIT_ANGLE(0.43126159906387),
         SCALE_SPLIT_ANGLE(0.52027010917664),
         SCALE_SPLIT_ANGLE(0.80654186010361),
         SCALE_SPLIT_ANGLE(1.41960310935974)},
        {SCALE_SPLIT_ANGLE(0.27415537834167),
         SCALE_SPLIT_ANGLE(0.28015670180321),
         SCALE_SPLIT_ANGLE(0.28969678282738),
         SCALE_SPLIT_ANGLE(0.31623730063438),
         SCALE_SPLIT_ANGLE(0.34670370817184),
         SCALE_SPLIT_ANGLE(0.40939208865166),
         SCALE_SPLIT_ANGLE(0.59604310989380),
         SCALE_SPLIT_ANGLE(0.94309806823730)},
        {SCALE_SPLIT_ANGLE(0.22730343043804),
         SCALE_SPLIT_ANGLE(0.23159568011761),
         SCALE_SPLIT_ANGLE(0.23840220272541),
         SCALE_SPLIT_ANGLE(0.25720024108887),
         SCALE_SPLIT_ANGLE(0.27846288681030),
         SCALE_SPLIT_ANGLE(0.32089167833328),
         SCALE_SPLIT_ANGLE(0.43515858054161),
         SCALE_SPLIT_ANGLE(0.60621982812881)},
        {SCALE_SPLIT_ANGLE(0.17074465751648),
         SCALE_SPLIT_ANGLE(0.17326098680496),
         SCALE_SPLIT_ANGLE(0.17722852528095),
         SCALE_SPLIT_ANGLE(0.18802370131016),
         SCALE_SPLIT_ANGLE(0.19990929961205),
         SCALE_SPLIT_ANGLE(0.22246663272381),
         SCALE_SPLIT_ANGLE(0.27514943480492),
         SCALE_SPLIT_ANGLE(0.33505329489708)},
        {SCALE_SPLIT_ANGLE(0.12695817649364),
         SCALE_SPLIT_ANGLE(0.12838459014893),
         SCALE_SPLIT_ANGLE(0.13061878085136),
         SCALE_SPLIT_ANGLE(0.13660037517548),
         SCALE_SPLIT_ANGLE(0.14301040768623),
         SCALE_SPLIT_ANGLE(0.15463486313820),
         SCALE_SPLIT_ANGLE(0.17893929779530),
         SCALE_SPLIT_ANGLE(0.20203559100628)},
        {SCALE_SPLIT_ANGLE(0.09338590502739),
         SCALE_SPLIT_ANGLE(0.09417138993740),
         SCALE_SPLIT_ANGLE(0.09539390355349),
         SCALE_SPLIT_ANGLE(0.09861853718758),
         SCALE_SPLIT_ANGLE(0.10199318081141),
         SCALE_SPLIT_ANGLE(0.10789106786251),
         SCALE_SPLIT_ANGLE(0.11927830427885),
         SCALE_SPLIT_ANGLE(0.12894381582737)},
        {SCALE_SPLIT_ANGLE(0.06804535537958),
         SCALE_SPLIT_ANGLE(0.06846775114536),
         SCALE_SPLIT_ANGLE(0.06912153959274),
         SCALE_SPLIT_ANGLE(0.07082461565733),
         SCALE_SPLIT_ANGLE(0.07257289439440),
         SCALE_SPLIT_ANGLE(0.07554303854704),
         SCALE_SPLIT_ANGLE(0.08096561580896),
         SCALE_SPLIT_ANGLE(0.08524779230356)},
        {SCALE_SPLIT_ANGLE(0.04920704290271),
         SCALE_SPLIT_ANGLE(0.04942999407649),
         SCALE_SPLIT_ANGLE(0.04977354034781),
         SCALE_SPLIT_ANGLE(0.05065960064530),
         SCALE_SPLIT_ANGLE(0.05155571550131),
         SCALE_SPLIT_ANGLE(0.05304637551308),
         SCALE_SPLIT_ANGLE(0.05566369369626),
         SCALE_SPLIT_ANGLE(0.05763531476259)},
        {SCALE_SPLIT_ANGLE(0.02832321822643),
         SCALE_SPLIT_ANGLE(0.02839783765376),
         SCALE_SPLIT_ANGLE(0.02851220779121),
         SCALE_SPLIT_ANGLE(0.02880378998816),
         SCALE_SPLIT_ANGLE(0.02909369394183),
         SCALE_SPLIT_ANGLE(0.02956490404904),
         SCALE_SPLIT_ANGLE(0.03035926818848),
         SCALE_SPLIT_ANGLE(0.03093044832349)},
        {SCALE_SPLIT_ANGLE(0.01614263281226),
         SCALE_SPLIT_ANGLE(0.01616701297462),
         SCALE_SPLIT_ANGLE(0.01620426215231),
         SCALE_SPLIT_ANGLE(0.01629856042564),
         SCALE_SPLIT_ANGLE(0.01639137230814),
         SCALE_SPLIT_ANGLE(0.01654022186995),
         SCALE_SPLIT_ANGLE(0.01678557507694),
         SCALE_SPLIT_ANGLE(0.01695770025253)},
        {SCALE_SPLIT_ANGLE(0.00914741214365),
         SCALE_SPLIT_ANGLE(0.00915526598692),
         SCALE_SPLIT_ANGLE(0.00916724558920),
         SCALE_SPLIT_ANGLE(0.00919744372368),
         SCALE_SPLIT_ANGLE(0.00922699086368),
         SCALE_SPLIT_ANGLE(0.00927402079105),
         SCALE_SPLIT_ANGLE(0.00935057550669),
         SCALE_SPLIT_ANGLE(0.00940357148647)},
        {SCALE_SPLIT_ANGLE(0.00516631966457),
         SCALE_SPLIT_ANGLE(0.00516883004457),
         SCALE_SPLIT_ANGLE(0.00517265405506),
         SCALE_SPLIT_ANGLE(0.00518227089196),
         SCALE_SPLIT_ANGLE(0.00519165024161),
         SCALE_SPLIT_ANGLE(0.00520651414990),
         SCALE_SPLIT_ANGLE(0.00523054087535),
         SCALE_SPLIT_ANGLE(0.00524705136195)},
        {SCALE_SPLIT_ANGLE(0.00000002921564),
         SCALE_SPLIT_ANGLE(0.00000002921564),
         SCALE_SPLIT_ANGLE(0.00000002921564),
         SCALE_SPLIT_ANGLE(0.00000002921564),
         SCALE_SPLIT_ANGLE(0.00000002921564),
         SCALE_SPLIT_ANGLE(0.00000002921564),
         SCALE_SPLIT_ANGLE(0.00000002921564),
         SCALE_SPLIT_ANGLE(0.00000002921564)},
    },
    {
        {SCALE_SPLIT_ANGLE(2.35619449615479),
         SCALE_SPLIT_ANGLE(2.35619449615479),
         SCALE_SPLIT_ANGLE(2.35619449615479),
         SCALE_SPLIT_ANGLE(2.35619449615479),
         SCALE_SPLIT_ANGLE(2.35619449615479),
         SCALE_SPLIT_ANGLE(2.35619449615479),
         SCALE_SPLIT_ANGLE(2.35619449615479),
         SCALE_SPLIT_ANGLE(2.35619449615479)},
        {SCALE_SPLIT_ANGLE(2.35216379165649),
         SCALE_SPLIT_ANGLE(2.35216617584229),
         SCALE_SPLIT_ANGLE(2.35216999053955),
         SCALE_SPLIT_ANGLE(2.35217905044556),
         SCALE_SPLIT_ANGLE(2.35218811035156),
         SCALE_SPLIT_ANGLE(2.35220217704773),
         SCALE_SPLIT_ANGLE(2.35222482681274),
         SCALE_SPLIT_ANGLE(2.35224032402039)},
        {SCALE_SPLIT_ANGLE(2.34895062446594),
         SCALE_SPLIT_ANGLE(2.34895825386047),
         SCALE_SPLIT_ANGLE(2.34897017478943),
         SCALE_SPLIT_ANGLE(2.34899950027466),
         SCALE_SPLIT_ANGLE(2.34902811050415),
         SCALE_SPLIT_ANGLE(2.34907317161560),
         SCALE_SPLIT_ANGLE(2.34914517402649),
         SCALE_SPLIT_ANGLE(2.34919428825378)},
        {SCALE_SPLIT_ANGLE(2.34306812286377),
         SCALE_SPLIT_ANGLE(2.34309291839600),
         SCALE_SPLIT_ANGLE(2.34313082695007),
         SCALE_SPLIT_ANGLE(2.34322524070740),
         SCALE_SPLIT_ANGLE(2.34331679344177),
         SCALE_SPLIT_ANGLE(2.34346079826355),
         SCALE_SPLIT_ANGLE(2.34369087219238),
         SCALE_SPLIT_ANGLE(2.34384727478027)},
        {SCALE_SPLIT_ANGLE(2.33205723762512),
         SCALE_SPLIT_ANGLE(2.33213782310486),
         SCALE_SPLIT_ANGLE(2.33226013183594),
         SCALE_SPLIT_ANGLE(2.33256578445435),
         SCALE_SPLIT_ANGLE(2.33286166191101),
         SCALE_SPLIT_ANGLE(2.33332633972168),
         SCALE_SPLIT_ANGLE(2.33406686782837),
         SCALE_SPLIT_ANGLE(2.33456921577454)},
        {SCALE_SPLIT_ANGLE(2.31062912940979),
         SCALE_SPLIT_ANGLE(2.31089663505554),
         SCALE_SPLIT_ANGLE(2.31130218505859),
         SCALE_SPLIT_ANGLE(2.31231284141541),
         SCALE_SPLIT_ANGLE(2.31328654289246),
         SCALE_SPLIT_ANGLE(2.31480789184570),
         SCALE_SPLIT_ANGLE(2.31722092628479),
         SCALE_SPLIT_ANGLE(2.31885290145874)},
        {SCALE_SPLIT_ANGLE(2.28808355331421),
         SCALE_SPLIT_ANGLE(2.28864479064941),
         SCALE_SPLIT_ANGLE(2.28949403762817),
         SCALE_SPLIT_ANGLE(2.29160070419312),
         SCALE_SPLIT_ANGLE(2.29361891746521),
         SCALE_SPLIT_ANGLE(2.29675459861755),
         SCALE_SPLIT_ANGLE(2.30169844627380),
         SCALE_SPLIT_ANGLE(2.30503511428833)},
        {SCALE_SPLIT_ANGLE(2.25191521644592),
         SCALE_SPLIT_ANGLE(2.25312566757202),
         SCALE_SPLIT_ANGLE(2.25494909286499),
         SCALE_SPLIT_ANGLE(2.25943517684937),
         SCALE_SPLIT_ANGLE(2.26368880271912),
         SCALE_SPLIT_ANGLE(2.27023100852966),
         SCALE_SPLIT_ANGLE(2.28044486045837),
         SCALE_SPLIT_ANGLE(2.28732299804688)},
        {SCALE_SPLIT_ANGLE(2.19093585014343),
         SCALE_SPLIT_ANGLE(2.19366121292114),
         SCALE_SPLIT_ANGLE(2.19773292541504),
         SCALE_SPLIT_ANGLE(2.20759749412537),
         SCALE_SPLIT_ANGLE(2.21677780151367),
         SCALE_SPLIT_ANGLE(2.23064494132996),
         SCALE_SPLIT_ANGLE(2.25193929672241),
         SCALE_SPLIT_ANGLE(2.26625943183899)},
        {SCALE_SPLIT_ANGLE(2.08102917671204),
         SCALE_SPLIT_ANGLE(2.08757281303406),
         SCALE_SPLIT_ANGLE(2.09720706939697),
         SCALE_SPLIT_ANGLE(2.11991167068481),
         SCALE_SPLIT_ANGLE(2.14035654067993),
         SCALE_SPLIT_ANGLE(2.17029213905334),
         SCALE_SPLIT_ANGLE(2.21503138542175),
         SCALE_SPLIT_ANGLE(2.24518108367920)},
        {SCALE_SPLIT_ANGLE(1.86738610267639),
         SCALE_SPLIT_ANGLE(1.88426077365875),
         SCALE_SPLIT_ANGLE(1.90853273868561),
         SCALE_SPLIT_ANGLE(1.96333324909210),
         SCALE_SPLIT_ANGLE(2.01024460792542),
         SCALE_SPLIT_ANGLE(2.07577633857727),
         SCALE_SPLIT_ANGLE(2.16986608505249),
         SCALE_SPLIT_ANGLE(2.23406052589417)},
        {SCALE_SPLIT_ANGLE(1.61812174320221),
         SCALE_SPLIT_ANGLE(1.64943754673004),
         SCALE_SPLIT_ANGLE(1.69389235973358),
         SCALE_SPLIT_ANGLE(1.79176020622253),
         SCALE_SPLIT_ANGLE(1.87292492389679),
         SCALE_SPLIT_ANGLE(1.98277986049652),
         SCALE_SPLIT_ANGLE(2.13605809211731),
         SCALE_SPLIT_ANGLE(2.24282979965210)},
        {SCALE_SPLIT_ANGLE(1.26556181907654),
         SCALE_SPLIT_ANGLE(1.31512010097504),
         SCALE_SPLIT_ANGLE(1.38608694076538),
         SCALE_SPLIT_ANGLE(1.54419934749603),
         SCALE_SPLIT_ANGLE(1.67621040344238),
         SCALE_SPLIT_ANGLE(1.85417342185974),
         SCALE_SPLIT_ANGLE(2.09956336021423),
         SCALE_SPLIT_ANGLE(2.27729439735413)},
        {SCALE_SPLIT_ANGLE(0.88984864950180),
         SCALE_SPLIT_ANGLE(0.94673132896423),
         SCALE_SPLIT_ANGLE(1.03102219104767),
         SCALE_SPLIT_ANGLE(1.23219704627991),
         SCALE_SPLIT_ANGLE(1.41468584537506),
         SCALE_SPLIT_ANGLE(1.67807435989380),
         SCALE_SPLIT_ANGLE(2.05749273300171),
         SCALE_SPLIT_ANGLE(2.35138511657715)},
        {SCALE_SPLIT_ANGLE(0.60630625486374),
         SCALE_SPLIT_ANGLE(0.65551131963730),
         SCALE_SPLIT_ANGLE(0.73032128810883),
         SCALE_SPLIT_ANGLE(0.92225730419159),
         SCALE_SPLIT_ANGLE(1.11866605281830),
         SCALE_SPLIT_ANGLE(1.44806647300720),
         SCALE_SPLIT_ANGLE(1.99872636795044),
         SCALE_SPLIT_ANGLE(2.47302055358887)},
        {SCALE_SPLIT_ANGLE(0.43393731117249),
         SCALE_SPLIT_ANGLE(0.47099208831787),
         SCALE_SPLIT_ANGLE(0.52780759334564),
         SCALE_SPLIT_ANGLE(0.67895972728729),
         SCALE_SPLIT_ANGLE(0.84712409973145),
         SCALE_SPLIT_ANGLE(1.17809724807739),
         SCALE_SPLIT_ANGLE(1.89703977108002),
         SCALE_SPLIT_ANGLE(2.59155654907227)},
        {SCALE_SPLIT_ANGLE(0.33522719144821),
         SCALE_SPLIT_ANGLE(0.36133098602295),
         SCALE_SPLIT_ANGLE(0.40159517526627),
         SCALE_SPLIT_ANGLE(0.51039946079254),
         SCALE_SPLIT_ANGLE(0.63590413331985),
         SCALE_SPLIT_ANGLE(0.90812796354294),
         SCALE_SPLIT_ANGLE(1.70793557167053),
         SCALE_SPLIT_ANGLE(2.52852439880371)},
        {SCALE_SPLIT_ANGLE(0.27478924393654),
         SCALE_SPLIT_ANGLE(0.29251149296761),
         SCALE_SPLIT_ANGLE(0.32007756829262),
         SCALE_SPLIT_ANGLE(0.39531299471855),
         SCALE_SPLIT_ANGLE(0.48291319608688),
         SCALE_SPLIT_ANGLE(0.67812001705170),
         SCALE_SPLIT_ANGLE(1.39007341861725),
         SCALE_SPLIT_ANGLE(2.34402561187744)},
        {SCALE_SPLIT_ANGLE(0.23185738921165),
         SCALE_SPLIT_ANGLE(0.24370795488358),
         SCALE_SPLIT_ANGLE(0.26227980852127),
         SCALE_SPLIT_ANGLE(0.31327381730080),
         SCALE_SPLIT_ANGLE(0.37241828441620),
         SCALE_SPLIT_ANGLE(0.50202107429504),
         SCALE_SPLIT_ANGLE(0.99085599184036),
         SCALE_SPLIT_ANGLE(1.96553468704224)},
        {SCALE_SPLIT_ANGLE(0.19698308408260),
         SCALE_SPLIT_ANGLE(0.20488271117210),
         SCALE_SPLIT_ANGLE(0.21731524169445),
         SCALE_SPLIT_ANGLE(0.25148212909698),
         SCALE_SPLIT_ANGLE(0.29065516591072),
         SCALE_SPLIT_ANGLE(0.37341466546059),
         SCALE_SPLIT_ANGLE(0.65295964479446),
         SCALE_SPLIT_ANGLE(1.28865826129913)},
        {SCALE_SPLIT_ANGLE(0.16667704284191),
         SCALE_SPLIT_ANGLE(0.17194211483002),
         SCALE_SPLIT_ANGLE(0.18023577332497),
         SCALE_SPLIT_ANGLE(0.20293866097927),
         SCALE_SPLIT_ANGLE(0.22855134308338),
         SCALE_SPLIT_ANGLE(0.28041818737984),
         SCALE_SPLIT_ANGLE(0.43142420053482),
         SCALE_SPLIT_ANGLE(0.70030152797699)},
        {SCALE_SPLIT_ANGLE(0.12773877382278),
         SCALE_SPLIT_ANGLE(0.13059370219707),
         SCALE_SPLIT_ANGLE(0.13507819175720),
         SCALE_SPLIT_ANGLE(0.14721076190472),
         SCALE_SPLIT_ANGLE(0.16052412986755),
         SCALE_SPLIT_ANGLE(0.18590225279331),
         SCALE_SPLIT_ANGLE(0.24703904986382),
         SCALE_SPLIT_ANGLE(0.32153329253197)},
        {SCALE_SPLIT_ANGLE(0.09603263437748),
         SCALE_SPLIT_ANGLE(0.09756572544575),
         SCALE_SPLIT_ANGLE(0.09996145218611),
         SCALE_SPLIT_ANGLE(0.10635073482990),
         SCALE_SPLIT_ANGLE(0.11317526549101),
         SCALE_SPLIT_ANGLE(0.12554961442947),
         SCALE_SPLIT_ANGLE(0.15168419480324),
         SCALE_SPLIT_ANGLE(0.17713627219200)},
        {SCALE_SPLIT_ANGLE(0.07104731351137),
         SCALE_SPLIT_ANGLE(0.07186015695333),
         SCALE_SPLIT_ANGLE(0.07312334328890),
         SCALE_SPLIT_ANGLE(0.07644616067410),
         SCALE_SPLIT_ANGLE(0.07991369813681),
         SCALE_SPLIT_ANGLE(0.08596338331699),
         SCALE_SPLIT_ANGLE(0.09766443818808),
         SCALE_SPLIT_ANGLE(0.10767273604870)},
        {SCALE_SPLIT_ANGLE(0.05192205682397),
         SCALE_SPLIT_ANGLE(0.05234766751528),
         SCALE_SPLIT_ANGLE(0.05300576984882),
         SCALE_SPLIT_ANGLE(0.05471667647362),
         SCALE_SPLIT_ANGLE(0.05646898597479),
         SCALE_SPLIT_ANGLE(0.05943991243839),
         SCALE_SPLIT_ANGLE(0.06485754251480),
         SCALE_SPLIT_ANGLE(0.06914159655571)},
        {SCALE_SPLIT_ANGLE(0.03760399296880),
         SCALE_SPLIT_ANGLE(0.03782445564866),
         SCALE_SPLIT_ANGLE(0.03816393017769),
         SCALE_SPLIT_ANGLE(0.03903824463487),
         SCALE_SPLIT_ANGLE(0.03992090374231),
         SCALE_SPLIT_ANGLE(0.04138650372624),
         SCALE_SPLIT_ANGLE(0.04395476728678),
         SCALE_SPLIT_ANGLE(0.04588782787323)},
        {SCALE_SPLIT_ANGLE(0.02166714705527),
         SCALE_SPLIT_ANGLE(0.02173948101699),
         SCALE_SPLIT_ANGLE(0.02185030654073),
         SCALE_SPLIT_ANGLE(0.02213260531425),
         SCALE_SPLIT_ANGLE(0.02241298183799),
         SCALE_SPLIT_ANGLE(0.02286812849343),
         SCALE_SPLIT_ANGLE(0.02363408915699),
         SCALE_SPLIT_ANGLE(0.02418405190110)},
        {SCALE_SPLIT_ANGLE(0.01235313806683),
         SCALE_SPLIT_ANGLE(0.01237650960684),
         SCALE_SPLIT_ANGLE(0.01241220813245),
         SCALE_SPLIT_ANGLE(0.01250253710896),
         SCALE_SPLIT_ANGLE(0.01259138900787),
         SCALE_SPLIT_ANGLE(0.01273377332836),
         SCALE_SPLIT_ANGLE(0.01296819839627),
         SCALE_SPLIT_ANGLE(0.01313247997314)},
        {SCALE_SPLIT_ANGLE(0.00700078532100),
         SCALE_SPLIT_ANGLE(0.00700826756656),
         SCALE_SPLIT_ANGLE(0.00701967673376),
         SCALE_SPLIT_ANGLE(0.00704843224958),
         SCALE_SPLIT_ANGLE(0.00707655772567),
         SCALE_SPLIT_ANGLE(0.00712130358443),
         SCALE_SPLIT_ANGLE(0.00719408970326),
         SCALE_SPLIT_ANGLE(0.00724443979561)},
        {SCALE_SPLIT_ANGLE(0.00395406875759),
         SCALE_SPLIT_ANGLE(0.00395645201206),
         SCALE_SPLIT_ANGLE(0.00396008137614),
         SCALE_SPLIT_ANGLE(0.00396920880303),
         SCALE_SPLIT_ANGLE(0.00397810759023),
         SCALE_SPLIT_ANGLE(0.00399220688269),
         SCALE_SPLIT_ANGLE(0.00401498842984),
         SCALE_SPLIT_ANGLE(0.00403063697740)},
        {SCALE_SPLIT_ANGLE(0.00000002236068),
         SCALE_SPLIT_ANGLE(0.00000002236068),
         SCALE_SPLIT_ANGLE(0.00000002236068),
         SCALE_SPLIT_ANGLE(0.00000002236068),
         SCALE_SPLIT_ANGLE(0.00000002236068),
         SCALE_SPLIT_ANGLE(0.00000002236068),
         SCALE_SPLIT_ANGLE(0.00000002236068),
         SCALE_SPLIT_ANGLE(0.00000002236068)},
    },
    {
        {SCALE_SPLIT_ANGLE(2.74889349937439),
         SCALE_SPLIT_ANGLE(2.74889349937439),
         SCALE_SPLIT_ANGLE(2.74889349937439),
         SCALE_SPLIT_ANGLE(2.74889349937439),
         SCALE_SPLIT_ANGLE(2.74889349937439),
         SCALE_SPLIT_ANGLE(2.74889349937439),
         SCALE_SPLIT_ANGLE(2.74889349937439),
         SCALE_SPLIT_ANGLE(2.74889349937439)},
        {SCALE_SPLIT_ANGLE(2.74670672416687),
         SCALE_SPLIT_ANGLE(2.74670815467834),
         SCALE_SPLIT_ANGLE(2.74671053886414),
         SCALE_SPLIT_ANGLE(2.74671602249146),
         SCALE_SPLIT_ANGLE(2.74672174453735),
         SCALE_SPLIT_ANGLE(2.74673032760620),
         SCALE_SPLIT_ANGLE(2.74674415588379),
         SCALE_SPLIT_ANGLE(2.74675345420837)},
        {SCALE_SPLIT_ANGLE(2.74495577812195),
         SCALE_SPLIT_ANGLE(2.74496054649353),
         SCALE_SPLIT_ANGLE(2.74496769905090),
         SCALE_SPLIT_ANGLE(2.74498581886292),
         SCALE_SPLIT_ANGLE(2.74500346183777),
         SCALE_SPLIT_ANGLE(2.74503111839294),
         SCALE_SPLIT_ANGLE(2.74507498741150),
         SCALE_SPLIT_ANGLE(2.74510502815247)},
        {SCALE_SPLIT_ANGLE(2.74173212051392),
         SCALE_SPLIT_ANGLE(2.74174761772156),
         SCALE_SPLIT_ANGLE(2.74177098274231),
         SCALE_SPLIT_ANGLE(2.74182939529419),
         SCALE_SPLIT_ANGLE(2.74188613891602),
         SCALE_SPLIT_ANGLE(2.74197483062744),
         SCALE_SPLIT_ANGLE(2.74211573600769),
         SCALE_SPLIT_ANGLE(2.74221110343933)},
        {SCALE_SPLIT_ANGLE(2.73563575744629),
         SCALE_SPLIT_ANGLE(2.73568630218506),
         SCALE_SPLIT_ANGLE(2.73576331138611),
         SCALE_SPLIT_ANGLE(2.73595523834229),
         SCALE_SPLIT_ANGLE(2.73614001274109),
         SCALE_SPLIT_ANGLE(2.73642849922180),
         SCALE_SPLIT_ANGLE(2.73688435554504),
         SCALE_SPLIT_ANGLE(2.73719072341919)},
        {SCALE_SPLIT_ANGLE(2.72353148460388),
         SCALE_SPLIT_ANGLE(2.72370529174805),
         SCALE_SPLIT_ANGLE(2.72396802902222),
         SCALE_SPLIT_ANGLE(2.72461819648743),
         SCALE_SPLIT_ANGLE(2.72523880004883),
         SCALE_SPLIT_ANGLE(2.72619819641113),
         SCALE_SPLIT_ANGLE(2.72769498825073),
         SCALE_SPLIT_ANGLE(2.72869181632996)},
        {SCALE_SPLIT_ANGLE(2.71044087409973),
         SCALE_SPLIT_ANGLE(2.71081781387329),
         SCALE_SPLIT_ANGLE(2.71138477325439),
         SCALE_SPLIT_ANGLE(2.71277689933777),
         SCALE_SPLIT_ANGLE(2.71409153938293),
         SCALE_SPLIT_ANGLE(2.71610021591187),
         SCALE_SPLIT_ANGLE(2.71919155120850),
         SCALE_SPLIT_ANGLE(2.72123122215271)},
        {SCALE_SPLIT_ANGLE(2.68862843513489),
         SCALE_SPLIT_ANGLE(2.68948626518250),
         SCALE_SPLIT_ANGLE(2.69076681137085),
         SCALE_SPLIT_ANGLE(2.69386243820190),
         SCALE_SPLIT_ANGLE(2.69673037528992),
         SCALE_SPLIT_ANGLE(2.70102667808533),
         SCALE_SPLIT_ANGLE(2.70749115943909),
         SCALE_SPLIT_ANGLE(2.71170210838318)},
        {SCALE_SPLIT_ANGLE(2.64932370185852),
         SCALE_SPLIT_ANGLE(2.65145039558411),
         SCALE_SPLIT_ANGLE(2.65457701683044),
         SCALE_SPLIT_ANGLE(2.66191530227661),
         SCALE_SPLIT_ANGLE(2.66847491264343),
         SCALE_SPLIT_ANGLE(2.67795729637146),
         SCALE_SPLIT_ANGLE(2.69169545173645),
         SCALE_SPLIT_ANGLE(2.70048093795776)},
        {SCALE_SPLIT_ANGLE(2.56864428520203),
         SCALE_SPLIT_ANGLE(2.57483482360840),
         SCALE_SPLIT_ANGLE(2.58364057540894),
         SCALE_SPLIT_ANGLE(2.60311055183411),
         SCALE_SPLIT_ANGLE(2.61933612823486),
         SCALE_SPLIT_ANGLE(2.64129805564880),
         SCALE_SPLIT_ANGLE(2.67107844352722),
         SCALE_SPLIT_ANGLE(2.68960857391357)},
        {SCALE_SPLIT_ANGLE(2.35773015022278),
         SCALE_SPLIT_ANGLE(2.38251185417175),
         SCALE_SPLIT_ANGLE(2.41520094871521),
         SCALE_SPLIT_ANGLE(2.47876882553101),
         SCALE_SPLIT_ANGLE(2.52468156814575),
         SCALE_SPLIT_ANGLE(2.57956743240356),
         SCALE_SPLIT_ANGLE(2.64563941955566),
         SCALE_SPLIT_ANGLE(2.68501615524292)},
        {SCALE_SPLIT_ANGLE(1.95455360412598),
         SCALE_SPLIT_ANGLE(2.03550028800964),
         SCALE_SPLIT_ANGLE(2.13431143760681),
         SCALE_SPLIT_ANGLE(2.30167627334595),
         SCALE_SPLIT_ANGLE(2.40472936630249),
         SCALE_SPLIT_ANGLE(2.51241874694824),
         SCALE_SPLIT_ANGLE(2.62649774551392),
         SCALE_SPLIT_ANGLE(2.69151234626770)},
        {SCALE_SPLIT_ANGLE(1.08639848232269),
         SCALE_SPLIT_ANGLE(1.25607907772064),
         SCALE_SPLIT_ANGLE(1.49360668659210),
         SCALE_SPLIT_ANGLE(1.93062829971313),
         SCALE_SPLIT_ANGLE(2.18087863922119),
         SCALE_SPLIT_ANGLE(2.40583086013794),
         SCALE_SPLIT_ANGLE(2.60574340820313),
         SCALE_SPLIT_ANGLE(2.71224212646484)},
        {SCALE_SPLIT_ANGLE(0.46298864483833),
         SCALE_SPLIT_ANGLE(0.57069420814514),
         SCALE_SPLIT_ANGLE(0.74941867589951),
         SCALE_SPLIT_ANGLE(1.27059137821198),
         SCALE_SPLIT_ANGLE(1.74987781047821),
         SCALE_SPLIT_ANGLE(2.22410750389099),
         SCALE_SPLIT_ANGLE(2.58140015602112),
         SCALE_SPLIT_ANGLE(2.75301027297974)},
        {SCALE_SPLIT_ANGLE(0.23063218593597),
         SCALE_SPLIT_ANGLE(0.29689303040504),
         SCALE_SPLIT_ANGLE(0.39820966124535),
         SCALE_SPLIT_ANGLE(0.70773023366928),
         SCALE_SPLIT_ANGLE(1.13546586036682),
         SCALE_SPLIT_ANGLE(1.89722001552582),
         SCALE_SPLIT_ANGLE(2.54544758796692),
         SCALE_SPLIT_ANGLE(2.81490159034729)},
        {SCALE_SPLIT_ANGLE(0.14590546488762),
         SCALE_SPLIT_ANGLE(0.19153353571892),
         SCALE_SPLIT_ANGLE(0.25519019365311),
         SCALE_SPLIT_ANGLE(0.43163710832596),
         SCALE_SPLIT_ANGLE(0.67776858806610),
         SCALE_SPLIT_ANGLE(1.37444674968719),
         SCALE_SPLIT_ANGLE(2.47591257095337),
         SCALE_SPLIT_ANGLE(2.87223863601685)},
        {SCALE_SPLIT_ANGLE(0.12191537022591),
         SCALE_SPLIT_ANGLE(0.15053890645504),
         SCALE_SPLIT_ANGLE(0.19072309136391),
         SCALE_SPLIT_ANGLE(0.29725375771523),
         SCALE_SPLIT_ANGLE(0.43550044298172),
         SCALE_SPLIT_ANGLE(0.85167354345322),
         SCALE_SPLIT_ANGLE(2.31663155555725),
         SCALE_SPLIT_ANGLE(2.84442567825317)},
        {SCALE_SPLIT_ANGLE(0.11467454582453),
         SCALE_SPLIT_ANGLE(0.13146138191223),
         SCALE_SPLIT_ANGLE(0.15621000528336),
         SCALE_SPLIT_ANGLE(0.22212918102741),
         SCALE_SPLIT_ANGLE(0.30330246686935),
         SCALE_SPLIT_ANGLE(0.52478593587875),
         SCALE_SPLIT_ANGLE(1.91173267364502),
         SCALE_SPLIT_ANGLE(2.75908088684082)},
        {SCALE_SPLIT_ANGLE(0.10720870643854),
         SCALE_SPLIT_ANGLE(0.11720535159111),
         SCALE_SPLIT_ANGLE(0.13246683776379),
         SCALE_SPLIT_ANGLE(0.17369449138641),
         SCALE_SPLIT_ANGLE(0.22279064357281),
         SCALE_SPLIT_ANGLE(0.34306266903877),
         SCALE_SPLIT_ANGLE(1.11311781406403),
         SCALE_SPLIT_ANGLE(2.55312228202820)},
        {SCALE_SPLIT_ANGLE(0.09705757349730),
         SCALE_SPLIT_ANGLE(0.10320189595222),
         SCALE_SPLIT_ANGLE(0.11274837702513),
         SCALE_SPLIT_ANGLE(0.13873106241226),
         SCALE_SPLIT_ANGLE(0.16888953745365),
         SCALE_SPLIT_ANGLE(0.23647473752499),
         SCALE_SPLIT_ANGLE(0.53898406028748),
         SCALE_SPLIT_ANGLE(1.80699026584625)},
        {SCALE_SPLIT_ANGLE(0.08528346568346),
         SCALE_SPLIT_ANGLE(0.08915080130100),
         SCALE_SPLIT_ANGLE(0.09520188719034),
         SCALE_SPLIT_ANGLE(0.11166745424271),
         SCALE_SPLIT_ANGLE(0.13034184277058),
         SCALE_SPLIT_ANGLE(0.16932605206966),
         SCALE_SPLIT_ANGLE(0.29887470602989),
         SCALE_SPLIT_ANGLE(0.63077676296234)},
        {SCALE_SPLIT_ANGLE(0.06733843684196),
         SCALE_SPLIT_ANGLE(0.06931617110968),
         SCALE_SPLIT_ANGLE(0.07241340726614),
         SCALE_SPLIT_ANGLE(0.08076417446136),
         SCALE_SPLIT_ANGLE(0.08993341028690),
         SCALE_SPLIT_ANGLE(0.10759533941746),
         SCALE_SPLIT_ANGLE(0.15204638242722),
         SCALE_SPLIT_ANGLE(0.21143139898777)},
        {SCALE_SPLIT_ANGLE(0.05132640898228),
         SCALE_SPLIT_ANGLE(0.05234802886844),
         SCALE_SPLIT_ANGLE(0.05394187942147),
         SCALE_SPLIT_ANGLE(0.05818277224898),
         SCALE_SPLIT_ANGLE(0.06270807981491),
         SCALE_SPLIT_ANGLE(0.07093632966280),
         SCALE_SPLIT_ANGLE(0.08856786042452),
         SCALE_SPLIT_ANGLE(0.10623694956303)},
        {SCALE_SPLIT_ANGLE(0.03821930661798),
         SCALE_SPLIT_ANGLE(0.03874678537250),
         SCALE_SPLIT_ANGLE(0.03956566005945),
         SCALE_SPLIT_ANGLE(0.04171610623598),
         SCALE_SPLIT_ANGLE(0.04395710676908),
         SCALE_SPLIT_ANGLE(0.04786692932248),
         SCALE_SPLIT_ANGLE(0.05546034500003),
         SCALE_SPLIT_ANGLE(0.06201593577862)},
        {SCALE_SPLIT_ANGLE(0.02801758050919),
         SCALE_SPLIT_ANGLE(0.02828873321414),
         SCALE_SPLIT_ANGLE(0.02870770171285),
         SCALE_SPLIT_ANGLE(0.02979558333755),
         SCALE_SPLIT_ANGLE(0.03090834617615),
         SCALE_SPLIT_ANGLE(0.03279331326485),
         SCALE_SPLIT_ANGLE(0.03623208031058),
         SCALE_SPLIT_ANGLE(0.03895835205913)},
        {SCALE_SPLIT_ANGLE(0.02032180689275),
         SCALE_SPLIT_ANGLE(0.02046046219766),
         SCALE_SPLIT_ANGLE(0.02067386545241),
         SCALE_SPLIT_ANGLE(0.02122297696769),
         SCALE_SPLIT_ANGLE(0.02177673391998),
         SCALE_SPLIT_ANGLE(0.02269527874887),
         SCALE_SPLIT_ANGLE(0.02430364489555),
         SCALE_SPLIT_ANGLE(0.02551441825926)},
        {SCALE_SPLIT_ANGLE(0.01172095164657),
         SCALE_SPLIT_ANGLE(0.01176583208144),
         SCALE_SPLIT_ANGLE(0.01183457672596),
         SCALE_SPLIT_ANGLE(0.01200959738344),
         SCALE_SPLIT_ANGLE(0.01218330394477),
         SCALE_SPLIT_ANGLE(0.01246506255120),
         SCALE_SPLIT_ANGLE(0.01293875463307),
         SCALE_SPLIT_ANGLE(0.01327861472964)},
        {SCALE_SPLIT_ANGLE(0.00668454170227),
         SCALE_SPLIT_ANGLE(0.00669893343002),
         SCALE_SPLIT_ANGLE(0.00672091403976),
         SCALE_SPLIT_ANGLE(0.00677651492879),
         SCALE_SPLIT_ANGLE(0.00683118170127),
         SCALE_SPLIT_ANGLE(0.00691874232143),
         SCALE_SPLIT_ANGLE(0.00706279883161),
         SCALE_SPLIT_ANGLE(0.00716368528083)},
        {SCALE_SPLIT_ANGLE(0.00378863257356),
         SCALE_SPLIT_ANGLE(0.00379322143272),
         SCALE_SPLIT_ANGLE(0.00380021659657),
         SCALE_SPLIT_ANGLE(0.00381784536876),
         SCALE_SPLIT_ANGLE(0.00383508414961),
         SCALE_SPLIT_ANGLE(0.00386250065640),
         SCALE_SPLIT_ANGLE(0.00390707794577),
         SCALE_SPLIT_ANGLE(0.00393790053204)},
        {SCALE_SPLIT_ANGLE(0.00213989755139),
         SCALE_SPLIT_ANGLE(0.00214135553688),
         SCALE_SPLIT_ANGLE(0.00214357557707),
         SCALE_SPLIT_ANGLE(0.00214915862307),
         SCALE_SPLIT_ANGLE(0.00215460127220),
         SCALE_SPLIT_ANGLE(0.00216322275810),
         SCALE_SPLIT_ANGLE(0.00217714952305),
         SCALE_SPLIT_ANGLE(0.00218671280891)},
        {SCALE_SPLIT_ANGLE(0.00000001210151),
         SCALE_SPLIT_ANGLE(0.00000001210151),
         SCALE_SPLIT_ANGLE(0.00000001210151),
         SCALE_SPLIT_ANGLE(0.00000001210152),
         SCALE_SPLIT_ANGLE(0.00000001210152),
         SCALE_SPLIT_ANGLE(0.00000001210152),
         SCALE_SPLIT_ANGLE(0.00000001210152),
         SCALE_SPLIT_ANGLE(0.00000001210152)},
    },
    {
        {SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399)},
        {SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399)},
        {SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399)},
        {SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399)},
        {SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399)},
        {SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399)},
        {SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399)},
        {SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399)},
        {SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399)},
        {SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399)},
        {SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399)},
        {SCALE_SPLIT_ANGLE(-3.14159226417542),
         SCALE_SPLIT_ANGLE(-3.14159226417542),
         SCALE_SPLIT_ANGLE(-3.14159226417542),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399)},
        {SCALE_SPLIT_ANGLE(-0.00000036774148),
         SCALE_SPLIT_ANGLE(-0.00000066993488),
         SCALE_SPLIT_ANGLE(-0.00001151842844),
         SCALE_SPLIT_ANGLE(-3.14159226417542),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399)},
        {SCALE_SPLIT_ANGLE(-0.00000008554968),
         SCALE_SPLIT_ANGLE(-0.00000012210570),
         SCALE_SPLIT_ANGLE(-0.00000019699247),
         SCALE_SPLIT_ANGLE(-0.00000110842382),
         SCALE_SPLIT_ANGLE(-3.14159202575684),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399)},
        {SCALE_SPLIT_ANGLE(-0.00000003016602),
         SCALE_SPLIT_ANGLE(-0.00000005321843),
         SCALE_SPLIT_ANGLE(-0.00000008440014),
         SCALE_SPLIT_ANGLE(-0.00000020468090),
         SCALE_SPLIT_ANGLE(-0.00000071846705),
         SCALE_SPLIT_ANGLE(-3.14159226417542),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399)},
        {SCALE_SPLIT_ANGLE(-0.00000000024720),
         SCALE_SPLIT_ANGLE(-0.00000003226497),
         SCALE_SPLIT_ANGLE(-0.00000005171609),
         SCALE_SPLIT_ANGLE(-0.00000010526998),
         SCALE_SPLIT_ANGLE(-0.00000020551137),
         SCALE_SPLIT_ANGLE(-1.57079637050629),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399)},
        {SCALE_SPLIT_ANGLE(-0.00000001688349),
         SCALE_SPLIT_ANGLE(-0.00000002741881),
         SCALE_SPLIT_ANGLE(-0.00000003926384),
         SCALE_SPLIT_ANGLE(-0.00000006928260),
         SCALE_SPLIT_ANGLE(-0.00000011240582),
         SCALE_SPLIT_ANGLE(-0.00000033763689),
         SCALE_SPLIT_ANGLE(-3.14159250259399),
         SCALE_SPLIT_ANGLE(-3.14159250259399)},
        {SCALE_SPLIT_ANGLE(-0.00000002143362),
         SCALE_SPLIT_ANGLE(-0.00000002640935),
         SCALE_SPLIT_ANGLE(-0.00000003328325),
         SCALE_SPLIT_ANGLE(-0.00000005112437),
         SCALE_SPLIT_ANGLE(-0.00000007399619),
         SCALE_SPLIT_ANGLE(-0.00000014946792),
         SCALE_SPLIT_ANGLE(-3.14159226417542),
         SCALE_SPLIT_ANGLE(-3.14159250259399)},
        {SCALE_SPLIT_ANGLE(-0.00000002225921),
         SCALE_SPLIT_ANGLE(-0.00000002497380),
         SCALE_SPLIT_ANGLE(-0.00000002903169),
         SCALE_SPLIT_ANGLE(-0.00000003987020),
         SCALE_SPLIT_ANGLE(-0.00000005300816),
         SCALE_SPLIT_ANGLE(-0.00000008783893),
         SCALE_SPLIT_ANGLE(-0.00000093762065),
         SCALE_SPLIT_ANGLE(-3.14159250259399)},
        {SCALE_SPLIT_ANGLE(-0.00000002109218),
         SCALE_SPLIT_ANGLE(-0.00000002269230),
         SCALE_SPLIT_ANGLE(-0.00000002515904),
         SCALE_SPLIT_ANGLE(-0.00000003183984),
         SCALE_SPLIT_ANGLE(-0.00000003965878),
         SCALE_SPLIT_ANGLE(-0.00000005782364),
         SCALE_SPLIT_ANGLE(-0.00000016152633),
         SCALE_SPLIT_ANGLE(-3.14159226417542)},
        {SCALE_SPLIT_ANGLE(-0.00000001895314),
         SCALE_SPLIT_ANGLE(-0.00000001993623),
         SCALE_SPLIT_ANGLE(-0.00000002146927),
         SCALE_SPLIT_ANGLE(-0.00000002563087),
         SCALE_SPLIT_ANGLE(-0.00000003036888),
         SCALE_SPLIT_ANGLE(-0.00000004043087),
         SCALE_SPLIT_ANGLE(-0.00000007667983),
         SCALE_SPLIT_ANGLE(-0.00000021028936)},
        {SCALE_SPLIT_ANGLE(-0.00000001519980),
         SCALE_SPLIT_ANGLE(-0.00000001569144),
         SCALE_SPLIT_ANGLE(-0.00000001646043),
         SCALE_SPLIT_ANGLE(-0.00000001853141),
         SCALE_SPLIT_ANGLE(-0.00000002080756),
         SCALE_SPLIT_ANGLE(-0.00000002521688),
         SCALE_SPLIT_ANGLE(-0.00000003656274),
         SCALE_SPLIT_ANGLE(-0.00000005247700)},
        {SCALE_SPLIT_ANGLE(-0.00000001166148),
         SCALE_SPLIT_ANGLE(-0.00000001191188),
         SCALE_SPLIT_ANGLE(-0.00000001230229),
         SCALE_SPLIT_ANGLE(-0.00000001334031),
         SCALE_SPLIT_ANGLE(-0.00000001444787),
         SCALE_SPLIT_ANGLE(-0.00000001646512),
         SCALE_SPLIT_ANGLE(-0.00000002081803),
         SCALE_SPLIT_ANGLE(-0.00000002523831)},
        {SCALE_SPLIT_ANGLE(-0.00000000870876),
         SCALE_SPLIT_ANGLE(-0.00000000883681),
         SCALE_SPLIT_ANGLE(-0.00000000903554),
         SCALE_SPLIT_ANGLE(-0.00000000955712),
         SCALE_SPLIT_ANGLE(-0.00000001010047),
         SCALE_SPLIT_ANGLE(-0.00000001104868),
         SCALE_SPLIT_ANGLE(-0.00000001289412),
         SCALE_SPLIT_ANGLE(-0.00000001449405)},
        {SCALE_SPLIT_ANGLE(-0.00000000639270),
         SCALE_SPLIT_ANGLE(-0.00000000645810),
         SCALE_SPLIT_ANGLE(-0.00000000655912),
         SCALE_SPLIT_ANGLE(-0.00000000682132),
         SCALE_SPLIT_ANGLE(-0.00000000708940),
         SCALE_SPLIT_ANGLE(-0.00000000754343),
         SCALE_SPLIT_ANGLE(-0.00000000837207),
         SCALE_SPLIT_ANGLE(-0.00000000902983)},
        {SCALE_SPLIT_ANGLE(-0.00000000463970),
         SCALE_SPLIT_ANGLE(-0.00000000467299),
         SCALE_SPLIT_ANGLE(-0.00000000472421),
         SCALE_SPLIT_ANGLE(-0.00000000485598),
         SCALE_SPLIT_ANGLE(-0.00000000498881),
         SCALE_SPLIT_ANGLE(-0.00000000520907),
         SCALE_SPLIT_ANGLE(-0.00000000559469),
         SCALE_SPLIT_ANGLE(-0.00000000588504)},
        {SCALE_SPLIT_ANGLE(-0.00000000267713),
         SCALE_SPLIT_ANGLE(-0.00000000268785),
         SCALE_SPLIT_ANGLE(-0.00000000270428),
         SCALE_SPLIT_ANGLE(-0.00000000274608),
         SCALE_SPLIT_ANGLE(-0.00000000278756),
         SCALE_SPLIT_ANGLE(-0.00000000285483),
         SCALE_SPLIT_ANGLE(-0.00000000296788),
         SCALE_SPLIT_ANGLE(-0.00000000304897)},
        {SCALE_SPLIT_ANGLE(-0.00000000152698),
         SCALE_SPLIT_ANGLE(-0.00000000153041),
         SCALE_SPLIT_ANGLE(-0.00000000153564),
         SCALE_SPLIT_ANGLE(-0.00000000154889),
         SCALE_SPLIT_ANGLE(-0.00000000156191),
         SCALE_SPLIT_ANGLE(-0.00000000158277),
         SCALE_SPLIT_ANGLE(-0.00000000161707),
         SCALE_SPLIT_ANGLE(-0.00000000164109)},
        {SCALE_SPLIT_ANGLE(-0.00000000086549),
         SCALE_SPLIT_ANGLE(-0.00000000086658),
         SCALE_SPLIT_ANGLE(-0.00000000086824),
         SCALE_SPLIT_ANGLE(-0.00000000087244),
         SCALE_SPLIT_ANGLE(-0.00000000087654),
         SCALE_SPLIT_ANGLE(-0.00000000088306),
         SCALE_SPLIT_ANGLE(-0.00000000089366),
         SCALE_SPLIT_ANGLE(-0.00000000090099)},
        {SCALE_SPLIT_ANGLE(-0.00000000048885),
         SCALE_SPLIT_ANGLE(-0.00000000048920),
         SCALE_SPLIT_ANGLE(-0.00000000048972),
         SCALE_SPLIT_ANGLE(-0.00000000049105),
         SCALE_SPLIT_ANGLE(-0.00000000049235),
         SCALE_SPLIT_ANGLE(-0.00000000049439),
         SCALE_SPLIT_ANGLE(-0.00000000049770),
         SCALE_SPLIT_ANGLE(-0.00000000049998)},
        {SCALE_SPLIT_ANGLE(-0.00000000000000),
         SCALE_SPLIT_ANGLE(-0.00000000000000),
         SCALE_SPLIT_ANGLE(-0.00000000000000),
         SCALE_SPLIT_ANGLE(-0.00000000000000),
         SCALE_SPLIT_ANGLE(-0.00000000000000),
         SCALE_SPLIT_ANGLE(-0.00000000000000),
         SCALE_SPLIT_ANGLE(-0.00000000000000),
         SCALE_SPLIT_ANGLE(-0.00000000000000)},
    },
    {
        {SCALE_SPLIT_ANGLE(-2.74889349937439),
         SCALE_SPLIT_ANGLE(-2.74889349937439),
         SCALE_SPLIT_ANGLE(-2.74889349937439),
         SCALE_SPLIT_ANGLE(-2.74889349937439),
         SCALE_SPLIT_ANGLE(-2.74889349937439),
         SCALE_SPLIT_ANGLE(-2.74889349937439),
         SCALE_SPLIT_ANGLE(-2.74889349937439),
         SCALE_SPLIT_ANGLE(-2.74889349937439)},
        {SCALE_SPLIT_ANGLE(-2.74670672416687),
         SCALE_SPLIT_ANGLE(-2.74670815467834),
         SCALE_SPLIT_ANGLE(-2.74671053886414),
         SCALE_SPLIT_ANGLE(-2.74671626091003),
         SCALE_SPLIT_ANGLE(-2.74672174453735),
         SCALE_SPLIT_ANGLE(-2.74673032760620),
         SCALE_SPLIT_ANGLE(-2.74674415588379),
         SCALE_SPLIT_ANGLE(-2.74675369262695)},
        {SCALE_SPLIT_ANGLE(-2.74495577812195),
         SCALE_SPLIT_ANGLE(-2.74496054649353),
         SCALE_SPLIT_ANGLE(-2.74496769905090),
         SCALE_SPLIT_ANGLE(-2.74498581886292),
         SCALE_SPLIT_ANGLE(-2.74500346183777),
         SCALE_SPLIT_ANGLE(-2.74503111839294),
         SCALE_SPLIT_ANGLE(-2.74507522583008),
         SCALE_SPLIT_ANGLE(-2.74510502815247)},
        {SCALE_SPLIT_ANGLE(-2.74173235893250),
         SCALE_SPLIT_ANGLE(-2.74174761772156),
         SCALE_SPLIT_ANGLE(-2.74177098274231),
         SCALE_SPLIT_ANGLE(-2.74182963371277),
         SCALE_SPLIT_ANGLE(-2.74188613891602),
         SCALE_SPLIT_ANGLE(-2.74197483062744),
         SCALE_SPLIT_ANGLE(-2.74211597442627),
         SCALE_SPLIT_ANGLE(-2.74221134185791)},
        {SCALE_SPLIT_ANGLE(-2.73563575744629),
         SCALE_SPLIT_ANGLE(-2.73568654060364),
         SCALE_SPLIT_ANGLE(-2.73576331138611),
         SCALE_SPLIT_ANGLE(-2.73595523834229),
         SCALE_SPLIT_ANGLE(-2.73614001274109),
         SCALE_SPLIT_ANGLE(-2.73642849922180),
         SCALE_SPLIT_ANGLE(-2.73688435554504),
         SCALE_SPLIT_ANGLE(-2.73719096183777)},
        {SCALE_SPLIT_ANGLE(-2.72353172302246),
         SCALE_SPLIT_ANGLE(-2.72370529174805),
         SCALE_SPLIT_ANGLE(-2.72396802902222),
         SCALE_SPLIT_ANGLE(-2.72461819648743),
         SCALE_SPLIT_ANGLE(-2.72523903846741),
         SCALE_SPLIT_ANGLE(-2.72619819641113),
         SCALE_SPLIT_ANGLE(-2.72769522666931),
         SCALE_SPLIT_ANGLE(-2.72869181632996)},
        {SCALE_SPLIT_ANGLE(-2.71044111251831),
         SCALE_SPLIT_ANGLE(-2.71081781387329),
         SCALE_SPLIT_ANGLE(-2.71138477325439),
         SCALE_SPLIT_ANGLE(-2.71277689933777),
         SCALE_SPLIT_ANGLE(-2.71409153938293),
         SCALE_SPLIT_ANGLE(-2.71610021591187),
         SCALE_SPLIT_ANGLE(-2.71919155120850),
         SCALE_SPLIT_ANGLE(-2.72123122215271)},
        {SCALE_SPLIT_ANGLE(-2.68862843513489),
         SCALE_SPLIT_ANGLE(-2.68948626518250),
         SCALE_SPLIT_ANGLE(-2.69076681137085),
         SCALE_SPLIT_ANGLE(-2.69386243820190),
         SCALE_SPLIT_ANGLE(-2.69673061370850),
         SCALE_SPLIT_ANGLE(-2.70102667808533),
         SCALE_SPLIT_ANGLE(-2.70749115943909),
         SCALE_SPLIT_ANGLE(-2.71170234680176)},
        {SCALE_SPLIT_ANGLE(-2.64932370185852),
         SCALE_SPLIT_ANGLE(-2.65145063400269),
         SCALE_SPLIT_ANGLE(-2.65457701683044),
         SCALE_SPLIT_ANGLE(-2.66191530227661),
         SCALE_SPLIT_ANGLE(-2.66847491264343),
         SCALE_SPLIT_ANGLE(-2.67795729637146),
         SCALE_SPLIT_ANGLE(-2.69169569015503),
         SCALE_SPLIT_ANGLE(-2.70048117637634)},
        {SCALE_SPLIT_ANGLE(-2.56864428520203),
         SCALE_SPLIT_ANGLE(-2.57483482360840),
         SCALE_SPLIT_ANGLE(-2.58364057540894),
         SCALE_SPLIT_ANGLE(-2.60311055183411),
         SCALE_SPLIT_ANGLE(-2.61933612823486),
         SCALE_SPLIT_ANGLE(-2.64129829406738),
         SCALE_SPLIT_ANGLE(-2.67107868194580),
         SCALE_SPLIT_ANGLE(-2.68960881233215)},
        {SCALE_SPLIT_ANGLE(-2.35773015022278),
         SCALE_SPLIT_ANGLE(-2.38251185417175),
         SCALE_SPLIT_ANGLE(-2.41520094871521),
         SCALE_SPLIT_ANGLE(-2.47876906394959),
         SCALE_SPLIT_ANGLE(-2.52468156814575),
         SCALE_SPLIT_ANGLE(-2.57956743240356),
         SCALE_SPLIT_ANGLE(-2.64563965797424),
         SCALE_SPLIT_ANGLE(-2.68501615524292)},
        {SCALE_SPLIT_ANGLE(-1.95455360412598),
         SCALE_SPLIT_ANGLE(-2.03550028800964),
         SCALE_SPLIT_ANGLE(-2.13431143760681),
         SCALE_SPLIT_ANGLE(-2.30167627334595),
         SCALE_SPLIT_ANGLE(-2.40472936630249),
         SCALE_SPLIT_ANGLE(-2.51241874694824),
         SCALE_SPLIT_ANGLE(-2.62649774551392),
         SCALE_SPLIT_ANGLE(-2.69151234626770)},
        {SCALE_SPLIT_ANGLE(-1.08639836311340),
         SCALE_SPLIT_ANGLE(-1.25607907772064),
         SCALE_SPLIT_ANGLE(-1.49360668659210),
         SCALE_SPLIT_ANGLE(-1.93062829971313),
         SCALE_SPLIT_ANGLE(-2.18087887763977),
         SCALE_SPLIT_ANGLE(-2.40583086013794),
         SCALE_SPLIT_ANGLE(-2.60574340820313),
         SCALE_SPLIT_ANGLE(-2.71224212646484)},
        {SCALE_SPLIT_ANGLE(-0.46298858523369),
         SCALE_SPLIT_ANGLE(-0.57069414854050),
         SCALE_SPLIT_ANGLE(-0.74941855669022),
         SCALE_SPLIT_ANGLE(-1.27059125900269),
         SCALE_SPLIT_ANGLE(-1.74987781047821),
         SCALE_SPLIT_ANGLE(-2.22410750389099),
         SCALE_SPLIT_ANGLE(-2.58140015602112),
         SCALE_SPLIT_ANGLE(-2.75301027297974)},
        {SCALE_SPLIT_ANGLE(-0.23063215613365),
         SCALE_SPLIT_ANGLE(-0.29689297080040),
         SCALE_SPLIT_ANGLE(-0.39820960164070),
         SCALE_SPLIT_ANGLE(-0.70773017406464),
         SCALE_SPLIT_ANGLE(-1.13546574115753),
         SCALE_SPLIT_ANGLE(-1.89722001552582),
         SCALE_SPLIT_ANGLE(-2.54544782638550),
         SCALE_SPLIT_ANGLE(-2.81490182876587)},
        {SCALE_SPLIT_ANGLE(-0.14590544998646),
         SCALE_SPLIT_ANGLE(-0.19153350591660),
         SCALE_SPLIT_ANGLE(-0.25519016385078),
         SCALE_SPLIT_ANGLE(-0.43163704872131),
         SCALE_SPLIT_ANGLE(-0.67776852846146),
         SCALE_SPLIT_ANGLE(-1.37444674968719),
         SCALE_SPLIT_ANGLE(-2.47591280937195),
         SCALE_SPLIT_ANGLE(-2.87223863601685)},
        {SCALE_SPLIT_ANGLE(-0.12191534787416),
         SCALE_SPLIT_ANGLE(-0.15053887665272),
         SCALE_SPLIT_ANGLE(-0.19072306156158),
         SCALE_SPLIT_ANGLE(-0.29725372791290),
         SCALE_SPLIT_ANGLE(-0.43550038337708),
         SCALE_SPLIT_ANGLE(-0.85167348384857),
         SCALE_SPLIT_ANGLE(-2.31663155555725),
         SCALE_SPLIT_ANGLE(-2.84442567825317)},
        {SCALE_SPLIT_ANGLE(-0.11467452347279),
         SCALE_SPLIT_ANGLE(-0.13146135210991),
         SCALE_SPLIT_ANGLE(-0.15620997548103),
         SCALE_SPLIT_ANGLE(-0.22212913632393),
         SCALE_SPLIT_ANGLE(-0.30330240726471),
         SCALE_SPLIT_ANGLE(-0.52478587627411),
         SCALE_SPLIT_ANGLE(-1.91173267364502),
         SCALE_SPLIT_ANGLE(-2.75908088684082)},
        {SCALE_SPLIT_ANGLE(-0.10720869153738),
         SCALE_SPLIT_ANGLE(-0.11720532923937),
         SCALE_SPLIT_ANGLE(-0.13246680796146),
         SCALE_SPLIT_ANGLE(-0.17369446158409),
         SCALE_SPLIT_ANGLE(-0.22279061377048),
         SCALE_SPLIT_ANGLE(-0.34306260943413),
         SCALE_SPLIT_ANGLE(-1.11311769485474),
         SCALE_SPLIT_ANGLE(-2.55312228202820)},
        {SCALE_SPLIT_ANGLE(-0.09705755859613),
         SCALE_SPLIT_ANGLE(-0.10320188105106),
         SCALE_SPLIT_ANGLE(-0.11274836212397),
         SCALE_SPLIT_ANGLE(-0.13873104751110),
         SCALE_SPLIT_ANGLE(-0.16888950765133),
         SCALE_SPLIT_ANGLE(-0.23647469282150),
         SCALE_SPLIT_ANGLE(-0.53898400068283),
         SCALE_SPLIT_ANGLE(-1.80699026584625)},
        {SCALE_SPLIT_ANGLE(-0.08528345078230),
         SCALE_SPLIT_ANGLE(-0.08915078639984),
         SCALE_SPLIT_ANGLE(-0.09520187228918),
         SCALE_SPLIT_ANGLE(-0.11166743934155),
         SCALE_SPLIT_ANGLE(-0.13034182786942),
         SCALE_SPLIT_ANGLE(-0.16932602226734),
         SCALE_SPLIT_ANGLE(-0.29887464642525),
         SCALE_SPLIT_ANGLE(-0.63077670335770)},
        {SCALE_SPLIT_ANGLE(-0.06733842939138),
         SCALE_SPLIT_ANGLE(-0.06931615620852),
         SCALE_SPLIT_ANGLE(-0.07241339236498),
         SCALE_SPLIT_ANGLE(-0.08076415956020),
         SCALE_SPLIT_ANGLE(-0.08993339538574),
         SCALE_SPLIT_ANGLE(-0.10759532451630),
         SCALE_SPLIT_ANGLE(-0.15204635262489),
         SCALE_SPLIT_ANGLE(-0.21143136918545)},
        {SCALE_SPLIT_ANGLE(-0.05132640153170),
         SCALE_SPLIT_ANGLE(-0.05234802141786),
         SCALE_SPLIT_ANGLE(-0.05394186824560),
         SCALE_SPLIT_ANGLE(-0.05818276479840),
         SCALE_SPLIT_ANGLE(-0.06270807236433),
         SCALE_SPLIT_ANGLE(-0.07093632221222),
         SCALE_SPLIT_ANGLE(-0.08856784552336),
         SCALE_SPLIT_ANGLE(-0.10623692721128)},
        {SCALE_SPLIT_ANGLE(-0.03821930289268),
         SCALE_SPLIT_ANGLE(-0.03874678164721),
         SCALE_SPLIT_ANGLE(-0.03956565260887),
         SCALE_SPLIT_ANGLE(-0.04171609878540),
         SCALE_SPLIT_ANGLE(-0.04395709931850),
         SCALE_SPLIT_ANGLE(-0.04786692187190),
         SCALE_SPLIT_ANGLE(-0.05546033382416),
         SCALE_SPLIT_ANGLE(-0.06201592460275)},
        {SCALE_SPLIT_ANGLE(-0.02801757678390),
         SCALE_SPLIT_ANGLE(-0.02828872948885),
         SCALE_SPLIT_ANGLE(-0.02870769798756),
         SCALE_SPLIT_ANGLE(-0.02979557774961),
         SCALE_SPLIT_ANGLE(-0.03090834245086),
         SCALE_SPLIT_ANGLE(-0.03279330953956),
         SCALE_SPLIT_ANGLE(-0.03623207286000),
         SCALE_SPLIT_ANGLE(-0.03895834833384)},
        {SCALE_SPLIT_ANGLE(-0.02032180316746),
         SCALE_SPLIT_ANGLE(-0.02046045847237),
         SCALE_SPLIT_ANGLE(-0.02067386172712),
         SCALE_SPLIT_ANGLE(-0.02122297324240),
         SCALE_SPLIT_ANGLE(-0.02177673205733),
         SCALE_SPLIT_ANGLE(-0.02269527502358),
         SCALE_SPLIT_ANGLE(-0.02430364117026),
         SCALE_SPLIT_ANGLE(-0.02551441267133)},
        {SCALE_SPLIT_ANGLE(-0.01172094978392),
         SCALE_SPLIT_ANGLE(-0.01176583021879),
         SCALE_SPLIT_ANGLE(-0.01183457486331),
         SCALE_SPLIT_ANGLE(-0.01200959552079),
         SCALE_SPLIT_ANGLE(-0.01218330208212),
         SCALE_SPLIT_ANGLE(-0.01246506068856),
         SCALE_SPLIT_ANGLE(-0.01293875277042),
         SCALE_SPLIT_ANGLE(-0.01327861286700)},
        {SCALE_SPLIT_ANGLE(-0.00668454030529),
         SCALE_SPLIT_ANGLE(-0.00669893249869),
         SCALE_SPLIT_ANGLE(-0.00672091310844),
         SCALE_SPLIT_ANGLE(-0.00677651399747),
         SCALE_SPLIT_ANGLE(-0.00683118030429),
         SCALE_SPLIT_ANGLE(-0.00691874139011),
         SCALE_SPLIT_ANGLE(-0.00706279790029),
         SCALE_SPLIT_ANGLE(-0.00716368434951)},
        {SCALE_SPLIT_ANGLE(-0.00378863210790),
         SCALE_SPLIT_ANGLE(-0.00379322096705),
         SCALE_SPLIT_ANGLE(-0.00380021613091),
         SCALE_SPLIT_ANGLE(-0.00381784490310),
         SCALE_SPLIT_ANGLE(-0.00383508345112),
         SCALE_SPLIT_ANGLE(-0.00386250019073),
         SCALE_SPLIT_ANGLE(-0.00390707701445),
         SCALE_SPLIT_ANGLE(-0.00393790006638)},
        {SCALE_SPLIT_ANGLE(-0.00213989731856),
         SCALE_SPLIT_ANGLE(-0.00214135507122),
         SCALE_SPLIT_ANGLE(-0.00214357534423),
         SCALE_SPLIT_ANGLE(-0.00214915839024),
         SCALE_SPLIT_ANGLE(-0.00215460080653),
         SCALE_SPLIT_ANGLE(-0.00216322229244),
         SCALE_SPLIT_ANGLE(-0.00217714929022),
         SCALE_SPLIT_ANGLE(-0.00218671257608)},
        {SCALE_SPLIT_ANGLE(-0.00000001210151),
         SCALE_SPLIT_ANGLE(-0.00000001210151),
         SCALE_SPLIT_ANGLE(-0.00000001210151),
         SCALE_SPLIT_ANGLE(-0.00000001210151),
         SCALE_SPLIT_ANGLE(-0.00000001210151),
         SCALE_SPLIT_ANGLE(-0.00000001210151),
         SCALE_SPLIT_ANGLE(-0.00000001210151),
         SCALE_SPLIT_ANGLE(-0.00000001210151)},
    },
    {
        {SCALE_SPLIT_ANGLE(-2.35619449615479),
         SCALE_SPLIT_ANGLE(-2.35619449615479),
         SCALE_SPLIT_ANGLE(-2.35619449615479),
         SCALE_SPLIT_ANGLE(-2.35619449615479),
         SCALE_SPLIT_ANGLE(-2.35619449615479),
         SCALE_SPLIT_ANGLE(-2.35619449615479),
         SCALE_SPLIT_ANGLE(-2.35619449615479),
         SCALE_SPLIT_ANGLE(-2.35619449615479)},
        {SCALE_SPLIT_ANGLE(-2.35216379165649),
         SCALE_SPLIT_ANGLE(-2.35216617584229),
         SCALE_SPLIT_ANGLE(-2.35216999053955),
         SCALE_SPLIT_ANGLE(-2.35217928886414),
         SCALE_SPLIT_ANGLE(-2.35218811035156),
         SCALE_SPLIT_ANGLE(-2.35220241546631),
         SCALE_SPLIT_ANGLE(-2.35222506523132),
         SCALE_SPLIT_ANGLE(-2.35224032402039)},
        {SCALE_SPLIT_ANGLE(-2.34895062446594),
         SCALE_SPLIT_ANGLE(-2.34895849227905),
         SCALE_SPLIT_ANGLE(-2.34897017478943),
         SCALE_SPLIT_ANGLE(-2.34899973869324),
         SCALE_SPLIT_ANGLE(-2.34902834892273),
         SCALE_SPLIT_ANGLE(-2.34907317161560),
         SCALE_SPLIT_ANGLE(-2.34914541244507),
         SCALE_SPLIT_ANGLE(-2.34919428825378)},
        {SCALE_SPLIT_ANGLE(-2.34306836128235),
         SCALE_SPLIT_ANGLE(-2.34309315681458),
         SCALE_SPLIT_ANGLE(-2.34313082695007),
         SCALE_SPLIT_ANGLE(-2.34322524070740),
         SCALE_SPLIT_ANGLE(-2.34331679344177),
         SCALE_SPLIT_ANGLE(-2.34346079826355),
         SCALE_SPLIT_ANGLE(-2.34369087219238),
         SCALE_SPLIT_ANGLE(-2.34384727478027)},
        {SCALE_SPLIT_ANGLE(-2.33205747604370),
         SCALE_SPLIT_ANGLE(-2.33213782310486),
         SCALE_SPLIT_ANGLE(-2.33226013183594),
         SCALE_SPLIT_ANGLE(-2.33256602287292),
         SCALE_SPLIT_ANGLE(-2.33286190032959),
         SCALE_SPLIT_ANGLE(-2.33332633972168),
         SCALE_SPLIT_ANGLE(-2.33406710624695),
         SCALE_SPLIT_ANGLE(-2.33456921577454)},
        {SCALE_SPLIT_ANGLE(-2.31062936782837),
         SCALE_SPLIT_ANGLE(-2.31089687347412),
         SCALE_SPLIT_ANGLE(-2.31130218505859),
         SCALE_SPLIT_ANGLE(-2.31231284141541),
         SCALE_SPLIT_ANGLE(-2.31328654289246),
         SCALE_SPLIT_ANGLE(-2.31480813026428),
         SCALE_SPLIT_ANGLE(-2.31722092628479),
         SCALE_SPLIT_ANGLE(-2.31885290145874)},
        {SCALE_SPLIT_ANGLE(-2.28808355331421),
         SCALE_SPLIT_ANGLE(-2.28864479064941),
         SCALE_SPLIT_ANGLE(-2.28949403762817),
         SCALE_SPLIT_ANGLE(-2.29160070419312),
         SCALE_SPLIT_ANGLE(-2.29361891746521),
         SCALE_SPLIT_ANGLE(-2.29675459861755),
         SCALE_SPLIT_ANGLE(-2.30169844627380),
         SCALE_SPLIT_ANGLE(-2.30503511428833)},
        {SCALE_SPLIT_ANGLE(-2.25191521644592),
         SCALE_SPLIT_ANGLE(-2.25312590599060),
         SCALE_SPLIT_ANGLE(-2.25494933128357),
         SCALE_SPLIT_ANGLE(-2.25943517684937),
         SCALE_SPLIT_ANGLE(-2.26368904113770),
         SCALE_SPLIT_ANGLE(-2.27023124694824),
         SCALE_SPLIT_ANGLE(-2.28044486045837),
         SCALE_SPLIT_ANGLE(-2.28732323646545)},
        {SCALE_SPLIT_ANGLE(-2.19093608856201),
         SCALE_SPLIT_ANGLE(-2.19366121292114),
         SCALE_SPLIT_ANGLE(-2.19773292541504),
         SCALE_SPLIT_ANGLE(-2.20759749412537),
         SCALE_SPLIT_ANGLE(-2.21677803993225),
         SCALE_SPLIT_ANGLE(-2.23064494132996),
         SCALE_SPLIT_ANGLE(-2.25193929672241),
         SCALE_SPLIT_ANGLE(-2.26625943183899)},
        {SCALE_SPLIT_ANGLE(-2.08102917671204),
         SCALE_SPLIT_ANGLE(-2.08757305145264),
         SCALE_SPLIT_ANGLE(-2.09720730781555),
         SCALE_SPLIT_ANGLE(-2.11991167068481),
         SCALE_SPLIT_ANGLE(-2.14035677909851),
         SCALE_SPLIT_ANGLE(-2.17029237747192),
         SCALE_SPLIT_ANGLE(-2.21503162384033),
         SCALE_SPLIT_ANGLE(-2.24518132209778)},
        {SCALE_SPLIT_ANGLE(-1.86738622188568),
         SCALE_SPLIT_ANGLE(-1.88426077365875),
         SCALE_SPLIT_ANGLE(-1.90853285789490),
         SCALE_SPLIT_ANGLE(-1.96333336830139),
         SCALE_SPLIT_ANGLE(-2.01024460792542),
         SCALE_SPLIT_ANGLE(-2.07577633857727),
         SCALE_SPLIT_ANGLE(-2.16986608505249),
         SCALE_SPLIT_ANGLE(-2.23406052589417)},
        {SCALE_SPLIT_ANGLE(-1.61812186241150),
         SCALE_SPLIT_ANGLE(-1.64943766593933),
         SCALE_SPLIT_ANGLE(-1.69389247894287),
         SCALE_SPLIT_ANGLE(-1.79176032543182),
         SCALE_SPLIT_ANGLE(-1.87292504310608),
         SCALE_SPLIT_ANGLE(-1.98277997970581),
         SCALE_SPLIT_ANGLE(-2.13605833053589),
         SCALE_SPLIT_ANGLE(-2.24282979965210)},
        {SCALE_SPLIT_ANGLE(-1.26556181907654),
         SCALE_SPLIT_ANGLE(-1.31512010097504),
         SCALE_SPLIT_ANGLE(-1.38608694076538),
         SCALE_SPLIT_ANGLE(-1.54419946670532),
         SCALE_SPLIT_ANGLE(-1.67621028423309),
         SCALE_SPLIT_ANGLE(-1.85417354106903),
         SCALE_SPLIT_ANGLE(-2.09956336021423),
         SCALE_SPLIT_ANGLE(-2.27729439735413)},
        {SCALE_SPLIT_ANGLE(-0.88984858989716),
         SCALE_SPLIT_ANGLE(-0.94673115015030),
         SCALE_SPLIT_ANGLE(-1.03102219104767),
         SCALE_SPLIT_ANGLE(-1.23219704627991),
         SCALE_SPLIT_ANGLE(-1.41468596458435),
         SCALE_SPLIT_ANGLE(-1.67807447910309),
         SCALE_SPLIT_ANGLE(-2.05749273300171),
         SCALE_SPLIT_ANGLE(-2.35138511657715)},
        {SCALE_SPLIT_ANGLE(-0.60630625486374),
         SCALE_SPLIT_ANGLE(-0.65551131963730),
         SCALE_SPLIT_ANGLE(-0.73032110929489),
         SCALE_SPLIT_ANGLE(-0.92225730419159),
         SCALE_SPLIT_ANGLE(-1.11866605281830),
         SCALE_SPLIT_ANGLE(-1.44806659221649),
         SCALE_SPLIT_ANGLE(-1.99872648715973),
         SCALE_SPLIT_ANGLE(-2.47302079200745)},
        {SCALE_SPLIT_ANGLE(-0.43393719196320),
         SCALE_SPLIT_ANGLE(-0.47099208831787),
         SCALE_SPLIT_ANGLE(-0.52780753374100),
         SCALE_SPLIT_ANGLE(-0.67895972728729),
         SCALE_SPLIT_ANGLE(-0.84712409973145),
         SCALE_SPLIT_ANGLE(-1.17809724807739),
         SCALE_SPLIT_ANGLE(-1.89703977108002),
         SCALE_SPLIT_ANGLE(-2.59155678749084)},
        {SCALE_SPLIT_ANGLE(-0.33522716164589),
         SCALE_SPLIT_ANGLE(-0.36133098602295),
         SCALE_SPLIT_ANGLE(-0.40159514546394),
         SCALE_SPLIT_ANGLE(-0.51039946079254),
         SCALE_SPLIT_ANGLE(-0.63590413331985),
         SCALE_SPLIT_ANGLE(-0.90812796354294),
         SCALE_SPLIT_ANGLE(-1.70793569087982),
         SCALE_SPLIT_ANGLE(-2.52852439880371)},
        {SCALE_SPLIT_ANGLE(-0.27478921413422),
         SCALE_SPLIT_ANGLE(-0.29251146316528),
         SCALE_SPLIT_ANGLE(-0.32007753849030),
         SCALE_SPLIT_ANGLE(-0.39531296491623),
         SCALE_SPLIT_ANGLE(-0.48291319608688),
         SCALE_SPLIT_ANGLE(-0.67812001705170),
         SCALE_SPLIT_ANGLE(-1.39007341861725),
         SCALE_SPLIT_ANGLE(-2.34402585029602)},
        {SCALE_SPLIT_ANGLE(-0.23185737431049),
         SCALE_SPLIT_ANGLE(-0.24370788037777),
         SCALE_SPLIT_ANGLE(-0.26227977871895),
         SCALE_SPLIT_ANGLE(-0.31327378749847),
         SCALE_SPLIT_ANGLE(-0.37241828441620),
         SCALE_SPLIT_ANGLE(-0.50202107429504),
         SCALE_SPLIT_ANGLE(-0.99085599184036),
         SCALE_SPLIT_ANGLE(-1.96553480625153)},
        {SCALE_SPLIT_ANGLE(-0.19698302447796),
         SCALE_SPLIT_ANGLE(-0.20488265156746),
         SCALE_SPLIT_ANGLE(-0.21731522679329),
         SCALE_SPLIT_ANGLE(-0.25148209929466),
         SCALE_SPLIT_ANGLE(-0.29065513610840),
         SCALE_SPLIT_ANGLE(-0.37341463565826),
         SCALE_SPLIT_ANGLE(-0.65295964479446),
         SCALE_SPLIT_ANGLE(-1.28865838050842)},
        {SCALE_SPLIT_ANGLE(-0.16667704284191),
         SCALE_SPLIT_ANGLE(-0.17194209992886),
         SCALE_SPLIT_ANGLE(-0.18023575842381),
         SCALE_SPLIT_ANGLE(-0.20293866097927),
         SCALE_SPLIT_ANGLE(-0.22855132818222),
         SCALE_SPLIT_ANGLE(-0.28041815757751),
         SCALE_SPLIT_ANGLE(-0.43142417073250),
         SCALE_SPLIT_ANGLE(-0.70030152797699)},
        {SCALE_SPLIT_ANGLE(-0.12773875892162),
         SCALE_SPLIT_ANGLE(-0.13059368729591),
         SCALE_SPLIT_ANGLE(-0.13507817685604),
         SCALE_SPLIT_ANGLE(-0.14721076190472),
         SCALE_SPLIT_ANGLE(-0.16052411496639),
         SCALE_SPLIT_ANGLE(-0.18590225279331),
         SCALE_SPLIT_ANGLE(-0.24703903496265),
         SCALE_SPLIT_ANGLE(-0.32153329253197)},
        {SCALE_SPLIT_ANGLE(-0.09603262692690),
         SCALE_SPLIT_ANGLE(-0.09756571799517),
         SCALE_SPLIT_ANGLE(-0.09996144473553),
         SCALE_SPLIT_ANGLE(-0.10635072737932),
         SCALE_SPLIT_ANGLE(-0.11317525804043),
         SCALE_SPLIT_ANGLE(-0.12554959952831),
         SCALE_SPLIT_ANGLE(-0.15168417990208),
         SCALE_SPLIT_ANGLE(-0.17713625729084)},
        {SCALE_SPLIT_ANGLE(-0.07104730606079),
         SCALE_SPLIT_ANGLE(-0.07186015695333),
         SCALE_SPLIT_ANGLE(-0.07312334328890),
         SCALE_SPLIT_ANGLE(-0.07644615322351),
         SCALE_SPLIT_ANGLE(-0.07991369068623),
         SCALE_SPLIT_ANGLE(-0.08596337586641),
         SCALE_SPLIT_ANGLE(-0.09766443073750),
         SCALE_SPLIT_ANGLE(-0.10767272859812)},
        {SCALE_SPLIT_ANGLE(-0.05192205309868),
         SCALE_SPLIT_ANGLE(-0.05234766378999),
         SCALE_SPLIT_ANGLE(-0.05300575867295),
         SCALE_SPLIT_ANGLE(-0.05471667274833),
         SCALE_SPLIT_ANGLE(-0.05646898224950),
         SCALE_SPLIT_ANGLE(-0.05943990871310),
         SCALE_SPLIT_ANGLE(-0.06485753506422),
         SCALE_SPLIT_ANGLE(-0.06914159655571)},
        {SCALE_SPLIT_ANGLE(-0.03760398924351),
         SCALE_SPLIT_ANGLE(-0.03782445192337),
         SCALE_SPLIT_ANGLE(-0.03816392645240),
         SCALE_SPLIT_ANGLE(-0.03903824090958),
         SCALE_SPLIT_ANGLE(-0.03992090001702),
         SCALE_SPLIT_ANGLE(-0.04138650000095),
         SCALE_SPLIT_ANGLE(-0.04395476356149),
         SCALE_SPLIT_ANGLE(-0.04588782414794)},
        {SCALE_SPLIT_ANGLE(-0.02166714519262),
         SCALE_SPLIT_ANGLE(-0.02173947915435),
         SCALE_SPLIT_ANGLE(-0.02185030654073),
         SCALE_SPLIT_ANGLE(-0.02213260345161),
         SCALE_SPLIT_ANGLE(-0.02241297997534),
         SCALE_SPLIT_ANGLE(-0.02286812663078),
         SCALE_SPLIT_ANGLE(-0.02363408729434),
         SCALE_SPLIT_ANGLE(-0.02418405003846)},
        {SCALE_SPLIT_ANGLE(-0.01235313713551),
         SCALE_SPLIT_ANGLE(-0.01237650867552),
         SCALE_SPLIT_ANGLE(-0.01241220720112),
         SCALE_SPLIT_ANGLE(-0.01250253617764),
         SCALE_SPLIT_ANGLE(-0.01259138714522),
         SCALE_SPLIT_ANGLE(-0.01273377239704),
         SCALE_SPLIT_ANGLE(-0.01296819653362),
         SCALE_SPLIT_ANGLE(-0.01313247904181)},
        {SCALE_SPLIT_ANGLE(-0.00700078438967),
         SCALE_SPLIT_ANGLE(-0.00700826710090),
         SCALE_SPLIT_ANGLE(-0.00701967626810),
         SCALE_SPLIT_ANGLE(-0.00704843178391),
         SCALE_SPLIT_ANGLE(-0.00707655726001),
         SCALE_SPLIT_ANGLE(-0.00712130265310),
         SCALE_SPLIT_ANGLE(-0.00719408923760),
         SCALE_SPLIT_ANGLE(-0.00724443932995)},
        {SCALE_SPLIT_ANGLE(-0.00395406875759),
         SCALE_SPLIT_ANGLE(-0.00395645154640),
         SCALE_SPLIT_ANGLE(-0.00396008091047),
         SCALE_SPLIT_ANGLE(-0.00396920833737),
         SCALE_SPLIT_ANGLE(-0.00397810759023),
         SCALE_SPLIT_ANGLE(-0.00399220641702),
         SCALE_SPLIT_ANGLE(-0.00401498842984),
         SCALE_SPLIT_ANGLE(-0.00403063651174)},
        {SCALE_SPLIT_ANGLE(-0.00000002236068),
         SCALE_SPLIT_ANGLE(-0.00000002236068),
         SCALE_SPLIT_ANGLE(-0.00000002236068),
         SCALE_SPLIT_ANGLE(-0.00000002236068),
         SCALE_SPLIT_ANGLE(-0.00000002236068),
         SCALE_SPLIT_ANGLE(-0.00000002236068),
         SCALE_SPLIT_ANGLE(-0.00000002236068),
         SCALE_SPLIT_ANGLE(-0.00000002236068)},
    },
    {
        {SCALE_SPLIT_ANGLE(-1.96349549293518),
         SCALE_SPLIT_ANGLE(-1.96349549293518),
         SCALE_SPLIT_ANGLE(-1.96349549293518),
         SCALE_SPLIT_ANGLE(-1.96349549293518),
         SCALE_SPLIT_ANGLE(-1.96349549293518),
         SCALE_SPLIT_ANGLE(-1.96349549293518),
         SCALE_SPLIT_ANGLE(-1.96349549293518),
         SCALE_SPLIT_ANGLE(-1.96349549293518)},
        {SCALE_SPLIT_ANGLE(-1.95824849605560),
         SCALE_SPLIT_ANGLE(-1.95825111865997),
         SCALE_SPLIT_ANGLE(-1.95825493335724),
         SCALE_SPLIT_ANGLE(-1.95826470851898),
         SCALE_SPLIT_ANGLE(-1.95827412605286),
         SCALE_SPLIT_ANGLE(-1.95828902721405),
         SCALE_SPLIT_ANGLE(-1.95831298828125),
         SCALE_SPLIT_ANGLE(-1.95832931995392)},
        {SCALE_SPLIT_ANGLE(-1.95409321784973),
         SCALE_SPLIT_ANGLE(-1.95410120487213),
         SCALE_SPLIT_ANGLE(-1.95411348342896),
         SCALE_SPLIT_ANGLE(-1.95414435863495),
         SCALE_SPLIT_ANGLE(-1.95417428016663),
         SCALE_SPLIT_ANGLE(-1.95422148704529),
         SCALE_SPLIT_ANGLE(-1.95429742336273),
         SCALE_SPLIT_ANGLE(-1.95434927940369)},
        {SCALE_SPLIT_ANGLE(-1.94654786586761),
         SCALE_SPLIT_ANGLE(-1.94657349586487),
         SCALE_SPLIT_ANGLE(-1.94661235809326),
         SCALE_SPLIT_ANGLE(-1.94671010971069),
         SCALE_SPLIT_ANGLE(-1.94680511951447),
         SCALE_SPLIT_ANGLE(-1.94695532321930),
         SCALE_SPLIT_ANGLE(-1.94719707965851),
         SCALE_SPLIT_ANGLE(-1.94736242294312)},
        {SCALE_SPLIT_ANGLE(-1.93263387680054),
         SCALE_SPLIT_ANGLE(-1.93271505832672),
         SCALE_SPLIT_ANGLE(-1.93283867835999),
         SCALE_SPLIT_ANGLE(-1.93314921855927),
         SCALE_SPLIT_ANGLE(-1.93345177173615),
         SCALE_SPLIT_ANGLE(-1.93393063545227),
         SCALE_SPLIT_ANGLE(-1.93470406532288),
         SCALE_SPLIT_ANGLE(-1.93523526191711)},
        {SCALE_SPLIT_ANGLE(-1.90630447864532),
         SCALE_SPLIT_ANGLE(-1.90656316280365),
         SCALE_SPLIT_ANGLE(-1.90695703029633),
         SCALE_SPLIT_ANGLE(-1.90794789791107),
         SCALE_SPLIT_ANGLE(-1.90891468524933),
         SCALE_SPLIT_ANGLE(-1.91044914722443),
         SCALE_SPLIT_ANGLE(-1.91294133663177),
         SCALE_SPLIT_ANGLE(-1.91466677188873)},
        {SCALE_SPLIT_ANGLE(-1.87960767745972),
         SCALE_SPLIT_ANGLE(-1.88012754917145),
         SCALE_SPLIT_ANGLE(-1.88091945648193),
         SCALE_SPLIT_ANGLE(-1.88291203975677),
         SCALE_SPLIT_ANGLE(-1.88485789299011),
         SCALE_SPLIT_ANGLE(-1.88795256614685),
         SCALE_SPLIT_ANGLE(-1.89300417900085),
         SCALE_SPLIT_ANGLE(-1.89653015136719)},
        {SCALE_SPLIT_ANGLE(-1.83877408504486),
         SCALE_SPLIT_ANGLE(-1.83982253074646),
         SCALE_SPLIT_ANGLE(-1.84141874313354),
         SCALE_SPLIT_ANGLE(-1.84543371200562),
         SCALE_SPLIT_ANGLE(-1.84935557842255),
         SCALE_SPLIT_ANGLE(-1.85560452938080),
         SCALE_SPLIT_ANGLE(-1.86587750911713),
         SCALE_SPLIT_ANGLE(-1.87314093112946)},
        {SCALE_SPLIT_ANGLE(-1.77493441104889),
         SCALE_SPLIT_ANGLE(-1.77705287933350),
         SCALE_SPLIT_ANGLE(-1.78027486801147),
         SCALE_SPLIT_ANGLE(-1.78836560249329),
         SCALE_SPLIT_ANGLE(-1.79626119136810),
         SCALE_SPLIT_ANGLE(-1.80886065959930),
         SCALE_SPLIT_ANGLE(-1.82978057861328),
         SCALE_SPLIT_ANGLE(-1.84489572048187)},
        {SCALE_SPLIT_ANGLE(-1.67321836948395),
         SCALE_SPLIT_ANGLE(-1.67747676372528),
         SCALE_SPLIT_ANGLE(-1.68394041061401),
         SCALE_SPLIT_ANGLE(-1.70011758804321),
         SCALE_SPLIT_ANGLE(-1.71586525440216),
         SCALE_SPLIT_ANGLE(-1.74102890491486),
         SCALE_SPLIT_ANGLE(-1.78345453739166),
         SCALE_SPLIT_ANGLE(-1.81531310081482)},
        {SCALE_SPLIT_ANGLE(-1.51132130622864),
         SCALE_SPLIT_ANGLE(-1.51959407329559),
         SCALE_SPLIT_ANGLE(-1.53212583065033),
         SCALE_SPLIT_ANGLE(-1.56339812278748),
         SCALE_SPLIT_ANGLE(-1.59380078315735),
         SCALE_SPLIT_ANGLE(-1.64260387420654),
         SCALE_SPLIT_ANGLE(-1.72719144821167),
         SCALE_SPLIT_ANGLE(-1.79549288749695)},
        {SCALE_SPLIT_ANGLE(-1.35904073715210),
         SCALE_SPLIT_ANGLE(-1.37121629714966),
         SCALE_SPLIT_ANGLE(-1.38967263698578),
         SCALE_SPLIT_ANGLE(-1.43583405017853),
         SCALE_SPLIT_ANGLE(-1.48093712329865),
         SCALE_SPLIT_ANGLE(-1.55410349369049),
         SCALE_SPLIT_ANGLE(-1.68521809577942),
         SCALE_SPLIT_ANGLE(-1.80024909973145)},
        {SCALE_SPLIT_ANGLE(-1.17258918285370),
         SCALE_SPLIT_ANGLE(-1.18893885612488),
         SCALE_SPLIT_ANGLE(-1.21383893489838),
         SCALE_SPLIT_ANGLE(-1.27678334712982),
         SCALE_SPLIT_ANGLE(-1.33930444717407),
         SCALE_SPLIT_ANGLE(-1.44322550296783),
         SCALE_SPLIT_ANGLE(-1.64006841182709),
         SCALE_SPLIT_ANGLE(-1.83627629280090)},
        {SCALE_SPLIT_ANGLE(-0.96933782100677),
         SCALE_SPLIT_ANGLE(-0.98854482173920),
         SCALE_SPLIT_ANGLE(-1.01807177066803),
         SCALE_SPLIT_ANGLE(-1.09429979324341),
         SCALE_SPLIT_ANGLE(-1.17245376110077),
         SCALE_SPLIT_ANGLE(-1.30826890468597),
         SCALE_SPLIT_ANGLE(-1.58911192417145),
         SCALE_SPLIT_ANGLE(-1.92719459533691)},
        {SCALE_SPLIT_ANGLE(-0.77729856967926),
         SCALE_SPLIT_ANGLE(-0.79675692319870),
         SCALE_SPLIT_ANGLE(-0.82701623439789),
         SCALE_SPLIT_ANGLE(-0.90724974870682),
         SCALE_SPLIT_ANGLE(-0.99302661418915),
         SCALE_SPLIT_ANGLE(-1.15164005756378),
         SCALE_SPLIT_ANGLE(-1.52265238761902),
         SCALE_SPLIT_ANGLE(-2.09869647026062)},
        {SCALE_SPLIT_ANGLE(-0.61765122413635),
         SCALE_SPLIT_ANGLE(-0.63503879308701),
         SCALE_SPLIT_ANGLE(-0.66235071420670),
         SCALE_SPLIT_ANGLE(-0.73653644323349),
         SCALE_SPLIT_ANGLE(-0.81904625892639),
         SCALE_SPLIT_ANGLE(-0.98174780607224),
         SCALE_SPLIT_ANGLE(-1.42110574245453),
         SCALE_SPLIT_ANGLE(-2.28386068344116)},
        {SCALE_SPLIT_ANGLE(-0.49486327171326),
         SCALE_SPLIT_ANGLE(-0.50909572839737),
         SCALE_SPLIT_ANGLE(-0.53160977363586),
         SCALE_SPLIT_ANGLE(-0.59379214048386),
         SCALE_SPLIT_ANGLE(-0.66487479209900),
         SCALE_SPLIT_ANGLE(-0.81185555458069),
         SCALE_SPLIT_ANGLE(-1.26233398914337),
         SCALE_SPLIT_ANGLE(-2.16925764083862)},
        {SCALE_SPLIT_ANGLE(-0.40230554342270),
         SCALE_SPLIT_ANGLE(-0.41332268714905),
         SCALE_SPLIT_ANGLE(-0.43082219362259),
         SCALE_SPLIT_ANGLE(-0.47957947850227),
         SCALE_SPLIT_ANGLE(-0.53603595495224),
         SCALE_SPLIT_ANGLE(-0.65522664785385),
         SCALE_SPLIT_ANGLE(-1.04503870010376),
         SCALE_SPLIT_ANGLE(-1.87041819095612)},
        {SCALE_SPLIT_ANGLE(-0.33104604482651),
         SCALE_SPLIT_ANGLE(-0.33927723765373),
         SCALE_SPLIT_ANGLE(-0.35237133502960),
         SCALE_SPLIT_ANGLE(-0.38892474770546),
         SCALE_SPLIT_ANGLE(-0.43126162886620),
         SCALE_SPLIT_ANGLE(-0.52027010917664),
         SCALE_SPLIT_ANGLE(-0.80654197931290),
         SCALE_SPLIT_ANGLE(-1.41960346698761)},
        {SCALE_SPLIT_ANGLE(-0.27415531873703),
         SCALE_SPLIT_ANGLE(-0.28015667200089),
         SCALE_SPLIT_ANGLE(-0.28969678282738),
         SCALE_SPLIT_ANGLE(-0.31623727083206),
         SCALE_SPLIT_ANGLE(-0.34670370817184),
         SCALE_SPLIT_ANGLE(-0.40939208865166),
         SCALE_SPLIT_ANGLE(-0.59604328870773),
         SCALE_SPLIT_ANGLE(-0.94309812784195)},
        {SCALE_SPLIT_ANGLE(-0.22730343043804),
         SCALE_SPLIT_ANGLE(-0.23159568011761),
         SCALE_SPLIT_ANGLE(-0.23840220272541),
         SCALE_SPLIT_ANGLE(-0.25720024108887),
         SCALE_SPLIT_ANGLE(-0.27846288681030),
         SCALE_SPLIT_ANGLE(-0.32089167833328),
         SCALE_SPLIT_ANGLE(-0.43515858054161),
         SCALE_SPLIT_ANGLE(-0.60622000694275)},
        {SCALE_SPLIT_ANGLE(-0.17074464261532),
         SCALE_SPLIT_ANGLE(-0.17326098680496),
         SCALE_SPLIT_ANGLE(-0.17722851037979),
         SCALE_SPLIT_ANGLE(-0.18802368640900),
         SCALE_SPLIT_ANGLE(-0.19990929961205),
         SCALE_SPLIT_ANGLE(-0.22246663272381),
         SCALE_SPLIT_ANGLE(-0.27514943480492),
         SCALE_SPLIT_ANGLE(-0.33505329489708)},
        {SCALE_SPLIT_ANGLE(-0.12695816159248),
         SCALE_SPLIT_ANGLE(-0.12838459014893),
         SCALE_SPLIT_ANGLE(-0.13061878085136),
         SCALE_SPLIT_ANGLE(-0.13660037517548),
         SCALE_SPLIT_ANGLE(-0.14301039278507),
         SCALE_SPLIT_ANGLE(-0.15463486313820),
         SCALE_SPLIT_ANGLE(-0.17893928289413),
         SCALE_SPLIT_ANGLE(-0.20203559100628)},
        {SCALE_SPLIT_ANGLE(-0.09338590502739),
         SCALE_SPLIT_ANGLE(-0.09417138248682),
         SCALE_SPLIT_ANGLE(-0.09539389610291),
         SCALE_SPLIT_ANGLE(-0.09861853718758),
         SCALE_SPLIT_ANGLE(-0.10199318081141),
         SCALE_SPLIT_ANGLE(-0.10789106041193),
         SCALE_SPLIT_ANGLE(-0.11927829682827),
         SCALE_SPLIT_ANGLE(-0.12894384562969)},
        {SCALE_SPLIT_ANGLE(-0.06804534792900),
         SCALE_SPLIT_ANGLE(-0.06846774369478),
         SCALE_SPLIT_ANGLE(-0.06912153959274),
         SCALE_SPLIT_ANGLE(-0.07082460820675),
         SCALE_SPLIT_ANGLE(-0.07257289439440),
         SCALE_SPLIT_ANGLE(-0.07554303109646),
         SCALE_SPLIT_ANGLE(-0.08096560835838),
         SCALE_SPLIT_ANGLE(-0.08524779230356)},
        {SCALE_SPLIT_ANGLE(-0.04920703917742),
         SCALE_SPLIT_ANGLE(-0.04942998290062),
         SCALE_SPLIT_ANGLE(-0.04977353662252),
         SCALE_SPLIT_ANGLE(-0.05065960064530),
         SCALE_SPLIT_ANGLE(-0.05155571177602),
         SCALE_SPLIT_ANGLE(-0.05304637178779),
         SCALE_SPLIT_ANGLE(-0.05566369369626),
         SCALE_SPLIT_ANGLE(-0.05763531103730)},
        {SCALE_SPLIT_ANGLE(-0.02832321636379),
         SCALE_SPLIT_ANGLE(-0.02839783579111),
         SCALE_SPLIT_ANGLE(-0.02851220592856),
         SCALE_SPLIT_ANGLE(-0.02880378812551),
         SCALE_SPLIT_ANGLE(-0.02909369207919),
         SCALE_SPLIT_ANGLE(-0.02956490218639),
         SCALE_SPLIT_ANGLE(-0.03035926632583),
         SCALE_SPLIT_ANGLE(-0.03093044646084)},
        {SCALE_SPLIT_ANGLE(-0.01614263094962),
         SCALE_SPLIT_ANGLE(-0.01616701111197),
         SCALE_SPLIT_ANGLE(-0.01620426028967),
         SCALE_SPLIT_ANGLE(-0.01629855856299),
         SCALE_SPLIT_ANGLE(-0.01639137044549),
         SCALE_SPLIT_ANGLE(-0.01654022000730),
         SCALE_SPLIT_ANGLE(-0.01678557321429),
         SCALE_SPLIT_ANGLE(-0.01695770025253)},
        {SCALE_SPLIT_ANGLE(-0.00914741121233),
         SCALE_SPLIT_ANGLE(-0.00915526598692),
         SCALE_SPLIT_ANGLE(-0.00916724465787),
         SCALE_SPLIT_ANGLE(-0.00919744279236),
         SCALE_SPLIT_ANGLE(-0.00922699086368),
         SCALE_SPLIT_ANGLE(-0.00927401985973),
         SCALE_SPLIT_ANGLE(-0.00935057457536),
         SCALE_SPLIT_ANGLE(-0.00940357148647)},
        {SCALE_SPLIT_ANGLE(-0.00516631966457),
         SCALE_SPLIT_ANGLE(-0.00516883004457),
         SCALE_SPLIT_ANGLE(-0.00517265358940),
         SCALE_SPLIT_ANGLE(-0.00518227042630),
         SCALE_SPLIT_ANGLE(-0.00519164977595),
         SCALE_SPLIT_ANGLE(-0.00520651368424),
         SCALE_SPLIT_ANGLE(-0.00523054040968),
         SCALE_SPLIT_ANGLE(-0.00524705089629)},
        {SCALE_SPLIT_ANGLE(-0.00000002921564),
         SCALE_SPLIT_ANGLE(-0.00000002921564),
         SCALE_SPLIT_ANGLE(-0.00000002921564),
         SCALE_SPLIT_ANGLE(-0.00000002921564),
         SCALE_SPLIT_ANGLE(-0.00000002921564),
         SCALE_SPLIT_ANGLE(-0.00000002921564),
         SCALE_SPLIT_ANGLE(-0.00000002921564),
         SCALE_SPLIT_ANGLE(-0.00000002921564)},
    },
    {
        {SCALE_SPLIT_ANGLE(-1.57079625129700),
         SCALE_SPLIT_ANGLE(-1.57079625129700),
         SCALE_SPLIT_ANGLE(-1.57079625129700),
         SCALE_SPLIT_ANGLE(-1.57079625129700),
         SCALE_SPLIT_ANGLE(-1.57079625129700),
         SCALE_SPLIT_ANGLE(-1.57079625129700),
         SCALE_SPLIT_ANGLE(-1.57079625129700),
         SCALE_SPLIT_ANGLE(-1.57079625129700)},
        {SCALE_SPLIT_ANGLE(-1.56514143943787),
         SCALE_SPLIT_ANGLE(-1.56514346599579),
         SCALE_SPLIT_ANGLE(-1.56514644622803),
         SCALE_SPLIT_ANGLE(-1.56515395641327),
         SCALE_SPLIT_ANGLE(-1.56516134738922),
         SCALE_SPLIT_ANGLE(-1.56517291069031),
         SCALE_SPLIT_ANGLE(-1.56519162654877),
         SCALE_SPLIT_ANGLE(-1.56520438194275)},
        {SCALE_SPLIT_ANGLE(-1.56069743633270),
         SCALE_SPLIT_ANGLE(-1.56070363521576),
         SCALE_SPLIT_ANGLE(-1.56071305274963),
         SCALE_SPLIT_ANGLE(-1.56073689460754),
         SCALE_SPLIT_ANGLE(-1.56076002120972),
         SCALE_SPLIT_ANGLE(-1.56079661846161),
         SCALE_SPLIT_ANGLE(-1.56085574626923),
         SCALE_SPLIT_ANGLE(-1.56089639663696)},
        {SCALE_SPLIT_ANGLE(-1.55270349979401),
         SCALE_SPLIT_ANGLE(-1.55272293090820),
         SCALE_SPLIT_ANGLE(-1.55275249481201),
         SCALE_SPLIT_ANGLE(-1.55282700061798),
         SCALE_SPLIT_ANGLE(-1.55289971828461),
         SCALE_SPLIT_ANGLE(-1.55301535129547),
         SCALE_SPLIT_ANGLE(-1.55320298671722),
         SCALE_SPLIT_ANGLE(-1.55333244800568)},
        {SCALE_SPLIT_ANGLE(-1.53820896148682),
         SCALE_SPLIT_ANGLE(-1.53826904296875),
         SCALE_SPLIT_ANGLE(-1.53836083412170),
         SCALE_SPLIT_ANGLE(-1.53859269618988),
         SCALE_SPLIT_ANGLE(-1.53882038593292),
         SCALE_SPLIT_ANGLE(-1.53918409347534),
         SCALE_SPLIT_ANGLE(-1.53978025913239),
         SCALE_SPLIT_ANGLE(-1.54019618034363)},
        {SCALE_SPLIT_ANGLE(-1.51160359382629),
         SCALE_SPLIT_ANGLE(-1.51178681850433),
         SCALE_SPLIT_ANGLE(-1.51206707954407),
         SCALE_SPLIT_ANGLE(-1.51277911663055),
         SCALE_SPLIT_ANGLE(-1.51348364353180),
         SCALE_SPLIT_ANGLE(-1.51462137699127),
         SCALE_SPLIT_ANGLE(-1.51652014255524),
         SCALE_SPLIT_ANGLE(-1.51787149906158)},
        {SCALE_SPLIT_ANGLE(-1.48564028739929),
         SCALE_SPLIT_ANGLE(-1.48599267005920),
         SCALE_SPLIT_ANGLE(-1.48653328418732),
         SCALE_SPLIT_ANGLE(-1.48791313171387),
         SCALE_SPLIT_ANGLE(-1.48928785324097),
         SCALE_SPLIT_ANGLE(-1.49152994155884),
         SCALE_SPLIT_ANGLE(-1.49533629417419),
         SCALE_SPLIT_ANGLE(-1.49810016155243)},
        {SCALE_SPLIT_ANGLE(-1.44770431518555),
         SCALE_SPLIT_ANGLE(-1.44837117195129),
         SCALE_SPLIT_ANGLE(-1.44939672946930),
         SCALE_SPLIT_ANGLE(-1.45203149318695),
         SCALE_SPLIT_ANGLE(-1.45468175411224),
         SCALE_SPLIT_ANGLE(-1.45906174182892),
         SCALE_SPLIT_ANGLE(-1.46668362617493),
         SCALE_SPLIT_ANGLE(-1.47238755226135)},
        {SCALE_SPLIT_ANGLE(-1.39214622974396),
         SCALE_SPLIT_ANGLE(-1.39337480068207),
         SCALE_SPLIT_ANGLE(-1.39527142047882),
         SCALE_SPLIT_ANGLE(-1.40018463134766),
         SCALE_SPLIT_ANGLE(-1.40518975257874),
         SCALE_SPLIT_ANGLE(-1.41361439228058),
         SCALE_SPLIT_ANGLE(-1.42880713939667),
         SCALE_SPLIT_ANGLE(-1.44072234630585)},
        {SCALE_SPLIT_ANGLE(-1.31133687496185),
         SCALE_SPLIT_ANGLE(-1.31350564956665),
         SCALE_SPLIT_ANGLE(-1.31686961650848),
         SCALE_SPLIT_ANGLE(-1.32567894458771),
         SCALE_SPLIT_ANGLE(-1.33480489253998),
         SCALE_SPLIT_ANGLE(-1.35055565834045),
         SCALE_SPLIT_ANGLE(-1.38048458099365),
         SCALE_SPLIT_ANGLE(-1.40579903125763)},
        {SCALE_SPLIT_ANGLE(-1.19695889949799),
         SCALE_SPLIT_ANGLE(-1.20052516460419),
         SCALE_SPLIT_ANGLE(-1.20609176158905),
         SCALE_SPLIT_ANGLE(-1.22087824344635),
         SCALE_SPLIT_ANGLE(-1.23654139041901),
         SCALE_SPLIT_ANGLE(-1.26451897621155),
         SCALE_SPLIT_ANGLE(-1.32194638252258),
         SCALE_SPLIT_ANGLE(-1.37709844112396)},
        {SCALE_SPLIT_ANGLE(-1.09969496726990),
         SCALE_SPLIT_ANGLE(-1.10437369346619),
         SCALE_SPLIT_ANGLE(-1.11171460151672),
         SCALE_SPLIT_ANGLE(-1.13144767284393),
         SCALE_SPLIT_ANGLE(-1.15274536609650),
         SCALE_SPLIT_ANGLE(-1.19192278385162),
         SCALE_SPLIT_ANGLE(-1.27820122241974),
         SCALE_SPLIT_ANGLE(-1.37287354469299)},
        {SCALE_SPLIT_ANGLE(-0.98739635944366),
         SCALE_SPLIT_ANGLE(-0.99314498901367),
         SCALE_SPLIT_ANGLE(-1.00221848487854),
         SCALE_SPLIT_ANGLE(-1.02694928646088),
         SCALE_SPLIT_ANGLE(-1.05423069000244),
         SCALE_SPLIT_ANGLE(-1.10619938373566),
         SCALE_SPLIT_ANGLE(-1.23116791248322),
         SCALE_SPLIT_ANGLE(-1.39771783351898)},
        {SCALE_SPLIT_ANGLE(-0.86566168069839),
         SCALE_SPLIT_ANGLE(-0.87219274044037),
         SCALE_SPLIT_ANGLE(-0.88256770372391),
         SCALE_SPLIT_ANGLE(-0.91127198934555),
         SCALE_SPLIT_ANGLE(-0.94370102882385),
         SCALE_SPLIT_ANGLE(-1.00792455673218),
         SCALE_SPLIT_ANGLE(-1.17914199829102),
         SCALE_SPLIT_ANGLE(-1.48121190071106)},
        {SCALE_SPLIT_ANGLE(-0.74293029308319),
         SCALE_SPLIT_ANGLE(-0.74975663423538),
         SCALE_SPLIT_ANGLE(-0.76066619157791),
         SCALE_SPLIT_ANGLE(-0.79128366708755),
         SCALE_SPLIT_ANGLE(-0.82667875289917),
         SCALE_SPLIT_ANGLE(-0.89952337741852),
         SCALE_SPLIT_ANGLE(-1.11571288108826),
         SCALE_SPLIT_ANGLE(-1.67431199550629)},
        {SCALE_SPLIT_ANGLE(-0.62761706113815),
         SCALE_SPLIT_ANGLE(-0.63421267271042),
         SCALE_SPLIT_ANGLE(-0.64480352401733),
         SCALE_SPLIT_ANGLE(-0.67486244440079),
         SCALE_SPLIT_ANGLE(-0.71025305986404),
         SCALE_SPLIT_ANGLE(-0.78539818525314),
         SCALE_SPLIT_ANGLE(-1.02937340736389),
         SCALE_SPLIT_ANGLE(-1.92301476001740)},
        {SCALE_SPLIT_ANGLE(-0.52522456645966),
         SCALE_SPLIT_ANGLE(-0.53118568658829),
         SCALE_SPLIT_ANGLE(-0.54078328609467),
         SCALE_SPLIT_ANGLE(-0.56819742918015),
         SCALE_SPLIT_ANGLE(-0.60080897808075),
         SCALE_SPLIT_ANGLE(-0.67127293348312),
         SCALE_SPLIT_ANGLE(-0.91114157438278),
         SCALE_SPLIT_ANGLE(-1.73398244380951)},
        {SCALE_SPLIT_ANGLE(-0.43751952052116),
         SCALE_SPLIT_ANGLE(-0.44262495636940),
         SCALE_SPLIT_ANGLE(-0.45084837079048),
         SCALE_SPLIT_ANGLE(-0.47435706853867),
         SCALE_SPLIT_ANGLE(-0.50235128402710),
         SCALE_SPLIT_ANGLE(-0.56287175416946),
         SCALE_SPLIT_ANGLE(-0.76705116033554),
         SCALE_SPLIT_ANGLE(-1.34888231754303)},
        {SCALE_SPLIT_ANGLE(-0.36364197731018),
         SCALE_SPLIT_ANGLE(-0.36782836914063),
         SCALE_SPLIT_ANGLE(-0.37456014752388),
         SCALE_SPLIT_ANGLE(-0.39372298121452),
         SCALE_SPLIT_ANGLE(-0.41636970639229),
         SCALE_SPLIT_ANGLE(-0.46459695696831),
         SCALE_SPLIT_ANGLE(-0.61803078651428),
         SCALE_SPLIT_ANGLE(-0.96275907754898)},
        {SCALE_SPLIT_ANGLE(-0.30166232585907),
         SCALE_SPLIT_ANGLE(-0.30497136712074),
         SCALE_SPLIT_ANGLE(-0.31027451157570),
         SCALE_SPLIT_ANGLE(-0.32524627447128),
         SCALE_SPLIT_ANGLE(-0.34269106388092),
         SCALE_SPLIT_ANGLE(-0.37887355685234),
         SCALE_SPLIT_ANGLE(-0.48432540893555),
         SCALE_SPLIT_ANGLE(-0.66878592967987)},
        {SCALE_SPLIT_ANGLE(-0.24960109591484),
         SCALE_SPLIT_ANGLE(-0.25213342905045),
         SCALE_SPLIT_ANGLE(-0.25617361068726),
         SCALE_SPLIT_ANGLE(-0.26745575666428),
         SCALE_SPLIT_ANGLE(-0.28036275506020),
         SCALE_SPLIT_ANGLE(-0.30627736449242),
         SCALE_SPLIT_ANGLE(-0.37490698695183),
         SCALE_SPLIT_ANGLE(-0.47145301103592)},
        {SCALE_SPLIT_ANGLE(-0.18661488592625),
         SCALE_SPLIT_ANGLE(-0.18822199106216),
         SCALE_SPLIT_ANGLE(-0.19076594710350),
         SCALE_SPLIT_ANGLE(-0.19773861765862),
         SCALE_SPLIT_ANGLE(-0.20547652244568),
         SCALE_SPLIT_ANGLE(-0.22024063766003),
         SCALE_SPLIT_ANGLE(-0.25452125072479),
         SCALE_SPLIT_ANGLE(-0.29236793518066)},
        {SCALE_SPLIT_ANGLE(-0.13821771740913),
         SCALE_SPLIT_ANGLE(-0.13918289542198),
         SCALE_SPLIT_ANGLE(-0.14069861173630),
         SCALE_SPLIT_ANGLE(-0.14477686583996),
         SCALE_SPLIT_ANGLE(-0.14917232096195),
         SCALE_SPLIT_ANGLE(-0.15718193352222),
         SCALE_SPLIT_ANGLE(-0.17394064366817),
         SCALE_SPLIT_ANGLE(-0.18971265852451)},
        {SCALE_SPLIT_ANGLE(-0.10140904784203),
         SCALE_SPLIT_ANGLE(-0.10196315497160),
         SCALE_SPLIT_ANGLE(-0.10282710194588),
         SCALE_SPLIT_ANGLE(-0.10511382669210),
         SCALE_SPLIT_ANGLE(-0.10751703381538),
         SCALE_SPLIT_ANGLE(-0.11173453181982),
         SCALE_SPLIT_ANGLE(-0.11990433931351),
         SCALE_SPLIT_ANGLE(-0.12683042883873)},
        {SCALE_SPLIT_ANGLE(-0.07378087192774),
         SCALE_SPLIT_ANGLE(-0.07408788800240),
         SCALE_SPLIT_ANGLE(-0.07456368207932),
         SCALE_SPLIT_ANGLE(-0.07580613344908),
         SCALE_SPLIT_ANGLE(-0.07708552479744),
         SCALE_SPLIT_ANGLE(-0.07926639169455),
         SCALE_SPLIT_ANGLE(-0.08326309919357),
         SCALE_SPLIT_ANGLE(-0.08642497658730)},
        {SCALE_SPLIT_ANGLE(-0.05331044271588),
         SCALE_SPLIT_ANGLE(-0.05347600579262),
         SCALE_SPLIT_ANGLE(-0.05373133346438),
         SCALE_SPLIT_ANGLE(-0.05439101532102),
         SCALE_SPLIT_ANGLE(-0.05505971238017),
         SCALE_SPLIT_ANGLE(-0.05617496743798),
         SCALE_SPLIT_ANGLE(-0.05813983827829),
         SCALE_SPLIT_ANGLE(-0.05962376296520)},
        {SCALE_SPLIT_ANGLE(-0.03066622652113),
         SCALE_SPLIT_ANGLE(-0.03072291985154),
         SCALE_SPLIT_ANGLE(-0.03080986253917),
         SCALE_SPLIT_ANGLE(-0.03103173524141),
         SCALE_SPLIT_ANGLE(-0.03125262632966),
         SCALE_SPLIT_ANGLE(-0.03161224350333),
         SCALE_SPLIT_ANGLE(-0.03221990913153),
         SCALE_SPLIT_ANGLE(-0.03265778720379)},
        {SCALE_SPLIT_ANGLE(-0.01747439615428),
         SCALE_SPLIT_ANGLE(-0.01749316416681),
         SCALE_SPLIT_ANGLE(-0.01752184517682),
         SCALE_SPLIT_ANGLE(-0.01759449020028),
         SCALE_SPLIT_ANGLE(-0.01766604930162),
         SCALE_SPLIT_ANGLE(-0.01778092049062),
         SCALE_SPLIT_ANGLE(-0.01797054335475),
         SCALE_SPLIT_ANGLE(-0.01810375973582)},
        {SCALE_SPLIT_ANGLE(-0.00990140344948),
         SCALE_SPLIT_ANGLE(-0.00990749336779),
         SCALE_SPLIT_ANGLE(-0.00991678331047),
         SCALE_SPLIT_ANGLE(-0.00994021166116),
         SCALE_SPLIT_ANGLE(-0.00996314454824),
         SCALE_SPLIT_ANGLE(-0.00999966636300),
         SCALE_SPLIT_ANGLE(-0.01005917042494),
         SCALE_SPLIT_ANGLE(-0.01010039448738)},
        {SCALE_SPLIT_ANGLE(-0.00559204118326),
         SCALE_SPLIT_ANGLE(-0.00559399509802),
         SCALE_SPLIT_ANGLE(-0.00559697346762),
         SCALE_SPLIT_ANGLE(-0.00560446362942),
         SCALE_SPLIT_ANGLE(-0.00561177125201),
         SCALE_SPLIT_ANGLE(-0.00562335411087),
         SCALE_SPLIT_ANGLE(-0.00564208766446),
         SCALE_SPLIT_ANGLE(-0.00565496599302)},
        {SCALE_SPLIT_ANGLE(-0.00000003162278),
         SCALE_SPLIT_ANGLE(-0.00000003162278),
         SCALE_SPLIT_ANGLE(-0.00000003162278),
         SCALE_SPLIT_ANGLE(-0.00000003162278),
         SCALE_SPLIT_ANGLE(-0.00000003162278),
         SCALE_SPLIT_ANGLE(-0.00000003162278),
         SCALE_SPLIT_ANGLE(-0.00000003162278),
         SCALE_SPLIT_ANGLE(-0.00000003162278)},
    },
    {
        {SCALE_SPLIT_ANGLE(-1.17809700965881),
         SCALE_SPLIT_ANGLE(-1.17809700965881),
         SCALE_SPLIT_ANGLE(-1.17809700965881),
         SCALE_SPLIT_ANGLE(-1.17809700965881),
         SCALE_SPLIT_ANGLE(-1.17809700965881),
         SCALE_SPLIT_ANGLE(-1.17809700965881),
         SCALE_SPLIT_ANGLE(-1.17809700965881),
         SCALE_SPLIT_ANGLE(-1.17809700965881)},
        {SCALE_SPLIT_ANGLE(-1.17289507389069),
         SCALE_SPLIT_ANGLE(-1.17289614677429),
         SCALE_SPLIT_ANGLE(-1.17289793491364),
         SCALE_SPLIT_ANGLE(-1.17290210723877),
         SCALE_SPLIT_ANGLE(-1.17290627956390),
         SCALE_SPLIT_ANGLE(-1.17291295528412),
         SCALE_SPLIT_ANGLE(-1.17292356491089),
         SCALE_SPLIT_ANGLE(-1.17293083667755)},
        {SCALE_SPLIT_ANGLE(-1.16883778572083),
         SCALE_SPLIT_ANGLE(-1.16884136199951),
         SCALE_SPLIT_ANGLE(-1.16884660720825),
         SCALE_SPLIT_ANGLE(-1.16885995864868),
         SCALE_SPLIT_ANGLE(-1.16887307167053),
         SCALE_SPLIT_ANGLE(-1.16889369487762),
         SCALE_SPLIT_ANGLE(-1.16892731189728),
         SCALE_SPLIT_ANGLE(-1.16895043849945)},
        {SCALE_SPLIT_ANGLE(-1.16160643100739),
         SCALE_SPLIT_ANGLE(-1.16161715984344),
         SCALE_SPLIT_ANGLE(-1.16163349151611),
         SCALE_SPLIT_ANGLE(-1.16167497634888),
         SCALE_SPLIT_ANGLE(-1.16171550750732),
         SCALE_SPLIT_ANGLE(-1.16178035736084),
         SCALE_SPLIT_ANGLE(-1.16188645362854),
         SCALE_SPLIT_ANGLE(-1.16196036338806)},
        {SCALE_SPLIT_ANGLE(-1.14870381355286),
         SCALE_SPLIT_ANGLE(-1.14873635768890),
         SCALE_SPLIT_ANGLE(-1.14878606796265),
         SCALE_SPLIT_ANGLE(-1.14891242980957),
         SCALE_SPLIT_ANGLE(-1.14903736114502),
         SCALE_SPLIT_ANGLE(-1.14923870563507),
         SCALE_SPLIT_ANGLE(-1.14957380294800),
         SCALE_SPLIT_ANGLE(-1.14981114864349)},
        {SCALE_SPLIT_ANGLE(-1.12567472457886),
         SCALE_SPLIT_ANGLE(-1.12576985359192),
         SCALE_SPLIT_ANGLE(-1.12591588497162),
         SCALE_SPLIT_ANGLE(-1.12629044055939),
         SCALE_SPLIT_ANGLE(-1.12666571140289),
         SCALE_SPLIT_ANGLE(-1.12728178501129),
         SCALE_SPLIT_ANGLE(-1.12833738327026),
         SCALE_SPLIT_ANGLE(-1.12910985946655)},
        {SCALE_SPLIT_ANGLE(-1.10394370555878),
         SCALE_SPLIT_ANGLE(-1.10411989688873),
         SCALE_SPLIT_ANGLE(-1.10439169406891),
         SCALE_SPLIT_ANGLE(-1.10509419441223),
         SCALE_SPLIT_ANGLE(-1.10580670833588),
         SCALE_SPLIT_ANGLE(-1.10699570178986),
         SCALE_SPLIT_ANGLE(-1.10909187793732),
         SCALE_SPLIT_ANGLE(-1.11067557334900)},
        {SCALE_SPLIT_ANGLE(-1.07335841655731),
         SCALE_SPLIT_ANGLE(-1.07367491722107),
         SCALE_SPLIT_ANGLE(-1.07416582107544),
         SCALE_SPLIT_ANGLE(-1.07544875144959),
         SCALE_SPLIT_ANGLE(-1.07677149772644),
         SCALE_SPLIT_ANGLE(-1.07902920246124),
         SCALE_SPLIT_ANGLE(-1.08317422866821),
         SCALE_SPLIT_ANGLE(-1.08645880222321)},
        {SCALE_SPLIT_ANGLE(-1.03070914745331),
         SCALE_SPLIT_ANGLE(-1.03125369548798),
         SCALE_SPLIT_ANGLE(-1.03210353851318),
         SCALE_SPLIT_ANGLE(-1.03435730934143),
         SCALE_SPLIT_ANGLE(-1.03673195838928),
         SCALE_SPLIT_ANGLE(-1.04091215133667),
         SCALE_SPLIT_ANGLE(-1.04904508590698),
         SCALE_SPLIT_ANGLE(-1.05597043037415)},
        {SCALE_SPLIT_ANGLE(-0.97233015298843),
         SCALE_SPLIT_ANGLE(-0.97321158647537),
         SCALE_SPLIT_ANGLE(-0.97459846735001),
         SCALE_SPLIT_ANGLE(-0.97834426164627),
         SCALE_SPLIT_ANGLE(-0.98240232467651),
         SCALE_SPLIT_ANGLE(-0.98984342813492),
         SCALE_SPLIT_ANGLE(-1.00556397438049),
         SCALE_SPLIT_ANGLE(-1.02053022384644)},
        {SCALE_SPLIT_ANGLE(-0.89506632089615),
         SCALE_SPLIT_ANGLE(-0.89638078212738),
         SCALE_SPLIT_ANGLE(-0.89846837520599),
         SCALE_SPLIT_ANGLE(-0.90423023700714),
         SCALE_SPLIT_ANGLE(-0.91068559885025),
         SCALE_SPLIT_ANGLE(-0.92315053939819),
         SCALE_SPLIT_ANGLE(-0.95268231630325),
         SCALE_SPLIT_ANGLE(-0.98626488447189)},
        {SCALE_SPLIT_ANGLE(-0.83257317543030),
         SCALE_SPLIT_ANGLE(-0.83419388532639),
         SCALE_SPLIT_ANGLE(-0.83678513765335),
         SCALE_SPLIT_ANGLE(-0.84404873847961),
         SCALE_SPLIT_ANGLE(-0.85238862037659),
         SCALE_SPLIT_ANGLE(-0.86914104223251),
         SCALE_SPLIT_ANGLE(-0.91285753250122),
         SCALE_SPLIT_ANGLE(-0.97222834825516)},
        {SCALE_SPLIT_ANGLE(-0.76227325201035),
         SCALE_SPLIT_ANGLE(-0.76417011022568),
         SCALE_SPLIT_ANGLE(-0.76722222566605),
         SCALE_SPLIT_ANGLE(-0.77590954303741),
         SCALE_SPLIT_ANGLE(-0.78613209724426),
         SCALE_SPLIT_ANGLE(-0.80752629041672),
         SCALE_SPLIT_ANGLE(-0.86987817287445),
         SCALE_SPLIT_ANGLE(-0.97863042354584)},
        {SCALE_SPLIT_ANGLE(-0.68631613254547),
         SCALE_SPLIT_ANGLE(-0.68841677904129),
         SCALE_SPLIT_ANGLE(-0.69181627035141),
         SCALE_SPLIT_ANGLE(-0.70162516832352),
         SCALE_SPLIT_ANGLE(-0.71342802047729),
         SCALE_SPLIT_ANGLE(-0.73910319805145),
         SCALE_SPLIT_ANGLE(-0.82307589054108),
         SCALE_SPLIT_ANGLE(-1.03222990036011)},
        {SCALE_SPLIT_ANGLE(-0.60781323909760),
         SCALE_SPLIT_ANGLE(-0.61001539230347),
         SCALE_SPLIT_ANGLE(-0.61359477043152),
         SCALE_SPLIT_ANGLE(-0.62403184175491),
         SCALE_SPLIT_ANGLE(-0.63681107759476),
         SCALE_SPLIT_ANGLE(-0.66548812389374),
         SCALE_SPLIT_ANGLE(-0.76931124925613),
         SCALE_SPLIT_ANGLE(-1.19638121128082)},
        {SCALE_SPLIT_ANGLE(-0.53021627664566),
         SCALE_SPLIT_ANGLE(-0.53240883350372),
         SCALE_SPLIT_ANGLE(-0.53598141670227),
         SCALE_SPLIT_ANGLE(-0.54646164178848),
         SCALE_SPLIT_ANGLE(-0.55942356586456),
         SCALE_SPLIT_ANGLE(-0.58904850482941),
         SCALE_SPLIT_ANGLE(-0.70326185226440),
         SCALE_SPLIT_ANGLE(-1.46822547912598)},
        {SCALE_SPLIT_ANGLE(-0.45655792951584),
         SCALE_SPLIT_ANGLE(-0.45864021778107),
         SCALE_SPLIT_ANGLE(-0.46203425526619),
         SCALE_SPLIT_ANGLE(-0.47199884057045),
         SCALE_SPLIT_ANGLE(-0.48433950543404),
         SCALE_SPLIT_ANGLE(-0.51260894536972),
         SCALE_SPLIT_ANGLE(-0.62212854623795),
         SCALE_SPLIT_ANGLE(-1.20720005035400)},
        {SCALE_SPLIT_ANGLE(-0.38893285393715),
         SCALE_SPLIT_ANGLE(-0.39082619547844),
         SCALE_SPLIT_ANGLE(-0.39390665292740),
         SCALE_SPLIT_ANGLE(-0.40291139483452),
         SCALE_SPLIT_ANGLE(-0.41398155689240),
         SCALE_SPLIT_ANGLE(-0.43899381160736),
         SCALE_SPLIT_ANGLE(-0.53091597557068),
         SCALE_SPLIT_ANGLE(-0.85221308469772)},
        {SCALE_SPLIT_ANGLE(-0.32840180397034),
         SCALE_SPLIT_ANGLE(-0.33005377650261),
         SCALE_SPLIT_ANGLE(-0.33273178339005),
         SCALE_SPLIT_ANGLE(-0.34049153327942),
         SCALE_SPLIT_ANGLE(-0.34989196062088),
         SCALE_SPLIT_ANGLE(-0.37057077884674),
         SCALE_SPLIT_ANGLE(-0.43990370631218),
         SCALE_SPLIT_ANGLE(-0.60593050718307)},
        {SCALE_SPLIT_ANGLE(-0.27521026134491),
         SCALE_SPLIT_ANGLE(-0.27659529447556),
         SCALE_SPLIT_ANGLE(-0.27882954478264),
         SCALE_SPLIT_ANGLE(-0.28522571921349),
         SCALE_SPLIT_ANGLE(-0.29282191395760),
         SCALE_SPLIT_ANGLE(-0.30895599722862),
         SCALE_SPLIT_ANGLE(-0.35752710700035),
         SCALE_SPLIT_ANGLE(-0.44366964697838)},
        {SCALE_SPLIT_ANGLE(-0.22909800708294),
         SCALE_SPLIT_ANGLE(-0.23021571338177),
         SCALE_SPLIT_ANGLE(-0.23200808465481),
         SCALE_SPLIT_ANGLE(-0.23706813156605),
         SCALE_SPLIT_ANGLE(-0.24294249713421),
         SCALE_SPLIT_ANGLE(-0.25494650006294),
         SCALE_SPLIT_ANGLE(-0.28743270039558),
         SCALE_SPLIT_ANGLE(-0.33326250314713)},
        {SCALE_SPLIT_ANGLE(-0.17204396426678),
         SCALE_SPLIT_ANGLE(-0.17280194163322),
         SCALE_SPLIT_ANGLE(-0.17400610446930),
         SCALE_SPLIT_ANGLE(-0.17733126878738),
         SCALE_SPLIT_ANGLE(-0.18105843663216),
         SCALE_SPLIT_ANGLE(-0.18825362622738),
         SCALE_SPLIT_ANGLE(-0.20519737899303),
         SCALE_SPLIT_ANGLE(-0.22397245466709)},
        {SCALE_SPLIT_ANGLE(-0.12763081490994),
         SCALE_SPLIT_ANGLE(-0.12810991704464),
         SCALE_SPLIT_ANGLE(-0.12886415421963),
         SCALE_SPLIT_ANGLE(-0.13090406358242),
         SCALE_SPLIT_ANGLE(-0.13311786949635),
         SCALE_SPLIT_ANGLE(-0.13718487322330),
         SCALE_SPLIT_ANGLE(-0.14578334987164),
         SCALE_SPLIT_ANGLE(-0.15392091870308)},
        {SCALE_SPLIT_ANGLE(-0.09368772059679),
         SCALE_SPLIT_ANGLE(-0.09397349506617),
         SCALE_SPLIT_ANGLE(-0.09441984444857),
         SCALE_SPLIT_ANGLE(-0.09560552984476),
         SCALE_SPLIT_ANGLE(-0.09685768932104),
         SCALE_SPLIT_ANGLE(-0.09906788170338),
         SCALE_SPLIT_ANGLE(-0.10338337719440),
         SCALE_SPLIT_ANGLE(-0.10706327110529)},
        {SCALE_SPLIT_ANGLE(-0.06817039847374),
         SCALE_SPLIT_ANGLE(-0.06833326816559),
         SCALE_SPLIT_ANGLE(-0.06858597695827),
         SCALE_SPLIT_ANGLE(-0.06924756616354),
         SCALE_SPLIT_ANGLE(-0.06993118673563),
         SCALE_SPLIT_ANGLE(-0.07110133022070),
         SCALE_SPLIT_ANGLE(-0.07325870543718),
         SCALE_SPLIT_ANGLE(-0.07497420907021)},
        {SCALE_SPLIT_ANGLE(-0.04925632849336),
         SCALE_SPLIT_ANGLE(-0.04934597387910),
         SCALE_SPLIT_ANGLE(-0.04948435723782),
         SCALE_SPLIT_ANGLE(-0.04984252154827),
         SCALE_SPLIT_ANGLE(-0.05020647123456),
         SCALE_SPLIT_ANGLE(-0.05081529170275),
         SCALE_SPLIT_ANGLE(-0.05189274996519),
         SCALE_SPLIT_ANGLE(-0.05270983278751)},
        {SCALE_SPLIT_ANGLE(-0.02833298221231),
         SCALE_SPLIT_ANGLE(-0.02836437523365),
         SCALE_SPLIT_ANGLE(-0.02841254323721),
         SCALE_SPLIT_ANGLE(-0.02853557653725),
         SCALE_SPLIT_ANGLE(-0.02865824848413),
         SCALE_SPLIT_ANGLE(-0.02885829471052),
         SCALE_SPLIT_ANGLE(-0.02919723838568),
         SCALE_SPLIT_ANGLE(-0.02944211103022)},
        {SCALE_SPLIT_ANGLE(-0.01614447496831),
         SCALE_SPLIT_ANGLE(-0.01615499891341),
         SCALE_SPLIT_ANGLE(-0.01617108844221),
         SCALE_SPLIT_ANGLE(-0.01621186546981),
         SCALE_SPLIT_ANGLE(-0.01625206507742),
         SCALE_SPLIT_ANGLE(-0.01631666161120),
         SCALE_SPLIT_ANGLE(-0.01642346009612),
         SCALE_SPLIT_ANGLE(-0.01649860478938)},
        {SCALE_SPLIT_ANGLE(-0.00914774928242),
         SCALE_SPLIT_ANGLE(-0.00915119051933),
         SCALE_SPLIT_ANGLE(-0.00915643945336),
         SCALE_SPLIT_ANGLE(-0.00916968192905),
         SCALE_SPLIT_ANGLE(-0.00918265059590),
         SCALE_SPLIT_ANGLE(-0.00920331384987),
         SCALE_SPLIT_ANGLE(-0.00923701003194),
         SCALE_SPLIT_ANGLE(-0.00926037784666)},
        {SCALE_SPLIT_ANGLE(-0.00516638066620),
         SCALE_SPLIT_ANGLE(-0.00516748940572),
         SCALE_SPLIT_ANGLE(-0.00516917882487),
         SCALE_SPLIT_ANGLE(-0.00517342938110),
         SCALE_SPLIT_ANGLE(-0.00517757609487),
         SCALE_SPLIT_ANGLE(-0.00518415309489),
         SCALE_SPLIT_ANGLE(-0.00519479531795),
         SCALE_SPLIT_ANGLE(-0.00520211551338)},
        {SCALE_SPLIT_ANGLE(-0.00000002921563),
         SCALE_SPLIT_ANGLE(-0.00000002921563),
         SCALE_SPLIT_ANGLE(-0.00000002921563),
         SCALE_SPLIT_ANGLE(-0.00000002921563),
         SCALE_SPLIT_ANGLE(-0.00000002921563),
         SCALE_SPLIT_ANGLE(-0.00000002921563),
         SCALE_SPLIT_ANGLE(-0.00000002921563),
         SCALE_SPLIT_ANGLE(-0.00000002921563)},
    },
    {
        {SCALE_SPLIT_ANGLE(-0.78539830446243),
         SCALE_SPLIT_ANGLE(-0.78539830446243),
         SCALE_SPLIT_ANGLE(-0.78539830446243),
         SCALE_SPLIT_ANGLE(-0.78539830446243),
         SCALE_SPLIT_ANGLE(-0.78539830446243),
         SCALE_SPLIT_ANGLE(-0.78539830446243),
         SCALE_SPLIT_ANGLE(-0.78539830446243),
         SCALE_SPLIT_ANGLE(-0.78539830446243)},
        {SCALE_SPLIT_ANGLE(-0.78143131732941),
         SCALE_SPLIT_ANGLE(-0.78143173456192),
         SCALE_SPLIT_ANGLE(-0.78143233060837),
         SCALE_SPLIT_ANGLE(-0.78143388032913),
         SCALE_SPLIT_ANGLE(-0.78143537044525),
         SCALE_SPLIT_ANGLE(-0.78143775463104),
         SCALE_SPLIT_ANGLE(-0.78144156932831),
         SCALE_SPLIT_ANGLE(-0.78144425153732)},
        {SCALE_SPLIT_ANGLE(-0.77835690975189),
         SCALE_SPLIT_ANGLE(-0.77835816144943),
         SCALE_SPLIT_ANGLE(-0.77836006879807),
         SCALE_SPLIT_ANGLE(-0.77836489677429),
         SCALE_SPLIT_ANGLE(-0.77836954593658),
         SCALE_SPLIT_ANGLE(-0.77837705612183),
         SCALE_SPLIT_ANGLE(-0.77838915586472),
         SCALE_SPLIT_ANGLE(-0.77839756011963)},
        {SCALE_SPLIT_ANGLE(-0.77291876077652),
         SCALE_SPLIT_ANGLE(-0.77292257547379),
         SCALE_SPLIT_ANGLE(-0.77292835712433),
         SCALE_SPLIT_ANGLE(-0.77294307947159),
         SCALE_SPLIT_ANGLE(-0.77295756340027),
         SCALE_SPLIT_ANGLE(-0.77298080921173),
         SCALE_SPLIT_ANGLE(-0.77301901578903),
         SCALE_SPLIT_ANGLE(-0.77304589748383)},
        {SCALE_SPLIT_ANGLE(-0.76334208250046),
         SCALE_SPLIT_ANGLE(-0.76335340738297),
         SCALE_SPLIT_ANGLE(-0.76337069272995),
         SCALE_SPLIT_ANGLE(-0.76341491937637),
         SCALE_SPLIT_ANGLE(-0.76345884799957),
         SCALE_SPLIT_ANGLE(-0.76353019475937),
         SCALE_SPLIT_ANGLE(-0.76365041732788),
         SCALE_SPLIT_ANGLE(-0.76373666524887)},
        {SCALE_SPLIT_ANGLE(-0.74662196636200),
         SCALE_SPLIT_ANGLE(-0.74665397405624),
         SCALE_SPLIT_ANGLE(-0.74670332670212),
         SCALE_SPLIT_ANGLE(-0.74683076143265),
         SCALE_SPLIT_ANGLE(-0.74695968627930),
         SCALE_SPLIT_ANGLE(-0.74717408418655),
         SCALE_SPLIT_ANGLE(-0.74754965305328),
         SCALE_SPLIT_ANGLE(-0.74783110618591)},
        {SCALE_SPLIT_ANGLE(-0.73124068975449),
         SCALE_SPLIT_ANGLE(-0.73129838705063),
         SCALE_SPLIT_ANGLE(-0.73138779401779),
         SCALE_SPLIT_ANGLE(-0.73162090778351),
         SCALE_SPLIT_ANGLE(-0.73186063766479),
         SCALE_SPLIT_ANGLE(-0.73226791620255),
         SCALE_SPLIT_ANGLE(-0.73300850391388),
         SCALE_SPLIT_ANGLE(-0.73358756303787)},
        {SCALE_SPLIT_ANGLE(-0.71016567945480),
         SCALE_SPLIT_ANGLE(-0.71026563644409),
         SCALE_SPLIT_ANGLE(-0.71042138338089),
         SCALE_SPLIT_ANGLE(-0.71083360910416),
         SCALE_SPLIT_ANGLE(-0.71126639842987),
         SCALE_SPLIT_ANGLE(-0.71202349662781),
         SCALE_SPLIT_ANGLE(-0.71347558498383),
         SCALE_SPLIT_ANGLE(-0.71468466520309)},
        {SCALE_SPLIT_ANGLE(-0.68173074722290),
         SCALE_SPLIT_ANGLE(-0.68189489841461),
         SCALE_SPLIT_ANGLE(-0.68215286731720),
         SCALE_SPLIT_ANGLE(-0.68284797668457),
         SCALE_SPLIT_ANGLE(-0.68359792232513),
         SCALE_SPLIT_ANGLE(-0.68496227264404),
         SCALE_SPLIT_ANGLE(-0.68778377771378),
         SCALE_SPLIT_ANGLE(-0.69036662578583)},
        {SCALE_SPLIT_ANGLE(-0.64424312114716),
         SCALE_SPLIT_ANGLE(-0.64449483156204),
         SCALE_SPLIT_ANGLE(-0.64489442110062),
         SCALE_SPLIT_ANGLE(-0.64599496126175),
         SCALE_SPLIT_ANGLE(-0.64722281694412),
         SCALE_SPLIT_ANGLE(-0.64957284927368),
         SCALE_SPLIT_ANGLE(-0.65497392416000),
         SCALE_SPLIT_ANGLE(-0.66069275140762)},
        {SCALE_SPLIT_ANGLE(-0.59645897150040),
         SCALE_SPLIT_ANGLE(-0.59681385755539),
         SCALE_SPLIT_ANGLE(-0.59738302230835),
         SCALE_SPLIT_ANGLE(-0.59898990392685),
         SCALE_SPLIT_ANGLE(-0.60085391998291),
         SCALE_SPLIT_ANGLE(-0.60464876890182),
         SCALE_SPLIT_ANGLE(-0.61471670866013),
         SCALE_SPLIT_ANGLE(-0.62811452150345)},
        {SCALE_SPLIT_ANGLE(-0.55878317356110),
         SCALE_SPLIT_ANGLE(-0.55920612812042),
         SCALE_SPLIT_ANGLE(-0.55988919734955),
         SCALE_SPLIT_ANGLE(-0.56185036897659),
         SCALE_SPLIT_ANGLE(-0.56418758630753),
         SCALE_SPLIT_ANGLE(-0.56916558742523),
         SCALE_SPLIT_ANGLE(-0.58402240276337),
         SCALE_SPLIT_ANGLE(-0.60877454280853)},
        {SCALE_SPLIT_ANGLE(-0.51690876483917),
         SCALE_SPLIT_ANGLE(-0.51739066839218),
         SCALE_SPLIT_ANGLE(-0.51817417144775),
         SCALE_SPLIT_ANGLE(-0.52045887708664),
         SCALE_SPLIT_ANGLE(-0.52325236797333),
         SCALE_SPLIT_ANGLE(-0.52947425842285),
         SCALE_SPLIT_ANGLE(-0.55062580108643),
         SCALE_SPLIT_ANGLE(-0.59875679016113)},
        {SCALE_SPLIT_ANGLE(-0.47171202301979),
         SCALE_SPLIT_ANGLE(-0.47223755717278),
         SCALE_SPLIT_ANGLE(-0.47309651970863),
         SCALE_SPLIT_ANGLE(-0.47563409805298),
         SCALE_SPLIT_ANGLE(-0.47880497574806),
         SCALE_SPLIT_ANGLE(-0.48615178465843),
         SCALE_SPLIT_ANGLE(-0.51456993818283),
         SCALE_SPLIT_ANGLE(-0.61478376388550)},
        {SCALE_SPLIT_ANGLE(-0.42445346713066),
         SCALE_SPLIT_ANGLE(-0.42500337958336),
         SCALE_SPLIT_ANGLE(-0.42590552568436),
         SCALE_SPLIT_ANGLE(-0.42859482765198),
         SCALE_SPLIT_ANGLE(-0.43200704455376),
         SCALE_SPLIT_ANGLE(-0.44014206528664),
         SCALE_SPLIT_ANGLE(-0.47505456209183),
         SCALE_SPLIT_ANGLE(-0.70435559749603)},
        {SCALE_SPLIT_ANGLE(-0.37662348151207),
         SCALE_SPLIT_ANGLE(-0.37717759609222),
         SCALE_SPLIT_ANGLE(-0.37808811664581),
         SCALE_SPLIT_ANGLE(-0.38081312179565),
         SCALE_SPLIT_ANGLE(-0.38429382443428),
         SCALE_SPLIT_ANGLE(-0.39269915223122),
         SCALE_SPLIT_ANGLE(-0.43061137199402),
         SCALE_SPLIT_ANGLE(-0.89949661493301)},
        {SCALE_SPLIT_ANGLE(-0.32972770929337),
         SCALE_SPLIT_ANGLE(-0.33026665449142),
         SCALE_SPLIT_ANGLE(-0.33115166425705),
         SCALE_SPLIT_ANGLE(-0.33379596471786),
         SCALE_SPLIT_ANGLE(-0.33716449141502),
         SCALE_SPLIT_ANGLE(-0.34525626897812),
         SCALE_SPLIT_ANGLE(-0.38098806142807),
         SCALE_SPLIT_ANGLE(-0.66312354803085)},
        {SCALE_SPLIT_ANGLE(-0.28508266806602),
         SCALE_SPLIT_ANGLE(-0.28558865189552),
         SCALE_SPLIT_ANGLE(-0.28641721606255),
         SCALE_SPLIT_ANGLE(-0.28887599706650),
         SCALE_SPLIT_ANGLE(-0.29197183251381),
         SCALE_SPLIT_ANGLE(-0.29924651980400),
         SCALE_SPLIT_ANGLE(-0.32879725098610),
         SCALE_SPLIT_ANGLE(-0.45467042922974)},
        {SCALE_SPLIT_ANGLE(-0.24368351697922),
         SCALE_SPLIT_ANGLE(-0.24414126574993),
         SCALE_SPLIT_ANGLE(-0.24488742649555),
         SCALE_SPLIT_ANGLE(-0.24707718193531),
         SCALE_SPLIT_ANGLE(-0.24978290498257),
         SCALE_SPLIT_ANGLE(-0.25592407584190),
         SCALE_SPLIT_ANGLE(-0.27806493639946),
         SCALE_SPLIT_ANGLE(-0.33706212043762)},
        {SCALE_SPLIT_ANGLE(-0.20616291463375),
         SCALE_SPLIT_ANGLE(-0.20656123757362),
         SCALE_SPLIT_ANGLE(-0.20720669627190),
         SCALE_SPLIT_ANGLE(-0.20907410979271),
         SCALE_SPLIT_ANGLE(-0.21132779121399),
         SCALE_SPLIT_ANGLE(-0.21623276174068),
         SCALE_SPLIT_ANGLE(-0.23178002238274),
         SCALE_SPLIT_ANGLE(-0.26115795969963)},
        {SCALE_SPLIT_ANGLE(-0.17282113432884),
         SCALE_SPLIT_ANGLE(-0.17315419018269),
         SCALE_SPLIT_ANGLE(-0.17369027435780),
         SCALE_SPLIT_ANGLE(-0.17521676421165),
         SCALE_SPLIT_ANGLE(-0.17701183259487),
         SCALE_SPLIT_ANGLE(-0.18074958026409),
         SCALE_SPLIT_ANGLE(-0.19124273955822),
         SCALE_SPLIT_ANGLE(-0.20666226744652)},
        {SCALE_SPLIT_ANGLE(-0.13066087663174),
         SCALE_SPLIT_ANGLE(-0.13089761137962),
         SCALE_SPLIT_ANGLE(-0.13127478957176),
         SCALE_SPLIT_ANGLE(-0.13232274353504),
         SCALE_SPLIT_ANGLE(-0.13350811600685),
         SCALE_SPLIT_ANGLE(-0.13582547008991),
         SCALE_SPLIT_ANGLE(-0.14140743017197),
         SCALE_SPLIT_ANGLE(-0.14774034917355)},
        {SCALE_SPLIT_ANGLE(-0.09729288518429),
         SCALE_SPLIT_ANGLE(-0.09744837880135),
         SCALE_SPLIT_ANGLE(-0.09769365936518),
         SCALE_SPLIT_ANGLE(-0.09835996478796),
         SCALE_SPLIT_ANGLE(-0.09908770024776),
         SCALE_SPLIT_ANGLE(-0.10043605417013),
         SCALE_SPLIT_ANGLE(-0.10332851856947),
         SCALE_SPLIT_ANGLE(-0.10610698908567)},
        {SCALE_SPLIT_ANGLE(-0.07155896723270),
         SCALE_SPLIT_ANGLE(-0.07165452837944),
         SCALE_SPLIT_ANGLE(-0.07180399447680),
         SCALE_SPLIT_ANGLE(-0.07220225781202),
         SCALE_SPLIT_ANGLE(-0.07262473553419),
         SCALE_SPLIT_ANGLE(-0.07337480783463),
         SCALE_SPLIT_ANGLE(-0.07485358417034),
         SCALE_SPLIT_ANGLE(-0.07612710446119)},
        {SCALE_SPLIT_ANGLE(-0.05212157964706),
         SCALE_SPLIT_ANGLE(-0.05217728391290),
         SCALE_SPLIT_ANGLE(-0.05226380378008),
         SCALE_SPLIT_ANGLE(-0.05249079316854),
         SCALE_SPLIT_ANGLE(-0.05272606760263),
         SCALE_SPLIT_ANGLE(-0.05313043296337),
         SCALE_SPLIT_ANGLE(-0.05388086661696),
         SCALE_SPLIT_ANGLE(-0.05448163300753)},
        {SCALE_SPLIT_ANGLE(-0.03767966106534),
         SCALE_SPLIT_ANGLE(-0.03771083801985),
         SCALE_SPLIT_ANGLE(-0.03775899857283),
         SCALE_SPLIT_ANGLE(-0.03788383677602),
         SCALE_SPLIT_ANGLE(-0.03801096975803),
         SCALE_SPLIT_ANGLE(-0.03822424262762),
         SCALE_SPLIT_ANGLE(-0.03860339894891),
         SCALE_SPLIT_ANGLE(-0.03889227285981)},
        {SCALE_SPLIT_ANGLE(-0.02168159000576),
         SCALE_SPLIT_ANGLE(-0.02169271185994),
         SCALE_SPLIT_ANGLE(-0.02170977741480),
         SCALE_SPLIT_ANGLE(-0.02175341919065),
         SCALE_SPLIT_ANGLE(-0.02179697901011),
         SCALE_SPLIT_ANGLE(-0.02186813205481),
         SCALE_SPLIT_ANGLE(-0.02198898792267),
         SCALE_SPLIT_ANGLE(-0.02207653038204)},
        {SCALE_SPLIT_ANGLE(-0.01235581189394),
         SCALE_SPLIT_ANGLE(-0.01235958002508),
         SCALE_SPLIT_ANGLE(-0.01236534304917),
         SCALE_SPLIT_ANGLE(-0.01237995456904),
         SCALE_SPLIT_ANGLE(-0.01239436771721),
         SCALE_SPLIT_ANGLE(-0.01241754833609),
         SCALE_SPLIT_ANGLE(-0.01245592441410),
         SCALE_SPLIT_ANGLE(-0.01248297002167)},
        {SCALE_SPLIT_ANGLE(-0.00700127193704),
         SCALE_SPLIT_ANGLE(-0.00700251199305),
         SCALE_SPLIT_ANGLE(-0.00700440304354),
         SCALE_SPLIT_ANGLE(-0.00700917467475),
         SCALE_SPLIT_ANGLE(-0.00701385131106),
         SCALE_SPLIT_ANGLE(-0.00702130468562),
         SCALE_SPLIT_ANGLE(-0.00703346915543),
         SCALE_SPLIT_ANGLE(-0.00704191112891)},
        {SCALE_SPLIT_ANGLE(-0.00395415676758),
         SCALE_SPLIT_ANGLE(-0.00395455863327),
         SCALE_SPLIT_ANGLE(-0.00395516911522),
         SCALE_SPLIT_ANGLE(-0.00395670579746),
         SCALE_SPLIT_ANGLE(-0.00395820569247),
         SCALE_SPLIT_ANGLE(-0.00396058475599),
         SCALE_SPLIT_ANGLE(-0.00396443624049),
         SCALE_SPLIT_ANGLE(-0.00396708631888)},
        {SCALE_SPLIT_ANGLE(-0.00000002236068),
         SCALE_SPLIT_ANGLE(-0.00000002236068),
         SCALE_SPLIT_ANGLE(-0.00000002236068),
         SCALE_SPLIT_ANGLE(-0.00000002236068),
         SCALE_SPLIT_ANGLE(-0.00000002236068),
         SCALE_SPLIT_ANGLE(-0.00000002236068),
         SCALE_SPLIT_ANGLE(-0.00000002236068),
         SCALE_SPLIT_ANGLE(-0.00000002236068)},
    },
    {
        {SCALE_SPLIT_ANGLE(-0.39269906282425),
         SCALE_SPLIT_ANGLE(-0.39269906282425),
         SCALE_SPLIT_ANGLE(-0.39269906282425),
         SCALE_SPLIT_ANGLE(-0.39269906282425),
         SCALE_SPLIT_ANGLE(-0.39269906282425),
         SCALE_SPLIT_ANGLE(-0.39269906282425),
         SCALE_SPLIT_ANGLE(-0.39269906282425),
         SCALE_SPLIT_ANGLE(-0.39269906282425)},
        {SCALE_SPLIT_ANGLE(-0.39055728912354),
         SCALE_SPLIT_ANGLE(-0.39055734872818),
         SCALE_SPLIT_ANGLE(-0.39055743813515),
         SCALE_SPLIT_ANGLE(-0.39055764675140),
         SCALE_SPLIT_ANGLE(-0.39055785536766),
         SCALE_SPLIT_ANGLE(-0.39055821299553),
         SCALE_SPLIT_ANGLE(-0.39055874943733),
         SCALE_SPLIT_ANGLE(-0.39055910706520)},
        {SCALE_SPLIT_ANGLE(-0.38890448212624),
         SCALE_SPLIT_ANGLE(-0.38890466094017),
         SCALE_SPLIT_ANGLE(-0.38890489935875),
         SCALE_SPLIT_ANGLE(-0.38890558481216),
         SCALE_SPLIT_ANGLE(-0.38890624046326),
         SCALE_SPLIT_ANGLE(-0.38890728354454),
         SCALE_SPLIT_ANGLE(-0.38890898227692),
         SCALE_SPLIT_ANGLE(-0.38891017436981)},
        {SCALE_SPLIT_ANGLE(-0.38599535822868),
         SCALE_SPLIT_ANGLE(-0.38599589467049),
         SCALE_SPLIT_ANGLE(-0.38599669933319),
         SCALE_SPLIT_ANGLE(-0.38599872589111),
         SCALE_SPLIT_ANGLE(-0.38600075244904),
         SCALE_SPLIT_ANGLE(-0.38600397109985),
         SCALE_SPLIT_ANGLE(-0.38600933551788),
         SCALE_SPLIT_ANGLE(-0.38601312041283)},
        {SCALE_SPLIT_ANGLE(-0.38091570138931),
         SCALE_SPLIT_ANGLE(-0.38091725111008),
         SCALE_SPLIT_ANGLE(-0.38091960549355),
         SCALE_SPLIT_ANGLE(-0.38092568516731),
         SCALE_SPLIT_ANGLE(-0.38093173503876),
         SCALE_SPLIT_ANGLE(-0.38094159960747),
         SCALE_SPLIT_ANGLE(-0.38095837831497),
         SCALE_SPLIT_ANGLE(-0.38097053766251)},
        {SCALE_SPLIT_ANGLE(-0.37216994166374),
         SCALE_SPLIT_ANGLE(-0.37217423319817),
         SCALE_SPLIT_ANGLE(-0.37218084931374),
         SCALE_SPLIT_ANGLE(-0.37219804525375),
         SCALE_SPLIT_ANGLE(-0.37221553921700),
         SCALE_SPLIT_ANGLE(-0.37224486470222),
         SCALE_SPLIT_ANGLE(-0.37229701876640),
         SCALE_SPLIT_ANGLE(-0.37233671545982)},
        {SCALE_SPLIT_ANGLE(-0.36424961686134),
         SCALE_SPLIT_ANGLE(-0.36425721645355),
         SCALE_SPLIT_ANGLE(-0.36426901817322),
         SCALE_SPLIT_ANGLE(-0.36429998278618),
         SCALE_SPLIT_ANGLE(-0.36433207988739),
         SCALE_SPLIT_ANGLE(-0.36438727378845),
         SCALE_SPLIT_ANGLE(-0.36448964476585),
         SCALE_SPLIT_ANGLE(-0.36457160115242)},
        {SCALE_SPLIT_ANGLE(-0.35356882214546),
         SCALE_SPLIT_ANGLE(-0.35358169674873),
         SCALE_SPLIT_ANGLE(-0.35360184311867),
         SCALE_SPLIT_ANGLE(-0.35365554690361),
         SCALE_SPLIT_ANGLE(-0.35371255874634),
         SCALE_SPLIT_ANGLE(-0.35381379723549),
         SCALE_SPLIT_ANGLE(-0.35401359200478),
         SCALE_SPLIT_ANGLE(-0.35418573021889)},
        {SCALE_SPLIT_ANGLE(-0.33942580223083),
         SCALE_SPLIT_ANGLE(-0.33944639563560),
         SCALE_SPLIT_ANGLE(-0.33947893977165),
         SCALE_SPLIT_ANGLE(-0.33956736326218),
         SCALE_SPLIT_ANGLE(-0.33966410160065),
         SCALE_SPLIT_ANGLE(-0.33984366059303),
         SCALE_SPLIT_ANGLE(-0.34023004770279),
         SCALE_SPLIT_ANGLE(-0.34060218930244)},
        {SCALE_SPLIT_ANGLE(-0.32115444540977),
         SCALE_SPLIT_ANGLE(-0.32118517160416),
         SCALE_SPLIT_ANGLE(-0.32123413681984),
         SCALE_SPLIT_ANGLE(-0.32137045264244),
         SCALE_SPLIT_ANGLE(-0.32152506709099),
         SCALE_SPLIT_ANGLE(-0.32182860374451),
         SCALE_SPLIT_ANGLE(-0.32256555557251),
         SCALE_SPLIT_ANGLE(-0.32340887188911)},
        {SCALE_SPLIT_ANGLE(-0.29830518364906),
         SCALE_SPLIT_ANGLE(-0.29834720492363),
         SCALE_SPLIT_ANGLE(-0.29841497540474),
         SCALE_SPLIT_ANGLE(-0.29860857129097),
         SCALE_SPLIT_ANGLE(-0.29883739352226),
         SCALE_SPLIT_ANGLE(-0.29931783676147),
         SCALE_SPLIT_ANGLE(-0.30069103837013),
         SCALE_SPLIT_ANGLE(-0.30275768041611)},
        {SCALE_SPLIT_ANGLE(-0.28050783276558),
         SCALE_SPLIT_ANGLE(-0.28055709600449),
         SCALE_SPLIT_ANGLE(-0.28063705563545),
         SCALE_SPLIT_ANGLE(-0.28086939454079),
         SCALE_SPLIT_ANGLE(-0.28115186095238),
         SCALE_SPLIT_ANGLE(-0.28177401423454),
         SCALE_SPLIT_ANGLE(-0.28380542993546),
         SCALE_SPLIT_ANGLE(-0.28782635927200)},
        {SCALE_SPLIT_ANGLE(-0.26083284616470),
         SCALE_SPLIT_ANGLE(-0.26088821887970),
         SCALE_SPLIT_ANGLE(-0.26097869873047),
         SCALE_SPLIT_ANGLE(-0.26124575734138),
         SCALE_SPLIT_ANGLE(-0.26157894730568),
         SCALE_SPLIT_ANGLE(-0.26234790682793),
         SCALE_SPLIT_ANGLE(-0.26525342464447),
         SCALE_SPLIT_ANGLE(-0.27373573184013)},
        {SCALE_SPLIT_ANGLE(-0.23960019648075),
         SCALE_SPLIT_ANGLE(-0.23966008424759),
         SCALE_SPLIT_ANGLE(-0.23975844681263),
         SCALE_SPLIT_ANGLE(-0.24005250632763),
         SCALE_SPLIT_ANGLE(-0.24042734503746),
         SCALE_SPLIT_ANGLE(-0.24132779240608),
         SCALE_SPLIT_ANGLE(-0.24525122344494),
         SCALE_SPLIT_ANGLE(-0.26534584164619)},
        {SCALE_SPLIT_ANGLE(-0.21727462112904),
         SCALE_SPLIT_ANGLE(-0.21733717620373),
         SCALE_SPLIT_ANGLE(-0.21744027733803),
         SCALE_SPLIT_ANGLE(-0.21775110065937),
         SCALE_SPLIT_ANGLE(-0.21815298497677),
         SCALE_SPLIT_ANGLE(-0.21914556622505),
         SCALE_SPLIT_ANGLE(-0.22397416830063),
         SCALE_SPLIT_ANGLE(-0.27997338771820)},
        {SCALE_SPLIT_ANGLE(-0.19442924857140),
         SCALE_SPLIT_ANGLE(-0.19449259340763),
         SCALE_SPLIT_ANGLE(-0.19459711015224),
         SCALE_SPLIT_ANGLE(-0.19491319358349),
         SCALE_SPLIT_ANGLE(-0.19532407820225),
         SCALE_SPLIT_ANGLE(-0.19634953141212),
         SCALE_SPLIT_ANGLE(-0.20156541466713),
         SCALE_SPLIT_ANGLE(-0.33650863170624)},
        {SCALE_SPLIT_ANGLE(-0.17168678343296),
         SCALE_SPLIT_ANGLE(-0.17174907028675),
         SCALE_SPLIT_ANGLE(-0.17185172438622),
         SCALE_SPLIT_ANGLE(-0.17216137051582),
         SCALE_SPLIT_ANGLE(-0.17256210744381),
         SCALE_SPLIT_ANGLE(-0.17355349659920),
         SCALE_SPLIT_ANGLE(-0.17841055989265),
         SCALE_SPLIT_ANGLE(-0.23922458291054)},
        {SCALE_SPLIT_ANGLE(-0.14965106546879),
         SCALE_SPLIT_ANGLE(-0.14971044659615),
         SCALE_SPLIT_ANGLE(-0.14980801939964),
         SCALE_SPLIT_ANGLE(-0.15010000765324),
         SCALE_SPLIT_ANGLE(-0.15047281980515),
         SCALE_SPLIT_ANGLE(-0.15137127041817),
         SCALE_SPLIT_ANGLE(-0.15533344447613),
         SCALE_SPLIT_ANGLE(-0.17691853642464)},
        {SCALE_SPLIT_ANGLE(-0.12884500622749),
         SCALE_SPLIT_ANGLE(-0.12889972329140),
         SCALE_SPLIT_ANGLE(-0.12898920476437),
         SCALE_SPLIT_ANGLE(-0.12925371527672),
         SCALE_SPLIT_ANGLE(-0.12958449125290),
         SCALE_SPLIT_ANGLE(-0.13035115599632),
         SCALE_SPLIT_ANGLE(-0.13329000771046),
         SCALE_SPLIT_ANGLE(-0.14226882159710)},
        {SCALE_SPLIT_ANGLE(-0.10966771095991),
         SCALE_SPLIT_ANGLE(-0.10971628129482),
         SCALE_SPLIT_ANGLE(-0.10979521274567),
         SCALE_SPLIT_ANGLE(-0.11002496629953),
         SCALE_SPLIT_ANGLE(-0.11030505597591),
         SCALE_SPLIT_ANGLE(-0.11092507094145),
         SCALE_SPLIT_ANGLE(-0.11297955363989),
         SCALE_SPLIT_ANGLE(-0.11718675494194)},
        {SCALE_SPLIT_ANGLE(-0.09237615764141),
         SCALE_SPLIT_ANGLE(-0.09241757541895),
         SCALE_SPLIT_ANGLE(-0.09248440712690),
         SCALE_SPLIT_ANGLE(-0.09267570078373),
         SCALE_SPLIT_ANGLE(-0.09290252625942),
         SCALE_SPLIT_ANGLE(-0.09338124096394),
         SCALE_SPLIT_ANGLE(-0.09476861357689),
         SCALE_SPLIT_ANGLE(-0.09691139310598)},
        {SCALE_SPLIT_ANGLE(-0.07020132243633),
         SCALE_SPLIT_ANGLE(-0.07023159414530),
         SCALE_SPLIT_ANGLE(-0.07027988135815),
         SCALE_SPLIT_ANGLE(-0.07041461765766),
         SCALE_SPLIT_ANGLE(-0.07056794315577),
         SCALE_SPLIT_ANGLE(-0.07087046653032),
         SCALE_SPLIT_ANGLE(-0.07161350548267),
         SCALE_SPLIT_ANGLE(-0.07247892767191)},
        {SCALE_SPLIT_ANGLE(-0.05244029313326),
         SCALE_SPLIT_ANGLE(-0.05246063694358),
         SCALE_SPLIT_ANGLE(-0.05249277129769),
         SCALE_SPLIT_ANGLE(-0.05258031189442),
         SCALE_SPLIT_ANGLE(-0.05267634615302),
         SCALE_SPLIT_ANGLE(-0.05285539105535),
         SCALE_SPLIT_ANGLE(-0.05324416607618),
         SCALE_SPLIT_ANGLE(-0.05362325906754)},
        {SCALE_SPLIT_ANGLE(-0.03864165395498),
         SCALE_SPLIT_ANGLE(-0.03865438699722),
         SCALE_SPLIT_ANGLE(-0.03867433220148),
         SCALE_SPLIT_ANGLE(-0.03872758150101),
         SCALE_SPLIT_ANGLE(-0.03878423944116),
         SCALE_SPLIT_ANGLE(-0.03888526186347),
         SCALE_SPLIT_ANGLE(-0.03908598423004),
         SCALE_SPLIT_ANGLE(-0.03926040232182)},
        {SCALE_SPLIT_ANGLE(-0.02817477099597),
         SCALE_SPLIT_ANGLE(-0.02818230539560),
         SCALE_SPLIT_ANGLE(-0.02819401212037),
         SCALE_SPLIT_ANGLE(-0.02822477370501),
         SCALE_SPLIT_ANGLE(-0.02825672924519),
         SCALE_SPLIT_ANGLE(-0.02831180207431),
         SCALE_SPLIT_ANGLE(-0.02841453626752),
         SCALE_SPLIT_ANGLE(-0.02849724888802)},
        {SCALE_SPLIT_ANGLE(-0.02037952840328),
         SCALE_SPLIT_ANGLE(-0.02038379199803),
         SCALE_SPLIT_ANGLE(-0.02039037644863),
         SCALE_SPLIT_ANGLE(-0.02040746808052),
         SCALE_SPLIT_ANGLE(-0.02042490057647),
         SCALE_SPLIT_ANGLE(-0.02045419998467),
         SCALE_SPLIT_ANGLE(-0.02050646580756),
         SCALE_SPLIT_ANGLE(-0.02054643817246)},
        {SCALE_SPLIT_ANGLE(-0.01173160132021),
         SCALE_SPLIT_ANGLE(-0.01173313893378),
         SCALE_SPLIT_ANGLE(-0.01173550169915),
         SCALE_SPLIT_ANGLE(-0.01174154412001),
         SCALE_SPLIT_ANGLE(-0.01174758281559),
         SCALE_SPLIT_ANGLE(-0.01175745390356),
         SCALE_SPLIT_ANGLE(-0.01177425216883),
         SCALE_SPLIT_ANGLE(-0.01178644038737)},
        {SCALE_SPLIT_ANGLE(-0.00668647419661),
         SCALE_SPLIT_ANGLE(-0.00668699899688),
         SCALE_SPLIT_ANGLE(-0.00668780226260),
         SCALE_SPLIT_ANGLE(-0.00668983859941),
         SCALE_SPLIT_ANGLE(-0.00669184979051),
         SCALE_SPLIT_ANGLE(-0.00669508427382),
         SCALE_SPLIT_ANGLE(-0.00670044496655),
         SCALE_SPLIT_ANGLE(-0.00670422706753)},
        {SCALE_SPLIT_ANGLE(-0.00378898018971),
         SCALE_SPLIT_ANGLE(-0.00378915364854),
         SCALE_SPLIT_ANGLE(-0.00378941860981),
         SCALE_SPLIT_ANGLE(-0.00379008613527),
         SCALE_SPLIT_ANGLE(-0.00379074038938),
         SCALE_SPLIT_ANGLE(-0.00379178440198),
         SCALE_SPLIT_ANGLE(-0.00379348848946),
         SCALE_SPLIT_ANGLE(-0.00379467150196)},
        {SCALE_SPLIT_ANGLE(-0.00213995948434),
         SCALE_SPLIT_ANGLE(-0.00214001582935),
         SCALE_SPLIT_ANGLE(-0.00214010151103),
         SCALE_SPLIT_ANGLE(-0.00214031687938),
         SCALE_SPLIT_ANGLE(-0.00214052735828),
         SCALE_SPLIT_ANGLE(-0.00214086123742),
         SCALE_SPLIT_ANGLE(-0.00214140163735),
         SCALE_SPLIT_ANGLE(-0.00214177393354)},
        {SCALE_SPLIT_ANGLE(-0.00000001210151),
         SCALE_SPLIT_ANGLE(-0.00000001210151),
         SCALE_SPLIT_ANGLE(-0.00000001210151),
         SCALE_SPLIT_ANGLE(-0.00000001210151),
         SCALE_SPLIT_ANGLE(-0.00000001210151),
         SCALE_SPLIT_ANGLE(-0.00000001210151),
         SCALE_SPLIT_ANGLE(-0.00000001210151),
         SCALE_SPLIT_ANGLE(-0.00000001210151)},
    },
};

#define SCALE_CLD(a) (FL2FXCONST_CFG(a))

const FIXP_CFG dequantCLD_c_l[31] = {
    SCALE_CLD(0.0000000316f),
    SCALE_CLD(0.0056233243f),
    SCALE_CLD(0.0099994997f),
    SCALE_CLD(0.0177799836f),
    SCALE_CLD(0.0316069759f),
    SCALE_CLD(0.0561454296f),
    SCALE_CLD(0.0791834071f),
    SCALE_CLD(0.1115021780f),
    SCALE_CLD(0.1565355062f),
    SCALE_CLD(0.2184644639f),
    SCALE_CLD(0.3015113473f),
    SCALE_CLD(0.3698741496f),
    SCALE_CLD(0.4480624795f),
    SCALE_CLD(0.5336171389f),
    SCALE_CLD(0.6219832301f),
    SCALE_CLD(0.7071067691f),
    SCALE_CLD(0.7830305696f),
    SCALE_CLD(0.8457261920f),
    SCALE_CLD(0.8940021992f),
    SCALE_CLD(0.9290818572f),
    SCALE_CLD(0.9534626007f),
    SCALE_CLD(0.9758449197f),
    SCALE_CLD(0.9876723289f),
    SCALE_CLD(0.9937641621f),
    SCALE_CLD(0.9968600869f),
    SCALE_CLD(0.9984226227f),
    SCALE_CLD(0.9995003939f),
    SCALE_CLD(0.9998419285f),
    SCALE_CLD(0.9999499917f),
    SCALE_CLD(0.9999842048f),
    /*SCALE_CLD(1.0000000000f)*/ FX_DBL2FX_CFG(MAXVAL_DBL)};

#define SC_H(a) (FL2FXCONST_CFG(a))
#define DATA_TYPE_H FIXP_CFG

/* not correlated  tables */
const DATA_TYPE_H H11_nc[31][8] = {
    {SC_H(0.0000000316f), SC_H(0.0000000296f), SC_H(0.0000000266f),
     SC_H(0.0000000190f), SC_H(0.0000000116f), SC_H(0.0000000000f),
     SC_H(-0.0000000186f), SC_H(-0.0000000313f)},
    {SC_H(0.0056233243f), SC_H(0.0052728835f), SC_H(0.0047394098f),
     SC_H(0.0033992692f), SC_H(0.0020946222f), SC_H(0.0000316215f),
     SC_H(-0.0032913829f), SC_H(-0.0055664564f)},
    {SC_H(0.0099994997f), SC_H(0.0093815643f), SC_H(0.0084402543f),
     SC_H(0.0060722125f), SC_H(0.0037622179f), SC_H(0.0000999898f),
     SC_H(-0.0058238208f), SC_H(-0.0098974844f)},
    {SC_H(0.0177799836f), SC_H(0.0166974831f), SC_H(0.0150465844f),
     SC_H(0.0108831404f), SC_H(0.0068073822f), SC_H(0.0003161267f),
     SC_H(-0.0102626514f), SC_H(-0.0175957214f)},
    {SC_H(0.0316069759f), SC_H(0.0297324844f), SC_H(0.0268681273f),
     SC_H(0.0196138974f), SC_H(0.0124691967f), SC_H(0.0009989988f),
     SC_H(-0.0179452803f), SC_H(-0.0312700421f)},
    {SC_H(0.0561454296f), SC_H(0.0529650487f), SC_H(0.0480896905f),
     SC_H(0.0356564634f), SC_H(0.0232860073f), SC_H(0.0031523081f),
     SC_H(-0.0309029408f), SC_H(-0.0555154830f)},
    {SC_H(0.0791834071f), SC_H(0.0748842582f), SC_H(0.0682762116f),
     SC_H(0.0513241664f), SC_H(0.0343080349f), SC_H(0.0062700072f),
     SC_H(-0.0422340371f), SC_H(-0.0782499388f)},
    {SC_H(0.1115021780f), SC_H(0.1057924852f), SC_H(0.0969873071f),
     SC_H(0.0742305145f), SC_H(0.0511277616f), SC_H(0.0124327289f),
     SC_H(-0.0566596612f), SC_H(-0.1100896299f)},
    {SC_H(0.1565355062f), SC_H(0.1491366178f), SC_H(0.1376826316f),
     SC_H(0.1078186408f), SC_H(0.0770794004f), SC_H(0.0245033558f),
     SC_H(-0.0735980421f), SC_H(-0.1543303132f)},
    {SC_H(0.2184644639f), SC_H(0.2091979682f), SC_H(0.1947948188f),
     SC_H(0.1568822265f), SC_H(0.1172478944f), SC_H(0.0477267131f),
     SC_H(-0.0899507254f), SC_H(-0.2148526460f)},
    {SC_H(0.3015113473f), SC_H(0.2904391289f), SC_H(0.2731673419f),
     SC_H(0.2273024023f), SC_H(0.1786239147f), SC_H(0.0909090787f),
     SC_H(-0.0964255333f), SC_H(-0.2951124907f)},
    {SC_H(0.3698741496f), SC_H(0.3578284085f), SC_H(0.3390066922f),
     SC_H(0.2888108492f), SC_H(0.2351117432f), SC_H(0.1368068755f),
     SC_H(-0.0850296095f), SC_H(-0.3597966135f)},
    {SC_H(0.4480624795f), SC_H(0.4354025424f), SC_H(0.4156077504f),
     SC_H(0.3627120256f), SC_H(0.3058823943f), SC_H(0.2007599771f),
     SC_H(-0.0484020934f), SC_H(-0.4304940701f)},
    {SC_H(0.5336171389f), SC_H(0.5208471417f), SC_H(0.5008935928f),
     SC_H(0.4476420581f), SC_H(0.3905044496f), SC_H(0.2847472429f),
     SC_H(0.0276676007f), SC_H(-0.4966579080f)},
    {SC_H(0.6219832301f), SC_H(0.6096963882f), SC_H(0.5905415416f),
     SC_H(0.5396950245f), SC_H(0.4856070578f), SC_H(0.3868631124f),
     SC_H(0.1531652957f), SC_H(-0.5045361519f)},
    {SC_H(0.7071067691f), SC_H(0.6958807111f), SC_H(0.6784504056f),
     SC_H(0.6326373219f), SC_H(0.5847306848f), SC_H(0.4999999702f),
     SC_H(0.3205464482f), SC_H(0.0500000045f)},
    {SC_H(0.7830305696f), SC_H(0.7733067870f), SC_H(0.7582961321f),
     SC_H(0.7194055915f), SC_H(0.6797705293f), SC_H(0.6131368876f),
     SC_H(0.4997332692f), SC_H(0.6934193969f)},
    {SC_H(0.8457261920f), SC_H(0.8377274871f), SC_H(0.8254694939f),
     SC_H(0.7942851782f), SC_H(0.7635439038f), SC_H(0.7152527571f),
     SC_H(0.6567122936f), SC_H(0.8229061961f)},
    {SC_H(0.8940021992f), SC_H(0.8877248168f), SC_H(0.8781855106f),
     SC_H(0.8544237614f), SC_H(0.8318918347f), SC_H(0.7992399335f),
     SC_H(0.7751275301f), SC_H(0.8853276968f)},
    {SC_H(0.9290818572f), SC_H(0.9243524075f), SC_H(0.9172304869f),
     SC_H(0.8998877406f), SC_H(0.8841174841f), SC_H(0.8631930947f),
     SC_H(0.8565139771f), SC_H(0.9251161218f)},
    {SC_H(0.9534626007f), SC_H(0.9500193000f), SC_H(0.9448821545f),
     SC_H(0.9326565266f), SC_H(0.9220023751f), SC_H(0.9090909362f),
     SC_H(0.9096591473f), SC_H(0.9514584541f)},
    {SC_H(0.9758449197f), SC_H(0.9738122821f), SC_H(0.9708200693f),
     SC_H(0.9639287591f), SC_H(0.9582763910f), SC_H(0.9522733092f),
     SC_H(0.9553207159f), SC_H(0.9750427008f)},
    {SC_H(0.9876723289f), SC_H(0.9865267277f), SC_H(0.9848603010f),
     SC_H(0.9811310172f), SC_H(0.9782302976f), SC_H(0.9754966497f),
     SC_H(0.9779621363f), SC_H(0.9873252511f)},
    {SC_H(0.9937641621f), SC_H(0.9931397438f), SC_H(0.9922404289f),
     SC_H(0.9902750254f), SC_H(0.9888116717f), SC_H(0.9875672460f),
     SC_H(0.9891131520f), SC_H(0.9936066866f)},
    {SC_H(0.9968600869f), SC_H(0.9965277910f), SC_H(0.9960530400f),
     SC_H(0.9950347543f), SC_H(0.9943022728f), SC_H(0.9937300086f),
     SC_H(0.9946073294f), SC_H(0.9967863560f)},
    {SC_H(0.9984226227f), SC_H(0.9982488155f), SC_H(0.9980020523f),
     SC_H(0.9974802136f), SC_H(0.9971146584f), SC_H(0.9968476892f),
     SC_H(0.9973216057f), SC_H(0.9983873963f)},
    {SC_H(0.9995003939f), SC_H(0.9994428754f), SC_H(0.9993617535f),
     SC_H(0.9991930723f), SC_H(0.9990783334f), SC_H(0.9990010262f),
     SC_H(0.9991616607f), SC_H(0.9994897842f)},
    {SC_H(0.9998419285f), SC_H(0.9998232722f), SC_H(0.9997970462f),
     SC_H(0.9997430444f), SC_H(0.9997069836f), SC_H(0.9996838570f),
     SC_H(0.9997364879f), SC_H(0.9998386502f)},
    {SC_H(0.9999499917f), SC_H(0.9999440312f), SC_H(0.9999356270f),
     SC_H(0.9999184012f), SC_H(0.9999070764f), SC_H(0.9998999834f),
     SC_H(0.9999169707f), SC_H(0.9999489784f)},
    {SC_H(0.9999842048f), SC_H(0.9999822974f), SC_H(0.9999796152f),
     SC_H(0.9999741912f), SC_H(0.9999706149f), SC_H(0.9999684095f),
     SC_H(0.9999738336f), SC_H(0.9999839067f)},
    /* { SC_H( 1.0000000000f), SC_H( 1.0000000000f), SC_H( 1.0000000000f),
       SC_H( 1.0000000000f), SC_H( 1.0000000000f), SC_H( 1.0000000000f),
       SC_H( 1.0000000000f), SC_H( 1.0000000000f)} */
    {FX_DBL2FX_CFG(MAXVAL_DBL), FX_DBL2FX_CFG(MAXVAL_DBL),
     FX_DBL2FX_CFG(MAXVAL_DBL), FX_DBL2FX_CFG(MAXVAL_DBL),
     FX_DBL2FX_CFG(MAXVAL_DBL), FX_DBL2FX_CFG(MAXVAL_DBL),
     FX_DBL2FX_CFG(MAXVAL_DBL), FX_DBL2FX_CFG(MAXVAL_DBL)}};
const DATA_TYPE_H H12_nc[31][8] = {
    {SC_H(0.0000000000f), SC_H(0.0000000110f), SC_H(0.0000000171f),
     SC_H(0.0000000253f), SC_H(0.0000000294f), SC_H(0.0000000316f),
     SC_H(0.0000000256f), SC_H(0.0000000045f)},
    {SC_H(0.0000000000f), SC_H(0.0019540924f), SC_H(0.0030265113f),
     SC_H(0.0044795922f), SC_H(0.0052186525f), SC_H(0.0056232354f),
     SC_H(0.0045594489f), SC_H(0.0007977085f)},
    {SC_H(0.0000000000f), SC_H(0.0034606720f), SC_H(0.0053620986f),
     SC_H(0.0079446984f), SC_H(0.0092647560f), SC_H(0.0099989995f),
     SC_H(0.0081285369f), SC_H(0.0014247064f)},
    {SC_H(0.0000000000f), SC_H(0.0061091618f), SC_H(0.0094724922f),
     SC_H(0.0140600521f), SC_H(0.0164252054f), SC_H(0.0177771728f),
     SC_H(0.0145191532f), SC_H(0.0025531140f)},
    {SC_H(0.0000000000f), SC_H(0.0107228858f), SC_H(0.0166464616f),
     SC_H(0.0247849934f), SC_H(0.0290434174f), SC_H(0.0315911844f),
     SC_H(0.0260186065f), SC_H(0.0046027615f)},
    {SC_H(0.0000000000f), SC_H(0.0186282862f), SC_H(0.0289774220f),
     SC_H(0.0433696397f), SC_H(0.0510888547f), SC_H(0.0560568646f),
     SC_H(0.0468755551f), SC_H(0.0083869267f)},
    {SC_H(0.0000000000f), SC_H(0.0257363543f), SC_H(0.0401044972f),
     SC_H(0.0602979437f), SC_H(0.0713650510f), SC_H(0.0789347738f),
     SC_H(0.0669798329f), SC_H(0.0121226767f)},
    {SC_H(0.0000000000f), SC_H(0.0352233723f), SC_H(0.0550108925f),
     SC_H(0.0832019597f), SC_H(0.0990892947f), SC_H(0.1108068749f),
     SC_H(0.0960334241f), SC_H(0.0176920593f)},
    {SC_H(0.0000000000f), SC_H(0.0475566536f), SC_H(0.0744772255f),
     SC_H(0.1134835035f), SC_H(0.1362429112f), SC_H(0.1546057910f),
     SC_H(0.1381545961f), SC_H(0.0261824392f)},
    {SC_H(0.0000000000f), SC_H(0.0629518181f), SC_H(0.0989024863f),
     SC_H(0.1520351619f), SC_H(0.1843357086f), SC_H(0.2131874412f),
     SC_H(0.1990868896f), SC_H(0.0395608991f)},
    {SC_H(0.0000000000f), SC_H(0.0809580907f), SC_H(0.1276271492f),
     SC_H(0.1980977356f), SC_H(0.2429044843f), SC_H(0.2874797881f),
     SC_H(0.2856767476f), SC_H(0.0617875643f)},
    {SC_H(0.0000000000f), SC_H(0.0936254337f), SC_H(0.1479234397f),
     SC_H(0.2310739607f), SC_H(0.2855334580f), SC_H(0.3436433673f),
     SC_H(0.3599678576f), SC_H(0.0857512727f)},
    {SC_H(0.0000000000f), SC_H(0.1057573780f), SC_H(0.1674221754f),
     SC_H(0.2630588412f), SC_H(0.3274079263f), SC_H(0.4005688727f),
     SC_H(0.4454404712f), SC_H(0.1242370531f)},
    {SC_H(0.0000000000f), SC_H(0.1160409302f), SC_H(0.1839915067f),
     SC_H(0.2904545665f), SC_H(0.3636667728f), SC_H(0.4512939751f),
     SC_H(0.5328993797f), SC_H(0.1951362640f)},
    {SC_H(0.0000000000f), SC_H(0.1230182052f), SC_H(0.1952532977f),
     SC_H(0.3091802597f), SC_H(0.3886501491f), SC_H(0.4870318770f),
     SC_H(0.6028295755f), SC_H(0.3637395203f)},
    {SC_H(0.0000000000f), SC_H(0.1254990250f), SC_H(0.1992611140f),
     SC_H(0.3158638775f), SC_H(0.3976053298f), SC_H(0.5000000000f),
     SC_H(0.6302776933f), SC_H(0.7053368092f)},
    {SC_H(0.0000000000f), SC_H(0.1230182052f), SC_H(0.1952533126f),
     SC_H(0.3091802597f), SC_H(0.3886501491f), SC_H(0.4870319068f),
     SC_H(0.6028295755f), SC_H(0.3637394905f)},
    {SC_H(0.0000000000f), SC_H(0.1160409302f), SC_H(0.1839915216f),
     SC_H(0.2904545665f), SC_H(0.3636668026f), SC_H(0.4512939751f),
     SC_H(0.5328993797f), SC_H(0.1951362044f)},
    {SC_H(0.0000000000f), SC_H(0.1057573855f), SC_H(0.1674221754f),
     SC_H(0.2630588710f), SC_H(0.3274079263f), SC_H(0.4005688727f),
     SC_H(0.4454405010f), SC_H(0.1242370382f)},
    {SC_H(0.0000000000f), SC_H(0.0936254337f), SC_H(0.1479234397f),
     SC_H(0.2310739607f), SC_H(0.2855334580f), SC_H(0.3436433673f),
     SC_H(0.3599678576f), SC_H(0.0857512653f)},
    {SC_H(0.0000000000f), SC_H(0.0809580907f), SC_H(0.1276271492f),
     SC_H(0.1980977207f), SC_H(0.2429044843f), SC_H(0.2874797881f),
     SC_H(0.2856767476f), SC_H(0.0617875606f)},
    {SC_H(0.0000000000f), SC_H(0.0629518107f), SC_H(0.0989024863f),
     SC_H(0.1520351619f), SC_H(0.1843357235f), SC_H(0.2131874412f),
     SC_H(0.1990868896f), SC_H(0.0395609401f)},
    {SC_H(0.0000000000f), SC_H(0.0475566462f), SC_H(0.0744772255f),
     SC_H(0.1134835184f), SC_H(0.1362429112f), SC_H(0.1546057761f),
     SC_H(0.1381545961f), SC_H(0.0261824802f)},
    {SC_H(0.0000000000f), SC_H(0.0352233797f), SC_H(0.0550108962f),
     SC_H(0.0832019448f), SC_H(0.0990892798f), SC_H(0.1108068526f),
     SC_H(0.0960334465f), SC_H(0.0176920686f)},
    {SC_H(0.0000000000f), SC_H(0.0257363524f), SC_H(0.0401044935f),
     SC_H(0.0602979474f), SC_H(0.0713650808f), SC_H(0.0789347589f),
     SC_H(0.0669797957f), SC_H(0.0121226516f)},
    {SC_H(0.0000000000f), SC_H(0.0186282881f), SC_H(0.0289774258f),
     SC_H(0.0433696248f), SC_H(0.0510888547f), SC_H(0.0560568906f),
     SC_H(0.0468755886f), SC_H(0.0083869714f)},
    {SC_H(0.0000000000f), SC_H(0.0107228830f), SC_H(0.0166464727f),
     SC_H(0.0247849822f), SC_H(0.0290434249f), SC_H(0.0315911621f),
     SC_H(0.0260186475f), SC_H(0.0046027377f)},
    {SC_H(0.0000000000f), SC_H(0.0061091576f), SC_H(0.0094724894f),
     SC_H(0.0140600465f), SC_H(0.0164251942f), SC_H(0.0177771524f),
     SC_H(0.0145191504f), SC_H(0.0025530567f)},
    {SC_H(0.0000000000f), SC_H(0.0034606743f), SC_H(0.0053620976f),
     SC_H(0.0079446994f), SC_H(0.0092647672f), SC_H(0.0099990256f),
     SC_H(0.0081285043f), SC_H(0.0014247177f)},
    {SC_H(0.0000000000f), SC_H(0.0019540912f), SC_H(0.0030265225f),
     SC_H(0.0044795908f), SC_H(0.0052186381f), SC_H(0.0056232223f),
     SC_H(0.0045594289f), SC_H(0.0007977359f)},
    {SC_H(0.0000000000f), SC_H(0.0000000149f), SC_H(0.0000000298f),
     SC_H(0.0000000298f), SC_H(0.0000000000f), SC_H(0.0000000596f),
     SC_H(0.0000000000f), SC_H(0.0000000000f)}};

/*
  for (i=0; i<31; i++) {
    cld = dequantCLD[i];
    val = (float)(FDKexp(cld/dbe)/(1+FDKexp(cld/dbe)));
    val = (float)(dbe*FDKlog(val));
  }
*/
#define SCALE_CLD_C1C2(a) (FL2FXCONST_DBL(a / (float)(1 << SF_CLD_C1C2)))
const FIXP_DBL dequantCLD_c1[31] = {SCALE_CLD_C1C2(-1.5000000000000000e+002f),
                                    SCALE_CLD_C1C2(-4.5000137329101563e+001f),
                                    SCALE_CLD_C1C2(-4.0000434875488281e+001f),
                                    SCALE_CLD_C1C2(-3.5001373291015625e+001f),
                                    SCALE_CLD_C1C2(-3.0004341125488281e+001f),
                                    SCALE_CLD_C1C2(-2.5013711929321289e+001f),
                                    SCALE_CLD_C1C2(-2.2027315139770508e+001f),
                                    SCALE_CLD_C1C2(-1.9054332733154297e+001f),
                                    SCALE_CLD_C1C2(-1.6107742309570313e+001f),
                                    SCALE_CLD_C1C2(-1.3212384223937988e+001f),
                                    SCALE_CLD_C1C2(-1.0413927078247070e+001f),
                                    SCALE_CLD_C1C2(-8.6389207839965820e+000f),
                                    SCALE_CLD_C1C2(-6.9732279777526855e+000f),
                                    SCALE_CLD_C1C2(-5.4554042816162109e+000f),
                                    SCALE_CLD_C1C2(-4.1244258880615234e+000f),
                                    SCALE_CLD_C1C2(-3.0102999210357666e+000f),
                                    SCALE_CLD_C1C2(-2.1244258880615234e+000f),
                                    SCALE_CLD_C1C2(-1.4554045200347900e+000f),
                                    SCALE_CLD_C1C2(-9.7322785854339600e-001f),
                                    SCALE_CLD_C1C2(-6.3892036676406860e-001f),
                                    SCALE_CLD_C1C2(-4.1392669081687927e-001f),
                                    SCALE_CLD_C1C2(-2.1238386631011963e-001f),
                                    SCALE_CLD_C1C2(-1.0774217545986176e-001f),
                                    SCALE_CLD_C1C2(-5.4333221167325974e-002f),
                                    SCALE_CLD_C1C2(-2.7315950021147728e-002f),
                                    SCALE_CLD_C1C2(-1.3711934909224510e-002f),
                                    SCALE_CLD_C1C2(-4.3406565673649311e-003f),
                                    SCALE_CLD_C1C2(-1.3732088264077902e-003f),
                                    SCALE_CLD_C1C2(-4.3438826105557382e-004f),
                                    SCALE_CLD_C1C2(-1.3745666365139186e-004f),
                                    SCALE_CLD_C1C2(0.0000000000000000e+000f)};

/* sac_stp */
/* none scaled */
const FIXP_CFG BP__FDK[] = {FL2FXCONST_CFG(0.73919999599457),
                            FL2FXCONST_CFG(0.97909998893738),
                            FL2FXCONST_CFG(0.99930000305176)};

/* scaled with 26 bits */
const FIXP_CFG BP_GF__FDK[] = {
    FL2FXCONST_CFG(0.00000000643330), FL2FXCONST_CFG(0.00004396850232),
    FL2FXCONST_CFG(0.00087456948552), FL2FXCONST_CFG(0.00474648220243),
    FL2FXCONST_CFG(0.01717987244800), FL2FXCONST_CFG(0.04906742491073),
    FL2FXCONST_CFG(0.10569518656729), FL2FXCONST_CFG(0.21165767592653),
    FL2FXCONST_CFG(0.36036762478024), FL2FXCONST_CFG(0.59894182766948),
    FL2FXCONST_CFG(0.81641678929129), FL2FXCONST_CFG(0.97418481133397),
    FL2FXCONST_CFG(0.99575411610845), FL2FXCONST_CFG(0.88842666281361),
    FL2FXCONST_CFG(0.79222317063736), FL2FXCONST_CFG(0.70828604318604),
    FL2FXCONST_CFG(0.66395054816338), FL2FXCONST_CFG(0.64633739516952),
    FL2FXCONST_CFG(0.66098278185255)};

/* sac_bitdec */
const INT samplingFreqTable[16] = {96000, 88200, 64000, 48000, 44100, 32000,
                                   24000, 22050, 16000, 12000, 11025, 8000,
                                   7350,  0,     0,     0};

const UCHAR freqResTable[] = {0, 28, 20, 14, 10, 7, 5, 4};

const UCHAR freqResTable_LD[] = {0, 23, 15, 12, 9, 7, 5, 4};

const UCHAR tempShapeChanTable[][8] = {{5, 5, 4, 6, 6, 4, 4, 2},
                                       {5, 5, 5, 7, 7, 4, 4, 2}};

const TREEPROPERTIES treePropertyTable[] = {
    {1, 6, 5, 0, {0, 0, 0, 0, 1}}, {1, 6, 5, 0, {0, 0, 1, 0, 0}},
    {2, 6, 3, 1, {1, 0, 0, 0, 0}}, {2, 8, 5, 1, {1, 0, 0, 0, 0}},
    {2, 8, 5, 1, {1, 0, 0, 0, 0}}, {6, 8, 2, 0, {0, 0, 0, 0, 0}},
    {6, 8, 2, 0, {0, 0, 0, 0, 0}}, {1, 2, 1, 0, {0, 0, 0, 0, 0}}};

const SCHAR kernels_4_to_71[MAX_HYBRID_BANDS] = {
    0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3};

const SCHAR kernels_5_to_71[MAX_HYBRID_BANDS] = {
    0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4};

const SCHAR kernels_7_to_71[MAX_HYBRID_BANDS] = {
    0, 0, 0, 0, 0, 0, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6};

const SCHAR kernels_10_to_71[MAX_HYBRID_BANDS] = {
    0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 7, 7, 7, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
    9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
    9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
    9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
    9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9};

const SCHAR kernels_14_to_71[MAX_HYBRID_BANDS] = {
    0,  0,  0,  0,  1,  1,  2,  3,  4,  4,  5,  6,  6,  7,  7,  8,  8,
    8,  9,  9,  9,  10, 10, 10, 10, 11, 11, 11, 11, 11, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13};

const SCHAR kernels_20_to_71[MAX_HYBRID_BANDS] = {
    0,  0,  1,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14,
    14, 15, 15, 15, 16, 16, 16, 16, 17, 17, 17, 17, 17, 18, 18, 18, 18,
    18, 18, 18, 18, 18, 18, 18, 18, 19, 19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19};

const SCHAR kernels_28_to_71[MAX_HYBRID_BANDS] = {
    0,  0,  1,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14,
    15, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21, 21, 22, 22, 22, 23,
    23, 23, 23, 24, 24, 24, 24, 24, 25, 25, 25, 25, 25, 25, 26, 26, 26,
    26, 26, 26, 26, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27};

const SCHAR kernels_4_to_64[MAX_HYBRID_BANDS] = {
    0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3};

const SCHAR kernels_5_to_64[MAX_HYBRID_BANDS] = {
    0, 1, 1, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4};

const SCHAR kernels_7_to_64[MAX_HYBRID_BANDS] = {
    0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6};

const SCHAR kernels_9_to_64[MAX_HYBRID_BANDS] = {
    0, 1, 2, 3, 3, 4, 4, 5, 5, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
    8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};

const SCHAR kernels_12_to_64[MAX_HYBRID_BANDS] = {
    0,  1,  2,  3,  4,  4,  5,  5,  6,  6,  6,  7,  7,  7,  8,  8,  8,  8,  9,
    9,  9,  9,  9,  10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11};

const SCHAR kernels_15_to_64[MAX_HYBRID_BANDS] = {
    0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  9,  10, 10, 10, 11, 11, 11, 11, 12,
    12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14};

const SCHAR kernels_23_to_64[MAX_HYBRID_BANDS] = {
    0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 12, 13, 13, 14, 14, 15,
    15, 16, 16, 16, 17, 17, 17, 18, 18, 18, 18, 19, 19, 19, 19, 19, 20, 20, 20,
    20, 20, 20, 21, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22};

const UCHAR mapping_15_to_23[MAX_PARAMETER_BANDS_LD] = {
    0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  9, 10,
    10, 11, 11, 12, 12, 13, 13, 13, 14, 14, 14};

const UCHAR mapping_12_to_23[MAX_PARAMETER_BANDS_LD] = {
    0, 1, 2, 3, 4, 4, 5, 5, 6, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 10, 11, 11, 11};

const UCHAR mapping_9_to_23[MAX_PARAMETER_BANDS_LD] = {
    0, 1, 2, 3, 3, 4, 4, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8};

const UCHAR mapping_7_to_23[MAX_PARAMETER_BANDS_LD] = {
    0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6};

const UCHAR mapping_5_to_23[MAX_PARAMETER_BANDS_LD] = {
    0, 1, 1, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4};

const UCHAR mapping_4_to_23[MAX_PARAMETER_BANDS_LD] = {
    0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3};

const FIXP_CFG clipGainTable__FDK[] = {
    /*CLIP_PROTECT_GAIN_0(1.000000f)*/ FX_DBL2FX_CFG(MAXVAL_DBL),
    CLIP_PROTECT_GAIN_1(1.189207f),
    CLIP_PROTECT_GAIN_1(1.414213f),
    CLIP_PROTECT_GAIN_1(1.681792f),
    /*CLIP_PROTECT_GAIN_1(2.000000f)*/ FX_DBL2FX_CFG(MAXVAL_DBL),
    CLIP_PROTECT_GAIN_2(2.378414f),
    CLIP_PROTECT_GAIN_2(2.828427f),
    /*CLIP_PROTECT_GAIN_2(4.000000f)*/ FX_DBL2FX_CFG(MAXVAL_DBL)};

const UCHAR clipGainSFTable__FDK[] = {0, 1, 1, 1, 1, 2, 2, 2};

const UCHAR pbStrideTable[] = {1, 2, 5, 28};

const int smgTimeTable[] = {64, 128, 256, 512};

/* table is scaled by factor 0.5 */
const FIXP_CFG envShapeDataTable__FDK[5][2] = {
    {FL2FXCONST_CFG(0.25000000000000f), FL2FXCONST_CFG(0.25000000000000f)},
    {FL2FXCONST_CFG(0.35355339059327f), FL2FXCONST_CFG(0.31498026247372f)},
    {FL2FXCONST_CFG(0.50000000000000f), FL2FXCONST_CFG(0.39685026299205f)},
    {FL2FXCONST_CFG(0.70710678118655f), FL2FXCONST_CFG(0.50000000000000f)},
    {/*FL2FXCONST_CFG( 1.00000000000000f)*/ FX_DBL2FX_CFG(MAXVAL_DBL),
     FL2FXCONST_CFG(0.62996052494744f)}};

/* sac_calcM1andM2 */
const SCHAR row2channelSTP[][MAX_M2_INPUT] = {{0, 1}, {0, 3}, {0, 2},  {0, 4},
                                              {0, 4}, {0, 2}, {-1, 2}, {0, 1}};

const SCHAR row2channelGES[][MAX_M2_INPUT] = {{0, 1}, {0, 3}, {0, 3},  {0, 5},
                                              {0, 5}, {0, 2}, {-1, 2}, {0, 1}};

const SCHAR row2residual[][MAX_M2_INPUT] = {{-1, 0},  {-1, 0},  {-1, -1},
                                            {-1, -1}, {-1, -1}, {-1, -1},
                                            {-1, -1}, {-1, 0}};

/*******************************************************************************
 Functionname: sac_getCLDValues
 *******************************************************************************

 Description: Get CLD values from table index.

 Arguments:
   index: Table index
   *cu, *cl : Pointer to locations where resulting values will be written to.

 Return: nothing

*******************************************************************************/
void SpatialDequantGetCLDValues(int index, FIXP_DBL* cu, FIXP_DBL* cl) {
  *cu = FX_CFG2FX_DBL(dequantCLD_c_l[index]);
  *cl = FX_CFG2FX_DBL(dequantCLD_c_l[31 - 1 - index]);
}

void SpatialDequantGetCLD2Values(int idx, FIXP_DBL* x) {
  *x = FX_CFG2FX_DBL(dequantCLD__FDK[idx]);
}
