/* $Id: xkbtoscan.h $ */
/** @file
 * VBox/Frontends/Common - X11 keyboard driver translation tables (XT scan
 *                         code mappings for XKB key names).
 */

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

/*
 * Oracle LGPL Disclaimer: For the avoidance of doubt, except that if any license choice
 * other than GPL or LGPL is available it will apply instead, Oracle elects to use only
 * the Lesser General Public License version 2.1 (LGPLv2) at this time for any software where
 * a choice of LGPL license versions is made available with the language indicating
 * that LGPLv2 or any later version may be used, or where a choice of which version
 * of the LGPL is applied is otherwise unspecified.
 */

#ifndef ___VBox_keyboard_tables_h
# error This file must be included from within keyboard-tables.h
#endif /* ___VBox_keyboard_tables_h */

enum { XKB_NAME_SIZE = 4 };

/**
 * This table contains a list of mappings of XKB key names to XT scan codes.
 */
struct
{
    const char cszName[XKB_NAME_SIZE];
    unsigned uScan;
} const xkbMap[] =
{
    { { 'E', 'S', 'C',  0  }, 0x1 },
    { { 'A', 'E', '0', '1' }, 0x2 },
    { { 'A', 'E', '0', '2' }, 0x3 },
    { { 'A', 'E', '0', '3' }, 0x4 },
    { { 'A', 'E', '0', '4' }, 0x5 },
    { { 'A', 'E', '0', '5' }, 0x6 },
    { { 'A', 'E', '0', '6' }, 0x7 },
    { { 'A', 'E', '0', '7' }, 0x8 },
    { { 'A', 'E', '0', '8' }, 0x9 },
    { { 'A', 'E', '0', '9' }, 0xa },
    { { 'A', 'E', '1', '0' }, 0xb },
    { { 'A', 'E', '1', '1' }, 0xc },
    { { 'A', 'E', '1', '2' }, 0xd },
    { { 'B', 'K', 'S', 'P' }, 0xe },
    { { 'T', 'A', 'B',  0  }, 0xf },
    { { 'A', 'D', '0', '1' }, 0x10 },
    { { 'A', 'D', '0', '2' }, 0x11 },
    { { 'A', 'D', '0', '3' }, 0x12 },
    { { 'A', 'D', '0', '4' }, 0x13 },
    { { 'A', 'D', '0', '5' }, 0x14 },
    { { 'A', 'D', '0', '6' }, 0x15 },
    { { 'A', 'D', '0', '7' }, 0x16 },
    { { 'A', 'D', '0', '8' }, 0x17 },
    { { 'A', 'D', '0', '9' }, 0x18 },
    { { 'A', 'D', '1', '0' }, 0x19 },
    { { 'A', 'D', '1', '1' }, 0x1a },
    { { 'A', 'D', '1', '2' }, 0x1b },
    { { 'R', 'T', 'R', 'N' }, 0x1c },
    { { 'L', 'C', 'T', 'L' }, 0x1d },
    { { 'A', 'C', '0', '1' }, 0x1e },
    { { 'A', 'C', '0', '2' }, 0x1f },
    { { 'A', 'C', '0', '3' }, 0x20 },
    { { 'A', 'C', '0', '4' }, 0x21 },
    { { 'A', 'C', '0', '5' }, 0x22 },
    { { 'A', 'C', '0', '6' }, 0x23 },
    { { 'A', 'C', '0', '7' }, 0x24 },
    { { 'A', 'C', '0', '8' }, 0x25 },
    { { 'A', 'C', '0', '9' }, 0x26 },
    { { 'A', 'C', '1', '0' }, 0x27 },
    { { 'A', 'C', '1', '1' }, 0x28 },
    { { 'A', 'C', '1', '2' }, 0x2b },
    { { 'T', 'L', 'D', 'E' }, 0x29 },
    { { 'L', 'F', 'S', 'H' }, 0x2a },
    { { 'B', 'K', 'S', 'L' }, 0x2b },
    { { 'A', 'B', '0', '1' }, 0x2c },
    { { 'A', 'B', '0', '2' }, 0x2d },
    { { 'A', 'B', '0', '3' }, 0x2e },
    { { 'A', 'B', '0', '4' }, 0x2f },
    { { 'A', 'B', '0', '5' }, 0x30 },
    { { 'A', 'B', '0', '6' }, 0x31 },
    { { 'A', 'B', '0', '7' }, 0x32 },
    { { 'A', 'B', '0', '8' }, 0x33 },
    { { 'A', 'B', '0', '9' }, 0x34 },
    { { 'A', 'B', '1', '0' }, 0x35 },
    { { 'R', 'T', 'S', 'H' }, 0x36 },
    { { 'K', 'P', 'M', 'U' }, 0x37 },
    { { 'L', 'A', 'L', 'T' }, 0x38 },
    { { 'S', 'P', 'C', 'E' }, 0x39 },
    { { 'C', 'A', 'P', 'S' }, 0x3a },
    { { 'F', 'K', '0', '1' }, 0x3b },
    { { 'F', 'K', '0', '2' }, 0x3c },
    { { 'F', 'K', '0', '3' }, 0x3d },
    { { 'F', 'K', '0', '4' }, 0x3e },
    { { 'F', 'K', '0', '5' }, 0x3f },
    { { 'F', 'K', '0', '6' }, 0x40 },
    { { 'F', 'K', '0', '7' }, 0x41 },
    { { 'F', 'K', '0', '8' }, 0x42 },
    { { 'F', 'K', '0', '9' }, 0x43 },
    { { 'F', 'K', '1', '0' }, 0x44 },
    { { 'N', 'M', 'L', 'K' }, 0x45 },
    { { 'S', 'C', 'L', 'K' }, 0x46 },
    { { 'K', 'P', '7',  0  }, 0x47 },
    { { 'K', 'P', '8',  0  }, 0x48 },
    { { 'K', 'P', '9',  0  }, 0x49 },
    { { 'K', 'P', 'S', 'U' }, 0x4a },
    { { 'K', 'P', '4',  0  }, 0x4b },
    { { 'K', 'P', '5',  0  }, 0x4c },
    { { 'K', 'P', '6',  0  }, 0x4d },
    { { 'K', 'P', 'A', 'D' }, 0x4e },
    { { 'K', 'P', '1',  0  }, 0x4f },
    { { 'K', 'P', '2',  0  }, 0x50 },
    { { 'K', 'P', '3',  0  }, 0x51 },
    { { 'K', 'P', '0',  0  }, 0x52 },
    { { 'K', 'P', 'D', 'L' }, 0x53 },
    { { 'K', 'P', 'P', 'T' }, 0x7e },
    { { 'L', 'V', 'L', '3' }, 0x138 },
    { { 'L', 'S', 'G', 'T' }, 0x56 },
    { { 'F', 'K', '1', '1' }, 0x57 },
    { { 'F', 'K', '1', '2' }, 0x58 },
    { { 'A', 'B', '1', '1' }, 0x73 },
    { { 'K', 'A', 'T', 'A' }, 0x0 },
    { { 'H', 'I', 'R', 'A' }, 0x0 },
    { { 'H', 'E', 'N', 'K' }, 0x79 },
    { { 'H', 'K', 'T', 'G' }, 0x70 },
    { { 'M', 'U', 'H', 'E' }, 0x7b },
    { { 'H', 'Z', 'T', 'G' }, 0x29 },
    { { 'J', 'P', 'C', 'M' }, 0x0 },
    { { 'K', 'P', 'E', 'N' }, 0x11c },
    { { 'R', 'C', 'T', 'L' }, 0x11d },
    { { 'K', 'P', 'D', 'V' }, 0x135 },
    { { 'P', 'R', 'S', 'C' }, 0x137 },
    { { 'R', 'A', 'L', 'T' }, 0x138 },
    { { 'A', 'L', 'G', 'R' }, 0x138 },
    { { 'L', 'N', 'F', 'D' }, 0x0 },
    { { 'H', 'O', 'M', 'E' }, 0x147 },
    { { 'U', 'P',  0 ,  0  }, 0x148 },
    { { 'P', 'G', 'U', 'P' }, 0x149 },
    { { 'L', 'E', 'F', 'T' }, 0x14b },
    { { 'R', 'G', 'H', 'T' }, 0x14d },
    { { 'E', 'N', 'D',  0  }, 0x14f },
    { { 'D', 'O', 'W', 'N' }, 0x150 },
    { { 'P', 'G', 'D', 'N' }, 0x151 },
    { { 'I', 'N', 'S',  0  }, 0x152 },
    { { 'D', 'E', 'L', 'E' }, 0x153 },
    { { 'I', '1', '2', '0' }, 0x0 },
    { { 'M', 'U', 'T', 'E' }, 0x120 },
    { { 'V', 'O', 'L', '-' }, 0x12e },
    { { 'V', 'O', 'L', '+' }, 0x130 },
    { { 'P', 'O', 'W', 'R' }, 0x15e },
    { { 'K', 'P', 'E', 'Q' }, 0x0 },
    { { 'I', '1', '2', '6' }, 0x0 },
    { { 'P', 'A', 'U', 'S' }, 0x145 },
    { { 'I', '1', '2', '8' }, 0x0 },
    { { 'I', '1', '2', '9' }, 0x7e },
    { { 'K', 'P', 'P', 'T' }, 0x7e },
    { { 'H', 'N', 'G', 'L' }, 0xf2 },
    { { 'H', 'J', 'C', 'V' }, 0xf1 },
    { { 'A', 'E', '1', '3' }, 0x7d },
    { { 'L', 'W', 'I', 'N' }, 0x15b },
    { { 'L', 'M', 'T', 'A' }, 0x15b },
    { { 'R', 'W', 'I', 'N' }, 0x15c },
    { { 'R', 'M', 'T', 'A' }, 0x15c },
    { { 'C', 'O', 'M', 'P' }, 0x15d },
    { { 'M', 'E', 'N', 'U' }, 0x15d },
    { { 'S', 'T', 'O', 'P' }, 0x168 },
    { { 'A', 'G', 'A', 'I' }, 0x105 },
    { { 'P', 'R', 'O', 'P' }, 0x106 },
    { { 'U', 'N', 'D', 'O' }, 0x107 },
    { { 'F', 'R', 'N', 'T' }, 0x10c },
    { { 'C', 'O', 'P', 'Y' }, 0x118 },
    { { 'O', 'P', 'E', 'N' }, 0x65 },
    { { 'P', 'A', 'S', 'T' }, 0x10a },
    { { 'F', 'I', 'N', 'D' }, 0x110 },
    { { 'C', 'U', 'T',  0  }, 0x117 },
    { { 'H', 'E', 'L', 'P' }, 0x175 },
    { { 'I', '1', '4', '7' }, 0x0 },
    { { 'I', '1', '4', '8' }, 0x0 },
    { { 'I', '1', '4', '9' }, 0x0 },
    { { 'I', '1', '5', '0' }, 0x15f },
    { { 'I', '1', '5', '1' }, 0x163 },
    { { 'I', '1', '5', '2' }, 0x0 },
    { { 'I', '1', '5', '3' }, 0x119 },
    { { 'I', '1', '5', '4' }, 0x0 },
    { { 'I', '1', '5', '5' }, 0x0 },
    { { 'I', '1', '5', '6' }, 0x0 },
    { { 'I', '1', '5', '7' }, 0x0 },
    { { 'I', '1', '5', '8' }, 0x0 },
    { { 'I', '1', '5', '9' }, 0x0 },
    { { 'I', '1', '6', '0' }, 0x120 },
    { { 'I', '1', '6', '1' }, 0x0 },
    { { 'I', '1', '6', '2' }, 0x122 },
    { { 'I', '1', '6', '3' }, 0x16c },
    { { 'I', '1', '6', '4' }, 0x124 },
    { { 'I', '1', '6', '5' }, 0x15f },
    { { 'I', '1', '6', '6' }, 0x16a },
    { { 'I', '1', '6', '7' }, 0x169 },
    { { 'I', '1', '6', '8' }, 0x0 },
    { { 'I', '1', '6', '9' }, 0x0 },
    { { 'I', '1', '7', '0' }, 0x0 },
    { { 'I', '1', '7', '1' }, 0x119 },
    { { 'I', '1', '7', '2' }, 0x122 },
    { { 'I', '1', '7', '3' }, 0x110 },
    { { 'I', '1', '7', '4' }, 0x12e },
    { { 'I', '1', '7', '5' }, 0x0 },
    { { 'I', '1', '7', '6' }, 0x130 },
    { { 'I', '1', '7', '7' }, 0x0 },
    { { 'I', '1', '7', '8' }, 0x0 },
    { { 'I', '1', '7', '9' }, 0x0 },
    { { 'I', '1', '8', '0' }, 0x132 },
    { { 'I', '1', '8', '1' }, 0x167 },
    { { 'I', '1', '8', '2' }, 0x140 },
    { { 'I', '1', '8', '3' }, 0x0 },
    { { 'I', '1', '8', '4' }, 0x0 },
    { { 'I', '1', '8', '5' }, 0x10b },
    { { 'I', '1', '8', '6' }, 0x18b },
    { { 'I', '1', '8', '7' }, 0x0 },
    { { 'I', '1', '8', '8' }, 0x0 },
    { { 'I', '1', '8', '9' }, 0x0 },
    { { 'I', '1', '9', '0' }, 0x105 },
    { { 'F', 'K', '1', '3' }, 0x0 },
    { { 'F', 'K', '1', '4' }, 0x0 },
    { { 'F', 'K', '1', '5' }, 0x0 },
    { { 'F', 'K', '1', '6' }, 0x0 },
    { { 'F', 'K', '1', '7' }, 0x0 },
    { { 'F', 'K', '1', '8' }, 0x0 },
    { { 'F', 'K', '1', '9' }, 0x0 },
    { { 'F', 'K', '2', '0' }, 0x0 },
    { { 'F', 'K', '2', '1' }, 0x0 },
    { { 'F', 'K', '2', '2' }, 0x0 },
    { { 'F', 'K', '2', '3' }, 0x0 },
    { { 'F', 'K', '2', '4' }, 0x0 },
    { { 'M', 'D', 'S', 'W' }, 0x138 },
    { { 'A', 'L', 'T',  0  }, 0x0 },
    { { 'M', 'E', 'T', 'A' }, 0x0 },
    { { 'S', 'U', 'P', 'R' }, 0x0 },
    { { 'H', 'Y', 'P', 'R' }, 0x0 },
    { { 'I', '2', '0', '8' }, 0x122 },
    { { 'I', '2', '0', '9' }, 0x122 },
    { { 'I', '2', '1', '0' }, 0x0 },
    { { 'I', '2', '1', '1' }, 0x0 },
    { { 'I', '2', '1', '2' }, 0x0 },
    { { 'I', '2', '1', '3' }, 0x0 },
    { { 'I', '2', '1', '4' }, 0x140 },
    { { 'I', '2', '1', '5' }, 0x122 },
    { { 'I', '2', '1', '6' }, 0x169 },
    { { 'I', '2', '1', '7' }, 0x0 },
    { { 'I', '2', '1', '8' }, 0x137 },
    { { 'I', '2', '1', '9' }, 0x0 },
    { { 'I', '2', '2', '0' }, 0x0 },
    { { 'I', '2', '2', '1' }, 0x0 },
    { { 'I', '2', '2', '2' }, 0x0 },
    { { 'I', '2', '2', '3' }, 0x0 },
    { { 'I', '2', '2', '4' }, 0x0 },
    { { 'I', '2', '2', '5' }, 0x165 },
    { { 'I', '2', '2', '6' }, 0x0 },
    { { 'I', '2', '2', '7' }, 0x0 },
    { { 'I', '2', '2', '8' }, 0x0 },
    { { 'I', '2', '2', '9' }, 0x165 },
    { { 'I', '2', '3', '0' }, 0x166 },
    { { 'I', '2', '3', '1' }, 0x167 },
    { { 'I', '2', '3', '2' }, 0x168 },
    { { 'I', '2', '3', '3' }, 0x169 },
    { { 'I', '2', '3', '4' }, 0x16a },
    { { 'I', '2', '3', '5' }, 0x16b },
    { { 'I', '2', '3', '6' }, 0x16c },
    { { 'I', '2', '3', '7' }, 0x16d },
    { { 'I', '2', '3', '8' }, 0x0 },
    { { 'I', '2', '3', '9' }, 0x143 },
    { { 'I', '2', '4', '0' }, 0x141 },
    { { 'I', '2', '4', '1' }, 0x0 },
    { { 'I', '2', '4', '2' }, 0x157 },
    { { 'I', '2', '4', '3' }, 0x105 },
    { { 'I', '2', '4', '4' }, 0x0 },
    { { 'I', '2', '4', '5' }, 0x0 },
    { { 'I', '2', '4', '6' }, 0x0 },
    { { 'I', '2', '4', '7' }, 0x0 },
    { { 'I', '2', '4', '8' }, 0x0 },
    { { 'I', '2', '4', '9' }, 0x0 },
    { { 'I', '2', '5', '0' }, 0x0 },
    { { 'I', '2', '5', '1' }, 0x0 },
    { { 'I', '2', '5', '2' }, 0x0 },
    { { 'I', '2', '5', '3' }, 0x0 }
};
