// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2022 The Sigstore Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package timestamp

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"io"
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/sigstore/timestamp-authority/v2/pkg/generated/models"
)

// GetTimestampResponseOKCode is the HTTP code returned for type GetTimestampResponseOK
const GetTimestampResponseOKCode int = 200

/*
GetTimestampResponseOK Returns a timestamp response and the location of the log entry in the transprency log

swagger:response getTimestampResponseOK
*/
type GetTimestampResponseOK struct {

	/*
	  In: Body
	*/
	Payload io.ReadCloser `json:"body,omitempty"`
}

// NewGetTimestampResponseOK creates GetTimestampResponseOK with default headers values
func NewGetTimestampResponseOK() *GetTimestampResponseOK {

	return &GetTimestampResponseOK{}
}

// WithPayload adds the payload to the get timestamp response o k response
func (o *GetTimestampResponseOK) WithPayload(payload io.ReadCloser) *GetTimestampResponseOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get timestamp response o k response
func (o *GetTimestampResponseOK) SetPayload(payload io.ReadCloser) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetTimestampResponseOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// GetTimestampResponseCreatedCode is the HTTP code returned for type GetTimestampResponseCreated
const GetTimestampResponseCreatedCode int = 201

/*
GetTimestampResponseCreated Returns a timestamp response and the location of the log entry in the transprency log

swagger:response getTimestampResponseCreated
*/
type GetTimestampResponseCreated struct {

	/*
	  In: Body
	*/
	Payload io.ReadCloser `json:"body,omitempty"`
}

// NewGetTimestampResponseCreated creates GetTimestampResponseCreated with default headers values
func NewGetTimestampResponseCreated() *GetTimestampResponseCreated {

	return &GetTimestampResponseCreated{}
}

// WithPayload adds the payload to the get timestamp response created response
func (o *GetTimestampResponseCreated) WithPayload(payload io.ReadCloser) *GetTimestampResponseCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get timestamp response created response
func (o *GetTimestampResponseCreated) SetPayload(payload io.ReadCloser) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetTimestampResponseCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	payload := o.Payload
	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// GetTimestampResponseBadRequestCode is the HTTP code returned for type GetTimestampResponseBadRequest
const GetTimestampResponseBadRequestCode int = 400

/*
GetTimestampResponseBadRequest The content supplied to the server was invalid

swagger:response getTimestampResponseBadRequest
*/
type GetTimestampResponseBadRequest struct {

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetTimestampResponseBadRequest creates GetTimestampResponseBadRequest with default headers values
func NewGetTimestampResponseBadRequest() *GetTimestampResponseBadRequest {

	return &GetTimestampResponseBadRequest{}
}

// WithPayload adds the payload to the get timestamp response bad request response
func (o *GetTimestampResponseBadRequest) WithPayload(payload *models.Error) *GetTimestampResponseBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get timestamp response bad request response
func (o *GetTimestampResponseBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetTimestampResponseBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetTimestampResponseNotImplementedCode is the HTTP code returned for type GetTimestampResponseNotImplemented
const GetTimestampResponseNotImplementedCode int = 501

/*
GetTimestampResponseNotImplemented The content requested is not implemented

swagger:response getTimestampResponseNotImplemented
*/
type GetTimestampResponseNotImplemented struct {
}

// NewGetTimestampResponseNotImplemented creates GetTimestampResponseNotImplemented with default headers values
func NewGetTimestampResponseNotImplemented() *GetTimestampResponseNotImplemented {

	return &GetTimestampResponseNotImplemented{}
}

// WriteResponse to the client
func (o *GetTimestampResponseNotImplemented) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) // Remove Content-Type on empty responses

	rw.WriteHeader(501)
}

/*
GetTimestampResponseDefault There was an internal error in the server while processing the request

swagger:response getTimestampResponseDefault
*/
type GetTimestampResponseDefault struct {
	_statusCode int

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetTimestampResponseDefault creates GetTimestampResponseDefault with default headers values
func NewGetTimestampResponseDefault(code int) *GetTimestampResponseDefault {
	if code <= 0 {
		code = 500
	}

	return &GetTimestampResponseDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get timestamp response default response
func (o *GetTimestampResponseDefault) WithStatusCode(code int) *GetTimestampResponseDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get timestamp response default response
func (o *GetTimestampResponseDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithPayload adds the payload to the get timestamp response default response
func (o *GetTimestampResponseDefault) WithPayload(payload *models.Error) *GetTimestampResponseDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get timestamp response default response
func (o *GetTimestampResponseDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetTimestampResponseDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
