; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

declare void @use.i8(i8)
declare void @use.i16(i16)
define i1 @src_is_mask_zext(i16 %x_in, i8 %y) {
; CHECK-LABEL: @src_is_mask_zext(
; CHECK-NEXT:    [[M_IN:%.*]] = lshr i8 -1, [[Y:%.*]]
; CHECK-NEXT:    [[MASK:%.*]] = zext i8 [[M_IN]] to i16
; CHECK-NEXT:    [[TMP1:%.*]] = xor i16 [[X_IN:%.*]], 123
; CHECK-NEXT:    [[R:%.*]] = icmp ule i16 [[TMP1]], [[MASK]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i16 %x_in, 123
  %m_in = lshr i8 -1, %y
  %mask = zext i8 %m_in to i16

  %and = and i16 %x, %mask
  %r = icmp eq i16 %and, %x
  ret i1 %r
}

define i1 @src_is_mask_zext_fail_not_mask(i16 %x_in, i8 %y) {
; CHECK-LABEL: @src_is_mask_zext_fail_not_mask(
; CHECK-NEXT:    [[M_IN:%.*]] = lshr i8 -2, [[Y:%.*]]
; CHECK-NEXT:    [[MASK:%.*]] = zext i8 [[M_IN]] to i16
; CHECK-NEXT:    [[TMP1:%.*]] = xor i16 [[X_IN:%.*]], -124
; CHECK-NEXT:    [[TMP2:%.*]] = or i16 [[TMP1]], [[MASK]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i16 [[TMP2]], -1
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i16 %x_in, 123
  %m_in = lshr i8 -2, %y
  %mask = zext i8 %m_in to i16

  %and = and i16 %x, %mask
  %r = icmp eq i16 %and, %x
  ret i1 %r
}

define i1 @src_is_mask_sext(i16 %x_in, i8 %y) {
; CHECK-LABEL: @src_is_mask_sext(
; CHECK-NEXT:    [[X:%.*]] = xor i16 [[X_IN:%.*]], 123
; CHECK-NEXT:    [[TMP1:%.*]] = lshr i8 31, [[Y:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = zext nneg i8 [[TMP1]] to i16
; CHECK-NEXT:    [[R:%.*]] = icmp ule i16 [[X]], [[TMP2]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i16 %x_in, 123
  %m_in = lshr i8 31, %y
  %mask = sext i8 %m_in to i16
  %notmask = xor i16 %mask, -1

  %and = and i16 %notmask, %x
  %r = icmp eq i16 %and, 0
  ret i1 %r
}

define i1 @src_is_mask_sext_fail_multiuse(i16 %x_in, i8 %y) {
; CHECK-LABEL: @src_is_mask_sext_fail_multiuse(
; CHECK-NEXT:    [[X:%.*]] = xor i16 [[X_IN:%.*]], 122
; CHECK-NEXT:    [[M_IN:%.*]] = lshr i8 -1, [[Y:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = xor i8 [[M_IN]], -1
; CHECK-NEXT:    [[NOTMASK:%.*]] = sext i8 [[TMP1]] to i16
; CHECK-NEXT:    [[AND:%.*]] = and i16 [[X]], [[NOTMASK]]
; CHECK-NEXT:    call void @use.i16(i16 [[AND]])
; CHECK-NEXT:    [[R:%.*]] = icmp eq i16 [[AND]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i16 %x_in, 123
  %m_in = lshr i8 -1, %y
  %mask = sext i8 %m_in to i16
  %notmask = xor i16 %mask, -1

  %and = and i16 %notmask, %x
  call void @use.i16(i16 %and)
  %r = icmp eq i16 %and, 0
  ret i1 %r
}

define i1 @src_is_mask_and(i8 %x_in, i8 %y, i8 %z) {
; CHECK-LABEL: @src_is_mask_and(
; CHECK-NEXT:    [[MY:%.*]] = lshr i8 7, [[Y:%.*]]
; CHECK-NEXT:    [[MZ:%.*]] = lshr i8 -1, [[Z:%.*]]
; CHECK-NEXT:    [[MASK:%.*]] = and i8 [[MY]], [[MZ]]
; CHECK-NEXT:    [[TMP1:%.*]] = xor i8 [[X_IN:%.*]], 123
; CHECK-NEXT:    [[R:%.*]] = icmp ule i8 [[TMP1]], [[MASK]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i8 %x_in, 123
  %my = ashr i8 7, %y
  %mz = lshr i8 -1, %z
  %mask = and i8 %my, %mz

  %and = and i8 %x, %mask
  %r = icmp eq i8 %x, %and
  ret i1 %r
}

define i1 @src_is_mask_and_fail_mixed(i8 %x_in, i8 %y, i8 %z) {
; CHECK-LABEL: @src_is_mask_and_fail_mixed(
; CHECK-NEXT:    [[MY:%.*]] = ashr i8 -8, [[Y:%.*]]
; CHECK-NEXT:    [[MZ:%.*]] = lshr i8 -1, [[Z:%.*]]
; CHECK-NEXT:    [[MASK:%.*]] = and i8 [[MY]], [[MZ]]
; CHECK-NEXT:    [[TMP1:%.*]] = xor i8 [[X_IN:%.*]], -124
; CHECK-NEXT:    [[TMP2:%.*]] = or i8 [[MASK]], [[TMP1]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[TMP2]], -1
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i8 %x_in, 123
  %my = ashr i8 -8, %y
  %mz = lshr i8 -1, %z
  %mask = and i8 %my, %mz

  %and = and i8 %x, %mask
  %r = icmp eq i8 %x, %and
  ret i1 %r
}

define i1 @src_is_mask_or(i8 %x_in, i8 %y) {
; CHECK-LABEL: @src_is_mask_or(
; CHECK-NEXT:    [[MY:%.*]] = lshr i8 -1, [[Y:%.*]]
; CHECK-NEXT:    [[MASK:%.*]] = and i8 [[MY]], 7
; CHECK-NEXT:    [[TMP1:%.*]] = xor i8 [[X_IN:%.*]], 123
; CHECK-NEXT:    [[R:%.*]] = icmp ule i8 [[TMP1]], [[MASK]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i8 %x_in, 123
  %my = lshr i8 -1, %y
  %mask = and i8 %my, 7

  %and = and i8 %mask, %x
  %r = icmp eq i8 %x, %and
  ret i1 %r
}

define i1 @src_is_mask_xor(i8 %x_in, i8 %y) {
; CHECK-LABEL: @src_is_mask_xor(
; CHECK-NEXT:    [[Y_M1:%.*]] = add i8 [[Y:%.*]], -1
; CHECK-NEXT:    [[MASK:%.*]] = xor i8 [[Y_M1]], [[Y]]
; CHECK-NEXT:    [[TMP1:%.*]] = xor i8 [[X_IN:%.*]], 123
; CHECK-NEXT:    [[R:%.*]] = icmp ugt i8 [[TMP1]], [[MASK]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i8 %x_in, 123
  %y_m1 = add i8 %y, -1
  %mask = xor i8 %y, %y_m1
  %and = and i8 %x, %mask
  %r = icmp ne i8 %and, %x
  ret i1 %r
}

define i1 @src_is_mask_xor_fail_notmask(i8 %x_in, i8 %y) {
; CHECK-LABEL: @src_is_mask_xor_fail_notmask(
; CHECK-NEXT:    [[TMP1:%.*]] = sub i8 0, [[Y:%.*]]
; CHECK-NEXT:    [[NOTMASK:%.*]] = xor i8 [[TMP1]], [[Y]]
; CHECK-NEXT:    [[TMP2:%.*]] = xor i8 [[X_IN:%.*]], -124
; CHECK-NEXT:    [[TMP3:%.*]] = or i8 [[NOTMASK]], [[TMP2]]
; CHECK-NEXT:    [[R:%.*]] = icmp ne i8 [[TMP3]], -1
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i8 %x_in, 123
  %y_m1 = add i8 %y, -1
  %mask = xor i8 %y, %y_m1
  %notmask = xor i8 %mask, -1
  %and = and i8 %x, %notmask
  %r = icmp ne i8 %and, %x
  ret i1 %r
}

define i1 @src_is_mask_select(i8 %x_in, i8 %y, i1 %cond) {
; CHECK-LABEL: @src_is_mask_select(
; CHECK-NEXT:    [[Y_M1:%.*]] = add i8 [[Y:%.*]], -1
; CHECK-NEXT:    [[YMASK:%.*]] = xor i8 [[Y_M1]], [[Y]]
; CHECK-NEXT:    [[MASK:%.*]] = select i1 [[COND:%.*]], i8 [[YMASK]], i8 15
; CHECK-NEXT:    [[TMP1:%.*]] = xor i8 [[X_IN:%.*]], 123
; CHECK-NEXT:    [[R:%.*]] = icmp ugt i8 [[TMP1]], [[MASK]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i8 %x_in, 123
  %y_m1 = add i8 %y, -1
  %ymask = xor i8 %y, %y_m1
  %mask = select i1 %cond, i8 %ymask, i8 15

  %and = and i8 %mask, %x
  %r = icmp ne i8 %and, %x
  ret i1 %r
}

define i1 @src_is_mask_select_fail_wrong_pattern(i8 %x_in, i8 %y, i1 %cond, i8 %z) {
; CHECK-LABEL: @src_is_mask_select_fail_wrong_pattern(
; CHECK-NEXT:    [[X:%.*]] = xor i8 [[X_IN:%.*]], 123
; CHECK-NEXT:    [[Y_M1:%.*]] = add i8 [[Y:%.*]], -1
; CHECK-NEXT:    [[YMASK:%.*]] = xor i8 [[Y_M1]], [[Y]]
; CHECK-NEXT:    [[MASK:%.*]] = select i1 [[COND:%.*]], i8 [[YMASK]], i8 15
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[MASK]], [[X]]
; CHECK-NEXT:    [[R:%.*]] = icmp ne i8 [[AND]], [[Z:%.*]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i8 %x_in, 123
  %y_m1 = add i8 %y, -1
  %ymask = xor i8 %y, %y_m1
  %mask = select i1 %cond, i8 %ymask, i8 15

  %and = and i8 %mask, %x
  %r = icmp ne i8 %and, %z
  ret i1 %r
}

define i1 @src_is_mask_shl_lshr(i8 %x_in, i8 %y, i1 %cond) {
; CHECK-LABEL: @src_is_mask_shl_lshr(
; CHECK-NEXT:    [[X:%.*]] = xor i8 [[X_IN:%.*]], 122
; CHECK-NEXT:    [[TMP1:%.*]] = lshr i8 -1, [[Y:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp ugt i8 [[X]], [[TMP1]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i8 %x_in, 123
  %m_shl = shl i8 -1, %y
  %mask = lshr i8 %m_shl, %y
  %notmask = xor i8 %mask, -1

  %and = and i8 %x, %notmask
  %r = icmp ne i8 0, %and
  ret i1 %r
}

define i1 @src_is_mask_shl_lshr_fail_not_allones(i8 %x_in, i8 %y, i1 %cond) {
; CHECK-LABEL: @src_is_mask_shl_lshr_fail_not_allones(
; CHECK-NEXT:    [[TMP1:%.*]] = lshr i8 -1, [[Y:%.*]]
; CHECK-NEXT:    [[MASK:%.*]] = and i8 [[TMP1]], -2
; CHECK-NEXT:    [[TMP2:%.*]] = xor i8 [[X_IN:%.*]], -124
; CHECK-NEXT:    [[TMP3:%.*]] = or i8 [[TMP2]], [[MASK]]
; CHECK-NEXT:    [[R:%.*]] = icmp ne i8 [[TMP3]], -1
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i8 %x_in, 123
  %m_shl = shl i8 -2, %y
  %mask = lshr i8 %m_shl, %y
  %notmask = xor i8 %mask, -1

  %and = and i8 %x, %notmask
  %r = icmp ne i8 0, %and
  ret i1 %r
}

define i1 @src_is_mask_lshr(i8 %x_in, i8 %y, i8 %z, i1 %cond) {
; CHECK-LABEL: @src_is_mask_lshr(
; CHECK-NEXT:    [[Y_M1:%.*]] = add i8 [[Y:%.*]], -1
; CHECK-NEXT:    [[YMASK:%.*]] = xor i8 [[Y_M1]], [[Y]]
; CHECK-NEXT:    [[SMASK:%.*]] = select i1 [[COND:%.*]], i8 [[YMASK]], i8 15
; CHECK-NEXT:    [[MASK:%.*]] = lshr i8 [[SMASK]], [[Z:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = xor i8 [[X_IN:%.*]], 123
; CHECK-NEXT:    [[R:%.*]] = icmp ugt i8 [[TMP1]], [[MASK]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i8 %x_in, 123
  %y_m1 = add i8 %y, -1
  %ymask = xor i8 %y, %y_m1
  %smask = select i1 %cond, i8 %ymask, i8 15
  %mask = lshr i8 %smask, %z
  %and = and i8 %mask, %x
  %r = icmp ne i8 %x, %and
  ret i1 %r
}

define i1 @src_is_mask_ashr(i8 %x_in, i8 %y, i8 %z, i1 %cond) {
; CHECK-LABEL: @src_is_mask_ashr(
; CHECK-NEXT:    [[Y_M1:%.*]] = add i8 [[Y:%.*]], -1
; CHECK-NEXT:    [[YMASK:%.*]] = xor i8 [[Y_M1]], [[Y]]
; CHECK-NEXT:    [[SMASK:%.*]] = select i1 [[COND:%.*]], i8 [[YMASK]], i8 15
; CHECK-NEXT:    [[MASK:%.*]] = ashr i8 [[SMASK]], [[Z:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = xor i8 [[X_IN:%.*]], 123
; CHECK-NEXT:    [[R:%.*]] = icmp ugt i8 [[TMP1]], [[MASK]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i8 %x_in, 123
  %y_m1 = add i8 %y, -1
  %ymask = xor i8 %y, %y_m1
  %smask = select i1 %cond, i8 %ymask, i8 15
  %mask = ashr i8 %smask, %z
  %and = and i8 %x, %mask
  %r = icmp ult i8 %and, %x
  ret i1 %r
}

define i1 @src_is_mask_p2_m1(i8 %x_in, i8 %y) {
; CHECK-LABEL: @src_is_mask_p2_m1(
; CHECK-NEXT:    [[P2ORZ:%.*]] = shl i8 2, [[Y:%.*]]
; CHECK-NEXT:    [[MASK:%.*]] = add i8 [[P2ORZ]], -1
; CHECK-NEXT:    [[TMP1:%.*]] = xor i8 [[X_IN:%.*]], 123
; CHECK-NEXT:    [[R:%.*]] = icmp ugt i8 [[TMP1]], [[MASK]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i8 %x_in, 123
  %p2orz = shl i8 2, %y
  %mask = add i8 %p2orz, -1
  %and = and i8 %mask, %x
  %r = icmp ult i8 %and, %x
  ret i1 %r
}

define i1 @src_is_mask_umax(i8 %x_in, i8 %y) {
; CHECK-LABEL: @src_is_mask_umax(
; CHECK-NEXT:    [[Y_M1:%.*]] = add i8 [[Y:%.*]], -1
; CHECK-NEXT:    [[YMASK:%.*]] = xor i8 [[Y_M1]], [[Y]]
; CHECK-NEXT:    [[MASK:%.*]] = call i8 @llvm.umax.i8(i8 [[YMASK]], i8 3)
; CHECK-NEXT:    [[TMP1:%.*]] = xor i8 [[X_IN:%.*]], 123
; CHECK-NEXT:    [[R:%.*]] = icmp ugt i8 [[TMP1]], [[MASK]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i8 %x_in, 123
  %y_m1 = add i8 %y, -1
  %ymask = xor i8 %y, %y_m1
  %mask = call i8 @llvm.umax.i8(i8 %ymask, i8 3)

  %and = and i8 %x, %mask
  %r = icmp ugt i8 %x, %and
  ret i1 %r
}

define i1 @src_is_mask_umin(i8 %x_in, i8 %y, i8 %z) {
; CHECK-LABEL: @src_is_mask_umin(
; CHECK-NEXT:    [[Y_M1:%.*]] = add i8 [[Y:%.*]], -1
; CHECK-NEXT:    [[YMASK:%.*]] = xor i8 [[Y_M1]], [[Y]]
; CHECK-NEXT:    [[ZMASK:%.*]] = lshr i8 15, [[Z:%.*]]
; CHECK-NEXT:    [[MASK:%.*]] = call i8 @llvm.umin.i8(i8 [[YMASK]], i8 [[ZMASK]])
; CHECK-NEXT:    [[TMP1:%.*]] = xor i8 [[X_IN:%.*]], 123
; CHECK-NEXT:    [[R:%.*]] = icmp ugt i8 [[TMP1]], [[MASK]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i8 %x_in, 123
  %y_m1 = add i8 %y, -1
  %ymask = xor i8 %y, %y_m1
  %zmask = lshr i8 15, %z
  %mask = call i8 @llvm.umin.i8(i8 %ymask, i8 %zmask)

  %and = and i8 %mask, %x
  %r = icmp ugt i8 %x, %and
  ret i1 %r
}

define i1 @src_is_mask_umin_fail_mismatch(i8 %x_in, i8 %y) {
; CHECK-LABEL: @src_is_mask_umin_fail_mismatch(
; CHECK-NEXT:    [[Y_M1:%.*]] = add i8 [[Y:%.*]], -1
; CHECK-NEXT:    [[YMASK:%.*]] = xor i8 [[Y_M1]], [[Y]]
; CHECK-NEXT:    [[MASK:%.*]] = call i8 @llvm.umin.i8(i8 [[YMASK]], i8 -32)
; CHECK-NEXT:    [[TMP1:%.*]] = xor i8 [[X_IN:%.*]], -124
; CHECK-NEXT:    [[TMP2:%.*]] = or i8 [[MASK]], [[TMP1]]
; CHECK-NEXT:    [[R:%.*]] = icmp ne i8 [[TMP2]], -1
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i8 %x_in, 123
  %y_m1 = add i8 %y, -1
  %ymask = xor i8 %y, %y_m1
  %mask = call i8 @llvm.umin.i8(i8 %ymask, i8 -32)

  %and = and i8 %mask, %x
  %r = icmp ugt i8 %x, %and
  ret i1 %r
}

define i1 @src_is_mask_smax(i8 %x_in, i8 %y) {
; CHECK-LABEL: @src_is_mask_smax(
; CHECK-NEXT:    [[Y_M1:%.*]] = add i8 [[Y:%.*]], -1
; CHECK-NEXT:    [[YMASK:%.*]] = xor i8 [[Y_M1]], [[Y]]
; CHECK-NEXT:    [[MASK:%.*]] = call i8 @llvm.smax.i8(i8 [[YMASK]], i8 -1)
; CHECK-NEXT:    [[TMP1:%.*]] = xor i8 [[X_IN:%.*]], 123
; CHECK-NEXT:    [[R:%.*]] = icmp ule i8 [[TMP1]], [[MASK]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i8 %x_in, 123
  %y_m1 = add i8 %y, -1
  %ymask = xor i8 %y, %y_m1
  %mask = call i8 @llvm.smax.i8(i8 %ymask, i8 -1)

  %and = and i8 %x, %mask
  %r = icmp uge i8 %and, %x
  ret i1 %r
}

define i1 @src_is_mask_smin(i8 %x_in, i8 %y) {
; CHECK-LABEL: @src_is_mask_smin(
; CHECK-NEXT:    [[Y_M1:%.*]] = add i8 [[Y:%.*]], -1
; CHECK-NEXT:    [[YMASK:%.*]] = xor i8 [[Y_M1]], [[Y]]
; CHECK-NEXT:    [[MASK:%.*]] = call i8 @llvm.smin.i8(i8 [[YMASK]], i8 0)
; CHECK-NEXT:    [[TMP1:%.*]] = xor i8 [[X_IN:%.*]], 123
; CHECK-NEXT:    [[R:%.*]] = icmp ule i8 [[TMP1]], [[MASK]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i8 %x_in, 123
  %y_m1 = add i8 %y, -1
  %ymask = xor i8 %y, %y_m1
  %mask = call i8 @llvm.smin.i8(i8 %ymask, i8 0)

  %and = and i8 %mask, %x
  %r = icmp uge i8 %and, %x
  ret i1 %r
}

define i1 @src_is_mask_bitreverse_not_mask(i8 %x_in, i8 %y) {
; CHECK-LABEL: @src_is_mask_bitreverse_not_mask(
; CHECK-NEXT:    [[NMASK:%.*]] = shl nsw i8 -1, [[Y:%.*]]
; CHECK-NEXT:    [[MASK:%.*]] = call i8 @llvm.bitreverse.i8(i8 [[NMASK]])
; CHECK-NEXT:    [[TMP1:%.*]] = xor i8 [[X_IN:%.*]], 123
; CHECK-NEXT:    [[R:%.*]] = icmp ule i8 [[TMP1]], [[MASK]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i8 %x_in, 123
  %nmask = shl i8 -1, %y
  %mask = call i8 @llvm.bitreverse.i8(i8 %nmask)

  %and = and i8 %x, %mask
  %r = icmp ule i8 %x, %and
  ret i1 %r
}

define i1 @src_is_notmask_sext(i16 %x_in, i8 %y) {
; CHECK-LABEL: @src_is_notmask_sext(
; CHECK-NEXT:    [[M_IN:%.*]] = shl i8 -8, [[Y:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = xor i16 [[X_IN:%.*]], -128
; CHECK-NEXT:    [[TMP2:%.*]] = sext i8 [[M_IN]] to i16
; CHECK-NEXT:    [[R:%.*]] = icmp uge i16 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i16 %x_in, 123
  %m_in = shl i8 -8, %y
  %nmask = sext i8 %m_in to i16
  %mask = xor i16 %nmask, -1
  %and = and i16 %mask, %x
  %r = icmp ule i16 %x, %and
  ret i1 %r
}

define i1 @src_is_notmask_shl(i8 %x_in, i8 %y, i1 %cond) {
; CHECK-LABEL: @src_is_notmask_shl(
; CHECK-NEXT:    [[X:%.*]] = xor i8 [[X_IN:%.*]], 122
; CHECK-NEXT:    [[NMASK:%.*]] = shl nsw i8 -1, [[Y:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = xor i8 [[NMASK]], -1
; CHECK-NEXT:    [[NOTMASK0:%.*]] = call i8 @llvm.bitreverse.i8(i8 [[TMP1]])
; CHECK-NEXT:    [[NOTMASK:%.*]] = select i1 [[COND:%.*]], i8 [[NOTMASK0]], i8 -8
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[X]], [[NOTMASK]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[AND]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i8 %x_in, 123
  %nmask = shl i8 -1, %y
  %mask = call i8 @llvm.bitreverse.i8(i8 %nmask)
  %notmask0 = xor i8 %mask, -1
  %notmask = select i1 %cond, i8 %notmask0, i8 -8
  %and = and i8 %x, %notmask
  %r = icmp eq i8 %and, 0
  ret i1 %r
}

define i1 @src_is_notmask_x_xor_neg_x(i8 %x_in, i8 %y, i1 %cond) {
; CHECK-LABEL: @src_is_notmask_x_xor_neg_x(
; CHECK-NEXT:    [[X:%.*]] = xor i8 [[X_IN:%.*]], 123
; CHECK-NEXT:    [[TMP1:%.*]] = add i8 [[Y:%.*]], -1
; CHECK-NEXT:    [[TMP2:%.*]] = xor i8 [[TMP1]], [[Y]]
; CHECK-NEXT:    [[TMP3:%.*]] = select i1 [[COND:%.*]], i8 [[TMP2]], i8 7
; CHECK-NEXT:    [[R:%.*]] = icmp ule i8 [[X]], [[TMP3]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i8 %x_in, 123
  %neg_y = sub i8 0, %y
  %nmask0 = xor i8 %y, %neg_y
  %notmask = select i1 %cond, i8 %nmask0, i8 -8
  %and = and i8 %x, %notmask
  %r = icmp eq i8 %and, 0
  ret i1 %r
}

define i1 @src_is_notmask_x_xor_neg_x_inv(i8 %x_in, i8 %y, i1 %cond) {
; CHECK-LABEL: @src_is_notmask_x_xor_neg_x_inv(
; CHECK-NEXT:    [[X:%.*]] = xor i8 [[X_IN:%.*]], 123
; CHECK-NEXT:    [[TMP1:%.*]] = add i8 [[Y:%.*]], -1
; CHECK-NEXT:    [[TMP2:%.*]] = xor i8 [[TMP1]], [[Y]]
; CHECK-NEXT:    [[TMP3:%.*]] = select i1 [[COND:%.*]], i8 [[TMP2]], i8 7
; CHECK-NEXT:    [[R:%.*]] = icmp ule i8 [[X]], [[TMP3]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i8 %x_in, 123
  %neg_y = sub i8 0, %y
  %nmask0 = xor i8 %y, %neg_y
  %notmask = select i1 %cond, i8 %nmask0, i8 -8
  %and = and i8 %notmask, %x
  %r = icmp eq i8 %and, 0
  ret i1 %r
}

define i1 @src_is_notmask_shl_fail_multiuse_invert(i8 %x_in, i8 %y, i1 %cond) {
; CHECK-LABEL: @src_is_notmask_shl_fail_multiuse_invert(
; CHECK-NEXT:    [[X:%.*]] = xor i8 [[X_IN:%.*]], 122
; CHECK-NEXT:    [[NMASK:%.*]] = shl nsw i8 -1, [[Y:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = xor i8 [[NMASK]], -1
; CHECK-NEXT:    [[NOTMASK0:%.*]] = call i8 @llvm.bitreverse.i8(i8 [[TMP1]])
; CHECK-NEXT:    [[NOTMASK:%.*]] = select i1 [[COND:%.*]], i8 [[NOTMASK0]], i8 -8
; CHECK-NEXT:    call void @use.i8(i8 [[NOTMASK]])
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[X]], [[NOTMASK]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[AND]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i8 %x_in, 123
  %nmask = shl i8 -1, %y
  %mask = call i8 @llvm.bitreverse.i8(i8 %nmask)
  %notmask0 = xor i8 %mask, -1
  %notmask = select i1 %cond, i8 %notmask0, i8 -8
  call void @use.i8(i8 %notmask)
  %and = and i8 %x, %notmask
  %r = icmp eq i8 %and, 0
  ret i1 %r
}

define i1 @src_is_notmask_lshr_shl(i8 %x_in, i8 %y) {
; CHECK-LABEL: @src_is_notmask_lshr_shl(
; CHECK-NEXT:    [[TMP1:%.*]] = shl nsw i8 -1, [[Y:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = xor i8 [[X_IN:%.*]], -124
; CHECK-NEXT:    [[R:%.*]] = icmp uge i8 [[TMP2]], [[TMP1]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i8 %x_in, 123
  %mask_shr = lshr i8 -1, %y
  %nmask = shl i8 %mask_shr, %y
  %mask = xor i8 %nmask, -1
  %and = and i8 %mask, %x
  %r = icmp eq i8 %and, %x
  ret i1 %r
}

define i1 @src_is_notmask_lshr_shl_fail_mismatch_shifts(i8 %x_in, i8 %y, i8 %z) {
; CHECK-LABEL: @src_is_notmask_lshr_shl_fail_mismatch_shifts(
; CHECK-NEXT:    [[MASK_SHR:%.*]] = lshr i8 -1, [[Y:%.*]]
; CHECK-NEXT:    [[NMASK:%.*]] = shl i8 [[MASK_SHR]], [[Z:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = xor i8 [[X_IN:%.*]], 123
; CHECK-NEXT:    [[TMP2:%.*]] = and i8 [[TMP1]], [[NMASK]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[TMP2]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i8 %x_in, 123
  %mask_shr = lshr i8 -1, %y
  %nmask = shl i8 %mask_shr, %z
  %mask = xor i8 %nmask, -1
  %and = and i8 %mask, %x
  %r = icmp eq i8 %and, %x
  ret i1 %r
}

define i1 @src_is_notmask_ashr(i16 %x_in, i8 %y, i16 %z) {
; CHECK-LABEL: @src_is_notmask_ashr(
; CHECK-NEXT:    [[M_IN:%.*]] = shl i8 -32, [[Y:%.*]]
; CHECK-NEXT:    [[NMASK:%.*]] = sext i8 [[M_IN]] to i16
; CHECK-NEXT:    [[NMASK_SHR:%.*]] = ashr i16 [[NMASK]], [[Z:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = xor i16 [[X_IN:%.*]], -124
; CHECK-NEXT:    [[R:%.*]] = icmp uge i16 [[TMP1]], [[NMASK_SHR]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i16 %x_in, 123
  %m_in = shl i8 -32, %y
  %nmask = sext i8 %m_in to i16
  %nmask_shr = ashr i16 %nmask, %z
  %mask = xor i16 %nmask_shr, -1
  %and = and i16 %x, %mask
  %r = icmp eq i16 %x, %and
  ret i1 %r
}

define i1 @src_is_notmask_neg_p2(i8 %x_in, i8 %y) {
; CHECK-LABEL: @src_is_notmask_neg_p2(
; CHECK-NEXT:    [[X:%.*]] = xor i8 [[X_IN:%.*]], 123
; CHECK-NEXT:    [[TMP1:%.*]] = add i8 [[Y:%.*]], -1
; CHECK-NEXT:    [[TMP2:%.*]] = xor i8 [[Y]], -1
; CHECK-NEXT:    [[TMP3:%.*]] = and i8 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[NOTMASK:%.*]] = call i8 @llvm.bitreverse.i8(i8 [[TMP3]])
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[NOTMASK]], [[X]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[AND]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i8 %x_in, 123
  %ny = sub i8 0, %y
  %p2 = and i8 %ny, %y
  %nmask = sub i8 0, %p2
  %mask = call i8 @llvm.bitreverse.i8(i8 %nmask)
  %notmask = xor i8 %mask, -1
  %and = and i8 %notmask, %x
  %r = icmp eq i8 0, %and
  ret i1 %r
}

define i1 @src_is_notmask_neg_p2_fail_not_invertable(i8 %x_in, i8 %y) {
; CHECK-LABEL: @src_is_notmask_neg_p2_fail_not_invertable(
; CHECK-NEXT:    [[TMP1:%.*]] = xor i8 [[X_IN:%.*]], -124
; CHECK-NEXT:    [[TMP2:%.*]] = sub i8 0, [[Y:%.*]]
; CHECK-NEXT:    [[TMP3:%.*]] = or i8 [[TMP2]], [[Y]]
; CHECK-NEXT:    [[R:%.*]] = icmp uge i8 [[TMP1]], [[TMP3]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i8 %x_in, 123
  %ny = sub i8 0, %y
  %p2 = and i8 %ny, %y
  %notmask = sub i8 0, %p2
  %and = and i8 %notmask, %x
  %r = icmp eq i8 0, %and
  ret i1 %r
}

define i1 @src_is_notmask_xor_fail(i8 %x_in, i8 %y) {
; CHECK-LABEL: @src_is_notmask_xor_fail(
; CHECK-NEXT:    [[X:%.*]] = xor i8 [[X_IN:%.*]], 123
; CHECK-NEXT:    [[TMP1:%.*]] = sub i8 0, [[Y:%.*]]
; CHECK-NEXT:    [[NOTMASK_REV:%.*]] = xor i8 [[TMP1]], [[Y]]
; CHECK-NEXT:    [[NOTMASK:%.*]] = call i8 @llvm.bitreverse.i8(i8 [[NOTMASK_REV]])
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[X]], [[NOTMASK]]
; CHECK-NEXT:    [[R:%.*]] = icmp slt i8 [[AND]], [[X]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i8 %x_in, 123
  %y_m1 = add i8 %y, -1
  %mask = xor i8 %y, %y_m1
  %notmask_rev = xor i8 %mask, -1
  %notmask = call i8 @llvm.bitreverse.i8(i8 %notmask_rev)
  %and = and i8 %x, %notmask
  %r = icmp slt i8 %and, %x
  ret i1 %r
}

define i1 @src_is_mask_const_slt(i8 %x_in) {
; CHECK-LABEL: @src_is_mask_const_slt(
; CHECK-NEXT:    [[R:%.*]] = icmp slt i8 [[X_IN:%.*]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i8 %x_in, 123
  %and = and i8 %x, 7
  %r = icmp slt i8 %x, %and
  ret i1 %r
}

define i1 @src_is_mask_const_sgt(i8 %x_in) {
; CHECK-LABEL: @src_is_mask_const_sgt(
; CHECK-NEXT:    [[X:%.*]] = xor i8 [[X_IN:%.*]], 123
; CHECK-NEXT:    [[R:%.*]] = icmp sgt i8 [[X]], 7
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i8 %x_in, 123
  %and = and i8 %x, 7
  %r = icmp sgt i8 %x, %and
  ret i1 %r
}

define i1 @src_is_mask_const_sle(i8 %x_in) {
; CHECK-LABEL: @src_is_mask_const_sle(
; CHECK-NEXT:    [[R:%.*]] = icmp sgt i8 [[X_IN:%.*]], -1
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i8 %x_in, 123
  %and = and i8 %x, 31
  %r = icmp sle i8 %and, %x
  ret i1 %r
}

define i1 @src_is_mask_const_sge(i8 %x_in) {
; CHECK-LABEL: @src_is_mask_const_sge(
; CHECK-NEXT:    [[X:%.*]] = xor i8 [[X_IN:%.*]], 123
; CHECK-NEXT:    [[R:%.*]] = icmp slt i8 [[X]], 32
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = xor i8 %x_in, 123
  %and = and i8 %x, 31
  %r = icmp sge i8 %and, %x
  ret i1 %r
}

define i1 @src_x_and_mask_slt(i8 %x, i8 %y, i1 %cond) {
; CHECK-LABEL: @src_x_and_mask_slt(
; CHECK-NEXT:    [[MASK0:%.*]] = lshr i8 -1, [[Y:%.*]]
; CHECK-NEXT:    [[MASK:%.*]] = select i1 [[COND:%.*]], i8 [[MASK0]], i8 0
; CHECK-NEXT:    [[MASK_POS:%.*]] = icmp sgt i8 [[MASK]], -1
; CHECK-NEXT:    call void @llvm.assume(i1 [[MASK_POS]])
; CHECK-NEXT:    [[R:%.*]] = icmp slt i8 [[MASK]], [[X:%.*]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %mask0 = lshr i8 -1, %y
  %mask = select i1 %cond, i8 %mask0, i8 0
  %mask_pos = icmp sge i8 %mask, 0
  call void @llvm.assume(i1 %mask_pos)
  %and = and i8 %x, %mask
  %r = icmp slt i8 %and, %x
  ret i1 %r
}

define i1 @src_x_and_mask_sge(i8 %x, i8 %y, i1 %cond) {
; CHECK-LABEL: @src_x_and_mask_sge(
; CHECK-NEXT:    [[MASK0:%.*]] = lshr i8 -1, [[Y:%.*]]
; CHECK-NEXT:    [[MASK:%.*]] = select i1 [[COND:%.*]], i8 [[MASK0]], i8 0
; CHECK-NEXT:    [[MASK_POS:%.*]] = icmp sgt i8 [[MASK]], -1
; CHECK-NEXT:    call void @llvm.assume(i1 [[MASK_POS]])
; CHECK-NEXT:    [[R:%.*]] = icmp sge i8 [[MASK]], [[X:%.*]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %mask0 = lshr i8 -1, %y
  %mask = select i1 %cond, i8 %mask0, i8 0
  %mask_pos = icmp sge i8 %mask, 0
  call void @llvm.assume(i1 %mask_pos)
  %and = and i8 %x, %mask
  %r = icmp sge i8 %and, %x
  ret i1 %r
}

define i1 @src_x_and_mask_slt_fail_maybe_neg(i8 %x, i8 %y, i1 %cond) {
; CHECK-LABEL: @src_x_and_mask_slt_fail_maybe_neg(
; CHECK-NEXT:    [[MASK0:%.*]] = lshr i8 -1, [[Y:%.*]]
; CHECK-NEXT:    [[MASK:%.*]] = select i1 [[COND:%.*]], i8 [[MASK0]], i8 0
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[MASK]], [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp slt i8 [[AND]], [[X]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %mask0 = lshr i8 -1, %y
  %mask = select i1 %cond, i8 %mask0, i8 0
  %and = and i8 %x, %mask
  %r = icmp slt i8 %and, %x
  ret i1 %r
}

define i1 @src_x_and_mask_sge_fail_maybe_neg(i8 %x, i8 %y, i1 %cond) {
; CHECK-LABEL: @src_x_and_mask_sge_fail_maybe_neg(
; CHECK-NEXT:    [[MASK0:%.*]] = lshr i8 -1, [[Y:%.*]]
; CHECK-NEXT:    [[MASK:%.*]] = select i1 [[COND:%.*]], i8 [[MASK0]], i8 0
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[MASK]], [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp sge i8 [[AND]], [[X]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %mask0 = lshr i8 -1, %y
  %mask = select i1 %cond, i8 %mask0, i8 0
  %and = and i8 %x, %mask
  %r = icmp sge i8 %and, %x
  ret i1 %r
}

define i1 @src_x_and_nmask_eq(i8 %x, i8 %y, i1 %cond) {
; CHECK-LABEL: @src_x_and_nmask_eq(
; CHECK-NEXT:    [[NOT_MASK0:%.*]] = shl nsw i8 -1, [[Y:%.*]]
; CHECK-NEXT:    [[R1:%.*]] = icmp ule i8 [[NOT_MASK0]], [[X:%.*]]
; CHECK-NEXT:    [[NOT_COND:%.*]] = xor i1 [[COND:%.*]], true
; CHECK-NEXT:    [[R:%.*]] = select i1 [[NOT_COND]], i1 true, i1 [[R1]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %not_mask0 = shl i8 -1, %y
  %not_mask = select i1 %cond, i8 %not_mask0, i8 0
  %and = and i8 %x, %not_mask
  %r = icmp eq i8 %not_mask, %and
  ret i1 %r
}

define i1 @src_x_and_nmask_ne(i8 %x, i8 %y, i1 %cond) {
; CHECK-LABEL: @src_x_and_nmask_ne(
; CHECK-NEXT:    [[NOT_MASK0:%.*]] = shl nsw i8 -1, [[Y:%.*]]
; CHECK-NEXT:    [[R1:%.*]] = icmp ugt i8 [[NOT_MASK0]], [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = select i1 [[COND:%.*]], i1 [[R1]], i1 false
; CHECK-NEXT:    ret i1 [[R]]
;
  %not_mask0 = shl i8 -1, %y
  %not_mask = select i1 %cond, i8 %not_mask0, i8 0
  %and = and i8 %x, %not_mask
  %r = icmp ne i8 %and, %not_mask
  ret i1 %r
}

define i1 @src_x_and_nmask_ult(i8 %x, i8 %y, i1 %cond) {
; CHECK-LABEL: @src_x_and_nmask_ult(
; CHECK-NEXT:    [[NOT_MASK0:%.*]] = shl nsw i8 -1, [[Y:%.*]]
; CHECK-NEXT:    [[R1:%.*]] = icmp ugt i8 [[NOT_MASK0]], [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = select i1 [[COND:%.*]], i1 [[R1]], i1 false
; CHECK-NEXT:    ret i1 [[R]]
;
  %not_mask0 = shl i8 -1, %y
  %not_mask = select i1 %cond, i8 %not_mask0, i8 0
  %and = and i8 %x, %not_mask
  %r = icmp ult i8 %and, %not_mask
  ret i1 %r
}

define i1 @src_x_and_nmask_uge(i8 %x, i8 %y, i1 %cond) {
; CHECK-LABEL: @src_x_and_nmask_uge(
; CHECK-NEXT:    [[NOT_MASK0:%.*]] = shl nsw i8 -1, [[Y:%.*]]
; CHECK-NEXT:    [[R1:%.*]] = icmp ule i8 [[NOT_MASK0]], [[X:%.*]]
; CHECK-NEXT:    [[NOT_COND:%.*]] = xor i1 [[COND:%.*]], true
; CHECK-NEXT:    [[R:%.*]] = select i1 [[NOT_COND]], i1 true, i1 [[R1]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %not_mask0 = shl i8 -1, %y
  %not_mask = select i1 %cond, i8 %not_mask0, i8 0
  %and = and i8 %x, %not_mask
  %r = icmp uge i8 %and, %not_mask
  ret i1 %r
}

define i1 @src_x_and_nmask_slt(i8 %x, i8 %y) {
; CHECK-LABEL: @src_x_and_nmask_slt(
; CHECK-NEXT:    [[NOT_MASK:%.*]] = shl nsw i8 -1, [[Y:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp sgt i8 [[NOT_MASK]], [[X:%.*]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %not_mask = shl i8 -1, %y
  %and = and i8 %x, %not_mask
  %r = icmp slt i8 %and, %not_mask
  ret i1 %r
}

define i1 @src_x_and_nmask_sge(i8 %x, i8 %y) {
; CHECK-LABEL: @src_x_and_nmask_sge(
; CHECK-NEXT:    [[NOT_MASK:%.*]] = shl nsw i8 -1, [[Y:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp sle i8 [[NOT_MASK]], [[X:%.*]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %not_mask = shl i8 -1, %y
  %and = and i8 %x, %not_mask
  %r = icmp sge i8 %and, %not_mask
  ret i1 %r
}

define i1 @src_x_and_nmask_slt_fail_maybe_z(i8 %x, i8 %y, i1 %cond) {
; CHECK-LABEL: @src_x_and_nmask_slt_fail_maybe_z(
; CHECK-NEXT:    [[NOT_MASK0:%.*]] = shl nsw i8 -1, [[Y:%.*]]
; CHECK-NEXT:    [[NOT_MASK:%.*]] = select i1 [[COND:%.*]], i8 [[NOT_MASK0]], i8 0
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[NOT_MASK]], [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp slt i8 [[AND]], [[NOT_MASK]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %not_mask0 = shl i8 -1, %y
  %not_mask = select i1 %cond, i8 %not_mask0, i8 0
  %and = and i8 %x, %not_mask
  %r = icmp slt i8 %and, %not_mask
  ret i1 %r
}

define i1 @src_x_and_nmask_sge_fail_maybe_z(i8 %x, i8 %y, i1 %cond) {
; CHECK-LABEL: @src_x_and_nmask_sge_fail_maybe_z(
; CHECK-NEXT:    [[NOT_MASK0:%.*]] = shl nsw i8 -1, [[Y:%.*]]
; CHECK-NEXT:    [[NOT_MASK:%.*]] = select i1 [[COND:%.*]], i8 [[NOT_MASK0]], i8 0
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[NOT_MASK]], [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp sge i8 [[AND]], [[NOT_MASK]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %not_mask0 = shl i8 -1, %y
  %not_mask = select i1 %cond, i8 %not_mask0, i8 0
  %and = and i8 %x, %not_mask
  %r = icmp sge i8 %and, %not_mask
  ret i1 %r
}

define i1 @src_x_or_mask_eq(i8 %x, i8 %y, i8 %z, i1 %c2, i1 %cond) {
; CHECK-LABEL: @src_x_or_mask_eq(
; CHECK-NEXT:    [[MASK0:%.*]] = lshr i8 -1, [[Y:%.*]]
; CHECK-NEXT:    [[MASK:%.*]] = select i1 [[COND:%.*]], i8 [[MASK0]], i8 0
; CHECK-NEXT:    [[TMP1:%.*]] = xor i8 [[X:%.*]], -124
; CHECK-NEXT:    [[TMP2:%.*]] = select i1 [[C2:%.*]], i8 [[TMP1]], i8 -46
; CHECK-NEXT:    [[TMP3:%.*]] = call i8 @llvm.umax.i8(i8 [[Z:%.*]], i8 [[TMP2]])
; CHECK-NEXT:    [[TMP4:%.*]] = add i8 [[TMP3]], -12
; CHECK-NEXT:    [[R:%.*]] = icmp ule i8 [[TMP4]], [[MASK]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %mask0 = lshr i8 -1, %y
  %mask = select i1 %cond, i8 %mask0, i8 0
  %nx = xor i8 %x, 123
  %nx_c = select i1 %c2, i8 %nx, i8 45
  %nz = xor i8 %z, -1
  %nx_cc = call i8 @llvm.umin.i8(i8 %nz, i8 %nx_c)
  %nx_ccc = add i8 %nx_cc, 12
  %or = or i8 %nx_ccc, %mask
  %r = icmp eq i8 %or, -1
  ret i1 %r
}

define i1 @src_x_or_mask_ne(i8 %x, i8 %y, i1 %cond) {
; CHECK-LABEL: @src_x_or_mask_ne(
; CHECK-NEXT:    [[MASK0:%.*]] = lshr i8 -1, [[Y:%.*]]
; CHECK-NEXT:    [[MASK:%.*]] = select i1 [[COND:%.*]], i8 [[MASK0]], i8 0
; CHECK-NEXT:    [[R:%.*]] = icmp ult i8 [[MASK]], [[X:%.*]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %mask0 = lshr i8 -1, %y
  %mask = select i1 %cond, i8 %mask0, i8 0
  %nx = xor i8 %x, -1
  %or = or i8 %mask, %nx
  %r = icmp ne i8 %or, -1
  ret i1 %r
}

define i1 @src_x_or_mask_ne_fail_multiuse(i8 %x, i8 %y, i1 %cond) {
; CHECK-LABEL: @src_x_or_mask_ne_fail_multiuse(
; CHECK-NEXT:    [[MASK0:%.*]] = lshr i8 -1, [[Y:%.*]]
; CHECK-NEXT:    [[MASK:%.*]] = select i1 [[COND:%.*]], i8 [[MASK0]], i8 0
; CHECK-NEXT:    [[NX:%.*]] = xor i8 [[X:%.*]], -1
; CHECK-NEXT:    [[OR:%.*]] = or i8 [[MASK]], [[NX]]
; CHECK-NEXT:    call void @use.i8(i8 [[OR]])
; CHECK-NEXT:    [[R:%.*]] = icmp ne i8 [[OR]], -1
; CHECK-NEXT:    ret i1 [[R]]
;
  %mask0 = lshr i8 -1, %y
  %mask = select i1 %cond, i8 %mask0, i8 0
  %nx = xor i8 %x, -1
  %or = or i8 %mask, %nx
  call void @use.i8(i8 %or)
  %r = icmp ne i8 %or, -1
  ret i1 %r
}
