"""Test constants package."""

from .const import (
    AUTHENTICATED_USER,
    REQUIRES_2FA_TOKEN,
    REQUIRES_2FA_USER,
    VALID_2FA_CODE,
    VALID_COOKIE,
    VALID_PASSWORD,
    VALID_TOKEN,
    VALID_TOKENS,
    VALID_USERS,
)
from .const_account import ACCOUNT_DEVICES_WORKING, ACCOUNT_STORAGE_WORKING
from .const_account_family import ACCOUNT_FAMILY_WORKING
from .const_drive import (
    DRIVE_FILE_DOWNLOAD_WORKING,
    DRIVE_FOLDER_WORKING,
    DRIVE_ROOT_INVALID,
    DRIVE_ROOT_WORKING,
    DRIVE_SUBFOLDER_WORKING,
    DRIVE_TRASH_DELETE_FOREVER_WORKING,
    DRIVE_TRASH_RECOVER_WORKING,
    DRIVE_TRASH_WORKING,
)
from .const_findmyiphone import FMI_FAMILY_WORKING
from .const_login import (
    AUTH_OK,
    LOGIN_2FA,
    LOGIN_WORKING,
    TRUSTED_DEVICE_1,
    TRUSTED_DEVICES,
    VERIFICATION_CODE_KO,
    VERIFICATION_CODE_OK,
)

__all__: list[str] = [
    "AUTHENTICATED_USER",
    "REQUIRES_2FA_TOKEN",
    "REQUIRES_2FA_USER",
    "VALID_2FA_CODE",
    "VALID_COOKIE",
    "VALID_TOKEN",
    "VALID_TOKENS",
    "VALID_USERS",
    "VALID_PASSWORD",
    "ACCOUNT_DEVICES_WORKING",
    "ACCOUNT_STORAGE_WORKING",
    "ACCOUNT_FAMILY_WORKING",
    "DRIVE_FILE_DOWNLOAD_WORKING",
    "DRIVE_FOLDER_WORKING",
    "DRIVE_ROOT_INVALID",
    "DRIVE_ROOT_WORKING",
    "DRIVE_SUBFOLDER_WORKING",
    "DRIVE_TRASH_DELETE_FOREVER_WORKING",
    "DRIVE_TRASH_RECOVER_WORKING",
    "DRIVE_TRASH_WORKING",
    "FMI_FAMILY_WORKING",
    "AUTH_OK",
    "LOGIN_2FA",
    "LOGIN_WORKING",
    "TRUSTED_DEVICE_1",
    "TRUSTED_DEVICES",
    "VERIFICATION_CODE_KO",
    "VERIFICATION_CODE_OK",
]
