% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step-subset-filter.R
\name{filter.dtplyr_step}
\alias{filter.dtplyr_step}
\title{Subset rows using column values}
\usage{
\method{filter}{dtplyr_step}(.data, ..., .by = NULL, .preserve = FALSE)
}
\arguments{
\item{.data}{A \code{\link[=lazy_dt]{lazy_dt()}}.}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Expressions that
return a logical vector, defined in terms of the variables in \code{.data}. If
multiple expressions are included, they are combined with the \code{&} operator.
To combine expressions using \code{|} instead, wrap them in \code{\link[dplyr:when_any]{when_any()}}. Only
rows for which all expressions evaluate to \code{TRUE} are kept (for \code{filter()})
or dropped (for \code{filter_out()}).}

\item{.by}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Optionally, a selection of columns to
group by for just this operation, functioning as an alternative to \code{\link[dplyr:group_by]{group_by()}}. For
details and examples, see \link[dplyr:dplyr_by]{?dplyr_by}.}

\item{.preserve}{Ignored}
}
\description{
This is a method for the dplyr \code{\link[dplyr:arrange]{dplyr::arrange()}} generic. It is translated to
the \code{i} argument of \verb{[.data.table}
}
\examples{
library(dplyr, warn.conflicts = FALSE)

dt <- lazy_dt(mtcars)
dt \%>\% filter(cyl == 4)
dt \%>\% filter(vs, am)

dt \%>\%
  group_by(cyl) \%>\%
  filter(mpg > mean(mpg))
}
