context("ggheatmap")

test_that("ggheatmap works", {
  g <- ggheatmap(mtcars, dendrogram = "none")
  expect_is(g, "egg")
  g <- ggheatmap(mtcars, dendrogram = "row")
  expect_is(g, "egg")
  g <- ggheatmap(mtcars, dendrogram = "column")
  expect_is(g, "egg")
  g <- ggheatmap(mtcars, row_dend_left = TRUE)
  expect_is(g, "egg")
  g <- ggheatmap(mtcars, dendrogram = "row", row_dend_left = TRUE)
  expect_is(g, "egg")
  g <- ggheatmap(mtcars, row_side_colors = mtcars[, 2])
  expect_is(g, "egg")
  g <- ggheatmap(mtcars, col_side_colors = t(mtcars[1, ]))
  expect_is(g, "egg")
  g <- ggheatmap(mtcars, row_side_colors = mtcars[, 2], col_side_colors = t(mtcars[1, ]))
  expect_is(g, "egg")
})
