% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppt_ph_dedupe_layout.R
\name{layout_dedupe_ph_labels}
\alias{layout_dedupe_ph_labels}
\title{Detect and handle duplicate placeholder labels}
\usage{
layout_dedupe_ph_labels(x, action = "detect", print_info = FALSE)
}
\arguments{
\item{x}{An \code{rpptx} object.}

\item{action}{Action to perform on duplicate placeholder labels. One of:
\itemize{
\item \code{detect} (default) = show info on dupes only, make no changes
\item \code{rename} = create unique labels. Labels are renamed by appending a sequential number
separated by dot to duplicate labels. For example, \code{c("title", "title")} becomes \code{c("title.1", "title.2")}.
\item \code{delete} = only keep one of the placeholders with a duplicate label
}}

\item{print_info}{Print action information (e.g. renamed placeholders) to console?
Default is \code{FALSE}. Always \code{TRUE} for action \code{detect}.}
}
\value{
A \code{rpptx} object (with modified placeholder labels).
}
\description{
PowerPoint does not enforce unique placeholder labels in a layout.
Selecting a placeholder via its label using \link{ph_location_label} will throw
an error, if the label is not unique. \link{layout_dedupe_ph_labels} helps to detect,
rename, or delete duplicate placholder labels.
}
\examples{
x <- read_pptx()
layout_dedupe_ph_labels(x)

file <- system.file("doc_examples", "ph_dupes.pptx", package = "officer")
x <- read_pptx(file)
layout_dedupe_ph_labels(x)
layout_dedupe_ph_labels(x, "rename", print_info = TRUE)

}
