% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_cor_mat.R
\name{as_cor_mat}
\alias{as_cor_mat}
\title{Convert a Correlation Test Data Frame into a Correlation Matrix}
\usage{
as_cor_mat(x)
}
\arguments{
\item{x}{an object of class \code{cor_test}.}
}
\value{
Returns a data frame containing the matrix of the correlation
  coefficients. The output has an attribute named "pvalue", which contains
  the matrix of the correlation test p-values.
}
\description{
Convert a correlation test data frame, returned by the
  \code{\link{cor_test}()}, into a correlation matrix format.
}
\examples{
# Pairwise correlation tests between variables
#:::::::::::::::::::::::::::::::::::::::::::::::
res.cor.test <- mtcars \%>\%
  select(mpg, disp, hp, drat, wt, qsec) \%>\%
  cor_test()
res.cor.test

# Convert the correlation test into a correlation matrix
#:::::::::::::::::::::::::::::::::::::::::::::::
res.cor.test \%>\% as_cor_mat()

}
\seealso{
\code{\link{cor_mat}()}, \code{\link{cor_test}()}
}
