use core:asm;
use lang:asm;

// These functions mirror RawPtr:read/write, except that they are visible to Progvis.
// The standard library uses them to make certain operations visible.

Byte markReadByte(unsafe:RawPtr base, Nat offset) {
	offset += sPtr.current * 2;
	Byte out;
	asm {
		mov eax, offset;
		add ptrA, base;
		mov out, b[ptrA];
	}
	out;
}

void markWriteByte(unsafe:RawPtr base, Nat offset, Byte value) {
	offset += sPtr.current * 2;
	asm {
		mov eax, offset;
		add ptrA, base;
		mov b[ptrA], value;
	}
}
