
package ONVIF::Device::Elements::SetNetworkInterfaces;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'http://www.onvif.org/ver10/device/wsdl' }

__PACKAGE__->__set_name('SetNetworkInterfaces');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %InterfaceToken_of :ATTR(:get<InterfaceToken>);
my %NetworkInterface_of :ATTR(:get<NetworkInterface>);

__PACKAGE__->_factory(
    [ qw(        InterfaceToken
        NetworkInterface

    ) ],
    {
        'InterfaceToken' => \%InterfaceToken_of,
        'NetworkInterface' => \%NetworkInterface_of,
    },
    {
        'InterfaceToken' => 'ONVIF::Device::Types::ReferenceToken',
        'NetworkInterface' => 'ONVIF::Device::Types::NetworkInterfaceSetConfiguration',
    },
    {

        'InterfaceToken' => 'InterfaceToken',
        'NetworkInterface' => 'NetworkInterface',
    }
);

} # end BLOCK







} # end of BLOCK



1;


=pod

=head1 NAME

ONVIF::Device::Elements::SetNetworkInterfaces

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
SetNetworkInterfaces from the namespace http://www.onvif.org/ver10/device/wsdl.







=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * InterfaceToken

 $element->set_InterfaceToken($data);
 $element->get_InterfaceToken();




=item * NetworkInterface

 $element->set_NetworkInterface($data);
 $element->get_NetworkInterface();





=back


=head1 METHODS

=head2 new

 my $element = ONVIF::Device::Elements::SetNetworkInterfaces->new($data);

Constructor. The following data structure may be passed to new():

 {
   InterfaceToken => $some_value, # ReferenceToken
   NetworkInterface =>  { # ONVIF::Device::Types::NetworkInterfaceSetConfiguration
     Enabled =>  $some_value, # boolean
     Link =>  { # ONVIF::Device::Types::NetworkInterfaceConnectionSetting
       AutoNegotiation =>  $some_value, # boolean
       Speed =>  $some_value, # int
       Duplex => $some_value, # Duplex
     },
     MTU =>  $some_value, # int
     IPv4 =>  { # ONVIF::Device::Types::IPv4NetworkInterfaceSetConfiguration
       Enabled =>  $some_value, # boolean
       Manual =>  { # ONVIF::Device::Types::PrefixedIPv4Address
         Address => $some_value, # IPv4Address
         PrefixLength =>  $some_value, # int
       },
       DHCP =>  $some_value, # boolean
     },
     IPv6 =>  { # ONVIF::Device::Types::IPv6NetworkInterfaceSetConfiguration
       Enabled =>  $some_value, # boolean
       AcceptRouterAdvert =>  $some_value, # boolean
       Manual =>  { # ONVIF::Device::Types::PrefixedIPv6Address
         Address => $some_value, # IPv6Address
         PrefixLength =>  $some_value, # int
       },
       DHCP => $some_value, # IPv6DHCPConfiguration
     },
     Extension =>  { # ONVIF::Device::Types::NetworkInterfaceSetConfigurationExtension
       Dot3 =>  { # ONVIF::Device::Types::Dot3Configuration
       },
       Dot11 =>  { # ONVIF::Device::Types::Dot11Configuration
         SSID => $some_value, # Dot11SSIDType
         Mode => $some_value, # Dot11StationMode
         Alias => $some_value, # Name
         Priority => $some_value, # NetworkInterfaceConfigPriority
         Security =>  { # ONVIF::Device::Types::Dot11SecurityConfiguration
           Mode => $some_value, # Dot11SecurityMode
           Algorithm => $some_value, # Dot11Cipher
           PSK =>  { # ONVIF::Device::Types::Dot11PSKSet
             Key => $some_value, # Dot11PSK
             Passphrase => $some_value, # Dot11PSKPassphrase
             Extension =>  { # ONVIF::Device::Types::Dot11PSKSetExtension
             },
           },
           Dot1X => $some_value, # ReferenceToken
           Extension =>  { # ONVIF::Device::Types::Dot11SecurityConfigurationExtension
           },
         },
       },
       Extension =>  { # ONVIF::Device::Types::NetworkInterfaceSetConfigurationExtension2
       },
     },
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

