# frozen_string_literal: true

class AddIndexVulnerabilityOccurrencesToSupportSbomServices < Gitlab::Database::Migration[2.2]
  milestone '17.4'

  TABLE_NAME = :vulnerability_occurrences
  INDEX_NAME = 'i_vuln_occurrences_on_proj_report_loc_dep_pkg_ver_file_img'
  COLUMNS = [
    'project_id',
    'report_type',
    "(location -> 'dependency' -> 'package' ->> 'name')",
    "(location -> 'dependency' ->> 'version')",
    "COALESCE(location ->> 'file', location ->> 'image')"
  ].join(',')

  disable_ddl_transaction!

  def up
    add_concurrent_index TABLE_NAME, COLUMNS, where: 'report_type IN (2, 1)', name: INDEX_NAME
  end

  def down
    remove_concurrent_index_by_name TABLE_NAME, INDEX_NAME
  end
end
