% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_parameters.R
\name{clean_parameters}
\alias{clean_parameters}
\title{Get clean names of model parameters}
\usage{
clean_parameters(x, ...)
}
\arguments{
\item{x}{A fitted model.}

\item{...}{Currently not used.}
}
\value{
A data frame with "cleaned" parameter names and information on effects,
component and group where parameters belong to. To be consistent across
different models, the returned data frame always has at least four columns
\code{Parameter}, \code{Effects}, \code{Component} and \code{Cleaned_Parameter}. See 'Details'.
}
\description{
This function "cleans" names of model parameters by removing
patterns like \code{"r_"} or \code{"b[]"} (mostly applicable to Stan models)
and adding columns with information to which group or component parameters
belong (i.e. fixed or random, count or zero-inflated...)

The main purpose of this function is to easily filter and select model parameters,
in particular of - but not limited to - posterior samples from Stan models,
depending on certain characteristics. This might be useful when only selective
results should be reported or results from all parameters should be filtered
to return only certain results (see \code{\link[=print_parameters]{print_parameters()}}).
}
\details{
The \code{Effects} column indicate if a parameter is a \emph{fixed} or \emph{random} effect.
The \code{Component} column refers to special model components like \emph{conditional},
\emph{zero_inflated}, or \emph{dispersion}. For models from package \strong{brms}, the
various distributional parameters are also included in this column. For
models with random effects, the \code{Group} column indicates the grouping factor
of the random effects. For multivariate response models from \strong{brms} or
\strong{rstanarm}, an additional \emph{Response} column is included, to indicate which
parameters belong to which response formula. Furthermore, \emph{Cleaned_Parameter}
column is returned that contains "human readable" parameter names (which are
mostly identical to \code{Parameter}, except for for models from \strong{brms} or
\strong{rstanarm}, or for specific terms like smooth- or spline-terms).
}
\examples{
\dontshow{if (require("curl", quietly = TRUE) && curl::has_internet() && require("brms")) withAutoprint(\{ # examplesIf}
\donttest{
model <- download_model("brms_zi_2")
if (!is.null(model)) {
  clean_parameters(model)
}
}
\dontshow{\}) # examplesIf}
}
