% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_cv.R
\name{performance_cv}
\alias{performance_cv}
\title{Cross-validated model performance}
\usage{
performance_cv(
  model,
  data = NULL,
  method = c("holdout", "k_fold", "loo"),
  metrics = "all",
  prop = 0.3,
  k = 5,
  stack = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{model}{A regression model.}

\item{data}{Optional. A data frame containing the same variables as \code{model}
that will be used as the cross-validation sample.}

\item{method}{Character string, indicating the cross-validation method to use:
whether holdout (\code{"holdout"}, aka train-test), k-fold (\code{"k_fold"}), or
leave-one-out (\code{"loo"}). If \code{data} is supplied, this argument is ignored.}

\item{metrics}{Can be \code{"all"}, \code{"common"} or a character vector of metrics to be
computed (some of \code{c("ELPD", "Deviance", "MSE", "RMSE", "R2")}). "common" will
compute R2 and RMSE.}

\item{prop}{If \code{method = "holdout"}, what proportion of the sample to hold
out as the test sample?}

\item{k}{If \code{method = "k_fold"}, the number of folds to use.}

\item{stack}{Logical. If \code{method = "k_fold"}, should performance be computed
by stacking residuals from each holdout fold and calculating each metric on
the stacked data (\code{TRUE}, default) or should performance be computed by
calculating metrics within each holdout fold and averaging performance
across each fold (\code{FALSE})?}

\item{verbose}{Toggle warnings.}

\item{...}{Not used.}
}
\value{
A data frame with columns for each metric requested, as well as \code{k}
if \code{method = "holdout"} and the \code{Method} used for cross-validation. If
\code{method = "holdout"} and \code{stack = TRUE}, the standard error (standard
deviation across holdout folds) for each metric is also included.
}
\description{
This function cross-validates regression models in a
user-supplied new sample or by using holdout (train-test), k-fold, or
leave-one-out cross-validation.
}
\examples{
model <- lm(mpg ~ wt + cyl, data = mtcars)
performance_cv(model)

}
