% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_variable_array.R
\name{extract_variable_array}
\alias{extract_variable_array}
\alias{extract_variable_array.default}
\alias{extract_variable_array.draws}
\title{Extract array of a single (possibly indexed) variable}
\usage{
extract_variable_array(x, variable, ...)

\method{extract_variable_array}{default}(x, variable, ...)

\method{extract_variable_array}{draws}(x, variable, ...)
}
\arguments{
\item{x}{(draws) A \code{draws} object or another \R object for which the method
is defined.}

\item{variable}{(string) The name of the variable to extract. To extract all
dimensions from variables with indices (e.g. \code{"x[1]"}), provide the base
variable name (e.g. \code{"x"}).}

\item{...}{Arguments passed to individual methods (if applicable).}
}
\value{
An \code{array} with dimension \code{niterations(x)} x \code{nchains(x)} x any remaining
dimensions determined by the indices of the variable \code{x}.
}
\description{
Extract an array of draws of a single variable, including any dimensions of
variables with indices.
}
\examples{
x <- example_draws(example = "multi_normal")

mu <- extract_variable_array(x, variable = "mu")
str(mu)

mu1 <- extract_variable_array(x, variable = "mu[1]")
str(mu1)

Sigma <- extract_variable_array(x, variable = "Sigma")
str(Sigma)

}
\seealso{
Other variable extraction methods: 
\code{\link{extract_variable}()},
\code{\link{extract_variable_matrix}()}
}
\concept{variable extraction methods}
