% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intCalibration.r
\name{intCalibration}
\alias{intCalibration}
\title{Check Parallelism Assumption of Ordinal Semiparametric Models}
\usage{
intCalibration(
  fit,
  ycuts,
  m,
  x,
  onlydata = FALSE,
  eps = 25,
  bass = 9,
  tsmooth = "lowess",
  hare = TRUE,
  dec = 4,
  xlab = bquote(hat(P)(.(yname) > y)),
  ylab = "Nonparametric Estimate",
  nrow = 1,
  ...
)
}
\arguments{
\item{fit}{a fit object for which there is a \code{\link[=survest]{survest()}} method, with \verb{x=TRUE, y=TRUE} in effect}

\item{ycuts}{a vector of cutpoints on Y}

\item{m}{used when \code{ycuts} is not given.  The lowest cutoff is chosen as the first Y value having at meast \code{m} uncensored observations to its left, and the highest cutoff is chosen so that there are at least \code{m} uncensored observations to the right of it.  Cutoffs are equally spaced between these values in terms of number of uncensored observations.  If omitted, \code{m} is set to the minimum of 50 and one quarter of the uncensored sample size.}

\item{x}{a variable for which calibration-in-the-small is desired, instead of plotting predicted vs. observed probabilities.  \code{x} will typically be chosen by virtue of being a strong predictor (such that lack of fit will matter more) but doesn't have to be in the model.}

\item{onlydata}{set to \code{TRUE} to return a data frame suitable for plotting instead of actually plotting}

\item{eps, bass, tsmooth, hare}{see \code{\link[Hmisc:movStats]{Hmisc::movStats()}}}

\item{dec}{number of digits to the right of the decimal place to which to round computed \code{ycuts}}

\item{xlab}{x-axis label with default constructed from the Y-variable name in the model fit (y-axis label when \code{x} is specified)}

\item{ylab}{y-axis label}

\item{nrow}{if \code{hare=TRUE}, the number of rows in the graph (must be 1 or 2)}

\item{...}{other arguments passed to \code{\link[Hmisc:movStats]{Hmisc::movStats()}}}
}
\value{
\code{ggplot2} object or a data frame
}
\description{
For all the observations used a model fit, computes the estimated probability that Y is greater than each of a number of cutoffs, and compares this to smoothed estimated probabilities as a function of predicted probabilities, to obtain internal model calibration plots with multiple cutpoints.  When Y is uncensored these are smoothed moving empirical cumulative distribution function estimates, and when Y has censored observations these are smoothing moving Kaplan-Meier estimates.  \code{\link[Hmisc:movStats]{Hmisc::movStats()}} is used to do the moving overlapping window calculations.  When \code{hare=TRUE}, adaptive linear spline hazard regression estimates are also made, using \code{\link[polspline:hare]{polspline::hare()}}.
}
\details{
These plots are plots of calibration-in-the-small.  Alternate calibration-in-the-small plots may be obtained by specifying a predictor variable \code{x} against which to plot both predicted and observed probabilties as a function of \code{x}.  This is the only place in the \code{rms} package where the "total effect" of a predictor is estimated instead of a partial effect.  When \code{x} varies and moving overlapping windows of predicted and observed exceedance probabilities are estimated, if \code{x} is collinear with other predictors, they will "come along for the ride".

The function also prints information on calibration-in-the-large, i.e., the mean predicted probability of being beyond each cutpoint vs. the overall proportion of observations above that cutpoint.  This is when \code{x} is not given.
}
\examples{
\dontrun{
getHdata(nhgh)
f <- orm(gh ~ rcs(age, 4), data=nhgh, family='loglog', x=TRUE, y=TRUE)
intCalibration(f, ycuts=c(5, 5.5, 6, 6.5))
f <- update(f, family='cloglog')
intCalibration(f, ycuts=c(5, 5.5, 6, 6.5))
intCalibration(f, ycuts=c(5, 6, 7), x=nhgh$age)
}
}
\author{
Frank Harrell
}
