% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbc-data.R
\docType{data}
\name{pbc}
\alias{pbc}
\title{Primary biliary cirrhosis data}
\format{
\code{pbc} is a dichotomously marked
\code{\link[spatstat.geom:ppp]{ppp.object}}, with locations expressed in UK Ordnance
Survey Coordinates (km).
}
\source{
Prince et al. (2001), The geographical distribution of primary
biliary cirrhosis in a well-defined cohort, \emph{Hepatology}, \bold{34},
1083-1088.
}
\description{
Data of the locations of 761 cases of primary biliary cirrhosis in several
adjacent health regions of north-eastern England, along with 3020 controls
representing the at-risk population, collected between 1987 and 1994. These
data were first presented and analysed by Prince et al. (2001); subsequent
analysis of these data in the spirit of \code{\link{sparr}} was performed in
Davies and Hazelton (2010). Also included is the polygonal study region.
}
\section{Acknowledgements}{
 The authors thank Prof. Peter Diggle for providing access
to these data.
}

\examples{

data(pbc)
summary(pbc)
plot(pbc)

}
\references{
Davies, T.M. and Hazelton, M.L. (2010), Adaptive kernel
estimation of spatial relative risk, \emph{Statistics in Medicine},
\bold{29}(23) 2423-2437.
}
\keyword{data}
