/* automatically generated by rust-bindgen 0.69.5 */

pub const GBM_FORMAT_BIG_ENDIAN: u32 = 2147483648;
pub const GBM_BO_IMPORT_WL_BUFFER: u32 = 21761;
pub const GBM_BO_IMPORT_EGL_IMAGE: u32 = 21762;
pub const GBM_BO_IMPORT_FD: u32 = 21763;
pub const GBM_BO_IMPORT_FD_MODIFIER: u32 = 21764;
pub const GBM_MAX_PLANES: u32 = 4;
#[doc = " \\file gbm.h\n \\brief Generic Buffer Manager"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gbm_device {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gbm_bo {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gbm_surface {
    _unused: [u8; 0],
}
#[doc = " Abstraction representing the handle to a buffer allocated by the\n manager"]
#[repr(C)]
#[derive(Copy, Clone)]
pub union gbm_bo_handle {
    pub ptr: *mut libc::c_void,
    pub s32: i32,
    pub u32_: u32,
    pub s64: i64,
    pub u64_: u64,
}
pub mod gbm_bo_format {
    #[doc = " Format of the allocated buffer"]
    pub type Type = libc::c_uint;
    #[doc = " RGB with 8 bits per channel in a 32 bit value"]
    pub const GBM_BO_FORMAT_XRGB8888: Type = 0;
    #[doc = " ARGB with 8 bits per channel in a 32 bit value"]
    pub const GBM_BO_FORMAT_ARGB8888: Type = 1;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gbm_format_name_desc {
    pub name: [libc::c_char; 5usize],
}
pub mod gbm_bo_flags {
    #[doc = " Flags to indicate the intended use for the buffer - these are passed into\n gbm_bo_create(). The caller must set the union of all the flags that are\n appropriate\n\n \\sa Use gbm_device_is_format_supported() to check if the combination of format\n and use flags are supported"]
    pub type Type = libc::c_uint;
    #[doc = " Buffer is going to be presented to the screen using an API such as KMS"]
    pub const GBM_BO_USE_SCANOUT: Type = 1;
    #[doc = " Buffer is going to be used as cursor"]
    pub const GBM_BO_USE_CURSOR: Type = 2;
    #[doc = " Deprecated"]
    pub const GBM_BO_USE_CURSOR_64X64: Type = 2;
    #[doc = " Buffer is to be used for rendering - for example it is going to be used\n as the storage for a color buffer"]
    pub const GBM_BO_USE_RENDERING: Type = 4;
    #[doc = " Buffer can be used for gbm_bo_write.  This is guaranteed to work\n with GBM_BO_USE_CURSOR, but may not work for other combinations."]
    pub const GBM_BO_USE_WRITE: Type = 8;
    #[doc = " Buffer is linear, i.e. not tiled."]
    pub const GBM_BO_USE_LINEAR: Type = 16;
    #[doc = " Buffer is protected, i.e. encrypted and not readable by CPU or any\n other non-secure / non-trusted components nor by non-trusted OpenGL,\n OpenCL, and Vulkan applications."]
    pub const GBM_BO_USE_PROTECTED: Type = 32;
}
extern "C" {
    pub fn gbm_device_get_fd(gbm: *mut gbm_device) -> libc::c_int;
}
extern "C" {
    pub fn gbm_device_get_backend_name(gbm: *mut gbm_device) -> *const libc::c_char;
}
extern "C" {
    pub fn gbm_device_is_format_supported(
        gbm: *mut gbm_device,
        format: u32,
        flags: u32,
    ) -> libc::c_int;
}
extern "C" {
    pub fn gbm_device_get_format_modifier_plane_count(
        gbm: *mut gbm_device,
        format: u32,
        modifier: u64,
    ) -> libc::c_int;
}
extern "C" {
    pub fn gbm_device_destroy(gbm: *mut gbm_device);
}
extern "C" {
    pub fn gbm_create_device(fd: libc::c_int) -> *mut gbm_device;
}
extern "C" {
    pub fn gbm_bo_create(
        gbm: *mut gbm_device,
        width: u32,
        height: u32,
        format: u32,
        flags: u32,
    ) -> *mut gbm_bo;
}
extern "C" {
    pub fn gbm_bo_create_with_modifiers(
        gbm: *mut gbm_device,
        width: u32,
        height: u32,
        format: u32,
        modifiers: *const u64,
        count: libc::c_uint,
    ) -> *mut gbm_bo;
}
extern "C" {
    pub fn gbm_bo_create_with_modifiers2(
        gbm: *mut gbm_device,
        width: u32,
        height: u32,
        format: u32,
        modifiers: *const u64,
        count: libc::c_uint,
        flags: u32,
    ) -> *mut gbm_bo;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gbm_import_fd_data {
    pub fd: libc::c_int,
    pub width: u32,
    pub height: u32,
    pub stride: u32,
    pub format: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gbm_import_fd_modifier_data {
    pub width: u32,
    pub height: u32,
    pub format: u32,
    pub num_fds: u32,
    pub fds: [libc::c_int; 4usize],
    pub strides: [libc::c_int; 4usize],
    pub offsets: [libc::c_int; 4usize],
    pub modifier: u64,
}
extern "C" {
    pub fn gbm_bo_import(
        gbm: *mut gbm_device,
        type_: u32,
        buffer: *mut libc::c_void,
        flags: u32,
    ) -> *mut gbm_bo;
}
pub mod gbm_bo_transfer_flags {
    #[doc = " Flags to indicate the type of mapping for the buffer - these are\n passed into gbm_bo_map(). The caller must set the union of all the\n flags that are appropriate.\n\n These flags are independent of the GBM_BO_USE_* creation flags. However,\n mapping the buffer may require copying to/from a staging buffer.\n\n See also: pipe_map_flags"]
    pub type Type = libc::c_uint;
    #[doc = " Buffer contents read back (or accessed directly) at transfer\n create time."]
    pub const GBM_BO_TRANSFER_READ: Type = 1;
    #[doc = " Buffer contents will be written back at unmap time\n (or modified as a result of being accessed directly)."]
    pub const GBM_BO_TRANSFER_WRITE: Type = 2;
    #[doc = " Read/modify/write"]
    pub const GBM_BO_TRANSFER_READ_WRITE: Type = 3;
}
extern "C" {
    pub fn gbm_bo_map(
        bo: *mut gbm_bo,
        x: u32,
        y: u32,
        width: u32,
        height: u32,
        flags: u32,
        stride: *mut u32,
        map_data: *mut *mut libc::c_void,
    ) -> *mut libc::c_void;
}
extern "C" {
    pub fn gbm_bo_unmap(bo: *mut gbm_bo, map_data: *mut libc::c_void);
}
extern "C" {
    pub fn gbm_bo_get_width(bo: *mut gbm_bo) -> u32;
}
extern "C" {
    pub fn gbm_bo_get_height(bo: *mut gbm_bo) -> u32;
}
extern "C" {
    pub fn gbm_bo_get_stride(bo: *mut gbm_bo) -> u32;
}
extern "C" {
    pub fn gbm_bo_get_stride_for_plane(bo: *mut gbm_bo, plane: libc::c_int) -> u32;
}
extern "C" {
    pub fn gbm_bo_get_format(bo: *mut gbm_bo) -> u32;
}
extern "C" {
    pub fn gbm_bo_get_bpp(bo: *mut gbm_bo) -> u32;
}
extern "C" {
    pub fn gbm_bo_get_offset(bo: *mut gbm_bo, plane: libc::c_int) -> u32;
}
extern "C" {
    pub fn gbm_bo_get_device(bo: *mut gbm_bo) -> *mut gbm_device;
}
extern "C" {
    pub fn gbm_bo_get_handle(bo: *mut gbm_bo) -> gbm_bo_handle;
}
extern "C" {
    pub fn gbm_bo_get_fd(bo: *mut gbm_bo) -> libc::c_int;
}
extern "C" {
    pub fn gbm_bo_get_modifier(bo: *mut gbm_bo) -> u64;
}
extern "C" {
    pub fn gbm_bo_get_plane_count(bo: *mut gbm_bo) -> libc::c_int;
}
extern "C" {
    pub fn gbm_bo_get_handle_for_plane(bo: *mut gbm_bo, plane: libc::c_int) -> gbm_bo_handle;
}
extern "C" {
    pub fn gbm_bo_get_fd_for_plane(bo: *mut gbm_bo, plane: libc::c_int) -> libc::c_int;
}
extern "C" {
    pub fn gbm_bo_write(bo: *mut gbm_bo, buf: *const libc::c_void, count: usize) -> libc::c_int;
}
extern "C" {
    pub fn gbm_bo_set_user_data(
        bo: *mut gbm_bo,
        data: *mut libc::c_void,
        destroy_user_data: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut gbm_bo, arg2: *mut libc::c_void),
        >,
    );
}
extern "C" {
    pub fn gbm_bo_get_user_data(bo: *mut gbm_bo) -> *mut libc::c_void;
}
extern "C" {
    pub fn gbm_bo_destroy(bo: *mut gbm_bo);
}
extern "C" {
    pub fn gbm_surface_create(
        gbm: *mut gbm_device,
        width: u32,
        height: u32,
        format: u32,
        flags: u32,
    ) -> *mut gbm_surface;
}
extern "C" {
    pub fn gbm_surface_create_with_modifiers(
        gbm: *mut gbm_device,
        width: u32,
        height: u32,
        format: u32,
        modifiers: *const u64,
        count: libc::c_uint,
    ) -> *mut gbm_surface;
}
extern "C" {
    pub fn gbm_surface_create_with_modifiers2(
        gbm: *mut gbm_device,
        width: u32,
        height: u32,
        format: u32,
        modifiers: *const u64,
        count: libc::c_uint,
        flags: u32,
    ) -> *mut gbm_surface;
}
extern "C" {
    pub fn gbm_surface_lock_front_buffer(surface: *mut gbm_surface) -> *mut gbm_bo;
}
extern "C" {
    pub fn gbm_surface_release_buffer(surface: *mut gbm_surface, bo: *mut gbm_bo);
}
extern "C" {
    pub fn gbm_surface_has_free_buffers(surface: *mut gbm_surface) -> libc::c_int;
}
extern "C" {
    pub fn gbm_surface_destroy(surface: *mut gbm_surface);
}
extern "C" {
    pub fn gbm_format_get_name(
        gbm_format: u32,
        desc: *mut gbm_format_name_desc,
    ) -> *mut libc::c_char;
}
