# 2022-10-26 Triage Log

An amazing week. We saw more wins than losses; I want to call out specifically
the wins from removing attributes from metadata (up to 8.2% faster builds for 18
benchmarks) and from enabling LTO for rustc_driver.so (up to 9.6% faster builds
for an epic 230 benchmarks, with *zero* regressions).

Triage done by **@pnkfelix**.
Revision range: [e0f8e60d..629a414d](https://perf.rust-lang.org/?start=e0f8e60dddfecfc9093ee9d9f42557d8260c0355&end=629a414d7ba4caa3ca28b0a46c478e2ecb4c0059&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | 0.7% | [0.7%, 0.7%] | 2     |
| Improvements ✅ <br /> (primary) | -4.3% | [-9.4%, -0.4%] | 231   |
| Improvements ✅ <br /> (secondary) | -4.4% | [-9.5%, -0.5%] | 256   |
| All ❌✅ (primary) | -4.3% | [-9.4%, -0.4%] | 231   |


2 Regressions, 6 Improvements, 2 Mixed; 2 of them in rollups
53 artifact comparisons made in total

#### Regressions

Add default trait implementations for "c-unwind" ABI function pointers [#101263](https://github.com/rust-lang/rust/pull/101263) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=57e2c06a8df3187980801962015a88657abd033d&end=5c8bff74bc1c52bef0c79f3689bb227f51f3e82d&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.9% | [0.2%, 2.6%] | 19    |
| Regressions ❌ <br /> (secondary) | 1.9% | [0.4%, 3.0%] | 23    |
| Improvements ✅ <br /> (primary) | -    | -     | 0     |
| Improvements ✅ <br /> (secondary) | -    | -     | 0     |
| All ❌✅ (primary) | 0.9% | [0.2%, 2.6%] | 19    |

* already triaged; all doc perf regressions, and already deemed acceptable.


Rollup of 10 pull requests [#103562](https://github.com/rust-lang/rust/pull/103562) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d49e7e7fa13479c11a3733824c78e280e391288b&end=629a414d7ba4caa3ca28b0a46c478e2ecb4c0059&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.3% | [0.2%, 0.4%] | 43    |
| Regressions ❌ <br /> (secondary) | 0.5% | [0.2%, 1.2%] | 25    |
| Improvements ✅ <br /> (primary) | -    | -     | 0     |
| Improvements ✅ <br /> (secondary) | -    | -     | 0     |
| All ❌✅ (primary) | 0.3% | [0.2%, 0.4%] | 43    |

* all of the primary regressions (which seem small) are all in incr-patched scenarios. Most are also check builds, though there is some debug and opt mixed in as well.
* hard to tell from the list of rolled up PR's which one(s) would be to blame here
* w.r.t. the secondary benchmarks, the main contributor (in terms of the max regression observed) is `deeply-nested-multi`, which regressed by 0.74--1.2% depending on the scenario.
  * (In this case, the 1.2% regression is to a full build, not an incremental one.)
* In any case, the sheer number of impacted benchmarks is large enough that this warrants further review. Not marking as triaged. I'll try to dig into it later.

#### Improvements

Use Set instead of Vec in transitive_relation [#103214](https://github.com/rust-lang/rust/pull/103214) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d7dd01fe8b071602510eaac9f676acc0e3cf8e4a&end=4b8f4319954ff2642690b9e5cbe4af352d095bf6&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -0.6% | [-0.7%, -0.6%] | 2     |
| Improvements ✅ <br /> (secondary) | -1.2% | [-1.6%, -0.6%] | 7     |
| All ❌✅ (primary) | -0.6% | [-0.7%, -0.6%] | 2     |

* as noted in PR description: "doesn't fix the underlying quadraticness but it makes it a lot faster to an extent where even doubling the amount of nested references still takes less than two seconds (50s on nightly)."

Remove more attributes from metadata [#98450](https://github.com/rust-lang/rust/pull/98450) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=657f246812ab2684e3c3954b1c77f98fd59e0b21&end=ba9d01be67a97dd6762935762172e37ee22083ae&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | 0.3% | [0.3%, 0.3%] | 1     |
| Improvements ✅ <br /> (primary) | -2.7% | [-8.2%, -0.2%] | 18    |
| Improvements ✅ <br /> (secondary) | -5.5% | [-8.4%, -0.8%] | 23    |
| All ❌✅ (primary) | -2.7% | [-8.2%, -0.2%] | 18    |

* This PR's comment+development history are pretty epic. :smile:
* anyway, great work from @lqd and @GuillaumeGomez

stop using `ty::UnevaluatedConst` directly [#103227](https://github.com/rust-lang/rust/pull/103227) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3022afe3d144ca6acd34da9846ab74fa51328fda&end=26c96e341639102afacbbcad0dc18ad0ac71ab18&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -0.3% | [-0.4%, -0.2%] | 10    |
| Improvements ✅ <br /> (secondary) | -    | -     | 0     |
| All ❌✅ (primary) | -0.3% | [-0.4%, -0.2%] | 10    |


Enable LTO for rustc_driver.so [#101403](https://github.com/rust-lang/rust/pull/101403) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9be2f35a4c1ed1b04aa4a6945b64763f599259ff&end=1ca6777c014813e3bdb98d155562fc3d111d86dd&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -4.2% | [-9.6%, -0.4%] | 230   |
| Improvements ✅ <br /> (secondary) | -4.0% | [-9.5%, -0.4%] | 257   |
| All ❌✅ (primary) | -4.2% | [-9.6%, -0.4%] | 230   |

* Holy cow: 9.6% faster compiling diesel, 7% faster compiling serde, 1.3% faster bootstrap. Epic wins there.
* there is perhaps concern that it caused [#103538](https://github.com/rust-lang/rust/issues/103538): "rustc-dev component recently became a lot bigger"

Rollup of 11 pull requests [#103502](https://github.com/rust-lang/rust/pull/103502) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=758f19645b8ebce61ea52d1f6672fd057bc8dbee&end=f2702e922ba31e49d6167f5651d4545646dcf22d&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | 2.3% | [2.3%, 2.3%] | 1     |
| Improvements ✅ <br /> (primary) | -0.5% | [-0.5%, -0.5%] | 1     |
| Improvements ✅ <br /> (secondary) | -0.9% | [-1.2%, -0.8%] | 6     |
| All ❌✅ (primary) | -0.5% | [-0.5%, -0.5%] | 1     |



Perf improvements for effective visibility calculating [#103158](https://github.com/rust-lang/rust/pull/103158) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6365e5ad9fa9e2ec867a67aeeae414e7c62d8354&end=a5406feb1cf1a9f2479b72917cf4225e5f6aa240&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -0.4% | [-0.5%, -0.3%] | 6     |
| Improvements ✅ <br /> (secondary) | -0.6% | [-2.0%, -0.2%] | 22    |
| All ❌✅ (primary) | -0.4% | [-0.5%, -0.3%] | 6     |

* libc build times improved by ~1% in ten scenarios



#### Mixed

Deny hashing ty/re/ct inference variables [#103220](https://github.com/rust-lang/rust/pull/103220) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ebdde35dced40adb46f8aad054fb2adb86b39427&end=4b3b731b55a588dd34a75bbb87fdaaec2e3f5707&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | 0.8% | [0.5%, 1.2%] | 8     |
| Improvements ✅ <br /> (primary) | -0.2% | [-0.3%, -0.2%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.9% | [-1.0%, -0.5%] | 9     |
| All ❌✅ (primary) | -0.2% | [-0.3%, -0.2%] | 2     |

* already triaged: "The perf changes are small and the wins balance out the losses. No need to stress on this one, I think."

Remove ParamEnv from uninhabited query [#102660](https://github.com/rust-lang/rust/pull/102660) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6e95b6da885f42a4e1314595089fa4295e329d11&end=6c9c2d862dd10718ba2b2a320c3390995ad414bc&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | 1.5% | [1.2%, 1.7%] | 7     |
| Improvements ✅ <br /> (primary) | -0.2% | [-0.2%, -0.2%] | 2     |
| Improvements ✅ <br /> (secondary) | -1.2% | [-1.2%, -1.2%] | 3     |
| All ❌✅ (primary) | -0.2% | [-0.2%, -0.2%] | 2     |

* Not sure why this was flagged as Mixed rather than Improvement.
* Marked as triaged.

#### Untriaged Pull Requests

- [#103562 Rollup of 10 pull requests](https://github.com/rust-lang/rust/pull/103562)
- [#102975 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/102975)
- [#102915 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/102915)
- [#102895 Get rid of `rustc_query_description!`](https://github.com/rust-lang/rust/pull/102895)
- [#102867 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/102867)
- [#102809 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/102809)
- [#102660 Remove ParamEnv from uninhabited query](https://github.com/rust-lang/rust/pull/102660)
- [#102548 Mark Cell::replace() as #[inline]](https://github.com/rust-lang/rust/pull/102548)
- [#102026 Populate effective visibilities in 'rustc_resolve'](https://github.com/rust-lang/rust/pull/102026)
- [#101858 derive various impls instead of hand-rolling them](https://github.com/rust-lang/rust/pull/101858)
- [#101857 change `FnMutDelegate` to trait objects](https://github.com/rust-lang/rust/pull/101857)
- [#101632 Remove `TypeckResults` from `InferCtxt`](https://github.com/rust-lang/rust/pull/101632)
- [#101620 Compute lint levels by definition](https://github.com/rust-lang/rust/pull/101620)
- [#101433 Emit a note that static bounds from HRTBs are a bug](https://github.com/rust-lang/rust/pull/101433)
- [#100982 Require `#[const_trait]` on `Trait` for `impl const Trait`](https://github.com/rust-lang/rust/pull/100982)
- [#100963 Rollup of 15 pull requests](https://github.com/rust-lang/rust/pull/100963)
- [#100869 Replace `rustc_data_structures::thin_vec::ThinVec` with `thin_vec::ThinVec`](https://github.com/rust-lang/rust/pull/100869)
- [#100841 update Miri](https://github.com/rust-lang/rust/pull/100841)
- [#100759 Make `const_eval_select` a real intrinsic](https://github.com/rust-lang/rust/pull/100759)
- [#100748 add `depth_limit` in `QueryVTable` to avoid entering a new tcx in `layout_of`](https://github.com/rust-lang/rust/pull/100748)
- [#100676 implied bounds: explicitly state which types are assumed to be wf](https://github.com/rust-lang/rust/pull/100676)
- [#100652 Remove deferred sized checks (make them eager)](https://github.com/rust-lang/rust/pull/100652)
- [#100497 Avoid cloning a collection only to iterate over it](https://github.com/rust-lang/rust/pull/100497)
- [#100429 rustdoc: Merge source code pages HTML elements together](https://github.com/rust-lang/rust/pull/100429)
- [#100293 Add inline-llvm option for disabling/enabling LLVM inlining](https://github.com/rust-lang/rust/pull/100293)
- [#100096 a fn pointer doesn't implement `Fn`/`FnMut`/`FnOnce` if its return type isn't sized](https://github.com/rust-lang/rust/pull/100096)
- [#99792 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/99792)
- [#99520 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/99520)
- [#99251 Upgrade indexmap and thorin-dwp to use hashbrown 0.12](https://github.com/rust-lang/rust/pull/99251)
- [#99231 Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/99231)

#### Nags requiring follow up

TODO: Nags

