# 2023-12-26 Triage Log

Some of the recent noise swings have been appearing again this week, but luckily
less often than before. There were a few actual regressions, but most of them
were localized to a single stress test. On the other hand, there were a few very
nice wins across the board, especially for check and incremental builds, primarily
thanks to [#118824](https://github.com/rust-lang/rust/pull/118824) and
[#119265](https://github.com/rust-lang/rust/pull/119265).

Triage done by **@kobzol**.
Revision range: [bf9229a2e366b4c311f059014a4aa08af16de5d8..1ab783112ab4e4807304dbd249b39771246013ef](https://perf.rust-lang.org/?start=bf9229a2e366b4c311f059014a4aa08af16de5d8&end=1ab783112ab4e4807304dbd249b39771246013ef&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%  | [0.6%, 0.6%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 2.5%  | [0.3%, 4.2%]   | 10    |
| Improvements ✅ <br /> (primary)   | -0.8% | [-3.3%, -0.1%] | 180   |
| Improvements ✅ <br /> (secondary) | -1.2% | [-5.5%, -0.2%] | 109   |
| All ❌✅ (primary)                 | -0.8% | [-3.3%, 0.6%]  | 181   |


5 Regressions, 7 Improvements, 2 Mixed; 1 of them in rollups
58 artifact comparisons made in total

#### Regressions

Make exhaustiveness usable outside of rustc [#118842](https://github.com/rust-lang/rust/pull/118842) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c9c9f527e373efbb755e88661aaf012ad6a2d17c&end=3a539c08891a422d34beb32d2556a08ea0357b7d&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.9%  | [0.9%, 1.0%]   | 6     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.4%, -0.4%] | 1     |
| All ❌✅ (primary)                 | -     | -              | 0     |

* This PR enables the use of exhaustiveness checking e.g. in rust-analyzer, which is part of the
"librarification effort". The small regression in a single stress-test benchmark is worth it.

mark ty::Const::Error when meet unsupport ty for const generic params [#117176](https://github.com/rust-lang/rust/pull/117176) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=cf6427373b8b6d4b8efed2087fb9df5149e69e67&end=08cc634f1a26f30801daa1cbe7b866b12aaf1edd&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7% | [0.6%, 0.7%] | 4     |
| Regressions ❌ <br /> (secondary)  | 0.4% | [0.2%, 0.6%] | 19    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.7% | [0.6%, 0.7%] | 4     |

* This PR only added a test, so this has to be noise.
* Already marked as triaged by @jackh726

Exhaustiveness: Improve complexity on some wide matches [#118796](https://github.com/rust-lang/rust/pull/118796) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ebb821f625db3cbc77c675326165b8dfc3d7a2be&end=1a086e49f14dd019a6ee147b6a9a72b32ac3fe2b&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 2.9%  | [2.6%, 3.1%]   | 6     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -1.3% | [-1.3%, -1.3%] | 1     |
| All ❌✅ (primary)                 | -     | -              | 0     |

* This PR fixed a potential hang in the compiler, the regression of the match checking stress-test
is unfortunate, but it's more important to avoid the pathological case.
* Already marked as triaged by @apiraino

Subtree sync for rustc_codegen_cranelift [#119278](https://github.com/rust-lang/rust/pull/119278) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1a086e49f14dd019a6ee147b6a9a72b32ac3fe2b&end=f736079c3caceca1adfd75822c754e1e31bddc3d&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.9% | [0.8%, 0.9%] | 3     |
| Regressions ❌ <br /> (secondary)  | 0.5% | [0.3%, 0.7%] | 20    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.9% | [0.8%, 0.9%] | 3     |

* Noise

fix ICE when using raw ptr in a pattern [#119274](https://github.com/rust-lang/rust/pull/119274) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=bf8716f1cd6416266807706bcae0ecb2e51c9d4a&end=471dcbdb0910bcacbef6732e5ec1dab0dcd6b999&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7% | [0.7%, 0.7%] | 1     |
| Regressions ❌ <br /> (secondary)  | 0.4% | [0.3%, 0.5%] | 6     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.7% | [0.7%, 0.7%] | 1     |

* Noise

#### Improvements

fast path for declared_generic_bounds_from_env [#119084](https://github.com/rust-lang/rust/pull/119084) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3a539c08891a422d34beb32d2556a08ea0357b7d&end=57ad5058d643d06c0e76bb85442ff9244d966f34&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.9% | [-2.9%, -0.2%] | 8     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -1.9% | [-2.9%, -0.2%] | 8     |

* Very nice improvement to diesel.

use Vec for region constraints instead of BTreeMap [#118824](https://github.com/rust-lang/rust/pull/118824) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=398fd92e177cd1a47ae1bb146506953e87e73d30&end=d6d7a93866f2ffcfb51828b8859bdad760b54ce0&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-1.3%, -0.2%] | 39    |
| Improvements ✅ <br /> (secondary) | -0.7% | [-1.7%, -0.2%] | 29    |
| All ❌✅ (primary)                 | -0.5% | [-1.3%, -0.2%] | 39    |

* Nice improvements to check builds across the board.

Rollup of 6 pull requests [#119237](https://github.com/rust-lang/rust/pull/119237) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=495203bf61efabecc2c460be38e1eb0f9952601b&end=c03d978a4bcb7c01d8cdf80bd7600b27e2d21588&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.8%, -0.3%] | 17    |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.6%, -0.2%] | 10    |
| All ❌✅ (primary)                 | -0.5% | [-0.8%, -0.3%] | 17    |

* Nice win for type checking across several benchmarks. It's unclear which PR from the rollup
has caused the wins though.

Stabilize ip_in_core feature [#119276](https://github.com/rust-lang/rust/pull/119276) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f736079c3caceca1adfd75822c754e1e31bddc3d&end=e87ccb8676be9ab641849a2539b215d0c9027237&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.9% | [-0.9%, -0.8%] | 4     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.8%, -0.2%] | 21    |
| All ❌✅ (primary)                 | -0.9% | [-0.9%, -0.8%] | 4     |

* This is just noise returning back to steady state.

Unify SourceFile::name_hash and StableSourceFileId [#119139](https://github.com/rust-lang/rust/pull/119139) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e87ccb8676be9ab641849a2539b215d0c9027237&end=bf8716f1cd6416266807706bcae0ecb2e51c9d4a&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.1%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.8% | [-0.9%, -0.6%] | 3     |
| All ❌✅ (primary)                 | -0.2% | [-0.2%, -0.1%] | 3     |

* A few small wins for incremental benchmarks.

Fix display of warning block if it is first element of the top doc block [#119283](https://github.com/rust-lang/rust/pull/119283) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=471dcbdb0910bcacbef6732e5ec1dab0dcd6b999&end=b87f649a5de8496df7be2fd272da5f1d42d82087&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-0.7%, -0.7%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.6%, -0.3%] | 5     |
| All ❌✅ (primary)                 | -0.7% | [-0.7%, -0.7%] | 2     |

* This PR only modified the UI and tests of rustdoc, so this is just noise.

Make closures carry their own ClosureKind [#119258](https://github.com/rust-lang/rust/pull/119258) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2271c26e4a8e062bb00d709d0ccb5846e0c341b9&end=1ab783112ab4e4807304dbd249b39771246013ef&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.1% | [-1.1%, -1.1%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -1.1% | [-1.1%, -1.1%] | 1     |

* This is probably just noise.

#### Mixed

add more niches to rawvec [#106790](https://github.com/rust-lang/rust/pull/106790) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f704f3b93b1543cf504ecca0052f9f8531b1f61f&end=51c0db6a9118735190466d15432b5d8890bb09ee&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.1%, 0.7%]   | 20    |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.2%, 1.0%]   | 2     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-2.0%, -0.1%] | 27    |
| Improvements ✅ <br /> (secondary) | -0.9% | [-5.3%, -0.2%] | 16    |
| All ❌✅ (primary)                 | -0.1% | [-2.0%, 0.7%]  | 47    |

* This PR enabled more optimization opportunities for LLVM, which could in theory help with
program optimization, but it also caused some binary size increases and compile-time regressions.
* Not marking as triaged yet.

Remove metadata decoding DefPathHash cache [#119265](https://github.com/rust-lang/rust/pull/119265) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=08cc634f1a26f30801daa1cbe7b866b12aaf1edd&end=ebb821f625db3cbc77c675326165b8dfc3d7a2be&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.9%  | [0.9%, 0.9%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.6% | [-2.1%, -0.2%] | 101   |
| Improvements ✅ <br /> (secondary) | -1.2% | [-3.2%, -0.2%] | 65    |
| All ❌✅ (primary)                 | -0.6% | [-2.1%, 0.9%]  | 102   |

* Very nice check and incremental wins across the board.
* The single regression is probably just noise returning back to steady state.
