// Copyright 2016 The Rust Project Developers. See the COPYRIGHT
// file at the top-level directory of this distribution and at
// http://rust-lang.org/COPYRIGHT.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

// This benchmark is inspired by https://github.com/urschrei/ostn15_phf, which
// showed up in issue #36799 because rustc was OOMing while compiling it. The
// source file in question contained two large arrays of tuples, one with
// ~175,000 entries, the other with ~877,000 entries.
//
// The code below consists of a single array containing 65,535 entries, which
// has the same structure (a nested tuple) as the larger of the two arrays from
// the original. (The length of 65,535 was chosen to keep compile times
// reasonable.) The particular values in the array don't matter and were
// generated with the following Python code.
//
// #! /usr/bin/python
// import random
// for i in xrange(0, 0xffff):
//     print('    ({}, ({:.3f}, {:.3f}, {:.3f})),'.format(
//         random.randint(1, 999999),
//         random.uniform(0.0, 9.999),
//         random.uniform(10.0, 19.999),
//         random.uniform(20.0, 29.999)))

static BIG_ARRAY_OF_TUPLES: [(i32, (f64, f64, f64)); 0xffff] = [
    (641161, (2.988, 10.544, 29.598)),
    (808569, (3.303, 18.434, 28.774)),
    (669534, (0.411, 15.099, 24.342)),
    (912177, (2.570, 14.758, 25.901)),
    (738872, (2.521, 14.354, 27.748)),
    (514437, (5.994, 12.283, 21.570)),
    (74590, (7.524, 14.671, 21.397)),
    (289428, (7.477, 18.247, 26.453)),
    (167523, (9.049, 10.905, 20.651)),
    (182653, (9.742, 19.827, 22.806)),
    (133834, (7.838, 12.224, 26.344)),
    (686059, (4.548, 19.950, 28.938)),
    (864951, (2.289, 18.378, 25.639)),
    (980948, (8.904, 18.781, 29.602)),
    (446688, (0.844, 15.246, 20.137)),
    (708019, (8.503, 16.637, 25.058)),
    (116165, (8.486, 18.725, 21.278)),
    (962730, (2.187, 19.102, 28.889)),
    (155118, (6.112, 13.337, 27.994)),
    (82658, (8.319, 15.240, 24.967)),
    (449217, (8.137, 18.304, 29.403)),
    (297354, (9.140, 16.979, 29.038)),
    (500919, (0.921, 19.637, 20.811)),
    (335741, (5.814, 17.730, 21.763)),
    (22751, (1.576, 18.576, 26.889)),
    (388552, (0.824, 11.668, 23.369)),
    (140055, (0.225, 15.008, 20.245)),
    (599645, (9.661, 18.825, 25.103)),
    (670917, (1.954, 19.046, 27.758)),
    (295682, (2.381, 10.727, 24.703)),
    (461719, (8.773, 15.652, 24.773)),
    (758705, (4.035, 15.648, 28.149)),
    (675729, (3.744, 14.321, 22.995)),
    (615979, (7.175, 12.723, 28.056)),
    (521013, (5.287, 13.387, 26.798)),
    (675194, (8.321, 11.052, 25.081)),
    (621080, (2.838, 17.786, 26.174)),
    (733726, (3.157, 16.554, 20.625)),
    (268932, (3.644, 10.552, 25.147)),
    (920248, (4.535, 12.326, 26.255)),
    (413049, (4.147, 13.361, 27.070)),
    (52242, (5.426, 12.330, 29.617)),
    (601423, (5.963, 10.182, 29.444)),
    (835058, (6.063, 15.404, 24.652)),
    (581232, (5.995, 16.381, 29.445)),
    (577626, (2.322, 12.526, 26.921)),
    (957145, (9.428, 19.975, 22.698)),
    (618009, (0.101, 11.899, 24.241)),
    (163954, (3.775, 10.704, 24.540)),
    (396875, (0.198, 12.611, 20.636)),
    (304893, (9.250, 17.758, 28.355)),
    (369534, (1.831, 13.951, 22.756)),
    (871054, (8.703, 10.170, 27.779)),
    (49391, (4.933, 11.793, 22.701)),
    (277201, (7.149, 13.857, 27.709)),
    (79197, (5.866, 19.233, 29.261)),
    (317482, (3.742, 12.217, 26.953)),
    (186612, (2.351, 16.441, 29.189)),
    (115642, (4.096, 12.304, 21.823)),
    (468965, (2.210, 14.777, 24.393)),
    (609329, (8.057, 12.647, 26.299)),
    (100053, (9.588, 19.627, 29.976)),
    (292659, (1.165, 15.264, 23.559)),
    (904931, (0.529, 13.136, 25.323)),
    (267822, (2.514, 16.254, 28.571)),
    (142836, (4.405, 13.534, 26.077)),
    (147604, (0.294, 19.723, 28.825)),
    (458567, (7.483, 17.500, 26.030)),
    (884610, (6.907, 15.009, 23.540)),
    (647939, (5.650, 11.273, 29.620)),
    (599411, (0.689, 16.047, 24.458)),
    (880520, (1.720, 14.125, 21.056)),
    (318177, (9.450, 13.255, 20.897)),
    (103787, (0.044, 18.004, 20.529)),
    (356319, (3.561, 11.171, 28.038)),
    (326751, (7.699, 17.801, 26.646)),
    (664119, (3.108, 18.102, 25.820)),
    (241295, (0.510, 12.840, 29.399)),
    (426160, (3.195, 10.057, 20.043)),
    (37524, (7.268, 13.392, 21.303)),
    (410705, (3.179, 10.168, 28.420)),
    (786899, (7.304, 10.039, 28.956)),
    (615040, (8.228, 15.696, 29.031)),
    (426689, (4.080, 10.682, 24.116)),
    (233413, (8.325, 10.077, 22.668)),
    (85797, (3.378, 13.805, 24.686)),
    (544964, (3.642, 18.649, 22.892)),
    (273037, (5.598, 10.748, 28.316)),
    (789721, (8.256, 17.543, 28.834)),
    (426771, (6.396, 10.526, 28.172)),
    (589441, (6.303, 16.536, 23.310)),
    (83793, (4.078, 12.274, 24.241)),
    (216451, (4.861, 12.565, 20.097)),
    (800100, (6.485, 18.771, 25.390)),
    (850433, (3.911, 18.332, 26.690)),
    (633776, (5.590, 16.523, 28.382)),
    (338250, (6.586, 14.858, 20.026)),
    (992045, (3.829, 10.871, 28.110)),
    (657552, (6.689, 14.078, 22.076)),
    (583095, (1.290, 13.204, 22.248)),
    (553508, (5.175, 11.535, 25.016)),
    (806934, (7.722, 10.237, 29.980)),
    (550039, (2.965, 14.326, 20.630)),
    (187331, (7.955, 10.775, 25.043)),
    (359210, (2.657, 19.694, 23.757)),
    (198380, (1.744, 17.358, 21.558)),
    (206118, (8.731, 15.609, 27.179)),
    (941268, (9.724, 10.475, 29.523)),
    (338616, (8.558, 10.920, 22.791)),
    (190412, (6.921, 18.738, 29.840)),
    (346528, (4.786, 18.444, 28.350)),
    (738270, (1.239, 18.866, 21.173)),
    (144959, (0.821, 15.905, 24.552)),
    (646368, (9.556, 10.491, 24.364)),
    (449953, (5.709, 11.855, 23.004)),
    (95537, (7.036, 16.388, 23.091)),
    (782446, (7.826, 13.566, 26.465)),
    (996111, (1.561, 10.445, 24.278)),
    (237207, (9.220, 13.817, 24.784)),
    (643639, (3.270, 12.424, 20.336)),
    (989456, (3.905, 16.789, 22.925)),
    (566012, (1.828, 17.735, 25.538)),
    (257244, (2.653, 10.151, 25.978)),
    (101578, (5.990, 15.896, 26.825)),
    (356876, (4.308, 19.679, 29.717)),
    (603270, (2.456, 15.376, 24.508)),
    (386416, (9.842, 17.790, 23.552)),
    (307246, (2.615, 18.822, 23.449)),
    (517724, (1.889, 16.270, 21.049)),
    (889848, (5.355, 13.636, 27.576)),
    (567656, (3.110, 10.196, 26.670)),
    (672707, (3.839, 14.338, 26.644)),
    (678297, (1.821, 13.262, 28.102)),
    (667639, (4.866, 13.094, 20.874)),
    (500487, (2.256, 12.496, 25.787)),
    (174384, (1.187, 13.218, 29.047)),
    (753258, (4.932, 11.232, 29.053)),
    (351799, (2.022, 13.774, 20.101)),
    (435001, (5.772, 16.095, 29.293)),
    (817741, (8.216, 10.557, 21.321)),
    (658238, (4.194, 11.030, 21.736)),
    (977259, (8.087, 12.194, 21.873)),
    (758782, (6.138, 16.170, 20.838)),
    (354355, (6.000, 15.015, 23.240)),
    (854437, (9.897, 11.550, 22.381)),
    (670529, (3.221, 12.536, 28.084)),
    (456719, (1.128, 10.791, 22.104)),
    (989255, (0.514, 11.442, 29.447)),
    (275802, (4.859, 15.466, 25.023)),
    (397291, (6.957, 14.445, 26.559)),
    (383697, (2.854, 13.912, 22.128)),
    (270905, (9.742, 15.044, 26.172)),
    (970746, (8.626, 16.305, 28.252)),
    (651289, (8.906, 18.873, 23.026)),
    (727519, (6.760, 10.232, 26.592)),
    (216418, (9.907, 13.470, 29.651)),
    (951853, (4.309, 11.326, 21.858)),
    (987477, (3.991, 13.368, 25.105)),
    (216640, (1.683, 19.950, 28.828)),
    (965725, (7.450, 15.487, 24.303)),
    (70658, (7.056, 15.935, 29.614)),
    (875065, (0.394, 15.761, 21.285)),
    (416684, (5.109, 10.273, 24.997)),
    (351401, (4.129, 16.345, 20.168)),
    (832448, (3.575, 14.392, 23.635)),
    (724295, (7.993, 18.279, 23.268)),
    (840681, (9.799, 19.372, 20.969)),
    (164031, (2.469, 10.174, 25.626)),
    (790700, (6.130, 13.930, 20.051)),
    (604125, (3.352, 18.362, 26.790)),
    (222559, (2.660, 16.220, 23.276)),
    (161501, (8.304, 14.122, 25.961)),
    (780435, (4.184, 13.424, 24.033)),
    (767990, (3.380, 17.853, 25.148)),
    (953955, (6.469, 16.385, 23.079)),
    (67232, (2.941, 12.782, 22.993)),
    (975651, (9.565, 13.088, 29.432)),
    (687289, (5.392, 10.163, 24.172)),
    (163661, (3.629, 10.357, 20.973)),
    (760801, (6.852, 19.099, 29.981)),
    (608125, (1.817, 14.570, 20.386)),
    (208433, (0.920, 19.441, 27.794)),
    (475207, (5.842, 18.441, 22.893)),
    (523400, (6.823, 14.105, 26.800)),
    (109361, (0.506, 19.985, 27.211)),
    (694904, (8.450, 14.206, 28.491)),
    (845900, (1.775, 13.409, 26.563)),
    (301806, (4.682, 11.091, 20.583)),
    (991046, (4.041, 13.990, 27.291)),
    (855679, (7.760, 13.418, 21.617)),
    (450207, (9.682, 13.287, 22.866)),
    (526724, (3.285, 14.988, 29.078)),
    (955985, (9.462, 16.548, 21.460)),
    (938437, (1.398, 10.686, 27.437)),
    (874402, (9.589, 13.826, 26.684)),
    (215199, (6.566, 12.071, 24.001)),
    (423253, (0.311, 17.649, 24.244)),
    (312427, (3.261, 12.675, 23.338)),
    (409348, (4.722, 12.937, 29.785)),
    (333279, (8.480, 10.961, 27.520)),
    (840903, (3.625, 11.668, 26.164)),
    (280865, (1.532, 10.087, 20.801)),
    (696958, (4.234, 14.861, 25.370)),
    (725712, (6.441, 14.295, 20.727)),
    (904912, (0.656, 13.843, 22.643)),
    (462281, (0.318, 18.138, 26.651)),
    (565035, (1.510, 14.605, 28.588)),
    (257253, (3.692, 19.686, 27.841)),
    (133179, (3.986, 19.175, 26.032)),
    (34868, (9.350, 10.443, 20.352)),
    (271966, (3.851, 14.875, 28.450)),
    (158816, (8.547, 12.992, 21.049)),
    (232621, (2.811, 18.690, 23.928)),
    (611027, (0.802, 14.815, 21.124)),
    (974254, (8.852, 10.361, 29.144)),
    (356688, (2.126, 10.667, 27.088)),
    (466983, (1.858, 10.070, 27.310)),
    (435169, (7.773, 16.221, 26.835)),
    (399014, (4.633, 16.549, 28.169)),
    (602966, (0.018, 12.125, 29.373)),
    (167906, (3.320, 10.919, 24.415)),
    (104442, (6.607, 11.531, 23.495)),
    (795419, (5.919, 16.970, 20.599)),
    (696850, (5.989, 10.869, 24.777)),
    (6624, (2.916, 14.809, 26.170)),
    (831991, (7.448, 10.902, 29.326)),
    (835612, (8.796, 18.279, 21.778)),
    (721177, (7.931, 15.739, 20.384)),
    (524945, (3.600, 15.250, 28.214)),
    (775595, (6.014, 18.109, 20.884)),
    (747467, (7.193, 10.429, 23.925)),
    (827932, (8.774, 17.078, 20.007)),
    (265966, (1.129, 14.199, 24.497)),
    (965380, (2.020, 12.555, 28.457)),
    (970716, (1.465, 18.223, 25.887)),
    (549772, (6.817, 11.853, 29.535)),
    (467187, (1.401, 10.391, 26.714)),
    (616510, (4.152, 15.143, 22.605)),
    (466316, (4.712, 17.251, 26.890)),
    (840893, (3.666, 17.373, 25.575)),
    (216548, (2.903, 10.551, 22.894)),
    (241999, (5.059, 13.716, 28.578)),
    (995481, (9.087, 11.628, 24.037)),
    (293813, (9.379, 13.299, 28.520)),
    (917292, (9.161, 18.214, 27.305)),
    (939999, (7.880, 17.522, 29.233)),
    (343594, (3.905, 14.102, 28.996)),
    (823594, (4.345, 17.905, 24.803)),
    (256067, (8.011, 11.740, 29.071)),
    (183677, (7.669, 18.149, 26.907)),
    (984040, (8.369, 12.202, 27.072)),
    (567547, (7.230, 10.686, 23.654)),
    (154545, (4.069, 19.372, 27.917)),
    (829638, (0.490, 13.153, 22.737)),
    (851921, (4.257, 15.098, 26.060)),
    (36055, (7.762, 19.828, 28.105)),
    (196787, (1.823, 13.051, 28.639)),
    (695761, (7.530, 17.606, 27.829)),
    (557188, (8.858, 14.670, 22.346)),
    (755274, (8.469, 15.625, 20.234)),
    (877125, (9.770, 15.631, 27.369)),
    (500263, (6.899, 11.367, 28.920)),
    (983610, (5.072, 16.081, 23.294)),
    (969259, (3.164, 16.310, 22.005)),
    (293698, (7.330, 18.468, 20.134)),
    (155553, (4.117, 13.171, 20.618)),
    (550672, (9.690, 10.548, 27.799)),
    (286319, (1.521, 10.791, 25.525)),
    (630533, (3.769, 17.743, 22.971)),
    (701371, (0.691, 18.655, 29.638)),
    (326791, (9.748, 10.023, 27.218)),
    (246126, (7.188, 14.435, 22.514)),
    (734907, (0.573, 17.346, 20.479)),
    (368400, (5.171, 16.905, 29.343)),
    (273917, (7.294, 13.623, 22.713)),
    (201600, (4.511, 16.000, 22.969)),
    (728911, (1.537, 13.239, 29.223)),
    (310289, (5.742, 12.499, 21.369)),
    (41511, (5.449, 18.229, 23.556)),
    (434079, (7.165, 16.216, 24.320)),
    (909202, (6.437, 17.744, 28.574)),
    (39412, (3.189, 12.246, 28.179)),
    (361044, (2.698, 19.291, 23.495)),
    (164177, (2.725, 15.318, 25.148)),
    (42745, (3.840, 18.408, 22.228)),
    (384569, (9.168, 18.050, 25.355)),
    (712127, (7.139, 12.284, 25.282)),
    (653850, (3.672, 11.214, 22.898)),
    (122434, (3.667, 10.859, 20.709)),
    (175737, (4.961, 15.830, 25.619)),
    (390313, (1.075, 19.937, 29.080)),
    (445900, (1.653, 13.119, 28.779)),
    (602816, (3.859, 17.946, 22.552)),
    (771447, (2.451, 13.645, 21.602)),
    (241235, (8.350, 11.997, 28.051)),
    (871125, (3.968, 14.426, 26.056)),
    (816195, (5.848, 15.051, 28.415)),
    (467883, (5.419, 19.721, 27.934)),
    (158625, (9.966, 18.705, 22.445)),
    (282259, (5.474, 18.110, 29.550)),
    (939911, (8.627, 15.640, 29.220)),
    (397910, (3.587, 17.946, 29.755)),
    (923185, (9.102, 14.963, 29.300)),
    (150359, (2.391, 12.529, 21.448)),
    (820454, (4.407, 16.102, 25.983)),
    (611500, (9.696, 19.599, 27.569)),
    (63348, (0.349, 15.502, 29.781)),
    (609441, (4.668, 11.871, 27.999)),
    (251596, (1.559, 16.778, 29.989)),
    (973077, (6.938, 16.148, 26.898)),
    (23055, (9.617, 14.803, 28.735)),
    (526621, (1.909, 13.641, 22.497)),
    (702292, (8.968, 16.102, 23.811)),
    (222524, (0.149, 12.846, 23.394)),
    (46400, (8.185, 11.985, 27.948)),
    (88138, (9.492, 10.594, 28.318)),
    (50390, (7.830, 10.942, 28.304)),
    (357928, (5.085, 18.223, 25.870)),
    (700634, (3.093, 10.297, 24.347)),
    (494927, (2.060, 19.472, 21.003)),
    (699772, (8.880, 15.018, 23.833)),
    (471282, (0.601, 14.635, 20.140)),
    (341836, (3.367, 15.686, 21.075)),
    (330431, (7.018, 16.663, 25.736)),
    (474825, (6.763, 16.165, 22.554)),
    (658946, (4.898, 16.995, 27.771)),
    (795235, (7.386, 10.655, 28.357)),
    (84563, (4.793, 14.347, 20.229)),
    (385465, (7.509, 15.220, 29.382)),
    (583920, (7.254, 12.989, 21.590)),
    (921988, (7.421, 18.636, 23.992)),
    (547187, (6.691, 19.102, 26.595)),
    (876195, (7.125, 13.980, 21.051)),
    (988482, (5.021, 13.367, 27.820)),
    (316961, (8.334, 15.099, 28.624)),
    (364201, (1.769, 15.758, 23.868)),
    (728432, (5.137, 10.521, 22.967)),
    (309914, (3.992, 16.306, 29.346)),
    (703132, (7.053, 19.711, 21.675)),
    (498822, (9.104, 12.602, 28.657)),
    (94637, (3.355, 12.285, 21.871)),
    (450965, (3.426, 11.026, 26.433)),
    (310639, (5.119, 14.587, 24.153)),
    (263145, (7.240, 13.211, 26.516)),
    (446869, (9.733, 17.929, 24.604)),
    (170483, (7.509, 16.433, 25.542)),
    (575199, (9.390, 11.840, 25.961)),
    (106451, (5.762, 13.542, 24.157)),
    (50834, (1.656, 15.318, 22.684)),
    (117250, (3.611, 10.176, 26.686)),
    (530124, (9.691, 18.213, 20.560)),
    (134174, (0.721, 14.947, 26.247)),
    (170114, (5.915, 13.513, 25.002)),
    (849807, (7.751, 18.825, 23.889)),
    (138868, (0.649, 17.029, 22.250)),
    (493227, (1.224, 10.657, 29.131)),
    (900836, (9.778, 13.804, 24.824)),
    (19802, (8.800, 13.193, 23.833)),
    (151229, (1.005, 12.399, 28.436)),
    (375637, (4.057, 14.370, 23.824)),
    (472422, (7.244, 10.917, 24.941)),
    (597705, (7.514, 11.650, 26.340)),
    (430681, (6.193, 18.011, 29.563)),
    (177360, (2.562, 18.700, 29.405)),
    (254834, (9.429, 18.239, 24.217)),
    (205977, (4.451, 10.370, 24.338)),
    (366098, (6.900, 12.582, 21.211)),
    (551025, (5.651, 12.762, 29.343)),
    (186522, (2.174, 16.840, 28.249)),
    (844787, (7.466, 12.823, 26.049)),
    (828505, (2.850, 10.726, 28.767)),
    (417682, (6.714, 16.734, 26.209)),
    (281850, (9.522, 13.539, 24.949)),
    (147063, (8.587, 13.161, 27.032)),
    (541614, (2.088, 12.130, 21.247)),
    (862967, (5.500, 11.955, 27.128)),
    (476596, (9.200, 12.363, 23.174)),
    (612722, (6.862, 10.661, 27.619)),
    (33366, (3.652, 17.374, 29.432)),
    (751369, (4.037, 18.427, 24.268)),
    (768989, (9.437, 12.882, 24.500)),
    (818941, (3.234, 15.311, 23.878)),
    (532481, (7.427, 14.794, 26.007)),
    (735624, (4.876, 17.155, 21.810)),
    (191992, (9.707, 10.977, 29.638)),
    (440067, (6.150, 19.996, 24.419)),
    (986967, (3.334, 11.046, 23.052)),
    (45789, (6.832, 19.102, 20.049)),
    (119243, (0.400, 17.251, 23.488)),
    (95794, (4.275, 11.401, 26.554)),
    (231562, (8.156, 19.394, 25.880)),
    (255367, (3.116, 15.768, 20.210)),
    (180578, (8.844, 15.323, 23.154)),
    (178941, (6.703, 12.696, 22.630)),
    (560378, (7.036, 12.279, 29.590)),
    (921970, (3.890, 19.893, 27.890)),
    (844530, (5.558, 13.940, 21.356)),
    (457044, (0.175, 18.383, 24.128)),
    (464073, (3.269, 12.322, 20.474)),
    (266373, (3.293, 19.449, 25.192)),
    (156423, (7.151, 18.079, 24.612)),
    (147281, (7.107, 16.984, 29.152)),
    (723654, (1.295, 17.850, 24.252)),
    (639895, (9.591, 15.789, 28.678)),
    (304647, (7.431, 17.531, 21.301)),
    (841558, (8.914, 11.186, 28.947)),
    (470477, (0.877, 16.338, 22.399)),
    (980077, (8.587, 19.619, 29.359)),
    (301724, (9.576, 14.960, 27.856)),
    (563444, (1.072, 14.589, 22.315)),
    (946434, (2.339, 13.327, 23.706)),
    (584373, (9.284, 16.455, 24.178)),
    (68299, (0.956, 19.243, 20.472)),
    (621010, (3.650, 14.243, 23.172)),
    (732917, (4.550, 15.978, 26.999)),
    (597519, (6.794, 14.987, 21.460)),
    (700274, (9.414, 17.228, 21.210)),
    (919099, (4.295, 18.490, 26.019)),
    (182075, (1.747, 12.802, 24.649)),
    (721355, (7.871, 15.522, 21.198)),
    (571858, (6.315, 19.566, 20.359)),
    (829415, (5.597, 17.500, 24.472)),
    (534630, (2.144, 13.872, 29.343)),
    (245825, (5.503, 17.014, 21.901)),
    (514466, (6.788, 10.188, 22.762)),
    (529404, (3.337, 12.075, 23.949)),
    (727884, (7.689, 15.137, 28.219)),
    (297496, (9.595, 15.223, 27.909)),
    (139901, (5.679, 16.762, 27.053)),
    (394566, (9.078, 16.448, 25.728)),
    (692251, (5.928, 15.860, 23.931)),
    (575825, (0.481, 16.563, 23.238)),
    (428262, (8.360, 11.333, 21.884)),
    (42062, (9.858, 18.500, 26.581)),
    (431466, (7.487, 17.605, 26.741)),
    (568968, (8.967, 14.013, 26.393)),
    (230235, (2.860, 11.941, 21.120)),
    (845264, (0.429, 12.490, 23.041)),
    (432470, (2.642, 15.385, 22.331)),
    (857490, (9.794, 12.739, 26.456)),
    (93246, (3.511, 10.281, 20.332)),
    (460965, (2.010, 18.126, 29.776)),
    (169115, (9.080, 14.464, 27.385)),
    (707003, (6.522, 13.442, 24.797)),
    (594935, (0.204, 19.522, 23.646)),
    (671426, (9.849, 11.667, 22.431)),
    (742090, (9.153, 16.084, 23.558)),
    (992539, (9.880, 11.111, 28.338)),
    (769066, (4.949, 13.759, 21.364)),
    (655751, (5.031, 14.412, 27.453)),
    (619053, (1.608, 13.638, 20.152)),
    (549430, (0.578, 17.200, 27.465)),
    (735513, (3.073, 17.871, 24.702)),
    (596862, (7.646, 17.001, 29.602)),
    (309864, (0.750, 18.752, 24.566)),
    (596990, (3.394, 18.068, 21.709)),
    (761169, (7.302, 15.824, 21.296)),
    (975098, (0.935, 13.194, 29.334)),
    (64067, (1.367, 13.828, 26.935)),
    (253701, (5.118, 16.458, 21.138)),
    (369310, (3.828, 13.957, 26.464)),
    (934289, (8.830, 13.301, 22.329)),
    (607154, (6.718, 16.118, 25.418)),
    (275009, (5.867, 13.737, 28.735)),
    (787177, (8.162, 13.556, 26.906)),
    (215744, (6.359, 19.734, 28.363)),
    (207363, (8.441, 18.492, 25.010)),
    (229333, (2.330, 15.503, 25.407)),
    (111554, (6.494, 10.949, 22.943)),
    (474056, (9.717, 18.209, 22.056)),
    (729955, (8.616, 10.784, 24.157)),
    (51279, (7.079, 12.848, 25.841)),
    (605570, (1.355, 10.648, 20.286)),
    (433013, (9.268, 13.676, 23.000)),
    (438033, (2.062, 13.648, 23.368)),
    (426002, (7.726, 12.043, 21.126)),
    (34462, (5.724, 11.722, 26.913)),
    (595923, (9.278, 19.247, 23.792)),
    (875796, (7.511, 19.869, 29.725)),
    (47530, (7.207, 19.044, 25.355)),
    (4011, (8.889, 14.344, 28.902)),
    (170193, (4.122, 16.124, 27.804)),
    (371674, (0.992, 10.188, 21.963)),
    (836546, (4.346, 19.174, 24.655)),
    (175671, (6.210, 12.732, 28.764)),
    (980611, (8.828, 18.925, 29.921)),
    (953751, (6.410, 12.256, 29.486)),
    (125315, (1.317, 16.336, 24.484)),
    (571174, (9.335, 16.452, 26.869)),
    (883519, (7.706, 15.927, 25.493)),
    (378252, (4.658, 14.425, 25.073)),
    (849633, (5.411, 18.492, 28.322)),
    (986561, (9.009, 17.158, 28.755)),
    (176434, (1.756, 16.270, 25.660)),
    (630310, (8.921, 15.327, 22.069)),
    (834345, (9.774, 12.055, 27.546)),
    (805624, (6.657, 19.893, 20.346)),
    (468841, (7.910, 19.015, 26.362)),
    (749733, (8.536, 17.478, 20.552)),
    (991270, (0.336, 19.496, 21.179)),
    (390790, (7.993, 16.215, 29.482)),
    (900864, (1.794, 19.433, 29.166)),
    (872465, (9.158, 19.648, 28.568)),
    (566049, (3.237, 10.964, 29.837)),
    (6158, (6.709, 17.785, 20.046)),
    (966951, (9.108, 15.022, 29.437)),
    (179470, (7.616, 19.838, 29.145)),
    (89679, (4.135, 19.595, 20.119)),
    (711392, (4.066, 10.369, 20.923)),
    (176414, (0.138, 12.402, 26.816)),
    (942452, (2.129, 17.641, 20.993)),
    (530219, (8.777, 14.322, 26.153)),
    (442841, (9.398, 16.536, 28.968)),
    (831930, (9.063, 14.486, 22.574)),
    (241946, (8.300, 17.691, 26.607)),
    (316659, (5.745, 11.584, 20.635)),
    (531926, (4.568, 14.828, 25.944)),
    (101256, (3.161, 17.167, 20.428)),
    (516846, (6.140, 10.093, 22.578)),
    (52535, (5.185, 10.219, 20.188)),
    (976562, (7.689, 16.261, 22.483)),
    (893253, (0.959, 12.183, 20.382)),
    (547426, (4.828, 19.059, 26.022)),
    (599458, (8.899, 16.986, 28.362)),
    (179554, (9.673, 13.131, 25.601)),
    (259583, (1.518, 10.762, 29.773)),
    (340111, (3.932, 14.078, 27.068)),
    (828907, (2.759, 11.542, 20.178)),
    (303148, (6.273, 15.145, 27.435)),
    (671441, (1.714, 17.256, 20.294)),
    (92017, (9.147, 18.670, 28.136)),
    (223981, (5.881, 18.964, 20.007)),
    (929909, (2.940, 19.729, 22.854)),
    (177447, (7.917, 15.853, 24.379)),
    (372715, (1.676, 18.554, 27.591)),
    (922419, (6.134, 18.415, 23.029)),
    (662908, (7.623, 19.869, 21.309)),
    (983608, (0.492, 13.107, 25.981)),
    (882858, (0.503, 14.080, 28.017)),
    (398184, (4.469, 10.727, 27.708)),
    (250668, (4.444, 11.012, 25.125)),
    (513064, (4.284, 18.868, 23.709)),
    (713870, (8.258, 15.815, 22.810)),
    (98117, (4.430, 10.112, 24.047)),
    (381676, (1.979, 12.931, 23.159)),
    (890067, (7.507, 12.212, 25.086)),
    (553474, (4.059, 15.091, 20.562)),
    (4351, (0.029, 10.109, 24.369)),
    (275588, (9.491, 11.715, 23.350)),
    (773359, (0.452, 11.014, 22.538)),
    (475252, (7.197, 10.979, 28.204)),
    (669516, (0.266, 13.207, 28.416)),
    (83731, (8.415, 15.994, 24.890)),
    (157074, (2.476, 19.816, 23.755)),
    (125333, (9.884, 19.349, 22.497)),
    (189714, (0.116, 17.295, 27.580)),
    (112974, (3.550, 12.315, 28.235)),
    (241616, (4.217, 19.441, 26.229)),
    (546202, (2.489, 15.030, 21.852)),
    (61642, (5.684, 19.404, 27.215)),
    (807123, (3.899, 16.059, 28.259)),
    (199446, (6.457, 14.733, 24.136)),
    (92227, (8.016, 12.085, 23.038)),
    (495146, (5.678, 11.723, 22.039)),
    (535335, (9.950, 13.525, 23.727)),
    (790370, (7.550, 12.245, 23.224)),
    (46049, (7.061, 13.548, 25.618)),
    (135520, (9.282, 15.715, 29.928)),
    (518965, (4.797, 15.183, 25.691)),
    (142839, (9.066, 12.989, 25.088)),
    (522666, (4.446, 10.732, 25.700)),
    (348621, (0.577, 17.681, 25.660)),
    (492978, (4.610, 11.494, 29.725)),
    (208648, (7.690, 16.423, 25.340)),
    (773246, (4.078, 11.356, 26.368)),
    (442931, (4.814, 10.941, 27.676)),
    (514344, (4.541, 13.829, 25.729)),
    (302800, (2.594, 11.852, 23.315)),
    (888419, (3.463, 15.959, 29.591)),
    (696500, (7.744, 18.175, 23.705)),
    (889344, (6.676, 17.669, 22.048)),
    (980403, (8.826, 17.497, 20.807)),
    (924505, (2.705, 10.452, 23.662)),
    (278167, (4.021, 15.652, 28.098)),
    (612086, (9.118, 11.000, 25.406)),
    (278397, (8.952, 10.526, 29.236)),
    (67726, (2.813, 19.990, 29.668)),
    (585223, (2.227, 14.872, 20.935)),
    (566048, (5.371, 16.040, 20.958)),
    (518287, (5.463, 16.316, 26.501)),
    (70201, (3.472, 18.079, 27.655)),
    (852819, (7.655, 19.424, 29.948)),
    (115853, (7.691, 15.993, 28.743)),
    (373393, (5.487, 11.030, 22.794)),
    (641781, (4.387, 16.916, 23.538)),
    (94474, (6.885, 11.647, 29.649)),
    (580795, (0.430, 16.418, 28.284)),
    (338855, (9.495, 17.390, 22.028)),
    (777692, (2.519, 16.689, 22.462)),
    (233973, (5.872, 12.753, 27.002)),
    (85136, (1.486, 11.173, 21.673)),
    (842161, (1.610, 11.092, 25.816)),
    (947446, (0.318, 15.164, 27.257)),
    (872108, (2.518, 13.997, 25.149)),
    (693298, (2.940, 14.408, 28.967)),
    (777791, (0.924, 12.218, 28.463)),
    (164680, (9.275, 14.899, 29.108)),
    (131173, (7.982, 16.893, 28.084)),
    (961076, (6.487, 12.120, 21.304)),
    (852869, (6.379, 16.176, 20.620)),
    (130708, (0.066, 10.223, 21.182)),
    (496279, (9.404, 19.168, 20.603)),
    (62451, (8.619, 15.629, 24.333)),
    (816668, (9.741, 12.633, 28.232)),
    (830322, (7.225, 19.622, 29.773)),
    (179935, (0.427, 17.082, 24.036)),
    (102161, (3.998, 18.211, 25.027)),
    (528839, (8.442, 15.370, 22.159)),
    (706156, (1.464, 13.005, 22.253)),
    (481920, (6.615, 17.436, 21.808)),
    (42089, (2.763, 15.404, 28.674)),
    (107394, (8.737, 10.416, 24.746)),
    (231905, (2.914, 11.548, 21.147)),
    (855209, (5.772, 18.160, 29.088)),
    (838091, (8.140, 14.472, 25.569)),
    (138016, (7.241, 19.148, 28.581)),
    (477371, (9.765, 12.567, 27.032)),
    (919251, (9.195, 16.097, 27.006)),
    (444025, (0.981, 12.741, 20.755)),
    (640104, (6.270, 10.670, 29.303)),
    (261223, (2.300, 15.196, 23.921)),
    (300455, (1.481, 13.862, 22.981)),
    (220022, (0.349, 15.283, 26.929)),
    (331014, (7.901, 15.973, 23.714)),
    (951172, (1.728, 19.684, 24.895)),
    (649566, (7.837, 15.787, 28.804)),
    (708356, (5.673, 14.820, 24.128)),
    (848507, (5.766, 17.873, 21.850)),
    (526781, (9.774, 19.810, 20.968)),
    (575112, (7.916, 10.614, 21.387)),
    (776301, (1.572, 12.960, 26.337)),
    (683780, (6.596, 12.554, 23.133)),
    (688749, (9.548, 19.471, 29.778)),
    (842402, (1.782, 11.242, 27.296)),
    (78852, (3.579, 13.666, 27.777)),
    (874138, (4.165, 16.130, 29.083)),
    (546412, (3.428, 12.149, 24.850)),
    (88233, (9.570, 12.414, 22.592)),
    (2947, (8.363, 16.366, 28.092)),
    (282932, (2.265, 12.268, 21.947)),
    (945701, (2.555, 11.331, 22.798)),
    (974064, (1.074, 14.483, 26.540)),
    (910336, (3.070, 10.493, 25.828)),
    (103053, (0.142, 17.145, 29.620)),
    (432234, (9.030, 10.336, 26.417)),
    (658830, (5.181, 10.669, 28.710)),
    (102638, (3.614, 11.026, 28.101)),
    (814796, (0.034, 14.302, 26.564)),
    (464825, (6.797, 11.315, 21.906)),
    (707972, (7.295, 13.945, 27.290)),
    (316031, (2.828, 16.157, 29.594)),
    (359755, (2.030, 17.284, 25.560)),
    (964430, (2.720, 15.303, 20.357)),
    (418594, (3.490, 14.766, 26.790)),
    (515534, (4.156, 19.265, 28.236)),
    (992213, (8.033, 14.215, 28.998)),
    (380455, (6.499, 16.181, 21.316)),
    (376948, (6.101, 17.772, 24.216)),
    (240407, (9.795, 13.906, 27.424)),
    (730791, (5.733, 13.990, 23.529)),
    (317252, (7.236, 13.192, 23.144)),
    (583682, (1.427, 16.140, 20.060)),
    (726353, (1.320, 18.638, 22.819)),
    (680269, (9.315, 11.159, 23.834)),
    (147456, (7.230, 10.631, 20.850)),
    (580922, (0.972, 15.483, 27.490)),
    (442570, (6.388, 11.505, 24.353)),
    (744601, (7.087, 17.593, 23.785)),
    (266658, (1.267, 12.703, 24.841)),
    (328464, (3.987, 14.240, 23.897)),
    (473803, (5.075, 10.824, 27.429)),
    (425898, (4.968, 17.088, 24.012)),
    (758977, (1.267, 10.715, 21.864)),
    (61760, (8.901, 16.697, 25.551)),
    (944491, (4.222, 10.263, 27.852)),
    (972788, (6.158, 10.112, 21.076)),
    (595730, (4.620, 19.524, 23.857)),
    (357505, (8.933, 13.820, 29.943)),
    (260824, (6.158, 14.349, 29.367)),
    (144355, (7.218, 19.145, 27.446)),
    (995878, (6.196, 16.343, 28.397)),
    (637830, (2.543, 17.779, 26.611)),
    (133552, (2.492, 19.330, 27.424)),
    (779073, (7.222, 12.098, 20.381)),
    (397399, (2.181, 17.012, 27.967)),
    (380668, (4.196, 11.162, 28.802)),
    (886466, (1.073, 15.771, 27.006)),
    (880895, (1.713, 16.507, 24.384)),
    (788722, (0.250, 15.126, 28.634)),
    (447309, (3.158, 17.983, 28.757)),
    (156779, (6.366, 12.753, 26.733)),
    (163277, (5.057, 16.274, 29.703)),
    (68401, (4.995, 14.116, 28.349)),
    (703736, (0.060, 19.358, 21.833)),
    (486004, (5.685, 18.019, 24.914)),
    (968705, (6.676, 14.105, 20.595)),
    (566803, (9.399, 16.332, 25.355)),
    (499823, (1.522, 13.277, 26.939)),
    (380535, (8.635, 10.536, 27.889)),
    (425379, (8.716, 13.142, 20.554)),
    (559173, (5.077, 15.168, 25.053)),
    (898762, (8.741, 14.409, 22.950)),
    (745865, (5.531, 10.418, 22.783)),
    (217989, (1.019, 13.565, 23.736)),
    (984434, (1.633, 13.410, 28.082)),
    (3340, (4.036, 10.611, 26.879)),
    (159623, (7.534, 16.806, 20.711)),
    (399979, (8.607, 17.192, 21.983)),
    (59686, (5.322, 10.305, 22.058)),
    (837411, (1.042, 11.446, 29.485)),
    (884699, (4.873, 13.283, 21.715)),
    (489850, (6.487, 10.078, 25.258)),
    (357419, (2.688, 10.465, 25.057)),
    (899686, (2.880, 10.945, 26.464)),
    (511007, (7.271, 17.956, 21.746)),
    (106852, (3.100, 13.689, 24.369)),
    (474777, (7.535, 17.681, 29.046)),
    (542774, (4.307, 18.778, 24.830)),
    (493176, (5.406, 10.066, 20.120)),
    (172324, (8.524, 17.887, 21.958)),
    (167555, (2.760, 16.916, 23.931)),
    (972677, (3.750, 10.589, 23.818)),
    (258864, (1.073, 14.652, 20.904)),
    (958210, (9.775, 18.995, 23.570)),
    (986083, (7.773, 14.728, 20.426)),
    (631440, (2.926, 12.415, 23.990)),
    (213977, (0.162, 16.482, 26.470)),
    (392055, (0.715, 12.760, 27.783)),
    (620181, (5.958, 11.037, 20.876)),
    (210944, (6.831, 14.010, 25.548)),
    (977641, (3.424, 18.355, 21.906)),
    (478532, (3.736, 10.502, 29.611)),
    (359565, (1.969, 10.293, 27.940)),
    (118361, (8.920, 16.181, 24.167)),
    (755821, (1.575, 13.981, 23.070)),
    (458491, (0.027, 13.559, 24.313)),
    (321767, (3.348, 15.007, 24.851)),
    (343701, (7.193, 16.504, 28.207)),
    (975211, (0.271, 17.157, 28.889)),
    (846697, (6.259, 10.442, 29.164)),
    (799618, (9.896, 17.900, 23.547)),
    (648104, (7.019, 14.407, 20.587)),
    (304258, (4.807, 12.084, 22.754)),
    (146241, (2.707, 11.944, 24.019)),
    (17168, (5.437, 11.163, 29.738)),
    (236235, (0.848, 15.999, 29.890)),
    (458147, (8.687, 14.507, 20.663)),
    (814203, (5.198, 15.194, 24.396)),
    (920584, (9.613, 16.440, 29.711)),
    (22421, (6.881, 13.711, 27.157)),
    (36046, (9.480, 14.871, 26.172)),
    (368056, (6.999, 18.852, 23.819)),
    (905346, (7.111, 17.818, 25.152)),
    (596111, (8.833, 12.987, 26.046)),
    (936476, (1.676, 19.341, 27.873)),
    (863795, (3.728, 16.795, 21.775)),
    (994378, (6.558, 11.349, 28.999)),
    (508871, (3.185, 10.595, 29.165)),
    (153278, (3.647, 17.154, 27.662)),
    (623172, (2.023, 13.464, 25.622)),
    (899866, (2.230, 10.743, 21.858)),
    (16990, (2.462, 13.481, 29.878)),
    (690585, (9.200, 11.556, 22.594)),
    (350854, (9.141, 12.884, 21.463)),
    (670107, (7.926, 13.831, 26.815)),
    (944410, (2.767, 18.365, 25.713)),
    (457916, (5.603, 12.461, 28.889)),
    (405632, (7.130, 11.687, 24.246)),
    (46540, (9.270, 13.328, 20.177)),
    (750791, (4.336, 19.716, 23.664)),
    (725560, (1.851, 19.661, 25.840)),
    (506490, (7.502, 16.136, 25.921)),
    (635104, (3.622, 11.434, 28.026)),
    (826145, (3.767, 10.585, 23.436)),
    (84771, (1.095, 18.092, 25.974)),
    (769133, (8.954, 16.534, 23.342)),
    (190364, (4.612, 14.463, 27.723)),
    (274398, (5.955, 12.895, 29.521)),
    (600093, (1.692, 10.119, 20.473)),
    (850042, (7.674, 14.792, 29.926)),
    (431127, (9.723, 18.665, 21.699)),
    (511885, (2.261, 15.979, 28.062)),
    (305411, (1.371, 14.753, 29.915)),
    (471582, (3.659, 13.493, 25.601)),
    (481596, (1.942, 12.614, 20.301)),
    (93913, (4.308, 17.953, 24.184)),
    (89897, (5.593, 10.036, 28.064)),
    (840223, (3.140, 15.433, 24.057)),
    (196387, (2.084, 16.052, 24.941)),
    (827592, (0.290, 15.994, 22.950)),
    (389399, (5.864, 14.249, 20.262)),
    (554781, (4.325, 10.979, 22.796)),
    (570611, (2.827, 17.774, 24.098)),
    (573412, (0.885, 10.139, 21.662)),
    (127275, (2.738, 10.846, 22.147)),
    (922440, (1.442, 10.371, 25.743)),
    (450520, (4.693, 19.329, 22.344)),
    (552534, (9.816, 16.328, 27.311)),
    (613427, (0.562, 13.344, 29.141)),
    (102815, (9.909, 12.335, 20.846)),
    (692060, (2.196, 15.534, 20.013)),
    (99970, (9.486, 19.463, 29.265)),
    (363371, (3.376, 19.818, 28.364)),
    (924055, (0.693, 15.254, 26.635)),
    (153515, (9.242, 19.611, 28.562)),
    (976886, (0.712, 10.667, 29.976)),
    (497808, (1.879, 12.750, 28.010)),
    (18581, (1.206, 14.621, 26.857)),
    (20675, (9.769, 12.415, 26.826)),
    (783868, (3.675, 14.607, 20.623)),
    (382578, (7.973, 19.287, 27.467)),
    (282328, (2.841, 17.146, 28.976)),
    (918023, (1.515, 12.224, 20.574)),
    (183537, (8.699, 11.792, 28.560)),
    (579923, (8.148, 11.185, 25.239)),
    (855233, (5.300, 13.165, 25.378)),
    (457871, (5.724, 11.177, 27.620)),
    (235973, (3.587, 13.810, 29.182)),
    (185446, (7.763, 12.752, 23.668)),
    (703684, (3.250, 13.972, 21.222)),
    (833178, (8.877, 13.708, 29.451)),
    (781902, (3.609, 15.401, 29.746)),
    (173321, (5.809, 11.686, 26.963)),
    (998266, (3.067, 10.891, 20.454)),
    (12533, (3.365, 17.713, 29.397)),
    (140624, (8.150, 11.016, 21.225)),
    (509129, (0.609, 14.668, 29.243)),
    (141264, (8.601, 19.407, 27.938)),
    (421190, (0.685, 13.626, 23.348)),
    (42068, (8.625, 15.084, 23.141)),
    (335919, (3.098, 16.152, 21.261)),
    (583400, (4.716, 14.522, 22.608)),
    (413837, (3.851, 13.280, 29.377)),
    (650578, (9.796, 12.809, 25.912)),
    (473032, (5.814, 10.882, 21.822)),
    (897881, (9.820, 15.105, 26.665)),
    (879159, (9.489, 19.992, 29.726)),
    (977180, (6.117, 10.629, 26.551)),
    (618639, (7.374, 16.223, 23.949)),
    (210128, (7.768, 16.255, 25.586)),
    (30299, (9.683, 16.768, 21.896)),
    (928208, (9.528, 18.075, 24.887)),
    (551313, (8.274, 13.920, 28.463)),
    (927310, (6.972, 13.598, 22.114)),
    (838942, (8.494, 19.846, 26.734)),
    (731594, (4.213, 11.320, 23.094)),
    (816344, (5.767, 12.789, 21.792)),
    (866197, (7.908, 15.969, 27.250)),
    (988934, (2.864, 17.417, 26.623)),
    (340272, (3.284, 16.315, 22.641)),
    (194357, (2.479, 14.077, 21.988)),
    (502187, (4.839, 14.448, 25.342)),
    (466626, (8.537, 17.396, 25.293)),
    (739195, (6.260, 17.497, 22.783)),
    (854972, (9.841, 13.230, 27.783)),
    (650382, (2.350, 19.082, 28.199)),
    (662035, (3.338, 13.709, 28.574)),
    (758531, (7.903, 10.931, 20.410)),
    (588180, (3.864, 12.130, 21.678)),
    (563680, (0.316, 14.058, 24.395)),
    (244120, (1.349, 18.012, 22.294)),
    (35268, (6.226, 13.757, 20.203)),
    (271739, (7.873, 16.961, 20.122)),
    (477180, (3.763, 13.652, 25.738)),
    (589805, (4.865, 14.788, 22.289)),
    (739171, (5.382, 12.627, 29.235)),
    (131742, (3.029, 17.871, 25.631)),
    (975577, (5.353, 14.112, 25.338)),
    (723043, (8.013, 19.557, 28.739)),
    (335102, (8.549, 19.980, 26.844)),
    (426840, (7.610, 17.584, 20.126)),
    (653100, (3.016, 10.596, 28.978)),
    (252833, (1.693, 17.799, 26.488)),
    (46591, (4.946, 10.065, 28.854)),
    (271601, (6.668, 13.140, 24.918)),
    (383987, (0.964, 14.158, 27.833)),
    (736511, (2.368, 10.965, 22.872)),
    (85314, (3.227, 15.103, 29.321)),
    (492804, (6.630, 18.279, 26.631)),
    (960569, (3.171, 11.398, 20.788)),
    (341616, (9.303, 17.993, 28.419)),
    (263779, (9.735, 16.352, 27.219)),
    (613536, (7.144, 17.078, 20.142)),
    (679166, (8.083, 19.320, 21.834)),
    (381894, (9.274, 16.756, 24.224)),
    (172033, (1.203, 11.774, 27.435)),
    (267208, (0.123, 10.968, 26.208)),
    (670810, (7.961, 10.354, 29.867)),
    (326401, (8.770, 12.769, 22.624)),
    (568434, (1.816, 13.249, 22.624)),
    (570447, (6.512, 13.139, 28.954)),
    (200554, (3.586, 10.369, 29.980)),
    (815305, (9.726, 10.152, 28.773)),
    (727991, (1.640, 14.136, 28.145)),
    (182865, (7.636, 13.054, 21.122)),
    (95645, (9.623, 19.385, 29.291)),
    (213285, (1.925, 19.068, 28.148)),
    (366349, (3.586, 11.214, 24.993)),
    (558636, (0.033, 18.984, 22.380)),
    (180236, (2.341, 14.770, 20.657)),
    (830005, (3.827, 19.029, 28.973)),
    (323864, (6.609, 19.004, 29.008)),
    (254964, (1.139, 15.079, 28.447)),
    (498461, (6.260, 15.122, 25.741)),
    (855022, (1.837, 17.026, 24.331)),
    (612012, (3.899, 16.438, 28.686)),
    (164825, (0.164, 11.965, 27.445)),
    (477777, (9.336, 13.623, 23.600)),
    (575200, (7.777, 14.138, 21.636)),
    (992041, (7.990, 18.247, 24.762)),
    (149172, (6.263, 13.003, 25.270)),
    (476451, (0.914, 15.319, 20.250)),
    (423274, (3.141, 13.586, 29.415)),
    (154741, (8.906, 14.086, 27.935)),
    (260863, (6.731, 19.460, 22.767)),
    (532337, (4.279, 14.334, 23.827)),
    (279723, (5.128, 13.672, 28.433)),
    (817334, (7.542, 12.895, 26.615)),
    (964433, (0.635, 17.557, 29.821)),
    (557636, (5.605, 15.221, 27.474)),
    (849143, (5.118, 18.962, 24.163)),
    (352213, (2.395, 10.246, 24.051)),
    (828027, (0.185, 13.143, 20.487)),
    (522630, (0.217, 12.862, 22.288)),
    (216327, (9.460, 17.262, 22.263)),
    (207745, (4.951, 10.783, 24.447)),
    (999442, (1.791, 14.058, 26.714)),
    (511550, (6.852, 18.378, 29.895)),
    (502015, (3.744, 18.410, 26.491)),
    (44009, (1.968, 14.461, 25.588)),
    (39605, (6.867, 14.016, 20.999)),
    (919935, (0.563, 14.316, 26.897)),
    (4423, (7.460, 11.135, 22.186)),
    (306113, (9.270, 12.730, 20.481)),
    (389221, (1.325, 10.775, 25.223)),
    (628425, (5.167, 18.149, 22.733)),
    (974798, (3.127, 14.707, 26.556)),
    (183357, (9.627, 16.229, 23.617)),
    (777653, (8.431, 15.721, 25.085)),
    (4605, (5.397, 15.603, 23.658)),
    (755727, (8.288, 16.973, 22.947)),
    (678096, (3.050, 18.060, 23.987)),
    (410243, (2.849, 15.856, 29.310)),
    (390867, (7.822, 10.582, 21.106)),
    (665861, (5.217, 15.180, 23.586)),
    (429034, (9.623, 11.403, 23.072)),
    (51947, (4.226, 16.889, 23.145)),
    (908550, (3.172, 15.109, 21.672)),
    (581950, (3.253, 17.163, 24.393)),
    (578420, (7.913, 10.550, 22.263)),
    (940608, (3.677, 10.538, 24.694)),
    (100266, (3.971, 18.990, 27.257)),
    (835444, (5.548, 11.803, 22.674)),
    (313801, (7.798, 18.857, 24.554)),
    (256999, (4.499, 10.891, 21.661)),
    (640282, (8.121, 19.413, 24.430)),
    (977269, (5.146, 10.823, 21.857)),
    (124321, (4.206, 11.741, 23.690)),
    (691582, (3.139, 15.360, 21.375)),
    (411781, (2.653, 13.446, 28.801)),
    (639948, (2.384, 12.233, 29.857)),
    (734886, (4.684, 19.792, 27.224)),
    (14390, (7.157, 19.061, 21.034)),
    (876791, (4.690, 15.209, 24.908)),
    (618974, (2.415, 10.773, 27.248)),
    (409365, (6.091, 15.441, 22.059)),
    (703828, (9.702, 11.925, 27.664)),
    (416554, (6.112, 18.405, 29.282)),
    (464776, (8.030, 15.266, 21.602)),
    (645093, (8.218, 12.484, 21.719)),
    (4403, (6.863, 17.678, 22.043)),
    (335514, (8.686, 16.626, 26.485)),
    (983366, (3.490, 13.613, 21.024)),
    (723932, (5.468, 16.671, 29.532)),
    (646814, (5.962, 18.728, 20.313)),
    (135421, (2.666, 15.445, 23.904)),
    (731376, (8.276, 17.761, 21.846)),
    (165871, (4.776, 14.026, 26.624)),
    (453178, (0.088, 13.784, 29.384)),
    (825060, (6.990, 10.031, 21.614)),
    (619550, (9.698, 17.814, 22.064)),
    (724177, (9.496, 17.677, 26.776)),
    (249556, (9.708, 18.719, 27.460)),
    (352422, (4.981, 13.023, 24.391)),
    (310937, (7.935, 13.651, 24.832)),
    (553011, (1.774, 15.962, 28.166)),
    (20565, (3.202, 14.798, 20.959)),
    (321169, (3.371, 10.281, 20.351)),
    (636247, (4.819, 14.556, 24.628)),
    (884492, (2.261, 17.441, 24.147)),
    (706656, (5.423, 12.614, 26.508)),
    (134746, (5.968, 17.409, 29.645)),
    (50020, (6.335, 11.649, 27.917)),
    (530365, (2.861, 12.153, 20.040)),
    (116475, (7.602, 17.575, 29.729)),
    (698650, (2.933, 13.240, 29.556)),
    (193459, (3.983, 19.696, 21.567)),
    (281499, (2.909, 17.814, 23.957)),
    (769189, (0.805, 14.530, 23.214)),
    (250042, (2.221, 13.706, 25.176)),
    (446666, (6.116, 10.419, 22.495)),
    (905391, (8.303, 18.582, 25.039)),
    (87153, (5.989, 14.828, 28.498)),
    (230532, (0.469, 19.991, 25.799)),
    (726719, (8.015, 11.968, 26.311)),
    (493435, (9.486, 19.887, 25.640)),
    (157330, (7.340, 12.845, 25.719)),
    (422628, (5.206, 14.413, 20.985)),
    (826361, (1.322, 13.713, 24.257)),
    (447015, (0.355, 19.432, 23.818)),
    (157931, (2.165, 16.232, 20.873)),
    (975164, (4.468, 18.482, 27.818)),
    (909871, (3.039, 10.659, 26.109)),
    (623501, (7.688, 17.507, 29.512)),
    (230854, (0.784, 16.202, 21.107)),
    (73674, (1.518, 16.997, 26.906)),
    (143394, (6.697, 12.564, 28.466)),
    (426315, (6.436, 13.089, 23.773)),
    (690452, (6.888, 10.389, 27.718)),
    (229943, (3.318, 12.416, 23.579)),
    (835748, (2.617, 11.364, 27.467)),
    (592343, (3.554, 10.484, 28.577)),
    (200223, (0.057, 11.316, 22.389)),
    (968948, (5.982, 18.730, 22.460)),
    (642138, (1.668, 11.104, 24.597)),
    (249916, (2.797, 10.269, 21.399)),
    (42355, (8.989, 16.563, 23.914)),
    (7505, (6.055, 10.150, 28.340)),
    (540016, (0.789, 18.705, 26.557)),
    (639909, (3.236, 17.965, 25.869)),
    (822523, (6.666, 10.583, 27.972)),
    (212202, (5.033, 12.587, 21.793)),
    (168958, (8.958, 19.274, 20.482)),
    (595638, (4.751, 15.466, 25.149)),
    (928546, (7.746, 17.393, 24.345)),
    (94943, (9.097, 18.719, 29.120)),
    (443982, (1.135, 12.221, 24.305)),
    (795383, (8.814, 15.452, 20.509)),
    (413829, (1.395, 12.560, 22.681)),
    (208767, (2.167, 13.429, 20.938)),
    (431023, (6.038, 19.278, 27.551)),
    (600296, (9.332, 15.139, 24.910)),
    (827003, (8.342, 10.146, 26.911)),
    (920994, (6.553, 19.997, 26.516)),
    (840822, (2.368, 12.144, 25.531)),
    (268225, (2.839, 18.033, 24.198)),
    (379447, (0.291, 18.523, 20.407)),
    (303067, (8.946, 17.514, 22.389)),
    (920773, (4.517, 15.905, 23.429)),
    (285930, (5.144, 18.119, 23.083)),
    (16081, (1.792, 18.090, 25.889)),
    (453403, (9.491, 10.562, 26.959)),
    (708482, (5.428, 16.347, 21.752)),
    (753323, (6.742, 11.076, 20.774)),
    (426054, (1.294, 11.114, 26.462)),
    (764283, (0.623, 19.478, 21.038)),
    (710300, (3.076, 14.327, 21.287)),
    (415725, (4.418, 15.758, 23.012)),
    (233049, (7.148, 16.310, 22.693)),
    (75002, (3.282, 10.843, 26.808)),
    (643883, (8.733, 14.895, 28.260)),
    (880269, (0.991, 15.382, 20.190)),
    (818139, (2.821, 17.747, 27.400)),
    (776923, (5.924, 16.605, 22.745)),
    (625543, (9.866, 17.614, 21.527)),
    (937157, (3.899, 17.960, 28.727)),
    (866825, (3.934, 12.763, 25.394)),
    (757000, (8.195, 19.582, 22.967)),
    (802011, (2.194, 12.047, 24.939)),
    (938761, (2.132, 16.999, 27.174)),
    (348605, (8.906, 12.765, 24.851)),
    (238147, (2.653, 17.113, 27.831)),
    (639065, (0.684, 13.815, 27.472)),
    (175241, (1.284, 18.444, 27.183)),
    (881369, (8.444, 12.092, 24.955)),
    (661804, (3.210, 12.469, 25.975)),
    (952398, (7.870, 15.044, 21.588)),
    (458936, (7.168, 12.211, 20.913)),
    (439086, (9.676, 10.512, 22.711)),
    (116936, (5.169, 12.967, 20.308)),
    (422785, (4.822, 17.797, 28.476)),
    (690300, (0.112, 11.398, 28.801)),
    (59883, (4.884, 15.949, 20.423)),
    (739406, (0.471, 14.311, 28.902)),
    (487365, (1.701, 14.917, 24.838)),
    (461595, (3.002, 10.250, 22.688)),
    (210647, (1.796, 19.788, 24.183)),
    (69713, (2.875, 12.546, 28.812)),
    (685412, (4.800, 19.673, 20.872)),
    (869939, (2.305, 15.478, 23.187)),
    (992592, (8.474, 10.781, 25.066)),
    (123645, (2.727, 18.352, 26.726)),
    (897323, (5.170, 19.695, 25.654)),
    (645304, (4.020, 10.129, 24.978)),
    (8351, (2.681, 13.930, 21.829)),
    (15130, (8.465, 14.247, 24.116)),
    (74956, (2.402, 18.905, 28.310)),
    (383503, (0.681, 15.355, 20.021)),
    (884677, (1.632, 16.258, 20.614)),
    (892370, (3.452, 18.157, 21.664)),
    (339103, (4.754, 18.128, 29.916)),
    (826481, (3.668, 11.877, 21.349)),
    (103598, (7.661, 19.818, 29.147)),
    (423033, (9.638, 18.170, 22.619)),
    (531672, (5.789, 16.983, 28.459)),
    (886778, (0.661, 11.888, 27.496)),
    (472313, (3.952, 14.640, 20.533)),
    (641358, (1.061, 10.116, 27.973)),
    (147956, (7.289, 11.121, 26.071)),
    (941046, (6.893, 11.748, 20.371)),
    (461868, (4.181, 14.284, 24.743)),
    (713466, (8.455, 15.743, 29.660)),
    (869538, (0.985, 11.016, 24.042)),
    (512975, (7.033, 15.643, 28.708)),
    (528746, (4.964, 18.967, 20.413)),
    (107302, (9.744, 19.222, 23.761)),
    (320680, (6.920, 13.659, 21.408)),
    (958786, (6.100, 17.846, 21.362)),
    (942874, (5.910, 16.779, 29.792)),
    (897449, (6.147, 10.471, 27.075)),
    (38619, (7.636, 12.746, 23.143)),
    (795278, (3.964, 10.235, 21.103)),
    (506951, (6.614, 12.606, 20.030)),
    (637126, (8.472, 15.676, 29.234)),
    (800474, (5.233, 10.518, 27.339)),
    (647941, (5.306, 14.617, 23.117)),
    (668333, (7.084, 13.148, 23.941)),
    (252468, (4.767, 16.222, 21.109)),
    (861221, (2.137, 16.996, 22.008)),
    (210601, (9.175, 17.714, 24.152)),
    (277998, (1.516, 12.160, 27.330)),
    (964442, (9.193, 19.868, 29.354)),
    (907708, (8.432, 11.400, 22.090)),
    (26865, (3.077, 16.687, 24.188)),
    (680482, (0.368, 14.487, 24.885)),
    (183041, (6.534, 10.587, 25.416)),
    (130413, (4.561, 14.746, 21.879)),
    (154263, (5.809, 15.468, 24.192)),
    (926670, (9.172, 16.721, 21.319)),
    (418226, (6.796, 18.048, 27.694)),
    (927279, (8.375, 13.782, 25.401)),
    (423253, (6.861, 17.849, 23.966)),
    (324271, (5.562, 19.564, 23.126)),
    (896550, (6.057, 18.970, 22.535)),
    (608609, (8.208, 12.124, 20.572)),
    (826220, (4.035, 16.475, 23.477)),
    (979199, (4.994, 19.367, 29.331)),
    (570840, (8.942, 17.357, 24.160)),
    (37394, (3.230, 17.976, 22.001)),
    (415687, (9.799, 15.615, 22.689)),
    (833641, (9.895, 15.343, 28.874)),
    (40305, (8.825, 18.019, 27.686)),
    (496788, (4.432, 18.222, 20.857)),
    (130658, (2.088, 13.056, 23.283)),
    (624058, (9.741, 17.885, 22.218)),
    (294745, (0.519, 11.810, 21.949)),
    (466685, (6.286, 12.035, 21.273)),
    (157988, (7.968, 13.032, 28.121)),
    (215615, (4.698, 12.790, 29.729)),
    (972581, (8.746, 15.111, 29.604)),
    (626057, (5.373, 17.324, 29.592)),
    (335094, (1.937, 17.278, 29.273)),
    (137064, (4.880, 10.754, 23.864)),
    (209976, (0.352, 11.125, 28.686)),
    (447856, (7.886, 12.116, 26.492)),
    (345127, (5.725, 19.338, 27.674)),
    (694928, (1.532, 11.879, 28.016)),
    (686492, (9.761, 16.301, 25.139)),
    (626594, (3.055, 15.700, 26.716)),
    (517635, (1.779, 18.868, 25.368)),
    (165330, (3.438, 12.110, 21.588)),
    (563241, (8.297, 16.636, 28.584)),
    (805203, (4.591, 17.313, 24.202)),
    (200573, (4.330, 11.502, 22.948)),
    (561020, (4.710, 17.743, 23.083)),
    (623869, (9.620, 19.049, 26.177)),
    (821084, (5.181, 19.698, 25.479)),
    (388864, (2.552, 12.930, 29.166)),
    (977111, (6.723, 11.221, 25.243)),
    (101487, (9.224, 17.398, 22.420)),
    (917753, (1.563, 11.431, 24.562)),
    (913579, (6.025, 17.449, 26.099)),
    (510807, (0.614, 18.878, 24.208)),
    (748194, (8.502, 12.628, 26.261)),
    (596711, (1.424, 13.789, 23.721)),
    (577467, (6.114, 10.728, 28.183)),
    (131004, (8.620, 15.372, 28.831)),
    (504442, (4.611, 19.925, 21.055)),
    (501373, (5.705, 13.131, 28.253)),
    (863910, (9.622, 19.014, 29.829)),
    (15619, (9.106, 19.151, 25.261)),
    (737077, (0.239, 19.731, 28.864)),
    (533937, (3.694, 11.093, 23.316)),
    (489335, (9.092, 17.397, 20.438)),
    (258385, (1.761, 11.963, 25.805)),
    (991323, (4.280, 15.156, 23.153)),
    (546, (6.523, 11.060, 22.248)),
    (273720, (4.829, 13.002, 26.319)),
    (455556, (4.654, 19.392, 20.464)),
    (386352, (4.587, 12.868, 25.370)),
    (838843, (5.639, 10.385, 29.037)),
    (189021, (4.475, 13.587, 25.682)),
    (350221, (0.895, 12.872, 29.946)),
    (576480, (1.721, 13.867, 29.533)),
    (609535, (1.514, 14.504, 22.067)),
    (436392, (4.299, 10.165, 24.052)),
    (160949, (9.067, 18.933, 26.574)),
    (27285, (6.391, 14.058, 22.737)),
    (278635, (6.319, 10.612, 27.872)),
    (800215, (1.776, 19.366, 25.495)),
    (365130, (0.059, 11.115, 27.311)),
    (867191, (1.982, 10.078, 27.609)),
    (780664, (4.677, 10.257, 28.359)),
    (74720, (7.408, 10.364, 27.073)),
    (801664, (3.738, 11.164, 22.468)),
    (64785, (9.154, 17.910, 29.809)),
    (530663, (6.983, 15.177, 27.810)),
    (432852, (9.515, 17.655, 28.282)),
    (79056, (5.246, 12.440, 22.002)),
    (850162, (9.271, 19.042, 25.887)),
    (436911, (4.308, 11.078, 24.995)),
    (611598, (1.689, 16.347, 20.866)),
    (305598, (9.448, 15.296, 23.296)),
    (983102, (3.424, 16.107, 27.692)),
    (657561, (0.045, 11.876, 26.753)),
    (230206, (9.080, 14.830, 24.853)),
    (807054, (7.873, 15.337, 24.147)),
    (194229, (6.390, 11.336, 25.419)),
    (612709, (4.386, 15.398, 28.449)),
    (760673, (7.022, 16.831, 23.552)),
    (635275, (2.259, 15.948, 26.040)),
    (717863, (8.975, 10.307, 24.956)),
    (912964, (2.395, 17.095, 25.472)),
    (46113, (5.279, 10.273, 23.998)),
    (54125, (5.824, 18.177, 27.472)),
    (826625, (2.767, 15.013, 23.468)),
    (822853, (9.622, 19.144, 28.791)),
    (536644, (7.837, 17.208, 24.263)),
    (851378, (5.713, 19.951, 21.533)),
    (923125, (8.062, 12.824, 27.037)),
    (8808, (0.363, 13.227, 21.539)),
    (696127, (2.274, 10.683, 29.758)),
    (780300, (7.305, 13.722, 24.296)),
    (423629, (6.085, 15.201, 27.914)),
    (630168, (3.309, 11.857, 24.461)),
    (860095, (7.714, 10.374, 23.972)),
    (41041, (3.901, 13.972, 27.103)),
    (209890, (2.365, 12.417, 28.822)),
    (437765, (8.039, 18.791, 21.114)),
    (944212, (9.053, 17.630, 24.274)),
    (618880, (6.677, 15.008, 28.159)),
    (119116, (6.980, 16.136, 21.231)),
    (884076, (3.259, 14.733, 22.824)),
    (974467, (8.623, 11.036, 21.875)),
    (560918, (6.469, 15.496, 25.019)),
    (894563, (6.665, 17.111, 26.775)),
    (476803, (1.897, 18.564, 23.232)),
    (509705, (1.233, 17.898, 23.752)),
    (223509, (8.874, 17.206, 24.508)),
    (649212, (1.852, 15.101, 29.243)),
    (568963, (5.770, 13.348, 22.850)),
    (193577, (5.389, 10.106, 26.246)),
    (905029, (2.972, 19.601, 21.050)),
    (594309, (3.220, 14.327, 20.167)),
    (975937, (9.605, 10.658, 23.903)),
    (731073, (5.137, 11.130, 29.913)),
    (234895, (7.012, 18.816, 27.029)),
    (737618, (6.322, 12.303, 26.811)),
    (670954, (3.697, 17.488, 26.912)),
    (604972, (6.636, 14.733, 28.941)),
    (688714, (4.435, 11.448, 25.212)),
    (978636, (3.679, 14.281, 26.434)),
    (210332, (9.790, 15.098, 22.982)),
    (113223, (0.309, 18.108, 29.959)),
    (152109, (5.641, 13.679, 27.396)),
    (752093, (6.032, 13.641, 27.344)),
    (698805, (9.566, 16.379, 20.884)),
    (997415, (9.658, 13.333, 22.764)),
    (342759, (2.936, 12.062, 26.550)),
    (927562, (8.430, 12.910, 23.172)),
    (134979, (9.343, 14.514, 29.258)),
    (783661, (3.275, 13.860, 23.824)),
    (388132, (3.111, 10.017, 29.974)),
    (175429, (9.045, 14.618, 25.164)),
    (475466, (3.272, 12.902, 26.861)),
    (154563, (3.297, 15.160, 25.760)),
    (929361, (8.464, 19.180, 24.681)),
    (374686, (6.235, 17.914, 21.799)),
    (221653, (8.743, 14.711, 27.148)),
    (176049, (5.449, 14.738, 20.099)),
    (841523, (7.283, 10.187, 24.302)),
    (715550, (7.766, 17.777, 21.595)),
    (188623, (8.650, 13.724, 28.254)),
    (271971, (8.160, 13.190, 27.072)),
    (771499, (1.398, 12.230, 29.698)),
    (860939, (6.563, 19.722, 25.983)),
    (1781, (8.592, 16.570, 21.100)),
    (133329, (9.437, 15.931, 23.412)),
    (84550, (3.586, 19.389, 23.663)),
    (460275, (1.545, 12.884, 21.915)),
    (567792, (6.227, 12.523, 28.741)),
    (626011, (2.494, 15.454, 29.924)),
    (52000, (5.373, 16.021, 20.621)),
    (811078, (7.159, 10.655, 26.296)),
    (298, (4.747, 10.984, 29.245)),
    (362907, (1.879, 12.749, 27.999)),
    (597260, (7.098, 12.899, 28.771)),
    (695673, (4.147, 17.815, 26.502)),
    (841544, (9.201, 14.859, 28.828)),
    (797848, (3.144, 19.780, 23.921)),
    (256398, (3.285, 11.390, 26.086)),
    (933113, (9.422, 14.438, 28.722)),
    (387782, (0.111, 14.560, 23.679)),
    (596694, (7.432, 18.762, 27.426)),
    (245561, (1.553, 10.450, 25.207)),
    (5242, (6.885, 13.576, 27.799)),
    (83344, (1.194, 13.046, 28.976)),
    (715487, (9.851, 11.395, 26.561)),
    (65877, (1.753, 11.408, 23.079)),
    (153346, (3.202, 14.422, 21.755)),
    (653620, (1.225, 15.693, 21.107)),
    (491600, (4.299, 18.113, 29.395)),
    (600801, (8.719, 14.255, 21.422)),
    (746285, (7.574, 18.850, 20.371)),
    (813268, (6.775, 12.526, 23.982)),
    (552019, (5.596, 12.640, 27.694)),
    (520895, (4.967, 10.466, 29.001)),
    (777510, (7.400, 10.105, 28.710)),
    (122217, (3.121, 14.271, 25.384)),
    (105252, (5.735, 12.642, 28.680)),
    (713624, (2.706, 11.519, 23.817)),
    (451428, (9.518, 12.191, 20.462)),
    (779957, (0.257, 12.587, 24.820)),
    (711467, (3.318, 13.812, 28.525)),
    (981168, (3.117, 12.017, 23.127)),
    (780388, (2.606, 14.896, 22.714)),
    (510861, (2.425, 14.602, 26.699)),
    (717331, (7.500, 13.904, 20.866)),
    (856640, (9.541, 17.437, 22.648)),
    (740255, (3.269, 16.390, 26.482)),
    (296866, (3.557, 18.022, 21.814)),
    (552193, (9.027, 12.241, 27.115)),
    (952240, (4.150, 14.144, 21.715)),
    (557242, (7.150, 15.726, 20.367)),
    (481320, (3.985, 18.043, 27.972)),
    (167043, (1.730, 13.116, 28.286)),
    (486792, (0.738, 11.233, 23.541)),
    (778322, (4.245, 19.998, 28.089)),
    (24281, (3.569, 17.578, 26.912)),
    (745345, (7.088, 18.904, 26.526)),
    (531774, (2.915, 10.099, 26.695)),
    (398250, (9.256, 12.446, 25.832)),
    (200786, (8.396, 15.909, 23.850)),
    (319786, (7.745, 13.621, 28.477)),
    (61852, (1.329, 12.709, 22.049)),
    (946262, (0.743, 11.714, 23.052)),
    (995916, (9.920, 13.285, 20.636)),
    (672818, (6.400, 19.955, 20.610)),
    (366504, (8.740, 14.272, 27.495)),
    (467033, (7.264, 11.280, 26.477)),
    (292055, (7.734, 18.838, 26.875)),
    (196808, (3.529, 12.402, 23.434)),
    (363219, (0.207, 10.738, 22.848)),
    (424601, (7.907, 12.267, 21.120)),
    (543906, (8.433, 11.851, 28.315)),
    (132712, (7.253, 19.430, 25.816)),
    (881339, (4.741, 12.849, 26.243)),
    (5541, (4.622, 12.145, 24.209)),
    (214052, (6.227, 11.770, 20.895)),
    (671697, (7.448, 16.574, 21.450)),
    (347210, (1.990, 11.119, 24.159)),
    (171468, (7.819, 15.268, 28.371)),
    (969348, (7.777, 11.330, 21.845)),
    (563386, (8.749, 15.250, 24.381)),
    (22527, (9.704, 10.275, 20.121)),
    (159024, (3.276, 14.140, 29.947)),
    (371402, (9.569, 17.267, 24.977)),
    (570613, (5.186, 13.451, 24.872)),
    (386129, (8.804, 10.730, 29.690)),
    (477527, (4.378, 13.440, 23.538)),
    (248795, (8.878, 19.516, 22.475)),
    (632726, (5.479, 15.626, 27.347)),
    (773220, (9.579, 13.976, 25.517)),
    (276936, (4.643, 17.033, 24.985)),
    (674048, (7.799, 14.228, 28.158)),
    (602399, (1.547, 10.384, 25.048)),
    (398570, (7.468, 19.207, 20.261)),
    (433186, (0.379, 17.130, 23.771)),
    (356043, (4.702, 16.844, 20.899)),
    (449680, (8.870, 15.447, 26.112)),
    (826954, (9.465, 16.771, 24.914)),
    (425855, (6.132, 19.466, 26.092)),
    (237064, (1.836, 19.970, 28.243)),
    (567887, (7.379, 15.206, 28.350)),
    (159488, (2.439, 10.242, 27.458)),
    (640154, (9.918, 19.947, 21.272)),
    (835206, (7.175, 15.290, 24.461)),
    (518920, (9.249, 15.983, 21.795)),
    (263248, (9.833, 12.312, 25.464)),
    (259622, (0.521, 17.718, 23.970)),
    (715518, (7.583, 12.125, 29.154)),
    (586442, (1.759, 17.906, 22.679)),
    (252570, (1.249, 18.987, 24.074)),
    (464645, (2.463, 18.379, 28.148)),
    (548380, (7.761, 15.610, 20.826)),
    (221038, (2.663, 14.173, 26.631)),
    (211613, (3.594, 16.870, 28.239)),
    (462073, (3.210, 16.827, 29.890)),
    (80229, (6.510, 14.248, 22.767)),
    (964739, (6.510, 16.849, 25.042)),
    (285772, (7.515, 16.472, 20.293)),
    (316357, (2.401, 18.945, 28.158)),
    (817285, (7.251, 10.804, 26.952)),
    (372829, (9.902, 19.427, 24.436)),
    (156594, (1.029, 13.901, 28.647)),
    (612712, (7.377, 19.560, 22.464)),
    (710097, (2.062, 13.571, 27.808)),
    (390438, (7.826, 12.168, 21.450)),
    (226035, (0.340, 10.467, 27.971)),
    (551631, (3.482, 14.688, 29.898)),
    (437692, (1.918, 16.310, 22.538)),
    (191412, (1.179, 12.090, 23.568)),
    (524246, (7.157, 14.936, 21.343)),
    (130533, (7.829, 11.662, 25.628)),
    (370827, (6.267, 19.600, 27.109)),
    (219033, (7.734, 16.670, 29.347)),
    (252501, (9.935, 18.056, 21.103)),
    (578122, (0.395, 13.042, 22.031)),
    (287586, (2.957, 18.613, 23.958)),
    (575589, (1.771, 12.486, 27.681)),
    (91486, (1.180, 11.041, 21.901)),
    (752447, (3.360, 15.050, 23.266)),
    (47282, (6.917, 15.431, 27.170)),
    (549142, (5.868, 18.841, 24.815)),
    (189201, (3.044, 18.796, 27.071)),
    (148111, (8.616, 19.423, 26.748)),
    (554006, (2.079, 12.776, 20.330)),
    (344674, (9.569, 16.522, 25.123)),
    (207016, (1.392, 19.480, 24.095)),
    (72971, (3.997, 16.403, 22.393)),
    (177144, (0.245, 19.378, 23.144)),
    (150528, (2.112, 17.338, 25.926)),
    (911330, (2.905, 15.631, 26.581)),
    (286941, (4.320, 14.170, 24.236)),
    (613150, (0.283, 19.166, 24.866)),
    (359078, (3.585, 14.271, 21.168)),
    (896611, (7.327, 14.752, 27.608)),
    (688889, (8.464, 18.301, 20.035)),
    (170341, (9.365, 11.235, 20.869)),
    (430889, (1.993, 19.045, 23.414)),
    (639809, (4.362, 19.809, 26.524)),
    (549873, (7.448, 14.100, 26.442)),
    (160812, (1.539, 11.424, 28.809)),
    (518205, (8.544, 16.137, 20.629)),
    (114480, (7.293, 17.224, 23.589)),
    (859794, (0.833, 19.833, 23.610)),
    (121368, (2.867, 17.530, 20.195)),
    (200071, (8.455, 12.757, 27.760)),
    (532351, (5.283, 13.193, 21.472)),
    (737949, (9.887, 11.604, 24.908)),
    (888373, (3.704, 19.468, 27.417)),
    (705208, (6.973, 15.802, 23.780)),
    (640579, (6.135, 10.127, 26.710)),
    (474095, (3.889, 19.964, 20.681)),
    (830554, (6.459, 10.086, 22.968)),
    (390284, (4.700, 12.835, 26.391)),
    (493488, (6.606, 10.111, 27.478)),
    (667630, (4.324, 14.357, 26.894)),
    (353484, (5.784, 14.463, 24.470)),
    (652089, (4.760, 18.004, 21.847)),
    (447773, (3.630, 10.101, 29.401)),
    (519415, (5.587, 15.916, 26.308)),
    (819101, (8.553, 10.062, 22.699)),
    (267521, (2.784, 19.243, 21.638)),
    (722170, (5.071, 14.680, 29.602)),
    (587126, (1.817, 16.933, 24.491)),
    (376731, (9.011, 19.461, 26.463)),
    (880027, (0.310, 10.355, 27.115)),
    (569732, (9.812, 11.532, 29.120)),
    (6684, (4.009, 15.860, 25.825)),
    (24699, (6.975, 17.869, 26.588)),
    (150696, (7.870, 15.034, 28.864)),
    (619234, (4.365, 19.896, 29.982)),
    (571250, (4.972, 11.252, 27.791)),
    (384352, (6.599, 19.978, 29.445)),
    (3508, (7.404, 18.376, 26.199)),
    (232259, (7.298, 18.620, 28.216)),
    (732056, (7.204, 15.104, 21.655)),
    (443007, (7.484, 12.663, 27.631)),
    (902754, (8.690, 14.393, 27.329)),
    (45598, (3.538, 10.431, 28.999)),
    (68809, (6.020, 13.432, 23.543)),
    (530717, (1.817, 17.976, 26.827)),
    (445772, (2.017, 16.251, 24.217)),
    (984667, (7.479, 19.444, 21.215)),
    (950340, (9.779, 11.394, 21.868)),
    (44061, (1.147, 16.809, 28.785)),
    (741448, (7.479, 12.708, 20.634)),
    (867011, (7.101, 19.526, 22.063)),
    (429457, (8.814, 11.256, 21.789)),
    (206333, (6.730, 18.074, 20.765)),
    (273664, (3.482, 16.475, 29.318)),
    (175357, (2.977, 15.668, 23.079)),
    (606981, (9.212, 19.905, 25.417)),
    (526920, (3.651, 12.940, 25.533)),
    (797334, (4.549, 15.512, 21.897)),
    (18628, (3.746, 10.849, 25.988)),
    (516184, (4.311, 16.547, 26.543)),
    (441434, (1.801, 10.937, 29.370)),
    (241010, (5.628, 15.588, 26.872)),
    (935755, (3.890, 16.042, 23.656)),
    (889679, (5.052, 17.881, 21.507)),
    (877022, (9.066, 15.769, 29.045)),
    (24491, (0.873, 12.228, 26.152)),
    (185953, (2.401, 17.536, 20.724)),
    (383381, (7.662, 19.907, 21.395)),
    (383644, (7.886, 16.955, 21.449)),
    (149657, (4.327, 19.848, 21.141)),
    (585596, (0.031, 17.501, 20.933)),
    (272214, (0.790, 16.748, 29.682)),
    (768808, (6.292, 15.714, 20.831)),
    (595320, (5.443, 19.536, 27.580)),
    (551399, (7.429, 17.842, 29.482)),
    (278418, (7.464, 17.054, 23.031)),
    (75342, (7.779, 14.290, 24.846)),
    (118032, (4.752, 19.364, 29.964)),
    (650754, (3.171, 13.650, 28.545)),
    (105475, (3.982, 15.497, 29.516)),
    (251824, (2.506, 13.662, 29.692)),
    (846975, (8.860, 16.042, 25.411)),
    (824216, (8.934, 19.716, 25.695)),
    (331930, (9.084, 14.567, 26.320)),
    (775528, (3.917, 15.054, 27.626)),
    (223228, (6.217, 15.113, 23.325)),
    (885685, (5.245, 13.886, 23.317)),
    (360562, (3.133, 12.874, 26.785)),
    (981121, (2.462, 13.925, 27.196)),
    (76589, (2.307, 15.778, 22.970)),
    (281466, (3.082, 18.246, 26.621)),
    (44209, (8.308, 14.289, 26.290)),
    (144490, (5.814, 12.577, 21.294)),
    (250761, (9.334, 18.433, 27.738)),
    (781517, (7.938, 12.371, 25.922)),
    (808099, (5.684, 11.940, 20.500)),
    (777151, (5.962, 15.669, 23.463)),
    (731175, (5.869, 17.241, 25.297)),
    (83793, (6.427, 13.985, 21.073)),
    (446309, (8.523, 17.133, 21.020)),
    (719888, (8.697, 12.900, 28.186)),
    (799117, (8.878, 16.346, 24.782)),
    (628823, (0.737, 10.097, 21.006)),
    (766079, (4.331, 13.822, 24.270)),
    (335828, (7.771, 18.880, 26.855)),
    (894815, (8.122, 19.603, 28.176)),
    (930777, (2.808, 19.627, 24.330)),
    (458164, (2.558, 14.930, 27.334)),
    (365558, (7.698, 14.075, 29.297)),
    (386468, (6.890, 14.235, 27.803)),
    (135105, (0.092, 11.721, 27.831)),
    (259663, (4.201, 11.374, 20.823)),
    (967399, (6.875, 19.741, 23.658)),
    (64475, (9.822, 19.542, 23.909)),
    (207308, (8.766, 17.880, 20.654)),
    (895919, (5.288, 17.116, 24.673)),
    (437800, (7.814, 10.075, 28.487)),
    (531223, (2.179, 15.160, 23.510)),
    (898227, (7.300, 12.958, 22.198)),
    (292472, (4.836, 16.088, 25.127)),
    (410933, (5.073, 14.345, 21.997)),
    (561607, (4.921, 17.569, 24.575)),
    (777755, (3.079, 18.077, 25.984)),
    (21900, (3.592, 12.109, 22.171)),
    (351568, (5.387, 13.983, 22.520)),
    (272744, (6.010, 12.105, 24.687)),
    (622125, (3.457, 16.214, 26.096)),
    (205750, (8.226, 15.257, 24.248)),
    (800215, (3.985, 11.475, 24.310)),
    (221271, (3.401, 11.673, 20.657)),
    (548862, (6.326, 18.252, 22.612)),
    (428187, (1.786, 18.839, 27.287)),
    (46013, (9.089, 12.336, 23.328)),
    (242492, (6.395, 12.037, 25.207)),
    (88583, (6.628, 19.015, 23.472)),
    (915073, (9.164, 11.103, 25.943)),
    (233081, (4.793, 14.152, 29.331)),
    (98345, (6.830, 16.174, 20.676)),
    (218077, (7.826, 15.330, 22.094)),
    (5779, (2.695, 13.622, 27.270)),
    (473173, (5.177, 15.592, 24.709)),
    (845691, (1.396, 13.164, 26.077)),
    (331981, (5.180, 17.352, 29.100)),
    (696380, (4.438, 17.262, 24.104)),
    (598, (9.279, 14.474, 21.056)),
    (457647, (3.476, 19.123, 28.864)),
    (677907, (9.288, 15.530, 25.717)),
    (959038, (8.187, 15.840, 20.730)),
    (827944, (0.366, 10.970, 25.236)),
    (255542, (1.001, 17.164, 29.010)),
    (750191, (5.733, 15.751, 25.773)),
    (641538, (4.971, 17.488, 21.630)),
    (339364, (5.722, 13.829, 27.339)),
    (812208, (7.485, 18.933, 29.705)),
    (586719, (9.086, 12.375, 29.507)),
    (713929, (4.375, 17.191, 24.636)),
    (73571, (4.270, 18.123, 27.524)),
    (639389, (6.720, 13.308, 20.146)),
    (203066, (1.205, 17.348, 20.112)),
    (493728, (9.376, 14.572, 24.005)),
    (514170, (5.970, 19.981, 27.841)),
    (63309, (5.296, 16.226, 26.147)),
    (446713, (2.765, 11.183, 21.760)),
    (457082, (9.855, 15.461, 22.739)),
    (794830, (6.440, 11.614, 24.011)),
    (578036, (5.651, 16.536, 27.419)),
    (795325, (0.310, 11.292, 28.456)),
    (133837, (8.345, 19.022, 24.498)),
    (988844, (7.533, 13.519, 21.769)),
    (617811, (0.539, 15.555, 25.780)),
    (783071, (9.286, 15.988, 20.029)),
    (690404, (1.885, 17.481, 20.601)),
    (642083, (4.187, 14.724, 26.205)),
    (241087, (1.190, 13.995, 26.244)),
    (864898, (7.184, 11.816, 25.664)),
    (373449, (2.684, 17.008, 29.080)),
    (673430, (3.811, 11.130, 26.080)),
    (527411, (7.444, 11.443, 25.870)),
    (238046, (3.621, 15.560, 28.007)),
    (831185, (2.437, 10.495, 28.051)),
    (715953, (9.407, 10.873, 20.557)),
    (348772, (8.413, 16.472, 21.979)),
    (538608, (6.060, 16.840, 27.727)),
    (603925, (3.116, 12.295, 22.703)),
    (851064, (8.045, 18.572, 22.496)),
    (758335, (4.110, 19.675, 21.272)),
    (213901, (3.082, 17.371, 23.492)),
    (118130, (9.969, 19.507, 26.378)),
    (59124, (6.752, 18.763, 23.156)),
    (420288, (1.621, 17.401, 23.399)),
    (319018, (5.498, 16.183, 29.094)),
    (281463, (1.198, 18.314, 26.979)),
    (984509, (3.056, 15.525, 21.172)),
    (982993, (8.696, 13.000, 22.676)),
    (95849, (6.788, 15.375, 27.077)),
    (292679, (6.688, 11.387, 25.932)),
    (632064, (4.548, 15.323, 21.257)),
    (951270, (4.410, 17.503, 21.446)),
    (635161, (0.686, 12.325, 24.342)),
    (942139, (1.013, 11.256, 28.974)),
    (828056, (3.202, 18.292, 20.586)),
    (491445, (0.572, 16.514, 22.811)),
    (888537, (3.954, 12.318, 23.248)),
    (800662, (9.549, 15.275, 26.029)),
    (488342, (1.705, 17.484, 29.658)),
    (930855, (0.216, 16.300, 27.085)),
    (589671, (2.791, 15.863, 26.861)),
    (61128, (0.169, 18.347, 29.735)),
    (125003, (0.861, 16.391, 24.775)),
    (959903, (4.995, 11.121, 20.374)),
    (50498, (0.436, 11.694, 23.779)),
    (823991, (2.712, 10.242, 20.265)),
    (255879, (7.076, 18.076, 24.259)),
    (312235, (0.065, 11.681, 24.138)),
    (398270, (9.141, 17.861, 27.687)),
    (656920, (6.377, 15.555, 21.746)),
    (165055, (4.606, 16.922, 23.993)),
    (801664, (6.555, 18.669, 24.605)),
    (941046, (0.918, 19.650, 28.969)),
    (651380, (9.951, 16.938, 27.098)),
    (119842, (5.517, 12.262, 27.785)),
    (385906, (0.976, 16.535, 23.622)),
    (621099, (6.393, 15.388, 21.198)),
    (933129, (4.450, 18.217, 24.721)),
    (668245, (8.656, 17.800, 23.652)),
    (751013, (5.897, 14.555, 25.942)),
    (58136, (7.874, 15.029, 20.403)),
    (948951, (6.798, 16.282, 20.397)),
    (163661, (3.274, 16.753, 29.272)),
    (212058, (0.780, 10.764, 25.566)),
    (795095, (8.759, 18.347, 29.530)),
    (334593, (8.698, 12.250, 27.972)),
    (641890, (1.971, 13.216, 28.811)),
    (379072, (3.971, 19.526, 21.076)),
    (823888, (6.055, 19.537, 29.709)),
    (873634, (9.580, 15.321, 21.175)),
    (656183, (7.722, 12.018, 21.742)),
    (672276, (0.238, 16.196, 21.162)),
    (824002, (4.678, 17.819, 29.676)),
    (129138, (6.153, 16.190, 27.042)),
    (380934, (2.941, 12.443, 20.716)),
    (336526, (8.126, 12.016, 29.985)),
    (582068, (8.862, 15.164, 21.345)),
    (479999, (2.549, 11.310, 26.922)),
    (268989, (1.262, 14.442, 24.307)),
    (701929, (3.334, 15.143, 26.779)),
    (331342, (1.596, 15.222, 20.398)),
    (565745, (3.739, 19.731, 26.201)),
    (91254, (0.658, 15.121, 20.891)),
    (688690, (1.472, 14.587, 23.314)),
    (269916, (7.978, 18.528, 28.481)),
    (699508, (6.759, 10.718, 21.709)),
    (828745, (6.543, 19.852, 27.905)),
    (181084, (6.949, 10.674, 27.065)),
    (853577, (8.883, 12.594, 22.686)),
    (917435, (8.306, 11.163, 29.492)),
    (475417, (5.719, 10.832, 29.795)),
    (241050, (3.740, 12.145, 23.089)),
    (496100, (9.596, 11.454, 25.508)),
    (623468, (9.162, 14.775, 22.007)),
    (87365, (9.061, 17.733, 21.737)),
    (145285, (4.073, 16.731, 20.531)),
    (427646, (9.829, 16.307, 21.660)),
    (609877, (5.954, 14.929, 24.156)),
    (861343, (9.623, 18.255, 20.537)),
    (803835, (4.768, 19.154, 29.618)),
    (338150, (2.848, 15.098, 22.636)),
    (570462, (9.509, 12.109, 25.674)),
    (996266, (3.624, 19.435, 29.183)),
    (462160, (2.412, 14.695, 28.134)),
    (46923, (0.014, 14.954, 23.760)),
    (554892, (3.276, 10.744, 22.421)),
    (461150, (0.535, 14.711, 28.273)),
    (77935, (6.546, 15.027, 21.893)),
    (599552, (4.705, 12.282, 25.409)),
    (821791, (9.893, 17.986, 21.607)),
    (201510, (7.970, 14.734, 29.864)),
    (660294, (3.027, 12.586, 22.390)),
    (633804, (6.191, 11.101, 25.460)),
    (624751, (0.392, 14.634, 29.417)),
    (794824, (0.655, 19.006, 20.069)),
    (50079, (8.838, 10.175, 25.299)),
    (299493, (0.697, 19.587, 27.618)),
    (399126, (8.585, 11.569, 25.307)),
    (690002, (0.870, 11.389, 20.095)),
    (949693, (1.057, 13.664, 26.063)),
    (335981, (4.325, 12.745, 22.245)),
    (153273, (2.908, 18.641, 21.736)),
    (724170, (1.370, 17.172, 25.171)),
    (276371, (0.376, 11.321, 20.767)),
    (985087, (2.281, 15.926, 26.550)),
    (659502, (1.953, 19.643, 25.409)),
    (272910, (3.683, 13.784, 27.861)),
    (373906, (6.786, 18.257, 26.222)),
    (215744, (5.243, 16.747, 28.696)),
    (490113, (6.600, 12.795, 21.050)),
    (906025, (7.416, 15.190, 25.438)),
    (277483, (5.967, 11.395, 28.218)),
    (32972, (4.576, 10.895, 25.317)),
    (868182, (4.980, 16.202, 24.892)),
    (243870, (4.142, 10.174, 24.124)),
    (999189, (5.049, 19.842, 20.929)),
    (871979, (9.813, 11.877, 22.441)),
    (585613, (5.494, 16.804, 27.624)),
    (804948, (9.052, 16.813, 25.597)),
    (143800, (1.553, 12.285, 22.178)),
    (358740, (5.189, 12.124, 21.988)),
    (487395, (9.771, 15.549, 29.002)),
    (807346, (6.705, 17.219, 26.766)),
    (994643, (3.615, 10.852, 23.770)),
    (3837, (0.480, 19.825, 24.679)),
    (340620, (0.691, 17.359, 21.606)),
    (39724, (5.873, 17.244, 26.720)),
    (315365, (4.043, 13.993, 27.316)),
    (546566, (6.831, 19.035, 21.895)),
    (582291, (7.853, 18.871, 20.226)),
    (70105, (5.739, 11.432, 27.601)),
    (522848, (4.912, 18.989, 26.455)),
    (851596, (7.868, 19.608, 29.858)),
    (194474, (1.651, 10.681, 26.308)),
    (235488, (6.540, 15.855, 26.075)),
    (198776, (6.459, 17.830, 23.138)),
    (702035, (1.031, 17.541, 29.043)),
    (16010, (9.676, 16.809, 23.507)),
    (222334, (4.670, 13.068, 23.127)),
    (19384, (4.916, 16.697, 23.773)),
    (496331, (5.000, 11.300, 29.106)),
    (684819, (9.932, 16.198, 27.375)),
    (196095, (1.095, 19.015, 23.220)),
    (80303, (2.407, 16.769, 26.955)),
    (200777, (3.027, 17.800, 27.505)),
    (36520, (8.163, 10.464, 27.801)),
    (439558, (8.011, 18.226, 23.773)),
    (955737, (3.383, 17.388, 21.506)),
    (204501, (7.880, 17.734, 27.278)),
    (770051, (0.526, 12.297, 28.379)),
    (87908, (1.543, 16.564, 26.204)),
    (378588, (7.041, 14.540, 21.968)),
    (614542, (6.427, 10.173, 23.881)),
    (464677, (9.124, 14.743, 21.765)),
    (533706, (5.982, 14.613, 28.331)),
    (310591, (4.622, 14.972, 24.184)),
    (464416, (6.557, 18.591, 27.623)),
    (180274, (0.954, 14.863, 23.707)),
    (16877, (2.409, 12.096, 21.373)),
    (431497, (6.230, 10.920, 22.681)),
    (898539, (3.846, 18.406, 27.365)),
    (818259, (0.407, 14.886, 29.233)),
    (944834, (2.441, 10.580, 26.176)),
    (602571, (5.022, 13.280, 25.575)),
    (819097, (8.503, 16.466, 26.158)),
    (341482, (8.275, 19.651, 25.519)),
    (660844, (5.831, 13.789, 27.705)),
    (905239, (9.854, 18.081, 24.593)),
    (231520, (7.783, 12.635, 25.233)),
    (21071, (0.549, 18.267, 24.268)),
    (683046, (8.624, 18.397, 26.416)),
    (254641, (6.034, 14.779, 27.356)),
    (28650, (5.764, 17.878, 26.604)),
    (4290, (2.490, 18.727, 20.338)),
    (912583, (8.452, 13.567, 29.397)),
    (125342, (7.837, 15.693, 27.035)),
    (514773, (8.542, 17.766, 29.034)),
    (439915, (0.203, 17.456, 23.384)),
    (714800, (2.863, 13.370, 26.814)),
    (934893, (2.048, 17.844, 23.978)),
    (679262, (6.051, 16.263, 22.448)),
    (759748, (9.204, 17.086, 21.216)),
    (879560, (8.898, 19.843, 29.393)),
    (607497, (1.279, 13.156, 22.795)),
    (742697, (1.060, 13.906, 23.312)),
    (974861, (5.293, 13.274, 26.668)),
    (893960, (2.595, 10.183, 24.613)),
    (736991, (4.430, 16.441, 24.058)),
    (279728, (2.713, 11.287, 26.683)),
    (953954, (3.838, 18.360, 24.270)),
    (815419, (6.274, 14.032, 23.261)),
    (828401, (7.827, 15.558, 29.342)),
    (963658, (1.876, 13.502, 29.492)),
    (991460, (5.040, 14.976, 26.422)),
    (783844, (4.973, 12.026, 24.057)),
    (85937, (9.118, 15.926, 24.584)),
    (566135, (4.906, 19.026, 21.581)),
    (522380, (9.761, 18.222, 21.183)),
    (614986, (5.174, 10.888, 24.153)),
    (792174, (6.782, 14.491, 20.788)),
    (966869, (2.813, 18.886, 24.955)),
    (845572, (1.850, 16.958, 29.588)),
    (138932, (6.704, 10.694, 20.306)),
    (458000, (3.640, 14.617, 24.030)),
    (220287, (9.144, 17.286, 25.998)),
    (707240, (3.868, 19.818, 20.357)),
    (19061, (7.091, 13.071, 20.813)),
    (68105, (0.907, 17.804, 28.034)),
    (606119, (5.853, 17.689, 25.431)),
    (884916, (2.066, 19.856, 23.094)),
    (248305, (0.630, 17.023, 21.861)),
    (857658, (1.816, 11.621, 27.882)),
    (267709, (5.121, 14.022, 26.991)),
    (261907, (0.313, 18.527, 29.131)),
    (530466, (8.770, 12.234, 20.508)),
    (206320, (2.696, 18.706, 24.924)),
    (274097, (4.463, 12.021, 23.479)),
    (439241, (5.959, 12.983, 22.369)),
    (767959, (4.891, 11.056, 22.335)),
    (1791, (6.759, 19.449, 24.273)),
    (753819, (9.582, 15.626, 21.723)),
    (364889, (5.099, 18.384, 25.747)),
    (901901, (1.074, 12.801, 21.023)),
    (967135, (3.864, 12.310, 20.357)),
    (340821, (1.105, 13.735, 26.914)),
    (575216, (3.845, 15.965, 23.353)),
    (560649, (1.829, 14.104, 21.636)),
    (475715, (5.501, 11.585, 29.764)),
    (102782, (0.224, 15.452, 21.177)),
    (102426, (0.621, 16.404, 28.777)),
    (555280, (9.310, 17.539, 26.055)),
    (106833, (9.519, 14.681, 20.206)),
    (687528, (6.452, 17.174, 21.567)),
    (453164, (3.625, 13.728, 25.466)),
    (661451, (1.414, 14.401, 23.353)),
    (829601, (1.956, 12.793, 29.497)),
    (26414, (5.384, 11.321, 29.465)),
    (836519, (2.230, 12.079, 21.506)),
    (983961, (7.876, 18.528, 29.685)),
    (914950, (7.594, 12.286, 20.082)),
    (867245, (7.241, 13.792, 29.713)),
    (726612, (4.462, 16.792, 27.025)),
    (615031, (5.006, 12.668, 22.399)),
    (314513, (9.980, 15.293, 27.507)),
    (142524, (1.666, 18.242, 21.138)),
    (648570, (2.344, 15.327, 24.502)),
    (381090, (0.498, 13.319, 20.656)),
    (619729, (1.307, 14.933, 21.634)),
    (486083, (8.841, 11.669, 25.314)),
    (149158, (0.739, 13.974, 20.012)),
    (414549, (5.650, 10.138, 28.986)),
    (389969, (4.428, 11.405, 24.260)),
    (903981, (6.930, 13.193, 23.043)),
    (824315, (7.803, 11.964, 23.878)),
    (308836, (3.857, 10.078, 23.414)),
    (424070, (2.368, 10.011, 23.703)),
    (218579, (4.727, 11.492, 21.740)),
    (647881, (0.502, 15.037, 23.309)),
    (93684, (8.583, 13.486, 21.100)),
    (143387, (7.900, 10.107, 22.135)),
    (113969, (9.819, 13.783, 26.687)),
    (539169, (8.369, 16.351, 27.173)),
    (671695, (9.529, 10.896, 27.196)),
    (281052, (2.138, 18.053, 24.962)),
    (18848, (1.178, 14.978, 29.448)),
    (15714, (1.498, 14.332, 22.911)),
    (185110, (3.079, 15.636, 21.442)),
    (315724, (7.989, 10.184, 25.926)),
    (785260, (8.319, 14.401, 22.668)),
    (814656, (4.550, 17.254, 21.980)),
    (778424, (0.023, 12.375, 28.151)),
    (584140, (2.625, 19.386, 22.951)),
    (420940, (4.221, 18.932, 20.316)),
    (19704, (1.370, 11.809, 20.683)),
    (771819, (1.063, 14.688, 23.843)),
    (495133, (4.310, 17.846, 28.462)),
    (351138, (7.611, 19.391, 22.124)),
    (197980, (0.709, 13.468, 24.902)),
    (934225, (9.332, 18.274, 23.402)),
    (321957, (4.377, 15.872, 23.535)),
    (28937, (7.531, 16.819, 28.315)),
    (961327, (1.864, 18.967, 20.332)),
    (222410, (9.583, 10.507, 25.602)),
    (569319, (4.230, 16.648, 27.930)),
    (334287, (0.697, 11.783, 24.051)),
    (115761, (4.343, 13.276, 23.750)),
    (991850, (2.071, 12.222, 26.381)),
    (623710, (8.905, 11.294, 29.362)),
    (404703, (9.739, 15.455, 21.734)),
    (569904, (7.139, 19.479, 21.517)),
    (847332, (0.047, 13.952, 28.432)),
    (636887, (9.706, 14.942, 24.553)),
    (418159, (4.326, 15.276, 27.500)),
    (708266, (0.191, 19.342, 29.513)),
    (849771, (4.472, 14.650, 20.227)),
    (577666, (2.119, 16.250, 27.541)),
    (618526, (4.217, 19.689, 21.667)),
    (480459, (5.977, 19.639, 25.035)),
    (865871, (7.429, 12.143, 21.605)),
    (791605, (2.811, 13.305, 26.100)),
    (572120, (6.919, 11.264, 24.860)),
    (658324, (5.196, 17.350, 21.695)),
    (449062, (1.483, 12.192, 25.938)),
    (893010, (5.378, 18.702, 29.860)),
    (401315, (8.614, 13.107, 28.757)),
    (324968, (4.751, 11.872, 22.913)),
    (306373, (1.219, 19.565, 20.110)),
    (862527, (0.750, 13.404, 21.555)),
    (360140, (7.101, 14.095, 23.329)),
    (471923, (9.000, 17.356, 27.031)),
    (96925, (7.678, 12.081, 28.826)),
    (95135, (7.018, 13.609, 24.011)),
    (297800, (0.574, 17.242, 28.557)),
    (874180, (7.253, 12.786, 29.878)),
    (255788, (2.003, 12.623, 23.139)),
    (263030, (6.005, 17.490, 27.836)),
    (623029, (0.906, 10.057, 26.592)),
    (298057, (1.164, 14.524, 23.971)),
    (459948, (9.864, 15.368, 20.365)),
    (642824, (2.634, 12.130, 22.231)),
    (979092, (7.909, 11.380, 26.749)),
    (329974, (4.394, 12.653, 21.173)),
    (714266, (2.444, 16.821, 26.175)),
    (107593, (4.043, 17.462, 21.053)),
    (43572, (8.864, 19.093, 21.937)),
    (209292, (3.693, 14.470, 28.304)),
    (173542, (8.050, 18.141, 21.887)),
    (547934, (1.793, 18.292, 27.884)),
    (524392, (2.387, 14.091, 29.762)),
    (674922, (5.602, 11.501, 27.383)),
    (961867, (2.460, 17.145, 29.604)),
    (744074, (5.202, 17.185, 29.650)),
    (159504, (7.924, 12.041, 29.690)),
    (264574, (4.642, 19.905, 23.793)),
    (602951, (2.718, 13.242, 26.697)),
    (757037, (7.606, 17.444, 23.112)),
    (760148, (2.284, 12.583, 27.139)),
    (375424, (9.834, 10.429, 26.043)),
    (696650, (3.470, 17.407, 25.387)),
    (716879, (8.989, 19.102, 29.367)),
    (30598, (3.129, 12.999, 21.176)),
    (628328, (6.415, 19.633, 25.539)),
    (706350, (5.233, 10.525, 29.669)),
    (742739, (4.154, 17.878, 21.070)),
    (736547, (3.022, 12.743, 24.571)),
    (923902, (7.250, 15.768, 22.559)),
    (504855, (9.759, 10.292, 24.632)),
    (343682, (2.975, 14.861, 23.367)),
    (295083, (3.422, 14.763, 29.334)),
    (736442, (6.828, 16.478, 21.531)),
    (764463, (5.438, 19.443, 26.537)),
    (217485, (1.407, 17.153, 20.540)),
    (535637, (2.926, 14.685, 22.808)),
    (607447, (0.546, 12.705, 23.504)),
    (400276, (7.705, 15.051, 29.412)),
    (57368, (2.250, 13.384, 22.908)),
    (483541, (1.897, 13.789, 25.124)),
    (688357, (0.079, 11.083, 23.335)),
    (757179, (6.225, 16.425, 25.001)),
    (753743, (8.636, 11.825, 26.702)),
    (845221, (4.760, 13.342, 27.439)),
    (895038, (7.270, 16.977, 26.162)),
    (340968, (4.948, 19.291, 21.724)),
    (543375, (4.852, 16.857, 25.130)),
    (800509, (0.965, 11.857, 28.860)),
    (54083, (7.315, 18.013, 27.371)),
    (231224, (8.502, 11.405, 25.166)),
    (124335, (6.273, 15.601, 21.820)),
    (345093, (7.444, 18.158, 24.542)),
    (463497, (7.832, 10.902, 20.781)),
    (551929, (8.281, 17.581, 21.300)),
    (246481, (7.273, 16.582, 21.695)),
    (147479, (3.728, 17.647, 20.726)),
    (967182, (6.405, 18.818, 21.493)),
    (597782, (4.298, 12.675, 28.052)),
    (380467, (0.878, 16.302, 22.666)),
    (518194, (7.453, 11.290, 21.326)),
    (146596, (2.452, 12.257, 27.996)),
    (854139, (6.586, 12.907, 26.461)),
    (56270, (2.498, 16.809, 28.182)),
    (657202, (2.485, 11.390, 24.234)),
    (178656, (3.478, 19.806, 28.028)),
    (750088, (6.299, 14.391, 22.115)),
    (867631, (7.079, 18.381, 21.937)),
    (253176, (3.903, 17.759, 22.286)),
    (792851, (0.793, 11.111, 21.326)),
    (342438, (5.303, 17.084, 29.378)),
    (234959, (5.252, 11.633, 21.546)),
    (329797, (1.096, 11.491, 28.008)),
    (970514, (1.248, 11.777, 26.505)),
    (132840, (2.833, 11.380, 22.875)),
    (510416, (2.575, 12.360, 21.256)),
    (152181, (6.872, 19.861, 27.570)),
    (869291, (3.784, 10.044, 27.918)),
    (330551, (7.483, 13.443, 27.952)),
    (817569, (3.026, 16.546, 22.317)),
    (172488, (6.933, 19.962, 25.505)),
    (928101, (0.285, 14.682, 29.347)),
    (454940, (8.644, 15.548, 27.868)),
    (845472, (8.456, 15.631, 21.902)),
    (120664, (9.620, 19.147, 23.770)),
    (753916, (4.913, 11.328, 28.562)),
    (638993, (6.664, 10.094, 25.710)),
    (607610, (4.410, 14.765, 26.052)),
    (726841, (0.701, 16.108, 22.754)),
    (136027, (4.002, 17.082, 22.642)),
    (391147, (9.465, 14.711, 26.692)),
    (770379, (1.159, 19.018, 27.567)),
    (269, (4.925, 11.239, 26.033)),
    (730149, (0.393, 13.245, 29.887)),
    (83303, (3.689, 18.945, 21.698)),
    (369748, (3.147, 15.996, 24.252)),
    (451049, (6.444, 18.767, 21.538)),
    (575460, (4.521, 16.822, 26.632)),
    (152406, (5.793, 17.773, 20.576)),
    (697188, (0.834, 18.948, 28.158)),
    (205523, (4.064, 16.941, 29.948)),
    (523056, (6.439, 12.181, 22.075)),
    (36169, (6.467, 19.079, 28.720)),
    (960624, (2.125, 11.604, 29.542)),
    (198428, (8.179, 15.575, 21.577)),
    (526801, (0.075, 19.716, 22.729)),
    (664246, (8.284, 12.513, 28.903)),
    (703983, (4.806, 19.363, 25.984)),
    (654295, (4.531, 12.226, 28.622)),
    (939756, (5.619, 16.995, 24.216)),
    (495272, (2.724, 16.833, 26.312)),
    (217809, (6.914, 19.448, 24.682)),
    (309615, (5.914, 11.114, 29.696)),
    (533923, (1.704, 15.842, 21.720)),
    (713643, (9.947, 15.802, 22.002)),
    (935913, (8.406, 10.907, 25.516)),
    (117402, (4.909, 11.762, 27.761)),
    (19073, (8.243, 18.040, 26.564)),
    (695871, (5.322, 14.287, 28.047)),
    (481028, (1.932, 10.700, 23.038)),
    (460999, (9.351, 11.396, 24.540)),
    (604369, (4.833, 14.338, 22.615)),
    (344700, (2.518, 10.706, 21.801)),
    (27225, (2.340, 18.194, 27.775)),
    (366836, (4.153, 17.061, 22.849)),
    (636128, (5.860, 12.972, 20.174)),
    (303107, (0.523, 11.990, 24.324)),
    (501235, (1.669, 13.833, 29.625)),
    (762316, (4.576, 18.975, 24.164)),
    (871638, (3.468, 15.881, 28.593)),
    (3422, (6.768, 13.921, 22.994)),
    (930079, (9.827, 11.872, 20.652)),
    (578456, (3.874, 13.219, 24.222)),
    (671447, (1.268, 12.031, 24.345)),
    (502673, (2.702, 17.976, 21.332)),
    (478640, (4.489, 10.774, 25.349)),
    (817159, (7.807, 13.570, 24.626)),
    (583169, (4.950, 19.235, 22.299)),
    (410381, (0.325, 19.203, 25.077)),
    (69013, (1.143, 12.163, 23.390)),
    (591460, (8.420, 16.208, 23.386)),
    (606900, (0.969, 18.535, 28.299)),
    (12422, (8.184, 13.695, 22.470)),
    (708681, (9.867, 19.799, 21.270)),
    (694071, (1.688, 11.022, 20.340)),
    (298189, (6.058, 18.886, 24.302)),
    (369379, (8.744, 11.805, 29.299)),
    (106124, (4.290, 13.915, 22.768)),
    (763834, (7.964, 12.286, 20.206)),
    (297982, (5.518, 16.866, 22.417)),
    (138556, (6.830, 17.855, 28.845)),
    (685220, (6.702, 17.536, 21.208)),
    (102217, (0.811, 19.256, 23.630)),
    (291273, (6.893, 15.183, 23.913)),
    (664774, (0.199, 13.028, 29.493)),
    (457724, (4.623, 15.820, 23.693)),
    (598306, (0.417, 11.849, 26.788)),
    (179311, (6.349, 10.690, 20.297)),
    (185996, (9.582, 12.882, 24.585)),
    (808213, (7.791, 19.903, 25.300)),
    (336016, (8.083, 18.216, 24.124)),
    (501420, (7.980, 17.418, 23.738)),
    (790206, (2.826, 15.051, 24.200)),
    (737555, (5.463, 12.115, 21.246)),
    (830171, (0.181, 14.220, 22.550)),
    (133019, (5.488, 18.824, 26.874)),
    (212065, (8.949, 14.490, 24.106)),
    (767555, (0.824, 14.846, 27.583)),
    (877258, (0.780, 12.516, 21.712)),
    (894598, (6.098, 11.632, 28.544)),
    (592777, (4.414, 10.429, 25.467)),
    (217691, (7.604, 13.982, 21.274)),
    (614007, (9.634, 18.120, 28.396)),
    (564420, (6.788, 13.811, 22.536)),
    (286548, (9.099, 10.182, 28.131)),
    (99739, (7.984, 14.235, 25.745)),
    (417955, (5.336, 15.181, 21.573)),
    (120869, (1.987, 12.351, 27.949)),
    (34954, (3.725, 16.425, 23.972)),
    (826323, (2.164, 15.939, 26.400)),
    (625865, (8.413, 10.709, 23.335)),
    (471204, (1.516, 19.215, 25.510)),
    (795198, (9.758, 19.866, 21.307)),
    (923755, (9.764, 13.766, 28.866)),
    (916450, (7.972, 17.102, 20.490)),
    (46611, (8.180, 15.044, 29.440)),
    (396575, (6.915, 12.123, 23.757)),
    (825093, (0.048, 17.232, 23.690)),
    (236714, (3.075, 19.183, 22.097)),
    (963460, (9.421, 16.006, 25.938)),
    (571138, (9.357, 12.293, 28.550)),
    (922049, (0.156, 13.231, 23.987)),
    (60384, (7.747, 17.347, 26.651)),
    (686973, (3.087, 18.124, 21.778)),
    (322339, (0.459, 15.629, 22.970)),
    (902253, (3.952, 16.768, 25.537)),
    (62300, (1.073, 11.687, 21.745)),
    (436762, (2.843, 10.967, 21.775)),
    (866481, (2.794, 15.071, 21.411)),
    (997825, (2.030, 14.447, 27.560)),
    (851769, (2.721, 16.330, 22.824)),
    (652332, (2.105, 10.355, 23.114)),
    (358011, (9.641, 10.281, 23.963)),
    (196797, (3.657, 12.410, 21.977)),
    (499343, (2.027, 13.070, 27.124)),
    (488190, (6.001, 12.834, 23.137)),
    (812819, (6.766, 14.441, 22.665)),
    (445160, (7.105, 14.241, 21.498)),
    (479170, (9.553, 13.209, 29.904)),
    (699426, (5.268, 16.197, 28.572)),
    (572120, (2.167, 16.072, 24.765)),
    (133511, (1.859, 12.787, 22.497)),
    (940409, (6.575, 14.215, 29.920)),
    (513315, (1.704, 10.964, 23.599)),
    (181302, (9.433, 12.616, 22.718)),
    (16379, (3.199, 12.875, 26.110)),
    (684887, (9.399, 11.840, 20.362)),
    (647993, (6.809, 18.898, 22.922)),
    (247671, (9.437, 15.267, 20.217)),
    (780095, (1.156, 15.435, 28.304)),
    (30188, (6.120, 14.523, 23.682)),
    (254233, (5.419, 11.422, 27.951)),
    (773628, (6.754, 13.067, 21.901)),
    (362146, (2.486, 12.312, 24.820)),
    (498508, (4.780, 15.912, 27.192)),
    (352144, (7.155, 15.111, 20.021)),
    (4491, (5.307, 17.866, 26.541)),
    (479408, (4.412, 17.413, 27.881)),
    (303768, (3.050, 17.717, 21.388)),
    (833574, (4.344, 19.474, 26.324)),
    (68135, (8.373, 16.891, 22.323)),
    (231758, (0.023, 13.462, 27.306)),
    (30423, (8.354, 12.324, 28.344)),
    (668131, (5.365, 15.827, 25.452)),
    (356917, (9.538, 10.963, 27.169)),
    (283617, (3.818, 13.341, 26.866)),
    (19522, (2.652, 11.409, 29.779)),
    (674602, (0.212, 18.497, 20.715)),
    (54771, (7.496, 16.373, 25.593)),
    (525099, (9.211, 15.083, 26.276)),
    (756595, (7.388, 17.732, 23.154)),
    (495815, (5.358, 17.521, 27.037)),
    (964700, (1.157, 14.255, 20.827)),
    (601728, (7.535, 15.330, 28.868)),
    (352666, (6.379, 11.142, 27.413)),
    (581036, (8.191, 10.322, 20.701)),
    (663995, (3.942, 10.941, 20.499)),
    (156787, (3.378, 19.418, 23.846)),
    (602322, (3.462, 11.101, 22.247)),
    (763594, (2.205, 17.139, 28.424)),
    (88203, (1.336, 13.327, 29.338)),
    (747516, (0.786, 13.908, 21.038)),
    (768843, (3.608, 18.857, 26.411)),
    (682248, (0.037, 13.995, 26.076)),
    (506318, (2.454, 15.782, 29.045)),
    (5530, (3.962, 13.671, 22.592)),
    (443452, (4.936, 12.369, 22.892)),
    (830499, (2.919, 16.717, 23.128)),
    (95872, (3.348, 19.618, 24.691)),
    (308576, (2.806, 13.844, 20.019)),
    (379683, (5.478, 11.678, 23.446)),
    (463415, (2.728, 17.489, 22.661)),
    (47058, (1.526, 15.081, 20.380)),
    (118814, (7.144, 17.045, 22.745)),
    (111484, (4.471, 11.897, 25.805)),
    (359094, (7.457, 19.786, 23.111)),
    (922184, (6.457, 14.384, 20.350)),
    (254068, (9.136, 11.657, 29.113)),
    (915976, (3.315, 15.792, 22.504)),
    (506615, (2.345, 11.308, 27.951)),
    (46790, (0.147, 17.158, 28.199)),
    (215872, (6.066, 11.414, 22.863)),
    (350587, (8.182, 19.451, 23.942)),
    (854309, (6.633, 15.147, 24.742)),
    (352511, (9.426, 11.803, 26.344)),
    (111167, (3.934, 10.204, 29.254)),
    (50899, (3.690, 18.548, 27.286)),
    (160638, (9.233, 12.595, 27.038)),
    (174097, (5.075, 10.587, 29.512)),
    (154786, (4.786, 10.215, 26.027)),
    (925640, (4.883, 11.902, 22.024)),
    (627896, (4.189, 12.452, 21.817)),
    (577281, (9.419, 19.336, 21.516)),
    (656877, (7.140, 14.857, 28.910)),
    (167303, (2.536, 18.471, 23.944)),
    (242110, (9.012, 19.202, 26.081)),
    (151750, (0.988, 11.635, 23.188)),
    (453201, (9.169, 13.045, 22.288)),
    (716391, (8.502, 14.273, 20.489)),
    (686596, (5.734, 13.334, 27.048)),
    (779389, (7.900, 19.219, 21.208)),
    (247425, (8.662, 10.247, 21.392)),
    (994885, (7.889, 19.667, 26.966)),
    (770838, (8.175, 19.003, 25.445)),
    (307254, (2.343, 11.733, 22.281)),
    (727745, (9.407, 19.600, 27.715)),
    (933390, (1.295, 10.625, 20.266)),
    (24813, (6.389, 14.470, 25.687)),
    (48183, (6.498, 13.988, 23.184)),
    (238516, (2.559, 14.975, 25.452)),
    (45485, (0.305, 18.907, 21.425)),
    (761003, (1.587, 14.294, 21.958)),
    (442749, (5.765, 14.414, 20.566)),
    (922008, (5.096, 14.995, 26.635)),
    (717602, (1.747, 15.209, 28.193)),
    (752779, (1.058, 10.074, 25.830)),
    (876888, (0.989, 18.396, 29.659)),
    (918798, (5.940, 18.449, 22.479)),
    (363352, (2.321, 17.144, 24.199)),
    (925851, (4.644, 16.226, 21.324)),
    (776365, (4.813, 17.503, 29.498)),
    (295613, (1.137, 16.699, 20.393)),
    (695817, (2.776, 14.072, 24.132)),
    (643370, (6.513, 12.422, 24.321)),
    (332339, (3.389, 10.478, 29.515)),
    (160168, (8.107, 19.013, 22.283)),
    (659258, (1.571, 19.920, 21.483)),
    (467506, (6.021, 16.048, 24.285)),
    (833804, (1.383, 12.997, 20.487)),
    (386620, (7.875, 12.130, 29.365)),
    (339057, (8.011, 13.661, 26.761)),
    (138555, (4.984, 14.403, 26.590)),
    (831189, (4.531, 13.303, 20.159)),
    (67625, (7.957, 16.533, 26.079)),
    (915116, (5.957, 16.526, 22.892)),
    (688361, (2.568, 12.447, 24.155)),
    (318112, (2.887, 18.884, 26.088)),
    (89398, (3.128, 14.121, 25.846)),
    (538461, (5.917, 10.295, 25.620)),
    (575822, (8.734, 14.304, 22.539)),
    (48884, (8.703, 19.098, 20.046)),
    (104580, (6.421, 19.674, 28.452)),
    (622569, (9.975, 12.088, 22.650)),
    (137538, (4.007, 14.723, 26.983)),
    (569605, (3.070, 19.368, 27.258)),
    (447605, (5.818, 15.136, 26.196)),
    (596315, (9.997, 10.265, 22.306)),
    (324232, (4.507, 15.199, 21.928)),
    (539510, (9.625, 12.385, 26.081)),
    (580349, (3.440, 17.563, 21.299)),
    (252537, (1.517, 16.411, 27.352)),
    (721989, (6.638, 11.067, 20.411)),
    (751492, (7.810, 11.937, 20.091)),
    (146306, (5.936, 18.505, 25.008)),
    (83945, (9.811, 17.746, 20.833)),
    (718413, (3.845, 19.350, 24.116)),
    (985585, (4.730, 12.893, 25.373)),
    (341192, (2.177, 19.604, 27.875)),
    (582939, (6.759, 18.447, 23.430)),
    (869519, (8.883, 15.299, 29.426)),
    (161868, (1.652, 17.896, 25.594)),
    (747283, (4.151, 14.238, 25.301)),
    (457276, (4.903, 15.872, 21.597)),
    (446437, (0.791, 14.222, 27.452)),
    (656106, (9.315, 19.430, 24.637)),
    (442985, (5.698, 12.568, 28.438)),
    (687698, (8.508, 10.762, 23.627)),
    (195579, (0.046, 14.756, 27.616)),
    (33616, (4.577, 19.226, 22.111)),
    (777727, (2.176, 18.236, 29.018)),
    (331069, (9.962, 13.661, 27.248)),
    (243507, (6.458, 19.019, 24.850)),
    (574141, (9.430, 17.505, 20.802)),
    (181655, (5.177, 18.521, 20.368)),
    (674850, (0.153, 17.251, 25.384)),
    (473360, (8.460, 19.272, 22.074)),
    (504175, (0.691, 19.397, 22.106)),
    (759209, (1.831, 16.271, 27.741)),
    (293119, (3.795, 15.441, 21.225)),
    (418374, (2.338, 14.563, 21.840)),
    (512832, (9.848, 18.780, 22.790)),
    (583604, (8.664, 14.382, 26.869)),
    (749309, (5.252, 11.963, 21.655)),
    (394439, (2.719, 14.618, 29.445)),
    (990555, (8.695, 15.438, 25.386)),
    (773659, (3.995, 16.015, 23.457)),
    (438171, (6.847, 19.355, 20.107)),
    (339032, (1.458, 16.716, 28.008)),
    (690227, (9.572, 11.242, 21.477)),
    (772713, (9.784, 17.556, 21.883)),
    (267464, (8.989, 12.212, 27.315)),
    (435912, (5.587, 11.051, 22.876)),
    (48044, (1.277, 12.880, 22.227)),
    (318089, (1.496, 11.410, 26.833)),
    (711224, (5.583, 19.171, 28.375)),
    (106229, (5.274, 12.725, 29.585)),
    (234185, (3.304, 13.187, 28.385)),
    (537104, (7.581, 10.406, 21.937)),
    (61931, (4.731, 10.509, 27.031)),
    (700482, (3.003, 10.291, 24.642)),
    (198321, (1.904, 16.336, 22.094)),
    (489786, (7.067, 15.483, 22.078)),
    (215652, (9.428, 11.058, 24.911)),
    (3098, (0.181, 16.257, 25.941)),
    (142087, (7.743, 14.682, 27.475)),
    (714759, (1.373, 17.012, 24.176)),
    (768005, (4.539, 19.851, 25.824)),
    (99163, (0.778, 15.459, 20.416)),
    (514650, (9.681, 11.578, 21.077)),
    (799836, (9.928, 10.517, 27.238)),
    (74270, (2.056, 11.567, 22.906)),
    (669524, (0.840, 14.897, 29.490)),
    (420215, (9.806, 16.477, 25.432)),
    (484360, (2.712, 14.309, 28.132)),
    (639628, (4.287, 13.043, 20.190)),
    (835466, (8.349, 10.465, 20.651)),
    (324186, (4.208, 17.041, 28.205)),
    (970228, (1.775, 13.552, 21.425)),
    (628871, (1.019, 12.087, 23.583)),
    (421020, (6.904, 14.801, 29.389)),
    (242749, (2.501, 14.654, 23.866)),
    (240279, (7.165, 12.862, 23.407)),
    (316689, (0.087, 17.762, 21.538)),
    (597466, (2.354, 13.790, 29.180)),
    (958129, (2.143, 10.675, 27.066)),
    (37400, (1.777, 18.045, 25.749)),
    (646774, (0.217, 15.146, 27.122)),
    (141859, (7.679, 16.500, 24.434)),
    (456667, (9.454, 17.118, 25.311)),
    (357292, (7.053, 13.650, 28.187)),
    (470752, (6.604, 11.961, 21.774)),
    (603580, (1.000, 15.239, 28.989)),
    (393005, (2.269, 19.384, 24.899)),
    (572773, (9.339, 16.960, 22.656)),
    (85709, (7.960, 14.648, 29.068)),
    (280247, (5.932, 15.336, 21.233)),
    (391645, (2.235, 13.104, 25.091)),
    (415134, (2.472, 13.372, 25.766)),
    (55525, (6.692, 18.697, 24.744)),
    (655437, (8.684, 10.720, 21.617)),
    (969226, (6.618, 15.989, 29.222)),
    (209955, (3.685, 18.971, 26.251)),
    (157665, (8.935, 11.446, 21.852)),
    (923334, (7.339, 10.116, 20.755)),
    (698087, (7.110, 15.825, 23.291)),
    (904350, (1.977, 17.778, 29.650)),
    (637773, (0.763, 16.786, 29.802)),
    (769289, (9.747, 17.540, 24.467)),
    (524453, (1.349, 13.476, 29.621)),
    (811307, (9.025, 18.498, 27.186)),
    (960068, (7.448, 17.291, 25.083)),
    (250520, (9.950, 18.061, 21.536)),
    (742473, (7.216, 13.160, 24.753)),
    (226988, (9.617, 17.786, 27.787)),
    (448653, (5.182, 11.738, 26.142)),
    (265401, (0.372, 19.244, 27.805)),
    (174024, (3.591, 12.807, 23.948)),
    (378341, (9.731, 16.610, 25.153)),
    (148192, (3.569, 18.563, 20.189)),
    (222414, (0.794, 16.276, 24.004)),
    (512180, (2.746, 14.121, 28.217)),
    (475277, (7.299, 15.908, 26.456)),
    (44564, (3.858, 14.514, 20.081)),
    (996562, (6.587, 18.448, 21.203)),
    (47440, (5.094, 10.009, 26.041)),
    (311527, (9.304, 16.726, 21.216)),
    (758572, (4.249, 18.060, 24.684)),
    (766052, (0.765, 13.809, 29.231)),
    (739407, (4.177, 18.066, 23.197)),
    (751390, (1.412, 18.268, 20.991)),
    (861952, (2.593, 10.721, 29.777)),
    (856324, (7.369, 12.655, 25.058)),
    (975390, (8.777, 15.818, 21.190)),
    (849534, (4.300, 16.043, 22.655)),
    (397715, (8.622, 15.626, 21.491)),
    (280106, (8.834, 14.780, 28.177)),
    (953875, (3.411, 16.069, 28.506)),
    (78351, (7.529, 18.762, 28.503)),
    (785975, (2.890, 14.109, 22.091)),
    (232854, (3.012, 10.954, 29.029)),
    (617678, (2.174, 17.637, 29.636)),
    (139738, (6.940, 15.402, 25.119)),
    (704643, (0.727, 15.765, 24.218)),
    (677605, (5.345, 11.648, 23.067)),
    (505592, (7.676, 12.716, 20.858)),
    (283672, (9.029, 16.674, 24.905)),
    (448160, (8.832, 17.085, 27.963)),
    (755272, (8.849, 12.038, 27.513)),
    (785728, (9.945, 17.106, 24.013)),
    (598401, (1.775, 16.777, 29.685)),
    (390321, (9.969, 17.947, 26.339)),
    (617741, (8.082, 10.419, 23.197)),
    (814474, (7.814, 13.375, 23.286)),
    (386367, (7.442, 18.653, 20.877)),
    (357444, (5.602, 11.708, 28.109)),
    (41009, (9.734, 19.822, 27.201)),
    (845620, (2.210, 15.343, 29.915)),
    (926848, (6.002, 19.338, 28.998)),
    (809604, (0.649, 17.574, 27.935)),
    (431223, (4.607, 19.076, 28.558)),
    (979729, (6.271, 10.317, 23.174)),
    (925090, (8.026, 17.240, 23.656)),
    (941585, (6.052, 10.416, 28.394)),
    (897724, (6.209, 17.461, 29.980)),
    (736789, (3.167, 12.510, 27.172)),
    (887423, (4.590, 16.335, 24.885)),
    (859632, (1.187, 18.359, 24.642)),
    (315152, (7.796, 16.354, 26.132)),
    (434418, (1.372, 11.589, 22.617)),
    (430277, (6.154, 17.630, 25.349)),
    (755998, (0.053, 17.872, 23.760)),
    (847772, (7.652, 17.249, 22.139)),
    (215952, (6.051, 17.335, 26.469)),
    (415248, (1.727, 18.847, 26.793)),
    (758480, (8.833, 19.837, 22.062)),
    (853244, (2.531, 11.239, 23.575)),
    (411077, (6.260, 13.031, 24.028)),
    (65387, (3.960, 14.250, 27.450)),
    (262176, (3.805, 15.847, 26.451)),
    (650472, (3.972, 10.378, 25.247)),
    (315625, (5.369, 15.791, 29.389)),
    (161492, (6.302, 10.804, 27.987)),
    (535536, (4.507, 19.377, 21.509)),
    (95287, (8.550, 14.998, 25.305)),
    (856344, (6.404, 19.908, 21.493)),
    (664737, (1.172, 18.693, 29.013)),
    (692843, (7.635, 13.967, 24.028)),
    (349696, (9.184, 18.592, 26.244)),
    (434538, (1.217, 15.420, 23.344)),
    (440274, (2.797, 15.278, 20.411)),
    (60831, (2.892, 18.107, 28.078)),
    (24738, (1.665, 17.781, 23.033)),
    (533199, (5.201, 13.646, 24.056)),
    (259987, (9.714, 16.366, 25.875)),
    (740969, (4.733, 15.126, 25.800)),
    (631163, (6.473, 15.130, 26.984)),
    (853168, (9.634, 11.418, 26.685)),
    (697896, (6.709, 10.482, 26.971)),
    (829036, (9.605, 12.784, 20.471)),
    (645379, (3.180, 19.789, 24.752)),
    (703235, (3.970, 14.707, 28.573)),
    (188263, (7.477, 10.958, 26.119)),
    (386615, (9.496, 15.113, 22.959)),
    (984111, (1.808, 17.421, 26.742)),
    (541555, (6.340, 12.302, 20.441)),
    (74062, (2.250, 19.623, 22.652)),
    (591140, (9.114, 18.036, 20.730)),
    (784547, (9.551, 14.744, 27.300)),
    (706744, (3.848, 15.142, 22.338)),
    (171180, (2.994, 18.741, 26.999)),
    (697039, (7.538, 11.903, 23.535)),
    (75508, (9.069, 14.914, 25.829)),
    (95616, (9.119, 18.670, 23.337)),
    (327736, (9.927, 14.462, 24.931)),
    (202183, (0.695, 13.124, 23.857)),
    (980094, (7.739, 15.005, 25.413)),
    (269046, (2.345, 17.502, 20.449)),
    (958325, (4.301, 11.454, 22.329)),
    (555787, (7.569, 17.742, 25.138)),
    (97518, (9.486, 11.940, 20.654)),
    (148014, (8.089, 16.855, 21.335)),
    (849499, (9.844, 14.055, 28.266)),
    (265873, (8.959, 19.439, 23.105)),
    (6150, (9.019, 10.682, 26.174)),
    (681623, (8.042, 11.978, 27.449)),
    (887858, (3.856, 16.058, 25.272)),
    (40653, (3.956, 12.280, 25.188)),
    (526821, (0.369, 16.826, 24.914)),
    (984903, (4.406, 19.462, 27.762)),
    (232481, (2.840, 15.952, 22.619)),
    (19499, (8.476, 12.467, 27.077)),
    (392214, (8.203, 15.544, 27.257)),
    (843043, (5.165, 14.372, 26.850)),
    (598752, (5.054, 13.850, 27.104)),
    (157070, (3.196, 19.241, 23.189)),
    (199532, (8.952, 11.798, 22.069)),
    (153903, (7.732, 18.080, 28.270)),
    (635056, (1.157, 17.110, 28.070)),
    (587887, (9.307, 19.224, 27.759)),
    (210890, (7.149, 14.269, 25.713)),
    (899490, (0.309, 19.284, 20.551)),
    (167328, (3.182, 17.354, 29.429)),
    (864002, (3.942, 19.114, 24.809)),
    (204000, (9.805, 13.550, 22.773)),
    (445732, (6.425, 12.830, 22.608)),
    (223528, (9.387, 15.513, 23.335)),
    (735172, (2.708, 11.516, 29.700)),
    (457919, (5.033, 13.683, 20.640)),
    (352816, (0.207, 11.501, 29.658)),
    (258692, (8.637, 10.963, 20.875)),
    (966954, (0.909, 10.033, 23.090)),
    (755208, (3.069, 11.003, 23.780)),
    (98498, (5.082, 19.683, 20.095)),
    (286228, (6.605, 10.422, 23.863)),
    (291946, (2.775, 15.010, 29.623)),
    (424094, (3.056, 13.228, 25.180)),
    (459345, (1.463, 13.637, 20.490)),
    (303517, (4.192, 18.615, 27.350)),
    (645934, (9.197, 16.623, 28.434)),
    (878463, (4.822, 15.642, 25.579)),
    (943446, (5.016, 19.630, 23.908)),
    (695743, (9.472, 17.337, 23.369)),
    (49600, (7.762, 15.207, 22.781)),
    (604541, (8.646, 11.487, 22.619)),
    (659415, (9.536, 13.971, 28.322)),
    (494244, (4.004, 19.628, 22.373)),
    (430935, (9.818, 19.599, 26.991)),
    (434152, (7.094, 18.529, 29.429)),
    (255127, (8.105, 17.381, 21.667)),
    (347231, (7.134, 19.630, 29.025)),
    (713222, (8.327, 15.780, 29.701)),
    (890363, (3.483, 15.981, 21.704)),
    (906676, (1.406, 13.720, 27.553)),
    (17618, (5.349, 16.663, 28.685)),
    (957723, (7.107, 19.840, 28.124)),
    (404821, (8.961, 11.759, 26.387)),
    (516246, (0.805, 11.891, 24.279)),
    (306812, (4.194, 18.597, 25.718)),
    (966942, (6.205, 15.715, 28.031)),
    (113356, (3.311, 12.126, 23.023)),
    (41310, (5.927, 17.539, 21.876)),
    (429673, (6.163, 18.561, 22.817)),
    (848977, (3.466, 19.910, 21.739)),
    (151121, (5.203, 15.225, 24.601)),
    (201651, (3.152, 12.031, 23.962)),
    (730407, (6.234, 11.409, 29.564)),
    (160972, (1.302, 13.910, 23.667)),
    (985116, (0.608, 10.777, 27.281)),
    (725215, (9.832, 14.525, 21.499)),
    (221950, (8.633, 12.659, 24.833)),
    (475062, (5.352, 10.588, 29.096)),
    (875570, (3.091, 17.224, 25.884)),
    (99024, (9.815, 18.525, 27.351)),
    (545912, (3.768, 18.288, 28.167)),
    (22096, (7.717, 17.532, 20.768)),
    (822200, (6.035, 11.866, 20.746)),
    (410853, (5.715, 10.883, 26.957)),
    (851177, (2.702, 10.108, 21.033)),
    (8659, (9.525, 13.566, 25.598)),
    (493137, (6.361, 11.945, 27.843)),
    (222870, (9.628, 18.877, 21.918)),
    (441611, (1.042, 17.974, 21.943)),
    (655895, (3.113, 14.940, 24.512)),
    (751589, (2.383, 13.539, 26.330)),
    (292399, (7.962, 14.545, 25.994)),
    (968933, (2.497, 15.814, 24.391)),
    (70869, (2.395, 14.785, 24.611)),
    (832265, (4.046, 18.102, 21.133)),
    (28515, (2.792, 19.425, 20.643)),
    (271546, (3.485, 17.588, 21.323)),
    (100958, (6.889, 17.671, 23.044)),
    (7647, (6.134, 18.720, 25.908)),
    (114336, (6.984, 17.950, 25.974)),
    (361487, (5.085, 17.904, 28.509)),
    (743949, (3.786, 15.211, 24.764)),
    (130349, (0.607, 11.839, 23.240)),
    (231647, (3.057, 19.314, 24.186)),
    (983817, (8.753, 10.674, 22.741)),
    (907041, (5.737, 17.012, 27.712)),
    (757623, (9.841, 14.925, 21.289)),
    (767309, (3.228, 13.231, 20.626)),
    (654721, (7.005, 15.092, 26.681)),
    (564455, (2.232, 14.099, 22.799)),
    (784081, (0.580, 16.842, 23.253)),
    (838060, (6.685, 13.274, 29.492)),
    (945771, (6.844, 11.060, 25.100)),
    (485821, (3.766, 10.763, 20.328)),
    (832743, (9.197, 11.951, 20.638)),
    (776143, (0.529, 19.398, 21.665)),
    (195164, (4.487, 19.527, 28.862)),
    (216088, (7.482, 17.756, 24.377)),
    (439389, (3.373, 19.584, 29.292)),
    (606663, (2.513, 13.619, 21.285)),
    (746048, (8.462, 15.719, 25.912)),
    (29086, (8.123, 14.057, 24.746)),
    (567324, (0.035, 13.389, 28.909)),
    (683369, (3.540, 14.663, 20.887)),
    (345006, (7.018, 15.031, 25.036)),
    (355751, (1.242, 10.391, 26.880)),
    (636345, (8.234, 12.513, 21.422)),
    (615608, (1.396, 19.297, 23.908)),
    (166663, (7.105, 15.975, 20.071)),
    (738065, (6.579, 19.462, 27.637)),
    (886464, (3.818, 10.862, 23.959)),
    (637010, (8.476, 15.983, 27.150)),
    (879436, (9.281, 12.001, 26.043)),
    (318125, (7.857, 15.083, 22.775)),
    (749291, (9.859, 10.477, 26.505)),
    (400722, (9.668, 12.751, 28.370)),
    (258381, (7.076, 10.550, 29.711)),
    (281621, (9.431, 15.886, 20.653)),
    (144546, (7.212, 17.001, 25.973)),
    (928966, (4.523, 13.970, 26.909)),
    (270536, (5.120, 15.394, 28.850)),
    (887533, (5.009, 16.512, 24.174)),
    (94335, (8.636, 12.857, 28.319)),
    (320023, (9.863, 14.331, 24.778)),
    (259008, (8.460, 15.642, 24.446)),
    (877628, (5.248, 12.152, 22.719)),
    (936270, (7.848, 17.585, 22.976)),
    (117122, (1.789, 13.232, 28.838)),
    (641480, (5.260, 19.425, 20.508)),
    (540873, (5.972, 17.196, 23.370)),
    (853814, (0.515, 14.621, 21.836)),
    (802596, (6.673, 17.563, 22.064)),
    (186227, (6.106, 10.976, 25.529)),
    (634406, (1.144, 17.777, 23.341)),
    (14556, (6.921, 17.210, 27.015)),
    (246359, (8.604, 11.732, 29.786)),
    (729055, (4.655, 11.894, 25.941)),
    (25794, (9.640, 10.917, 23.443)),
    (860531, (5.866, 14.523, 25.542)),
    (562689, (3.563, 19.640, 23.931)),
    (153476, (7.877, 13.399, 25.883)),
    (948592, (2.755, 11.481, 26.696)),
    (663148, (6.802, 11.149, 28.508)),
    (961487, (7.902, 18.029, 27.394)),
    (488817, (1.698, 12.246, 22.944)),
    (447292, (2.430, 16.612, 24.508)),
    (699710, (9.196, 11.343, 28.677)),
    (355441, (3.922, 12.887, 25.902)),
    (315162, (7.173, 16.702, 23.807)),
    (603158, (5.807, 12.326, 20.885)),
    (774996, (2.718, 17.918, 25.972)),
    (564906, (4.329, 16.640, 24.424)),
    (436727, (1.682, 13.294, 26.235)),
    (557003, (9.237, 17.480, 28.478)),
    (558720, (6.186, 18.801, 26.503)),
    (758, (0.611, 14.014, 22.233)),
    (538123, (8.592, 17.916, 27.712)),
    (55760, (3.314, 12.492, 20.463)),
    (398331, (3.547, 14.886, 29.615)),
    (857710, (9.306, 17.156, 23.777)),
    (428175, (1.298, 14.003, 20.689)),
    (32720, (5.387, 15.158, 28.827)),
    (376071, (8.432, 14.436, 29.858)),
    (686664, (7.721, 14.358, 21.518)),
    (918208, (7.381, 16.560, 26.032)),
    (415639, (9.317, 10.360, 29.125)),
    (448139, (2.440, 14.901, 29.539)),
    (711083, (9.460, 19.412, 29.964)),
    (516372, (2.132, 14.039, 22.862)),
    (404069, (3.867, 13.116, 26.260)),
    (848733, (5.825, 14.315, 20.100)),
    (789562, (7.828, 19.791, 23.812)),
    (997341, (7.743, 12.348, 26.871)),
    (4427, (8.364, 17.903, 24.415)),
    (354045, (5.047, 19.057, 28.465)),
    (31146, (3.126, 13.024, 24.788)),
    (145774, (6.780, 18.502, 20.098)),
    (989947, (9.054, 16.909, 26.020)),
    (30289, (6.784, 19.144, 21.176)),
    (83346, (1.445, 13.072, 25.879)),
    (895200, (4.648, 12.334, 22.218)),
    (147324, (6.569, 16.642, 24.254)),
    (846535, (8.978, 16.452, 23.951)),
    (741447, (2.770, 19.249, 23.687)),
    (583221, (1.669, 10.168, 20.569)),
    (431148, (1.296, 17.829, 22.235)),
    (441742, (6.569, 11.868, 26.801)),
    (933828, (8.484, 16.556, 20.598)),
    (423871, (7.566, 13.616, 21.919)),
    (775291, (9.687, 14.488, 20.392)),
    (547787, (2.783, 15.651, 22.508)),
    (448640, (5.262, 10.919, 23.528)),
    (355400, (7.108, 11.038, 27.259)),
    (379473, (4.657, 12.011, 21.780)),
    (978905, (4.116, 14.493, 25.801)),
    (307150, (7.986, 19.711, 25.766)),
    (771565, (6.141, 18.941, 24.633)),
    (435917, (5.120, 10.349, 27.558)),
    (798919, (1.464, 11.696, 23.982)),
    (941668, (0.317, 19.587, 21.305)),
    (402999, (1.187, 18.040, 24.935)),
    (868066, (9.552, 19.233, 21.566)),
    (784589, (8.345, 17.725, 28.980)),
    (193080, (7.820, 16.353, 29.563)),
    (953217, (4.269, 18.614, 25.934)),
    (866169, (5.115, 18.718, 26.377)),
    (618134, (6.596, 11.003, 26.537)),
    (419523, (1.099, 13.573, 23.500)),
    (289327, (1.684, 12.940, 25.636)),
    (823868, (4.121, 13.444, 24.917)),
    (980042, (7.137, 10.097, 22.769)),
    (904364, (2.337, 15.399, 21.059)),
    (74567, (3.031, 11.461, 29.817)),
    (551578, (0.722, 19.124, 25.006)),
    (95804, (1.166, 15.089, 22.177)),
    (520481, (2.574, 11.473, 22.754)),
    (543506, (2.533, 13.668, 24.162)),
    (628231, (6.503, 11.377, 29.051)),
    (620356, (0.848, 18.649, 20.630)),
    (912549, (3.480, 13.084, 21.952)),
    (533569, (2.986, 13.354, 29.170)),
    (515405, (4.938, 16.483, 29.357)),
    (717893, (8.303, 15.072, 29.284)),
    (937015, (5.931, 13.911, 21.184)),
    (519493, (7.518, 11.198, 22.308)),
    (179921, (8.613, 17.134, 27.172)),
    (319678, (0.372, 17.486, 29.554)),
    (329758, (5.017, 17.991, 21.948)),
    (729750, (8.381, 11.718, 26.510)),
    (247540, (6.390, 11.915, 20.842)),
    (259701, (2.832, 13.140, 28.580)),
    (416187, (7.969, 14.453, 22.073)),
    (456172, (4.298, 16.269, 22.126)),
    (215584, (6.739, 11.238, 27.861)),
    (145653, (5.588, 11.131, 22.648)),
    (720075, (4.562, 18.035, 24.869)),
    (542569, (7.611, 11.840, 23.721)),
    (956128, (0.790, 10.269, 23.617)),
    (252950, (5.006, 12.365, 26.298)),
    (459878, (8.945, 19.051, 26.876)),
    (259607, (5.263, 17.227, 24.899)),
    (937316, (0.798, 18.343, 24.678)),
    (588170, (0.739, 14.229, 28.471)),
    (456862, (5.044, 18.807, 29.226)),
    (499589, (4.622, 14.847, 27.973)),
    (689544, (1.902, 14.960, 27.248)),
    (241219, (8.506, 12.203, 26.829)),
    (603984, (8.717, 16.687, 23.306)),
    (799205, (4.353, 11.020, 29.384)),
    (328718, (4.875, 11.442, 20.778)),
    (643305, (9.158, 14.575, 28.213)),
    (678325, (2.104, 15.287, 22.799)),
    (293199, (6.900, 14.681, 29.703)),
    (410174, (4.668, 10.254, 28.395)),
    (83919, (7.384, 10.107, 23.629)),
    (312106, (1.236, 19.677, 21.697)),
    (930617, (9.470, 15.864, 25.414)),
    (462880, (5.494, 11.622, 20.527)),
    (117436, (8.634, 17.043, 25.178)),
    (439468, (4.304, 11.611, 25.211)),
    (238918, (7.946, 15.008, 20.625)),
    (179763, (0.300, 16.307, 25.804)),
    (296417, (1.319, 17.507, 23.007)),
    (90575, (9.943, 13.332, 24.145)),
    (521486, (7.710, 16.868, 20.987)),
    (466178, (3.070, 16.436, 24.231)),
    (492292, (2.905, 14.930, 27.531)),
    (822185, (6.966, 18.385, 29.606)),
    (70621, (1.282, 16.909, 28.923)),
    (208076, (4.385, 14.364, 27.228)),
    (244023, (4.478, 14.016, 26.742)),
    (742235, (3.723, 13.037, 23.483)),
    (621755, (0.982, 10.843, 23.846)),
    (836434, (3.354, 19.334, 22.036)),
    (605803, (2.678, 17.897, 20.467)),
    (476810, (3.051, 17.396, 28.567)),
    (901403, (4.930, 11.194, 21.507)),
    (506391, (6.571, 11.367, 27.636)),
    (303243, (4.323, 17.929, 21.868)),
    (466544, (3.593, 17.345, 27.093)),
    (747563, (3.219, 14.296, 21.781)),
    (418090, (3.908, 17.863, 27.794)),
    (322655, (6.029, 14.661, 21.089)),
    (795673, (6.326, 14.416, 24.118)),
    (70270, (0.410, 14.391, 28.059)),
    (16431, (2.858, 13.500, 26.997)),
    (238852, (6.021, 18.686, 23.759)),
    (865771, (3.146, 15.550, 28.253)),
    (237949, (9.075, 19.884, 21.578)),
    (610928, (7.045, 10.010, 23.249)),
    (317476, (7.738, 14.557, 25.730)),
    (174093, (5.629, 12.936, 24.151)),
    (668074, (5.081, 17.432, 22.472)),
    (893286, (9.454, 15.558, 25.235)),
    (635090, (5.184, 17.153, 27.346)),
    (17701, (1.796, 10.856, 29.410)),
    (495600, (0.485, 12.913, 26.465)),
    (108085, (3.193, 16.111, 23.681)),
    (15814, (0.528, 18.219, 27.317)),
    (571390, (1.555, 14.305, 26.343)),
    (248223, (2.284, 16.553, 28.743)),
    (114112, (4.402, 10.230, 20.486)),
    (514357, (8.933, 19.726, 24.196)),
    (892283, (4.180, 17.110, 25.599)),
    (981350, (4.204, 15.711, 21.334)),
    (19630, (1.952, 11.720, 23.108)),
    (382344, (2.312, 12.769, 29.872)),
    (244845, (9.686, 15.141, 23.341)),
    (319826, (8.510, 19.452, 22.659)),
    (307758, (3.204, 16.104, 21.507)),
    (95607, (0.814, 18.075, 27.218)),
    (57363, (7.201, 12.036, 23.678)),
    (831999, (3.889, 16.706, 20.851)),
    (226287, (9.435, 13.361, 22.456)),
    (507241, (1.082, 12.317, 24.040)),
    (477015, (1.301, 15.545, 29.689)),
    (607231, (7.202, 14.999, 21.577)),
    (904315, (6.720, 18.652, 22.460)),
    (961313, (8.739, 15.929, 23.184)),
    (643648, (1.785, 14.966, 21.622)),
    (273331, (0.343, 11.238, 20.703)),
    (896799, (9.700, 17.056, 27.544)),
    (348643, (9.154, 18.040, 26.151)),
    (255569, (3.453, 16.099, 21.357)),
    (405302, (2.821, 11.567, 27.240)),
    (418314, (4.802, 17.509, 26.174)),
    (926194, (0.135, 15.721, 23.321)),
    (858323, (7.318, 14.698, 28.779)),
    (439202, (9.560, 10.947, 24.191)),
    (55199, (1.882, 16.974, 27.289)),
    (37157, (8.662, 12.076, 26.107)),
    (40750, (6.340, 19.116, 29.707)),
    (629234, (7.104, 19.313, 23.703)),
    (614872, (0.577, 15.517, 29.049)),
    (247088, (2.094, 11.292, 26.246)),
    (532164, (9.663, 16.342, 28.478)),
    (544058, (8.034, 16.121, 22.160)),
    (237527, (3.881, 12.871, 22.055)),
    (733917, (7.577, 10.799, 27.530)),
    (785583, (2.602, 19.185, 28.703)),
    (519112, (7.314, 16.316, 22.249)),
    (125661, (8.703, 15.051, 21.845)),
    (409467, (5.591, 14.621, 29.255)),
    (713328, (5.569, 16.578, 24.449)),
    (541000, (4.691, 19.568, 20.106)),
    (466728, (4.542, 15.581, 26.990)),
    (416730, (8.454, 15.286, 24.768)),
    (58653, (9.594, 18.231, 28.675)),
    (62518, (6.207, 12.051, 24.483)),
    (444876, (1.854, 19.999, 21.981)),
    (67150, (8.016, 11.417, 21.511)),
    (440399, (9.646, 14.048, 23.651)),
    (940072, (2.601, 12.965, 27.466)),
    (973683, (5.903, 17.356, 26.330)),
    (590194, (5.853, 12.740, 25.638)),
    (703389, (1.376, 12.424, 29.996)),
    (169439, (0.782, 19.288, 23.227)),
    (716269, (9.801, 18.038, 27.793)),
    (914287, (4.428, 14.542, 23.688)),
    (955993, (9.705, 10.342, 24.307)),
    (130576, (7.385, 14.778, 21.794)),
    (322542, (4.431, 10.737, 28.103)),
    (937629, (0.839, 12.054, 26.026)),
    (239246, (5.089, 19.998, 25.159)),
    (329759, (2.053, 16.509, 20.045)),
    (474442, (1.048, 18.155, 27.365)),
    (180350, (0.082, 18.313, 22.610)),
    (609700, (1.712, 10.150, 27.768)),
    (156660, (3.432, 19.749, 21.498)),
    (498934, (6.089, 10.006, 25.629)),
    (624554, (9.910, 14.273, 20.208)),
    (578825, (1.025, 18.912, 23.307)),
    (365126, (8.125, 14.847, 25.067)),
    (444970, (2.573, 19.895, 25.613)),
    (297055, (7.819, 14.420, 24.286)),
    (23093, (3.485, 11.110, 23.109)),
    (482194, (3.201, 12.695, 28.813)),
    (383379, (4.051, 18.945, 26.154)),
    (334073, (3.577, 13.904, 27.263)),
    (875759, (9.061, 18.596, 23.695)),
    (674319, (5.628, 16.156, 28.628)),
    (287956, (0.041, 18.642, 24.344)),
    (430070, (6.293, 15.337, 28.271)),
    (885054, (1.518, 13.139, 26.123)),
    (570480, (2.520, 12.931, 28.949)),
    (952607, (4.146, 18.908, 26.603)),
    (330074, (9.610, 17.657, 27.579)),
    (706824, (3.802, 19.061, 29.454)),
    (901011, (9.968, 18.428, 22.632)),
    (225808, (6.219, 18.421, 27.976)),
    (67657, (1.133, 15.231, 22.183)),
    (661080, (6.916, 18.041, 21.285)),
    (923740, (7.541, 16.587, 21.087)),
    (390204, (3.385, 11.088, 22.946)),
    (923565, (9.999, 15.951, 26.014)),
    (298666, (6.994, 12.310, 21.324)),
    (192531, (6.382, 11.831, 21.836)),
    (892171, (2.966, 18.677, 26.668)),
    (708173, (1.160, 11.566, 23.691)),
    (685284, (3.749, 18.391, 22.392)),
    (679366, (4.968, 15.724, 23.279)),
    (355147, (6.804, 12.279, 29.105)),
    (131541, (6.091, 15.043, 22.306)),
    (869155, (5.442, 10.291, 24.564)),
    (812020, (0.882, 10.750, 22.323)),
    (843358, (1.577, 19.197, 23.144)),
    (462349, (9.245, 13.305, 28.670)),
    (817285, (5.025, 18.628, 26.582)),
    (302560, (6.846, 15.396, 25.611)),
    (170388, (1.420, 15.711, 27.766)),
    (832822, (5.128, 18.870, 28.437)),
    (662302, (2.442, 12.996, 26.579)),
    (104297, (2.107, 11.206, 21.777)),
    (555980, (9.493, 12.626, 23.309)),
    (388632, (3.025, 15.177, 28.149)),
    (711373, (1.933, 15.842, 24.678)),
    (511871, (0.084, 17.123, 28.288)),
    (113062, (4.006, 12.526, 24.603)),
    (103436, (4.269, 12.997, 22.190)),
    (240549, (2.175, 13.869, 24.585)),
    (656635, (9.587, 14.152, 29.981)),
    (329435, (5.431, 16.308, 26.177)),
    (819055, (2.573, 13.383, 21.878)),
    (22171, (9.686, 11.805, 22.023)),
    (577025, (2.230, 18.273, 28.210)),
    (245455, (7.926, 12.712, 28.378)),
    (901473, (9.022, 16.485, 27.494)),
    (594549, (7.349, 17.861, 28.764)),
    (407066, (8.119, 19.985, 22.169)),
    (941057, (5.986, 16.968, 21.558)),
    (400310, (9.396, 15.349, 22.163)),
    (929217, (5.900, 17.288, 28.397)),
    (477194, (3.736, 19.795, 22.695)),
    (205749, (6.149, 19.382, 25.210)),
    (209586, (0.645, 13.706, 26.841)),
    (373331, (1.282, 10.547, 22.254)),
    (480640, (8.279, 17.978, 29.375)),
    (768266, (6.880, 11.273, 25.187)),
    (857857, (3.724, 11.291, 29.256)),
    (303139, (3.287, 16.555, 23.255)),
    (116389, (1.930, 18.939, 26.437)),
    (39, (3.397, 18.518, 21.266)),
    (809108, (5.893, 16.920, 23.038)),
    (583557, (9.977, 17.855, 26.682)),
    (213385, (3.852, 19.465, 29.449)),
    (382225, (8.428, 15.370, 20.893)),
    (662027, (6.072, 19.245, 22.834)),
    (753334, (7.524, 19.068, 21.592)),
    (170484, (4.898, 10.853, 23.102)),
    (972975, (1.351, 10.680, 29.747)),
    (596102, (3.158, 15.675, 27.136)),
    (503397, (4.198, 14.322, 27.934)),
    (537023, (4.206, 10.323, 20.627)),
    (822976, (7.296, 19.864, 21.491)),
    (964788, (6.453, 18.739, 25.649)),
    (837305, (7.315, 17.544, 27.376)),
    (174064, (1.219, 11.934, 21.783)),
    (679830, (4.129, 18.087, 27.639)),
    (28169, (9.486, 15.769, 26.666)),
    (608061, (9.179, 15.967, 20.409)),
    (484959, (3.639, 10.729, 24.973)),
    (369411, (4.202, 12.314, 22.063)),
    (344053, (2.261, 13.302, 26.155)),
    (469025, (7.083, 12.130, 27.877)),
    (657676, (5.665, 12.527, 20.286)),
    (670165, (4.762, 16.539, 29.305)),
    (202547, (2.801, 16.354, 26.241)),
    (793129, (2.739, 18.797, 22.806)),
    (95617, (4.883, 14.071, 20.258)),
    (60490, (5.651, 14.996, 28.054)),
    (95052, (7.493, 14.038, 22.289)),
    (576158, (1.372, 13.196, 24.220)),
    (458116, (6.480, 10.543, 24.687)),
    (863982, (6.631, 15.167, 25.783)),
    (773799, (9.128, 12.418, 27.465)),
    (214503, (6.531, 10.426, 28.475)),
    (903109, (6.755, 14.410, 28.421)),
    (174165, (3.578, 13.530, 25.751)),
    (813147, (8.382, 18.342, 26.716)),
    (224152, (6.028, 16.324, 22.504)),
    (507586, (4.869, 19.031, 29.404)),
    (241299, (0.851, 11.812, 25.765)),
    (29646, (0.428, 12.635, 24.885)),
    (755498, (0.582, 13.216, 23.133)),
    (130599, (2.198, 12.089, 25.433)),
    (718041, (3.165, 11.425, 21.200)),
    (604119, (1.842, 16.155, 26.493)),
    (973813, (4.191, 10.319, 23.879)),
    (136750, (7.093, 17.728, 25.459)),
    (408713, (3.773, 13.167, 23.323)),
    (641224, (3.095, 19.842, 24.581)),
    (852051, (7.804, 15.785, 26.657)),
    (907515, (5.804, 13.427, 22.249)),
    (494007, (2.787, 15.292, 23.299)),
    (959495, (3.984, 16.658, 25.339)),
    (873980, (9.889, 19.600, 29.128)),
    (180221, (8.723, 10.187, 23.767)),
    (496051, (3.978, 15.902, 25.351)),
    (679201, (3.682, 17.064, 24.998)),
    (380794, (2.892, 14.247, 25.315)),
    (138966, (6.921, 18.263, 21.081)),
    (506691, (0.668, 12.912, 26.329)),
    (58413, (8.935, 12.652, 28.872)),
    (455834, (7.099, 14.788, 25.111)),
    (773128, (2.991, 15.703, 24.749)),
    (504007, (6.659, 17.898, 29.871)),
    (728598, (6.723, 15.044, 26.739)),
    (127169, (6.345, 11.159, 23.026)),
    (113098, (4.627, 12.017, 23.200)),
    (285718, (6.693, 16.395, 26.673)),
    (231619, (8.993, 17.908, 21.384)),
    (883825, (1.875, 15.454, 27.845)),
    (227081, (8.697, 10.541, 26.013)),
    (457950, (8.984, 17.683, 23.620)),
    (41641, (6.122, 17.294, 26.185)),
    (957523, (4.265, 17.889, 20.547)),
    (278853, (0.866, 15.683, 23.058)),
    (659520, (9.992, 17.806, 28.096)),
    (380584, (9.931, 10.539, 28.488)),
    (561770, (3.867, 17.846, 20.618)),
    (706623, (4.002, 19.321, 29.402)),
    (535008, (8.879, 15.958, 24.376)),
    (215817, (7.031, 17.090, 25.755)),
    (333646, (5.092, 13.173, 22.323)),
    (247845, (6.901, 10.861, 27.910)),
    (274893, (2.430, 16.370, 20.530)),
    (466059, (9.236, 13.573, 24.856)),
    (804475, (2.513, 12.800, 24.680)),
    (112231, (9.343, 18.186, 20.735)),
    (28050, (3.175, 18.996, 24.592)),
    (672055, (1.807, 10.472, 25.988)),
    (477493, (9.810, 13.333, 27.649)),
    (204521, (9.767, 17.452, 25.375)),
    (207857, (0.902, 12.104, 23.263)),
    (224904, (0.201, 10.781, 21.440)),
    (52617, (7.441, 13.710, 22.169)),
    (872434, (1.698, 12.812, 23.752)),
    (872158, (5.450, 15.174, 29.391)),
    (512971, (2.015, 19.908, 27.489)),
    (104194, (1.253, 13.790, 26.359)),
    (843162, (4.707, 18.389, 27.655)),
    (542900, (2.947, 13.837, 28.486)),
    (202402, (4.599, 12.919, 22.425)),
    (747417, (2.985, 13.391, 27.158)),
    (171666, (7.319, 17.568, 28.468)),
    (815736, (6.641, 12.241, 23.254)),
    (428456, (2.316, 19.284, 23.889)),
    (861875, (1.655, 14.239, 23.404)),
    (782501, (6.571, 14.340, 21.686)),
    (677275, (8.229, 13.243, 24.263)),
    (12725, (9.112, 13.836, 29.118)),
    (227425, (7.809, 11.701, 29.022)),
    (196389, (5.204, 19.887, 25.104)),
    (181416, (2.459, 17.684, 27.309)),
    (940865, (4.405, 11.105, 27.793)),
    (220833, (3.964, 15.991, 26.028)),
    (654390, (0.575, 13.041, 25.228)),
    (865158, (0.967, 19.414, 22.215)),
    (83796, (2.621, 15.547, 28.684)),
    (54935, (4.754, 16.442, 24.617)),
    (446498, (8.975, 14.783, 25.651)),
    (17392, (2.378, 17.499, 23.259)),
    (831522, (0.026, 17.439, 29.548)),
    (561713, (2.455, 10.220, 22.894)),
    (475567, (5.692, 13.170, 29.417)),
    (937712, (6.480, 16.355, 25.996)),
    (311306, (6.524, 17.405, 24.178)),
    (673800, (0.999, 14.714, 28.529)),
    (564302, (1.787, 15.514, 27.213)),
    (815083, (1.432, 18.571, 28.994)),
    (655309, (9.883, 17.465, 20.433)),
    (943761, (6.157, 19.402, 22.031)),
    (875780, (6.646, 19.453, 29.094)),
    (139479, (9.947, 19.003, 22.249)),
    (887161, (1.470, 13.080, 23.982)),
    (548761, (7.672, 19.372, 23.527)),
    (933370, (6.263, 17.742, 27.094)),
    (646912, (9.245, 16.913, 28.286)),
    (607514, (3.338, 12.843, 23.417)),
    (757270, (3.812, 12.275, 26.820)),
    (940288, (5.466, 13.200, 24.958)),
    (382997, (9.040, 11.125, 29.274)),
    (433200, (4.306, 16.389, 26.082)),
    (93223, (2.735, 16.827, 20.769)),
    (894782, (9.850, 18.679, 26.152)),
    (317984, (5.219, 14.289, 25.120)),
    (538273, (0.318, 10.624, 20.729)),
    (527114, (1.714, 10.003, 20.862)),
    (86244, (3.027, 15.376, 25.600)),
    (373622, (3.035, 17.599, 20.941)),
    (841252, (0.949, 10.146, 25.001)),
    (605615, (8.900, 15.385, 28.042)),
    (430857, (2.076, 18.438, 24.449)),
    (138449, (0.142, 16.085, 28.421)),
    (124646, (5.205, 18.801, 29.545)),
    (185627, (2.022, 18.866, 26.173)),
    (696381, (5.857, 10.009, 26.178)),
    (889060, (7.091, 19.314, 24.119)),
    (691986, (4.695, 15.337, 28.579)),
    (947789, (7.525, 12.207, 26.405)),
    (95695, (8.933, 18.245, 20.087)),
    (1764, (2.917, 14.971, 23.509)),
    (929871, (3.879, 15.165, 20.906)),
    (55378, (2.340, 13.689, 23.936)),
    (262070, (9.366, 11.185, 22.533)),
    (866223, (6.451, 18.775, 26.230)),
    (659237, (3.174, 11.501, 26.829)),
    (739603, (2.795, 13.385, 25.040)),
    (70502, (1.841, 18.245, 22.258)),
    (867960, (4.968, 11.972, 22.054)),
    (480088, (8.727, 18.249, 20.809)),
    (534814, (7.571, 13.978, 27.501)),
    (918963, (7.386, 11.557, 22.291)),
    (613285, (6.815, 13.721, 29.227)),
    (716389, (4.827, 19.240, 23.565)),
    (644729, (6.283, 14.363, 20.939)),
    (682078, (6.846, 13.044, 22.329)),
    (703581, (9.830, 16.080, 25.489)),
    (91966, (6.344, 18.439, 29.241)),
    (933133, (7.630, 18.167, 22.775)),
    (129969, (0.265, 11.829, 29.670)),
    (379030, (2.069, 13.281, 23.754)),
    (720954, (5.649, 10.019, 25.334)),
    (526591, (6.006, 10.060, 27.803)),
    (817326, (6.728, 16.534, 21.597)),
    (947120, (4.148, 14.253, 26.275)),
    (775325, (8.359, 10.441, 24.920)),
    (855913, (6.716, 12.490, 29.418)),
    (925118, (3.512, 16.458, 20.222)),
    (899563, (0.031, 12.681, 20.562)),
    (304673, (2.143, 11.036, 27.174)),
    (788443, (1.994, 18.978, 21.469)),
    (770848, (4.549, 17.314, 27.831)),
    (258266, (9.756, 15.685, 22.827)),
    (668451, (7.467, 17.176, 21.845)),
    (460701, (2.126, 14.622, 20.775)),
    (792301, (7.843, 12.528, 23.842)),
    (904572, (1.827, 13.575, 27.060)),
    (700873, (4.982, 13.191, 22.336)),
    (356434, (6.359, 10.540, 23.786)),
    (104016, (8.744, 14.555, 29.581)),
    (379663, (7.819, 13.518, 21.645)),
    (602149, (3.317, 19.323, 26.170)),
    (92431, (1.717, 15.736, 20.090)),
    (770192, (7.872, 16.139, 23.095)),
    (743196, (2.227, 13.209, 20.394)),
    (887769, (9.330, 18.588, 24.056)),
    (245251, (7.378, 12.666, 28.340)),
    (538561, (7.760, 11.280, 21.688)),
    (488566, (8.869, 10.619, 23.125)),
    (193299, (5.604, 14.593, 21.462)),
    (683814, (1.958, 14.153, 21.106)),
    (978946, (4.892, 14.197, 24.589)),
    (690440, (5.032, 11.410, 24.465)),
    (331620, (7.699, 11.675, 21.570)),
    (12332, (8.433, 13.595, 22.173)),
    (940191, (3.644, 11.675, 21.610)),
    (900174, (1.394, 12.317, 26.182)),
    (637178, (2.807, 19.366, 26.160)),
    (293948, (0.061, 12.452, 21.164)),
    (944733, (4.582, 16.695, 24.757)),
    (158031, (0.166, 16.650, 26.850)),
    (409838, (2.794, 17.036, 25.245)),
    (278191, (1.176, 17.406, 27.313)),
    (746587, (3.674, 13.007, 21.219)),
    (988154, (3.056, 10.495, 25.291)),
    (414179, (0.663, 15.811, 29.575)),
    (753504, (7.324, 17.295, 28.005)),
    (394493, (7.098, 15.664, 29.105)),
    (496144, (8.752, 11.657, 20.353)),
    (157714, (8.334, 17.119, 23.009)),
    (47584, (6.231, 15.473, 28.975)),
    (421983, (8.723, 19.539, 20.234)),
    (961098, (2.111, 10.119, 20.680)),
    (1983, (2.172, 17.527, 24.405)),
    (135505, (8.378, 11.121, 25.656)),
    (901607, (4.272, 17.030, 23.155)),
    (422570, (2.632, 18.203, 25.971)),
    (388336, (7.231, 19.164, 29.614)),
    (569077, (7.301, 17.741, 20.199)),
    (421347, (1.885, 18.664, 28.207)),
    (68289, (5.878, 19.466, 20.980)),
    (399302, (2.788, 17.141, 23.058)),
    (837309, (3.392, 10.296, 29.311)),
    (806708, (4.737, 15.408, 27.658)),
    (872758, (9.381, 19.823, 23.215)),
    (873710, (6.751, 11.396, 29.708)),
    (675739, (7.572, 15.496, 26.657)),
    (489419, (1.998, 10.576, 21.319)),
    (922589, (2.609, 18.344, 26.653)),
    (278084, (2.028, 17.429, 22.671)),
    (710951, (4.006, 16.040, 24.834)),
    (560668, (4.062, 17.027, 27.995)),
    (52253, (1.710, 19.755, 28.348)),
    (255123, (1.089, 15.790, 25.152)),
    (921790, (6.250, 13.150, 24.493)),
    (999297, (6.673, 11.476, 23.333)),
    (855439, (2.540, 11.863, 22.109)),
    (275018, (3.034, 15.169, 28.030)),
    (362782, (4.255, 12.739, 27.045)),
    (559652, (6.296, 11.122, 26.057)),
    (105811, (4.823, 10.138, 28.205)),
    (526410, (1.507, 16.438, 25.574)),
    (892216, (7.836, 10.456, 28.056)),
    (459109, (4.085, 10.112, 26.274)),
    (830105, (8.296, 11.903, 28.050)),
    (125592, (7.680, 18.328, 22.284)),
    (276872, (2.942, 14.749, 29.886)),
    (709533, (3.402, 14.994, 28.397)),
    (64276, (2.895, 16.033, 25.662)),
    (652900, (6.215, 19.555, 25.381)),
    (23444, (0.333, 13.458, 29.685)),
    (988081, (8.629, 12.084, 29.097)),
    (820663, (7.028, 19.411, 25.519)),
    (940808, (9.624, 12.300, 26.817)),
    (985277, (1.834, 14.956, 29.846)),
    (582838, (4.153, 17.911, 22.867)),
    (524283, (2.764, 13.692, 28.765)),
    (857374, (7.062, 15.498, 24.365)),
    (569746, (5.836, 18.384, 24.629)),
    (887356, (2.673, 19.321, 27.498)),
    (180496, (8.836, 16.455, 26.859)),
    (478518, (7.283, 17.284, 21.509)),
    (146354, (6.768, 17.366, 20.119)),
    (960621, (2.533, 18.826, 21.953)),
    (168938, (5.609, 16.296, 25.835)),
    (945526, (7.685, 16.430, 26.936)),
    (455656, (6.527, 11.644, 23.893)),
    (367048, (8.054, 16.487, 29.085)),
    (547520, (3.839, 19.152, 27.270)),
    (165553, (7.397, 11.521, 24.057)),
    (100646, (5.626, 17.855, 24.154)),
    (784632, (9.690, 14.308, 29.332)),
    (294098, (5.593, 19.881, 29.346)),
    (874401, (2.769, 14.535, 26.950)),
    (361095, (6.048, 12.562, 22.561)),
    (243708, (9.518, 15.472, 26.240)),
    (70610, (5.349, 10.589, 23.622)),
    (375210, (7.297, 13.384, 23.758)),
    (415263, (6.574, 19.671, 21.393)),
    (595529, (8.438, 10.045, 25.639)),
    (242805, (6.438, 15.625, 21.812)),
    (59881, (3.772, 17.664, 29.780)),
    (93555, (9.666, 11.435, 21.805)),
    (350182, (6.520, 16.114, 24.670)),
    (554144, (0.352, 11.591, 27.339)),
    (949343, (6.120, 17.942, 24.122)),
    (525729, (8.946, 15.375, 27.020)),
    (449310, (9.965, 11.098, 26.388)),
    (838658, (6.029, 15.654, 28.066)),
    (280210, (1.281, 10.831, 27.973)),
    (899785, (3.848, 18.897, 21.484)),
    (87604, (6.408, 15.095, 29.013)),
    (457482, (6.753, 15.767, 22.021)),
    (624722, (8.945, 17.401, 22.204)),
    (416743, (2.726, 19.396, 28.833)),
    (262477, (1.227, 16.070, 23.363)),
    (999124, (3.977, 16.795, 24.747)),
    (88696, (4.741, 14.242, 26.033)),
    (588060, (8.826, 17.019, 26.214)),
    (485057, (6.287, 18.773, 29.512)),
    (169082, (4.719, 16.787, 21.889)),
    (911995, (7.946, 17.394, 24.326)),
    (472320, (2.075, 14.369, 21.989)),
    (20976, (5.041, 18.376, 28.030)),
    (393309, (3.353, 11.795, 28.320)),
    (830705, (5.477, 12.326, 27.179)),
    (107520, (1.788, 10.086, 26.188)),
    (4439, (2.077, 10.206, 28.049)),
    (175767, (3.167, 14.290, 23.598)),
    (218608, (0.715, 19.316, 29.639)),
    (632232, (7.564, 10.886, 24.796)),
    (843176, (1.573, 19.450, 23.647)),
    (862882, (3.742, 16.762, 23.063)),
    (953596, (1.848, 19.554, 22.620)),
    (540161, (8.062, 19.244, 22.559)),
    (839084, (8.146, 14.455, 28.260)),
    (116813, (2.089, 11.602, 21.961)),
    (925357, (8.064, 14.420, 22.529)),
    (94015, (6.445, 15.394, 26.084)),
    (424572, (2.213, 11.690, 24.723)),
    (300070, (1.584, 19.846, 25.522)),
    (895712, (1.719, 19.382, 26.732)),
    (10680, (0.210, 14.401, 29.230)),
    (4289, (2.819, 19.034, 26.419)),
    (788065, (0.504, 18.823, 26.293)),
    (191871, (8.960, 12.400, 28.672)),
    (527617, (2.809, 17.747, 21.492)),
    (414774, (5.819, 13.553, 27.506)),
    (628903, (7.161, 16.877, 29.449)),
    (159402, (0.864, 17.798, 28.783)),
    (863929, (8.906, 19.768, 29.684)),
    (312734, (7.756, 12.594, 28.737)),
    (143652, (0.142, 10.580, 20.026)),
    (965256, (3.864, 17.462, 21.229)),
    (293135, (4.474, 12.982, 25.533)),
    (215903, (1.772, 14.142, 24.171)),
    (197035, (0.797, 12.175, 27.906)),
    (828124, (9.761, 14.308, 24.134)),
    (459873, (2.675, 17.398, 21.311)),
    (983978, (5.159, 16.953, 25.211)),
    (890422, (1.129, 18.661, 27.392)),
    (810492, (2.226, 17.245, 22.674)),
    (382079, (9.715, 15.953, 20.178)),
    (732377, (4.948, 13.694, 24.902)),
    (262229, (4.324, 15.861, 26.233)),
    (780298, (0.076, 19.291, 24.296)),
    (777218, (6.986, 13.644, 23.933)),
    (336281, (1.497, 15.089, 27.427)),
    (252967, (1.217, 11.620, 29.436)),
    (867371, (1.198, 19.561, 26.974)),
    (123037, (3.257, 11.869, 23.740)),
    (171766, (0.589, 17.503, 25.379)),
    (219502, (6.210, 11.578, 25.284)),
    (996171, (7.862, 18.835, 26.066)),
    (712450, (3.967, 14.876, 29.777)),
    (499356, (8.079, 15.509, 27.003)),
    (307, (6.815, 14.126, 20.206)),
    (239533, (1.063, 16.080, 29.124)),
    (307513, (4.380, 12.077, 29.167)),
    (520907, (4.049, 19.353, 26.885)),
    (109170, (4.490, 11.402, 28.605)),
    (675848, (9.430, 10.688, 23.700)),
    (45424, (3.607, 19.739, 27.268)),
    (827364, (6.478, 17.691, 25.027)),
    (199642, (0.617, 13.350, 28.416)),
    (690916, (6.327, 10.374, 21.710)),
    (314566, (7.001, 13.435, 26.199)),
    (862788, (5.960, 14.516, 27.932)),
    (564639, (9.147, 11.581, 27.374)),
    (622819, (9.022, 19.286, 28.374)),
    (722277, (3.959, 13.662, 25.448)),
    (475031, (1.170, 15.463, 29.327)),
    (453897, (6.310, 12.419, 22.499)),
    (206582, (2.535, 13.573, 21.870)),
    (998660, (2.785, 17.748, 27.533)),
    (746752, (6.265, 16.347, 27.963)),
    (988410, (3.268, 14.977, 23.256)),
    (478025, (8.275, 13.180, 24.784)),
    (319168, (6.753, 19.127, 27.595)),
    (786797, (0.084, 11.661, 23.264)),
    (673164, (1.061, 10.587, 20.468)),
    (235173, (5.429, 13.403, 28.165)),
    (870549, (1.000, 10.298, 22.318)),
    (307133, (1.099, 13.751, 24.096)),
    (522230, (7.376, 13.906, 25.248)),
    (247469, (5.437, 12.111, 22.701)),
    (382968, (6.639, 19.782, 25.887)),
    (331895, (6.433, 17.435, 28.742)),
    (634359, (8.486, 18.006, 27.328)),
    (281654, (5.024, 16.580, 21.345)),
    (824147, (8.426, 14.186, 28.247)),
    (99153, (5.621, 18.801, 25.433)),
    (757046, (4.011, 12.682, 22.787)),
    (39549, (8.123, 18.087, 20.877)),
    (66492, (7.181, 13.147, 23.711)),
    (20077, (2.504, 12.916, 22.350)),
    (573739, (0.423, 10.718, 22.408)),
    (526373, (3.451, 15.412, 25.936)),
    (377932, (3.703, 19.470, 21.508)),
    (435653, (0.927, 18.479, 29.682)),
    (897426, (5.969, 16.331, 26.631)),
    (957638, (8.320, 17.668, 28.872)),
    (414144, (6.757, 15.765, 23.835)),
    (356495, (3.365, 12.342, 26.061)),
    (263932, (8.126, 16.596, 26.193)),
    (486417, (8.009, 16.079, 25.445)),
    (738488, (3.229, 10.885, 22.984)),
    (733809, (4.985, 17.232, 20.284)),
    (901642, (9.357, 16.160, 28.737)),
    (827571, (0.202, 17.630, 26.427)),
    (806413, (6.514, 11.590, 27.851)),
    (204651, (2.435, 17.441, 21.800)),
    (61507, (3.801, 12.349, 28.934)),
    (755713, (1.957, 13.279, 29.212)),
    (707597, (3.732, 16.928, 27.181)),
    (783041, (9.523, 11.823, 27.764)),
    (871229, (0.922, 15.868, 29.879)),
    (133474, (7.867, 11.999, 28.723)),
    (563823, (9.014, 13.486, 29.567)),
    (431124, (0.756, 18.968, 29.437)),
    (797474, (6.292, 19.840, 23.509)),
    (850120, (1.306, 12.140, 24.474)),
    (743436, (4.840, 17.371, 24.828)),
    (240954, (5.226, 17.193, 20.981)),
    (274324, (1.191, 16.508, 29.125)),
    (747062, (6.487, 11.825, 29.807)),
    (707764, (6.233, 16.444, 24.201)),
    (522106, (5.026, 15.347, 28.193)),
    (575866, (5.238, 15.893, 24.245)),
    (248096, (1.219, 15.160, 23.738)),
    (702235, (5.530, 19.765, 25.069)),
    (857619, (9.770, 16.196, 20.967)),
    (895222, (6.583, 11.364, 25.724)),
    (355594, (6.066, 10.075, 20.681)),
    (867500, (2.286, 12.834, 27.315)),
    (83902, (6.197, 11.508, 24.246)),
    (762052, (8.115, 14.868, 29.546)),
    (231347, (7.955, 16.119, 25.418)),
    (831549, (8.623, 18.048, 29.615)),
    (532720, (2.051, 18.507, 26.603)),
    (676364, (7.389, 11.966, 29.733)),
    (3517, (3.019, 15.890, 25.414)),
    (640943, (1.403, 19.971, 20.146)),
    (923866, (7.919, 12.060, 29.747)),
    (716082, (7.834, 16.261, 25.078)),
    (28038, (0.250, 17.201, 23.732)),
    (536821, (3.910, 19.031, 20.598)),
    (812323, (9.160, 16.025, 25.594)),
    (497038, (0.824, 13.654, 26.402)),
    (15965, (2.069, 15.225, 26.321)),
    (153814, (5.152, 16.484, 26.591)),
    (527739, (1.755, 12.562, 20.801)),
    (898996, (0.586, 16.146, 21.344)),
    (693116, (8.312, 13.463, 20.395)),
    (965673, (3.109, 17.103, 26.845)),
    (746104, (8.985, 19.582, 24.217)),
    (399553, (3.857, 16.316, 23.489)),
    (753685, (5.539, 15.099, 22.123)),
    (952465, (6.471, 10.288, 25.528)),
    (569585, (1.311, 18.126, 29.811)),
    (234738, (5.348, 14.417, 29.894)),
    (932537, (1.260, 17.178, 24.457)),
    (648565, (6.861, 16.119, 25.421)),
    (528722, (3.800, 17.877, 26.414)),
    (151698, (2.515, 10.176, 20.502)),
    (143166, (3.944, 19.104, 26.087)),
    (941895, (2.078, 12.295, 21.964)),
    (757725, (1.832, 18.428, 29.506)),
    (459564, (7.066, 19.695, 22.266)),
    (304971, (7.159, 16.056, 22.256)),
    (605689, (4.101, 19.138, 27.248)),
    (196266, (5.954, 17.039, 29.352)),
    (317911, (5.074, 12.980, 25.815)),
    (131323, (0.395, 15.804, 20.300)),
    (226468, (1.462, 10.376, 22.910)),
    (532756, (3.122, 16.386, 22.628)),
    (740030, (7.525, 17.810, 26.640)),
    (411933, (6.480, 11.468, 24.032)),
    (193791, (1.616, 16.637, 27.484)),
    (901843, (5.701, 12.867, 26.623)),
    (894051, (7.802, 18.279, 23.709)),
    (894893, (2.569, 15.568, 28.283)),
    (825956, (6.964, 17.359, 25.792)),
    (145531, (6.040, 13.992, 25.028)),
    (238522, (9.065, 11.804, 23.412)),
    (385705, (1.097, 16.687, 27.727)),
    (603249, (3.095, 14.475, 27.647)),
    (856415, (3.803, 12.820, 25.069)),
    (268547, (3.448, 17.761, 26.694)),
    (811808, (5.306, 12.215, 29.060)),
    (155913, (7.228, 16.602, 23.062)),
    (620078, (0.812, 13.210, 24.071)),
    (984893, (9.963, 11.819, 21.907)),
    (59023, (8.721, 12.156, 28.899)),
    (754174, (2.013, 19.277, 22.964)),
    (176488, (1.319, 15.006, 27.977)),
    (379899, (5.248, 18.030, 25.106)),
    (790415, (2.055, 13.286, 21.928)),
    (966004, (2.018, 10.651, 23.617)),
    (492344, (8.206, 18.423, 26.792)),
    (561255, (9.260, 12.036, 21.216)),
    (913353, (3.876, 13.430, 23.193)),
    (214792, (0.530, 19.749, 25.081)),
    (410473, (0.058, 19.682, 24.410)),
    (64256, (4.876, 19.382, 26.422)),
    (527785, (7.234, 15.300, 23.149)),
    (913143, (1.323, 15.556, 26.493)),
    (540460, (1.983, 12.914, 26.815)),
    (195660, (6.117, 17.067, 24.064)),
    (179492, (6.399, 17.493, 20.999)),
    (199394, (2.269, 16.569, 24.391)),
    (436520, (4.308, 17.105, 20.135)),
    (655060, (7.818, 16.296, 26.065)),
    (532343, (5.668, 15.261, 28.462)),
    (921582, (0.311, 15.017, 22.675)),
    (102085, (6.284, 10.729, 21.362)),
    (5544, (7.915, 14.463, 28.986)),
    (176603, (2.649, 16.976, 29.532)),
    (15315, (6.094, 16.515, 26.117)),
    (40960, (0.371, 12.458, 25.398)),
    (333712, (9.190, 10.984, 25.254)),
    (34720, (9.333, 15.066, 21.900)),
    (431915, (6.624, 11.328, 26.869)),
    (277298, (1.945, 15.551, 22.752)),
    (230871, (3.924, 16.946, 23.184)),
    (23388, (6.991, 12.669, 24.141)),
    (269778, (0.222, 18.822, 29.493)),
    (418453, (4.104, 13.024, 29.585)),
    (578530, (1.403, 10.657, 27.766)),
    (809008, (5.028, 19.165, 21.519)),
    (838109, (7.895, 13.728, 23.407)),
    (410265, (2.772, 16.000, 21.600)),
    (916075, (2.036, 18.759, 21.011)),
    (164045, (7.697, 10.514, 23.578)),
    (413692, (8.366, 18.924, 22.518)),
    (501452, (6.077, 15.403, 29.058)),
    (206492, (4.652, 10.052, 27.973)),
    (528994, (8.860, 13.760, 22.433)),
    (888303, (6.512, 15.425, 26.745)),
    (298249, (2.032, 15.770, 22.564)),
    (908957, (3.293, 11.332, 25.729)),
    (435005, (0.327, 11.134, 20.167)),
    (441844, (8.579, 18.244, 20.978)),
    (336804, (7.205, 19.172, 25.799)),
    (588740, (7.863, 18.986, 29.346)),
    (781914, (6.062, 17.779, 23.002)),
    (73143, (2.447, 17.646, 21.777)),
    (834024, (0.414, 17.877, 20.388)),
    (836756, (3.921, 19.935, 24.433)),
    (833568, (4.395, 16.055, 25.733)),
    (513326, (8.998, 12.558, 22.602)),
    (733, (3.315, 16.534, 26.089)),
    (228814, (4.900, 10.566, 26.461)),
    (421389, (8.203, 13.783, 25.297)),
    (766662, (9.830, 14.841, 25.348)),
    (785592, (1.362, 19.209, 24.730)),
    (231130, (6.400, 19.275, 23.985)),
    (454116, (4.682, 12.041, 28.406)),
    (164834, (9.361, 11.336, 27.354)),
    (265146, (8.042, 13.325, 21.348)),
    (436647, (5.972, 17.421, 25.945)),
    (46214, (6.041, 14.193, 25.540)),
    (529338, (9.184, 18.255, 29.172)),
    (914538, (9.088, 16.511, 26.865)),
    (856994, (6.800, 19.458, 26.748)),
    (43245, (0.692, 12.158, 24.566)),
    (194483, (1.696, 16.638, 29.200)),
    (426434, (8.223, 17.614, 27.656)),
    (817966, (5.656, 12.864, 23.072)),
    (566603, (4.160, 11.015, 28.760)),
    (179694, (7.731, 10.255, 20.917)),
    (326754, (6.268, 11.375, 28.788)),
    (822902, (8.669, 14.778, 21.837)),
    (688780, (7.728, 11.458, 25.375)),
    (60831, (6.807, 15.799, 24.923)),
    (27722, (5.818, 12.162, 29.701)),
    (765797, (7.195, 10.245, 25.127)),
    (195945, (1.816, 12.011, 29.314)),
    (345326, (3.620, 14.772, 29.730)),
    (345998, (7.625, 16.436, 24.810)),
    (11465, (2.917, 16.196, 23.181)),
    (258404, (3.257, 16.932, 29.638)),
    (515498, (1.374, 14.900, 27.629)),
    (716200, (6.841, 10.308, 23.750)),
    (915409, (9.554, 19.889, 25.205)),
    (32538, (4.996, 18.904, 27.994)),
    (250383, (0.182, 12.164, 25.545)),
    (250622, (9.226, 11.022, 24.606)),
    (864528, (6.283, 16.761, 20.911)),
    (402856, (5.595, 14.637, 24.080)),
    (46208, (6.846, 19.234, 24.738)),
    (655496, (2.730, 17.284, 26.182)),
    (165410, (0.047, 13.323, 27.793)),
    (716202, (2.103, 14.676, 28.518)),
    (121770, (9.890, 15.249, 24.828)),
    (998832, (5.991, 15.787, 22.796)),
    (232127, (8.805, 11.799, 24.929)),
    (807948, (7.773, 15.147, 25.213)),
    (31826, (0.560, 11.506, 25.336)),
    (500457, (6.538, 12.977, 28.843)),
    (165832, (8.525, 16.700, 29.520)),
    (299175, (6.702, 15.022, 20.362)),
    (178900, (0.803, 11.472, 28.622)),
    (88607, (0.839, 14.305, 20.722)),
    (102801, (2.989, 18.328, 27.388)),
    (527159, (8.975, 14.649, 20.456)),
    (835587, (7.511, 16.826, 24.011)),
    (307391, (6.946, 12.797, 28.826)),
    (572079, (5.107, 15.777, 21.158)),
    (58535, (9.727, 13.489, 28.534)),
    (823291, (2.236, 18.951, 27.009)),
    (883018, (9.506, 10.584, 27.562)),
    (790255, (9.363, 10.561, 27.688)),
    (55764, (6.885, 11.546, 28.142)),
    (610182, (6.008, 14.428, 26.053)),
    (249907, (5.232, 18.007, 23.339)),
    (777623, (4.286, 13.388, 23.381)),
    (287041, (8.376, 11.691, 23.357)),
    (121924, (1.543, 17.395, 25.197)),
    (835643, (0.136, 11.867, 21.648)),
    (625078, (9.622, 18.280, 26.853)),
    (709872, (9.112, 13.313, 20.407)),
    (887882, (5.358, 17.481, 22.033)),
    (31641, (1.281, 19.487, 23.330)),
    (615850, (1.181, 11.690, 29.556)),
    (70512, (3.365, 12.830, 20.317)),
    (810780, (1.794, 18.102, 27.783)),
    (473897, (3.023, 15.349, 22.169)),
    (152137, (2.887, 16.012, 27.828)),
    (608301, (7.119, 17.186, 29.353)),
    (192465, (8.280, 15.924, 26.654)),
    (242305, (0.148, 13.304, 29.906)),
    (877419, (2.360, 15.731, 21.749)),
    (921539, (2.045, 14.082, 29.850)),
    (918036, (8.814, 18.692, 27.080)),
    (411875, (9.820, 11.876, 29.006)),
    (805179, (0.109, 14.907, 22.659)),
    (938782, (5.029, 14.240, 26.237)),
    (628683, (8.375, 15.561, 25.486)),
    (448439, (6.970, 13.550, 25.941)),
    (565127, (5.658, 15.520, 29.431)),
    (831006, (9.227, 12.381, 20.148)),
    (180686, (6.513, 12.621, 27.015)),
    (320306, (7.817, 15.369, 21.833)),
    (437441, (5.419, 19.877, 29.139)),
    (93031, (3.133, 14.794, 23.086)),
    (579920, (9.404, 17.139, 24.526)),
    (846406, (4.927, 17.154, 27.461)),
    (778257, (3.717, 15.929, 25.603)),
    (939918, (8.488, 12.773, 24.539)),
    (144597, (4.743, 17.381, 20.413)),
    (578910, (3.814, 12.583, 23.207)),
    (313798, (3.135, 18.142, 26.046)),
    (861558, (5.236, 18.201, 22.847)),
    (573784, (5.448, 12.988, 28.484)),
    (61308, (6.852, 19.850, 25.263)),
    (341105, (2.544, 14.975, 23.741)),
    (226040, (4.332, 13.042, 27.446)),
    (633933, (0.594, 12.625, 28.094)),
    (378856, (1.387, 11.896, 29.552)),
    (64149, (0.489, 19.247, 22.230)),
    (273968, (4.012, 15.702, 22.425)),
    (243792, (7.226, 14.998, 25.316)),
    (892036, (7.494, 13.950, 23.606)),
    (760741, (4.851, 16.225, 24.335)),
    (38287, (1.327, 16.733, 23.122)),
    (917331, (6.413, 11.207, 25.256)),
    (748284, (6.744, 13.599, 28.344)),
    (16419, (2.946, 16.345, 29.745)),
    (940613, (6.885, 16.467, 21.850)),
    (736607, (5.169, 19.422, 22.245)),
    (204528, (7.319, 10.716, 29.169)),
    (825497, (4.244, 19.955, 24.621)),
    (976425, (3.016, 11.135, 27.160)),
    (22904, (8.010, 11.222, 29.401)),
    (178636, (3.865, 16.121, 26.957)),
    (477462, (3.793, 12.306, 28.974)),
    (175703, (2.098, 12.689, 21.516)),
    (264260, (2.124, 18.984, 26.820)),
    (151876, (2.915, 17.455, 23.954)),
    (170940, (9.032, 17.395, 22.581)),
    (834938, (4.855, 19.844, 22.963)),
    (955187, (2.979, 10.239, 24.649)),
    (424659, (3.860, 18.624, 22.500)),
    (296664, (1.589, 12.080, 27.403)),
    (175432, (5.534, 12.943, 21.604)),
    (811329, (0.373, 11.839, 20.769)),
    (119309, (6.088, 15.788, 29.855)),
    (738909, (3.887, 11.644, 23.199)),
    (372305, (7.126, 17.823, 27.183)),
    (583366, (0.660, 11.818, 24.913)),
    (636725, (9.092, 18.796, 28.506)),
    (857408, (0.685, 19.733, 20.789)),
    (877901, (7.184, 16.692, 26.875)),
    (951573, (3.298, 13.186, 25.131)),
    (811062, (8.911, 11.244, 27.519)),
    (111334, (4.075, 19.162, 28.250)),
    (945095, (3.145, 13.241, 27.770)),
    (783201, (5.985, 16.934, 20.469)),
    (792041, (0.788, 12.882, 22.151)),
    (967790, (4.337, 13.763, 26.771)),
    (87737, (3.958, 18.155, 20.252)),
    (119558, (3.617, 15.546, 25.538)),
    (253015, (1.456, 11.456, 22.187)),
    (102302, (5.416, 13.694, 26.787)),
    (204188, (8.456, 13.636, 26.065)),
    (268387, (8.771, 18.362, 26.005)),
    (929647, (6.922, 13.429, 22.229)),
    (280549, (3.326, 14.847, 22.942)),
    (792461, (9.984, 15.023, 28.285)),
    (387290, (5.303, 15.853, 24.734)),
    (163254, (3.926, 19.506, 24.002)),
    (225169, (9.633, 18.253, 25.898)),
    (69510, (3.077, 10.357, 29.082)),
    (888840, (5.186, 13.489, 22.700)),
    (102465, (1.173, 15.987, 25.094)),
    (162268, (3.876, 18.714, 27.259)),
    (450579, (8.115, 10.433, 24.372)),
    (370941, (0.164, 13.767, 21.106)),
    (6737, (6.272, 10.799, 20.678)),
    (608643, (8.544, 18.474, 20.577)),
    (90546, (3.250, 15.366, 29.226)),
    (952192, (1.742, 10.128, 29.302)),
    (223815, (3.427, 15.634, 27.548)),
    (185272, (5.412, 13.782, 20.052)),
    (785956, (1.754, 19.816, 21.594)),
    (852790, (2.070, 16.717, 26.732)),
    (123960, (5.265, 17.812, 26.611)),
    (25787, (0.641, 17.823, 27.764)),
    (251358, (2.533, 17.482, 27.957)),
    (398837, (2.664, 11.561, 20.184)),
    (81064, (1.155, 17.310, 24.445)),
    (625554, (2.086, 19.028, 23.982)),
    (522189, (3.755, 16.139, 25.609)),
    (860941, (1.810, 19.712, 21.152)),
    (258491, (5.572, 14.613, 22.235)),
    (469458, (4.547, 12.939, 26.253)),
    (972292, (8.762, 19.831, 23.890)),
    (910407, (5.501, 11.806, 21.355)),
    (548167, (8.758, 14.941, 27.485)),
    (292443, (7.981, 18.951, 28.760)),
    (431222, (0.949, 19.336, 22.900)),
    (59987, (6.408, 14.105, 24.950)),
    (864209, (6.215, 16.881, 24.162)),
    (137158, (8.130, 13.611, 20.060)),
    (783613, (4.318, 12.478, 21.192)),
    (975007, (8.956, 12.940, 23.661)),
    (905787, (6.352, 11.118, 25.798)),
    (618842, (9.592, 18.293, 20.644)),
    (377232, (7.258, 13.590, 27.277)),
    (236489, (9.851, 10.301, 26.799)),
    (579009, (3.635, 14.888, 22.464)),
    (461273, (7.280, 16.780, 25.882)),
    (43440, (0.831, 14.913, 29.160)),
    (708086, (3.725, 17.917, 23.360)),
    (423077, (4.895, 15.182, 29.831)),
    (533542, (5.350, 19.054, 23.340)),
    (526917, (8.152, 10.768, 20.187)),
    (342659, (5.586, 14.342, 22.769)),
    (74811, (7.094, 15.731, 22.478)),
    (514655, (7.670, 13.572, 29.139)),
    (902481, (3.792, 17.262, 29.997)),
    (598624, (7.166, 17.056, 25.552)),
    (437570, (8.417, 10.014, 28.369)),
    (960238, (3.508, 15.379, 29.272)),
    (158368, (2.470, 15.763, 24.880)),
    (807294, (8.311, 13.337, 29.573)),
    (698543, (7.969, 11.576, 26.095)),
    (309670, (2.379, 18.235, 25.322)),
    (75985, (6.186, 19.192, 20.526)),
    (916190, (9.743, 16.292, 20.213)),
    (11470, (0.469, 16.761, 21.960)),
    (16775, (0.323, 10.255, 27.690)),
    (129782, (3.255, 19.319, 21.857)),
    (473921, (1.724, 11.960, 23.893)),
    (446, (2.225, 15.276, 28.813)),
    (316070, (7.965, 17.789, 22.980)),
    (235023, (4.033, 19.961, 23.388)),
    (110057, (0.394, 13.279, 20.360)),
    (75067, (1.578, 19.572, 22.433)),
    (931748, (5.285, 13.445, 23.457)),
    (483456, (4.457, 18.151, 23.684)),
    (522176, (9.285, 19.918, 27.718)),
    (436, (8.046, 19.297, 20.412)),
    (193446, (4.402, 11.526, 22.015)),
    (633734, (5.143, 14.563, 26.814)),
    (67345, (0.891, 19.533, 27.498)),
    (64344, (2.434, 14.241, 22.732)),
    (730017, (4.727, 18.463, 26.227)),
    (214304, (7.236, 13.370, 25.537)),
    (985583, (8.676, 19.268, 27.163)),
    (347797, (3.694, 10.116, 22.692)),
    (841271, (2.328, 16.885, 25.429)),
    (116459, (9.054, 18.673, 29.706)),
    (414235, (0.340, 16.220, 25.008)),
    (5219, (5.143, 16.317, 24.105)),
    (616238, (5.075, 17.690, 22.678)),
    (230194, (9.051, 17.948, 27.182)),
    (441584, (9.495, 11.475, 21.934)),
    (668986, (9.187, 18.570, 23.298)),
    (311887, (9.402, 11.970, 24.245)),
    (261346, (6.651, 19.821, 26.314)),
    (34074, (2.619, 13.400, 23.867)),
    (587327, (1.989, 18.425, 25.351)),
    (205588, (3.315, 17.955, 29.968)),
    (159423, (7.600, 18.698, 21.255)),
    (699158, (5.810, 16.095, 20.005)),
    (596801, (2.625, 13.622, 22.611)),
    (727656, (5.611, 14.798, 20.978)),
    (835434, (9.096, 16.837, 25.424)),
    (831183, (6.440, 17.108, 28.893)),
    (263114, (4.713, 15.487, 28.383)),
    (721530, (4.273, 17.821, 26.236)),
    (472185, (3.027, 19.811, 27.272)),
    (564899, (9.374, 14.793, 20.410)),
    (640717, (8.355, 15.677, 29.826)),
    (536810, (5.089, 11.748, 24.890)),
    (551953, (6.430, 18.593, 22.168)),
    (82137, (0.466, 10.073, 21.667)),
    (280462, (8.802, 18.053, 27.938)),
    (47786, (2.277, 12.828, 27.673)),
    (591724, (2.054, 12.398, 27.016)),
    (864340, (5.530, 11.540, 21.944)),
    (246178, (8.344, 18.279, 21.941)),
    (43203, (5.300, 18.991, 27.076)),
    (663485, (9.797, 19.982, 21.950)),
    (957322, (5.731, 12.128, 22.770)),
    (118808, (4.234, 14.769, 26.057)),
    (711754, (0.218, 16.380, 26.169)),
    (684111, (6.372, 17.963, 28.517)),
    (839834, (6.906, 11.009, 25.553)),
    (248938, (4.005, 15.519, 22.739)),
    (346338, (0.807, 15.038, 27.975)),
    (959502, (2.854, 16.077, 28.827)),
    (652107, (3.054, 14.014, 23.376)),
    (337477, (1.858, 14.017, 22.780)),
    (711109, (4.523, 15.126, 21.454)),
    (156267, (4.809, 14.259, 27.468)),
    (467100, (0.628, 18.042, 28.767)),
    (908773, (9.224, 17.130, 28.512)),
    (562108, (8.493, 19.579, 23.176)),
    (411294, (2.823, 19.778, 27.250)),
    (661590, (8.360, 13.277, 25.666)),
    (259484, (0.548, 15.130, 29.438)),
    (140630, (4.672, 16.655, 22.669)),
    (372968, (6.423, 10.167, 26.960)),
    (212248, (8.127, 15.796, 22.416)),
    (518279, (2.381, 16.779, 22.807)),
    (472961, (9.653, 18.276, 24.454)),
    (966264, (9.277, 13.348, 26.046)),
    (941563, (0.819, 10.448, 24.733)),
    (956981, (0.791, 11.623, 25.706)),
    (736061, (9.654, 18.528, 23.606)),
    (689231, (8.866, 15.393, 20.803)),
    (20765, (0.348, 14.211, 23.723)),
    (227278, (7.834, 19.022, 29.978)),
    (231493, (3.156, 11.123, 21.233)),
    (597505, (4.526, 17.227, 24.395)),
    (359005, (7.907, 19.929, 28.926)),
    (951973, (0.445, 12.068, 25.726)),
    (356335, (6.153, 12.636, 28.116)),
    (149675, (1.670, 17.956, 25.317)),
    (811502, (8.991, 19.856, 27.885)),
    (982980, (0.014, 15.423, 25.434)),
    (632729, (3.018, 13.319, 20.383)),
    (647073, (5.580, 18.192, 20.660)),
    (133858, (5.285, 14.132, 23.644)),
    (594561, (3.054, 14.311, 25.054)),
    (378614, (6.323, 13.767, 23.281)),
    (562877, (7.441, 17.409, 22.327)),
    (261861, (1.089, 11.643, 29.486)),
    (957158, (4.827, 10.483, 29.264)),
    (79536, (4.908, 11.981, 25.771)),
    (860220, (5.121, 12.060, 29.427)),
    (889850, (4.135, 12.829, 21.447)),
    (103584, (8.213, 10.493, 24.871)),
    (510725, (6.125, 13.085, 28.495)),
    (946122, (1.351, 17.706, 26.141)),
    (477843, (3.830, 14.016, 27.357)),
    (540988, (0.330, 19.998, 29.349)),
    (3065, (4.934, 13.516, 21.341)),
    (622542, (1.494, 16.110, 25.683)),
    (145466, (7.475, 14.612, 23.827)),
    (531834, (7.707, 11.607, 28.773)),
    (277308, (4.970, 11.644, 29.136)),
    (827067, (6.823, 12.002, 21.566)),
    (267608, (1.021, 17.062, 21.730)),
    (325237, (7.880, 10.847, 29.451)),
    (526852, (0.207, 11.503, 21.182)),
    (283854, (9.588, 18.958, 26.180)),
    (257222, (2.194, 18.928, 29.417)),
    (104371, (6.060, 13.855, 28.468)),
    (692247, (9.809, 17.050, 25.271)),
    (856552, (7.086, 16.130, 26.364)),
    (739421, (8.834, 18.221, 25.082)),
    (290485, (4.329, 13.440, 28.643)),
    (300333, (0.388, 17.878, 28.422)),
    (144129, (8.458, 17.353, 26.763)),
    (857855, (3.305, 11.378, 26.334)),
    (99878, (8.017, 19.405, 21.454)),
    (438765, (3.827, 12.790, 27.724)),
    (910622, (3.970, 15.311, 23.220)),
    (158489, (7.312, 18.415, 24.271)),
    (274584, (9.319, 17.578, 26.554)),
    (852753, (2.544, 15.251, 24.226)),
    (856528, (3.171, 17.664, 28.567)),
    (991171, (8.386, 19.821, 28.054)),
    (313963, (5.528, 11.427, 24.004)),
    (23520, (7.087, 16.477, 26.767)),
    (699937, (8.769, 19.899, 26.396)),
    (383011, (3.879, 19.267, 28.139)),
    (487192, (2.308, 13.768, 22.976)),
    (272474, (3.293, 14.591, 26.568)),
    (200391, (6.004, 17.535, 27.313)),
    (215449, (3.281, 12.143, 22.925)),
    (635127, (1.349, 10.898, 28.284)),
    (824060, (2.641, 15.389, 25.460)),
    (249272, (3.986, 11.771, 26.311)),
    (202325, (7.959, 13.688, 25.460)),
    (812669, (3.180, 10.398, 22.008)),
    (655135, (7.932, 10.840, 25.128)),
    (130044, (4.423, 18.404, 29.890)),
    (246021, (3.245, 15.381, 28.453)),
    (166565, (7.613, 16.089, 23.505)),
    (501942, (5.283, 19.094, 23.523)),
    (14790, (1.276, 10.065, 27.594)),
    (779762, (0.500, 11.780, 25.729)),
    (387001, (2.479, 13.287, 25.650)),
    (269279, (1.275, 13.556, 21.787)),
    (614987, (0.222, 19.598, 25.154)),
    (684469, (1.251, 15.364, 23.465)),
    (44005, (5.342, 16.550, 26.773)),
    (700684, (9.540, 10.531, 22.402)),
    (259321, (5.096, 11.416, 21.268)),
    (493655, (2.932, 11.895, 21.000)),
    (252091, (9.939, 17.181, 24.526)),
    (251522, (4.702, 11.238, 25.740)),
    (30622, (7.029, 16.240, 29.049)),
    (684486, (0.827, 14.111, 22.344)),
    (529697, (9.654, 12.161, 21.728)),
    (677675, (8.592, 12.770, 29.886)),
    (873452, (7.907, 14.251, 23.954)),
    (194438, (3.484, 19.341, 29.168)),
    (904878, (8.495, 16.187, 28.186)),
    (349475, (1.211, 14.893, 25.055)),
    (820164, (9.249, 15.804, 21.078)),
    (643510, (6.029, 10.503, 23.371)),
    (900763, (8.752, 14.511, 24.066)),
    (934484, (5.874, 14.651, 20.509)),
    (862789, (1.371, 15.693, 25.080)),
    (930581, (3.770, 11.024, 26.356)),
    (102950, (2.705, 10.158, 20.590)),
    (750723, (9.468, 15.081, 22.583)),
    (783501, (5.634, 18.935, 24.602)),
    (548769, (3.709, 16.062, 28.343)),
    (618144, (3.242, 13.514, 27.367)),
    (737758, (1.947, 19.217, 23.788)),
    (879560, (6.850, 11.613, 23.123)),
    (798115, (7.756, 19.118, 28.911)),
    (756236, (7.620, 16.334, 20.552)),
    (2444, (0.532, 10.017, 24.606)),
    (535082, (9.441, 12.096, 24.320)),
    (37896, (1.928, 13.094, 22.835)),
    (437100, (2.265, 17.675, 23.611)),
    (841079, (6.366, 12.739, 24.818)),
    (988406, (6.199, 10.185, 23.729)),
    (784500, (5.240, 17.562, 21.098)),
    (515884, (9.553, 15.690, 27.674)),
    (767044, (4.475, 19.306, 28.411)),
    (192094, (4.962, 16.647, 23.215)),
    (578556, (1.269, 10.061, 23.216)),
    (44334, (8.573, 19.159, 22.451)),
    (507040, (9.319, 16.053, 23.713)),
    (51142, (1.605, 13.681, 20.904)),
    (196430, (6.015, 15.855, 23.036)),
    (538856, (3.575, 17.486, 22.593)),
    (149664, (6.989, 17.502, 28.121)),
    (352241, (6.419, 13.959, 25.107)),
    (316303, (2.026, 12.252, 29.830)),
    (3790, (2.238, 17.051, 23.147)),
    (809372, (2.200, 15.697, 25.670)),
    (574364, (5.991, 15.858, 29.263)),
    (762442, (1.551, 10.918, 29.558)),
    (217490, (9.747, 11.460, 21.658)),
    (139234, (2.497, 12.347, 24.864)),
    (283414, (0.896, 12.230, 29.244)),
    (601579, (8.435, 17.495, 25.022)),
    (350682, (0.604, 11.859, 24.579)),
    (458282, (3.493, 17.616, 29.352)),
    (932690, (8.180, 12.640, 23.879)),
    (659674, (8.944, 18.300, 25.863)),
    (906769, (1.589, 12.382, 25.473)),
    (824560, (5.568, 18.849, 24.573)),
    (504197, (1.254, 13.581, 20.777)),
    (701470, (7.472, 15.947, 27.842)),
    (253893, (4.846, 15.097, 24.687)),
    (845161, (2.599, 16.314, 29.204)),
    (856358, (3.330, 18.983, 29.688)),
    (371155, (7.312, 18.691, 23.577)),
    (534051, (9.680, 17.746, 28.546)),
    (70559, (9.929, 10.198, 26.623)),
    (522434, (9.111, 15.731, 27.420)),
    (56826, (5.032, 14.432, 29.347)),
    (16984, (0.914, 13.959, 28.996)),
    (213464, (9.141, 13.313, 27.417)),
    (336727, (6.221, 12.640, 21.105)),
    (940242, (9.566, 15.322, 23.212)),
    (221607, (3.732, 18.215, 29.495)),
    (78455, (3.276, 12.497, 23.177)),
    (42156, (5.411, 11.520, 27.255)),
    (616478, (1.062, 11.336, 26.137)),
    (197400, (1.011, 13.252, 28.443)),
    (385372, (2.780, 11.553, 25.432)),
    (760261, (5.883, 12.953, 28.780)),
    (704422, (6.786, 10.254, 20.362)),
    (615896, (3.043, 11.462, 23.635)),
    (243259, (8.965, 15.897, 29.617)),
    (962287, (5.296, 19.164, 28.974)),
    (951745, (8.852, 15.080, 23.556)),
    (304904, (9.138, 13.908, 29.453)),
    (298679, (4.010, 12.071, 26.944)),
    (982570, (0.380, 13.679, 24.035)),
    (216510, (1.591, 16.112, 25.477)),
    (397028, (6.584, 10.651, 27.858)),
    (261855, (5.756, 16.556, 28.014)),
    (833682, (0.704, 12.307, 22.706)),
    (388609, (4.845, 12.277, 26.538)),
    (237660, (2.570, 13.656, 27.341)),
    (247801, (2.650, 18.701, 21.916)),
    (758372, (7.353, 18.360, 24.529)),
    (403803, (5.544, 18.148, 23.921)),
    (635446, (6.913, 16.612, 25.722)),
    (272329, (2.853, 12.866, 29.113)),
    (946111, (1.210, 19.225, 29.916)),
    (911883, (5.339, 12.153, 24.536)),
    (253784, (0.864, 12.101, 27.368)),
    (98484, (0.836, 12.385, 28.195)),
    (373755, (4.403, 12.402, 27.547)),
    (48339, (7.460, 16.115, 24.905)),
    (659776, (7.723, 10.933, 26.880)),
    (855760, (7.398, 17.796, 21.045)),
    (189126, (9.559, 17.594, 26.017)),
    (75498, (7.993, 13.276, 22.548)),
    (406059, (6.680, 10.899, 25.566)),
    (653831, (7.679, 14.584, 28.216)),
    (76347, (7.855, 15.591, 29.529)),
    (440898, (7.018, 19.550, 24.631)),
    (205068, (8.571, 11.401, 28.718)),
    (646227, (4.520, 18.260, 27.732)),
    (492940, (8.272, 12.309, 20.439)),
    (356859, (3.311, 16.858, 28.442)),
    (112573, (7.181, 19.573, 27.136)),
    (309255, (5.809, 10.552, 24.651)),
    (491171, (6.681, 18.286, 27.506)),
    (637494, (2.037, 12.140, 20.338)),
    (838545, (8.131, 16.010, 23.674)),
    (683472, (2.837, 16.956, 21.330)),
    (536723, (3.048, 13.350, 21.421)),
    (663572, (6.660, 13.431, 28.560)),
    (32556, (9.617, 10.501, 21.603)),
    (205593, (9.913, 18.425, 28.921)),
    (474163, (5.431, 15.587, 22.269)),
    (515058, (2.322, 10.081, 28.742)),
    (953245, (1.359, 17.687, 25.685)),
    (828226, (2.057, 15.098, 21.250)),
    (668546, (9.097, 10.951, 29.983)),
    (236674, (1.816, 17.991, 20.368)),
    (800999, (2.121, 12.118, 27.820)),
    (455378, (8.280, 18.329, 26.657)),
    (298316, (0.641, 17.202, 27.379)),
    (665604, (7.387, 19.649, 28.779)),
    (905623, (9.762, 13.634, 28.737)),
    (734410, (4.881, 18.216, 21.329)),
    (568245, (3.641, 11.102, 22.488)),
    (775227, (9.100, 15.080, 29.440)),
    (143535, (7.444, 10.027, 20.088)),
    (306484, (6.528, 14.445, 20.583)),
    (115351, (0.335, 14.331, 25.737)),
    (140821, (7.445, 16.688, 27.911)),
    (288913, (3.621, 13.257, 21.909)),
    (493975, (6.906, 12.318, 20.661)),
    (561870, (2.806, 16.439, 22.420)),
    (475085, (4.628, 18.445, 22.270)),
    (662004, (3.143, 17.230, 20.196)),
    (374661, (3.414, 18.943, 24.790)),
    (258076, (5.507, 10.909, 22.680)),
    (983321, (7.061, 11.289, 27.723)),
    (670380, (2.808, 14.558, 27.097)),
    (443790, (2.787, 16.783, 26.621)),
    (133693, (6.482, 17.570, 25.712)),
    (759785, (9.679, 16.620, 27.864)),
    (818664, (5.889, 19.648, 27.329)),
    (102156, (0.196, 18.812, 23.935)),
    (708892, (4.731, 19.955, 22.372)),
    (979653, (6.104, 11.301, 22.036)),
    (529185, (0.607, 14.407, 28.160)),
    (173463, (0.871, 11.986, 23.552)),
    (129802, (9.547, 14.461, 24.156)),
    (421121, (8.481, 12.499, 23.630)),
    (260221, (1.054, 12.394, 21.661)),
    (984935, (4.820, 16.518, 25.899)),
    (548683, (5.907, 12.423, 25.573)),
    (534603, (6.211, 11.139, 23.719)),
    (873217, (4.499, 16.028, 29.217)),
    (689543, (0.759, 19.738, 25.836)),
    (532612, (1.937, 17.097, 27.221)),
    (987871, (1.466, 10.329, 28.818)),
    (357820, (5.827, 17.360, 22.416)),
    (690000, (1.148, 19.567, 28.772)),
    (41104, (7.483, 15.056, 28.479)),
    (936527, (5.540, 15.684, 20.155)),
    (842841, (8.095, 16.023, 27.034)),
    (473365, (2.033, 15.835, 27.304)),
    (871835, (1.790, 19.173, 24.047)),
    (559219, (4.506, 11.843, 28.737)),
    (305392, (2.110, 10.329, 24.853)),
    (488380, (9.701, 11.373, 20.614)),
    (423105, (6.847, 15.366, 20.741)),
    (566161, (2.223, 13.190, 20.374)),
    (313838, (6.369, 14.534, 26.279)),
    (424392, (7.302, 17.232, 25.248)),
    (413836, (5.304, 11.401, 21.361)),
    (139929, (3.922, 16.038, 28.268)),
    (431057, (6.063, 15.302, 20.092)),
    (468722, (0.512, 13.829, 24.216)),
    (396645, (1.395, 13.933, 26.204)),
    (918165, (6.327, 11.814, 25.461)),
    (873097, (7.132, 17.985, 20.500)),
    (429642, (8.983, 10.052, 24.657)),
    (961321, (9.302, 16.285, 25.051)),
    (853801, (8.350, 14.364, 22.778)),
    (205273, (1.172, 11.634, 26.955)),
    (220751, (9.643, 13.276, 21.053)),
    (667062, (9.665, 17.063, 20.549)),
    (771346, (7.362, 17.964, 22.323)),
    (878712, (3.943, 14.689, 26.868)),
    (713244, (2.125, 13.528, 28.641)),
    (328598, (0.041, 17.031, 20.571)),
    (494929, (9.755, 19.481, 20.765)),
    (213927, (9.641, 19.638, 24.097)),
    (872873, (0.718, 12.718, 21.263)),
    (819073, (8.976, 12.120, 28.167)),
    (912932, (5.844, 16.522, 21.117)),
    (507463, (3.041, 16.194, 27.152)),
    (599869, (3.342, 19.969, 20.022)),
    (766854, (5.494, 15.656, 29.758)),
    (946006, (4.131, 16.701, 20.175)),
    (340620, (8.411, 17.087, 22.202)),
    (304099, (3.083, 12.928, 24.943)),
    (62938, (8.986, 15.598, 20.295)),
    (29759, (5.263, 19.546, 22.428)),
    (63569, (1.925, 12.723, 20.367)),
    (705877, (6.024, 19.045, 26.888)),
    (404379, (4.600, 15.387, 29.626)),
    (113476, (8.168, 16.807, 28.855)),
    (63540, (2.716, 19.109, 22.419)),
    (597732, (0.494, 17.259, 29.017)),
    (801108, (0.529, 16.177, 24.299)),
    (235040, (9.560, 17.849, 25.826)),
    (434268, (3.499, 13.211, 24.812)),
    (547297, (8.877, 14.230, 25.623)),
    (502106, (7.036, 19.429, 28.880)),
    (672688, (1.542, 13.403, 25.368)),
    (388259, (6.672, 10.897, 29.094)),
    (144713, (8.126, 11.112, 23.789)),
    (904176, (4.890, 19.148, 20.445)),
    (358734, (3.847, 13.749, 26.629)),
    (83146, (1.824, 13.571, 24.116)),
    (677097, (0.760, 17.145, 29.121)),
    (964900, (6.813, 14.886, 26.119)),
    (848157, (2.578, 17.654, 28.501)),
    (946610, (3.657, 18.709, 22.290)),
    (936667, (0.727, 14.111, 21.576)),
    (58959, (5.881, 11.404, 24.903)),
    (381605, (5.547, 17.611, 20.830)),
    (58400, (2.025, 10.412, 27.689)),
    (858850, (7.106, 10.116, 28.331)),
    (35121, (7.519, 19.231, 25.611)),
    (142567, (9.014, 11.371, 26.584)),
    (584397, (6.925, 16.633, 22.488)),
    (137390, (9.492, 11.583, 29.084)),
    (38041, (8.051, 10.127, 22.709)),
    (105848, (4.316, 10.464, 26.471)),
    (819723, (4.347, 17.474, 22.003)),
    (207832, (8.560, 18.567, 23.504)),
    (473124, (8.158, 15.433, 23.994)),
    (405544, (7.229, 10.307, 20.248)),
    (880622, (8.904, 12.413, 24.247)),
    (602172, (4.071, 14.538, 26.495)),
    (375158, (4.311, 19.159, 27.332)),
    (948115, (9.944, 16.884, 27.212)),
    (309034, (4.654, 19.311, 28.628)),
    (494683, (2.479, 18.781, 27.456)),
    (643894, (0.964, 19.836, 27.320)),
    (450663, (8.944, 16.065, 22.984)),
    (659699, (0.893, 11.427, 23.003)),
    (26373, (4.021, 15.100, 28.614)),
    (477891, (4.603, 11.710, 25.350)),
    (750489, (8.272, 13.029, 20.164)),
    (408981, (9.945, 15.689, 26.444)),
    (550286, (3.255, 13.202, 29.997)),
    (5787, (1.209, 18.037, 21.787)),
    (974577, (0.707, 18.146, 21.499)),
    (766532, (1.356, 12.262, 26.189)),
    (825901, (5.762, 11.638, 26.061)),
    (755791, (2.895, 15.241, 21.568)),
    (952616, (6.550, 11.160, 29.612)),
    (572962, (3.201, 13.657, 21.934)),
    (566949, (5.287, 15.229, 29.633)),
    (249098, (0.056, 12.610, 25.358)),
    (621647, (4.118, 14.327, 23.425)),
    (436235, (0.013, 19.131, 24.802)),
    (429554, (4.835, 16.746, 25.475)),
    (513963, (9.808, 13.655, 27.495)),
    (270585, (6.728, 10.647, 25.947)),
    (174990, (4.075, 14.863, 24.503)),
    (629689, (9.277, 17.034, 20.938)),
    (56631, (9.218, 14.632, 21.790)),
    (944601, (1.673, 10.223, 27.704)),
    (627954, (5.085, 12.701, 20.720)),
    (673272, (3.014, 12.776, 27.402)),
    (81443, (3.887, 15.784, 26.010)),
    (468215, (1.948, 12.882, 24.630)),
    (50705, (2.090, 15.825, 25.657)),
    (400080, (4.902, 17.254, 28.369)),
    (366424, (2.560, 10.569, 26.065)),
    (897281, (0.562, 11.959, 20.418)),
    (527647, (2.257, 12.655, 29.924)),
    (352266, (0.251, 18.981, 26.898)),
    (490937, (7.078, 10.127, 21.816)),
    (706696, (2.699, 18.145, 24.030)),
    (264650, (0.552, 16.145, 28.829)),
    (351358, (0.791, 18.687, 27.106)),
    (570528, (3.645, 17.336, 21.637)),
    (9500, (5.916, 14.326, 27.679)),
    (814691, (8.411, 10.867, 28.848)),
    (673349, (9.313, 16.320, 27.764)),
    (962624, (1.663, 12.750, 24.455)),
    (463460, (4.521, 11.455, 27.823)),
    (212016, (0.774, 11.595, 29.889)),
    (70717, (7.663, 19.927, 24.416)),
    (999521, (0.718, 12.895, 21.030)),
    (408536, (5.297, 10.806, 24.067)),
    (934334, (9.140, 18.060, 28.921)),
    (465282, (4.508, 17.272, 25.822)),
    (588684, (0.117, 15.709, 23.985)),
    (97989, (4.349, 11.432, 27.300)),
    (920815, (7.727, 16.794, 20.449)),
    (72871, (3.059, 14.251, 23.321)),
    (246793, (2.147, 16.940, 20.689)),
    (426482, (0.828, 12.539, 25.199)),
    (439786, (0.280, 13.442, 22.130)),
    (353703, (6.516, 19.389, 22.630)),
    (385920, (6.290, 11.176, 27.030)),
    (691267, (4.940, 14.817, 25.515)),
    (222459, (9.613, 17.104, 23.732)),
    (498527, (8.202, 13.531, 28.475)),
    (408883, (2.535, 15.830, 23.066)),
    (988053, (4.036, 11.751, 22.870)),
    (576732, (3.246, 11.219, 22.623)),
    (37266, (5.163, 11.112, 26.003)),
    (777135, (4.915, 18.326, 25.049)),
    (952182, (5.857, 13.258, 25.173)),
    (255254, (8.620, 18.586, 21.768)),
    (900836, (5.611, 14.603, 23.877)),
    (54161, (7.715, 12.525, 29.508)),
    (495803, (7.418, 16.758, 28.017)),
    (944909, (2.660, 12.890, 26.740)),
    (306416, (3.855, 13.508, 22.825)),
    (412410, (5.425, 17.230, 23.193)),
    (956959, (4.336, 12.292, 23.179)),
    (117937, (5.574, 19.099, 21.693)),
    (837345, (4.039, 11.349, 20.576)),
    (306975, (8.565, 11.237, 23.921)),
    (411609, (0.431, 15.676, 20.770)),
    (460236, (9.065, 10.206, 25.169)),
    (824228, (8.158, 13.815, 26.357)),
    (282414, (7.753, 16.043, 20.580)),
    (434275, (3.735, 11.176, 23.006)),
    (183869, (1.843, 13.922, 24.346)),
    (862923, (7.482, 16.789, 24.539)),
    (291849, (6.540, 16.451, 24.701)),
    (80463, (5.958, 11.138, 26.892)),
    (677554, (5.153, 11.146, 22.373)),
    (322008, (5.392, 12.824, 27.696)),
    (821640, (6.789, 10.891, 20.008)),
    (605652, (1.915, 18.586, 24.045)),
    (176779, (0.242, 10.479, 29.140)),
    (504500, (0.142, 19.066, 25.036)),
    (197059, (9.042, 13.258, 27.114)),
    (611505, (3.136, 13.670, 24.699)),
    (891673, (7.977, 19.521, 23.068)),
    (897692, (6.812, 16.697, 27.679)),
    (475772, (3.274, 10.384, 21.841)),
    (526229, (7.699, 16.917, 21.396)),
    (247120, (6.216, 10.749, 24.319)),
    (559900, (5.487, 13.268, 25.988)),
    (837097, (2.607, 15.991, 28.660)),
    (240200, (3.101, 12.212, 20.158)),
    (107157, (3.166, 10.073, 27.539)),
    (335192, (5.803, 13.390, 28.539)),
    (213540, (4.392, 13.162, 25.235)),
    (640319, (1.367, 12.766, 27.360)),
    (370576, (3.062, 11.876, 27.860)),
    (34368, (6.929, 17.795, 29.783)),
    (349197, (5.329, 18.417, 25.077)),
    (703550, (8.893, 10.145, 29.145)),
    (214091, (5.836, 19.946, 28.651)),
    (820005, (9.164, 10.333, 22.027)),
    (510969, (4.744, 11.180, 20.241)),
    (41770, (7.931, 13.424, 27.162)),
    (646616, (7.142, 18.776, 25.298)),
    (734718, (8.225, 18.193, 24.691)),
    (92631, (4.343, 14.963, 29.304)),
    (216095, (8.079, 18.210, 25.586)),
    (604523, (8.055, 11.691, 23.700)),
    (895571, (0.789, 11.506, 26.851)),
    (829857, (1.352, 10.891, 29.080)),
    (556764, (4.974, 15.747, 24.505)),
    (750996, (5.113, 14.833, 25.240)),
    (722359, (0.772, 16.067, 23.418)),
    (40878, (0.496, 13.966, 29.765)),
    (557769, (3.680, 12.548, 24.047)),
    (247937, (9.990, 16.575, 23.265)),
    (791695, (8.643, 19.307, 26.264)),
    (870391, (1.852, 10.443, 23.055)),
    (151668, (9.085, 12.282, 20.662)),
    (202518, (2.040, 10.215, 21.389)),
    (944035, (1.031, 17.088, 23.391)),
    (802097, (9.200, 16.340, 24.707)),
    (217589, (8.081, 19.993, 22.230)),
    (595598, (2.687, 17.343, 25.048)),
    (778615, (3.322, 13.736, 24.670)),
    (927834, (0.554, 14.671, 25.766)),
    (617361, (9.345, 11.517, 29.602)),
    (561336, (8.580, 15.291, 22.466)),
    (381986, (6.994, 19.299, 28.526)),
    (593779, (2.322, 10.559, 22.134)),
    (989647, (6.954, 18.609, 24.219)),
    (794739, (8.612, 12.371, 22.753)),
    (831616, (9.876, 17.604, 21.100)),
    (269846, (4.442, 15.110, 26.392)),
    (964776, (7.795, 11.793, 20.885)),
    (515135, (3.737, 19.108, 20.663)),
    (478482, (4.211, 16.299, 25.726)),
    (295564, (4.195, 13.912, 25.244)),
    (631138, (6.188, 10.136, 24.392)),
    (768348, (0.042, 10.964, 21.221)),
    (287774, (5.395, 12.874, 21.478)),
    (839149, (6.400, 14.096, 27.236)),
    (700409, (8.465, 15.616, 24.246)),
    (74977, (9.329, 12.896, 23.487)),
    (269635, (0.473, 16.571, 25.405)),
    (523913, (2.031, 16.856, 21.935)),
    (561497, (6.162, 16.005, 23.925)),
    (867157, (5.440, 12.014, 23.112)),
    (725462, (6.124, 12.649, 22.810)),
    (253317, (8.485, 11.064, 29.272)),
    (147736, (7.944, 13.570, 27.802)),
    (453698, (9.370, 18.995, 22.578)),
    (162613, (4.936, 14.325, 23.167)),
    (13910, (4.475, 11.894, 22.910)),
    (572714, (9.354, 12.494, 26.681)),
    (456959, (8.569, 18.936, 26.280)),
    (9911, (9.455, 18.962, 27.586)),
    (83715, (7.993, 18.734, 23.066)),
    (223656, (0.431, 19.916, 28.923)),
    (502722, (2.446, 10.537, 24.294)),
    (845153, (1.461, 11.776, 29.369)),
    (658631, (8.917, 13.068, 28.304)),
    (283036, (6.652, 16.004, 20.035)),
    (186541, (0.163, 10.196, 28.183)),
    (772271, (9.924, 11.649, 24.128)),
    (658607, (1.347, 13.780, 21.301)),
    (801680, (9.887, 16.412, 26.250)),
    (435854, (3.409, 10.464, 22.281)),
    (954177, (8.459, 19.525, 29.687)),
    (150733, (6.534, 15.871, 26.110)),
    (176884, (7.691, 11.177, 25.238)),
    (375469, (2.960, 15.018, 22.275)),
    (464447, (9.751, 19.676, 20.248)),
    (426410, (8.722, 16.527, 22.109)),
    (167206, (0.958, 11.082, 28.977)),
    (115795, (6.169, 13.516, 22.310)),
    (804242, (0.432, 14.100, 20.117)),
    (858687, (8.525, 17.973, 23.663)),
    (15111, (3.905, 17.986, 22.572)),
    (927396, (8.602, 11.405, 26.052)),
    (966381, (4.229, 10.006, 27.664)),
    (541794, (7.255, 15.135, 25.504)),
    (816727, (7.115, 19.507, 23.886)),
    (217615, (2.436, 19.909, 29.698)),
    (943477, (0.981, 10.992, 26.124)),
    (921635, (6.727, 14.275, 23.709)),
    (533848, (6.752, 11.615, 21.696)),
    (344073, (2.996, 16.933, 21.539)),
    (432603, (5.318, 15.143, 20.301)),
    (319876, (4.266, 17.228, 21.456)),
    (590770, (9.723, 10.296, 23.065)),
    (937426, (2.242, 18.357, 23.951)),
    (739139, (9.250, 11.536, 25.998)),
    (459080, (4.488, 15.626, 21.138)),
    (534647, (2.113, 10.234, 26.209)),
    (816356, (7.971, 14.050, 24.423)),
    (683726, (8.090, 15.881, 24.257)),
    (17145, (1.100, 16.582, 28.126)),
    (960792, (6.741, 19.744, 25.252)),
    (268706, (2.746, 15.750, 21.399)),
    (217128, (8.808, 12.552, 26.074)),
    (537159, (8.229, 19.841, 25.418)),
    (627047, (3.617, 18.888, 20.688)),
    (633033, (0.353, 19.691, 23.731)),
    (272828, (8.270, 18.973, 28.762)),
    (218618, (0.306, 13.145, 27.047)),
    (115808, (3.406, 13.634, 23.255)),
    (318315, (6.572, 19.418, 26.767)),
    (765130, (3.180, 12.603, 23.982)),
    (815990, (0.259, 17.275, 26.395)),
    (438922, (1.409, 19.537, 23.299)),
    (577162, (7.022, 13.113, 28.606)),
    (93604, (0.668, 16.806, 29.177)),
    (342700, (8.507, 17.376, 24.356)),
    (100359, (6.652, 14.443, 23.881)),
    (86751, (4.886, 15.236, 27.945)),
    (682418, (1.760, 13.315, 22.232)),
    (142312, (3.711, 10.640, 26.561)),
    (792040, (9.252, 15.543, 26.727)),
    (980215, (9.127, 14.145, 20.092)),
    (468862, (8.608, 17.055, 22.542)),
    (437685, (9.531, 10.027, 20.043)),
    (846812, (6.111, 14.285, 21.169)),
    (290035, (0.453, 16.062, 22.612)),
    (355828, (1.010, 14.949, 22.372)),
    (471502, (2.310, 11.394, 26.868)),
    (134946, (2.231, 13.087, 24.169)),
    (648294, (5.118, 15.924, 27.280)),
    (231744, (4.701, 17.157, 26.760)),
    (683979, (3.169, 14.973, 29.223)),
    (982603, (4.099, 12.156, 28.715)),
    (345458, (1.640, 16.786, 23.682)),
    (551832, (8.220, 11.552, 27.601)),
    (273228, (3.524, 11.143, 28.451)),
    (866166, (9.566, 19.674, 23.931)),
    (225792, (7.790, 18.344, 28.382)),
    (881484, (7.086, 16.083, 29.913)),
    (349534, (2.604, 13.598, 28.779)),
    (542921, (1.218, 16.949, 26.655)),
    (872005, (9.922, 13.289, 26.848)),
    (489147, (3.561, 16.245, 24.883)),
    (957107, (2.074, 13.922, 29.284)),
    (421691, (6.012, 19.732, 22.808)),
    (757965, (9.784, 10.782, 27.653)),
    (443491, (2.986, 14.094, 21.775)),
    (676982, (0.325, 16.664, 28.299)),
    (828843, (9.454, 18.838, 22.925)),
    (91140, (6.822, 19.601, 28.374)),
    (3304, (1.547, 18.125, 20.712)),
    (249970, (2.847, 18.927, 21.046)),
    (940835, (7.031, 17.096, 23.075)),
    (203869, (9.023, 16.227, 23.066)),
    (441369, (8.230, 12.033, 21.167)),
    (368588, (5.902, 10.813, 29.858)),
    (265371, (0.450, 13.672, 29.584)),
    (942935, (8.032, 12.742, 28.857)),
    (928478, (8.201, 17.745, 20.921)),
    (587851, (9.603, 19.732, 29.377)),
    (92923, (6.924, 16.168, 29.268)),
    (912125, (5.037, 17.654, 23.285)),
    (465166, (2.375, 19.023, 22.890)),
    (677212, (2.275, 18.002, 26.726)),
    (769303, (6.529, 18.616, 20.849)),
    (457281, (3.523, 12.571, 23.979)),
    (365256, (4.304, 19.228, 22.685)),
    (750966, (4.650, 17.080, 21.890)),
    (833252, (7.597, 17.482, 20.071)),
    (211214, (0.568, 14.338, 27.600)),
    (384889, (5.739, 10.899, 21.410)),
    (64811, (4.265, 11.306, 26.921)),
    (537619, (1.045, 13.045, 27.310)),
    (919698, (5.420, 12.224, 22.698)),
    (628458, (6.095, 17.302, 20.290)),
    (412711, (8.298, 10.378, 25.160)),
    (585681, (2.988, 18.526, 23.671)),
    (627914, (0.978, 13.028, 23.775)),
    (891951, (6.037, 18.741, 25.513)),
    (727523, (1.808, 13.036, 27.202)),
    (103487, (4.368, 13.123, 25.976)),
    (161089, (8.245, 18.182, 25.369)),
    (498978, (7.774, 10.239, 26.719)),
    (768651, (9.411, 16.718, 20.403)),
    (918408, (5.226, 15.247, 29.560)),
    (215555, (4.196, 10.353, 29.856)),
    (545072, (2.487, 13.682, 20.545)),
    (258763, (2.041, 12.601, 26.331)),
    (856136, (6.018, 16.673, 24.462)),
    (859129, (5.441, 16.230, 25.174)),
    (164688, (5.483, 14.834, 24.417)),
    (361179, (0.794, 14.670, 27.405)),
    (279456, (8.529, 16.575, 28.562)),
    (974392, (6.207, 11.901, 22.627)),
    (99144, (9.599, 11.213, 28.532)),
    (975742, (8.914, 14.874, 27.634)),
    (435347, (2.899, 14.913, 26.904)),
    (392446, (5.788, 12.047, 22.790)),
    (361430, (4.796, 11.738, 26.943)),
    (741133, (5.757, 15.651, 27.495)),
    (599821, (7.140, 18.885, 25.718)),
    (666437, (8.667, 17.869, 28.031)),
    (239738, (0.652, 14.744, 20.589)),
    (283782, (2.935, 18.017, 21.621)),
    (485148, (6.335, 14.735, 29.599)),
    (47835, (0.926, 10.508, 24.435)),
    (932241, (1.835, 11.038, 20.257)),
    (470292, (1.126, 10.304, 22.738)),
    (673427, (3.809, 17.016, 26.047)),
    (600605, (3.542, 19.343, 29.541)),
    (125298, (9.476, 18.835, 20.682)),
    (455098, (1.907, 11.916, 25.250)),
    (401599, (2.163, 14.792, 25.715)),
    (953062, (7.253, 11.288, 24.207)),
    (166463, (8.083, 15.481, 26.682)),
    (263086, (6.566, 12.669, 21.194)),
    (664092, (0.620, 18.882, 23.079)),
    (853054, (1.642, 10.909, 21.603)),
    (108795, (3.774, 12.420, 28.605)),
    (4469, (0.191, 18.279, 28.551)),
    (295916, (0.285, 18.360, 20.630)),
    (698760, (3.917, 19.612, 24.078)),
    (980586, (8.680, 15.061, 20.763)),
    (821385, (2.663, 18.423, 24.078)),
    (545107, (6.050, 10.681, 27.391)),
    (179698, (3.174, 15.999, 23.843)),
    (802905, (2.100, 15.350, 24.215)),
    (587263, (0.655, 12.189, 27.734)),
    (191066, (0.813, 15.135, 20.449)),
    (979868, (4.626, 12.047, 28.914)),
    (715347, (7.382, 11.536, 26.532)),
    (186135, (7.684, 19.903, 20.710)),
    (446273, (5.307, 14.866, 27.839)),
    (484992, (6.258, 14.757, 26.501)),
    (592718, (2.740, 14.469, 24.230)),
    (272568, (4.499, 12.532, 23.131)),
    (554630, (9.813, 18.972, 21.928)),
    (287969, (4.555, 14.457, 24.792)),
    (554030, (4.519, 15.946, 23.656)),
    (772738, (5.173, 10.165, 26.058)),
    (616956, (0.296, 19.012, 23.325)),
    (843640, (4.580, 15.347, 27.213)),
    (749639, (5.818, 18.999, 25.288)),
    (314495, (6.432, 17.027, 26.855)),
    (338305, (2.790, 15.510, 27.136)),
    (808917, (3.939, 17.643, 23.070)),
    (1271, (3.805, 19.990, 23.487)),
    (402642, (3.640, 11.358, 26.413)),
    (698412, (6.543, 16.943, 25.947)),
    (683659, (0.679, 17.692, 29.072)),
    (471099, (6.134, 16.224, 26.121)),
    (120495, (4.442, 15.515, 29.326)),
    (384407, (0.601, 10.720, 24.765)),
    (522113, (0.424, 10.305, 22.909)),
    (271608, (9.178, 18.048, 24.836)),
    (968981, (1.984, 19.395, 28.328)),
    (885508, (3.187, 13.779, 27.369)),
    (109235, (7.465, 12.563, 21.198)),
    (844540, (5.438, 15.088, 28.068)),
    (458448, (4.575, 14.572, 29.714)),
    (215719, (2.046, 12.300, 29.553)),
    (457359, (4.728, 10.188, 24.320)),
    (613874, (3.263, 16.710, 20.310)),
    (235703, (5.109, 14.804, 22.453)),
    (512421, (6.534, 17.610, 25.930)),
    (225739, (3.335, 14.670, 22.806)),
    (282854, (9.172, 16.546, 23.900)),
    (105661, (3.268, 15.380, 21.522)),
    (469610, (0.796, 19.328, 26.230)),
    (50742, (8.988, 18.029, 26.611)),
    (469175, (9.542, 19.737, 23.027)),
    (741099, (4.524, 13.144, 24.841)),
    (992686, (1.422, 10.049, 26.321)),
    (60131, (9.429, 12.598, 21.393)),
    (472162, (3.615, 18.262, 24.804)),
    (338078, (0.920, 13.687, 20.890)),
    (42200, (8.910, 12.761, 26.693)),
    (469836, (3.948, 17.976, 22.993)),
    (278331, (0.198, 14.686, 22.682)),
    (62922, (8.438, 19.164, 20.295)),
    (538349, (7.006, 18.421, 21.531)),
    (749736, (2.523, 10.776, 21.138)),
    (474104, (2.257, 16.927, 20.735)),
    (557318, (6.351, 12.338, 28.277)),
    (297594, (6.231, 15.790, 24.476)),
    (491257, (6.458, 13.822, 28.449)),
    (126346, (6.782, 19.033, 21.125)),
    (850639, (3.352, 13.985, 28.956)),
    (154463, (1.635, 18.769, 24.642)),
    (450757, (6.866, 17.445, 27.069)),
    (637015, (4.871, 17.261, 23.939)),
    (654001, (3.631, 11.172, 26.481)),
    (817001, (3.710, 11.400, 27.078)),
    (817556, (5.119, 13.221, 29.392)),
    (555965, (7.030, 10.935, 28.055)),
    (222898, (8.739, 10.639, 22.088)),
    (259745, (5.269, 14.836, 27.692)),
    (425623, (6.222, 17.696, 27.288)),
    (973481, (4.293, 18.263, 27.773)),
    (675593, (2.781, 11.158, 21.386)),
    (248988, (1.986, 16.522, 22.752)),
    (963282, (3.409, 13.449, 29.656)),
    (731114, (3.686, 13.604, 29.870)),
    (619425, (5.994, 12.142, 26.729)),
    (320795, (0.931, 17.515, 28.140)),
    (174840, (9.445, 16.168, 29.582)),
    (972671, (1.400, 12.512, 27.207)),
    (220829, (6.240, 14.478, 24.283)),
    (107903, (5.337, 12.616, 20.101)),
    (133398, (4.220, 12.889, 26.522)),
    (352853, (6.181, 18.374, 23.376)),
    (159578, (3.462, 15.399, 23.654)),
    (56541, (4.511, 14.488, 20.571)),
    (650793, (0.808, 10.951, 29.732)),
    (450059, (4.525, 14.061, 21.367)),
    (856091, (0.436, 12.108, 27.482)),
    (917786, (1.029, 19.311, 25.385)),
    (841325, (5.017, 13.105, 24.124)),
    (311868, (1.569, 19.579, 26.397)),
    (806651, (6.253, 16.724, 29.794)),
    (663670, (1.491, 15.126, 24.736)),
    (898525, (6.665, 18.020, 20.854)),
    (56203, (8.699, 11.159, 22.602)),
    (488492, (4.419, 11.044, 23.754)),
    (739208, (3.742, 16.143, 22.014)),
    (753494, (3.682, 14.261, 26.240)),
    (647516, (9.947, 18.650, 23.205)),
    (963342, (0.614, 16.527, 23.423)),
    (216086, (8.339, 11.782, 26.933)),
    (371869, (5.093, 12.522, 23.534)),
    (614682, (5.112, 17.182, 22.881)),
    (691015, (6.087, 13.033, 27.144)),
    (72787, (3.910, 11.736, 21.567)),
    (907284, (7.053, 12.624, 27.569)),
    (542125, (4.380, 10.549, 25.356)),
    (432808, (9.525, 18.362, 26.173)),
    (950271, (8.747, 14.856, 21.729)),
    (382213, (9.889, 18.668, 22.604)),
    (215322, (0.685, 14.890, 29.683)),
    (472524, (0.051, 13.046, 27.873)),
    (625888, (3.036, 18.842, 25.359)),
    (41385, (6.246, 16.436, 22.281)),
    (235220, (3.620, 14.408, 21.894)),
    (65659, (9.250, 10.778, 23.024)),
    (361266, (9.933, 15.105, 27.840)),
    (810793, (5.049, 17.713, 27.217)),
    (807342, (2.754, 19.672, 25.562)),
    (574372, (9.105, 11.697, 25.211)),
    (761808, (9.709, 19.463, 26.498)),
    (721033, (2.278, 17.796, 22.671)),
    (934363, (7.518, 16.856, 22.792)),
    (439455, (9.752, 10.031, 22.720)),
    (652515, (1.910, 17.267, 29.443)),
    (401904, (2.414, 14.984, 27.783)),
    (938181, (4.412, 15.591, 29.970)),
    (727608, (6.349, 12.301, 24.149)),
    (199837, (9.474, 13.009, 29.446)),
    (393857, (9.428, 11.866, 27.341)),
    (319876, (9.037, 10.784, 21.341)),
    (138462, (2.167, 12.955, 23.890)),
    (399377, (1.369, 10.787, 27.306)),
    (205486, (1.126, 11.080, 25.544)),
    (403822, (1.018, 14.991, 27.159)),
    (873125, (2.020, 14.815, 22.575)),
    (547771, (7.717, 11.508, 20.551)),
    (679872, (4.114, 14.979, 23.047)),
    (979781, (9.602, 13.958, 25.151)),
    (831960, (0.814, 15.472, 28.904)),
    (496488, (2.214, 11.725, 23.782)),
    (418070, (1.613, 15.431, 23.979)),
    (648218, (8.015, 14.163, 24.239)),
    (900901, (2.290, 17.815, 25.447)),
    (81977, (3.137, 10.736, 23.632)),
    (319318, (0.644, 19.092, 22.529)),
    (513254, (7.844, 15.884, 20.929)),
    (257670, (6.193, 10.535, 26.413)),
    (640962, (0.088, 13.833, 27.396)),
    (976656, (1.712, 17.115, 28.900)),
    (766565, (1.550, 18.753, 23.330)),
    (720950, (4.554, 10.758, 25.115)),
    (309042, (3.877, 18.345, 26.734)),
    (109996, (8.367, 12.298, 23.518)),
    (379971, (1.472, 15.158, 24.409)),
    (556695, (5.009, 17.971, 23.075)),
    (194946, (8.387, 16.039, 28.611)),
    (35516, (8.200, 12.970, 28.793)),
    (573999, (9.728, 15.203, 28.580)),
    (300791, (0.593, 19.082, 24.121)),
    (753986, (2.191, 11.946, 27.958)),
    (601521, (6.059, 15.963, 20.887)),
    (358951, (6.591, 17.238, 27.005)),
    (518345, (8.081, 12.999, 25.770)),
    (777932, (4.725, 16.255, 21.863)),
    (727198, (5.119, 10.041, 29.247)),
    (159517, (1.743, 13.390, 21.497)),
    (899933, (6.484, 18.326, 25.656)),
    (428166, (6.645, 16.633, 21.579)),
    (600637, (7.523, 14.446, 21.027)),
    (407417, (1.764, 15.808, 22.275)),
    (733238, (0.226, 15.665, 21.490)),
    (493571, (3.631, 12.638, 23.326)),
    (122929, (3.972, 16.088, 28.490)),
    (699505, (8.113, 17.018, 28.374)),
    (157843, (8.899, 15.520, 23.130)),
    (13562, (5.610, 14.387, 23.437)),
    (743611, (1.407, 16.634, 21.182)),
    (540865, (4.820, 13.046, 22.435)),
    (90043, (7.143, 13.263, 24.491)),
    (837738, (4.478, 18.530, 23.602)),
    (318501, (6.707, 12.820, 20.289)),
    (344748, (7.962, 18.745, 25.931)),
    (585173, (2.488, 19.845, 20.662)),
    (530785, (9.445, 13.235, 28.193)),
    (434127, (2.719, 10.720, 20.018)),
    (844268, (2.491, 10.812, 26.478)),
    (440262, (7.400, 13.689, 26.524)),
    (322768, (3.559, 11.843, 22.643)),
    (384689, (2.342, 12.135, 26.232)),
    (803628, (6.441, 15.758, 25.959)),
    (671453, (6.553, 16.241, 27.660)),
    (297289, (6.952, 13.237, 22.985)),
    (237899, (8.049, 13.839, 24.733)),
    (658744, (2.038, 10.045, 27.211)),
    (193633, (8.574, 12.604, 24.390)),
    (392447, (2.561, 16.187, 20.576)),
    (722619, (5.366, 12.426, 28.694)),
    (206211, (3.784, 10.005, 23.471)),
    (525733, (2.517, 19.720, 20.828)),
    (97138, (8.213, 13.677, 22.373)),
    (879244, (9.164, 13.376, 29.890)),
    (713816, (2.917, 15.727, 21.418)),
    (367627, (8.509, 12.488, 29.922)),
    (934159, (5.462, 14.650, 24.014)),
    (885257, (4.372, 12.697, 29.001)),
    (224878, (5.591, 19.867, 20.992)),
    (770053, (1.280, 14.107, 28.552)),
    (544906, (7.618, 17.987, 29.510)),
    (416804, (6.780, 12.763, 22.574)),
    (497896, (2.877, 10.483, 25.308)),
    (386699, (5.543, 15.020, 21.211)),
    (535398, (5.758, 15.155, 26.545)),
    (44417, (6.041, 17.057, 21.692)),
    (621882, (0.915, 15.701, 28.187)),
    (813537, (2.510, 19.541, 29.389)),
    (360209, (2.594, 16.538, 23.777)),
    (746108, (4.012, 11.984, 28.014)),
    (786490, (4.963, 15.689, 28.281)),
    (979360, (7.709, 11.549, 24.491)),
    (955548, (4.140, 16.038, 23.136)),
    (39421, (8.214, 18.339, 28.510)),
    (146143, (6.770, 15.223, 21.211)),
    (825681, (9.320, 14.084, 24.221)),
    (811992, (8.437, 12.983, 24.230)),
    (595216, (7.450, 17.509, 29.865)),
    (447903, (8.448, 17.044, 24.649)),
    (576977, (1.656, 16.684, 28.410)),
    (593780, (2.232, 15.001, 21.259)),
    (39404, (0.598, 16.154, 22.340)),
    (139501, (0.226, 18.406, 27.242)),
    (783547, (3.355, 19.455, 29.117)),
    (383141, (3.278, 10.825, 20.132)),
    (971003, (8.253, 19.773, 20.542)),
    (30205, (3.394, 16.009, 21.836)),
    (845325, (6.202, 10.741, 23.942)),
    (561688, (5.835, 11.317, 21.196)),
    (440831, (4.726, 10.154, 26.959)),
    (940510, (9.987, 12.395, 29.906)),
    (499927, (0.843, 12.634, 22.057)),
    (539789, (6.122, 11.806, 21.259)),
    (983669, (2.453, 19.480, 25.452)),
    (713084, (7.032, 18.079, 23.969)),
    (777740, (7.980, 15.515, 25.230)),
    (818423, (1.395, 15.964, 24.892)),
    (581165, (2.800, 17.895, 24.768)),
    (660648, (6.142, 12.540, 25.486)),
    (445232, (5.155, 11.746, 20.879)),
    (242785, (9.947, 10.351, 24.962)),
    (666906, (6.418, 12.157, 27.068)),
    (979738, (2.268, 10.681, 20.044)),
    (281636, (0.942, 14.092, 25.099)),
    (308633, (2.505, 17.103, 24.132)),
    (255177, (2.495, 18.055, 20.662)),
    (713414, (0.976, 15.826, 24.040)),
    (604792, (8.534, 14.526, 28.733)),
    (144539, (4.272, 18.703, 27.071)),
    (9022, (0.688, 12.549, 23.381)),
    (192342, (4.463, 10.281, 26.824)),
    (425372, (3.934, 19.101, 23.131)),
    (847801, (9.675, 11.643, 25.157)),
    (811636, (8.952, 10.684, 21.088)),
    (897435, (4.794, 11.560, 25.199)),
    (128448, (1.958, 15.066, 25.392)),
    (224449, (2.780, 16.365, 27.728)),
    (825002, (2.875, 18.663, 24.418)),
    (525114, (8.365, 15.033, 25.819)),
    (605514, (4.488, 12.216, 26.024)),
    (217764, (2.043, 14.036, 29.771)),
    (898015, (9.896, 10.384, 20.872)),
    (258608, (4.244, 13.413, 24.077)),
    (437116, (3.556, 19.766, 23.326)),
    (901290, (0.119, 15.545, 21.397)),
    (540324, (9.650, 15.594, 24.350)),
    (888105, (0.038, 11.626, 29.084)),
    (62185, (4.781, 13.660, 23.703)),
    (582188, (3.448, 14.702, 28.665)),
    (917113, (8.365, 18.656, 27.956)),
    (837928, (1.230, 18.391, 20.712)),
    (851592, (2.738, 12.006, 26.218)),
    (871101, (0.731, 12.467, 23.885)),
    (395703, (0.721, 10.819, 27.274)),
    (95710, (5.946, 19.388, 23.609)),
    (880115, (8.690, 13.663, 28.842)),
    (256399, (1.573, 11.412, 29.260)),
    (979330, (1.208, 10.342, 22.712)),
    (350640, (3.782, 11.447, 22.362)),
    (295126, (1.011, 11.384, 24.087)),
    (179778, (8.368, 12.840, 26.722)),
    (920750, (7.451, 13.859, 20.199)),
    (982215, (5.109, 16.689, 29.320)),
    (309764, (9.685, 10.081, 24.052)),
    (340168, (7.931, 14.109, 23.429)),
    (424879, (2.884, 17.254, 28.937)),
    (639818, (3.020, 13.228, 20.960)),
    (198908, (1.484, 16.415, 20.701)),
    (338479, (2.711, 14.068, 22.241)),
    (408233, (3.928, 18.671, 27.954)),
    (275179, (5.612, 14.423, 24.951)),
    (142436, (9.691, 12.930, 20.978)),
    (431846, (1.179, 12.285, 24.920)),
    (254703, (5.997, 12.229, 20.177)),
    (475462, (0.775, 18.241, 24.942)),
    (844930, (9.084, 17.063, 28.500)),
    (35837, (4.073, 19.036, 29.193)),
    (620424, (7.659, 17.569, 20.991)),
    (693351, (1.079, 12.700, 23.920)),
    (803714, (9.230, 12.799, 27.798)),
    (699678, (9.176, 12.098, 28.241)),
    (2653, (7.549, 12.491, 25.273)),
    (79952, (0.718, 13.011, 21.113)),
    (487199, (1.980, 15.313, 29.525)),
    (829851, (5.141, 15.330, 29.550)),
    (961378, (5.181, 16.607, 25.608)),
    (969676, (1.507, 17.373, 25.986)),
    (605916, (9.515, 15.982, 28.968)),
    (252057, (1.294, 18.214, 21.080)),
    (431850, (4.775, 19.938, 23.802)),
    (519908, (8.658, 18.657, 22.448)),
    (794685, (8.826, 14.574, 21.238)),
    (838593, (9.690, 10.971, 26.832)),
    (133395, (9.544, 16.581, 25.235)),
    (735542, (3.624, 16.673, 22.955)),
    (675933, (8.161, 11.061, 29.420)),
    (663305, (8.671, 16.803, 29.510)),
    (920497, (9.474, 13.516, 21.537)),
    (956021, (3.761, 10.041, 20.196)),
    (90642, (5.575, 19.196, 27.563)),
    (510209, (0.539, 14.070, 28.416)),
    (991391, (9.113, 19.769, 21.647)),
    (32143, (9.242, 18.835, 26.993)),
    (787448, (7.697, 11.117, 25.425)),
    (372654, (8.624, 11.868, 22.857)),
    (590942, (0.639, 13.770, 28.467)),
    (40632, (2.809, 14.375, 28.489)),
    (282804, (5.290, 18.818, 26.050)),
    (601503, (6.685, 19.286, 20.342)),
    (700350, (5.328, 17.609, 20.772)),
    (672077, (8.752, 17.013, 22.802)),
    (181692, (8.883, 15.634, 28.344)),
    (496230, (4.835, 19.993, 22.172)),
    (248641, (7.072, 13.205, 23.234)),
    (756356, (1.471, 15.932, 27.893)),
    (886408, (8.995, 11.458, 21.888)),
    (10728, (3.803, 12.921, 25.934)),
    (545741, (3.683, 17.564, 22.599)),
    (138735, (4.453, 11.232, 29.240)),
    (312326, (1.505, 10.185, 20.464)),
    (18687, (7.275, 13.402, 20.308)),
    (743055, (2.413, 18.197, 27.855)),
    (52974, (8.728, 18.338, 24.484)),
    (372983, (2.794, 12.103, 29.031)),
    (652082, (8.720, 10.058, 21.312)),
    (479977, (0.269, 10.719, 27.224)),
    (873255, (5.975, 15.033, 22.788)),
    (779898, (4.330, 14.530, 23.477)),
    (46644, (9.741, 19.309, 21.580)),
    (566197, (3.529, 14.741, 25.980)),
    (40719, (7.449, 18.895, 28.069)),
    (113792, (9.994, 19.826, 28.364)),
    (232864, (7.175, 11.125, 29.159)),
    (320068, (9.775, 12.673, 20.617)),
    (910833, (2.045, 10.115, 28.280)),
    (518948, (9.108, 10.943, 21.516)),
    (952542, (8.695, 18.191, 20.773)),
    (161893, (4.352, 10.549, 24.205)),
    (636749, (1.797, 18.552, 29.207)),
    (81588, (7.598, 12.170, 20.085)),
    (776502, (6.216, 17.472, 25.798)),
    (27378, (3.377, 15.947, 28.288)),
    (911408, (7.030, 13.476, 25.869)),
    (568754, (4.120, 16.430, 24.802)),
    (797862, (5.185, 17.463, 21.367)),
    (386682, (0.712, 16.188, 26.429)),
    (667599, (8.567, 13.353, 21.791)),
    (847840, (8.819, 18.123, 28.954)),
    (906511, (6.719, 13.994, 28.149)),
    (316119, (5.448, 10.469, 22.075)),
    (440537, (1.460, 13.784, 25.297)),
    (95570, (9.692, 15.151, 23.727)),
    (194321, (6.307, 12.189, 26.861)),
    (147216, (5.493, 18.173, 26.829)),
    (803216, (2.854, 11.553, 29.234)),
    (425790, (8.110, 18.927, 25.648)),
    (795996, (2.315, 11.893, 25.686)),
    (803868, (9.309, 11.519, 22.844)),
    (910134, (4.891, 16.629, 22.489)),
    (11230, (2.535, 18.569, 22.793)),
    (398921, (7.173, 18.066, 28.635)),
    (706946, (1.611, 10.648, 24.468)),
    (267076, (3.239, 16.925, 26.360)),
    (790370, (9.182, 11.778, 24.737)),
    (951131, (4.948, 18.958, 24.277)),
    (296735, (0.190, 18.733, 22.806)),
    (206075, (8.262, 18.303, 24.611)),
    (34670, (2.100, 15.595, 29.799)),
    (581138, (3.713, 10.805, 26.595)),
    (280304, (3.148, 15.736, 29.945)),
    (235055, (8.022, 19.026, 27.125)),
    (35953, (6.860, 11.919, 21.475)),
    (757237, (4.031, 19.048, 22.089)),
    (481556, (1.923, 17.547, 25.257)),
    (864815, (6.189, 11.093, 27.948)),
    (129614, (8.651, 11.252, 27.112)),
    (516389, (7.616, 11.243, 20.534)),
    (696341, (8.779, 19.835, 21.971)),
    (995054, (0.916, 13.537, 29.288)),
    (767616, (0.085, 19.814, 27.909)),
    (377659, (9.252, 16.519, 23.572)),
    (900410, (0.963, 19.205, 23.342)),
    (876639, (6.819, 18.634, 27.427)),
    (193990, (9.507, 13.629, 25.377)),
    (346206, (4.108, 12.333, 24.735)),
    (345883, (2.750, 13.630, 23.447)),
    (381195, (7.295, 11.037, 26.920)),
    (586199, (6.111, 14.585, 24.976)),
    (667983, (5.663, 15.172, 24.497)),
    (544533, (0.765, 10.802, 27.990)),
    (791005, (9.226, 19.712, 25.246)),
    (648007, (1.330, 11.855, 29.880)),
    (550624, (7.841, 13.929, 29.878)),
    (975853, (2.093, 12.989, 29.609)),
    (840221, (7.335, 11.652, 22.061)),
    (444934, (1.739, 15.447, 29.716)),
    (6822, (3.736, 14.631, 27.890)),
    (409958, (4.109, 15.759, 25.585)),
    (940654, (0.649, 12.536, 26.026)),
    (802453, (0.485, 17.297, 28.654)),
    (526428, (3.500, 18.162, 29.897)),
    (612939, (4.817, 18.266, 28.145)),
    (519507, (0.777, 13.577, 26.994)),
    (419477, (5.107, 18.572, 24.466)),
    (141826, (6.794, 11.041, 23.058)),
    (824671, (8.418, 18.266, 29.832)),
    (629929, (1.259, 19.558, 21.433)),
    (759505, (4.122, 15.411, 22.760)),
    (887955, (0.578, 15.409, 26.505)),
    (59626, (2.503, 12.332, 22.206)),
    (867878, (9.331, 19.005, 21.216)),
    (66461, (4.001, 16.944, 28.012)),
    (763867, (9.577, 10.046, 27.205)),
    (229549, (8.289, 15.774, 26.415)),
    (796607, (6.463, 14.249, 29.521)),
    (774957, (5.944, 10.018, 25.378)),
    (52096, (5.726, 13.455, 20.166)),
    (467205, (2.265, 11.644, 29.906)),
    (498128, (3.771, 14.397, 22.694)),
    (687144, (4.089, 12.376, 27.037)),
    (528857, (4.094, 17.221, 23.849)),
    (705924, (1.781, 14.858, 25.595)),
    (81285, (5.230, 18.152, 27.975)),
    (398790, (9.444, 17.716, 28.381)),
    (807617, (1.081, 17.253, 25.783)),
    (99281, (5.911, 17.976, 24.765)),
    (831862, (5.051, 18.835, 26.998)),
    (264950, (7.528, 10.061, 20.587)),
    (42019, (8.668, 15.155, 22.743)),
    (34419, (6.631, 19.130, 21.909)),
    (51505, (3.285, 19.997, 29.549)),
    (102273, (4.446, 11.808, 22.426)),
    (328086, (8.277, 16.382, 22.172)),
    (60193, (0.341, 12.369, 29.640)),
    (520574, (9.191, 10.380, 26.838)),
    (416963, (8.568, 15.042, 25.051)),
    (950588, (0.515, 17.082, 26.198)),
    (680978, (3.701, 15.030, 25.288)),
    (964350, (4.850, 10.533, 20.949)),
    (160775, (9.544, 17.555, 26.781)),
    (371001, (2.451, 13.337, 22.653)),
    (40210, (4.855, 17.109, 21.920)),
    (163306, (9.447, 10.546, 21.536)),
    (476836, (3.139, 10.523, 20.296)),
    (56392, (2.290, 14.792, 22.022)),
    (711538, (4.151, 17.756, 27.597)),
    (797081, (5.792, 10.288, 24.167)),
    (613809, (3.685, 19.134, 29.266)),
    (996163, (3.674, 19.423, 26.579)),
    (180787, (9.183, 15.878, 22.378)),
    (691220, (3.734, 12.197, 20.216)),
    (60588, (2.950, 17.270, 28.244)),
    (771374, (1.198, 18.805, 28.460)),
    (146164, (7.040, 19.110, 26.788)),
    (923478, (8.081, 18.679, 24.653)),
    (372777, (3.276, 10.591, 27.926)),
    (97301, (8.740, 11.796, 22.877)),
    (130688, (0.772, 18.282, 29.396)),
    (608621, (3.595, 19.786, 28.556)),
    (827834, (7.149, 18.251, 29.694)),
    (790091, (5.396, 17.494, 24.425)),
    (398838, (4.394, 14.388, 28.119)),
    (717877, (7.921, 13.606, 23.671)),
    (790663, (0.661, 13.301, 28.517)),
    (352810, (7.158, 12.226, 28.234)),
    (469270, (7.840, 10.860, 22.878)),
    (56412, (7.325, 16.876, 29.988)),
    (614162, (1.157, 10.391, 22.384)),
    (683747, (0.460, 19.345, 23.782)),
    (559486, (5.492, 14.684, 23.831)),
    (801740, (8.667, 11.450, 25.451)),
    (408463, (1.910, 17.895, 26.722)),
    (347130, (7.842, 14.823, 23.297)),
    (927808, (2.997, 15.506, 21.634)),
    (676941, (3.195, 11.183, 22.092)),
    (478162, (7.142, 10.969, 29.569)),
    (519815, (4.930, 16.018, 24.113)),
    (162211, (3.364, 13.956, 27.644)),
    (213049, (3.771, 17.468, 20.959)),
    (308016, (7.736, 19.701, 27.444)),
    (919275, (8.251, 16.833, 21.492)),
    (380796, (4.222, 14.333, 28.998)),
    (125282, (7.849, 10.620, 23.654)),
    (875405, (5.574, 15.753, 20.476)),
    (605366, (1.003, 17.554, 23.774)),
    (816386, (9.034, 18.845, 29.061)),
    (270560, (6.137, 18.243, 20.127)),
    (790037, (1.701, 10.019, 23.351)),
    (40033, (1.894, 16.991, 26.798)),
    (336885, (1.422, 15.935, 24.720)),
    (575077, (4.408, 16.763, 20.718)),
    (6966, (5.899, 19.411, 22.478)),
    (958516, (8.101, 17.204, 24.072)),
    (261490, (7.651, 13.367, 26.807)),
    (422315, (4.375, 19.351, 29.661)),
    (973704, (6.359, 15.725, 21.691)),
    (240723, (1.522, 12.469, 28.936)),
    (748660, (7.047, 14.099, 28.577)),
    (570455, (0.284, 11.291, 22.620)),
    (603444, (3.328, 14.329, 20.822)),
    (126285, (0.458, 12.013, 25.890)),
    (35923, (7.408, 18.947, 22.310)),
    (637096, (0.927, 16.948, 23.541)),
    (104082, (3.396, 11.342, 21.582)),
    (424847, (3.279, 14.817, 26.147)),
    (556668, (5.518, 16.801, 25.980)),
    (596367, (3.796, 14.990, 28.806)),
    (449052, (8.684, 18.738, 27.075)),
    (316939, (8.272, 16.352, 25.463)),
    (562099, (7.473, 18.491, 26.958)),
    (711354, (2.805, 19.763, 20.123)),
    (253279, (1.379, 15.304, 23.716)),
    (632953, (7.342, 17.077, 20.554)),
    (593430, (6.999, 14.947, 22.195)),
    (114918, (7.280, 18.789, 26.002)),
    (798577, (9.701, 13.703, 24.731)),
    (314851, (5.732, 18.076, 23.123)),
    (386947, (4.083, 18.683, 24.903)),
    (332662, (7.308, 14.692, 23.514)),
    (989020, (2.644, 12.654, 29.454)),
    (702904, (4.553, 16.326, 28.980)),
    (305597, (3.709, 13.631, 24.930)),
    (640749, (6.800, 11.578, 28.282)),
    (179559, (6.509, 10.066, 27.799)),
    (245890, (6.371, 18.995, 26.530)),
    (890090, (2.549, 16.305, 23.635)),
    (389205, (7.965, 13.075, 25.798)),
    (456749, (8.379, 10.494, 25.239)),
    (840630, (5.476, 16.192, 25.611)),
    (178183, (9.405, 15.035, 23.078)),
    (820065, (1.679, 16.653, 20.147)),
    (227933, (6.426, 15.322, 20.039)),
    (629385, (3.392, 14.460, 21.079)),
    (479524, (7.648, 13.991, 25.670)),
    (748187, (7.089, 15.466, 21.640)),
    (504034, (0.005, 15.531, 20.032)),
    (683668, (9.327, 16.706, 24.142)),
    (776908, (5.008, 10.136, 28.469)),
    (717547, (1.606, 17.385, 25.704)),
    (376238, (7.740, 16.046, 28.293)),
    (68284, (6.350, 14.682, 28.488)),
    (577436, (1.257, 18.314, 23.070)),
    (530641, (3.842, 15.200, 26.495)),
    (133813, (4.787, 12.749, 24.762)),
    (431719, (9.757, 17.663, 28.050)),
    (509622, (8.383, 11.423, 29.179)),
    (956994, (5.955, 11.314, 20.725)),
    (330150, (9.551, 19.060, 23.689)),
    (90515, (7.052, 15.855, 26.015)),
    (74931, (3.851, 14.352, 25.352)),
    (818315, (9.202, 11.427, 22.767)),
    (401235, (0.789, 13.581, 24.345)),
    (734727, (0.105, 15.391, 28.728)),
    (308016, (4.374, 14.484, 27.549)),
    (192050, (1.668, 12.516, 27.084)),
    (498329, (0.085, 10.879, 29.649)),
    (168967, (0.545, 16.705, 23.354)),
    (54726, (1.316, 19.575, 26.442)),
    (166119, (8.225, 15.783, 26.265)),
    (399192, (9.438, 19.089, 24.993)),
    (486020, (4.397, 11.882, 29.601)),
    (977091, (8.136, 17.342, 28.145)),
    (988264, (5.262, 14.636, 22.596)),
    (171014, (2.921, 13.320, 21.736)),
    (450324, (8.547, 16.735, 23.621)),
    (966311, (6.608, 16.132, 24.091)),
    (482464, (4.453, 13.267, 21.487)),
    (8002, (8.270, 19.066, 24.150)),
    (887784, (5.836, 10.035, 29.098)),
    (950685, (4.825, 18.165, 29.059)),
    (127005, (3.027, 19.766, 24.013)),
    (304723, (6.949, 16.030, 22.334)),
    (75004, (7.925, 19.577, 21.979)),
    (755001, (4.000, 18.269, 21.011)),
    (667380, (5.723, 19.932, 24.787)),
    (789723, (7.084, 10.262, 23.356)),
    (206735, (3.306, 12.709, 26.829)),
    (409160, (5.087, 19.745, 26.199)),
    (375022, (2.081, 13.723, 23.211)),
    (903613, (4.332, 14.265, 26.900)),
    (629405, (6.934, 12.195, 24.129)),
    (872244, (9.149, 18.174, 28.502)),
    (893767, (7.998, 13.447, 24.139)),
    (821080, (7.229, 12.883, 29.999)),
    (365062, (5.136, 15.451, 20.519)),
    (20897, (3.719, 17.434, 20.909)),
    (107256, (5.270, 17.879, 24.729)),
    (170011, (4.021, 19.456, 26.999)),
    (877650, (1.158, 13.989, 25.362)),
    (551981, (9.099, 13.837, 24.506)),
    (432080, (6.013, 13.639, 20.409)),
    (2198, (8.060, 16.918, 29.612)),
    (222242, (3.812, 14.662, 24.285)),
    (365784, (0.002, 13.545, 29.530)),
    (300202, (8.923, 10.010, 26.668)),
    (629208, (5.777, 10.548, 26.389)),
    (488406, (6.748, 18.492, 26.482)),
    (535996, (1.808, 19.204, 29.749)),
    (638605, (6.699, 11.866, 28.552)),
    (210325, (4.669, 12.632, 25.335)),
    (996520, (3.537, 10.113, 27.730)),
    (520751, (9.006, 19.049, 29.588)),
    (481104, (7.289, 19.386, 26.516)),
    (887847, (7.241, 13.973, 29.234)),
    (253102, (8.346, 11.572, 28.019)),
    (891494, (8.528, 15.030, 27.272)),
    (168142, (8.611, 14.781, 28.468)),
    (767617, (3.391, 10.621, 29.098)),
    (523887, (0.353, 17.029, 24.933)),
    (671978, (9.286, 11.301, 27.970)),
    (264780, (6.229, 12.291, 24.784)),
    (251196, (1.204, 13.413, 27.515)),
    (446649, (6.233, 11.692, 24.353)),
    (755379, (7.704, 17.670, 28.908)),
    (536556, (2.524, 17.190, 28.507)),
    (565459, (9.823, 18.971, 22.743)),
    (274949, (9.524, 14.293, 29.779)),
    (387390, (3.716, 14.752, 22.530)),
    (485264, (1.316, 18.165, 26.364)),
    (468869, (7.418, 11.894, 27.237)),
    (75348, (3.481, 12.440, 23.102)),
    (328848, (1.118, 13.524, 29.124)),
    (782605, (0.991, 13.665, 24.972)),
    (626500, (5.875, 12.436, 20.067)),
    (885139, (5.508, 15.302, 28.168)),
    (730349, (7.321, 13.017, 23.780)),
    (420630, (7.531, 17.219, 26.730)),
    (218811, (6.537, 16.000, 23.555)),
    (666902, (4.724, 12.659, 27.755)),
    (202930, (1.081, 15.228, 20.653)),
    (674620, (8.840, 10.361, 24.967)),
    (395802, (4.447, 19.459, 29.830)),
    (519086, (7.048, 16.027, 24.229)),
    (433020, (5.422, 12.923, 20.524)),
    (352775, (5.319, 15.428, 20.274)),
    (442083, (6.999, 17.201, 25.289)),
    (560184, (8.250, 19.127, 28.295)),
    (876782, (8.610, 16.399, 23.213)),
    (903470, (7.506, 15.588, 26.182)),
    (182243, (9.135, 15.840, 26.119)),
    (741177, (4.847, 17.875, 27.735)),
    (848028, (4.672, 13.113, 27.412)),
    (770661, (9.654, 16.175, 20.955)),
    (595999, (0.139, 14.784, 28.639)),
    (489070, (6.147, 10.878, 20.459)),
    (937384, (3.897, 11.481, 23.978)),
    (489918, (2.402, 15.441, 29.472)),
    (451679, (2.362, 19.883, 28.416)),
    (45681, (3.386, 14.090, 20.495)),
    (868797, (7.596, 14.102, 20.796)),
    (683335, (8.126, 13.311, 22.746)),
    (903442, (8.040, 12.020, 23.587)),
    (210873, (0.651, 11.219, 26.873)),
    (478016, (2.115, 12.153, 28.213)),
    (416594, (5.290, 12.717, 22.280)),
    (133714, (3.257, 12.102, 29.974)),
    (46856, (0.210, 13.267, 23.095)),
    (242570, (2.867, 16.444, 29.917)),
    (372141, (4.388, 13.402, 21.060)),
    (219340, (0.628, 13.809, 28.138)),
    (435664, (2.575, 13.949, 22.260)),
    (24430, (0.463, 12.187, 28.471)),
    (802739, (7.959, 18.199, 24.335)),
    (815637, (6.617, 13.755, 26.595)),
    (476115, (7.676, 10.368, 24.781)),
    (321385, (0.539, 12.775, 28.704)),
    (999921, (4.817, 16.612, 24.709)),
    (10568, (9.685, 16.625, 29.795)),
    (549979, (6.777, 19.880, 27.098)),
    (184610, (9.804, 16.812, 22.445)),
    (705614, (4.633, 19.903, 21.461)),
    (168421, (6.185, 18.409, 25.138)),
    (543384, (5.858, 15.681, 29.307)),
    (97452, (9.001, 19.475, 24.188)),
    (659924, (1.199, 11.876, 24.889)),
    (433548, (5.898, 16.975, 20.168)),
    (554523, (4.468, 11.456, 27.770)),
    (727952, (9.048, 19.700, 24.446)),
    (853790, (7.669, 19.538, 20.722)),
    (776337, (0.779, 17.436, 24.651)),
    (51499, (5.849, 11.304, 26.190)),
    (139503, (6.375, 12.420, 24.570)),
    (46429, (4.038, 16.368, 22.529)),
    (667506, (0.807, 13.678, 27.005)),
    (294617, (8.847, 16.980, 27.063)),
    (871621, (9.992, 11.854, 29.360)),
    (444987, (9.581, 14.598, 28.589)),
    (900608, (7.362, 11.259, 26.894)),
    (190291, (2.389, 10.122, 27.118)),
    (409364, (7.548, 17.576, 22.857)),
    (361045, (6.315, 15.905, 21.671)),
    (4673, (4.763, 16.544, 22.414)),
    (939021, (2.374, 11.203, 22.496)),
    (490369, (2.538, 12.615, 26.566)),
    (157007, (8.533, 10.210, 24.646)),
    (884309, (2.634, 11.836, 27.423)),
    (15409, (0.569, 10.150, 27.889)),
    (961829, (6.030, 16.614, 25.428)),
    (839908, (2.550, 19.271, 21.821)),
    (908340, (1.048, 11.602, 20.205)),
    (9591, (1.920, 17.481, 27.524)),
    (134510, (7.084, 11.889, 25.774)),
    (915517, (8.923, 17.182, 28.481)),
    (389511, (5.284, 14.400, 24.739)),
    (608085, (9.937, 14.073, 24.380)),
    (992560, (4.529, 18.246, 26.070)),
    (934049, (7.377, 13.598, 22.536)),
    (75741, (4.750, 14.300, 29.785)),
    (681064, (6.768, 15.684, 25.066)),
    (653135, (4.496, 11.629, 28.977)),
    (642031, (7.771, 11.882, 20.545)),
    (830587, (5.151, 16.834, 24.318)),
    (67027, (0.617, 11.801, 23.248)),
    (420669, (5.436, 11.404, 20.668)),
    (86683, (1.207, 11.850, 22.676)),
    (962492, (6.425, 18.538, 24.054)),
    (110630, (9.650, 18.209, 29.143)),
    (985788, (2.405, 17.283, 23.212)),
    (188160, (5.555, 15.272, 26.613)),
    (791528, (0.418, 15.401, 27.567)),
    (268808, (7.411, 11.151, 24.504)),
    (921529, (3.182, 15.487, 27.329)),
    (541991, (2.096, 11.429, 20.045)),
    (312417, (1.261, 17.787, 29.842)),
    (183294, (5.476, 16.659, 26.422)),
    (863051, (6.843, 10.675, 25.308)),
    (907760, (4.349, 18.663, 20.325)),
    (762740, (6.327, 12.585, 29.896)),
    (119416, (3.988, 11.318, 28.035)),
    (435334, (9.017, 19.357, 26.492)),
    (189212, (2.914, 14.062, 27.535)),
    (163584, (9.478, 11.852, 22.994)),
    (667756, (5.566, 18.041, 27.157)),
    (833147, (9.486, 11.480, 27.553)),
    (501238, (1.216, 13.357, 22.556)),
    (520595, (8.830, 14.541, 20.217)),
    (559214, (4.714, 17.985, 28.522)),
    (680556, (5.172, 11.281, 21.170)),
    (222211, (9.978, 10.336, 20.974)),
    (683730, (7.045, 10.508, 29.258)),
    (812442, (8.352, 12.514, 21.889)),
    (233732, (8.755, 18.747, 28.091)),
    (418561, (1.239, 13.567, 28.186)),
    (129366, (6.910, 15.644, 28.240)),
    (551746, (7.385, 15.458, 21.898)),
    (764173, (6.195, 19.979, 22.012)),
    (450867, (1.312, 13.044, 29.298)),
    (523974, (6.312, 17.506, 24.736)),
    (344791, (9.195, 14.281, 22.145)),
    (661786, (7.314, 14.257, 29.688)),
    (493946, (1.503, 17.752, 28.401)),
    (41273, (5.315, 13.889, 21.657)),
    (231690, (0.843, 16.900, 22.462)),
    (236146, (8.316, 10.090, 28.866)),
    (586174, (4.328, 14.842, 21.352)),
    (656870, (1.529, 13.304, 23.130)),
    (927726, (3.712, 12.261, 21.060)),
    (119700, (3.617, 15.746, 29.411)),
    (939384, (5.080, 14.998, 20.553)),
    (578257, (0.996, 14.164, 27.223)),
    (713916, (3.438, 19.552, 25.289)),
    (424060, (8.905, 12.378, 29.706)),
    (273203, (8.755, 17.562, 23.268)),
    (523497, (2.934, 19.040, 22.706)),
    (641176, (5.707, 19.782, 28.647)),
    (720481, (4.505, 19.209, 29.922)),
    (871301, (5.721, 16.594, 27.015)),
    (182137, (9.785, 13.347, 27.172)),
    (150146, (8.735, 14.128, 23.553)),
    (686270, (8.646, 18.845, 26.630)),
    (255272, (9.705, 12.782, 27.189)),
    (305524, (7.203, 18.427, 28.146)),
    (752899, (8.752, 18.366, 25.633)),
    (416669, (2.693, 15.359, 27.242)),
    (179354, (0.449, 16.369, 23.003)),
    (430750, (0.875, 17.233, 26.569)),
    (206285, (8.921, 12.099, 23.289)),
    (881212, (1.118, 13.561, 28.357)),
    (295585, (1.929, 19.164, 26.695)),
    (942050, (5.781, 16.571, 29.298)),
    (695019, (2.695, 10.237, 24.645)),
    (10587, (1.373, 16.217, 20.552)),
    (400412, (1.016, 14.195, 21.480)),
    (605563, (6.837, 16.169, 27.237)),
    (505467, (1.342, 17.200, 20.765)),
    (397804, (6.059, 19.405, 27.547)),
    (828127, (9.558, 14.591, 20.565)),
    (566871, (1.175, 16.181, 27.703)),
    (178814, (3.928, 19.684, 25.175)),
    (344947, (5.091, 18.410, 22.095)),
    (413689, (9.724, 19.593, 22.449)),
    (41073, (1.315, 14.407, 21.840)),
    (245767, (3.469, 10.423, 28.378)),
    (122541, (0.130, 14.138, 24.269)),
    (252065, (9.028, 17.682, 24.425)),
    (939426, (3.093, 12.524, 23.760)),
    (436169, (3.895, 15.290, 27.642)),
    (51038, (0.048, 10.841, 22.624)),
    (738467, (4.525, 16.142, 24.996)),
    (596090, (6.694, 18.009, 20.114)),
    (486238, (5.407, 13.560, 20.654)),
    (425509, (9.722, 11.792, 20.323)),
    (114500, (5.748, 16.109, 21.084)),
    (568087, (0.266, 11.822, 25.512)),
    (633188, (4.902, 11.491, 28.982)),
    (917206, (3.716, 10.604, 28.568)),
    (592686, (9.245, 16.306, 22.276)),
    (874146, (6.219, 11.449, 23.759)),
    (219701, (0.478, 15.698, 24.292)),
    (262792, (0.227, 18.153, 24.016)),
    (712151, (7.369, 18.735, 25.405)),
    (80014, (0.459, 14.760, 27.389)),
    (16672, (9.106, 16.290, 25.042)),
    (357986, (9.997, 14.453, 28.522)),
    (720918, (6.647, 16.159, 23.218)),
    (253541, (0.800, 11.971, 21.597)),
    (260953, (3.891, 14.301, 29.132)),
    (471216, (9.243, 12.992, 25.499)),
    (990472, (5.256, 18.375, 22.448)),
    (469845, (8.780, 12.136, 23.324)),
    (356325, (6.331, 18.745, 22.663)),
    (60081, (6.716, 10.475, 24.704)),
    (362631, (5.758, 18.784, 22.538)),
    (980290, (3.177, 17.987, 29.647)),
    (355426, (9.815, 18.728, 25.676)),
    (526396, (1.135, 10.145, 24.386)),
    (53288, (6.804, 17.393, 25.063)),
    (808500, (7.885, 18.642, 28.248)),
    (943636, (4.561, 17.590, 25.621)),
    (353901, (7.032, 17.179, 20.618)),
    (417044, (9.598, 14.507, 28.651)),
    (486145, (9.243, 14.526, 29.073)),
    (200580, (5.385, 15.538, 26.705)),
    (207776, (1.901, 19.870, 26.054)),
    (219538, (7.031, 17.251, 28.308)),
    (635931, (1.652, 11.034, 21.997)),
    (762441, (5.681, 13.560, 21.593)),
    (865695, (6.793, 10.678, 27.179)),
    (327990, (0.380, 13.435, 27.436)),
    (722697, (6.162, 11.641, 24.293)),
    (786465, (3.561, 18.021, 21.335)),
    (324868, (6.115, 10.216, 29.699)),
    (998299, (6.114, 19.357, 28.560)),
    (220180, (4.486, 11.135, 24.049)),
    (43161, (8.923, 10.689, 29.609)),
    (871699, (8.257, 16.482, 26.846)),
    (196026, (7.552, 18.732, 24.947)),
    (670544, (2.580, 16.128, 23.208)),
    (11989, (8.845, 19.331, 28.552)),
    (741220, (4.807, 18.942, 28.425)),
    (418623, (8.435, 15.802, 28.142)),
    (777980, (6.984, 12.822, 24.563)),
    (945952, (2.025, 10.609, 29.856)),
    (168477, (2.361, 12.465, 25.098)),
    (114478, (0.688, 18.132, 25.211)),
    (77401, (8.224, 18.541, 24.364)),
    (602859, (7.648, 18.126, 22.331)),
    (780042, (0.521, 15.611, 22.903)),
    (986720, (6.522, 19.650, 24.411)),
    (227910, (1.834, 18.117, 29.562)),
    (383289, (1.218, 15.819, 27.841)),
    (471105, (5.152, 17.137, 26.804)),
    (274018, (2.164, 14.104, 21.706)),
    (7271, (0.240, 15.049, 23.288)),
    (182157, (9.815, 13.561, 23.426)),
    (881677, (1.817, 14.039, 24.985)),
    (958447, (6.342, 19.067, 21.910)),
    (925459, (3.652, 17.220, 27.053)),
    (143432, (0.662, 11.499, 25.893)),
    (220439, (1.094, 14.496, 20.912)),
    (606303, (4.844, 10.281, 27.691)),
    (606738, (3.860, 16.947, 26.958)),
    (28329, (8.529, 15.807, 24.108)),
    (171705, (0.683, 16.184, 27.051)),
    (652170, (5.143, 18.059, 23.851)),
    (860417, (9.501, 12.365, 26.502)),
    (679308, (4.219, 12.204, 21.371)),
    (548970, (3.540, 12.582, 28.827)),
    (824968, (8.026, 18.807, 23.694)),
    (541598, (6.338, 15.535, 28.584)),
    (968553, (0.820, 11.279, 24.862)),
    (591867, (0.861, 10.979, 28.381)),
    (514016, (4.621, 10.137, 28.426)),
    (239416, (5.541, 16.066, 23.423)),
    (284585, (9.052, 18.464, 29.837)),
    (150365, (7.051, 14.325, 21.986)),
    (117006, (9.952, 13.755, 23.840)),
    (753103, (4.303, 14.373, 25.373)),
    (673866, (2.969, 13.390, 27.314)),
    (659282, (4.193, 12.020, 23.940)),
    (385314, (3.322, 13.727, 27.238)),
    (27310, (4.396, 10.348, 20.264)),
    (193101, (8.839, 14.619, 26.453)),
    (964798, (6.949, 10.092, 29.455)),
    (805435, (9.064, 17.471, 29.308)),
    (963166, (4.879, 17.849, 21.193)),
    (879714, (6.789, 13.413, 25.705)),
    (945808, (9.448, 10.632, 23.010)),
    (300849, (9.247, 15.669, 20.573)),
    (155955, (8.593, 17.654, 20.909)),
    (3477, (6.986, 11.909, 28.318)),
    (604537, (2.400, 17.527, 29.968)),
    (157342, (1.069, 13.883, 27.080)),
    (174216, (5.411, 13.380, 24.362)),
    (612943, (0.434, 19.407, 23.602)),
    (490140, (5.704, 19.529, 26.974)),
    (109002, (6.521, 13.023, 20.323)),
    (461903, (4.495, 17.317, 22.946)),
    (665610, (3.297, 17.770, 27.305)),
    (798852, (0.123, 18.294, 27.335)),
    (515952, (3.269, 13.905, 25.419)),
    (429162, (4.717, 14.562, 26.998)),
    (589104, (2.845, 15.462, 24.803)),
    (344117, (5.354, 19.645, 28.398)),
    (581131, (7.356, 13.906, 23.694)),
    (638492, (3.061, 17.393, 23.808)),
    (270127, (4.413, 18.078, 28.011)),
    (919160, (4.812, 16.733, 26.977)),
    (535345, (0.833, 17.755, 25.768)),
    (354837, (9.877, 14.509, 21.238)),
    (310813, (3.176, 11.708, 23.989)),
    (986703, (4.101, 14.039, 22.980)),
    (266431, (4.651, 15.709, 20.540)),
    (742716, (8.132, 12.862, 29.342)),
    (708159, (1.867, 13.323, 26.591)),
    (226779, (1.364, 11.340, 27.271)),
    (148968, (8.642, 10.438, 27.190)),
    (883882, (1.241, 10.212, 22.917)),
    (154457, (4.352, 13.671, 27.374)),
    (185256, (8.384, 10.693, 26.380)),
    (803410, (3.315, 16.091, 21.580)),
    (642717, (8.727, 11.407, 22.683)),
    (276847, (0.511, 19.311, 25.802)),
    (462249, (8.759, 12.936, 23.458)),
    (228340, (9.938, 11.235, 23.523)),
    (574259, (4.527, 13.411, 22.367)),
    (440099, (6.916, 13.066, 23.334)),
    (77681, (5.991, 18.558, 27.403)),
    (818040, (2.534, 13.253, 25.798)),
    (889712, (9.725, 11.024, 22.495)),
    (640661, (6.638, 19.886, 20.799)),
    (786868, (7.203, 19.739, 21.764)),
    (616303, (5.633, 11.376, 27.755)),
    (490963, (0.590, 18.369, 26.999)),
    (520617, (5.898, 17.116, 29.603)),
    (229983, (2.778, 14.149, 25.851)),
    (290534, (2.844, 16.208, 25.211)),
    (242909, (1.727, 12.457, 28.292)),
    (549196, (5.677, 11.349, 23.351)),
    (704769, (2.114, 19.368, 28.855)),
    (7252, (4.801, 19.069, 25.087)),
    (142828, (4.677, 18.328, 23.026)),
    (521593, (4.837, 18.013, 28.304)),
    (924936, (5.816, 13.247, 28.647)),
    (325659, (7.455, 15.815, 20.893)),
    (124162, (9.274, 17.781, 27.402)),
    (319283, (2.340, 16.048, 23.178)),
    (733158, (0.594, 19.249, 21.283)),
    (377838, (3.522, 10.414, 23.940)),
    (618670, (8.527, 10.564, 25.935)),
    (550222, (6.050, 11.708, 22.200)),
    (185438, (3.008, 17.487, 22.949)),
    (552964, (2.066, 10.170, 28.531)),
    (505789, (3.951, 10.336, 27.245)),
    (694226, (1.229, 19.348, 26.788)),
    (301536, (0.374, 18.408, 21.416)),
    (462190, (2.527, 11.817, 23.149)),
    (424538, (3.184, 11.671, 24.333)),
    (885834, (0.930, 15.491, 29.492)),
    (634529, (9.426, 16.809, 24.186)),
    (893867, (5.898, 15.259, 26.849)),
    (825295, (0.081, 18.904, 27.034)),
    (741920, (7.159, 11.864, 24.898)),
    (490502, (9.901, 18.937, 29.182)),
    (357864, (5.164, 12.596, 28.395)),
    (221639, (0.495, 19.066, 21.965)),
    (762359, (3.692, 18.649, 26.018)),
    (97109, (9.502, 14.046, 20.526)),
    (429144, (2.177, 17.310, 22.378)),
    (176322, (9.709, 19.677, 27.223)),
    (755922, (4.352, 18.326, 29.974)),
    (650232, (4.077, 14.936, 26.134)),
    (915268, (3.167, 16.642, 22.434)),
    (691872, (9.203, 17.478, 24.982)),
    (839851, (9.473, 10.095, 24.784)),
    (356203, (1.409, 19.883, 23.461)),
    (741880, (3.584, 14.707, 27.865)),
    (343272, (7.262, 10.310, 21.879)),
    (383283, (2.445, 14.545, 25.588)),
    (496255, (6.825, 11.373, 24.319)),
    (227267, (6.950, 10.329, 27.737)),
    (956837, (2.250, 19.681, 28.355)),
    (878619, (6.981, 18.452, 27.347)),
    (406486, (6.741, 17.608, 24.905)),
    (864181, (2.149, 16.964, 27.717)),
    (30327, (7.227, 12.206, 26.629)),
    (325340, (3.844, 16.333, 27.283)),
    (205151, (0.404, 16.548, 23.295)),
    (223263, (1.434, 18.870, 21.329)),
    (931005, (2.193, 17.802, 25.301)),
    (281160, (3.563, 12.196, 26.999)),
    (754731, (7.075, 14.954, 29.739)),
    (839071, (9.074, 12.872, 21.737)),
    (844990, (5.768, 14.148, 27.833)),
    (822119, (9.719, 15.279, 20.563)),
    (996529, (8.392, 18.174, 27.320)),
    (557779, (6.595, 11.851, 27.941)),
    (285437, (4.251, 19.915, 22.236)),
    (163015, (5.581, 19.632, 25.653)),
    (476088, (8.494, 17.724, 24.819)),
    (148625, (7.882, 13.421, 20.500)),
    (158051, (4.081, 12.500, 23.438)),
    (661887, (7.649, 15.569, 26.172)),
    (99843, (9.619, 12.242, 21.362)),
    (71117, (1.940, 13.184, 21.063)),
    (163988, (9.462, 13.287, 24.439)),
    (865965, (1.240, 15.381, 20.987)),
    (277299, (3.620, 14.333, 29.319)),
    (654045, (7.890, 15.721, 25.112)),
    (421758, (6.414, 19.118, 20.075)),
    (104218, (8.795, 11.107, 27.753)),
    (342196, (8.678, 12.067, 23.438)),
    (993746, (2.000, 16.056, 22.077)),
    (823199, (0.896, 17.356, 26.337)),
    (34948, (1.658, 19.290, 29.258)),
    (365752, (6.818, 10.152, 29.287)),
    (580311, (5.360, 15.405, 28.919)),
    (89167, (8.522, 14.383, 22.116)),
    (9189, (3.128, 18.922, 25.294)),
    (193399, (3.151, 15.021, 25.272)),
    (546798, (3.144, 17.277, 24.684)),
    (657559, (5.781, 19.796, 24.332)),
    (747804, (0.794, 18.939, 20.379)),
    (443185, (1.520, 10.755, 29.605)),
    (497038, (6.194, 18.669, 22.619)),
    (37855, (0.681, 11.963, 23.553)),
    (25891, (0.438, 11.210, 28.718)),
    (892391, (8.247, 13.950, 22.724)),
    (48611, (6.560, 17.418, 29.915)),
    (700161, (8.614, 19.978, 21.298)),
    (954084, (6.034, 12.702, 24.850)),
    (493209, (8.874, 19.107, 28.434)),
    (756988, (5.825, 11.777, 23.309)),
    (485736, (9.513, 19.463, 27.157)),
    (644938, (9.849, 15.536, 22.352)),
    (864449, (5.104, 12.319, 29.330)),
    (102298, (4.385, 10.829, 22.388)),
    (574684, (3.348, 16.647, 29.659)),
    (88239, (3.776, 16.650, 25.292)),
    (998410, (7.689, 13.727, 20.327)),
    (491849, (1.438, 18.240, 29.298)),
    (297033, (0.320, 16.098, 27.098)),
    (397612, (7.609, 11.471, 25.086)),
    (673050, (9.920, 16.745, 27.425)),
    (343630, (9.857, 16.995, 22.998)),
    (112834, (5.111, 16.412, 20.591)),
    (533012, (8.429, 16.133, 20.307)),
    (765090, (0.734, 14.316, 29.105)),
    (211463, (0.097, 18.614, 20.061)),
    (169368, (2.548, 13.072, 27.948)),
    (820997, (1.060, 19.887, 23.950)),
    (371367, (5.966, 11.707, 27.968)),
    (885977, (5.580, 11.226, 29.139)),
    (997753, (6.992, 17.522, 26.492)),
    (561311, (6.848, 11.259, 21.320)),
    (62122, (0.303, 13.553, 22.439)),
    (635495, (0.531, 10.943, 23.840)),
    (624318, (1.423, 12.944, 29.734)),
    (359661, (0.428, 19.517, 28.925)),
    (27817, (4.972, 13.004, 25.396)),
    (665178, (9.611, 17.896, 21.239)),
    (594686, (9.087, 16.159, 22.978)),
    (796400, (8.252, 12.836, 28.088)),
    (135701, (3.750, 17.149, 26.138)),
    (120668, (5.484, 11.525, 28.368)),
    (613586, (9.198, 12.497, 24.905)),
    (347206, (2.976, 19.995, 29.354)),
    (25638, (1.943, 12.947, 23.508)),
    (718467, (5.719, 19.159, 20.666)),
    (793122, (5.576, 18.963, 23.350)),
    (128291, (7.017, 13.865, 21.670)),
    (652280, (0.283, 17.686, 26.265)),
    (775749, (9.428, 16.988, 25.563)),
    (992632, (8.869, 11.706, 29.467)),
    (425646, (7.156, 18.890, 25.826)),
    (511476, (9.640, 14.671, 21.707)),
    (249438, (0.381, 17.485, 27.684)),
    (123506, (8.237, 11.229, 26.669)),
    (232420, (0.718, 11.037, 22.519)),
    (286009, (6.311, 18.475, 25.380)),
    (478574, (9.456, 12.048, 28.780)),
    (963348, (3.509, 14.146, 23.857)),
    (158493, (2.991, 16.495, 23.137)),
    (372951, (2.283, 14.184, 26.225)),
    (737639, (1.243, 11.957, 25.445)),
    (891738, (4.677, 17.653, 29.906)),
    (604487, (8.859, 17.156, 26.593)),
    (302796, (5.931, 14.619, 20.272)),
    (208418, (2.617, 19.039, 29.145)),
    (776040, (6.351, 13.125, 29.484)),
    (702286, (4.060, 11.931, 22.711)),
    (826429, (4.903, 17.061, 20.617)),
    (446532, (8.876, 14.983, 20.848)),
    (62163, (5.397, 19.341, 27.631)),
    (435634, (3.733, 13.510, 23.066)),
    (42982, (9.375, 11.233, 22.458)),
    (96985, (9.989, 17.340, 25.971)),
    (341000, (1.607, 16.797, 20.024)),
    (774677, (3.827, 13.082, 22.029)),
    (121017, (4.522, 16.287, 25.223)),
    (382170, (0.735, 18.149, 23.688)),
    (735396, (4.628, 14.057, 26.050)),
    (278522, (0.583, 12.957, 25.687)),
    (942499, (9.019, 12.745, 27.001)),
    (771226, (7.818, 14.442, 27.041)),
    (107039, (9.868, 15.939, 26.896)),
    (736062, (8.834, 18.730, 24.671)),
    (864422, (2.638, 10.788, 27.633)),
    (564098, (1.437, 15.656, 28.888)),
    (675360, (6.099, 14.082, 29.158)),
    (303555, (0.535, 18.140, 24.748)),
    (14270, (4.722, 14.583, 25.177)),
    (869206, (2.016, 10.601, 23.939)),
    (432377, (9.280, 10.752, 22.073)),
    (686448, (1.616, 13.004, 21.287)),
    (24351, (5.474, 15.973, 21.295)),
    (492333, (0.602, 15.064, 22.705)),
    (997930, (4.440, 10.018, 25.217)),
    (420696, (5.344, 14.956, 20.080)),
    (78560, (0.508, 12.060, 21.657)),
    (243560, (4.438, 17.354, 26.528)),
    (702126, (2.070, 14.637, 25.933)),
    (665995, (3.191, 19.531, 21.642)),
    (788, (7.894, 11.797, 26.726)),
    (101452, (4.841, 17.003, 24.092)),
    (399674, (6.000, 17.197, 20.222)),
    (584208, (9.967, 11.124, 24.216)),
    (934644, (7.760, 15.672, 21.640)),
    (591639, (4.845, 10.859, 24.111)),
    (883728, (3.526, 13.981, 27.082)),
    (409078, (6.312, 17.413, 27.751)),
    (931992, (8.095, 16.864, 28.297)),
    (12709, (6.885, 18.170, 23.414)),
    (991296, (9.706, 17.061, 21.307)),
    (851263, (9.259, 11.093, 22.714)),
    (56284, (1.644, 14.192, 26.971)),
    (182085, (1.984, 18.410, 27.785)),
    (809963, (4.404, 12.377, 25.668)),
    (525860, (4.902, 13.780, 28.313)),
    (569615, (2.197, 15.095, 23.665)),
    (294517, (2.446, 18.579, 22.459)),
    (233042, (4.406, 16.220, 22.013)),
    (409979, (6.716, 11.394, 29.366)),
    (490329, (0.974, 11.716, 21.697)),
    (300727, (4.250, 19.385, 26.470)),
    (799449, (5.452, 16.679, 22.071)),
    (694813, (5.110, 18.923, 20.862)),
    (31727, (8.090, 15.473, 27.319)),
    (808569, (1.634, 19.673, 25.099)),
    (307666, (3.457, 11.542, 25.952)),
    (807690, (4.816, 15.129, 22.353)),
    (934933, (7.951, 12.006, 27.132)),
    (743888, (8.531, 13.262, 23.853)),
    (114847, (0.957, 14.506, 29.736)),
    (211862, (5.104, 17.438, 25.837)),
    (859948, (4.613, 16.088, 29.263)),
    (510917, (3.767, 19.054, 22.516)),
    (691321, (2.761, 14.692, 28.582)),
    (165629, (6.439, 19.052, 23.751)),
    (205844, (8.283, 12.229, 25.191)),
    (726652, (3.563, 17.439, 22.248)),
    (738590, (6.316, 17.247, 25.947)),
    (846226, (8.456, 10.754, 27.596)),
    (709156, (1.285, 18.587, 26.590)),
    (496087, (8.312, 18.834, 23.290)),
    (387022, (2.492, 15.517, 20.446)),
    (629414, (2.659, 17.080, 26.863)),
    (194485, (7.857, 11.520, 27.136)),
    (171782, (9.972, 18.473, 24.248)),
    (363402, (9.375, 13.725, 27.661)),
    (294988, (6.665, 14.949, 22.500)),
    (741789, (7.983, 10.361, 25.823)),
    (932747, (4.904, 16.551, 28.634)),
    (337728, (9.573, 17.219, 29.172)),
    (201718, (1.653, 11.995, 23.561)),
    (900414, (3.416, 16.324, 29.470)),
    (560785, (6.886, 12.889, 29.830)),
    (111129, (4.484, 13.925, 22.260)),
    (853051, (8.713, 18.504, 28.023)),
    (553071, (0.487, 15.661, 26.009)),
    (855876, (1.155, 13.956, 21.388)),
    (350750, (8.890, 10.416, 20.160)),
    (429085, (2.408, 10.741, 24.758)),
    (345752, (2.009, 15.035, 25.942)),
    (596271, (3.937, 11.827, 25.404)),
    (687216, (1.589, 13.570, 21.300)),
    (541568, (1.915, 12.528, 20.282)),
    (996863, (3.926, 18.410, 24.695)),
    (831276, (1.212, 14.049, 28.850)),
    (503866, (5.027, 12.827, 25.119)),
    (501259, (4.316, 14.334, 23.101)),
    (896433, (5.962, 14.674, 21.376)),
    (629666, (4.731, 16.640, 24.143)),
    (634910, (7.246, 18.053, 25.355)),
    (587986, (6.192, 12.874, 27.799)),
    (109945, (9.280, 19.751, 29.310)),
    (366277, (5.842, 10.736, 28.691)),
    (553630, (3.018, 16.167, 26.874)),
    (341315, (4.958, 15.139, 21.592)),
    (617829, (5.590, 17.844, 24.491)),
    (507174, (0.294, 14.296, 21.679)),
    (675840, (1.013, 18.490, 21.995)),
    (23579, (6.979, 15.300, 29.965)),
    (400336, (0.206, 17.412, 25.666)),
    (142895, (1.302, 12.858, 27.785)),
    (711967, (1.462, 12.637, 26.769)),
    (387455, (6.929, 11.452, 29.196)),
    (988820, (7.061, 17.474, 21.861)),
    (371853, (8.677, 16.839, 20.371)),
    (795377, (6.296, 11.648, 28.711)),
    (694580, (4.079, 16.441, 22.203)),
    (825241, (4.790, 18.730, 25.772)),
    (158804, (2.412, 10.806, 21.354)),
    (782018, (1.842, 14.350, 23.983)),
    (765843, (2.928, 12.345, 28.009)),
    (547217, (0.307, 14.620, 20.600)),
    (517101, (5.546, 17.729, 25.317)),
    (440294, (9.589, 14.031, 28.766)),
    (243386, (5.998, 17.359, 23.969)),
    (260465, (3.779, 15.377, 25.965)),
    (910526, (9.494, 10.225, 21.580)),
    (305338, (1.812, 15.398, 26.080)),
    (111446, (8.444, 18.102, 21.524)),
    (885285, (1.510, 10.975, 23.604)),
    (537349, (8.196, 15.838, 26.363)),
    (830043, (9.974, 16.748, 28.543)),
    (99650, (6.356, 17.679, 26.993)),
    (38734, (2.898, 14.961, 20.969)),
    (507532, (7.407, 19.486, 28.031)),
    (280401, (2.204, 14.450, 20.308)),
    (642194, (3.000, 11.252, 23.525)),
    (723184, (4.439, 12.274, 26.616)),
    (563425, (4.249, 19.243, 29.626)),
    (504526, (0.762, 19.343, 27.973)),
    (31645, (3.412, 10.467, 27.354)),
    (491776, (9.410, 15.815, 21.419)),
    (861559, (4.195, 18.357, 24.816)),
    (1053, (1.942, 10.450, 26.131)),
    (717620, (5.278, 13.818, 22.420)),
    (447982, (3.902, 16.546, 23.015)),
    (562618, (5.862, 12.782, 29.700)),
    (550011, (1.917, 17.413, 26.723)),
    (980592, (9.625, 11.556, 25.135)),
    (378557, (7.721, 16.278, 27.016)),
    (154929, (8.014, 13.840, 26.289)),
    (898666, (9.207, 13.815, 24.100)),
    (914546, (1.156, 15.326, 28.472)),
    (168111, (4.870, 13.044, 25.772)),
    (763295, (3.373, 19.161, 21.267)),
    (889334, (9.067, 14.925, 23.162)),
    (457286, (0.194, 18.064, 20.418)),
    (598600, (4.100, 10.582, 23.532)),
    (188237, (6.925, 19.738, 23.005)),
    (781504, (1.911, 17.778, 29.541)),
    (641625, (4.357, 18.696, 26.101)),
    (439459, (6.719, 13.210, 21.338)),
    (419419, (0.842, 15.548, 27.754)),
    (526151, (5.824, 13.409, 29.879)),
    (809300, (6.378, 19.922, 28.327)),
    (978773, (5.964, 16.034, 20.658)),
    (202772, (5.999, 14.429, 27.472)),
    (797224, (6.787, 19.394, 25.877)),
    (983978, (1.963, 17.342, 21.731)),
    (136266, (4.625, 10.252, 29.228)),
    (365889, (7.191, 10.138, 29.406)),
    (761967, (1.035, 17.282, 25.865)),
    (939520, (5.897, 10.070, 20.220)),
    (741393, (7.640, 12.844, 24.282)),
    (885902, (7.442, 12.615, 24.896)),
    (829927, (5.627, 18.687, 27.674)),
    (441410, (8.908, 19.129, 24.528)),
    (125148, (3.347, 14.118, 21.522)),
    (565869, (4.335, 12.131, 23.939)),
    (474187, (6.044, 17.998, 26.407)),
    (159163, (0.182, 13.428, 28.091)),
    (177960, (3.234, 16.182, 28.624)),
    (639286, (1.374, 14.366, 21.498)),
    (63713, (5.769, 17.774, 24.719)),
    (518065, (6.577, 12.140, 22.984)),
    (473321, (6.656, 11.755, 23.858)),
    (925920, (2.624, 15.782, 23.311)),
    (972803, (8.607, 19.826, 26.283)),
    (441729, (4.636, 14.776, 27.573)),
    (345396, (1.593, 12.207, 25.465)),
    (145490, (6.293, 14.154, 29.239)),
    (424989, (7.951, 16.312, 26.816)),
    (712825, (5.193, 18.873, 23.630)),
    (591768, (9.416, 13.713, 23.004)),
    (264087, (3.079, 11.927, 22.264)),
    (237159, (2.803, 11.136, 20.559)),
    (527694, (6.255, 18.111, 23.635)),
    (241608, (9.676, 14.468, 25.200)),
    (307660, (6.657, 11.414, 25.024)),
    (45775, (9.739, 16.206, 28.705)),
    (159464, (8.704, 18.060, 21.293)),
    (533805, (3.520, 11.039, 24.876)),
    (463305, (0.867, 11.090, 24.825)),
    (836098, (6.660, 14.318, 21.034)),
    (308548, (7.347, 12.880, 23.218)),
    (323304, (3.169, 16.218, 21.987)),
    (126735, (7.907, 12.347, 21.116)),
    (650324, (6.810, 17.369, 28.270)),
    (701320, (0.003, 16.896, 27.361)),
    (568986, (3.971, 19.659, 29.277)),
    (143575, (8.460, 15.506, 25.477)),
    (711250, (4.286, 12.678, 27.143)),
    (63488, (8.005, 18.868, 25.395)),
    (828461, (5.938, 19.239, 22.117)),
    (843448, (3.039, 19.570, 27.166)),
    (505384, (7.822, 11.761, 24.987)),
    (658060, (5.773, 18.364, 28.897)),
    (190650, (3.948, 19.691, 21.013)),
    (902371, (4.739, 11.736, 20.868)),
    (485281, (2.329, 18.198, 25.525)),
    (431917, (3.787, 19.385, 20.811)),
    (10428, (3.099, 12.513, 23.871)),
    (211985, (0.184, 11.960, 27.907)),
    (194315, (8.009, 18.188, 23.548)),
    (15418, (9.424, 15.367, 28.675)),
    (239301, (1.941, 19.085, 28.525)),
    (49637, (1.179, 18.676, 29.167)),
    (354141, (1.243, 11.066, 25.595)),
    (14955, (1.780, 16.783, 21.730)),
    (61615, (9.504, 15.424, 24.416)),
    (926571, (9.186, 11.134, 28.916)),
    (933451, (2.188, 10.211, 23.329)),
    (780564, (9.802, 19.774, 22.157)),
    (367836, (6.450, 11.732, 29.562)),
    (938053, (0.932, 17.911, 20.451)),
    (485377, (6.197, 11.751, 26.814)),
    (376221, (9.415, 10.511, 25.441)),
    (221156, (9.786, 19.492, 27.005)),
    (558829, (5.537, 13.040, 26.774)),
    (566759, (5.821, 19.020, 28.853)),
    (684641, (7.061, 11.850, 27.625)),
    (739939, (8.576, 10.617, 22.404)),
    (531355, (3.937, 19.200, 29.327)),
    (333110, (6.504, 18.355, 26.915)),
    (450026, (0.576, 18.902, 26.970)),
    (974386, (6.531, 19.294, 22.112)),
    (407647, (8.681, 15.898, 29.891)),
    (26007, (7.763, 17.643, 21.267)),
    (633563, (2.630, 12.523, 24.464)),
    (928020, (9.424, 11.645, 22.020)),
    (309642, (9.121, 13.505, 23.197)),
    (666778, (6.767, 17.042, 29.753)),
    (548859, (2.203, 10.394, 26.107)),
    (570926, (0.575, 13.018, 21.556)),
    (413360, (5.853, 13.058, 25.753)),
    (686358, (6.714, 14.042, 26.674)),
    (620544, (3.497, 15.495, 25.245)),
    (323219, (3.994, 10.966, 25.576)),
    (878751, (4.305, 13.849, 25.606)),
    (380309, (3.377, 10.066, 29.334)),
    (956699, (7.084, 14.761, 22.337)),
    (691136, (8.198, 15.563, 27.172)),
    (66472, (1.611, 18.295, 22.052)),
    (530028, (0.947, 18.642, 20.435)),
    (518869, (8.763, 17.027, 26.598)),
    (167679, (1.942, 14.089, 27.185)),
    (200966, (3.046, 18.525, 28.462)),
    (66245, (1.152, 19.360, 28.678)),
    (42091, (0.830, 19.292, 26.940)),
    (364856, (0.927, 18.550, 24.442)),
    (55301, (4.542, 13.609, 27.982)),
    (256377, (3.049, 19.150, 28.448)),
    (417357, (8.579, 14.643, 27.888)),
    (483493, (2.210, 15.744, 24.234)),
    (279421, (1.743, 19.041, 28.122)),
    (729091, (2.693, 19.144, 28.261)),
    (852523, (6.183, 15.689, 23.474)),
    (77981, (2.389, 17.568, 21.001)),
    (949755, (3.905, 14.283, 22.757)),
    (209196, (6.728, 13.720, 26.047)),
    (63326, (5.283, 12.634, 28.963)),
    (812923, (4.147, 18.582, 25.618)),
    (199559, (3.867, 10.146, 29.634)),
    (699132, (3.556, 19.405, 26.133)),
    (95998, (7.236, 18.944, 23.786)),
    (114010, (5.976, 17.824, 21.327)),
    (557250, (6.930, 17.561, 25.954)),
    (127478, (3.645, 12.761, 21.843)),
    (898055, (8.999, 10.448, 22.548)),
    (692603, (6.597, 13.172, 24.699)),
    (712797, (7.708, 10.887, 22.421)),
    (277419, (1.190, 12.243, 21.881)),
    (426346, (2.442, 16.092, 24.974)),
    (202493, (9.098, 15.370, 22.657)),
    (684508, (3.571, 12.425, 24.607)),
    (183153, (4.846, 10.309, 27.532)),
    (948315, (7.225, 15.936, 26.244)),
    (253691, (9.358, 17.091, 24.122)),
    (692265, (0.406, 18.509, 25.682)),
    (838708, (0.288, 15.514, 20.572)),
    (72325, (2.471, 11.047, 22.392)),
    (549433, (8.642, 12.512, 24.035)),
    (642546, (7.003, 13.976, 20.408)),
    (646269, (3.747, 18.773, 25.938)),
    (765076, (4.326, 12.286, 29.735)),
    (983118, (0.695, 16.932, 23.048)),
    (921262, (3.721, 17.051, 26.770)),
    (644242, (6.642, 17.597, 22.964)),
    (384267, (3.409, 14.123, 23.898)),
    (263895, (9.600, 18.007, 20.059)),
    (802221, (3.981, 15.933, 26.989)),
    (186950, (5.777, 14.400, 20.770)),
    (454359, (2.897, 19.871, 29.896)),
    (126198, (4.925, 12.052, 22.962)),
    (354874, (6.390, 11.341, 22.146)),
    (68705, (3.587, 11.958, 22.154)),
    (538830, (9.925, 16.553, 25.478)),
    (58059, (4.607, 17.029, 22.964)),
    (542887, (2.688, 14.866, 21.891)),
    (655758, (4.205, 11.307, 23.957)),
    (23910, (8.902, 14.328, 28.703)),
    (454955, (1.515, 12.442, 25.183)),
    (413139, (7.645, 14.999, 26.061)),
    (563828, (3.445, 10.662, 25.064)),
    (215318, (2.498, 13.832, 23.961)),
    (421034, (2.409, 17.755, 25.597)),
    (58457, (0.697, 15.737, 29.233)),
    (46633, (7.012, 12.702, 28.530)),
    (695171, (9.977, 15.794, 28.782)),
    (129213, (9.344, 17.305, 21.992)),
    (141041, (5.817, 14.203, 20.605)),
    (835216, (5.745, 17.651, 26.510)),
    (407666, (0.435, 14.977, 23.259)),
    (5842, (6.753, 16.322, 26.676)),
    (74837, (4.352, 15.858, 27.645)),
    (682859, (6.403, 16.960, 22.742)),
    (598760, (4.626, 16.224, 23.316)),
    (958055, (6.241, 19.623, 20.641)),
    (541858, (9.235, 14.428, 21.608)),
    (44853, (9.916, 16.236, 21.157)),
    (324917, (5.347, 15.488, 27.147)),
    (89941, (7.865, 13.487, 25.289)),
    (489409, (3.396, 15.949, 20.884)),
    (858170, (2.790, 15.621, 29.379)),
    (500276, (6.555, 13.976, 26.025)),
    (359548, (7.207, 17.472, 21.003)),
    (907632, (4.837, 14.750, 20.168)),
    (456899, (4.817, 18.162, 27.034)),
    (801130, (5.374, 18.596, 28.187)),
    (606869, (3.302, 16.575, 20.848)),
    (367330, (6.738, 14.393, 24.786)),
    (550992, (0.157, 11.621, 28.172)),
    (472082, (9.380, 18.871, 29.083)),
    (201066, (7.565, 15.898, 28.254)),
    (922563, (8.526, 10.028, 26.258)),
    (405369, (9.339, 13.659, 27.589)),
    (372635, (1.246, 18.056, 22.780)),
    (558833, (4.757, 18.191, 25.108)),
    (310605, (6.235, 16.897, 27.490)),
    (752347, (8.491, 12.855, 28.071)),
    (692366, (6.493, 14.155, 28.874)),
    (482655, (5.876, 15.789, 26.881)),
    (560871, (0.569, 11.632, 20.373)),
    (824848, (7.531, 16.121, 25.208)),
    (17352, (4.761, 19.182, 22.528)),
    (455565, (1.352, 16.546, 21.927)),
    (890360, (0.458, 19.089, 26.056)),
    (123055, (4.059, 17.224, 20.393)),
    (708610, (3.532, 14.093, 21.745)),
    (288654, (7.896, 15.036, 21.791)),
    (641138, (0.481, 10.155, 22.793)),
    (977632, (0.321, 14.348, 29.989)),
    (99860, (0.173, 10.485, 22.752)),
    (234064, (6.105, 10.893, 26.201)),
    (326863, (1.245, 10.220, 21.922)),
    (538891, (3.834, 15.434, 22.480)),
    (381555, (6.489, 10.537, 29.995)),
    (304974, (3.737, 19.016, 28.030)),
    (160029, (9.792, 14.053, 21.023)),
    (754158, (2.396, 19.850, 24.146)),
    (730602, (0.834, 11.229, 23.828)),
    (608972, (4.381, 13.442, 25.829)),
    (6651, (1.190, 14.228, 28.907)),
    (838785, (6.809, 11.947, 20.487)),
    (798402, (4.996, 17.035, 25.475)),
    (782473, (7.843, 18.104, 21.482)),
    (392024, (9.592, 10.534, 21.820)),
    (162725, (9.202, 13.336, 22.334)),
    (230776, (5.238, 17.010, 27.230)),
    (659993, (8.744, 16.033, 27.110)),
    (355679, (2.035, 10.736, 23.595)),
    (603710, (3.686, 19.822, 20.650)),
    (199293, (9.168, 17.407, 26.451)),
    (835930, (5.297, 16.245, 28.135)),
    (637141, (0.386, 10.732, 25.054)),
    (479633, (7.473, 12.191, 22.064)),
    (928293, (2.380, 19.393, 29.475)),
    (217280, (1.508, 13.104, 23.489)),
    (226175, (2.259, 13.835, 24.467)),
    (677075, (0.464, 16.459, 26.498)),
    (210566, (1.616, 10.642, 29.633)),
    (370043, (5.832, 14.040, 25.315)),
    (594371, (0.125, 15.999, 24.344)),
    (463936, (9.552, 19.210, 20.280)),
    (112580, (9.559, 10.099, 20.993)),
    (503200, (7.078, 16.543, 28.723)),
    (386184, (0.899, 13.821, 29.763)),
    (679567, (4.044, 12.042, 24.946)),
    (890127, (2.188, 11.913, 26.445)),
    (912910, (9.584, 11.243, 25.220)),
    (181499, (1.968, 16.257, 29.251)),
    (778473, (2.720, 10.783, 27.419)),
    (941948, (0.339, 11.791, 25.755)),
    (804188, (5.379, 15.622, 24.424)),
    (750152, (4.886, 19.668, 28.597)),
    (923065, (6.862, 10.350, 25.163)),
    (270203, (9.417, 19.797, 24.532)),
    (302275, (8.668, 19.310, 21.842)),
    (197957, (8.702, 11.135, 21.771)),
    (563607, (9.767, 12.340, 21.113)),
    (395737, (2.631, 13.858, 23.131)),
    (70830, (6.192, 10.473, 20.550)),
    (982134, (6.577, 13.260, 25.283)),
    (158465, (2.232, 19.021, 27.310)),
    (229897, (7.203, 16.045, 23.146)),
    (214290, (8.753, 17.725, 28.462)),
    (921719, (9.509, 18.154, 21.596)),
    (540733, (2.041, 11.953, 24.615)),
    (30793, (6.789, 16.160, 28.811)),
    (470254, (8.919, 10.540, 23.992)),
    (151022, (6.338, 12.186, 27.353)),
    (564607, (4.993, 19.617, 20.507)),
    (502503, (7.685, 19.310, 25.758)),
    (150819, (9.502, 16.225, 28.915)),
    (781679, (2.836, 14.482, 20.164)),
    (205499, (3.862, 17.105, 21.055)),
    (611777, (1.632, 10.666, 27.127)),
    (23594, (4.212, 13.361, 25.447)),
    (453560, (2.435, 11.389, 29.596)),
    (294220, (8.372, 14.504, 27.256)),
    (386128, (3.494, 14.868, 26.128)),
    (436533, (6.018, 18.616, 23.360)),
    (345155, (2.889, 10.923, 26.425)),
    (610966, (1.007, 14.873, 23.977)),
    (604167, (3.675, 14.564, 21.484)),
    (114062, (0.401, 14.103, 24.470)),
    (927065, (8.872, 15.028, 24.041)),
    (666138, (6.063, 14.999, 22.599)),
    (52918, (1.950, 19.646, 20.878)),
    (759116, (5.543, 17.765, 23.965)),
    (975787, (9.492, 12.728, 28.378)),
    (882816, (1.376, 17.709, 20.320)),
    (698691, (6.053, 15.557, 20.959)),
    (2768, (2.778, 10.579, 26.775)),
    (34416, (6.220, 16.372, 22.694)),
    (252051, (7.324, 17.360, 20.989)),
    (921755, (0.617, 19.172, 23.931)),
    (886371, (8.320, 19.775, 24.224)),
    (199350, (5.011, 11.659, 27.302)),
    (105585, (3.029, 10.090, 21.194)),
    (906112, (6.372, 12.024, 20.577)),
    (708816, (0.897, 14.830, 21.200)),
    (79098, (8.220, 18.058, 21.466)),
    (212209, (1.832, 14.575, 22.905)),
    (652509, (2.611, 13.470, 27.951)),
    (910055, (1.923, 17.307, 26.077)),
    (222427, (2.653, 17.503, 25.542)),
    (865063, (1.447, 18.030, 24.903)),
    (44370, (5.789, 18.022, 26.975)),
    (765633, (5.154, 17.915, 23.786)),
    (531344, (2.729, 13.116, 20.236)),
    (715879, (8.782, 19.722, 29.213)),
    (472014, (6.050, 18.534, 26.525)),
    (125726, (6.837, 11.271, 26.302)),
    (763103, (1.269, 13.789, 25.416)),
    (340523, (5.752, 13.555, 24.468)),
    (127669, (9.769, 17.815, 25.361)),
    (789895, (2.689, 18.329, 24.529)),
    (468693, (6.564, 16.716, 22.959)),
    (48493, (7.285, 14.668, 28.801)),
    (260936, (0.443, 10.459, 28.076)),
    (231867, (2.403, 14.949, 22.960)),
    (851226, (9.260, 10.438, 29.418)),
    (865627, (0.404, 12.918, 22.898)),
    (797591, (9.738, 17.009, 28.250)),
    (593301, (9.902, 16.058, 25.516)),
    (684325, (2.792, 11.927, 27.169)),
    (72488, (9.244, 19.743, 27.432)),
    (6376, (0.346, 14.709, 23.976)),
    (299907, (4.268, 19.618, 25.828)),
    (246679, (2.030, 13.443, 28.856)),
    (10024, (8.506, 13.596, 20.253)),
    (946734, (4.429, 13.787, 25.996)),
    (661724, (5.601, 10.892, 22.687)),
    (957944, (9.577, 16.298, 20.766)),
    (880208, (8.543, 18.785, 21.398)),
    (50798, (3.064, 16.304, 26.278)),
    (362067, (1.419, 12.083, 24.575)),
    (612559, (1.496, 13.161, 21.304)),
    (107299, (6.309, 13.028, 24.186)),
    (289818, (3.022, 17.484, 26.506)),
    (656958, (8.921, 14.462, 21.977)),
    (525887, (6.707, 14.839, 26.730)),
    (284812, (4.825, 15.137, 21.430)),
    (73424, (2.880, 14.069, 20.349)),
    (645066, (2.505, 14.816, 24.165)),
    (731912, (8.447, 12.363, 20.522)),
    (478460, (6.940, 17.598, 29.060)),
    (402553, (4.781, 14.928, 21.048)),
    (173611, (2.364, 16.951, 20.965)),
    (398121, (9.473, 17.519, 21.009)),
    (813948, (0.215, 16.415, 23.327)),
    (268843, (4.883, 19.325, 29.516)),
    (161123, (6.524, 13.385, 23.126)),
    (696324, (9.358, 10.758, 22.520)),
    (235708, (6.426, 14.295, 25.359)),
    (125006, (2.290, 11.913, 29.089)),
    (835148, (7.198, 17.415, 24.917)),
    (605532, (1.682, 16.894, 21.584)),
    (202937, (8.837, 15.270, 21.947)),
    (637208, (1.413, 16.002, 24.331)),
    (944553, (5.804, 12.343, 28.501)),
    (534197, (6.758, 17.844, 29.690)),
    (874222, (4.586, 11.298, 20.218)),
    (247939, (9.131, 18.237, 25.529)),
    (895404, (9.548, 18.656, 27.630)),
    (600606, (2.094, 10.541, 27.400)),
    (909730, (0.478, 19.815, 25.884)),
    (98689, (5.473, 11.872, 20.711)),
    (671527, (6.949, 16.736, 28.010)),
    (59695, (5.002, 19.900, 20.198)),
    (363630, (5.461, 18.504, 29.082)),
    (985489, (2.910, 12.508, 27.845)),
    (821501, (1.347, 12.593, 26.767)),
    (61907, (7.373, 14.064, 21.913)),
    (662067, (5.451, 10.325, 25.860)),
    (239848, (5.752, 12.245, 25.994)),
    (264560, (3.108, 12.423, 22.905)),
    (598291, (4.578, 19.147, 27.237)),
    (689209, (2.476, 14.377, 28.330)),
    (81008, (6.211, 10.044, 21.036)),
    (625141, (0.647, 16.716, 20.199)),
    (270642, (8.709, 18.376, 25.021)),
    (340905, (1.583, 10.607, 29.698)),
    (22711, (5.386, 19.285, 27.026)),
    (913457, (9.483, 10.087, 26.007)),
    (649026, (1.831, 16.690, 21.851)),
    (615918, (8.774, 17.781, 27.721)),
    (871985, (2.736, 19.709, 23.561)),
    (707602, (7.538, 10.042, 28.567)),
    (707447, (6.440, 18.843, 28.015)),
    (649052, (1.850, 10.589, 20.652)),
    (428712, (5.837, 10.751, 23.155)),
    (509091, (0.827, 18.609, 22.989)),
    (961460, (8.228, 11.783, 21.735)),
    (467323, (0.634, 19.933, 24.244)),
    (484484, (2.881, 14.876, 27.076)),
    (549714, (6.817, 19.838, 22.671)),
    (490017, (3.187, 18.073, 20.673)),
    (636135, (2.191, 13.023, 23.044)),
    (683542, (3.636, 11.062, 21.383)),
    (933174, (4.858, 15.479, 26.273)),
    (52138, (0.395, 14.668, 24.383)),
    (723063, (6.886, 15.316, 20.539)),
    (362421, (0.726, 11.599, 21.927)),
    (886727, (9.387, 15.491, 26.283)),
    (153400, (6.761, 19.611, 24.091)),
    (709004, (7.276, 11.366, 23.829)),
    (50284, (7.686, 13.065, 20.296)),
    (872615, (1.098, 10.087, 28.400)),
    (998252, (9.140, 18.079, 23.284)),
    (519291, (2.746, 18.907, 29.128)),
    (212201, (9.126, 15.222, 22.251)),
    (451932, (4.294, 15.751, 25.538)),
    (381677, (0.254, 11.174, 28.215)),
    (210356, (1.628, 14.642, 23.161)),
    (465238, (1.482, 13.402, 24.355)),
    (173453, (5.695, 19.323, 27.185)),
    (443066, (1.314, 18.466, 28.793)),
    (532212, (0.310, 13.498, 22.124)),
    (158445, (1.594, 17.121, 25.247)),
    (376588, (9.003, 14.935, 29.285)),
    (814515, (9.389, 12.111, 24.665)),
    (728509, (2.839, 14.460, 28.338)),
    (53774, (7.954, 13.000, 29.049)),
    (759950, (3.426, 14.760, 22.978)),
    (978703, (0.582, 16.883, 21.904)),
    (935274, (7.600, 17.796, 28.892)),
    (333012, (0.982, 12.905, 28.150)),
    (985196, (8.018, 13.073, 24.823)),
    (425507, (6.373, 13.638, 27.567)),
    (815086, (3.756, 17.088, 29.423)),
    (104400, (8.710, 10.042, 26.341)),
    (159670, (8.951, 19.624, 23.674)),
    (177412, (6.580, 13.992, 21.114)),
    (924890, (6.095, 14.414, 21.616)),
    (645945, (6.473, 19.837, 22.903)),
    (933828, (1.650, 19.631, 26.156)),
    (517488, (7.154, 14.030, 24.145)),
    (110766, (5.249, 17.881, 25.929)),
    (838193, (0.599, 12.352, 21.139)),
    (238368, (2.213, 17.971, 24.287)),
    (779201, (7.590, 19.498, 26.686)),
    (690249, (2.661, 18.550, 21.632)),
    (182207, (2.515, 14.028, 20.599)),
    (433523, (2.638, 13.288, 20.348)),
    (851873, (9.548, 16.068, 25.340)),
    (594225, (2.516, 15.378, 28.550)),
    (493634, (1.998, 16.635, 22.292)),
    (27677, (1.599, 16.478, 22.354)),
    (746406, (3.980, 18.937, 20.718)),
    (819767, (7.860, 11.903, 28.661)),
    (106604, (9.187, 10.651, 21.343)),
    (687241, (3.202, 16.657, 20.465)),
    (976289, (5.395, 16.658, 23.577)),
    (39769, (1.645, 14.937, 26.329)),
    (789738, (3.489, 13.842, 27.902)),
    (175632, (4.425, 12.525, 26.361)),
    (732632, (0.091, 18.282, 23.831)),
    (524777, (7.503, 14.633, 22.699)),
    (386241, (8.155, 12.153, 25.994)),
    (330767, (1.789, 12.544, 21.492)),
    (247661, (3.375, 13.468, 22.056)),
    (832413, (5.097, 15.507, 29.905)),
    (747306, (4.248, 13.230, 23.480)),
    (395639, (0.599, 13.984, 23.270)),
    (306401, (5.705, 12.348, 27.627)),
    (78789, (3.862, 12.875, 22.293)),
    (458116, (5.707, 12.568, 23.596)),
    (26951, (2.390, 19.641, 26.288)),
    (572085, (4.296, 19.417, 26.656)),
    (346932, (9.562, 16.930, 26.571)),
    (708603, (6.970, 17.459, 28.554)),
    (669517, (9.801, 18.701, 27.012)),
    (971101, (8.464, 16.947, 21.186)),
    (694607, (6.484, 17.678, 28.750)),
    (780155, (1.709, 15.473, 22.131)),
    (348581, (7.419, 12.513, 26.481)),
    (986915, (0.576, 15.134, 28.073)),
    (786417, (2.938, 18.511, 29.581)),
    (653456, (2.372, 11.987, 26.320)),
    (690648, (9.228, 17.763, 25.266)),
    (607939, (0.538, 14.671, 23.279)),
    (73260, (8.126, 12.952, 23.157)),
    (563862, (1.500, 19.318, 22.593)),
    (877187, (0.651, 13.882, 21.957)),
    (642265, (7.461, 16.158, 25.819)),
    (127043, (3.265, 13.042, 28.632)),
    (84831, (9.924, 13.859, 29.013)),
    (669869, (5.273, 19.819, 21.604)),
    (341572, (0.771, 18.469, 27.454)),
    (805038, (5.015, 17.706, 22.307)),
    (22254, (5.687, 11.400, 20.602)),
    (652890, (8.773, 12.522, 21.177)),
    (617358, (4.918, 15.939, 25.606)),
    (623536, (3.946, 10.302, 27.125)),
    (147509, (6.344, 17.207, 29.428)),
    (60137, (5.788, 19.443, 20.101)),
    (665361, (3.798, 16.098, 24.636)),
    (231917, (4.428, 18.339, 21.390)),
    (157492, (8.400, 13.625, 25.496)),
    (6534, (2.232, 12.665, 22.397)),
    (556027, (7.683, 14.550, 29.558)),
    (416808, (7.205, 18.511, 27.704)),
    (967771, (8.854, 16.840, 21.641)),
    (964141, (7.993, 18.549, 20.225)),
    (567581, (8.157, 18.377, 20.414)),
    (54060, (2.830, 11.412, 28.102)),
    (242866, (6.457, 15.559, 22.441)),
    (494871, (1.282, 15.320, 22.661)),
    (502462, (9.370, 10.771, 24.149)),
    (67843, (6.144, 10.471, 28.989)),
    (251781, (8.292, 18.426, 22.045)),
    (527660, (3.345, 19.152, 29.386)),
    (519521, (3.438, 18.307, 26.528)),
    (671157, (2.105, 15.993, 29.743)),
    (114048, (7.246, 13.951, 22.732)),
    (445406, (2.120, 19.983, 28.365)),
    (641728, (8.585, 13.587, 21.953)),
    (906095, (0.656, 14.621, 25.050)),
    (56599, (2.508, 18.020, 22.322)),
    (889279, (1.822, 19.079, 29.570)),
    (908368, (7.184, 15.700, 26.537)),
    (50821, (2.048, 16.427, 29.531)),
    (216097, (2.704, 13.994, 27.087)),
    (449642, (1.082, 19.439, 29.987)),
    (434336, (7.755, 16.225, 23.857)),
    (10812, (0.282, 10.705, 26.588)),
    (563678, (9.420, 19.586, 28.183)),
    (379573, (0.496, 19.948, 28.279)),
    (878617, (5.900, 18.014, 24.889)),
    (410123, (7.567, 11.810, 24.199)),
    (628068, (5.225, 10.807, 28.969)),
    (648223, (8.066, 11.526, 21.157)),
    (31780, (3.985, 19.804, 25.585)),
    (634168, (6.494, 16.884, 28.622)),
    (493495, (8.329, 16.570, 21.298)),
    (100454, (3.071, 15.563, 20.381)),
    (957287, (5.278, 16.277, 21.957)),
    (674657, (7.236, 15.806, 26.987)),
    (127663, (7.806, 11.456, 23.704)),
    (910721, (3.430, 19.507, 22.738)),
    (986049, (3.630, 18.906, 24.567)),
    (296812, (7.384, 10.968, 26.934)),
    (942716, (8.891, 14.107, 23.606)),
    (639403, (0.841, 10.858, 29.481)),
    (925059, (8.065, 14.465, 24.867)),
    (967437, (5.142, 19.862, 26.263)),
    (309382, (6.014, 15.061, 29.093)),
    (662260, (7.133, 18.767, 24.898)),
    (950987, (5.650, 15.452, 22.662)),
    (871336, (1.868, 13.481, 22.478)),
    (679467, (0.713, 16.335, 24.497)),
    (517490, (6.500, 13.520, 22.119)),
    (531849, (4.439, 17.326, 25.116)),
    (482302, (6.691, 10.799, 20.569)),
    (214072, (6.987, 17.836, 27.738)),
    (729103, (4.216, 18.792, 25.656)),
    (562760, (7.535, 15.914, 23.454)),
    (307509, (1.967, 11.120, 22.012)),
    (304068, (1.296, 12.637, 29.963)),
    (594627, (9.243, 14.784, 28.979)),
    (827281, (7.515, 13.222, 28.027)),
    (13755, (7.469, 18.230, 26.103)),
    (685308, (7.853, 15.828, 26.487)),
    (728320, (9.472, 14.691, 23.419)),
    (192299, (0.909, 10.118, 28.455)),
    (327455, (8.307, 10.126, 22.250)),
    (786999, (5.723, 12.709, 21.874)),
    (345381, (9.332, 15.707, 21.418)),
    (584117, (4.211, 19.261, 22.230)),
    (433507, (8.777, 16.115, 26.268)),
    (834384, (1.403, 13.835, 23.014)),
    (185685, (6.201, 19.706, 28.168)),
    (280752, (0.855, 12.646, 21.747)),
    (310695, (9.444, 11.063, 23.390)),
    (523286, (6.918, 17.500, 21.277)),
    (391207, (4.225, 18.318, 25.990)),
    (44767, (8.260, 10.754, 26.299)),
    (684951, (1.153, 18.778, 28.711)),
    (622591, (5.241, 13.152, 24.766)),
    (891079, (8.692, 10.481, 25.181)),
    (637279, (5.888, 18.343, 28.629)),
    (963386, (8.600, 12.555, 22.922)),
    (704865, (9.197, 14.845, 20.972)),
    (879608, (0.178, 17.728, 25.382)),
    (182728, (8.064, 18.915, 24.323)),
    (144904, (2.677, 11.353, 29.443)),
    (852251, (9.896, 13.061, 27.853)),
    (593887, (4.185, 13.623, 27.545)),
    (442528, (7.580, 14.887, 28.607)),
    (180949, (3.922, 15.620, 26.205)),
    (19975, (9.264, 16.650, 21.517)),
    (59330, (9.504, 18.861, 24.039)),
    (174845, (1.234, 14.554, 21.254)),
    (256899, (7.098, 17.197, 28.849)),
    (991224, (5.591, 17.140, 24.234)),
    (118137, (0.459, 19.142, 23.397)),
    (163233, (4.641, 12.628, 24.241)),
    (552382, (3.118, 10.272, 26.311)),
    (194763, (8.798, 12.024, 21.150)),
    (66651, (7.722, 15.756, 23.036)),
    (26612, (8.488, 10.868, 24.591)),
    (425690, (3.036, 14.948, 23.397)),
    (158392, (8.710, 19.119, 29.895)),
    (115345, (9.696, 10.316, 26.669)),
    (756841, (7.794, 17.137, 28.391)),
    (745955, (0.490, 18.025, 23.139)),
    (924483, (2.750, 13.215, 28.067)),
    (889693, (1.702, 15.619, 23.445)),
    (996512, (4.689, 11.639, 29.980)),
    (791662, (8.315, 17.995, 26.910)),
    (689055, (4.095, 14.008, 27.218)),
    (196068, (0.608, 13.898, 23.394)),
    (326644, (0.740, 11.153, 25.018)),
    (936935, (8.954, 15.963, 20.053)),
    (155677, (6.265, 13.911, 20.050)),
    (384100, (2.426, 18.658, 25.677)),
    (125769, (7.865, 15.852, 25.713)),
    (253037, (6.316, 15.458, 21.584)),
    (278625, (4.165, 18.267, 26.449)),
    (58435, (0.173, 15.493, 21.180)),
    (578323, (0.702, 15.487, 27.448)),
    (323500, (7.255, 18.913, 21.873)),
    (362691, (2.685, 16.876, 23.853)),
    (696656, (4.873, 10.991, 22.771)),
    (855798, (0.161, 11.114, 22.700)),
    (737382, (6.626, 15.160, 21.865)),
    (268152, (3.968, 18.615, 28.961)),
    (885737, (7.782, 18.428, 24.546)),
    (488847, (8.087, 12.227, 23.489)),
    (176448, (9.869, 13.856, 28.798)),
    (87375, (8.394, 11.552, 27.702)),
    (219206, (5.564, 17.948, 21.302)),
    (87832, (7.079, 12.057, 22.441)),
    (934170, (7.461, 14.520, 25.238)),
    (566564, (0.890, 18.932, 24.983)),
    (632164, (6.627, 12.690, 21.041)),
    (967535, (9.338, 19.774, 29.881)),
    (263590, (9.150, 10.664, 27.065)),
    (198899, (1.651, 17.215, 22.097)),
    (850992, (3.824, 12.037, 23.605)),
    (218728, (0.244, 15.720, 21.020)),
    (995008, (0.257, 16.615, 20.102)),
    (35804, (5.097, 18.546, 23.750)),
    (621022, (7.195, 17.584, 24.366)),
    (353722, (2.858, 16.277, 25.626)),
    (921397, (1.257, 10.597, 27.794)),
    (42864, (5.331, 13.665, 28.184)),
    (327704, (1.580, 14.277, 23.399)),
    (656546, (2.649, 13.819, 25.440)),
    (115832, (6.201, 19.105, 23.127)),
    (505390, (4.541, 13.093, 22.718)),
    (718945, (3.157, 12.423, 25.317)),
    (102736, (6.747, 11.486, 26.958)),
    (791961, (7.052, 17.233, 23.508)),
    (351900, (4.046, 12.722, 27.768)),
    (521264, (2.387, 13.851, 26.819)),
    (149867, (5.194, 14.111, 20.975)),
    (234241, (8.487, 19.241, 28.463)),
    (452022, (0.307, 14.198, 21.781)),
    (729526, (5.763, 14.340, 22.733)),
    (494555, (4.316, 10.442, 27.219)),
    (911121, (3.592, 14.472, 26.420)),
    (299718, (8.867, 14.685, 25.146)),
    (35808, (5.214, 14.331, 26.176)),
    (1945, (2.367, 11.241, 28.183)),
    (563309, (2.991, 18.070, 29.967)),
    (373376, (3.530, 15.775, 26.722)),
    (886354, (3.184, 10.492, 22.350)),
    (254584, (7.642, 15.042, 23.593)),
    (180078, (2.035, 10.452, 22.992)),
    (761428, (7.323, 16.676, 29.345)),
    (68121, (1.332, 10.956, 23.651)),
    (136863, (1.922, 10.191, 27.071)),
    (847571, (7.850, 14.930, 29.018)),
    (197099, (2.715, 17.440, 21.929)),
    (195443, (0.798, 13.975, 20.921)),
    (64752, (1.862, 14.190, 25.224)),
    (956655, (4.265, 16.072, 29.507)),
    (180642, (8.615, 12.664, 22.262)),
    (740279, (2.542, 15.935, 22.826)),
    (519653, (1.647, 19.925, 21.678)),
    (617960, (9.511, 19.987, 22.079)),
    (914915, (7.210, 17.397, 27.000)),
    (927272, (2.821, 10.681, 28.784)),
    (981596, (5.044, 17.635, 20.374)),
    (942682, (2.992, 11.218, 27.976)),
    (975212, (7.207, 17.194, 20.108)),
    (290438, (5.961, 12.153, 20.326)),
    (798357, (1.323, 15.164, 24.735)),
    (349032, (7.790, 11.624, 26.684)),
    (645915, (9.418, 15.666, 26.630)),
    (879456, (4.919, 10.241, 23.695)),
    (449652, (1.118, 19.132, 24.019)),
    (421033, (6.959, 19.593, 25.443)),
    (925015, (0.632, 15.393, 25.114)),
    (738859, (6.636, 18.025, 23.517)),
    (975583, (5.896, 10.610, 21.503)),
    (353866, (7.900, 10.125, 25.818)),
    (461624, (3.763, 11.391, 29.768)),
    (736860, (8.112, 15.682, 25.028)),
    (20185, (0.862, 10.299, 20.355)),
    (77932, (5.137, 18.447, 20.268)),
    (736108, (6.216, 16.516, 21.583)),
    (700574, (2.138, 10.126, 22.084)),
    (207051, (3.256, 18.761, 24.212)),
    (951198, (8.659, 19.929, 23.631)),
    (349826, (3.939, 12.028, 25.350)),
    (762176, (6.424, 15.796, 27.930)),
    (601968, (6.009, 10.877, 25.069)),
    (549666, (4.660, 10.526, 25.043)),
    (33705, (7.485, 18.666, 24.761)),
    (385794, (4.783, 12.719, 21.464)),
    (627510, (2.738, 11.901, 27.177)),
    (629987, (3.643, 16.012, 22.672)),
    (958231, (2.333, 17.550, 26.685)),
    (187429, (7.695, 19.578, 28.338)),
    (658016, (4.857, 10.105, 29.404)),
    (743245, (1.048, 17.793, 21.241)),
    (226873, (8.328, 18.090, 25.775)),
    (706520, (4.249, 11.595, 24.409)),
    (386032, (4.210, 11.762, 20.760)),
    (948313, (6.079, 17.688, 24.579)),
    (124503, (2.169, 18.524, 28.891)),
    (502289, (4.728, 17.039, 20.380)),
    (938770, (8.827, 10.275, 22.502)),
    (283800, (2.739, 15.921, 28.577)),
    (760773, (3.769, 19.100, 23.225)),
    (635006, (8.233, 17.380, 23.072)),
    (860064, (9.925, 16.022, 26.979)),
    (330279, (8.829, 17.958, 23.549)),
    (882319, (5.743, 12.743, 29.279)),
    (559172, (6.023, 18.384, 25.757)),
    (325014, (2.470, 11.829, 22.280)),
    (406436, (4.619, 17.632, 25.026)),
    (462746, (2.130, 11.153, 20.193)),
    (133797, (9.196, 18.515, 25.339)),
    (116329, (3.188, 17.874, 26.051)),
    (733952, (6.854, 16.530, 21.597)),
    (538539, (5.845, 19.055, 20.848)),
    (436413, (7.161, 19.534, 20.600)),
    (708242, (3.285, 17.392, 24.532)),
    (713620, (3.646, 13.334, 28.703)),
    (120344, (2.954, 16.774, 21.807)),
    (478929, (6.992, 16.091, 21.641)),
    (713116, (7.885, 16.421, 29.778)),
    (439557, (1.172, 14.099, 20.030)),
    (981892, (6.439, 11.287, 25.819)),
    (696724, (5.480, 15.775, 25.774)),
    (630437, (4.298, 16.965, 28.367)),
    (550848, (9.671, 15.533, 26.189)),
    (548103, (2.226, 16.050, 28.317)),
    (795783, (7.379, 14.215, 22.506)),
    (336578, (8.194, 13.957, 22.550)),
    (306764, (9.591, 12.531, 21.941)),
    (28397, (5.339, 11.499, 21.426)),
    (522845, (1.258, 17.646, 29.687)),
    (367405, (5.075, 14.924, 21.996)),
    (813343, (1.211, 19.070, 26.489)),
    (179545, (7.864, 18.074, 28.059)),
    (104385, (8.373, 17.773, 20.678)),
    (270351, (3.690, 10.717, 27.181)),
    (600701, (0.103, 18.268, 22.688)),
    (213966, (2.721, 13.137, 28.567)),
    (29823, (3.631, 16.024, 27.449)),
    (381499, (2.370, 11.416, 27.119)),
    (241520, (8.144, 17.109, 27.801)),
    (808681, (2.766, 13.190, 24.907)),
    (136097, (4.367, 19.698, 21.909)),
    (28472, (2.456, 13.614, 24.294)),
    (762737, (7.323, 17.180, 28.390)),
    (153540, (0.007, 15.462, 28.102)),
    (957913, (3.878, 16.231, 22.214)),
    (552806, (0.533, 16.035, 20.651)),
    (494702, (4.079, 13.152, 29.760)),
    (781437, (7.226, 18.398, 26.003)),
    (969762, (6.136, 10.505, 21.493)),
    (2869, (5.074, 18.671, 28.343)),
    (7473, (4.986, 19.634, 25.221)),
    (825531, (3.165, 16.175, 25.271)),
    (759183, (3.913, 13.297, 24.201)),
    (681316, (0.048, 13.734, 26.000)),
    (618154, (5.787, 18.596, 23.149)),
    (493142, (0.937, 19.908, 25.450)),
    (232595, (8.665, 13.272, 24.718)),
    (884851, (5.717, 13.083, 27.439)),
    (618397, (7.260, 18.545, 20.458)),
    (517261, (9.617, 17.199, 27.788)),
    (764218, (2.654, 16.168, 29.898)),
    (542582, (0.120, 10.677, 24.644)),
    (847197, (1.410, 14.154, 27.801)),
    (868926, (0.489, 12.639, 25.753)),
    (993167, (3.289, 11.066, 21.430)),
    (95052, (8.684, 15.662, 26.507)),
    (151528, (2.085, 19.250, 21.707)),
    (336773, (6.603, 17.419, 24.674)),
    (180760, (1.760, 13.832, 24.225)),
    (242786, (5.509, 14.959, 21.972)),
    (181351, (8.445, 16.524, 27.199)),
    (923609, (8.047, 19.763, 29.283)),
    (279964, (8.341, 18.523, 22.603)),
    (245093, (6.061, 18.182, 27.412)),
    (599334, (4.120, 10.605, 20.428)),
    (746262, (0.724, 19.095, 28.126)),
    (933957, (0.739, 10.161, 21.379)),
    (189785, (4.691, 15.066, 26.325)),
    (833807, (3.452, 13.411, 26.555)),
    (478996, (1.996, 18.669, 27.866)),
    (323347, (2.677, 17.776, 24.988)),
    (261906, (7.150, 16.975, 25.743)),
    (410719, (1.332, 19.113, 28.983)),
    (104534, (8.656, 13.625, 26.605)),
    (460879, (6.828, 11.986, 22.895)),
    (686246, (5.119, 16.763, 20.404)),
    (558637, (8.574, 17.363, 21.979)),
    (585283, (4.409, 19.681, 27.812)),
    (839455, (5.862, 14.385, 20.229)),
    (856425, (1.225, 17.657, 28.010)),
    (12787, (7.908, 13.272, 25.420)),
    (272792, (5.617, 11.134, 27.574)),
    (131458, (2.587, 12.894, 27.516)),
    (428720, (5.521, 14.548, 29.511)),
    (807273, (1.073, 15.881, 26.994)),
    (165257, (8.244, 16.304, 27.966)),
    (233893, (4.143, 12.762, 29.088)),
    (830549, (3.497, 13.002, 29.907)),
    (280355, (2.901, 15.972, 24.339)),
    (814402, (8.480, 15.674, 22.697)),
    (65255, (6.117, 14.682, 22.517)),
    (863884, (7.571, 17.031, 23.633)),
    (159680, (8.370, 10.164, 22.036)),
    (300407, (4.349, 18.094, 26.604)),
    (942023, (9.868, 12.578, 23.147)),
    (451506, (0.308, 19.726, 29.162)),
    (87326, (1.273, 14.936, 24.875)),
    (644394, (4.739, 14.598, 25.704)),
    (757839, (9.787, 11.206, 21.492)),
    (379855, (2.292, 13.105, 22.187)),
    (976030, (4.078, 19.165, 26.695)),
    (927468, (4.108, 14.405, 21.133)),
    (702499, (2.877, 19.488, 25.231)),
    (901555, (9.848, 19.670, 25.436)),
    (56652, (0.918, 16.234, 21.330)),
    (93145, (6.780, 12.308, 23.867)),
    (399246, (9.637, 14.803, 21.765)),
    (553981, (2.901, 10.715, 20.917)),
    (596803, (8.784, 18.710, 24.497)),
    (912844, (2.632, 18.681, 27.025)),
    (422809, (2.698, 12.184, 26.165)),
    (588732, (6.223, 15.555, 22.497)),
    (215702, (2.353, 11.628, 22.005)),
    (742630, (9.891, 10.103, 27.482)),
    (981260, (3.370, 14.473, 24.492)),
    (670305, (2.528, 15.951, 26.911)),
    (709310, (6.255, 19.417, 26.688)),
    (425026, (1.802, 16.482, 29.957)),
    (108524, (4.291, 16.516, 24.973)),
    (744499, (2.101, 11.805, 28.743)),
    (824585, (9.688, 16.723, 26.408)),
    (678548, (2.157, 18.323, 24.174)),
    (335421, (2.520, 15.906, 23.697)),
    (775020, (1.276, 14.308, 26.528)),
    (975515, (8.538, 16.029, 20.840)),
    (433283, (8.708, 14.028, 27.873)),
    (73797, (2.096, 10.210, 26.539)),
    (773571, (1.914, 17.500, 24.955)),
    (803844, (0.809, 19.354, 26.950)),
    (294718, (5.368, 12.956, 28.302)),
    (538110, (0.181, 10.141, 23.223)),
    (856759, (0.443, 16.837, 24.939)),
    (984975, (0.939, 11.875, 29.919)),
    (994963, (7.717, 13.221, 28.084)),
    (469913, (9.368, 11.247, 22.660)),
    (845951, (0.826, 14.469, 24.460)),
    (720506, (9.953, 17.958, 25.596)),
    (670830, (9.149, 16.447, 27.803)),
    (444015, (7.091, 18.438, 27.979)),
    (291893, (6.882, 18.852, 27.274)),
    (374838, (1.052, 14.346, 23.855)),
    (862396, (5.682, 18.176, 20.819)),
    (302029, (4.485, 13.877, 24.619)),
    (583772, (3.940, 17.801, 20.003)),
    (451985, (3.813, 12.231, 21.244)),
    (938025, (5.999, 12.259, 28.223)),
    (4, (4.829, 18.341, 25.053)),
    (280242, (7.481, 19.307, 21.254)),
    (114128, (2.671, 13.745, 24.841)),
    (549307, (8.221, 10.228, 29.504)),
    (123399, (3.340, 16.196, 25.777)),
    (569401, (5.291, 17.337, 26.271)),
    (15489, (4.971, 14.104, 28.374)),
    (515700, (8.916, 11.503, 22.058)),
    (640088, (2.690, 11.841, 23.198)),
    (799726, (7.553, 16.656, 20.560)),
    (491173, (8.781, 10.070, 24.060)),
    (898271, (0.390, 14.727, 29.706)),
    (826683, (5.587, 19.465, 22.885)),
    (836899, (5.814, 10.297, 29.350)),
    (136775, (3.158, 12.698, 21.561)),
    (877357, (2.772, 13.314, 24.053)),
    (608524, (9.865, 19.476, 27.759)),
    (811062, (9.302, 17.726, 26.744)),
    (227648, (9.539, 12.461, 21.043)),
    (998755, (5.161, 16.224, 25.107)),
    (101929, (2.740, 11.090, 21.662)),
    (542816, (3.286, 19.745, 29.041)),
    (870254, (0.118, 12.432, 28.703)),
    (348647, (7.900, 11.365, 24.552)),
    (605044, (2.114, 11.697, 27.918)),
    (26093, (5.219, 17.254, 29.654)),
    (144702, (4.118, 17.484, 28.004)),
    (409041, (1.726, 13.929, 25.601)),
    (556134, (4.992, 10.280, 27.998)),
    (499902, (7.501, 17.518, 28.244)),
    (902465, (3.560, 12.172, 21.353)),
    (12073, (2.237, 18.965, 29.788)),
    (841141, (4.234, 17.545, 20.135)),
    (607231, (1.411, 10.550, 25.374)),
    (697428, (8.559, 14.126, 23.173)),
    (946798, (5.960, 17.678, 24.103)),
    (563654, (2.457, 14.442, 23.919)),
    (708371, (8.335, 13.240, 22.819)),
    (78411, (1.070, 10.975, 27.959)),
    (502730, (4.818, 15.370, 22.188)),
    (243820, (4.462, 19.786, 29.957)),
    (262416, (2.020, 16.530, 22.963)),
    (830811, (9.784, 19.735, 20.295)),
    (638490, (9.080, 10.652, 24.646)),
    (940126, (1.482, 10.227, 24.417)),
    (363140, (3.958, 18.339, 29.132)),
    (285311, (0.535, 11.299, 24.735)),
    (982125, (2.051, 10.077, 23.678)),
    (266355, (6.080, 14.269, 20.681)),
    (932075, (8.618, 13.372, 29.517)),
    (993517, (8.545, 19.875, 29.984)),
    (89851, (8.411, 13.009, 23.841)),
    (664307, (6.907, 17.501, 23.231)),
    (31832, (8.253, 10.559, 23.072)),
    (3350, (1.507, 18.899, 20.104)),
    (808838, (5.654, 10.148, 29.745)),
    (595046, (5.069, 11.026, 29.666)),
    (458904, (1.692, 13.331, 22.399)),
    (330572, (0.435, 19.814, 26.761)),
    (473671, (8.379, 14.532, 22.987)),
    (875270, (8.491, 15.453, 24.334)),
    (607668, (8.054, 13.149, 24.430)),
    (718494, (8.959, 18.698, 20.430)),
    (978552, (0.694, 10.564, 25.517)),
    (506399, (0.296, 12.517, 24.986)),
    (221366, (0.250, 12.412, 21.744)),
    (435364, (0.850, 12.433, 25.215)),
    (61519, (1.095, 16.700, 28.769)),
    (602783, (2.799, 12.054, 21.889)),
    (763994, (7.215, 18.983, 21.540)),
    (767492, (4.084, 14.748, 28.260)),
    (429441, (4.793, 17.244, 28.793)),
    (764988, (8.486, 18.131, 24.994)),
    (856918, (5.607, 15.456, 22.533)),
    (86169, (8.498, 18.923, 20.320)),
    (91142, (3.047, 14.391, 28.946)),
    (436838, (5.674, 17.672, 20.029)),
    (773327, (6.464, 13.928, 28.365)),
    (54910, (6.093, 10.073, 24.040)),
    (640504, (7.443, 13.057, 26.025)),
    (167176, (5.581, 11.804, 28.919)),
    (875110, (5.912, 18.146, 25.509)),
    (676591, (2.685, 15.072, 25.820)),
    (678621, (3.064, 13.840, 20.311)),
    (683132, (7.003, 14.496, 21.897)),
    (502716, (4.574, 11.731, 27.391)),
    (331125, (7.439, 17.576, 25.800)),
    (531620, (6.039, 11.412, 20.977)),
    (206509, (4.962, 12.008, 25.534)),
    (499130, (3.132, 13.077, 29.978)),
    (436653, (4.960, 12.169, 21.772)),
    (245184, (3.750, 12.960, 21.375)),
    (908106, (1.748, 17.359, 26.164)),
    (309682, (3.695, 12.794, 29.703)),
    (594586, (8.793, 15.216, 21.728)),
    (760047, (9.377, 15.219, 23.446)),
    (823095, (3.505, 14.591, 24.686)),
    (261022, (8.693, 13.503, 23.675)),
    (822217, (6.139, 19.913, 23.207)),
    (318933, (8.408, 14.462, 20.908)),
    (151607, (8.226, 19.130, 29.890)),
    (622788, (9.729, 12.709, 28.741)),
    (337345, (7.565, 19.735, 25.576)),
    (600298, (7.934, 13.415, 21.059)),
    (152737, (4.018, 17.319, 20.686)),
    (290253, (7.224, 12.509, 25.502)),
    (195019, (4.729, 14.030, 20.701)),
    (24146, (4.931, 15.278, 25.791)),
    (316159, (0.175, 12.550, 23.954)),
    (722487, (3.194, 13.145, 22.511)),
    (756771, (9.616, 15.573, 25.549)),
    (605277, (1.049, 15.178, 23.029)),
    (775466, (5.382, 18.752, 28.992)),
    (857455, (4.113, 14.013, 26.807)),
    (448308, (4.793, 17.055, 26.229)),
    (501137, (4.580, 15.455, 26.200)),
    (153148, (9.647, 19.550, 25.794)),
    (316710, (8.417, 16.401, 20.192)),
    (872571, (3.874, 14.771, 26.656)),
    (129806, (0.239, 10.103, 23.548)),
    (437580, (2.776, 14.336, 28.542)),
    (567757, (8.564, 12.790, 29.304)),
    (557221, (2.653, 14.755, 29.931)),
    (138566, (9.379, 17.373, 22.834)),
    (88855, (0.812, 18.968, 20.801)),
    (26500, (8.663, 15.683, 20.546)),
    (113965, (5.934, 15.983, 29.290)),
    (180226, (7.819, 13.513, 27.518)),
    (652771, (1.046, 18.046, 28.965)),
    (107691, (4.417, 11.296, 25.092)),
    (729361, (2.798, 10.803, 23.417)),
    (976074, (2.606, 16.226, 20.891)),
    (672333, (3.193, 12.530, 28.485)),
    (109866, (9.897, 15.496, 25.090)),
    (480588, (5.269, 18.006, 29.667)),
    (272137, (9.839, 11.093, 20.306)),
    (580105, (8.367, 10.491, 26.419)),
    (538455, (8.726, 10.001, 29.221)),
    (852634, (0.977, 15.844, 25.851)),
    (521418, (2.878, 19.143, 25.497)),
    (549127, (6.639, 18.241, 29.899)),
    (175732, (8.122, 16.799, 20.419)),
    (258776, (3.593, 14.588, 29.470)),
    (101939, (4.116, 15.083, 29.921)),
    (654287, (8.559, 15.208, 26.562)),
    (837197, (4.467, 19.764, 27.282)),
    (15455, (3.988, 17.711, 24.625)),
    (862514, (9.823, 10.278, 27.259)),
    (134160, (8.772, 13.162, 21.621)),
    (985224, (5.913, 16.150, 24.230)),
    (433950, (7.752, 18.640, 25.118)),
    (703021, (5.715, 18.985, 29.397)),
    (14688, (8.355, 13.687, 27.664)),
    (147415, (7.037, 11.326, 28.468)),
    (314974, (2.267, 11.920, 29.793)),
    (478627, (0.031, 16.946, 24.537)),
    (212197, (5.143, 15.973, 21.757)),
    (308456, (9.168, 15.759, 24.621)),
    (155343, (4.196, 14.223, 22.118)),
    (722822, (9.363, 15.187, 24.171)),
    (498844, (7.417, 18.621, 23.777)),
    (707952, (2.028, 10.763, 26.836)),
    (270265, (5.094, 14.877, 25.575)),
    (323542, (2.493, 13.322, 23.797)),
    (277315, (4.575, 12.327, 23.151)),
    (81432, (4.036, 16.433, 27.217)),
    (180228, (5.162, 14.578, 27.435)),
    (272746, (5.730, 17.127, 24.338)),
    (794748, (5.620, 15.328, 20.743)),
    (716779, (6.443, 17.804, 29.585)),
    (784651, (5.873, 19.794, 22.292)),
    (991550, (5.084, 12.219, 25.350)),
    (286182, (4.602, 17.148, 20.159)),
    (541426, (1.833, 19.255, 20.806)),
    (692234, (9.352, 18.586, 29.895)),
    (703985, (0.800, 17.345, 25.515)),
    (756022, (6.087, 16.708, 28.665)),
    (481469, (6.140, 12.143, 29.592)),
    (755228, (5.435, 18.465, 28.678)),
    (287373, (6.464, 19.129, 21.394)),
    (938669, (6.964, 18.288, 20.106)),
    (864159, (8.291, 12.724, 28.285)),
    (624404, (0.726, 14.159, 26.354)),
    (915187, (9.507, 13.404, 25.478)),
    (900949, (4.004, 10.053, 28.170)),
    (552831, (7.259, 11.841, 23.318)),
    (802934, (9.971, 10.155, 20.290)),
    (57738, (9.642, 16.024, 21.200)),
    (500071, (8.161, 19.800, 23.743)),
    (551451, (2.686, 10.389, 27.720)),
    (499063, (4.652, 16.234, 28.969)),
    (331631, (4.460, 16.541, 21.442)),
    (100484, (8.662, 15.531, 28.348)),
    (152630, (2.883, 13.231, 25.273)),
    (953398, (3.486, 12.140, 20.397)),
    (798756, (5.434, 13.192, 24.324)),
    (144250, (0.598, 16.183, 28.867)),
    (213220, (7.592, 17.532, 24.242)),
    (990911, (5.828, 12.121, 22.821)),
    (225634, (1.474, 16.997, 20.806)),
    (945493, (6.175, 16.077, 28.532)),
    (62874, (6.540, 12.207, 21.458)),
    (982069, (0.393, 19.239, 22.947)),
    (477495, (9.628, 12.938, 23.458)),
    (866387, (1.507, 16.978, 22.784)),
    (71664, (8.648, 16.133, 25.775)),
    (446410, (3.669, 15.861, 23.445)),
    (94740, (3.591, 14.722, 20.792)),
    (866247, (3.089, 14.117, 21.101)),
    (255949, (8.453, 11.006, 27.787)),
    (920448, (1.368, 13.922, 24.542)),
    (207791, (4.148, 17.486, 29.616)),
    (665521, (5.317, 13.106, 28.312)),
    (752735, (2.829, 10.986, 29.424)),
    (422814, (6.584, 18.316, 29.263)),
    (433660, (1.207, 14.032, 27.163)),
    (822922, (4.939, 11.949, 25.714)),
    (214141, (3.219, 18.286, 29.454)),
    (60609, (5.054, 11.287, 27.879)),
    (395568, (3.399, 14.100, 21.856)),
    (806034, (3.903, 16.554, 24.895)),
    (889119, (6.715, 18.866, 29.246)),
    (494157, (7.850, 11.213, 28.682)),
    (718384, (1.954, 12.738, 23.692)),
    (267495, (3.026, 13.718, 22.327)),
    (486591, (2.918, 14.030, 22.117)),
    (982840, (6.753, 19.453, 28.539)),
    (633431, (1.227, 17.515, 27.405)),
    (743537, (2.951, 19.456, 23.300)),
    (592912, (1.659, 17.805, 24.994)),
    (643904, (1.323, 10.671, 20.621)),
    (426796, (1.599, 10.701, 23.335)),
    (667674, (0.054, 13.972, 28.389)),
    (305398, (3.321, 19.139, 23.137)),
    (217474, (2.634, 17.483, 23.109)),
    (97127, (8.036, 19.474, 27.482)),
    (773287, (1.764, 10.670, 29.943)),
    (461916, (6.320, 11.231, 24.904)),
    (733697, (6.352, 16.393, 28.314)),
    (131634, (4.623, 10.792, 26.024)),
    (252209, (6.545, 15.370, 21.959)),
    (175831, (2.942, 10.127, 25.376)),
    (561645, (7.754, 13.806, 25.853)),
    (177913, (6.025, 17.191, 26.940)),
    (621507, (0.494, 14.504, 26.936)),
    (160776, (2.600, 17.648, 23.297)),
    (498176, (9.529, 14.814, 27.594)),
    (91612, (1.412, 18.042, 27.805)),
    (148825, (9.855, 14.911, 26.742)),
    (31283, (8.418, 19.212, 26.030)),
    (872713, (4.636, 15.938, 23.781)),
    (43472, (0.305, 18.707, 28.999)),
    (448418, (5.944, 10.873, 28.365)),
    (78471, (2.852, 11.235, 22.171)),
    (740583, (1.960, 16.524, 21.376)),
    (9103, (5.668, 19.531, 25.631)),
    (213838, (1.715, 10.123, 23.490)),
    (377868, (9.704, 19.869, 21.110)),
    (157787, (0.519, 13.949, 28.569)),
    (967754, (6.836, 18.461, 22.591)),
    (545026, (8.652, 11.754, 21.414)),
    (23119, (3.573, 11.111, 27.239)),
    (251047, (6.988, 13.566, 27.840)),
    (163972, (2.136, 14.782, 24.961)),
    (653533, (4.986, 14.820, 20.065)),
    (733674, (9.342, 13.582, 28.370)),
    (927239, (1.346, 11.245, 24.137)),
    (103777, (0.186, 10.817, 23.579)),
    (951662, (2.337, 13.398, 24.474)),
    (563498, (4.980, 16.045, 29.674)),
    (302071, (6.274, 15.019, 25.069)),
    (726100, (8.646, 12.167, 20.341)),
    (398977, (5.369, 18.180, 20.365)),
    (66124, (4.956, 18.693, 28.430)),
    (889480, (8.319, 10.844, 27.603)),
    (574394, (2.945, 10.119, 26.812)),
    (391703, (7.611, 12.926, 28.660)),
    (14668, (7.071, 14.533, 24.943)),
    (118361, (2.144, 13.054, 28.248)),
    (738293, (6.774, 14.083, 28.272)),
    (807959, (7.618, 13.796, 28.865)),
    (519744, (3.397, 19.339, 21.777)),
    (235798, (3.138, 12.943, 28.575)),
    (792559, (5.527, 12.114, 20.633)),
    (797555, (2.623, 14.757, 25.570)),
    (664420, (3.578, 18.222, 24.460)),
    (830753, (4.928, 19.542, 22.164)),
    (603147, (8.971, 16.381, 25.743)),
    (374066, (5.028, 12.095, 28.481)),
    (870037, (4.411, 11.855, 22.695)),
    (303559, (2.998, 17.076, 24.324)),
    (513266, (9.177, 10.381, 24.478)),
    (418216, (2.491, 17.627, 26.162)),
    (830537, (1.427, 18.098, 22.459)),
    (766986, (9.169, 16.980, 22.046)),
    (818303, (4.954, 19.175, 29.693)),
    (696406, (0.604, 19.731, 28.085)),
    (606064, (5.523, 17.435, 27.436)),
    (839363, (7.033, 10.507, 29.670)),
    (155262, (9.218, 15.477, 21.281)),
    (242053, (3.302, 11.758, 27.153)),
    (97046, (8.973, 18.563, 29.693)),
    (183945, (1.011, 18.343, 28.885)),
    (688630, (1.617, 13.077, 23.877)),
    (983507, (8.400, 18.424, 27.419)),
    (769667, (4.935, 16.777, 20.279)),
    (909934, (9.552, 13.668, 23.150)),
    (59290, (2.027, 10.651, 29.732)),
    (721596, (0.222, 12.991, 27.049)),
    (569601, (2.206, 17.052, 27.561)),
    (388706, (2.795, 11.377, 22.802)),
    (86092, (0.688, 12.110, 23.877)),
    (691282, (4.847, 19.904, 23.914)),
    (15177, (2.358, 15.212, 21.771)),
    (103161, (8.493, 14.385, 28.739)),
    (711650, (2.138, 10.526, 22.971)),
    (384501, (6.910, 15.251, 28.355)),
    (438017, (8.913, 19.094, 29.808)),
    (608186, (9.948, 11.796, 21.368)),
    (437903, (7.507, 12.049, 24.416)),
    (268913, (8.741, 15.634, 24.319)),
    (853890, (3.228, 14.927, 21.385)),
    (902700, (8.270, 19.858, 26.857)),
    (632233, (8.587, 18.258, 20.540)),
    (744564, (7.666, 17.979, 29.046)),
    (989340, (6.092, 16.852, 26.614)),
    (647950, (7.899, 12.714, 27.082)),
    (158597, (0.098, 11.042, 24.326)),
    (100728, (6.959, 18.218, 24.527)),
    (213208, (0.949, 15.414, 26.720)),
    (247365, (5.065, 13.990, 24.250)),
    (60662, (0.623, 13.079, 22.938)),
    (831973, (9.543, 11.837, 28.683)),
    (879394, (1.959, 11.316, 20.959)),
    (82570, (6.404, 19.273, 25.949)),
    (389642, (8.681, 15.544, 23.321)),
    (18490, (4.372, 16.145, 22.180)),
    (972566, (6.488, 15.561, 20.821)),
    (626245, (2.383, 18.700, 29.867)),
    (12321, (6.796, 18.323, 29.566)),
    (24762, (7.969, 13.847, 22.994)),
    (659212, (1.596, 16.872, 28.075)),
    (710263, (6.715, 15.455, 23.950)),
    (493643, (4.754, 18.809, 26.818)),
    (666983, (1.452, 12.072, 29.717)),
    (16483, (4.015, 17.576, 29.218)),
    (358196, (2.240, 10.717, 25.359)),
    (824691, (0.785, 17.892, 20.477)),
    (391126, (8.844, 14.581, 25.329)),
    (868696, (7.168, 10.412, 20.589)),
    (909961, (7.176, 12.686, 22.127)),
    (807211, (2.433, 19.977, 22.798)),
    (412443, (5.681, 15.316, 27.630)),
    (397516, (7.989, 15.507, 22.889)),
    (846244, (2.771, 18.555, 20.100)),
    (848670, (7.542, 19.117, 25.127)),
    (227669, (2.928, 15.226, 20.085)),
    (723220, (3.942, 12.818, 23.874)),
    (378395, (7.443, 19.728, 29.140)),
    (284009, (3.759, 12.151, 21.868)),
    (233309, (6.374, 15.370, 26.119)),
    (793675, (0.384, 13.056, 25.628)),
    (45760, (1.094, 13.036, 20.069)),
    (110173, (8.244, 17.870, 22.468)),
    (120529, (1.883, 14.190, 29.182)),
    (344481, (6.054, 11.888, 25.919)),
    (471194, (7.979, 12.407, 20.137)),
    (200422, (9.262, 13.271, 28.531)),
    (876869, (2.041, 16.736, 26.134)),
    (75341, (3.672, 18.995, 22.791)),
    (261215, (9.850, 10.412, 22.871)),
    (428646, (8.068, 13.928, 26.723)),
    (391737, (5.794, 19.729, 27.019)),
    (433567, (1.224, 14.996, 22.720)),
    (312839, (5.383, 14.945, 20.930)),
    (2808, (5.692, 19.357, 26.283)),
    (227976, (8.291, 13.172, 21.155)),
    (826404, (5.098, 17.457, 23.367)),
    (234344, (0.868, 13.435, 26.886)),
    (531652, (5.725, 10.579, 24.437)),
    (330757, (0.469, 12.448, 23.249)),
    (247487, (2.048, 10.355, 23.188)),
    (167134, (2.850, 18.268, 29.017)),
    (288357, (5.195, 19.420, 21.711)),
    (387996, (6.734, 19.679, 20.746)),
    (628189, (5.526, 16.975, 25.732)),
    (440508, (0.379, 19.284, 23.015)),
    (771377, (5.095, 17.410, 29.379)),
    (394668, (0.548, 14.638, 29.707)),
    (300536, (1.718, 18.443, 22.131)),
    (830744, (8.297, 16.485, 21.558)),
    (287720, (6.289, 10.152, 21.460)),
    (376240, (2.001, 11.196, 20.468)),
    (957657, (0.290, 17.370, 25.363)),
    (150431, (4.455, 14.630, 21.658)),
    (19725, (4.534, 10.088, 25.369)),
    (174940, (8.893, 14.151, 26.362)),
    (582420, (5.559, 17.817, 27.614)),
    (684026, (1.211, 15.014, 25.520)),
    (483526, (9.357, 13.127, 24.508)),
    (294825, (2.207, 12.893, 29.312)),
    (45858, (9.536, 15.070, 22.307)),
    (493727, (6.484, 17.311, 26.594)),
    (566201, (1.297, 17.036, 29.886)),
    (201316, (3.459, 15.090, 24.843)),
    (366063, (8.222, 18.767, 29.693)),
    (452397, (3.823, 13.078, 24.300)),
    (223219, (7.721, 18.413, 22.357)),
    (188380, (7.112, 10.640, 28.485)),
    (647453, (3.984, 12.033, 29.008)),
    (965551, (0.600, 18.327, 24.892)),
    (302390, (7.642, 14.456, 28.330)),
    (749391, (6.684, 17.017, 29.344)),
    (361423, (4.302, 17.923, 26.945)),
    (926097, (4.782, 18.245, 20.886)),
    (816620, (0.601, 18.556, 20.904)),
    (630858, (7.159, 18.477, 28.744)),
    (817911, (5.428, 17.516, 24.952)),
    (813454, (0.317, 13.725, 28.663)),
    (751133, (3.338, 19.780, 22.477)),
    (940702, (8.122, 16.593, 21.341)),
    (691573, (8.492, 10.216, 23.297)),
    (873761, (5.480, 11.907, 26.937)),
    (166721, (5.748, 11.942, 24.055)),
    (267707, (2.678, 17.086, 29.932)),
    (107167, (2.095, 16.619, 25.965)),
    (313029, (0.832, 16.044, 21.835)),
    (437028, (8.311, 15.156, 24.117)),
    (220278, (4.496, 13.036, 28.146)),
    (703709, (8.002, 15.086, 25.188)),
    (350863, (2.930, 13.612, 28.754)),
    (79906, (2.140, 11.235, 23.066)),
    (718118, (8.983, 13.619, 28.399)),
    (682783, (1.945, 19.181, 29.576)),
    (600158, (1.802, 19.006, 27.590)),
    (705168, (1.653, 13.800, 29.211)),
    (167504, (3.939, 13.784, 29.308)),
    (289961, (6.451, 18.513, 20.701)),
    (983682, (2.837, 12.348, 24.680)),
    (183487, (0.042, 19.088, 23.461)),
    (108483, (2.457, 10.794, 25.317)),
    (200000, (4.205, 17.066, 26.738)),
    (518928, (6.943, 15.285, 27.439)),
    (684256, (8.150, 13.832, 20.327)),
    (4131, (0.432, 13.538, 26.500)),
    (39474, (8.112, 18.313, 28.363)),
    (141799, (0.006, 11.557, 27.265)),
    (10198, (7.307, 16.143, 25.109)),
    (462830, (5.468, 19.579, 21.765)),
    (987624, (3.261, 10.588, 23.843)),
    (708973, (3.835, 13.965, 25.005)),
    (344910, (8.565, 19.656, 22.433)),
    (741781, (3.806, 14.252, 21.473)),
    (41060, (9.589, 12.572, 21.637)),
    (596941, (5.567, 15.778, 27.426)),
    (446938, (3.622, 14.167, 25.384)),
    (514662, (1.742, 14.074, 22.774)),
    (586479, (1.616, 17.731, 26.423)),
    (564537, (4.553, 15.968, 26.398)),
    (15009, (1.350, 14.631, 25.783)),
    (285871, (0.542, 16.240, 24.375)),
    (410746, (7.608, 13.956, 25.332)),
    (872975, (3.644, 11.274, 27.138)),
    (595522, (4.155, 17.946, 28.785)),
    (294702, (1.723, 18.722, 26.808)),
    (189129, (0.662, 12.809, 22.151)),
    (664019, (3.754, 15.082, 28.937)),
    (330632, (2.540, 10.640, 27.080)),
    (428944, (2.090, 18.491, 24.085)),
    (542965, (0.466, 11.908, 20.552)),
    (801783, (1.551, 10.332, 22.694)),
    (641533, (3.837, 15.870, 24.795)),
    (695844, (8.987, 19.280, 21.161)),
    (798576, (4.478, 14.855, 28.410)),
    (510614, (8.604, 13.538, 21.319)),
    (542410, (1.540, 15.990, 21.964)),
    (799339, (3.994, 12.115, 20.480)),
    (739357, (7.175, 19.454, 21.691)),
    (655627, (4.432, 18.595, 25.670)),
    (250347, (7.590, 19.171, 22.530)),
    (497449, (4.661, 13.464, 20.047)),
    (863751, (3.270, 19.600, 29.380)),
    (298238, (4.009, 16.257, 25.761)),
    (99554, (6.123, 10.126, 27.241)),
    (650780, (8.169, 13.769, 29.094)),
    (902311, (0.817, 17.963, 29.859)),
    (577775, (8.798, 17.798, 29.497)),
    (803386, (0.031, 19.352, 29.501)),
    (757749, (9.131, 12.455, 26.844)),
    (867950, (2.279, 16.058, 25.518)),
    (434293, (0.661, 12.604, 24.939)),
    (249542, (5.204, 14.850, 24.099)),
    (740965, (9.750, 14.689, 25.532)),
    (233364, (3.791, 15.527, 24.215)),
    (551768, (8.646, 11.379, 26.496)),
    (809710, (6.467, 13.204, 20.439)),
    (792041, (4.577, 18.655, 25.383)),
    (728289, (9.173, 11.895, 28.183)),
    (776494, (3.868, 16.570, 29.354)),
    (373216, (1.679, 19.412, 21.989)),
    (903163, (4.940, 18.975, 21.485)),
    (881837, (5.486, 17.064, 21.377)),
    (448858, (6.070, 17.576, 23.273)),
    (676144, (1.739, 19.857, 29.279)),
    (475318, (0.006, 10.240, 23.767)),
    (467569, (5.862, 10.218, 20.662)),
    (394587, (7.291, 16.306, 25.800)),
    (936701, (8.217, 17.322, 24.206)),
    (12957, (4.643, 16.561, 29.880)),
    (799755, (4.276, 17.733, 23.339)),
    (627682, (5.257, 19.113, 28.789)),
    (152114, (0.198, 16.516, 22.241)),
    (716850, (4.184, 18.301, 29.326)),
    (268855, (2.758, 17.892, 20.159)),
    (766971, (5.296, 14.039, 26.420)),
    (506018, (9.400, 13.915, 26.708)),
    (160606, (1.783, 15.239, 26.158)),
    (875524, (3.556, 10.236, 26.883)),
    (334093, (8.036, 15.483, 26.225)),
    (59612, (0.484, 19.257, 24.183)),
    (138395, (6.925, 18.682, 23.016)),
    (923113, (3.786, 19.685, 23.890)),
    (654706, (8.106, 18.949, 29.060)),
    (844003, (3.649, 18.578, 21.274)),
    (852657, (4.471, 19.817, 28.835)),
    (216437, (4.416, 17.691, 24.532)),
    (571592, (8.283, 12.557, 20.467)),
    (376373, (5.407, 14.059, 28.976)),
    (303780, (2.852, 11.553, 27.950)),
    (916747, (3.874, 16.823, 20.383)),
    (858196, (7.342, 10.556, 26.095)),
    (419093, (1.877, 15.581, 26.434)),
    (25047, (0.860, 16.038, 23.122)),
    (537761, (8.032, 13.217, 21.805)),
    (188110, (5.927, 15.186, 21.194)),
    (109060, (7.906, 16.536, 20.038)),
    (3209, (1.796, 14.934, 22.112)),
    (127015, (5.359, 18.343, 24.093)),
    (407262, (0.609, 12.693, 29.576)),
    (939011, (0.050, 19.177, 21.574)),
    (443009, (7.564, 18.339, 25.554)),
    (934535, (5.130, 18.016, 22.653)),
    (66145, (3.760, 18.634, 23.327)),
    (109269, (0.853, 15.076, 20.337)),
    (86515, (3.694, 15.676, 25.460)),
    (970531, (2.125, 16.041, 21.890)),
    (405899, (0.234, 15.410, 27.673)),
    (842685, (0.724, 14.868, 20.747)),
    (337620, (8.176, 14.528, 28.738)),
    (243093, (1.486, 15.811, 24.351)),
    (331904, (1.656, 17.574, 21.042)),
    (660273, (4.479, 19.789, 29.353)),
    (975313, (5.730, 18.507, 20.518)),
    (644660, (7.155, 15.122, 25.657)),
    (49781, (0.011, 13.912, 26.198)),
    (232063, (7.367, 11.283, 28.056)),
    (992261, (5.161, 14.357, 20.949)),
    (861822, (0.718, 10.563, 26.316)),
    (798008, (8.070, 11.857, 22.454)),
    (985294, (8.989, 13.072, 28.512)),
    (45108, (4.580, 16.956, 27.673)),
    (80603, (5.825, 18.151, 23.346)),
    (102948, (1.071, 15.413, 21.812)),
    (307760, (0.277, 14.315, 27.190)),
    (266217, (1.057, 15.079, 28.498)),
    (348099, (4.246, 14.638, 27.571)),
    (33536, (4.467, 17.555, 25.664)),
    (8777, (0.127, 11.155, 29.662)),
    (889381, (6.544, 17.788, 21.906)),
    (145732, (4.833, 12.210, 27.607)),
    (95126, (3.449, 11.836, 27.355)),
    (113035, (1.698, 19.939, 24.146)),
    (105502, (8.436, 12.430, 24.970)),
    (751901, (4.861, 12.773, 28.103)),
    (362528, (7.981, 17.265, 26.008)),
    (96137, (3.022, 19.519, 21.819)),
    (33207, (7.160, 13.620, 21.099)),
    (592997, (4.441, 18.390, 27.902)),
    (693895, (5.895, 11.645, 25.933)),
    (256691, (6.957, 17.632, 23.090)),
    (636190, (5.936, 10.610, 26.976)),
    (86124, (3.570, 13.497, 27.067)),
    (851557, (8.102, 13.968, 26.353)),
    (155146, (2.035, 19.830, 21.277)),
    (746943, (1.228, 15.418, 27.219)),
    (323234, (5.609, 10.682, 28.511)),
    (468893, (7.526, 11.210, 20.151)),
    (315245, (3.853, 14.805, 23.185)),
    (194392, (7.531, 19.815, 21.050)),
    (188336, (8.996, 17.489, 23.106)),
    (936778, (7.200, 12.450, 29.017)),
    (729210, (5.061, 13.041, 27.619)),
    (954329, (9.886, 11.531, 29.006)),
    (276807, (0.177, 14.273, 26.616)),
    (320820, (1.295, 16.165, 21.088)),
    (963400, (2.391, 10.965, 20.133)),
    (31120, (7.206, 17.166, 27.092)),
    (234574, (9.715, 19.107, 21.369)),
    (822931, (0.161, 14.524, 25.086)),
    (934933, (2.145, 17.937, 24.881)),
    (671535, (3.019, 12.616, 21.876)),
    (208036, (5.114, 14.790, 26.007)),
    (662946, (2.794, 12.546, 24.415)),
    (476019, (8.130, 18.683, 24.862)),
    (136411, (6.470, 10.828, 21.440)),
    (193211, (2.385, 15.405, 22.778)),
    (472409, (5.072, 14.962, 24.408)),
    (783423, (0.033, 16.890, 20.304)),
    (470449, (9.922, 12.655, 20.495)),
    (325332, (2.534, 15.874, 23.195)),
    (857183, (8.774, 13.690, 24.840)),
    (63109, (0.543, 15.648, 28.711)),
    (979528, (9.817, 16.989, 29.194)),
    (5578, (7.421, 10.797, 28.226)),
    (12522, (7.213, 12.928, 21.335)),
    (32936, (2.696, 19.286, 28.651)),
    (813707, (6.350, 13.060, 21.088)),
    (873846, (3.776, 19.020, 28.135)),
    (738963, (0.591, 11.017, 29.453)),
    (20590, (0.781, 19.089, 28.949)),
    (589080, (6.590, 14.539, 22.907)),
    (38033, (3.868, 16.981, 25.726)),
    (261629, (7.780, 10.798, 25.048)),
    (971847, (6.914, 11.608, 24.148)),
    (633624, (7.972, 19.786, 29.522)),
    (106739, (0.707, 17.821, 25.370)),
    (233114, (4.173, 14.314, 27.776)),
    (214561, (9.489, 13.485, 26.440)),
    (215585, (7.330, 12.355, 22.988)),
    (878923, (5.784, 12.019, 23.633)),
    (236744, (3.810, 18.373, 24.995)),
    (85214, (3.802, 11.454, 22.483)),
    (1788, (0.123, 10.689, 26.891)),
    (390311, (5.905, 10.065, 27.112)),
    (701296, (5.409, 16.319, 22.412)),
    (27979, (2.590, 18.713, 24.129)),
    (92480, (7.637, 16.418, 21.770)),
    (525849, (5.136, 16.161, 20.157)),
    (188648, (7.947, 11.501, 26.057)),
    (427099, (3.463, 15.141, 29.596)),
    (607978, (5.846, 12.538, 26.801)),
    (449380, (0.025, 15.605, 29.323)),
    (219471, (1.143, 15.965, 26.660)),
    (748416, (6.099, 10.254, 22.753)),
    (804823, (6.979, 17.970, 23.179)),
    (934416, (2.729, 15.788, 21.600)),
    (685102, (9.134, 10.855, 25.291)),
    (822326, (4.728, 19.226, 23.946)),
    (236167, (1.337, 11.688, 20.853)),
    (764981, (0.231, 12.407, 21.396)),
    (427069, (6.774, 10.585, 25.665)),
    (906315, (2.105, 18.514, 20.640)),
    (474150, (1.521, 14.770, 24.993)),
    (821053, (2.609, 18.437, 24.008)),
    (360541, (6.000, 15.592, 21.471)),
    (796419, (6.876, 17.302, 25.910)),
    (335811, (0.717, 19.239, 21.820)),
    (384761, (2.173, 12.792, 27.462)),
    (883366, (4.441, 13.096, 26.128)),
    (152238, (6.761, 17.605, 25.508)),
    (158119, (9.254, 18.259, 22.334)),
    (676168, (1.278, 18.187, 21.335)),
    (80431, (2.121, 16.960, 25.048)),
    (707466, (8.413, 10.061, 24.211)),
    (396164, (7.180, 13.325, 29.681)),
    (211058, (8.299, 13.836, 28.186)),
    (244312, (9.965, 15.740, 25.032)),
    (538035, (2.547, 18.389, 22.882)),
    (670703, (5.454, 14.638, 28.298)),
    (326734, (0.097, 12.862, 23.829)),
    (422481, (2.768, 17.534, 24.475)),
    (261462, (9.007, 12.464, 28.428)),
    (19855, (8.552, 12.246, 25.843)),
    (35855, (2.827, 15.828, 20.929)),
    (44715, (3.531, 16.839, 28.870)),
    (180853, (5.854, 11.350, 22.811)),
    (710270, (5.541, 15.858, 20.354)),
    (60199, (2.382, 18.423, 27.194)),
    (746564, (7.765, 18.321, 23.507)),
    (51408, (8.748, 15.367, 29.466)),
    (25860, (8.562, 16.221, 20.345)),
    (429235, (8.255, 16.326, 24.507)),
    (668033, (5.418, 17.445, 27.134)),
    (933380, (3.792, 14.974, 22.392)),
    (576499, (7.443, 13.800, 26.600)),
    (451397, (9.654, 13.792, 29.065)),
    (259819, (0.506, 15.376, 23.706)),
    (344885, (2.403, 17.399, 26.738)),
    (622079, (6.923, 13.124, 28.110)),
    (306095, (1.750, 10.658, 25.542)),
    (300253, (0.924, 16.292, 22.569)),
    (956691, (9.036, 10.138, 25.573)),
    (932930, (6.376, 14.258, 29.500)),
    (472520, (4.381, 19.600, 26.092)),
    (837862, (6.973, 12.306, 21.740)),
    (136856, (1.409, 14.568, 20.459)),
    (667067, (5.810, 13.514, 26.658)),
    (246355, (0.726, 10.707, 23.346)),
    (949136, (5.798, 12.128, 29.795)),
    (830433, (7.774, 16.154, 24.760)),
    (618204, (2.403, 16.540, 20.782)),
    (826032, (8.256, 19.303, 26.080)),
    (793055, (5.649, 15.073, 21.754)),
    (801569, (2.689, 14.499, 27.736)),
    (727608, (2.591, 17.794, 26.133)),
    (769069, (0.207, 19.919, 28.693)),
    (484599, (0.646, 15.041, 24.617)),
    (227226, (3.501, 13.066, 26.078)),
    (912019, (7.726, 10.609, 25.298)),
    (451628, (7.460, 13.347, 21.518)),
    (748429, (9.226, 19.046, 25.005)),
    (506276, (2.947, 16.809, 25.211)),
    (182528, (5.038, 16.817, 28.216)),
    (804213, (2.591, 18.138, 21.159)),
    (788504, (4.979, 10.477, 27.689)),
    (87495, (8.717, 19.253, 20.945)),
    (141410, (5.369, 18.634, 26.520)),
    (269839, (5.238, 16.637, 24.616)),
    (672954, (5.883, 11.991, 26.301)),
    (137266, (0.295, 12.772, 21.579)),
    (823872, (8.189, 16.385, 29.929)),
    (619112, (0.909, 11.179, 20.197)),
    (209505, (9.844, 11.018, 20.601)),
    (2393, (0.731, 10.605, 28.701)),
    (899980, (7.755, 14.748, 29.111)),
    (876159, (2.960, 18.393, 20.031)),
    (695226, (4.838, 14.697, 24.273)),
    (170867, (0.068, 17.101, 23.710)),
    (565296, (8.987, 13.773, 29.670)),
    (869737, (7.706, 17.995, 27.901)),
    (283126, (3.126, 18.844, 23.776)),
    (10735, (2.639, 16.427, 29.642)),
    (37322, (9.608, 13.314, 29.908)),
    (382700, (2.114, 19.476, 20.655)),
    (379436, (3.102, 16.191, 21.214)),
    (937752, (8.256, 13.713, 25.913)),
    (112719, (3.353, 17.084, 20.239)),
    (973019, (6.763, 13.847, 21.346)),
    (768508, (2.981, 14.599, 26.945)),
    (684574, (5.100, 10.376, 26.410)),
    (902147, (1.470, 13.235, 29.388)),
    (660338, (7.549, 15.255, 27.133)),
    (704272, (8.759, 14.333, 20.157)),
    (332891, (0.232, 12.819, 26.784)),
    (704860, (6.020, 16.995, 26.067)),
    (191047, (8.842, 15.436, 29.703)),
    (148708, (4.202, 15.688, 20.548)),
    (66110, (5.116, 11.020, 22.163)),
    (407493, (8.815, 12.757, 26.215)),
    (106473, (5.288, 13.627, 22.160)),
    (43983, (1.067, 19.304, 28.596)),
    (106623, (7.389, 18.796, 22.536)),
    (588407, (6.013, 10.351, 24.260)),
    (486177, (4.456, 10.042, 29.502)),
    (211911, (3.877, 14.043, 27.870)),
    (357421, (8.948, 13.423, 28.557)),
    (245565, (4.366, 19.303, 21.896)),
    (620759, (9.973, 19.409, 24.726)),
    (587374, (8.869, 17.239, 29.143)),
    (903694, (6.806, 14.054, 22.742)),
    (558577, (9.632, 10.607, 22.216)),
    (166876, (3.356, 16.297, 27.398)),
    (684845, (6.302, 17.868, 26.336)),
    (942385, (8.684, 14.270, 29.767)),
    (409106, (3.972, 17.628, 25.805)),
    (58976, (2.909, 17.201, 27.082)),
    (824543, (4.124, 10.565, 23.601)),
    (311804, (0.107, 17.209, 21.152)),
    (93619, (5.027, 14.063, 27.420)),
    (25141, (0.263, 14.254, 28.613)),
    (849397, (0.953, 10.030, 27.424)),
    (522142, (6.508, 17.812, 22.159)),
    (936928, (8.176, 15.313, 25.872)),
    (306668, (7.804, 11.580, 24.023)),
    (374109, (6.887, 17.236, 22.203)),
    (513486, (2.966, 14.547, 27.913)),
    (932350, (4.364, 11.877, 22.474)),
    (936655, (2.420, 18.616, 28.183)),
    (371973, (9.583, 16.422, 29.557)),
    (306438, (3.169, 10.589, 27.399)),
    (94814, (9.686, 10.419, 20.618)),
    (136283, (9.711, 18.758, 21.273)),
    (465572, (1.219, 11.757, 20.010)),
    (530536, (8.261, 11.389, 25.857)),
    (775043, (9.717, 13.161, 27.440)),
    (399750, (4.990, 17.723, 25.414)),
    (299002, (9.470, 18.336, 24.340)),
    (180721, (2.404, 13.121, 28.870)),
    (899222, (9.363, 10.336, 24.655)),
    (110363, (1.055, 10.055, 22.183)),
    (747759, (7.002, 18.890, 24.870)),
    (800504, (8.619, 11.438, 20.288)),
    (581755, (6.614, 15.644, 25.758)),
    (156279, (3.495, 15.431, 20.037)),
    (881756, (6.543, 18.186, 20.330)),
    (118995, (8.968, 18.156, 26.729)),
    (968509, (2.141, 14.115, 20.885)),
    (481776, (4.002, 15.783, 26.972)),
    (864998, (8.212, 12.444, 24.278)),
    (400323, (5.747, 18.576, 25.312)),
    (106616, (8.648, 19.679, 21.820)),
    (905168, (4.078, 10.415, 29.833)),
    (131570, (0.727, 14.985, 28.583)),
    (255196, (4.627, 13.069, 25.327)),
    (455598, (4.127, 12.442, 29.739)),
    (841146, (2.211, 10.136, 25.539)),
    (971323, (5.315, 18.266, 29.220)),
    (566326, (1.880, 16.658, 22.390)),
    (32636, (7.604, 13.373, 27.982)),
    (830160, (3.409, 13.181, 26.638)),
    (996258, (0.648, 10.474, 25.798)),
    (38650, (7.537, 14.720, 25.109)),
    (696245, (4.558, 17.428, 22.074)),
    (58488, (4.563, 10.373, 20.327)),
    (518824, (2.634, 16.654, 26.881)),
    (207667, (6.102, 14.217, 21.831)),
    (978574, (9.663, 17.385, 27.223)),
    (187478, (2.524, 16.206, 29.372)),
    (269810, (9.299, 16.108, 25.774)),
    (616940, (5.273, 14.129, 25.671)),
    (668497, (7.945, 13.930, 29.864)),
    (666050, (6.292, 14.940, 23.039)),
    (591694, (0.881, 11.376, 22.437)),
    (720977, (4.218, 19.052, 21.641)),
    (850135, (4.196, 13.868, 26.846)),
    (329898, (0.262, 16.110, 25.185)),
    (315274, (3.324, 15.655, 27.559)),
    (336549, (7.021, 15.339, 29.353)),
    (734108, (5.375, 16.825, 25.854)),
    (348348, (4.883, 14.041, 23.221)),
    (408648, (1.057, 19.210, 28.517)),
    (366408, (4.880, 19.331, 28.878)),
    (688023, (0.080, 13.031, 29.839)),
    (601214, (5.588, 11.843, 20.748)),
    (422658, (4.067, 14.562, 26.285)),
    (590097, (1.771, 19.280, 26.170)),
    (220478, (3.041, 14.153, 23.679)),
    (240355, (7.653, 12.104, 20.332)),
    (20520, (6.805, 15.321, 25.839)),
    (979144, (4.150, 16.526, 23.841)),
    (535016, (1.192, 10.390, 27.751)),
    (734364, (8.609, 18.473, 29.981)),
    (203159, (7.940, 18.126, 27.025)),
    (404945, (0.519, 17.737, 22.113)),
    (696868, (0.629, 11.478, 22.847)),
    (824084, (3.461, 15.036, 28.127)),
    (939352, (2.528, 16.068, 25.614)),
    (370790, (4.341, 12.309, 29.450)),
    (95562, (5.270, 19.749, 23.147)),
    (975586, (4.487, 18.877, 24.383)),
    (838779, (4.250, 18.054, 23.394)),
    (556875, (9.044, 14.925, 22.863)),
    (519781, (9.332, 12.987, 27.385)),
    (256214, (4.730, 18.108, 24.214)),
    (626789, (0.657, 18.216, 20.443)),
    (29489, (1.218, 10.177, 29.097)),
    (639453, (0.461, 12.905, 27.635)),
    (661174, (3.711, 13.864, 28.745)),
    (481087, (4.693, 13.858, 26.136)),
    (28080, (8.272, 18.092, 25.830)),
    (779211, (3.926, 12.757, 22.082)),
    (293962, (5.684, 15.554, 27.986)),
    (110256, (1.691, 14.244, 22.622)),
    (128005, (3.830, 17.730, 25.786)),
    (635332, (0.015, 15.630, 27.383)),
    (288141, (8.448, 17.246, 29.371)),
    (179359, (9.668, 11.083, 27.537)),
    (845800, (3.410, 13.545, 27.163)),
    (672970, (6.017, 16.891, 24.647)),
    (392366, (3.274, 10.931, 26.722)),
    (804542, (6.723, 18.896, 25.033)),
    (647188, (6.015, 18.311, 21.395)),
    (171785, (9.049, 19.247, 20.573)),
    (651011, (9.956, 13.104, 26.376)),
    (63794, (4.798, 11.355, 22.411)),
    (247970, (4.397, 12.352, 26.903)),
    (946006, (3.677, 12.387, 24.089)),
    (582348, (1.655, 14.485, 22.741)),
    (67888, (4.973, 17.034, 27.272)),
    (566064, (6.932, 17.054, 23.328)),
    (79249, (3.910, 18.781, 23.312)),
    (277641, (6.843, 14.981, 22.962)),
    (390261, (5.304, 18.139, 20.234)),
    (148712, (7.697, 15.370, 28.325)),
    (740701, (2.955, 14.457, 20.829)),
    (688622, (8.871, 13.611, 25.267)),
    (225278, (9.015, 17.204, 29.624)),
    (498164, (0.354, 19.538, 22.502)),
    (42657, (1.366, 19.303, 23.128)),
    (498180, (7.630, 14.097, 25.806)),
    (28108, (7.078, 13.960, 27.490)),
    (288430, (6.451, 10.595, 23.039)),
    (955123, (6.951, 10.221, 29.219)),
    (788643, (7.640, 16.928, 27.349)),
    (418124, (0.929, 17.488, 20.144)),
    (622443, (5.070, 16.659, 20.651)),
    (705766, (6.743, 17.003, 25.628)),
    (380641, (8.863, 13.946, 23.143)),
    (625657, (7.583, 12.477, 21.485)),
    (969924, (7.739, 12.052, 27.553)),
    (18527, (5.161, 12.980, 20.791)),
    (185346, (3.722, 10.710, 21.406)),
    (154610, (6.737, 16.409, 25.823)),
    (676797, (1.291, 11.666, 23.554)),
    (44825, (6.520, 16.190, 20.574)),
    (316423, (9.695, 14.311, 26.917)),
    (662455, (2.862, 11.583, 26.183)),
    (867917, (0.696, 13.302, 26.802)),
    (69446, (4.580, 17.221, 29.430)),
    (220564, (5.590, 12.615, 29.556)),
    (634276, (1.573, 15.295, 26.129)),
    (936819, (4.268, 13.446, 25.996)),
    (948996, (7.517, 13.660, 26.075)),
    (324716, (9.855, 10.134, 25.600)),
    (789378, (7.766, 18.563, 21.098)),
    (831636, (9.776, 17.990, 28.998)),
    (66354, (1.128, 11.222, 25.626)),
    (34430, (9.842, 18.024, 26.663)),
    (254680, (8.380, 14.171, 20.607)),
    (356980, (2.373, 16.782, 27.231)),
    (476628, (9.630, 14.725, 25.971)),
    (769713, (9.781, 17.031, 28.609)),
    (141666, (4.312, 17.634, 20.499)),
    (330704, (7.379, 16.095, 24.297)),
    (8501, (8.429, 18.181, 22.272)),
    (117889, (6.492, 10.149, 20.653)),
    (946537, (2.949, 14.487, 22.799)),
    (525486, (2.628, 15.969, 28.416)),
    (431186, (1.814, 16.110, 22.933)),
    (588083, (3.305, 13.602, 20.472)),
    (806569, (7.213, 16.910, 24.933)),
    (956656, (0.308, 15.360, 25.406)),
    (950793, (3.629, 18.466, 25.737)),
    (620858, (6.048, 15.224, 26.030)),
    (215845, (0.610, 18.903, 22.478)),
    (594118, (1.711, 12.377, 23.317)),
    (581575, (7.146, 11.894, 20.606)),
    (266647, (8.864, 18.037, 23.100)),
    (214556, (9.547, 15.807, 27.170)),
    (733375, (4.298, 16.116, 23.615)),
    (317953, (5.349, 16.827, 23.886)),
    (669855, (0.155, 10.140, 26.619)),
    (66759, (2.648, 17.521, 24.664)),
    (619271, (7.220, 17.945, 25.104)),
    (917612, (2.852, 13.640, 23.793)),
    (181266, (6.596, 14.334, 28.049)),
    (819975, (3.941, 13.769, 21.646)),
    (48972, (3.891, 16.593, 22.618)),
    (403179, (2.534, 17.019, 26.193)),
    (11558, (2.361, 15.368, 24.970)),
    (9313, (0.539, 14.976, 22.983)),
    (375735, (0.005, 19.599, 29.801)),
    (931815, (4.460, 19.974, 20.707)),
    (926228, (1.383, 16.800, 28.205)),
    (230911, (3.304, 12.673, 25.105)),
    (343385, (5.949, 19.994, 27.116)),
    (499797, (9.499, 14.246, 24.039)),
    (684277, (2.857, 17.299, 28.875)),
    (923844, (1.504, 11.545, 26.832)),
    (240266, (3.098, 16.045, 26.945)),
    (714667, (5.966, 14.776, 23.109)),
    (947063, (0.197, 18.272, 25.857)),
    (412969, (0.453, 18.060, 25.521)),
    (990521, (4.494, 16.693, 20.617)),
    (421573, (0.816, 13.757, 22.942)),
    (663050, (3.641, 11.797, 29.780)),
    (749917, (0.514, 16.580, 28.958)),
    (326638, (1.580, 19.775, 28.561)),
    (275989, (5.134, 16.319, 24.540)),
    (600898, (8.169, 13.339, 22.304)),
    (10850, (4.190, 15.030, 25.411)),
    (683776, (0.185, 19.337, 28.776)),
    (254984, (9.903, 16.354, 20.670)),
    (297571, (1.051, 12.417, 28.445)),
    (449146, (7.796, 12.120, 28.425)),
    (708991, (5.749, 16.704, 20.615)),
    (729760, (5.345, 10.073, 22.681)),
    (926885, (9.321, 16.131, 21.515)),
    (609394, (1.458, 13.253, 28.706)),
    (497873, (7.774, 18.809, 23.844)),
    (371516, (1.052, 13.124, 21.256)),
    (837911, (0.993, 14.062, 28.806)),
    (81957, (3.580, 13.989, 27.092)),
    (767275, (9.097, 16.719, 27.326)),
    (842502, (3.448, 14.495, 25.644)),
    (595401, (6.731, 14.906, 21.878)),
    (393126, (2.507, 10.104, 22.422)),
    (97558, (7.093, 18.728, 25.862)),
    (982319, (2.622, 13.418, 27.086)),
    (408281, (5.116, 15.131, 29.470)),
    (204878, (2.469, 17.873, 28.903)),
    (757232, (7.784, 13.760, 23.692)),
    (244383, (8.249, 17.489, 24.826)),
    (610902, (4.557, 19.258, 20.376)),
    (839917, (0.635, 10.279, 25.717)),
    (193308, (9.569, 14.102, 28.478)),
    (646808, (1.733, 15.915, 20.884)),
    (51212, (2.009, 10.787, 24.181)),
    (416130, (0.770, 15.381, 28.398)),
    (535473, (3.144, 10.498, 27.884)),
    (62641, (7.130, 10.999, 21.632)),
    (641883, (5.728, 16.836, 28.542)),
    (181702, (2.226, 14.154, 26.528)),
    (344286, (9.118, 13.838, 26.379)),
    (897777, (6.352, 17.963, 25.035)),
    (840282, (4.217, 14.856, 21.283)),
    (147365, (6.047, 14.769, 26.169)),
    (481411, (4.931, 19.701, 29.401)),
    (162181, (5.895, 13.175, 21.685)),
    (971541, (9.225, 11.161, 29.544)),
    (668836, (3.415, 16.434, 20.865)),
    (615828, (4.729, 13.084, 26.148)),
    (218034, (7.948, 13.275, 28.767)),
    (806659, (1.997, 14.562, 23.902)),
    (158003, (7.030, 19.388, 26.202)),
    (989822, (6.698, 11.404, 24.447)),
    (604746, (6.278, 13.254, 26.709)),
    (837571, (2.258, 14.243, 26.315)),
    (47946, (3.157, 12.466, 24.535)),
    (382153, (3.554, 19.802, 27.512)),
    (632565, (3.146, 12.483, 24.997)),
    (295238, (0.349, 13.206, 22.886)),
    (931304, (0.765, 13.978, 23.302)),
    (149367, (3.553, 18.238, 27.047)),
    (313581, (1.064, 15.413, 22.394)),
    (42493, (9.048, 14.719, 26.943)),
    (509195, (5.496, 16.886, 21.831)),
    (645349, (0.041, 15.190, 26.309)),
    (621922, (0.334, 16.246, 26.564)),
    (271708, (6.392, 13.947, 21.908)),
    (793241, (9.276, 12.256, 28.441)),
    (425593, (7.621, 13.549, 26.729)),
    (283571, (4.895, 12.199, 22.249)),
    (368181, (1.556, 10.530, 21.493)),
    (457098, (5.948, 11.787, 24.609)),
    (741592, (4.001, 11.066, 27.538)),
    (695151, (2.295, 16.229, 29.950)),
    (481667, (0.672, 16.347, 21.594)),
    (426880, (3.388, 12.749, 27.238)),
    (85413, (8.008, 11.953, 29.341)),
    (152111, (2.126, 19.060, 21.975)),
    (419864, (3.279, 14.218, 25.273)),
    (476274, (2.626, 10.259, 27.221)),
    (927276, (3.806, 19.158, 23.848)),
    (182607, (3.093, 17.015, 29.126)),
    (453766, (5.058, 11.169, 24.599)),
    (805519, (2.768, 15.274, 20.789)),
    (528121, (0.221, 14.207, 27.731)),
    (747717, (7.943, 13.735, 20.967)),
    (791621, (7.975, 16.150, 20.317)),
    (662978, (6.820, 13.519, 28.514)),
    (243215, (1.153, 15.833, 27.524)),
    (107726, (3.535, 13.636, 26.819)),
    (415617, (0.536, 18.192, 22.862)),
    (154639, (7.068, 14.153, 21.869)),
    (680684, (5.722, 18.060, 29.860)),
    (965958, (6.812, 13.460, 26.546)),
    (107249, (8.168, 16.461, 25.437)),
    (767066, (6.485, 15.104, 24.169)),
    (538667, (5.716, 18.656, 20.730)),
    (949663, (0.379, 13.477, 22.112)),
    (246760, (0.239, 11.376, 26.028)),
    (55987, (9.298, 12.738, 27.030)),
    (812117, (4.492, 19.906, 27.357)),
    (652745, (4.581, 16.062, 25.368)),
    (113533, (4.233, 17.090, 26.952)),
    (698174, (7.091, 11.793, 25.180)),
    (379328, (3.506, 16.304, 24.281)),
    (820939, (0.186, 19.671, 21.110)),
    (933297, (1.061, 19.268, 25.146)),
    (11168, (7.894, 13.893, 20.295)),
    (573824, (9.476, 18.547, 24.073)),
    (920357, (1.360, 15.987, 25.583)),
    (303028, (8.551, 12.342, 27.958)),
    (23918, (6.577, 18.260, 25.397)),
    (363639, (6.746, 18.646, 26.804)),
    (195719, (3.806, 18.642, 27.662)),
    (845246, (3.871, 17.310, 21.621)),
    (289300, (0.242, 13.191, 21.331)),
    (650885, (3.293, 18.997, 24.707)),
    (529384, (4.345, 17.674, 22.948)),
    (311131, (4.562, 16.507, 20.517)),
    (496381, (0.707, 11.074, 20.907)),
    (322903, (7.735, 11.745, 23.327)),
    (760517, (4.272, 10.767, 20.290)),
    (565491, (1.178, 13.377, 26.383)),
    (577992, (6.368, 10.610, 21.022)),
    (154305, (1.381, 18.085, 27.443)),
    (148202, (2.488, 18.241, 28.794)),
    (763704, (0.547, 11.015, 29.415)),
    (281843, (3.449, 16.479, 28.465)),
    (915027, (0.759, 12.655, 24.725)),
    (228776, (5.427, 14.399, 28.972)),
    (434443, (6.076, 12.805, 23.627)),
    (47822, (4.390, 15.988, 21.413)),
    (405445, (3.696, 18.814, 20.141)),
    (366286, (3.621, 11.088, 22.076)),
    (368013, (8.496, 17.288, 29.818)),
    (686547, (3.584, 14.672, 26.352)),
    (346483, (5.458, 15.195, 28.375)),
    (42047, (9.169, 15.592, 29.632)),
    (988179, (6.238, 15.524, 21.255)),
    (454778, (7.408, 19.235, 24.921)),
    (86266, (2.379, 14.584, 23.523)),
    (110826, (1.971, 18.664, 22.345)),
    (756176, (8.390, 14.033, 21.322)),
    (108973, (5.110, 14.877, 28.151)),
    (829292, (5.982, 16.435, 24.135)),
    (181410, (5.412, 12.478, 20.305)),
    (659354, (2.543, 15.984, 24.231)),
    (339516, (7.324, 14.675, 24.971)),
    (704963, (5.311, 15.406, 21.325)),
    (113794, (1.888, 17.039, 22.766)),
    (37254, (2.026, 19.665, 28.239)),
    (385182, (6.729, 11.938, 29.295)),
    (376037, (4.769, 16.560, 23.951)),
    (22714, (4.087, 11.409, 29.521)),
    (704692, (3.009, 17.251, 24.267)),
    (478030, (2.742, 11.858, 23.207)),
    (992011, (5.000, 16.002, 23.316)),
    (637282, (8.050, 17.780, 25.099)),
    (618143, (0.795, 19.435, 28.527)),
    (487604, (2.412, 11.658, 21.997)),
    (269383, (0.796, 15.468, 25.877)),
    (784388, (7.339, 17.428, 23.795)),
    (1033, (6.050, 12.100, 23.269)),
    (895544, (1.144, 17.175, 27.870)),
    (286600, (4.366, 12.443, 26.328)),
    (64073, (0.927, 11.283, 21.378)),
    (949543, (2.366, 14.521, 28.908)),
    (742360, (7.044, 11.141, 22.599)),
    (45003, (5.875, 18.691, 21.685)),
    (99904, (5.158, 10.925, 28.779)),
    (642649, (0.587, 13.633, 26.592)),
    (721634, (4.393, 16.984, 25.330)),
    (940746, (3.100, 14.557, 22.798)),
    (402770, (5.048, 10.530, 20.410)),
    (493534, (0.619, 11.346, 26.012)),
    (165818, (7.530, 15.897, 27.420)),
    (533668, (3.880, 16.687, 20.054)),
    (134847, (3.456, 10.909, 27.491)),
    (80965, (4.909, 19.397, 24.801)),
    (571644, (2.383, 18.391, 22.182)),
    (243681, (7.489, 14.017, 22.533)),
    (154595, (2.643, 12.602, 29.003)),
    (30424, (6.724, 15.199, 24.703)),
    (28539, (9.812, 17.262, 27.452)),
    (576034, (1.503, 13.093, 21.561)),
    (171682, (1.865, 13.049, 24.482)),
    (651831, (9.476, 14.273, 25.788)),
    (538008, (1.615, 10.288, 25.581)),
    (313371, (6.918, 11.185, 29.102)),
    (871087, (4.678, 19.855, 24.807)),
    (997224, (4.925, 10.691, 28.697)),
    (302887, (4.548, 18.339, 22.635)),
    (971236, (9.164, 18.890, 23.130)),
    (962329, (5.681, 11.332, 25.089)),
    (337950, (3.650, 14.795, 22.930)),
    (812213, (4.223, 16.856, 24.425)),
    (675626, (8.264, 13.323, 28.620)),
    (375537, (6.399, 13.405, 28.827)),
    (154889, (4.042, 13.971, 21.052)),
    (165911, (3.177, 15.097, 20.704)),
    (206097, (8.720, 15.133, 20.902)),
    (480538, (8.866, 16.404, 23.391)),
    (946164, (0.488, 16.811, 29.309)),
    (408844, (0.928, 18.567, 29.493)),
    (769672, (2.242, 16.656, 29.557)),
    (85424, (6.139, 13.683, 28.132)),
    (145998, (6.895, 12.731, 22.929)),
    (387842, (1.139, 15.229, 28.030)),
    (744426, (9.453, 12.427, 23.685)),
    (129801, (5.996, 18.250, 26.037)),
    (345622, (4.941, 17.180, 25.428)),
    (730104, (7.474, 14.902, 24.562)),
    (237868, (0.962, 18.329, 29.602)),
    (933905, (5.792, 19.366, 27.904)),
    (179633, (8.685, 11.117, 21.783)),
    (995351, (6.333, 18.948, 25.352)),
    (281963, (1.925, 16.417, 28.195)),
    (376688, (0.338, 17.153, 21.148)),
    (574419, (2.598, 19.844, 27.013)),
    (443716, (0.117, 19.374, 20.161)),
    (804362, (3.294, 18.299, 21.714)),
    (614329, (8.422, 10.440, 22.246)),
    (691095, (7.332, 14.790, 21.783)),
    (906399, (7.862, 13.682, 23.175)),
    (187015, (7.535, 13.064, 22.615)),
    (916058, (6.328, 13.259, 23.873)),
    (218886, (0.570, 17.319, 24.936)),
    (163268, (3.961, 12.294, 29.883)),
    (393681, (6.981, 17.875, 22.196)),
    (82909, (5.656, 13.454, 25.103)),
    (525230, (9.224, 12.212, 26.143)),
    (545732, (7.187, 15.646, 26.175)),
    (45742, (2.522, 17.576, 29.893)),
    (125989, (8.217, 11.574, 23.585)),
    (593379, (6.631, 17.698, 26.402)),
    (701063, (2.189, 19.250, 27.942)),
    (53594, (8.460, 19.769, 22.251)),
    (141, (7.371, 17.469, 29.527)),
    (969674, (6.067, 15.872, 21.499)),
    (1299, (7.597, 16.941, 25.801)),
    (536965, (0.269, 18.711, 29.644)),
    (983587, (9.705, 12.457, 26.615)),
    (760963, (2.969, 18.873, 25.158)),
    (101808, (4.185, 19.280, 23.417)),
    (680633, (5.578, 19.899, 26.293)),
    (708943, (5.758, 17.565, 22.495)),
    (760809, (2.926, 13.411, 23.776)),
    (361981, (8.979, 18.469, 22.644)),
    (270053, (8.794, 16.772, 24.443)),
    (752110, (9.200, 12.354, 26.567)),
    (964125, (3.031, 13.902, 29.890)),
    (448060, (5.616, 19.265, 25.386)),
    (223626, (5.116, 11.668, 20.677)),
    (895790, (9.382, 19.179, 28.106)),
    (148798, (2.548, 13.719, 25.810)),
    (168304, (6.165, 17.301, 23.553)),
    (45377, (8.441, 12.355, 28.073)),
    (103384, (4.683, 16.522, 23.382)),
    (291356, (0.079, 18.031, 23.730)),
    (191848, (2.523, 11.256, 22.686)),
    (899208, (5.662, 11.681, 21.755)),
    (518861, (0.689, 13.346, 26.696)),
    (215742, (4.900, 15.135, 21.673)),
    (708698, (9.652, 18.331, 26.885)),
    (490722, (5.179, 14.465, 28.083)),
    (652294, (6.491, 10.842, 22.251)),
    (218041, (4.070, 17.300, 25.151)),
    (7773, (2.186, 15.269, 21.464)),
    (786195, (5.405, 11.637, 21.934)),
    (65457, (8.420, 13.457, 27.962)),
    (275343, (5.623, 15.450, 24.245)),
    (28387, (2.554, 10.904, 28.145)),
    (562584, (7.774, 12.255, 25.687)),
    (903682, (7.775, 12.592, 24.541)),
    (101994, (5.106, 15.756, 26.564)),
    (779503, (8.116, 18.189, 21.202)),
    (615397, (2.719, 15.454, 25.602)),
    (753059, (0.573, 17.234, 25.780)),
    (770978, (2.177, 19.548, 29.279)),
    (387643, (3.251, 11.159, 23.351)),
    (228858, (0.460, 10.229, 27.638)),
    (595444, (7.113, 18.194, 20.534)),
    (749289, (5.893, 15.333, 21.123)),
    (739643, (5.458, 12.395, 21.904)),
    (170758, (0.703, 13.563, 23.202)),
    (473838, (1.055, 17.187, 23.646)),
    (135333, (7.393, 12.959, 27.325)),
    (392227, (6.847, 16.706, 24.535)),
    (438737, (0.193, 16.553, 23.578)),
    (888911, (0.776, 12.053, 23.622)),
    (17078, (2.027, 10.531, 21.105)),
    (181664, (4.901, 10.287, 24.011)),
    (343518, (1.446, 13.088, 22.879)),
    (190327, (0.476, 18.812, 27.494)),
    (263339, (9.618, 18.411, 24.342)),
    (455896, (8.024, 15.815, 29.548)),
    (962064, (6.314, 19.512, 25.723)),
    (262478, (5.087, 17.684, 23.826)),
    (506952, (7.075, 19.840, 25.753)),
    (70720, (9.660, 19.325, 23.233)),
    (49817, (0.592, 15.098, 23.221)),
    (503929, (0.413, 19.737, 22.661)),
    (249881, (9.231, 17.647, 24.919)),
    (682864, (4.610, 14.554, 22.484)),
    (242508, (8.912, 13.343, 21.185)),
    (321085, (6.075, 15.225, 23.523)),
    (91848, (3.394, 16.917, 27.221)),
    (654638, (1.572, 16.449, 21.354)),
    (640736, (7.620, 16.034, 28.558)),
    (116571, (8.416, 14.370, 27.287)),
    (825501, (6.944, 16.737, 22.580)),
    (129163, (4.553, 11.926, 26.075)),
    (116963, (1.218, 11.452, 20.349)),
    (460957, (2.838, 15.333, 21.373)),
    (472476, (0.457, 16.743, 26.788)),
    (520761, (7.857, 10.716, 23.221)),
    (158373, (0.738, 10.094, 24.137)),
    (212522, (0.113, 18.545, 28.167)),
    (936901, (8.111, 14.590, 24.521)),
    (294344, (1.921, 12.235, 20.807)),
    (337028, (5.194, 19.465, 26.232)),
    (913301, (7.598, 18.029, 23.414)),
    (655470, (1.352, 10.847, 21.077)),
    (169496, (2.098, 13.675, 22.292)),
    (753675, (2.835, 19.978, 28.143)),
    (523332, (8.918, 12.340, 20.552)),
    (371698, (9.170, 11.691, 20.924)),
    (34408, (8.002, 16.760, 27.466)),
    (975368, (7.141, 12.169, 20.652)),
    (597119, (0.507, 14.491, 29.482)),
    (741693, (5.574, 11.074, 28.638)),
    (713815, (8.007, 15.045, 20.394)),
    (521623, (8.462, 15.090, 22.468)),
    (519971, (8.221, 14.237, 22.544)),
    (691025, (7.950, 12.501, 20.494)),
    (242653, (2.412, 13.613, 29.358)),
    (715388, (9.871, 18.932, 29.826)),
    (597392, (5.124, 12.751, 26.664)),
    (760874, (4.794, 17.695, 23.229)),
    (131131, (4.969, 19.571, 20.743)),
    (84331, (8.486, 10.474, 22.277)),
    (453899, (2.490, 10.069, 22.968)),
    (604406, (8.205, 15.453, 26.618)),
    (135882, (6.673, 15.901, 28.380)),
    (637881, (7.850, 18.839, 23.697)),
    (66906, (8.657, 12.539, 29.932)),
    (243031, (2.913, 19.424, 23.590)),
    (262129, (4.909, 17.054, 28.490)),
    (69326, (2.769, 17.035, 22.549)),
    (378911, (3.693, 18.645, 23.507)),
    (288900, (4.391, 15.332, 29.733)),
    (445752, (0.995, 14.174, 24.187)),
    (889197, (3.386, 13.807, 27.782)),
    (666673, (0.613, 19.621, 28.593)),
    (391727, (0.442, 13.541, 29.670)),
    (586930, (7.379, 16.077, 26.796)),
    (204436, (9.380, 19.850, 25.123)),
    (721619, (4.520, 15.019, 29.741)),
    (360346, (9.474, 14.899, 21.216)),
    (198908, (6.876, 13.788, 28.709)),
    (13165, (9.074, 13.769, 21.964)),
    (305128, (8.703, 14.640, 29.871)),
    (536516, (1.924, 15.147, 20.553)),
    (465411, (2.737, 15.437, 22.480)),
    (73895, (9.662, 14.130, 28.522)),
    (58186, (6.189, 14.344, 25.559)),
    (57985, (9.559, 12.062, 20.142)),
    (376222, (5.343, 19.814, 28.927)),
    (259548, (7.448, 10.035, 23.298)),
    (732036, (1.943, 14.215, 28.899)),
    (992296, (9.001, 13.256, 25.372)),
    (137577, (9.718, 14.530, 22.079)),
    (981863, (4.960, 19.767, 21.581)),
    (373025, (8.707, 10.053, 24.595)),
    (984860, (7.932, 19.604, 23.162)),
    (638632, (0.301, 17.259, 21.580)),
    (473957, (3.602, 17.901, 25.859)),
    (449584, (8.860, 11.884, 28.883)),
    (405646, (2.143, 13.161, 21.861)),
    (711901, (0.231, 19.484, 28.793)),
    (590605, (4.213, 10.982, 27.957)),
    (667702, (2.041, 13.578, 24.965)),
    (460776, (5.608, 14.945, 26.476)),
    (44811, (7.943, 14.346, 20.806)),
    (119741, (4.359, 16.683, 20.059)),
    (850266, (1.038, 16.183, 28.290)),
    (479018, (0.940, 18.858, 20.119)),
    (467768, (2.488, 14.704, 28.683)),
    (600309, (7.215, 18.739, 29.436)),
    (424454, (5.699, 13.118, 21.716)),
    (885904, (8.961, 19.098, 22.960)),
    (956262, (2.577, 17.252, 29.667)),
    (680834, (2.110, 12.212, 20.915)),
    (805744, (0.349, 15.492, 23.269)),
    (154759, (7.231, 12.905, 20.929)),
    (344508, (2.834, 13.956, 21.081)),
    (144267, (5.874, 19.199, 24.812)),
    (442588, (8.733, 13.705, 29.093)),
    (371966, (5.529, 19.354, 24.768)),
    (537202, (5.775, 14.659, 24.254)),
    (840501, (6.973, 12.843, 21.521)),
    (111784, (1.693, 19.532, 28.282)),
    (64824, (0.622, 14.684, 22.716)),
    (570259, (3.311, 15.233, 27.301)),
    (343869, (8.518, 13.067, 29.811)),
    (707482, (0.118, 10.470, 24.471)),
    (277709, (8.614, 10.531, 22.263)),
    (172790, (5.625, 13.509, 26.678)),
    (369018, (7.738, 18.379, 21.404)),
    (287531, (3.293, 19.249, 29.013)),
    (833527, (3.702, 13.291, 23.798)),
    (323824, (0.137, 14.254, 27.204)),
    (956888, (1.533, 19.182, 27.576)),
    (163633, (3.614, 13.410, 26.736)),
    (160276, (1.231, 16.774, 26.065)),
    (126123, (7.583, 12.171, 20.293)),
    (460139, (5.703, 13.668, 21.501)),
    (858184, (1.976, 17.256, 27.867)),
    (597110, (3.946, 14.912, 24.107)),
    (796422, (9.591, 16.014, 27.950)),
    (768370, (5.332, 10.847, 28.421)),
    (968553, (3.970, 10.980, 22.717)),
    (138619, (4.835, 12.124, 28.656)),
    (68602, (1.225, 12.379, 29.903)),
    (50786, (7.245, 16.055, 26.401)),
    (731840, (0.598, 18.158, 21.453)),
    (141596, (0.499, 17.632, 26.326)),
    (146289, (8.037, 15.100, 26.375)),
    (992603, (1.510, 14.142, 25.953)),
    (744888, (8.849, 10.824, 20.614)),
    (100808, (3.276, 16.152, 28.552)),
    (460567, (6.281, 10.867, 24.874)),
    (102705, (1.614, 14.572, 26.190)),
    (54098, (7.302, 16.919, 27.097)),
    (313227, (9.876, 18.565, 25.103)),
    (29669, (7.297, 16.498, 23.887)),
    (202718, (8.832, 19.217, 27.010)),
    (442811, (1.148, 19.620, 21.621)),
    (844211, (8.713, 12.226, 20.929)),
    (43288, (3.594, 18.820, 20.314)),
    (927098, (9.703, 17.953, 24.536)),
    (945454, (0.769, 16.460, 26.558)),
    (383679, (4.990, 12.335, 22.612)),
    (747673, (7.202, 10.454, 21.620)),
    (647170, (4.527, 15.460, 22.465)),
    (172722, (1.433, 11.866, 24.627)),
    (135093, (6.223, 14.267, 25.311)),
    (958916, (3.343, 11.431, 25.385)),
    (704800, (2.090, 16.688, 26.156)),
    (416348, (0.059, 17.368, 23.271)),
    (765289, (3.591, 14.514, 27.515)),
    (14975, (6.849, 11.342, 29.435)),
    (305471, (9.991, 19.926, 20.566)),
    (985232, (3.901, 10.155, 21.028)),
    (621811, (5.347, 15.993, 27.478)),
    (862790, (2.940, 15.260, 24.132)),
    (668636, (2.136, 16.551, 28.916)),
    (815461, (2.701, 14.436, 24.815)),
    (251335, (7.254, 14.166, 25.946)),
    (105427, (3.183, 16.662, 21.431)),
    (697244, (3.097, 12.797, 27.232)),
    (605322, (0.805, 12.916, 26.861)),
    (124942, (6.255, 11.906, 29.261)),
    (855299, (3.720, 14.010, 21.899)),
    (153854, (3.647, 15.768, 26.653)),
    (494260, (0.435, 13.108, 26.204)),
    (792642, (3.908, 10.041, 22.513)),
    (194534, (5.461, 11.124, 29.081)),
    (775909, (6.789, 13.451, 27.248)),
    (125250, (7.238, 17.021, 26.982)),
    (628266, (2.457, 17.324, 25.872)),
    (636495, (7.653, 17.338, 24.641)),
    (769256, (0.633, 11.780, 26.957)),
    (264271, (9.242, 12.021, 27.503)),
    (501866, (2.144, 17.675, 22.401)),
    (448144, (2.943, 14.685, 25.725)),
    (295709, (9.185, 13.654, 25.240)),
    (428768, (2.701, 12.818, 26.553)),
    (591595, (8.219, 13.277, 20.941)),
    (929077, (1.692, 12.975, 23.893)),
    (336918, (2.574, 17.418, 26.347)),
    (832014, (5.471, 14.155, 26.581)),
    (393984, (9.120, 14.372, 20.042)),
    (440768, (3.037, 11.980, 24.085)),
    (740004, (1.189, 11.655, 23.602)),
    (382077, (2.593, 11.083, 22.437)),
    (453444, (4.146, 16.731, 23.006)),
    (58135, (3.620, 12.053, 24.348)),
    (407484, (0.459, 13.189, 29.377)),
    (206123, (9.337, 12.809, 28.182)),
    (639711, (7.875, 14.446, 20.988)),
    (582440, (8.934, 12.512, 28.537)),
    (325894, (9.094, 18.392, 25.792)),
    (485749, (0.395, 19.479, 25.062)),
    (286886, (6.519, 16.682, 21.297)),
    (569137, (2.330, 18.282, 24.252)),
    (821634, (5.401, 15.732, 22.970)),
    (633364, (1.128, 15.747, 22.898)),
    (854150, (1.228, 16.095, 23.709)),
    (44329, (4.897, 13.700, 26.658)),
    (639554, (4.252, 15.299, 27.865)),
    (574781, (3.741, 11.956, 28.903)),
    (34135, (1.694, 11.823, 24.712)),
    (673855, (6.237, 18.483, 21.428)),
    (157933, (9.326, 13.862, 25.426)),
    (166135, (2.958, 14.507, 23.494)),
    (116265, (1.096, 13.696, 20.219)),
    (58085, (0.350, 15.858, 25.192)),
    (710000, (4.914, 18.497, 25.387)),
    (178329, (2.627, 10.935, 26.152)),
    (691878, (8.288, 15.159, 21.288)),
    (785476, (8.457, 16.493, 28.101)),
    (620066, (6.847, 17.968, 24.172)),
    (806819, (5.348, 18.952, 24.344)),
    (50944, (1.810, 15.686, 27.244)),
    (479496, (0.124, 10.032, 24.852)),
    (489103, (3.390, 17.009, 23.147)),
    (121680, (4.973, 10.050, 21.054)),
    (547211, (4.017, 19.574, 29.456)),
    (264291, (5.132, 13.930, 26.664)),
    (757046, (0.009, 16.177, 28.460)),
    (15691, (3.503, 11.514, 22.571)),
    (192044, (2.226, 18.779, 29.964)),
    (654337, (9.652, 19.639, 27.848)),
    (243990, (9.341, 16.728, 20.029)),
    (650821, (5.740, 17.929, 27.406)),
    (389533, (6.875, 13.150, 21.616)),
    (377156, (2.510, 12.255, 27.524)),
    (252083, (4.169, 15.560, 20.389)),
    (773705, (7.968, 12.735, 21.714)),
    (823620, (5.080, 16.342, 26.742)),
    (638756, (0.888, 11.308, 26.596)),
    (36923, (4.480, 13.522, 23.014)),
    (946487, (5.636, 15.327, 20.609)),
    (192307, (4.641, 13.845, 29.620)),
    (290913, (2.503, 12.177, 24.054)),
    (804347, (1.603, 14.096, 24.466)),
    (108149, (6.306, 11.117, 28.455)),
    (904442, (0.142, 14.746, 28.920)),
    (331082, (6.840, 13.139, 27.669)),
    (746085, (8.550, 14.148, 25.030)),
    (677726, (8.852, 18.738, 26.167)),
    (127124, (2.753, 17.122, 29.053)),
    (523159, (8.226, 16.591, 27.872)),
    (357290, (1.019, 19.745, 21.637)),
    (810631, (8.035, 12.663, 24.627)),
    (888289, (3.188, 19.495, 26.114)),
    (986248, (5.988, 16.416, 29.517)),
    (151110, (5.074, 15.442, 28.064)),
    (462587, (7.674, 19.895, 25.435)),
    (112004, (0.831, 13.969, 20.341)),
    (110138, (7.262, 16.177, 25.424)),
    (464786, (8.511, 11.773, 29.206)),
    (570143, (2.773, 16.795, 21.713)),
    (651409, (7.340, 14.475, 24.462)),
    (743091, (2.283, 18.402, 20.555)),
    (284097, (6.422, 12.156, 21.812)),
    (654701, (0.949, 11.271, 22.465)),
    (709822, (6.977, 19.360, 26.919)),
    (915027, (8.522, 10.026, 28.525)),
    (268117, (0.844, 19.623, 26.171)),
    (673075, (6.717, 17.919, 29.219)),
    (223005, (3.099, 19.117, 26.445)),
    (560280, (8.843, 10.375, 21.481)),
    (439573, (4.185, 17.920, 22.590)),
    (402881, (1.117, 16.319, 25.266)),
    (610742, (7.499, 13.114, 24.388)),
    (271895, (0.681, 10.482, 26.661)),
    (617650, (0.614, 12.932, 24.093)),
    (810590, (7.447, 15.926, 26.233)),
    (268055, (3.795, 15.506, 28.793)),
    (943022, (3.326, 15.403, 25.069)),
    (498009, (0.941, 11.898, 25.285)),
    (549558, (1.737, 19.184, 29.882)),
    (971738, (1.618, 11.414, 23.708)),
    (658451, (6.433, 10.673, 29.644)),
    (446866, (0.244, 14.887, 28.356)),
    (818048, (9.548, 16.145, 29.814)),
    (466833, (1.178, 15.648, 24.396)),
    (835840, (7.940, 15.253, 25.815)),
    (352011, (5.919, 15.425, 21.282)),
    (566366, (6.664, 12.628, 20.752)),
    (551512, (6.626, 19.283, 26.097)),
    (973524, (6.789, 19.098, 24.063)),
    (753823, (0.088, 10.129, 25.292)),
    (832444, (2.101, 19.570, 29.411)),
    (387894, (5.374, 10.120, 21.678)),
    (811690, (3.226, 17.975, 28.349)),
    (520587, (4.921, 12.716, 28.174)),
    (719675, (2.839, 10.797, 26.996)),
    (257181, (3.178, 12.200, 23.570)),
    (775501, (3.598, 16.660, 25.252)),
    (975909, (8.169, 17.301, 28.646)),
    (837825, (9.318, 19.885, 24.535)),
    (755687, (1.676, 14.188, 25.104)),
    (923149, (6.554, 17.528, 27.222)),
    (619301, (3.974, 18.635, 23.808)),
    (688950, (3.298, 15.735, 25.513)),
    (652896, (3.880, 14.579, 28.128)),
    (893245, (9.072, 12.301, 29.291)),
    (633939, (4.989, 19.315, 28.600)),
    (849737, (7.400, 10.215, 21.638)),
    (632356, (0.164, 13.106, 25.464)),
    (904586, (0.700, 11.956, 22.833)),
    (742402, (4.370, 18.268, 26.709)),
    (428002, (4.702, 15.649, 21.911)),
    (602648, (3.886, 12.035, 27.260)),
    (471372, (0.383, 12.883, 24.376)),
    (857358, (3.781, 10.076, 22.795)),
    (156584, (2.424, 10.192, 25.682)),
    (483193, (8.760, 13.314, 20.226)),
    (161184, (7.911, 11.082, 29.350)),
    (191791, (2.515, 19.544, 21.053)),
    (256004, (6.175, 15.970, 23.865)),
    (426186, (2.970, 13.095, 28.191)),
    (124365, (9.049, 11.410, 26.636)),
    (570630, (9.920, 11.968, 23.466)),
    (645908, (2.775, 17.188, 23.078)),
    (981552, (8.362, 14.028, 29.070)),
    (134281, (6.348, 15.848, 25.321)),
    (605412, (3.563, 10.727, 24.427)),
    (630683, (2.010, 19.533, 24.315)),
    (361053, (5.761, 13.033, 26.346)),
    (30957, (7.470, 15.468, 25.775)),
    (87847, (5.878, 13.055, 23.497)),
    (950572, (1.445, 14.586, 25.660)),
    (775108, (7.275, 13.749, 26.732)),
    (167897, (3.157, 19.721, 27.923)),
    (445805, (6.592, 19.923, 26.692)),
    (541505, (5.777, 18.395, 27.969)),
    (769879, (9.398, 10.079, 23.191)),
    (9183, (4.950, 17.225, 28.481)),
    (785154, (0.669, 10.128, 27.595)),
    (626832, (7.225, 14.468, 24.090)),
    (845823, (1.029, 11.158, 22.108)),
    (742072, (0.917, 10.485, 26.680)),
    (304238, (9.729, 17.843, 25.531)),
    (400962, (2.944, 15.919, 28.631)),
    (569170, (5.318, 13.166, 24.711)),
    (355520, (6.428, 17.833, 26.528)),
    (426660, (1.580, 13.899, 27.111)),
    (896838, (2.299, 17.976, 20.748)),
    (396872, (4.550, 10.422, 23.960)),
    (58459, (6.480, 19.293, 28.257)),
    (550325, (8.910, 16.836, 22.378)),
    (423916, (0.753, 12.657, 22.688)),
    (561504, (6.690, 11.825, 20.077)),
    (939952, (2.240, 11.550, 29.227)),
    (316834, (1.308, 15.333, 25.282)),
    (950357, (4.960, 13.229, 25.621)),
    (485644, (0.376, 14.561, 27.438)),
    (646544, (4.857, 14.531, 23.405)),
    (498339, (4.933, 18.812, 28.026)),
    (888163, (1.540, 12.423, 26.016)),
    (112933, (1.827, 12.170, 28.709)),
    (699377, (5.494, 17.065, 20.731)),
    (189205, (5.702, 10.547, 22.042)),
    (166777, (1.242, 16.618, 28.294)),
    (323072, (5.420, 18.197, 22.946)),
    (91157, (8.952, 10.792, 20.064)),
    (842723, (6.451, 13.256, 29.188)),
    (455832, (5.168, 15.019, 25.791)),
    (408243, (5.729, 17.453, 20.835)),
    (146916, (1.055, 11.001, 25.619)),
    (215234, (1.852, 10.335, 26.036)),
    (713116, (8.108, 17.592, 20.525)),
    (95439, (7.318, 17.816, 26.539)),
    (393117, (8.050, 17.076, 24.264)),
    (130372, (5.636, 19.177, 29.412)),
    (209067, (1.190, 16.022, 22.594)),
    (433764, (8.272, 18.567, 24.584)),
    (536644, (5.133, 11.418, 22.456)),
    (122461, (9.158, 17.247, 29.761)),
    (786670, (8.950, 17.460, 28.299)),
    (349808, (0.651, 12.726, 25.776)),
    (356144, (1.370, 10.287, 23.583)),
    (661542, (7.683, 11.935, 27.564)),
    (883522, (2.634, 11.913, 25.424)),
    (962929, (2.030, 17.635, 29.286)),
    (495620, (0.089, 11.099, 27.126)),
    (472336, (3.083, 18.171, 28.988)),
    (993432, (3.228, 19.255, 25.122)),
    (259249, (2.183, 11.322, 27.078)),
    (269688, (3.963, 17.400, 24.276)),
    (847943, (2.509, 16.553, 26.610)),
    (781748, (4.393, 10.692, 22.537)),
    (137767, (6.640, 18.098, 21.797)),
    (744825, (0.854, 12.339, 26.550)),
    (617762, (3.765, 17.243, 24.224)),
    (140577, (2.190, 12.108, 25.297)),
    (826619, (1.720, 10.203, 29.371)),
    (391697, (0.326, 17.836, 22.205)),
    (609290, (6.270, 19.443, 25.693)),
    (246166, (3.107, 18.131, 28.216)),
    (633426, (6.163, 18.735, 28.148)),
    (810536, (0.536, 16.643, 29.305)),
    (782693, (6.077, 19.991, 27.053)),
    (577954, (6.254, 14.965, 27.243)),
    (631552, (5.731, 12.872, 20.412)),
    (183717, (8.809, 16.756, 25.288)),
    (838078, (8.659, 15.131, 26.036)),
    (67189, (2.631, 14.038, 21.639)),
    (383023, (7.364, 15.825, 24.235)),
    (743, (4.456, 16.456, 22.600)),
    (227473, (0.432, 16.353, 23.882)),
    (711871, (2.436, 10.287, 24.374)),
    (173168, (2.876, 13.791, 23.578)),
    (597006, (5.698, 10.948, 24.667)),
    (799693, (2.500, 17.255, 22.376)),
    (872606, (8.074, 14.486, 20.195)),
    (294106, (3.125, 13.131, 27.870)),
    (724024, (4.767, 18.010, 25.122)),
    (812698, (8.116, 18.548, 29.190)),
    (340299, (3.165, 12.934, 25.247)),
    (829593, (6.420, 12.820, 21.580)),
    (729499, (4.898, 16.597, 21.898)),
    (509702, (2.891, 14.276, 26.918)),
    (863454, (7.964, 15.066, 22.658)),
    (252914, (6.948, 17.781, 27.443)),
    (107496, (6.816, 18.166, 25.045)),
    (960984, (0.745, 14.595, 24.374)),
    (408737, (8.018, 12.295, 24.289)),
    (40112, (6.174, 17.008, 24.977)),
    (546757, (0.409, 11.651, 27.991)),
    (589582, (8.723, 11.451, 26.485)),
    (210916, (1.079, 16.158, 20.330)),
    (237940, (6.120, 10.314, 20.791)),
    (42245, (8.699, 18.293, 22.544)),
    (190954, (8.605, 12.659, 29.070)),
    (787650, (3.056, 17.628, 22.285)),
    (910826, (9.838, 13.625, 29.959)),
    (361079, (7.405, 12.856, 24.489)),
    (187941, (8.403, 19.929, 25.264)),
    (268786, (9.349, 17.252, 23.086)),
    (115142, (1.604, 14.951, 27.878)),
    (715276, (1.879, 14.353, 22.542)),
    (326702, (1.001, 15.078, 27.350)),
    (381035, (6.774, 13.103, 22.322)),
    (239749, (2.447, 11.850, 22.420)),
    (26851, (7.908, 10.950, 21.601)),
    (966776, (9.213, 15.326, 20.685)),
    (6069, (0.548, 13.212, 26.895)),
    (498064, (5.867, 16.276, 26.255)),
    (681781, (8.750, 16.062, 27.867)),
    (609710, (0.756, 17.049, 28.233)),
    (760749, (6.967, 13.405, 29.849)),
    (326766, (7.724, 13.710, 20.262)),
    (279735, (1.736, 17.073, 24.646)),
    (712504, (6.341, 11.445, 24.320)),
    (312764, (2.044, 13.733, 28.595)),
    (392224, (4.273, 10.997, 29.491)),
    (976943, (9.228, 16.880, 23.976)),
    (190231, (4.964, 18.647, 21.478)),
    (176183, (1.278, 17.446, 24.228)),
    (342412, (7.097, 11.294, 28.761)),
    (63175, (6.127, 13.264, 28.341)),
    (778725, (6.856, 10.625, 29.295)),
    (566234, (5.615, 15.205, 25.138)),
    (525849, (8.272, 19.250, 20.219)),
    (390968, (8.822, 13.168, 29.889)),
    (723502, (5.358, 17.750, 21.347)),
    (213135, (6.072, 19.952, 21.079)),
    (490883, (5.798, 16.177, 23.757)),
    (633241, (7.083, 19.440, 28.945)),
    (528083, (7.640, 19.457, 22.177)),
    (256793, (0.014, 12.507, 26.048)),
    (663318, (0.611, 17.440, 21.195)),
    (208646, (0.371, 11.046, 22.146)),
    (279197, (3.938, 13.626, 21.799)),
    (951979, (0.694, 10.104, 21.402)),
    (41463, (2.467, 19.717, 23.689)),
    (337047, (2.742, 15.057, 22.481)),
    (210101, (4.448, 10.445, 21.276)),
    (123604, (3.111, 12.100, 20.956)),
    (209796, (3.234, 13.187, 21.165)),
    (201053, (7.271, 18.681, 22.020)),
    (979821, (2.381, 15.829, 28.437)),
    (236244, (6.246, 17.896, 25.843)),
    (308346, (5.986, 11.599, 28.351)),
    (498700, (8.365, 12.180, 20.625)),
    (709560, (2.596, 11.471, 20.853)),
    (463714, (5.498, 11.073, 25.454)),
    (112340, (5.323, 11.597, 21.789)),
    (11533, (8.242, 14.601, 28.864)),
    (290273, (0.747, 18.968, 24.576)),
    (125395, (5.643, 17.648, 29.067)),
    (991222, (3.975, 13.320, 25.261)),
    (78730, (0.710, 17.249, 28.614)),
    (715824, (4.291, 12.726, 28.727)),
    (869290, (2.151, 15.537, 23.006)),
    (81193, (6.252, 17.200, 24.941)),
    (973320, (7.384, 17.507, 26.298)),
    (804524, (0.615, 10.872, 25.287)),
    (139411, (4.634, 17.800, 20.735)),
    (392423, (2.845, 11.778, 23.402)),
    (384950, (1.968, 18.367, 20.369)),
    (861040, (6.720, 15.853, 20.226)),
    (689436, (7.199, 16.775, 29.047)),
    (331777, (7.176, 14.526, 26.341)),
    (984235, (5.229, 11.722, 22.866)),
    (41194, (4.490, 16.466, 28.476)),
    (555678, (9.770, 13.252, 26.485)),
    (794989, (5.371, 17.160, 20.082)),
    (471218, (9.229, 15.521, 27.393)),
    (153309, (3.702, 19.446, 22.887)),
    (349602, (3.956, 17.956, 24.769)),
    (41729, (1.977, 15.875, 28.110)),
    (252937, (4.974, 12.753, 27.961)),
    (593438, (5.382, 17.406, 21.582)),
    (494632, (1.978, 11.760, 24.066)),
    (141151, (5.816, 14.367, 25.683)),
    (202398, (5.716, 12.359, 27.272)),
    (727929, (3.474, 10.058, 29.759)),
    (170524, (6.763, 15.299, 28.221)),
    (652685, (2.647, 13.409, 29.824)),
    (267994, (0.200, 19.786, 24.942)),
    (87691, (8.240, 17.728, 24.486)),
    (515297, (0.415, 15.092, 27.397)),
    (485746, (9.639, 19.913, 29.381)),
    (733720, (8.741, 19.996, 22.440)),
    (767733, (8.416, 11.673, 28.355)),
    (310637, (3.787, 17.717, 26.862)),
    (707247, (9.109, 10.136, 26.142)),
    (602710, (4.365, 14.501, 21.695)),
    (834646, (1.859, 19.999, 23.156)),
    (616811, (4.363, 17.007, 29.492)),
    (73298, (1.500, 18.559, 24.984)),
    (336277, (1.210, 14.370, 27.091)),
    (610714, (6.338, 16.131, 24.586)),
    (65219, (5.158, 17.424, 20.657)),
    (378688, (0.681, 17.856, 20.237)),
    (615742, (3.681, 12.061, 24.167)),
    (968612, (3.330, 19.316, 29.606)),
    (324865, (8.805, 19.298, 28.328)),
    (869502, (1.778, 17.460, 24.255)),
    (412603, (7.961, 11.320, 29.682)),
    (712084, (0.292, 12.636, 21.384)),
    (90300, (3.998, 14.811, 28.152)),
    (324458, (5.203, 15.893, 21.385)),
    (437485, (0.079, 12.703, 28.909)),
    (564544, (8.662, 18.911, 20.519)),
    (854208, (1.691, 19.649, 20.080)),
    (149005, (1.484, 17.327, 28.504)),
    (861204, (5.344, 15.260, 20.705)),
    (385196, (1.932, 14.792, 29.147)),
    (253385, (1.593, 11.323, 24.126)),
    (655276, (3.999, 12.176, 26.532)),
    (64451, (3.755, 14.783, 26.990)),
    (212972, (3.391, 19.248, 25.337)),
    (561475, (1.167, 14.018, 21.335)),
    (855371, (4.441, 17.936, 20.464)),
    (132534, (0.220, 19.596, 25.289)),
    (371476, (0.763, 10.652, 25.121)),
    (944349, (4.522, 12.921, 23.074)),
    (444490, (4.115, 19.136, 20.538)),
    (351456, (8.470, 15.677, 24.891)),
    (987054, (4.369, 19.874, 22.261)),
    (603233, (2.131, 10.325, 26.387)),
    (929150, (4.726, 12.189, 26.587)),
    (479756, (7.938, 18.909, 20.900)),
    (510122, (4.350, 13.331, 27.416)),
    (263874, (4.292, 11.805, 28.983)),
    (820355, (2.364, 12.425, 29.302)),
    (31830, (1.194, 18.010, 26.605)),
    (776030, (2.241, 15.840, 26.628)),
    (713705, (4.681, 13.809, 23.225)),
    (252509, (3.727, 16.054, 26.768)),
    (179430, (1.313, 10.209, 26.351)),
    (400779, (5.356, 12.924, 25.177)),
    (595475, (0.105, 11.249, 29.770)),
    (142180, (8.400, 18.454, 22.948)),
    (85916, (9.746, 18.136, 29.328)),
    (173162, (0.049, 16.430, 22.339)),
    (853669, (7.630, 12.800, 28.257)),
    (695256, (5.018, 10.787, 29.498)),
    (248565, (7.272, 17.642, 27.152)),
    (867764, (1.358, 19.957, 27.562)),
    (414691, (5.378, 19.960, 20.696)),
    (721894, (2.628, 13.394, 26.972)),
    (638689, (0.996, 19.729, 26.283)),
    (932140, (5.171, 19.384, 22.925)),
    (545342, (7.440, 11.926, 22.854)),
    (897463, (0.647, 14.319, 20.327)),
    (284544, (8.106, 17.153, 22.643)),
    (204748, (7.885, 17.591, 24.015)),
    (688568, (9.734, 18.412, 28.248)),
    (602543, (1.244, 19.227, 27.704)),
    (71151, (0.463, 16.266, 26.863)),
    (889107, (6.478, 16.839, 29.051)),
    (461325, (5.182, 14.623, 21.591)),
    (595897, (1.040, 17.688, 23.134)),
    (406558, (7.863, 12.981, 21.652)),
    (92585, (1.388, 13.899, 20.992)),
    (857411, (8.097, 15.402, 25.336)),
    (316643, (0.991, 12.239, 20.965)),
    (378349, (5.462, 13.476, 23.890)),
    (581499, (9.007, 17.934, 24.575)),
    (422475, (9.657, 12.836, 24.841)),
    (38578, (9.491, 17.513, 26.579)),
    (619700, (6.751, 12.304, 21.310)),
    (324989, (3.338, 14.764, 29.461)),
    (144209, (1.358, 17.820, 27.766)),
    (90215, (4.730, 17.270, 20.005)),
    (44900, (9.348, 18.262, 27.360)),
    (296074, (6.965, 17.124, 24.557)),
    (737407, (9.780, 18.851, 21.381)),
    (602001, (2.204, 16.618, 26.965)),
    (609251, (1.455, 12.870, 24.347)),
    (435138, (4.474, 18.550, 27.077)),
    (454904, (7.239, 13.578, 28.818)),
    (287252, (2.405, 11.511, 24.943)),
    (422213, (7.595, 19.480, 23.655)),
    (188741, (9.646, 14.138, 22.807)),
    (420224, (7.756, 10.149, 23.029)),
    (521447, (7.241, 19.168, 20.087)),
    (877688, (0.586, 19.512, 28.402)),
    (934470, (9.687, 19.707, 20.230)),
    (257719, (8.929, 13.471, 26.186)),
    (304407, (0.163, 11.284, 25.483)),
    (763319, (3.698, 17.009, 22.384)),
    (789059, (6.831, 13.206, 28.553)),
    (74271, (1.291, 16.880, 23.635)),
    (613947, (2.728, 16.941, 28.270)),
    (417230, (3.859, 18.280, 27.738)),
    (303336, (9.244, 19.699, 23.011)),
    (26811, (1.098, 13.812, 21.799)),
    (341835, (1.040, 17.629, 25.246)),
    (966409, (6.244, 10.298, 24.271)),
    (839413, (5.751, 15.020, 25.132)),
    (545392, (2.931, 14.589, 29.159)),
    (553250, (9.228, 18.266, 22.400)),
    (879909, (6.391, 10.755, 27.623)),
    (124461, (0.149, 13.944, 26.605)),
    (533630, (7.033, 16.173, 29.012)),
    (78087, (9.826, 18.629, 27.463)),
    (832734, (6.350, 13.414, 22.457)),
    (875678, (5.333, 12.748, 26.813)),
    (242602, (5.550, 12.896, 24.935)),
    (5928, (6.995, 16.897, 28.709)),
    (94090, (8.865, 12.423, 29.406)),
    (586705, (6.666, 16.986, 27.392)),
    (936751, (6.259, 16.647, 21.852)),
    (60723, (4.771, 13.951, 23.408)),
    (223972, (2.733, 19.331, 20.669)),
    (498120, (0.685, 10.762, 22.605)),
    (827377, (9.299, 17.000, 29.806)),
    (524679, (7.594, 17.886, 22.265)),
    (236879, (6.705, 19.260, 27.391)),
    (915611, (6.383, 12.457, 27.155)),
    (247751, (6.371, 13.010, 25.877)),
    (317353, (8.653, 15.345, 24.917)),
    (825956, (8.539, 19.230, 27.054)),
    (445746, (2.115, 16.870, 25.280)),
    (909051, (2.410, 16.898, 20.993)),
    (32885, (5.954, 14.996, 26.554)),
    (269334, (8.873, 16.182, 25.484)),
    (484435, (6.637, 17.956, 20.136)),
    (570540, (0.605, 13.596, 23.650)),
    (388777, (9.771, 10.716, 23.872)),
    (936560, (1.187, 12.999, 26.724)),
    (696407, (5.615, 18.016, 24.981)),
    (774485, (2.378, 15.847, 20.219)),
    (897573, (6.311, 14.544, 25.496)),
    (359146, (3.162, 14.671, 25.749)),
    (402194, (3.579, 15.177, 27.004)),
    (324170, (2.604, 19.497, 23.090)),
    (384947, (6.283, 17.016, 20.089)),
    (232322, (9.562, 13.059, 24.012)),
    (809134, (9.591, 12.069, 28.079)),
    (823960, (4.810, 10.755, 21.240)),
    (800855, (9.303, 12.202, 20.126)),
    (841604, (3.717, 14.070, 21.011)),
    (85257, (1.934, 11.983, 20.271)),
    (440306, (5.906, 15.041, 23.369)),
    (563066, (0.529, 11.688, 22.677)),
    (880565, (1.671, 19.125, 22.328)),
    (849174, (3.266, 15.208, 27.493)),
    (742569, (2.674, 17.751, 20.892)),
    (812776, (8.336, 19.654, 25.022)),
    (888338, (8.975, 14.080, 26.582)),
    (915577, (6.711, 14.174, 28.894)),
    (607275, (8.531, 12.354, 28.643)),
    (493305, (3.609, 11.750, 26.770)),
    (949211, (9.338, 18.137, 27.623)),
    (288791, (8.177, 13.736, 21.379)),
    (999405, (2.187, 18.519, 27.034)),
    (759578, (4.717, 19.256, 24.849)),
    (496824, (8.721, 10.417, 25.852)),
    (181474, (8.484, 15.778, 23.175)),
    (758721, (8.738, 15.192, 27.914)),
    (366520, (5.865, 17.233, 20.226)),
    (524993, (4.182, 10.181, 24.062)),
    (496130, (7.042, 18.108, 25.975)),
    (434362, (9.438, 17.313, 27.942)),
    (992609, (3.903, 18.222, 23.905)),
    (711803, (2.969, 13.879, 22.784)),
    (596759, (9.333, 16.624, 23.914)),
    (865183, (0.965, 12.282, 28.694)),
    (501026, (8.136, 18.068, 20.010)),
    (902671, (9.179, 13.279, 25.632)),
    (389864, (6.534, 16.908, 22.758)),
    (773252, (4.652, 14.164, 25.591)),
    (917575, (8.464, 10.603, 25.014)),
    (71685, (7.326, 15.658, 23.509)),
    (618742, (3.782, 16.054, 22.310)),
    (68951, (4.929, 16.975, 20.539)),
    (868931, (3.226, 15.112, 24.125)),
    (169062, (1.074, 10.573, 22.941)),
    (444946, (3.714, 12.297, 22.735)),
    (794596, (3.576, 11.432, 23.439)),
    (236509, (8.908, 18.904, 25.993)),
    (763636, (0.073, 18.681, 21.200)),
    (951078, (1.286, 19.434, 21.867)),
    (186311, (3.538, 19.054, 22.393)),
    (792674, (2.349, 16.536, 26.621)),
    (753890, (9.993, 16.427, 25.760)),
    (856394, (6.016, 16.896, 23.021)),
    (150938, (7.466, 15.021, 20.159)),
    (871260, (7.376, 15.340, 28.222)),
    (218038, (6.631, 18.289, 21.815)),
    (226409, (2.824, 13.142, 27.763)),
    (705623, (2.858, 11.570, 21.652)),
    (478453, (4.430, 11.120, 28.091)),
    (745044, (7.668, 13.590, 27.556)),
    (346662, (6.197, 10.878, 23.469)),
    (786851, (7.267, 17.348, 22.041)),
    (108074, (8.473, 10.509, 27.761)),
    (841361, (8.414, 11.727, 29.901)),
    (609964, (2.571, 17.549, 25.310)),
    (695926, (8.129, 17.714, 20.173)),
    (311272, (1.095, 10.838, 29.661)),
    (338598, (1.481, 16.049, 29.759)),
    (886749, (4.088, 18.843, 27.816)),
    (755683, (7.459, 18.476, 20.327)),
    (427425, (8.047, 16.116, 20.680)),
    (931480, (0.877, 14.232, 23.379)),
    (484359, (5.463, 15.926, 23.640)),
    (437707, (5.995, 10.634, 24.863)),
    (308616, (3.189, 11.665, 29.140)),
    (599704, (9.944, 17.991, 25.827)),
    (817521, (3.717, 13.422, 20.010)),
    (500208, (9.500, 13.544, 29.164)),
    (410359, (6.252, 18.618, 27.107)),
    (642338, (1.414, 12.387, 29.760)),
    (40891, (9.467, 16.362, 23.972)),
    (831619, (7.040, 15.702, 21.917)),
    (611275, (2.268, 19.870, 22.399)),
    (301600, (5.752, 15.347, 26.421)),
    (805302, (2.851, 10.479, 20.888)),
    (540789, (4.300, 12.317, 29.196)),
    (741672, (3.120, 16.653, 23.683)),
    (397817, (7.689, 13.980, 26.429)),
    (624839, (2.119, 11.555, 25.182)),
    (389010, (5.535, 12.627, 29.644)),
    (840098, (0.828, 17.466, 28.030)),
    (160344, (8.848, 11.975, 21.095)),
    (67071, (9.513, 15.354, 20.984)),
    (846690, (5.051, 17.443, 23.688)),
    (177673, (9.230, 10.456, 28.300)),
    (38262, (0.418, 16.116, 26.972)),
    (809107, (1.399, 14.707, 25.234)),
    (575257, (7.834, 10.015, 24.228)),
    (742405, (4.793, 16.280, 23.459)),
    (354400, (1.562, 11.018, 20.865)),
    (884346, (4.825, 18.509, 24.038)),
    (964620, (2.311, 10.312, 27.934)),
    (84536, (3.732, 12.778, 25.999)),
    (53528, (2.530, 15.898, 23.748)),
    (799784, (2.672, 14.596, 28.058)),
    (856800, (5.034, 13.693, 22.745)),
    (598343, (0.213, 14.521, 21.624)),
    (666995, (6.799, 19.111, 25.329)),
    (724257, (0.774, 17.487, 26.044)),
    (51592, (6.819, 10.859, 27.001)),
    (215787, (1.037, 13.587, 22.694)),
    (262905, (4.767, 16.985, 25.872)),
    (103805, (4.418, 11.693, 26.570)),
    (359299, (7.337, 17.159, 25.539)),
    (322584, (5.208, 17.132, 25.307)),
    (195157, (2.291, 11.680, 23.976)),
    (964634, (4.473, 16.342, 24.882)),
    (943124, (2.164, 14.959, 26.574)),
    (679345, (3.397, 18.832, 20.646)),
    (153226, (4.239, 15.029, 29.289)),
    (761317, (6.845, 16.896, 26.592)),
    (267343, (0.483, 19.542, 26.896)),
    (544048, (6.077, 11.473, 26.800)),
    (109368, (1.060, 12.457, 28.751)),
    (366129, (9.604, 18.570, 20.255)),
    (564011, (1.244, 16.690, 27.999)),
    (567159, (0.796, 12.546, 21.729)),
    (894635, (4.242, 14.215, 28.133)),
    (537293, (0.502, 13.962, 24.821)),
    (587767, (3.759, 10.059, 25.787)),
    (440685, (7.274, 19.407, 25.460)),
    (686035, (8.576, 15.058, 27.432)),
    (261206, (7.969, 15.207, 23.271)),
    (174805, (7.638, 14.042, 26.456)),
    (350972, (4.274, 12.583, 29.802)),
    (134740, (5.264, 14.312, 29.153)),
    (31397, (8.960, 17.267, 20.118)),
    (306185, (8.787, 14.420, 23.834)),
    (964877, (1.802, 19.584, 24.123)),
    (964825, (5.871, 14.900, 24.550)),
    (703973, (4.582, 16.208, 28.534)),
    (884112, (7.098, 13.731, 28.445)),
    (393656, (8.995, 11.023, 28.774)),
    (256192, (8.071, 17.057, 26.033)),
    (821495, (4.303, 10.711, 29.021)),
    (132995, (0.266, 18.428, 29.077)),
    (412001, (8.022, 12.867, 26.292)),
    (199399, (6.865, 14.814, 20.139)),
    (198049, (2.440, 14.741, 28.980)),
    (41336, (6.132, 19.962, 29.615)),
    (824433, (3.492, 10.216, 20.329)),
    (353716, (8.255, 19.915, 22.830)),
    (730754, (2.661, 16.909, 22.418)),
    (862526, (4.360, 18.961, 22.000)),
    (920656, (2.616, 10.754, 22.787)),
    (263321, (1.278, 18.305, 21.665)),
    (155552, (6.961, 12.311, 28.439)),
    (977628, (5.829, 17.847, 28.577)),
    (663421, (2.179, 13.444, 25.312)),
    (83042, (5.674, 19.618, 25.064)),
    (50857, (7.607, 10.293, 20.309)),
    (893957, (3.066, 15.330, 21.566)),
    (143511, (1.682, 10.222, 29.017)),
    (547405, (5.030, 12.387, 20.592)),
    (692151, (0.743, 18.844, 26.999)),
    (92131, (9.437, 18.273, 28.373)),
    (506942, (1.268, 11.684, 21.462)),
    (11731, (0.038, 15.805, 24.197)),
    (351753, (8.566, 14.482, 26.852)),
    (905113, (6.092, 11.150, 22.391)),
    (108783, (2.045, 10.557, 23.489)),
    (3129, (8.621, 11.112, 24.154)),
    (452167, (1.751, 13.483, 21.680)),
    (299109, (4.955, 12.165, 29.518)),
    (438676, (2.379, 11.136, 25.709)),
    (975953, (3.767, 17.119, 21.783)),
    (802901, (2.450, 16.631, 26.952)),
    (720877, (7.038, 11.534, 26.932)),
    (636292, (3.759, 12.664, 29.284)),
    (291486, (2.960, 19.527, 20.263)),
    (71133, (0.195, 13.419, 26.716)),
    (192538, (3.904, 14.804, 29.369)),
    (234199, (2.535, 12.878, 23.202)),
    (988469, (2.216, 16.757, 28.903)),
    (374266, (5.358, 14.913, 27.264)),
    (687133, (8.953, 18.171, 22.007)),
    (444579, (6.456, 14.031, 24.773)),
    (386290, (7.548, 13.482, 25.765)),
    (44583, (2.523, 10.656, 25.504)),
    (457276, (7.668, 18.028, 21.218)),
    (744456, (9.854, 18.660, 29.249)),
    (435426, (3.862, 13.405, 26.949)),
    (468150, (3.474, 14.270, 22.548)),
    (134072, (8.283, 14.906, 23.263)),
    (557322, (8.688, 12.459, 29.172)),
    (760365, (6.964, 16.095, 24.371)),
    (534523, (4.631, 17.409, 22.712)),
    (8725, (7.784, 11.645, 24.540)),
    (837366, (5.657, 17.580, 21.022)),
    (392812, (3.412, 18.374, 25.290)),
    (371250, (9.543, 11.929, 20.589)),
    (936222, (5.225, 13.102, 27.546)),
    (371277, (7.358, 16.990, 22.637)),
    (352762, (6.902, 12.538, 23.507)),
    (624948, (5.611, 19.747, 24.547)),
    (625533, (1.858, 11.350, 26.535)),
    (942683, (3.613, 13.363, 21.344)),
    (350483, (3.730, 13.300, 26.306)),
    (846418, (2.897, 10.679, 25.310)),
    (434188, (2.179, 16.743, 26.262)),
    (899029, (5.351, 13.231, 24.514)),
    (54664, (3.819, 11.353, 27.275)),
    (284289, (2.768, 15.441, 24.551)),
    (501771, (6.767, 16.989, 20.710)),
    (799627, (2.714, 14.023, 23.448)),
    (415864, (6.016, 10.450, 26.930)),
    (209157, (8.216, 13.562, 26.783)),
    (39223, (8.342, 18.338, 25.648)),
    (180624, (4.778, 18.141, 25.281)),
    (673664, (3.134, 19.389, 21.502)),
    (780460, (7.210, 10.838, 20.235)),
    (569082, (3.897, 11.329, 22.109)),
    (483095, (9.526, 11.326, 21.845)),
    (318933, (9.659, 16.592, 23.547)),
    (654521, (9.986, 16.332, 29.736)),
    (814098, (1.465, 16.907, 29.925)),
    (850885, (1.165, 11.340, 25.348)),
    (988500, (5.903, 10.650, 29.889)),
    (524422, (3.109, 19.649, 22.218)),
    (643560, (4.442, 18.341, 25.380)),
    (368584, (8.851, 14.216, 24.610)),
    (997517, (9.324, 12.875, 26.121)),
    (367389, (9.994, 13.438, 25.745)),
    (581416, (5.087, 12.883, 27.919)),
    (357059, (2.864, 15.393, 23.260)),
    (649486, (3.486, 10.141, 20.300)),
    (548697, (8.358, 13.075, 27.616)),
    (755388, (7.598, 19.543, 27.783)),
    (883837, (2.213, 13.649, 23.872)),
    (37487, (9.897, 13.686, 26.236)),
    (335061, (3.268, 10.150, 22.937)),
    (357808, (8.088, 16.577, 23.969)),
    (393823, (2.456, 14.536, 27.547)),
    (474003, (8.485, 14.956, 20.317)),
    (927967, (4.033, 14.452, 20.536)),
    (230155, (2.903, 10.512, 26.866)),
    (779416, (4.072, 14.316, 29.814)),
    (513686, (3.147, 19.152, 26.506)),
    (903197, (6.757, 11.965, 25.764)),
    (541957, (7.615, 14.908, 21.155)),
    (837964, (4.846, 14.104, 28.934)),
    (582049, (0.093, 10.193, 22.401)),
    (250435, (1.335, 11.308, 20.232)),
    (18152, (9.657, 16.077, 20.029)),
    (143522, (3.285, 18.121, 22.897)),
    (360245, (0.983, 13.757, 25.346)),
    (427522, (2.534, 18.516, 22.376)),
    (159116, (0.080, 15.020, 27.202)),
    (150574, (0.740, 19.606, 21.419)),
    (783696, (8.347, 14.711, 27.738)),
    (771779, (1.858, 14.067, 23.429)),
    (519363, (2.664, 17.991, 25.898)),
    (758928, (7.026, 18.498, 21.683)),
    (837273, (2.494, 11.177, 26.230)),
    (916582, (3.291, 12.276, 27.679)),
    (449431, (9.333, 17.952, 22.066)),
    (679118, (3.712, 16.665, 28.906)),
    (491412, (7.229, 17.566, 20.769)),
    (990790, (0.318, 11.058, 27.024)),
    (559573, (8.375, 19.604, 25.400)),
    (589575, (4.670, 14.580, 28.986)),
    (765220, (6.025, 19.271, 23.589)),
    (410904, (3.160, 14.362, 28.527)),
    (414473, (8.617, 13.859, 25.500)),
    (268408, (3.099, 10.092, 28.289)),
    (968258, (6.252, 11.801, 20.192)),
    (964571, (8.817, 10.679, 23.100)),
    (863666, (6.392, 13.772, 26.667)),
    (334962, (7.624, 11.950, 22.397)),
    (325874, (6.490, 13.938, 28.046)),
    (665625, (3.217, 11.667, 28.887)),
    (173867, (6.733, 19.533, 24.316)),
    (631075, (7.812, 11.528, 22.397)),
    (999625, (4.676, 11.982, 22.591)),
    (136527, (4.495, 13.484, 29.071)),
    (558654, (4.926, 16.483, 26.315)),
    (990510, (8.598, 13.720, 25.572)),
    (283819, (7.968, 18.337, 24.616)),
    (813131, (0.689, 13.874, 24.994)),
    (216907, (5.339, 15.478, 23.691)),
    (845187, (0.767, 13.087, 28.345)),
    (975514, (5.273, 18.529, 27.631)),
    (405099, (0.467, 17.516, 28.373)),
    (625706, (1.189, 13.728, 27.558)),
    (836209, (1.596, 10.407, 29.007)),
    (245624, (8.719, 11.498, 21.060)),
    (659080, (4.907, 17.252, 23.458)),
    (914637, (7.862, 17.187, 20.125)),
    (601704, (6.526, 17.009, 25.853)),
    (965461, (2.606, 19.611, 29.410)),
    (75443, (5.829, 18.186, 29.831)),
    (302980, (1.414, 15.706, 25.069)),
    (401530, (7.963, 16.284, 28.584)),
    (40551, (5.356, 10.652, 26.841)),
    (584534, (7.779, 19.229, 23.963)),
    (529785, (0.395, 11.979, 27.410)),
    (589684, (0.048, 11.960, 26.343)),
    (396992, (0.907, 17.892, 22.709)),
    (313000, (0.797, 19.164, 28.668)),
    (968132, (4.812, 17.999, 21.094)),
    (654015, (9.090, 14.024, 24.604)),
    (241668, (8.186, 15.767, 20.532)),
    (917747, (4.925, 19.742, 28.197)),
    (401057, (6.569, 15.044, 24.438)),
    (419049, (7.389, 15.214, 22.657)),
    (718200, (9.034, 18.368, 26.725)),
    (689240, (1.466, 12.527, 23.908)),
    (489577, (5.317, 10.053, 20.967)),
    (996827, (1.455, 10.141, 26.052)),
    (371829, (4.400, 19.085, 26.499)),
    (379570, (5.494, 11.586, 23.992)),
    (712269, (8.382, 12.485, 24.743)),
    (853059, (8.801, 17.703, 29.827)),
    (259115, (4.594, 17.187, 26.198)),
    (932494, (5.536, 12.783, 21.639)),
    (393917, (8.503, 19.133, 23.411)),
    (226187, (5.048, 19.318, 25.321)),
    (355767, (1.649, 16.374, 29.063)),
    (615184, (1.113, 16.169, 28.160)),
    (765601, (6.088, 19.546, 20.293)),
    (653530, (4.910, 11.510, 26.053)),
    (588773, (1.814, 16.261, 23.426)),
    (620143, (0.038, 10.174, 29.298)),
    (659518, (7.866, 12.477, 27.079)),
    (219482, (7.025, 14.854, 26.377)),
    (371678, (6.618, 11.362, 24.964)),
    (475981, (4.780, 17.025, 26.624)),
    (305915, (3.670, 11.114, 23.139)),
    (939846, (8.915, 17.584, 24.751)),
    (354292, (4.669, 11.229, 22.481)),
    (237843, (7.032, 15.112, 28.212)),
    (90364, (1.314, 12.021, 26.790)),
    (260501, (7.555, 17.444, 23.957)),
    (719862, (0.177, 19.795, 20.253)),
    (463653, (7.306, 10.380, 28.313)),
    (944426, (1.272, 19.507, 24.672)),
    (30077, (7.326, 10.985, 21.096)),
    (124134, (4.539, 18.275, 28.762)),
    (539306, (7.871, 19.576, 25.626)),
    (440659, (8.216, 10.167, 22.700)),
    (4710, (6.782, 18.149, 24.589)),
    (697112, (6.109, 17.260, 27.528)),
    (725305, (2.150, 15.134, 21.736)),
    (156727, (3.136, 18.155, 22.203)),
    (689439, (8.772, 15.219, 26.564)),
    (918675, (2.626, 11.187, 27.012)),
    (974112, (0.176, 15.350, 24.425)),
    (518406, (2.833, 12.192, 24.567)),
    (130502, (5.388, 13.636, 27.894)),
    (897422, (6.387, 15.886, 28.987)),
    (515133, (9.275, 16.063, 23.358)),
    (821745, (8.200, 17.165, 20.742)),
    (799888, (0.341, 18.667, 24.500)),
    (342180, (8.892, 11.114, 20.424)),
    (399783, (1.158, 15.033, 22.320)),
    (457771, (8.295, 17.002, 21.020)),
    (657192, (5.023, 14.242, 21.776)),
    (37788, (5.814, 16.004, 25.468)),
    (890525, (5.293, 10.900, 21.122)),
    (955945, (8.034, 17.020, 22.131)),
    (921547, (8.530, 13.368, 24.324)),
    (363227, (7.610, 18.363, 27.909)),
    (546769, (0.301, 13.006, 21.130)),
    (316049, (2.119, 17.273, 27.222)),
    (605227, (4.303, 11.692, 22.370)),
    (677563, (1.984, 19.267, 22.338)),
    (175362, (2.687, 15.636, 23.823)),
    (544258, (5.199, 10.079, 24.280)),
    (521674, (9.906, 15.607, 27.049)),
    (897645, (3.203, 14.484, 25.971)),
    (208087, (8.795, 18.951, 25.650)),
    (390623, (2.541, 18.172, 29.515)),
    (135467, (8.082, 11.956, 26.693)),
    (590332, (6.307, 10.445, 25.893)),
    (991524, (8.816, 19.260, 21.420)),
    (67337, (4.944, 11.210, 28.968)),
    (113799, (3.088, 16.218, 21.085)),
    (408427, (3.869, 12.154, 26.230)),
    (728587, (8.233, 10.780, 23.812)),
    (898773, (4.248, 14.922, 24.212)),
    (815800, (4.534, 16.257, 21.586)),
    (848154, (1.474, 11.891, 29.927)),
    (513180, (0.135, 16.615, 24.445)),
    (142350, (1.753, 14.039, 22.714)),
    (730971, (3.111, 18.264, 22.113)),
    (657575, (8.586, 18.806, 28.809)),
    (607761, (4.206, 16.149, 29.656)),
    (293836, (4.651, 14.589, 22.713)),
    (898752, (3.770, 19.778, 28.312)),
    (109327, (9.273, 14.961, 21.457)),
    (698032, (1.950, 11.951, 25.039)),
    (191387, (1.181, 13.045, 22.456)),
    (269358, (5.381, 12.080, 24.555)),
    (663509, (6.113, 19.969, 20.468)),
    (295289, (5.556, 19.359, 28.407)),
    (276251, (8.167, 17.804, 28.820)),
    (357735, (7.324, 11.282, 25.009)),
    (414212, (3.007, 18.317, 21.584)),
    (269553, (1.841, 15.445, 23.906)),
    (64267, (5.479, 19.119, 27.393)),
    (775998, (5.541, 17.911, 26.350)),
    (595771, (5.177, 17.341, 20.186)),
    (916623, (8.115, 13.443, 27.185)),
    (36563, (2.485, 19.062, 20.502)),
    (652212, (0.954, 16.340, 21.476)),
    (996386, (2.787, 15.865, 23.691)),
    (598194, (9.550, 16.672, 24.515)),
    (812439, (4.202, 14.564, 21.385)),
    (114346, (3.596, 19.009, 20.610)),
    (286727, (3.731, 15.297, 23.366)),
    (344147, (7.312, 11.906, 26.455)),
    (233653, (5.136, 10.915, 20.826)),
    (540333, (4.475, 17.181, 27.237)),
    (964859, (8.444, 16.682, 26.894)),
    (963652, (4.678, 15.465, 26.908)),
    (655792, (6.181, 14.231, 27.689)),
    (872303, (9.084, 19.166, 24.042)),
    (155545, (3.350, 14.387, 26.434)),
    (241704, (1.171, 14.100, 21.753)),
    (832812, (9.442, 14.336, 20.279)),
    (630142, (1.586, 12.030, 23.992)),
    (854414, (9.302, 19.121, 28.134)),
    (53287, (0.633, 10.535, 23.954)),
    (999089, (3.000, 10.769, 26.097)),
    (293537, (7.477, 10.996, 26.591)),
    (198627, (8.961, 15.479, 25.328)),
    (829822, (1.057, 16.748, 24.703)),
    (159369, (4.657, 10.568, 29.769)),
    (34174, (4.827, 10.284, 28.342)),
    (301085, (6.940, 14.580, 29.298)),
    (388768, (9.267, 11.080, 28.068)),
    (814119, (6.674, 14.081, 20.776)),
    (756529, (5.418, 14.786, 28.078)),
    (450639, (3.494, 10.429, 29.746)),
    (325238, (7.446, 17.075, 27.565)),
    (795663, (2.783, 14.097, 24.314)),
    (451910, (3.595, 10.925, 21.727)),
    (357634, (4.313, 15.742, 26.441)),
    (527675, (3.874, 12.024, 28.897)),
    (511536, (0.403, 15.340, 22.705)),
    (458783, (8.213, 10.080, 23.213)),
    (710213, (9.119, 11.384, 22.059)),
    (206474, (8.862, 11.224, 29.592)),
    (417938, (3.583, 10.292, 28.242)),
    (785619, (1.374, 11.312, 26.669)),
    (549304, (2.490, 15.488, 28.089)),
    (771354, (3.444, 13.436, 24.461)),
    (786186, (8.058, 12.579, 22.493)),
    (723572, (6.486, 11.790, 22.025)),
    (527749, (7.110, 10.197, 29.178)),
    (331340, (8.534, 11.361, 21.620)),
    (71866, (5.324, 15.084, 28.993)),
    (776192, (0.228, 13.432, 27.122)),
    (730631, (5.347, 10.004, 29.756)),
    (224879, (1.060, 15.935, 27.216)),
    (412446, (8.802, 16.410, 29.418)),
    (345481, (5.968, 19.414, 25.402)),
    (264276, (5.017, 13.520, 29.149)),
    (860962, (7.678, 19.018, 20.619)),
    (755544, (2.031, 16.010, 27.757)),
    (280095, (5.607, 17.981, 27.101)),
    (859628, (8.666, 15.174, 26.356)),
    (977468, (7.943, 18.709, 23.608)),
    (518651, (3.832, 14.152, 21.627)),
    (473860, (7.616, 11.787, 22.601)),
    (604550, (0.593, 12.489, 28.738)),
    (972825, (5.113, 19.622, 26.906)),
    (120047, (3.372, 17.128, 25.326)),
    (373441, (4.565, 11.374, 25.462)),
    (680590, (9.512, 17.203, 20.693)),
    (439195, (0.385, 17.486, 24.643)),
    (760487, (7.967, 17.767, 27.014)),
    (113511, (2.203, 16.045, 23.682)),
    (948697, (3.646, 17.347, 29.096)),
    (86500, (0.230, 10.383, 26.138)),
    (746938, (0.352, 11.037, 23.283)),
    (64573, (9.930, 17.244, 26.120)),
    (816379, (7.976, 10.081, 29.075)),
    (16404, (6.788, 13.189, 22.131)),
    (410201, (2.000, 14.905, 22.731)),
    (793939, (6.518, 15.683, 22.116)),
    (861759, (2.052, 15.727, 25.507)),
    (317779, (6.122, 13.699, 27.479)),
    (752429, (2.915, 19.331, 22.425)),
    (420791, (4.036, 18.022, 24.028)),
    (521335, (1.189, 10.807, 20.018)),
    (256219, (7.899, 11.612, 22.202)),
    (471983, (7.671, 12.882, 22.096)),
    (428728, (7.433, 16.602, 27.325)),
    (166262, (8.400, 12.975, 27.139)),
    (428427, (2.745, 12.462, 29.387)),
    (553152, (6.837, 15.828, 29.445)),
    (606741, (6.607, 11.828, 25.107)),
    (780994, (8.764, 12.586, 24.160)),
    (393902, (7.048, 14.963, 24.866)),
    (948375, (5.863, 17.489, 26.635)),
    (38122, (4.630, 11.767, 23.859)),
    (699902, (9.311, 19.364, 27.206)),
    (111387, (7.151, 10.230, 22.465)),
    (13405, (9.148, 13.475, 29.636)),
    (30241, (9.879, 13.401, 22.641)),
    (269244, (0.820, 16.645, 24.733)),
    (770497, (4.262, 17.852, 26.424)),
    (77558, (3.913, 11.285, 21.785)),
    (203930, (2.043, 11.185, 25.439)),
    (354927, (6.057, 17.105, 22.419)),
    (798478, (3.213, 12.273, 21.981)),
    (255229, (9.580, 19.575, 28.849)),
    (447340, (9.739, 13.414, 25.411)),
    (683593, (2.378, 18.889, 28.612)),
    (447667, (3.812, 14.775, 24.402)),
    (409188, (9.418, 10.964, 23.842)),
    (659824, (1.723, 13.497, 22.971)),
    (134242, (7.676, 18.127, 25.813)),
    (272811, (4.918, 13.165, 29.639)),
    (993758, (1.541, 14.195, 22.704)),
    (720885, (2.421, 17.976, 20.932)),
    (531481, (2.540, 18.424, 28.256)),
    (484452, (2.297, 11.273, 23.342)),
    (159370, (1.661, 15.785, 25.011)),
    (453615, (1.819, 12.696, 20.830)),
    (236674, (6.141, 18.818, 27.062)),
    (969426, (1.171, 12.360, 20.810)),
    (643687, (8.648, 12.725, 26.081)),
    (442434, (4.505, 10.539, 25.208)),
    (91955, (1.858, 11.141, 29.302)),
    (450118, (9.658, 13.527, 21.327)),
    (512249, (3.758, 16.474, 24.244)),
    (320833, (0.129, 19.368, 27.438)),
    (21193, (1.904, 14.267, 23.942)),
    (482542, (3.018, 11.997, 29.483)),
    (685591, (3.721, 10.284, 29.443)),
    (255163, (0.135, 16.673, 24.398)),
    (973326, (6.315, 19.098, 20.676)),
    (112585, (0.195, 12.907, 26.125)),
    (310961, (8.101, 14.323, 23.017)),
    (508544, (9.378, 12.562, 29.739)),
    (849625, (9.134, 12.627, 21.914)),
    (556514, (8.651, 11.177, 26.915)),
    (889050, (0.047, 10.379, 26.983)),
    (370188, (3.115, 10.397, 28.144)),
    (240309, (3.986, 16.380, 27.001)),
    (161797, (3.074, 11.692, 25.562)),
    (704466, (8.644, 19.828, 23.402)),
    (139616, (7.380, 14.124, 24.022)),
    (537399, (6.683, 10.036, 23.832)),
    (76155, (1.000, 14.571, 26.914)),
    (579824, (8.062, 14.503, 20.671)),
    (559670, (8.183, 14.525, 20.781)),
    (47498, (0.021, 11.308, 20.123)),
    (587592, (8.750, 18.027, 28.097)),
    (500454, (9.325, 15.942, 26.940)),
    (75725, (9.293, 10.253, 25.350)),
    (222142, (6.304, 17.182, 27.179)),
    (617149, (4.626, 16.569, 29.064)),
    (436689, (8.048, 16.026, 24.299)),
    (98522, (2.880, 12.749, 22.969)),
    (528161, (3.661, 12.147, 26.222)),
    (274870, (8.401, 13.340, 21.705)),
    (265346, (5.128, 14.980, 27.808)),
    (500017, (7.452, 13.048, 28.684)),
    (720658, (0.880, 18.342, 29.896)),
    (380806, (0.238, 15.345, 23.251)),
    (96256, (4.543, 15.390, 24.636)),
    (594567, (9.341, 18.810, 23.103)),
    (632007, (3.845, 18.561, 21.694)),
    (79194, (5.820, 14.157, 26.708)),
    (821218, (6.451, 19.060, 22.448)),
    (250477, (1.049, 16.396, 24.076)),
    (361730, (4.148, 14.258, 20.980)),
    (73198, (3.373, 16.911, 27.464)),
    (430290, (5.479, 14.572, 24.652)),
    (722060, (9.221, 13.340, 22.168)),
    (851443, (5.024, 17.741, 28.679)),
    (517144, (1.851, 16.561, 28.526)),
    (122333, (5.618, 15.031, 23.557)),
    (621427, (2.322, 19.697, 22.918)),
    (799383, (6.806, 10.066, 26.397)),
    (902581, (6.140, 10.392, 28.760)),
    (248360, (1.665, 17.276, 20.235)),
    (122399, (3.208, 14.922, 28.992)),
    (145188, (4.807, 11.328, 22.525)),
    (905874, (8.187, 19.052, 25.359)),
    (342606, (6.720, 11.224, 27.869)),
    (660493, (5.306, 17.218, 20.847)),
    (913739, (5.407, 14.974, 26.401)),
    (546307, (1.060, 19.479, 27.000)),
    (200311, (9.006, 14.054, 23.462)),
    (701007, (2.887, 10.202, 23.819)),
    (468736, (6.372, 10.580, 29.062)),
    (157613, (7.884, 18.513, 27.903)),
    (952129, (2.837, 18.815, 25.682)),
    (852580, (9.161, 17.211, 25.771)),
    (231864, (5.090, 11.227, 22.102)),
    (918147, (3.159, 15.174, 22.240)),
    (146691, (6.178, 10.378, 28.166)),
    (762002, (4.621, 13.095, 25.210)),
    (567119, (6.515, 18.095, 22.919)),
    (59219, (5.712, 11.746, 24.797)),
    (433907, (6.353, 18.825, 24.112)),
    (70762, (5.434, 11.604, 23.236)),
    (148243, (2.421, 10.653, 23.130)),
    (731435, (7.511, 13.070, 27.698)),
    (146564, (7.487, 16.976, 28.603)),
    (150448, (4.083, 10.307, 27.231)),
    (611466, (6.188, 18.219, 22.388)),
    (683448, (8.820, 15.886, 28.611)),
    (516279, (6.036, 14.930, 23.959)),
    (380608, (9.941, 13.667, 23.357)),
    (230514, (5.907, 10.486, 26.167)),
    (761322, (5.141, 13.722, 20.611)),
    (830493, (8.089, 12.298, 24.274)),
    (367688, (0.652, 11.605, 21.304)),
    (242635, (4.232, 19.270, 24.496)),
    (625981, (8.698, 17.503, 21.114)),
    (888408, (2.337, 12.251, 28.809)),
    (386300, (5.072, 16.164, 28.316)),
    (135608, (1.666, 13.925, 23.679)),
    (297347, (7.861, 14.266, 22.409)),
    (495957, (4.456, 16.844, 26.239)),
    (95809, (1.365, 16.503, 23.838)),
    (465294, (7.509, 11.683, 27.069)),
    (225906, (7.739, 18.157, 26.760)),
    (636836, (1.765, 12.260, 24.273)),
    (215290, (1.152, 10.366, 20.655)),
    (483580, (2.193, 10.420, 25.179)),
    (225841, (6.933, 17.456, 25.567)),
    (546473, (7.273, 16.041, 21.036)),
    (855373, (1.935, 12.010, 27.441)),
    (38998, (9.805, 18.448, 23.775)),
    (99830, (6.194, 14.192, 25.155)),
    (256796, (3.169, 12.926, 22.096)),
    (942830, (3.182, 12.253, 22.628)),
    (912857, (1.507, 13.653, 25.931)),
    (277459, (0.425, 16.211, 23.304)),
    (925789, (2.937, 13.349, 23.409)),
    (796802, (3.516, 18.506, 27.992)),
    (686166, (7.349, 12.651, 28.180)),
    (618732, (5.897, 15.267, 20.826)),
    (996188, (0.396, 16.888, 20.360)),
    (794678, (9.808, 11.807, 23.789)),
    (825492, (6.336, 11.112, 23.773)),
    (865408, (6.738, 11.170, 21.627)),
    (642863, (0.481, 17.555, 20.513)),
    (356696, (7.536, 10.778, 26.859)),
    (142848, (5.624, 14.736, 27.579)),
    (540480, (7.939, 19.584, 21.230)),
    (325094, (0.266, 10.382, 27.097)),
    (540165, (4.949, 14.411, 29.170)),
    (823950, (1.750, 17.256, 23.663)),
    (904380, (4.163, 18.169, 22.125)),
    (903790, (3.175, 15.449, 20.103)),
    (735761, (8.520, 11.922, 21.389)),
    (662634, (2.151, 15.058, 27.560)),
    (947665, (3.800, 14.471, 21.414)),
    (292800, (4.586, 12.330, 28.646)),
    (785230, (9.892, 15.233, 27.771)),
    (10090, (2.552, 19.635, 28.865)),
    (849622, (2.163, 14.482, 24.305)),
    (935268, (9.912, 17.632, 20.465)),
    (892541, (0.334, 16.694, 28.592)),
    (600797, (6.102, 14.871, 24.175)),
    (459321, (4.002, 16.456, 23.489)),
    (629186, (4.536, 18.798, 26.710)),
    (710489, (8.713, 19.616, 20.121)),
    (337950, (5.924, 15.958, 23.868)),
    (234153, (8.331, 13.597, 22.312)),
    (788336, (4.845, 13.884, 22.773)),
    (380131, (0.025, 15.857, 23.433)),
    (970671, (4.654, 16.393, 29.659)),
    (345829, (0.934, 18.470, 27.472)),
    (593742, (2.463, 14.794, 24.550)),
    (878284, (0.874, 15.182, 27.094)),
    (959240, (9.917, 18.203, 22.352)),
    (847003, (6.442, 11.429, 21.306)),
    (888204, (2.662, 10.314, 20.111)),
    (498950, (1.315, 18.059, 21.190)),
    (440344, (6.840, 13.348, 26.248)),
    (291579, (3.240, 16.263, 21.711)),
    (85487, (1.691, 18.605, 20.504)),
    (876773, (8.710, 13.201, 29.621)),
    (989906, (9.361, 16.710, 24.478)),
    (52596, (8.002, 13.166, 28.743)),
    (354711, (3.286, 17.129, 20.706)),
    (227807, (5.197, 17.521, 25.945)),
    (488808, (9.852, 12.095, 20.464)),
    (737383, (3.946, 10.474, 20.759)),
    (492076, (6.426, 11.825, 29.980)),
    (441668, (1.781, 14.055, 22.653)),
    (166770, (2.684, 14.236, 25.040)),
    (56653, (4.088, 13.431, 29.271)),
    (844204, (6.673, 11.904, 26.522)),
    (752296, (4.149, 18.431, 25.951)),
    (449852, (7.673, 15.455, 27.916)),
    (262975, (2.059, 18.338, 21.758)),
    (485960, (1.469, 16.908, 25.081)),
    (977619, (8.585, 11.200, 28.327)),
    (263513, (1.844, 16.508, 23.155)),
    (7311, (0.639, 13.112, 25.133)),
    (265442, (2.749, 18.206, 26.249)),
    (85903, (5.499, 14.377, 24.949)),
    (900522, (2.230, 18.575, 22.640)),
    (471104, (9.100, 19.253, 20.157)),
    (446279, (5.696, 12.324, 27.098)),
    (213977, (3.912, 19.775, 22.217)),
    (866144, (7.395, 13.087, 24.715)),
    (899760, (0.327, 12.552, 25.137)),
    (537255, (2.494, 12.645, 24.636)),
    (535225, (5.391, 14.059, 22.443)),
    (184868, (9.599, 14.002, 22.753)),
    (381041, (8.178, 14.215, 20.464)),
    (394137, (1.207, 10.157, 22.373)),
    (253083, (3.702, 12.690, 28.746)),
    (39700, (4.920, 15.696, 23.392)),
    (171926, (6.176, 10.986, 25.760)),
    (824486, (1.520, 18.664, 25.217)),
    (342006, (9.585, 17.023, 29.935)),
    (282364, (8.603, 13.261, 22.971)),
    (780911, (5.554, 14.083, 25.558)),
    (160438, (3.074, 16.838, 22.802)),
    (448092, (2.411, 11.646, 20.184)),
    (937055, (1.808, 10.035, 20.216)),
    (215377, (0.438, 16.359, 28.562)),
    (642989, (0.222, 11.635, 22.715)),
    (480157, (1.162, 18.767, 26.928)),
    (374124, (7.719, 13.415, 22.874)),
    (993939, (0.998, 17.683, 22.062)),
    (759848, (9.116, 19.536, 23.608)),
    (727055, (7.861, 16.058, 23.472)),
    (28579, (6.086, 13.830, 26.927)),
    (246915, (3.851, 11.586, 21.904)),
    (694373, (4.985, 15.023, 22.745)),
    (129743, (1.239, 13.682, 20.803)),
    (733432, (7.741, 18.859, 22.854)),
    (170384, (0.405, 16.414, 23.863)),
    (735285, (8.514, 10.033, 28.637)),
    (728656, (6.134, 10.192, 22.825)),
    (798456, (0.930, 11.613, 24.488)),
    (480000, (2.784, 11.413, 29.522)),
    (431757, (4.973, 15.210, 27.230)),
    (932944, (6.351, 18.481, 29.205)),
    (305592, (8.235, 17.536, 25.480)),
    (512925, (8.996, 13.729, 21.960)),
    (551333, (2.280, 18.444, 22.039)),
    (816122, (6.442, 15.216, 20.802)),
    (554878, (2.136, 14.331, 20.213)),
    (412614, (5.350, 16.233, 24.206)),
    (241355, (6.672, 10.752, 25.875)),
    (825635, (9.575, 14.186, 26.170)),
    (918878, (7.170, 16.433, 21.350)),
    (756630, (9.680, 11.826, 26.155)),
    (18392, (8.313, 14.391, 24.384)),
    (625696, (5.976, 15.256, 21.242)),
    (311983, (7.658, 15.214, 28.275)),
    (704722, (8.249, 19.823, 21.034)),
    (16314, (4.198, 17.082, 24.926)),
    (75582, (8.723, 17.893, 20.305)),
    (141182, (1.314, 14.590, 25.017)),
    (144170, (6.937, 11.787, 20.347)),
    (860477, (9.463, 15.477, 26.345)),
    (990051, (1.993, 18.562, 25.631)),
    (967340, (6.888, 11.083, 25.710)),
    (936036, (7.546, 13.045, 27.299)),
    (707369, (1.005, 11.565, 29.827)),
    (284740, (4.017, 15.833, 26.886)),
    (514059, (4.110, 14.558, 26.284)),
    (198244, (2.818, 19.325, 24.851)),
    (160578, (9.793, 13.463, 28.214)),
    (595349, (2.117, 11.242, 22.060)),
    (518701, (9.665, 17.066, 29.875)),
    (955162, (3.373, 18.371, 25.801)),
    (948508, (7.890, 12.809, 22.783)),
    (669845, (7.825, 13.773, 29.293)),
    (269347, (0.656, 18.295, 20.407)),
    (965651, (6.697, 16.882, 28.507)),
    (962343, (1.758, 15.813, 27.164)),
    (215261, (7.450, 19.305, 21.628)),
    (694898, (9.182, 18.678, 20.928)),
    (673883, (1.309, 14.592, 28.141)),
    (121620, (8.297, 13.216, 22.775)),
    (297095, (1.117, 18.129, 21.544)),
    (211545, (3.120, 11.085, 27.774)),
    (738787, (0.324, 12.840, 23.784)),
    (869467, (6.817, 11.224, 26.915)),
    (702342, (8.477, 19.351, 22.403)),
    (607221, (1.595, 14.794, 24.287)),
    (80636, (8.284, 15.461, 26.880)),
    (717551, (2.425, 11.134, 26.903)),
    (92097, (5.294, 19.018, 28.913)),
    (686693, (3.959, 16.667, 28.288)),
    (517701, (9.098, 10.006, 27.615)),
    (769297, (6.976, 12.648, 24.690)),
    (846086, (3.038, 11.796, 20.851)),
    (683029, (3.505, 11.151, 24.697)),
    (616472, (2.630, 14.116, 25.704)),
    (516786, (4.617, 17.195, 21.497)),
    (961251, (7.291, 19.559, 20.788)),
    (766239, (7.326, 10.012, 24.521)),
    (183400, (6.316, 18.998, 22.930)),
    (675295, (7.159, 14.019, 22.615)),
    (801540, (9.333, 17.632, 23.727)),
    (212496, (7.743, 18.755, 26.269)),
    (628741, (2.449, 16.628, 27.033)),
    (595960, (3.897, 15.495, 26.114)),
    (238506, (8.914, 17.975, 20.849)),
    (138588, (7.907, 17.697, 22.537)),
    (671777, (8.463, 10.039, 27.807)),
    (381812, (8.771, 17.205, 21.845)),
    (778687, (8.628, 17.612, 21.690)),
    (443581, (0.509, 11.023, 21.995)),
    (719465, (9.914, 19.566, 28.248)),
    (179781, (0.225, 19.435, 26.014)),
    (339734, (5.620, 10.843, 23.767)),
    (868041, (2.547, 19.200, 23.907)),
    (263136, (8.791, 15.786, 24.098)),
    (357222, (4.294, 11.356, 20.026)),
    (627558, (9.140, 13.425, 25.249)),
    (576363, (3.758, 17.812, 23.987)),
    (645116, (1.557, 11.671, 29.173)),
    (308066, (5.208, 15.575, 29.532)),
    (778460, (6.175, 10.178, 23.173)),
    (145344, (9.563, 10.742, 29.940)),
    (426116, (8.649, 11.085, 27.794)),
    (823393, (0.325, 16.658, 23.368)),
    (483237, (2.036, 10.176, 21.250)),
    (25034, (0.646, 19.778, 25.073)),
    (694279, (0.379, 19.417, 21.393)),
    (403328, (8.306, 15.312, 28.054)),
    (953476, (8.873, 11.154, 21.961)),
    (834824, (4.712, 10.535, 26.496)),
    (562931, (4.289, 17.240, 29.357)),
    (503448, (0.543, 16.680, 26.585)),
    (607036, (1.884, 11.383, 27.629)),
    (806257, (1.160, 11.859, 25.540)),
    (302103, (1.759, 10.658, 29.525)),
    (354723, (9.047, 11.484, 23.374)),
    (446451, (5.291, 15.102, 27.530)),
    (300985, (4.249, 15.538, 25.010)),
    (86184, (4.372, 17.100, 27.868)),
    (553823, (1.264, 12.304, 23.064)),
    (987312, (7.850, 11.476, 24.917)),
    (608863, (1.616, 16.487, 24.863)),
    (685134, (4.450, 17.732, 21.056)),
    (912551, (9.324, 16.164, 29.221)),
    (139640, (9.076, 16.134, 23.160)),
    (101506, (4.456, 11.940, 23.105)),
    (924681, (5.719, 14.439, 28.519)),
    (170196, (7.795, 12.849, 29.893)),
    (154030, (5.757, 18.118, 29.267)),
    (980705, (0.995, 14.140, 24.606)),
    (444329, (2.835, 16.523, 29.902)),
    (190966, (7.467, 13.955, 23.763)),
    (39218, (6.839, 18.652, 26.636)),
    (368546, (4.930, 14.364, 27.458)),
    (343062, (2.041, 16.310, 27.779)),
    (556665, (0.104, 11.583, 20.988)),
    (323399, (7.664, 15.526, 21.188)),
    (857517, (8.524, 15.561, 26.803)),
    (615578, (1.730, 16.632, 26.005)),
    (331286, (4.164, 11.920, 22.021)),
    (229997, (9.330, 13.734, 20.466)),
    (287870, (7.334, 16.689, 24.066)),
    (934053, (3.637, 17.304, 28.981)),
    (259326, (4.049, 17.654, 21.075)),
    (312322, (1.841, 13.171, 21.850)),
    (428091, (6.778, 10.376, 27.217)),
    (857059, (8.819, 10.795, 29.919)),
    (973532, (6.010, 15.766, 24.056)),
    (115583, (8.571, 15.261, 28.730)),
    (82125, (2.777, 16.759, 23.303)),
    (127369, (2.553, 15.631, 27.712)),
    (64989, (2.411, 14.118, 25.200)),
    (632391, (0.812, 15.173, 29.183)),
    (998237, (0.326, 15.085, 22.721)),
    (590229, (0.536, 12.266, 24.584)),
    (44028, (9.047, 10.424, 21.199)),
    (457593, (2.576, 14.561, 29.082)),
    (950673, (7.342, 17.324, 24.758)),
    (794605, (8.414, 16.772, 20.195)),
    (137602, (0.260, 19.143, 28.874)),
    (359683, (5.877, 15.994, 29.974)),
    (205506, (1.664, 17.283, 22.185)),
    (626063, (2.027, 18.768, 21.569)),
    (121600, (9.005, 19.138, 24.422)),
    (979877, (9.742, 18.267, 22.558)),
    (332710, (0.290, 17.646, 23.277)),
    (433050, (3.635, 11.281, 22.119)),
    (638834, (3.515, 11.834, 27.393)),
    (640037, (3.807, 17.434, 28.433)),
    (572701, (2.920, 11.348, 25.502)),
    (715074, (1.913, 12.138, 29.814)),
    (195153, (1.395, 10.897, 26.618)),
    (583317, (0.097, 15.565, 29.070)),
    (55294, (8.184, 15.720, 21.697)),
    (788092, (3.518, 14.298, 20.590)),
    (974527, (8.155, 17.515, 24.615)),
    (880097, (7.840, 11.403, 29.613)),
    (258395, (3.307, 19.485, 27.075)),
    (853112, (0.401, 15.762, 28.171)),
    (256678, (3.095, 12.973, 20.909)),
    (269425, (7.175, 19.925, 20.144)),
    (92144, (7.148, 18.945, 29.819)),
    (88235, (3.868, 17.849, 21.991)),
    (627338, (4.380, 10.724, 29.753)),
    (787538, (2.404, 13.625, 24.201)),
    (566730, (8.231, 14.817, 27.039)),
    (802408, (6.578, 12.662, 21.724)),
    (107904, (9.809, 10.924, 29.961)),
    (395454, (8.361, 17.663, 24.903)),
    (643277, (6.187, 13.764, 26.827)),
    (277566, (1.593, 11.520, 25.312)),
    (399702, (4.626, 13.736, 22.606)),
    (829722, (7.053, 18.115, 26.808)),
    (108223, (0.382, 10.630, 22.900)),
    (695577, (4.968, 16.758, 20.896)),
    (569954, (8.544, 10.420, 26.259)),
    (57264, (3.970, 13.652, 20.817)),
    (701440, (3.493, 14.132, 26.118)),
    (337732, (3.012, 11.528, 23.732)),
    (717853, (7.647, 13.817, 28.369)),
    (205835, (9.961, 15.889, 20.969)),
    (303553, (2.681, 11.996, 21.096)),
    (164156, (1.548, 15.737, 23.883)),
    (495735, (2.901, 15.040, 21.471)),
    (615778, (6.488, 18.256, 27.439)),
    (501364, (5.673, 11.703, 25.393)),
    (843601, (6.168, 18.427, 24.187)),
    (597366, (0.850, 12.438, 21.894)),
    (824462, (4.610, 19.583, 23.301)),
    (746567, (6.516, 10.774, 23.675)),
    (333001, (6.573, 18.606, 23.175)),
    (156136, (1.937, 12.373, 27.410)),
    (361863, (9.384, 16.220, 22.670)),
    (272060, (6.594, 15.848, 24.494)),
    (530064, (6.909, 15.700, 26.550)),
    (709702, (2.372, 15.637, 26.550)),
    (226425, (2.860, 13.499, 21.971)),
    (481167, (9.467, 15.384, 22.565)),
    (686284, (2.915, 14.616, 25.486)),
    (502839, (5.876, 11.864, 20.920)),
    (303043, (4.357, 11.929, 28.581)),
    (495371, (6.429, 13.075, 25.222)),
    (518748, (1.916, 12.443, 20.367)),
    (719034, (9.735, 19.809, 28.770)),
    (179179, (4.646, 13.926, 22.501)),
    (823313, (1.503, 15.551, 27.818)),
    (852008, (8.749, 17.710, 26.266)),
    (113051, (3.837, 17.303, 29.923)),
    (31979, (7.307, 13.283, 24.715)),
    (763455, (2.032, 17.837, 25.046)),
    (504489, (6.339, 12.992, 27.157)),
    (109455, (0.457, 10.761, 24.737)),
    (128760, (6.527, 14.086, 23.891)),
    (578416, (3.660, 15.535, 26.115)),
    (695127, (2.657, 13.113, 25.229)),
    (167472, (7.678, 17.770, 27.162)),
    (374909, (7.283, 10.880, 24.404)),
    (331460, (2.192, 10.699, 24.643)),
    (523332, (0.126, 15.260, 28.682)),
    (923051, (0.118, 14.495, 25.491)),
    (986410, (9.114, 12.313, 27.060)),
    (215800, (4.554, 19.401, 28.698)),
    (188401, (3.031, 13.452, 27.430)),
    (374930, (7.398, 12.817, 28.494)),
    (691340, (2.785, 14.213, 28.848)),
    (965575, (5.322, 11.218, 20.117)),
    (570371, (9.458, 15.012, 20.775)),
    (957471, (6.913, 14.191, 28.598)),
    (105090, (8.072, 17.874, 26.330)),
    (315838, (3.345, 10.153, 22.525)),
    (621407, (4.328, 12.182, 26.651)),
    (627829, (5.438, 12.245, 22.857)),
    (895612, (0.596, 19.540, 27.079)),
    (71717, (6.110, 10.407, 26.610)),
    (848328, (3.848, 18.016, 28.856)),
    (299294, (2.733, 10.285, 20.405)),
    (340968, (4.777, 11.982, 21.364)),
    (733389, (9.648, 19.495, 21.681)),
    (377185, (7.760, 13.091, 21.287)),
    (6052, (9.194, 18.095, 28.107)),
    (589560, (0.576, 18.150, 27.404)),
    (599300, (6.813, 15.507, 28.325)),
    (606581, (6.064, 17.860, 29.551)),
    (544152, (3.566, 13.578, 27.524)),
    (159730, (0.563, 12.861, 21.167)),
    (845881, (4.055, 13.338, 23.830)),
    (957252, (8.731, 10.012, 29.427)),
    (820310, (0.382, 11.603, 26.022)),
    (5530, (6.301, 11.077, 24.318)),
    (266968, (9.060, 15.066, 29.762)),
    (149784, (2.649, 15.307, 24.777)),
    (479549, (3.279, 17.388, 25.257)),
    (866464, (7.177, 16.147, 25.934)),
    (885503, (8.427, 16.866, 25.686)),
    (666232, (5.038, 17.065, 29.270)),
    (818233, (2.199, 15.759, 27.473)),
    (83844, (9.665, 13.564, 20.172)),
    (549131, (1.513, 11.721, 28.761)),
    (889305, (5.583, 11.058, 26.892)),
    (64771, (9.864, 11.427, 25.499)),
    (639539, (2.414, 14.399, 20.453)),
    (145685, (9.323, 12.551, 22.142)),
    (860044, (0.023, 16.316, 29.021)),
    (709027, (8.558, 11.233, 21.725)),
    (717549, (5.661, 16.706, 22.512)),
    (974107, (6.743, 11.879, 23.384)),
    (329246, (0.837, 11.959, 26.438)),
    (93103, (6.866, 12.293, 29.046)),
    (363411, (4.146, 11.379, 26.627)),
    (197002, (6.118, 14.186, 29.491)),
    (666112, (5.208, 17.011, 21.512)),
    (4091, (9.382, 19.958, 25.424)),
    (181390, (5.253, 17.167, 24.300)),
    (122976, (0.104, 15.175, 21.555)),
    (121038, (1.561, 10.739, 24.467)),
    (869503, (4.781, 12.678, 24.797)),
    (939848, (9.698, 16.791, 27.035)),
    (900699, (0.746, 18.813, 28.877)),
    (591755, (7.759, 18.148, 20.164)),
    (574610, (0.688, 16.329, 20.000)),
    (445362, (8.331, 17.369, 23.252)),
    (776173, (0.177, 17.575, 27.778)),
    (688716, (0.192, 13.218, 28.468)),
    (570879, (7.411, 14.067, 28.618)),
    (495245, (7.112, 12.112, 22.837)),
    (675993, (1.847, 16.233, 24.673)),
    (861656, (9.496, 17.221, 24.029)),
    (687311, (6.891, 19.361, 23.071)),
    (95685, (3.327, 17.464, 20.679)),
    (457470, (1.847, 16.031, 21.278)),
    (723169, (4.024, 14.476, 28.003)),
    (769307, (1.500, 16.878, 25.652)),
    (374181, (1.526, 17.126, 27.250)),
    (295752, (9.628, 18.172, 22.109)),
    (528027, (3.460, 15.931, 24.677)),
    (912135, (1.994, 14.604, 29.674)),
    (397299, (4.272, 11.872, 28.133)),
    (310625, (1.856, 11.585, 29.334)),
    (987733, (5.639, 10.552, 29.554)),
    (508508, (2.204, 13.304, 21.611)),
    (249962, (0.122, 18.838, 24.408)),
    (127837, (1.787, 11.025, 26.431)),
    (955034, (4.735, 14.646, 23.797)),
    (808703, (2.963, 13.104, 28.292)),
    (351942, (0.880, 10.107, 26.988)),
    (562764, (3.740, 18.427, 23.055)),
    (352505, (2.018, 16.563, 26.078)),
    (992522, (6.557, 17.617, 29.751)),
    (604734, (4.995, 13.171, 24.823)),
    (861382, (3.492, 14.398, 29.559)),
    (746827, (0.110, 19.303, 24.964)),
    (159810, (4.350, 17.813, 27.632)),
    (489874, (8.435, 16.941, 23.977)),
    (539759, (9.664, 11.871, 24.316)),
    (768993, (1.467, 19.361, 22.062)),
    (126617, (7.788, 12.424, 26.245)),
    (31676, (2.305, 10.771, 28.357)),
    (497846, (6.288, 19.282, 22.097)),
    (361793, (4.600, 14.001, 24.217)),
    (60887, (5.993, 11.053, 25.278)),
    (867877, (7.615, 12.520, 20.491)),
    (546663, (9.966, 11.956, 27.997)),
    (864607, (3.634, 15.519, 29.415)),
    (241221, (0.817, 12.254, 21.062)),
    (193774, (7.435, 11.199, 24.085)),
    (50939, (5.981, 10.825, 22.493)),
    (115676, (4.924, 19.457, 22.510)),
    (29374, (9.088, 19.785, 29.546)),
    (530300, (2.540, 15.663, 26.453)),
    (796442, (9.072, 19.788, 28.736)),
    (888935, (3.665, 17.087, 25.690)),
    (447553, (0.303, 18.543, 24.705)),
    (453770, (5.908, 19.910, 20.832)),
    (13649, (7.693, 13.913, 29.351)),
    (401659, (9.147, 19.782, 22.771)),
    (347453, (8.078, 13.163, 28.189)),
    (500174, (2.485, 14.546, 24.523)),
    (804523, (8.098, 10.551, 23.762)),
    (482646, (2.621, 13.585, 24.933)),
    (509495, (8.383, 13.286, 25.225)),
    (962980, (1.029, 11.184, 28.322)),
    (739388, (3.985, 19.784, 27.364)),
    (233957, (4.009, 18.205, 26.915)),
    (374386, (0.639, 12.227, 20.670)),
    (167559, (9.221, 18.204, 27.373)),
    (146928, (1.649, 15.827, 24.677)),
    (693433, (2.857, 11.633, 21.142)),
    (180319, (9.404, 14.359, 28.181)),
    (838634, (8.745, 12.217, 26.467)),
    (412039, (3.501, 18.700, 28.025)),
    (549753, (1.613, 19.336, 24.617)),
    (710895, (0.825, 14.644, 26.165)),
    (121975, (3.360, 18.338, 23.037)),
    (536292, (9.115, 16.996, 29.429)),
    (2324, (0.010, 12.464, 24.797)),
    (594857, (4.339, 13.718, 21.775)),
    (232818, (8.050, 10.350, 20.937)),
    (118755, (7.631, 19.913, 25.267)),
    (292998, (8.706, 18.906, 20.549)),
    (327629, (8.847, 13.843, 25.398)),
    (690225, (9.882, 17.463, 23.015)),
    (662733, (8.482, 10.026, 22.339)),
    (834826, (7.829, 18.290, 23.562)),
    (962400, (3.263, 13.997, 21.244)),
    (827804, (8.238, 13.061, 29.145)),
    (668756, (1.635, 11.830, 21.764)),
    (405369, (5.856, 11.605, 26.239)),
    (39320, (2.252, 13.154, 27.194)),
    (211821, (8.094, 16.253, 23.378)),
    (777218, (6.592, 16.715, 23.957)),
    (242662, (8.835, 12.642, 21.078)),
    (217095, (2.093, 13.835, 21.305)),
    (688300, (0.727, 11.801, 23.430)),
    (657478, (2.296, 12.525, 20.497)),
    (165218, (9.005, 19.511, 29.626)),
    (669809, (1.133, 19.144, 23.162)),
    (577813, (0.937, 15.681, 24.731)),
    (422288, (4.001, 13.938, 22.611)),
    (652708, (7.930, 19.981, 27.478)),
    (873517, (5.568, 15.162, 20.035)),
    (96078, (8.531, 19.771, 21.953)),
    (365077, (5.709, 18.369, 28.481)),
    (289483, (6.194, 16.519, 26.561)),
    (272732, (8.765, 14.630, 23.046)),
    (526717, (4.903, 15.935, 20.468)),
    (585499, (9.063, 19.127, 21.119)),
    (265146, (2.194, 11.896, 24.936)),
    (361785, (0.325, 10.769, 22.874)),
    (348111, (2.827, 15.558, 25.492)),
    (200297, (5.288, 11.607, 25.958)),
    (232213, (7.532, 19.434, 28.467)),
    (758143, (4.705, 15.984, 28.433)),
    (520352, (3.752, 19.476, 26.867)),
    (913714, (7.934, 19.554, 25.706)),
    (338134, (0.895, 17.897, 22.742)),
    (524061, (9.651, 12.041, 21.519)),
    (959565, (7.701, 18.608, 23.400)),
    (352104, (3.099, 15.300, 21.536)),
    (860268, (0.988, 12.260, 23.560)),
    (784132, (3.664, 19.496, 26.724)),
    (487386, (8.471, 11.955, 20.333)),
    (652293, (7.912, 10.148, 26.067)),
    (742038, (0.653, 11.299, 27.126)),
    (474297, (1.565, 14.034, 28.849)),
    (867299, (2.750, 10.345, 26.381)),
    (541889, (8.058, 13.848, 20.525)),
    (425802, (9.348, 16.197, 25.033)),
    (465716, (4.725, 12.019, 21.282)),
    (517224, (0.791, 14.271, 22.699)),
    (559542, (0.521, 18.587, 20.369)),
    (42087, (0.011, 14.638, 21.272)),
    (461037, (3.635, 19.845, 26.636)),
    (114936, (8.163, 12.037, 26.760)),
    (183676, (1.568, 13.321, 24.354)),
    (348133, (0.577, 19.241, 24.800)),
    (707042, (6.710, 18.278, 27.479)),
    (418084, (1.709, 16.649, 28.749)),
    (924169, (6.058, 17.354, 22.194)),
    (262998, (0.134, 17.909, 24.275)),
    (73155, (4.322, 19.495, 25.626)),
    (919864, (4.837, 14.488, 21.435)),
    (159846, (5.523, 14.432, 25.670)),
    (171681, (4.152, 19.270, 29.438)),
    (880097, (8.028, 17.319, 24.386)),
    (311929, (9.405, 17.043, 26.344)),
    (310536, (1.810, 10.890, 24.024)),
    (601578, (6.529, 12.832, 24.115)),
    (629016, (1.211, 11.984, 25.448)),
    (178793, (8.665, 12.098, 25.726)),
    (390399, (8.764, 17.442, 27.549)),
    (40915, (1.196, 19.603, 27.674)),
    (37057, (4.842, 16.678, 23.697)),
    (490504, (2.674, 16.687, 27.668)),
    (141374, (8.074, 17.502, 23.491)),
    (985407, (4.306, 13.600, 24.982)),
    (38625, (3.321, 19.584, 26.999)),
    (491336, (1.764, 11.712, 29.128)),
    (49391, (9.203, 13.445, 24.336)),
    (716407, (6.184, 19.499, 20.516)),
    (708787, (2.528, 13.436, 24.730)),
    (124593, (8.605, 10.290, 20.100)),
    (196930, (0.307, 11.672, 23.667)),
    (451172, (7.124, 17.789, 27.131)),
    (670789, (8.373, 19.994, 24.730)),
    (806455, (5.188, 16.252, 22.757)),
    (49681, (4.991, 16.282, 27.014)),
    (692635, (0.742, 19.952, 20.231)),
    (738182, (0.312, 17.851, 27.934)),
    (534373, (2.557, 15.632, 24.103)),
    (426021, (4.805, 10.349, 29.737)),
    (218820, (4.841, 18.715, 28.669)),
    (489336, (4.959, 19.906, 27.790)),
    (188149, (8.823, 18.872, 29.506)),
    (582811, (6.785, 10.179, 23.685)),
    (433100, (7.658, 11.614, 22.244)),
    (892778, (0.512, 10.132, 22.847)),
    (833921, (0.111, 13.418, 27.209)),
    (425538, (5.103, 18.278, 27.263)),
    (60077, (3.731, 12.409, 21.924)),
    (213850, (0.767, 11.304, 24.584)),
    (30343, (9.623, 12.755, 26.457)),
    (621084, (6.338, 13.426, 23.709)),
    (275412, (4.746, 12.236, 25.158)),
    (361021, (0.408, 10.481, 25.877)),
    (629682, (6.772, 15.259, 22.677)),
    (793805, (9.335, 12.968, 26.252)),
    (250491, (7.567, 11.023, 20.719)),
    (182299, (8.352, 17.620, 22.006)),
    (22605, (3.248, 19.945, 21.622)),
    (380010, (1.002, 13.963, 27.998)),
    (186451, (9.432, 10.828, 23.972)),
    (578932, (2.708, 16.769, 27.967)),
    (378160, (3.218, 10.400, 29.167)),
    (936940, (5.534, 18.467, 25.501)),
    (448160, (6.920, 15.767, 22.581)),
    (395319, (6.920, 13.955, 28.333)),
    (989817, (4.336, 15.636, 26.320)),
    (818124, (2.944, 15.993, 29.917)),
    (420055, (6.861, 12.287, 29.877)),
    (732913, (8.337, 10.468, 26.955)),
    (432482, (0.717, 10.262, 24.319)),
    (357778, (0.548, 15.110, 24.905)),
    (230711, (1.458, 14.484, 29.402)),
    (24323, (3.518, 10.313, 27.744)),
    (813434, (7.808, 19.336, 26.030)),
    (831810, (2.416, 11.074, 20.066)),
    (21082, (6.630, 18.093, 24.535)),
    (220541, (7.523, 12.439, 25.741)),
    (852888, (8.845, 19.440, 29.962)),
    (675515, (8.274, 16.863, 27.235)),
    (154634, (6.596, 19.532, 27.345)),
    (440899, (1.187, 11.879, 29.150)),
    (112975, (0.354, 14.929, 27.762)),
    (941723, (6.048, 11.564, 24.404)),
    (947203, (0.437, 10.449, 26.766)),
    (296226, (4.362, 15.929, 22.468)),
    (711883, (4.951, 16.816, 20.552)),
    (354801, (0.493, 11.443, 27.218)),
    (196035, (8.974, 12.509, 25.065)),
    (518276, (7.050, 16.787, 29.097)),
    (474426, (2.215, 16.961, 21.665)),
    (101057, (4.730, 10.890, 20.726)),
    (441805, (2.076, 10.673, 22.731)),
    (275808, (3.849, 18.351, 26.809)),
    (542071, (9.187, 12.770, 24.541)),
    (561753, (2.477, 14.687, 26.980)),
    (122046, (6.133, 15.117, 22.909)),
    (390534, (8.938, 12.887, 28.910)),
    (729865, (2.216, 18.952, 26.122)),
    (232492, (0.325, 13.359, 24.403)),
    (642579, (5.449, 10.508, 22.032)),
    (52700, (8.592, 11.946, 22.917)),
    (205282, (7.966, 18.492, 25.901)),
    (906893, (4.411, 14.158, 25.016)),
    (653551, (0.789, 16.702, 23.702)),
    (161431, (5.458, 15.792, 23.104)),
    (305341, (1.818, 16.764, 25.051)),
    (494483, (4.262, 10.031, 23.054)),
    (162077, (7.813, 19.386, 24.936)),
    (406925, (1.087, 11.708, 22.035)),
    (306345, (4.797, 13.534, 28.818)),
    (934340, (2.497, 19.491, 27.227)),
    (387616, (6.607, 16.025, 24.033)),
    (108839, (3.885, 17.162, 22.485)),
    (633287, (5.259, 15.829, 27.841)),
    (507293, (5.332, 14.550, 22.877)),
    (608254, (6.449, 15.567, 20.908)),
    (837519, (0.979, 13.896, 22.377)),
    (77010, (9.628, 10.079, 29.175)),
    (813379, (0.589, 15.239, 26.207)),
    (957220, (3.669, 19.263, 20.660)),
    (92351, (5.295, 19.195, 29.370)),
    (5566, (0.270, 12.760, 23.867)),
    (939081, (1.184, 19.454, 21.107)),
    (547004, (9.852, 12.245, 28.421)),
    (492730, (3.624, 17.437, 26.410)),
    (96901, (2.964, 18.986, 23.085)),
    (419084, (7.871, 12.726, 21.155)),
    (171582, (9.320, 17.112, 21.277)),
    (971558, (8.746, 12.232, 22.466)),
    (791589, (0.913, 17.748, 27.827)),
    (755201, (0.580, 11.838, 28.787)),
    (513032, (6.053, 14.219, 27.942)),
    (193594, (5.132, 19.238, 22.546)),
    (954085, (2.353, 15.318, 26.064)),
    (237889, (6.875, 17.831, 24.043)),
    (9582, (2.161, 16.879, 20.259)),
    (225251, (3.749, 15.953, 25.711)),
    (498355, (2.992, 13.010, 29.547)),
    (692213, (5.818, 12.383, 27.542)),
    (636743, (5.116, 17.883, 25.446)),
    (455812, (9.388, 17.398, 24.661)),
    (67687, (9.701, 13.597, 26.532)),
    (807146, (9.182, 10.647, 25.831)),
    (162659, (7.568, 10.794, 22.141)),
    (563345, (0.696, 17.217, 27.531)),
    (181260, (9.375, 17.301, 28.865)),
    (68469, (4.452, 18.349, 21.409)),
    (610756, (0.508, 12.623, 24.619)),
    (301352, (4.167, 11.385, 27.211)),
    (894671, (1.731, 11.990, 25.295)),
    (665434, (5.159, 10.608, 29.232)),
    (852382, (9.103, 17.895, 24.781)),
    (937722, (6.845, 16.398, 23.299)),
    (342592, (4.836, 10.170, 27.922)),
    (662070, (3.812, 16.972, 27.814)),
    (26696, (6.819, 19.576, 25.943)),
    (368022, (4.836, 12.375, 26.910)),
    (378033, (9.768, 18.398, 22.229)),
    (721790, (6.351, 14.203, 25.253)),
    (617705, (6.188, 10.558, 21.023)),
    (315071, (0.555, 14.832, 29.336)),
    (14122, (3.152, 13.812, 22.184)),
    (302838, (6.250, 15.217, 29.143)),
    (29798, (7.966, 15.628, 26.604)),
    (574346, (6.317, 17.325, 28.568)),
    (718225, (2.538, 12.407, 21.028)),
    (427605, (1.898, 11.101, 22.058)),
    (958536, (2.764, 13.394, 27.430)),
    (932658, (6.077, 10.992, 26.829)),
    (233710, (9.449, 14.326, 22.024)),
    (856169, (3.300, 14.327, 28.151)),
    (988707, (1.200, 11.955, 26.551)),
    (650293, (5.850, 17.334, 29.533)),
    (362124, (9.335, 11.472, 28.054)),
    (628698, (5.523, 19.140, 21.463)),
    (220543, (7.068, 12.829, 22.351)),
    (806662, (2.410, 18.819, 23.862)),
    (404146, (1.394, 13.348, 20.735)),
    (507028, (5.564, 13.263, 23.682)),
    (141227, (0.230, 16.642, 21.081)),
    (735659, (4.190, 14.858, 25.055)),
    (783008, (1.196, 19.797, 24.228)),
    (913872, (5.156, 16.001, 25.142)),
    (769838, (1.878, 19.551, 22.139)),
    (864050, (5.130, 12.643, 27.008)),
    (38688, (2.002, 11.128, 22.914)),
    (519949, (9.755, 12.350, 24.488)),
    (386137, (0.897, 12.420, 24.735)),
    (100423, (0.636, 11.897, 24.478)),
    (44847, (1.770, 17.085, 26.177)),
    (679288, (7.705, 11.281, 24.019)),
    (13700, (1.908, 15.350, 29.048)),
    (162793, (8.630, 10.673, 27.861)),
    (844571, (2.276, 10.645, 22.823)),
    (847871, (2.856, 11.279, 21.528)),
    (935802, (7.014, 13.059, 24.413)),
    (779004, (7.939, 18.741, 28.165)),
    (560844, (4.736, 12.865, 26.246)),
    (146912, (3.465, 11.473, 29.468)),
    (792822, (6.372, 17.374, 28.360)),
    (294744, (8.648, 12.062, 27.441)),
    (507440, (2.749, 13.307, 26.520)),
    (923202, (5.091, 10.249, 24.391)),
    (204038, (5.496, 11.949, 27.586)),
    (601692, (6.709, 13.988, 27.529)),
    (68211, (6.818, 19.803, 28.149)),
    (937026, (9.641, 12.296, 27.676)),
    (271007, (9.685, 18.094, 28.054)),
    (924008, (6.118, 17.222, 28.668)),
    (920293, (4.294, 19.913, 20.629)),
    (132195, (3.794, 18.324, 20.399)),
    (138943, (4.910, 19.666, 23.185)),
    (700333, (7.577, 12.830, 29.468)),
    (181101, (6.604, 18.822, 22.365)),
    (413953, (3.837, 17.852, 25.544)),
    (340553, (0.168, 11.117, 21.415)),
    (660839, (2.371, 19.820, 23.168)),
    (978824, (6.043, 15.590, 20.118)),
    (915705, (9.421, 12.185, 20.468)),
    (563354, (6.795, 15.462, 23.798)),
    (314379, (1.595, 13.779, 21.980)),
    (53968, (0.538, 15.013, 23.609)),
    (773302, (6.184, 14.190, 26.226)),
    (630980, (3.411, 17.874, 27.714)),
    (51045, (9.748, 12.911, 21.374)),
    (415472, (1.526, 17.246, 27.347)),
    (561378, (9.991, 15.026, 24.902)),
    (377012, (8.257, 18.464, 23.025)),
    (710110, (5.821, 14.559, 25.048)),
    (396162, (0.801, 19.907, 27.845)),
    (126052, (8.981, 10.623, 26.355)),
    (755412, (4.398, 12.691, 22.828)),
    (664305, (9.330, 14.818, 20.628)),
    (840651, (3.640, 18.428, 22.436)),
    (375217, (8.549, 17.264, 26.144)),
    (520282, (6.085, 15.614, 22.276)),
    (162480, (4.765, 15.230, 25.855)),
    (815857, (9.313, 14.615, 27.547)),
    (694534, (1.065, 14.001, 21.045)),
    (636325, (0.751, 11.970, 21.556)),
    (8381, (6.038, 17.192, 28.057)),
    (321488, (2.320, 16.256, 25.662)),
    (64799, (0.855, 19.921, 21.649)),
    (375546, (2.461, 19.782, 28.783)),
    (328740, (3.633, 17.761, 21.090)),
    (414757, (3.331, 11.145, 25.595)),
    (897347, (8.470, 10.271, 27.952)),
    (187852, (8.694, 11.800, 26.388)),
    (436977, (0.187, 13.172, 28.550)),
    (995771, (5.135, 14.377, 22.982)),
    (990111, (2.893, 19.959, 27.141)),
    (94601, (0.397, 19.250, 29.351)),
    (623434, (1.821, 18.630, 25.411)),
    (635484, (8.209, 11.611, 29.860)),
    (58080, (5.812, 13.360, 25.186)),
    (472070, (1.758, 12.960, 29.139)),
    (290777, (1.753, 18.704, 25.741)),
    (69693, (3.908, 16.011, 26.210)),
    (858868, (3.163, 14.755, 27.664)),
    (542609, (6.454, 13.765, 22.929)),
    (977903, (1.365, 11.099, 23.949)),
    (403858, (7.066, 11.488, 29.682)),
    (144770, (7.670, 17.671, 25.626)),
    (2225, (9.571, 13.076, 27.571)),
    (706475, (7.485, 17.063, 29.834)),
    (522056, (5.853, 16.349, 20.213)),
    (855460, (9.654, 17.521, 27.082)),
    (577374, (0.455, 15.783, 24.656)),
    (220776, (6.977, 15.076, 20.243)),
    (374314, (2.908, 17.648, 27.749)),
    (441123, (7.040, 14.240, 26.619)),
    (356804, (2.481, 19.453, 22.817)),
    (140300, (6.622, 10.129, 25.981)),
    (705924, (7.348, 11.407, 24.807)),
    (990632, (3.704, 15.478, 21.737)),
    (630240, (9.611, 11.741, 20.175)),
    (159961, (0.848, 10.433, 28.004)),
    (597164, (4.939, 13.001, 26.042)),
    (352705, (4.993, 12.227, 22.257)),
    (311166, (4.765, 14.200, 25.773)),
    (386196, (4.958, 14.043, 20.807)),
    (254038, (7.735, 12.575, 26.326)),
    (612814, (6.070, 10.192, 23.793)),
    (466518, (5.072, 17.738, 21.365)),
    (745373, (7.562, 18.851, 21.673)),
    (537992, (6.066, 17.320, 29.221)),
    (790909, (7.100, 16.768, 25.783)),
    (541496, (1.967, 15.707, 23.841)),
    (379335, (6.733, 18.600, 21.407)),
    (273387, (9.376, 13.009, 25.904)),
    (617564, (8.927, 16.202, 21.243)),
    (436156, (0.737, 15.475, 27.585)),
    (964148, (0.875, 16.108, 28.817)),
    (82727, (5.399, 16.601, 26.639)),
    (879766, (5.090, 10.691, 23.208)),
    (268513, (0.847, 11.052, 28.571)),
    (470153, (5.801, 13.434, 25.678)),
    (406081, (4.393, 13.364, 21.665)),
    (171272, (7.613, 15.567, 25.733)),
    (322380, (9.712, 16.981, 28.734)),
    (742837, (4.451, 12.651, 21.149)),
    (13715, (2.981, 15.175, 22.611)),
    (210293, (2.824, 12.892, 23.717)),
    (944572, (1.977, 10.799, 27.832)),
    (903800, (3.915, 18.555, 22.233)),
    (813287, (0.375, 16.379, 21.853)),
    (51493, (5.404, 16.828, 28.527)),
    (811490, (2.102, 17.534, 26.811)),
    (951222, (3.129, 17.335, 25.429)),
    (687348, (6.014, 18.309, 20.823)),
    (34228, (2.228, 11.212, 23.174)),
    (817745, (8.535, 12.706, 22.086)),
    (229952, (8.937, 19.026, 24.371)),
    (556197, (0.006, 16.838, 22.067)),
    (172054, (2.554, 17.384, 25.467)),
    (319182, (5.974, 12.194, 22.946)),
    (25823, (4.957, 15.746, 25.942)),
    (408980, (6.549, 13.075, 26.874)),
    (49394, (3.353, 19.382, 24.970)),
    (494965, (2.251, 17.639, 23.501)),
    (452126, (2.846, 13.497, 20.496)),
    (838757, (7.985, 15.815, 26.439)),
    (772613, (1.747, 18.122, 23.162)),
    (369529, (8.168, 15.547, 24.897)),
    (639959, (8.327, 10.345, 20.826)),
    (519296, (5.345, 17.583, 21.220)),
    (476524, (6.090, 15.834, 26.871)),
    (20069, (4.614, 19.567, 22.994)),
    (56801, (4.438, 10.939, 21.286)),
    (990560, (5.150, 14.762, 23.573)),
    (421879, (3.978, 12.079, 28.476)),
    (945771, (8.703, 10.601, 29.933)),
    (225429, (2.762, 18.748, 24.961)),
    (891681, (8.814, 19.011, 29.958)),
    (876466, (3.277, 13.458, 20.384)),
    (705745, (0.345, 16.192, 21.924)),
    (305735, (5.320, 14.491, 20.750)),
    (103042, (9.845, 18.918, 26.192)),
    (831265, (4.679, 12.471, 27.151)),
    (596442, (8.731, 10.157, 22.155)),
    (334860, (8.076, 11.868, 28.800)),
    (206140, (3.788, 15.861, 20.822)),
    (954745, (5.152, 10.154, 28.701)),
    (949437, (4.348, 11.573, 28.074)),
    (866361, (8.578, 15.433, 25.456)),
    (747003, (6.525, 14.071, 21.582)),
    (6535, (3.239, 19.737, 20.581)),
    (130625, (3.019, 13.382, 24.916)),
    (934126, (6.778, 12.839, 24.128)),
    (174905, (9.603, 19.995, 25.265)),
    (851533, (6.019, 11.769, 24.493)),
    (252951, (9.067, 11.674, 21.042)),
    (933376, (5.750, 18.629, 28.891)),
    (944166, (6.742, 17.992, 25.659)),
    (775816, (3.913, 18.909, 29.202)),
    (328587, (8.990, 12.231, 27.589)),
    (368781, (6.092, 13.842, 29.287)),
    (221750, (9.893, 12.851, 26.409)),
    (292271, (6.244, 18.876, 24.057)),
    (240306, (7.468, 12.272, 21.053)),
    (749842, (1.431, 18.992, 25.606)),
    (261845, (2.894, 15.987, 25.526)),
    (73989, (9.313, 17.297, 29.161)),
    (380155, (3.880, 12.003, 26.818)),
    (268566, (9.534, 13.402, 21.351)),
    (73365, (9.439, 16.949, 29.519)),
    (886505, (5.538, 17.980, 20.525)),
    (387375, (7.066, 16.310, 25.923)),
    (753197, (1.053, 14.968, 22.074)),
    (693271, (4.572, 18.995, 20.132)),
    (751440, (4.605, 15.151, 24.676)),
    (85574, (0.542, 12.267, 21.127)),
    (125269, (0.139, 18.880, 22.377)),
    (177337, (1.278, 15.059, 21.632)),
    (190328, (5.179, 11.058, 25.632)),
    (971035, (5.077, 13.585, 26.649)),
    (569616, (1.975, 12.160, 21.626)),
    (216857, (4.741, 16.349, 27.069)),
    (770182, (9.428, 15.461, 26.277)),
    (905325, (7.425, 15.534, 26.270)),
    (56857, (0.302, 11.040, 26.538)),
    (895673, (1.057, 15.281, 23.477)),
    (708491, (9.521, 15.620, 25.917)),
    (809251, (7.450, 17.570, 21.808)),
    (686366, (4.943, 11.966, 29.683)),
    (528678, (0.332, 18.169, 26.744)),
    (521676, (0.237, 15.891, 21.095)),
    (529432, (0.988, 18.644, 29.537)),
    (415072, (8.544, 19.731, 21.591)),
    (389024, (4.803, 17.716, 23.806)),
    (183428, (4.059, 17.440, 29.018)),
    (756465, (7.329, 10.311, 23.426)),
    (78611, (3.747, 18.509, 27.528)),
    (450681, (0.285, 12.636, 27.587)),
    (302338, (8.484, 11.773, 21.119)),
    (785430, (8.131, 10.310, 20.816)),
    (350313, (7.223, 11.682, 24.548)),
    (751067, (3.028, 12.701, 28.694)),
    (872565, (4.052, 12.524, 25.760)),
    (579417, (7.184, 15.370, 28.798)),
    (664888, (9.894, 16.698, 20.708)),
    (898973, (3.577, 11.351, 28.890)),
    (254957, (7.597, 14.729, 25.183)),
    (340969, (1.949, 11.283, 20.787)),
    (741282, (3.457, 19.759, 22.678)),
    (946649, (6.887, 11.700, 23.114)),
    (496629, (8.602, 16.316, 20.555)),
    (288872, (6.032, 17.568, 21.093)),
    (801552, (3.045, 12.384, 23.176)),
    (677764, (0.728, 13.168, 28.851)),
    (137928, (3.873, 12.923, 29.997)),
    (220023, (8.588, 13.097, 22.325)),
    (200666, (7.559, 19.560, 28.153)),
    (510711, (1.721, 12.723, 23.591)),
    (27650, (4.903, 16.564, 21.750)),
    (914090, (2.199, 11.566, 26.239)),
    (646783, (5.770, 14.455, 21.453)),
    (358931, (6.450, 12.135, 24.379)),
    (465975, (2.679, 14.837, 20.361)),
    (586388, (6.519, 18.629, 22.494)),
    (750139, (3.613, 16.491, 27.962)),
    (73229, (9.959, 10.746, 23.016)),
    (68747, (6.614, 11.606, 26.030)),
    (674807, (0.544, 19.916, 25.183)),
    (207770, (9.094, 12.192, 25.577)),
    (767642, (4.761, 19.903, 27.304)),
    (15485, (9.235, 14.878, 27.257)),
    (917498, (6.258, 15.517, 21.642)),
    (600027, (3.416, 17.352, 28.833)),
    (938733, (8.686, 14.515, 21.805)),
    (263473, (9.669, 10.327, 28.562)),
    (392602, (4.254, 12.921, 24.283)),
    (418679, (8.158, 15.394, 28.496)),
    (649788, (6.344, 18.086, 23.625)),
    (204696, (7.891, 18.005, 24.149)),
    (551917, (8.122, 15.459, 21.173)),
    (329444, (3.518, 16.835, 24.776)),
    (138457, (7.336, 18.971, 21.131)),
    (402139, (5.992, 11.944, 26.200)),
    (50113, (6.065, 17.570, 27.040)),
    (178011, (6.452, 12.947, 26.137)),
    (243427, (1.820, 11.322, 20.165)),
    (682207, (9.446, 18.353, 26.804)),
    (587416, (9.351, 17.426, 29.219)),
    (186467, (2.359, 12.655, 24.092)),
    (657824, (6.816, 16.610, 21.376)),
    (871607, (4.890, 11.021, 23.454)),
    (534523, (8.305, 13.710, 26.587)),
    (870353, (3.196, 18.942, 23.871)),
    (542691, (3.024, 17.739, 28.616)),
    (944378, (5.372, 13.757, 24.747)),
    (851456, (9.277, 16.341, 26.011)),
    (140644, (0.384, 12.619, 27.239)),
    (973629, (5.630, 15.403, 21.331)),
    (20996, (2.677, 12.845, 21.454)),
    (440014, (4.202, 11.085, 27.236)),
    (67206, (7.036, 13.340, 22.135)),
    (577534, (2.318, 19.974, 27.059)),
    (356712, (1.124, 19.180, 25.621)),
    (426907, (8.688, 11.211, 24.980)),
    (845347, (9.765, 18.303, 27.453)),
    (848340, (3.913, 15.328, 27.005)),
    (722889, (6.205, 17.700, 27.495)),
    (285764, (8.657, 14.284, 28.668)),
    (963878, (3.165, 17.553, 20.503)),
    (161604, (6.298, 17.935, 21.512)),
    (84393, (5.921, 16.587, 23.981)),
    (305657, (3.859, 12.659, 27.213)),
    (424102, (7.293, 19.227, 25.204)),
    (376499, (3.884, 13.715, 26.214)),
    (871275, (1.335, 17.983, 20.573)),
    (904178, (4.760, 13.474, 21.287)),
    (234689, (8.617, 19.940, 22.395)),
    (711098, (5.917, 16.281, 20.745)),
    (304987, (9.577, 18.165, 23.914)),
    (129512, (7.622, 18.667, 26.619)),
    (790851, (7.813, 18.513, 20.956)),
    (290678, (6.571, 17.621, 29.408)),
    (233895, (0.760, 14.227, 22.925)),
    (812467, (0.555, 14.959, 20.045)),
    (97281, (9.472, 15.125, 29.451)),
    (525603, (1.363, 10.987, 27.694)),
    (926357, (2.665, 10.102, 28.741)),
    (559503, (9.058, 19.543, 20.993)),
    (33491, (5.338, 19.749, 25.243)),
    (532252, (2.853, 13.631, 29.876)),
    (726775, (3.135, 19.206, 27.657)),
    (37482, (2.914, 12.065, 27.541)),
    (601114, (0.028, 16.963, 25.432)),
    (261958, (4.328, 18.989, 25.350)),
    (799577, (2.132, 12.449, 28.416)),
    (707336, (7.850, 13.037, 22.242)),
    (478025, (1.604, 19.603, 29.602)),
    (281063, (9.360, 18.565, 26.913)),
    (547513, (9.208, 10.048, 23.471)),
    (102620, (0.613, 14.776, 21.703)),
    (738028, (5.202, 10.525, 26.516)),
    (249218, (1.106, 15.080, 21.366)),
    (107726, (7.315, 12.147, 28.593)),
    (188129, (4.256, 12.221, 28.759)),
    (484558, (3.690, 17.384, 29.030)),
    (475005, (7.971, 16.829, 22.261)),
    (155563, (7.714, 14.853, 20.865)),
    (131881, (4.384, 16.223, 27.069)),
    (827145, (5.864, 11.460, 21.074)),
    (914405, (4.854, 14.181, 21.628)),
    (12565, (9.486, 10.692, 27.860)),
    (949412, (2.866, 15.697, 20.820)),
    (681184, (0.944, 10.679, 22.156)),
    (875293, (5.486, 18.418, 24.169)),
    (656740, (1.961, 10.630, 23.462)),
    (553805, (5.558, 17.068, 26.761)),
    (826756, (0.173, 11.822, 28.750)),
    (701642, (3.553, 14.589, 22.926)),
    (590001, (8.632, 10.933, 27.197)),
    (254006, (8.278, 12.838, 21.984)),
    (468955, (0.138, 17.543, 26.448)),
    (250949, (9.021, 12.006, 28.835)),
    (75297, (0.385, 10.605, 29.586)),
    (712320, (8.225, 13.700, 20.857)),
    (87508, (2.819, 19.667, 21.668)),
    (655566, (6.365, 19.738, 21.560)),
    (73617, (0.794, 15.219, 24.464)),
    (742547, (7.356, 16.175, 22.489)),
    (503457, (9.358, 11.323, 23.091)),
    (73624, (2.127, 17.030, 23.990)),
    (840847, (7.885, 12.457, 27.260)),
    (37597, (9.474, 13.153, 20.803)),
    (996902, (7.562, 16.328, 29.975)),
    (874148, (2.716, 13.876, 26.793)),
    (546905, (8.676, 12.438, 24.574)),
    (111408, (3.867, 17.376, 20.011)),
    (666190, (4.053, 12.732, 23.874)),
    (841820, (5.765, 13.958, 26.837)),
    (739353, (4.727, 19.984, 20.045)),
    (982406, (1.595, 19.084, 28.719)),
    (484619, (2.460, 16.999, 23.979)),
    (754770, (1.577, 11.138, 26.862)),
    (590638, (5.500, 16.492, 25.189)),
    (109292, (7.756, 16.121, 20.306)),
    (863421, (0.586, 19.143, 23.833)),
    (896423, (5.061, 11.887, 28.017)),
    (938943, (8.479, 19.595, 21.168)),
    (419361, (4.629, 16.138, 26.907)),
    (451212, (1.239, 10.280, 20.946)),
    (221645, (6.835, 12.596, 24.332)),
    (371893, (1.036, 10.101, 22.803)),
    (380421, (8.844, 12.462, 21.293)),
    (891250, (8.048, 15.853, 22.050)),
    (278828, (6.492, 10.891, 22.246)),
    (642071, (3.962, 16.637, 28.348)),
    (641194, (7.148, 19.230, 27.669)),
    (842192, (5.344, 14.893, 28.991)),
    (508701, (9.736, 10.858, 28.762)),
    (902606, (8.385, 14.152, 24.954)),
    (562418, (1.213, 16.680, 23.663)),
    (589608, (3.958, 17.953, 22.125)),
    (360263, (9.914, 18.119, 22.676)),
    (932091, (5.052, 15.173, 29.002)),
    (717368, (3.016, 14.975, 24.201)),
    (509236, (5.498, 18.888, 29.198)),
    (331371, (0.106, 17.299, 26.572)),
    (270297, (2.367, 16.419, 25.470)),
    (960832, (7.176, 11.703, 25.865)),
    (214194, (5.705, 15.213, 28.065)),
    (680389, (2.141, 16.891, 21.930)),
    (679299, (9.803, 12.472, 25.724)),
    (760, (3.322, 10.049, 22.716)),
    (114381, (9.521, 10.989, 29.310)),
    (382261, (3.472, 13.012, 28.412)),
    (602254, (2.666, 11.432, 22.828)),
    (267135, (4.670, 11.415, 29.707)),
    (74821, (4.192, 15.411, 29.092)),
    (824009, (6.904, 16.175, 24.116)),
    (370793, (6.634, 14.259, 21.943)),
    (897278, (0.172, 16.541, 28.536)),
    (151853, (0.562, 19.336, 22.036)),
    (164396, (7.018, 12.768, 22.586)),
    (613653, (0.267, 17.295, 29.659)),
    (271965, (5.168, 11.156, 25.632)),
    (353644, (4.413, 18.232, 26.529)),
    (497619, (3.000, 11.009, 28.614)),
    (966518, (3.729, 18.197, 23.187)),
    (378353, (6.236, 12.821, 26.200)),
    (66153, (1.973, 11.157, 25.043)),
    (401176, (4.422, 16.078, 25.736)),
    (736846, (7.634, 10.982, 24.735)),
    (740916, (4.671, 15.098, 20.831)),
    (939959, (8.123, 14.812, 29.729)),
    (684688, (5.002, 19.010, 20.621)),
    (726194, (0.219, 11.997, 27.621)),
    (102130, (1.098, 13.031, 21.353)),
    (871543, (4.686, 16.283, 22.045)),
    (969799, (8.460, 13.869, 29.349)),
    (996114, (0.950, 12.689, 25.648)),
    (757123, (2.729, 10.595, 29.407)),
    (107228, (6.574, 13.372, 24.009)),
    (437855, (0.286, 19.678, 24.567)),
    (305411, (8.724, 11.023, 23.866)),
    (713774, (7.655, 10.147, 27.402)),
    (154721, (5.533, 12.240, 28.726)),
    (73566, (7.166, 12.431, 20.526)),
    (629786, (9.543, 11.409, 21.684)),
    (90776, (5.401, 12.626, 26.233)),
    (599073, (6.533, 17.962, 20.511)),
    (876716, (9.228, 15.440, 22.655)),
    (927865, (1.816, 15.167, 28.830)),
    (462189, (3.559, 11.346, 27.615)),
    (82378, (0.732, 13.016, 22.840)),
    (825844, (6.404, 16.606, 21.730)),
    (506177, (9.170, 13.755, 27.794)),
    (589651, (3.142, 14.717, 28.664)),
    (323351, (8.357, 19.386, 21.985)),
    (613121, (2.896, 16.588, 21.118)),
    (748331, (7.761, 18.228, 25.489)),
    (568782, (3.315, 14.245, 24.507)),
    (24327, (7.667, 19.875, 28.181)),
    (533592, (9.587, 16.399, 24.758)),
    (308201, (7.958, 12.119, 20.159)),
    (702369, (7.184, 16.758, 24.139)),
    (690307, (8.664, 12.715, 24.459)),
    (861027, (3.721, 18.554, 27.487)),
    (601847, (3.149, 16.022, 22.165)),
    (945659, (8.571, 15.061, 26.319)),
    (356981, (6.547, 15.457, 28.888)),
    (964347, (3.395, 15.360, 25.542)),
    (219679, (9.604, 18.987, 25.029)),
    (79442, (1.338, 12.392, 22.437)),
    (880655, (3.956, 11.382, 25.008)),
    (761419, (4.886, 19.365, 24.738)),
    (15913, (4.188, 11.100, 21.053)),
    (492960, (1.080, 11.279, 25.872)),
    (837605, (9.228, 19.259, 21.943)),
    (969006, (0.062, 15.837, 28.235)),
    (678121, (0.258, 17.065, 23.743)),
    (342611, (6.964, 17.119, 29.540)),
    (484118, (3.690, 16.977, 24.126)),
    (149454, (3.491, 13.671, 25.161)),
    (722888, (1.722, 16.846, 26.988)),
    (659746, (1.393, 14.912, 21.258)),
    (783373, (7.999, 19.537, 21.504)),
    (312588, (1.268, 15.870, 21.364)),
    (179756, (2.394, 12.994, 20.347)),
    (32736, (4.916, 14.581, 21.425)),
    (527776, (1.867, 10.531, 23.771)),
    (194268, (1.075, 16.919, 21.298)),
    (121027, (1.858, 18.801, 23.671)),
    (790716, (8.224, 18.946, 28.336)),
    (689450, (3.121, 13.570, 26.796)),
    (966421, (0.392, 16.765, 25.469)),
    (38746, (1.950, 12.568, 20.862)),
    (868432, (0.001, 18.839, 21.949)),
    (161849, (6.230, 12.712, 23.628)),
    (713435, (8.299, 11.113, 29.985)),
    (808850, (4.333, 12.220, 28.839)),
    (810138, (2.507, 14.533, 20.304)),
    (880838, (2.161, 18.083, 28.470)),
    (247611, (3.885, 13.834, 26.944)),
    (108608, (7.263, 11.387, 24.704)),
    (118051, (7.911, 10.272, 29.112)),
    (859951, (5.727, 18.256, 25.587)),
    (17445, (4.937, 15.790, 29.243)),
    (170740, (4.496, 16.144, 21.850)),
    (998314, (8.932, 19.301, 29.301)),
    (976938, (2.900, 18.470, 28.040)),
    (361008, (4.902, 15.697, 23.477)),
    (486195, (3.322, 12.533, 21.264)),
    (724188, (1.980, 18.786, 29.402)),
    (469255, (4.086, 10.716, 23.924)),
    (140992, (7.737, 14.632, 20.920)),
    (524396, (1.734, 13.402, 27.430)),
    (480581, (2.298, 18.331, 28.779)),
    (997683, (9.513, 13.430, 26.168)),
    (768947, (1.221, 13.089, 24.349)),
    (149263, (1.042, 19.740, 27.086)),
    (927010, (7.145, 11.041, 23.355)),
    (364626, (9.246, 19.302, 27.450)),
    (386672, (1.258, 14.007, 27.495)),
    (448085, (6.104, 19.098, 21.904)),
    (617111, (3.193, 11.009, 29.538)),
    (840566, (8.306, 15.181, 26.842)),
    (503642, (2.646, 16.845, 23.309)),
    (547755, (2.813, 11.184, 22.106)),
    (302362, (9.224, 12.934, 21.698)),
    (669253, (6.561, 15.516, 25.615)),
    (592390, (4.346, 19.823, 26.459)),
    (69506, (8.069, 16.303, 23.964)),
    (249209, (5.206, 17.082, 29.393)),
    (371905, (0.958, 14.340, 29.905)),
    (129199, (6.250, 12.575, 23.939)),
    (440959, (0.232, 14.791, 23.772)),
    (804943, (2.366, 10.026, 29.974)),
    (573597, (8.254, 17.598, 22.190)),
    (211407, (5.408, 12.342, 22.638)),
    (462110, (5.617, 16.500, 26.994)),
    (587896, (9.150, 13.864, 25.676)),
    (561961, (2.370, 13.288, 25.974)),
    (159405, (8.491, 15.969, 29.623)),
    (967127, (6.866, 14.577, 25.889)),
    (757333, (5.568, 13.686, 21.534)),
    (153478, (0.320, 11.660, 23.632)),
    (247917, (8.664, 14.717, 28.604)),
    (640002, (9.305, 10.562, 28.811)),
    (254866, (7.525, 16.454, 24.386)),
    (481201, (5.641, 16.907, 29.815)),
    (858225, (9.789, 17.528, 24.445)),
    (118424, (3.909, 15.402, 22.211)),
    (518956, (7.621, 19.686, 20.574)),
    (543900, (8.710, 19.741, 20.963)),
    (803233, (1.708, 10.473, 26.060)),
    (799814, (0.860, 17.724, 24.066)),
    (134638, (0.101, 16.657, 21.192)),
    (240086, (5.383, 13.554, 23.571)),
    (739594, (0.001, 10.830, 27.409)),
    (881200, (8.276, 18.458, 28.292)),
    (56925, (1.642, 17.156, 25.002)),
    (540614, (4.149, 10.369, 29.946)),
    (897640, (2.801, 17.424, 26.169)),
    (554075, (3.549, 17.532, 27.551)),
    (884500, (9.410, 15.960, 20.873)),
    (713536, (9.707, 11.494, 22.148)),
    (651502, (9.766, 13.359, 20.801)),
    (17496, (9.457, 14.733, 21.945)),
    (79654, (1.816, 10.471, 29.055)),
    (201377, (5.474, 10.575, 23.070)),
    (500566, (3.207, 11.872, 27.810)),
    (499243, (3.263, 15.956, 27.697)),
    (748378, (8.403, 12.083, 29.574)),
    (785238, (6.349, 11.981, 22.834)),
    (537309, (2.635, 17.312, 24.224)),
    (933399, (5.396, 11.159, 24.660)),
    (578084, (0.627, 11.762, 23.521)),
    (770719, (8.684, 11.656, 20.756)),
    (739802, (4.883, 11.116, 20.770)),
    (940252, (3.514, 12.870, 23.168)),
    (122628, (0.723, 12.738, 28.175)),
    (64986, (6.334, 19.615, 26.912)),
    (876964, (7.705, 16.306, 23.923)),
    (852542, (5.431, 17.817, 22.910)),
    (903149, (1.905, 18.945, 26.197)),
    (451688, (3.060, 19.925, 20.621)),
    (93272, (4.484, 10.674, 23.073)),
    (69179, (6.169, 12.695, 25.971)),
    (253837, (1.805, 10.135, 20.590)),
    (134500, (1.996, 18.145, 22.238)),
    (110409, (9.351, 14.940, 26.844)),
    (353793, (6.636, 13.259, 27.081)),
    (172188, (9.671, 11.266, 22.652)),
    (30652, (7.198, 12.060, 23.393)),
    (746096, (9.962, 11.741, 21.533)),
    (209007, (2.761, 15.900, 24.396)),
    (875734, (3.271, 19.620, 25.109)),
    (710492, (0.041, 18.005, 28.167)),
    (388697, (5.415, 17.978, 20.107)),
    (292013, (3.724, 16.510, 22.861)),
    (112489, (9.989, 11.292, 29.041)),
    (115405, (8.649, 19.314, 27.081)),
    (251415, (3.089, 12.720, 22.223)),
    (611569, (0.929, 14.106, 22.566)),
    (63608, (9.558, 19.587, 23.649)),
    (616318, (9.077, 11.389, 23.078)),
    (639431, (6.273, 12.654, 24.083)),
    (498446, (3.654, 12.280, 26.994)),
    (675505, (2.219, 10.802, 22.620)),
    (427483, (1.433, 18.238, 22.150)),
    (429665, (7.125, 14.760, 21.016)),
    (800454, (2.693, 16.685, 27.246)),
    (656674, (2.277, 10.035, 20.337)),
    (586325, (8.973, 15.595, 25.845)),
    (637867, (2.314, 13.181, 21.982)),
    (943981, (5.245, 13.263, 23.187)),
    (322267, (9.992, 17.310, 27.284)),
    (398208, (4.585, 10.522, 24.835)),
    (953376, (4.289, 11.364, 25.010)),
    (846288, (2.457, 16.866, 20.042)),
    (634142, (9.625, 15.269, 26.069)),
    (104485, (4.188, 13.189, 24.105)),
    (119652, (5.718, 11.960, 24.434)),
    (749693, (3.457, 16.235, 25.593)),
    (133395, (1.201, 19.055, 29.404)),
    (946892, (4.377, 19.389, 29.680)),
    (181163, (7.473, 12.973, 26.191)),
    (103466, (5.351, 11.061, 27.452)),
    (811196, (2.504, 15.654, 26.560)),
    (684740, (0.994, 17.741, 27.776)),
    (754214, (5.166, 12.918, 20.538)),
    (303523, (5.810, 16.060, 26.661)),
    (61689, (2.066, 19.581, 23.541)),
    (220423, (5.378, 18.780, 25.779)),
    (368948, (1.031, 12.320, 27.182)),
    (329904, (8.259, 15.954, 20.774)),
    (418132, (3.550, 19.274, 26.747)),
    (700263, (0.909, 13.962, 23.949)),
    (901444, (9.663, 17.461, 26.216)),
    (177769, (3.427, 12.987, 26.693)),
    (722574, (8.089, 18.903, 20.067)),
    (541871, (2.127, 11.363, 28.980)),
    (466270, (2.110, 18.800, 26.966)),
    (657387, (4.274, 11.681, 20.297)),
    (373117, (4.949, 15.285, 29.117)),
    (846222, (5.097, 12.246, 23.628)),
    (52487, (8.841, 13.592, 29.932)),
    (351332, (0.228, 18.124, 29.015)),
    (998233, (3.418, 19.537, 21.449)),
    (86864, (6.164, 18.736, 20.827)),
    (103231, (8.788, 13.395, 28.982)),
    (584128, (0.026, 15.417, 20.295)),
    (811814, (4.835, 17.827, 28.582)),
    (807076, (2.595, 18.007, 28.535)),
    (47278, (6.789, 13.340, 23.375)),
    (253972, (6.635, 15.880, 28.727)),
    (229438, (7.994, 19.139, 22.028)),
    (944106, (5.296, 15.808, 27.829)),
    (836527, (3.958, 18.007, 23.152)),
    (489307, (1.420, 18.670, 26.206)),
    (663994, (6.039, 17.914, 24.546)),
    (444306, (0.047, 17.019, 23.837)),
    (865652, (2.214, 14.960, 22.749)),
    (251602, (1.095, 18.030, 21.778)),
    (182457, (2.374, 13.409, 23.859)),
    (76378, (1.683, 15.547, 25.446)),
    (630561, (7.647, 17.119, 28.986)),
    (935472, (2.861, 12.265, 21.558)),
    (841523, (7.892, 16.320, 22.951)),
    (914046, (0.753, 14.827, 25.822)),
    (981527, (5.642, 17.787, 26.566)),
    (88353, (8.009, 16.343, 23.117)),
    (65803, (9.629, 19.882, 21.725)),
    (382152, (3.613, 15.407, 26.406)),
    (574426, (8.881, 18.728, 24.556)),
    (343577, (4.057, 10.188, 21.239)),
    (542842, (6.616, 15.459, 25.798)),
    (133605, (4.002, 17.061, 23.722)),
    (610375, (1.918, 10.515, 27.706)),
    (953163, (4.505, 18.319, 23.638)),
    (768466, (5.110, 10.032, 22.854)),
    (694696, (8.217, 11.721, 22.397)),
    (322248, (5.271, 17.746, 26.502)),
    (482796, (6.058, 14.890, 27.377)),
    (785844, (9.286, 15.423, 25.971)),
    (885819, (5.344, 10.640, 25.341)),
    (263028, (3.879, 14.369, 29.083)),
    (564619, (3.261, 15.234, 24.441)),
    (609693, (8.209, 10.327, 22.766)),
    (888749, (5.532, 11.238, 26.549)),
    (652357, (2.725, 13.622, 24.146)),
    (573219, (3.335, 17.232, 21.647)),
    (826891, (2.813, 12.982, 20.199)),
    (498184, (3.441, 13.867, 24.337)),
    (591521, (1.004, 16.032, 26.922)),
    (136401, (9.511, 17.923, 25.234)),
    (362401, (9.642, 19.301, 25.079)),
    (316872, (0.118, 16.689, 24.408)),
    (81359, (3.051, 17.182, 28.556)),
    (994382, (1.463, 16.816, 27.053)),
    (178947, (2.404, 17.780, 20.429)),
    (359675, (9.643, 16.837, 20.525)),
    (622114, (1.496, 12.634, 24.396)),
    (196989, (3.583, 12.998, 25.129)),
    (90094, (0.911, 13.647, 28.361)),
    (168240, (6.779, 14.424, 22.979)),
    (407439, (7.290, 14.516, 22.128)),
    (856072, (4.334, 18.975, 23.513)),
    (454296, (7.375, 14.276, 25.278)),
    (670101, (6.451, 10.408, 27.729)),
    (739924, (1.516, 18.580, 25.641)),
    (951303, (3.099, 19.685, 21.597)),
    (566601, (1.784, 16.177, 25.286)),
    (995714, (3.257, 15.865, 26.998)),
    (797367, (5.944, 12.926, 20.405)),
    (99357, (1.322, 14.366, 26.587)),
    (954735, (7.296, 12.491, 28.189)),
    (173999, (9.845, 18.909, 29.257)),
    (197523, (1.614, 11.812, 29.700)),
    (868567, (6.969, 18.320, 24.642)),
    (760319, (9.064, 11.597, 27.811)),
    (570962, (2.596, 10.558, 20.238)),
    (267341, (1.483, 17.393, 22.876)),
    (635559, (3.033, 15.802, 27.933)),
    (753414, (4.493, 15.581, 20.939)),
    (367987, (0.884, 13.309, 27.302)),
    (257454, (1.837, 17.454, 27.500)),
    (980105, (6.377, 15.753, 28.248)),
    (766955, (0.702, 17.951, 28.968)),
    (159377, (1.546, 12.878, 28.781)),
    (413123, (9.728, 10.613, 28.359)),
    (597492, (8.858, 13.571, 24.505)),
    (117315, (5.226, 12.682, 27.914)),
    (958380, (3.384, 13.139, 27.942)),
    (564515, (4.532, 11.847, 24.993)),
    (720222, (0.105, 11.520, 23.902)),
    (965796, (0.023, 13.934, 20.912)),
    (165507, (8.533, 17.973, 21.238)),
    (983430, (2.019, 12.005, 24.269)),
    (165533, (3.953, 16.913, 29.937)),
    (308669, (6.714, 19.767, 25.176)),
    (173553, (5.024, 18.925, 25.029)),
    (159220, (8.207, 11.526, 21.099)),
    (570456, (4.943, 15.154, 29.438)),
    (723904, (0.615, 12.853, 24.127)),
    (892828, (2.534, 17.726, 24.005)),
    (631946, (5.938, 19.467, 22.240)),
    (499088, (4.749, 15.815, 23.562)),
    (997245, (8.123, 12.557, 25.041)),
    (533937, (9.584, 18.972, 27.651)),
    (723199, (8.258, 15.255, 23.206)),
    (888245, (0.042, 18.034, 23.167)),
    (163888, (5.967, 13.552, 29.404)),
    (350735, (3.155, 10.747, 26.519)),
    (595528, (9.632, 19.031, 28.406)),
    (510398, (2.702, 19.439, 20.760)),
    (445008, (5.457, 13.635, 20.643)),
    (974175, (6.467, 14.917, 27.951)),
    (331475, (2.122, 14.565, 20.249)),
    (777922, (7.056, 12.947, 24.522)),
    (94467, (3.038, 15.748, 24.093)),
    (500524, (5.109, 12.529, 27.513)),
    (641844, (5.865, 17.831, 21.101)),
    (376854, (0.743, 14.069, 23.247)),
    (647802, (7.560, 13.080, 27.009)),
    (236603, (4.546, 15.282, 25.074)),
    (515417, (6.734, 18.539, 21.675)),
    (861681, (4.867, 14.996, 21.459)),
    (123651, (1.533, 19.810, 23.519)),
    (863129, (1.542, 18.452, 25.161)),
    (516488, (8.838, 14.728, 21.535)),
    (225295, (1.188, 17.207, 20.412)),
    (875523, (1.152, 14.890, 24.185)),
    (750546, (5.268, 16.390, 21.132)),
    (243359, (3.060, 10.962, 24.357)),
    (281357, (6.476, 10.850, 26.725)),
    (12673, (4.887, 10.761, 23.838)),
    (299396, (3.880, 16.451, 23.771)),
    (680769, (5.600, 13.539, 27.918)),
    (24284, (4.011, 19.880, 28.429)),
    (611030, (3.430, 17.131, 25.729)),
    (718035, (8.824, 16.097, 26.842)),
    (429725, (4.151, 13.385, 29.212)),
    (137604, (3.470, 13.521, 28.178)),
    (56893, (8.010, 13.444, 22.150)),
    (8613, (5.039, 17.910, 26.705)),
    (930331, (3.692, 17.877, 27.737)),
    (888157, (4.629, 14.665, 25.525)),
    (760739, (8.325, 17.756, 29.700)),
    (674284, (6.865, 19.250, 20.548)),
    (134992, (2.717, 15.061, 26.319)),
    (7549, (0.097, 12.983, 24.974)),
    (662325, (7.025, 11.002, 28.803)),
    (990830, (8.620, 19.734, 23.143)),
    (29063, (4.710, 15.614, 23.601)),
    (400567, (9.137, 17.962, 21.554)),
    (920018, (4.015, 15.224, 23.411)),
    (333529, (0.373, 15.243, 24.091)),
    (53103, (8.759, 16.907, 25.132)),
    (9934, (8.794, 19.455, 26.875)),
    (486437, (9.060, 12.138, 25.659)),
    (437714, (0.530, 19.234, 25.982)),
    (461910, (5.728, 12.272, 27.307)),
    (668599, (0.747, 16.898, 21.467)),
    (350053, (9.535, 11.022, 26.326)),
    (863609, (9.726, 14.135, 24.111)),
    (347478, (7.089, 16.714, 25.105)),
    (443034, (7.972, 11.923, 20.374)),
    (637722, (5.639, 16.143, 25.815)),
    (872693, (5.736, 16.890, 22.714)),
    (316371, (8.234, 11.919, 29.503)),
    (243463, (4.338, 18.303, 29.800)),
    (557869, (8.550, 18.093, 23.452)),
    (265249, (6.575, 17.359, 29.698)),
    (198754, (3.129, 13.819, 23.877)),
    (10364, (3.364, 10.992, 29.431)),
    (258996, (9.725, 11.769, 20.764)),
    (122119, (3.240, 12.004, 22.779)),
    (272709, (9.155, 14.849, 28.755)),
    (746564, (9.448, 17.576, 23.558)),
    (152128, (0.861, 18.691, 21.467)),
    (158820, (2.967, 13.241, 26.851)),
    (326783, (6.688, 11.011, 28.123)),
    (456421, (4.008, 14.453, 23.169)),
    (641121, (5.279, 13.303, 26.830)),
    (529253, (3.534, 12.130, 28.017)),
    (904771, (9.530, 11.970, 20.708)),
    (161394, (4.038, 18.267, 25.412)),
    (558524, (0.808, 15.433, 28.831)),
    (652037, (9.886, 11.456, 24.160)),
    (168734, (4.568, 10.180, 27.089)),
    (999071, (2.672, 18.012, 29.184)),
    (954979, (4.518, 10.169, 21.781)),
    (104245, (3.361, 14.916, 28.110)),
    (580710, (4.110, 11.034, 22.977)),
    (925461, (1.776, 16.795, 22.079)),
    (660334, (2.288, 10.239, 26.135)),
    (338149, (0.650, 17.063, 23.747)),
    (280021, (5.447, 14.059, 28.893)),
    (212203, (2.242, 10.349, 21.021)),
    (945707, (8.570, 12.434, 22.939)),
    (695805, (5.075, 12.449, 23.644)),
    (579086, (7.499, 18.547, 21.390)),
    (241928, (6.001, 15.405, 23.992)),
    (221588, (2.336, 10.684, 28.350)),
    (398471, (4.172, 13.129, 28.923)),
    (65399, (9.502, 15.385, 27.879)),
    (162437, (6.199, 18.987, 26.319)),
    (820587, (8.862, 19.561, 23.257)),
    (521903, (9.635, 11.150, 25.314)),
    (111126, (7.065, 11.757, 22.870)),
    (158241, (1.845, 19.527, 27.154)),
    (649912, (8.986, 11.383, 26.508)),
    (914444, (1.516, 17.888, 23.428)),
    (853141, (1.875, 12.057, 23.503)),
    (995052, (7.991, 14.161, 24.698)),
    (551441, (7.258, 10.876, 25.139)),
    (985715, (8.936, 16.319, 22.830)),
    (905072, (7.354, 17.047, 22.337)),
    (932955, (2.547, 16.382, 22.543)),
    (238388, (7.650, 15.565, 23.638)),
    (669260, (7.768, 14.726, 21.303)),
    (287028, (3.899, 18.091, 28.893)),
    (902546, (0.694, 18.692, 28.254)),
    (240264, (8.292, 16.777, 21.621)),
    (712302, (3.401, 14.789, 26.403)),
    (145173, (8.679, 12.452, 24.629)),
    (497357, (2.663, 16.593, 29.479)),
    (582563, (1.612, 18.632, 23.018)),
    (336748, (6.328, 14.532, 23.209)),
    (137323, (4.680, 10.844, 20.079)),
    (990633, (8.329, 19.213, 22.552)),
    (592496, (4.029, 17.965, 25.051)),
    (807367, (6.314, 17.728, 29.953)),
    (864563, (5.668, 10.814, 25.576)),
    (495556, (1.675, 10.672, 22.652)),
    (192811, (1.431, 15.221, 25.248)),
    (295270, (0.858, 16.764, 24.589)),
    (963709, (3.346, 19.282, 21.734)),
    (260003, (0.510, 15.531, 22.954)),
    (778969, (8.044, 10.535, 24.725)),
    (451762, (1.197, 12.114, 24.767)),
    (144445, (3.979, 16.797, 29.052)),
    (659113, (3.038, 17.423, 20.132)),
    (876573, (9.222, 16.589, 28.332)),
    (797381, (5.520, 14.281, 27.265)),
    (288198, (8.305, 16.156, 25.283)),
    (863125, (7.901, 18.656, 23.091)),
    (767324, (5.022, 18.973, 27.599)),
    (644187, (3.653, 18.761, 29.026)),
    (244735, (3.493, 19.958, 25.833)),
    (102439, (7.941, 18.357, 27.225)),
    (911400, (1.283, 10.081, 23.720)),
    (108393, (0.230, 17.239, 25.732)),
    (251234, (3.195, 19.866, 23.564)),
    (872576, (1.288, 18.111, 23.992)),
    (771116, (9.788, 10.454, 26.586)),
    (583294, (5.340, 19.863, 23.043)),
    (332979, (4.282, 17.202, 22.167)),
    (334291, (5.422, 16.466, 26.319)),
    (644798, (7.356, 17.749, 28.066)),
    (572021, (7.638, 19.460, 20.112)),
    (753414, (4.581, 11.707, 23.665)),
    (831879, (9.153, 15.366, 23.206)),
    (558896, (2.583, 19.474, 28.338)),
    (981101, (6.129, 18.631, 21.255)),
    (964424, (1.089, 16.817, 27.823)),
    (774079, (2.701, 13.824, 21.280)),
    (928005, (1.184, 17.954, 23.360)),
    (300376, (1.874, 12.826, 24.640)),
    (896851, (1.047, 13.234, 23.176)),
    (135460, (7.925, 11.522, 25.168)),
    (370049, (2.379, 13.472, 23.031)),
    (152587, (0.819, 19.872, 26.625)),
    (171047, (2.518, 18.881, 24.786)),
    (334063, (4.763, 13.657, 23.994)),
    (121208, (0.020, 12.042, 27.412)),
    (321754, (4.325, 19.064, 29.351)),
    (107844, (5.329, 15.018, 29.125)),
    (593592, (1.756, 19.827, 24.098)),
    (636349, (4.190, 12.298, 27.119)),
    (113285, (0.015, 11.440, 28.361)),
    (882923, (8.475, 19.849, 20.167)),
    (521458, (5.389, 14.244, 29.895)),
    (330756, (9.753, 18.873, 26.048)),
    (927010, (1.268, 11.096, 26.597)),
    (363818, (7.073, 14.525, 29.829)),
    (599122, (7.445, 19.395, 29.936)),
    (551334, (5.884, 19.901, 29.950)),
    (520037, (5.598, 12.203, 21.358)),
    (808458, (2.522, 15.963, 25.670)),
    (960946, (0.451, 16.184, 27.139)),
    (628489, (6.903, 12.572, 26.149)),
    (979650, (8.339, 10.142, 24.167)),
    (733993, (2.467, 16.093, 24.351)),
    (843060, (3.695, 11.948, 25.703)),
    (905632, (5.296, 16.307, 20.848)),
    (190823, (1.910, 12.050, 20.227)),
    (623912, (5.257, 15.241, 21.257)),
    (26220, (8.172, 16.421, 24.291)),
    (396876, (1.783, 17.011, 29.599)),
    (382987, (0.394, 17.525, 20.724)),
    (480376, (1.296, 12.021, 24.843)),
    (530740, (9.645, 10.991, 21.809)),
    (719346, (4.542, 13.903, 22.453)),
    (137726, (4.163, 19.349, 28.200)),
    (182792, (6.901, 15.884, 28.682)),
    (795961, (7.555, 12.385, 27.688)),
    (77186, (5.140, 18.619, 28.649)),
    (798018, (5.246, 16.049, 24.969)),
    (763500, (4.867, 18.311, 21.703)),
    (11105, (4.445, 13.404, 28.244)),
    (320351, (2.571, 12.296, 20.946)),
    (410589, (7.606, 14.548, 24.131)),
    (481472, (6.545, 14.347, 26.818)),
    (858715, (3.932, 16.454, 21.224)),
    (351260, (7.340, 12.318, 23.278)),
    (739023, (1.192, 19.932, 24.186)),
    (312464, (3.469, 17.214, 22.144)),
    (761869, (5.576, 17.443, 28.745)),
    (22229, (6.485, 14.575, 27.144)),
    (585032, (5.405, 18.780, 29.942)),
    (556042, (5.596, 11.746, 22.232)),
    (930200, (1.566, 11.832, 20.633)),
    (244440, (8.331, 12.895, 23.020)),
    (297185, (9.969, 19.275, 20.644)),
    (125682, (4.078, 11.699, 24.374)),
    (495058, (8.109, 10.900, 29.532)),
    (839153, (2.217, 10.852, 28.021)),
    (449741, (1.716, 17.870, 20.479)),
    (456496, (4.556, 10.344, 25.731)),
    (981539, (7.055, 10.830, 21.816)),
    (887641, (0.225, 13.360, 29.656)),
    (939696, (2.355, 18.215, 29.017)),
    (824586, (0.143, 10.381, 22.316)),
    (64476, (8.003, 11.272, 21.189)),
    (602367, (3.012, 17.216, 21.178)),
    (838343, (2.111, 15.721, 27.891)),
    (8599, (2.083, 10.047, 28.143)),
    (802349, (7.125, 17.903, 29.589)),
    (197758, (7.389, 10.799, 20.177)),
    (240562, (9.707, 17.096, 23.444)),
    (642631, (8.999, 19.894, 25.904)),
    (241010, (7.873, 13.550, 20.716)),
    (828127, (1.731, 17.880, 27.115)),
    (68305, (8.702, 11.556, 28.317)),
    (120147, (8.875, 17.289, 20.882)),
    (566288, (4.127, 15.968, 29.701)),
    (337897, (3.160, 11.425, 28.405)),
    (539126, (3.170, 18.963, 26.986)),
    (150899, (6.160, 11.622, 21.955)),
    (288541, (8.178, 19.216, 25.915)),
    (575960, (4.637, 14.148, 25.053)),
    (232469, (3.099, 10.578, 26.837)),
    (660442, (8.866, 11.560, 29.101)),
    (138258, (0.360, 16.043, 23.259)),
    (298921, (2.375, 12.788, 26.387)),
    (99809, (1.294, 19.376, 22.632)),
    (423536, (4.705, 15.687, 28.437)),
    (362601, (7.852, 11.042, 21.320)),
    (762295, (1.319, 16.029, 23.315)),
    (691679, (9.104, 13.456, 29.038)),
    (754259, (2.667, 13.982, 29.281)),
    (635462, (5.318, 17.506, 20.306)),
    (234438, (3.826, 15.368, 23.322)),
    (103986, (5.106, 16.158, 24.898)),
    (406398, (8.121, 12.908, 27.021)),
    (525195, (5.952, 10.175, 20.304)),
    (518365, (1.647, 15.643, 24.912)),
    (26471, (0.557, 10.762, 23.840)),
    (583070, (7.575, 15.577, 28.423)),
    (911950, (9.100, 18.263, 22.614)),
    (662624, (6.180, 18.000, 22.480)),
    (127573, (7.029, 15.492, 21.764)),
    (305491, (6.431, 16.595, 22.280)),
    (612264, (0.318, 15.379, 22.739)),
    (707856, (8.725, 14.211, 26.260)),
    (757465, (8.782, 16.966, 28.621)),
    (952340, (6.595, 14.247, 27.108)),
    (502885, (5.635, 12.286, 29.749)),
    (665913, (5.249, 18.151, 23.585)),
    (918403, (5.139, 14.426, 23.038)),
    (648152, (2.472, 15.850, 22.886)),
    (36135, (6.726, 13.752, 28.499)),
    (63414, (0.590, 17.729, 23.885)),
    (850439, (9.124, 14.194, 27.761)),
    (125800, (2.936, 11.124, 24.163)),
    (863710, (3.389, 11.913, 24.727)),
    (308639, (0.423, 13.149, 23.598)),
    (237408, (7.105, 15.163, 25.284)),
    (749526, (2.193, 14.990, 20.802)),
    (48942, (2.880, 16.487, 25.146)),
    (539426, (2.238, 15.841, 24.401)),
    (997401, (6.831, 13.938, 26.862)),
    (443513, (2.614, 13.291, 24.008)),
    (558323, (7.136, 13.731, 25.823)),
    (477903, (6.643, 16.933, 20.277)),
    (45001, (0.285, 18.938, 20.115)),
    (824350, (8.658, 10.429, 22.542)),
    (253097, (9.852, 13.549, 29.436)),
    (967332, (1.355, 16.826, 26.794)),
    (57600, (0.722, 18.406, 26.036)),
    (759617, (8.004, 18.939, 26.183)),
    (115804, (8.735, 19.006, 27.079)),
    (634188, (7.263, 14.689, 23.737)),
    (152064, (7.006, 16.656, 28.965)),
    (95079, (9.453, 15.509, 25.900)),
    (912531, (1.462, 18.182, 29.220)),
    (271477, (9.861, 10.554, 24.022)),
    (80466, (3.707, 10.440, 28.929)),
    (901107, (1.194, 15.195, 20.098)),
    (334906, (5.472, 16.595, 29.948)),
    (392341, (0.511, 18.187, 23.502)),
    (990293, (3.358, 11.445, 23.742)),
    (453425, (5.263, 16.666, 28.496)),
    (421155, (6.418, 19.173, 21.094)),
    (278538, (8.166, 11.194, 23.136)),
    (761746, (2.472, 10.501, 24.470)),
    (386688, (9.553, 17.292, 23.575)),
    (279675, (6.753, 19.257, 22.288)),
    (130723, (4.782, 15.460, 21.175)),
    (599694, (5.017, 14.205, 28.531)),
    (665527, (1.417, 17.829, 22.829)),
    (170127, (6.301, 10.974, 24.846)),
    (76951, (8.530, 17.424, 23.730)),
    (303124, (0.474, 14.807, 20.505)),
    (479205, (3.427, 17.590, 23.982)),
    (33063, (0.899, 13.103, 26.136)),
    (169972, (9.748, 10.274, 21.151)),
    (538538, (2.641, 16.675, 28.163)),
    (538197, (4.990, 18.602, 23.813)),
    (610516, (7.230, 10.309, 25.796)),
    (704522, (8.954, 18.374, 21.578)),
    (635760, (1.005, 12.399, 29.255)),
    (879667, (8.285, 15.357, 27.037)),
    (527693, (0.112, 11.692, 24.167)),
    (93635, (9.828, 17.172, 23.621)),
    (190122, (4.481, 14.142, 21.956)),
    (46952, (0.645, 17.316, 22.846)),
    (266015, (3.264, 18.627, 27.978)),
    (49377, (6.977, 16.884, 28.882)),
    (348315, (3.809, 14.619, 26.294)),
    (704384, (3.662, 12.149, 29.401)),
    (576665, (5.298, 15.834, 26.038)),
    (730957, (3.535, 14.848, 23.923)),
    (661090, (3.259, 19.930, 20.039)),
    (142171, (7.661, 17.145, 24.843)),
    (642078, (8.757, 16.917, 29.921)),
    (163297, (1.040, 13.144, 23.806)),
    (44078, (5.810, 17.001, 29.160)),
    (921259, (1.665, 14.981, 28.219)),
    (263739, (9.387, 19.365, 24.902)),
    (609029, (3.374, 11.003, 29.627)),
    (578909, (1.741, 15.199, 23.674)),
    (745092, (4.719, 18.155, 28.224)),
    (779130, (7.600, 16.899, 24.814)),
    (943625, (7.648, 13.429, 28.938)),
    (879935, (6.937, 14.769, 26.725)),
    (458193, (3.558, 10.890, 20.602)),
    (972103, (2.227, 19.945, 27.484)),
    (701400, (2.997, 17.450, 22.716)),
    (95260, (5.989, 10.302, 21.365)),
    (830878, (0.141, 16.338, 21.038)),
    (637783, (0.245, 16.023, 21.185)),
    (170503, (6.026, 13.837, 21.889)),
    (992472, (9.896, 19.983, 22.773)),
    (511467, (0.019, 18.681, 27.573)),
    (882595, (2.275, 13.108, 20.096)),
    (746973, (8.349, 18.849, 23.800)),
    (191935, (8.770, 17.815, 20.246)),
    (125671, (8.962, 19.900, 24.461)),
    (4571, (2.160, 10.474, 24.856)),
    (809227, (1.980, 10.229, 25.251)),
    (803354, (8.762, 19.406, 23.447)),
    (68123, (9.707, 10.971, 20.253)),
    (758177, (3.820, 15.576, 28.943)),
    (162979, (1.956, 10.440, 29.956)),
    (217688, (8.794, 15.524, 29.694)),
    (847304, (7.751, 13.932, 26.708)),
    (575070, (2.943, 15.789, 24.832)),
    (91640, (7.946, 14.684, 23.589)),
    (654356, (1.760, 19.952, 23.721)),
    (881061, (7.698, 19.274, 22.574)),
    (172616, (2.983, 12.342, 25.826)),
    (637652, (9.120, 17.143, 29.920)),
    (269004, (9.638, 13.913, 23.430)),
    (395626, (9.067, 19.737, 28.021)),
    (754614, (2.735, 16.803, 26.407)),
    (108350, (4.673, 11.467, 25.428)),
    (118558, (6.595, 14.838, 27.100)),
    (700884, (6.778, 13.874, 23.372)),
    (159319, (9.478, 14.552, 27.512)),
    (102651, (7.601, 12.130, 22.447)),
    (409371, (6.337, 15.031, 21.820)),
    (365508, (3.083, 15.692, 29.588)),
    (941754, (0.858, 13.042, 24.769)),
    (755524, (3.901, 17.127, 22.652)),
    (964270, (4.698, 13.984, 22.202)),
    (715270, (5.786, 12.952, 26.018)),
    (360375, (3.719, 15.683, 28.728)),
    (593161, (3.935, 11.724, 22.525)),
    (27932, (0.159, 16.521, 29.242)),
    (62376, (8.396, 14.312, 25.002)),
    (598784, (1.156, 10.425, 21.497)),
    (440705, (4.434, 11.540, 23.171)),
    (656432, (9.914, 14.158, 23.518)),
    (715972, (2.207, 15.320, 29.349)),
    (950887, (8.749, 11.275, 29.616)),
    (918734, (2.530, 13.369, 20.404)),
    (953749, (7.965, 15.704, 26.835)),
    (328426, (7.865, 13.571, 28.861)),
    (495658, (3.410, 14.522, 27.791)),
    (274076, (6.476, 18.383, 20.642)),
    (380043, (5.876, 10.958, 25.891)),
    (749878, (9.309, 13.222, 28.942)),
    (300677, (6.166, 13.898, 27.755)),
    (307066, (9.900, 13.627, 28.304)),
    (902149, (4.576, 16.390, 24.408)),
    (962483, (5.909, 10.660, 22.830)),
    (843981, (4.395, 16.408, 27.353)),
    (177247, (5.502, 12.526, 24.186)),
    (581399, (1.552, 10.167, 21.469)),
    (441625, (2.318, 12.081, 27.749)),
    (849737, (6.964, 10.646, 29.858)),
    (283024, (6.047, 10.434, 24.316)),
    (934259, (2.095, 18.864, 29.876)),
    (570520, (7.174, 19.414, 20.228)),
    (22214, (1.461, 18.068, 21.289)),
    (693028, (2.326, 15.328, 24.376)),
    (850549, (6.626, 17.299, 21.692)),
    (709623, (8.103, 18.351, 23.958)),
    (239877, (2.861, 18.067, 29.319)),
    (53358, (7.076, 11.624, 23.613)),
    (592790, (0.444, 19.378, 21.315)),
    (282460, (5.671, 19.536, 22.917)),
    (303699, (7.389, 19.657, 29.683)),
    (497957, (6.719, 16.426, 29.372)),
    (591650, (6.056, 11.362, 22.011)),
    (276041, (8.977, 13.881, 26.868)),
    (465854, (2.458, 11.304, 29.469)),
    (369956, (5.570, 17.851, 27.752)),
    (886702, (2.561, 14.454, 26.496)),
    (869395, (0.549, 17.755, 26.548)),
    (661720, (2.164, 16.999, 20.595)),
    (307059, (9.661, 14.419, 25.793)),
    (527831, (2.790, 10.356, 29.157)),
    (412829, (8.987, 16.616, 27.158)),
    (705844, (6.863, 12.727, 22.287)),
    (780523, (6.786, 17.851, 28.373)),
    (544328, (7.776, 18.165, 23.878)),
    (457377, (8.306, 10.528, 27.854)),
    (826222, (3.454, 16.507, 23.160)),
    (192417, (5.404, 16.723, 26.605)),
    (10858, (6.838, 13.249, 29.288)),
    (942379, (9.861, 15.904, 27.571)),
    (633521, (6.490, 13.769, 21.083)),
    (989008, (3.897, 15.312, 20.796)),
    (746303, (7.640, 10.241, 21.456)),
    (769404, (0.512, 12.900, 21.111)),
    (294155, (8.154, 17.033, 20.464)),
    (173574, (6.156, 13.044, 25.639)),
    (9209, (9.509, 18.940, 29.825)),
    (994260, (9.909, 16.697, 21.758)),
    (630702, (8.324, 19.814, 28.069)),
    (173971, (9.555, 17.044, 25.810)),
    (520129, (2.983, 12.496, 21.336)),
    (826082, (9.804, 12.991, 23.431)),
    (556043, (0.662, 18.213, 21.460)),
    (117966, (7.235, 14.278, 25.893)),
    (807110, (9.495, 18.758, 28.672)),
    (948017, (4.975, 18.986, 27.714)),
    (615889, (8.573, 17.943, 27.119)),
    (243091, (0.630, 11.339, 24.138)),
    (431210, (2.593, 10.889, 26.707)),
    (605052, (7.656, 11.556, 27.971)),
    (962225, (2.319, 12.185, 28.533)),
    (347687, (3.180, 16.361, 25.224)),
    (121506, (6.991, 12.007, 26.659)),
    (574424, (5.216, 11.499, 20.903)),
    (881120, (5.486, 13.232, 28.442)),
    (377547, (8.598, 17.166, 22.788)),
    (956126, (7.155, 16.840, 26.386)),
    (439455, (9.520, 15.425, 29.759)),
    (251660, (5.293, 12.756, 28.732)),
    (191180, (7.084, 10.996, 29.507)),
    (614967, (0.245, 17.439, 26.635)),
    (427117, (8.529, 13.666, 20.802)),
    (972666, (2.001, 19.608, 23.533)),
    (806767, (6.617, 19.001, 25.349)),
    (731781, (7.848, 14.171, 26.487)),
    (470554, (0.647, 14.332, 23.000)),
    (230308, (7.330, 12.130, 21.324)),
    (800657, (0.473, 12.091, 23.909)),
    (97941, (1.537, 14.836, 25.031)),
    (557713, (6.333, 12.019, 24.134)),
    (508646, (6.173, 17.440, 22.231)),
    (981299, (6.517, 10.195, 23.539)),
    (311174, (3.176, 11.319, 26.145)),
    (920545, (7.597, 16.222, 24.605)),
    (661071, (3.999, 14.655, 29.066)),
    (902377, (0.636, 12.975, 20.824)),
    (414648, (1.017, 19.416, 20.369)),
    (577116, (0.663, 12.770, 21.471)),
    (201819, (4.756, 19.578, 22.249)),
    (800776, (8.638, 18.286, 27.335)),
    (267225, (9.937, 16.463, 27.842)),
    (755420, (2.344, 19.487, 28.382)),
    (742211, (4.266, 19.882, 20.762)),
    (753749, (0.102, 17.161, 23.800)),
    (514506, (5.758, 18.170, 25.628)),
    (555678, (2.145, 10.653, 29.936)),
    (196324, (2.689, 19.133, 21.681)),
    (330734, (2.369, 12.446, 22.859)),
    (651797, (1.984, 14.773, 27.160)),
    (605622, (1.457, 12.686, 29.085)),
    (848217, (6.153, 19.820, 26.205)),
    (631045, (1.082, 11.979, 23.309)),
    (933579, (6.928, 14.486, 24.849)),
    (76165, (7.237, 16.704, 29.005)),
    (352502, (4.159, 16.001, 21.629)),
    (141130, (5.393, 17.753, 22.656)),
    (716131, (1.911, 18.297, 22.851)),
    (783534, (5.971, 19.470, 27.618)),
    (171073, (3.238, 17.117, 29.863)),
    (181880, (8.512, 18.638, 25.873)),
    (974331, (2.336, 17.582, 27.673)),
    (241080, (2.612, 17.618, 28.991)),
    (656877, (4.958, 13.681, 27.097)),
    (573211, (6.269, 15.594, 27.424)),
    (922368, (9.642, 13.225, 26.846)),
    (534820, (3.618, 19.890, 22.060)),
    (897933, (1.846, 14.918, 25.325)),
    (610609, (8.798, 19.838, 24.110)),
    (307353, (6.642, 19.744, 20.875)),
    (303718, (5.689, 12.286, 22.958)),
    (573751, (4.239, 15.161, 24.617)),
    (600451, (1.082, 15.968, 24.713)),
    (237606, (0.778, 18.587, 20.756)),
    (1284, (0.576, 13.591, 28.850)),
    (975764, (4.493, 16.213, 28.230)),
    (797472, (6.470, 14.426, 26.642)),
    (772528, (7.890, 15.734, 24.463)),
    (523434, (7.704, 16.299, 21.127)),
    (991145, (6.349, 12.822, 26.381)),
    (420742, (9.084, 13.174, 25.824)),
    (150917, (0.045, 11.288, 29.543)),
    (878091, (9.498, 19.845, 29.825)),
    (326794, (3.989, 13.105, 20.561)),
    (629822, (9.494, 13.783, 26.032)),
    (335440, (1.186, 10.413, 25.778)),
    (827483, (8.270, 14.512, 26.491)),
    (457712, (3.338, 19.204, 21.833)),
    (602457, (5.460, 14.866, 23.614)),
    (138890, (7.980, 11.430, 27.436)),
    (956109, (7.263, 18.413, 24.913)),
    (304784, (4.196, 11.330, 24.764)),
    (489394, (7.384, 17.726, 20.119)),
    (578220, (0.996, 12.775, 27.650)),
    (308326, (9.208, 14.109, 20.524)),
    (605527, (7.333, 11.778, 26.231)),
    (777987, (1.506, 10.962, 23.398)),
    (914995, (9.418, 19.495, 21.283)),
    (251219, (3.053, 15.041, 29.713)),
    (585848, (7.471, 10.871, 29.850)),
    (850487, (8.565, 11.180, 21.490)),
    (958942, (4.723, 13.058, 26.536)),
    (858254, (2.554, 15.534, 22.453)),
    (665832, (4.886, 17.687, 22.953)),
    (183391, (9.353, 14.766, 24.703)),
    (320667, (8.097, 18.887, 28.404)),
    (655687, (1.189, 13.667, 27.222)),
    (77780, (4.155, 14.716, 25.972)),
    (904452, (0.431, 18.548, 27.738)),
    (346215, (6.700, 19.010, 21.139)),
    (477276, (1.361, 18.666, 23.639)),
    (317942, (7.148, 12.704, 26.586)),
    (51597, (3.764, 17.232, 26.087)),
    (362050, (2.942, 18.693, 27.715)),
    (654611, (8.900, 10.195, 20.531)),
    (387751, (1.032, 14.937, 23.885)),
    (885941, (4.956, 16.362, 24.521)),
    (285958, (0.420, 17.612, 29.121)),
    (100846, (2.613, 11.706, 23.985)),
    (765400, (3.931, 10.055, 24.145)),
    (91414, (6.280, 13.450, 29.681)),
    (319205, (2.180, 19.962, 22.319)),
    (476625, (7.774, 19.886, 22.239)),
    (548795, (1.581, 10.923, 22.330)),
    (274044, (5.315, 17.346, 29.516)),
    (169595, (1.712, 13.628, 22.360)),
    (114464, (8.008, 18.508, 20.058)),
    (443280, (8.494, 12.964, 21.026)),
    (414898, (7.551, 17.923, 25.955)),
    (321349, (5.531, 14.965, 21.698)),
    (412160, (1.236, 11.286, 24.247)),
    (999935, (3.653, 13.264, 22.781)),
    (407130, (1.639, 16.965, 20.685)),
    (383029, (5.429, 13.311, 27.548)),
    (383462, (9.865, 11.162, 26.008)),
    (520659, (6.632, 11.920, 23.757)),
    (237283, (2.785, 14.422, 26.269)),
    (983793, (8.228, 17.884, 20.513)),
    (220901, (1.580, 15.859, 20.136)),
    (827137, (3.711, 16.829, 22.327)),
    (232547, (3.197, 10.724, 26.483)),
    (591088, (2.685, 12.249, 29.197)),
    (423627, (4.808, 19.860, 27.257)),
    (68731, (4.619, 18.857, 25.804)),
    (11015, (7.721, 14.429, 22.963)),
    (301174, (8.715, 15.585, 24.792)),
    (932267, (1.463, 13.820, 27.197)),
    (700115, (6.871, 16.587, 29.720)),
    (309478, (9.325, 10.909, 23.169)),
    (626782, (0.162, 13.614, 20.221)),
    (861677, (7.697, 12.176, 20.115)),
    (647186, (2.486, 19.396, 29.246)),
    (498942, (0.144, 19.514, 24.847)),
    (811222, (2.990, 14.163, 21.496)),
    (528922, (3.079, 11.220, 29.996)),
    (76137, (1.482, 18.866, 20.341)),
    (755057, (6.492, 19.333, 27.948)),
    (510117, (2.881, 15.333, 24.287)),
    (668350, (6.060, 17.791, 29.522)),
    (220703, (6.461, 17.861, 23.414)),
    (266539, (3.291, 11.101, 20.162)),
    (869292, (1.471, 14.398, 27.022)),
    (555030, (1.332, 10.769, 23.452)),
    (841893, (7.905, 15.969, 28.312)),
    (257571, (5.485, 10.409, 25.932)),
    (964161, (6.208, 16.081, 24.718)),
    (472207, (6.336, 15.092, 25.507)),
    (644072, (6.794, 17.694, 27.739)),
    (384899, (3.659, 14.243, 24.567)),
    (129634, (1.408, 12.976, 26.438)),
    (147820, (8.370, 17.355, 22.348)),
    (814370, (7.962, 18.509, 23.187)),
    (195667, (0.846, 19.056, 26.093)),
    (27487, (1.367, 10.277, 26.990)),
    (228272, (5.550, 14.305, 23.258)),
    (459580, (5.028, 14.080, 22.652)),
    (423909, (2.090, 18.720, 24.211)),
    (755052, (0.824, 15.698, 24.119)),
    (509043, (2.320, 12.977, 25.924)),
    (235970, (5.273, 15.550, 23.130)),
    (682160, (6.531, 12.718, 28.996)),
    (381025, (0.552, 17.073, 24.625)),
    (295369, (9.695, 11.450, 27.922)),
    (834555, (2.045, 18.126, 25.420)),
    (16115, (6.653, 18.719, 24.044)),
    (573754, (8.168, 15.976, 27.342)),
    (500346, (8.352, 16.917, 24.490)),
    (633185, (8.663, 13.526, 26.232)),
    (533998, (7.307, 14.884, 21.291)),
    (276573, (2.760, 15.589, 20.721)),
    (457806, (7.943, 11.941, 20.749)),
    (603759, (1.353, 18.884, 24.249)),
    (648877, (1.886, 11.939, 24.016)),
    (745502, (3.607, 11.944, 27.865)),
    (403364, (7.357, 12.298, 24.683)),
    (117225, (7.631, 18.302, 23.794)),
    (463839, (9.251, 16.486, 22.828)),
    (33616, (8.633, 19.408, 20.755)),
    (795320, (8.191, 11.959, 27.951)),
    (785246, (0.368, 17.358, 20.208)),
    (568613, (3.087, 16.382, 24.323)),
    (933504, (5.250, 19.033, 21.605)),
    (121813, (3.490, 13.369, 26.049)),
    (662718, (5.272, 13.761, 29.637)),
    (941048, (8.239, 12.134, 28.309)),
    (620732, (1.351, 15.348, 25.119)),
    (974354, (7.876, 10.840, 27.110)),
    (796815, (2.637, 12.490, 22.049)),
    (221844, (5.905, 12.196, 20.072)),
    (138685, (6.543, 18.352, 24.873)),
    (776491, (8.473, 12.174, 26.862)),
    (400345, (6.663, 11.335, 20.821)),
    (518840, (0.766, 17.173, 27.533)),
    (112253, (1.939, 18.204, 25.852)),
    (647886, (6.566, 18.043, 27.718)),
    (966096, (8.334, 16.046, 20.101)),
    (372855, (6.183, 11.004, 27.443)),
    (353218, (7.205, 11.426, 21.471)),
    (733855, (0.199, 17.078, 29.757)),
    (44840, (4.655, 10.497, 23.519)),
    (171270, (9.635, 19.757, 20.108)),
    (314568, (2.196, 12.279, 22.132)),
    (57028, (8.643, 12.494, 25.738)),
    (233837, (8.951, 12.560, 26.643)),
    (109427, (9.269, 11.651, 26.372)),
    (913643, (4.049, 17.410, 20.266)),
    (190102, (7.592, 18.899, 26.749)),
    (851266, (2.888, 10.799, 24.338)),
    (492516, (9.212, 13.912, 22.407)),
    (680957, (6.640, 11.970, 26.844)),
    (914611, (0.760, 13.001, 28.789)),
    (521737, (2.976, 16.334, 29.782)),
    (41818, (6.487, 17.548, 25.382)),
    (241062, (5.071, 18.032, 26.549)),
    (556798, (7.625, 18.409, 28.814)),
    (847614, (7.773, 16.472, 23.316)),
    (867666, (5.103, 10.183, 26.250)),
    (469858, (0.865, 19.768, 26.547)),
    (821819, (8.410, 15.106, 20.202)),
    (482013, (7.417, 12.168, 25.553)),
    (908582, (4.671, 18.929, 25.307)),
    (913037, (6.190, 18.305, 20.956)),
    (533395, (3.081, 13.561, 23.868)),
    (899704, (8.100, 12.953, 21.052)),
    (782951, (3.854, 16.974, 29.126)),
    (811885, (7.196, 10.819, 27.688)),
    (633629, (4.852, 16.223, 21.735)),
    (218906, (9.329, 10.142, 27.226)),
    (861347, (1.278, 14.781, 25.087)),
    (739708, (7.769, 13.875, 26.299)),
    (742425, (1.478, 19.871, 22.889)),
    (901189, (4.360, 16.456, 28.584)),
    (924262, (9.998, 19.228, 27.602)),
    (209914, (6.736, 19.856, 28.213)),
    (672866, (7.605, 11.204, 21.451)),
    (467468, (3.093, 10.385, 22.477)),
    (999266, (8.570, 10.366, 29.005)),
    (496998, (4.769, 12.681, 25.709)),
    (914428, (8.325, 16.725, 20.381)),
    (312153, (5.995, 12.003, 28.464)),
    (859841, (5.306, 17.831, 26.736)),
    (388330, (2.961, 10.720, 28.583)),
    (855571, (8.649, 17.210, 29.814)),
    (482905, (1.611, 14.872, 23.227)),
    (487245, (5.302, 16.389, 21.812)),
    (10698, (9.411, 10.630, 22.630)),
    (627248, (9.942, 16.588, 23.430)),
    (489592, (1.479, 12.485, 29.475)),
    (940760, (4.132, 12.991, 29.293)),
    (164234, (1.732, 10.091, 20.402)),
    (5346, (5.610, 18.017, 28.213)),
    (805603, (7.840, 17.735, 29.385)),
    (417614, (4.684, 14.029, 29.029)),
    (2710, (9.124, 11.103, 26.139)),
    (39017, (0.322, 17.059, 20.326)),
    (873035, (7.742, 13.709, 23.499)),
    (492878, (8.484, 13.386, 21.610)),
    (864389, (6.098, 10.587, 20.372)),
    (942985, (9.824, 17.195, 27.779)),
    (448861, (5.830, 12.393, 22.196)),
    (80618, (1.627, 16.051, 25.671)),
    (249226, (1.479, 10.436, 21.428)),
    (208502, (3.734, 19.591, 21.439)),
    (286992, (6.497, 10.669, 28.743)),
    (265298, (1.016, 18.773, 20.541)),
    (604891, (1.410, 11.158, 27.427)),
    (484102, (2.037, 18.023, 21.113)),
    (780087, (4.252, 18.656, 21.106)),
    (731053, (0.377, 18.504, 24.205)),
    (903612, (8.661, 15.362, 27.198)),
    (674698, (2.075, 10.904, 20.213)),
    (402068, (7.861, 14.584, 20.922)),
    (651518, (5.580, 11.391, 24.006)),
    (705655, (3.956, 10.270, 20.870)),
    (742820, (1.112, 17.738, 28.266)),
    (510468, (8.395, 12.097, 27.168)),
    (807649, (0.246, 17.080, 24.009)),
    (192738, (1.359, 13.703, 28.245)),
    (121818, (0.993, 12.296, 20.893)),
    (179, (3.868, 16.843, 28.037)),
    (375157, (1.578, 16.232, 22.842)),
    (493578, (8.767, 13.957, 25.597)),
    (160669, (0.636, 12.285, 24.043)),
    (365248, (5.170, 19.818, 26.148)),
    (682770, (4.807, 13.506, 26.279)),
    (586259, (2.678, 19.284, 20.861)),
    (313185, (8.863, 19.933, 23.094)),
    (321827, (0.033, 11.268, 27.115)),
    (717552, (6.676, 10.317, 20.609)),
    (383859, (7.124, 17.951, 26.246)),
    (578770, (9.910, 18.647, 21.594)),
    (336994, (9.437, 11.544, 20.511)),
    (508748, (9.913, 10.799, 20.853)),
    (258165, (6.756, 10.682, 29.972)),
    (598451, (2.302, 17.697, 24.294)),
    (847771, (9.485, 18.361, 26.521)),
    (559496, (4.204, 17.169, 23.103)),
    (189532, (9.976, 11.710, 28.449)),
    (894206, (5.218, 10.827, 20.692)),
    (236544, (1.874, 14.481, 28.395)),
    (6518, (5.811, 16.827, 21.036)),
    (303892, (7.496, 19.363, 28.290)),
    (96492, (5.095, 12.153, 24.970)),
    (913949, (3.171, 17.730, 20.800)),
    (265651, (2.928, 11.863, 22.967)),
    (382525, (4.745, 19.690, 20.595)),
    (829169, (5.820, 15.298, 25.682)),
    (260749, (3.435, 19.080, 21.439)),
    (100921, (8.382, 17.957, 23.721)),
    (211910, (2.431, 12.079, 27.294)),
    (845127, (6.640, 12.218, 25.473)),
    (245254, (8.814, 17.002, 20.238)),
    (216000, (7.511, 13.162, 23.092)),
    (644749, (6.655, 12.403, 25.072)),
    (117474, (0.553, 18.041, 23.806)),
    (690807, (7.628, 18.193, 27.467)),
    (68624, (3.221, 11.860, 29.800)),
    (94332, (6.489, 18.574, 23.604)),
    (291421, (6.392, 14.412, 22.400)),
    (992192, (9.793, 10.362, 27.402)),
    (117615, (8.705, 13.584, 26.420)),
    (573624, (5.983, 15.262, 23.171)),
    (680828, (4.989, 14.374, 26.667)),
    (613091, (2.813, 10.055, 28.333)),
    (525875, (7.723, 13.677, 21.115)),
    (472786, (8.615, 12.412, 23.972)),
    (378304, (7.143, 18.730, 27.473)),
    (434374, (6.540, 10.316, 27.019)),
    (333596, (2.914, 16.073, 23.454)),
    (882514, (4.674, 13.183, 21.482)),
    (493810, (9.519, 17.624, 29.854)),
    (293252, (3.062, 15.022, 29.540)),
    (362871, (8.125, 17.769, 27.663)),
    (938011, (2.010, 15.107, 21.153)),
    (389275, (2.524, 12.218, 23.367)),
    (663604, (1.732, 18.240, 23.602)),
    (683095, (4.703, 13.470, 27.099)),
    (640484, (8.114, 13.079, 26.480)),
    (870609, (8.901, 14.757, 29.433)),
    (319387, (8.802, 14.598, 22.754)),
    (146934, (1.370, 10.450, 20.188)),
    (809276, (8.093, 11.009, 23.055)),
    (46993, (4.441, 12.669, 24.416)),
    (506054, (9.416, 12.674, 22.291)),
    (229038, (3.123, 12.131, 23.765)),
    (839532, (6.889, 17.684, 29.944)),
    (359324, (9.478, 12.042, 26.162)),
    (226212, (8.179, 13.619, 27.206)),
    (752384, (5.426, 18.789, 28.643)),
    (580692, (7.136, 11.686, 27.253)),
    (225703, (4.088, 10.083, 22.833)),
    (4492, (4.824, 18.318, 26.389)),
    (925373, (3.445, 16.445, 25.541)),
    (549971, (4.777, 14.742, 20.726)),
    (741357, (4.401, 19.740, 23.366)),
    (177623, (9.066, 16.691, 28.449)),
    (168626, (8.312, 16.533, 21.123)),
    (702485, (6.403, 10.920, 29.268)),
    (459734, (9.727, 17.981, 25.381)),
    (111653, (4.148, 19.229, 24.344)),
    (221054, (2.567, 12.986, 24.245)),
    (555223, (4.864, 16.615, 22.814)),
    (684544, (8.406, 17.202, 27.612)),
    (767804, (4.701, 10.807, 27.426)),
    (740972, (2.374, 17.902, 20.323)),
    (394124, (7.852, 17.845, 27.278)),
    (972917, (6.079, 10.972, 29.467)),
    (378636, (1.152, 13.655, 23.600)),
    (124229, (3.141, 14.137, 27.442)),
    (421161, (9.161, 11.510, 23.799)),
    (145803, (1.100, 12.206, 28.258)),
    (40651, (8.408, 13.920, 24.146)),
    (187684, (1.271, 15.874, 24.823)),
    (892347, (0.720, 16.869, 26.167)),
    (662894, (2.970, 16.632, 28.763)),
    (191657, (2.589, 15.714, 29.772)),
    (793571, (7.470, 15.050, 20.888)),
    (105710, (7.585, 14.715, 29.077)),
    (710276, (6.010, 18.265, 20.845)),
    (245905, (3.785, 12.531, 26.595)),
    (387859, (7.601, 10.108, 27.437)),
    (223569, (1.843, 10.678, 23.099)),
    (13015, (9.340, 12.097, 20.232)),
    (485002, (8.284, 10.373, 25.646)),
    (182119, (4.006, 13.576, 23.783)),
    (439044, (2.699, 17.797, 26.961)),
    (837704, (5.717, 19.073, 27.013)),
    (955212, (6.062, 16.293, 21.031)),
    (181989, (3.559, 11.551, 23.341)),
    (856661, (4.888, 14.185, 24.912)),
    (837819, (3.833, 12.111, 29.510)),
    (378943, (6.272, 12.604, 20.759)),
    (670668, (9.371, 18.068, 22.486)),
    (724481, (7.631, 18.759, 20.128)),
    (253630, (0.657, 16.540, 21.618)),
    (545200, (5.335, 13.190, 20.340)),
    (997159, (8.279, 16.987, 24.507)),
    (168091, (5.455, 11.011, 27.485)),
    (479431, (3.442, 18.683, 27.927)),
    (882992, (3.748, 14.877, 28.463)),
    (360943, (2.997, 17.101, 26.293)),
    (866848, (1.447, 12.101, 27.358)),
    (984584, (8.724, 17.095, 21.612)),
    (327915, (7.171, 13.622, 28.271)),
    (719448, (9.612, 12.901, 26.795)),
    (135339, (7.798, 15.352, 20.103)),
    (304746, (4.800, 11.423, 26.735)),
    (982608, (0.524, 13.771, 21.730)),
    (157669, (8.947, 10.589, 27.009)),
    (395439, (6.210, 18.854, 21.582)),
    (483951, (0.807, 14.677, 24.322)),
    (339503, (7.320, 11.239, 20.911)),
    (958541, (3.004, 14.996, 26.496)),
    (256976, (6.446, 17.831, 23.311)),
    (863381, (9.956, 11.172, 22.957)),
    (381701, (6.487, 16.208, 21.219)),
    (585198, (9.706, 11.737, 20.557)),
    (893252, (2.866, 14.992, 20.364)),
    (758660, (8.721, 18.533, 21.534)),
    (363599, (9.524, 11.558, 26.510)),
    (31525, (9.603, 13.831, 20.172)),
    (46757, (3.927, 12.357, 29.687)),
    (373927, (5.609, 15.734, 24.106)),
    (26587, (3.821, 19.808, 25.110)),
    (366672, (6.358, 19.399, 20.675)),
    (619398, (6.341, 14.159, 26.966)),
    (222475, (2.778, 19.394, 21.766)),
    (402826, (6.546, 19.565, 24.419)),
    (133966, (8.095, 10.680, 24.279)),
    (705027, (6.460, 17.096, 26.039)),
    (131355, (3.932, 15.276, 21.214)),
    (798540, (8.164, 17.854, 20.867)),
    (133334, (2.834, 18.061, 23.120)),
    (628332, (1.819, 19.460, 23.415)),
    (551007, (8.270, 13.613, 23.669)),
    (404419, (5.846, 17.734, 29.278)),
    (599128, (0.699, 11.785, 20.936)),
    (847158, (5.151, 17.999, 26.025)),
    (116383, (4.065, 17.442, 20.305)),
    (625867, (4.905, 10.835, 27.279)),
    (21640, (0.013, 10.813, 22.558)),
    (878362, (2.883, 15.567, 25.437)),
    (943885, (2.660, 16.861, 20.632)),
    (563158, (2.682, 19.273, 21.817)),
    (740876, (2.277, 15.188, 28.540)),
    (722332, (1.842, 13.646, 20.761)),
    (442565, (8.002, 11.078, 21.932)),
    (421111, (2.917, 14.863, 28.552)),
    (752143, (7.153, 16.402, 29.261)),
    (383898, (0.771, 14.380, 26.662)),
    (54421, (4.379, 18.038, 23.007)),
    (142285, (3.616, 18.446, 27.449)),
    (91787, (7.156, 18.611, 29.123)),
    (820830, (9.939, 11.781, 22.798)),
    (719435, (8.018, 11.541, 22.806)),
    (241184, (6.624, 13.160, 20.686)),
    (723980, (0.839, 10.543, 25.937)),
    (86299, (6.221, 12.103, 24.897)),
    (495096, (9.770, 19.630, 22.087)),
    (679, (8.932, 18.952, 20.262)),
    (66800, (9.263, 11.755, 24.556)),
    (963920, (5.330, 15.497, 28.670)),
    (205771, (9.007, 13.710, 20.843)),
    (419119, (0.978, 16.885, 20.357)),
    (292505, (8.084, 16.521, 29.752)),
    (975118, (3.324, 16.654, 28.309)),
    (119664, (0.135, 17.300, 21.243)),
    (141944, (8.165, 18.453, 23.449)),
    (711265, (6.684, 10.711, 21.716)),
    (136377, (5.428, 13.309, 29.163)),
    (636918, (6.469, 15.415, 23.810)),
    (531123, (3.540, 16.095, 23.581)),
    (737846, (5.498, 16.564, 25.231)),
    (868003, (3.485, 19.500, 23.489)),
    (163648, (6.518, 11.927, 25.364)),
    (798199, (1.416, 13.029, 26.367)),
    (254725, (1.107, 12.610, 23.814)),
    (291069, (3.634, 19.560, 24.543)),
    (949520, (8.067, 15.956, 20.729)),
    (175090, (2.061, 15.856, 24.628)),
    (459813, (3.874, 13.334, 27.678)),
    (402541, (0.334, 11.091, 20.043)),
    (514347, (1.368, 13.355, 26.306)),
    (988349, (5.492, 16.267, 20.669)),
    (660239, (9.851, 16.018, 20.873)),
    (747694, (3.120, 11.195, 24.645)),
    (189810, (1.275, 19.791, 27.488)),
    (83152, (8.722, 18.077, 27.843)),
    (154323, (5.564, 15.586, 21.081)),
    (29830, (7.708, 12.135, 28.587)),
    (414811, (1.225, 11.956, 25.836)),
    (168777, (3.657, 10.916, 23.299)),
    (63433, (7.770, 17.184, 24.300)),
    (803492, (6.844, 17.209, 24.970)),
    (283957, (4.590, 16.835, 27.758)),
    (131809, (2.880, 13.162, 26.372)),
    (273387, (2.230, 17.647, 24.266)),
    (896412, (5.803, 19.557, 25.658)),
    (373726, (2.152, 12.878, 29.197)),
    (460552, (5.214, 14.075, 23.139)),
    (121920, (2.731, 15.407, 20.908)),
    (180614, (5.395, 10.103, 23.349)),
    (675226, (2.990, 17.452, 24.616)),
    (701047, (2.024, 12.831, 23.391)),
    (408721, (3.804, 19.463, 26.643)),
    (461796, (8.545, 15.164, 24.661)),
    (709538, (2.207, 15.236, 23.333)),
    (188717, (5.474, 12.508, 25.740)),
    (618121, (0.654, 12.987, 25.937)),
    (470553, (3.382, 15.433, 23.571)),
    (28684, (3.934, 14.049, 24.502)),
    (967798, (0.886, 15.922, 26.976)),
    (502493, (0.100, 14.528, 27.247)),
    (396682, (1.420, 10.530, 20.645)),
    (26488, (7.771, 17.413, 27.085)),
    (780963, (2.424, 18.362, 21.748)),
    (347541, (0.121, 17.563, 27.606)),
    (416929, (9.204, 14.424, 20.052)),
    (137782, (8.575, 11.854, 26.190)),
    (524917, (0.221, 13.674, 27.386)),
    (462071, (4.513, 12.806, 28.234)),
    (396013, (8.976, 10.940, 24.895)),
    (560297, (5.981, 15.221, 29.439)),
    (587678, (0.407, 17.265, 24.255)),
    (106907, (8.131, 18.258, 22.880)),
    (428954, (7.784, 19.373, 29.262)),
    (989508, (4.345, 14.562, 22.249)),
    (979791, (7.317, 11.512, 21.692)),
    (773449, (2.157, 14.430, 26.701)),
    (408387, (4.793, 13.882, 25.053)),
    (112587, (9.910, 17.209, 22.851)),
    (932345, (6.386, 12.496, 27.700)),
    (770273, (0.987, 19.678, 24.693)),
    (819435, (9.299, 12.738, 26.426)),
    (417578, (0.031, 17.157, 27.660)),
    (273523, (6.834, 11.041, 21.464)),
    (482406, (4.028, 16.316, 24.006)),
    (472812, (9.142, 16.001, 24.669)),
    (335013, (2.131, 14.781, 29.160)),
    (855307, (0.842, 16.366, 27.535)),
    (772734, (8.803, 18.974, 25.046)),
    (985705, (6.238, 14.650, 24.923)),
    (846477, (0.643, 16.468, 20.979)),
    (69519, (7.570, 16.352, 22.704)),
    (347290, (0.221, 13.439, 20.569)),
    (869339, (7.116, 18.159, 28.848)),
    (45368, (8.555, 13.038, 26.282)),
    (142061, (2.109, 19.875, 22.297)),
    (987278, (8.107, 16.559, 23.440)),
    (854329, (6.021, 11.815, 25.453)),
    (173630, (6.069, 14.077, 29.110)),
    (659946, (6.605, 10.828, 22.153)),
    (985730, (7.449, 12.214, 24.291)),
    (367548, (7.435, 14.603, 27.259)),
    (701594, (2.657, 13.376, 25.531)),
    (568288, (4.605, 18.130, 29.280)),
    (468019, (2.266, 16.190, 23.699)),
    (88313, (1.557, 19.401, 25.237)),
    (258596, (9.995, 14.130, 21.742)),
    (199879, (4.790, 18.207, 25.005)),
    (871680, (1.570, 12.468, 29.659)),
    (310861, (9.777, 18.088, 22.451)),
    (596001, (5.239, 12.042, 23.064)),
    (671769, (2.078, 10.103, 26.901)),
    (434331, (9.248, 19.128, 21.532)),
    (860470, (9.007, 19.827, 25.529)),
    (779272, (0.794, 18.310, 28.067)),
    (366646, (1.699, 16.304, 23.663)),
    (296796, (0.103, 14.833, 28.281)),
    (361710, (3.414, 12.533, 26.529)),
    (23589, (3.510, 10.147, 23.309)),
    (90491, (8.087, 11.544, 20.099)),
    (809058, (3.007, 11.213, 21.440)),
    (595891, (4.229, 13.628, 26.940)),
    (173470, (3.119, 12.130, 24.939)),
    (5483, (5.621, 16.877, 22.913)),
    (23696, (9.660, 10.002, 20.443)),
    (769476, (6.570, 15.643, 21.442)),
    (825490, (1.805, 15.657, 22.398)),
    (354546, (1.638, 14.203, 28.376)),
    (844018, (7.546, 14.220, 25.631)),
    (859461, (6.917, 18.978, 21.044)),
    (729379, (4.078, 11.668, 26.130)),
    (978718, (4.278, 13.958, 22.801)),
    (633442, (0.896, 10.973, 23.830)),
    (959609, (2.438, 15.089, 27.154)),
    (202579, (9.857, 15.681, 25.285)),
    (154989, (2.065, 14.468, 29.599)),
    (40546, (1.110, 12.817, 26.189)),
    (173199, (6.297, 15.902, 21.609)),
    (957582, (9.332, 18.911, 23.036)),
    (451699, (2.113, 16.597, 27.845)),
    (224905, (5.256, 18.496, 26.490)),
    (43914, (1.656, 19.738, 20.843)),
    (317563, (1.811, 16.098, 22.867)),
    (580446, (4.253, 10.269, 27.473)),
    (512702, (2.384, 10.700, 25.045)),
    (932821, (1.989, 11.762, 24.996)),
    (3118, (5.686, 19.194, 24.738)),
    (609115, (8.499, 14.703, 24.509)),
    (630814, (4.416, 14.702, 25.142)),
    (279776, (0.125, 14.880, 23.757)),
    (946530, (1.378, 16.916, 20.652)),
    (607649, (2.377, 19.228, 29.214)),
    (102020, (5.707, 11.900, 21.902)),
    (599638, (4.406, 16.645, 20.791)),
    (24099, (9.566, 14.066, 24.579)),
    (46411, (8.430, 12.409, 23.630)),
    (156061, (9.687, 12.368, 21.107)),
    (190233, (6.176, 11.755, 29.165)),
    (279921, (2.678, 13.486, 24.895)),
    (304778, (3.448, 14.509, 25.078)),
    (229923, (2.251, 12.362, 26.433)),
    (171565, (1.128, 15.582, 28.135)),
    (445054, (7.360, 13.041, 21.646)),
    (579332, (7.011, 15.759, 25.584)),
    (377521, (9.472, 18.777, 29.310)),
    (851065, (4.489, 16.677, 21.699)),
    (36312, (8.252, 11.188, 23.889)),
    (602969, (5.867, 12.427, 27.109)),
    (826655, (1.986, 17.550, 26.211)),
    (581498, (6.813, 12.217, 22.414)),
    (852705, (5.730, 11.513, 25.171)),
    (457911, (5.408, 15.701, 21.258)),
    (272736, (8.882, 15.288, 20.983)),
    (104405, (0.995, 12.248, 24.176)),
    (516483, (6.768, 13.072, 20.811)),
    (523939, (2.077, 14.810, 21.687)),
    (488503, (4.267, 13.035, 25.346)),
    (850345, (3.381, 18.983, 21.181)),
    (601809, (6.431, 14.533, 25.774)),
    (732429, (8.124, 19.810, 25.019)),
    (809702, (8.530, 18.052, 29.755)),
    (909314, (1.474, 17.087, 28.586)),
    (277075, (4.670, 14.460, 26.098)),
    (145973, (6.739, 15.723, 22.048)),
    (555157, (9.157, 11.521, 29.437)),
    (990415, (0.427, 16.446, 23.827)),
    (183412, (7.621, 17.837, 28.362)),
    (123758, (9.098, 14.332, 28.837)),
    (166006, (4.308, 19.088, 25.517)),
    (359967, (3.825, 17.927, 27.202)),
    (270566, (9.899, 19.123, 20.687)),
    (530436, (4.727, 11.604, 24.727)),
    (290075, (3.213, 13.743, 23.890)),
    (886218, (5.498, 16.103, 27.796)),
    (518929, (8.140, 15.546, 24.593)),
    (494820, (1.229, 17.549, 26.115)),
    (14022, (1.214, 15.361, 20.787)),
    (876249, (5.412, 11.152, 21.890)),
    (477355, (4.074, 15.342, 20.215)),
    (498442, (9.221, 19.193, 20.702)),
    (766800, (0.202, 14.694, 23.522)),
    (217557, (1.975, 12.526, 25.292)),
    (794477, (9.154, 17.951, 25.033)),
    (190721, (6.175, 10.279, 26.374)),
    (749846, (3.382, 18.066, 28.734)),
    (542271, (1.487, 16.645, 27.530)),
    (357485, (6.128, 18.574, 27.175)),
    (596802, (7.979, 11.904, 21.240)),
    (190839, (3.562, 11.669, 26.650)),
    (417516, (5.146, 17.154, 21.195)),
    (4985, (6.676, 17.826, 20.140)),
    (707198, (0.609, 18.482, 25.048)),
    (748568, (3.958, 19.368, 23.965)),
    (434753, (8.501, 17.834, 25.527)),
    (323082, (8.644, 13.035, 22.990)),
    (121053, (6.590, 11.154, 28.845)),
    (574524, (3.264, 18.212, 29.548)),
    (552823, (7.597, 19.519, 21.856)),
    (509691, (9.183, 11.143, 27.448)),
    (897022, (1.389, 18.454, 27.100)),
    (899745, (2.338, 13.322, 20.440)),
    (480085, (3.966, 16.004, 26.311)),
    (931966, (9.770, 12.039, 20.461)),
    (530968, (8.696, 17.815, 21.184)),
    (125596, (2.906, 19.885, 23.405)),
    (642784, (1.333, 13.587, 26.671)),
    (438433, (6.182, 15.000, 27.842)),
    (640062, (4.043, 16.231, 21.696)),
    (764293, (5.455, 19.146, 24.207)),
    (200782, (4.313, 11.325, 26.390)),
    (531487, (4.459, 17.021, 21.855)),
    (284142, (2.726, 19.180, 27.947)),
    (28633, (8.296, 17.996, 24.706)),
    (594983, (7.852, 15.724, 22.468)),
    (402718, (5.564, 18.145, 24.948)),
    (696685, (0.402, 19.785, 28.866)),
    (103306, (8.911, 19.392, 23.979)),
    (756388, (7.561, 13.800, 22.835)),
    (858442, (5.710, 19.779, 21.491)),
    (481424, (1.272, 12.995, 25.351)),
    (124988, (1.613, 13.703, 29.431)),
    (990856, (1.424, 13.755, 23.164)),
    (724995, (4.565, 17.110, 23.703)),
    (425978, (7.802, 10.559, 25.500)),
    (427646, (3.646, 10.384, 29.078)),
    (266966, (9.192, 12.634, 28.483)),
    (726209, (1.798, 19.077, 23.800)),
    (767449, (1.260, 14.185, 23.835)),
    (17925, (1.151, 17.964, 20.708)),
    (364808, (5.801, 18.927, 27.513)),
    (670520, (7.967, 12.971, 29.080)),
    (774273, (0.569, 10.221, 29.137)),
    (936990, (2.971, 18.839, 27.160)),
    (559956, (4.295, 19.144, 22.593)),
    (407178, (3.719, 14.200, 28.197)),
    (83213, (4.531, 12.825, 28.637)),
    (896937, (4.686, 14.246, 20.230)),
    (76119, (0.269, 16.324, 23.244)),
    (226081, (3.912, 13.154, 29.199)),
    (278197, (2.799, 17.987, 26.398)),
    (936059, (6.569, 16.861, 27.831)),
    (634395, (9.870, 11.566, 23.209)),
    (948399, (9.360, 18.388, 26.373)),
    (32986, (5.756, 10.864, 24.731)),
    (381086, (8.749, 16.307, 20.730)),
    (113285, (9.075, 16.117, 25.174)),
    (282658, (8.420, 11.025, 24.860)),
    (867543, (8.253, 16.978, 27.232)),
    (787836, (7.047, 12.856, 29.877)),
    (266130, (4.853, 15.929, 24.685)),
    (92689, (3.743, 17.944, 22.702)),
    (709633, (3.338, 14.069, 22.391)),
    (563527, (6.359, 13.295, 25.848)),
    (501843, (0.313, 12.144, 24.617)),
    (659997, (6.938, 18.569, 25.165)),
    (154319, (8.952, 11.811, 29.541)),
    (469020, (0.241, 16.694, 29.107)),
    (417643, (0.744, 17.397, 27.215)),
    (757547, (8.687, 18.432, 25.132)),
    (283257, (4.562, 17.663, 28.770)),
    (893654, (2.889, 16.178, 21.733)),
    (757332, (6.170, 11.269, 25.539)),
    (471709, (5.355, 16.047, 28.598)),
    (103326, (4.008, 14.486, 22.467)),
    (674772, (5.389, 14.446, 23.534)),
    (229479, (4.080, 18.631, 26.763)),
    (111218, (5.978, 10.208, 25.559)),
    (451637, (9.383, 17.754, 23.300)),
    (533015, (7.413, 11.794, 28.321)),
    (197093, (4.882, 14.637, 27.513)),
    (8383, (8.631, 11.176, 20.880)),
    (53781, (1.607, 17.844, 29.572)),
    (664628, (9.068, 18.323, 22.428)),
    (813809, (7.482, 17.224, 27.461)),
    (837434, (5.386, 15.689, 24.871)),
    (612842, (4.514, 14.773, 26.782)),
    (121090, (1.069, 14.762, 29.221)),
    (929009, (8.413, 11.138, 26.273)),
    (244477, (4.353, 15.022, 29.900)),
    (993519, (3.918, 10.383, 28.300)),
    (753788, (9.317, 11.513, 22.157)),
    (9085, (2.513, 11.456, 25.362)),
    (829332, (4.436, 14.974, 29.731)),
    (518327, (6.998, 11.012, 26.219)),
    (667048, (1.944, 16.988, 27.379)),
    (922290, (8.733, 11.082, 20.236)),
    (98672, (0.398, 10.810, 23.581)),
    (121633, (7.895, 19.460, 26.396)),
    (886028, (0.071, 16.001, 20.156)),
    (329785, (9.190, 11.638, 20.980)),
    (849362, (3.353, 11.862, 26.849)),
    (524441, (0.148, 19.025, 22.729)),
    (536483, (9.007, 18.725, 28.775)),
    (657910, (6.360, 14.441, 26.215)),
    (391722, (6.494, 16.970, 24.986)),
    (583511, (9.114, 19.892, 24.134)),
    (405754, (3.294, 12.233, 25.999)),
    (777847, (6.522, 13.064, 29.056)),
    (654233, (7.695, 15.222, 25.995)),
    (961097, (6.282, 13.281, 27.512)),
    (645189, (3.669, 10.444, 23.524)),
    (835694, (4.739, 10.128, 28.462)),
    (806578, (4.149, 10.266, 22.731)),
    (918553, (1.459, 10.322, 21.994)),
    (928230, (1.447, 17.988, 25.920)),
    (433633, (7.329, 13.985, 20.017)),
    (226730, (2.015, 16.626, 26.005)),
    (158139, (5.671, 17.878, 26.580)),
    (880609, (0.877, 10.227, 21.015)),
    (164410, (4.789, 19.920, 20.553)),
    (465338, (7.963, 14.873, 23.569)),
    (244028, (2.560, 16.078, 20.185)),
    (742823, (5.210, 13.025, 29.797)),
    (217856, (5.102, 14.209, 29.160)),
    (601142, (6.181, 12.129, 25.306)),
    (816807, (9.804, 15.933, 22.266)),
    (488188, (2.507, 10.652, 21.937)),
    (184572, (7.744, 10.975, 24.232)),
    (42193, (2.903, 13.770, 27.720)),
    (268529, (4.324, 15.070, 26.683)),
    (251529, (2.825, 13.918, 24.844)),
    (775505, (5.506, 18.624, 28.864)),
    (993540, (9.978, 16.473, 22.903)),
    (261958, (3.180, 18.173, 29.861)),
    (895118, (9.123, 14.147, 27.530)),
    (34141, (2.621, 15.592, 25.188)),
    (661255, (2.559, 18.706, 27.150)),
    (914185, (3.713, 14.219, 28.969)),
    (759248, (9.507, 16.117, 21.737)),
    (322656, (4.392, 12.592, 26.085)),
    (815263, (4.714, 14.655, 21.937)),
    (144296, (4.424, 10.758, 25.799)),
    (982607, (3.346, 13.081, 24.254)),
    (892975, (2.659, 12.975, 27.112)),
    (111935, (0.534, 12.509, 29.215)),
    (805335, (2.760, 12.415, 28.813)),
    (248003, (3.093, 14.263, 27.972)),
    (715038, (2.358, 12.398, 23.216)),
    (182903, (7.455, 15.793, 25.500)),
    (300456, (1.731, 12.759, 26.091)),
    (375608, (1.546, 18.980, 25.252)),
    (406981, (5.953, 19.185, 21.044)),
    (296768, (8.834, 12.602, 25.494)),
    (839192, (2.885, 12.404, 22.125)),
    (65829, (1.024, 14.479, 28.271)),
    (615242, (4.310, 12.634, 20.294)),
    (312483, (5.953, 17.139, 29.943)),
    (830548, (2.646, 11.135, 26.253)),
    (73127, (5.826, 19.503, 20.567)),
    (624701, (1.888, 17.913, 29.864)),
    (898224, (5.223, 18.269, 28.277)),
    (65713, (5.504, 15.781, 27.263)),
    (79265, (4.985, 17.242, 25.643)),
    (426010, (5.016, 17.620, 28.669)),
    (215373, (3.567, 17.041, 25.462)),
    (790716, (4.021, 15.716, 28.387)),
    (711631, (1.577, 16.118, 25.390)),
    (915063, (7.638, 10.921, 22.497)),
    (761685, (3.827, 12.596, 24.640)),
    (456766, (1.038, 19.668, 24.455)),
    (362045, (4.747, 10.945, 21.580)),
    (842058, (4.942, 16.746, 29.281)),
    (470941, (5.400, 14.460, 25.831)),
    (35413, (4.379, 15.957, 26.255)),
    (87824, (8.653, 12.868, 29.274)),
    (510470, (3.560, 10.038, 28.441)),
    (72090, (7.172, 12.894, 21.304)),
    (988248, (3.296, 14.692, 27.961)),
    (384897, (0.153, 10.724, 26.177)),
    (435333, (0.182, 19.350, 26.651)),
    (329174, (0.634, 12.459, 20.020)),
    (336833, (5.847, 18.558, 27.208)),
    (329285, (0.183, 12.638, 25.631)),
    (916171, (1.433, 19.101, 21.508)),
    (416324, (7.426, 18.977, 27.352)),
    (26126, (1.030, 11.731, 24.165)),
    (654745, (1.572, 14.181, 24.366)),
    (473710, (2.881, 17.378, 26.066)),
    (127215, (0.822, 14.692, 22.243)),
    (353460, (9.326, 16.325, 29.382)),
    (879071, (8.776, 14.854, 20.085)),
    (121836, (9.282, 12.169, 23.895)),
    (149971, (4.979, 16.082, 22.823)),
    (192337, (8.135, 13.004, 25.271)),
    (769428, (9.686, 11.546, 21.061)),
    (949354, (5.571, 16.920, 20.414)),
    (167106, (8.438, 12.978, 25.964)),
    (685929, (8.444, 10.109, 29.527)),
    (75350, (4.652, 16.265, 26.598)),
    (356071, (6.687, 16.104, 21.244)),
    (609024, (5.093, 12.611, 29.592)),
    (672222, (2.921, 15.312, 21.905)),
    (466689, (4.387, 15.778, 29.779)),
    (971527, (9.690, 13.708, 20.377)),
    (986176, (3.068, 16.339, 20.356)),
    (434003, (2.491, 11.035, 20.786)),
    (343713, (6.410, 13.641, 24.548)),
    (920191, (6.632, 10.023, 28.434)),
    (720629, (5.883, 19.752, 27.754)),
    (236089, (3.066, 16.062, 25.288)),
    (197557, (4.896, 15.283, 23.935)),
    (131802, (3.723, 12.692, 27.580)),
    (457204, (0.222, 16.762, 22.584)),
    (110463, (0.654, 13.216, 24.273)),
    (405976, (6.770, 12.865, 26.568)),
    (78407, (9.414, 18.378, 26.118)),
    (5358, (2.505, 18.377, 28.913)),
    (756245, (3.423, 12.542, 29.040)),
    (577193, (1.106, 10.984, 26.490)),
    (439768, (8.399, 15.812, 27.298)),
    (299834, (6.981, 13.694, 21.676)),
    (818274, (6.569, 14.361, 27.754)),
    (822251, (0.565, 17.672, 24.980)),
    (917801, (9.096, 10.889, 26.390)),
    (883043, (9.533, 16.558, 23.422)),
    (126004, (9.355, 12.349, 22.783)),
    (830580, (7.190, 19.989, 27.556)),
    (333361, (6.345, 10.610, 29.449)),
    (471843, (1.629, 19.831, 27.252)),
    (701124, (7.669, 13.235, 20.553)),
    (128324, (2.666, 13.901, 28.815)),
    (475579, (3.363, 19.074, 29.241)),
    (95767, (5.949, 18.193, 26.151)),
    (786387, (2.794, 10.478, 25.801)),
    (757682, (2.573, 17.653, 26.046)),
    (769353, (7.949, 19.169, 24.316)),
    (848463, (7.871, 19.360, 27.454)),
    (619626, (9.358, 19.946, 29.682)),
    (291837, (0.271, 17.652, 20.035)),
    (425583, (9.398, 14.078, 23.373)),
    (288034, (6.282, 15.830, 21.369)),
    (773191, (6.619, 16.883, 21.710)),
    (115200, (4.407, 17.598, 29.921)),
    (999809, (1.976, 14.294, 28.197)),
    (106374, (5.600, 16.554, 29.338)),
    (618892, (4.854, 16.064, 26.239)),
    (368561, (9.917, 19.523, 23.225)),
    (375918, (0.600, 10.472, 25.102)),
    (14873, (3.737, 18.103, 29.710)),
    (49332, (6.782, 11.838, 26.083)),
    (201107, (4.773, 16.880, 27.482)),
    (12051, (9.995, 18.682, 22.564)),
    (253863, (7.850, 12.784, 21.573)),
    (432812, (6.507, 11.196, 27.837)),
    (704654, (4.994, 17.190, 21.623)),
    (942579, (7.152, 10.354, 27.553)),
    (479854, (1.635, 17.921, 22.590)),
    (603446, (1.830, 11.267, 29.425)),
    (173588, (6.532, 10.038, 23.155)),
    (440640, (7.945, 16.284, 21.104)),
    (146265, (6.887, 13.455, 22.226)),
    (359332, (3.013, 19.593, 24.967)),
    (452959, (5.356, 10.182, 23.870)),
    (550100, (9.700, 16.044, 21.612)),
    (291146, (4.131, 18.398, 23.571)),
    (374337, (9.897, 18.780, 21.919)),
    (4193, (7.730, 16.364, 26.327)),
    (29231, (5.074, 18.318, 25.027)),
    (70789, (0.647, 15.854, 20.043)),
    (13117, (4.466, 17.078, 22.836)),
    (588502, (2.796, 11.134, 24.836)),
    (750876, (5.155, 12.753, 27.299)),
    (478746, (9.155, 14.681, 25.772)),
    (164025, (5.944, 14.432, 25.294)),
    (118480, (8.309, 13.407, 25.277)),
    (394823, (7.141, 10.250, 26.566)),
    (134947, (7.044, 14.275, 24.594)),
    (861448, (2.126, 14.873, 20.694)),
    (475107, (7.170, 15.633, 27.953)),
    (307951, (2.282, 17.448, 21.270)),
    (464965, (1.377, 12.305, 23.451)),
    (395695, (0.379, 11.974, 24.747)),
    (860422, (1.563, 15.040, 25.756)),
    (940538, (7.915, 18.164, 22.413)),
    (906445, (8.782, 17.012, 24.504)),
    (218747, (2.288, 11.309, 28.181)),
    (212197, (3.700, 11.289, 21.317)),
    (587624, (4.716, 18.817, 23.182)),
    (667844, (8.027, 19.745, 20.410)),
    (530210, (5.766, 12.863, 26.001)),
    (776224, (0.499, 17.868, 27.055)),
    (952480, (2.550, 15.662, 28.170)),
    (16848, (5.756, 12.849, 21.562)),
    (513670, (5.250, 12.523, 20.586)),
    (389425, (9.785, 17.901, 24.450)),
    (705952, (8.140, 16.544, 28.060)),
    (450266, (8.144, 17.110, 22.930)),
    (153410, (9.793, 11.881, 21.947)),
    (63969, (4.748, 14.827, 27.857)),
    (2391, (4.385, 14.077, 29.635)),
    (935734, (2.721, 10.780, 29.099)),
    (939737, (1.981, 12.732, 23.495)),
    (721719, (0.084, 17.724, 20.825)),
    (662377, (6.415, 10.492, 28.494)),
    (40235, (9.038, 17.498, 20.317)),
    (509810, (3.513, 15.636, 27.788)),
    (292094, (7.685, 13.379, 25.177)),
    (961458, (4.849, 19.281, 20.499)),
    (881530, (8.161, 19.188, 21.626)),
    (790478, (3.473, 12.898, 29.711)),
    (294008, (6.744, 16.655, 27.387)),
    (81430, (8.713, 14.669, 23.671)),
    (289581, (6.687, 11.447, 27.119)),
    (917273, (7.162, 12.057, 23.316)),
    (129889, (2.294, 15.075, 27.119)),
    (21670, (2.877, 10.849, 22.902)),
    (637484, (8.261, 13.377, 20.588)),
    (469903, (9.202, 12.238, 28.694)),
    (552180, (1.824, 13.171, 20.767)),
    (849653, (4.846, 14.152, 28.171)),
    (543771, (8.447, 17.562, 24.902)),
    (102457, (2.126, 13.886, 21.789)),
    (504435, (7.240, 10.873, 27.133)),
    (573448, (9.619, 15.039, 24.894)),
    (407272, (9.398, 17.289, 22.524)),
    (260782, (1.348, 11.874, 29.254)),
    (204110, (3.511, 16.503, 20.080)),
    (881465, (1.457, 13.747, 27.273)),
    (318205, (1.998, 15.334, 21.627)),
    (188649, (2.534, 11.981, 21.309)),
    (420965, (0.747, 19.021, 26.610)),
    (917012, (3.658, 11.264, 26.055)),
    (514380, (5.241, 14.428, 29.047)),
    (328539, (8.801, 18.485, 28.050)),
    (500639, (0.949, 17.109, 20.497)),
    (559313, (1.029, 19.932, 28.365)),
    (904077, (1.464, 15.370, 22.196)),
    (149251, (6.587, 12.161, 24.992)),
    (589977, (5.133, 15.314, 21.398)),
    (896590, (8.564, 19.667, 21.739)),
    (801183, (4.450, 13.626, 23.600)),
    (336262, (8.763, 19.279, 29.414)),
    (777341, (0.588, 14.999, 28.253)),
    (741973, (2.704, 13.478, 27.858)),
    (676660, (2.924, 17.958, 26.480)),
    (931556, (0.338, 14.280, 21.634)),
    (724193, (7.449, 18.899, 24.777)),
    (830271, (2.683, 12.678, 29.039)),
    (738443, (5.493, 13.131, 24.330)),
    (639016, (7.166, 11.561, 27.373)),
    (22906, (3.214, 14.015, 25.404)),
    (391016, (8.537, 16.391, 26.388)),
    (943016, (2.982, 15.379, 25.412)),
    (566113, (3.593, 19.551, 29.594)),
    (191163, (5.829, 12.673, 21.650)),
    (357354, (9.615, 18.753, 28.157)),
    (488185, (6.611, 15.307, 24.320)),
    (643241, (1.583, 19.717, 23.932)),
    (545663, (6.705, 19.470, 28.060)),
    (337726, (9.290, 17.436, 23.788)),
    (586819, (6.902, 15.549, 24.886)),
    (838309, (5.229, 18.267, 28.214)),
    (114846, (3.642, 17.522, 22.465)),
    (945660, (3.601, 19.934, 24.767)),
    (873639, (2.113, 13.880, 28.307)),
    (650755, (0.580, 12.834, 26.434)),
    (794811, (8.483, 16.663, 26.628)),
    (519435, (5.692, 19.551, 29.139)),
    (296385, (7.267, 15.924, 24.244)),
    (278341, (8.798, 19.603, 27.035)),
    (597986, (4.100, 19.388, 23.543)),
    (83798, (6.668, 12.342, 24.368)),
    (91241, (6.216, 10.079, 28.549)),
    (396632, (1.458, 10.172, 22.636)),
    (544251, (0.978, 15.621, 20.311)),
    (39497, (5.188, 15.533, 25.820)),
    (843830, (5.474, 10.627, 20.188)),
    (333509, (4.479, 12.863, 27.534)),
    (916278, (7.670, 14.807, 28.924)),
    (960755, (9.708, 11.188, 27.771)),
    (267994, (2.394, 10.786, 20.546)),
    (400931, (3.762, 17.898, 29.979)),
    (559087, (7.810, 11.253, 26.747)),
    (642289, (8.527, 10.557, 26.532)),
    (21782, (3.202, 17.896, 28.189)),
    (414880, (4.658, 12.158, 20.682)),
    (228197, (4.730, 16.045, 23.114)),
    (669093, (9.010, 15.986, 27.756)),
    (758109, (9.553, 13.044, 21.600)),
    (463562, (2.660, 10.785, 28.115)),
    (46425, (2.898, 11.880, 29.769)),
    (464816, (9.824, 18.861, 20.658)),
    (861589, (7.179, 13.203, 22.805)),
    (582161, (5.638, 13.628, 27.833)),
    (357654, (4.404, 15.161, 21.347)),
    (455534, (2.815, 15.688, 22.264)),
    (32701, (6.949, 12.859, 23.952)),
    (871353, (4.384, 13.330, 28.702)),
    (335946, (5.054, 11.274, 20.085)),
    (125225, (2.995, 11.825, 21.935)),
    (820208, (8.937, 12.135, 21.682)),
    (38662, (5.903, 19.570, 29.998)),
    (849994, (5.771, 12.624, 21.348)),
    (609791, (1.822, 14.214, 22.700)),
    (125804, (9.090, 10.883, 20.257)),
    (664396, (4.995, 19.373, 24.755)),
    (797343, (9.013, 10.351, 24.922)),
    (594412, (3.021, 14.639, 22.058)),
    (832109, (0.472, 10.886, 29.980)),
    (798352, (6.456, 17.251, 21.828)),
    (518884, (2.548, 19.387, 29.730)),
    (182488, (2.376, 10.448, 27.399)),
    (882684, (3.138, 13.753, 26.058)),
    (271146, (8.965, 19.063, 27.299)),
    (377059, (1.385, 15.718, 24.914)),
    (335384, (7.549, 11.437, 24.338)),
    (409221, (0.499, 13.442, 26.921)),
    (131725, (9.718, 15.673, 23.228)),
    (808934, (0.739, 11.173, 20.421)),
    (691765, (6.488, 12.428, 24.102)),
    (711757, (1.039, 12.030, 22.660)),
    (946907, (5.879, 11.250, 24.189)),
    (499343, (5.871, 12.498, 25.722)),
    (19072, (4.101, 13.399, 26.975)),
    (637010, (6.840, 18.558, 29.565)),
    (298321, (8.462, 13.783, 23.562)),
    (949718, (2.538, 18.114, 27.613)),
    (292449, (9.141, 10.352, 24.099)),
    (279178, (4.117, 13.631, 24.877)),
    (80488, (0.653, 19.785, 23.617)),
    (606567, (9.299, 15.872, 28.261)),
    (493951, (5.746, 13.460, 20.668)),
    (317064, (3.114, 18.656, 27.089)),
    (41267, (8.554, 18.204, 20.484)),
    (876350, (9.457, 12.991, 21.697)),
    (308465, (0.257, 14.325, 27.085)),
    (147139, (0.270, 16.254, 24.970)),
    (318139, (8.931, 10.588, 21.869)),
    (460589, (8.136, 13.867, 27.599)),
    (107147, (2.813, 11.879, 20.553)),
    (400581, (8.601, 16.349, 25.879)),
    (273661, (9.896, 11.275, 25.479)),
    (802069, (3.405, 14.901, 29.403)),
    (156957, (4.916, 17.168, 22.864)),
    (478930, (0.930, 18.698, 27.465)),
    (534183, (4.899, 12.798, 26.804)),
    (588632, (1.499, 12.779, 25.900)),
    (653457, (0.132, 11.901, 22.852)),
    (113788, (5.455, 17.564, 28.970)),
    (464068, (2.941, 10.397, 28.176)),
    (778336, (4.383, 16.354, 20.344)),
    (888514, (2.041, 16.860, 25.224)),
    (891169, (0.820, 11.098, 25.785)),
    (839746, (8.797, 14.332, 26.000)),
    (623937, (5.062, 11.696, 28.209)),
    (259126, (6.106, 19.101, 25.338)),
    (729583, (3.544, 16.105, 24.390)),
    (481091, (0.614, 14.701, 23.316)),
    (12350, (4.968, 17.240, 29.627)),
    (126692, (3.286, 19.850, 26.430)),
    (951318, (5.273, 12.890, 27.512)),
    (884441, (0.977, 17.202, 22.021)),
    (224754, (4.600, 13.441, 27.233)),
    (637527, (4.963, 15.958, 29.953)),
    (51661, (3.803, 19.753, 22.264)),
    (848954, (1.484, 18.460, 21.541)),
    (126871, (6.171, 13.026, 24.003)),
    (73067, (2.057, 16.834, 26.421)),
    (673969, (5.602, 17.855, 27.497)),
    (276093, (3.656, 14.375, 23.943)),
    (109924, (2.990, 12.740, 27.835)),
    (871735, (8.320, 17.339, 24.705)),
    (475968, (3.007, 10.798, 27.563)),
    (163991, (5.746, 12.818, 23.373)),
    (923158, (0.644, 10.447, 23.617)),
    (542640, (7.942, 16.152, 24.540)),
    (286358, (9.063, 19.624, 27.781)),
    (762657, (4.277, 18.683, 25.894)),
    (710869, (2.071, 11.777, 25.095)),
    (805705, (4.325, 11.370, 29.854)),
    (637162, (0.493, 19.555, 24.632)),
    (140473, (6.807, 19.151, 23.383)),
    (86854, (0.807, 10.669, 22.571)),
    (989506, (5.947, 19.277, 20.910)),
    (791427, (3.707, 10.637, 29.448)),
    (934271, (6.153, 17.753, 27.736)),
    (468645, (6.581, 14.412, 26.132)),
    (815552, (2.381, 13.507, 28.680)),
    (542162, (2.704, 10.869, 24.405)),
    (635517, (2.506, 10.808, 27.789)),
    (376864, (1.419, 17.823, 20.387)),
    (426956, (9.796, 16.742, 25.222)),
    (633890, (3.476, 13.193, 29.289)),
    (14425, (2.217, 13.241, 27.270)),
    (508965, (2.370, 18.105, 21.942)),
    (629911, (2.417, 15.061, 27.339)),
    (26065, (7.217, 16.835, 24.914)),
    (646838, (7.477, 10.608, 24.677)),
    (318852, (4.574, 11.774, 28.981)),
    (385978, (3.349, 16.671, 26.249)),
    (377541, (4.416, 15.436, 26.823)),
    (258046, (4.075, 10.670, 24.086)),
    (488648, (7.423, 16.144, 27.417)),
    (294452, (8.190, 13.654, 26.366)),
    (518074, (6.305, 12.140, 21.987)),
    (476992, (1.376, 17.823, 28.273)),
    (409251, (3.108, 17.542, 27.117)),
    (44570, (3.333, 10.715, 25.689)),
    (262692, (6.545, 11.132, 28.341)),
    (728115, (5.769, 13.325, 27.663)),
    (953879, (8.687, 12.838, 29.565)),
    (588533, (4.784, 18.588, 26.669)),
    (79053, (0.563, 14.344, 21.490)),
    (419152, (3.704, 18.196, 23.575)),
    (850819, (8.004, 11.275, 27.721)),
    (825962, (0.544, 10.361, 24.640)),
    (583352, (1.069, 14.447, 28.364)),
    (32193, (8.911, 16.902, 21.575)),
    (414623, (4.946, 18.061, 24.503)),
    (188218, (6.636, 17.293, 25.755)),
    (225354, (1.544, 14.841, 22.320)),
    (953370, (9.015, 17.182, 29.227)),
    (543647, (3.716, 13.049, 22.443)),
    (483689, (9.442, 14.489, 24.253)),
    (314921, (7.784, 15.237, 28.900)),
    (26958, (8.337, 10.281, 29.168)),
    (777211, (4.166, 14.875, 28.565)),
    (80746, (4.961, 16.405, 26.254)),
    (775960, (3.439, 18.920, 23.386)),
    (155105, (1.767, 12.386, 28.578)),
    (697108, (0.140, 19.515, 22.845)),
    (970402, (7.258, 19.483, 29.045)),
    (962012, (4.689, 11.823, 23.255)),
    (849604, (6.943, 13.284, 27.942)),
    (537087, (5.451, 17.857, 28.263)),
    (487509, (5.590, 17.535, 23.157)),
    (483096, (1.125, 18.009, 21.175)),
    (990181, (8.462, 13.607, 23.443)),
    (255658, (3.902, 18.282, 25.870)),
    (527497, (4.010, 17.100, 23.955)),
    (798182, (0.106, 15.034, 27.693)),
    (37582, (0.331, 11.088, 29.433)),
    (154360, (1.646, 19.325, 23.032)),
    (379741, (2.942, 19.958, 26.624)),
    (287826, (5.798, 18.392, 20.710)),
    (82353, (5.481, 18.498, 20.480)),
    (58062, (4.178, 16.970, 27.695)),
    (974896, (9.729, 10.887, 29.078)),
    (902476, (2.928, 15.332, 27.953)),
    (261770, (5.587, 18.566, 26.405)),
    (800798, (3.822, 13.515, 24.933)),
    (412608, (1.681, 13.500, 22.712)),
    (238148, (3.083, 11.738, 26.145)),
    (384925, (2.601, 12.445, 20.732)),
    (913815, (6.495, 15.806, 27.330)),
    (226286, (2.795, 11.949, 21.875)),
    (347858, (6.208, 13.023, 24.847)),
    (419414, (4.314, 19.409, 28.577)),
    (570831, (8.602, 15.052, 23.819)),
    (393649, (0.816, 16.583, 29.438)),
    (378389, (2.107, 14.006, 26.240)),
    (354143, (3.920, 16.952, 26.964)),
    (818539, (2.301, 19.509, 24.662)),
    (635900, (2.298, 12.944, 26.428)),
    (230041, (1.902, 11.007, 26.871)),
    (769113, (7.186, 19.956, 21.904)),
    (365907, (5.935, 18.457, 26.806)),
    (619495, (4.519, 11.608, 20.038)),
    (762400, (8.299, 11.748, 29.722)),
    (66431, (9.292, 16.767, 28.460)),
    (892991, (5.962, 14.542, 28.851)),
    (779188, (4.492, 11.135, 29.914)),
    (643469, (2.983, 11.242, 21.629)),
    (938453, (5.291, 12.284, 21.457)),
    (570529, (0.509, 17.042, 28.378)),
    (331258, (8.809, 17.428, 20.887)),
    (737929, (6.298, 12.956, 24.869)),
    (183953, (6.081, 18.748, 27.405)),
    (423693, (5.293, 19.182, 27.384)),
    (567058, (6.668, 14.197, 22.802)),
    (482242, (3.620, 12.280, 23.467)),
    (586081, (5.215, 12.990, 21.125)),
    (720723, (6.733, 13.496, 23.284)),
    (877554, (4.299, 13.979, 21.338)),
    (596170, (2.477, 16.642, 25.492)),
    (357494, (5.188, 10.804, 20.189)),
    (571152, (7.391, 16.024, 25.486)),
    (599836, (8.062, 18.282, 20.048)),
    (668752, (9.188, 17.667, 21.896)),
    (196574, (1.642, 17.785, 26.502)),
    (598830, (3.899, 18.004, 24.169)),
    (837737, (0.709, 16.282, 24.039)),
    (561916, (1.064, 14.600, 27.732)),
    (816991, (1.528, 14.136, 26.292)),
    (353715, (5.371, 18.308, 25.446)),
    (383994, (5.119, 19.449, 27.083)),
    (777096, (0.145, 15.913, 23.423)),
    (649969, (5.022, 15.857, 20.516)),
    (567534, (5.081, 13.019, 20.461)),
    (157029, (2.853, 14.445, 25.753)),
    (404681, (3.612, 11.986, 21.435)),
    (290928, (7.471, 12.937, 21.133)),
    (502802, (0.114, 11.903, 24.165)),
    (926123, (1.191, 10.915, 28.655)),
    (419433, (8.664, 16.972, 29.843)),
    (428220, (7.204, 13.612, 20.865)),
    (773536, (3.873, 10.538, 23.021)),
    (815026, (3.464, 11.665, 27.686)),
    (499718, (9.158, 10.447, 25.787)),
    (901880, (9.587, 10.516, 28.399)),
    (14989, (7.756, 11.350, 26.769)),
    (54045, (2.586, 17.155, 23.838)),
    (568927, (9.434, 10.957, 29.978)),
    (262306, (4.478, 12.661, 25.016)),
    (915620, (6.429, 10.949, 28.022)),
    (831194, (1.360, 17.796, 22.310)),
    (767120, (8.564, 19.256, 21.670)),
    (386022, (6.184, 16.775, 24.153)),
    (789353, (3.009, 19.083, 26.872)),
    (682546, (9.844, 12.091, 23.819)),
    (815420, (3.934, 17.119, 24.839)),
    (340007, (1.798, 16.623, 28.249)),
    (982586, (4.577, 10.742, 28.249)),
    (620564, (5.192, 10.281, 25.310)),
    (58232, (9.539, 14.081, 22.037)),
    (151660, (9.293, 15.418, 25.945)),
    (214246, (2.523, 13.404, 22.480)),
    (915144, (9.327, 17.597, 28.393)),
    (519926, (2.866, 13.341, 27.903)),
    (835173, (9.336, 11.233, 27.956)),
    (674993, (4.877, 14.856, 28.823)),
    (180364, (3.771, 15.847, 26.097)),
    (226255, (0.463, 19.897, 23.388)),
    (354388, (6.108, 16.818, 27.679)),
    (414179, (9.741, 12.855, 27.352)),
    (402690, (1.738, 19.357, 28.008)),
    (526504, (9.360, 18.000, 24.548)),
    (62014, (0.513, 14.250, 27.274)),
    (372394, (9.355, 15.397, 29.658)),
    (737438, (2.553, 13.217, 25.239)),
    (449612, (6.029, 16.563, 25.568)),
    (488978, (9.430, 18.064, 20.778)),
    (464054, (3.852, 18.289, 28.904)),
    (50815, (9.497, 10.676, 25.154)),
    (586832, (6.146, 10.735, 21.778)),
    (329180, (8.316, 19.958, 22.139)),
    (366026, (8.052, 12.871, 28.124)),
    (229764, (0.254, 12.785, 28.547)),
    (479358, (7.827, 17.805, 28.222)),
    (312545, (5.960, 19.730, 24.135)),
    (719555, (1.866, 15.541, 24.621)),
    (892249, (1.405, 18.883, 20.299)),
    (63671, (4.106, 19.256, 23.806)),
    (685393, (8.898, 19.047, 28.024)),
    (670361, (7.135, 11.173, 24.889)),
    (102620, (6.737, 15.311, 21.506)),
    (347101, (2.978, 18.197, 27.925)),
    (445241, (6.851, 11.000, 23.599)),
    (801044, (3.227, 18.849, 29.528)),
    (176693, (2.025, 19.488, 23.155)),
    (962267, (7.059, 10.637, 25.916)),
    (762874, (3.622, 11.327, 24.147)),
    (388497, (6.586, 19.361, 23.882)),
    (771511, (9.815, 10.147, 28.154)),
    (304025, (0.983, 10.935, 29.453)),
    (964458, (4.872, 15.422, 24.093)),
    (178296, (1.737, 11.513, 28.056)),
    (929660, (9.824, 10.679, 24.434)),
    (286251, (5.777, 13.217, 22.787)),
    (279352, (5.391, 18.237, 26.868)),
    (183422, (9.042, 10.836, 20.238)),
    (860922, (2.335, 11.955, 28.155)),
    (315440, (8.010, 17.556, 24.543)),
    (39941, (9.816, 10.596, 27.219)),
    (119766, (1.299, 19.244, 29.078)),
    (613052, (9.463, 15.947, 26.574)),
    (759997, (6.488, 11.089, 21.819)),
    (901608, (4.543, 15.979, 23.979)),
    (98211, (5.156, 11.427, 20.657)),
    (352963, (1.528, 14.804, 20.851)),
    (567094, (4.078, 18.529, 24.709)),
    (182841, (6.305, 17.378, 25.459)),
    (969061, (6.458, 17.253, 24.051)),
    (737755, (3.088, 18.409, 25.257)),
    (634234, (7.136, 19.368, 29.659)),
    (935018, (6.779, 11.570, 28.012)),
    (339616, (7.634, 15.146, 22.439)),
    (913184, (9.145, 19.602, 27.042)),
    (450560, (4.577, 18.747, 26.026)),
    (643980, (6.410, 15.286, 20.574)),
    (918631, (7.019, 15.866, 27.160)),
    (550925, (5.414, 14.247, 22.764)),
    (954956, (2.102, 14.505, 26.695)),
    (294578, (4.936, 14.283, 21.512)),
    (184855, (0.558, 18.227, 25.776)),
    (284577, (3.950, 16.453, 28.161)),
    (209940, (3.382, 13.051, 27.585)),
    (712011, (8.087, 11.118, 20.846)),
    (802758, (4.248, 13.335, 25.547)),
    (705182, (2.976, 11.796, 24.918)),
    (699346, (4.694, 14.913, 25.344)),
    (487581, (7.520, 18.968, 26.349)),
    (506609, (9.087, 15.001, 24.912)),
    (503472, (6.907, 16.870, 25.173)),
    (711107, (8.150, 13.346, 28.286)),
    (99310, (9.549, 19.051, 20.768)),
    (788202, (3.679, 11.573, 29.132)),
    (129446, (1.122, 13.577, 28.661)),
    (389640, (5.582, 15.689, 28.385)),
    (803, (8.740, 19.845, 20.818)),
    (458775, (9.869, 17.955, 22.797)),
    (947884, (9.380, 12.774, 24.336)),
    (664885, (0.908, 14.759, 20.963)),
    (279140, (0.630, 15.943, 25.615)),
    (221219, (5.960, 11.397, 27.222)),
    (924850, (8.875, 15.742, 20.527)),
    (511963, (8.589, 18.979, 29.613)),
    (865027, (9.974, 15.132, 24.753)),
    (776779, (6.736, 16.257, 21.174)),
    (788738, (3.149, 10.659, 20.273)),
    (63681, (0.870, 17.867, 21.044)),
    (455622, (2.324, 19.426, 23.336)),
    (907050, (2.256, 11.534, 26.862)),
    (726622, (4.197, 11.716, 23.404)),
    (549394, (0.489, 15.096, 24.923)),
    (406419, (2.111, 13.875, 20.741)),
    (782274, (6.986, 19.578, 22.077)),
    (23579, (1.692, 12.200, 27.336)),
    (791544, (1.785, 14.235, 22.495)),
    (881491, (1.775, 18.236, 25.885)),
    (33230, (9.633, 16.756, 21.883)),
    (842071, (8.379, 15.248, 25.092)),
    (304765, (0.962, 15.782, 25.706)),
    (718063, (9.171, 18.153, 23.101)),
    (659286, (3.437, 14.317, 25.765)),
    (800811, (0.805, 17.061, 25.362)),
    (47933, (3.275, 17.037, 20.549)),
    (656438, (8.659, 18.972, 21.829)),
    (654740, (4.646, 13.112, 29.582)),
    (987733, (4.253, 16.780, 21.382)),
    (688630, (0.023, 11.050, 23.865)),
    (826052, (3.844, 13.495, 27.492)),
    (925750, (4.828, 14.686, 29.318)),
    (30658, (2.037, 18.075, 22.963)),
    (404838, (6.713, 13.482, 27.294)),
    (719763, (2.585, 15.694, 23.421)),
    (883436, (0.210, 16.493, 24.257)),
    (843165, (4.202, 15.212, 23.600)),
    (225445, (9.943, 17.778, 26.036)),
    (293470, (5.123, 18.263, 29.288)),
    (268618, (0.078, 11.380, 24.308)),
    (287224, (2.355, 17.719, 29.105)),
    (942462, (8.003, 16.287, 29.110)),
    (154053, (9.109, 10.406, 29.851)),
    (611426, (1.605, 17.695, 27.110)),
    (228678, (2.802, 11.831, 23.516)),
    (788042, (9.592, 15.561, 25.588)),
    (481196, (1.111, 12.660, 26.450)),
    (408533, (8.131, 17.431, 22.324)),
    (934094, (2.047, 17.048, 27.157)),
    (134726, (7.101, 15.472, 24.982)),
    (398895, (9.710, 15.920, 23.566)),
    (824834, (6.040, 17.662, 22.959)),
    (698247, (1.791, 12.659, 21.833)),
    (488422, (3.704, 12.926, 23.045)),
    (877626, (7.917, 18.133, 29.122)),
    (419152, (9.058, 14.616, 25.342)),
    (113868, (7.943, 16.948, 21.035)),
    (72057, (1.156, 19.267, 29.570)),
    (432117, (6.481, 16.506, 26.775)),
    (606069, (6.207, 18.944, 21.193)),
    (274738, (0.700, 10.201, 27.871)),
    (453529, (0.061, 14.212, 26.832)),
    (734598, (3.222, 11.038, 29.818)),
    (493002, (8.303, 13.304, 20.961)),
    (977696, (8.820, 19.130, 25.366)),
    (272555, (0.303, 19.290, 24.462)),
    (247683, (5.645, 18.655, 22.917)),
    (558997, (3.096, 16.295, 23.893)),
    (44750, (1.732, 12.746, 22.233)),
    (867401, (0.300, 16.322, 25.456)),
    (336124, (4.073, 14.412, 24.841)),
    (710047, (0.819, 13.858, 26.295)),
    (716362, (5.736, 11.999, 27.992)),
    (212079, (5.856, 12.240, 29.956)),
    (836185, (5.282, 16.483, 22.824)),
    (94392, (3.699, 15.935, 23.017)),
    (719340, (5.724, 14.426, 25.934)),
    (674782, (0.870, 18.120, 29.524)),
    (996181, (4.781, 14.421, 25.950)),
    (878615, (8.816, 16.091, 28.063)),
    (273008, (3.970, 17.748, 23.584)),
    (173814, (8.212, 18.955, 22.811)),
    (342206, (8.181, 14.303, 23.245)),
    (440290, (0.707, 10.219, 25.584)),
    (556660, (2.651, 11.976, 26.278)),
    (257130, (8.776, 18.097, 28.073)),
    (627050, (9.937, 13.320, 21.772)),
    (756154, (6.958, 11.991, 24.939)),
    (461798, (0.038, 10.247, 29.703)),
    (412857, (5.206, 12.761, 27.937)),
    (820748, (3.747, 13.086, 25.333)),
    (536907, (0.710, 11.582, 20.029)),
    (172478, (0.421, 14.743, 24.169)),
    (405984, (2.365, 14.308, 29.595)),
    (159203, (2.167, 17.789, 27.580)),
    (670137, (1.983, 17.391, 29.377)),
    (185520, (6.320, 15.282, 24.860)),
    (328702, (4.386, 16.739, 27.910)),
    (932583, (8.178, 19.963, 24.260)),
    (60205, (8.028, 13.935, 24.864)),
    (470275, (7.923, 12.181, 22.073)),
    (367764, (0.493, 18.425, 24.501)),
    (561784, (5.710, 10.884, 27.979)),
    (501792, (2.590, 13.649, 26.487)),
    (253722, (1.869, 11.896, 26.233)),
    (225281, (3.349, 13.807, 28.881)),
    (587066, (4.214, 10.364, 25.589)),
    (136192, (1.463, 18.079, 25.781)),
    (953183, (8.179, 18.231, 27.549)),
    (887443, (2.336, 10.285, 22.727)),
    (598363, (5.818, 15.342, 21.183)),
    (288247, (7.784, 18.963, 24.999)),
    (321620, (7.361, 12.150, 29.327)),
    (711572, (9.163, 16.194, 26.202)),
    (130901, (7.539, 14.742, 24.418)),
    (844929, (1.705, 18.709, 29.365)),
    (632362, (7.691, 18.535, 26.990)),
    (828224, (2.511, 17.624, 21.207)),
    (739064, (5.065, 14.339, 23.721)),
    (316913, (8.649, 13.889, 28.715)),
    (49684, (3.740, 17.267, 26.560)),
    (827670, (6.167, 14.478, 27.437)),
    (675302, (7.735, 16.477, 23.711)),
    (820808, (8.716, 10.366, 28.322)),
    (486277, (4.467, 14.289, 29.023)),
    (641566, (2.286, 16.203, 20.641)),
    (162663, (3.242, 12.441, 26.822)),
    (268301, (4.218, 12.656, 20.378)),
    (217257, (7.254, 15.084, 26.389)),
    (150883, (5.818, 14.121, 22.482)),
    (636081, (5.144, 11.670, 21.198)),
    (215577, (9.277, 19.648, 23.427)),
    (106950, (4.704, 19.398, 20.428)),
    (300353, (8.471, 18.931, 27.619)),
    (660779, (1.386, 19.702, 23.544)),
    (643762, (6.684, 17.122, 23.244)),
    (746207, (0.013, 16.392, 29.379)),
    (78950, (9.329, 18.417, 29.616)),
    (472342, (5.610, 11.457, 21.234)),
    (698628, (5.253, 12.616, 24.951)),
    (1527, (1.117, 16.111, 23.404)),
    (787634, (9.389, 11.564, 21.396)),
    (129369, (0.763, 16.611, 22.869)),
    (506428, (7.304, 14.029, 29.164)),
    (885367, (3.419, 15.277, 26.589)),
    (177669, (7.663, 15.658, 27.645)),
    (871489, (1.605, 11.031, 21.464)),
    (839662, (8.444, 11.291, 24.080)),
    (983912, (3.769, 16.856, 27.574)),
    (218516, (0.268, 15.615, 25.074)),
    (866640, (1.344, 10.443, 21.822)),
    (72670, (3.857, 10.307, 20.371)),
    (223097, (5.366, 19.365, 25.981)),
    (225451, (1.346, 10.591, 20.890)),
    (959578, (6.392, 10.324, 24.820)),
    (409281, (5.021, 18.708, 20.630)),
    (405435, (8.871, 10.054, 28.906)),
    (221559, (0.656, 11.909, 25.430)),
    (158410, (4.607, 13.067, 22.133)),
    (185971, (6.734, 14.697, 25.220)),
    (648294, (9.356, 14.235, 21.400)),
    (413370, (2.562, 14.717, 21.016)),
    (113721, (0.972, 13.060, 21.224)),
    (451725, (6.118, 18.863, 21.057)),
    (791037, (0.419, 10.088, 28.444)),
    (489717, (9.602, 19.389, 21.484)),
    (727397, (3.605, 17.038, 26.791)),
    (311851, (7.302, 15.976, 27.816)),
    (388014, (5.378, 18.679, 24.417)),
    (110163, (0.624, 14.836, 25.494)),
    (840656, (5.982, 12.203, 24.109)),
    (818221, (0.129, 11.411, 20.674)),
    (241055, (7.567, 12.027, 20.995)),
    (19359, (2.716, 19.015, 20.863)),
    (676868, (2.210, 16.724, 29.506)),
    (670996, (1.962, 17.352, 29.119)),
    (603216, (1.562, 17.923, 29.420)),
    (508157, (7.476, 18.492, 28.283)),
    (579728, (0.974, 14.452, 21.020)),
    (120040, (7.434, 12.834, 24.591)),
    (121113, (2.184, 17.685, 25.050)),
    (413655, (3.788, 16.673, 27.274)),
    (2398, (2.714, 16.941, 29.672)),
    (712693, (7.158, 10.574, 21.076)),
    (71183, (9.896, 14.014, 20.757)),
    (463062, (2.352, 16.964, 28.499)),
    (956555, (9.854, 15.890, 26.053)),
    (307425, (0.457, 14.964, 21.032)),
    (529970, (3.041, 16.683, 27.245)),
    (146879, (5.661, 16.607, 24.450)),
    (739838, (1.936, 10.333, 26.063)),
    (933205, (3.611, 11.592, 21.849)),
    (499906, (9.698, 15.325, 26.421)),
    (476333, (7.884, 14.016, 24.190)),
    (916775, (0.723, 14.052, 27.881)),
    (999219, (4.840, 12.099, 22.932)),
    (462627, (0.896, 19.625, 28.392)),
    (462056, (1.793, 19.961, 21.539)),
    (499310, (9.986, 18.837, 28.798)),
    (123212, (0.277, 11.404, 28.576)),
    (840666, (9.249, 11.397, 29.453)),
    (442839, (8.982, 19.473, 21.346)),
    (753437, (1.071, 10.728, 20.193)),
    (483726, (2.042, 12.357, 25.181)),
    (752474, (2.573, 11.942, 26.122)),
    (300317, (3.993, 10.527, 24.000)),
    (219659, (6.280, 16.591, 26.625)),
    (715402, (0.497, 10.101, 25.394)),
    (884484, (1.253, 10.398, 23.644)),
    (350547, (5.848, 16.573, 20.692)),
    (776326, (1.661, 10.843, 25.441)),
    (91078, (6.924, 16.797, 29.712)),
    (942938, (9.775, 15.703, 27.234)),
    (669003, (4.834, 11.941, 26.302)),
    (458783, (0.429, 17.775, 22.295)),
    (894901, (2.017, 17.476, 25.186)),
    (542517, (2.178, 18.099, 27.793)),
    (600741, (0.772, 17.071, 28.427)),
    (430393, (5.519, 10.231, 22.800)),
    (758643, (8.931, 17.637, 22.582)),
    (21528, (9.475, 11.931, 29.254)),
    (856924, (3.183, 12.011, 23.635)),
    (415166, (4.748, 18.269, 25.556)),
    (945724, (7.797, 18.397, 27.783)),
    (278741, (0.807, 19.229, 28.934)),
    (153396, (8.157, 18.023, 27.583)),
    (721696, (5.901, 18.601, 26.372)),
    (113333, (9.009, 19.780, 23.745)),
    (154960, (1.933, 19.055, 27.089)),
    (519436, (5.648, 12.256, 20.562)),
    (883897, (3.363, 11.094, 22.503)),
    (967484, (6.627, 15.336, 21.604)),
    (985056, (0.702, 18.945, 25.990)),
    (47898, (9.305, 12.509, 20.304)),
    (716380, (0.088, 16.767, 20.939)),
    (131213, (2.936, 19.069, 28.345)),
    (326154, (2.217, 19.396, 25.350)),
    (602961, (0.682, 17.099, 24.157)),
    (885063, (0.297, 16.014, 24.454)),
    (588275, (7.872, 17.361, 28.314)),
    (176114, (7.137, 11.999, 22.010)),
    (872680, (0.059, 10.055, 25.866)),
    (463140, (8.961, 11.056, 26.890)),
    (232867, (5.705, 12.399, 21.921)),
    (253938, (6.639, 15.083, 23.237)),
    (682505, (4.465, 13.127, 21.889)),
    (477565, (5.785, 15.011, 20.572)),
    (763379, (1.233, 12.071, 21.770)),
    (581076, (1.196, 13.073, 22.375)),
    (854863, (1.977, 11.208, 23.279)),
    (28293, (3.092, 12.282, 27.171)),
    (950145, (1.718, 12.666, 25.279)),
    (889676, (1.913, 18.285, 23.180)),
    (896100, (1.867, 14.963, 23.988)),
    (389922, (5.640, 17.782, 23.903)),
    (974289, (0.002, 18.324, 23.124)),
    (179876, (5.801, 12.061, 25.347)),
    (601090, (5.974, 15.963, 29.756)),
    (241802, (7.918, 17.531, 23.784)),
    (94746, (4.880, 18.461, 28.539)),
    (783440, (3.767, 13.142, 26.316)),
    (316785, (6.456, 17.266, 24.196)),
    (228991, (8.692, 19.628, 23.187)),
    (884176, (2.815, 12.803, 26.342)),
    (258878, (5.736, 18.849, 28.067)),
    (259500, (3.721, 18.766, 21.610)),
    (243300, (1.482, 12.571, 26.287)),
    (759169, (8.799, 10.594, 23.614)),
    (244374, (5.510, 15.408, 22.162)),
    (911511, (3.552, 12.720, 26.397)),
    (412825, (6.489, 18.432, 29.569)),
    (952550, (8.561, 19.162, 24.001)),
    (23149, (3.746, 15.781, 29.102)),
    (945897, (6.828, 13.960, 27.903)),
    (56404, (4.947, 19.671, 22.151)),
    (128202, (8.436, 14.079, 28.457)),
    (910144, (0.643, 16.581, 27.317)),
    (902828, (6.604, 13.476, 24.747)),
    (196102, (3.696, 17.034, 27.988)),
    (166483, (5.533, 17.884, 23.796)),
    (763750, (6.496, 17.338, 20.700)),
    (221227, (5.062, 13.522, 24.951)),
    (668532, (5.855, 13.448, 23.478)),
    (825698, (5.374, 19.523, 20.012)),
    (629341, (3.991, 11.613, 27.609)),
    (928816, (4.445, 18.359, 28.160)),
    (348736, (2.264, 17.781, 24.761)),
    (229339, (1.843, 13.835, 21.645)),
    (824233, (6.582, 12.318, 27.818)),
    (956998, (8.603, 16.067, 23.069)),
    (621287, (2.876, 17.336, 20.532)),
    (436639, (6.343, 17.719, 29.906)),
    (20367, (8.151, 19.205, 23.759)),
    (836567, (7.099, 19.223, 27.851)),
    (444669, (6.774, 10.077, 25.699)),
    (899254, (1.931, 13.217, 27.832)),
    (581446, (6.294, 17.403, 21.126)),
    (720465, (4.093, 13.365, 23.095)),
    (679537, (7.354, 19.027, 22.906)),
    (201455, (0.962, 12.034, 29.523)),
    (92257, (5.141, 14.710, 26.347)),
    (824950, (8.234, 19.121, 28.244)),
    (664094, (9.831, 18.917, 23.526)),
    (298477, (2.253, 17.458, 29.671)),
    (15555, (1.001, 16.881, 22.122)),
    (10983, (3.792, 17.600, 26.706)),
    (843370, (2.093, 18.504, 29.346)),
    (761246, (0.155, 10.282, 26.839)),
    (620104, (8.781, 17.865, 20.461)),
    (416768, (4.119, 13.200, 28.938)),
    (737668, (2.600, 15.555, 26.406)),
    (321390, (8.436, 19.550, 23.744)),
    (931805, (8.136, 11.778, 29.261)),
    (632949, (0.828, 14.912, 22.095)),
    (843636, (0.943, 14.774, 20.094)),
    (911250, (5.531, 13.194, 23.756)),
    (453124, (3.290, 12.739, 25.128)),
    (67847, (5.853, 14.723, 24.056)),
    (211660, (1.458, 11.139, 22.034)),
    (621621, (6.109, 13.855, 26.699)),
    (984826, (3.671, 18.205, 20.896)),
    (575433, (5.822, 13.169, 21.406)),
    (340578, (4.090, 17.881, 29.264)),
    (836514, (6.246, 16.878, 23.455)),
    (490717, (7.026, 19.272, 24.849)),
    (677676, (8.832, 11.657, 22.402)),
    (74375, (7.074, 10.160, 26.266)),
    (329695, (8.767, 17.354, 25.011)),
    (376191, (9.278, 12.967, 20.037)),
    (540702, (3.361, 16.410, 29.961)),
    (612461, (0.819, 12.127, 29.680)),
    (910523, (9.711, 12.919, 24.476)),
    (102296, (5.857, 14.678, 28.428)),
    (524125, (8.873, 12.987, 25.026)),
    (836976, (8.392, 15.266, 29.190)),
    (886102, (2.901, 14.673, 20.459)),
    (39398, (2.289, 10.575, 28.111)),
    (389981, (0.350, 19.843, 23.630)),
    (498141, (8.085, 10.016, 27.012)),
    (56698, (8.612, 18.982, 29.493)),
    (325463, (9.858, 11.926, 27.593)),
    (701741, (5.407, 12.950, 25.588)),
    (861456, (9.968, 16.570, 25.522)),
    (756050, (8.212, 13.938, 22.058)),
    (544202, (7.160, 11.396, 23.615)),
    (705434, (7.246, 14.886, 27.779)),
    (329788, (8.374, 17.510, 26.757)),
    (792773, (6.836, 19.119, 29.089)),
    (165684, (3.353, 15.242, 21.776)),
    (949124, (0.559, 17.170, 26.777)),
    (999816, (6.839, 12.241, 28.743)),
    (230395, (4.454, 16.984, 21.687)),
    (192563, (1.572, 17.330, 22.032)),
    (427752, (3.109, 18.061, 25.548)),
    (930538, (3.669, 10.425, 24.306)),
    (547471, (9.335, 12.166, 29.215)),
    (228725, (0.585, 19.188, 24.552)),
    (546769, (4.436, 16.548, 21.294)),
    (468304, (7.432, 16.730, 24.315)),
    (698527, (8.279, 18.786, 26.428)),
    (723728, (1.577, 13.231, 21.410)),
    (883337, (9.144, 16.799, 26.225)),
    (89534, (1.392, 10.383, 26.627)),
    (649225, (7.066, 16.278, 21.468)),
    (883301, (5.561, 17.710, 23.549)),
    (123638, (7.732, 13.640, 23.622)),
    (317821, (1.038, 11.633, 23.660)),
    (68985, (9.790, 19.752, 29.883)),
    (493424, (5.693, 14.933, 25.020)),
    (915128, (1.835, 10.132, 27.106)),
    (983043, (6.808, 18.067, 28.974)),
    (83733, (7.024, 13.630, 27.575)),
    (167575, (0.652, 13.041, 27.775)),
    (410672, (6.091, 19.579, 28.474)),
    (224625, (6.745, 16.484, 29.812)),
    (315961, (9.195, 15.314, 24.836)),
    (759491, (5.153, 18.199, 27.740)),
    (934387, (9.153, 19.411, 22.263)),
    (895048, (7.259, 15.058, 20.035)),
    (61352, (9.878, 17.693, 29.960)),
    (217765, (9.227, 10.033, 26.979)),
    (688229, (6.086, 17.103, 27.353)),
    (542637, (1.583, 10.596, 21.423)),
    (453849, (5.949, 19.651, 25.527)),
    (595074, (5.219, 14.083, 28.747)),
    (221779, (4.796, 19.198, 21.737)),
    (289326, (1.099, 10.937, 28.577)),
    (925264, (1.541, 19.978, 27.122)),
    (212062, (1.522, 11.556, 26.900)),
    (365066, (1.311, 14.891, 23.211)),
    (430153, (5.959, 17.131, 29.687)),
    (60284, (5.875, 15.023, 22.576)),
    (619569, (5.648, 12.651, 23.775)),
    (792849, (9.383, 14.729, 26.732)),
    (702152, (6.542, 12.826, 27.446)),
    (578188, (1.129, 10.559, 26.854)),
    (74745, (9.113, 18.062, 28.275)),
    (761565, (4.178, 19.153, 22.388)),
    (191370, (2.487, 19.291, 22.639)),
    (231876, (4.875, 16.437, 23.470)),
    (107063, (0.844, 12.254, 26.071)),
    (849330, (5.973, 10.792, 27.749)),
    (94393, (1.397, 11.270, 20.807)),
    (265354, (7.412, 19.592, 22.536)),
    (897919, (6.495, 15.095, 27.857)),
    (378587, (8.157, 19.359, 21.609)),
    (883473, (3.591, 16.732, 21.076)),
    (530257, (7.897, 19.754, 25.972)),
    (908443, (5.527, 10.792, 29.456)),
    (665199, (7.169, 13.422, 23.681)),
    (494114, (1.237, 12.584, 21.695)),
    (528153, (3.177, 17.184, 25.574)),
    (253473, (6.530, 16.157, 24.772)),
    (765817, (6.194, 18.687, 25.455)),
    (36310, (6.411, 13.172, 25.660)),
    (340483, (0.384, 16.058, 25.292)),
    (420289, (6.724, 17.463, 26.652)),
    (516216, (5.739, 15.530, 27.286)),
    (105875, (2.248, 13.401, 29.525)),
    (386874, (9.412, 19.968, 24.017)),
    (46349, (0.325, 18.101, 29.862)),
    (553260, (0.766, 11.789, 28.756)),
    (716490, (2.312, 18.256, 27.291)),
    (559571, (9.686, 18.737, 28.943)),
    (666654, (5.852, 12.324, 27.156)),
    (738178, (9.068, 16.674, 24.799)),
    (988916, (9.393, 17.788, 25.565)),
    (184128, (2.120, 12.723, 22.385)),
    (688841, (8.351, 13.913, 24.460)),
    (759635, (2.094, 18.551, 24.341)),
    (700981, (1.400, 17.237, 27.085)),
    (455450, (6.255, 15.961, 29.055)),
    (197683, (1.363, 11.186, 27.467)),
    (158796, (0.226, 10.155, 25.412)),
    (385746, (4.260, 16.258, 25.518)),
    (550125, (2.897, 14.307, 21.020)),
    (354277, (8.616, 16.565, 28.233)),
    (489591, (3.826, 14.705, 29.017)),
    (674101, (0.038, 19.805, 26.134)),
    (806875, (6.653, 15.080, 26.080)),
    (110401, (3.626, 13.783, 20.411)),
    (464147, (4.665, 11.306, 27.049)),
    (813149, (0.517, 17.262, 27.999)),
    (982687, (0.393, 13.659, 25.609)),
    (127081, (2.363, 11.676, 25.272)),
    (285277, (9.101, 13.124, 24.310)),
    (377985, (2.257, 15.056, 27.875)),
    (102838, (4.063, 19.847, 27.509)),
    (840007, (5.230, 10.309, 25.554)),
    (748348, (1.148, 17.799, 29.297)),
    (223948, (0.055, 16.538, 28.585)),
    (9883, (5.059, 18.502, 27.870)),
    (754040, (6.287, 11.635, 26.547)),
    (283702, (7.832, 13.579, 20.030)),
    (152328, (9.830, 12.605, 25.403)),
    (19418, (8.591, 15.232, 20.045)),
    (79872, (2.078, 18.353, 27.999)),
    (827120, (3.571, 19.387, 20.885)),
    (548788, (3.953, 18.291, 24.162)),
    (97789, (9.657, 11.951, 24.233)),
    (384766, (4.334, 16.345, 26.611)),
    (756203, (9.195, 12.835, 28.130)),
    (788468, (2.938, 18.050, 27.178)),
    (252314, (3.317, 10.754, 24.528)),
    (45873, (5.010, 19.204, 29.052)),
    (606551, (3.386, 13.814, 29.123)),
    (496513, (7.466, 19.652, 29.429)),
    (88240, (3.659, 10.823, 27.778)),
    (692250, (9.637, 14.698, 25.691)),
    (97440, (7.259, 12.130, 23.520)),
    (472068, (4.901, 14.799, 27.701)),
    (526996, (3.407, 17.931, 25.163)),
    (221993, (1.674, 14.992, 24.822)),
    (745276, (1.853, 15.555, 28.143)),
    (529646, (2.962, 18.709, 29.934)),
    (851725, (0.467, 19.400, 20.510)),
    (130151, (3.946, 12.777, 27.888)),
    (972102, (9.277, 13.663, 20.611)),
    (845589, (7.009, 16.454, 25.000)),
    (277811, (0.171, 10.314, 23.814)),
    (755454, (1.661, 11.525, 24.311)),
    (74349, (8.438, 13.113, 22.604)),
    (235191, (3.745, 10.647, 29.767)),
    (405301, (1.799, 10.041, 23.293)),
    (996277, (1.612, 15.190, 25.809)),
    (303005, (7.988, 19.672, 29.191)),
    (389542, (9.285, 12.507, 24.315)),
    (382838, (4.515, 13.265, 25.824)),
    (858681, (1.026, 15.927, 21.140)),
    (233466, (2.590, 13.482, 21.317)),
    (206578, (4.702, 16.891, 26.778)),
    (178060, (7.283, 13.334, 23.704)),
    (160030, (1.484, 10.410, 26.520)),
    (916416, (6.695, 14.130, 20.376)),
    (76925, (6.707, 12.564, 24.706)),
    (921060, (6.243, 19.664, 29.632)),
    (129390, (9.564, 11.411, 20.739)),
    (149538, (8.299, 11.149, 23.973)),
    (262445, (6.207, 14.981, 22.244)),
    (332558, (1.219, 19.231, 22.244)),
    (297106, (8.843, 11.219, 27.413)),
    (510463, (2.380, 13.053, 23.211)),
    (769939, (2.663, 16.254, 27.976)),
    (799262, (0.350, 11.457, 29.511)),
    (116715, (6.683, 16.639, 26.917)),
    (983327, (7.973, 12.629, 21.267)),
    (97153, (3.201, 13.354, 23.077)),
    (171389, (4.026, 13.665, 20.620)),
    (822677, (6.988, 15.682, 25.992)),
    (142444, (0.113, 18.473, 27.682)),
    (553844, (8.506, 12.360, 25.987)),
    (716994, (8.336, 15.642, 22.376)),
    (7010, (5.954, 15.681, 23.988)),
    (523660, (0.860, 11.291, 25.274)),
    (274097, (4.784, 16.481, 26.474)),
    (698136, (8.801, 15.394, 24.058)),
    (386870, (7.989, 11.352, 27.511)),
    (381244, (7.150, 15.523, 29.441)),
    (60904, (4.896, 11.001, 22.453)),
    (905051, (2.218, 12.275, 29.798)),
    (5462, (5.210, 12.486, 21.858)),
    (694471, (4.743, 13.341, 21.517)),
    (326795, (2.694, 12.264, 24.567)),
    (90025, (5.340, 10.539, 29.445)),
    (824052, (7.511, 14.609, 26.508)),
    (218313, (7.994, 14.877, 28.392)),
    (153118, (9.614, 18.352, 22.589)),
    (322128, (4.056, 19.896, 28.776)),
    (635534, (4.869, 10.702, 20.170)),
    (362125, (6.451, 12.454, 24.345)),
    (596608, (7.732, 10.620, 29.864)),
    (223817, (5.579, 18.939, 27.021)),
    (94571, (2.082, 16.706, 26.585)),
    (704382, (5.065, 16.430, 26.542)),
    (767183, (9.830, 17.994, 29.989)),
    (278983, (7.728, 10.682, 21.141)),
    (106997, (3.516, 18.202, 20.410)),
    (109481, (1.440, 13.653, 27.470)),
    (976814, (7.385, 18.279, 28.207)),
    (167177, (7.578, 19.887, 29.333)),
    (239411, (1.941, 16.125, 23.341)),
    (122400, (3.133, 11.471, 22.425)),
    (525342, (2.010, 10.160, 25.941)),
    (74554, (5.948, 14.656, 23.684)),
    (338028, (8.576, 17.977, 25.368)),
    (432604, (4.251, 10.169, 23.868)),
    (74787, (5.573, 10.929, 20.595)),
    (976722, (5.265, 15.832, 21.141)),
    (437478, (2.397, 14.037, 28.748)),
    (177702, (2.704, 18.718, 21.420)),
    (652568, (1.087, 18.258, 29.874)),
    (873512, (2.219, 15.328, 21.308)),
    (313271, (1.020, 11.759, 29.504)),
    (300152, (2.420, 13.992, 26.400)),
    (892781, (4.518, 13.116, 22.665)),
    (88122, (2.501, 16.712, 26.324)),
    (92924, (0.815, 17.174, 22.291)),
    (790386, (9.139, 10.479, 21.982)),
    (445626, (2.870, 10.213, 21.484)),
    (244827, (3.490, 16.127, 22.665)),
    (107146, (5.482, 18.584, 23.971)),
    (666769, (1.260, 10.792, 26.001)),
    (936129, (3.433, 16.143, 21.935)),
    (1440, (8.244, 14.599, 28.703)),
    (248742, (7.062, 15.690, 22.342)),
    (360426, (6.317, 10.597, 22.485)),
    (839356, (7.393, 18.860, 29.504)),
    (383171, (1.248, 16.865, 23.183)),
    (984896, (2.292, 14.133, 27.702)),
    (641643, (5.227, 18.187, 24.503)),
    (288675, (1.015, 14.389, 22.004)),
    (116960, (0.160, 19.628, 23.312)),
    (761803, (4.805, 18.482, 22.135)),
    (56215, (1.813, 19.460, 20.642)),
    (339762, (3.122, 15.704, 27.983)),
    (681700, (9.673, 11.487, 29.882)),
    (607088, (7.236, 13.753, 22.568)),
    (167905, (9.100, 14.199, 22.276)),
    (49194, (3.733, 19.130, 23.432)),
    (194972, (1.279, 10.315, 27.311)),
    (186473, (9.939, 19.371, 27.774)),
    (468534, (1.687, 11.418, 21.203)),
    (855406, (5.443, 10.013, 22.377)),
    (178907, (7.572, 18.137, 25.865)),
    (155036, (0.401, 14.735, 23.284)),
    (819089, (8.397, 17.687, 27.872)),
    (759559, (5.228, 14.332, 28.842)),
    (878994, (5.060, 15.732, 20.743)),
    (265877, (2.959, 10.723, 21.464)),
    (255565, (3.334, 10.127, 27.045)),
    (140991, (5.316, 10.116, 25.161)),
    (269421, (9.710, 14.866, 22.224)),
    (784833, (1.186, 12.317, 20.274)),
    (687699, (6.349, 19.242, 25.063)),
    (160178, (4.813, 11.840, 29.876)),
    (636007, (7.906, 18.482, 22.467)),
    (817034, (2.506, 15.200, 29.309)),
    (637317, (8.254, 15.549, 25.166)),
    (319152, (6.999, 19.143, 26.078)),
    (504166, (7.020, 10.389, 26.794)),
    (429127, (5.173, 19.056, 21.043)),
    (138520, (6.945, 18.895, 27.959)),
    (927318, (2.001, 10.635, 25.197)),
    (218093, (8.072, 13.108, 22.039)),
    (412424, (5.301, 12.255, 23.468)),
    (787778, (0.963, 16.318, 25.272)),
    (898257, (9.594, 11.921, 22.421)),
    (768148, (1.771, 18.172, 22.454)),
    (117221, (6.828, 13.442, 21.104)),
    (61893, (6.582, 18.840, 25.189)),
    (290270, (0.164, 16.227, 26.078)),
    (139793, (6.763, 18.585, 21.801)),
    (53716, (2.769, 16.949, 27.138)),
    (550935, (1.482, 14.694, 20.327)),
    (265041, (8.000, 12.019, 29.554)),
    (218626, (3.140, 19.250, 28.234)),
    (250917, (5.382, 15.476, 29.331)),
    (669139, (7.296, 12.483, 24.094)),
    (713723, (2.730, 17.318, 22.167)),
    (67507, (5.968, 19.210, 29.116)),
    (385855, (3.775, 10.088, 26.532)),
    (862773, (8.787, 13.266, 22.780)),
    (235725, (6.348, 16.902, 28.118)),
    (779150, (5.775, 19.082, 26.125)),
    (97706, (1.285, 16.494, 25.095)),
    (385381, (2.740, 13.005, 25.484)),
    (181941, (0.773, 14.673, 20.140)),
    (107721, (5.434, 14.124, 29.263)),
    (570525, (3.903, 11.672, 20.416)),
    (460487, (1.135, 14.673, 27.669)),
    (262487, (1.793, 10.532, 28.599)),
    (953602, (7.572, 11.371, 26.794)),
    (790638, (3.690, 19.501, 24.325)),
    (506930, (2.068, 13.356, 20.366)),
    (218757, (7.196, 18.285, 25.797)),
    (852464, (4.808, 10.853, 25.763)),
    (945166, (1.726, 14.792, 25.109)),
    (462021, (4.265, 10.655, 28.146)),
    (406296, (1.862, 15.064, 21.100)),
    (373560, (2.147, 19.696, 26.726)),
    (276399, (6.367, 18.134, 22.814)),
    (759642, (2.207, 18.665, 26.550)),
    (132948, (1.397, 17.826, 21.718)),
    (164511, (6.059, 12.749, 20.502)),
    (310838, (5.389, 16.422, 24.184)),
    (852577, (1.590, 14.882, 24.992)),
    (289531, (3.522, 18.637, 29.570)),
    (449147, (7.181, 19.585, 27.328)),
    (707380, (6.009, 13.212, 29.104)),
    (168169, (2.984, 16.853, 20.959)),
    (999721, (7.506, 15.741, 29.749)),
    (317936, (6.602, 14.937, 27.130)),
    (937570, (0.356, 19.583, 22.644)),
    (277943, (9.865, 12.960, 21.504)),
    (1815, (3.509, 15.688, 25.426)),
    (715178, (2.995, 12.792, 28.152)),
    (664803, (7.174, 12.763, 27.409)),
    (585260, (9.341, 16.260, 29.525)),
    (362178, (9.167, 11.794, 20.073)),
    (981478, (8.058, 13.559, 28.163)),
    (527484, (6.933, 16.127, 23.594)),
    (798868, (6.800, 18.286, 22.300)),
    (617238, (1.268, 12.556, 26.659)),
    (328271, (3.358, 17.500, 25.326)),
    (158722, (9.540, 18.228, 29.391)),
    (87145, (8.966, 15.853, 26.599)),
    (768063, (2.914, 18.667, 26.210)),
    (74691, (2.944, 14.259, 23.771)),
    (172062, (7.905, 13.342, 27.221)),
    (993459, (3.137, 13.340, 24.073)),
    (41889, (6.062, 19.504, 22.658)),
    (458192, (2.503, 18.178, 29.802)),
    (566574, (2.818, 16.741, 25.924)),
    (37966, (0.478, 16.963, 23.736)),
    (492057, (2.595, 15.862, 21.020)),
    (547563, (5.827, 16.471, 23.669)),
    (904216, (8.384, 16.662, 29.687)),
    (301851, (7.193, 12.480, 23.317)),
    (515031, (4.522, 14.992, 23.552)),
    (978855, (5.271, 10.583, 23.963)),
    (324605, (4.851, 16.220, 20.689)),
    (102395, (8.647, 16.091, 27.693)),
    (521436, (9.020, 13.369, 27.022)),
    (317318, (2.389, 19.241, 26.950)),
    (260075, (6.215, 18.309, 20.506)),
    (600744, (0.114, 12.585, 29.347)),
    (518379, (7.626, 11.199, 21.653)),
    (925535, (1.724, 18.573, 24.995)),
    (68945, (1.480, 10.701, 28.529)),
    (504015, (4.924, 16.870, 26.086)),
    (515700, (8.567, 17.442, 26.022)),
    (838942, (8.443, 19.576, 24.243)),
    (813111, (7.814, 17.134, 27.698)),
    (628271, (1.200, 17.626, 21.401)),
    (874285, (9.074, 13.684, 25.055)),
    (55699, (5.749, 10.630, 24.009)),
    (198481, (2.067, 17.511, 29.375)),
    (255366, (5.652, 14.290, 29.786)),
    (322896, (8.823, 17.116, 28.669)),
    (786002, (4.215, 16.915, 20.467)),
    (307831, (4.282, 19.994, 26.182)),
    (616329, (5.846, 10.171, 29.712)),
    (658666, (1.678, 14.667, 25.436)),
    (760172, (0.117, 11.077, 27.302)),
    (567524, (3.444, 13.105, 24.711)),
    (437511, (0.602, 16.562, 23.976)),
    (241250, (4.730, 10.605, 26.318)),
    (925926, (7.392, 16.847, 23.375)),
    (921024, (4.633, 16.803, 27.725)),
    (563835, (0.910, 11.073, 23.392)),
    (642371, (0.908, 17.318, 29.578)),
    (428614, (6.254, 11.461, 20.824)),
    (232987, (9.940, 11.291, 27.298)),
    (909232, (9.647, 19.360, 24.975)),
    (111386, (4.620, 15.279, 21.148)),
    (841355, (0.977, 15.324, 23.294)),
    (61252, (5.149, 17.563, 22.485)),
    (716330, (6.505, 12.563, 29.058)),
    (833137, (1.437, 16.889, 25.262)),
    (976586, (5.098, 11.954, 29.618)),
    (826315, (2.840, 17.624, 20.721)),
    (363638, (0.501, 19.199, 26.348)),
    (99618, (2.395, 19.166, 29.677)),
    (147101, (2.317, 13.645, 21.402)),
    (768742, (7.130, 10.040, 23.064)),
    (562916, (9.761, 18.630, 29.667)),
    (336762, (5.033, 13.676, 20.250)),
    (602839, (5.550, 19.324, 23.848)),
    (29906, (4.193, 10.864, 26.775)),
    (2128, (6.547, 15.173, 27.153)),
    (837068, (9.094, 16.749, 26.192)),
    (4166, (2.488, 15.393, 25.638)),
    (737145, (8.077, 11.304, 27.483)),
    (633297, (5.843, 17.676, 23.886)),
    (792979, (4.962, 11.088, 24.221)),
    (866334, (6.438, 12.320, 21.818)),
    (769625, (9.557, 14.805, 23.330)),
    (833004, (1.844, 11.920, 28.065)),
    (874612, (6.621, 10.900, 23.100)),
    (364613, (5.396, 16.993, 20.410)),
    (671995, (6.361, 12.562, 24.922)),
    (989577, (7.596, 12.895, 27.443)),
    (484251, (8.536, 14.190, 23.640)),
    (826175, (6.102, 12.092, 25.159)),
    (59669, (6.848, 13.577, 24.925)),
    (224406, (2.693, 18.163, 25.421)),
    (43898, (9.583, 15.432, 25.866)),
    (673993, (5.965, 19.808, 25.360)),
    (259610, (9.558, 11.034, 26.857)),
    (380466, (6.212, 15.276, 28.006)),
    (271869, (6.431, 19.638, 26.896)),
    (458058, (9.683, 17.388, 21.125)),
    (161364, (2.391, 10.931, 29.592)),
    (226527, (8.562, 16.039, 20.548)),
    (481786, (2.887, 11.648, 24.414)),
    (956514, (3.139, 19.017, 27.177)),
    (436217, (5.553, 15.788, 20.123)),
    (293273, (9.052, 16.297, 29.453)),
    (499736, (3.353, 14.111, 25.204)),
    (327766, (1.259, 11.994, 24.532)),
    (159309, (3.599, 15.094, 28.078)),
    (596301, (3.106, 16.067, 20.621)),
    (227303, (7.826, 14.638, 20.494)),
    (50402, (2.984, 17.859, 20.912)),
    (849920, (2.607, 18.335, 23.008)),
    (403590, (3.176, 17.042, 20.223)),
    (698408, (7.125, 15.223, 25.226)),
    (732755, (4.734, 12.328, 28.005)),
    (354466, (9.907, 16.165, 28.768)),
    (762173, (7.621, 14.945, 24.176)),
    (323207, (2.531, 11.947, 24.474)),
    (326399, (8.047, 13.925, 26.238)),
    (352098, (5.761, 11.945, 29.719)),
    (883010, (3.579, 13.248, 24.387)),
    (104483, (0.148, 11.518, 21.235)),
    (542818, (7.683, 13.420, 23.108)),
    (297521, (5.574, 15.025, 27.555)),
    (719798, (2.073, 18.768, 23.073)),
    (822724, (3.588, 19.144, 27.019)),
    (169873, (8.340, 10.640, 23.548)),
    (866934, (6.478, 13.399, 29.751)),
    (167920, (7.159, 10.589, 20.699)),
    (581980, (6.212, 19.250, 20.524)),
    (931222, (5.882, 14.565, 24.159)),
    (420551, (7.867, 13.675, 25.081)),
    (286562, (2.893, 16.180, 23.354)),
    (150476, (6.198, 18.169, 22.837)),
    (304451, (3.699, 17.525, 21.579)),
    (848912, (5.360, 16.150, 26.554)),
    (722967, (2.368, 11.412, 26.953)),
    (861104, (4.886, 10.347, 22.615)),
    (576391, (8.276, 11.320, 28.791)),
    (785545, (1.077, 19.253, 27.030)),
    (540243, (1.774, 12.968, 26.142)),
    (634035, (2.593, 18.725, 23.205)),
    (986737, (6.966, 12.877, 20.365)),
    (149059, (1.393, 15.786, 26.322)),
    (490676, (9.060, 16.398, 23.526)),
    (226916, (5.511, 11.048, 29.040)),
    (328125, (8.895, 15.429, 25.285)),
    (152369, (2.287, 17.493, 20.470)),
    (31391, (7.325, 16.152, 29.157)),
    (520315, (5.313, 19.744, 23.943)),
    (869079, (3.561, 16.074, 22.154)),
    (86015, (4.115, 11.149, 23.408)),
    (530150, (3.633, 19.332, 27.344)),
    (412801, (2.527, 17.299, 23.398)),
    (570273, (9.496, 15.515, 25.707)),
    (426141, (6.466, 15.091, 23.881)),
    (533278, (2.723, 10.492, 21.874)),
    (917250, (7.758, 18.938, 29.194)),
    (680390, (3.436, 16.673, 29.576)),
    (48190, (7.800, 12.283, 29.718)),
    (29002, (1.188, 16.191, 26.432)),
    (714444, (5.603, 10.144, 22.822)),
    (682839, (2.920, 10.548, 21.743)),
    (923659, (9.994, 13.743, 23.372)),
    (947416, (1.073, 18.971, 26.254)),
    (719179, (4.482, 16.647, 29.149)),
    (518108, (0.373, 10.588, 21.088)),
    (873898, (9.590, 17.754, 22.488)),
    (538962, (1.345, 19.343, 27.451)),
    (477883, (4.077, 12.931, 29.212)),
    (652521, (0.767, 11.598, 21.637)),
    (967021, (2.258, 16.030, 22.758)),
    (947591, (4.419, 12.541, 27.001)),
    (989911, (1.361, 10.348, 22.091)),
    (138265, (1.745, 17.872, 23.971)),
    (32293, (0.090, 13.775, 22.902)),
    (200539, (3.373, 13.990, 26.608)),
    (18001, (8.597, 16.356, 20.447)),
    (56486, (5.345, 14.248, 22.595)),
    (478243, (8.879, 18.549, 21.637)),
    (721382, (6.921, 19.094, 25.862)),
    (240646, (2.024, 11.119, 23.119)),
    (20046, (2.826, 10.288, 26.659)),
    (309609, (5.270, 18.145, 21.962)),
    (508651, (2.899, 19.077, 22.174)),
    (174414, (3.306, 18.830, 22.285)),
    (861657, (9.612, 13.322, 22.853)),
    (697532, (8.468, 19.386, 27.738)),
    (293050, (8.509, 15.339, 24.301)),
    (98090, (4.882, 11.857, 28.231)),
    (724744, (6.451, 16.652, 22.036)),
    (716558, (5.132, 19.036, 22.304)),
    (79445, (5.754, 12.682, 24.409)),
    (27518, (2.813, 14.502, 23.804)),
    (828248, (6.678, 18.015, 25.166)),
    (727530, (2.237, 14.691, 29.277)),
    (276983, (9.907, 10.235, 22.998)),
    (718315, (9.227, 18.936, 28.152)),
    (421781, (6.687, 16.034, 28.313)),
    (97988, (5.421, 12.792, 26.911)),
    (148574, (6.517, 14.639, 22.643)),
    (777478, (9.577, 12.045, 26.193)),
    (656362, (7.233, 16.134, 22.049)),
    (954698, (0.445, 10.331, 24.547)),
    (286201, (7.785, 16.916, 28.774)),
    (26894, (1.936, 13.419, 26.641)),
    (675001, (0.989, 11.675, 21.137)),
    (846311, (2.828, 19.311, 24.584)),
    (417408, (5.304, 10.344, 27.706)),
    (547166, (9.160, 17.697, 28.335)),
    (249406, (6.406, 12.290, 27.351)),
    (262891, (2.133, 17.181, 22.434)),
    (434395, (5.706, 19.588, 28.398)),
    (331919, (2.979, 18.522, 24.397)),
    (131341, (5.812, 14.660, 20.464)),
    (973110, (4.097, 16.670, 23.847)),
    (149947, (3.745, 17.770, 27.880)),
    (519107, (3.138, 13.524, 21.261)),
    (885970, (6.755, 13.408, 27.451)),
    (276616, (1.879, 16.094, 22.463)),
    (100811, (3.627, 12.192, 22.918)),
    (710870, (2.201, 19.186, 25.543)),
    (488256, (0.818, 16.550, 29.375)),
    (8183, (1.236, 10.586, 20.660)),
    (108645, (7.800, 13.308, 25.840)),
    (683188, (4.903, 10.779, 23.904)),
    (334909, (2.975, 10.254, 29.537)),
    (338283, (1.371, 18.300, 23.680)),
    (43178, (7.073, 19.270, 21.198)),
    (597630, (3.039, 18.353, 27.722)),
    (334294, (1.093, 12.399, 20.781)),
    (541972, (1.394, 19.922, 29.794)),
    (632642, (9.915, 11.621, 28.444)),
    (212524, (4.752, 19.347, 26.961)),
    (261685, (8.120, 17.022, 29.698)),
    (79792, (1.346, 15.108, 25.585)),
    (413280, (6.216, 12.744, 27.441)),
    (395161, (0.448, 19.188, 26.877)),
    (560698, (7.071, 13.373, 29.984)),
    (700117, (5.582, 12.328, 25.057)),
    (900863, (7.959, 14.826, 26.803)),
    (253412, (1.833, 18.925, 28.095)),
    (266229, (1.610, 16.316, 27.447)),
    (817597, (0.996, 11.260, 29.266)),
    (884573, (6.252, 10.812, 24.004)),
    (253430, (7.950, 12.028, 21.185)),
    (236622, (1.662, 14.283, 25.812)),
    (487427, (4.325, 11.434, 23.744)),
    (665880, (0.848, 19.522, 29.509)),
    (712439, (3.911, 10.060, 26.254)),
    (316244, (2.496, 15.139, 21.039)),
    (153802, (1.406, 12.252, 22.311)),
    (470457, (4.010, 17.872, 26.859)),
    (662416, (6.346, 12.972, 29.756)),
    (897720, (8.954, 14.506, 26.951)),
    (43501, (1.452, 17.725, 26.632)),
    (879254, (3.497, 14.659, 27.055)),
    (753227, (8.166, 16.612, 24.031)),
    (573599, (6.013, 16.099, 21.959)),
    (689875, (4.308, 11.577, 26.097)),
    (700365, (3.978, 13.939, 22.585)),
    (63666, (3.545, 17.696, 24.202)),
    (89314, (6.507, 15.388, 29.518)),
    (694863, (9.071, 15.393, 20.616)),
    (779165, (4.372, 19.480, 29.416)),
    (502642, (6.873, 11.054, 23.738)),
    (100138, (0.797, 19.099, 28.434)),
    (321959, (1.267, 18.085, 20.505)),
    (331533, (0.356, 13.471, 20.508)),
    (951668, (0.499, 17.424, 20.744)),
    (205635, (3.084, 17.133, 24.892)),
    (864424, (7.039, 17.771, 21.140)),
    (847893, (1.914, 12.022, 28.035)),
    (839692, (2.861, 11.714, 20.177)),
    (776735, (5.061, 10.379, 25.132)),
    (166385, (1.709, 10.261, 27.643)),
    (334433, (3.242, 12.096, 24.318)),
    (964489, (0.538, 15.279, 20.893)),
    (892106, (7.152, 12.863, 26.489)),
    (987007, (8.923, 17.411, 22.130)),
    (776951, (9.219, 14.798, 23.041)),
    (968062, (6.731, 11.841, 20.157)),
    (657321, (1.281, 11.956, 27.905)),
    (232846, (8.919, 19.918, 21.834)),
    (18798, (8.889, 14.488, 21.574)),
    (813913, (1.139, 14.762, 20.632)),
    (990522, (7.844, 19.255, 23.322)),
    (806533, (5.455, 10.870, 20.734)),
    (53796, (2.715, 18.056, 21.674)),
    (372855, (8.656, 18.696, 26.456)),
    (585321, (5.711, 14.285, 28.580)),
    (807644, (6.489, 14.572, 26.720)),
    (130077, (4.534, 10.471, 23.053)),
    (762227, (8.470, 14.608, 29.783)),
    (157222, (9.908, 11.878, 29.470)),
    (374935, (5.079, 15.062, 23.048)),
    (4588, (6.711, 19.961, 21.108)),
    (496200, (0.859, 16.665, 29.669)),
    (638232, (7.804, 16.769, 25.474)),
    (156398, (5.509, 10.965, 21.690)),
    (705971, (0.198, 18.640, 29.989)),
    (387839, (0.187, 17.717, 28.292)),
    (259900, (7.346, 16.489, 23.717)),
    (557278, (8.544, 10.528, 24.652)),
    (208831, (2.180, 11.381, 28.183)),
    (126710, (1.690, 16.599, 28.829)),
    (433565, (4.575, 15.980, 28.747)),
    (353939, (3.118, 19.885, 27.423)),
    (353470, (7.807, 13.918, 23.815)),
    (771065, (1.466, 13.247, 28.175)),
    (554011, (4.285, 10.896, 26.057)),
    (2138, (2.236, 15.439, 28.195)),
    (381857, (6.915, 11.737, 24.793)),
    (581853, (0.474, 17.855, 29.767)),
    (786661, (5.984, 13.135, 23.672)),
    (592853, (7.603, 15.702, 23.929)),
    (565226, (9.045, 12.281, 27.548)),
    (237052, (3.202, 15.458, 21.203)),
    (677762, (4.532, 15.436, 24.629)),
    (811894, (2.765, 17.696, 27.993)),
    (494394, (5.508, 14.634, 20.670)),
    (806078, (9.033, 19.227, 28.597)),
    (514720, (7.569, 18.739, 20.698)),
    (978750, (1.190, 18.349, 25.132)),
    (258406, (1.582, 11.929, 25.685)),
    (362437, (0.698, 11.844, 21.498)),
    (268900, (0.312, 13.163, 29.254)),
    (27310, (3.571, 15.953, 21.659)),
    (813132, (0.130, 16.162, 24.630)),
    (680202, (7.274, 15.151, 26.290)),
    (693078, (2.935, 17.315, 23.687)),
    (541694, (7.881, 16.983, 26.897)),
    (209404, (1.016, 10.596, 26.911)),
    (4172, (6.449, 14.234, 29.069)),
    (441234, (3.551, 11.342, 23.919)),
    (164431, (9.106, 12.867, 23.273)),
    (453713, (6.787, 13.283, 23.806)),
    (778541, (0.226, 11.906, 20.362)),
    (410156, (3.712, 11.307, 28.273)),
    (684392, (0.446, 18.490, 22.754)),
    (778578, (9.984, 13.102, 21.269)),
    (314403, (9.200, 18.689, 23.638)),
    (591844, (0.023, 18.046, 22.787)),
    (250051, (1.587, 14.479, 28.718)),
    (828482, (3.509, 10.242, 25.543)),
    (848935, (8.634, 11.713, 25.688)),
    (880208, (6.988, 17.189, 20.471)),
    (163627, (3.107, 11.525, 21.332)),
    (727970, (0.167, 14.449, 26.290)),
    (224717, (0.200, 14.440, 21.010)),
    (626363, (1.803, 15.245, 23.663)),
    (939613, (8.494, 16.599, 28.854)),
    (43023, (5.022, 10.524, 28.426)),
    (758186, (9.404, 18.505, 22.283)),
    (689509, (1.556, 11.048, 20.103)),
    (802204, (5.144, 13.586, 29.069)),
    (489254, (1.898, 14.568, 28.502)),
    (237606, (5.883, 17.395, 28.151)),
    (919526, (2.591, 15.971, 22.246)),
    (920324, (7.514, 11.979, 24.476)),
    (699460, (7.391, 10.236, 23.516)),
    (939184, (2.979, 13.017, 28.198)),
    (560205, (5.489, 11.234, 25.984)),
    (482900, (9.412, 18.718, 25.097)),
    (530882, (9.380, 12.950, 27.685)),
    (170065, (5.625, 18.907, 26.597)),
    (201658, (1.782, 16.045, 27.981)),
    (958839, (2.560, 13.948, 28.993)),
    (136007, (9.166, 13.598, 27.047)),
    (328679, (3.887, 10.532, 27.168)),
    (35726, (6.380, 14.415, 24.494)),
    (256311, (2.107, 15.030, 29.036)),
    (555912, (3.158, 13.319, 23.422)),
    (476203, (0.204, 16.853, 24.189)),
    (474402, (2.191, 12.434, 26.211)),
    (136040, (1.036, 12.208, 22.794)),
    (775905, (7.946, 15.838, 21.912)),
    (469167, (4.151, 17.013, 20.307)),
    (236169, (4.539, 16.573, 28.615)),
    (682588, (9.527, 14.731, 25.485)),
    (663906, (5.902, 13.277, 23.773)),
    (563652, (8.204, 19.543, 22.606)),
    (56619, (8.519, 10.661, 26.841)),
    (421251, (7.654, 16.105, 21.704)),
    (165343, (6.529, 11.689, 25.029)),
    (211282, (9.544, 13.170, 22.766)),
    (794399, (0.276, 10.084, 27.149)),
    (828635, (3.627, 19.784, 28.881)),
    (662955, (9.489, 14.062, 25.699)),
    (17619, (9.390, 12.033, 24.062)),
    (273255, (9.719, 13.643, 25.023)),
    (465981, (1.827, 15.717, 21.425)),
    (438461, (3.919, 17.277, 29.101)),
    (324011, (7.083, 14.557, 20.941)),
    (655271, (1.077, 19.028, 21.041)),
    (586674, (7.095, 19.612, 22.757)),
    (931881, (9.544, 19.107, 24.753)),
    (242213, (9.246, 18.817, 27.451)),
    (209660, (9.026, 15.659, 29.343)),
    (299491, (9.094, 13.833, 25.741)),
    (538954, (5.600, 16.574, 24.531)),
    (123457, (3.931, 14.628, 23.847)),
    (411813, (0.209, 19.135, 25.791)),
    (879735, (5.754, 15.114, 27.129)),
    (113833, (3.187, 14.789, 27.001)),
    (116831, (1.644, 16.217, 24.682)),
    (525750, (1.790, 11.204, 23.863)),
    (950800, (2.029, 10.384, 23.900)),
    (609059, (1.329, 17.596, 22.998)),
    (636894, (9.957, 16.895, 20.246)),
    (715620, (0.903, 18.705, 20.109)),
    (740232, (0.671, 11.231, 21.115)),
    (781773, (6.822, 10.612, 27.647)),
    (964343, (4.179, 17.707, 23.730)),
    (547980, (3.553, 16.848, 26.765)),
    (276986, (3.428, 11.832, 26.681)),
    (771362, (7.248, 17.296, 23.879)),
    (863093, (9.373, 15.859, 20.675)),
    (409613, (4.938, 15.488, 23.854)),
    (632474, (6.736, 12.507, 22.623)),
    (867538, (8.264, 17.612, 22.700)),
    (213303, (2.910, 19.508, 22.461)),
    (961980, (4.121, 11.211, 23.000)),
    (668356, (8.763, 16.814, 29.077)),
    (771559, (5.920, 11.454, 27.568)),
    (39788, (0.686, 12.475, 29.884)),
    (566610, (6.767, 11.415, 24.245)),
    (4401, (4.590, 14.921, 23.767)),
    (475038, (7.522, 16.542, 23.985)),
    (659685, (8.174, 19.950, 21.770)),
    (358966, (7.923, 13.911, 28.894)),
    (406361, (1.742, 18.057, 22.896)),
    (93730, (9.867, 14.713, 25.892)),
    (242888, (3.619, 14.824, 21.603)),
    (390637, (0.881, 11.127, 28.731)),
    (94614, (4.749, 17.810, 29.048)),
    (450510, (8.944, 13.093, 28.940)),
    (25576, (0.358, 17.020, 22.094)),
    (856470, (3.175, 11.194, 25.853)),
    (178844, (5.287, 11.596, 23.874)),
    (761247, (4.803, 11.189, 21.529)),
    (304676, (6.317, 16.271, 23.690)),
    (493191, (0.319, 12.581, 29.048)),
    (121013, (9.535, 15.360, 25.773)),
    (710142, (3.809, 18.322, 28.084)),
    (120648, (9.022, 17.116, 23.804)),
    (451693, (7.480, 18.279, 21.943)),
    (87817, (1.006, 12.071, 24.087)),
    (232834, (2.276, 16.360, 22.563)),
    (846344, (5.390, 10.704, 20.642)),
    (137267, (4.932, 12.178, 22.482)),
    (569906, (7.253, 13.822, 27.679)),
    (316709, (9.035, 15.479, 29.710)),
    (841232, (8.159, 13.110, 21.393)),
    (100012, (4.106, 16.384, 22.782)),
    (877412, (8.685, 13.813, 22.396)),
    (990092, (5.729, 15.196, 20.736)),
    (943403, (2.902, 10.214, 20.181)),
    (466571, (8.478, 19.794, 21.947)),
    (549010, (1.862, 19.603, 22.402)),
    (810097, (1.394, 14.189, 20.656)),
    (493955, (6.587, 11.746, 21.762)),
    (68186, (4.452, 12.241, 26.469)),
    (291750, (7.171, 10.978, 20.976)),
    (163295, (8.289, 13.045, 22.151)),
    (375416, (4.460, 19.314, 26.413)),
    (485346, (9.881, 13.262, 22.257)),
    (301156, (7.266, 13.471, 23.068)),
    (277685, (2.825, 15.359, 24.751)),
    (81456, (7.709, 12.442, 24.888)),
    (114730, (7.990, 14.636, 22.214)),
    (449254, (2.854, 18.406, 25.263)),
    (485590, (3.804, 19.496, 23.297)),
    (900348, (5.736, 18.040, 22.792)),
    (818637, (5.005, 18.759, 28.154)),
    (608134, (2.791, 15.344, 29.594)),
    (125578, (6.415, 19.744, 25.743)),
    (710530, (8.486, 11.437, 24.577)),
    (818333, (8.060, 14.088, 27.995)),
    (892985, (5.770, 14.962, 20.929)),
    (960529, (0.053, 18.377, 26.461)),
    (248133, (5.714, 18.196, 28.092)),
    (696890, (5.613, 12.589, 25.321)),
    (598429, (9.150, 18.925, 22.391)),
    (684955, (8.075, 14.755, 20.686)),
    (668348, (4.672, 18.826, 25.078)),
    (450741, (6.029, 15.072, 21.537)),
    (257406, (9.955, 18.056, 28.217)),
    (759885, (8.550, 19.584, 28.826)),
    (519831, (5.505, 11.704, 20.462)),
    (519826, (5.631, 19.955, 22.868)),
    (257778, (5.142, 10.577, 20.784)),
    (342535, (8.851, 11.323, 22.576)),
    (207590, (8.169, 14.383, 23.308)),
    (676947, (2.153, 10.912, 20.560)),
    (625583, (8.541, 17.562, 23.412)),
    (753441, (7.961, 15.292, 29.217)),
    (603630, (6.111, 14.711, 21.585)),
    (742406, (9.872, 19.448, 27.670)),
    (192973, (6.440, 15.393, 27.836)),
    (641161, (3.224, 11.389, 20.463)),
    (713086, (4.497, 18.744, 22.043)),
    (22508, (3.891, 10.036, 21.411)),
    (185209, (3.141, 19.943, 21.747)),
    (439090, (8.869, 17.259, 26.129)),
    (474166, (8.509, 15.817, 25.910)),
    (637991, (2.478, 12.329, 29.656)),
    (81330, (3.676, 16.547, 27.500)),
    (590949, (7.218, 13.731, 24.461)),
    (80352, (2.660, 15.853, 28.529)),
    (252407, (4.226, 19.772, 24.464)),
    (627593, (0.756, 17.755, 22.869)),
    (52322, (8.088, 12.441, 27.172)),
    (380498, (3.176, 19.687, 28.661)),
    (480, (8.647, 13.168, 20.265)),
    (275066, (8.069, 10.866, 24.779)),
    (677998, (7.187, 11.329, 22.298)),
    (167578, (4.926, 17.434, 27.951)),
    (110432, (0.399, 16.088, 26.801)),
    (621896, (2.152, 12.083, 27.229)),
    (817957, (5.586, 17.666, 27.593)),
    (5697, (7.431, 18.237, 26.859)),
    (728479, (7.158, 19.095, 25.380)),
    (216310, (2.693, 19.808, 21.645)),
    (92924, (9.733, 17.642, 28.338)),
    (419009, (2.501, 17.545, 24.712)),
    (856328, (5.207, 13.085, 26.711)),
    (898309, (1.586, 12.575, 20.984)),
    (118962, (0.730, 10.503, 21.914)),
    (391775, (1.432, 10.616, 27.178)),
    (898179, (9.166, 18.841, 25.244)),
    (992568, (1.379, 18.543, 20.654)),
    (788113, (7.036, 17.754, 24.661)),
    (544744, (7.601, 11.506, 25.663)),
    (195015, (2.369, 14.307, 28.024)),
    (444259, (6.362, 13.486, 26.732)),
    (810233, (9.878, 19.539, 21.698)),
    (878744, (9.769, 15.527, 20.072)),
    (469011, (2.838, 11.083, 27.777)),
    (30873, (3.249, 19.870, 26.322)),
    (585053, (9.883, 18.064, 23.628)),
    (111859, (2.686, 16.385, 20.419)),
    (838744, (5.892, 12.699, 23.390)),
    (960177, (1.782, 13.365, 27.223)),
    (943081, (8.900, 12.293, 20.454)),
    (715059, (0.368, 16.220, 26.899)),
    (652628, (0.085, 19.551, 23.498)),
    (595742, (2.885, 17.673, 26.977)),
    (217760, (8.524, 11.880, 29.713)),
    (993409, (3.790, 11.843, 27.576)),
    (537041, (7.865, 15.862, 26.794)),
    (43575, (7.568, 10.661, 23.580)),
    (120921, (5.540, 11.290, 28.972)),
    (492221, (0.661, 10.716, 23.888)),
    (278222, (2.318, 17.866, 28.594)),
    (435602, (8.589, 17.553, 28.528)),
    (602015, (1.404, 13.260, 25.273)),
    (791565, (1.996, 10.450, 27.988)),
    (742156, (0.838, 14.645, 21.169)),
    (397076, (4.203, 10.148, 22.213)),
    (127021, (8.973, 17.262, 25.231)),
    (340990, (9.300, 17.274, 26.841)),
    (455071, (8.844, 16.246, 22.246)),
    (244231, (5.197, 19.710, 21.842)),
    (448992, (2.312, 14.448, 29.587)),
    (677669, (8.415, 17.994, 25.554)),
    (911713, (5.164, 19.914, 21.255)),
    (595518, (3.395, 15.806, 22.003)),
    (797726, (4.113, 17.530, 25.069)),
    (835346, (3.828, 12.822, 27.676)),
    (741291, (9.119, 12.048, 27.989)),
    (630629, (7.917, 16.364, 25.322)),
    (668129, (2.221, 18.564, 24.430)),
    (821879, (1.850, 16.348, 25.564)),
    (770879, (3.922, 16.860, 24.005)),
    (224731, (2.008, 17.992, 22.928)),
    (641517, (0.588, 13.577, 29.947)),
    (571201, (7.427, 18.377, 28.742)),
    (703627, (1.703, 18.175, 23.137)),
    (121646, (8.816, 10.728, 20.740)),
    (995276, (2.767, 12.286, 24.842)),
    (102889, (9.731, 14.663, 25.386)),
    (258759, (0.425, 17.080, 23.271)),
    (937028, (1.264, 10.047, 26.198)),
    (960456, (7.925, 18.923, 26.877)),
    (252871, (9.646, 14.651, 22.397)),
    (833180, (7.850, 11.517, 21.308)),
    (504133, (4.699, 17.957, 24.290)),
    (928894, (4.040, 11.958, 24.553)),
    (436955, (1.819, 11.494, 21.070)),
    (518833, (9.143, 10.653, 29.211)),
    (586539, (2.854, 12.339, 25.885)),
    (543056, (2.350, 16.942, 24.681)),
    (906483, (7.023, 14.904, 20.306)),
    (469211, (9.075, 14.890, 20.219)),
    (104495, (7.217, 13.495, 21.472)),
    (949173, (5.207, 19.449, 20.708)),
    (490054, (6.153, 10.442, 22.741)),
    (191513, (3.653, 12.277, 29.577)),
    (658002, (9.534, 10.540, 23.417)),
    (904206, (8.263, 13.358, 27.096)),
    (466799, (7.270, 13.535, 23.344)),
    (411933, (4.192, 19.998, 25.323)),
    (286397, (7.176, 18.599, 20.235)),
    (562774, (4.977, 13.136, 23.515)),
    (975376, (4.405, 18.791, 27.955)),
    (197041, (0.910, 11.910, 28.685)),
    (251382, (2.017, 10.726, 28.302)),
    (495647, (5.693, 18.155, 26.544)),
    (243132, (1.491, 19.449, 29.194)),
    (56696, (6.121, 18.449, 23.065)),
    (119929, (0.375, 15.002, 26.736)),
    (415184, (5.859, 12.686, 21.247)),
    (529237, (4.308, 11.669, 23.990)),
    (376937, (3.642, 17.115, 21.667)),
    (645110, (5.992, 18.489, 21.442)),
    (64335, (9.125, 11.303, 25.322)),
    (389777, (1.586, 19.377, 22.783)),
    (12133, (3.561, 19.153, 21.533)),
    (316986, (0.582, 13.695, 28.041)),
    (963022, (6.707, 17.665, 23.239)),
    (359432, (8.788, 18.882, 21.749)),
    (990830, (7.480, 16.415, 20.466)),
    (271522, (8.690, 12.564, 29.049)),
    (117649, (2.012, 10.562, 29.138)),
    (942133, (2.443, 16.879, 23.201)),
    (426216, (4.754, 11.952, 21.147)),
    (709138, (3.656, 13.624, 27.110)),
    (662187, (5.786, 12.841, 24.080)),
    (580857, (8.676, 12.595, 28.281)),
    (538531, (9.466, 15.374, 26.173)),
    (493604, (0.785, 13.108, 20.452)),
    (799904, (4.006, 11.757, 26.686)),
    (901155, (4.229, 13.327, 28.944)),
    (718070, (4.354, 10.060, 27.503)),
    (514355, (8.496, 10.342, 29.930)),
    (516991, (0.255, 17.733, 21.708)),
    (187083, (3.566, 13.419, 23.468)),
    (990797, (4.494, 13.353, 21.696)),
    (631534, (8.254, 17.919, 21.248)),
    (837759, (2.278, 15.265, 24.032)),
    (765858, (3.424, 16.637, 22.465)),
    (906063, (0.199, 16.621, 23.475)),
    (204365, (1.962, 17.068, 22.300)),
    (478650, (0.234, 13.542, 24.052)),
    (822207, (3.229, 14.734, 23.500)),
    (672929, (1.686, 13.732, 27.212)),
    (182977, (4.894, 11.184, 29.415)),
    (933430, (0.881, 14.419, 29.029)),
    (940800, (0.914, 16.302, 23.016)),
    (688414, (6.995, 12.476, 22.838)),
    (333228, (4.966, 10.342, 26.523)),
    (708354, (8.364, 14.112, 23.575)),
    (2791, (1.914, 17.728, 22.587)),
    (49090, (2.145, 19.508, 28.850)),
    (774488, (1.120, 15.199, 21.292)),
    (313734, (0.247, 13.542, 28.940)),
    (211736, (9.853, 10.174, 20.444)),
    (160536, (2.176, 11.718, 27.837)),
    (717520, (3.137, 12.510, 22.989)),
    (704748, (1.565, 17.815, 26.524)),
    (309278, (6.205, 12.703, 29.731)),
    (384253, (3.469, 15.865, 25.912)),
    (675593, (0.921, 10.050, 23.448)),
    (508701, (6.991, 12.391, 22.173)),
    (715939, (7.429, 11.294, 29.096)),
    (467685, (3.846, 10.594, 27.366)),
    (645174, (5.427, 15.874, 26.780)),
    (691531, (8.627, 19.179, 26.431)),
    (867219, (4.166, 11.767, 22.369)),
    (546058, (4.270, 14.729, 26.912)),
    (875193, (6.914, 19.529, 29.234)),
    (969511, (3.667, 13.510, 20.280)),
    (540914, (4.620, 12.388, 25.879)),
    (254140, (5.576, 14.936, 28.116)),
    (946323, (9.341, 18.237, 29.774)),
    (884758, (8.606, 18.803, 28.955)),
    (282299, (5.623, 15.873, 24.080)),
    (378444, (5.204, 15.261, 23.156)),
    (851757, (1.658, 19.188, 22.235)),
    (66773, (5.356, 16.796, 26.178)),
    (367652, (8.847, 11.996, 23.288)),
    (610031, (4.437, 10.827, 28.092)),
    (557207, (8.658, 13.449, 25.192)),
    (154313, (5.731, 10.004, 24.075)),
    (32716, (7.278, 13.221, 20.511)),
    (6435, (1.680, 17.942, 27.665)),
    (635804, (8.956, 16.889, 24.106)),
    (784161, (5.301, 11.247, 27.113)),
    (157333, (2.631, 12.154, 28.704)),
    (740970, (8.787, 10.071, 23.125)),
    (829498, (5.098, 18.271, 22.285)),
    (391227, (9.192, 18.816, 29.803)),
    (267865, (3.952, 16.160, 28.815)),
    (948715, (7.488, 13.438, 26.545)),
    (802183, (9.590, 13.755, 20.656)),
    (987685, (0.363, 11.875, 28.565)),
    (342896, (0.982, 19.083, 25.757)),
    (425166, (9.317, 10.040, 22.541)),
    (644139, (5.657, 16.230, 24.749)),
    (196411, (4.488, 15.085, 22.648)),
    (407382, (0.682, 18.126, 21.117)),
    (39439, (9.902, 10.714, 27.166)),
    (794516, (8.028, 16.909, 27.876)),
    (267961, (1.565, 19.736, 29.401)),
    (598369, (3.157, 19.739, 24.447)),
    (251042, (6.813, 17.171, 28.309)),
    (175983, (7.082, 16.826, 27.641)),
    (900763, (0.725, 18.145, 29.523)),
    (702277, (8.773, 11.147, 27.675)),
    (652838, (0.022, 14.062, 27.089)),
    (783680, (3.469, 13.304, 27.647)),
    (502064, (6.647, 12.810, 27.772)),
    (166935, (6.326, 15.773, 23.480)),
    (971248, (8.179, 19.663, 23.207)),
    (99068, (8.433, 14.531, 27.267)),
    (105796, (0.959, 17.221, 23.155)),
    (132692, (6.625, 13.162, 28.704)),
    (355098, (3.787, 12.816, 29.429)),
    (953206, (9.151, 16.465, 28.787)),
    (845095, (7.998, 14.344, 28.984)),
    (334816, (4.265, 14.187, 24.428)),
    (364670, (5.237, 12.166, 26.774)),
    (859925, (3.429, 17.427, 23.050)),
    (363855, (3.380, 10.659, 27.755)),
    (799268, (5.657, 16.028, 23.887)),
    (910088, (8.573, 10.717, 26.795)),
    (452248, (8.705, 13.354, 23.148)),
    (905682, (2.714, 16.718, 24.738)),
    (678618, (8.602, 13.981, 27.819)),
    (791159, (1.625, 12.823, 21.105)),
    (983863, (7.040, 19.607, 22.398)),
    (98649, (9.648, 11.307, 20.019)),
    (944710, (5.856, 14.882, 22.505)),
    (58109, (6.941, 13.926, 20.449)),
    (169769, (2.252, 16.243, 28.449)),
    (948801, (5.731, 14.199, 29.904)),
    (109483, (3.711, 10.165, 22.411)),
    (677414, (4.460, 19.149, 24.876)),
    (641286, (6.848, 13.595, 25.594)),
    (372310, (7.108, 19.229, 26.179)),
    (152512, (1.835, 10.669, 20.305)),
    (517804, (4.174, 15.905, 27.870)),
    (138879, (4.364, 14.527, 22.811)),
    (84248, (9.877, 15.271, 21.331)),
    (292948, (1.921, 18.726, 20.789)),
    (966438, (5.289, 18.487, 25.137)),
    (795559, (9.817, 15.354, 25.306)),
    (402123, (0.582, 13.852, 24.328)),
    (712172, (8.015, 12.119, 21.896)),
    (554459, (7.629, 10.176, 20.726)),
    (169116, (3.304, 15.565, 20.017)),
    (853937, (6.966, 18.888, 29.558)),
    (258640, (6.726, 11.212, 21.482)),
    (495299, (2.004, 10.725, 29.902)),
    (163374, (1.748, 13.785, 26.144)),
    (247166, (8.570, 12.428, 26.312)),
    (87659, (4.474, 12.522, 26.789)),
    (436951, (2.172, 17.878, 27.448)),
    (764168, (7.612, 13.028, 24.313)),
    (683093, (3.076, 19.785, 28.088)),
    (456297, (9.132, 12.355, 25.753)),
    (321222, (7.102, 12.703, 20.506)),
    (221630, (0.692, 13.725, 25.974)),
    (411233, (0.377, 14.918, 23.215)),
    (773869, (4.372, 13.255, 25.354)),
    (773324, (8.165, 12.078, 22.667)),
    (672511, (5.007, 19.295, 28.983)),
    (510986, (2.768, 10.423, 22.720)),
    (240043, (3.080, 17.990, 22.389)),
    (232508, (6.272, 16.536, 29.076)),
    (297648, (8.591, 18.970, 25.904)),
    (39139, (2.626, 19.834, 25.046)),
    (855248, (7.529, 13.529, 28.192)),
    (469946, (3.154, 10.582, 27.851)),
    (284692, (8.015, 12.501, 24.200)),
    (652520, (3.480, 12.556, 21.900)),
    (656585, (0.402, 12.000, 29.401)),
    (633141, (6.309, 17.581, 24.335)),
    (802332, (9.661, 11.500, 28.402)),
    (752741, (0.004, 19.175, 26.295)),
    (426390, (0.973, 17.021, 27.398)),
    (853341, (8.152, 14.797, 27.858)),
    (802996, (5.910, 14.322, 20.814)),
    (493840, (5.115, 18.380, 21.433)),
    (638063, (6.469, 10.108, 21.519)),
    (155100, (3.435, 12.048, 29.157)),
    (944031, (1.748, 15.900, 28.484)),
    (773549, (3.985, 12.745, 20.142)),
    (676852, (2.671, 13.080, 20.002)),
    (973301, (3.691, 17.849, 22.224)),
    (477783, (0.979, 19.587, 23.475)),
    (786171, (3.755, 14.210, 21.735)),
    (468876, (9.078, 19.780, 21.403)),
    (641242, (7.733, 17.537, 27.445)),
    (459083, (2.067, 12.554, 24.085)),
    (222745, (6.976, 17.467, 20.800)),
    (252435, (8.262, 14.360, 22.079)),
    (263879, (6.169, 12.763, 24.018)),
    (797074, (1.285, 15.017, 28.395)),
    (813979, (9.701, 16.610, 23.161)),
    (768258, (5.275, 11.440, 21.011)),
    (809145, (4.604, 12.855, 28.017)),
    (186658, (1.884, 10.022, 21.476)),
    (120903, (5.755, 10.437, 27.578)),
    (502743, (4.729, 14.328, 26.545)),
    (576436, (5.681, 16.156, 28.960)),
    (213115, (4.260, 19.821, 27.199)),
    (689420, (2.654, 17.964, 23.301)),
    (260801, (9.748, 17.582, 21.138)),
    (856528, (7.042, 14.720, 28.348)),
    (990967, (0.312, 17.515, 26.228)),
    (792475, (1.305, 14.990, 24.071)),
    (604970, (7.502, 13.305, 28.631)),
    (441863, (5.086, 14.212, 20.383)),
    (698114, (4.619, 17.317, 27.552)),
    (794044, (9.770, 13.981, 27.404)),
    (454261, (1.788, 15.268, 22.529)),
    (729740, (5.434, 11.575, 24.334)),
    (640087, (3.134, 18.664, 21.077)),
    (475922, (1.291, 10.534, 29.309)),
    (341358, (3.743, 16.292, 28.960)),
    (23633, (7.522, 14.607, 25.388)),
    (639864, (7.457, 10.673, 24.665)),
    (370777, (7.702, 10.995, 20.196)),
    (359276, (0.092, 11.040, 24.690)),
    (604119, (4.136, 13.088, 23.156)),
    (578798, (1.123, 17.088, 21.986)),
    (850568, (2.736, 16.426, 21.858)),
    (164866, (9.628, 12.635, 27.578)),
    (672353, (8.974, 14.176, 25.631)),
    (42157, (8.004, 14.095, 27.745)),
    (671279, (0.621, 11.610, 22.327)),
    (631424, (7.281, 11.753, 24.545)),
    (919963, (3.545, 10.752, 27.680)),
    (403712, (0.919, 14.996, 25.646)),
    (990349, (2.246, 16.478, 24.811)),
    (107341, (4.552, 18.311, 28.584)),
    (772990, (6.019, 11.709, 29.069)),
    (871134, (4.252, 19.074, 24.753)),
    (170135, (4.441, 16.318, 24.810)),
    (305462, (9.399, 13.101, 24.102)),
    (784714, (9.256, 15.294, 26.110)),
    (98675, (7.237, 12.141, 25.631)),
    (438738, (7.989, 14.061, 21.656)),
    (229835, (2.297, 15.250, 25.767)),
    (616488, (4.094, 10.627, 22.606)),
    (387231, (5.561, 14.950, 22.914)),
    (826595, (6.939, 18.654, 22.558)),
    (441240, (3.862, 14.429, 27.520)),
    (987775, (9.675, 13.454, 22.455)),
    (14384, (3.572, 17.943, 20.013)),
    (93285, (3.782, 16.299, 27.252)),
    (607542, (3.010, 14.451, 28.340)),
    (55184, (3.791, 13.642, 20.170)),
    (896087, (1.163, 18.916, 28.839)),
    (77507, (0.432, 11.846, 29.269)),
    (918767, (0.123, 13.309, 29.400)),
    (838163, (1.479, 12.957, 22.060)),
    (676479, (5.775, 13.008, 24.220)),
    (788370, (0.355, 11.357, 27.885)),
    (799339, (1.599, 18.702, 29.244)),
    (968536, (9.599, 15.241, 25.083)),
    (102317, (6.901, 19.247, 22.892)),
    (30400, (1.997, 19.332, 21.699)),
    (165394, (7.756, 18.251, 28.925)),
    (622378, (8.867, 14.211, 21.672)),
    (667773, (2.100, 11.887, 26.948)),
    (506925, (2.479, 19.266, 22.422)),
    (956788, (5.724, 14.173, 21.645)),
    (428232, (5.365, 12.391, 25.509)),
    (138473, (7.181, 18.282, 25.159)),
    (228323, (6.941, 18.430, 20.200)),
    (862153, (1.123, 13.500, 23.460)),
    (308359, (3.427, 15.263, 21.690)),
    (26080, (6.626, 18.436, 23.948)),
    (3702, (0.820, 12.365, 23.041)),
    (633559, (9.358, 18.327, 22.454)),
    (858230, (0.686, 13.235, 28.605)),
    (220421, (0.439, 18.149, 28.664)),
    (646274, (9.061, 12.560, 21.425)),
    (1893, (9.842, 15.421, 20.282)),
    (34401, (5.838, 18.081, 25.001)),
    (388072, (3.995, 10.289, 28.120)),
    (228971, (4.158, 16.571, 21.648)),
    (197416, (6.045, 16.942, 21.442)),
    (270897, (2.926, 18.994, 27.029)),
    (583193, (4.340, 12.814, 24.441)),
    (337587, (3.746, 11.020, 23.403)),
    (31025, (0.339, 18.951, 27.875)),
    (152567, (0.594, 18.983, 22.618)),
    (813172, (2.219, 15.499, 20.566)),
    (367021, (1.024, 10.998, 20.111)),
    (91105, (4.646, 12.038, 20.839)),
    (905154, (6.302, 12.681, 20.145)),
    (870198, (2.492, 15.715, 27.388)),
    (999634, (0.836, 16.317, 29.498)),
    (363131, (9.764, 11.187, 22.525)),
    (127366, (3.210, 15.558, 24.084)),
    (210741, (3.798, 17.105, 23.788)),
    (966949, (0.687, 14.018, 23.354)),
    (153847, (4.848, 17.384, 21.478)),
    (26133, (2.047, 11.530, 28.335)),
    (23218, (4.848, 13.865, 25.883)),
    (901469, (4.835, 17.781, 22.402)),
    (328225, (2.051, 19.997, 22.822)),
    (1863, (6.845, 12.076, 24.101)),
    (36724, (4.226, 14.948, 22.909)),
    (197653, (6.273, 18.494, 21.201)),
    (677036, (8.136, 13.359, 25.870)),
    (546968, (8.575, 15.411, 28.282)),
    (830231, (7.990, 15.203, 20.524)),
    (196596, (8.101, 13.330, 29.716)),
    (122804, (3.782, 19.182, 27.270)),
    (91271, (1.440, 13.797, 21.846)),
    (351792, (8.561, 19.649, 27.839)),
    (984594, (3.932, 14.936, 26.798)),
    (613892, (6.977, 14.522, 26.119)),
    (179143, (8.376, 17.502, 28.189)),
    (730377, (9.590, 12.169, 23.206)),
    (189934, (3.633, 16.631, 25.408)),
    (511084, (7.910, 10.161, 21.890)),
    (623077, (0.464, 13.454, 23.162)),
    (949787, (1.202, 16.703, 29.749)),
    (279794, (7.648, 13.169, 20.745)),
    (700686, (7.589, 17.618, 23.686)),
    (480671, (9.612, 10.030, 20.735)),
    (713535, (5.110, 10.902, 23.493)),
    (433708, (0.132, 17.565, 20.609)),
    (97774, (4.413, 16.174, 23.447)),
    (511830, (6.067, 17.676, 21.713)),
    (740878, (6.757, 17.758, 28.396)),
    (393332, (0.426, 13.984, 29.862)),
    (370678, (8.001, 14.977, 22.725)),
    (483967, (7.915, 16.764, 27.700)),
    (468789, (4.125, 12.739, 26.655)),
    (813615, (7.373, 10.608, 24.075)),
    (123201, (8.008, 18.794, 24.686)),
    (688700, (7.656, 17.567, 20.249)),
    (552422, (0.433, 19.413, 25.970)),
    (610216, (2.653, 11.663, 23.162)),
    (448602, (6.876, 15.870, 23.746)),
    (771928, (9.700, 11.135, 22.012)),
    (123519, (5.600, 17.881, 24.696)),
    (413728, (9.151, 12.310, 21.062)),
    (302929, (8.557, 19.461, 24.188)),
    (68676, (1.495, 18.846, 29.274)),
    (873801, (7.366, 15.122, 25.016)),
    (735505, (7.430, 12.486, 24.633)),
    (566376, (9.562, 12.578, 22.288)),
    (705324, (2.651, 13.916, 22.785)),
    (483270, (2.643, 10.613, 27.744)),
    (534002, (4.404, 12.878, 21.493)),
    (747512, (0.925, 19.554, 23.781)),
    (137296, (4.166, 18.845, 26.802)),
    (274162, (3.560, 13.794, 23.022)),
    (784107, (3.286, 19.986, 21.600)),
    (945704, (2.942, 12.180, 23.440)),
    (383836, (7.974, 16.714, 27.498)),
    (191231, (9.320, 10.917, 21.169)),
    (6360, (0.362, 14.348, 22.890)),
    (448817, (9.643, 10.654, 22.808)),
    (125722, (8.974, 14.532, 20.036)),
    (806782, (4.737, 17.435, 22.983)),
    (400152, (3.789, 16.300, 22.084)),
    (362285, (8.795, 14.364, 22.715)),
    (801945, (2.728, 17.292, 22.633)),
    (755693, (9.987, 10.656, 20.724)),
    (245798, (9.880, 17.347, 24.732)),
    (757631, (8.362, 10.932, 22.586)),
    (950018, (0.711, 14.106, 28.893)),
    (978016, (3.442, 16.144, 24.098)),
    (284272, (7.743, 18.806, 29.133)),
    (864847, (0.789, 11.385, 26.606)),
    (961027, (7.915, 10.359, 26.908)),
    (172071, (9.466, 16.520, 22.781)),
    (844406, (1.408, 13.572, 23.133)),
    (596810, (7.638, 19.996, 21.157)),
    (2844, (7.147, 17.200, 21.116)),
    (964506, (8.293, 14.488, 21.854)),
    (828511, (7.124, 17.441, 21.752)),
    (424919, (7.652, 14.468, 24.182)),
    (637461, (5.994, 13.538, 28.962)),
    (812932, (8.002, 15.321, 28.617)),
    (786191, (9.777, 13.366, 24.818)),
    (554483, (6.098, 15.934, 20.428)),
    (49137, (2.040, 17.614, 23.883)),
    (636957, (1.262, 10.930, 23.554)),
    (43792, (7.291, 16.697, 29.157)),
    (504971, (3.963, 12.133, 20.246)),
    (165522, (2.944, 14.291, 20.934)),
    (496816, (1.968, 19.443, 27.255)),
    (586890, (6.883, 11.748, 21.265)),
    (476067, (4.810, 10.551, 23.949)),
    (304374, (6.060, 10.584, 24.684)),
    (12454, (4.548, 10.527, 27.420)),
    (845867, (8.128, 19.436, 23.114)),
    (637488, (9.812, 19.560, 20.825)),
    (526335, (1.649, 17.616, 20.066)),
    (396943, (6.171, 14.600, 25.710)),
    (932446, (9.649, 18.662, 27.440)),
    (939563, (2.109, 14.559, 25.023)),
    (931320, (7.790, 18.804, 28.887)),
    (290296, (9.643, 13.589, 25.821)),
    (369219, (9.546, 12.991, 29.309)),
    (856119, (5.216, 14.303, 29.147)),
    (103872, (0.488, 14.337, 25.439)),
    (863618, (9.889, 16.304, 25.024)),
    (383085, (8.200, 16.843, 23.674)),
    (865805, (7.853, 10.505, 20.167)),
    (505739, (3.397, 15.045, 26.100)),
    (112436, (5.574, 10.299, 25.293)),
    (953442, (5.483, 11.255, 24.061)),
    (676903, (7.828, 15.429, 22.213)),
    (136630, (0.877, 18.162, 20.593)),
    (316206, (4.417, 11.376, 24.210)),
    (365039, (1.815, 13.000, 29.404)),
    (437328, (2.242, 15.721, 25.455)),
    (462791, (3.901, 10.584, 21.422)),
    (249612, (0.301, 16.554, 24.602)),
    (400062, (1.086, 19.687, 27.672)),
    (617161, (8.632, 19.724, 22.575)),
    (692299, (7.402, 13.822, 21.926)),
    (707226, (0.432, 14.063, 29.962)),
    (348451, (3.033, 15.380, 26.190)),
    (60966, (9.509, 10.738, 21.751)),
    (680671, (8.964, 10.712, 28.268)),
    (7923, (1.980, 10.108, 23.945)),
    (708859, (7.650, 16.797, 28.239)),
    (233084, (0.873, 12.918, 28.211)),
    (330330, (0.184, 12.898, 26.145)),
    (142202, (3.750, 11.442, 26.282)),
    (608144, (3.298, 14.903, 26.949)),
    (284235, (6.010, 13.592, 26.782)),
    (411062, (5.470, 14.011, 21.610)),
    (853051, (9.847, 14.150, 21.518)),
    (293409, (7.017, 16.842, 25.839)),
    (102260, (5.320, 11.520, 26.486)),
    (581755, (5.398, 16.431, 29.589)),
    (671022, (1.059, 13.633, 26.623)),
    (917782, (4.336, 17.414, 28.748)),
    (918819, (8.608, 10.146, 27.065)),
    (545560, (9.117, 18.570, 21.378)),
    (60922, (0.015, 18.027, 24.271)),
    (948670, (2.052, 16.820, 20.414)),
    (839329, (9.611, 12.144, 20.170)),
    (238367, (3.937, 19.217, 24.236)),
    (767258, (6.988, 13.952, 22.615)),
    (372873, (4.197, 13.026, 23.870)),
    (191158, (6.292, 11.892, 25.948)),
    (300110, (1.117, 19.161, 25.735)),
    (708020, (8.832, 14.718, 23.810)),
    (232405, (0.024, 10.244, 26.405)),
    (654434, (8.545, 13.494, 29.178)),
    (801640, (0.191, 15.054, 23.150)),
    (672930, (5.894, 18.341, 27.084)),
    (895537, (9.189, 11.745, 24.840)),
    (136625, (0.729, 12.060, 25.915)),
    (159466, (7.978, 11.236, 20.174)),
    (261919, (1.075, 14.479, 28.736)),
    (463374, (0.459, 14.932, 21.025)),
    (727104, (5.237, 12.711, 24.068)),
    (462190, (7.288, 10.223, 25.856)),
    (406212, (6.979, 18.521, 20.992)),
    (788197, (1.475, 17.680, 28.175)),
    (565858, (8.885, 13.155, 20.755)),
    (678633, (3.726, 15.167, 23.667)),
    (623723, (8.627, 16.148, 27.839)),
    (425619, (6.097, 11.730, 21.569)),
    (77259, (3.692, 18.915, 20.775)),
    (980371, (0.681, 12.254, 24.245)),
    (5300, (6.048, 17.034, 21.964)),
    (316494, (2.405, 18.097, 29.245)),
    (530530, (1.550, 13.878, 24.923)),
    (366869, (2.606, 18.458, 24.769)),
    (142151, (5.662, 17.009, 29.454)),
    (74112, (1.487, 17.131, 21.398)),
    (115302, (3.211, 19.751, 27.670)),
    (586568, (7.484, 16.252, 26.722)),
    (582975, (8.292, 14.432, 22.662)),
    (254859, (7.180, 15.867, 25.906)),
    (730087, (2.781, 17.072, 22.688)),
    (992941, (7.848, 19.369, 21.093)),
    (315491, (5.910, 18.124, 23.904)),
    (916715, (7.268, 19.728, 26.326)),
    (583219, (6.346, 13.406, 23.235)),
    (58728, (0.351, 19.415, 23.799)),
    (283462, (2.307, 15.791, 26.592)),
    (704617, (5.174, 12.226, 23.363)),
    (194740, (2.855, 16.638, 28.853)),
    (634976, (7.292, 17.009, 29.175)),
    (90509, (1.347, 13.713, 21.641)),
    (508614, (4.197, 19.202, 28.723)),
    (677070, (5.044, 13.770, 23.376)),
    (832750, (7.021, 17.644, 27.946)),
    (691905, (8.682, 16.190, 29.131)),
    (505586, (8.601, 16.381, 29.519)),
    (159046, (8.835, 13.320, 22.302)),
    (229768, (6.046, 14.515, 22.040)),
    (981035, (6.801, 18.949, 28.525)),
    (444947, (7.075, 19.914, 23.392)),
    (821483, (4.333, 10.770, 26.496)),
    (892811, (6.192, 16.252, 23.836)),
    (732460, (8.330, 10.468, 27.349)),
    (591765, (0.377, 17.956, 21.929)),
    (760103, (3.592, 14.199, 25.799)),
    (369178, (4.747, 19.504, 26.403)),
    (187458, (6.031, 12.092, 21.261)),
    (355982, (7.049, 14.608, 20.218)),
    (32770, (8.470, 19.513, 29.781)),
    (385405, (5.087, 15.911, 25.531)),
    (411945, (6.027, 10.241, 21.084)),
    (468328, (8.909, 13.667, 24.113)),
    (589699, (3.293, 12.088, 22.168)),
    (308592, (2.798, 10.410, 26.822)),
    (168683, (6.632, 17.552, 23.897)),
    (263480, (3.899, 18.736, 23.089)),
    (195336, (7.364, 15.042, 26.814)),
    (242578, (6.361, 18.406, 26.271)),
    (921505, (5.000, 12.702, 23.980)),
    (346212, (3.267, 15.419, 26.904)),
    (513608, (0.722, 17.981, 25.405)),
    (122101, (2.912, 11.217, 20.256)),
    (881589, (6.712, 19.412, 21.079)),
    (226702, (2.648, 15.328, 25.364)),
    (63684, (4.582, 13.817, 25.586)),
    (481144, (7.151, 11.127, 26.459)),
    (475887, (6.082, 15.598, 22.626)),
    (182101, (1.295, 10.022, 25.664)),
    (167816, (3.986, 10.616, 26.072)),
    (371907, (5.625, 17.046, 26.033)),
    (450771, (9.168, 16.228, 22.332)),
    (55510, (5.265, 19.744, 27.059)),
    (573556, (5.919, 14.699, 28.356)),
    (128951, (7.730, 12.770, 24.238)),
    (365499, (4.530, 14.476, 24.791)),
    (193708, (6.777, 16.950, 24.425)),
    (133708, (1.147, 13.311, 21.540)),
    (2257, (1.599, 13.030, 24.556)),
    (722152, (7.962, 18.007, 29.872)),
    (289425, (9.677, 18.984, 22.916)),
    (346007, (7.914, 11.982, 23.080)),
    (882055, (0.519, 19.710, 23.504)),
    (664078, (8.684, 17.795, 29.689)),
    (444042, (6.389, 15.888, 20.021)),
    (380012, (4.417, 15.120, 27.278)),
    (169388, (8.766, 17.430, 24.137)),
    (662996, (7.962, 10.149, 20.168)),
    (385407, (5.167, 15.320, 28.422)),
    (60765, (5.229, 14.564, 24.339)),
    (497070, (4.404, 18.570, 24.445)),
    (891427, (4.752, 17.654, 24.373)),
    (832466, (7.350, 10.931, 29.632)),
    (580954, (5.533, 17.132, 28.554)),
    (862739, (3.470, 15.585, 25.065)),
    (943175, (9.890, 13.581, 21.736)),
    (308535, (8.527, 13.577, 24.127)),
    (980001, (1.380, 10.471, 20.053)),
    (991346, (5.888, 15.010, 25.001)),
    (567401, (0.467, 13.973, 21.508)),
    (878404, (4.857, 18.364, 25.789)),
    (579498, (3.029, 18.706, 29.176)),
    (314111, (8.801, 12.717, 27.911)),
    (740207, (4.970, 17.365, 25.621)),
    (158808, (8.320, 17.190, 21.691)),
    (395911, (6.878, 11.877, 26.323)),
    (902575, (6.339, 14.703, 22.018)),
    (828929, (6.508, 12.816, 21.279)),
    (825547, (1.483, 17.598, 22.523)),
    (126763, (7.355, 18.400, 28.751)),
    (281588, (8.722, 15.011, 29.090)),
    (972819, (8.446, 15.210, 27.447)),
    (659516, (4.642, 14.416, 24.725)),
    (845461, (9.563, 18.063, 29.155)),
    (262271, (6.787, 12.959, 28.496)),
    (533273, (6.038, 16.265, 26.968)),
    (47653, (3.652, 13.770, 24.839)),
    (978957, (2.277, 19.112, 27.234)),
    (415772, (9.529, 17.652, 20.517)),
    (295088, (0.659, 16.613, 23.311)),
    (681007, (7.295, 17.091, 23.383)),
    (677898, (8.138, 12.710, 20.972)),
    (8410, (4.771, 18.368, 20.692)),
    (22137, (6.195, 18.995, 28.720)),
    (92411, (5.434, 10.287, 24.902)),
    (406552, (6.956, 13.005, 21.029)),
    (301409, (0.329, 16.574, 27.285)),
    (62107, (1.356, 15.395, 25.176)),
    (332606, (2.644, 16.222, 28.920)),
    (25024, (5.197, 18.945, 20.119)),
    (959526, (2.335, 10.710, 27.178)),
    (510680, (5.844, 14.115, 22.169)),
    (71312, (1.519, 17.193, 21.567)),
    (282662, (9.982, 12.232, 27.011)),
    (299078, (0.987, 14.628, 26.171)),
    (551601, (8.365, 10.150, 25.963)),
    (224766, (5.199, 18.508, 28.477)),
    (910895, (8.917, 11.320, 28.542)),
    (923820, (5.208, 12.486, 21.010)),
    (1798, (0.783, 17.581, 29.944)),
    (438249, (2.005, 14.909, 26.407)),
    (711123, (1.907, 10.341, 25.959)),
    (293935, (0.177, 14.106, 28.383)),
    (536898, (8.663, 17.324, 24.965)),
    (361867, (2.544, 10.028, 27.299)),
    (756782, (6.267, 13.224, 27.280)),
    (35563, (9.250, 15.506, 25.277)),
    (22774, (1.387, 17.069, 20.674)),
    (132616, (7.189, 12.961, 24.582)),
    (539689, (0.968, 12.633, 25.470)),
    (129332, (8.676, 14.619, 21.233)),
    (210593, (5.157, 12.021, 23.332)),
    (322640, (8.010, 16.327, 23.516)),
    (10533, (9.426, 14.466, 29.245)),
    (871292, (3.023, 10.949, 20.896)),
    (96520, (1.588, 18.683, 28.133)),
    (243497, (2.967, 18.836, 21.824)),
    (740151, (2.405, 17.361, 26.633)),
    (904876, (4.718, 13.648, 22.858)),
    (429160, (8.947, 18.973, 25.625)),
    (52402, (7.753, 15.372, 28.158)),
    (815689, (9.719, 10.901, 23.424)),
    (509748, (4.096, 13.658, 23.960)),
    (519717, (1.183, 16.662, 25.249)),
    (70784, (3.139, 14.916, 28.653)),
    (939936, (2.447, 13.880, 26.146)),
    (258146, (6.148, 13.217, 24.265)),
    (893869, (2.974, 14.952, 25.912)),
    (568784, (8.302, 17.865, 25.364)),
    (646051, (7.134, 19.655, 25.078)),
    (232450, (6.048, 19.521, 25.784)),
    (40186, (6.082, 17.730, 23.426)),
    (82361, (4.633, 15.091, 24.178)),
    (942767, (1.701, 17.443, 25.050)),
    (726970, (7.429, 14.404, 24.605)),
    (411633, (8.299, 14.974, 28.062)),
    (827936, (9.801, 13.519, 23.337)),
    (741749, (2.121, 16.409, 23.214)),
    (259762, (9.729, 17.151, 20.129)),
    (131278, (5.722, 14.174, 23.488)),
    (137163, (6.232, 14.246, 23.946)),
    (318437, (2.990, 13.512, 25.477)),
    (496671, (5.701, 16.782, 29.563)),
    (113648, (8.494, 14.842, 23.720)),
    (550473, (4.231, 15.205, 27.151)),
    (317152, (1.510, 11.578, 26.527)),
    (279710, (4.540, 19.911, 22.923)),
    (976367, (8.656, 18.024, 20.533)),
    (977806, (9.055, 19.084, 27.412)),
    (391676, (6.057, 11.474, 23.869)),
    (430303, (5.267, 19.106, 24.452)),
    (25162, (4.133, 12.537, 20.070)),
    (190635, (9.415, 11.113, 23.810)),
    (185793, (7.922, 17.768, 21.884)),
    (161518, (8.436, 18.157, 22.349)),
    (982837, (7.474, 10.481, 22.644)),
    (777101, (3.441, 13.244, 24.094)),
    (197378, (6.756, 18.269, 25.140)),
    (440677, (3.678, 16.460, 25.566)),
    (951836, (7.132, 15.800, 26.450)),
    (745672, (7.083, 11.203, 26.089)),
    (915348, (5.629, 13.555, 24.377)),
    (665464, (4.914, 15.846, 21.627)),
    (608725, (6.511, 18.449, 26.307)),
    (143491, (0.410, 16.296, 26.966)),
    (448596, (2.894, 13.701, 23.937)),
    (982532, (2.793, 16.857, 24.701)),
    (737899, (3.461, 13.043, 24.966)),
    (819817, (0.532, 10.948, 21.748)),
    (674740, (4.816, 12.220, 20.183)),
    (554411, (9.494, 13.283, 21.659)),
    (727510, (5.090, 16.295, 24.532)),
    (362302, (3.670, 10.067, 20.416)),
    (156488, (1.147, 14.608, 21.970)),
    (472299, (3.479, 16.690, 28.092)),
    (275801, (8.515, 14.489, 21.058)),
    (219477, (2.676, 14.563, 24.592)),
    (129192, (3.945, 16.196, 23.310)),
    (773169, (9.636, 11.334, 21.452)),
    (910098, (0.827, 13.666, 23.977)),
    (437938, (3.195, 16.088, 22.428)),
    (719212, (2.596, 18.855, 23.564)),
    (645227, (8.322, 16.578, 20.723)),
    (804898, (6.937, 17.450, 23.253)),
    (93002, (5.281, 19.011, 21.286)),
    (695664, (0.098, 15.074, 21.329)),
    (889824, (3.901, 19.700, 20.089)),
    (749158, (7.788, 19.149, 23.110)),
    (595030, (6.884, 18.334, 25.241)),
    (689767, (9.517, 19.251, 24.243)),
    (893046, (7.629, 13.166, 26.953)),
    (928345, (4.862, 18.703, 28.602)),
    (100401, (7.508, 14.797, 29.433)),
    (427371, (5.380, 11.511, 27.092)),
    (523957, (9.583, 18.456, 28.996)),
    (700435, (6.908, 18.875, 24.672)),
    (164964, (6.376, 11.748, 21.749)),
    (150794, (1.627, 16.747, 22.922)),
    (334867, (5.725, 11.864, 28.263)),
    (806810, (1.734, 17.589, 29.398)),
    (905269, (6.039, 11.515, 20.709)),
    (748722, (3.991, 14.177, 21.127)),
    (210319, (5.527, 11.713, 23.366)),
    (734023, (6.788, 11.663, 28.564)),
    (173273, (5.759, 12.132, 29.938)),
    (873714, (5.877, 17.036, 26.240)),
    (984947, (0.198, 11.459, 25.293)),
    (285527, (0.602, 14.425, 27.383)),
    (763826, (8.279, 13.320, 24.818)),
    (519164, (0.343, 17.511, 29.802)),
    (132357, (8.859, 18.003, 22.336)),
    (261372, (5.023, 16.916, 28.025)),
    (424286, (4.440, 13.787, 26.199)),
    (178360, (3.505, 14.457, 23.283)),
    (589993, (0.896, 14.486, 24.098)),
    (712824, (1.563, 15.880, 25.883)),
    (623376, (7.868, 12.746, 26.074)),
    (478697, (1.972, 11.703, 20.905)),
    (486941, (9.849, 11.936, 25.971)),
    (250498, (6.686, 19.543, 28.014)),
    (86900, (8.082, 14.149, 29.862)),
    (633677, (2.394, 19.841, 25.757)),
    (248140, (1.954, 14.161, 22.970)),
    (739282, (4.888, 12.015, 20.381)),
    (128683, (9.717, 15.717, 22.184)),
    (989772, (1.971, 18.931, 21.905)),
    (940062, (5.500, 10.613, 22.923)),
    (851701, (4.913, 17.551, 24.642)),
    (578801, (0.248, 18.037, 23.559)),
    (38639, (7.212, 18.104, 25.537)),
    (963579, (2.467, 12.636, 21.094)),
    (92314, (6.130, 12.139, 29.582)),
    (29081, (5.164, 13.934, 23.244)),
    (208715, (2.545, 12.331, 27.332)),
    (742562, (1.652, 15.839, 25.850)),
    (249164, (2.248, 19.013, 20.067)),
    (475600, (0.184, 18.890, 27.062)),
    (54080, (0.605, 15.620, 29.390)),
    (922735, (7.015, 12.766, 22.323)),
    (445236, (6.644, 16.077, 26.361)),
    (341715, (0.701, 10.659, 21.852)),
    (276525, (3.890, 19.860, 24.885)),
    (351512, (2.925, 12.581, 20.967)),
    (86765, (0.379, 10.007, 25.362)),
    (309963, (0.236, 12.991, 24.867)),
    (351114, (9.501, 18.497, 28.189)),
    (801951, (9.571, 12.849, 22.971)),
    (177912, (9.435, 15.954, 27.665)),
    (37203, (3.185, 11.675, 27.514)),
    (926683, (5.601, 11.308, 25.900)),
    (157559, (3.779, 17.575, 25.604)),
    (124548, (2.491, 15.350, 20.611)),
    (320155, (1.772, 15.737, 21.695)),
    (662850, (5.584, 13.295, 23.366)),
    (242892, (5.039, 13.438, 21.464)),
    (994443, (2.106, 17.408, 27.071)),
    (166361, (9.287, 11.048, 26.284)),
    (549811, (5.063, 18.704, 27.413)),
    (416502, (4.893, 11.219, 20.282)),
    (132971, (3.953, 18.659, 28.913)),
    (361861, (9.025, 16.309, 26.693)),
    (404307, (3.918, 13.914, 27.476)),
    (716936, (0.904, 18.443, 24.967)),
    (392249, (0.300, 18.582, 26.903)),
    (134464, (4.902, 10.675, 29.850)),
    (949057, (0.552, 13.016, 20.446)),
    (754669, (8.251, 10.481, 27.939)),
    (355435, (0.478, 11.846, 24.149)),
    (245128, (8.870, 17.807, 25.104)),
    (281911, (9.216, 13.117, 22.378)),
    (645518, (3.483, 15.013, 28.103)),
    (644612, (5.444, 12.906, 23.389)),
    (94262, (0.455, 19.774, 22.939)),
    (648645, (8.068, 19.075, 21.348)),
    (872489, (6.524, 16.008, 22.013)),
    (837603, (0.290, 12.270, 23.104)),
    (715750, (7.121, 13.712, 22.615)),
    (487614, (1.301, 17.638, 24.273)),
    (750986, (8.306, 15.557, 25.770)),
    (914374, (2.126, 19.577, 23.242)),
    (27684, (2.909, 19.967, 21.738)),
    (967995, (2.783, 11.968, 28.541)),
    (54257, (1.558, 15.212, 22.292)),
    (82271, (5.789, 15.866, 28.111)),
    (460397, (3.657, 12.533, 22.290)),
    (756942, (2.332, 12.706, 27.643)),
    (29686, (7.035, 12.828, 26.645)),
    (962808, (0.528, 13.172, 29.328)),
    (561241, (3.761, 18.089, 22.864)),
    (580610, (0.110, 19.324, 26.118)),
    (983994, (5.547, 13.542, 20.693)),
    (533930, (7.392, 12.903, 25.877)),
    (260468, (9.753, 13.264, 20.923)),
    (688208, (5.793, 12.751, 27.206)),
    (612953, (1.939, 10.345, 27.146)),
    (439245, (4.525, 14.833, 21.300)),
    (160925, (5.493, 14.988, 20.952)),
    (616173, (4.699, 12.423, 20.926)),
    (182301, (3.220, 11.509, 20.385)),
    (408736, (8.302, 12.972, 25.396)),
    (540640, (6.266, 18.990, 28.950)),
    (763095, (1.888, 13.393, 22.979)),
    (755961, (9.374, 19.831, 25.235)),
    (154325, (3.779, 11.956, 28.320)),
    (702916, (5.104, 17.710, 28.980)),
    (740689, (7.337, 14.521, 29.072)),
    (739283, (2.870, 18.592, 26.082)),
    (462107, (2.147, 17.051, 20.232)),
    (499957, (9.468, 15.244, 24.368)),
    (856148, (6.459, 15.623, 20.706)),
    (787450, (9.003, 17.757, 27.500)),
    (830152, (4.051, 15.077, 28.000)),
    (285582, (6.521, 14.741, 27.321)),
    (803002, (7.204, 13.825, 24.572)),
    (450346, (4.229, 17.044, 24.047)),
    (246927, (6.540, 11.505, 28.230)),
    (361210, (7.867, 17.360, 25.903)),
    (994435, (4.514, 14.540, 28.889)),
    (309940, (8.884, 13.345, 26.781)),
    (968869, (9.857, 11.266, 27.810)),
    (453168, (8.328, 15.744, 26.467)),
    (322432, (1.860, 16.699, 28.750)),
    (624599, (1.028, 19.673, 26.244)),
    (318687, (4.099, 17.484, 26.052)),
    (970519, (7.919, 14.858, 26.232)),
    (343301, (6.410, 13.756, 20.208)),
    (759588, (4.967, 15.933, 20.549)),
    (726194, (6.057, 15.441, 21.997)),
    (639157, (0.658, 10.158, 29.744)),
    (468760, (5.711, 16.117, 27.684)),
    (127304, (8.667, 13.069, 27.488)),
    (180948, (1.376, 15.575, 27.712)),
    (491689, (0.559, 14.475, 28.685)),
    (567998, (1.027, 19.549, 24.223)),
    (123244, (3.004, 15.649, 23.769)),
    (523103, (5.886, 11.136, 27.422)),
    (511345, (7.394, 12.809, 25.221)),
    (989597, (3.456, 11.959, 25.528)),
    (465523, (5.910, 16.100, 27.542)),
    (951430, (0.167, 19.181, 24.286)),
    (355708, (6.908, 15.546, 20.861)),
    (460850, (5.062, 14.910, 24.834)),
    (798858, (9.718, 17.440, 29.851)),
    (687932, (2.735, 14.077, 20.602)),
    (590889, (8.629, 10.399, 20.758)),
    (849332, (8.270, 18.540, 21.527)),
    (248343, (2.617, 15.710, 22.845)),
    (736267, (9.297, 11.081, 26.990)),
    (503510, (1.612, 11.490, 23.850)),
    (801589, (2.445, 14.971, 25.036)),
    (880710, (5.525, 11.778, 25.205)),
    (142377, (9.892, 15.283, 26.042)),
    (681907, (5.223, 16.897, 21.196)),
    (162485, (8.138, 12.772, 23.577)),
    (84932, (3.140, 12.955, 22.980)),
    (410421, (2.004, 14.194, 22.569)),
    (760952, (1.268, 11.444, 27.205)),
    (380837, (9.190, 17.715, 23.921)),
    (630631, (0.975, 15.003, 26.307)),
    (576573, (3.812, 15.424, 28.681)),
    (876395, (2.019, 16.345, 25.173)),
    (518181, (5.926, 11.621, 23.323)),
    (946347, (9.237, 13.769, 25.440)),
    (215934, (7.896, 14.558, 29.014)),
    (540700, (5.378, 17.441, 24.567)),
    (250224, (6.486, 16.749, 26.383)),
    (711607, (7.613, 15.083, 29.138)),
    (420629, (4.604, 10.895, 23.788)),
    (511831, (0.000, 15.152, 28.681)),
    (170567, (2.304, 13.102, 22.521)),
    (85472, (9.370, 11.269, 23.502)),
    (82691, (0.597, 15.771, 24.133)),
    (788856, (2.918, 16.050, 26.908)),
    (745556, (2.612, 13.293, 28.658)),
    (67285, (4.251, 11.632, 20.061)),
    (441611, (4.292, 10.442, 22.940)),
    (551964, (0.677, 19.823, 22.862)),
    (384434, (9.721, 11.145, 22.607)),
    (884164, (7.327, 18.150, 27.641)),
    (21202, (9.524, 17.802, 20.069)),
    (986359, (5.738, 18.746, 22.330)),
    (717311, (3.114, 16.531, 26.826)),
    (907878, (4.415, 11.236, 26.842)),
    (541822, (6.067, 11.496, 21.433)),
    (189504, (4.457, 11.939, 22.123)),
    (662919, (0.305, 18.001, 26.795)),
    (262765, (9.522, 14.094, 28.816)),
    (633601, (0.828, 14.800, 22.895)),
    (243727, (2.814, 17.641, 20.342)),
    (27506, (7.210, 13.531, 22.093)),
    (395532, (6.516, 10.425, 20.168)),
    (864528, (8.372, 11.823, 20.927)),
    (929818, (3.798, 18.635, 29.296)),
    (819307, (6.106, 16.908, 28.944)),
    (658884, (6.840, 18.044, 21.837)),
    (313166, (8.506, 10.815, 20.770)),
    (989189, (5.727, 13.167, 29.918)),
    (605313, (1.816, 13.846, 23.027)),
    (463774, (2.716, 16.419, 20.852)),
    (632141, (7.042, 18.852, 25.062)),
    (584679, (5.364, 11.955, 23.824)),
    (833599, (2.720, 16.746, 20.882)),
    (608713, (0.562, 17.800, 22.286)),
    (638606, (8.296, 12.560, 28.154)),
    (180881, (7.540, 15.130, 20.761)),
    (599657, (4.127, 11.333, 24.520)),
    (906252, (1.278, 19.008, 21.129)),
    (117275, (1.927, 17.730, 24.686)),
    (779496, (8.233, 14.328, 21.139)),
    (78522, (5.813, 15.519, 28.426)),
    (94414, (1.071, 13.251, 20.898)),
    (400323, (3.419, 18.756, 20.563)),
    (844890, (3.482, 11.003, 28.345)),
    (466592, (9.995, 12.236, 23.199)),
    (75290, (0.915, 15.240, 26.238)),
    (203979, (6.041, 18.315, 26.201)),
    (571526, (9.056, 17.997, 25.079)),
    (728540, (3.174, 19.571, 25.701)),
    (519907, (7.138, 14.409, 29.770)),
    (215381, (0.818, 16.476, 24.366)),
    (162581, (4.952, 12.295, 24.502)),
    (631964, (3.388, 16.945, 28.892)),
    (923736, (7.280, 18.356, 29.120)),
    (820540, (0.185, 19.427, 29.754)),
    (659809, (6.447, 18.256, 29.950)),
    (439303, (4.150, 19.052, 22.053)),
    (597073, (1.598, 18.040, 25.745)),
    (199972, (2.207, 16.651, 24.134)),
    (998631, (3.123, 17.431, 22.311)),
    (41485, (4.798, 10.471, 21.683)),
    (12993, (6.116, 16.800, 27.620)),
    (490080, (1.255, 13.010, 26.720)),
    (620526, (3.771, 14.101, 21.716)),
    (411034, (7.179, 15.359, 27.765)),
    (246119, (5.116, 10.949, 22.459)),
    (57145, (9.238, 13.423, 20.346)),
    (380720, (8.992, 12.413, 23.223)),
    (441626, (1.098, 10.483, 25.728)),
    (855096, (9.268, 13.804, 29.627)),
    (619622, (1.308, 18.338, 24.524)),
    (140790, (0.914, 12.195, 26.698)),
    (618031, (8.084, 14.181, 22.362)),
    (766890, (2.436, 16.724, 24.219)),
    (976433, (9.702, 18.355, 28.546)),
    (762288, (5.153, 12.067, 21.793)),
    (266895, (0.564, 12.950, 27.213)),
    (790856, (1.803, 11.676, 23.346)),
    (928192, (9.945, 13.311, 22.033)),
    (735207, (7.363, 14.361, 29.565)),
    (324192, (4.035, 10.022, 25.620)),
    (772859, (7.877, 10.501, 24.858)),
    (777265, (5.170, 10.574, 29.340)),
    (456394, (2.256, 18.283, 28.228)),
    (970112, (7.347, 11.420, 29.961)),
    (962225, (7.066, 13.648, 28.524)),
    (628123, (7.680, 10.228, 25.567)),
    (274703, (5.407, 16.653, 21.460)),
    (333305, (8.636, 17.628, 24.246)),
    (202610, (9.622, 16.026, 22.329)),
    (920227, (7.243, 19.656, 23.012)),
    (863278, (5.390, 11.894, 26.765)),
    (572520, (5.827, 13.971, 21.113)),
    (853243, (2.024, 19.712, 23.923)),
    (374966, (7.736, 17.221, 23.676)),
    (698737, (1.446, 16.633, 24.621)),
    (181641, (1.870, 12.713, 27.930)),
    (66650, (0.169, 17.277, 21.852)),
    (956078, (7.177, 19.674, 22.630)),
    (742201, (0.629, 13.120, 20.337)),
    (288937, (8.793, 10.747, 20.467)),
    (704642, (3.094, 18.027, 24.859)),
    (572187, (5.032, 17.420, 29.257)),
    (341663, (6.429, 19.784, 20.887)),
    (707229, (3.900, 16.012, 21.962)),
    (134661, (6.165, 10.227, 22.260)),
    (604606, (9.303, 15.725, 21.003)),
    (456033, (3.400, 16.529, 24.482)),
    (726870, (9.566, 12.739, 27.178)),
    (652220, (0.034, 18.523, 26.328)),
    (159520, (4.332, 17.652, 28.047)),
    (703911, (6.786, 18.183, 25.091)),
    (687786, (1.427, 15.398, 21.690)),
    (256240, (6.638, 13.166, 23.885)),
    (557343, (8.744, 18.803, 28.277)),
    (501819, (1.081, 19.106, 27.255)),
    (365176, (7.209, 15.644, 24.626)),
    (64607, (5.928, 13.270, 21.530)),
    (632116, (6.886, 19.608, 22.786)),
    (812730, (7.295, 14.951, 21.485)),
    (777954, (6.890, 15.110, 21.087)),
    (30401, (9.589, 18.452, 28.556)),
    (45011, (6.090, 19.887, 26.754)),
    (853885, (9.943, 17.100, 25.463)),
    (180826, (0.098, 16.557, 29.296)),
    (423260, (1.017, 17.864, 26.794)),
    (754318, (5.046, 17.357, 24.344)),
    (575926, (2.217, 16.051, 29.418)),
    (33985, (9.356, 12.743, 24.311)),
    (57657, (9.683, 15.160, 21.408)),
    (345128, (2.697, 13.431, 24.359)),
    (837310, (1.229, 10.621, 27.459)),
    (471302, (0.275, 17.347, 28.237)),
    (281600, (7.858, 16.860, 24.737)),
    (87117, (0.533, 13.759, 27.544)),
    (592549, (1.573, 15.677, 26.669)),
    (289884, (7.425, 17.638, 22.885)),
    (219020, (0.764, 19.902, 22.343)),
    (503052, (4.155, 10.933, 23.887)),
    (441370, (9.268, 18.133, 22.612)),
    (157465, (8.613, 13.374, 21.020)),
    (323739, (7.457, 11.696, 23.069)),
    (229166, (6.815, 15.020, 27.493)),
    (411390, (7.332, 10.354, 28.878)),
    (623405, (2.933, 14.451, 25.473)),
    (39010, (7.244, 19.011, 22.925)),
    (575360, (2.940, 18.033, 29.685)),
    (596337, (1.629, 13.879, 24.009)),
    (328619, (7.071, 12.042, 22.474)),
    (933623, (1.832, 17.278, 23.632)),
    (985416, (2.505, 15.749, 20.547)),
    (761185, (7.420, 11.218, 21.791)),
    (376829, (7.294, 15.058, 22.770)),
    (638657, (3.726, 12.526, 21.598)),
    (777547, (9.661, 16.471, 22.149)),
    (702118, (7.865, 12.513, 24.626)),
    (130573, (3.195, 11.902, 21.887)),
    (175834, (2.410, 16.415, 23.544)),
    (758967, (6.303, 18.478, 25.937)),
    (161372, (4.329, 10.619, 25.659)),
    (783287, (5.765, 13.992, 29.827)),
    (67594, (7.769, 13.227, 24.242)),
    (124188, (4.410, 13.775, 21.799)),
    (685198, (1.566, 17.397, 23.056)),
    (238941, (7.173, 13.479, 24.327)),
    (140557, (0.593, 18.125, 22.291)),
    (840999, (3.563, 15.501, 27.319)),
    (470755, (0.627, 14.920, 27.893)),
    (356415, (6.647, 16.271, 25.817)),
    (239500, (4.059, 19.308, 24.554)),
    (79325, (7.470, 13.646, 25.983)),
    (478138, (3.821, 10.272, 27.933)),
    (616762, (1.430, 11.163, 28.661)),
    (842264, (2.808, 10.021, 25.597)),
    (852034, (3.474, 16.868, 20.947)),
    (995899, (8.206, 10.019, 20.989)),
    (37064, (0.367, 11.946, 21.743)),
    (911654, (7.349, 13.867, 21.880)),
    (566933, (5.748, 10.034, 22.618)),
    (641170, (1.070, 16.628, 27.415)),
    (761752, (5.944, 14.282, 23.714)),
    (607016, (8.461, 17.745, 20.181)),
    (609070, (8.829, 11.215, 20.964)),
    (773411, (3.776, 17.693, 21.717)),
    (378420, (3.680, 18.747, 21.312)),
    (836901, (7.909, 19.861, 26.300)),
    (560073, (8.679, 18.969, 27.859)),
    (11465, (0.564, 17.782, 23.866)),
    (610242, (2.647, 10.840, 28.221)),
    (1629, (7.106, 10.588, 28.309)),
    (253408, (2.137, 14.777, 28.077)),
    (440202, (8.672, 15.340, 27.939)),
    (529987, (5.029, 14.121, 25.475)),
    (292647, (2.335, 11.146, 24.140)),
    (164730, (8.932, 10.481, 25.699)),
    (450360, (5.838, 13.400, 27.266)),
    (343509, (1.332, 14.614, 22.355)),
    (327612, (9.823, 11.467, 26.462)),
    (450631, (0.173, 19.275, 21.011)),
    (111228, (7.134, 10.782, 23.139)),
    (142022, (0.199, 18.414, 26.590)),
    (516300, (4.293, 19.240, 25.512)),
    (880051, (0.009, 14.709, 28.626)),
    (614575, (5.257, 19.389, 28.428)),
    (690441, (1.759, 12.052, 25.196)),
    (673561, (8.371, 18.948, 29.679)),
    (78381, (4.318, 16.435, 23.165)),
    (825614, (0.837, 11.154, 24.734)),
    (928117, (0.660, 18.425, 20.896)),
    (653850, (7.165, 18.072, 25.454)),
    (117275, (6.017, 14.842, 27.035)),
    (276398, (4.449, 12.732, 27.868)),
    (415235, (5.631, 17.704, 24.020)),
    (278635, (1.071, 17.715, 21.782)),
    (170509, (3.276, 11.110, 28.265)),
    (621722, (8.217, 17.898, 26.110)),
    (851691, (5.636, 10.382, 26.855)),
    (721220, (4.914, 18.302, 27.724)),
    (335397, (1.264, 14.083, 29.597)),
    (428261, (9.957, 11.950, 23.204)),
    (638483, (4.113, 15.738, 22.750)),
    (567435, (6.349, 14.459, 21.287)),
    (771188, (2.696, 18.477, 22.722)),
    (899766, (0.771, 18.566, 22.386)),
    (795346, (2.480, 15.273, 24.587)),
    (473975, (4.060, 15.595, 21.560)),
    (583277, (2.658, 13.326, 28.181)),
    (616343, (2.035, 13.601, 24.756)),
    (158878, (7.962, 12.280, 28.033)),
    (717930, (2.494, 13.777, 21.781)),
    (341127, (8.398, 11.662, 26.049)),
    (103799, (4.362, 18.935, 22.498)),
    (44478, (1.656, 17.805, 24.965)),
    (259976, (4.052, 14.171, 26.111)),
    (714389, (4.988, 12.281, 25.212)),
    (783765, (5.535, 17.812, 29.202)),
    (378660, (2.380, 10.743, 23.391)),
    (794080, (1.697, 17.979, 26.241)),
    (797691, (0.457, 18.521, 26.077)),
    (824010, (8.095, 11.050, 22.134)),
    (300413, (3.996, 19.045, 22.316)),
    (824575, (1.753, 10.535, 26.310)),
    (390194, (1.806, 16.490, 25.037)),
    (876088, (0.849, 18.227, 28.237)),
    (823832, (1.361, 10.646, 23.570)),
    (93127, (0.322, 10.046, 21.231)),
    (82878, (2.779, 14.751, 29.865)),
    (873088, (8.000, 11.689, 24.172)),
    (646802, (1.022, 17.753, 23.012)),
    (649813, (9.373, 14.668, 29.287)),
    (438950, (2.203, 14.212, 26.160)),
    (335967, (9.832, 15.653, 27.533)),
    (275397, (6.635, 19.190, 23.658)),
    (171025, (0.722, 13.277, 25.894)),
    (887168, (5.963, 15.028, 24.921)),
    (712543, (9.459, 15.648, 29.866)),
    (299374, (4.227, 15.617, 27.643)),
    (546013, (9.187, 13.574, 25.364)),
    (17541, (1.623, 15.861, 29.201)),
    (166485, (2.332, 10.330, 20.252)),
    (854836, (8.105, 16.562, 21.247)),
    (968721, (8.959, 17.679, 26.783)),
    (763201, (9.176, 16.161, 25.099)),
    (917117, (0.652, 12.088, 25.299)),
    (912612, (0.027, 12.103, 21.445)),
    (142323, (6.892, 18.787, 21.164)),
    (563096, (5.854, 14.642, 21.485)),
    (393595, (0.202, 14.123, 20.702)),
    (250294, (1.155, 15.195, 22.272)),
    (487978, (1.236, 12.722, 20.558)),
    (121721, (5.702, 17.755, 25.192)),
    (440800, (3.946, 17.982, 27.266)),
    (962529, (1.954, 14.755, 22.683)),
    (303064, (6.457, 14.030, 27.351)),
    (71231, (9.238, 16.439, 22.389)),
    (310385, (5.394, 18.204, 29.637)),
    (717389, (9.324, 15.893, 21.665)),
    (28023, (1.756, 19.314, 29.720)),
    (120589, (2.998, 17.946, 27.017)),
    (730502, (8.849, 14.952, 22.445)),
    (832926, (9.496, 14.457, 29.258)),
    (883371, (9.614, 12.477, 25.515)),
    (767962, (4.243, 12.351, 25.537)),
    (91302, (7.483, 17.047, 21.931)),
    (704332, (7.193, 12.434, 28.240)),
    (403112, (1.692, 18.321, 22.386)),
    (878513, (2.467, 12.177, 25.557)),
    (195956, (4.516, 13.992, 28.605)),
    (768456, (6.886, 10.084, 23.600)),
    (632088, (8.508, 16.739, 24.725)),
    (520064, (9.812, 10.620, 20.202)),
    (160326, (8.515, 18.089, 20.988)),
    (171125, (5.671, 10.569, 27.438)),
    (428165, (0.049, 18.397, 20.440)),
    (631488, (6.911, 14.551, 23.831)),
    (76126, (2.006, 14.639, 24.538)),
    (718382, (2.793, 15.841, 24.361)),
    (129214, (3.751, 11.268, 20.005)),
    (760335, (2.771, 14.494, 21.460)),
    (149309, (3.461, 19.538, 25.078)),
    (431686, (5.757, 16.402, 29.183)),
    (220136, (1.278, 17.364, 21.435)),
    (500191, (4.035, 13.680, 24.708)),
    (586712, (7.351, 18.232, 22.148)),
    (18822, (7.949, 16.509, 25.812)),
    (599952, (4.935, 17.500, 20.051)),
    (933541, (1.723, 15.572, 27.998)),
    (741134, (1.004, 18.741, 20.770)),
    (673000, (7.471, 16.527, 20.668)),
    (187726, (7.738, 13.355, 28.579)),
    (723144, (1.646, 19.569, 21.108)),
    (314913, (0.876, 16.376, 23.599)),
    (826733, (8.547, 11.150, 25.831)),
    (203467, (4.998, 15.768, 20.716)),
    (673079, (9.520, 19.924, 29.213)),
    (441134, (3.180, 14.241, 25.859)),
    (200324, (5.272, 19.271, 28.134)),
    (288264, (9.205, 12.599, 26.922)),
    (165708, (5.010, 10.245, 24.686)),
    (436973, (4.361, 12.976, 26.102)),
    (835379, (7.814, 11.075, 21.495)),
    (40685, (3.867, 12.410, 28.351)),
    (836912, (2.829, 12.516, 26.847)),
    (894907, (0.347, 18.893, 29.923)),
    (728572, (5.965, 19.027, 21.805)),
    (179946, (5.718, 10.163, 29.021)),
    (33025, (7.881, 17.911, 22.003)),
    (777013, (5.554, 12.429, 29.398)),
    (448609, (7.835, 10.499, 21.406)),
    (475936, (2.880, 15.144, 21.969)),
    (136107, (2.429, 10.609, 20.625)),
    (832398, (2.355, 14.064, 26.698)),
    (514886, (2.370, 17.360, 26.686)),
    (885702, (0.323, 18.878, 22.648)),
    (285410, (1.722, 10.488, 22.781)),
    (207404, (2.156, 11.081, 25.847)),
    (166756, (9.925, 19.797, 23.240)),
    (788819, (7.025, 18.826, 24.890)),
    (412761, (0.639, 13.774, 26.646)),
    (385240, (1.514, 11.953, 22.027)),
    (198736, (6.333, 16.251, 25.088)),
    (384625, (5.911, 15.646, 25.070)),
    (6205, (3.009, 10.468, 24.531)),
    (32351, (5.144, 11.987, 26.630)),
    (832466, (9.035, 15.165, 29.021)),
    (396240, (9.802, 13.458, 28.224)),
    (488967, (0.128, 13.593, 25.858)),
    (705290, (6.412, 10.260, 25.745)),
    (825035, (7.818, 16.322, 28.583)),
    (735775, (6.269, 12.489, 22.447)),
    (542945, (5.224, 10.771, 20.027)),
    (282793, (7.259, 14.435, 24.239)),
    (164960, (8.565, 12.477, 27.201)),
    (860075, (1.883, 15.284, 22.139)),
    (913425, (2.996, 16.097, 27.525)),
    (816587, (3.560, 17.345, 24.149)),
    (189524, (7.201, 17.354, 27.533)),
    (289249, (9.794, 18.576, 29.874)),
    (841569, (6.465, 17.887, 26.780)),
    (821293, (2.626, 11.216, 23.249)),
    (866764, (8.879, 12.548, 20.172)),
    (418141, (1.154, 13.972, 29.690)),
    (185632, (5.386, 15.083, 20.275)),
    (813654, (1.153, 13.494, 25.987)),
    (668287, (0.932, 15.563, 21.388)),
    (491586, (2.280, 18.077, 24.759)),
    (326145, (2.147, 18.835, 23.612)),
    (538038, (6.882, 14.363, 23.729)),
    (451633, (4.205, 13.617, 26.820)),
    (445381, (6.052, 11.996, 22.077)),
    (915357, (9.167, 10.678, 27.107)),
    (801417, (6.929, 16.406, 21.860)),
    (429595, (9.344, 17.566, 23.787)),
    (433473, (5.255, 13.621, 22.325)),
    (197466, (0.372, 10.708, 23.061)),
    (984959, (2.563, 19.785, 20.353)),
    (836524, (6.490, 10.556, 21.675)),
    (920703, (5.219, 10.891, 22.296)),
    (428942, (9.315, 11.737, 24.168)),
    (723228, (2.326, 19.187, 22.635)),
    (44521, (6.358, 14.279, 21.653)),
    (497078, (0.692, 11.380, 24.188)),
    (162940, (5.753, 17.408, 22.130)),
    (670186, (3.613, 15.834, 29.091)),
    (375684, (6.905, 18.904, 28.539)),
    (245619, (2.944, 15.237, 29.783)),
    (179549, (2.410, 19.905, 21.582)),
    (807949, (8.933, 11.636, 28.545)),
    (835973, (4.922, 12.543, 23.499)),
    (162029, (9.897, 11.908, 26.436)),
    (606906, (0.872, 19.353, 20.767)),
    (460066, (3.075, 16.727, 25.609)),
    (769752, (3.816, 17.861, 27.779)),
    (292213, (9.822, 13.925, 26.259)),
    (764118, (0.267, 13.395, 28.540)),
    (352729, (1.436, 19.318, 27.565)),
    (563251, (0.780, 10.047, 24.571)),
    (212838, (6.009, 14.055, 27.593)),
    (524151, (9.562, 10.144, 23.335)),
    (462215, (0.466, 18.409, 24.323)),
    (494105, (6.664, 17.484, 23.943)),
    (156103, (0.312, 14.337, 21.543)),
    (169883, (0.309, 14.659, 24.865)),
    (280438, (4.612, 16.432, 26.651)),
    (554118, (4.296, 14.302, 21.619)),
    (761374, (7.922, 11.949, 26.986)),
    (889407, (1.371, 18.806, 29.018)),
    (271236, (1.065, 19.195, 23.702)),
    (111485, (2.571, 11.247, 29.366)),
    (874254, (2.802, 12.741, 23.974)),
    (635654, (8.131, 13.129, 26.911)),
    (3877, (4.818, 14.844, 25.521)),
    (481768, (4.834, 18.380, 26.175)),
    (389484, (0.505, 17.517, 25.296)),
    (888820, (9.538, 14.625, 22.982)),
    (502289, (5.027, 19.015, 26.210)),
    (280566, (3.523, 15.999, 28.950)),
    (963087, (2.393, 18.443, 26.747)),
    (2145, (5.514, 15.316, 28.940)),
    (940352, (4.781, 16.669, 21.045)),
    (995806, (4.220, 11.088, 22.177)),
    (370442, (5.456, 12.809, 21.826)),
    (59235, (2.919, 11.240, 27.195)),
    (582292, (2.262, 14.335, 21.601)),
    (793034, (4.420, 13.057, 27.017)),
    (965188, (7.539, 13.160, 21.819)),
    (225709, (7.736, 15.684, 28.579)),
    (118883, (7.314, 16.200, 29.325)),
    (520801, (5.859, 18.370, 24.837)),
    (243813, (4.050, 10.215, 27.724)),
    (656795, (3.847, 14.523, 24.009)),
    (499727, (8.236, 14.352, 22.938)),
    (935927, (1.188, 18.857, 23.883)),
    (163157, (1.656, 13.330, 21.766)),
    (758052, (7.261, 10.316, 20.279)),
    (59620, (2.945, 18.110, 24.510)),
    (646898, (6.071, 17.558, 24.926)),
    (338849, (1.559, 13.403, 22.606)),
    (797612, (2.996, 14.065, 28.403)),
    (733919, (9.753, 13.117, 29.293)),
    (169857, (5.104, 12.039, 23.639)),
    (937211, (3.393, 13.881, 26.421)),
    (633145, (2.721, 11.824, 20.170)),
    (13049, (1.262, 17.751, 23.476)),
    (850438, (3.256, 13.726, 25.838)),
    (362549, (3.002, 19.864, 20.710)),
    (887883, (7.207, 15.826, 29.723)),
    (970347, (6.820, 13.136, 26.459)),
    (939615, (9.280, 18.998, 21.458)),
    (337846, (5.057, 15.486, 28.310)),
    (458311, (7.367, 13.812, 28.033)),
    (655834, (9.708, 13.301, 23.883)),
    (605893, (6.358, 19.998, 20.861)),
    (624928, (0.295, 18.015, 24.398)),
    (234217, (1.648, 13.610, 27.639)),
    (346753, (7.937, 19.905, 29.114)),
    (63104, (6.655, 12.275, 22.795)),
    (801433, (9.186, 11.760, 24.544)),
    (177196, (1.371, 12.880, 28.445)),
    (886126, (0.501, 13.228, 29.284)),
    (424029, (3.111, 17.925, 26.367)),
    (792580, (0.923, 14.780, 20.553)),
    (730475, (4.611, 19.809, 27.244)),
    (259656, (0.819, 19.270, 28.962)),
    (645709, (4.531, 19.554, 24.192)),
    (240940, (7.285, 15.097, 22.205)),
    (736155, (0.422, 14.005, 24.638)),
    (342963, (1.175, 19.452, 26.831)),
    (763314, (9.816, 17.707, 20.066)),
    (312549, (7.900, 16.284, 20.589)),
    (767630, (9.138, 17.341, 23.889)),
    (321945, (6.908, 18.743, 24.334)),
    (288094, (0.484, 11.093, 27.094)),
    (272873, (7.478, 19.239, 23.788)),
    (582494, (1.332, 12.554, 22.015)),
    (577754, (4.397, 18.114, 25.406)),
    (438923, (4.949, 12.739, 25.362)),
    (417879, (2.927, 13.983, 29.010)),
    (873492, (0.961, 14.829, 22.435)),
    (91855, (7.778, 14.012, 27.268)),
    (819621, (7.852, 11.932, 20.631)),
    (431454, (4.771, 17.480, 20.833)),
    (519135, (0.167, 13.662, 24.224)),
    (691866, (6.172, 13.986, 24.793)),
    (209230, (5.594, 17.392, 22.730)),
    (227579, (4.939, 15.597, 24.799)),
    (948157, (8.051, 16.285, 23.754)),
    (185476, (4.723, 12.954, 26.177)),
    (564288, (4.309, 12.133, 24.186)),
    (160275, (1.686, 13.770, 29.185)),
    (420851, (4.431, 14.595, 29.844)),
    (358297, (5.196, 18.104, 22.192)),
    (928587, (9.758, 15.160, 23.702)),
    (87913, (2.232, 15.281, 22.794)),
    (661592, (7.325, 14.895, 20.082)),
    (145495, (8.525, 17.736, 21.935)),
    (731960, (1.584, 16.491, 23.501)),
    (373336, (3.910, 12.233, 24.850)),
    (265601, (6.292, 16.159, 23.275)),
    (707192, (3.148, 13.710, 22.742)),
    (78829, (4.258, 19.012, 24.471)),
    (62717, (2.999, 17.186, 26.933)),
    (264230, (4.229, 13.780, 22.059)),
    (757511, (5.521, 13.693, 26.169)),
    (597920, (0.543, 15.572, 26.025)),
    (889614, (6.266, 16.890, 21.946)),
    (44641, (9.837, 15.664, 28.412)),
    (777646, (4.145, 14.562, 24.238)),
    (74019, (3.256, 11.346, 26.402)),
    (636174, (8.714, 17.872, 23.467)),
    (154372, (1.674, 12.634, 29.777)),
    (541475, (8.935, 11.648, 24.673)),
    (210371, (9.577, 17.153, 23.104)),
    (575862, (4.285, 10.240, 26.070)),
    (583193, (0.797, 16.610, 21.495)),
    (584924, (4.164, 19.309, 28.279)),
    (630199, (2.588, 17.389, 27.469)),
    (607580, (1.151, 12.305, 20.164)),
    (737879, (1.586, 16.217, 27.832)),
    (522995, (0.372, 18.577, 24.340)),
    (745230, (8.227, 11.698, 25.726)),
    (315230, (5.939, 14.180, 20.397)),
    (90364, (2.583, 12.226, 24.139)),
    (940597, (8.256, 12.102, 28.781)),
    (577968, (9.136, 14.537, 21.847)),
    (651705, (5.430, 17.089, 25.926)),
    (523324, (0.137, 12.468, 25.700)),
    (642483, (4.378, 16.804, 25.022)),
    (722958, (0.056, 19.062, 23.110)),
    (430763, (3.873, 17.858, 26.762)),
    (293320, (1.871, 15.744, 23.409)),
    (282282, (7.369, 12.708, 21.392)),
    (817196, (3.494, 16.087, 26.528)),
    (373385, (2.407, 19.104, 27.737)),
    (262353, (8.765, 19.130, 25.962)),
    (954934, (3.074, 11.460, 21.596)),
    (436145, (2.309, 13.736, 27.421)),
    (746587, (9.930, 12.319, 27.336)),
    (504789, (6.615, 11.648, 24.240)),
    (434930, (9.116, 15.326, 28.878)),
    (347579, (8.058, 18.912, 28.302)),
    (485633, (4.422, 19.269, 21.596)),
    (671089, (9.634, 18.435, 21.827)),
    (451019, (8.933, 19.098, 23.490)),
    (750691, (0.902, 19.351, 26.838)),
    (140475, (9.950, 15.619, 29.318)),
    (113519, (0.563, 10.528, 24.012)),
    (235805, (6.137, 11.763, 21.438)),
    (951644, (6.925, 15.871, 22.385)),
    (859575, (2.141, 15.221, 27.474)),
    (779076, (1.778, 17.018, 23.750)),
    (921679, (2.505, 15.978, 22.993)),
    (45119, (3.116, 19.176, 22.702)),
    (562429, (9.057, 18.716, 25.158)),
    (611116, (4.642, 17.064, 28.489)),
    (766053, (0.349, 17.671, 24.892)),
    (767755, (0.765, 16.486, 27.108)),
    (499642, (0.778, 14.769, 26.143)),
    (385120, (7.439, 11.469, 24.635)),
    (311007, (2.152, 14.010, 29.659)),
    (141076, (5.946, 13.848, 23.281)),
    (742214, (0.695, 19.638, 29.484)),
    (942745, (8.677, 12.609, 23.019)),
    (284525, (7.480, 14.170, 20.009)),
    (643233, (2.898, 16.029, 20.253)),
    (610423, (9.476, 18.387, 23.204)),
    (53555, (9.451, 18.173, 23.689)),
    (304248, (0.646, 14.581, 20.037)),
    (734390, (2.173, 13.199, 22.356)),
    (521950, (6.150, 11.225, 26.878)),
    (63851, (5.839, 19.480, 26.318)),
    (243000, (9.462, 11.053, 29.975)),
    (620055, (8.508, 12.938, 29.890)),
    (601130, (6.696, 14.731, 21.826)),
    (578780, (2.359, 14.853, 21.723)),
    (239818, (6.838, 14.805, 22.980)),
    (54519, (9.827, 16.709, 24.874)),
    (577728, (5.424, 13.326, 28.974)),
    (989814, (5.854, 10.788, 20.947)),
    (427770, (5.322, 11.012, 29.134)),
    (498892, (5.942, 18.020, 28.553)),
    (381250, (6.318, 13.021, 25.355)),
    (802290, (2.115, 11.690, 23.708)),
    (598334, (0.297, 17.369, 20.923)),
    (939429, (9.706, 17.494, 26.026)),
    (210343, (0.508, 16.015, 29.827)),
    (774172, (2.428, 10.485, 22.985)),
    (220749, (0.772, 11.057, 22.148)),
    (373211, (9.261, 19.687, 26.403)),
    (107570, (1.054, 12.892, 29.508)),
    (644472, (7.619, 19.466, 29.857)),
    (43265, (2.060, 18.078, 28.872)),
    (316905, (8.779, 17.326, 24.379)),
    (757663, (1.636, 16.933, 27.846)),
    (499879, (5.976, 15.013, 20.264)),
    (296510, (1.364, 13.681, 29.016)),
    (18024, (5.174, 15.766, 21.391)),
    (955847, (5.014, 16.588, 29.322)),
    (17033, (4.435, 10.482, 22.897)),
    (649803, (2.064, 19.810, 23.458)),
    (298940, (7.038, 12.274, 21.013)),
    (550021, (6.092, 12.459, 26.804)),
    (922101, (3.150, 13.118, 27.511)),
    (902998, (4.195, 10.676, 29.785)),
    (97000, (1.238, 13.417, 22.783)),
    (276487, (2.474, 12.770, 21.777)),
    (530659, (4.545, 16.374, 23.090)),
    (378560, (9.492, 11.768, 26.239)),
    (797359, (0.540, 16.616, 25.778)),
    (356002, (5.789, 16.572, 24.931)),
    (623218, (2.350, 15.511, 28.630)),
    (115801, (0.473, 11.513, 21.454)),
    (842921, (7.392, 11.056, 24.606)),
    (815926, (0.726, 19.590, 24.209)),
    (6785, (1.403, 18.134, 22.154)),
    (103358, (5.686, 17.035, 25.077)),
    (197606, (9.057, 10.857, 28.162)),
    (214562, (0.145, 17.637, 20.388)),
    (815721, (3.609, 11.069, 25.538)),
    (340196, (0.998, 13.656, 26.401)),
    (676196, (9.343, 11.220, 25.543)),
    (398346, (5.739, 15.975, 28.611)),
    (312155, (3.676, 15.023, 21.000)),
    (181330, (9.923, 19.672, 29.022)),
    (95707, (1.291, 12.999, 22.133)),
    (166464, (8.939, 16.549, 29.204)),
    (95912, (3.904, 12.150, 20.514)),
    (753144, (5.090, 16.921, 24.611)),
    (575673, (5.501, 14.663, 28.113)),
    (536843, (0.784, 18.171, 20.140)),
    (906790, (2.142, 13.308, 26.304)),
    (291950, (4.446, 10.550, 22.431)),
    (531793, (8.777, 13.348, 27.231)),
    (839386, (2.593, 13.897, 25.758)),
    (961939, (6.211, 18.927, 28.522)),
    (988941, (6.449, 12.461, 24.815)),
    (366411, (5.202, 17.603, 26.188)),
    (271043, (6.152, 14.034, 20.542)),
    (588480, (4.004, 10.747, 23.105)),
    (103943, (5.913, 17.178, 24.305)),
    (993193, (5.274, 15.973, 29.856)),
    (685781, (0.186, 19.000, 21.911)),
    (362014, (8.903, 13.722, 20.152)),
    (287540, (3.852, 10.776, 25.493)),
    (249617, (9.077, 12.724, 20.054)),
    (828437, (9.474, 15.596, 24.724)),
    (644390, (6.731, 17.674, 24.411)),
    (100432, (1.258, 16.883, 24.708)),
    (991539, (8.169, 13.479, 20.635)),
    (197566, (9.125, 11.487, 29.526)),
    (702851, (7.296, 10.658, 20.849)),
    (546293, (3.324, 11.312, 24.360)),
    (800026, (2.508, 16.578, 21.338)),
    (957540, (6.245, 17.154, 20.982)),
    (489580, (2.301, 19.931, 24.769)),
    (4042, (9.066, 13.477, 27.176)),
    (772053, (1.999, 16.238, 21.847)),
    (643836, (7.590, 10.014, 23.579)),
    (551349, (7.748, 19.209, 25.902)),
    (385986, (2.082, 13.799, 27.578)),
    (396839, (8.190, 11.691, 23.319)),
    (972889, (7.612, 11.816, 26.294)),
    (293633, (1.614, 15.400, 28.012)),
    (555513, (5.464, 11.237, 21.436)),
    (887316, (2.441, 11.022, 23.752)),
    (814076, (8.845, 18.681, 22.046)),
    (238622, (7.639, 18.765, 28.695)),
    (986798, (4.790, 18.255, 24.270)),
    (240833, (3.804, 11.628, 28.921)),
    (253120, (4.156, 14.696, 28.805)),
    (92220, (9.815, 15.877, 21.237)),
    (606667, (0.488, 10.995, 24.698)),
    (670944, (0.647, 13.804, 20.649)),
    (928557, (1.340, 18.910, 27.746)),
    (379619, (9.784, 13.718, 21.502)),
    (89112, (9.021, 13.381, 24.123)),
    (989261, (7.567, 18.855, 27.889)),
    (634025, (8.746, 15.090, 24.831)),
    (983782, (6.240, 15.159, 20.326)),
    (289438, (0.826, 13.516, 27.680)),
    (811352, (6.009, 14.436, 27.072)),
    (389743, (5.941, 17.607, 22.420)),
    (594326, (0.706, 10.253, 27.692)),
    (413879, (5.314, 11.818, 24.461)),
    (119752, (3.268, 11.845, 25.143)),
    (135050, (6.924, 18.791, 21.071)),
    (86014, (2.277, 13.938, 28.942)),
    (500225, (4.975, 15.318, 21.558)),
    (969415, (1.358, 17.187, 26.531)),
    (693039, (7.313, 12.354, 27.376)),
    (860427, (3.808, 16.900, 23.315)),
    (5809, (1.311, 15.230, 27.140)),
    (71342, (0.313, 18.769, 25.487)),
    (945163, (6.791, 14.139, 26.092)),
    (614174, (0.937, 16.779, 26.768)),
    (468607, (5.671, 10.657, 24.521)),
    (175161, (0.963, 15.123, 24.395)),
    (171882, (5.885, 17.359, 26.993)),
    (775371, (5.694, 16.995, 21.233)),
    (105789, (7.892, 19.920, 22.680)),
    (126300, (2.515, 14.876, 26.496)),
    (401928, (0.165, 12.171, 24.239)),
    (385456, (6.439, 10.963, 20.941)),
    (833081, (4.498, 15.649, 23.177)),
    (761289, (5.628, 18.790, 22.638)),
    (108138, (4.814, 16.541, 26.685)),
    (110338, (7.148, 14.351, 29.867)),
    (855485, (2.654, 15.023, 21.924)),
    (356011, (5.540, 14.725, 27.645)),
    (64595, (1.342, 11.705, 22.721)),
    (334543, (4.007, 19.652, 29.745)),
    (578388, (6.041, 19.879, 22.130)),
    (549652, (5.783, 16.048, 21.377)),
    (152499, (4.137, 11.091, 21.339)),
    (584522, (7.089, 16.989, 20.830)),
    (694471, (8.242, 12.701, 24.047)),
    (642118, (0.735, 15.112, 28.330)),
    (963096, (1.290, 18.261, 22.864)),
    (645525, (9.836, 10.618, 25.276)),
    (128681, (8.963, 15.642, 27.929)),
    (68753, (0.039, 14.144, 27.864)),
    (598821, (6.231, 16.577, 28.398)),
    (935439, (6.680, 11.446, 23.125)),
    (650154, (3.516, 13.958, 22.370)),
    (520122, (4.688, 19.077, 22.753)),
    (75304, (6.694, 12.236, 23.326)),
    (751270, (6.763, 11.345, 25.511)),
    (18213, (6.556, 11.935, 25.145)),
    (903842, (6.726, 15.146, 24.951)),
    (805415, (7.181, 19.376, 29.315)),
    (64887, (4.499, 13.990, 21.879)),
    (231618, (9.728, 16.415, 24.777)),
    (389785, (0.204, 18.551, 23.950)),
    (87655, (5.198, 18.378, 27.069)),
    (353260, (1.236, 13.786, 28.540)),
    (931172, (9.249, 17.936, 28.120)),
    (960573, (3.027, 13.594, 21.913)),
    (196078, (3.813, 10.866, 26.805)),
    (157400, (2.988, 15.451, 23.323)),
    (809205, (5.980, 15.561, 28.722)),
    (912554, (5.336, 14.362, 24.110)),
    (6525, (5.476, 18.278, 25.578)),
    (912651, (9.927, 17.824, 20.368)),
    (408372, (8.215, 13.232, 27.449)),
    (491348, (0.840, 14.107, 25.126)),
    (731916, (2.897, 18.809, 28.515)),
    (26602, (9.792, 11.327, 29.447)),
    (362076, (5.830, 13.249, 27.186)),
    (630095, (2.345, 11.065, 26.701)),
    (507340, (7.619, 11.338, 21.482)),
    (129192, (6.581, 12.942, 27.328)),
    (179645, (7.819, 18.268, 20.672)),
    (400649, (5.155, 10.602, 29.040)),
    (517452, (4.771, 19.810, 26.003)),
    (443281, (8.767, 15.264, 29.950)),
    (954019, (7.662, 16.524, 25.724)),
    (191372, (7.104, 10.210, 23.648)),
    (244515, (4.686, 16.385, 27.180)),
    (973662, (0.591, 12.030, 28.027)),
    (698451, (1.231, 14.379, 22.986)),
    (222109, (3.200, 18.096, 27.657)),
    (17323, (2.808, 18.215, 22.394)),
    (717258, (0.237, 19.790, 28.225)),
    (70255, (7.715, 19.898, 28.420)),
    (17459, (1.176, 16.703, 22.213)),
    (787864, (5.174, 11.389, 26.539)),
    (728417, (1.657, 10.739, 24.739)),
    (40240, (2.668, 16.045, 24.147)),
    (444427, (5.676, 14.482, 26.359)),
    (197900, (8.904, 17.633, 28.117)),
    (104954, (0.837, 16.357, 26.858)),
    (739096, (2.600, 17.877, 20.105)),
    (873067, (4.067, 15.449, 28.753)),
    (427767, (8.300, 17.657, 27.779)),
    (323320, (8.583, 15.555, 29.841)),
    (111753, (2.580, 19.817, 29.943)),
    (173691, (2.557, 13.993, 27.111)),
    (341078, (6.101, 15.283, 22.044)),
    (225111, (9.785, 17.468, 26.625)),
    (678620, (3.515, 16.912, 21.443)),
    (429139, (4.288, 15.812, 28.157)),
    (802200, (3.327, 18.393, 25.182)),
    (749971, (9.020, 14.169, 29.126)),
    (112888, (2.415, 13.904, 24.173)),
    (472893, (6.119, 11.303, 27.150)),
    (434051, (6.111, 11.109, 23.991)),
    (204296, (1.353, 17.983, 26.989)),
    (358131, (2.517, 19.743, 28.569)),
    (738620, (1.807, 10.015, 29.984)),
    (433322, (6.548, 10.644, 27.705)),
    (751758, (9.222, 19.543, 28.098)),
    (633342, (2.963, 10.187, 21.856)),
    (331541, (4.200, 18.725, 29.139)),
    (854557, (4.895, 19.948, 26.902)),
    (9658, (9.735, 11.974, 23.855)),
    (330142, (4.160, 17.739, 28.955)),
    (699856, (7.524, 13.355, 23.502)),
    (690103, (7.143, 12.717, 21.476)),
    (144921, (8.207, 15.571, 26.689)),
    (700222, (2.320, 16.297, 22.406)),
    (273102, (8.641, 12.121, 25.286)),
    (161802, (1.962, 10.240, 27.670)),
    (254497, (7.692, 18.883, 27.637)),
    (537668, (4.904, 14.596, 29.976)),
    (117545, (7.346, 17.394, 29.086)),
    (470017, (5.309, 19.132, 25.997)),
    (646104, (0.735, 11.992, 29.189)),
    (494491, (5.207, 10.450, 28.728)),
    (37501, (7.959, 16.848, 29.988)),
    (483630, (9.270, 13.337, 24.377)),
    (158618, (2.131, 19.144, 22.983)),
    (281651, (5.294, 19.272, 20.872)),
    (504749, (3.364, 19.460, 25.388)),
    (535769, (4.819, 10.983, 28.490)),
    (276304, (2.623, 15.784, 25.825)),
    (968483, (8.214, 14.209, 27.074)),
    (715678, (2.426, 16.796, 23.905)),
    (438204, (6.999, 17.147, 21.123)),
    (263663, (4.805, 18.925, 22.844)),
    (401408, (4.136, 12.158, 20.894)),
    (180666, (7.698, 12.263, 29.433)),
    (233998, (0.585, 11.840, 24.898)),
    (901135, (9.612, 15.074, 25.440)),
    (402579, (8.450, 17.533, 28.529)),
    (209930, (0.356, 15.688, 29.876)),
    (755071, (2.932, 11.784, 21.864)),
    (777433, (8.951, 15.695, 25.006)),
    (272354, (3.603, 11.666, 26.144)),
    (740278, (0.059, 10.702, 20.681)),
    (988448, (9.408, 12.189, 21.373)),
    (833783, (2.131, 14.438, 22.690)),
    (358962, (3.936, 17.199, 28.421)),
    (833523, (3.271, 17.189, 29.427)),
    (545952, (9.752, 11.779, 26.784)),
    (924786, (6.199, 15.852, 24.259)),
    (970871, (0.618, 14.093, 27.038)),
    (54774, (1.064, 11.983, 22.910)),
    (616776, (3.434, 13.819, 22.585)),
    (256363, (4.349, 13.105, 21.569)),
    (215425, (2.005, 16.834, 22.441)),
    (65950, (7.120, 11.921, 22.584)),
    (137427, (6.840, 19.644, 25.520)),
    (972251, (9.639, 17.836, 25.487)),
    (698541, (3.782, 15.063, 22.415)),
    (730987, (1.216, 14.867, 23.659)),
    (55657, (6.807, 18.319, 25.231)),
    (919620, (1.387, 17.038, 26.167)),
    (477702, (2.753, 12.156, 29.119)),
    (745600, (0.271, 12.339, 24.561)),
    (613102, (9.857, 15.239, 27.919)),
    (729347, (3.750, 15.016, 22.739)),
    (163057, (0.326, 17.726, 27.067)),
    (965173, (5.541, 11.483, 26.192)),
    (660145, (4.760, 14.532, 24.690)),
    (594978, (1.319, 12.329, 20.062)),
    (767572, (2.480, 11.298, 22.920)),
    (517008, (6.014, 14.898, 28.477)),
    (766250, (7.805, 14.328, 24.745)),
    (474553, (1.480, 15.490, 29.389)),
    (508654, (0.211, 16.678, 28.132)),
    (917386, (6.872, 18.295, 27.120)),
    (977748, (2.692, 16.131, 28.373)),
    (266938, (3.132, 12.516, 26.160)),
    (691908, (4.478, 10.812, 22.550)),
    (958328, (0.764, 16.726, 20.183)),
    (805458, (3.501, 17.666, 28.787)),
    (400723, (1.907, 10.712, 28.359)),
    (900512, (2.228, 19.734, 24.774)),
    (433506, (8.047, 13.445, 27.145)),
    (549544, (9.440, 17.786, 22.171)),
    (260729, (6.513, 11.354, 26.490)),
    (159064, (0.493, 13.532, 21.627)),
    (342887, (8.846, 12.118, 20.310)),
    (701148, (0.646, 19.288, 23.953)),
    (503672, (7.806, 15.588, 20.641)),
    (554987, (8.043, 14.971, 22.540)),
    (485094, (7.699, 13.640, 25.090)),
    (293583, (6.207, 11.851, 29.343)),
    (983133, (3.746, 15.562, 27.149)),
    (982471, (3.266, 14.507, 29.857)),
    (314920, (6.534, 15.645, 23.154)),
    (570219, (8.463, 12.510, 24.324)),
    (683605, (1.049, 10.594, 26.000)),
    (199656, (9.046, 18.625, 27.506)),
    (857270, (7.674, 13.616, 21.264)),
    (209337, (7.465, 17.496, 29.432)),
    (896890, (1.553, 10.922, 27.666)),
    (845915, (0.195, 11.217, 27.948)),
    (829246, (5.644, 16.106, 22.825)),
    (52941, (1.716, 10.457, 21.947)),
    (206359, (4.760, 19.648, 27.295)),
    (994671, (0.324, 19.544, 26.411)),
    (26041, (8.448, 17.782, 29.876)),
    (506223, (5.182, 16.097, 26.373)),
    (239542, (1.935, 10.399, 29.053)),
    (285571, (9.823, 10.490, 27.921)),
    (639087, (0.991, 11.131, 21.958)),
    (128101, (0.786, 13.185, 22.271)),
    (908333, (2.421, 10.861, 26.251)),
    (993121, (9.401, 15.649, 26.978)),
    (874054, (0.583, 14.405, 24.979)),
    (997676, (4.307, 15.818, 28.557)),
    (890662, (7.705, 11.005, 22.738)),
    (213622, (9.728, 16.776, 20.349)),
    (556529, (4.577, 18.595, 22.536)),
    (871688, (0.220, 14.360, 27.615)),
    (94324, (9.784, 19.672, 28.788)),
    (598601, (4.163, 14.053, 27.442)),
    (960016, (6.677, 12.810, 21.144)),
    (567753, (4.644, 11.917, 28.652)),
    (332727, (3.843, 14.210, 28.948)),
    (794418, (8.019, 11.667, 27.869)),
    (895380, (8.933, 18.318, 21.358)),
    (866407, (8.984, 13.322, 24.904)),
    (796555, (1.099, 18.994, 25.461)),
    (948797, (3.234, 17.126, 25.788)),
    (5431, (6.920, 19.350, 27.196)),
    (354573, (8.452, 17.407, 26.195)),
    (716865, (4.525, 17.573, 23.823)),
    (868051, (9.455, 19.183, 20.055)),
    (835026, (4.214, 16.437, 20.672)),
    (406632, (5.542, 10.024, 22.252)),
    (474949, (0.158, 14.674, 21.454)),
    (297278, (7.233, 13.511, 22.236)),
    (413278, (4.403, 15.008, 20.450)),
    (376674, (2.623, 14.750, 25.421)),
    (166649, (3.457, 16.954, 26.233)),
    (702356, (5.762, 12.554, 21.544)),
    (23077, (5.435, 13.399, 24.448)),
    (224360, (4.387, 14.828, 23.143)),
    (414463, (5.420, 18.218, 28.827)),
    (188907, (9.878, 18.042, 25.833)),
    (486489, (5.492, 12.285, 21.182)),
    (435140, (5.733, 17.859, 29.792)),
    (505925, (4.528, 11.879, 23.464)),
    (917666, (4.054, 14.510, 29.216)),
    (492617, (9.053, 14.469, 21.282)),
    (697796, (9.065, 19.323, 25.665)),
    (55472, (8.763, 10.199, 23.004)),
    (818807, (3.958, 16.899, 25.865)),
    (599152, (1.970, 15.212, 22.705)),
    (744793, (8.394, 12.284, 25.845)),
    (597268, (1.700, 10.947, 26.630)),
    (29332, (0.295, 12.105, 24.354)),
    (509276, (7.886, 18.890, 26.960)),
    (586134, (8.980, 11.554, 23.411)),
    (696220, (4.411, 18.648, 26.290)),
    (924724, (3.273, 16.176, 28.649)),
    (50264, (4.870, 18.217, 20.674)),
    (474599, (8.853, 10.126, 20.774)),
    (427802, (0.944, 17.299, 21.481)),
    (83416, (9.576, 17.944, 24.637)),
    (281521, (1.115, 10.248, 26.062)),
    (592852, (9.245, 19.485, 23.290)),
    (515267, (4.349, 11.736, 23.720)),
    (745827, (9.652, 15.863, 23.893)),
    (912196, (9.694, 15.763, 22.474)),
    (918907, (2.834, 11.984, 21.236)),
    (474190, (8.459, 13.002, 20.488)),
    (635099, (9.027, 10.984, 20.991)),
    (785670, (5.022, 18.072, 24.126)),
    (210267, (5.104, 17.238, 22.864)),
    (954710, (2.715, 12.879, 20.560)),
    (243070, (1.205, 12.782, 24.896)),
    (496038, (0.150, 17.381, 24.092)),
    (650636, (1.238, 19.497, 22.235)),
    (32313, (9.738, 15.998, 27.206)),
    (606347, (4.833, 19.122, 24.857)),
    (979708, (1.389, 13.728, 22.238)),
    (135497, (0.427, 19.753, 28.610)),
    (80612, (8.058, 13.443, 22.502)),
    (438401, (4.452, 17.598, 21.831)),
    (500252, (8.693, 10.942, 28.192)),
    (319113, (6.747, 14.925, 23.949)),
    (501640, (6.880, 17.865, 24.534)),
    (730772, (3.649, 19.903, 27.049)),
    (98250, (2.714, 10.293, 28.740)),
    (5305, (0.508, 16.554, 21.226)),
    (418725, (4.417, 12.694, 23.741)),
    (129094, (8.190, 10.791, 26.415)),
    (962849, (1.933, 15.923, 27.491)),
    (757300, (7.721, 14.158, 29.724)),
    (804423, (5.923, 11.744, 21.318)),
    (908639, (7.846, 15.098, 26.005)),
    (296379, (5.265, 11.428, 29.446)),
    (173202, (5.323, 11.901, 21.681)),
    (160951, (7.345, 19.741, 23.074)),
    (286392, (2.423, 16.852, 24.211)),
    (145852, (1.033, 18.611, 23.417)),
    (523888, (9.571, 14.400, 23.765)),
    (616198, (4.084, 17.998, 20.208)),
    (473420, (5.869, 16.439, 20.696)),
    (235179, (1.358, 17.062, 26.864)),
    (78835, (2.282, 18.874, 26.529)),
    (710887, (4.016, 18.802, 25.790)),
    (847925, (9.653, 15.609, 29.209)),
    (875983, (4.226, 17.938, 28.331)),
    (386285, (3.025, 19.416, 21.250)),
    (62886, (7.224, 15.734, 28.790)),
    (892100, (0.613, 16.620, 23.957)),
    (232387, (4.477, 11.426, 27.339)),
    (276453, (1.822, 15.954, 24.486)),
    (936145, (7.319, 14.554, 23.762)),
    (699077, (1.255, 19.022, 22.368)),
    (549640, (7.082, 19.212, 29.372)),
    (498312, (0.973, 14.763, 29.007)),
    (414489, (1.258, 11.211, 25.443)),
    (585707, (7.751, 13.178, 29.585)),
    (268076, (0.379, 19.277, 25.126)),
    (554121, (2.372, 19.626, 23.971)),
    (502247, (3.525, 10.751, 22.268)),
    (688943, (8.696, 10.147, 22.800)),
    (345450, (2.343, 12.460, 20.033)),
    (660620, (2.113, 17.921, 25.986)),
    (672116, (1.596, 11.243, 23.716)),
    (108183, (5.942, 15.011, 27.114)),
    (687288, (6.447, 13.590, 29.595)),
    (265496, (4.583, 12.866, 29.869)),
    (38050, (7.912, 16.446, 25.765)),
    (60124, (5.910, 16.799, 27.586)),
    (686374, (7.963, 14.414, 26.648)),
    (965709, (3.125, 17.158, 23.829)),
    (795917, (1.620, 16.703, 25.569)),
    (646815, (8.384, 11.222, 21.109)),
    (743908, (6.856, 15.938, 21.686)),
    (932688, (1.572, 15.530, 21.684)),
    (762354, (6.807, 15.526, 21.438)),
    (760772, (0.337, 16.074, 22.413)),
    (542948, (6.748, 16.579, 27.287)),
    (709466, (7.609, 15.679, 23.682)),
    (299562, (4.314, 19.703, 28.512)),
    (87088, (1.321, 17.093, 28.565)),
    (993207, (3.329, 18.807, 23.396)),
    (679765, (4.001, 15.202, 23.897)),
    (686987, (7.395, 12.192, 21.253)),
    (249703, (7.391, 15.629, 23.375)),
    (543074, (1.301, 13.939, 21.616)),
    (21762, (1.997, 15.162, 26.264)),
    (201901, (4.192, 14.192, 27.254)),
    (584884, (0.936, 15.135, 24.267)),
    (816279, (7.500, 13.679, 25.252)),
    (498649, (4.215, 13.858, 28.143)),
    (395612, (0.876, 14.604, 22.579)),
    (632258, (4.181, 14.435, 23.694)),
    (360911, (1.592, 12.193, 26.430)),
    (354681, (9.242, 10.467, 21.781)),
    (180761, (8.732, 19.098, 25.780)),
    (324319, (8.404, 11.635, 20.786)),
    (368124, (6.162, 18.704, 21.746)),
    (994519, (6.833, 11.889, 21.399)),
    (611319, (7.167, 18.847, 22.044)),
    (385415, (4.126, 14.687, 29.243)),
    (571443, (0.627, 12.973, 27.387)),
    (167736, (7.662, 14.194, 28.642)),
    (562031, (9.052, 15.911, 27.525)),
    (218159, (9.551, 19.258, 21.171)),
    (734767, (9.006, 14.609, 28.192)),
    (865624, (2.598, 11.612, 25.696)),
    (184225, (9.268, 11.656, 27.085)),
    (38886, (1.382, 13.321, 26.191)),
    (807320, (2.670, 13.857, 26.762)),
    (666064, (7.246, 11.077, 26.047)),
    (23095, (9.525, 15.195, 23.189)),
    (418727, (3.844, 10.425, 21.243)),
    (601940, (5.430, 13.710, 25.922)),
    (192735, (6.347, 10.286, 27.420)),
    (392389, (2.149, 15.115, 24.688)),
    (70831, (4.435, 13.893, 26.106)),
    (364609, (4.095, 14.697, 27.916)),
    (869341, (0.181, 10.173, 27.510)),
    (862806, (5.354, 16.835, 22.351)),
    (377151, (4.298, 19.855, 26.515)),
    (747840, (7.911, 14.913, 26.238)),
    (323824, (2.784, 12.686, 27.357)),
    (420708, (2.379, 10.636, 20.079)),
    (141489, (8.390, 18.285, 24.457)),
    (564423, (1.933, 17.984, 21.531)),
    (714097, (3.415, 12.355, 27.404)),
    (530307, (6.621, 16.278, 29.126)),
    (719467, (0.330, 17.595, 26.663)),
    (610410, (2.137, 16.608, 26.492)),
    (411367, (9.934, 12.123, 22.308)),
    (313127, (8.559, 13.548, 24.752)),
    (921497, (7.613, 12.042, 20.778)),
    (42216, (7.206, 17.725, 29.030)),
    (316553, (4.522, 10.493, 27.647)),
    (799655, (5.244, 13.395, 23.696)),
    (672914, (5.658, 11.900, 20.513)),
    (969967, (3.276, 15.258, 21.514)),
    (499641, (6.906, 18.920, 28.869)),
    (582286, (7.257, 12.774, 29.097)),
    (715745, (7.811, 18.549, 28.842)),
    (633248, (0.367, 10.160, 21.629)),
    (592926, (1.743, 11.158, 28.865)),
    (512176, (6.559, 19.683, 21.900)),
    (834281, (3.786, 10.400, 25.916)),
    (653828, (1.336, 19.694, 25.458)),
    (132975, (6.852, 12.853, 26.439)),
    (802081, (9.772, 16.707, 27.799)),
    (435426, (4.053, 15.725, 23.997)),
    (157449, (9.888, 18.692, 22.961)),
    (890730, (9.920, 11.192, 24.610)),
    (40590, (8.524, 10.648, 29.005)),
    (447159, (8.648, 10.968, 25.840)),
    (199156, (9.411, 16.093, 29.190)),
    (256915, (0.631, 13.354, 20.983)),
    (85690, (4.755, 13.278, 24.755)),
    (143259, (5.648, 12.545, 23.882)),
    (456887, (6.651, 10.367, 20.031)),
    (584323, (2.806, 16.371, 25.370)),
    (248654, (3.469, 17.262, 26.955)),
    (987110, (8.629, 13.934, 29.188)),
    (466154, (4.913, 19.843, 24.186)),
    (585431, (6.908, 12.453, 25.893)),
    (574891, (9.205, 14.574, 21.063)),
    (91404, (4.717, 15.694, 23.455)),
    (820931, (7.685, 15.085, 25.722)),
    (919131, (4.270, 19.423, 20.088)),
    (110095, (0.172, 16.564, 22.365)),
    (491247, (0.532, 11.774, 23.841)),
    (635407, (5.714, 10.189, 21.784)),
    (2832, (5.214, 19.986, 20.179)),
    (475649, (9.966, 19.666, 28.329)),
    (675972, (7.439, 15.284, 29.790)),
    (274672, (5.477, 16.254, 26.879)),
    (684823, (5.823, 16.622, 26.390)),
    (336537, (7.568, 10.395, 21.228)),
    (607946, (3.649, 12.468, 20.321)),
    (901218, (7.771, 18.748, 25.505)),
    (673310, (2.929, 11.734, 23.223)),
    (644451, (7.966, 17.717, 24.101)),
    (577517, (2.694, 19.466, 22.263)),
    (545610, (3.904, 19.469, 28.452)),
    (522726, (4.523, 12.476, 29.874)),
    (322620, (3.103, 10.689, 23.295)),
    (96807, (0.591, 17.957, 27.125)),
    (252378, (6.389, 14.922, 29.416)),
    (534734, (5.893, 15.458, 20.785)),
    (235644, (1.731, 16.512, 20.628)),
    (450569, (9.328, 12.718, 26.893)),
    (265327, (2.842, 17.828, 29.246)),
    (471307, (2.408, 14.664, 24.031)),
    (983002, (0.697, 11.939, 22.683)),
    (131296, (8.167, 10.714, 26.137)),
    (769483, (9.406, 15.276, 20.592)),
    (947534, (7.235, 11.657, 21.715)),
    (357823, (9.769, 12.791, 28.409)),
    (697031, (8.178, 11.841, 24.057)),
    (8793, (7.097, 12.412, 20.257)),
    (227973, (2.730, 14.393, 25.751)),
    (779573, (8.915, 15.227, 20.013)),
    (65309, (4.162, 10.588, 29.950)),
    (569916, (4.095, 19.146, 21.356)),
    (942141, (6.808, 12.600, 27.840)),
    (365620, (1.337, 10.115, 27.911)),
    (991499, (6.342, 15.730, 21.444)),
    (854016, (3.770, 19.503, 29.884)),
    (520632, (7.126, 12.200, 27.727)),
    (736856, (0.684, 19.191, 21.939)),
    (512089, (7.898, 18.008, 25.272)),
    (443480, (9.882, 19.316, 21.864)),
    (770726, (5.484, 11.905, 25.263)),
    (45541, (7.520, 13.256, 22.441)),
    (329695, (2.603, 16.818, 29.755)),
    (626759, (9.742, 13.779, 27.959)),
    (933553, (6.233, 18.811, 21.370)),
    (417617, (3.530, 13.969, 26.619)),
    (763761, (3.027, 17.110, 28.051)),
    (948317, (8.616, 12.210, 26.368)),
    (588476, (8.458, 13.884, 23.503)),
    (386732, (6.316, 16.536, 27.996)),
    (195136, (4.636, 14.859, 20.146)),
    (776079, (7.304, 14.312, 24.363)),
    (367702, (3.620, 12.791, 26.173)),
    (973594, (3.159, 10.946, 24.336)),
    (776525, (5.911, 12.453, 26.796)),
    (400064, (6.916, 12.322, 29.388)),
    (72347, (5.578, 11.180, 22.252)),
    (75737, (4.523, 18.585, 22.860)),
    (700019, (1.016, 19.321, 26.028)),
    (875477, (0.231, 17.219, 29.000)),
    (243715, (8.943, 12.554, 21.358)),
    (562381, (5.736, 11.412, 23.530)),
    (899635, (7.603, 12.742, 26.826)),
    (257338, (7.006, 16.871, 27.155)),
    (117245, (7.095, 13.253, 25.605)),
    (39134, (8.650, 18.433, 28.294)),
    (654291, (1.038, 14.746, 27.155)),
    (273876, (0.871, 12.021, 22.057)),
    (313158, (9.213, 14.852, 23.146)),
    (709845, (8.863, 11.215, 21.319)),
    (972028, (1.452, 13.269, 23.290)),
    (287916, (4.102, 11.174, 27.157)),
    (279525, (5.341, 12.794, 22.520)),
    (175964, (2.197, 13.553, 28.341)),
    (379590, (0.287, 12.289, 20.238)),
    (916985, (3.522, 17.320, 25.281)),
    (529368, (9.650, 19.018, 24.464)),
    (527310, (2.946, 13.478, 25.933)),
    (469697, (5.877, 14.684, 23.488)),
    (309371, (2.103, 10.377, 25.592)),
    (709397, (6.607, 12.121, 26.713)),
    (538042, (2.356, 17.019, 26.510)),
    (939557, (4.765, 16.718, 23.032)),
    (877287, (3.522, 18.792, 28.792)),
    (313014, (1.931, 11.485, 23.617)),
    (875824, (1.266, 19.827, 29.574)),
    (579900, (4.999, 12.395, 26.871)),
    (700770, (9.220, 10.621, 24.136)),
    (598895, (1.320, 11.212, 26.311)),
    (178028, (1.352, 18.241, 24.398)),
    (848603, (1.457, 12.409, 20.800)),
    (243933, (5.429, 19.150, 21.443)),
    (145176, (5.277, 11.929, 21.861)),
    (551088, (6.482, 17.178, 26.493)),
    (970861, (7.030, 10.138, 21.045)),
    (220010, (4.116, 17.863, 20.992)),
    (263007, (7.256, 11.087, 24.803)),
    (150043, (9.033, 19.287, 25.308)),
    (110840, (8.298, 19.054, 22.333)),
    (916356, (8.845, 18.756, 24.998)),
    (671326, (2.623, 12.604, 24.123)),
    (873091, (8.687, 11.727, 23.342)),
    (341487, (4.110, 19.532, 22.570)),
    (510887, (6.245, 11.560, 29.020)),
    (950332, (8.896, 14.281, 26.068)),
    (578567, (7.317, 13.398, 26.245)),
    (121072, (1.959, 17.543, 20.511)),
    (835340, (7.677, 12.509, 29.401)),
    (333573, (0.047, 13.609, 28.568)),
    (136601, (5.338, 19.741, 22.482)),
    (19502, (6.618, 14.375, 25.956)),
    (330097, (6.536, 11.307, 29.932)),
    (419740, (6.473, 10.603, 29.560)),
    (913593, (3.348, 16.475, 27.243)),
    (148047, (2.295, 14.097, 24.717)),
    (498976, (4.493, 12.674, 27.363)),
    (378718, (8.826, 18.890, 25.844)),
    (436191, (5.529, 12.187, 20.258)),
    (212244, (7.270, 15.979, 24.862)),
    (386012, (7.309, 14.798, 24.871)),
    (301910, (5.963, 12.879, 21.007)),
    (707098, (5.841, 17.167, 28.915)),
    (400976, (5.701, 15.218, 26.188)),
    (854789, (3.793, 11.996, 20.241)),
    (817336, (0.946, 13.561, 21.407)),
    (605817, (6.214, 16.157, 28.694)),
    (629037, (6.979, 10.513, 20.242)),
    (843459, (6.725, 11.476, 22.790)),
    (130943, (1.943, 14.484, 23.671)),
    (609775, (0.243, 11.977, 28.740)),
    (707255, (0.966, 17.975, 25.735)),
    (287038, (8.044, 15.296, 22.222)),
    (620468, (1.878, 13.395, 29.891)),
    (658696, (9.761, 11.760, 22.520)),
    (993944, (2.113, 16.231, 29.181)),
    (240189, (0.580, 16.550, 28.309)),
    (726965, (3.909, 12.844, 27.034)),
    (197749, (3.645, 12.228, 22.393)),
    (190038, (7.185, 19.128, 23.753)),
    (568260, (1.554, 12.488, 25.019)),
    (380193, (0.789, 10.939, 25.699)),
    (446675, (6.673, 11.842, 23.505)),
    (70331, (1.461, 14.652, 20.783)),
    (915090, (1.708, 11.966, 27.337)),
    (406898, (2.274, 16.970, 21.857)),
    (405413, (4.232, 18.966, 29.306)),
    (765535, (0.210, 12.530, 24.347)),
    (231311, (3.474, 14.802, 28.872)),
    (120717, (5.244, 17.639, 26.830)),
    (989059, (0.610, 15.653, 24.444)),
    (727012, (1.296, 18.712, 27.222)),
    (915640, (0.119, 10.678, 29.757)),
    (324198, (7.790, 11.311, 21.748)),
    (879325, (1.574, 11.478, 29.671)),
    (332177, (9.644, 12.236, 29.039)),
    (39712, (1.122, 14.544, 22.730)),
    (630763, (8.008, 17.401, 25.873)),
    (923090, (5.290, 18.322, 23.119)),
    (72803, (3.965, 11.702, 22.456)),
    (418877, (9.132, 18.018, 25.573)),
    (321158, (6.361, 12.118, 26.088)),
    (912583, (7.671, 12.831, 21.738)),
    (782155, (2.657, 15.028, 25.577)),
    (924101, (8.672, 16.033, 20.138)),
    (983304, (0.001, 13.650, 25.930)),
    (313363, (8.521, 16.739, 20.952)),
    (396392, (7.555, 10.723, 20.610)),
    (871701, (2.131, 11.064, 22.196)),
    (508818, (1.533, 17.961, 24.847)),
    (305268, (0.905, 10.942, 27.955)),
    (756733, (7.048, 10.950, 23.597)),
    (192585, (3.268, 19.955, 26.490)),
    (29478, (6.125, 18.591, 24.842)),
    (975007, (5.210, 14.912, 21.304)),
    (214121, (4.393, 10.531, 29.927)),
    (554886, (7.716, 15.027, 26.284)),
    (953269, (4.489, 15.018, 22.888)),
    (418682, (0.598, 19.834, 23.677)),
    (90427, (6.896, 18.564, 27.431)),
    (402991, (1.021, 17.764, 22.847)),
    (745872, (3.194, 11.696, 28.274)),
    (515566, (0.243, 17.899, 24.206)),
    (798096, (1.978, 18.982, 25.719)),
    (450440, (8.995, 18.608, 26.327)),
    (50928, (5.935, 12.570, 21.117)),
    (809052, (0.124, 17.328, 23.180)),
    (672192, (9.789, 15.245, 21.855)),
    (343751, (8.080, 19.993, 26.459)),
    (176049, (8.686, 11.138, 27.741)),
    (479884, (1.190, 15.846, 29.081)),
    (615577, (2.648, 19.189, 28.956)),
    (229285, (8.664, 10.045, 28.862)),
    (104715, (5.961, 14.647, 22.369)),
    (690811, (7.787, 15.650, 23.910)),
    (564615, (8.294, 16.592, 28.212)),
    (605424, (5.431, 10.217, 25.677)),
    (946367, (4.505, 14.083, 28.668)),
    (842131, (1.899, 14.475, 24.924)),
    (714986, (4.439, 19.908, 23.792)),
    (522875, (0.609, 16.504, 27.957)),
    (823816, (4.709, 13.768, 21.355)),
    (756949, (2.666, 17.670, 28.848)),
    (399588, (6.263, 11.923, 21.905)),
    (340680, (2.428, 10.981, 25.951)),
    (603849, (4.191, 13.669, 28.793)),
    (529207, (6.112, 19.343, 28.077)),
    (867267, (9.353, 15.142, 27.627)),
    (385532, (8.339, 10.122, 21.995)),
    (172307, (2.466, 14.451, 23.474)),
    (640494, (1.584, 13.075, 24.782)),
    (54428, (3.003, 10.030, 27.019)),
    (880707, (6.142, 17.374, 22.713)),
    (231255, (0.401, 16.725, 23.329)),
    (891651, (2.697, 13.133, 25.738)),
    (86232, (3.602, 14.960, 23.793)),
    (323290, (3.449, 12.161, 22.615)),
    (343289, (5.543, 15.075, 22.776)),
    (431722, (7.104, 14.659, 23.900)),
    (185493, (9.013, 18.281, 25.196)),
    (1781, (9.827, 11.885, 21.955)),
    (164945, (9.988, 13.719, 25.748)),
    (366155, (5.990, 13.674, 29.877)),
    (171941, (9.093, 11.663, 26.110)),
    (714856, (6.444, 13.784, 24.811)),
    (537063, (2.202, 14.846, 22.261)),
    (223733, (1.481, 17.640, 24.724)),
    (245196, (1.301, 14.254, 20.287)),
    (26647, (9.043, 19.281, 26.174)),
    (528819, (4.204, 12.820, 29.805)),
    (171791, (5.705, 10.123, 22.360)),
    (647174, (5.132, 11.072, 29.600)),
    (736984, (8.837, 16.273, 23.565)),
    (736470, (1.881, 11.892, 29.434)),
    (896946, (7.237, 13.799, 22.594)),
    (982011, (2.327, 12.428, 24.399)),
    (496760, (1.828, 16.727, 23.354)),
    (784530, (1.191, 16.496, 21.487)),
    (163281, (7.578, 19.241, 23.268)),
    (133487, (5.563, 19.980, 29.067)),
    (450691, (1.722, 18.111, 20.416)),
    (261220, (3.829, 10.204, 25.122)),
    (8966, (1.400, 13.182, 21.591)),
    (421534, (3.274, 11.193, 25.643)),
    (40996, (8.136, 19.313, 25.129)),
    (6404, (1.999, 11.010, 23.438)),
    (464958, (8.811, 10.368, 23.748)),
    (870236, (3.708, 13.616, 29.927)),
    (884932, (4.247, 12.690, 25.602)),
    (227900, (5.242, 19.922, 23.211)),
    (712756, (1.467, 13.376, 29.076)),
    (888269, (1.669, 11.676, 24.931)),
    (548808, (4.873, 10.042, 26.218)),
    (814049, (1.709, 15.565, 21.986)),
    (188612, (5.825, 10.037, 25.033)),
    (610061, (2.647, 10.361, 21.977)),
    (898381, (4.916, 19.345, 26.111)),
    (136722, (2.013, 10.963, 26.131)),
    (863224, (7.914, 16.518, 24.773)),
    (564398, (8.619, 19.886, 23.955)),
    (565716, (8.490, 11.267, 23.451)),
    (39398, (3.349, 12.907, 26.377)),
    (242529, (1.968, 14.596, 25.760)),
    (657250, (3.258, 10.509, 22.232)),
    (129054, (2.096, 14.917, 20.703)),
    (867922, (2.197, 13.855, 20.537)),
    (51421, (0.049, 17.024, 22.339)),
    (647529, (2.758, 14.510, 27.920)),
    (742276, (5.007, 16.285, 27.465)),
    (406430, (3.652, 14.629, 25.081)),
    (261069, (5.688, 14.109, 28.357)),
    (638565, (3.874, 19.564, 28.010)),
    (432146, (1.895, 17.500, 29.181)),
    (941018, (2.210, 11.981, 25.868)),
    (874620, (9.208, 12.558, 26.761)),
    (943661, (4.390, 17.603, 26.690)),
    (871166, (3.473, 13.526, 25.952)),
    (120879, (7.922, 12.370, 24.298)),
    (922839, (6.030, 16.527, 26.430)),
    (254400, (3.187, 17.848, 22.922)),
    (343179, (2.664, 11.216, 26.047)),
    (887682, (9.861, 15.999, 20.079)),
    (996098, (1.181, 11.542, 21.945)),
    (395302, (7.712, 10.875, 27.756)),
    (998594, (1.397, 15.357, 21.329)),
    (370150, (7.258, 17.284, 22.637)),
    (884341, (8.200, 14.491, 23.608)),
    (512919, (0.017, 15.662, 20.230)),
    (818462, (9.653, 19.902, 28.987)),
    (321507, (0.592, 12.574, 28.490)),
    (482436, (6.886, 13.054, 28.689)),
    (968277, (7.751, 13.034, 28.747)),
    (743538, (6.824, 15.690, 25.369)),
    (470717, (5.078, 14.750, 26.477)),
    (233130, (0.634, 15.392, 26.755)),
    (702628, (3.245, 12.059, 28.404)),
    (888408, (5.894, 12.011, 21.803)),
    (121487, (0.015, 17.597, 28.893)),
    (718752, (4.158, 15.626, 22.279)),
    (445828, (9.187, 11.989, 26.169)),
    (942557, (1.495, 12.425, 26.728)),
    (375957, (2.666, 12.279, 22.301)),
    (309809, (0.312, 19.009, 20.974)),
    (939803, (7.212, 18.400, 27.516)),
    (825088, (1.198, 19.649, 22.141)),
    (234207, (8.536, 12.563, 20.445)),
    (376800, (7.034, 15.361, 27.952)),
    (874069, (8.350, 19.947, 27.432)),
    (185532, (2.310, 15.859, 29.798)),
    (621631, (5.844, 12.287, 28.647)),
    (119706, (6.598, 17.657, 24.395)),
    (585314, (1.310, 16.914, 22.917)),
    (96008, (0.234, 16.932, 23.845)),
    (924141, (5.849, 11.314, 26.647)),
    (793879, (0.509, 10.713, 28.940)),
    (633252, (3.984, 10.313, 20.641)),
    (566109, (8.296, 10.870, 22.203)),
    (808233, (9.630, 19.261, 24.284)),
    (179273, (7.963, 13.752, 25.231)),
    (308538, (8.650, 15.551, 26.543)),
    (416422, (8.696, 19.995, 20.967)),
    (138696, (7.104, 17.089, 28.557)),
    (826297, (6.571, 18.032, 26.950)),
    (781591, (8.555, 10.559, 29.376)),
    (696826, (0.343, 11.422, 23.081)),
    (72277, (5.457, 11.206, 21.409)),
    (120729, (7.346, 12.655, 23.731)),
    (937818, (8.325, 17.827, 20.530)),
    (381469, (4.478, 13.521, 23.630)),
    (567052, (1.844, 18.528, 29.707)),
    (667795, (0.506, 13.538, 20.618)),
    (181969, (5.420, 12.615, 29.316)),
    (564014, (4.364, 13.689, 23.576)),
    (997919, (9.956, 15.952, 24.887)),
    (142180, (4.160, 11.542, 21.010)),
    (330235, (6.217, 13.739, 29.746)),
    (125969, (2.234, 13.943, 26.973)),
    (202897, (1.462, 18.828, 26.453)),
    (948752, (4.381, 18.357, 22.858)),
    (615923, (4.867, 16.323, 21.460)),
    (962573, (2.944, 11.452, 27.349)),
    (910091, (4.657, 13.456, 22.733)),
    (181102, (7.693, 13.461, 27.936)),
    (263365, (4.284, 18.423, 25.792)),
    (551102, (8.602, 15.199, 27.772)),
    (339569, (3.707, 13.138, 28.471)),
    (285251, (9.115, 19.026, 23.663)),
    (291945, (9.835, 15.533, 27.503)),
    (372378, (8.715, 10.727, 23.105)),
    (814514, (1.172, 11.086, 21.476)),
    (207649, (5.762, 15.350, 25.357)),
    (726780, (5.486, 17.399, 20.568)),
    (778188, (8.516, 18.733, 22.054)),
    (98180, (0.772, 13.762, 20.423)),
    (883469, (2.953, 13.353, 20.734)),
    (154566, (8.702, 14.121, 27.269)),
    (892581, (8.967, 15.133, 23.927)),
    (42208, (6.346, 13.017, 23.570)),
    (810903, (5.670, 18.161, 26.919)),
    (947014, (9.331, 13.115, 27.813)),
    (354348, (8.411, 17.046, 20.606)),
    (189974, (5.811, 10.339, 29.606)),
    (41667, (5.295, 15.037, 26.926)),
    (842952, (6.057, 16.900, 26.387)),
    (366604, (0.587, 16.427, 24.672)),
    (634891, (0.553, 18.819, 27.061)),
    (798865, (5.939, 18.287, 24.161)),
    (980118, (0.265, 19.755, 29.385)),
    (437329, (7.546, 15.839, 23.177)),
    (935102, (0.360, 16.901, 27.079)),
    (945592, (8.542, 18.062, 28.592)),
    (107924, (7.828, 18.918, 22.292)),
    (470298, (2.850, 11.190, 22.226)),
    (70920, (5.040, 15.461, 25.222)),
    (413328, (0.342, 15.215, 23.857)),
    (214618, (4.161, 14.715, 20.798)),
    (633165, (0.871, 12.771, 25.783)),
    (863147, (1.259, 12.857, 23.496)),
    (20802, (6.159, 13.683, 27.979)),
    (25699, (2.038, 11.791, 22.867)),
    (423113, (9.212, 17.187, 29.891)),
    (53167, (1.203, 15.236, 20.693)),
    (668043, (7.280, 19.038, 24.009)),
    (656493, (2.775, 10.923, 25.154)),
    (819310, (6.179, 16.987, 25.961)),
    (850629, (4.047, 10.022, 20.737)),
    (747934, (3.751, 18.451, 21.661)),
    (870375, (2.997, 15.116, 23.860)),
    (700203, (0.821, 12.432, 23.477)),
    (757649, (6.666, 18.967, 21.653)),
    (534074, (1.752, 16.513, 24.873)),
    (240087, (4.348, 13.993, 20.682)),
    (895592, (1.207, 11.562, 29.887)),
    (674278, (5.300, 15.105, 26.809)),
    (212441, (1.106, 13.890, 23.812)),
    (821466, (6.270, 18.395, 25.375)),
    (290709, (6.219, 15.516, 22.411)),
    (378283, (3.898, 15.087, 29.211)),
    (578276, (8.907, 11.790, 24.072)),
    (245153, (8.838, 13.454, 27.488)),
    (261974, (0.397, 16.864, 23.867)),
    (382625, (1.651, 17.170, 27.099)),
    (403933, (6.836, 10.382, 28.229)),
    (440048, (3.915, 14.010, 29.055)),
    (100031, (2.232, 17.891, 29.672)),
    (545100, (4.674, 16.248, 25.852)),
    (612753, (3.532, 16.666, 21.753)),
    (619822, (6.181, 11.989, 22.148)),
    (41156, (2.749, 14.216, 20.558)),
    (456666, (5.458, 18.320, 24.792)),
    (13888, (1.001, 17.342, 20.671)),
    (938169, (8.570, 15.512, 22.070)),
    (13701, (1.605, 14.033, 21.124)),
    (779389, (2.605, 12.372, 21.723)),
    (816681, (1.115, 11.650, 29.381)),
    (18196, (0.018, 13.599, 24.531)),
    (201545, (1.310, 18.702, 26.732)),
    (155576, (8.518, 12.529, 24.292)),
    (64781, (1.030, 18.916, 29.733)),
    (895340, (2.305, 18.088, 21.822)),
    (456960, (4.824, 10.920, 20.979)),
    (908669, (0.882, 10.572, 28.901)),
    (845425, (6.401, 13.260, 27.506)),
    (949989, (9.341, 12.291, 26.460)),
    (55578, (0.137, 10.165, 20.344)),
    (793686, (5.979, 10.233, 20.602)),
    (850465, (2.005, 13.241, 27.696)),
    (675025, (5.345, 18.838, 22.821)),
    (92346, (8.077, 12.169, 27.288)),
    (758568, (8.111, 17.478, 24.498)),
    (357164, (6.734, 15.548, 20.114)),
    (929507, (6.920, 19.899, 24.937)),
    (110856, (1.343, 11.721, 21.168)),
    (94156, (3.598, 11.989, 21.172)),
    (563766, (3.090, 15.310, 29.501)),
    (368283, (6.583, 12.932, 29.563)),
    (330178, (8.936, 15.926, 23.408)),
    (23291, (5.424, 13.563, 22.253)),
    (857452, (1.912, 14.458, 22.264)),
    (702624, (6.135, 14.926, 27.229)),
    (407760, (9.432, 18.685, 23.167)),
    (595419, (7.823, 15.236, 23.572)),
    (552469, (8.227, 10.166, 29.599)),
    (252976, (1.122, 13.187, 22.725)),
    (629228, (1.943, 13.729, 20.999)),
    (572308, (7.965, 14.282, 24.492)),
    (400628, (0.888, 18.855, 22.011)),
    (892236, (5.242, 11.818, 23.383)),
    (955944, (1.458, 10.160, 27.364)),
    (768333, (9.552, 14.285, 20.324)),
    (429468, (4.260, 18.808, 26.788)),
    (652103, (5.399, 16.878, 29.873)),
    (708547, (1.242, 14.182, 28.788)),
    (69035, (4.232, 16.259, 28.380)),
    (971820, (1.346, 19.325, 23.406)),
    (851087, (8.787, 19.146, 28.379)),
    (545493, (2.159, 10.582, 25.584)),
    (531285, (7.108, 18.579, 20.897)),
    (237817, (5.933, 11.826, 23.202)),
    (56525, (8.820, 16.768, 28.242)),
    (951083, (3.478, 15.412, 24.150)),
    (163245, (1.728, 19.776, 26.285)),
    (4730, (0.681, 16.488, 21.525)),
    (57172, (7.163, 10.055, 21.004)),
    (244061, (7.599, 10.285, 20.937)),
    (941440, (8.325, 13.894, 21.935)),
    (174968, (9.657, 11.328, 26.261)),
    (294770, (8.672, 10.655, 24.936)),
    (267838, (2.815, 10.166, 20.421)),
    (326262, (8.807, 11.514, 24.440)),
    (636795, (8.945, 10.230, 29.571)),
    (21221, (3.332, 10.632, 24.895)),
    (753349, (1.183, 16.832, 26.512)),
    (20444, (3.030, 11.522, 29.453)),
    (441496, (3.482, 11.812, 20.436)),
    (944467, (2.541, 13.532, 24.090)),
    (401725, (5.873, 12.122, 24.597)),
    (160486, (2.020, 13.248, 20.498)),
    (510456, (8.417, 19.838, 26.906)),
    (790615, (6.220, 19.204, 22.865)),
    (97332, (1.140, 15.020, 25.535)),
    (348393, (6.350, 10.405, 22.882)),
    (44040, (4.599, 11.308, 20.430)),
    (32825, (5.439, 15.200, 22.274)),
    (267564, (2.774, 11.316, 24.140)),
    (686456, (1.078, 11.337, 29.172)),
    (993170, (9.250, 19.240, 26.688)),
    (858092, (0.608, 15.839, 28.655)),
    (455354, (4.588, 19.342, 27.831)),
    (862423, (6.925, 17.046, 21.744)),
    (411809, (9.765, 10.072, 24.447)),
    (777032, (4.666, 11.863, 29.759)),
    (599383, (3.769, 17.312, 25.577)),
    (264085, (6.615, 17.501, 23.756)),
    (460202, (7.631, 16.956, 23.416)),
    (776858, (8.900, 15.391, 27.474)),
    (896585, (7.581, 19.674, 26.687)),
    (102814, (8.964, 13.977, 20.744)),
    (668081, (6.476, 19.193, 21.735)),
    (754621, (2.964, 18.283, 23.180)),
    (940179, (9.116, 19.369, 28.467)),
    (761274, (5.894, 18.784, 29.259)),
    (852832, (8.950, 14.227, 27.506)),
    (404032, (9.879, 19.815, 21.243)),
    (845885, (1.326, 19.421, 20.451)),
    (646739, (3.678, 10.928, 28.204)),
    (948754, (1.161, 11.861, 25.848)),
    (999116, (1.185, 13.614, 22.266)),
    (668266, (0.518, 12.760, 28.379)),
    (587706, (3.327, 12.446, 22.645)),
    (379138, (0.968, 15.875, 25.550)),
    (242307, (6.810, 12.804, 22.574)),
    (464030, (7.926, 12.508, 22.166)),
    (211712, (3.472, 13.351, 24.509)),
    (584286, (1.007, 19.105, 25.559)),
    (599288, (4.908, 18.836, 27.031)),
    (804723, (4.634, 17.317, 25.815)),
    (305831, (3.504, 12.942, 29.486)),
    (920613, (1.846, 13.176, 25.411)),
    (189078, (3.130, 12.931, 23.817)),
    (103930, (1.454, 17.069, 22.752)),
    (840461, (6.675, 11.786, 27.917)),
    (950328, (9.550, 17.688, 26.108)),
    (502124, (0.630, 11.513, 27.403)),
    (303858, (9.187, 16.072, 22.229)),
    (840489, (5.590, 14.842, 24.442)),
    (284186, (7.697, 15.757, 23.593)),
    (328188, (9.204, 11.464, 21.917)),
    (606374, (3.145, 19.672, 21.763)),
    (653650, (5.866, 14.084, 26.747)),
    (730309, (8.471, 18.339, 29.234)),
    (689462, (9.211, 17.020, 25.891)),
    (327835, (8.520, 12.554, 23.861)),
    (310955, (1.474, 16.387, 28.184)),
    (399864, (3.705, 17.690, 21.633)),
    (508964, (6.944, 13.452, 21.490)),
    (405380, (1.634, 15.421, 24.510)),
    (791964, (2.460, 11.767, 28.933)),
    (367582, (1.227, 17.473, 24.256)),
    (607919, (3.117, 14.037, 22.719)),
    (813281, (7.565, 18.390, 26.182)),
    (483079, (0.924, 14.516, 27.272)),
    (253259, (4.632, 14.976, 22.020)),
    (866680, (8.695, 16.051, 21.757)),
    (242792, (2.179, 16.295, 27.975)),
    (986126, (8.689, 13.930, 22.329)),
    (882173, (7.659, 15.496, 23.819)),
    (851543, (5.195, 11.360, 28.080)),
    (431383, (8.546, 15.750, 20.367)),
    (265179, (8.528, 11.864, 22.454)),
    (961638, (4.728, 15.891, 27.134)),
    (525683, (2.228, 14.112, 27.563)),
    (593806, (0.958, 19.279, 28.628)),
    (519614, (9.011, 19.051, 26.999)),
    (219428, (9.921, 13.087, 29.900)),
    (694160, (8.184, 19.138, 20.408)),
    (273340, (8.731, 15.218, 24.186)),
    (413994, (4.196, 18.073, 23.904)),
    (335335, (2.062, 17.834, 22.940)),
    (845766, (5.415, 13.915, 25.443)),
    (906689, (8.211, 15.751, 20.747)),
    (6027, (1.035, 18.688, 28.540)),
    (896480, (9.529, 15.469, 21.673)),
    (156721, (3.475, 12.871, 26.831)),
    (304465, (5.044, 16.245, 20.344)),
    (927463, (4.508, 17.572, 25.744)),
    (518663, (1.349, 15.643, 20.873)),
    (377416, (1.829, 14.185, 20.573)),
    (466700, (9.293, 12.174, 22.244)),
    (589838, (7.808, 14.963, 25.673)),
    (851788, (5.459, 12.963, 29.189)),
    (452892, (4.634, 17.203, 28.273)),
    (82227, (0.277, 13.735, 27.351)),
    (664917, (9.354, 17.995, 20.867)),
    (141638, (2.189, 16.708, 29.019)),
    (433900, (2.132, 12.154, 29.013)),
    (895284, (2.812, 12.523, 20.716)),
    (483048, (5.853, 16.076, 21.959)),
    (697474, (6.683, 16.698, 22.035)),
    (720675, (7.220, 14.308, 28.656)),
    (766731, (8.535, 19.800, 27.428)),
    (814158, (0.699, 14.410, 20.364)),
    (38237, (3.395, 12.862, 28.156)),
    (489212, (3.850, 15.122, 21.743)),
    (237426, (6.339, 11.576, 29.255)),
    (645159, (6.605, 19.959, 21.036)),
    (99407, (1.041, 14.163, 28.387)),
    (770191, (8.572, 17.675, 26.286)),
    (432180, (1.078, 16.945, 23.581)),
    (456382, (7.812, 17.335, 22.136)),
    (77144, (0.879, 16.932, 24.948)),
    (4803, (9.246, 16.555, 25.026)),
    (619770, (7.658, 13.799, 28.493)),
    (989650, (0.858, 12.178, 25.674)),
    (664115, (0.291, 17.982, 28.637)),
    (921047, (8.416, 15.838, 28.413)),
    (698447, (2.193, 12.955, 21.604)),
    (159400, (4.125, 14.626, 23.559)),
    (256516, (8.398, 11.587, 22.207)),
    (111987, (7.655, 11.041, 28.757)),
    (882163, (6.021, 16.265, 26.506)),
    (255425, (4.379, 18.700, 22.383)),
    (566608, (0.000, 12.450, 20.914)),
    (796977, (1.288, 16.553, 29.136)),
    (694706, (0.786, 13.193, 21.803)),
    (507471, (1.786, 11.094, 25.256)),
    (588164, (6.975, 17.838, 27.286)),
    (914735, (8.627, 14.560, 29.405)),
    (390400, (8.398, 11.773, 24.588)),
    (85689, (5.983, 13.358, 25.582)),
    (901542, (7.574, 15.443, 22.611)),
    (796470, (1.843, 17.275, 29.166)),
    (159725, (1.545, 17.894, 21.561)),
    (135262, (0.342, 18.860, 27.935)),
    (373120, (5.901, 19.171, 27.413)),
    (238393, (9.020, 15.749, 28.606)),
    (477639, (2.428, 12.891, 26.380)),
    (139306, (7.744, 19.977, 24.654)),
    (905221, (1.989, 15.714, 29.461)),
    (375174, (1.608, 11.214, 27.262)),
    (930003, (1.708, 14.366, 22.877)),
    (178582, (6.185, 14.939, 23.859)),
    (869354, (7.149, 13.607, 28.021)),
    (819390, (4.268, 19.320, 21.641)),
    (695983, (1.076, 18.171, 26.991)),
    (849482, (3.388, 11.745, 25.495)),
    (852180, (1.401, 16.294, 23.133)),
    (672047, (3.750, 18.902, 26.110)),
    (507847, (5.030, 13.299, 22.924)),
    (379823, (3.617, 12.549, 26.912)),
    (304142, (5.050, 15.779, 20.383)),
    (671422, (1.650, 13.481, 24.397)),
    (184659, (9.616, 12.500, 25.884)),
    (638718, (2.630, 13.088, 22.708)),
    (676879, (5.896, 13.866, 21.325)),
    (863753, (6.283, 10.149, 23.410)),
    (898057, (8.687, 10.730, 29.518)),
    (109313, (1.933, 18.889, 28.451)),
    (106162, (3.318, 18.567, 26.124)),
    (702711, (3.604, 16.276, 28.602)),
    (509736, (5.542, 18.115, 26.686)),
    (199890, (9.525, 17.877, 20.087)),
    (424995, (9.426, 16.953, 25.408)),
    (827051, (8.714, 14.982, 23.127)),
    (93713, (2.326, 15.835, 25.261)),
    (68736, (5.583, 17.375, 21.591)),
    (143718, (6.994, 19.647, 28.964)),
    (953547, (9.065, 16.557, 25.769)),
    (498613, (0.502, 10.099, 27.266)),
    (871418, (8.277, 10.004, 22.585)),
    (100295, (1.503, 16.357, 26.240)),
    (951741, (8.422, 16.461, 22.145)),
    (12468, (7.028, 15.105, 25.098)),
    (877017, (1.358, 17.486, 26.925)),
    (432331, (0.856, 13.872, 22.546)),
    (622459, (6.291, 12.452, 28.203)),
    (77284, (5.910, 17.664, 24.447)),
    (714605, (7.547, 12.150, 27.115)),
    (902431, (4.617, 17.122, 26.222)),
    (351140, (0.485, 14.324, 20.784)),
    (690164, (3.664, 11.584, 26.077)),
    (648712, (4.018, 14.131, 25.790)),
    (265352, (8.722, 10.149, 25.855)),
    (557212, (9.288, 10.113, 24.768)),
    (20596, (3.172, 15.849, 26.342)),
    (85098, (5.960, 19.608, 23.240)),
    (336095, (7.167, 19.950, 25.395)),
    (807685, (1.914, 11.803, 24.212)),
    (946023, (1.761, 13.505, 28.733)),
    (599086, (0.299, 14.474, 28.921)),
    (143850, (1.228, 13.220, 28.032)),
    (832210, (4.310, 15.016, 20.430)),
    (305045, (6.305, 10.322, 21.862)),
    (230598, (1.307, 14.740, 22.868)),
    (224813, (2.741, 15.098, 20.124)),
    (236638, (1.694, 19.492, 25.975)),
    (171718, (1.473, 13.938, 23.278)),
    (544544, (7.749, 13.083, 29.293)),
    (833874, (2.918, 13.273, 22.557)),
    (716501, (8.493, 11.729, 23.243)),
    (102520, (0.356, 11.589, 25.675)),
    (972679, (7.740, 14.315, 23.646)),
    (967541, (2.762, 18.069, 21.918)),
    (996270, (8.027, 15.360, 23.948)),
    (60890, (1.769, 15.914, 29.699)),
    (180567, (1.379, 16.032, 28.722)),
    (618977, (7.790, 12.550, 22.297)),
    (993226, (8.156, 12.137, 23.467)),
    (733311, (8.303, 15.578, 27.743)),
    (518609, (7.585, 10.609, 21.273)),
    (541520, (7.536, 16.295, 26.207)),
    (134502, (8.841, 19.849, 24.394)),
    (801514, (2.670, 16.074, 23.164)),
    (235339, (1.942, 18.401, 26.190)),
    (154284, (6.687, 17.570, 25.741)),
    (641412, (0.427, 18.009, 27.609)),
    (33413, (4.302, 10.580, 24.881)),
    (385727, (6.600, 14.936, 20.565)),
    (739209, (6.915, 17.505, 27.581)),
    (450594, (9.916, 11.499, 23.218)),
    (970840, (0.594, 17.030, 29.227)),
    (414751, (8.033, 19.315, 23.181)),
    (950302, (3.449, 18.439, 27.559)),
    (962391, (2.967, 14.161, 20.462)),
    (662475, (3.863, 14.854, 29.352)),
    (188653, (9.804, 18.383, 21.672)),
    (918567, (7.624, 13.631, 24.599)),
    (536403, (6.433, 13.329, 25.505)),
    (155924, (4.535, 16.667, 25.130)),
    (770278, (6.595, 19.746, 26.506)),
    (91130, (6.513, 10.175, 23.040)),
    (271531, (9.151, 17.952, 29.678)),
    (685043, (6.655, 11.036, 20.837)),
    (453110, (9.322, 11.034, 28.230)),
    (871347, (8.399, 17.705, 22.211)),
    (528253, (2.505, 11.448, 28.611)),
    (826955, (1.964, 11.460, 24.649)),
    (902643, (4.389, 14.421, 26.387)),
    (719950, (6.792, 17.584, 20.357)),
    (14686, (8.129, 13.191, 28.536)),
    (996735, (6.185, 11.211, 25.494)),
    (138760, (8.150, 19.456, 26.469)),
    (566862, (1.140, 12.984, 24.195)),
    (943050, (3.834, 18.250, 23.784)),
    (719838, (3.262, 11.784, 20.674)),
    (631383, (1.268, 18.345, 28.084)),
    (750159, (8.060, 12.527, 23.430)),
    (201925, (7.210, 14.152, 22.361)),
    (988671, (7.273, 16.726, 25.421)),
    (236877, (1.279, 10.223, 26.228)),
    (428648, (3.448, 19.773, 23.872)),
    (892965, (1.487, 18.962, 23.609)),
    (516135, (6.795, 16.144, 23.752)),
    (709842, (1.569, 17.533, 24.596)),
    (774247, (0.719, 15.529, 26.993)),
    (922968, (8.023, 11.144, 29.049)),
    (100193, (0.074, 13.527, 22.169)),
    (538028, (3.925, 15.865, 27.634)),
    (51053, (1.950, 14.606, 23.310)),
    (80683, (4.143, 13.445, 28.661)),
    (830685, (4.462, 17.497, 29.553)),
    (989673, (0.474, 15.485, 29.609)),
    (742528, (6.210, 15.153, 22.027)),
    (698686, (8.464, 13.326, 24.460)),
    (975520, (7.192, 12.907, 26.704)),
    (999724, (9.548, 12.265, 21.305)),
    (244858, (2.975, 12.929, 21.061)),
    (807500, (5.736, 12.581, 29.531)),
    (582471, (2.574, 17.507, 23.711)),
    (460226, (5.718, 13.738, 29.327)),
    (61698, (7.572, 17.401, 23.257)),
    (131439, (9.435, 15.513, 28.597)),
    (745527, (0.529, 16.399, 28.375)),
    (908189, (3.323, 17.530, 24.626)),
    (416852, (1.978, 18.573, 20.129)),
    (483193, (5.850, 11.181, 23.000)),
    (738108, (7.327, 15.164, 25.896)),
    (138502, (5.858, 13.886, 26.713)),
    (656308, (5.586, 17.499, 25.044)),
    (652016, (8.010, 12.000, 20.508)),
    (628654, (1.921, 19.355, 21.466)),
    (932685, (6.230, 11.704, 23.761)),
    (820532, (5.390, 19.704, 26.879)),
    (874667, (7.959, 16.343, 23.574)),
    (937016, (1.199, 17.685, 20.589)),
    (281181, (9.424, 11.889, 26.901)),
    (848879, (1.405, 13.018, 26.748)),
    (610811, (3.781, 13.905, 27.111)),
    (770731, (2.885, 14.718, 29.398)),
    (531455, (2.844, 12.724, 25.145)),
    (911365, (8.556, 14.222, 23.453)),
    (799817, (5.171, 13.141, 23.820)),
    (212818, (7.202, 13.623, 27.086)),
    (944988, (7.430, 15.214, 29.226)),
    (669194, (2.849, 12.822, 28.908)),
    (52640, (5.143, 10.754, 23.963)),
    (394661, (6.667, 14.682, 26.265)),
    (465025, (4.450, 19.075, 24.669)),
    (345235, (1.681, 17.603, 27.442)),
    (967847, (9.763, 17.449, 23.813)),
    (922813, (1.037, 11.914, 26.487)),
    (153411, (5.375, 10.389, 20.889)),
    (914520, (1.898, 17.164, 20.499)),
    (749624, (1.082, 16.401, 20.611)),
    (897085, (2.419, 10.109, 22.813)),
    (946831, (2.395, 17.631, 29.603)),
    (275953, (8.314, 18.253, 28.032)),
    (947817, (2.250, 10.833, 25.899)),
    (484640, (5.538, 14.840, 28.358)),
    (720, (6.575, 18.913, 26.586)),
    (290087, (0.046, 19.245, 20.005)),
    (646342, (9.596, 17.559, 29.954)),
    (559136, (9.432, 16.955, 26.823)),
    (186580, (3.136, 17.249, 20.786)),
    (178404, (1.873, 16.593, 24.878)),
    (116178, (9.249, 16.905, 28.597)),
    (687383, (3.394, 15.096, 29.054)),
    (78258, (4.678, 12.634, 21.643)),
    (380473, (0.201, 19.212, 25.709)),
    (549579, (9.067, 11.130, 28.172)),
    (196158, (4.389, 12.160, 24.739)),
    (977346, (8.419, 11.402, 29.705)),
    (3653, (3.412, 10.213, 27.966)),
    (199432, (5.367, 15.276, 28.600)),
    (750826, (0.847, 12.688, 22.251)),
    (838400, (3.890, 16.798, 21.243)),
    (552754, (2.133, 12.402, 28.149)),
    (259540, (5.638, 16.593, 21.123)),
    (618016, (0.852, 10.914, 23.718)),
    (720538, (1.180, 15.634, 21.091)),
    (439709, (8.235, 11.937, 28.180)),
    (832422, (9.662, 18.660, 20.498)),
    (9307, (6.795, 16.464, 21.769)),
    (498440, (4.674, 16.122, 25.191)),
    (991113, (6.265, 14.703, 27.722)),
    (280259, (3.688, 19.721, 20.957)),
    (403063, (6.020, 19.615, 21.085)),
    (930910, (2.739, 19.354, 28.584)),
    (549351, (7.446, 10.413, 26.924)),
    (887570, (0.884, 18.535, 27.988)),
    (137186, (2.201, 12.033, 26.395)),
    (872898, (2.745, 13.647, 28.381)),
    (525280, (4.802, 16.218, 28.212)),
    (914432, (9.385, 15.274, 27.537)),
    (274793, (7.585, 11.633, 29.054)),
    (650112, (7.714, 13.647, 24.847)),
    (684567, (8.710, 10.106, 23.290)),
    (347592, (3.578, 12.383, 22.326)),
    (175963, (9.963, 11.311, 27.899)),
    (746569, (1.082, 14.368, 29.942)),
    (50157, (7.935, 16.663, 21.735)),
    (990275, (5.270, 19.221, 22.572)),
    (961797, (2.059, 17.029, 24.348)),
    (126100, (1.917, 11.532, 23.577)),
    (428836, (4.474, 18.931, 27.277)),
    (454099, (1.953, 13.482, 29.993)),
    (515816, (5.096, 16.887, 29.869)),
    (322662, (9.782, 12.752, 27.674)),
    (19115, (8.060, 14.543, 21.866)),
    (128370, (7.927, 19.462, 25.139)),
    (543514, (1.658, 15.797, 29.215)),
    (964425, (1.271, 11.883, 24.448)),
    (67600, (3.474, 18.554, 26.942)),
    (655064, (3.397, 19.041, 21.941)),
    (424309, (7.518, 10.168, 26.722)),
    (275361, (2.148, 14.187, 29.690)),
    (847968, (9.172, 14.586, 29.314)),
    (15942, (4.577, 16.935, 29.618)),
    (394177, (7.219, 19.004, 22.091)),
    (743962, (9.800, 19.737, 22.047)),
    (419175, (3.336, 11.645, 20.246)),
    (219596, (2.219, 12.428, 28.508)),
    (460088, (0.050, 15.086, 26.191)),
    (701036, (6.872, 10.184, 26.832)),
    (548091, (7.077, 16.523, 23.309)),
    (915570, (1.602, 18.722, 29.087)),
    (271452, (4.530, 11.353, 29.594)),
    (532171, (2.476, 13.752, 24.657)),
    (378049, (8.179, 12.599, 20.548)),
    (468873, (8.616, 12.410, 22.157)),
    (710080, (4.974, 11.732, 27.966)),
    (618069, (1.696, 16.420, 28.202)),
    (414230, (1.298, 18.935, 20.578)),
    (543432, (0.939, 10.017, 23.790)),
    (954808, (3.016, 14.650, 26.834)),
    (397665, (7.280, 16.790, 27.125)),
    (512075, (0.913, 11.568, 20.286)),
    (606331, (4.697, 11.277, 27.499)),
    (199132, (3.415, 13.220, 29.351)),
    (296584, (1.022, 14.209, 20.144)),
    (717823, (7.381, 19.971, 26.106)),
    (571388, (9.924, 18.566, 24.268)),
    (936895, (8.273, 19.300, 20.863)),
    (417021, (0.731, 16.180, 25.376)),
    (4314, (6.668, 11.061, 25.446)),
    (515977, (8.522, 13.952, 26.475)),
    (264710, (3.167, 14.982, 22.023)),
    (270248, (8.497, 13.845, 27.826)),
    (327307, (7.125, 19.438, 24.115)),
    (111395, (5.192, 12.669, 21.114)),
    (128005, (8.772, 12.496, 26.549)),
    (733291, (8.352, 12.041, 29.983)),
    (64616, (3.424, 10.675, 27.321)),
    (295232, (3.995, 14.885, 20.789)),
    (259697, (2.966, 18.411, 26.818)),
    (527142, (7.891, 17.326, 21.061)),
    (767727, (3.608, 19.089, 21.897)),
    (363544, (8.436, 19.441, 22.491)),
    (863013, (4.114, 19.207, 23.823)),
    (8514, (4.775, 11.207, 23.012)),
    (532746, (6.628, 17.882, 28.935)),
    (651110, (8.813, 15.882, 21.401)),
    (666184, (0.058, 10.972, 29.095)),
    (512712, (2.118, 14.742, 25.628)),
    (135079, (2.314, 14.408, 26.176)),
    (67227, (6.704, 11.444, 23.172)),
    (307307, (4.982, 16.629, 26.828)),
    (837560, (5.001, 11.167, 25.987)),
    (51569, (2.296, 18.477, 22.877)),
    (178218, (6.096, 16.834, 29.921)),
    (799745, (8.431, 16.835, 21.313)),
    (369510, (0.683, 15.450, 23.523)),
    (425520, (4.140, 12.206, 26.938)),
    (499904, (0.133, 16.489, 24.297)),
    (301192, (0.675, 16.482, 24.067)),
    (387210, (0.699, 19.573, 26.329)),
    (186094, (3.510, 11.501, 23.573)),
    (739378, (4.192, 18.380, 29.219)),
    (293461, (2.027, 18.877, 25.348)),
    (14816, (7.481, 14.575, 29.663)),
    (420566, (9.332, 12.636, 25.541)),
    (305419, (6.618, 11.977, 20.300)),
    (306424, (4.760, 17.457, 29.852)),
    (373684, (6.961, 10.475, 27.954)),
    (888139, (9.823, 17.640, 27.480)),
    (572992, (1.889, 16.962, 22.579)),
    (684701, (5.524, 12.856, 28.324)),
    (861773, (7.983, 15.572, 22.997)),
    (52305, (8.264, 15.626, 22.300)),
    (486344, (1.134, 10.273, 23.053)),
    (132755, (8.622, 13.376, 20.300)),
    (792185, (6.560, 13.890, 29.541)),
    (979386, (6.087, 10.247, 23.112)),
    (388824, (3.808, 18.616, 24.315)),
    (33925, (5.432, 14.092, 25.992)),
    (213092, (2.996, 10.869, 20.777)),
    (725662, (6.471, 10.777, 25.049)),
    (373428, (1.670, 15.887, 20.033)),
    (419586, (3.039, 10.276, 27.655)),
    (298187, (7.560, 18.946, 21.975)),
    (635237, (1.171, 10.837, 25.204)),
    (81129, (9.396, 17.774, 20.128)),
    (679700, (9.535, 13.696, 20.760)),
    (18146, (3.965, 14.061, 28.790)),
    (909920, (2.041, 13.742, 25.866)),
    (957885, (0.766, 18.303, 21.393)),
    (457147, (5.840, 10.847, 26.723)),
    (884235, (4.480, 17.158, 20.059)),
    (171754, (2.271, 13.012, 23.463)),
    (669313, (0.814, 12.611, 23.672)),
    (384063, (4.905, 17.417, 25.875)),
    (403125, (9.432, 13.884, 28.632)),
    (625828, (6.873, 13.745, 28.831)),
    (61280, (8.389, 13.522, 22.447)),
    (80380, (8.917, 14.209, 24.046)),
    (45554, (1.389, 10.465, 22.092)),
    (586735, (0.532, 16.731, 24.300)),
    (4536, (9.941, 15.318, 22.205)),
    (288580, (0.432, 11.123, 26.044)),
    (436151, (9.241, 19.315, 26.016)),
    (603383, (2.527, 15.138, 28.289)),
    (945682, (5.879, 12.773, 27.101)),
    (427281, (5.173, 18.654, 25.892)),
    (796852, (4.701, 19.657, 26.269)),
    (496348, (1.700, 15.456, 20.178)),
    (263728, (4.243, 18.082, 26.666)),
    (133097, (4.795, 14.301, 29.112)),
    (579462, (7.404, 12.063, 23.315)),
    (561171, (6.806, 19.409, 29.266)),
    (150521, (2.894, 11.980, 29.159)),
    (260466, (9.762, 13.607, 21.924)),
    (453911, (0.669, 17.471, 27.111)),
    (994255, (2.761, 17.455, 27.491)),
    (958503, (2.881, 10.341, 25.022)),
    (183501, (5.041, 18.410, 25.835)),
    (716025, (5.560, 10.343, 23.712)),
    (728703, (6.254, 15.796, 28.038)),
    (347446, (9.006, 18.646, 21.763)),
    (693068, (0.924, 18.900, 20.431)),
    (30140, (1.666, 19.618, 26.435)),
    (816990, (3.749, 11.385, 29.550)),
    (609456, (9.483, 17.660, 27.325)),
    (554909, (8.910, 12.480, 28.475)),
    (686648, (3.397, 18.633, 28.935)),
    (998330, (6.592, 19.534, 24.653)),
    (849337, (1.098, 15.169, 26.524)),
    (121437, (9.115, 18.650, 28.105)),
    (983787, (1.035, 14.562, 27.822)),
    (320934, (1.091, 10.138, 29.268)),
    (602294, (5.898, 10.213, 21.215)),
    (695918, (5.764, 11.823, 28.698)),
    (900952, (6.380, 15.945, 27.910)),
    (504150, (7.292, 19.644, 20.267)),
    (890287, (0.259, 16.183, 25.978)),
    (43779, (0.332, 10.579, 20.620)),
    (222817, (7.011, 12.593, 22.750)),
    (678162, (3.600, 11.971, 23.784)),
    (729743, (8.129, 10.092, 20.833)),
    (562496, (5.571, 11.695, 25.904)),
    (143713, (7.196, 14.496, 22.605)),
    (424951, (5.259, 11.198, 27.581)),
    (650842, (9.552, 13.562, 20.076)),
    (610567, (5.025, 18.736, 24.443)),
    (902202, (6.659, 14.564, 29.936)),
    (22324, (4.826, 16.738, 26.547)),
    (995838, (1.182, 15.968, 27.568)),
    (579290, (2.461, 19.467, 29.803)),
    (756628, (0.342, 13.057, 26.469)),
    (425336, (6.030, 19.724, 25.486)),
    (716966, (9.133, 18.872, 23.896)),
    (681051, (8.745, 11.869, 21.551)),
    (466162, (1.858, 18.932, 28.322)),
    (499338, (6.131, 16.380, 25.090)),
    (550944, (2.295, 19.068, 27.532)),
    (38493, (5.905, 10.126, 21.111)),
    (802416, (4.509, 15.313, 26.028)),
    (492531, (2.518, 15.159, 20.973)),
    (943257, (0.003, 15.033, 27.206)),
    (160073, (4.000, 12.769, 21.137)),
    (534438, (8.413, 12.047, 23.838)),
    (390602, (1.619, 10.179, 23.294)),
    (765715, (4.831, 13.396, 20.222)),
    (699852, (1.225, 16.454, 24.422)),
    (860293, (0.346, 14.940, 24.616)),
    (997162, (9.905, 11.663, 26.496)),
    (982143, (3.387, 12.373, 22.616)),
    (892086, (9.765, 17.090, 26.885)),
    (666418, (9.204, 11.727, 22.641)),
    (482615, (5.279, 10.294, 24.703)),
    (385282, (5.541, 13.395, 20.676)),
    (343709, (0.058, 12.516, 24.946)),
    (253824, (1.711, 18.498, 23.380)),
    (260785, (9.517, 14.069, 29.184)),
    (193404, (3.427, 19.276, 26.613)),
    (258579, (4.009, 18.188, 22.783)),
    (86016, (7.792, 14.582, 20.836)),
    (847966, (3.944, 19.802, 25.723)),
    (826983, (7.919, 12.460, 22.803)),
    (188560, (4.001, 13.391, 21.398)),
    (368155, (7.385, 10.874, 29.046)),
    (824422, (9.717, 16.575, 29.934)),
    (27769, (8.950, 15.004, 27.156)),
    (552087, (4.085, 17.795, 28.558)),
    (685824, (6.612, 13.162, 21.324)),
    (181832, (0.898, 12.995, 24.213)),
    (133678, (9.018, 13.406, 22.150)),
    (112093, (3.037, 10.524, 22.654)),
    (425873, (1.757, 16.852, 21.565)),
    (68225, (4.104, 18.379, 29.684)),
    (794317, (9.621, 12.723, 20.177)),
    (289162, (5.578, 13.200, 23.118)),
    (661975, (4.100, 15.408, 29.162)),
    (87862, (8.707, 10.669, 21.495)),
    (403282, (2.958, 11.273, 21.605)),
    (640855, (8.218, 16.276, 25.570)),
    (384807, (9.582, 11.979, 21.727)),
    (482934, (7.029, 16.407, 21.116)),
    (949677, (9.288, 12.249, 25.685)),
    (202434, (2.170, 17.569, 23.718)),
    (617810, (7.745, 18.774, 28.809)),
    (295154, (7.210, 18.072, 25.725)),
    (62618, (0.135, 19.031, 23.900)),
    (381860, (2.071, 17.451, 29.954)),
    (687138, (0.861, 14.979, 28.584)),
    (835289, (7.197, 17.818, 26.471)),
    (92676, (5.008, 16.684, 28.306)),
    (900918, (6.482, 12.071, 27.210)),
    (927870, (6.344, 13.226, 20.520)),
    (280573, (1.390, 12.517, 28.197)),
    (910535, (2.919, 11.935, 28.063)),
    (883231, (5.689, 11.998, 22.872)),
    (865103, (4.390, 17.006, 26.569)),
    (306395, (9.604, 11.481, 21.312)),
    (873949, (6.059, 14.755, 20.287)),
    (23599, (2.600, 13.917, 29.547)),
    (80866, (5.931, 18.322, 27.423)),
    (599220, (5.070, 19.228, 21.671)),
    (90764, (0.098, 18.343, 28.031)),
    (861703, (9.678, 13.033, 25.182)),
    (414676, (5.166, 11.035, 23.325)),
    (800993, (6.038, 11.739, 23.154)),
    (775227, (7.832, 12.696, 21.205)),
    (157783, (0.907, 17.098, 29.966)),
    (535161, (1.616, 13.238, 23.059)),
    (552461, (3.469, 14.145, 23.568)),
    (173609, (7.715, 13.876, 25.971)),
    (99424, (3.809, 16.725, 22.422)),
    (849902, (8.884, 17.493, 28.512)),
    (853909, (3.449, 13.912, 28.716)),
    (29142, (4.579, 19.639, 25.602)),
    (621281, (6.414, 17.674, 29.516)),
    (446866, (5.708, 15.830, 21.454)),
    (600208, (5.126, 19.498, 26.644)),
    (371077, (8.365, 16.224, 29.619)),
    (214278, (6.476, 11.684, 20.985)),
    (472922, (0.793, 16.603, 28.013)),
    (161598, (5.886, 15.387, 20.671)),
    (936926, (7.434, 10.404, 23.877)),
    (320088, (3.740, 12.900, 29.334)),
    (224723, (9.783, 18.002, 25.431)),
    (141652, (5.072, 10.966, 25.384)),
    (372600, (7.497, 18.386, 27.554)),
    (487201, (7.039, 16.552, 29.146)),
    (462890, (8.098, 15.553, 27.444)),
    (169458, (1.508, 19.719, 20.641)),
    (15695, (5.885, 18.547, 25.466)),
    (505048, (5.375, 18.800, 27.938)),
    (350867, (8.328, 14.019, 23.939)),
    (830960, (5.443, 11.270, 29.772)),
    (986466, (2.354, 10.628, 26.232)),
    (547008, (7.770, 12.219, 22.706)),
    (340307, (9.469, 12.472, 26.711)),
    (996336, (1.371, 11.308, 24.442)),
    (354945, (2.943, 10.117, 27.165)),
    (53953, (1.504, 10.609, 25.230)),
    (832409, (8.122, 14.809, 24.162)),
    (272073, (0.176, 15.737, 24.660)),
    (346052, (0.388, 18.936, 22.766)),
    (761695, (9.327, 10.446, 29.987)),
    (158220, (4.562, 13.658, 28.886)),
    (216563, (6.318, 14.394, 25.662)),
    (164426, (6.257, 10.537, 28.794)),
    (514748, (0.317, 17.796, 26.579)),
    (916907, (1.946, 19.158, 28.377)),
    (905109, (7.328, 19.481, 26.304)),
    (600607, (0.912, 18.349, 29.454)),
    (489816, (3.825, 10.967, 26.284)),
    (167906, (9.140, 10.496, 21.720)),
    (276417, (9.801, 19.736, 28.518)),
    (224938, (7.414, 16.350, 21.327)),
    (305211, (0.295, 16.908, 24.515)),
    (809898, (6.194, 12.731, 22.299)),
    (791356, (5.416, 16.831, 21.138)),
    (470749, (5.265, 12.677, 24.440)),
    (599455, (7.155, 12.963, 24.285)),
    (252214, (9.469, 11.011, 25.622)),
    (82762, (7.779, 15.604, 28.144)),
    (253265, (3.662, 16.795, 21.587)),
    (326663, (3.474, 12.972, 21.367)),
    (665051, (3.609, 17.361, 20.330)),
    (810716, (4.997, 11.704, 22.014)),
    (894758, (6.281, 17.359, 22.170)),
    (972829, (1.188, 14.880, 23.894)),
    (261774, (5.167, 16.807, 24.478)),
    (220736, (3.655, 18.071, 20.580)),
    (317832, (2.923, 18.879, 22.726)),
    (167530, (2.704, 17.085, 28.824)),
    (44213, (0.223, 14.296, 20.236)),
    (821613, (2.311, 13.546, 27.001)),
    (960818, (5.956, 13.680, 26.663)),
    (533484, (3.428, 16.925, 25.432)),
    (203548, (6.339, 19.435, 29.937)),
    (573780, (5.703, 16.470, 20.800)),
    (339386, (2.561, 13.380, 22.841)),
    (40801, (2.276, 17.986, 22.677)),
    (339038, (7.494, 17.653, 23.931)),
    (249801, (3.211, 11.961, 20.993)),
    (299172, (2.816, 16.530, 20.171)),
    (836919, (0.450, 13.944, 21.851)),
    (205805, (8.074, 11.013, 21.140)),
    (830849, (1.435, 11.779, 27.322)),
    (515028, (0.855, 12.269, 24.724)),
    (109921, (3.173, 12.183, 23.612)),
    (541918, (9.212, 17.526, 29.050)),
    (7251, (7.133, 10.736, 22.769)),
    (261153, (6.705, 18.461, 28.480)),
    (999640, (4.532, 16.997, 23.491)),
    (370202, (9.720, 11.024, 29.540)),
    (492596, (7.845, 11.013, 26.695)),
    (928074, (9.110, 15.130, 22.096)),
    (939004, (7.890, 13.411, 29.687)),
    (104996, (7.558, 17.808, 22.240)),
    (929806, (4.273, 15.184, 26.158)),
    (365117, (3.889, 17.093, 20.154)),
    (194075, (4.675, 15.902, 23.053)),
    (948664, (8.474, 19.736, 28.896)),
    (701530, (9.292, 17.288, 23.201)),
    (823060, (7.014, 12.738, 27.369)),
    (591772, (5.894, 12.257, 21.973)),
    (115076, (3.435, 10.034, 20.253)),
    (89996, (0.943, 18.006, 24.846)),
    (203200, (4.983, 17.661, 23.985)),
    (832127, (8.328, 12.911, 28.597)),
    (637165, (2.443, 18.344, 23.585)),
    (477092, (8.404, 17.224, 20.184)),
    (86130, (6.298, 18.665, 21.333)),
    (954122, (0.823, 17.430, 27.490)),
    (815280, (3.078, 11.003, 28.483)),
    (573111, (8.212, 16.464, 27.167)),
    (1292, (1.505, 11.760, 25.799)),
    (227601, (3.849, 19.367, 24.266)),
    (636724, (9.992, 19.328, 22.827)),
    (396350, (8.384, 14.047, 25.408)),
    (271555, (6.207, 18.914, 29.968)),
    (183099, (0.103, 18.684, 24.014)),
    (463385, (7.764, 12.266, 27.842)),
    (120471, (7.054, 11.617, 29.417)),
    (435441, (2.828, 13.985, 27.041)),
    (7892, (6.434, 10.090, 21.816)),
    (948299, (4.298, 12.904, 28.488)),
    (742481, (2.477, 11.715, 23.936)),
    (187817, (3.895, 10.568, 22.954)),
    (87112, (2.635, 18.375, 22.207)),
    (401560, (0.727, 15.268, 26.043)),
    (913534, (9.884, 14.229, 24.083)),
    (606285, (4.874, 16.859, 25.229)),
    (445483, (9.187, 10.961, 23.265)),
    (943123, (6.633, 11.264, 29.223)),
    (426545, (4.823, 13.947, 28.876)),
    (309869, (9.766, 12.318, 24.137)),
    (920000, (9.215, 10.181, 28.987)),
    (190533, (8.249, 18.993, 27.093)),
    (361958, (0.310, 16.989, 29.784)),
    (538526, (5.806, 15.725, 26.386)),
    (823052, (2.700, 16.587, 24.518)),
    (307263, (7.091, 19.945, 21.524)),
    (899710, (5.588, 12.251, 24.263)),
    (964091, (7.336, 17.084, 25.767)),
    (934719, (8.821, 11.739, 27.387)),
    (837822, (1.076, 13.748, 24.680)),
    (872563, (9.618, 10.167, 25.470)),
    (937146, (3.149, 19.560, 28.981)),
    (728840, (8.076, 17.771, 26.848)),
    (491230, (2.021, 12.603, 21.439)),
    (21335, (9.518, 12.465, 28.309)),
    (853474, (2.509, 11.899, 26.607)),
    (800609, (6.199, 12.865, 26.973)),
    (31678, (1.897, 10.893, 22.437)),
    (789691, (9.147, 14.708, 26.536)),
    (522842, (5.895, 17.314, 21.660)),
    (964406, (9.487, 14.729, 26.988)),
    (340870, (2.059, 16.964, 26.759)),
    (825728, (0.482, 12.208, 23.532)),
    (205880, (6.150, 18.697, 29.992)),
    (739088, (2.005, 18.317, 25.640)),
    (64095, (2.286, 13.820, 27.410)),
    (675767, (6.088, 11.027, 28.278)),
    (207469, (6.140, 11.915, 27.272)),
    (391153, (1.793, 15.223, 27.254)),
    (244550, (6.132, 19.428, 27.285)),
    (282766, (3.678, 17.548, 23.125)),
    (976401, (1.671, 10.751, 21.780)),
    (411436, (7.198, 17.021, 27.317)),
    (937601, (6.154, 19.889, 20.824)),
    (304813, (1.495, 14.872, 27.077)),
    (303684, (0.603, 11.298, 25.454)),
    (936743, (6.814, 17.957, 22.180)),
    (136342, (7.470, 15.707, 23.050)),
    (174468, (2.591, 18.733, 24.002)),
    (990527, (0.204, 13.437, 23.993)),
    (891671, (2.392, 11.829, 26.198)),
    (289998, (5.347, 10.139, 26.273)),
    (214584, (7.160, 14.534, 25.276)),
    (506955, (9.568, 14.787, 25.240)),
    (553299, (6.659, 17.039, 23.644)),
    (243430, (1.638, 14.783, 29.986)),
    (764996, (1.344, 14.248, 29.094)),
    (955089, (6.481, 10.664, 22.570)),
    (613070, (4.265, 12.598, 21.274)),
    (198009, (4.059, 17.727, 23.013)),
    (617969, (5.565, 11.881, 23.194)),
    (563641, (2.504, 12.074, 28.489)),
    (513470, (1.498, 12.907, 29.409)),
    (930141, (5.539, 11.723, 28.309)),
    (130904, (3.694, 12.072, 27.166)),
    (492379, (8.543, 12.876, 21.487)),
    (425867, (7.122, 18.767, 29.985)),
    (589538, (1.258, 17.715, 21.027)),
    (368582, (6.510, 10.088, 28.842)),
    (578054, (8.577, 11.586, 29.429)),
    (160764, (3.216, 13.551, 28.825)),
    (976876, (1.015, 19.820, 20.702)),
    (695891, (4.546, 12.704, 24.428)),
    (865067, (8.414, 16.823, 23.690)),
    (101631, (6.159, 15.513, 27.982)),
    (503599, (7.481, 12.476, 29.359)),
    (789994, (5.862, 17.510, 25.030)),
    (262392, (4.604, 10.424, 27.513)),
    (110621, (4.653, 18.850, 26.148)),
    (304637, (1.567, 16.171, 28.344)),
    (635053, (1.302, 16.815, 26.821)),
    (166848, (4.920, 13.100, 21.788)),
    (930465, (6.729, 17.779, 29.766)),
    (588785, (0.623, 16.139, 20.167)),
    (518972, (7.231, 12.161, 26.033)),
    (109231, (7.966, 18.571, 26.587)),
    (145638, (8.646, 15.829, 24.034)),
    (43288, (5.946, 10.043, 26.992)),
    (648808, (3.044, 13.305, 28.836)),
    (649641, (4.777, 11.216, 26.681)),
    (374142, (5.808, 11.963, 24.714)),
    (790320, (6.071, 15.299, 27.070)),
    (641957, (6.310, 17.065, 24.978)),
    (600007, (0.929, 18.487, 29.907)),
    (40354, (3.854, 18.114, 23.373)),
    (988519, (4.163, 19.409, 27.336)),
    (287900, (4.795, 10.349, 21.614)),
    (492969, (8.823, 16.283, 20.302)),
    (870762, (2.363, 10.145, 21.728)),
    (52475, (4.488, 12.448, 28.721)),
    (48092, (7.636, 15.881, 29.456)),
    (561509, (3.991, 10.947, 20.494)),
    (644705, (9.634, 11.674, 28.028)),
    (101352, (0.248, 18.045, 24.611)),
    (260651, (2.887, 12.156, 26.072)),
    (715760, (7.558, 10.850, 26.062)),
    (860532, (9.706, 10.829, 27.561)),
    (368733, (2.664, 13.081, 21.466)),
    (67370, (1.774, 15.120, 25.104)),
    (2741, (5.741, 14.051, 26.270)),
    (862276, (8.331, 15.975, 25.183)),
    (931289, (2.495, 17.545, 27.275)),
    (423261, (0.519, 17.877, 24.820)),
    (741493, (8.068, 19.619, 26.916)),
    (808214, (2.004, 10.808, 22.276)),
    (160134, (7.729, 15.027, 27.014)),
    (520885, (2.410, 10.599, 22.110)),
    (643205, (8.378, 11.671, 27.055)),
    (512482, (8.582, 11.480, 29.731)),
    (64968, (5.238, 16.263, 20.104)),
    (976984, (6.175, 14.746, 27.918)),
    (522821, (0.098, 13.625, 29.522)),
    (12463, (9.260, 18.204, 25.720)),
    (904361, (2.802, 15.718, 28.294)),
    (846774, (7.500, 14.374, 22.956)),
    (369210, (2.470, 10.309, 23.021)),
    (464866, (9.977, 11.616, 26.730)),
    (985541, (0.952, 16.436, 23.220)),
    (383758, (0.027, 18.003, 28.965)),
    (26201, (3.322, 15.286, 29.253)),
    (404263, (9.164, 19.024, 29.181)),
    (371194, (5.856, 12.847, 20.474)),
    (124829, (8.517, 13.074, 26.654)),
    (18664, (7.661, 10.057, 29.390)),
    (857190, (6.542, 18.059, 24.734)),
    (591352, (0.617, 15.581, 21.553)),
    (515328, (9.386, 12.538, 29.610)),
    (583570, (8.966, 19.567, 29.620)),
    (814073, (0.980, 19.062, 26.177)),
    (378922, (8.301, 14.190, 26.426)),
    (274643, (2.809, 11.238, 24.267)),
    (533034, (2.872, 15.756, 29.495)),
    (600515, (3.083, 18.685, 20.575)),
    (978842, (7.126, 10.241, 27.032)),
    (73422, (9.872, 10.504, 29.012)),
    (997054, (5.734, 10.731, 21.862)),
    (358825, (7.442, 11.791, 29.354)),
    (152580, (6.718, 10.549, 20.648)),
    (491264, (7.188, 19.689, 21.119)),
    (556586, (5.131, 16.903, 27.553)),
    (145740, (7.292, 12.558, 21.745)),
    (631900, (6.269, 15.502, 20.311)),
    (341637, (1.443, 13.520, 24.052)),
    (110887, (0.775, 14.422, 23.350)),
    (625767, (1.391, 13.700, 25.510)),
    (204868, (4.175, 15.274, 22.521)),
    (98852, (4.984, 16.639, 27.090)),
    (656729, (7.050, 11.472, 21.845)),
    (260734, (4.889, 17.079, 25.668)),
    (878452, (9.015, 14.972, 22.252)),
    (190670, (9.530, 13.222, 21.684)),
    (682596, (6.140, 12.683, 20.511)),
    (941701, (3.175, 14.025, 22.793)),
    (986461, (6.411, 19.344, 25.870)),
    (690524, (7.867, 13.997, 23.083)),
    (758903, (2.793, 12.190, 22.637)),
    (882329, (1.196, 12.828, 26.838)),
    (250693, (5.741, 13.626, 26.149)),
    (758286, (9.943, 10.569, 23.690)),
    (808231, (8.952, 10.284, 20.544)),
    (839057, (9.951, 12.123, 28.453)),
    (489731, (4.743, 18.404, 28.875)),
    (722502, (8.945, 12.804, 28.625)),
    (539082, (2.622, 19.542, 23.537)),
    (610754, (9.841, 12.213, 22.189)),
    (928543, (1.461, 18.322, 26.194)),
    (267187, (7.167, 17.977, 24.790)),
    (117546, (6.874, 16.167, 29.300)),
    (853774, (2.143, 13.454, 29.706)),
    (405054, (9.664, 19.483, 22.779)),
    (246447, (6.867, 15.824, 22.019)),
    (362757, (2.771, 16.324, 25.430)),
    (226329, (9.344, 14.898, 24.614)),
    (31186, (6.674, 12.260, 27.117)),
    (844517, (7.773, 16.256, 28.239)),
    (125956, (6.189, 17.954, 24.458)),
    (42695, (3.428, 13.060, 28.132)),
    (22635, (6.340, 17.113, 24.336)),
    (125604, (4.650, 18.216, 28.431)),
    (511300, (0.979, 12.341, 24.027)),
    (237321, (0.987, 10.561, 29.503)),
    (793312, (6.226, 17.832, 23.231)),
    (173948, (7.465, 19.496, 23.328)),
    (407002, (7.633, 15.173, 21.258)),
    (821627, (1.712, 13.472, 24.352)),
    (441914, (5.708, 10.225, 22.959)),
    (661051, (0.573, 11.558, 29.996)),
    (551479, (6.692, 16.447, 26.149)),
    (582080, (2.623, 17.395, 29.062)),
    (27779, (1.578, 15.649, 23.635)),
    (473114, (9.351, 13.801, 20.728)),
    (543384, (9.313, 12.665, 27.295)),
    (398796, (3.133, 16.868, 21.355)),
    (465478, (1.727, 19.906, 26.245)),
    (431253, (1.968, 19.159, 21.858)),
    (122234, (6.494, 11.204, 26.631)),
    (382558, (9.925, 15.906, 22.332)),
    (454066, (3.247, 16.809, 22.819)),
    (647628, (5.300, 10.286, 24.056)),
    (197868, (1.486, 13.861, 24.062)),
    (471169, (5.274, 10.119, 27.013)),
    (570446, (1.922, 15.654, 26.603)),
    (511934, (6.965, 16.395, 23.100)),
    (685092, (3.651, 15.320, 21.963)),
    (212410, (7.945, 18.212, 24.104)),
    (622032, (8.075, 13.269, 26.599)),
    (47767, (4.184, 17.771, 28.665)),
    (401336, (2.770, 14.279, 27.352)),
    (932638, (1.670, 17.708, 25.321)),
    (863570, (7.408, 18.576, 28.218)),
    (366202, (7.895, 15.691, 29.554)),
    (246261, (9.471, 12.401, 21.768)),
    (580958, (7.976, 11.434, 21.580)),
    (262732, (8.279, 12.871, 25.669)),
    (830776, (5.506, 10.364, 21.105)),
    (967649, (7.728, 15.734, 27.360)),
    (916065, (2.697, 17.950, 26.612)),
    (619642, (0.462, 11.182, 24.756)),
    (721322, (9.163, 15.909, 28.029)),
    (523945, (1.241, 10.600, 25.479)),
    (780083, (2.793, 17.043, 24.058)),
    (440218, (3.524, 19.148, 20.991)),
    (732220, (5.365, 13.002, 23.622)),
    (998416, (8.744, 11.478, 21.728)),
    (490724, (3.966, 11.010, 20.108)),
    (21707, (3.383, 15.566, 27.672)),
    (491242, (6.598, 14.806, 22.114)),
    (514239, (2.949, 19.182, 26.433)),
    (831069, (2.435, 12.416, 24.189)),
    (42860, (6.646, 17.533, 26.513)),
    (453150, (7.180, 19.873, 26.156)),
    (316245, (2.711, 14.391, 29.609)),
    (499004, (5.538, 15.105, 23.103)),
    (633802, (0.550, 11.136, 28.437)),
    (974354, (0.987, 17.439, 22.757)),
    (309809, (1.680, 18.099, 24.852)),
    (786021, (9.329, 15.112, 21.040)),
    (995779, (6.455, 11.336, 20.140)),
    (490498, (7.880, 11.304, 23.240)),
    (535173, (3.749, 13.442, 28.688)),
    (803862, (5.653, 19.322, 21.944)),
    (520383, (5.728, 16.786, 20.309)),
    (764016, (9.241, 12.694, 29.697)),
    (304521, (9.597, 19.243, 23.377)),
    (486041, (7.622, 13.060, 21.126)),
    (41057, (7.786, 19.520, 24.533)),
    (966717, (9.748, 19.195, 21.338)),
    (569435, (2.359, 10.600, 26.474)),
    (595378, (9.105, 14.622, 28.332)),
    (190411, (6.237, 15.463, 28.941)),
    (539550, (6.482, 16.268, 23.554)),
    (570893, (7.763, 10.294, 26.021)),
    (694634, (8.774, 18.987, 24.014)),
    (307866, (1.871, 15.014, 21.745)),
    (169600, (0.817, 11.321, 20.559)),
    (489178, (5.903, 11.717, 26.853)),
    (517728, (2.102, 12.320, 21.655)),
    (482439, (1.086, 11.721, 29.214)),
    (902322, (8.373, 19.633, 23.625)),
    (161344, (9.710, 13.158, 20.087)),
    (984948, (0.857, 14.377, 20.319)),
    (54822, (7.290, 12.486, 24.448)),
    (499605, (0.711, 15.606, 24.116)),
    (75809, (6.814, 10.582, 24.841)),
    (532654, (4.838, 14.756, 20.019)),
    (733774, (2.770, 14.679, 28.983)),
    (495670, (1.283, 16.834, 25.699)),
    (509610, (6.361, 12.046, 22.351)),
    (552089, (4.359, 12.316, 21.417)),
    (885932, (6.308, 13.577, 20.861)),
    (811124, (6.654, 18.248, 25.293)),
    (534814, (2.803, 19.860, 26.098)),
    (74770, (1.940, 18.521, 22.140)),
    (547678, (0.821, 10.752, 22.455)),
    (466505, (7.806, 11.466, 24.814)),
    (103404, (4.493, 11.604, 27.141)),
    (229480, (9.655, 11.340, 29.776)),
    (639301, (1.652, 15.689, 25.622)),
    (127016, (2.933, 13.241, 25.622)),
    (812292, (1.266, 10.677, 29.128)),
    (78988, (3.613, 11.951, 27.601)),
    (3060, (7.240, 12.925, 26.761)),
    (882963, (8.440, 15.068, 27.964)),
    (951811, (1.939, 11.644, 21.980)),
    (681336, (6.322, 19.903, 25.377)),
    (658478, (6.473, 19.082, 23.199)),
    (290627, (6.063, 19.818, 26.875)),
    (626375, (9.946, 12.466, 24.088)),
    (654302, (1.944, 13.041, 21.657)),
    (140354, (7.814, 12.705, 29.262)),
    (359057, (6.239, 15.094, 21.630)),
    (778590, (1.635, 17.853, 25.213)),
    (208136, (3.319, 11.831, 20.643)),
    (915266, (2.426, 12.408, 22.081)),
    (189380, (0.624, 17.116, 29.719)),
    (162859, (4.477, 15.849, 24.227)),
    (865887, (1.682, 10.367, 26.388)),
    (394165, (8.008, 13.355, 21.546)),
    (610102, (7.033, 18.206, 22.001)),
    (288886, (8.612, 14.626, 20.311)),
    (180432, (2.021, 14.717, 23.829)),
    (915660, (9.560, 15.171, 21.681)),
    (742156, (8.213, 12.144, 29.959)),
    (392541, (2.455, 16.941, 28.156)),
    (740213, (7.408, 12.658, 26.712)),
    (203939, (5.437, 13.735, 29.531)),
    (482450, (2.240, 11.755, 20.427)),
    (749718, (5.300, 13.640, 25.495)),
    (443526, (3.305, 19.382, 24.001)),
    (374205, (1.233, 14.345, 20.170)),
    (849847, (2.701, 13.231, 29.888)),
    (89049, (6.644, 15.613, 23.992)),
    (844071, (4.148, 14.460, 28.140)),
    (22738, (7.451, 15.548, 24.524)),
    (738966, (0.132, 19.446, 21.105)),
    (952240, (7.268, 19.504, 22.737)),
    (59729, (2.962, 11.981, 23.040)),
    (931667, (4.027, 13.390, 29.706)),
    (815520, (8.812, 11.330, 20.107)),
    (984494, (4.536, 15.611, 20.225)),
    (447182, (1.006, 16.233, 20.949)),
    (214709, (1.463, 14.805, 29.251)),
    (580445, (2.038, 16.194, 23.315)),
    (988156, (3.786, 19.602, 21.686)),
    (994405, (6.843, 18.330, 26.094)),
    (604212, (2.535, 16.215, 21.298)),
    (228885, (3.006, 12.346, 29.427)),
    (609796, (4.996, 15.293, 29.633)),
    (965288, (6.176, 14.693, 22.686)),
    (216747, (3.528, 10.166, 29.454)),
    (363731, (2.953, 14.000, 25.907)),
    (601650, (1.865, 14.832, 23.317)),
    (719596, (4.529, 16.282, 24.314)),
    (262727, (7.604, 15.729, 21.143)),
    (59567, (5.971, 14.356, 23.479)),
    (264832, (8.591, 10.863, 25.061)),
    (389861, (2.035, 18.216, 20.480)),
    (628387, (2.523, 19.397, 29.685)),
    (699187, (5.842, 14.251, 22.733)),
    (194055, (9.687, 18.016, 20.064)),
    (32234, (9.380, 12.916, 20.309)),
    (387665, (1.191, 11.406, 26.152)),
    (320601, (7.210, 12.030, 24.184)),
    (703072, (7.412, 10.754, 25.362)),
    (628372, (1.969, 18.297, 22.220)),
    (610931, (4.207, 16.532, 26.773)),
    (596640, (8.806, 17.598, 27.256)),
    (484380, (6.271, 15.420, 27.582)),
    (608711, (8.381, 14.920, 23.401)),
    (740579, (4.129, 10.974, 21.834)),
    (255827, (3.641, 16.942, 29.717)),
    (708799, (4.021, 13.106, 22.752)),
    (280014, (1.037, 11.115, 26.829)),
    (623030, (4.373, 18.310, 26.201)),
    (490321, (3.791, 16.634, 28.170)),
    (908216, (7.307, 16.954, 21.328)),
    (980404, (9.938, 16.179, 24.890)),
    (345651, (3.869, 12.354, 27.161)),
    (670444, (0.592, 11.372, 27.171)),
    (948745, (3.030, 15.027, 24.731)),
    (964593, (0.658, 11.118, 27.883)),
    (444201, (0.977, 14.108, 22.107)),
    (515899, (4.587, 12.735, 28.473)),
    (86574, (8.891, 17.233, 22.106)),
    (231330, (5.202, 19.403, 20.429)),
    (12268, (4.840, 12.165, 28.634)),
    (164855, (2.026, 18.971, 24.218)),
    (245351, (9.989, 16.073, 20.675)),
    (784015, (0.204, 18.180, 24.023)),
    (248858, (0.938, 17.115, 29.406)),
    (421011, (1.479, 19.741, 22.485)),
    (464684, (2.601, 12.224, 29.239)),
    (64508, (4.962, 19.198, 23.589)),
    (2077, (4.907, 19.582, 29.614)),
    (606904, (9.783, 13.222, 21.718)),
    (857483, (5.485, 11.531, 20.411)),
    (742182, (6.716, 15.043, 26.087)),
    (262937, (8.666, 15.339, 29.620)),
    (421102, (6.912, 19.989, 29.860)),
    (47222, (8.657, 19.919, 21.893)),
    (501344, (5.470, 12.896, 29.203)),
    (110826, (5.217, 13.408, 28.804)),
    (328915, (4.825, 10.212, 25.196)),
    (632003, (7.150, 15.207, 20.487)),
    (228514, (2.605, 11.618, 24.697)),
    (973353, (0.347, 19.666, 28.460)),
    (942142, (3.054, 19.369, 29.595)),
    (855276, (1.051, 18.016, 27.429)),
    (779846, (8.449, 17.341, 28.337)),
    (834322, (7.900, 18.679, 24.037)),
    (717710, (2.098, 14.647, 21.865)),
    (412337, (2.631, 10.456, 28.562)),
    (955876, (0.495, 16.303, 27.238)),
    (642276, (9.664, 17.819, 28.670)),
    (848657, (3.499, 10.024, 22.877)),
    (73444, (3.734, 11.798, 23.150)),
    (887184, (7.083, 18.270, 21.138)),
    (547827, (4.507, 19.726, 24.609)),
    (1051, (9.155, 19.120, 28.565)),
    (35677, (7.923, 15.455, 29.934)),
    (695625, (3.317, 13.139, 20.314)),
    (903449, (0.149, 19.045, 29.148)),
    (575603, (3.931, 14.880, 26.900)),
    (854859, (1.358, 15.104, 23.076)),
    (523850, (7.749, 13.267, 24.097)),
    (744299, (1.067, 16.653, 23.262)),
    (112980, (4.338, 12.820, 20.539)),
    (666005, (6.307, 17.368, 26.969)),
    (467904, (5.225, 17.603, 27.651)),
    (932944, (4.399, 16.971, 26.807)),
    (563062, (8.688, 10.549, 28.155)),
    (959621, (5.204, 17.727, 22.194)),
    (477637, (9.355, 17.458, 29.952)),
    (734546, (5.922, 18.600, 25.296)),
    (986041, (2.779, 16.217, 25.531)),
    (146188, (5.701, 17.507, 27.266)),
    (141284, (9.570, 17.007, 22.673)),
    (347459, (5.423, 18.793, 24.144)),
    (65891, (2.436, 13.258, 26.017)),
    (238394, (3.974, 19.015, 24.338)),
    (113894, (3.962, 19.580, 23.236)),
    (902860, (1.496, 12.263, 29.185)),
    (790874, (1.675, 15.576, 28.098)),
    (489965, (7.142, 18.937, 29.765)),
    (26662, (4.442, 19.476, 21.212)),
    (514720, (7.863, 19.315, 26.600)),
    (662453, (6.939, 11.932, 29.936)),
    (898814, (8.262, 19.872, 22.897)),
    (513293, (5.517, 13.100, 26.762)),
    (100722, (6.992, 11.594, 23.454)),
    (79914, (5.841, 19.312, 27.746)),
    (67791, (2.203, 12.742, 29.973)),
    (948099, (9.813, 15.733, 28.328)),
    (373765, (8.725, 10.010, 25.480)),
    (557836, (5.983, 14.435, 20.993)),
    (132335, (5.186, 12.814, 23.454)),
    (920018, (1.313, 12.827, 22.728)),
    (171738, (7.447, 10.238, 23.842)),
    (878111, (9.398, 19.463, 21.687)),
    (309969, (1.878, 18.048, 25.266)),
    (693352, (0.988, 11.525, 29.981)),
    (753069, (0.360, 18.893, 24.037)),
    (509266, (3.685, 18.410, 28.203)),
    (939904, (3.701, 17.077, 24.864)),
    (766821, (0.310, 13.947, 24.737)),
    (296662, (8.945, 19.390, 28.633)),
    (367413, (2.430, 14.262, 21.253)),
    (264782, (7.438, 12.761, 29.029)),
    (692255, (0.724, 16.518, 22.755)),
    (275576, (2.835, 17.539, 27.847)),
    (590074, (7.362, 13.033, 29.793)),
    (788675, (7.644, 13.622, 29.118)),
    (211748, (1.440, 12.103, 25.975)),
    (88317, (5.824, 18.656, 21.367)),
    (91294, (3.833, 14.597, 26.466)),
    (249535, (9.660, 18.648, 23.380)),
    (32265, (2.619, 12.064, 24.449)),
    (390013, (8.041, 16.005, 22.624)),
    (269350, (3.801, 15.696, 26.747)),
    (777817, (9.703, 19.015, 23.982)),
    (922415, (9.930, 17.313, 22.120)),
    (691586, (3.794, 11.853, 28.310)),
    (656214, (6.564, 18.469, 29.774)),
    (106855, (1.559, 17.024, 20.557)),
    (134166, (2.856, 17.314, 20.782)),
    (664032, (5.773, 11.629, 26.751)),
    (30181, (0.647, 10.566, 20.565)),
    (555633, (9.199, 12.107, 22.289)),
    (633483, (3.765, 14.426, 25.307)),
    (941412, (2.550, 15.487, 28.847)),
    (278751, (4.005, 13.575, 24.654)),
    (812196, (1.615, 17.264, 27.928)),
    (929709, (7.254, 15.262, 23.137)),
    (742718, (4.673, 13.708, 22.982)),
    (188756, (0.695, 11.946, 22.038)),
    (834507, (7.338, 12.228, 23.513)),
    (48748, (1.145, 15.336, 25.054)),
    (423714, (7.630, 12.140, 24.101)),
    (588311, (9.961, 18.801, 20.963)),
    (614609, (7.174, 13.201, 26.102)),
    (404952, (8.235, 16.154, 23.397)),
    (994160, (1.842, 18.621, 24.089)),
    (691646, (9.008, 10.154, 23.864)),
    (750801, (7.688, 11.684, 22.197)),
    (289378, (0.509, 10.106, 29.902)),
    (111703, (3.307, 16.671, 26.979)),
    (548326, (9.165, 14.205, 23.078)),
    (102774, (8.154, 17.391, 20.895)),
    (697852, (8.547, 12.070, 20.693)),
    (914022, (0.394, 18.787, 22.810)),
    (658331, (8.501, 10.093, 26.173)),
    (223709, (0.078, 12.380, 26.428)),
    (722733, (9.074, 15.290, 25.566)),
    (202454, (2.499, 18.271, 27.015)),
    (35887, (1.841, 16.572, 22.247)),
    (706622, (2.517, 10.517, 20.356)),
    (467416, (6.211, 19.864, 28.336)),
    (746108, (3.594, 13.973, 25.729)),
    (450094, (4.905, 14.334, 25.211)),
    (188829, (8.034, 14.213, 29.410)),
    (599562, (1.740, 12.082, 21.850)),
    (350766, (6.849, 18.336, 29.710)),
    (196603, (2.744, 14.159, 22.785)),
    (945304, (3.272, 11.802, 23.015)),
    (286648, (0.009, 18.380, 28.650)),
    (389507, (7.336, 14.976, 27.075)),
    (484139, (1.870, 19.813, 21.899)),
    (551353, (7.683, 19.856, 24.461)),
    (883292, (5.360, 15.820, 22.541)),
    (366995, (3.110, 17.854, 22.609)),
    (798644, (7.093, 14.782, 26.737)),
    (689293, (8.937, 11.981, 29.610)),
    (870038, (4.084, 18.944, 27.960)),
    (685271, (3.710, 17.018, 27.981)),
    (576069, (0.967, 15.732, 24.770)),
    (803632, (4.780, 19.853, 24.000)),
    (221815, (8.219, 10.534, 28.518)),
    (824354, (9.106, 19.819, 20.039)),
    (706401, (9.362, 12.643, 24.535)),
    (836177, (6.026, 14.929, 20.629)),
    (488618, (1.616, 12.993, 29.730)),
    (907428, (0.496, 18.756, 21.827)),
    (965950, (8.121, 18.555, 26.125)),
    (118956, (1.170, 10.966, 23.414)),
    (191846, (4.947, 12.867, 28.412)),
    (872023, (1.191, 18.704, 21.603)),
    (684174, (5.843, 11.994, 27.478)),
    (384331, (1.441, 11.071, 25.332)),
    (843992, (7.276, 13.424, 23.802)),
    (960810, (3.342, 14.748, 25.505)),
    (598321, (7.020, 14.131, 22.187)),
    (867152, (2.137, 11.697, 26.884)),
    (748078, (4.589, 18.199, 21.929)),
    (19932, (1.940, 17.653, 26.941)),
    (327763, (9.262, 17.866, 29.760)),
    (633573, (6.580, 19.963, 28.040)),
    (517705, (4.204, 11.459, 23.225)),
    (820583, (1.981, 11.274, 24.555)),
    (907486, (0.491, 16.715, 22.334)),
    (583714, (6.627, 16.896, 29.880)),
    (245180, (9.345, 17.776, 23.435)),
    (304221, (2.609, 17.335, 26.409)),
    (678963, (7.740, 16.122, 20.739)),
    (28583, (6.206, 12.372, 25.199)),
    (507475, (3.457, 17.390, 29.487)),
    (685959, (3.904, 10.049, 29.268)),
    (386050, (5.777, 15.574, 24.950)),
    (689236, (4.796, 16.221, 21.548)),
    (45176, (4.895, 19.633, 29.359)),
    (857844, (8.297, 11.484, 25.285)),
    (955763, (4.715, 19.101, 20.726)),
    (644161, (5.675, 12.990, 28.226)),
    (756712, (9.590, 13.839, 25.284)),
    (183520, (1.284, 12.074, 22.956)),
    (200334, (6.213, 17.346, 20.311)),
    (219979, (3.065, 15.877, 22.981)),
    (184151, (0.796, 14.385, 24.452)),
    (68761, (1.036, 18.850, 25.730)),
    (992889, (9.598, 12.797, 23.703)),
    (573695, (8.601, 15.041, 26.838)),
    (620362, (9.489, 19.230, 28.671)),
    (495286, (4.078, 11.525, 22.548)),
    (557785, (7.624, 17.124, 28.313)),
    (246041, (5.185, 13.006, 23.671)),
    (661744, (5.679, 15.066, 21.379)),
    (874202, (6.813, 19.503, 22.463)),
    (307130, (7.917, 15.515, 21.794)),
    (555728, (4.782, 12.413, 24.807)),
    (635431, (9.375, 13.143, 22.708)),
    (34349, (7.527, 12.650, 23.564)),
    (614695, (1.012, 14.238, 29.555)),
    (867705, (1.160, 19.431, 25.676)),
    (387855, (7.956, 18.964, 24.834)),
    (398024, (0.679, 19.864, 21.821)),
    (474601, (6.511, 13.080, 28.098)),
    (685555, (5.455, 14.076, 28.494)),
    (552098, (9.633, 16.984, 26.221)),
    (965204, (8.732, 18.795, 28.463)),
    (855552, (6.707, 14.500, 22.241)),
    (365532, (9.678, 10.712, 20.356)),
    (67139, (6.555, 13.145, 20.950)),
    (275635, (4.472, 13.209, 22.418)),
    (324012, (8.235, 10.545, 20.220)),
    (602573, (5.781, 19.304, 23.790)),
    (272695, (6.064, 17.179, 25.647)),
    (901039, (7.408, 13.658, 26.966)),
    (963123, (6.267, 12.517, 27.640)),
    (736675, (1.842, 10.676, 24.757)),
    (791958, (5.206, 13.182, 25.198)),
    (445562, (0.734, 18.429, 26.296)),
    (630971, (0.732, 17.398, 23.511)),
    (117787, (3.232, 18.299, 24.650)),
    (361522, (7.815, 19.286, 26.108)),
    (750240, (7.162, 17.166, 23.941)),
    (256464, (3.555, 18.960, 22.947)),
    (693788, (2.165, 13.442, 24.060)),
    (659279, (0.815, 10.815, 23.950)),
    (597180, (7.235, 14.367, 24.118)),
    (180569, (9.356, 11.337, 25.672)),
    (939984, (4.157, 16.540, 27.941)),
    (685177, (8.019, 14.821, 29.408)),
    (796266, (9.452, 16.204, 22.780)),
    (791780, (6.463, 13.022, 26.822)),
    (200470, (2.352, 13.382, 22.949)),
    (21811, (7.515, 10.178, 27.008)),
    (563663, (2.324, 12.885, 28.174)),
    (109393, (0.308, 18.964, 29.498)),
    (898100, (5.678, 10.674, 27.079)),
    (948142, (4.236, 18.181, 22.732)),
    (319827, (0.413, 17.048, 29.487)),
    (969408, (9.294, 10.685, 28.609)),
    (283742, (5.747, 13.910, 20.610)),
    (621908, (1.579, 14.583, 25.298)),
    (220626, (4.435, 19.210, 21.797)),
    (969485, (1.694, 16.120, 22.843)),
    (866131, (6.804, 18.029, 21.678)),
    (144885, (8.147, 13.125, 21.779)),
    (880517, (7.695, 12.580, 24.135)),
    (426193, (0.650, 11.461, 21.687)),
    (56462, (4.733, 19.481, 22.258)),
    (698125, (1.583, 10.640, 28.179)),
    (936488, (3.989, 10.959, 29.520)),
    (869004, (9.216, 13.171, 22.610)),
    (113368, (7.147, 17.696, 29.080)),
    (824502, (7.007, 11.550, 22.663)),
    (667807, (2.441, 12.254, 27.156)),
    (300686, (6.252, 12.547, 25.525)),
    (959570, (2.447, 11.999, 28.282)),
    (85365, (4.475, 15.175, 22.724)),
    (640895, (3.445, 17.480, 20.598)),
    (583223, (3.704, 17.514, 25.325)),
    (830726, (6.542, 18.872, 20.563)),
    (785829, (2.890, 13.350, 22.414)),
    (264798, (1.228, 12.116, 21.646)),
    (9073, (9.264, 17.718, 27.162)),
    (502436, (1.051, 12.418, 27.513)),
    (349943, (6.777, 11.460, 28.179)),
    (871508, (4.936, 13.980, 23.424)),
    (205962, (9.310, 11.688, 27.852)),
    (59648, (4.761, 15.435, 21.272)),
    (962156, (5.143, 15.725, 20.934)),
    (253824, (6.508, 11.209, 28.393)),
    (617040, (6.799, 12.751, 21.511)),
    (571765, (0.237, 14.790, 22.974)),
    (673496, (9.397, 11.789, 23.979)),
    (264256, (5.334, 13.610, 21.964)),
    (217887, (5.803, 12.802, 20.751)),
    (139354, (0.743, 15.914, 25.026)),
    (224064, (6.531, 15.255, 29.251)),
    (401165, (9.089, 16.723, 22.479)),
    (994901, (7.760, 12.232, 23.014)),
    (728634, (2.836, 15.482, 20.910)),
    (468993, (0.161, 16.887, 21.761)),
    (745842, (7.711, 11.622, 23.656)),
    (828527, (0.292, 18.128, 27.147)),
    (305823, (3.156, 14.140, 20.903)),
    (178186, (4.321, 15.624, 28.161)),
    (202237, (1.175, 16.473, 20.529)),
    (484976, (6.478, 10.713, 25.460)),
    (221744, (7.397, 18.801, 26.438)),
    (875232, (0.921, 16.461, 23.918)),
    (844463, (1.340, 15.741, 23.004)),
    (951504, (0.963, 19.101, 26.583)),
    (754076, (2.541, 17.654, 27.005)),
    (528237, (8.400, 14.855, 28.953)),
    (685482, (3.039, 17.223, 20.709)),
    (13993, (5.093, 17.363, 27.484)),
    (497625, (6.364, 11.635, 26.026)),
    (557359, (9.187, 11.845, 21.483)),
    (515212, (7.348, 10.027, 22.435)),
    (191015, (1.933, 16.863, 29.473)),
    (700317, (7.441, 19.286, 23.702)),
    (530353, (0.753, 10.631, 27.441)),
    (147017, (8.353, 10.917, 20.923)),
    (273807, (8.026, 14.559, 28.461)),
    (378938, (4.902, 11.892, 27.048)),
    (620488, (5.096, 17.037, 25.849)),
    (125428, (4.152, 10.717, 21.307)),
    (592349, (7.702, 18.924, 21.934)),
    (547797, (3.312, 16.015, 21.305)),
    (167906, (7.516, 17.850, 29.313)),
    (267597, (1.338, 17.624, 29.661)),
    (306803, (7.423, 10.088, 22.368)),
    (949364, (0.028, 15.831, 27.155)),
    (496914, (1.545, 10.281, 28.475)),
    (779085, (9.425, 18.022, 20.249)),
    (833354, (2.488, 15.084, 22.759)),
    (856538, (5.259, 14.132, 23.483)),
    (446530, (3.770, 18.698, 25.987)),
    (885697, (8.743, 16.165, 28.568)),
    (231627, (9.037, 18.947, 28.403)),
    (114174, (0.555, 11.647, 22.805)),
    (883950, (6.494, 11.080, 26.450)),
    (92786, (3.847, 13.432, 20.515)),
    (165391, (2.553, 15.301, 29.799)),
    (732110, (8.521, 19.552, 23.976)),
    (916822, (2.871, 15.174, 24.494)),
    (605945, (1.501, 18.309, 25.984)),
    (965737, (5.293, 16.549, 22.846)),
    (832609, (6.880, 17.210, 22.151)),
    (268694, (0.326, 10.161, 21.559)),
    (82212, (3.207, 17.250, 28.202)),
    (187572, (3.378, 15.527, 21.793)),
    (887523, (4.035, 11.821, 21.138)),
    (928259, (5.707, 13.492, 29.566)),
    (611825, (5.277, 12.869, 29.123)),
    (947512, (2.088, 18.480, 29.967)),
    (942028, (8.768, 13.270, 20.239)),
    (509682, (5.312, 15.407, 22.741)),
    (777145, (1.877, 19.767, 26.189)),
    (264787, (8.503, 19.212, 28.537)),
    (71161, (2.868, 11.696, 22.800)),
    (379593, (4.414, 13.082, 27.604)),
    (660926, (6.376, 18.565, 28.551)),
    (801439, (1.719, 10.372, 26.970)),
    (989444, (6.723, 18.842, 26.449)),
    (899421, (1.019, 16.497, 28.487)),
    (392251, (9.325, 11.072, 23.933)),
    (605556, (9.377, 11.604, 23.877)),
    (926340, (9.378, 19.855, 24.035)),
    (84413, (8.071, 14.765, 29.518)),
    (601258, (9.251, 13.508, 27.740)),
    (365406, (4.160, 19.670, 24.031)),
    (945772, (5.132, 13.564, 23.434)),
    (948964, (9.093, 11.346, 20.824)),
    (666419, (1.053, 16.110, 21.088)),
    (334995, (2.976, 11.823, 24.522)),
    (70784, (6.375, 15.728, 20.092)),
    (775817, (2.044, 11.742, 28.260)),
    (802529, (2.306, 10.050, 24.884)),
    (186342, (2.753, 12.413, 23.142)),
    (607843, (3.470, 12.686, 27.637)),
    (428116, (9.003, 12.813, 28.933)),
    (741831, (0.998, 16.775, 25.642)),
    (116015, (9.202, 19.525, 21.994)),
    (476894, (8.172, 19.208, 27.110)),
    (81304, (3.028, 18.064, 29.604)),
    (950135, (6.840, 17.307, 20.118)),
    (805154, (5.147, 14.613, 27.600)),
    (701600, (0.024, 18.286, 21.295)),
    (347218, (5.681, 17.129, 27.896)),
    (747224, (5.528, 15.843, 24.309)),
    (121153, (2.141, 12.806, 28.548)),
    (621224, (5.821, 18.458, 24.372)),
    (45845, (8.835, 17.137, 22.156)),
    (298248, (9.531, 15.758, 27.075)),
    (217394, (6.521, 13.504, 29.534)),
    (224420, (4.819, 19.166, 26.382)),
    (625670, (7.327, 18.983, 29.310)),
    (476568, (1.914, 19.087, 27.070)),
    (695701, (8.537, 12.562, 26.360)),
    (481281, (0.312, 13.127, 25.024)),
    (963179, (9.328, 17.658, 26.234)),
    (296173, (1.160, 10.115, 22.980)),
    (12039, (9.343, 11.387, 26.388)),
    (644998, (2.187, 13.257, 22.414)),
    (630124, (2.402, 13.853, 28.533)),
    (418635, (5.249, 17.110, 27.648)),
    (720131, (7.341, 17.479, 28.205)),
    (36409, (3.988, 16.173, 24.747)),
    (926459, (2.706, 18.852, 23.212)),
    (548282, (9.040, 13.996, 27.786)),
    (160199, (8.377, 18.240, 26.649)),
    (362981, (1.416, 18.364, 21.666)),
    (191147, (7.792, 17.522, 25.602)),
    (379376, (9.721, 13.654, 26.559)),
    (755789, (3.724, 12.883, 20.928)),
    (694923, (0.839, 18.849, 25.009)),
    (460474, (0.890, 10.246, 29.249)),
    (979352, (1.393, 12.281, 21.550)),
    (221654, (8.367, 16.293, 25.987)),
    (705269, (5.722, 19.276, 29.682)),
    (942390, (9.149, 15.021, 28.757)),
    (282555, (5.503, 14.576, 28.225)),
    (289594, (9.291, 17.149, 26.888)),
    (96718, (9.531, 10.076, 20.270)),
    (219990, (3.615, 18.186, 23.877)),
    (992, (2.102, 10.947, 28.996)),
    (517910, (1.096, 14.477, 25.362)),
    (829159, (6.680, 10.537, 24.490)),
    (657885, (6.992, 15.951, 25.769)),
    (36666, (6.470, 15.151, 22.012)),
    (632138, (1.370, 10.103, 22.403)),
    (164969, (2.711, 18.578, 24.728)),
    (977047, (1.484, 11.296, 22.717)),
    (80018, (1.268, 10.936, 25.891)),
    (611030, (0.680, 15.489, 22.190)),
    (266118, (6.614, 18.424, 28.199)),
    (909927, (5.443, 12.118, 24.349)),
    (347451, (0.477, 14.954, 25.749)),
    (484298, (3.651, 13.010, 22.520)),
    (601952, (9.835, 11.249, 24.862)),
    (561308, (4.726, 12.278, 22.001)),
    (476516, (7.843, 11.146, 28.312)),
    (599706, (7.485, 10.608, 20.570)),
    (14614, (7.137, 15.811, 27.002)),
    (669601, (1.363, 16.801, 21.421)),
    (569571, (2.525, 11.803, 27.587)),
    (551537, (4.602, 13.217, 29.721)),
    (791122, (0.986, 11.554, 24.763)),
    (695228, (3.364, 13.848, 24.489)),
    (708457, (5.301, 13.325, 24.961)),
    (344047, (4.600, 14.890, 28.996)),
    (512566, (5.424, 12.576, 24.191)),
    (744259, (5.047, 17.644, 23.682)),
    (210288, (3.425, 15.038, 24.902)),
    (370032, (7.182, 16.145, 23.976)),
    (1592, (9.402, 12.228, 29.990)),
    (461274, (3.039, 16.740, 27.758)),
    (220479, (1.901, 17.017, 22.210)),
    (620984, (6.375, 11.428, 22.814)),
    (701894, (9.882, 13.418, 25.507)),
    (589041, (6.387, 16.084, 28.042)),
    (710379, (9.366, 11.664, 29.828)),
    (797869, (2.803, 14.552, 21.469)),
    (347303, (4.956, 10.555, 28.816)),
    (196670, (4.168, 16.886, 24.917)),
    (610962, (8.963, 17.397, 22.388)),
    (830875, (3.851, 16.224, 21.837)),
    (74176, (0.042, 10.480, 26.552)),
    (117111, (4.457, 19.639, 28.111)),
    (453514, (7.807, 11.133, 29.002)),
    (188470, (5.791, 15.440, 27.548)),
    (281342, (7.122, 14.425, 24.345)),
    (597621, (6.051, 14.509, 28.073)),
    (511968, (9.329, 12.353, 29.263)),
    (748654, (5.226, 19.208, 24.781)),
    (71022, (0.211, 17.247, 22.308)),
    (897745, (3.085, 19.869, 22.276)),
    (739140, (5.138, 10.742, 20.049)),
    (896470, (3.999, 10.170, 28.738)),
    (411070, (7.906, 16.086, 26.262)),
    (986627, (3.524, 19.167, 23.949)),
    (329770, (1.145, 11.145, 23.464)),
    (156006, (0.131, 17.525, 22.079)),
    (691078, (1.886, 11.059, 28.561)),
    (340652, (4.580, 19.358, 22.246)),
    (890436, (9.222, 12.966, 22.886)),
    (533373, (3.864, 16.183, 25.103)),
    (455380, (0.560, 10.645, 25.997)),
    (441702, (6.494, 17.411, 23.779)),
    (641418, (1.321, 16.949, 22.127)),
    (998419, (4.618, 17.944, 21.857)),
    (173706, (3.819, 13.825, 20.805)),
    (463858, (1.234, 11.767, 22.407)),
    (249319, (7.340, 19.540, 22.999)),
    (682259, (9.219, 12.461, 20.801)),
    (440935, (8.407, 10.457, 21.676)),
    (174101, (2.710, 19.975, 25.594)),
    (563183, (9.310, 11.469, 28.569)),
    (906319, (1.170, 19.141, 29.164)),
    (940226, (5.542, 15.456, 26.057)),
    (804, (0.969, 14.991, 29.543)),
    (423092, (6.558, 11.858, 29.528)),
    (9505, (9.074, 13.569, 20.177)),
    (30914, (8.744, 14.659, 25.425)),
    (526995, (2.918, 15.170, 28.686)),
    (659470, (8.884, 17.525, 22.594)),
    (700472, (6.978, 18.813, 21.851)),
    (420028, (7.472, 12.138, 22.426)),
    (957234, (3.057, 11.233, 22.670)),
    (842227, (8.976, 12.210, 24.999)),
    (900720, (2.772, 17.487, 29.229)),
    (105702, (0.315, 17.904, 26.688)),
    (854673, (4.694, 18.285, 20.842)),
    (14801, (1.675, 10.393, 20.434)),
    (429651, (1.985, 19.994, 29.997)),
    (21827, (8.973, 12.049, 20.678)),
    (119042, (6.308, 15.703, 26.139)),
    (420439, (7.418, 15.385, 21.006)),
    (171227, (2.031, 11.543, 21.595)),
    (498233, (4.209, 11.543, 20.166)),
    (677249, (4.694, 16.946, 26.324)),
    (850779, (6.078, 19.270, 21.410)),
    (733232, (1.185, 10.703, 21.505)),
    (273141, (3.493, 12.041, 29.365)),
    (451980, (3.744, 10.989, 24.329)),
    (215970, (0.366, 11.258, 26.754)),
    (755669, (0.733, 19.997, 20.462)),
    (696999, (2.451, 11.465, 26.658)),
    (249443, (3.797, 15.884, 20.095)),
    (571569, (4.684, 13.830, 21.468)),
    (406683, (1.512, 19.310, 24.273)),
    (988402, (8.461, 18.570, 23.567)),
    (982973, (1.979, 18.646, 25.611)),
    (279543, (9.020, 14.692, 26.833)),
    (224606, (8.708, 17.720, 24.947)),
    (238794, (1.158, 13.650, 22.359)),
    (38979, (8.631, 18.432, 24.960)),
    (783019, (1.272, 14.933, 20.369)),
    (406563, (5.476, 13.555, 22.286)),
    (557284, (2.246, 16.042, 29.817)),
    (339466, (2.052, 15.472, 20.424)),
    (668563, (9.096, 10.577, 20.052)),
    (804649, (7.423, 13.101, 29.580)),
    (890668, (3.222, 11.057, 24.971)),
    (584599, (9.642, 12.529, 24.556)),
    (678545, (5.986, 10.210, 27.471)),
    (742113, (1.510, 16.463, 21.964)),
    (106465, (3.922, 14.555, 22.870)),
    (577028, (0.087, 18.576, 22.694)),
    (749026, (5.273, 19.634, 22.487)),
    (884285, (8.291, 17.391, 20.777)),
    (237227, (2.343, 12.576, 26.183)),
    (548758, (5.677, 16.160, 28.657)),
    (21961, (0.095, 16.462, 20.988)),
    (957182, (9.633, 19.266, 25.742)),
    (317073, (3.860, 18.060, 21.019)),
    (950218, (5.932, 14.812, 22.354)),
    (514214, (5.391, 10.068, 29.687)),
    (36279, (5.708, 15.491, 25.446)),
    (421014, (5.237, 16.940, 26.555)),
    (504219, (3.453, 12.824, 26.311)),
    (584547, (9.380, 12.738, 26.282)),
    (106216, (5.578, 14.109, 28.507)),
    (248216, (8.364, 12.459, 25.929)),
    (238778, (4.419, 13.966, 27.158)),
    (881578, (1.051, 12.277, 21.360)),
    (541236, (5.801, 10.964, 24.069)),
    (131007, (4.442, 16.191, 26.446)),
    (132396, (7.720, 16.310, 25.590)),
    (499976, (1.138, 19.540, 22.426)),
    (664015, (9.255, 11.567, 21.159)),
    (680885, (0.073, 13.999, 21.766)),
    (885585, (9.267, 10.891, 23.157)),
    (105592, (3.643, 14.867, 26.062)),
    (421109, (6.648, 15.542, 25.243)),
    (501133, (0.512, 10.243, 24.823)),
    (494953, (3.854, 19.402, 27.019)),
    (831903, (5.322, 18.960, 28.091)),
    (62908, (1.469, 13.725, 24.281)),
    (392487, (6.959, 14.828, 21.623)),
    (633181, (5.477, 19.039, 20.667)),
    (414287, (6.354, 15.504, 27.647)),
    (949743, (5.399, 14.046, 20.562)),
    (402300, (5.045, 16.952, 22.670)),
    (744431, (0.744, 17.971, 25.792)),
    (4627, (0.449, 17.216, 26.342)),
    (26319, (5.881, 13.903, 28.127)),
    (606013, (0.699, 12.163, 21.810)),
    (923348, (6.791, 13.984, 20.815)),
    (148687, (5.331, 16.447, 24.912)),
    (823128, (7.695, 17.667, 26.843)),
    (439295, (9.384, 13.835, 23.131)),
    (420647, (6.272, 19.837, 24.280)),
    (786015, (5.410, 12.805, 27.857)),
    (323715, (9.436, 12.145, 27.711)),
    (569139, (4.069, 10.448, 29.884)),
    (76378, (1.387, 10.195, 20.745)),
    (369507, (2.774, 16.935, 24.894)),
    (376121, (4.708, 16.273, 22.347)),
    (964478, (7.813, 14.165, 20.111)),
    (402570, (0.710, 17.195, 26.581)),
    (752258, (0.598, 12.915, 25.990)),
    (601815, (0.063, 18.345, 28.268)),
    (30987, (2.424, 16.143, 29.014)),
    (151462, (4.223, 16.877, 26.063)),
    (828079, (9.435, 16.585, 25.620)),
    (133220, (3.821, 14.419, 29.672)),
    (198298, (2.382, 16.075, 26.379)),
    (540872, (7.336, 14.445, 26.070)),
    (951118, (4.159, 12.323, 24.287)),
    (310105, (5.712, 19.619, 29.139)),
    (44326, (0.775, 10.287, 23.788)),
    (674841, (2.011, 11.093, 25.643)),
    (145058, (1.563, 13.056, 21.495)),
    (665796, (2.292, 15.087, 22.948)),
    (624716, (5.375, 19.247, 24.002)),
    (421337, (7.833, 10.200, 25.870)),
    (27349, (0.294, 11.747, 23.026)),
    (138319, (0.308, 10.699, 25.350)),
    (969595, (2.766, 10.661, 28.564)),
    (129381, (3.615, 17.299, 28.909)),
    (105017, (4.200, 16.046, 24.271)),
    (97635, (5.938, 16.827, 27.000)),
    (552635, (2.960, 12.023, 29.619)),
    (53073, (8.594, 16.765, 26.856)),
    (58104, (0.635, 13.691, 20.416)),
    (601318, (8.610, 11.324, 23.709)),
    (642984, (5.505, 13.341, 24.347)),
    (206972, (2.151, 16.368, 24.747)),
    (156526, (9.510, 11.166, 29.352)),
    (390047, (9.602, 10.209, 20.048)),
    (306456, (4.561, 18.495, 24.245)),
    (69949, (7.454, 18.327, 27.707)),
    (277390, (0.097, 15.110, 26.432)),
    (467547, (6.096, 14.318, 24.445)),
    (751900, (5.855, 11.469, 28.937)),
    (137222, (7.193, 11.534, 22.810)),
    (159955, (6.388, 19.632, 25.147)),
    (167816, (0.052, 16.259, 23.630)),
    (686165, (9.060, 14.573, 24.887)),
    (357529, (1.276, 12.200, 23.348)),
    (125292, (8.034, 19.808, 23.450)),
    (340195, (6.335, 19.561, 28.456)),
    (956078, (0.618, 19.942, 28.103)),
    (96769, (1.178, 19.661, 20.826)),
    (617872, (2.475, 10.710, 28.557)),
    (608098, (4.170, 15.192, 28.679)),
    (692202, (9.170, 17.636, 27.912)),
    (369523, (5.172, 16.012, 24.207)),
    (446896, (9.850, 18.690, 21.682)),
    (613616, (7.618, 15.243, 24.789)),
    (595425, (8.999, 11.154, 27.209)),
    (794667, (3.076, 13.697, 26.630)),
    (154411, (4.596, 11.045, 23.438)),
    (492480, (9.471, 10.449, 28.541)),
    (573730, (2.161, 12.387, 23.897)),
    (749696, (2.579, 17.976, 20.209)),
    (949559, (2.818, 16.393, 27.108)),
    (932233, (7.548, 18.743, 21.936)),
    (849732, (5.610, 18.680, 23.450)),
    (554138, (3.683, 10.532, 22.349)),
    (249857, (1.523, 19.977, 26.171)),
    (849336, (1.223, 19.788, 20.817)),
    (688078, (2.136, 10.795, 27.491)),
    (627955, (2.690, 14.951, 21.717)),
    (594708, (2.978, 13.341, 24.896)),
    (372973, (8.352, 11.093, 25.136)),
    (916017, (1.409, 14.613, 28.434)),
    (839020, (1.527, 10.622, 26.567)),
    (496540, (4.049, 15.770, 20.267)),
    (911563, (8.161, 18.047, 29.497)),
    (448678, (6.721, 17.302, 25.444)),
    (480154, (1.997, 16.527, 23.221)),
    (466979, (9.801, 13.424, 28.022)),
    (266989, (2.737, 12.340, 28.763)),
    (224340, (1.977, 14.827, 23.590)),
    (840089, (7.004, 10.411, 20.833)),
    (590641, (0.030, 12.264, 27.115)),
    (361938, (2.316, 19.199, 26.335)),
    (86251, (1.433, 16.083, 25.237)),
    (270882, (6.600, 16.226, 28.246)),
    (782831, (0.179, 13.423, 23.036)),
    (198414, (5.861, 19.564, 23.485)),
    (339226, (8.726, 18.647, 26.875)),
    (754410, (5.151, 18.192, 23.088)),
    (443089, (6.546, 13.025, 21.823)),
    (980445, (7.897, 13.142, 23.036)),
    (951057, (2.891, 16.104, 21.783)),
    (732018, (5.630, 10.174, 23.680)),
    (43608, (8.345, 19.572, 21.877)),
    (239986, (8.066, 14.452, 23.385)),
    (480270, (3.139, 12.538, 20.120)),
    (571872, (2.744, 16.931, 22.401)),
    (176645, (3.276, 10.578, 26.231)),
    (704139, (3.885, 14.337, 25.385)),
    (965546, (3.034, 19.324, 22.664)),
    (810360, (7.441, 17.752, 25.355)),
    (135545, (1.160, 13.910, 21.328)),
    (692184, (1.624, 14.848, 25.442)),
    (269063, (4.116, 19.389, 25.909)),
    (885716, (2.945, 17.522, 26.093)),
    (278081, (9.401, 19.240, 20.929)),
    (384959, (2.413, 10.421, 25.146)),
    (26872, (9.602, 11.417, 23.396)),
    (821228, (1.767, 18.765, 28.322)),
    (161456, (4.556, 15.361, 26.508)),
    (249115, (3.585, 17.723, 24.854)),
    (934633, (6.079, 18.222, 22.112)),
    (264698, (4.093, 19.836, 27.064)),
    (281188, (6.421, 12.914, 21.198)),
    (848797, (2.027, 17.516, 23.577)),
    (124488, (5.068, 17.197, 22.435)),
    (873633, (8.270, 16.676, 28.068)),
    (388263, (4.768, 16.571, 25.007)),
    (840777, (1.754, 15.323, 28.955)),
    (376602, (2.675, 10.076, 27.291)),
    (778602, (9.187, 17.122, 25.797)),
    (999294, (7.037, 11.162, 26.635)),
    (462282, (9.899, 12.382, 23.195)),
    (383083, (7.660, 13.583, 20.730)),
    (82155, (2.299, 11.525, 28.158)),
    (160333, (0.400, 19.321, 26.519)),
    (862605, (1.377, 11.036, 24.294)),
    (13755, (8.375, 12.609, 23.543)),
    (655400, (4.489, 13.075, 28.236)),
    (858426, (4.221, 11.477, 23.740)),
    (349809, (9.069, 10.635, 22.814)),
    (472881, (6.398, 19.491, 28.384)),
    (90239, (8.733, 16.525, 26.478)),
    (14577, (9.167, 19.564, 23.396)),
    (800764, (0.369, 15.715, 22.582)),
    (646884, (0.706, 15.109, 24.144)),
    (690488, (7.832, 15.974, 26.144)),
    (108611, (9.164, 16.017, 21.842)),
    (327937, (2.856, 16.729, 22.216)),
    (249821, (4.714, 14.332, 23.066)),
    (247879, (7.222, 18.963, 28.321)),
    (651167, (0.233, 10.091, 20.695)),
    (67635, (2.529, 17.327, 25.422)),
    (821967, (9.443, 19.464, 27.173)),
    (967249, (1.502, 17.582, 27.874)),
    (106418, (1.421, 16.733, 20.690)),
    (275185, (0.489, 17.935, 27.307)),
    (891976, (3.569, 17.915, 22.130)),
    (200827, (6.962, 11.247, 27.096)),
    (643269, (1.595, 14.176, 24.073)),
    (96441, (4.444, 11.220, 25.845)),
    (693856, (2.895, 15.284, 27.093)),
    (380447, (6.388, 13.665, 22.426)),
    (840092, (3.139, 12.700, 29.105)),
    (32100, (2.535, 16.192, 21.801)),
    (2982, (8.153, 16.996, 26.086)),
    (842790, (7.439, 14.121, 27.303)),
    (252848, (2.297, 13.512, 28.297)),
    (939434, (6.416, 12.710, 22.922)),
    (205763, (0.860, 16.679, 24.834)),
    (126218, (5.545, 15.829, 26.085)),
    (819697, (9.946, 10.782, 28.842)),
    (192694, (4.248, 17.021, 21.319)),
    (979464, (1.258, 13.530, 25.238)),
    (106217, (0.086, 13.143, 20.936)),
    (617832, (1.031, 13.938, 24.432)),
    (734113, (2.938, 17.021, 22.855)),
    (365193, (5.969, 14.211, 25.596)),
    (378575, (6.567, 11.818, 22.287)),
    (256917, (9.031, 18.379, 27.248)),
    (157544, (3.274, 14.838, 27.354)),
    (383406, (1.536, 19.283, 25.306)),
    (251322, (4.928, 12.569, 22.609)),
    (498410, (3.129, 10.624, 28.696)),
    (651781, (4.359, 14.543, 29.136)),
    (387004, (5.434, 11.656, 21.125)),
    (609000, (4.357, 18.502, 23.486)),
    (444982, (4.877, 18.814, 29.814)),
    (542748, (5.412, 10.259, 26.271)),
    (621108, (7.459, 10.778, 24.287)),
    (620753, (8.796, 12.136, 27.720)),
    (627417, (6.329, 10.531, 21.783)),
    (309531, (3.424, 17.106, 21.510)),
    (605294, (0.152, 17.799, 28.036)),
    (242928, (9.697, 15.533, 23.524)),
    (354944, (8.843, 17.886, 22.375)),
    (230926, (8.861, 11.851, 26.682)),
    (295868, (7.787, 13.404, 28.799)),
    (262609, (0.989, 18.570, 26.716)),
    (637075, (8.953, 17.774, 26.445)),
    (443781, (2.863, 13.915, 20.590)),
    (913219, (5.456, 19.385, 20.120)),
    (970206, (9.241, 18.336, 20.531)),
    (82956, (8.112, 19.479, 22.479)),
    (965482, (5.588, 19.748, 29.520)),
    (275489, (6.579, 18.939, 26.479)),
    (148244, (8.113, 11.800, 20.629)),
    (976498, (8.316, 14.084, 20.288)),
    (165708, (3.335, 10.394, 27.464)),
    (502616, (1.893, 17.829, 26.772)),
    (282938, (1.966, 15.641, 21.338)),
    (219302, (7.350, 14.695, 25.173)),
    (701659, (3.813, 14.669, 29.773)),
    (216752, (8.581, 18.769, 20.306)),
    (738227, (8.852, 19.085, 26.125)),
    (157788, (8.711, 16.363, 27.758)),
    (363408, (4.987, 13.435, 25.450)),
    (158921, (9.846, 11.320, 20.476)),
    (687261, (8.547, 16.644, 27.074)),
    (270400, (3.814, 10.306, 20.799)),
    (496179, (2.028, 18.023, 23.341)),
    (109055, (5.616, 15.562, 27.001)),
    (179758, (0.310, 17.456, 26.098)),
    (602215, (0.702, 13.657, 24.086)),
    (315743, (6.020, 13.786, 21.823)),
    (622256, (9.396, 12.467, 20.027)),
    (424096, (6.609, 15.140, 22.941)),
    (451767, (5.230, 17.700, 21.615)),
    (519969, (4.858, 14.280, 22.629)),
    (492382, (0.413, 11.093, 25.945)),
    (13119, (0.384, 14.542, 29.981)),
    (11362, (8.842, 19.372, 24.529)),
    (887479, (5.104, 18.057, 20.999)),
    (348833, (4.291, 15.178, 22.340)),
    (444737, (1.715, 19.048, 27.253)),
    (336864, (6.448, 16.470, 20.846)),
    (572576, (4.704, 16.069, 23.497)),
    (560883, (7.453, 15.977, 28.080)),
    (301699, (2.698, 15.805, 21.567)),
    (52061, (8.345, 14.463, 26.430)),
    (771922, (5.521, 12.101, 20.031)),
    (905603, (8.098, 16.752, 25.797)),
    (834459, (7.239, 15.716, 25.811)),
    (96131, (6.573, 12.297, 26.994)),
    (237683, (5.165, 14.390, 23.004)),
    (620615, (3.382, 18.326, 29.412)),
    (295618, (9.911, 16.784, 25.439)),
    (874045, (6.336, 10.553, 20.194)),
    (167714, (7.349, 16.559, 27.071)),
    (480996, (7.797, 10.640, 28.616)),
    (361871, (7.968, 12.992, 22.256)),
    (887149, (6.118, 16.816, 22.886)),
    (355804, (5.222, 13.333, 27.395)),
    (217624, (5.892, 13.328, 20.899)),
    (629743, (3.301, 11.220, 20.860)),
    (764543, (4.805, 18.874, 24.330)),
    (549958, (5.744, 14.919, 26.345)),
    (453532, (2.985, 13.841, 28.428)),
    (773388, (0.202, 16.730, 25.016)),
    (169275, (0.613, 14.155, 25.458)),
    (704680, (6.303, 16.198, 24.540)),
    (932460, (9.482, 19.684, 28.956)),
    (966353, (3.534, 11.623, 24.334)),
    (202764, (7.868, 15.926, 24.810)),
    (851304, (4.795, 19.885, 28.015)),
    (859176, (0.037, 15.763, 29.654)),
    (766155, (3.296, 16.811, 25.486)),
    (657938, (2.837, 15.510, 29.057)),
    (980393, (8.913, 18.470, 25.338)),
    (129899, (2.189, 10.025, 21.339)),
    (796225, (8.126, 12.719, 26.260)),
    (571593, (9.573, 19.048, 25.960)),
    (841004, (3.272, 12.831, 24.677)),
    (672755, (3.647, 18.462, 21.518)),
    (971826, (3.354, 10.661, 27.610)),
    (884670, (0.016, 12.735, 23.757)),
    (29312, (8.992, 13.530, 25.069)),
    (321959, (7.246, 18.692, 26.007)),
    (466448, (5.811, 19.607, 25.329)),
    (41342, (6.532, 17.920, 28.746)),
    (418760, (3.209, 12.483, 25.947)),
    (490370, (7.724, 19.768, 23.401)),
    (608925, (7.608, 13.788, 24.356)),
    (135990, (4.440, 17.591, 23.149)),
    (660248, (8.288, 12.234, 20.245)),
    (542425, (4.105, 15.103, 22.203)),
    (877712, (8.943, 15.083, 21.432)),
    (120607, (4.443, 18.050, 28.654)),
    (614894, (4.233, 15.921, 20.961)),
    (70892, (7.911, 12.253, 27.291)),
    (605977, (9.406, 19.412, 26.412)),
    (852650, (0.597, 16.046, 21.192)),
    (617092, (9.910, 11.148, 22.267)),
    (749494, (4.051, 13.411, 20.363)),
    (223008, (4.490, 16.862, 24.645)),
    (449390, (6.783, 15.239, 27.885)),
    (258077, (8.340, 12.146, 25.534)),
    (555859, (5.126, 13.578, 25.470)),
    (667262, (3.877, 11.026, 29.665)),
    (78121, (3.268, 14.682, 26.188)),
    (388113, (7.028, 12.927, 25.902)),
    (82865, (0.631, 17.788, 22.864)),
    (47969, (6.786, 14.047, 24.342)),
    (749523, (7.219, 17.779, 22.437)),
    (301970, (5.773, 11.914, 26.117)),
    (341943, (9.588, 16.928, 25.855)),
    (565080, (9.485, 17.982, 26.156)),
    (824404, (6.566, 12.899, 24.746)),
    (472226, (7.679, 10.638, 20.083)),
    (283333, (6.393, 15.867, 26.943)),
    (581117, (3.106, 17.597, 26.070)),
    (958351, (2.383, 11.191, 25.204)),
    (760663, (4.534, 13.422, 22.769)),
    (153988, (1.220, 13.477, 28.814)),
    (660614, (9.461, 11.602, 20.748)),
    (538655, (0.913, 10.958, 22.250)),
    (534519, (7.935, 11.024, 21.842)),
    (617368, (0.807, 15.316, 22.907)),
    (370309, (7.731, 16.541, 26.770)),
    (364627, (1.059, 15.324, 26.126)),
    (825706, (1.694, 16.948, 21.321)),
    (91745, (8.963, 12.032, 28.577)),
    (88058, (3.551, 11.965, 27.424)),
    (956892, (1.566, 19.625, 26.640)),
    (363569, (9.073, 10.871, 28.231)),
    (231651, (6.922, 13.747, 21.551)),
    (475177, (9.333, 16.359, 28.950)),
    (187067, (8.017, 19.540, 24.660)),
    (42757, (3.852, 15.367, 25.449)),
    (967730, (5.985, 11.681, 26.122)),
    (466960, (8.183, 13.444, 20.071)),
    (772885, (7.276, 12.195, 25.448)),
    (143714, (4.515, 15.690, 25.349)),
    (30631, (3.967, 12.279, 24.388)),
    (826266, (1.610, 16.009, 27.419)),
    (541636, (2.252, 12.249, 23.236)),
    (689366, (6.460, 11.417, 28.598)),
    (866731, (2.239, 11.268, 23.865)),
    (504478, (2.769, 16.202, 26.323)),
    (91874, (2.442, 10.116, 29.813)),
    (966106, (0.317, 15.871, 22.377)),
    (918861, (4.295, 19.973, 29.645)),
    (308694, (1.445, 15.160, 26.397)),
    (603921, (0.806, 17.615, 24.402)),
    (722574, (7.424, 10.547, 29.736)),
    (605046, (7.402, 17.189, 26.858)),
    (625120, (2.900, 14.830, 25.793)),
    (959233, (5.460, 10.721, 23.619)),
    (295463, (3.505, 16.954, 20.433)),
    (919887, (3.354, 19.215, 25.328)),
    (951352, (0.283, 17.127, 21.087)),
    (791377, (6.101, 17.102, 27.781)),
    (80584, (4.756, 12.251, 21.420)),
    (867628, (2.737, 16.138, 27.117)),
    (437753, (0.817, 18.490, 25.218)),
    (33716, (0.658, 19.886, 25.854)),
    (340850, (8.988, 11.520, 20.408)),
    (904100, (1.788, 12.470, 27.735)),
    (744314, (6.005, 15.787, 25.456)),
    (964965, (7.205, 10.879, 27.317)),
    (208236, (4.249, 11.554, 21.956)),
    (43603, (4.894, 14.646, 20.843)),
    (534242, (5.798, 17.840, 28.871)),
    (886586, (4.570, 17.419, 28.776)),
    (484732, (6.828, 16.978, 24.012)),
    (433590, (0.194, 19.829, 24.234)),
    (322106, (1.878, 11.817, 22.228)),
    (699857, (8.686, 13.488, 22.804)),
    (154968, (3.753, 16.761, 24.294)),
    (599223, (1.529, 19.245, 23.647)),
    (305329, (2.348, 10.832, 21.604)),
    (510237, (0.103, 18.369, 20.790)),
    (603210, (8.801, 16.799, 22.117)),
    (671797, (1.617, 15.101, 28.203)),
    (1708, (8.255, 19.323, 23.397)),
    (424232, (9.126, 13.809, 25.092)),
    (432772, (6.267, 11.315, 28.765)),
    (956388, (7.239, 10.124, 25.689)),
    (350260, (2.232, 18.079, 21.064)),
    (658897, (9.485, 19.361, 29.393)),
    (969138, (8.883, 17.217, 24.817)),
    (778457, (8.658, 18.575, 28.834)),
    (477315, (7.022, 10.120, 21.421)),
    (349974, (2.870, 10.877, 29.122)),
    (501188, (4.124, 13.198, 23.392)),
    (4297, (3.378, 15.799, 23.493)),
    (748493, (9.395, 16.123, 20.817)),
    (384789, (4.306, 15.260, 29.129)),
    (365911, (0.754, 15.403, 21.083)),
    (779022, (1.335, 11.497, 24.945)),
    (640707, (5.067, 11.345, 21.215)),
    (197026, (2.729, 10.413, 27.557)),
    (761434, (7.505, 13.488, 29.621)),
    (197646, (7.145, 19.402, 24.002)),
    (615314, (3.727, 16.169, 21.035)),
    (754449, (5.354, 18.191, 26.667)),
    (998652, (0.680, 15.083, 23.524)),
    (152543, (5.521, 11.170, 25.344)),
    (880196, (1.215, 18.814, 25.363)),
    (795059, (4.788, 12.424, 22.605)),
    (399695, (3.839, 12.654, 23.054)),
    (584000, (7.294, 16.357, 20.725)),
    (918789, (9.954, 19.467, 25.748)),
    (115676, (4.103, 17.665, 29.425)),
    (658635, (1.491, 16.308, 28.813)),
    (268555, (4.715, 15.428, 20.662)),
    (154258, (8.643, 12.682, 20.913)),
    (247667, (7.751, 16.271, 24.536)),
    (797750, (1.395, 10.575, 27.862)),
    (538631, (4.293, 13.107, 22.232)),
    (947541, (5.534, 11.036, 20.164)),
    (247571, (1.297, 15.191, 23.207)),
    (813829, (0.672, 10.058, 26.862)),
    (218940, (2.495, 15.626, 25.203)),
    (708277, (8.074, 15.298, 22.696)),
    (207586, (4.052, 15.412, 23.378)),
    (120628, (9.472, 14.777, 28.840)),
    (487669, (0.524, 17.164, 23.534)),
    (165639, (7.105, 16.816, 21.054)),
    (739779, (2.363, 18.908, 29.494)),
    (523607, (9.179, 14.098, 29.836)),
    (928139, (9.733, 14.808, 22.192)),
    (919455, (3.573, 11.028, 20.792)),
    (136106, (8.163, 19.836, 28.367)),
    (221132, (1.090, 19.832, 26.259)),
    (171796, (2.580, 17.620, 28.176)),
    (469535, (9.724, 16.214, 29.823)),
    (631758, (1.022, 18.157, 28.610)),
    (948383, (8.219, 11.987, 28.266)),
    (777793, (1.210, 15.181, 26.088)),
    (765009, (3.625, 12.396, 27.319)),
    (459785, (9.023, 13.446, 20.685)),
    (497411, (1.992, 19.450, 21.115)),
    (522139, (6.534, 18.035, 28.494)),
    (740102, (3.112, 10.176, 24.736)),
    (348396, (5.634, 11.929, 22.444)),
    (713314, (7.458, 18.836, 25.436)),
    (611372, (4.247, 14.076, 26.843)),
    (310619, (0.128, 15.958, 25.932)),
    (994297, (3.982, 14.028, 25.571)),
    (238543, (2.826, 11.149, 20.400)),
    (196289, (8.704, 15.719, 25.985)),
    (490718, (4.996, 17.778, 25.019)),
    (639477, (6.645, 14.043, 21.970)),
    (51020, (1.616, 15.434, 29.447)),
    (566482, (8.554, 10.824, 28.621)),
    (108428, (3.214, 14.747, 22.618)),
    (695269, (0.471, 12.414, 20.628)),
    (557002, (0.940, 15.104, 22.678)),
    (986954, (5.474, 17.364, 22.967)),
    (159190, (1.940, 15.097, 24.701)),
    (299145, (3.055, 11.894, 27.526)),
    (583557, (9.803, 10.910, 23.271)),
    (149552, (2.124, 16.697, 23.754)),
    (746108, (4.768, 17.422, 25.572)),
    (28041, (4.322, 15.199, 24.129)),
    (322725, (6.051, 14.461, 23.628)),
    (411468, (9.098, 11.501, 29.506)),
    (483522, (7.811, 14.629, 21.477)),
    (171049, (1.849, 16.701, 20.369)),
    (889901, (5.692, 10.739, 25.889)),
    (659251, (1.952, 13.277, 20.989)),
    (199046, (5.137, 18.055, 27.723)),
    (876029, (0.089, 19.149, 20.275)),
    (21698, (5.618, 14.086, 23.022)),
    (470197, (1.500, 19.648, 20.902)),
    (479595, (7.408, 13.920, 26.058)),
    (65135, (9.707, 10.411, 22.300)),
    (675644, (4.134, 18.741, 28.661)),
    (11487, (3.029, 10.491, 27.856)),
    (374922, (8.880, 17.556, 24.559)),
    (260006, (9.066, 15.252, 24.920)),
    (821063, (3.792, 17.133, 22.534)),
    (292736, (9.647, 18.100, 21.555)),
    (701460, (2.014, 11.798, 20.622)),
    (576693, (4.697, 11.340, 27.477)),
    (19331, (1.574, 15.800, 24.310)),
    (653509, (5.884, 19.576, 23.342)),
    (425699, (6.241, 10.761, 27.686)),
    (803823, (4.286, 10.005, 22.316)),
    (913338, (8.532, 10.132, 22.118)),
    (80113, (9.979, 19.488, 25.455)),
    (330476, (3.166, 19.118, 22.490)),
    (282708, (6.341, 16.446, 20.247)),
    (123898, (1.583, 12.818, 26.103)),
    (340365, (7.223, 11.855, 20.976)),
    (92841, (3.960, 18.269, 26.542)),
    (531516, (8.661, 19.713, 22.134)),
    (19018, (8.678, 10.535, 22.731)),
    (796955, (6.764, 14.645, 22.706)),
    (289069, (1.344, 12.349, 28.699)),
    (257839, (2.026, 11.343, 20.347)),
    (552881, (5.358, 18.083, 21.405)),
    (450046, (8.984, 13.637, 21.125)),
    (223610, (8.630, 10.262, 29.047)),
    (287743, (3.295, 19.169, 27.219)),
    (841757, (8.345, 12.400, 27.171)),
    (28750, (9.901, 16.556, 27.503)),
    (675804, (1.152, 19.126, 26.242)),
    (121234, (3.302, 11.898, 26.286)),
    (238142, (8.446, 10.622, 21.085)),
    (626437, (7.025, 12.686, 25.532)),
    (201945, (2.512, 19.005, 26.848)),
    (597908, (9.698, 17.769, 27.606)),
    (532634, (7.427, 10.553, 24.787)),
    (531589, (5.563, 10.790, 26.383)),
    (877832, (6.455, 13.005, 22.079)),
    (94065, (4.175, 11.377, 22.196)),
    (297492, (0.377, 15.552, 24.808)),
    (241136, (4.048, 15.879, 27.563)),
    (897686, (3.104, 17.861, 24.854)),
    (79206, (2.420, 12.527, 22.536)),
    (382965, (7.264, 11.983, 22.730)),
    (445988, (1.988, 15.663, 23.653)),
    (657320, (1.176, 10.462, 25.974)),
    (694025, (6.524, 10.894, 25.798)),
    (915186, (4.271, 16.263, 22.896)),
    (229350, (0.669, 16.185, 20.272)),
    (820657, (5.709, 14.703, 23.617)),
    (428282, (9.041, 14.919, 26.606)),
    (638600, (8.545, 14.366, 25.504)),
    (445861, (7.640, 16.400, 23.755)),
    (403159, (3.925, 12.327, 21.600)),
    (4823, (9.524, 13.729, 23.913)),
    (596502, (0.956, 12.446, 28.454)),
    (413143, (5.631, 15.068, 27.581)),
    (206733, (6.682, 14.437, 29.339)),
    (598233, (8.372, 17.756, 24.276)),
    (433697, (5.427, 18.987, 23.749)),
    (689966, (0.128, 18.899, 24.716)),
    (186204, (6.044, 18.380, 21.819)),
    (482719, (6.580, 15.519, 25.149)),
    (767363, (9.825, 17.018, 27.036)),
    (795874, (9.074, 19.984, 29.230)),
    (14100, (3.607, 16.392, 26.640)),
    (547787, (5.176, 16.716, 26.189)),
    (981470, (6.649, 11.411, 22.224)),
    (595205, (7.796, 19.919, 20.503)),
    (137060, (2.677, 12.307, 25.611)),
    (926662, (6.039, 17.676, 22.539)),
    (233870, (7.593, 17.049, 28.252)),
    (472808, (5.256, 16.237, 24.685)),
    (383415, (7.793, 15.792, 23.620)),
    (597816, (2.041, 12.444, 23.739)),
    (58647, (5.788, 15.098, 26.573)),
    (699981, (7.621, 17.645, 24.514)),
    (432584, (1.888, 12.165, 22.816)),
    (997060, (0.247, 14.420, 21.915)),
    (971782, (1.444, 14.086, 28.066)),
    (199451, (8.541, 11.723, 25.203)),
    (258520, (9.625, 19.780, 21.921)),
    (578762, (2.935, 12.751, 28.607)),
    (581373, (9.963, 19.363, 27.249)),
    (470571, (0.166, 13.825, 24.654)),
    (183454, (6.566, 10.432, 21.777)),
    (139937, (2.744, 13.233, 20.935)),
    (897359, (2.214, 19.871, 28.165)),
    (328868, (5.026, 12.867, 25.805)),
    (141634, (6.710, 14.259, 25.387)),
    (569277, (0.783, 17.620, 28.753)),
    (748904, (4.127, 10.206, 26.087)),
    (795655, (7.989, 15.266, 26.866)),
    (262109, (7.792, 17.215, 29.677)),
    (314649, (9.883, 15.012, 24.468)),
    (305018, (7.052, 18.341, 29.588)),
    (873791, (8.438, 14.903, 25.382)),
    (285136, (7.362, 17.929, 25.243)),
    (701636, (6.696, 18.221, 26.708)),
    (710620, (3.835, 14.514, 23.683)),
    (3704, (9.227, 17.211, 21.657)),
    (795392, (3.906, 10.348, 28.021)),
    (865285, (0.613, 17.831, 26.170)),
    (635175, (6.235, 16.808, 24.994)),
    (173753, (9.634, 14.331, 26.898)),
    (496461, (1.040, 16.699, 21.034)),
    (904160, (0.425, 10.464, 20.421)),
    (934013, (6.356, 16.559, 29.560)),
    (419855, (1.694, 10.275, 27.014)),
    (533360, (6.201, 12.279, 25.671)),
    (996219, (0.184, 15.054, 26.141)),
    (483536, (3.132, 15.477, 21.527)),
    (220653, (7.904, 13.012, 28.780)),
    (998070, (0.020, 13.342, 23.556)),
    (113663, (2.345, 14.527, 29.039)),
    (406097, (1.403, 13.041, 23.097)),
    (187420, (4.708, 19.896, 23.828)),
    (428093, (3.055, 16.468, 29.025)),
    (448539, (2.917, 14.106, 22.812)),
    (912650, (5.443, 10.687, 25.576)),
    (856239, (9.580, 11.141, 22.739)),
    (974595, (7.100, 14.721, 22.113)),
    (35106, (5.620, 18.942, 20.175)),
    (629881, (9.284, 16.310, 27.338)),
    (487959, (7.827, 10.583, 28.131)),
    (46925, (1.718, 19.718, 27.968)),
    (923484, (0.446, 12.064, 22.301)),
    (925538, (2.962, 15.559, 22.296)),
    (344577, (9.037, 12.525, 23.490)),
    (813142, (0.130, 15.212, 26.787)),
    (534419, (1.744, 13.471, 25.495)),
    (286114, (8.562, 17.175, 22.243)),
    (406470, (4.468, 19.907, 27.321)),
    (476745, (6.804, 10.609, 29.471)),
    (279686, (4.636, 14.910, 23.110)),
    (24317, (4.551, 17.433, 21.853)),
    (50402, (2.496, 16.465, 23.300)),
    (247538, (2.367, 18.602, 20.410)),
    (271518, (3.145, 18.810, 25.270)),
    (756986, (5.698, 10.979, 29.225)),
    (475712, (7.776, 19.063, 24.031)),
    (876371, (2.012, 15.191, 25.817)),
    (843033, (0.973, 19.294, 28.143)),
    (212595, (4.046, 15.777, 29.797)),
    (624406, (8.249, 14.753, 25.929)),
    (821916, (3.603, 14.869, 23.575)),
    (182508, (2.909, 14.632, 28.699)),
    (246954, (1.352, 12.617, 28.851)),
    (534446, (6.333, 16.548, 22.243)),
    (320759, (1.395, 13.236, 23.003)),
    (70782, (5.876, 17.541, 25.202)),
    (975169, (5.973, 13.355, 25.297)),
    (461234, (2.601, 18.983, 24.722)),
    (218288, (8.665, 15.096, 26.269)),
    (788268, (3.300, 15.786, 29.103)),
    (697983, (4.259, 16.107, 24.449)),
    (483611, (2.891, 15.372, 20.958)),
    (563351, (4.281, 13.734, 28.829)),
    (173711, (7.723, 11.007, 21.551)),
    (855696, (8.337, 13.073, 25.314)),
    (340471, (3.571, 16.526, 27.795)),
    (292218, (8.878, 13.133, 26.224)),
    (791840, (3.114, 14.108, 22.640)),
    (207387, (9.662, 17.987, 27.833)),
    (697258, (7.791, 13.520, 29.685)),
    (819552, (6.815, 18.396, 27.587)),
    (85139, (0.684, 19.422, 25.206)),
    (916236, (5.624, 17.358, 24.185)),
    (992171, (3.579, 19.722, 20.942)),
    (236743, (0.573, 16.704, 20.291)),
    (864451, (9.975, 11.574, 26.280)),
    (994981, (1.554, 10.284, 24.698)),
    (257261, (3.236, 10.611, 21.320)),
    (891221, (5.976, 15.165, 23.786)),
    (897516, (6.412, 14.890, 29.717)),
    (419297, (4.339, 16.522, 20.489)),
    (621203, (1.601, 12.523, 24.594)),
    (539630, (3.532, 11.778, 22.037)),
    (917039, (1.043, 18.137, 28.020)),
    (264075, (1.220, 14.940, 20.900)),
    (904081, (1.785, 18.032, 26.474)),
    (315910, (3.473, 19.897, 23.235)),
    (35468, (8.863, 11.384, 22.024)),
    (92596, (3.592, 14.415, 28.685)),
    (369767, (5.107, 19.378, 28.677)),
    (792988, (7.118, 18.364, 21.880)),
    (657416, (3.530, 16.529, 26.679)),
    (912139, (0.700, 19.234, 22.242)),
    (725110, (0.726, 13.837, 28.164)),
    (16607, (6.963, 13.523, 26.724)),
    (63954, (5.734, 10.376, 28.468)),
    (411903, (0.694, 11.602, 27.005)),
    (76190, (7.134, 19.790, 25.666)),
    (518175, (0.171, 11.658, 20.148)),
    (864906, (4.658, 18.589, 22.003)),
    (537030, (9.915, 13.349, 24.704)),
    (16943, (5.044, 19.265, 22.574)),
    (119770, (5.996, 18.200, 22.336)),
    (453428, (4.726, 12.846, 27.375)),
    (369894, (5.459, 14.622, 23.444)),
    (608206, (9.240, 14.296, 29.209)),
    (5811, (0.529, 10.326, 28.255)),
    (571072, (5.992, 13.836, 26.744)),
    (633639, (8.064, 12.046, 26.469)),
    (299908, (1.803, 10.761, 28.755)),
    (456544, (7.309, 10.888, 21.451)),
    (69981, (0.472, 12.126, 27.555)),
    (328406, (7.597, 16.323, 23.791)),
    (70723, (1.372, 11.440, 24.798)),
    (450756, (8.441, 13.277, 22.425)),
    (99163, (5.204, 12.867, 24.177)),
    (35705, (5.082, 11.514, 27.741)),
    (527599, (0.429, 16.224, 22.381)),
    (785890, (8.621, 16.726, 22.523)),
    (985111, (7.765, 16.331, 26.774)),
    (186103, (2.628, 10.693, 27.918)),
    (768339, (3.418, 12.294, 22.054)),
    (907855, (6.167, 11.533, 25.094)),
    (872134, (9.184, 11.451, 23.995)),
    (157719, (8.553, 18.350, 25.562)),
    (851927, (6.198, 10.488, 21.604)),
    (365244, (3.512, 15.675, 27.745)),
    (134804, (1.426, 18.090, 21.794)),
    (20853, (7.525, 18.116, 20.791)),
    (720538, (0.989, 19.422, 26.733)),
    (233054, (0.856, 15.005, 25.939)),
    (738282, (5.862, 18.967, 25.496)),
    (226198, (3.612, 14.404, 23.440)),
    (59011, (9.227, 18.334, 28.242)),
    (359545, (2.418, 16.004, 22.494)),
    (427961, (4.769, 12.761, 24.645)),
    (659521, (5.927, 12.726, 29.175)),
    (543908, (4.612, 17.367, 28.064)),
    (239833, (6.835, 11.074, 21.069)),
    (287131, (1.780, 14.196, 29.600)),
    (214299, (4.492, 14.033, 20.453)),
    (321449, (3.687, 17.814, 24.146)),
    (579936, (7.332, 14.848, 21.917)),
    (640894, (2.068, 14.239, 22.415)),
    (596431, (7.773, 17.914, 21.758)),
    (138390, (3.579, 14.628, 20.355)),
    (611589, (5.882, 18.578, 23.573)),
    (926420, (4.286, 13.350, 26.299)),
    (372729, (4.621, 11.689, 23.025)),
    (618594, (8.357, 17.852, 27.869)),
    (534529, (1.723, 13.645, 28.823)),
    (555036, (1.160, 13.937, 27.937)),
    (307208, (3.633, 18.677, 20.502)),
    (137367, (5.939, 10.832, 27.488)),
    (311501, (5.854, 15.002, 29.784)),
    (32716, (4.843, 16.105, 28.629)),
    (836663, (7.547, 14.443, 29.842)),
    (755082, (7.515, 16.986, 24.728)),
    (939441, (8.007, 12.382, 24.001)),
    (416929, (9.789, 16.372, 24.081)),
    (325497, (4.021, 18.364, 29.368)),
    (408519, (6.687, 19.551, 25.669)),
    (638004, (7.440, 11.321, 21.110)),
    (138597, (0.796, 10.371, 21.306)),
    (219316, (3.075, 14.223, 24.266)),
    (804767, (1.841, 16.115, 22.623)),
    (152204, (6.916, 18.646, 20.402)),
    (491358, (2.438, 19.964, 23.792)),
    (315732, (2.755, 14.040, 28.627)),
    (833665, (1.261, 11.583, 24.312)),
    (470447, (2.218, 14.025, 28.338)),
    (543848, (0.940, 13.268, 28.524)),
    (635037, (9.771, 11.176, 24.320)),
    (841778, (2.505, 19.415, 20.910)),
    (393682, (0.108, 19.521, 28.139)),
    (235525, (0.760, 10.550, 25.543)),
    (976161, (8.929, 13.915, 20.734)),
    (317147, (2.007, 11.985, 25.752)),
    (512030, (6.288, 14.321, 22.290)),
    (185724, (5.769, 10.670, 20.021)),
    (450535, (7.642, 15.452, 24.868)),
    (267026, (4.024, 18.613, 24.157)),
    (959487, (3.072, 11.047, 21.400)),
    (974832, (9.524, 13.922, 26.129)),
    (591141, (6.244, 13.169, 29.037)),
    (740578, (5.775, 16.041, 24.861)),
    (643029, (5.618, 18.832, 24.364)),
    (33018, (9.907, 11.727, 24.425)),
    (225711, (3.948, 12.766, 26.760)),
    (930872, (8.432, 11.450, 29.714)),
    (831175, (5.954, 10.732, 25.963)),
    (344048, (8.522, 18.145, 26.472)),
    (993415, (8.977, 15.509, 23.590)),
    (449865, (5.388, 18.683, 25.003)),
    (688525, (4.267, 17.272, 20.629)),
    (771730, (6.119, 19.193, 28.255)),
    (705865, (8.389, 16.850, 22.197)),
    (384124, (3.003, 14.055, 27.461)),
    (604891, (0.221, 15.333, 29.045)),
    (268068, (4.168, 13.920, 26.216)),
    (607089, (2.448, 16.719, 24.405)),
    (447806, (3.697, 15.730, 24.962)),
    (614164, (2.940, 19.669, 29.968)),
    (698578, (2.985, 19.599, 22.745)),
    (507284, (3.485, 12.659, 22.102)),
    (990446, (6.203, 19.529, 25.384)),
    (646331, (0.869, 18.791, 23.102)),
    (380984, (2.242, 13.470, 23.909)),
    (688838, (5.309, 16.923, 21.183)),
    (639746, (8.649, 11.562, 21.009)),
    (46219, (6.328, 18.646, 26.634)),
    (642121, (5.116, 15.191, 27.317)),
    (742587, (6.981, 17.039, 27.306)),
    (701647, (4.434, 11.552, 29.994)),
    (489746, (5.509, 19.788, 20.243)),
    (719646, (0.404, 14.504, 23.260)),
    (235415, (8.813, 17.446, 22.032)),
    (628359, (7.874, 13.907, 22.915)),
    (313406, (2.789, 10.936, 22.834)),
    (971620, (3.590, 17.140, 29.687)),
    (584008, (8.028, 13.183, 24.321)),
    (50181, (5.159, 11.044, 20.431)),
    (765849, (4.842, 16.382, 27.055)),
    (269239, (0.494, 13.032, 25.448)),
    (664806, (9.266, 16.976, 28.322)),
    (119078, (7.837, 12.616, 26.740)),
    (902147, (3.692, 17.862, 28.066)),
    (423996, (4.835, 11.246, 28.908)),
    (648670, (3.191, 16.022, 20.871)),
    (178325, (9.524, 13.767, 27.875)),
    (805152, (2.871, 19.091, 25.152)),
    (434577, (2.935, 17.212, 29.305)),
    (19762, (9.300, 18.675, 22.114)),
    (945243, (8.004, 18.962, 23.989)),
    (740083, (0.931, 17.955, 25.976)),
    (418867, (2.950, 16.748, 24.721)),
    (167768, (7.325, 19.345, 23.526)),
    (83450, (7.652, 10.904, 25.386)),
    (452299, (3.306, 19.069, 29.180)),
    (649846, (6.730, 13.823, 23.459)),
    (847291, (9.298, 10.702, 28.498)),
    (883221, (6.974, 16.902, 21.117)),
    (812858, (3.258, 16.653, 20.263)),
    (409692, (9.762, 17.431, 22.705)),
    (678399, (7.543, 15.456, 29.451)),
    (888535, (3.045, 12.026, 29.499)),
    (919454, (8.874, 14.037, 25.547)),
    (440563, (9.537, 18.892, 22.901)),
    (494082, (8.678, 11.800, 26.556)),
    (429419, (5.309, 12.778, 25.350)),
    (81247, (2.382, 13.189, 28.935)),
    (923586, (2.897, 13.436, 25.584)),
    (137591, (6.738, 16.049, 25.931)),
    (565315, (0.744, 15.638, 26.783)),
    (738991, (3.797, 13.590, 20.964)),
    (155142, (4.341, 17.539, 26.475)),
    (910725, (2.122, 17.504, 23.078)),
    (30602, (6.603, 16.130, 27.729)),
    (546914, (2.346, 12.289, 29.835)),
    (234642, (2.367, 16.802, 21.021)),
    (135550, (1.557, 18.114, 20.659)),
    (694114, (0.723, 11.005, 24.288)),
    (605486, (7.562, 16.417, 21.961)),
    (860734, (9.064, 16.604, 29.366)),
    (696625, (5.557, 17.109, 23.269)),
    (764896, (3.911, 19.694, 25.912)),
    (864384, (4.181, 15.780, 23.833)),
    (785148, (6.027, 11.255, 23.661)),
    (626271, (2.291, 17.985, 23.655)),
    (80173, (2.322, 12.573, 23.602)),
    (216486, (6.424, 10.549, 26.249)),
    (292176, (4.570, 18.368, 26.833)),
    (319022, (1.703, 12.199, 27.645)),
    (817920, (0.703, 12.674, 20.203)),
    (395632, (6.655, 10.738, 20.846)),
    (576707, (5.417, 17.639, 21.347)),
    (330961, (7.641, 16.681, 21.063)),
    (96812, (7.838, 18.440, 27.211)),
    (762992, (4.692, 19.151, 20.817)),
    (37775, (4.279, 15.654, 27.155)),
    (433816, (9.937, 10.759, 21.009)),
    (849445, (9.175, 11.240, 29.411)),
    (221861, (3.411, 12.594, 23.075)),
    (750217, (4.456, 13.233, 20.494)),
    (918633, (3.018, 10.131, 24.189)),
    (826429, (1.615, 10.063, 25.830)),
    (195800, (2.390, 10.046, 23.792)),
    (329346, (2.552, 15.354, 22.686)),
    (784387, (9.625, 13.626, 23.488)),
    (94810, (7.028, 11.235, 24.297)),
    (984265, (8.216, 11.007, 22.480)),
    (316618, (5.556, 12.595, 22.315)),
    (563360, (1.385, 11.617, 28.228)),
    (897041, (6.564, 18.018, 23.789)),
    (674536, (3.950, 13.944, 24.944)),
    (828547, (4.097, 17.538, 25.408)),
    (31251, (3.434, 11.779, 28.802)),
    (342210, (6.966, 13.411, 29.490)),
    (299021, (0.522, 14.589, 27.917)),
    (882795, (4.176, 15.788, 26.512)),
    (549781, (5.612, 10.568, 23.761)),
    (571760, (2.297, 11.438, 28.908)),
    (199766, (2.185, 10.659, 20.700)),
    (58977, (6.188, 13.303, 26.825)),
    (920914, (2.496, 15.711, 27.139)),
    (98827, (7.736, 13.014, 23.251)),
    (780623, (3.511, 19.613, 26.930)),
    (61468, (8.717, 15.389, 24.178)),
    (656467, (2.437, 14.644, 24.963)),
    (236514, (4.673, 14.120, 29.456)),
    (725434, (9.078, 18.514, 27.345)),
    (461603, (2.044, 10.615, 25.459)),
    (245828, (8.501, 11.061, 24.398)),
    (967240, (0.222, 11.624, 21.338)),
    (352019, (1.857, 10.320, 27.367)),
    (679986, (3.398, 14.745, 21.964)),
    (380293, (7.891, 10.522, 20.464)),
    (153493, (2.128, 14.865, 26.067)),
    (671483, (2.871, 17.161, 25.255)),
    (770324, (2.671, 14.974, 21.588)),
    (317838, (6.788, 13.657, 26.945)),
    (567965, (6.097, 11.701, 26.106)),
    (814189, (3.799, 15.751, 27.255)),
    (72291, (8.867, 17.009, 28.751)),
    (695626, (3.100, 17.425, 20.248)),
    (406710, (9.019, 18.260, 25.198)),
    (704037, (9.484, 13.515, 27.700)),
    (790219, (8.734, 10.540, 23.728)),
    (965282, (1.854, 10.229, 25.501)),
    (256477, (7.343, 15.195, 26.661)),
    (269357, (8.055, 11.733, 22.403)),
    (938332, (1.974, 15.284, 21.642)),
    (403768, (4.043, 11.278, 22.492)),
    (715759, (4.280, 13.965, 29.392)),
    (222600, (5.199, 16.891, 21.265)),
    (28628, (4.136, 16.228, 28.794)),
    (873650, (5.976, 14.129, 26.961)),
    (768787, (3.887, 15.991, 27.161)),
    (468803, (8.957, 18.632, 24.262)),
    (511748, (5.687, 14.862, 28.223)),
    (112888, (4.329, 13.996, 23.069)),
    (635992, (8.004, 11.987, 28.174)),
    (991112, (4.198, 10.373, 23.303)),
    (90612, (7.965, 19.609, 26.294)),
    (559567, (9.658, 13.802, 28.804)),
    (977912, (2.748, 14.021, 21.680)),
    (518781, (4.928, 10.058, 28.705)),
    (798553, (8.457, 15.331, 21.292)),
    (27491, (2.453, 16.099, 27.140)),
    (662788, (5.662, 13.999, 29.495)),
    (789057, (3.691, 17.526, 23.865)),
    (126473, (0.709, 19.556, 29.442)),
    (29129, (3.077, 11.202, 21.655)),
    (704250, (7.947, 18.029, 29.898)),
    (90155, (0.727, 14.368, 23.235)),
    (443, (0.656, 10.895, 27.083)),
    (798667, (2.748, 11.625, 20.149)),
    (303805, (2.167, 10.780, 27.828)),
    (969881, (1.796, 16.928, 26.075)),
    (862380, (3.863, 15.172, 29.329)),
    (774311, (6.673, 17.537, 20.816)),
    (16509, (8.399, 10.569, 26.000)),
    (691002, (3.801, 18.373, 21.068)),
    (726327, (6.748, 16.313, 26.020)),
    (794488, (9.082, 11.663, 21.605)),
    (378725, (4.135, 12.033, 20.199)),
    (605041, (0.772, 15.220, 25.135)),
    (617703, (5.598, 15.211, 21.952)),
    (73889, (5.683, 14.987, 20.437)),
    (79593, (4.020, 14.639, 21.377)),
    (787326, (8.235, 13.765, 27.748)),
    (83494, (9.095, 17.753, 21.179)),
    (281724, (9.504, 13.231, 29.560)),
    (918458, (7.699, 14.373, 24.753)),
    (324683, (4.844, 18.441, 22.053)),
    (945577, (4.310, 14.365, 28.438)),
    (84, (6.505, 13.490, 20.436)),
    (375246, (9.064, 14.584, 29.374)),
    (613939, (7.641, 17.811, 25.998)),
    (737106, (7.857, 12.850, 25.799)),
    (479628, (0.361, 16.249, 23.516)),
    (741244, (0.419, 13.627, 20.184)),
    (603817, (2.325, 12.389, 25.099)),
    (760387, (4.206, 11.638, 24.887)),
    (588092, (5.492, 11.169, 26.147)),
    (212787, (2.368, 13.844, 28.203)),
    (903415, (5.593, 14.393, 21.505)),
    (423137, (1.496, 17.741, 22.226)),
    (170953, (9.158, 13.405, 26.863)),
    (533554, (9.523, 17.754, 25.414)),
    (279533, (0.326, 19.012, 29.921)),
    (30086, (2.157, 16.336, 23.457)),
    (418322, (6.878, 16.987, 29.371)),
    (722582, (8.646, 15.529, 26.399)),
    (78756, (2.663, 14.331, 22.997)),
    (493572, (2.484, 13.180, 28.970)),
    (201359, (7.730, 10.525, 24.605)),
    (330377, (5.420, 16.274, 23.363)),
    (847390, (0.780, 10.807, 28.676)),
    (622179, (8.222, 18.393, 20.840)),
    (194820, (0.536, 12.897, 29.879)),
    (76177, (2.409, 15.358, 21.458)),
    (791985, (0.796, 10.628, 29.612)),
    (475560, (4.634, 13.927, 26.445)),
    (35805, (0.528, 19.218, 29.382)),
    (976797, (0.615, 13.972, 22.098)),
    (636236, (1.348, 13.652, 25.456)),
    (339024, (5.520, 11.226, 20.949)),
    (583418, (3.132, 17.540, 25.948)),
    (775183, (1.857, 13.337, 26.046)),
    (914768, (9.162, 16.532, 29.027)),
    (439508, (5.220, 13.883, 26.757)),
    (853650, (1.525, 16.394, 24.420)),
    (731314, (0.361, 14.682, 25.188)),
    (426213, (1.359, 12.420, 24.536)),
    (775692, (0.992, 12.451, 20.885)),
    (15578, (7.804, 14.562, 22.215)),
    (429125, (0.305, 18.158, 23.260)),
    (960593, (0.125, 17.252, 27.788)),
    (145293, (8.495, 12.098, 21.226)),
    (320655, (5.492, 15.735, 28.832)),
    (184894, (8.885, 18.891, 23.875)),
    (473960, (5.442, 19.654, 29.830)),
    (714905, (6.531, 17.208, 25.339)),
    (547415, (9.503, 17.960, 24.921)),
    (529422, (8.542, 15.335, 24.592)),
    (639530, (2.939, 11.513, 27.059)),
    (130440, (5.502, 14.353, 24.384)),
    (718622, (8.856, 15.286, 20.472)),
    (836276, (1.682, 13.414, 20.197)),
    (28353, (3.039, 15.496, 20.232)),
    (391082, (6.204, 18.235, 20.982)),
    (397094, (0.646, 19.647, 26.643)),
    (221470, (5.309, 13.460, 20.692)),
    (956530, (8.965, 16.899, 26.258)),
    (913657, (5.581, 18.782, 26.647)),
    (564576, (5.767, 18.338, 25.154)),
    (926286, (9.482, 13.632, 24.267)),
    (422356, (3.749, 15.199, 28.805)),
    (174105, (7.217, 15.743, 20.445)),
    (379594, (8.029, 10.779, 26.357)),
    (895807, (8.217, 16.485, 21.147)),
    (320755, (9.310, 14.616, 22.435)),
    (297152, (3.101, 11.113, 24.934)),
    (477766, (5.918, 19.219, 20.150)),
    (463675, (5.138, 17.133, 23.483)),
    (429618, (5.625, 10.194, 27.401)),
    (855259, (0.461, 15.927, 23.128)),
    (77232, (0.719, 14.867, 28.230)),
    (15818, (1.814, 13.660, 25.697)),
    (363035, (1.742, 13.198, 26.003)),
    (609899, (5.646, 11.970, 25.989)),
    (278872, (8.720, 17.777, 29.428)),
    (121184, (6.049, 12.994, 26.428)),
    (141590, (2.266, 11.090, 24.029)),
    (662043, (4.207, 19.730, 20.918)),
    (324425, (2.136, 14.694, 21.531)),
    (330844, (5.971, 11.166, 27.973)),
    (910664, (2.556, 16.569, 28.989)),
    (333702, (6.547, 12.096, 28.835)),
    (624241, (2.200, 12.133, 27.891)),
    (345930, (2.140, 14.829, 25.898)),
    (40699, (9.859, 13.090, 24.304)),
    (217807, (7.769, 16.145, 26.926)),
    (588631, (7.120, 10.671, 20.061)),
    (688295, (2.040, 18.503, 24.197)),
    (784434, (5.271, 18.005, 21.250)),
    (345798, (7.126, 10.604, 23.259)),
    (36951, (4.344, 19.699, 29.386)),
    (790384, (0.890, 18.885, 20.966)),
    (384566, (8.206, 16.722, 29.292)),
    (75360, (9.021, 15.552, 28.508)),
    (815378, (7.722, 10.154, 24.924)),
    (79572, (9.418, 17.420, 20.421)),
    (796578, (1.077, 15.327, 21.534)),
    (121293, (1.121, 11.331, 25.198)),
    (256155, (9.970, 17.478, 28.682)),
    (124436, (5.176, 14.167, 21.969)),
    (271160, (3.414, 10.108, 25.268)),
    (744196, (2.806, 11.230, 23.250)),
    (687794, (9.964, 10.109, 23.159)),
    (567733, (7.703, 17.859, 22.204)),
    (769017, (8.724, 19.190, 28.943)),
    (520659, (5.327, 16.313, 26.588)),
    (640405, (4.450, 18.628, 22.842)),
    (108869, (1.458, 11.488, 20.620)),
    (618407, (9.189, 10.391, 24.835)),
    (302929, (3.705, 18.053, 23.185)),
    (600308, (5.918, 18.315, 29.122)),
    (874719, (8.218, 15.292, 23.644)),
    (826402, (7.791, 17.932, 27.412)),
    (817147, (0.192, 16.805, 27.241)),
    (592569, (4.380, 14.173, 21.137)),
    (560709, (5.612, 14.955, 27.967)),
    (383700, (9.953, 14.398, 26.712)),
    (230957, (0.584, 10.767, 23.204)),
    (749471, (4.996, 14.728, 29.330)),
    (345259, (1.265, 17.196, 27.515)),
    (10619, (8.218, 14.353, 24.996)),
    (398601, (3.588, 13.923, 24.115)),
    (343450, (0.425, 13.964, 28.020)),
    (1620, (4.494, 15.225, 29.366)),
    (288194, (7.527, 13.448, 23.888)),
    (488541, (8.673, 19.707, 22.226)),
    (67513, (2.952, 14.232, 20.621)),
    (765266, (8.933, 17.254, 20.966)),
    (127645, (0.336, 19.255, 25.816)),
    (754568, (8.822, 15.740, 29.293)),
    (834661, (8.150, 19.848, 24.032)),
    (885680, (1.056, 17.802, 27.566)),
    (14310, (3.002, 19.416, 20.352)),
    (379268, (0.268, 15.135, 25.114)),
    (451404, (0.805, 19.786, 21.467)),
    (646546, (6.036, 12.766, 23.243)),
    (168200, (7.193, 13.589, 24.097)),
    (422214, (7.873, 11.775, 29.183)),
    (399043, (7.845, 13.468, 25.513)),
    (565037, (3.134, 11.380, 20.569)),
    (702991, (8.302, 19.884, 25.501)),
    (669198, (3.377, 12.701, 28.365)),
    (234874, (6.409, 10.908, 24.548)),
    (656805, (2.237, 19.014, 29.091)),
    (863298, (5.777, 14.179, 25.289)),
    (765926, (9.527, 15.120, 27.212)),
    (716675, (3.293, 17.175, 25.820)),
    (437917, (2.612, 17.348, 23.709)),
    (115068, (4.921, 10.709, 22.960)),
    (358177, (3.814, 19.751, 24.828)),
    (726860, (6.211, 12.436, 26.659)),
    (793693, (3.545, 17.776, 29.647)),
    (678196, (7.372, 11.635, 20.007)),
    (952990, (7.839, 19.025, 28.973)),
    (552485, (5.592, 19.771, 20.467)),
    (843284, (1.365, 10.031, 26.072)),
    (958563, (7.512, 15.307, 23.880)),
    (386726, (0.715, 10.256, 23.227)),
    (575549, (1.348, 11.056, 29.905)),
    (629454, (2.134, 18.316, 21.227)),
    (563553, (7.605, 18.502, 21.851)),
    (546980, (8.126, 14.552, 27.036)),
    (955008, (3.032, 14.393, 22.785)),
    (754187, (1.435, 15.600, 29.451)),
    (26131, (0.823, 15.439, 20.554)),
    (463587, (6.138, 14.856, 26.234)),
    (219465, (9.560, 12.379, 23.576)),
    (310551, (6.604, 16.811, 25.551)),
    (916897, (7.235, 12.913, 22.583)),
    (622552, (5.982, 19.190, 24.604)),
    (300004, (8.589, 18.321, 26.914)),
    (785538, (9.247, 15.338, 21.188)),
    (598311, (8.584, 12.525, 20.501)),
    (114951, (5.958, 11.753, 24.074)),
    (964858, (4.314, 12.873, 20.276)),
    (261033, (3.433, 11.755, 21.769)),
    (509338, (0.886, 16.945, 22.936)),
    (276390, (8.833, 14.839, 21.841)),
    (331148, (0.353, 16.424, 21.523)),
    (266617, (1.893, 10.209, 29.285)),
    (647670, (9.660, 15.398, 29.527)),
    (705138, (9.585, 16.105, 23.631)),
    (308820, (5.419, 19.985, 22.650)),
    (681486, (2.641, 11.673, 24.899)),
    (382001, (4.005, 11.052, 24.663)),
    (208587, (3.282, 15.981, 24.330)),
    (582323, (0.115, 10.888, 27.177)),
    (294149, (8.329, 15.480, 22.259)),
    (717495, (1.930, 10.310, 27.257)),
    (817600, (8.002, 18.164, 29.146)),
    (269722, (2.141, 18.295, 20.606)),
    (52354, (9.245, 14.163, 27.213)),
    (689647, (5.969, 18.769, 28.250)),
    (653121, (4.704, 19.859, 21.437)),
    (865250, (6.623, 10.411, 24.918)),
    (970970, (5.058, 10.544, 29.849)),
    (406361, (5.635, 12.744, 21.874)),
    (18498, (2.878, 18.656, 26.489)),
    (997129, (7.587, 12.853, 28.209)),
    (757412, (4.824, 11.460, 24.638)),
    (501376, (5.764, 15.029, 26.944)),
    (621241, (9.612, 12.525, 25.856)),
    (711731, (7.526, 14.798, 29.622)),
    (375322, (8.777, 12.334, 22.604)),
    (377563, (0.680, 12.739, 25.470)),
    (266139, (3.987, 19.014, 20.430)),
    (513609, (9.122, 19.832, 28.625)),
    (134495, (4.682, 15.146, 26.782)),
    (10157, (1.109, 10.243, 22.922)),
    (313020, (3.854, 14.155, 28.862)),
    (811005, (3.924, 12.740, 27.530)),
    (70196, (8.633, 13.433, 21.981)),
    (646703, (1.531, 15.077, 20.253)),
    (765110, (8.605, 10.128, 24.001)),
    (570839, (6.735, 12.072, 22.716)),
    (431796, (0.283, 10.672, 20.436)),
    (917297, (2.535, 19.605, 20.887)),
    (770095, (5.188, 15.366, 26.737)),
    (466907, (1.816, 12.796, 27.303)),
    (606455, (3.898, 10.274, 29.770)),
    (433224, (8.916, 14.231, 26.457)),
    (978023, (0.724, 11.279, 26.666)),
    (98732, (3.469, 11.039, 28.404)),
    (306011, (4.245, 10.760, 24.818)),
    (783633, (4.475, 12.114, 29.998)),
    (14857, (5.380, 19.251, 28.538)),
    (420060, (4.034, 13.179, 21.748)),
    (521540, (0.965, 14.285, 27.574)),
    (834434, (4.175, 11.487, 29.737)),
    (499680, (7.310, 10.439, 29.809)),
    (989912, (0.662, 11.973, 22.265)),
    (360180, (5.615, 17.147, 23.918)),
    (697064, (3.638, 17.095, 28.948)),
    (507240, (8.294, 14.781, 25.914)),
    (970271, (6.543, 17.569, 22.893)),
    (149687, (5.013, 12.990, 20.117)),
    (863333, (2.746, 15.368, 20.875)),
    (194209, (3.152, 10.815, 26.223)),
    (956314, (7.347, 15.002, 20.243)),
    (581468, (0.486, 15.357, 22.578)),
    (413502, (0.599, 13.404, 25.038)),
    (797206, (4.498, 16.911, 28.306)),
    (752284, (1.630, 16.953, 20.701)),
    (540379, (6.276, 14.404, 23.807)),
    (517060, (2.936, 18.673, 22.500)),
    (965651, (6.794, 19.484, 26.407)),
    (276251, (0.171, 15.695, 23.132)),
    (179489, (5.695, 11.379, 24.129)),
    (243969, (9.135, 11.684, 24.377)),
    (539655, (4.633, 11.448, 22.757)),
    (484204, (9.727, 17.611, 28.102)),
    (253710, (2.125, 10.469, 26.615)),
    (203590, (2.223, 17.569, 27.010)),
    (371854, (2.592, 10.246, 21.817)),
    (606077, (9.824, 17.545, 26.240)),
    (145589, (5.664, 13.348, 25.560)),
    (23878, (2.543, 12.598, 26.022)),
    (778258, (3.030, 13.976, 28.021)),
    (944859, (8.901, 16.302, 22.646)),
    (691352, (4.824, 19.314, 24.655)),
    (31801, (1.629, 10.408, 22.119)),
    (977950, (0.507, 13.452, 28.527)),
    (149088, (1.529, 16.744, 26.158)),
    (552614, (4.268, 14.920, 26.834)),
    (825893, (9.030, 12.938, 20.175)),
    (311625, (1.556, 16.888, 29.842)),
    (710594, (6.795, 10.998, 26.678)),
    (671415, (9.745, 15.974, 25.484)),
    (279203, (9.540, 17.510, 26.604)),
    (468724, (4.721, 19.894, 25.224)),
    (346559, (2.292, 13.257, 28.723)),
    (376064, (8.644, 11.340, 27.386)),
    (700697, (8.301, 13.115, 20.509)),
    (315601, (7.700, 14.032, 29.602)),
    (302558, (1.467, 12.213, 27.525)),
    (207285, (2.400, 17.641, 27.866)),
    (925740, (8.525, 18.930, 26.126)),
    (227401, (3.177, 11.968, 23.780)),
    (328670, (5.776, 10.673, 27.787)),
    (235796, (0.720, 18.541, 27.272)),
    (370903, (4.936, 17.645, 24.859)),
    (381630, (0.760, 13.368, 22.637)),
    (803111, (4.772, 12.091, 26.410)),
    (531011, (2.432, 19.912, 21.342)),
    (357784, (4.652, 10.754, 21.213)),
    (245982, (9.986, 16.010, 29.926)),
    (44142, (6.464, 16.378, 27.559)),
    (324046, (8.980, 10.536, 23.854)),
    (745649, (3.345, 14.984, 21.601)),
    (262514, (2.623, 11.424, 20.432)),
    (991759, (3.965, 19.243, 20.438)),
    (902440, (7.938, 12.512, 28.005)),
    (916836, (9.290, 15.034, 22.258)),
    (422353, (3.510, 18.000, 26.299)),
    (406279, (8.933, 13.559, 24.402)),
    (12260, (2.412, 14.617, 20.098)),
    (838004, (2.745, 19.773, 23.910)),
    (655444, (0.275, 16.054, 26.980)),
    (236391, (5.672, 13.615, 23.999)),
    (874103, (9.767, 17.228, 21.955)),
    (524344, (3.539, 15.291, 26.051)),
    (637215, (6.085, 11.759, 29.208)),
    (346991, (9.400, 18.921, 21.658)),
    (734055, (0.703, 13.357, 23.252)),
    (1382, (6.725, 16.435, 23.307)),
    (18694, (2.931, 17.252, 23.789)),
    (264094, (5.458, 12.179, 27.957)),
    (842625, (4.229, 14.848, 26.421)),
    (905582, (4.178, 19.325, 27.730)),
    (601638, (3.935, 10.626, 29.916)),
    (880359, (4.421, 13.561, 26.491)),
    (728387, (0.196, 12.349, 29.356)),
    (739147, (0.058, 18.962, 26.904)),
    (741842, (0.851, 18.326, 28.967)),
    (490819, (4.192, 12.847, 27.872)),
    (102599, (5.509, 13.677, 27.113)),
    (167786, (7.987, 16.818, 21.680)),
    (800124, (7.934, 13.542, 28.392)),
    (183383, (9.235, 18.402, 20.690)),
    (489403, (4.698, 15.714, 27.578)),
    (354989, (3.035, 14.018, 27.142)),
    (247828, (2.867, 18.328, 25.141)),
    (456139, (3.825, 12.027, 28.733)),
    (840659, (1.441, 15.119, 22.972)),
    (971906, (4.237, 10.616, 23.679)),
    (674226, (7.776, 17.053, 23.605)),
    (339009, (9.555, 15.909, 23.244)),
    (263284, (5.049, 10.910, 21.106)),
    (118785, (5.025, 17.643, 24.984)),
    (989191, (0.354, 16.586, 25.333)),
    (172379, (5.080, 10.504, 26.299)),
    (919745, (2.275, 18.574, 21.972)),
    (813567, (8.087, 14.189, 28.460)),
    (449798, (4.011, 12.838, 26.580)),
    (359543, (3.807, 17.522, 25.097)),
    (1916, (0.737, 17.690, 26.005)),
    (438409, (1.037, 16.584, 25.518)),
    (391167, (9.921, 19.499, 23.027)),
    (5731, (8.592, 17.548, 26.927)),
    (225613, (8.111, 19.074, 24.296)),
    (336027, (2.507, 11.428, 29.670)),
    (468112, (8.266, 14.363, 22.165)),
    (97849, (9.730, 16.844, 28.487)),
    (679703, (1.477, 19.751, 22.545)),
    (13014, (8.809, 19.757, 22.630)),
    (653540, (3.214, 15.203, 27.812)),
    (868170, (4.922, 18.985, 26.259)),
    (276235, (7.375, 19.819, 20.908)),
    (690073, (8.827, 12.652, 26.253)),
    (329980, (7.147, 11.046, 25.156)),
    (878718, (1.769, 14.244, 26.284)),
    (590301, (0.825, 18.519, 27.286)),
    (804358, (0.096, 14.448, 28.287)),
    (864717, (2.293, 19.208, 27.989)),
    (475542, (1.031, 18.181, 26.632)),
    (222555, (7.253, 12.019, 29.180)),
    (996770, (5.794, 11.212, 25.464)),
    (846342, (0.769, 18.953, 27.945)),
    (643871, (6.539, 15.887, 24.433)),
    (203886, (4.682, 19.749, 25.914)),
    (868290, (4.472, 17.956, 22.534)),
    (724973, (3.811, 19.890, 20.164)),
    (495016, (4.842, 14.266, 27.628)),
    (855583, (8.369, 16.660, 21.603)),
    (214138, (4.827, 17.081, 26.225)),
    (392428, (7.522, 12.577, 20.958)),
    (424231, (0.266, 12.731, 28.600)),
    (142352, (1.569, 19.419, 24.122)),
    (507130, (3.745, 12.477, 29.372)),
    (672521, (4.573, 13.309, 25.513)),
    (546121, (3.740, 16.065, 25.491)),
    (626594, (0.156, 19.608, 23.935)),
    (441834, (0.340, 15.868, 20.579)),
    (143105, (7.696, 11.171, 23.657)),
    (927266, (6.860, 11.068, 21.108)),
    (624832, (0.286, 15.539, 22.539)),
    (276451, (5.434, 14.199, 26.908)),
    (330621, (9.141, 14.487, 22.913)),
    (155729, (8.186, 18.804, 25.187)),
    (551972, (5.369, 12.320, 29.490)),
    (487012, (2.041, 16.177, 23.801)),
    (539891, (8.557, 13.163, 27.497)),
    (364089, (5.902, 15.507, 22.726)),
    (986173, (3.894, 19.468, 26.224)),
    (793609, (7.138, 17.162, 20.375)),
    (679266, (7.091, 16.928, 26.557)),
    (468833, (5.692, 12.405, 28.303)),
    (188783, (8.026, 19.989, 28.273)),
    (578360, (4.600, 12.788, 26.470)),
    (670970, (1.441, 16.068, 22.186)),
    (655411, (4.078, 12.174, 25.481)),
    (829559, (6.095, 17.831, 22.853)),
    (865775, (3.869, 16.050, 24.905)),
    (597746, (5.936, 10.558, 22.970)),
    (942454, (0.357, 19.126, 25.927)),
    (431007, (5.210, 12.492, 24.222)),
    (963645, (4.355, 13.084, 28.094)),
    (672246, (0.912, 13.649, 25.469)),
    (531829, (7.427, 14.904, 22.626)),
    (401772, (5.430, 11.752, 25.356)),
    (868080, (4.604, 12.013, 26.885)),
    (643826, (9.507, 17.028, 23.888)),
    (575376, (8.899, 10.456, 27.667)),
    (577020, (7.131, 17.211, 29.220)),
    (317347, (2.240, 19.373, 25.423)),
    (326206, (5.032, 18.741, 20.198)),
    (310995, (6.444, 18.897, 23.157)),
    (57426, (7.000, 12.166, 24.399)),
    (628367, (6.166, 16.939, 22.621)),
    (560259, (6.021, 18.387, 26.576)),
    (471820, (5.574, 14.457, 28.822)),
    (134099, (0.741, 11.507, 22.706)),
    (66436, (6.744, 10.116, 29.582)),
    (507804, (9.423, 11.871, 27.047)),
    (567442, (5.904, 11.434, 29.333)),
    (884638, (5.719, 16.954, 27.343)),
    (329161, (6.972, 15.244, 22.864)),
    (161380, (0.807, 15.406, 28.401)),
    (304159, (0.938, 14.853, 26.290)),
    (380349, (2.777, 19.800, 25.981)),
    (532290, (8.323, 12.277, 29.005)),
    (428764, (3.387, 15.825, 28.124)),
    (545225, (7.458, 16.735, 26.506)),
    (75065, (8.625, 13.620, 28.938)),
    (650933, (9.700, 19.488, 26.529)),
    (126516, (9.423, 19.409, 25.372)),
    (365181, (2.877, 14.941, 23.380)),
    (180815, (8.602, 18.468, 26.947)),
    (382304, (2.527, 16.402, 26.217)),
    (527, (0.405, 18.885, 23.040)),
    (619639, (9.341, 11.706, 21.785)),
    (227330, (3.544, 10.355, 24.002)),
    (917560, (6.198, 11.674, 23.122)),
    (197616, (2.299, 15.037, 26.868)),
    (305359, (7.967, 10.236, 21.943)),
    (954945, (5.251, 13.823, 23.633)),
    (461813, (6.201, 15.732, 21.399)),
    (746805, (0.972, 10.224, 26.806)),
    (312208, (3.725, 13.505, 23.475)),
    (692135, (2.320, 16.601, 23.301)),
    (746972, (3.752, 11.112, 24.827)),
    (212640, (5.587, 15.697, 28.371)),
    (109387, (5.505, 10.102, 26.676)),
    (782711, (8.131, 14.067, 21.930)),
    (257493, (9.590, 15.664, 25.308)),
    (241591, (0.435, 16.042, 21.339)),
    (789167, (6.021, 17.448, 23.176)),
    (128696, (5.196, 15.768, 22.120)),
    (52627, (5.979, 19.033, 29.024)),
    (452309, (7.969, 11.743, 24.794)),
    (706295, (9.811, 12.535, 21.553)),
    (99492, (3.631, 13.222, 29.930)),
    (808365, (7.233, 17.364, 25.988)),
    (196492, (6.416, 18.221, 22.287)),
    (867252, (6.957, 10.114, 25.343)),
    (549247, (7.843, 17.814, 26.212)),
    (784415, (7.052, 14.185, 22.596)),
    (522785, (9.558, 12.664, 29.632)),
    (697544, (1.150, 16.976, 26.169)),
    (261167, (8.264, 11.112, 23.506)),
    (827172, (2.248, 10.132, 28.116)),
    (232189, (1.060, 16.212, 21.397)),
    (504273, (1.200, 17.700, 27.617)),
    (588451, (8.415, 15.250, 20.769)),
    (817941, (6.794, 19.938, 28.673)),
    (774859, (6.643, 16.534, 21.762)),
    (792852, (7.261, 16.316, 28.602)),
    (156560, (1.877, 12.003, 20.182)),
    (278085, (5.830, 18.932, 24.476)),
    (205367, (4.657, 12.145, 20.182)),
    (905604, (9.356, 13.795, 20.920)),
    (649421, (6.662, 14.840, 27.135)),
    (416368, (2.152, 15.403, 28.770)),
    (959984, (4.046, 19.877, 21.391)),
    (55703, (1.798, 11.129, 20.233)),
    (771163, (3.208, 16.713, 23.833)),
    (556369, (6.752, 13.558, 20.309)),
    (648330, (5.935, 11.513, 20.546)),
    (331697, (0.996, 14.934, 24.596)),
    (996050, (4.532, 15.601, 23.966)),
    (806823, (9.912, 15.532, 27.653)),
    (538447, (0.559, 10.002, 23.095)),
    (178752, (3.532, 10.233, 27.104)),
    (590624, (4.332, 16.238, 22.271)),
    (757021, (3.487, 11.384, 23.386)),
    (775233, (9.050, 18.644, 26.686)),
    (715866, (5.313, 18.376, 25.540)),
    (289442, (9.966, 17.223, 24.682)),
    (394558, (2.277, 12.939, 24.858)),
    (315254, (1.300, 12.066, 29.491)),
    (150180, (1.434, 11.300, 28.768)),
    (559328, (0.463, 19.487, 29.595)),
    (783655, (1.092, 16.821, 24.319)),
    (618011, (2.802, 11.088, 29.452)),
    (353708, (1.345, 13.969, 24.600)),
    (454333, (8.638, 17.772, 29.812)),
    (901170, (0.782, 18.618, 22.232)),
    (663524, (4.831, 11.851, 24.139)),
    (111126, (9.420, 13.376, 26.790)),
    (38242, (3.770, 18.327, 22.512)),
    (294489, (2.388, 11.219, 20.884)),
    (652561, (6.106, 10.399, 23.632)),
    (336461, (4.899, 15.567, 23.798)),
    (712941, (2.460, 12.664, 25.816)),
    (152198, (6.872, 14.839, 22.027)),
    (82773, (9.658, 11.663, 20.272)),
    (376620, (5.550, 16.232, 22.963)),
    (232991, (4.940, 18.216, 20.666)),
    (945048, (9.058, 19.255, 29.799)),
    (113430, (5.481, 13.419, 29.786)),
    (490226, (0.100, 12.474, 29.380)),
    (990627, (9.386, 15.905, 29.442)),
    (283381, (7.435, 11.362, 24.378)),
    (587488, (2.899, 12.946, 21.645)),
    (335609, (1.627, 14.377, 20.074)),
    (433507, (2.436, 13.091, 26.016)),
    (939015, (9.648, 19.248, 25.969)),
    (937620, (0.539, 12.557, 29.523)),
    (903431, (4.528, 16.117, 29.859)),
    (608228, (8.156, 12.866, 27.896)),
    (737764, (1.593, 17.188, 21.467)),
    (113227, (3.159, 12.878, 20.454)),
    (335173, (0.176, 12.500, 20.179)),
    (198845, (4.949, 11.277, 28.049)),
    (874967, (3.634, 12.551, 20.806)),
    (379693, (1.942, 12.878, 23.831)),
    (569307, (6.294, 13.709, 24.251)),
    (344774, (7.931, 14.017, 23.421)),
    (514429, (3.943, 19.206, 29.002)),
    (215639, (5.030, 18.834, 25.224)),
    (733161, (9.803, 15.607, 28.255)),
    (770476, (4.874, 11.655, 21.260)),
    (129965, (2.060, 16.102, 20.803)),
    (999125, (6.774, 17.243, 23.848)),
    (596883, (8.756, 10.070, 28.814)),
    (416572, (5.774, 16.532, 23.506)),
    (562862, (8.545, 12.093, 26.428)),
    (521307, (1.870, 13.670, 20.632)),
    (163601, (7.434, 15.669, 26.166)),
    (476618, (6.234, 12.889, 29.096)),
    (258049, (7.697, 16.371, 24.694)),
    (79236, (6.369, 14.224, 21.601)),
    (994817, (2.905, 18.617, 29.273)),
    (902300, (9.655, 10.331, 29.531)),
    (355335, (5.343, 13.221, 26.888)),
    (138237, (9.505, 15.678, 28.044)),
    (924414, (2.310, 15.041, 20.681)),
    (243815, (1.194, 11.027, 27.809)),
    (472242, (9.933, 10.225, 24.610)),
    (325253, (5.615, 16.416, 26.613)),
    (471321, (5.644, 14.297, 27.255)),
    (370760, (3.365, 11.308, 29.218)),
    (380473, (6.912, 14.916, 21.988)),
    (126160, (3.444, 14.337, 23.557)),
    (932100, (3.293, 19.181, 28.356)),
    (286039, (1.958, 13.799, 28.007)),
    (579448, (0.371, 15.165, 27.031)),
    (3561, (6.918, 12.440, 23.655)),
    (250317, (8.690, 12.495, 26.969)),
    (293243, (2.575, 14.508, 29.178)),
    (654685, (7.149, 15.899, 21.191)),
    (325294, (2.019, 17.505, 21.188)),
    (779603, (7.084, 14.747, 28.242)),
    (254729, (9.070, 12.005, 25.526)),
    (35616, (8.117, 18.075, 26.987)),
    (211619, (6.305, 17.476, 29.035)),
    (551111, (2.649, 14.595, 28.836)),
    (285759, (7.015, 19.162, 29.276)),
    (603317, (6.491, 19.138, 22.906)),
    (90727, (4.645, 15.359, 24.837)),
    (979425, (5.713, 10.189, 21.856)),
    (656855, (1.985, 11.563, 24.826)),
    (51858, (6.144, 17.727, 20.622)),
    (299637, (3.629, 10.779, 21.584)),
    (523765, (1.810, 16.949, 22.324)),
    (448459, (3.178, 19.272, 29.153)),
    (900322, (0.605, 14.372, 22.656)),
    (490473, (5.937, 18.662, 20.021)),
    (848712, (7.607, 14.533, 21.868)),
    (918299, (4.575, 19.876, 25.435)),
    (888070, (6.169, 14.321, 29.121)),
    (720528, (4.272, 17.956, 22.610)),
    (676898, (0.796, 16.641, 29.852)),
    (206562, (3.927, 12.084, 29.872)),
    (83269, (5.482, 13.220, 26.459)),
    (240321, (4.976, 15.976, 20.144)),
    (583005, (2.380, 19.851, 29.785)),
    (845653, (4.626, 14.043, 27.138)),
    (211313, (4.639, 13.292, 22.118)),
    (446038, (2.090, 17.032, 22.752)),
    (503301, (2.644, 11.386, 20.241)),
    (174301, (6.380, 14.153, 27.759)),
    (107543, (9.670, 11.901, 22.624)),
    (56727, (8.756, 10.424, 25.489)),
    (303287, (7.067, 17.797, 25.437)),
    (803301, (6.094, 17.729, 21.895)),
    (253740, (7.686, 12.052, 24.356)),
    (646965, (6.404, 18.851, 21.787)),
    (370752, (3.691, 14.893, 24.914)),
    (247455, (4.010, 13.966, 29.593)),
    (756277, (0.308, 13.144, 20.756)),
    (650357, (3.696, 17.045, 23.141)),
    (517563, (6.437, 15.482, 23.375)),
    (319256, (1.563, 14.809, 25.484)),
    (129476, (9.168, 19.356, 27.012)),
    (590861, (2.381, 12.364, 20.314)),
    (659942, (8.480, 17.268, 20.533)),
    (495693, (5.488, 14.580, 25.653)),
    (248204, (4.630, 13.241, 20.258)),
    (75811, (6.314, 18.644, 25.497)),
    (362174, (6.168, 17.372, 22.996)),
    (655343, (9.424, 16.272, 25.467)),
    (7620, (2.974, 14.182, 22.951)),
    (945599, (5.232, 18.668, 23.827)),
    (202493, (8.477, 17.130, 28.875)),
    (175698, (2.259, 15.954, 28.528)),
    (329997, (1.334, 13.618, 23.549)),
    (955722, (7.314, 19.552, 25.810)),
    (550419, (0.164, 13.778, 29.021)),
    (96757, (8.781, 16.585, 24.465)),
    (93642, (1.028, 15.355, 25.379)),
    (459730, (8.082, 12.354, 21.093)),
    (869752, (9.454, 13.950, 28.298)),
    (340898, (6.178, 13.717, 26.936)),
    (861524, (5.505, 10.387, 20.696)),
    (649288, (8.584, 15.336, 25.378)),
    (376816, (5.440, 15.990, 22.389)),
    (181336, (5.709, 12.817, 21.349)),
    (328264, (6.337, 17.818, 21.697)),
    (535914, (5.020, 19.706, 24.024)),
    (245896, (2.907, 11.859, 27.742)),
    (4543, (0.491, 16.490, 28.779)),
    (202282, (4.838, 17.313, 23.567)),
    (498350, (0.378, 19.422, 20.131)),
    (697718, (1.716, 11.987, 25.884)),
    (20468, (0.538, 11.779, 20.788)),
    (337709, (1.344, 13.658, 26.841)),
    (858812, (9.518, 13.093, 22.370)),
    (480740, (9.291, 15.137, 26.066)),
    (57763, (8.957, 16.105, 25.428)),
    (86636, (4.154, 14.606, 24.908)),
    (769854, (6.108, 10.773, 24.542)),
    (233040, (6.902, 10.508, 20.741)),
    (106910, (5.168, 17.118, 28.318)),
    (464550, (0.434, 18.157, 23.432)),
    (760637, (5.410, 18.288, 29.820)),
    (108066, (2.954, 17.555, 23.735)),
    (264253, (4.086, 13.319, 26.004)),
    (105648, (9.982, 10.203, 24.046)),
    (431225, (4.705, 18.855, 23.949)),
    (697002, (6.162, 11.023, 26.038)),
    (210549, (9.580, 10.617, 24.857)),
    (70749, (6.132, 14.811, 25.049)),
    (532934, (6.774, 15.583, 25.803)),
    (734625, (1.597, 18.861, 23.038)),
    (514353, (4.970, 10.296, 22.932)),
    (655189, (9.374, 14.021, 23.169)),
    (670345, (6.067, 12.117, 20.755)),
    (156681, (7.075, 12.966, 20.889)),
    (918205, (6.300, 19.738, 28.074)),
    (79303, (6.292, 19.120, 21.436)),
    (160845, (8.194, 10.330, 20.921)),
    (961590, (8.944, 16.065, 20.091)),
    (354986, (6.354, 15.661, 22.412)),
    (469700, (0.424, 12.570, 20.061)),
    (714964, (8.303, 12.085, 25.628)),
    (66048, (2.697, 16.669, 24.404)),
    (185431, (8.539, 14.157, 20.398)),
    (487014, (7.715, 13.439, 26.686)),
    (335309, (1.465, 11.005, 23.532)),
    (585164, (8.237, 11.609, 24.683)),
    (834661, (5.659, 13.112, 29.282)),
    (943282, (5.121, 10.738, 28.854)),
    (85092, (5.516, 13.373, 20.630)),
    (9615, (0.757, 10.785, 28.167)),
    (858242, (2.015, 13.732, 20.443)),
    (78330, (9.007, 10.767, 23.886)),
    (70321, (9.492, 11.659, 28.555)),
    (104227, (1.600, 13.185, 22.774)),
    (427871, (1.419, 13.148, 20.394)),
    (824477, (3.300, 10.421, 28.994)),
    (290340, (5.706, 10.491, 22.050)),
    (816420, (9.137, 18.472, 29.416)),
    (526280, (6.787, 10.967, 29.903)),
    (471399, (6.817, 14.461, 20.978)),
    (120144, (9.851, 15.163, 26.685)),
    (937802, (8.814, 19.373, 20.885)),
    (161970, (8.411, 14.547, 27.673)),
    (110667, (0.570, 12.736, 27.339)),
    (476428, (7.605, 17.054, 23.700)),
    (315123, (4.201, 16.731, 20.957)),
    (20645, (8.660, 18.969, 29.190)),
    (355604, (1.524, 11.763, 26.252)),
    (178722, (1.404, 15.387, 22.128)),
    (803131, (6.457, 19.037, 20.312)),
    (857379, (1.830, 16.013, 22.354)),
    (640000, (4.604, 10.047, 29.358)),
    (699660, (7.572, 12.474, 28.524)),
    (697220, (7.662, 18.584, 20.522)),
    (471651, (5.893, 12.903, 26.176)),
    (798993, (4.944, 18.499, 29.233)),
    (350311, (0.007, 13.982, 20.822)),
    (812639, (6.868, 10.766, 26.549)),
    (125326, (1.704, 16.192, 29.946)),
    (783869, (7.217, 16.262, 29.013)),
    (358433, (5.724, 18.185, 25.015)),
    (454676, (1.580, 18.179, 25.324)),
    (606200, (0.115, 12.078, 22.698)),
    (676326, (5.467, 15.755, 21.215)),
    (300078, (1.811, 13.897, 25.821)),
    (304290, (2.108, 11.700, 24.557)),
    (331091, (3.440, 10.514, 22.808)),
    (877293, (0.362, 17.934, 22.999)),
    (455833, (0.521, 14.478, 21.940)),
    (329256, (1.335, 15.993, 21.418)),
    (136889, (6.223, 17.247, 23.496)),
    (738964, (3.800, 14.595, 23.118)),
    (898666, (6.859, 16.397, 23.807)),
    (218663, (2.989, 17.126, 29.871)),
    (44259, (3.699, 12.093, 29.003)),
    (779955, (7.394, 13.111, 23.347)),
    (530124, (3.444, 17.941, 20.036)),
    (842680, (4.470, 12.092, 21.639)),
    (478609, (5.975, 18.174, 21.369)),
    (552416, (2.918, 19.049, 27.063)),
    (5367, (8.091, 15.898, 23.762)),
    (603678, (5.831, 13.481, 22.437)),
    (873103, (5.971, 13.401, 22.022)),
    (132353, (8.731, 19.796, 21.341)),
    (295491, (7.200, 11.665, 29.075)),
    (349248, (3.469, 11.211, 26.014)),
    (405976, (2.622, 16.570, 28.386)),
    (934275, (8.969, 10.806, 28.246)),
    (392552, (4.606, 10.101, 22.827)),
    (278976, (8.574, 12.987, 26.029)),
    (699493, (9.283, 14.256, 24.242)),
    (808109, (7.135, 14.342, 21.948)),
    (805422, (9.323, 18.222, 20.925)),
    (402684, (4.205, 16.122, 24.689)),
    (70359, (3.744, 10.366, 22.640)),
    (955387, (1.287, 19.458, 21.538)),
    (984188, (0.154, 14.472, 27.461)),
    (318286, (1.022, 18.723, 20.671)),
    (484404, (4.613, 14.982, 27.360)),
    (830578, (1.480, 12.622, 24.165)),
    (243762, (2.026, 12.851, 23.229)),
    (758099, (7.560, 17.952, 27.103)),
    (532134, (0.510, 12.160, 28.810)),
    (409704, (3.392, 14.244, 20.421)),
    (416210, (7.655, 12.733, 22.636)),
    (641664, (6.307, 13.377, 21.693)),
    (968979, (2.242, 10.270, 28.737)),
    (780340, (0.200, 17.080, 22.371)),
    (672537, (4.379, 17.631, 26.236)),
    (408905, (9.804, 15.286, 20.354)),
    (386227, (0.743, 12.161, 22.295)),
    (322642, (3.445, 14.711, 23.795)),
    (500568, (2.414, 10.479, 28.420)),
    (399616, (7.045, 16.499, 22.475)),
    (114317, (1.795, 12.019, 28.375)),
    (500966, (9.334, 16.614, 22.055)),
    (324759, (0.511, 10.864, 25.793)),
    (253965, (1.914, 11.010, 22.970)),
    (376072, (3.832, 16.141, 23.494)),
    (541988, (0.209, 18.574, 20.179)),
    (613021, (9.426, 10.816, 29.454)),
    (21603, (3.220, 14.624, 23.317)),
    (775971, (1.820, 16.234, 25.225)),
    (95000, (4.857, 17.825, 26.524)),
    (472269, (3.816, 13.454, 21.131)),
    (143793, (1.706, 10.337, 24.636)),
    (882722, (7.816, 15.423, 28.307)),
    (705510, (8.678, 13.734, 26.867)),
    (568736, (8.791, 18.544, 24.309)),
    (103812, (1.779, 19.405, 21.448)),
    (438543, (8.126, 13.836, 27.700)),
    (743947, (2.917, 12.700, 22.946)),
    (91580, (6.786, 18.672, 22.999)),
    (196858, (5.237, 17.665, 27.436)),
    (692284, (4.015, 14.970, 27.714)),
    (943515, (3.775, 11.771, 20.487)),
    (104000, (5.035, 18.904, 27.617)),
    (643360, (9.987, 18.565, 28.568)),
    (84715, (4.188, 10.852, 29.036)),
    (568645, (6.552, 15.863, 23.621)),
    (311565, (8.094, 17.040, 29.049)),
    (296690, (9.319, 12.559, 25.168)),
    (678181, (5.518, 10.372, 20.578)),
    (509673, (9.606, 10.523, 24.700)),
    (9338, (1.847, 14.848, 22.534)),
    (585270, (9.399, 18.582, 22.903)),
    (155233, (0.295, 10.220, 22.956)),
    (526535, (4.919, 10.529, 24.884)),
    (456464, (2.045, 10.597, 23.473)),
    (546239, (1.863, 15.661, 25.100)),
    (498511, (8.974, 10.649, 22.259)),
    (481047, (1.206, 19.783, 21.597)),
    (499543, (6.005, 17.604, 26.036)),
    (960559, (0.083, 11.542, 29.693)),
    (779069, (2.277, 19.946, 25.641)),
    (351178, (2.296, 13.290, 29.076)),
    (815542, (9.467, 19.896, 27.261)),
    (809095, (4.688, 11.294, 24.835)),
    (545942, (6.950, 16.459, 20.594)),
    (737618, (9.552, 15.494, 23.355)),
    (580301, (3.194, 14.599, 22.226)),
    (139908, (7.833, 11.352, 22.256)),
    (890174, (0.411, 14.394, 22.266)),
    (531374, (2.543, 11.441, 26.033)),
    (421282, (7.705, 11.874, 26.558)),
    (333376, (3.238, 17.742, 29.908)),
    (940472, (9.377, 15.404, 21.339)),
    (501777, (1.506, 15.308, 22.363)),
    (497545, (3.014, 10.579, 22.792)),
    (165325, (3.367, 13.492, 29.932)),
    (21636, (0.523, 10.327, 29.533)),
    (946580, (3.231, 18.196, 25.713)),
    (758499, (8.838, 13.852, 26.545)),
    (368881, (3.862, 19.551, 25.560)),
    (359687, (1.609, 10.261, 25.606)),
    (621182, (8.113, 15.664, 22.683)),
    (410760, (2.163, 11.699, 29.746)),
    (916726, (5.518, 14.800, 28.129)),
    (199500, (7.256, 17.485, 24.131)),
    (569024, (3.400, 17.861, 28.006)),
    (36704, (6.412, 16.510, 26.946)),
    (39702, (1.254, 12.412, 20.856)),
    (155671, (4.107, 16.830, 22.196)),
    (7983, (5.048, 13.178, 27.891)),
    (24862, (8.389, 13.685, 23.784)),
    (560617, (2.290, 18.388, 26.280)),
    (443440, (4.822, 19.452, 25.373)),
    (621177, (9.047, 17.616, 24.691)),
    (241582, (3.460, 16.399, 25.532)),
    (114961, (3.962, 18.249, 28.299)),
    (847451, (9.630, 10.203, 26.537)),
    (196803, (5.504, 14.208, 23.598)),
    (843487, (9.483, 13.378, 21.663)),
    (411206, (4.028, 13.226, 25.455)),
    (100743, (6.374, 13.963, 24.671)),
    (981093, (7.724, 17.242, 21.647)),
    (2654, (1.961, 13.742, 27.445)),
    (288221, (8.314, 13.760, 26.153)),
    (444012, (5.647, 13.997, 27.037)),
    (777260, (4.398, 16.368, 21.150)),
    (652721, (1.834, 19.881, 25.698)),
    (279487, (4.862, 18.834, 25.214)),
    (619463, (9.635, 15.725, 20.809)),
    (475054, (5.780, 14.730, 24.137)),
    (914281, (8.063, 11.010, 22.517)),
    (651395, (4.157, 10.872, 20.510)),
    (629833, (7.817, 12.884, 21.960)),
    (280146, (4.733, 14.142, 20.700)),
    (854007, (4.097, 17.757, 28.868)),
    (430515, (6.957, 17.025, 27.441)),
    (512471, (6.999, 12.078, 24.559)),
    (463936, (1.178, 18.778, 22.872)),
    (821147, (2.280, 19.223, 28.951)),
    (548030, (8.775, 16.417, 22.250)),
    (536572, (9.498, 18.088, 20.344)),
    (319705, (2.884, 18.132, 26.674)),
    (833029, (2.131, 16.940, 28.153)),
    (258257, (5.669, 18.554, 25.426)),
    (147916, (9.367, 17.738, 24.544)),
    (245262, (9.273, 15.663, 28.855)),
    (768307, (7.537, 16.047, 28.051)),
    (931811, (9.345, 12.356, 27.919)),
    (803024, (9.428, 14.980, 21.429)),
    (675369, (0.665, 11.620, 25.273)),
    (653975, (3.354, 15.474, 24.054)),
    (962472, (4.892, 12.789, 26.423)),
    (461383, (4.969, 16.332, 23.910)),
    (164011, (4.172, 12.050, 20.430)),
    (745492, (9.119, 19.757, 20.444)),
    (714027, (6.682, 14.843, 22.248)),
    (858909, (8.681, 19.466, 21.409)),
    (965594, (9.070, 14.341, 23.305)),
    (825877, (7.661, 12.839, 20.993)),
    (475341, (0.462, 16.774, 24.148)),
    (365322, (8.477, 15.221, 23.337)),
    (35740, (9.068, 17.224, 20.191)),
    (733715, (9.146, 18.453, 22.272)),
    (256025, (5.428, 16.005, 25.312)),
    (230162, (7.817, 18.624, 25.703)),
    (564262, (9.721, 12.912, 28.169)),
    (683657, (0.561, 15.471, 22.187)),
    (306056, (2.841, 14.525, 25.210)),
    (277847, (5.877, 15.285, 25.814)),
    (242690, (2.186, 15.439, 22.469)),
    (852793, (9.495, 16.805, 22.850)),
    (17815, (8.972, 10.907, 21.072)),
    (719122, (1.195, 13.291, 28.538)),
    (813470, (4.635, 18.498, 28.754)),
    (88555, (6.535, 10.951, 21.770)),
    (9223, (4.402, 19.805, 20.406)),
    (995332, (6.506, 17.146, 20.429)),
    (108767, (3.761, 13.476, 27.592)),
    (549820, (1.156, 16.290, 20.971)),
    (258755, (7.202, 15.274, 28.454)),
    (790908, (1.007, 19.052, 29.438)),
    (978497, (3.525, 18.605, 22.623)),
    (649071, (7.130, 14.095, 26.994)),
    (115696, (4.716, 14.307, 20.812)),
    (36013, (4.116, 10.178, 22.365)),
    (182169, (1.428, 17.472, 27.289)),
    (860858, (4.547, 16.686, 26.736)),
    (547740, (0.565, 16.412, 24.262)),
    (409762, (7.635, 11.840, 28.452)),
    (125968, (7.867, 18.685, 20.542)),
    (196941, (1.569, 18.285, 22.949)),
    (653429, (2.334, 12.540, 27.082)),
    (844936, (6.605, 12.666, 28.367)),
    (508233, (6.289, 11.886, 20.995)),
    (22983, (2.714, 10.140, 27.696)),
    (757625, (1.822, 11.104, 24.568)),
    (177282, (3.319, 18.576, 26.208)),
    (766000, (9.174, 18.917, 28.944)),
    (308848, (5.178, 17.889, 24.670)),
    (30446, (9.704, 14.811, 21.452)),
    (846281, (2.981, 19.475, 28.402)),
    (859178, (4.520, 12.542, 29.989)),
    (458717, (2.883, 16.943, 21.592)),
    (65188, (9.660, 17.071, 29.064)),
    (359724, (5.953, 16.713, 28.325)),
    (918429, (0.436, 16.853, 21.767)),
    (515050, (6.613, 14.552, 25.892)),
    (874964, (5.778, 17.009, 22.339)),
    (286439, (2.653, 15.291, 29.113)),
    (600411, (1.506, 17.012, 20.261)),
    (693948, (0.056, 12.398, 28.281)),
    (667666, (1.166, 10.502, 26.656)),
    (583532, (3.275, 14.676, 22.421)),
    (366864, (4.195, 11.261, 24.413)),
    (248143, (6.918, 13.899, 24.573)),
    (798627, (9.210, 16.004, 25.322)),
    (368305, (6.002, 19.526, 26.215)),
    (323734, (2.954, 10.248, 25.485)),
    (60636, (3.591, 17.909, 28.157)),
    (481704, (9.249, 14.844, 20.099)),
    (290059, (6.373, 16.864, 22.222)),
    (816570, (2.306, 16.859, 20.037)),
    (258659, (6.610, 17.973, 24.724)),
    (196757, (1.219, 10.606, 26.312)),
    (659600, (7.010, 14.034, 25.889)),
    (594197, (8.088, 16.043, 24.225)),
    (231364, (0.943, 15.340, 23.843)),
    (426637, (8.241, 11.465, 27.418)),
    (910684, (4.985, 19.438, 26.495)),
    (726089, (9.979, 18.590, 23.400)),
    (745689, (2.520, 14.897, 22.353)),
    (672054, (0.502, 15.848, 29.843)),
    (52713, (3.342, 11.393, 21.186)),
    (555272, (3.301, 10.745, 28.962)),
    (664808, (1.625, 17.545, 21.610)),
    (604971, (3.821, 10.034, 20.513)),
    (125076, (6.503, 18.084, 29.629)),
    (614999, (8.305, 18.932, 28.223)),
    (61804, (3.602, 19.839, 25.554)),
    (574501, (1.651, 12.028, 23.351)),
    (328042, (3.084, 18.159, 27.968)),
    (415507, (6.150, 13.633, 26.522)),
    (660456, (4.983, 13.066, 28.971)),
    (809970, (3.533, 13.266, 21.313)),
    (650137, (7.940, 12.602, 25.168)),
    (100640, (1.879, 12.596, 23.494)),
    (961216, (8.835, 12.029, 25.078)),
    (318794, (7.411, 12.974, 27.180)),
    (622980, (4.420, 19.325, 21.188)),
    (493714, (6.683, 15.368, 25.849)),
    (196936, (0.744, 10.413, 23.057)),
    (339667, (6.794, 15.824, 26.628)),
    (491279, (3.057, 19.749, 21.152)),
    (320696, (8.804, 12.614, 26.481)),
    (921689, (0.500, 11.958, 26.737)),
    (769550, (2.152, 12.460, 29.044)),
    (801443, (5.902, 10.186, 20.648)),
    (737756, (3.846, 16.454, 22.955)),
    (289035, (6.264, 10.399, 29.775)),
    (409417, (7.083, 16.708, 27.617)),
    (811786, (6.438, 16.668, 26.029)),
    (497789, (8.782, 12.754, 22.352)),
    (288471, (5.460, 19.894, 24.718)),
    (229537, (5.110, 18.549, 28.949)),
    (688150, (4.730, 12.494, 22.303)),
    (187450, (9.263, 14.885, 24.507)),
    (111960, (3.046, 16.027, 22.997)),
    (269182, (2.477, 10.391, 23.646)),
    (384121, (0.347, 15.652, 21.535)),
    (543893, (2.514, 18.168, 24.936)),
    (56397, (4.387, 17.471, 28.893)),
    (873018, (6.540, 15.116, 20.255)),
    (335451, (6.819, 10.722, 21.910)),
    (817865, (7.717, 10.670, 27.386)),
    (999878, (4.294, 15.584, 22.890)),
    (361702, (0.580, 18.530, 20.381)),
    (120903, (4.105, 10.854, 27.210)),
    (928065, (6.346, 15.285, 22.086)),
    (679148, (4.719, 15.506, 27.306)),
    (733701, (6.279, 13.576, 27.091)),
    (751089, (1.426, 19.963, 26.584)),
    (702169, (0.944, 14.465, 22.006)),
    (796430, (9.671, 10.616, 27.794)),
    (703254, (0.921, 10.856, 26.873)),
    (676303, (7.794, 19.356, 20.476)),
    (8638, (8.086, 11.521, 21.335)),
    (178065, (2.152, 18.563, 25.462)),
    (126400, (3.733, 16.154, 20.315)),
    (225888, (1.327, 11.521, 26.291)),
    (589970, (6.143, 14.344, 25.963)),
    (75610, (1.690, 13.680, 22.079)),
    (896332, (9.064, 15.218, 23.518)),
    (876204, (9.709, 10.945, 24.766)),
    (108556, (2.969, 10.831, 25.783)),
    (330420, (2.835, 15.666, 25.452)),
    (820737, (8.300, 18.105, 25.562)),
    (348578, (5.684, 12.051, 22.339)),
    (7075, (6.684, 14.333, 22.632)),
    (840200, (4.910, 13.880, 23.621)),
    (597578, (9.561, 11.305, 20.102)),
    (317659, (5.007, 16.914, 21.936)),
    (242161, (9.599, 14.882, 23.255)),
    (66887, (1.972, 13.554, 29.344)),
    (632501, (5.274, 11.072, 26.171)),
    (462213, (0.884, 19.271, 28.851)),
    (631569, (7.601, 19.602, 22.499)),
    (298138, (1.112, 16.777, 27.792)),
    (14953, (8.994, 17.631, 25.075)),
    (133890, (1.438, 17.778, 27.967)),
    (167280, (1.745, 11.543, 22.726)),
    (841293, (6.001, 11.618, 29.621)),
    (223552, (8.053, 17.736, 21.815)),
    (958823, (1.001, 11.046, 29.890)),
    (179028, (2.344, 15.351, 28.213)),
    (349673, (3.163, 16.680, 24.267)),
    (672685, (1.100, 19.440, 27.074)),
    (466644, (8.974, 15.336, 23.223)),
    (780291, (6.631, 13.021, 22.460)),
    (571314, (3.714, 15.981, 27.745)),
    (19844, (5.056, 16.352, 26.470)),
    (831348, (5.198, 18.361, 27.338)),
    (42090, (4.358, 10.565, 25.460)),
    (69774, (1.392, 13.023, 26.128)),
    (592885, (3.514, 16.063, 26.073)),
    (27268, (2.858, 15.950, 24.965)),
    (132517, (0.647, 13.789, 22.465)),
    (633340, (9.610, 15.855, 23.668)),
    (783522, (4.923, 18.478, 27.338)),
    (520277, (6.410, 12.763, 23.611)),
    (301440, (6.811, 19.225, 26.026)),
    (222098, (3.480, 16.100, 27.593)),
    (737585, (1.508, 19.462, 28.467)),
    (655518, (1.896, 16.082, 22.632)),
    (589200, (4.982, 16.528, 23.892)),
    (481050, (1.201, 17.419, 22.170)),
    (785312, (9.217, 14.638, 21.838)),
    (169376, (5.695, 13.614, 24.504)),
    (747478, (1.404, 19.536, 20.523)),
    (567905, (0.755, 13.715, 22.673)),
    (28369, (3.567, 18.046, 24.797)),
    (93355, (5.737, 11.355, 29.143)),
    (17416, (4.389, 18.683, 21.836)),
    (496987, (6.854, 10.906, 22.873)),
    (360422, (2.807, 15.070, 22.107)),
    (376608, (5.347, 19.716, 27.634)),
    (611950, (6.642, 19.724, 21.172)),
    (996061, (5.732, 18.421, 27.773)),
    (979319, (5.374, 18.974, 22.743)),
    (119971, (9.491, 17.119, 26.529)),
    (873128, (7.257, 10.775, 29.898)),
    (302306, (3.429, 15.933, 23.226)),
    (827896, (9.436, 18.712, 20.631)),
    (698922, (2.108, 15.543, 29.114)),
    (27200, (8.357, 19.798, 23.440)),
    (104370, (6.702, 11.114, 23.152)),
    (465162, (4.552, 13.753, 29.668)),
    (239251, (5.983, 14.398, 29.210)),
    (665945, (1.934, 11.809, 25.178)),
    (479971, (3.270, 19.025, 20.436)),
    (107772, (8.913, 11.478, 24.945)),
    (43729, (2.094, 14.685, 22.653)),
    (691094, (4.661, 18.838, 23.365)),
    (164489, (0.738, 16.171, 21.859)),
    (732792, (4.038, 19.240, 26.641)),
    (490113, (0.006, 12.837, 23.475)),
    (961873, (4.956, 13.647, 22.822)),
    (349135, (3.696, 11.723, 21.486)),
    (562244, (2.761, 17.788, 27.284)),
    (91227, (9.493, 13.787, 23.359)),
    (996964, (2.803, 11.537, 25.227)),
    (387238, (2.521, 16.240, 28.526)),
    (742995, (0.498, 10.013, 25.782)),
    (949531, (8.943, 19.321, 24.549)),
    (248833, (1.791, 17.540, 22.850)),
    (353550, (6.722, 13.760, 29.027)),
    (56716, (2.589, 13.342, 27.522)),
    (137926, (6.299, 18.586, 23.435)),
    (709487, (9.694, 13.176, 22.127)),
    (368861, (7.860, 11.218, 29.414)),
    (354770, (7.818, 15.452, 28.539)),
    (744375, (1.597, 14.139, 24.703)),
    (3714, (7.501, 13.163, 25.581)),
    (62022, (1.217, 19.937, 23.753)),
    (288932, (5.607, 13.494, 21.871)),
    (918292, (3.657, 11.261, 29.623)),
    (544891, (1.601, 13.374, 23.892)),
    (164698, (0.942, 11.902, 26.550)),
    (891615, (8.187, 18.151, 27.519)),
    (565825, (8.477, 16.526, 25.296)),
    (806011, (1.141, 14.689, 27.234)),
    (444429, (4.014, 18.299, 25.803)),
    (500595, (4.640, 19.309, 27.269)),
    (82021, (6.099, 16.135, 26.736)),
    (706076, (5.172, 16.167, 21.669)),
    (844720, (8.698, 12.457, 23.051)),
    (543247, (1.828, 10.136, 22.971)),
    (840944, (7.888, 11.377, 21.453)),
    (942910, (9.393, 19.697, 27.150)),
    (890948, (8.663, 15.645, 22.855)),
    (431107, (0.328, 19.282, 21.786)),
    (214199, (7.108, 18.999, 23.306)),
    (2035, (9.704, 15.446, 24.020)),
    (254885, (6.725, 18.549, 21.423)),
    (248761, (2.670, 16.823, 20.928)),
    (654681, (0.978, 10.490, 28.363)),
    (909029, (0.113, 19.300, 24.241)),
    (944129, (7.668, 18.923, 24.733)),
    (414603, (7.798, 10.074, 28.868)),
    (321722, (1.397, 18.513, 29.034)),
    (414543, (8.121, 17.172, 23.140)),
    (418981, (7.615, 14.643, 24.827)),
    (903577, (5.758, 16.461, 24.249)),
    (386782, (7.708, 18.515, 26.386)),
    (608275, (9.424, 14.278, 22.468)),
    (748556, (1.586, 10.966, 28.507)),
    (342361, (3.353, 12.823, 28.267)),
    (479867, (8.813, 15.284, 20.897)),
    (373858, (9.553, 14.687, 23.917)),
    (212862, (2.634, 10.509, 24.844)),
    (589094, (8.966, 14.574, 25.692)),
    (702030, (4.026, 13.006, 29.476)),
    (982602, (2.018, 11.284, 21.975)),
    (513554, (1.350, 12.000, 24.485)),
    (806428, (5.491, 13.440, 28.247)),
    (373120, (6.964, 13.225, 20.653)),
    (241034, (8.842, 14.405, 27.279)),
    (527727, (4.882, 10.447, 23.199)),
    (504782, (4.379, 10.393, 27.579)),
    (809921, (0.017, 10.872, 29.204)),
    (690847, (2.954, 19.070, 20.068)),
    (6741, (4.271, 11.795, 28.806)),
    (629928, (0.453, 17.576, 27.896)),
    (116878, (5.664, 11.782, 21.602)),
    (893529, (2.044, 18.925, 26.336)),
    (560648, (9.523, 10.340, 23.806)),
    (897411, (6.435, 17.092, 29.284)),
    (176115, (4.083, 13.208, 21.731)),
    (164642, (5.067, 17.588, 25.930)),
    (45559, (7.560, 16.242, 23.105)),
    (819322, (4.073, 12.362, 29.767)),
    (792569, (1.472, 15.978, 26.525)),
    (382896, (0.203, 18.269, 21.365)),
    (693641, (3.244, 19.372, 25.094)),
    (260869, (9.201, 17.208, 20.948)),
    (327755, (8.985, 19.991, 20.373)),
    (235848, (3.743, 18.042, 29.669)),
    (317644, (8.782, 12.592, 20.578)),
    (222693, (1.990, 19.642, 25.581)),
    (287312, (9.281, 17.713, 27.517)),
    (64856, (4.196, 14.644, 20.604)),
    (298262, (6.942, 12.347, 24.309)),
    (408724, (0.544, 19.701, 28.606)),
    (930790, (7.244, 19.820, 26.471)),
    (594752, (3.914, 12.562, 22.155)),
    (919775, (5.641, 18.616, 22.349)),
    (189677, (1.593, 12.695, 29.350)),
    (814447, (0.920, 18.372, 29.739)),
    (861692, (7.212, 11.014, 21.649)),
    (302954, (8.730, 15.721, 28.762)),
    (708399, (1.444, 10.627, 24.468)),
    (416058, (5.850, 13.796, 23.725)),
    (35166, (1.978, 17.372, 29.709)),
    (755075, (3.279, 18.542, 24.311)),
    (642630, (0.039, 10.514, 29.516)),
    (664790, (2.928, 10.836, 25.684)),
    (162191, (8.095, 18.571, 26.702)),
    (138179, (5.045, 10.391, 28.813)),
    (629805, (0.737, 18.624, 22.690)),
    (89984, (2.775, 13.164, 23.207)),
    (514311, (7.661, 13.879, 26.358)),
    (904975, (1.920, 12.591, 20.798)),
    (863198, (2.698, 15.472, 29.975)),
    (240514, (5.548, 14.886, 28.961)),
    (569582, (9.930, 12.779, 26.445)),
    (892970, (0.982, 10.990, 21.768)),
    (746325, (2.854, 18.748, 27.860)),
    (215553, (8.226, 11.982, 22.959)),
    (107788, (6.495, 11.507, 24.923)),
    (855569, (9.859, 11.797, 28.934)),
    (437394, (5.602, 10.281, 23.180)),
    (128447, (5.384, 16.153, 22.784)),
    (578665, (1.786, 11.374, 24.427)),
    (675235, (0.655, 19.113, 22.891)),
    (348720, (6.083, 15.696, 21.409)),
    (795399, (1.812, 14.330, 27.705)),
    (762801, (9.439, 10.403, 29.807)),
    (837198, (3.587, 18.133, 23.375)),
    (830951, (5.312, 11.632, 21.071)),
    (719884, (7.236, 19.810, 23.309)),
    (575176, (1.879, 16.716, 27.588)),
    (541215, (3.857, 10.905, 22.782)),
    (585443, (2.158, 13.121, 24.076)),
    (869476, (1.027, 12.838, 21.617)),
    (861125, (0.967, 13.247, 29.223)),
    (774352, (6.683, 17.571, 25.857)),
    (277618, (0.174, 10.853, 29.460)),
    (364762, (9.676, 18.571, 29.591)),
    (602298, (6.453, 19.844, 28.477)),
    (149498, (5.327, 18.139, 26.950)),
    (10356, (1.654, 11.923, 21.517)),
    (433060, (5.476, 13.329, 22.976)),
    (959458, (9.013, 18.102, 23.898)),
    (333717, (7.192, 11.209, 27.834)),
    (58836, (0.060, 19.303, 24.427)),
    (260263, (5.851, 10.725, 23.486)),
    (240278, (9.063, 19.570, 25.337)),
    (814332, (7.219, 15.497, 29.009)),
    (595461, (3.991, 12.051, 27.483)),
    (905280, (3.089, 15.726, 28.264)),
    (21227, (1.650, 15.229, 24.628)),
    (341471, (3.967, 14.295, 21.556)),
    (883068, (6.862, 13.302, 29.637)),
    (370338, (3.521, 12.762, 29.246)),
    (268971, (1.776, 10.285, 27.698)),
    (588727, (3.129, 13.894, 25.677)),
    (112689, (8.454, 14.458, 24.854)),
    (653536, (9.727, 14.271, 27.410)),
    (598364, (0.836, 15.659, 24.270)),
    (519275, (1.674, 13.206, 28.116)),
    (232386, (4.702, 14.911, 27.156)),
    (547948, (3.604, 15.423, 25.334)),
    (631810, (5.860, 10.899, 22.837)),
    (546549, (3.891, 18.895, 24.273)),
    (456189, (6.728, 16.212, 23.107)),
    (34608, (4.391, 18.475, 20.981)),
    (256898, (4.948, 15.509, 22.669)),
    (838510, (6.342, 13.011, 25.848)),
    (503055, (2.792, 18.932, 21.162)),
    (538427, (9.146, 13.671, 26.064)),
    (380596, (2.440, 14.818, 20.437)),
    (416203, (1.661, 19.307, 27.340)),
    (953035, (4.028, 12.979, 24.817)),
    (663238, (8.607, 13.951, 27.669)),
    (552246, (5.142, 13.748, 28.015)),
    (601884, (6.592, 13.423, 23.642)),
    (543070, (4.636, 18.746, 25.878)),
    (363608, (6.934, 16.623, 29.320)),
    (910514, (8.027, 18.699, 24.954)),
    (582202, (2.660, 11.281, 29.852)),
    (169410, (9.837, 12.559, 29.769)),
    (654032, (7.799, 16.943, 28.739)),
    (619930, (6.333, 16.118, 24.731)),
    (653886, (9.409, 18.143, 23.869)),
    (376665, (2.286, 15.266, 23.077)),
    (680196, (1.707, 16.385, 24.966)),
    (832360, (8.015, 18.456, 26.062)),
    (160590, (3.588, 12.470, 25.498)),
    (500702, (0.853, 15.850, 26.913)),
    (149294, (9.267, 18.156, 26.618)),
    (845942, (9.316, 10.841, 22.807)),
    (698650, (5.445, 19.500, 28.692)),
    (532732, (4.394, 15.597, 28.947)),
    (145423, (7.499, 18.563, 20.335)),
    (426566, (3.221, 13.170, 26.865)),
    (359029, (6.587, 15.395, 20.392)),
    (874132, (0.447, 16.815, 26.017)),
    (825577, (7.018, 11.459, 20.236)),
    (345408, (1.691, 16.448, 22.940)),
    (39075, (2.045, 15.056, 21.232)),
    (808195, (8.230, 11.171, 26.979)),
    (718477, (4.272, 18.639, 28.629)),
    (510985, (8.976, 10.772, 23.369)),
    (958770, (3.116, 11.599, 20.055)),
    (38366, (7.244, 10.454, 22.346)),
    (140004, (7.071, 15.256, 20.430)),
    (617550, (2.515, 16.262, 22.092)),
    (854927, (1.738, 12.885, 29.022)),
    (820237, (4.195, 10.359, 26.416)),
    (501456, (6.515, 14.924, 29.686)),
    (539398, (4.048, 12.287, 26.891)),
    (652676, (9.457, 10.319, 24.393)),
    (492776, (4.503, 10.081, 20.775)),
    (639924, (0.438, 19.941, 22.667)),
    (113087, (2.708, 12.679, 27.444)),
    (333596, (7.027, 18.382, 27.478)),
    (465627, (2.206, 12.112, 28.195)),
    (13198, (1.534, 19.438, 27.873)),
    (718262, (3.387, 11.167, 22.276)),
    (617828, (6.365, 15.516, 22.966)),
    (87335, (2.384, 19.398, 23.808)),
    (580719, (4.815, 10.209, 25.376)),
    (472821, (4.971, 16.596, 29.968)),
    (625069, (9.641, 13.754, 28.883)),
    (32665, (0.655, 16.453, 29.507)),
    (975274, (1.103, 12.785, 24.805)),
    (928380, (4.663, 13.633, 21.830)),
    (446757, (2.443, 19.406, 25.264)),
    (171979, (9.838, 10.879, 24.161)),
    (797711, (9.454, 17.993, 22.864)),
    (409779, (8.836, 19.286, 23.085)),
    (626904, (8.000, 18.939, 23.943)),
    (959086, (2.592, 13.543, 20.631)),
    (285505, (4.913, 17.627, 20.219)),
    (772547, (0.476, 10.890, 24.311)),
    (14470, (8.729, 16.049, 20.817)),
    (841394, (5.366, 17.900, 29.778)),
    (769475, (9.430, 17.470, 21.488)),
    (815947, (7.963, 14.067, 28.371)),
    (464854, (0.496, 17.204, 29.614)),
    (554763, (6.683, 13.710, 23.385)),
    (421832, (9.397, 11.375, 24.650)),
    (712036, (9.804, 19.901, 23.192)),
    (652219, (0.764, 10.379, 26.298)),
    (57681, (9.102, 10.475, 26.319)),
    (602936, (7.376, 17.486, 27.480)),
    (4073, (7.312, 14.742, 24.741)),
    (121918, (3.506, 10.722, 28.384)),
    (148762, (9.425, 16.560, 26.442)),
    (156690, (6.982, 16.018, 28.471)),
    (906261, (6.964, 15.607, 29.490)),
    (595284, (4.144, 19.571, 20.483)),
    (993047, (7.418, 13.563, 23.347)),
    (859137, (9.911, 15.029, 21.453)),
    (92180, (1.738, 16.059, 27.111)),
    (565336, (8.280, 11.335, 22.860)),
    (66408, (5.637, 16.638, 24.188)),
    (658362, (0.756, 13.079, 26.574)),
    (162595, (6.742, 13.459, 27.804)),
    (114343, (6.503, 14.195, 29.959)),
    (832283, (6.549, 17.216, 23.701)),
    (44227, (7.296, 13.084, 27.473)),
    (248494, (2.578, 15.856, 22.898)),
    (839510, (1.070, 17.221, 27.936)),
    (656487, (7.086, 13.967, 20.533)),
    (109124, (5.393, 10.289, 22.207)),
    (323873, (2.727, 18.208, 22.098)),
    (290230, (1.623, 19.467, 22.814)),
    (761413, (6.918, 18.554, 20.210)),
    (40471, (2.210, 10.284, 24.057)),
    (455561, (6.921, 15.934, 21.222)),
    (753880, (5.090, 10.268, 23.173)),
    (644260, (7.742, 15.249, 29.735)),
    (790390, (4.245, 18.619, 23.676)),
    (27344, (3.117, 18.071, 24.999)),
    (902425, (4.724, 16.576, 23.159)),
    (906335, (4.749, 15.996, 20.862)),
    (218816, (7.306, 15.220, 27.977)),
    (417327, (1.863, 18.858, 22.411)),
    (567347, (1.148, 17.292, 26.864)),
    (135024, (4.141, 18.492, 26.928)),
    (486355, (9.443, 15.491, 27.678)),
    (339186, (0.094, 18.325, 23.816)),
    (938959, (9.923, 11.230, 29.514)),
    (410672, (2.508, 14.817, 24.789)),
    (452722, (9.099, 17.649, 27.956)),
    (865474, (7.599, 12.790, 24.067)),
    (74268, (9.690, 12.293, 21.042)),
    (976732, (0.083, 19.125, 24.386)),
    (405256, (8.227, 10.131, 29.385)),
    (962369, (7.672, 17.121, 27.602)),
    (635395, (6.474, 14.705, 23.802)),
    (466848, (4.979, 14.302, 29.053)),
    (911440, (3.024, 15.986, 21.149)),
    (515879, (7.885, 10.151, 23.502)),
    (467936, (7.631, 19.783, 24.606)),
    (403741, (4.973, 16.167, 25.428)),
    (619501, (7.392, 18.374, 24.642)),
    (867661, (4.748, 11.621, 21.780)),
    (177994, (4.071, 12.606, 23.923)),
    (247971, (5.822, 19.674, 22.228)),
    (430858, (6.342, 10.035, 28.856)),
    (16080, (3.460, 15.342, 26.145)),
    (796985, (8.207, 17.987, 24.343)),
    (436769, (9.076, 13.905, 21.423)),
    (899571, (1.129, 15.064, 26.299)),
    (622741, (7.768, 11.514, 23.101)),
    (786780, (8.606, 19.057, 22.844)),
    (192349, (8.359, 19.562, 27.416)),
    (50418, (7.027, 16.834, 24.464)),
    (781162, (2.484, 11.483, 25.739)),
    (176819, (4.567, 15.390, 29.848)),
    (60625, (5.004, 19.471, 23.212)),
    (129570, (2.669, 18.221, 23.778)),
    (926294, (7.090, 15.804, 29.533)),
    (384062, (0.996, 11.506, 28.079)),
    (420534, (1.683, 18.043, 26.158)),
    (965935, (0.004, 19.951, 25.696)),
    (675320, (2.270, 14.055, 24.240)),
    (188567, (0.174, 15.113, 22.380)),
    (638362, (5.268, 16.821, 22.285)),
    (926275, (0.306, 18.072, 24.191)),
    (135576, (6.615, 19.242, 23.559)),
    (253604, (6.043, 12.781, 20.708)),
    (787797, (5.907, 12.508, 24.769)),
    (681616, (0.227, 19.714, 24.937)),
    (982054, (1.177, 15.832, 28.544)),
    (419195, (4.128, 10.788, 22.235)),
    (999975, (3.604, 15.759, 20.643)),
    (380363, (8.486, 16.218, 23.125)),
    (178682, (2.685, 18.433, 21.255)),
    (801517, (9.543, 11.609, 20.900)),
    (710844, (7.460, 10.036, 24.741)),
    (49427, (1.266, 16.017, 23.356)),
    (580047, (9.463, 19.756, 26.669)),
    (234672, (5.238, 10.983, 28.154)),
    (909509, (1.132, 17.811, 28.632)),
    (77957, (7.835, 19.547, 22.748)),
    (253374, (2.274, 16.721, 28.428)),
    (539706, (1.008, 15.447, 26.330)),
    (440935, (9.271, 13.972, 25.889)),
    (427689, (7.876, 16.932, 20.739)),
    (219015, (6.563, 14.178, 20.045)),
    (13220, (6.217, 15.439, 21.102)),
    (34607, (9.541, 16.732, 21.668)),
    (897113, (9.669, 15.543, 24.824)),
    (750345, (6.497, 16.955, 20.743)),
    (674138, (9.312, 12.889, 25.220)),
    (578525, (5.303, 16.276, 22.572)),
    (377527, (2.916, 10.851, 22.252)),
    (587400, (4.370, 18.630, 28.246)),
    (967203, (8.948, 12.925, 20.798)),
    (625332, (2.951, 17.614, 26.866)),
    (536199, (1.225, 11.819, 23.770)),
    (951008, (3.894, 15.863, 27.609)),
    (674273, (1.899, 10.556, 21.506)),
    (413049, (1.148, 19.339, 27.117)),
    (689614, (5.496, 15.606, 27.097)),
    (355308, (5.453, 15.692, 22.451)),
    (38926, (8.823, 15.934, 23.798)),
    (372376, (3.088, 17.242, 23.633)),
    (352749, (5.338, 10.556, 20.017)),
    (999191, (4.312, 15.111, 25.208)),
    (429772, (9.536, 11.882, 21.932)),
    (529628, (3.888, 11.782, 26.351)),
    (450591, (8.891, 14.408, 22.680)),
    (921989, (4.326, 16.631, 28.814)),
    (788810, (1.541, 18.859, 28.651)),
    (887002, (6.507, 16.202, 25.783)),
    (417080, (4.659, 14.235, 27.194)),
    (277330, (9.330, 11.028, 20.769)),
    (736002, (5.893, 11.489, 21.796)),
    (786806, (5.578, 12.908, 26.486)),
    (245698, (3.051, 16.938, 27.452)),
    (122261, (0.499, 13.066, 26.301)),
    (304690, (3.045, 12.603, 24.074)),
    (522180, (9.477, 18.470, 26.219)),
    (960797, (3.979, 19.932, 25.142)),
    (306088, (8.079, 16.476, 28.813)),
    (266368, (9.919, 11.498, 20.370)),
    (627628, (4.431, 15.030, 23.386)),
    (434252, (7.606, 19.457, 29.491)),
    (701561, (3.118, 19.606, 29.099)),
    (584570, (0.774, 19.438, 29.985)),
    (539205, (5.605, 12.011, 22.569)),
    (227003, (0.341, 12.906, 23.070)),
    (210108, (5.494, 16.605, 26.563)),
    (346333, (9.927, 17.845, 27.551)),
    (939391, (4.391, 10.822, 24.162)),
    (293975, (6.890, 16.379, 28.283)),
    (948466, (7.383, 12.572, 21.946)),
    (60047, (6.551, 12.874, 26.301)),
    (340788, (7.537, 18.688, 28.833)),
    (216586, (9.750, 13.623, 22.988)),
    (103405, (3.876, 11.143, 27.430)),
    (105816, (5.799, 13.464, 25.415)),
    (226707, (6.260, 17.646, 28.949)),
    (208454, (9.439, 14.632, 29.093)),
    (74935, (7.598, 11.880, 27.624)),
    (646278, (0.661, 12.046, 21.387)),
    (854288, (9.716, 13.096, 28.165)),
    (709270, (4.307, 12.302, 20.600)),
    (638593, (7.559, 12.741, 27.654)),
    (860063, (5.211, 10.886, 24.932)),
    (106883, (9.340, 15.706, 25.050)),
    (96397, (7.815, 15.117, 24.829)),
    (450367, (0.609, 15.419, 29.322)),
    (746349, (9.142, 19.361, 26.707)),
    (997547, (1.822, 10.910, 24.171)),
    (402973, (9.880, 18.994, 21.172)),
    (812214, (3.739, 16.288, 22.213)),
    (103247, (3.994, 18.016, 20.594)),
    (253187, (6.913, 17.688, 26.907)),
    (320785, (9.521, 14.774, 20.683)),
    (746321, (9.652, 15.475, 20.007)),
    (339263, (0.610, 10.750, 21.877)),
    (649678, (4.671, 16.802, 24.125)),
    (661146, (2.428, 12.144, 25.309)),
    (326112, (2.022, 13.691, 23.235)),
    (61626, (5.802, 13.707, 29.052)),
    (927483, (8.255, 14.860, 23.417)),
    (623334, (9.171, 14.970, 25.051)),
    (788382, (4.037, 11.978, 23.846)),
    (366587, (5.618, 16.397, 22.457)),
    (546182, (4.053, 12.060, 28.746)),
    (492464, (4.131, 11.632, 20.813)),
    (455984, (9.840, 18.322, 25.799)),
    (107561, (2.264, 15.484, 29.802)),
    (786743, (6.207, 17.660, 24.350)),
    (770242, (3.930, 11.814, 20.474)),
    (974865, (2.345, 17.164, 24.523)),
    (779432, (8.167, 13.142, 26.529)),
    (232941, (7.745, 16.919, 24.302)),
    (467410, (4.144, 11.186, 26.044)),
    (551240, (2.909, 17.552, 22.115)),
    (632564, (1.177, 10.253, 22.986)),
    (530139, (9.736, 10.838, 24.260)),
    (552440, (6.417, 16.584, 27.644)),
    (337824, (6.546, 18.297, 27.947)),
    (203453, (6.479, 17.954, 24.633)),
    (767586, (9.494, 12.875, 20.374)),
    (125346, (1.879, 15.758, 28.971)),
    (688552, (3.792, 12.266, 22.667)),
    (703361, (3.318, 15.828, 20.433)),
    (579899, (2.902, 19.831, 28.130)),
    (43848, (1.186, 16.156, 29.028)),
    (396004, (6.362, 10.324, 29.533)),
    (983306, (8.384, 17.032, 27.795)),
    (363136, (7.606, 17.252, 29.540)),
    (733032, (2.315, 19.467, 29.238)),
    (874019, (8.546, 17.413, 27.418)),
    (922437, (2.880, 13.245, 22.877)),
    (127094, (3.383, 15.412, 22.054)),
    (90199, (2.734, 18.950, 28.781)),
    (396350, (7.264, 11.761, 26.035)),
    (785657, (6.147, 15.365, 21.687)),
    (859815, (2.401, 17.043, 24.982)),
    (987116, (5.033, 10.679, 24.477)),
    (152341, (4.761, 14.580, 29.892)),
    (913909, (1.079, 10.360, 27.934)),
    (951467, (5.469, 10.370, 29.356)),
    (37140, (2.654, 10.372, 23.285)),
    (116006, (7.052, 15.136, 23.794)),
    (431998, (9.579, 15.140, 25.721)),
    (875754, (9.566, 19.955, 23.662)),
    (370386, (8.676, 10.952, 26.485)),
    (962677, (6.724, 19.626, 20.071)),
    (293211, (3.784, 17.831, 22.703)),
    (384430, (0.229, 11.059, 28.759)),
    (109516, (8.894, 13.651, 21.309)),
    (885080, (3.529, 15.039, 21.924)),
    (323596, (2.732, 14.368, 21.123)),
    (956909, (4.062, 19.580, 20.734)),
    (62957, (1.275, 17.144, 26.539)),
    (554498, (0.277, 16.050, 22.760)),
    (538969, (1.404, 17.927, 23.868)),
    (37375, (2.470, 10.420, 28.966)),
    (399327, (1.463, 11.570, 21.052)),
    (870446, (5.824, 14.908, 21.713)),
    (795052, (9.384, 17.566, 28.935)),
    (920380, (9.550, 17.174, 22.937)),
    (779900, (5.351, 11.678, 22.291)),
    (155588, (4.476, 13.825, 28.243)),
    (226558, (2.489, 11.926, 24.634)),
    (878489, (0.633, 15.141, 24.649)),
    (482619, (7.172, 13.427, 28.416)),
    (747951, (4.727, 18.660, 23.233)),
    (618093, (1.274, 19.197, 25.169)),
    (526515, (5.952, 14.245, 24.516)),
    (304386, (7.661, 19.736, 20.570)),
    (935154, (7.112, 14.422, 22.350)),
    (308351, (0.505, 16.795, 20.318)),
    (440380, (1.467, 17.740, 23.801)),
    (307841, (1.161, 19.336, 25.449)),
    (618293, (8.421, 15.131, 22.523)),
    (19875, (3.857, 16.216, 28.400)),
    (511073, (5.670, 19.951, 25.115)),
    (91761, (9.707, 12.376, 25.660)),
    (257860, (6.341, 13.811, 20.482)),
    (756315, (7.560, 12.711, 26.367)),
    (726518, (2.429, 13.762, 29.958)),
    (301582, (9.279, 13.992, 22.831)),
    (551970, (0.643, 16.662, 20.043)),
    (693629, (3.319, 15.032, 24.705)),
    (723886, (3.018, 17.223, 25.091)),
    (264645, (6.240, 18.958, 23.091)),
    (23464, (5.044, 12.208, 23.988)),
    (777071, (4.461, 12.844, 25.255)),
    (809427, (3.477, 18.552, 23.734)),
    (227250, (9.381, 14.725, 22.510)),
    (269844, (3.645, 10.691, 27.336)),
    (979138, (5.753, 13.528, 26.539)),
    (262375, (9.496, 18.294, 29.697)),
    (295891, (7.142, 17.923, 24.133)),
    (19401, (9.843, 10.861, 21.507)),
    (215008, (4.730, 15.941, 29.399)),
    (831765, (2.955, 15.074, 28.909)),
    (306798, (0.876, 17.866, 29.935)),
    (671775, (5.867, 16.882, 24.181)),
    (780052, (4.469, 11.533, 26.678)),
    (909050, (7.484, 12.173, 23.470)),
    (171965, (9.113, 13.306, 24.531)),
    (188147, (7.974, 16.782, 24.264)),
    (849036, (0.225, 17.259, 29.057)),
    (387897, (5.825, 10.242, 25.013)),
    (292358, (9.904, 10.010, 20.567)),
    (832209, (5.103, 13.814, 26.746)),
    (530407, (3.777, 17.232, 23.023)),
    (682593, (5.144, 19.858, 20.895)),
    (149370, (6.302, 19.474, 22.203)),
    (348442, (7.731, 10.717, 21.122)),
    (966181, (0.302, 18.033, 25.346)),
    (799489, (0.796, 18.131, 27.461)),
    (715721, (2.058, 12.214, 26.659)),
    (863832, (8.496, 12.672, 28.655)),
    (159178, (3.666, 12.613, 29.065)),
    (427950, (9.549, 14.945, 25.439)),
    (216862, (9.685, 10.561, 22.814)),
    (424932, (7.736, 13.065, 22.915)),
    (440715, (1.282, 16.563, 26.958)),
    (785917, (6.120, 13.911, 29.225)),
    (988322, (4.272, 19.992, 26.382)),
    (209719, (5.676, 13.456, 25.679)),
    (788479, (7.487, 19.444, 28.285)),
    (658984, (7.670, 17.730, 27.865)),
    (855400, (4.207, 18.137, 21.625)),
    (457816, (4.548, 17.466, 24.204)),
    (325876, (6.957, 13.738, 28.593)),
    (543963, (4.905, 14.813, 25.762)),
    (783947, (2.785, 14.194, 20.591)),
    (412681, (2.739, 16.998, 23.586)),
    (828071, (8.876, 16.768, 23.312)),
    (564834, (7.146, 15.514, 29.523)),
    (775820, (8.887, 19.324, 23.857)),
    (35340, (4.017, 12.816, 27.155)),
    (257301, (4.224, 12.468, 23.202)),
    (446444, (1.791, 18.979, 29.494)),
    (777699, (5.439, 19.059, 25.648)),
    (288405, (7.984, 17.333, 28.599)),
    (641059, (2.759, 16.106, 28.644)),
    (863527, (8.153, 12.269, 29.900)),
    (328115, (2.034, 14.527, 22.549)),
    (691277, (4.007, 18.636, 29.530)),
    (438882, (0.400, 17.487, 26.608)),
    (653365, (8.217, 10.634, 24.671)),
    (578245, (5.769, 13.966, 22.393)),
    (780454, (8.696, 13.149, 29.377)),
    (230663, (4.438, 14.725, 26.452)),
    (704841, (5.442, 15.183, 23.631)),
    (824309, (7.729, 19.078, 26.405)),
    (580703, (5.005, 10.285, 23.222)),
    (948704, (3.970, 18.292, 29.098)),
    (812972, (6.622, 18.943, 24.117)),
    (272188, (4.835, 10.013, 23.182)),
    (331827, (7.900, 14.310, 22.168)),
    (332784, (9.224, 11.950, 24.080)),
    (372475, (6.147, 12.255, 28.878)),
    (709394, (5.076, 11.224, 22.492)),
    (287786, (9.431, 12.106, 28.198)),
    (565424, (7.711, 11.209, 27.754)),
    (993341, (5.066, 14.824, 24.278)),
    (531120, (4.029, 19.947, 28.913)),
    (744057, (0.989, 17.683, 26.623)),
    (971213, (2.332, 14.205, 29.672)),
    (613486, (3.676, 18.494, 20.976)),
    (664669, (4.824, 11.055, 22.101)),
    (914991, (7.195, 17.869, 28.542)),
    (432122, (6.748, 11.754, 29.369)),
    (408818, (6.629, 14.072, 24.149)),
    (897301, (7.593, 12.185, 26.139)),
    (990624, (8.705, 13.642, 21.073)),
    (991356, (8.094, 15.724, 27.226)),
    (918988, (3.912, 18.792, 21.797)),
    (749491, (2.438, 19.718, 23.200)),
    (199794, (2.107, 14.761, 28.751)),
    (303619, (7.530, 15.379, 21.719)),
    (712627, (8.314, 17.385, 23.406)),
    (877083, (7.788, 19.644, 22.205)),
    (970426, (9.932, 18.466, 25.320)),
    (609641, (7.514, 19.338, 29.944)),
    (856235, (5.281, 17.266, 25.055)),
    (588936, (1.020, 12.461, 26.056)),
    (190701, (8.599, 12.505, 28.681)),
    (843788, (6.972, 15.528, 20.742)),
    (328082, (4.589, 15.524, 26.529)),
    (586227, (2.935, 10.577, 28.204)),
    (451807, (8.305, 17.390, 26.229)),
    (777123, (7.554, 16.389, 26.840)),
    (742818, (8.038, 11.332, 20.622)),
    (904612, (3.321, 13.542, 21.044)),
    (297955, (8.967, 15.712, 29.072)),
    (657807, (1.325, 15.568, 22.610)),
    (418368, (7.794, 16.378, 27.876)),
    (569351, (0.056, 13.559, 28.257)),
    (993195, (8.757, 18.562, 25.988)),
    (403129, (2.056, 14.819, 28.124)),
    (901057, (5.423, 12.879, 22.632)),
    (318724, (7.238, 14.385, 24.722)),
    (13838, (1.372, 13.949, 28.925)),
    (537489, (0.806, 19.063, 27.652)),
    (533429, (0.224, 13.152, 24.094)),
    (984100, (6.652, 16.215, 25.052)),
    (639842, (7.699, 16.857, 22.498)),
    (809875, (4.155, 14.559, 26.614)),
    (416579, (5.815, 19.085, 24.303)),
    (986380, (5.532, 14.170, 28.932)),
    (221027, (1.941, 16.664, 22.804)),
    (719068, (1.272, 10.253, 29.118)),
    (542040, (4.816, 18.978, 26.281)),
    (772196, (7.631, 12.885, 28.548)),
    (206959, (9.205, 17.241, 28.579)),
    (476037, (1.101, 17.699, 22.567)),
    (209016, (5.229, 14.472, 21.508)),
    (897303, (3.483, 12.793, 29.520)),
    (953908, (4.506, 11.925, 28.578)),
    (819895, (3.893, 17.374, 26.499)),
    (532306, (3.221, 18.901, 29.804)),
    (122080, (7.452, 17.951, 25.235)),
    (506147, (8.212, 11.345, 23.536)),
    (155878, (7.302, 16.196, 26.845)),
    (905307, (0.921, 10.973, 25.914)),
    (31581, (5.152, 13.114, 29.506)),
    (228752, (0.640, 12.460, 27.155)),
    (410194, (6.395, 17.853, 27.831)),
    (599850, (0.777, 17.562, 21.306)),
    (285084, (4.856, 14.105, 22.358)),
    (83266, (1.009, 10.094, 21.461)),
    (568396, (9.286, 18.423, 26.378)),
    (791663, (5.855, 19.332, 27.053)),
    (108703, (3.622, 15.395, 20.408)),
    (33835, (7.709, 11.243, 29.965)),
    (636571, (8.081, 12.676, 23.075)),
    (272611, (7.508, 17.591, 27.366)),
    (846585, (3.747, 15.672, 24.369)),
    (149687, (0.358, 19.813, 20.208)),
    (419117, (5.609, 10.578, 21.022)),
    (519940, (5.805, 12.452, 27.789)),
    (242609, (8.248, 12.479, 24.565)),
    (403529, (2.779, 14.283, 27.167)),
    (237900, (6.159, 18.373, 26.757)),
    (845667, (8.743, 12.333, 26.627)),
    (380250, (1.868, 10.924, 21.351)),
    (860933, (6.679, 16.896, 23.423)),
    (531492, (9.586, 17.145, 24.641)),
    (494027, (8.778, 12.105, 28.694)),
    (757365, (0.290, 16.622, 20.171)),
    (509342, (2.617, 14.181, 29.787)),
    (2732, (9.908, 16.864, 26.262)),
    (378244, (6.697, 19.236, 20.463)),
    (12974, (4.013, 17.293, 29.009)),
    (664184, (5.235, 14.614, 28.326)),
    (359842, (7.792, 14.582, 24.388)),
    (964468, (6.980, 14.466, 22.905)),
    (754616, (0.710, 13.929, 26.042)),
    (194057, (1.823, 17.376, 21.334)),
    (248238, (1.023, 16.206, 21.908)),
    (983958, (7.195, 17.046, 28.145)),
    (3964, (1.077, 19.612, 28.494)),
    (468081, (4.708, 11.359, 28.124)),
    (544643, (8.742, 15.562, 21.031)),
    (290615, (5.277, 19.395, 25.562)),
    (884134, (6.639, 14.767, 25.190)),
    (343513, (0.143, 17.453, 26.260)),
    (545829, (9.396, 15.148, 29.047)),
    (256347, (2.706, 17.780, 25.511)),
    (286102, (3.883, 16.102, 20.147)),
    (368118, (4.843, 14.300, 29.837)),
    (661830, (2.548, 12.979, 23.499)),
    (592960, (1.837, 14.779, 29.844)),
    (184277, (6.824, 15.506, 24.917)),
    (790764, (8.824, 16.198, 26.462)),
    (54695, (7.744, 12.702, 23.620)),
    (201088, (0.284, 17.439, 20.547)),
    (567947, (1.505, 10.200, 25.437)),
    (95714, (9.134, 19.396, 23.616)),
    (846408, (2.865, 15.294, 29.511)),
    (439576, (7.608, 19.655, 23.852)),
    (377121, (8.480, 14.545, 25.212)),
    (836942, (3.132, 14.851, 25.339)),
    (196125, (7.811, 17.327, 26.891)),
    (576509, (9.764, 19.647, 23.847)),
    (746823, (3.925, 14.867, 21.414)),
    (482490, (1.537, 16.994, 21.278)),
    (773261, (8.094, 16.633, 22.150)),
    (764283, (7.136, 10.960, 27.575)),
    (587506, (7.574, 19.073, 21.573)),
    (256375, (1.466, 16.703, 21.163)),
    (928190, (1.440, 12.041, 26.787)),
    (429088, (4.281, 17.355, 24.914)),
    (821786, (0.904, 11.134, 26.033)),
    (872432, (9.995, 13.678, 21.149)),
    (205274, (7.732, 17.122, 21.462)),
    (437101, (2.160, 14.649, 21.760)),
    (148776, (2.705, 17.719, 23.970)),
    (490545, (9.665, 15.168, 26.796)),
    (599948, (9.686, 14.702, 27.165)),
    (968536, (6.066, 16.908, 22.889)),
    (44616, (2.039, 19.195, 26.436)),
    (586294, (3.445, 17.554, 26.309)),
    (689168, (1.004, 17.678, 22.446)),
    (474989, (8.524, 10.305, 27.501)),
    (314348, (7.495, 18.987, 21.000)),
    (366656, (8.550, 14.178, 25.731)),
    (444454, (5.260, 17.392, 29.979)),
    (533403, (4.228, 11.445, 29.174)),
    (767099, (7.141, 12.927, 24.943)),
    (310440, (6.619, 15.511, 22.498)),
    (260702, (4.214, 11.152, 23.671)),
    (276213, (5.430, 10.496, 20.748)),
    (926557, (8.667, 19.260, 29.362)),
    (729915, (8.479, 10.383, 21.777)),
    (562258, (5.480, 13.072, 20.873)),
    (561023, (5.399, 15.762, 23.317)),
    (585069, (3.335, 19.755, 25.094)),
    (484168, (9.076, 14.745, 29.288)),
    (228542, (4.872, 11.335, 23.706)),
    (663962, (9.959, 12.240, 27.399)),
    (355792, (9.179, 14.793, 25.856)),
    (750221, (0.543, 17.584, 24.527)),
    (751933, (2.523, 13.246, 20.020)),
    (343758, (5.015, 16.182, 29.511)),
    (722176, (4.454, 15.378, 24.583)),
    (218873, (6.643, 12.799, 29.868)),
    (60616, (9.703, 18.435, 28.955)),
    (724856, (2.185, 11.497, 29.921)),
    (422573, (0.873, 17.097, 29.300)),
    (328732, (5.753, 15.842, 24.350)),
    (25922, (9.804, 17.136, 23.794)),
    (818167, (8.628, 13.325, 29.585)),
    (975253, (4.167, 13.179, 29.524)),
    (436609, (6.329, 18.219, 27.776)),
    (811022, (7.770, 16.706, 27.449)),
    (306639, (7.658, 11.249, 22.379)),
    (499487, (7.307, 12.637, 24.360)),
    (384586, (7.165, 13.787, 24.217)),
    (609288, (5.072, 11.126, 28.254)),
    (60582, (4.480, 18.461, 25.174)),
    (587126, (4.599, 16.434, 26.989)),
    (270939, (3.041, 15.048, 23.358)),
    (730808, (4.637, 16.017, 27.757)),
    (27732, (5.442, 10.902, 22.210)),
    (743189, (4.706, 12.262, 23.225)),
    (302537, (7.429, 17.403, 28.385)),
    (458204, (9.077, 16.804, 24.360)),
    (140926, (8.071, 17.895, 20.193)),
    (818008, (1.099, 10.026, 28.139)),
    (947700, (4.045, 19.687, 27.082)),
    (532163, (3.057, 18.932, 25.077)),
    (348814, (0.822, 14.938, 25.406)),
    (749982, (8.144, 17.197, 26.906)),
    (856624, (3.165, 10.879, 29.077)),
    (832188, (7.634, 16.482, 25.253)),
    (366800, (9.589, 11.081, 24.370)),
    (444204, (3.124, 11.332, 29.327)),
    (536621, (5.099, 17.805, 27.792)),
    (141204, (9.672, 12.129, 24.300)),
    (706, (3.039, 14.651, 28.426)),
    (577042, (9.129, 13.607, 20.088)),
    (571269, (7.824, 15.212, 26.476)),
    (240174, (0.944, 15.859, 22.137)),
    (509777, (5.103, 19.253, 23.124)),
    (54054, (5.520, 17.769, 27.171)),
    (172804, (6.998, 13.059, 25.387)),
    (621250, (9.430, 13.162, 25.779)),
    (49239, (2.590, 14.574, 20.949)),
    (477629, (3.118, 11.005, 27.392)),
    (29953, (7.423, 19.309, 23.226)),
    (629015, (1.317, 18.373, 29.553)),
    (383166, (2.771, 15.571, 23.202)),
    (688141, (2.633, 19.460, 29.052)),
    (637586, (9.570, 19.074, 26.978)),
    (660367, (2.796, 14.410, 29.869)),
    (433557, (8.400, 18.483, 27.453)),
    (895269, (1.904, 11.001, 25.636)),
    (622086, (3.846, 14.124, 25.863)),
    (126170, (2.338, 12.630, 29.572)),
    (762623, (4.592, 16.195, 27.802)),
    (250112, (7.127, 10.397, 24.856)),
    (332641, (5.850, 13.184, 28.819)),
    (458813, (1.999, 11.380, 29.194)),
    (257741, (5.972, 10.799, 27.907)),
    (909814, (8.646, 18.784, 28.244)),
    (553935, (1.298, 17.252, 27.554)),
    (92624, (8.977, 16.458, 22.816)),
    (325062, (8.976, 19.525, 25.036)),
    (256644, (5.894, 13.432, 26.433)),
    (234555, (8.601, 17.690, 20.666)),
    (287983, (5.642, 13.679, 24.311)),
    (245915, (1.730, 12.398, 27.558)),
    (342091, (5.971, 18.800, 25.793)),
    (196362, (1.022, 11.022, 28.340)),
    (771418, (8.061, 10.655, 24.454)),
    (706846, (9.940, 10.987, 21.333)),
    (85376, (4.671, 11.010, 21.459)),
    (824517, (8.765, 17.600, 26.953)),
    (549078, (5.488, 18.044, 25.776)),
    (829906, (4.016, 18.440, 22.722)),
    (926959, (8.531, 16.114, 21.789)),
    (877911, (5.009, 13.052, 21.896)),
    (57199, (4.768, 13.018, 25.436)),
    (462568, (5.765, 15.936, 25.600)),
    (100824, (3.656, 12.970, 25.428)),
    (261636, (9.553, 10.771, 24.156)),
    (180528, (7.307, 17.498, 21.297)),
    (156695, (4.853, 12.752, 24.967)),
    (921017, (4.981, 18.149, 22.192)),
    (891840, (5.490, 16.010, 27.528)),
    (226506, (8.957, 10.298, 28.319)),
    (387350, (4.187, 19.577, 21.928)),
    (369477, (5.981, 13.527, 24.192)),
    (957432, (7.110, 13.750, 28.671)),
    (899971, (0.857, 13.567, 27.810)),
    (339031, (7.910, 12.135, 27.431)),
    (42190, (8.695, 18.127, 26.864)),
    (343112, (5.267, 17.327, 27.404)),
    (613676, (8.598, 12.710, 26.784)),
    (651193, (2.771, 11.138, 23.133)),
    (449036, (6.662, 14.305, 20.260)),
    (567932, (9.209, 17.705, 27.356)),
    (219748, (5.275, 14.163, 25.367)),
    (350007, (7.906, 12.271, 25.010)),
    (570773, (6.847, 13.088, 25.386)),
    (495693, (5.711, 19.028, 25.936)),
    (641554, (5.831, 17.541, 23.587)),
    (941015, (3.191, 14.891, 20.904)),
    (328977, (2.696, 14.572, 27.406)),
    (812872, (5.938, 19.789, 28.212)),
    (359191, (1.703, 14.019, 25.805)),
    (703028, (9.970, 10.683, 24.876)),
    (918235, (2.921, 17.844, 29.960)),
    (895388, (9.304, 16.243, 22.979)),
    (248556, (2.043, 18.204, 28.486)),
    (280395, (0.861, 11.937, 24.616)),
    (313390, (0.794, 15.082, 22.914)),
    (974317, (1.408, 14.400, 29.112)),
    (877478, (9.911, 14.297, 25.178)),
    (548895, (3.720, 16.789, 23.558)),
    (360122, (8.985, 11.247, 24.058)),
    (902121, (6.453, 13.577, 21.268)),
    (282396, (4.907, 18.653, 26.764)),
    (232260, (6.530, 13.519, 21.287)),
    (755016, (2.646, 17.697, 24.962)),
    (1865, (4.313, 16.842, 25.059)),
    (148347, (0.754, 15.552, 29.326)),
    (233733, (0.045, 12.791, 29.726)),
    (192276, (4.608, 12.402, 23.304)),
    (891995, (1.830, 16.532, 20.962)),
    (906021, (9.802, 18.736, 21.271)),
    (145711, (9.689, 13.315, 21.930)),
    (36690, (5.430, 16.080, 20.690)),
    (780310, (5.005, 13.165, 24.647)),
    (23883, (3.021, 19.574, 27.188)),
    (41616, (1.188, 19.613, 29.825)),
    (2264, (4.982, 18.642, 23.574)),
    (55865, (6.884, 13.243, 21.137)),
    (72834, (0.710, 15.741, 26.809)),
    (561942, (2.762, 13.643, 27.439)),
    (936306, (3.084, 18.837, 25.318)),
    (238637, (3.632, 18.287, 25.298)),
    (455987, (4.610, 12.032, 27.716)),
    (910335, (8.900, 10.641, 21.305)),
    (621126, (4.681, 11.028, 28.048)),
    (777851, (3.159, 10.438, 29.348)),
    (929923, (4.335, 18.255, 26.820)),
    (538752, (7.158, 19.475, 27.621)),
    (326311, (0.676, 18.278, 26.113)),
    (608374, (7.800, 13.718, 26.198)),
    (617963, (0.486, 19.238, 25.378)),
    (11059, (2.421, 18.022, 23.451)),
    (712206, (7.006, 16.142, 24.503)),
    (833451, (9.405, 10.839, 28.019)),
    (885397, (4.855, 18.314, 21.884)),
    (906716, (7.892, 11.672, 27.107)),
    (495078, (0.625, 12.713, 27.649)),
    (831066, (5.984, 16.125, 29.992)),
    (899284, (7.564, 10.526, 29.025)),
    (44012, (9.841, 19.033, 26.837)),
    (148610, (0.766, 12.951, 28.122)),
    (168305, (7.752, 17.618, 27.112)),
    (283139, (6.824, 18.395, 29.014)),
    (682684, (6.406, 19.655, 29.412)),
    (179879, (3.861, 17.384, 27.915)),
    (455295, (3.505, 18.826, 25.366)),
    (1689, (3.808, 13.858, 27.493)),
    (58393, (7.164, 14.805, 25.955)),
    (723964, (5.615, 19.736, 20.936)),
    (39974, (9.847, 19.853, 23.115)),
    (880559, (0.243, 14.144, 29.717)),
    (871502, (8.572, 13.839, 26.488)),
    (920550, (3.023, 17.073, 22.535)),
    (246971, (5.801, 18.319, 27.155)),
    (741979, (8.698, 13.247, 28.660)),
    (40772, (6.606, 15.305, 25.499)),
    (439266, (5.092, 19.298, 24.345)),
    (618501, (8.812, 14.162, 25.675)),
    (175666, (2.927, 10.096, 29.597)),
    (669317, (7.812, 15.796, 29.928)),
    (792362, (3.925, 18.255, 29.164)),
    (751713, (1.812, 19.387, 22.263)),
    (658964, (3.532, 12.486, 29.876)),
    (185718, (4.577, 12.442, 26.844)),
    (628091, (8.437, 17.021, 26.906)),
    (55524, (7.984, 12.656, 20.352)),
    (422343, (7.951, 17.282, 21.842)),
    (81689, (7.923, 10.109, 25.469)),
    (250929, (6.426, 12.620, 24.767)),
    (874690, (1.957, 12.064, 22.924)),
    (465028, (2.753, 18.111, 21.987)),
    (241321, (1.828, 13.124, 26.569)),
    (531227, (2.920, 19.497, 24.002)),
    (264952, (9.770, 16.884, 23.872)),
    (371504, (5.681, 16.100, 26.721)),
    (780610, (9.728, 16.339, 24.900)),
    (549209, (2.679, 14.827, 25.496)),
    (798267, (3.491, 12.750, 29.164)),
    (990558, (5.288, 16.792, 29.471)),
    (661891, (9.382, 16.558, 24.894)),
    (674022, (0.216, 14.574, 28.242)),
    (732746, (1.175, 11.971, 25.461)),
    (129722, (5.423, 11.820, 26.907)),
    (405896, (3.574, 10.216, 20.512)),
    (675549, (4.719, 15.417, 24.089)),
    (922393, (7.310, 12.937, 22.897)),
    (420831, (4.292, 19.668, 26.686)),
    (339954, (5.386, 14.434, 21.082)),
    (242619, (7.469, 19.525, 22.612)),
    (308558, (1.793, 15.993, 27.224)),
    (589562, (5.994, 12.463, 27.548)),
    (933784, (5.367, 14.575, 26.767)),
    (572872, (3.722, 16.893, 29.103)),
    (244176, (7.939, 14.392, 22.252)),
    (183257, (9.107, 19.829, 29.928)),
    (290260, (2.464, 14.614, 23.797)),
    (101676, (9.029, 10.351, 26.417)),
    (674059, (0.751, 10.082, 26.163)),
    (597030, (8.201, 16.189, 21.072)),
    (327750, (0.531, 12.352, 23.434)),
    (217924, (9.714, 10.038, 25.228)),
    (894067, (4.335, 14.617, 28.976)),
    (14636, (6.289, 17.349, 25.153)),
    (653881, (0.998, 16.760, 27.017)),
    (311936, (7.295, 16.952, 28.934)),
    (582438, (3.564, 14.723, 21.834)),
    (116066, (7.668, 16.973, 27.053)),
    (453739, (0.239, 10.296, 22.105)),
    (963608, (1.715, 13.663, 23.257)),
    (855211, (6.837, 14.882, 26.977)),
    (405899, (1.011, 14.841, 24.255)),
    (865294, (4.815, 10.465, 25.604)),
    (156989, (9.989, 10.284, 22.423)),
    (20724, (6.365, 13.407, 22.183)),
    (118348, (5.147, 18.719, 24.183)),
    (795076, (0.747, 14.839, 27.848)),
    (830871, (9.906, 12.958, 25.902)),
    (664602, (9.418, 16.386, 29.941)),
    (576835, (1.794, 17.130, 29.365)),
    (308373, (9.220, 10.999, 20.263)),
    (541715, (6.371, 14.395, 20.738)),
    (333720, (9.207, 10.209, 22.243)),
    (819386, (8.643, 16.214, 22.243)),
    (529584, (5.824, 13.025, 26.981)),
    (183769, (3.205, 13.036, 27.705)),
    (606343, (2.852, 16.879, 28.261)),
    (631520, (9.269, 16.756, 28.303)),
    (779382, (3.074, 17.041, 28.648)),
    (354674, (0.613, 15.479, 27.748)),
    (203352, (6.479, 13.731, 21.087)),
    (302742, (4.909, 10.915, 21.165)),
    (797062, (6.609, 13.032, 26.105)),
    (589543, (8.089, 17.935, 22.288)),
    (888055, (3.328, 13.261, 23.674)),
    (567869, (0.909, 11.033, 22.733)),
    (827822, (8.527, 16.831, 28.308)),
    (154798, (4.875, 10.732, 28.610)),
    (220238, (5.764, 10.713, 26.730)),
    (388294, (6.028, 16.687, 25.932)),
    (80581, (3.003, 18.575, 24.411)),
    (718787, (7.299, 11.945, 28.027)),
    (614291, (6.435, 10.738, 20.349)),
    (735904, (4.282, 17.772, 28.406)),
    (191853, (5.745, 11.272, 24.401)),
    (610501, (0.582, 15.715, 25.433)),
    (868093, (4.620, 15.565, 28.233)),
    (231347, (3.189, 15.899, 26.105)),
    (806273, (7.832, 18.261, 20.733)),
    (393428, (0.123, 13.666, 23.870)),
    (844489, (4.786, 10.650, 24.955)),
    (897256, (8.889, 19.733, 24.472)),
    (714631, (6.668, 13.228, 28.554)),
    (271676, (9.088, 14.909, 21.659)),
    (581004, (4.436, 14.486, 20.386)),
    (691153, (9.313, 18.007, 21.722)),
    (691707, (0.998, 10.768, 28.301)),
    (667013, (6.025, 10.344, 25.963)),
    (668983, (2.218, 17.972, 23.170)),
    (606027, (1.804, 12.054, 21.939)),
    (593933, (2.778, 13.948, 27.779)),
    (286659, (6.674, 18.308, 29.443)),
    (108350, (9.774, 11.680, 26.393)),
    (143012, (4.362, 19.073, 21.228)),
    (507236, (4.799, 17.008, 25.012)),
    (525412, (5.251, 10.026, 20.440)),
    (877448, (7.690, 10.891, 26.092)),
    (462500, (3.955, 11.178, 26.394)),
    (742568, (8.054, 11.767, 20.809)),
    (787616, (9.020, 14.401, 28.558)),
    (280754, (1.023, 10.467, 23.976)),
    (237825, (0.554, 18.681, 21.035)),
    (308029, (5.642, 17.827, 22.098)),
    (443523, (3.053, 10.543, 25.842)),
    (623687, (4.730, 15.653, 23.506)),
    (930867, (0.431, 19.880, 29.353)),
    (320641, (5.801, 16.499, 27.060)),
    (931775, (1.404, 15.184, 29.610)),
    (569587, (0.676, 13.099, 21.247)),
    (573073, (8.068, 17.304, 27.177)),
    (144156, (2.875, 16.829, 26.487)),
    (320475, (4.511, 13.163, 24.836)),
    (84015, (8.529, 18.768, 21.274)),
    (84550, (0.416, 19.864, 20.241)),
    (801217, (8.564, 16.636, 28.045)),
    (300680, (2.908, 19.828, 21.144)),
    (995603, (4.623, 10.807, 20.403)),
    (57831, (7.268, 13.125, 21.428)),
    (640216, (5.255, 10.910, 24.734)),
    (881828, (2.315, 11.344, 20.860)),
    (314933, (0.009, 15.975, 22.328)),
    (860622, (2.457, 17.796, 22.550)),
    (163342, (3.614, 10.705, 26.075)),
    (254275, (9.297, 17.296, 23.369)),
    (912115, (0.722, 14.048, 24.663)),
    (830062, (0.003, 19.090, 29.748)),
    (428433, (0.853, 16.571, 28.372)),
    (253706, (0.687, 11.360, 21.408)),
    (181930, (5.560, 10.650, 24.797)),
    (400039, (9.177, 14.839, 22.019)),
    (209629, (9.983, 13.178, 28.568)),
    (245458, (0.335, 17.868, 28.422)),
    (402274, (1.688, 10.335, 28.434)),
    (902115, (8.768, 15.696, 23.660)),
    (911777, (1.583, 17.421, 25.575)),
    (969872, (8.412, 18.635, 23.938)),
    (665259, (5.431, 16.940, 26.860)),
    (983035, (0.917, 10.136, 25.697)),
    (881731, (0.462, 18.750, 22.343)),
    (908495, (1.371, 13.706, 21.118)),
    (845915, (0.607, 14.170, 29.989)),
    (162229, (4.140, 13.725, 24.714)),
    (216162, (2.587, 11.775, 24.262)),
    (967123, (4.612, 19.321, 20.244)),
    (489269, (8.669, 14.526, 25.934)),
    (461261, (2.493, 13.793, 23.423)),
    (902804, (2.791, 12.437, 25.785)),
    (749907, (5.770, 18.740, 20.848)),
    (716784, (1.289, 11.296, 26.002)),
    (234686, (8.094, 13.048, 28.263)),
    (213957, (2.697, 18.484, 29.871)),
    (87598, (7.911, 18.917, 23.873)),
    (793847, (6.203, 12.491, 27.653)),
    (719985, (6.986, 12.504, 22.948)),
    (724542, (8.589, 11.714, 29.228)),
    (261599, (2.110, 19.694, 23.521)),
    (273535, (4.282, 18.102, 22.115)),
    (533061, (5.330, 18.485, 29.789)),
    (125321, (0.499, 19.508, 21.296)),
    (756237, (0.924, 15.521, 20.476)),
    (802201, (9.876, 13.760, 20.343)),
    (523955, (0.849, 16.600, 29.041)),
    (647026, (3.381, 14.481, 22.029)),
    (783473, (8.091, 12.024, 29.608)),
    (444118, (0.339, 11.350, 20.996)),
    (505558, (3.856, 15.703, 26.924)),
    (463697, (0.250, 10.773, 27.431)),
    (192462, (1.341, 12.394, 24.722)),
    (815955, (6.804, 15.446, 29.687)),
    (76320, (2.846, 18.036, 29.795)),
    (370118, (0.373, 13.298, 28.890)),
    (5093, (6.916, 17.034, 20.479)),
    (633737, (0.622, 10.306, 22.737)),
    (779443, (4.728, 12.340, 22.873)),
    (405945, (7.634, 16.217, 21.917)),
    (902343, (5.621, 10.645, 27.216)),
    (423612, (7.195, 19.151, 20.722)),
    (437104, (7.660, 13.820, 20.210)),
    (876266, (0.851, 13.735, 24.664)),
    (387948, (7.795, 15.617, 22.216)),
    (482025, (3.456, 17.528, 27.927)),
    (328258, (6.537, 18.903, 26.149)),
    (37595, (9.943, 19.965, 27.629)),
    (752982, (6.486, 11.389, 20.626)),
    (41202, (8.927, 13.800, 23.016)),
    (630521, (6.180, 12.246, 24.629)),
    (61484, (9.285, 18.261, 22.625)),
    (402249, (8.441, 13.617, 28.783)),
    (23249, (3.667, 10.764, 23.857)),
    (517079, (0.664, 11.945, 23.743)),
    (655664, (3.360, 11.331, 26.981)),
    (414470, (8.321, 14.387, 23.402)),
    (83957, (1.793, 18.825, 20.416)),
    (300004, (9.270, 15.088, 21.859)),
    (674019, (6.867, 14.489, 29.493)),
    (998671, (8.344, 10.850, 22.569)),
    (705667, (8.616, 10.245, 21.015)),
    (463783, (8.659, 16.246, 29.264)),
    (465403, (4.280, 10.850, 27.411)),
    (412843, (5.885, 11.493, 20.567)),
    (412988, (5.101, 16.044, 23.507)),
    (874321, (1.838, 16.012, 20.034)),
    (112128, (5.224, 10.680, 24.008)),
    (273048, (6.193, 17.766, 25.552)),
    (470129, (8.729, 19.739, 22.148)),
    (510069, (3.174, 11.663, 25.216)),
    (637061, (3.186, 13.440, 23.390)),
    (746781, (7.533, 17.579, 26.103)),
    (244541, (2.027, 11.745, 22.214)),
    (571388, (7.044, 14.974, 20.788)),
    (530740, (4.555, 10.601, 21.433)),
    (327942, (8.894, 10.240, 24.367)),
    (571928, (3.177, 16.744, 27.866)),
    (802137, (8.900, 14.358, 27.002)),
    (633026, (1.033, 12.992, 26.918)),
    (565785, (0.550, 19.596, 23.322)),
    (385047, (8.277, 19.089, 23.965)),
    (184688, (0.496, 12.122, 21.266)),
    (269176, (7.352, 19.470, 24.586)),
    (504799, (3.236, 17.515, 26.676)),
    (45577, (6.172, 15.832, 27.900)),
    (826526, (1.013, 19.478, 29.579)),
    (636561, (9.902, 19.119, 22.560)),
    (944237, (4.654, 11.017, 25.097)),
    (17858, (0.716, 10.758, 23.762)),
    (45754, (8.161, 15.878, 21.815)),
    (779929, (7.647, 17.468, 26.373)),
    (661412, (0.023, 10.101, 25.462)),
    (981248, (4.047, 18.904, 20.556)),
    (263390, (0.135, 14.652, 22.985)),
    (640477, (2.799, 15.380, 24.368)),
    (361365, (1.956, 14.693, 29.131)),
    (824950, (7.854, 10.402, 23.983)),
    (918705, (5.887, 17.698, 26.380)),
    (371756, (0.354, 16.179, 22.579)),
    (164508, (6.094, 11.508, 27.077)),
    (410427, (6.271, 18.856, 20.979)),
    (162787, (2.800, 10.810, 21.706)),
    (381887, (1.803, 16.532, 23.127)),
    (231287, (1.970, 19.609, 22.603)),
    (93549, (4.378, 11.950, 29.474)),
    (642379, (1.416, 14.539, 22.669)),
    (251628, (6.463, 12.371, 28.334)),
    (811825, (8.340, 12.966, 27.209)),
    (228577, (8.341, 17.248, 27.806)),
    (839942, (4.300, 15.980, 28.358)),
    (160245, (4.854, 18.056, 25.504)),
    (621285, (3.411, 17.220, 22.224)),
    (492829, (3.054, 16.344, 26.048)),
    (363069, (3.905, 14.316, 27.867)),
    (609375, (9.063, 13.433, 29.125)),
    (522841, (4.434, 15.270, 29.484)),
    (875240, (2.711, 17.933, 23.537)),
    (667115, (5.783, 15.638, 28.888)),
    (817100, (5.153, 11.356, 21.989)),
    (976724, (2.462, 18.548, 23.539)),
    (546765, (3.496, 10.207, 20.356)),
    (417154, (0.561, 18.063, 25.955)),
    (382615, (7.211, 17.525, 24.573)),
    (271142, (7.570, 16.211, 26.359)),
    (781505, (3.339, 12.014, 28.294)),
    (280889, (3.885, 13.460, 23.078)),
    (960556, (4.273, 10.052, 24.202)),
    (475556, (3.986, 16.493, 21.744)),
    (205442, (5.781, 12.546, 26.354)),
    (304651, (5.497, 18.637, 25.817)),
    (812149, (0.203, 18.425, 25.817)),
    (117965, (4.332, 10.618, 29.495)),
    (804305, (1.793, 14.212, 29.474)),
    (802887, (4.645, 19.447, 20.385)),
    (993377, (6.443, 18.170, 29.812)),
    (878976, (4.637, 17.485, 21.093)),
    (886610, (4.257, 12.507, 26.016)),
    (463185, (1.794, 19.122, 28.724)),
    (524961, (2.048, 11.804, 23.063)),
    (163685, (4.133, 13.243, 20.194)),
    (431760, (1.029, 10.458, 23.206)),
    (744415, (5.547, 17.276, 20.501)),
    (279771, (3.084, 18.246, 29.858)),
    (630504, (0.683, 19.691, 23.618)),
    (620374, (9.396, 10.230, 25.930)),
    (49873, (4.628, 12.407, 26.137)),
    (856786, (4.182, 10.434, 21.252)),
    (260305, (5.155, 19.224, 21.463)),
    (320110, (7.688, 12.030, 21.143)),
    (5055, (1.315, 10.698, 22.935)),
    (13363, (0.032, 18.192, 28.238)),
    (950809, (7.524, 17.356, 25.969)),
    (705764, (8.177, 13.187, 20.029)),
    (807294, (8.132, 17.556, 23.368)),
    (476911, (7.807, 15.652, 28.218)),
    (356216, (4.151, 15.032, 27.698)),
    (521921, (1.580, 15.599, 27.118)),
    (918324, (6.774, 18.108, 20.031)),
    (508858, (5.413, 10.515, 25.061)),
    (418811, (1.862, 16.960, 28.222)),
    (51155, (4.471, 16.012, 28.810)),
    (39462, (1.839, 15.145, 29.817)),
    (493052, (2.042, 10.517, 27.634)),
    (862773, (7.004, 13.959, 24.485)),
    (358683, (4.344, 12.534, 27.633)),
    (408697, (3.276, 12.495, 25.779)),
    (449856, (1.370, 16.206, 25.664)),
    (282912, (7.164, 14.306, 27.071)),
    (715862, (3.731, 18.346, 25.879)),
    (51076, (5.005, 18.341, 28.962)),
    (72593, (5.348, 17.293, 24.190)),
    (145419, (9.137, 13.709, 22.437)),
    (575925, (8.092, 11.106, 20.318)),
    (329464, (1.059, 11.961, 28.175)),
    (230887, (3.105, 12.084, 26.886)),
    (137507, (2.023, 14.808, 26.946)),
    (129050, (6.711, 11.637, 21.028)),
    (542053, (4.453, 13.104, 26.191)),
    (399594, (0.502, 10.648, 29.578)),
    (48914, (9.380, 16.277, 27.859)),
    (332026, (8.002, 18.489, 23.868)),
    (906220, (0.768, 18.351, 22.733)),
    (964149, (1.012, 12.826, 29.434)),
    (992427, (7.367, 13.348, 27.492)),
    (91801, (0.265, 17.998, 24.131)),
    (431750, (6.987, 11.362, 22.491)),
    (476381, (1.404, 17.860, 24.650)),
    (337032, (1.949, 17.714, 25.173)),
    (547752, (0.110, 19.380, 21.699)),
    (762116, (7.293, 16.433, 22.176)),
    (288416, (9.717, 15.376, 22.168)),
    (952167, (9.234, 10.645, 21.331)),
    (113028, (7.181, 12.861, 25.435)),
    (426272, (6.394, 15.352, 25.617)),
    (864505, (3.768, 11.178, 29.776)),
    (491276, (7.756, 16.702, 25.713)),
    (127910, (7.490, 14.824, 26.674)),
    (173314, (9.806, 11.996, 21.618)),
    (989782, (9.185, 16.473, 22.052)),
    (783558, (9.329, 14.105, 29.393)),
    (629877, (4.159, 12.835, 27.397)),
    (850314, (7.431, 11.371, 29.495)),
    (228483, (1.883, 14.555, 21.131)),
    (944660, (9.544, 16.659, 22.996)),
    (864644, (2.154, 10.442, 27.554)),
    (337655, (6.702, 12.903, 23.296)),
    (949693, (8.588, 11.128, 27.984)),
    (694227, (8.293, 13.895, 25.670)),
    (206757, (3.380, 15.558, 20.527)),
    (786783, (9.079, 15.022, 27.164)),
    (367817, (2.072, 17.415, 23.142)),
    (984855, (1.929, 18.533, 25.393)),
    (302492, (5.468, 16.183, 28.210)),
    (12103, (4.124, 11.348, 23.220)),
    (381867, (6.607, 18.151, 24.956)),
    (949417, (9.547, 13.772, 27.285)),
    (976164, (3.598, 19.537, 28.372)),
    (895948, (4.112, 18.115, 22.024)),
    (112517, (8.787, 14.962, 21.381)),
    (743453, (5.460, 14.942, 24.224)),
    (976783, (5.170, 16.454, 20.714)),
    (556170, (7.052, 16.471, 26.088)),
    (869503, (8.406, 13.210, 27.873)),
    (230701, (6.457, 19.614, 21.384)),
    (690922, (3.607, 15.668, 21.229)),
    (82447, (0.082, 18.557, 28.949)),
    (680628, (2.869, 19.097, 27.297)),
    (940818, (3.174, 18.240, 22.744)),
    (157994, (7.645, 18.276, 24.065)),
    (738166, (6.612, 16.556, 27.333)),
    (382720, (1.789, 13.226, 25.448)),
    (917577, (6.855, 19.010, 22.601)),
    (733200, (4.746, 13.600, 28.572)),
    (831862, (0.298, 12.610, 26.019)),
    (631904, (3.292, 14.036, 27.668)),
    (79821, (0.246, 16.871, 20.341)),
    (1100, (1.824, 14.672, 23.145)),
    (540349, (0.926, 12.040, 21.274)),
    (427753, (3.945, 13.198, 25.072)),
    (408881, (4.640, 19.156, 21.502)),
    (747055, (1.003, 13.676, 27.894)),
    (203717, (2.780, 11.311, 24.744)),
    (220784, (0.322, 14.097, 26.972)),
    (238647, (0.550, 13.149, 20.551)),
    (598983, (9.483, 17.796, 26.455)),
    (155815, (0.835, 14.304, 24.432)),
    (528875, (1.155, 19.364, 26.278)),
    (821279, (9.894, 10.554, 22.026)),
    (7356, (5.314, 17.819, 28.570)),
    (508180, (9.170, 15.200, 20.227)),
    (820264, (4.413, 10.476, 29.328)),
    (574937, (6.195, 12.507, 25.754)),
    (975708, (6.875, 11.301, 27.099)),
    (382600, (0.916, 16.821, 22.205)),
    (984116, (7.872, 15.451, 28.321)),
    (430225, (6.805, 18.269, 25.145)),
    (467658, (8.501, 18.905, 24.354)),
    (471991, (8.834, 14.869, 27.631)),
    (678549, (0.365, 14.753, 23.644)),
    (141650, (4.597, 11.780, 21.704)),
    (236258, (9.224, 14.948, 22.675)),
    (820797, (4.939, 11.959, 28.362)),
    (277683, (8.531, 16.776, 25.702)),
    (349236, (2.463, 11.643, 20.276)),
    (431202, (8.543, 19.753, 23.700)),
    (921915, (7.222, 13.385, 23.409)),
    (789716, (6.631, 13.351, 27.221)),
    (995919, (2.791, 14.368, 28.121)),
    (516764, (2.393, 19.430, 29.571)),
    (403155, (2.893, 16.443, 29.652)),
    (586403, (5.994, 16.189, 24.294)),
    (624868, (2.073, 11.973, 24.839)),
    (870041, (5.523, 19.789, 25.202)),
    (651064, (3.976, 15.624, 26.836)),
    (939774, (2.707, 16.412, 24.542)),
    (663447, (3.116, 12.286, 29.338)),
    (743792, (8.693, 18.083, 28.222)),
    (582790, (1.279, 13.646, 23.755)),
    (230973, (0.623, 15.757, 23.646)),
    (900790, (0.380, 17.296, 28.683)),
    (396885, (2.685, 12.754, 27.120)),
    (482618, (0.761, 19.434, 24.241)),
    (185513, (6.652, 13.533, 20.568)),
    (823031, (6.879, 16.241, 22.201)),
    (228377, (3.850, 13.502, 23.709)),
    (636514, (3.685, 13.002, 28.361)),
    (267081, (5.291, 16.459, 25.691)),
    (861194, (4.662, 15.886, 23.134)),
    (155821, (4.353, 15.339, 26.392)),
    (256882, (1.378, 19.014, 24.891)),
    (810095, (6.991, 16.965, 22.727)),
    (335315, (5.385, 14.296, 29.316)),
    (90257, (1.178, 12.426, 22.309)),
    (641591, (8.957, 13.637, 27.741)),
    (323762, (6.539, 13.488, 21.495)),
    (831612, (6.387, 12.108, 20.473)),
    (885873, (5.318, 18.725, 24.682)),
    (358640, (2.741, 16.310, 25.522)),
    (64533, (5.694, 16.527, 21.845)),
    (844700, (0.664, 10.277, 21.926)),
    (331485, (4.203, 13.450, 29.299)),
    (560653, (7.415, 18.104, 20.778)),
    (206941, (9.486, 17.524, 23.655)),
    (632412, (5.381, 10.176, 21.497)),
    (722666, (0.851, 17.301, 29.453)),
    (320451, (5.644, 18.053, 29.096)),
    (733606, (8.392, 11.296, 22.873)),
    (24375, (6.964, 18.888, 27.409)),
    (525023, (5.167, 12.344, 28.624)),
    (573771, (8.378, 15.246, 29.496)),
    (468694, (8.323, 10.355, 26.527)),
    (280323, (3.057, 13.380, 21.312)),
    (978726, (9.277, 15.590, 21.243)),
    (141780, (5.912, 18.729, 27.094)),
    (541006, (6.003, 12.808, 28.889)),
    (760672, (8.393, 12.561, 22.648)),
    (326449, (6.339, 11.703, 23.961)),
    (996068, (4.543, 13.916, 20.113)),
    (857038, (0.549, 14.151, 22.787)),
    (423662, (4.273, 15.393, 26.429)),
    (722564, (1.223, 10.433, 25.404)),
    (606258, (5.057, 10.173, 20.605)),
    (564464, (3.927, 18.278, 27.202)),
    (743575, (7.413, 16.481, 21.467)),
    (64931, (5.073, 14.451, 23.849)),
    (448659, (5.104, 14.797, 29.795)),
    (803171, (7.362, 19.414, 28.809)),
    (292171, (7.884, 13.397, 22.637)),
    (340699, (1.339, 15.537, 23.573)),
    (222891, (2.716, 13.335, 23.737)),
    (407019, (4.273, 17.085, 27.778)),
    (586304, (5.968, 13.978, 21.453)),
    (844147, (5.196, 19.619, 28.627)),
    (10323, (1.560, 17.066, 22.027)),
    (330923, (6.741, 12.848, 21.922)),
    (228539, (5.876, 19.596, 20.043)),
    (735665, (1.212, 19.616, 20.452)),
    (935636, (1.877, 11.499, 23.474)),
    (791613, (8.474, 19.176, 24.308)),
    (966267, (1.539, 11.462, 27.416)),
    (736592, (6.393, 12.927, 26.622)),
    (993433, (3.432, 16.301, 22.445)),
    (790154, (2.367, 11.217, 20.638)),
    (218312, (0.547, 11.578, 27.077)),
    (717703, (8.935, 11.136, 25.874)),
    (67840, (2.562, 15.090, 25.486)),
    (881222, (8.159, 13.938, 27.602)),
    (761913, (6.793, 18.122, 28.811)),
    (470223, (4.915, 19.393, 27.624)),
    (977834, (7.554, 19.630, 20.014)),
    (437070, (1.020, 16.952, 24.883)),
    (72424, (0.551, 13.505, 24.927)),
    (465247, (8.771, 11.721, 23.091)),
    (811976, (1.062, 14.321, 23.850)),
    (551289, (0.620, 10.596, 20.556)),
    (617272, (8.893, 11.532, 23.048)),
    (480633, (0.460, 15.362, 20.324)),
    (894965, (2.188, 14.986, 25.414)),
    (504669, (1.691, 15.737, 28.995)),
    (221264, (1.650, 17.493, 25.226)),
    (942594, (6.994, 10.755, 20.643)),
    (226774, (7.014, 14.348, 23.220)),
    (196656, (3.613, 12.127, 20.192)),
    (628183, (6.268, 14.459, 22.866)),
    (267307, (9.380, 19.742, 26.229)),
    (822071, (0.898, 19.689, 21.470)),
    (380536, (3.217, 15.299, 27.545)),
    (941048, (8.616, 12.394, 20.540)),
    (95305, (5.889, 14.697, 27.771)),
    (861090, (5.554, 10.866, 22.256)),
    (864575, (6.930, 14.259, 21.517)),
    (475871, (1.472, 15.065, 29.000)),
    (451889, (5.245, 19.216, 27.739)),
    (123056, (8.441, 19.662, 27.372)),
    (28362, (6.551, 17.833, 23.995)),
    (279970, (0.972, 19.423, 25.156)),
    (736570, (7.402, 18.027, 21.982)),
    (314901, (4.145, 15.757, 24.522)),
    (204405, (9.964, 13.828, 24.933)),
    (815289, (8.837, 17.400, 27.251)),
    (790651, (3.733, 10.747, 24.377)),
    (860324, (4.318, 18.952, 29.260)),
    (541473, (9.368, 12.866, 21.007)),
    (23471, (8.175, 12.947, 23.766)),
    (5600, (0.096, 17.586, 20.924)),
    (766442, (0.636, 12.375, 25.192)),
    (646365, (6.249, 11.861, 25.656)),
    (100426, (7.625, 19.058, 21.216)),
    (777838, (8.875, 19.789, 23.360)),
    (711148, (2.593, 19.002, 26.069)),
    (747169, (6.298, 17.366, 23.862)),
    (310904, (0.569, 11.918, 21.375)),
    (879440, (2.468, 10.907, 20.349)),
    (145436, (2.709, 18.565, 22.498)),
    (827075, (7.724, 14.649, 20.584)),
    (958791, (3.725, 16.329, 29.374)),
    (628420, (0.447, 15.809, 21.060)),
    (919028, (3.843, 12.255, 25.061)),
    (129511, (0.361, 15.789, 24.374)),
    (757495, (4.351, 19.742, 29.836)),
    (397067, (6.980, 12.854, 23.410)),
    (618146, (0.983, 15.385, 25.431)),
    (378845, (2.724, 17.409, 26.802)),
    (436125, (4.177, 14.128, 27.126)),
    (739267, (3.651, 13.933, 24.206)),
    (46017, (1.822, 17.746, 22.981)),
    (875416, (9.063, 19.811, 22.378)),
    (467963, (0.131, 18.120, 23.999)),
    (557322, (4.046, 17.424, 29.560)),
    (367133, (7.681, 15.010, 22.905)),
    (597450, (9.144, 19.798, 28.239)),
    (189614, (0.649, 16.209, 26.875)),
    (432479, (7.230, 13.002, 23.306)),
    (739100, (9.728, 19.096, 29.690)),
    (525324, (0.289, 12.913, 26.678)),
    (409007, (8.787, 12.233, 23.161)),
    (91366, (4.825, 13.679, 26.290)),
    (812086, (4.349, 10.515, 23.600)),
    (263474, (8.768, 13.987, 27.092)),
    (881451, (4.256, 16.329, 20.325)),
    (456436, (3.792, 12.502, 23.357)),
    (337861, (5.524, 16.756, 22.112)),
    (116107, (3.542, 14.393, 22.287)),
    (161156, (4.021, 13.994, 21.870)),
    (560281, (1.911, 14.239, 21.465)),
    (357894, (4.331, 14.576, 24.296)),
    (925313, (9.367, 13.460, 21.443)),
    (554360, (8.350, 13.090, 27.474)),
    (947670, (8.166, 12.062, 25.183)),
    (179262, (6.854, 19.159, 22.174)),
    (357886, (2.643, 10.049, 28.720)),
    (647302, (8.069, 13.623, 22.567)),
    (735616, (7.155, 13.033, 28.230)),
    (44221, (3.867, 19.767, 21.767)),
    (881264, (0.249, 13.674, 27.289)),
    (227979, (5.696, 12.088, 20.478)),
    (201533, (9.748, 14.174, 27.868)),
    (103860, (7.569, 16.347, 28.938)),
    (842489, (3.222, 14.043, 27.501)),
    (208264, (0.433, 19.586, 27.911)),
    (422580, (1.295, 10.100, 28.974)),
    (534415, (7.053, 16.918, 23.402)),
    (141749, (0.661, 10.286, 26.226)),
    (679313, (0.791, 14.544, 21.965)),
    (449864, (8.266, 17.212, 25.929)),
    (81181, (1.201, 11.843, 29.745)),
    (496794, (8.432, 11.114, 23.078)),
    (854664, (2.073, 16.145, 23.254)),
    (802142, (7.307, 18.529, 28.884)),
    (612252, (0.784, 10.696, 28.677)),
    (338930, (4.393, 15.720, 21.651)),
    (335934, (1.163, 19.227, 27.110)),
    (601026, (4.536, 10.155, 22.280)),
    (209709, (6.624, 15.606, 26.128)),
    (599876, (0.237, 13.140, 27.494)),
    (52211, (0.539, 16.932, 24.305)),
    (360688, (3.353, 18.879, 22.769)),
    (89983, (9.877, 18.017, 20.122)),
    (713913, (4.259, 16.557, 27.725)),
    (857327, (9.942, 17.565, 26.480)),
    (175391, (9.929, 11.676, 21.386)),
    (641323, (9.288, 10.884, 22.672)),
    (215705, (8.982, 16.885, 23.512)),
    (172655, (6.040, 11.171, 27.691)),
    (412120, (2.973, 13.368, 20.378)),
    (351078, (8.620, 13.052, 26.089)),
    (522520, (2.830, 19.812, 22.618)),
    (913442, (1.151, 11.695, 20.916)),
    (96645, (7.559, 13.041, 29.003)),
    (190085, (4.192, 15.131, 23.591)),
    (966535, (6.996, 18.260, 23.678)),
    (760289, (4.517, 14.794, 20.671)),
    (884280, (9.629, 13.585, 26.960)),
    (527046, (8.240, 18.837, 22.039)),
    (116153, (7.396, 15.754, 25.625)),
    (689165, (5.774, 17.798, 24.360)),
    (639789, (9.743, 18.607, 21.652)),
    (906172, (9.725, 12.482, 28.106)),
    (913373, (3.844, 14.778, 24.466)),
    (253677, (8.504, 13.335, 24.865)),
    (770332, (8.786, 14.529, 24.035)),
    (522098, (3.118, 11.764, 29.241)),
    (195118, (6.453, 19.398, 21.995)),
    (569957, (9.964, 16.304, 29.214)),
    (846, (3.568, 14.115, 29.764)),
    (655238, (2.474, 19.501, 22.469)),
    (743188, (1.697, 16.979, 28.999)),
    (28907, (5.285, 14.504, 23.663)),
    (470483, (0.289, 12.824, 26.456)),
    (250344, (5.196, 16.848, 24.964)),
    (484808, (9.671, 14.297, 20.477)),
    (437648, (6.045, 19.803, 22.481)),
    (564265, (6.300, 17.489, 22.939)),
    (198067, (1.760, 13.558, 21.393)),
    (617627, (1.564, 17.555, 28.226)),
    (708140, (7.363, 16.526, 24.139)),
    (909769, (1.137, 15.680, 24.788)),
    (612177, (1.051, 15.458, 26.336)),
    (472525, (5.083, 19.814, 28.715)),
    (12908, (3.152, 14.940, 23.824)),
    (739213, (8.309, 19.393, 25.708)),
    (951743, (6.827, 12.779, 23.486)),
    (112230, (5.723, 19.648, 25.582)),
    (240740, (1.241, 12.201, 25.330)),
    (943086, (6.753, 11.034, 29.898)),
    (749979, (9.249, 15.697, 20.042)),
    (812878, (8.391, 11.703, 21.106)),
    (401199, (3.541, 10.603, 20.437)),
    (620570, (7.718, 11.921, 20.836)),
    (389383, (0.650, 18.977, 24.231)),
    (265237, (8.688, 11.690, 21.881)),
    (844533, (7.896, 10.798, 20.931)),
    (867767, (4.323, 11.053, 26.444)),
    (869504, (5.030, 16.057, 29.925)),
    (916827, (8.612, 16.250, 25.058)),
    (42397, (4.552, 16.608, 28.752)),
    (831596, (4.110, 18.252, 28.577)),
    (733463, (8.999, 19.656, 21.241)),
    (711862, (1.784, 12.574, 26.789)),
    (880457, (9.061, 14.578, 26.416)),
    (229851, (1.197, 17.144, 29.218)),
    (609212, (2.077, 18.499, 21.653)),
    (920738, (7.580, 10.922, 29.888)),
    (55632, (9.433, 16.988, 20.802)),
    (285556, (4.058, 12.645, 23.505)),
    (386433, (3.886, 15.959, 28.886)),
    (133076, (5.481, 12.369, 22.083)),
    (432608, (4.643, 16.615, 20.616)),
    (83246, (6.055, 16.313, 28.136)),
    (451187, (5.841, 13.631, 29.119)),
    (969045, (2.706, 19.724, 26.810)),
    (766236, (2.826, 13.990, 25.227)),
    (536995, (5.871, 16.906, 27.883)),
    (780098, (7.392, 12.825, 27.845)),
    (219275, (4.105, 19.623, 28.088)),
    (704494, (1.163, 11.915, 29.840)),
    (636766, (5.805, 17.939, 26.598)),
    (450254, (7.006, 15.071, 28.098)),
    (74626, (6.419, 13.423, 28.323)),
    (951007, (5.297, 12.071, 24.856)),
    (36462, (1.850, 12.553, 25.262)),
    (750532, (3.097, 12.798, 27.060)),
    (425549, (9.000, 13.671, 24.185)),
    (974495, (8.366, 11.619, 22.506)),
    (971715, (5.672, 12.188, 29.450)),
    (797658, (3.937, 15.766, 28.262)),
    (282433, (1.308, 17.232, 20.337)),
    (980665, (7.095, 16.857, 28.279)),
    (293394, (7.337, 18.589, 22.677)),
    (789382, (3.302, 11.301, 22.651)),
    (871105, (4.884, 12.569, 24.757)),
    (52427, (9.180, 13.715, 20.052)),
    (451079, (9.262, 12.434, 22.465)),
    (545554, (9.041, 14.222, 22.369)),
    (143314, (0.113, 19.419, 28.060)),
    (905648, (7.043, 16.284, 23.542)),
    (626018, (2.789, 19.507, 24.941)),
    (293674, (7.049, 13.528, 25.770)),
    (886121, (3.837, 18.085, 29.777)),
    (599222, (6.866, 10.118, 24.668)),
    (946723, (7.945, 12.359, 26.572)),
    (399146, (9.343, 19.990, 29.253)),
    (618972, (7.190, 16.300, 29.172)),
    (227137, (5.802, 10.047, 24.511)),
    (646195, (3.691, 14.138, 21.447)),
    (24312, (7.399, 12.086, 24.114)),
    (784731, (6.264, 18.788, 21.597)),
    (665672, (4.060, 14.389, 21.686)),
    (92837, (9.768, 18.101, 20.212)),
    (578127, (5.223, 15.496, 20.749)),
    (524078, (9.221, 14.046, 23.865)),
    (172537, (4.618, 15.435, 21.634)),
    (682363, (6.571, 16.751, 28.360)),
    (148724, (5.265, 11.834, 27.087)),
    (153230, (8.370, 14.715, 22.598)),
    (886812, (0.878, 14.145, 20.648)),
    (729837, (8.883, 13.718, 28.282)),
    (336791, (7.585, 10.817, 24.079)),
    (660967, (0.813, 16.572, 26.749)),
    (119624, (5.767, 17.579, 28.262)),
    (374999, (5.883, 19.927, 21.461)),
    (855678, (7.302, 12.238, 29.248)),
    (354135, (5.192, 10.273, 24.259)),
    (187307, (3.717, 13.563, 24.506)),
    (708402, (1.878, 18.662, 26.588)),
    (462007, (2.925, 11.562, 23.567)),
    (722524, (1.756, 16.349, 27.280)),
    (226954, (0.827, 10.127, 23.063)),
    (947115, (1.354, 15.483, 24.197)),
    (322086, (4.432, 11.365, 26.771)),
    (293288, (3.549, 12.335, 21.325)),
    (556501, (6.582, 18.263, 28.562)),
    (819885, (7.719, 14.321, 27.706)),
    (137826, (2.247, 11.039, 22.942)),
    (389272, (4.975, 18.059, 20.458)),
    (432675, (8.722, 11.736, 21.505)),
    (912549, (6.294, 19.393, 26.091)),
    (694716, (5.624, 15.996, 28.363)),
    (828476, (4.349, 16.170, 23.822)),
    (226045, (2.364, 10.540, 28.550)),
    (764036, (7.446, 12.230, 26.001)),
    (274360, (9.846, 14.201, 29.829)),
    (140285, (7.568, 13.690, 21.497)),
    (724576, (4.229, 18.310, 24.884)),
    (950971, (9.091, 10.331, 22.297)),
    (68360, (5.125, 14.039, 29.250)),
    (100200, (0.819, 10.279, 29.408)),
    (16372, (4.016, 15.608, 27.260)),
    (177152, (0.752, 15.172, 29.065)),
    (50279, (3.917, 15.729, 25.769)),
    (439804, (1.844, 15.191, 21.907)),
    (808883, (3.662, 17.480, 29.781)),
    (411037, (4.991, 13.192, 29.585)),
    (753341, (2.799, 15.610, 20.950)),
    (228888, (3.914, 14.952, 27.624)),
    (837955, (0.625, 14.029, 25.999)),
    (155009, (9.136, 15.944, 29.993)),
    (42326, (3.930, 16.585, 28.037)),
    (409407, (9.895, 10.312, 27.290)),
    (128624, (8.112, 14.779, 21.496)),
    (439178, (7.660, 19.046, 26.179)),
    (985503, (6.231, 19.448, 22.271)),
    (165344, (1.680, 15.201, 21.610)),
    (125187, (4.387, 16.110, 21.778)),
    (382573, (5.982, 14.464, 23.569)),
    (853117, (2.036, 13.913, 23.256)),
    (340555, (0.474, 13.543, 27.139)),
    (871248, (3.704, 18.856, 25.075)),
    (389691, (0.068, 15.319, 27.421)),
    (646093, (6.110, 13.968, 21.293)),
    (842055, (6.712, 10.446, 20.879)),
    (944360, (9.556, 11.828, 28.788)),
    (930124, (0.624, 19.609, 29.839)),
    (115156, (9.926, 10.965, 29.964)),
    (848507, (0.062, 12.734, 23.310)),
    (646890, (9.947, 11.549, 23.056)),
    (639147, (6.232, 10.903, 20.940)),
    (24283, (8.079, 15.318, 25.099)),
    (417039, (1.723, 19.110, 29.545)),
    (750315, (2.313, 15.855, 29.914)),
    (982955, (1.711, 16.765, 29.473)),
    (234787, (3.119, 11.594, 25.258)),
    (146617, (0.564, 10.923, 20.444)),
    (7533, (6.986, 15.628, 29.855)),
    (778031, (3.150, 15.531, 23.047)),
    (882555, (5.108, 11.464, 29.720)),
    (57463, (3.150, 18.432, 21.985)),
    (981776, (6.058, 18.343, 21.240)),
    (82673, (2.747, 17.362, 26.669)),
    (23586, (5.323, 16.898, 27.706)),
    (672163, (6.023, 15.515, 23.457)),
    (215598, (4.860, 16.269, 26.595)),
    (358470, (0.820, 17.823, 23.011)),
    (607266, (1.518, 15.126, 27.749)),
    (447273, (6.967, 16.050, 28.157)),
    (266750, (0.320, 10.349, 26.149)),
    (374152, (4.613, 18.696, 26.634)),
    (220992, (5.501, 15.121, 25.033)),
    (292809, (1.390, 11.174, 27.467)),
    (531575, (1.516, 13.884, 25.981)),
    (772473, (5.594, 14.635, 29.237)),
    (134804, (2.895, 12.697, 22.531)),
    (594884, (0.751, 13.227, 29.905)),
    (82970, (6.199, 10.810, 20.480)),
    (533394, (3.462, 15.952, 28.792)),
    (916955, (0.825, 17.827, 22.805)),
    (140180, (1.145, 12.363, 26.157)),
    (701663, (1.220, 19.365, 29.247)),
    (304991, (8.531, 13.032, 29.684)),
    (380829, (2.123, 14.752, 20.857)),
    (846647, (8.097, 19.818, 27.751)),
    (232667, (8.781, 15.054, 22.411)),
    (331404, (9.340, 11.229, 26.743)),
    (223405, (7.067, 17.902, 24.146)),
    (271196, (1.407, 16.750, 25.516)),
    (917647, (5.255, 12.550, 22.138)),
    (672135, (4.195, 16.689, 23.440)),
    (129420, (0.968, 13.270, 23.340)),
    (513525, (7.936, 18.751, 29.163)),
    (790903, (4.840, 10.069, 24.139)),
    (574423, (8.933, 13.029, 28.099)),
    (124981, (8.123, 17.540, 23.606)),
    (907937, (0.672, 13.155, 27.058)),
    (150258, (6.011, 14.789, 22.960)),
    (856789, (5.773, 19.565, 28.942)),
    (29672, (4.675, 10.550, 20.693)),
    (964130, (7.110, 14.833, 27.074)),
    (774642, (1.577, 15.285, 26.324)),
    (589365, (3.476, 19.752, 25.231)),
    (489980, (2.493, 12.936, 28.661)),
    (696455, (6.085, 18.833, 28.599)),
    (12200, (5.836, 15.189, 26.058)),
    (129186, (2.657, 15.852, 20.961)),
    (662861, (3.333, 19.048, 29.967)),
    (969966, (4.254, 13.776, 20.768)),
    (601352, (0.057, 13.189, 26.621)),
    (696250, (3.510, 19.880, 26.783)),
    (902724, (6.039, 16.767, 22.625)),
    (577965, (7.922, 15.569, 22.434)),
    (540790, (4.075, 16.417, 28.338)),
    (896327, (4.655, 16.289, 27.789)),
    (645808, (3.835, 15.978, 25.206)),
    (904103, (2.851, 11.364, 21.091)),
    (207432, (5.643, 19.421, 23.223)),
    (851685, (5.140, 18.000, 27.204)),
    (623168, (8.721, 19.209, 26.406)),
    (889766, (7.198, 11.646, 29.944)),
    (992414, (7.587, 13.530, 26.369)),
    (512733, (7.598, 13.889, 23.188)),
    (62713, (5.309, 18.948, 23.987)),
    (559668, (8.227, 10.046, 26.803)),
    (285363, (3.868, 18.531, 29.161)),
    (103549, (1.927, 16.969, 28.076)),
    (769557, (1.464, 19.196, 23.081)),
    (738500, (9.020, 16.398, 26.721)),
    (183853, (2.217, 10.251, 24.908)),
    (952067, (5.069, 17.961, 24.258)),
    (291674, (2.462, 11.562, 20.462)),
    (893408, (4.393, 13.252, 25.676)),
    (885680, (9.851, 17.669, 23.332)),
    (526962, (8.602, 12.643, 26.167)),
    (631861, (0.456, 13.615, 28.887)),
    (20085, (5.216, 11.662, 25.606)),
    (228813, (8.487, 12.436, 21.727)),
    (593138, (2.069, 19.071, 23.665)),
    (735940, (1.839, 14.730, 26.962)),
    (435991, (0.020, 10.823, 21.642)),
    (73364, (4.188, 15.411, 29.461)),
    (698564, (2.213, 15.068, 29.789)),
    (374346, (4.676, 15.477, 26.797)),
    (744518, (6.560, 15.282, 27.232)),
    (395571, (4.718, 13.815, 23.674)),
    (959782, (5.182, 10.922, 25.881)),
    (124201, (1.047, 10.524, 21.278)),
    (42717, (4.871, 19.165, 20.949)),
    (277366, (2.144, 16.275, 23.670)),
    (119170, (1.279, 18.854, 21.914)),
    (755375, (9.389, 10.190, 29.108)),
    (165939, (4.294, 15.266, 25.734)),
    (713631, (6.274, 10.807, 25.325)),
    (489243, (1.713, 11.519, 25.366)),
    (623033, (2.223, 10.391, 23.297)),
    (199308, (2.208, 13.981, 23.070)),
    (853418, (6.450, 11.477, 21.061)),
    (906084, (6.571, 10.525, 23.179)),
    (111354, (3.025, 10.282, 23.608)),
    (266642, (3.656, 19.640, 23.514)),
    (266256, (7.681, 16.473, 27.044)),
    (1610, (3.360, 17.755, 20.924)),
    (375334, (9.476, 15.570, 20.475)),
    (122989, (3.320, 14.569, 25.206)),
    (511113, (7.827, 16.735, 21.264)),
    (735617, (8.807, 15.027, 26.688)),
    (674747, (4.907, 14.332, 20.557)),
    (655076, (7.916, 16.373, 26.053)),
    (599296, (1.274, 10.979, 25.816)),
    (313787, (6.192, 12.655, 21.812)),
    (289296, (1.617, 19.161, 26.459)),
    (758364, (8.077, 11.867, 26.057)),
    (829078, (2.885, 18.848, 22.334)),
    (696348, (8.483, 11.824, 25.343)),
    (378765, (2.998, 19.731, 24.012)),
    (620195, (3.236, 14.707, 29.188)),
    (901861, (8.761, 12.315, 23.447)),
    (262829, (7.811, 19.622, 20.365)),
    (867269, (5.160, 12.074, 21.317)),
    (822717, (0.412, 12.900, 28.101)),
    (297769, (6.871, 11.377, 28.729)),
    (822123, (2.812, 13.976, 22.586)),
    (42643, (9.852, 16.230, 20.342)),
    (870518, (2.611, 13.091, 22.558)),
    (828413, (2.233, 10.001, 20.701)),
    (541468, (0.767, 13.661, 29.307)),
    (929769, (8.163, 16.852, 26.834)),
    (55941, (9.845, 16.187, 23.085)),
    (49461, (2.499, 14.422, 24.625)),
    (304020, (5.423, 17.855, 26.119)),
    (977388, (2.762, 14.425, 25.872)),
    (824034, (5.064, 18.468, 22.187)),
    (762495, (3.425, 15.108, 24.728)),
    (15991, (7.790, 16.500, 25.302)),
    (991077, (5.602, 15.263, 21.406)),
    (9499, (7.706, 13.208, 23.835)),
    (114723, (4.660, 11.755, 25.208)),
    (58465, (1.503, 10.347, 21.470)),
    (182184, (5.169, 11.699, 26.198)),
    (289327, (9.113, 15.852, 25.936)),
    (366042, (1.904, 15.559, 23.619)),
    (141581, (8.467, 10.081, 22.417)),
    (197170, (9.489, 10.567, 23.895)),
    (615854, (4.849, 12.807, 25.364)),
    (322561, (8.218, 15.498, 23.378)),
    (582098, (6.988, 16.220, 29.844)),
    (601141, (1.622, 13.602, 23.909)),
    (123719, (2.111, 12.224, 21.136)),
    (422011, (9.801, 12.482, 24.401)),
    (256277, (4.694, 16.081, 20.727)),
    (389274, (3.222, 16.220, 22.142)),
    (40609, (9.461, 11.550, 25.206)),
    (594006, (2.101, 10.141, 28.069)),
    (617977, (8.425, 18.959, 28.232)),
    (178984, (8.937, 14.909, 21.095)),
    (22114, (9.931, 18.719, 24.860)),
    (379940, (9.614, 14.783, 28.951)),
    (953268, (1.687, 16.964, 28.844)),
    (318601, (8.762, 13.791, 20.787)),
    (906201, (0.005, 10.992, 20.848)),
    (767576, (0.398, 17.005, 23.633)),
    (93522, (4.622, 11.542, 22.706)),
    (879944, (0.959, 15.309, 25.253)),
    (760737, (3.870, 19.481, 29.672)),
    (741298, (0.007, 13.771, 25.600)),
    (774667, (5.193, 15.037, 26.603)),
    (783279, (0.214, 19.787, 29.957)),
    (547741, (8.623, 13.831, 25.212)),
    (534101, (2.485, 10.075, 20.120)),
    (690544, (5.140, 11.642, 24.697)),
    (908439, (0.770, 12.436, 27.329)),
    (277204, (6.857, 18.755, 28.583)),
    (873290, (1.788, 13.410, 26.828)),
    (77921, (0.721, 15.494, 24.627)),
    (512112, (0.774, 15.477, 20.496)),
    (986841, (1.117, 10.662, 27.638)),
    (683813, (7.043, 18.709, 26.401)),
    (70626, (4.038, 14.123, 23.469)),
    (761469, (0.789, 17.108, 27.009)),
    (770246, (7.119, 19.601, 23.435)),
    (682569, (5.154, 18.881, 24.387)),
    (465355, (6.500, 19.076, 29.321)),
    (404620, (8.418, 10.748, 27.038)),
    (890740, (5.520, 14.275, 22.380)),
    (357961, (9.863, 13.413, 24.045)),
    (81943, (1.209, 19.974, 27.262)),
    (751514, (2.100, 12.712, 29.992)),
    (65758, (7.708, 15.355, 23.759)),
    (622584, (5.512, 13.514, 28.511)),
    (858191, (5.913, 16.207, 29.050)),
    (417038, (2.314, 17.414, 21.593)),
    (667091, (6.014, 15.344, 28.745)),
    (929014, (8.309, 17.754, 23.224)),
    (847136, (3.709, 16.600, 29.826)),
    (670808, (7.529, 10.190, 23.461)),
    (344498, (5.325, 11.100, 24.335)),
    (580402, (8.217, 18.528, 26.377)),
    (524485, (3.407, 10.789, 23.370)),
    (64000, (2.186, 16.109, 27.099)),
    (23701, (4.831, 18.274, 23.320)),
    (862929, (0.897, 13.399, 22.663)),
    (469647, (4.194, 12.955, 29.991)),
    (942483, (5.405, 14.193, 28.567)),
    (512772, (5.224, 16.273, 22.408)),
    (697378, (9.721, 10.843, 20.996)),
    (218249, (8.596, 14.382, 22.609)),
    (457973, (2.328, 12.646, 21.441)),
    (22272, (5.337, 15.674, 24.371)),
    (600568, (6.138, 12.789, 22.035)),
    (538267, (0.608, 14.668, 26.583)),
    (408971, (5.429, 14.654, 24.012)),
    (734715, (0.947, 13.767, 23.449)),
    (223684, (6.773, 10.643, 23.141)),
    (146547, (2.760, 14.597, 29.784)),
    (934069, (0.776, 15.286, 22.438)),
    (353346, (7.878, 12.198, 25.481)),
    (414347, (8.323, 18.232, 21.144)),
    (644712, (2.739, 18.686, 27.611)),
    (229713, (7.487, 13.201, 20.350)),
    (789601, (0.183, 15.993, 24.132)),
    (433961, (4.855, 13.365, 28.066)),
    (798842, (8.347, 14.121, 28.904)),
    (806626, (8.002, 11.255, 28.281)),
    (787480, (2.507, 11.939, 22.749)),
    (370482, (9.307, 14.393, 20.747)),
    (938670, (4.842, 18.489, 26.977)),
    (566145, (8.572, 12.218, 23.665)),
    (912106, (3.701, 13.067, 26.964)),
    (356737, (8.379, 18.654, 28.452)),
    (122673, (8.883, 15.588, 22.361)),
    (69162, (3.329, 17.265, 25.416)),
    (245831, (8.471, 15.979, 20.007)),
    (41419, (9.575, 10.038, 20.019)),
    (577761, (4.524, 10.762, 28.986)),
    (545594, (5.054, 19.732, 29.269)),
    (468702, (5.672, 19.324, 25.874)),
    (779663, (2.621, 11.896, 20.606)),
    (419815, (0.390, 13.852, 24.551)),
    (252864, (9.428, 11.353, 23.568)),
    (731647, (4.304, 15.182, 25.814)),
    (566755, (4.728, 10.628, 26.495)),
    (391534, (9.853, 14.145, 29.140)),
    (597526, (1.633, 12.716, 28.020)),
    (853259, (9.039, 13.784, 29.996)),
    (245045, (1.548, 18.830, 26.335)),
    (291289, (9.992, 10.395, 20.408)),
    (712881, (3.362, 16.658, 25.924)),
    (507294, (7.586, 13.581, 25.594)),
    (392529, (0.070, 16.035, 22.295)),
    (367114, (2.862, 16.121, 24.734)),
    (13642, (8.690, 14.931, 22.453)),
    (290045, (8.027, 17.578, 27.977)),
    (511999, (3.515, 12.324, 24.135)),
    (185825, (4.867, 16.712, 27.125)),
    (9727, (5.342, 12.226, 25.894)),
    (590142, (7.850, 14.586, 29.437)),
    (605398, (5.618, 10.119, 27.180)),
    (527655, (6.864, 19.860, 21.208)),
    (582527, (1.687, 16.807, 21.121)),
    (314392, (1.936, 19.589, 28.074)),
    (426985, (8.700, 11.644, 29.501)),
    (981769, (1.837, 16.578, 29.798)),
    (248200, (5.624, 16.150, 20.728)),
    (59901, (6.819, 11.684, 27.526)),
    (900567, (8.109, 18.622, 25.299)),
    (18840, (3.720, 17.707, 28.147)),
    (828526, (8.618, 11.520, 26.234)),
    (123666, (0.678, 19.698, 22.590)),
    (117113, (9.667, 14.591, 26.256)),
    (26237, (3.877, 17.220, 25.332)),
    (785488, (4.338, 14.328, 29.633)),
    (383554, (7.287, 15.394, 27.045)),
    (813613, (6.440, 17.977, 28.002)),
    (142033, (2.428, 17.296, 21.514)),
    (917835, (3.356, 11.123, 23.381)),
    (103371, (3.644, 11.929, 29.732)),
    (968204, (2.796, 18.190, 28.704)),
    (591587, (2.117, 14.972, 23.658)),
    (677636, (9.357, 12.418, 25.031)),
    (344628, (8.380, 11.590, 26.126)),
    (635072, (3.399, 19.365, 26.238)),
    (724144, (4.378, 13.183, 28.436)),
    (517183, (8.028, 10.480, 27.274)),
    (378837, (9.388, 15.010, 29.498)),
    (596602, (6.131, 12.428, 25.016)),
    (775466, (5.528, 10.582, 25.103)),
    (663459, (5.754, 13.418, 26.364)),
    (131110, (9.973, 14.965, 27.413)),
    (801967, (9.615, 12.156, 20.153)),
    (340453, (3.479, 11.657, 23.232)),
    (207879, (2.996, 18.397, 24.646)),
    (954117, (4.658, 18.460, 25.622)),
    (947966, (9.388, 11.906, 26.562)),
    (875546, (7.647, 10.511, 23.787)),
    (283456, (9.422, 12.554, 28.579)),
    (237056, (5.380, 11.225, 23.904)),
    (671888, (2.612, 12.340, 27.710)),
    (219430, (9.137, 14.406, 25.039)),
    (809983, (6.091, 15.966, 27.396)),
    (361450, (2.701, 12.480, 25.327)),
    (194420, (3.937, 19.809, 24.025)),
    (471060, (4.023, 18.365, 25.915)),
    (114700, (6.440, 17.964, 29.941)),
    (256886, (1.317, 19.938, 25.309)),
    (903825, (1.460, 19.961, 20.208)),
    (124552, (8.506, 19.462, 25.017)),
    (914118, (9.114, 13.329, 21.347)),
    (768533, (9.766, 10.416, 23.674)),
    (716953, (8.001, 10.913, 24.953)),
    (475495, (5.653, 13.149, 25.329)),
    (685774, (8.652, 19.899, 22.734)),
    (298634, (3.011, 17.810, 29.404)),
    (53900, (1.246, 10.080, 25.582)),
    (33787, (7.146, 17.254, 26.893)),
    (198026, (6.231, 12.712, 22.011)),
    (251868, (4.122, 14.076, 25.024)),
    (444153, (0.308, 15.413, 20.587)),
    (175886, (8.560, 18.812, 26.705)),
    (575598, (1.379, 19.066, 21.434)),
    (592062, (9.751, 12.393, 26.296)),
    (428129, (6.226, 13.255, 21.654)),
    (300676, (3.177, 18.429, 24.981)),
    (195055, (6.202, 16.805, 26.946)),
    (677760, (5.019, 18.178, 24.572)),
    (314091, (9.388, 11.934, 21.134)),
    (748506, (4.569, 11.322, 21.267)),
    (867018, (4.771, 14.998, 27.304)),
    (319646, (7.380, 12.653, 23.894)),
    (194668, (9.349, 16.087, 28.159)),
    (244446, (5.307, 13.692, 28.910)),
    (942641, (3.337, 13.651, 23.300)),
    (964376, (9.348, 10.887, 26.000)),
    (682914, (8.903, 11.949, 29.249)),
    (441630, (9.507, 15.350, 29.819)),
    (695189, (1.663, 18.916, 28.346)),
    (933382, (2.110, 13.877, 28.162)),
    (236252, (9.057, 19.980, 27.100)),
    (992390, (5.473, 12.980, 28.892)),
    (787791, (4.567, 14.435, 24.017)),
    (26137, (8.423, 14.205, 24.632)),
    (375233, (8.184, 16.031, 23.233)),
    (922823, (1.280, 13.717, 22.966)),
    (831656, (1.086, 18.225, 20.561)),
    (651614, (2.196, 19.590, 27.782)),
    (710085, (2.469, 17.345, 25.057)),
    (9317, (6.748, 11.794, 24.098)),
    (838817, (4.770, 12.534, 24.252)),
    (654050, (0.716, 10.043, 25.920)),
    (745797, (2.617, 19.249, 23.075)),
    (971740, (0.168, 15.390, 28.745)),
    (474945, (5.108, 15.847, 23.941)),
    (296555, (0.502, 16.625, 24.972)),
    (592831, (6.543, 10.637, 22.625)),
    (131430, (9.727, 11.511, 23.502)),
    (673733, (1.380, 13.468, 28.646)),
    (822144, (7.211, 18.971, 29.970)),
    (704725, (8.684, 17.668, 23.654)),
    (894363, (1.597, 13.376, 20.195)),
    (636569, (3.899, 19.074, 23.616)),
    (133462, (9.319, 18.160, 22.093)),
    (122372, (2.072, 18.484, 23.427)),
    (741096, (6.575, 18.964, 23.613)),
    (731864, (7.818, 17.074, 23.139)),
    (107268, (2.325, 16.795, 27.295)),
    (747670, (1.037, 16.510, 24.735)),
    (214918, (5.164, 19.005, 28.752)),
    (199155, (4.967, 15.438, 29.580)),
    (494216, (9.199, 17.548, 22.819)),
    (616323, (9.382, 19.128, 27.638)),
    (466631, (0.237, 10.623, 24.734)),
    (421572, (8.369, 13.166, 25.290)),
    (92659, (9.654, 16.611, 23.451)),
    (31466, (3.660, 16.773, 24.640)),
    (461734, (9.300, 13.948, 26.823)),
    (766646, (8.371, 19.268, 27.848)),
    (196115, (5.447, 13.434, 25.928)),
    (212478, (5.286, 17.757, 21.921)),
    (861384, (2.298, 14.318, 25.625)),
    (469808, (8.154, 18.022, 27.558)),
    (380257, (0.906, 10.908, 24.480)),
    (498521, (0.978, 15.799, 27.202)),
    (614599, (4.863, 10.526, 20.205)),
    (387000, (5.808, 16.264, 20.184)),
    (933212, (2.284, 10.510, 23.983)),
    (822436, (7.031, 17.748, 29.046)),
    (880204, (7.287, 13.112, 27.001)),
    (56121, (1.668, 10.683, 29.349)),
    (89142, (2.056, 13.813, 28.257)),
    (546134, (0.491, 17.262, 28.839)),
    (972205, (0.390, 16.092, 22.788)),
    (686383, (8.102, 10.758, 24.808)),
    (526119, (4.107, 17.919, 22.991)),
    (633347, (2.060, 18.303, 26.026)),
    (467642, (1.639, 12.856, 22.507)),
    (395971, (5.458, 12.841, 26.867)),
    (388180, (2.165, 11.050, 25.582)),
    (489275, (9.618, 11.834, 27.073)),
    (64719, (1.848, 10.687, 20.429)),
    (668105, (4.961, 17.089, 21.500)),
    (77823, (5.782, 12.995, 22.072)),
    (994823, (9.928, 18.671, 28.223)),
    (711216, (0.490, 19.061, 24.249)),
    (329055, (9.654, 13.339, 27.006)),
    (13313, (8.586, 11.384, 23.323)),
    (871252, (5.422, 10.157, 22.981)),
    (851913, (6.221, 14.928, 29.583)),
    (425929, (4.278, 13.135, 22.178)),
    (285523, (6.440, 10.235, 25.106)),
    (506960, (9.947, 15.759, 24.723)),
    (791721, (2.345, 10.719, 26.820)),
    (732422, (1.478, 12.542, 25.919)),
    (969255, (1.683, 10.741, 21.860)),
    (646237, (1.299, 14.395, 29.659)),
    (399902, (0.890, 17.960, 21.187)),
    (698263, (5.905, 16.813, 26.157)),
    (347149, (6.903, 12.386, 21.648)),
    (899165, (1.455, 12.860, 23.693)),
    (981080, (6.040, 18.424, 26.506)),
    (239148, (7.301, 13.557, 28.743)),
    (594549, (9.534, 18.952, 21.056)),
    (463176, (6.683, 12.645, 21.051)),
    (825680, (4.939, 16.619, 23.645)),
    (707986, (4.991, 19.003, 27.619)),
    (947141, (0.583, 12.850, 20.432)),
    (787085, (2.540, 16.559, 25.223)),
    (179199, (2.281, 13.568, 27.726)),
    (639723, (0.320, 12.995, 27.163)),
    (324661, (9.875, 17.307, 29.795)),
    (275311, (0.412, 19.812, 28.020)),
    (648693, (9.193, 16.806, 22.468)),
    (635, (9.239, 14.891, 22.392)),
    (81016, (9.638, 18.272, 26.358)),
    (266644, (5.703, 18.159, 23.621)),
    (422780, (6.781, 16.766, 20.651)),
    (588844, (4.523, 18.060, 26.946)),
    (638268, (5.525, 15.224, 24.640)),
    (203453, (6.829, 16.212, 26.670)),
    (718410, (4.850, 14.603, 21.270)),
    (238759, (0.979, 15.639, 28.422)),
    (879854, (1.324, 13.760, 22.193)),
    (98518, (7.783, 11.111, 28.869)),
    (416839, (5.286, 19.165, 29.459)),
    (98073, (7.929, 16.516, 21.299)),
    (770874, (7.715, 18.658, 21.626)),
    (749739, (8.566, 16.863, 27.843)),
    (918058, (6.712, 17.578, 21.225)),
    (420776, (3.374, 15.810, 29.350)),
    (103799, (8.930, 15.250, 23.343)),
    (603917, (9.894, 10.751, 21.327)),
    (332941, (6.718, 18.054, 25.392)),
    (494211, (9.016, 17.021, 29.257)),
    (33085, (1.329, 18.442, 21.490)),
    (446507, (8.611, 12.345, 21.994)),
    (996005, (3.876, 10.572, 27.703)),
    (775885, (4.150, 16.627, 25.358)),
    (461717, (7.780, 19.866, 28.741)),
    (228599, (4.129, 17.359, 27.755)),
    (36473, (9.503, 17.889, 20.456)),
    (855359, (3.712, 14.901, 23.653)),
    (733908, (9.206, 14.875, 22.236)),
    (788303, (4.209, 17.039, 22.320)),
    (514460, (2.512, 12.704, 20.972)),
    (941452, (4.732, 11.819, 21.799)),
    (99054, (6.899, 12.580, 21.109)),
    (108930, (8.926, 12.707, 23.957)),
    (847666, (8.823, 17.762, 24.325)),
    (43509, (8.024, 15.054, 22.280)),
    (78400, (3.628, 10.795, 27.480)),
    (189546, (2.959, 10.948, 27.322)),
    (389050, (4.534, 15.439, 29.178)),
    (164312, (2.461, 18.070, 28.049)),
    (27789, (4.189, 17.422, 29.530)),
    (595887, (2.869, 17.886, 25.987)),
    (572057, (5.116, 11.034, 29.185)),
    (293886, (2.932, 12.499, 26.359)),
    (985242, (3.453, 16.767, 21.726)),
    (35729, (8.435, 10.138, 29.573)),
    (497824, (7.157, 14.478, 23.733)),
    (982357, (7.567, 12.301, 22.126)),
    (189737, (5.223, 18.287, 24.003)),
    (129498, (4.932, 14.671, 22.272)),
    (169160, (6.423, 18.859, 27.609)),
    (80726, (6.777, 12.180, 23.921)),
    (799753, (9.378, 16.684, 29.813)),
    (200655, (2.909, 14.907, 29.716)),
    (528243, (7.062, 11.211, 29.276)),
    (122531, (5.968, 19.359, 29.849)),
    (192895, (9.750, 15.744, 26.034)),
    (113933, (4.893, 10.189, 26.035)),
    (751913, (2.726, 14.418, 28.346)),
    (85251, (7.033, 13.534, 28.444)),
    (868406, (1.148, 14.422, 29.107)),
    (573619, (0.441, 15.642, 25.554)),
    (75743, (3.741, 10.107, 24.492)),
    (25948, (0.899, 19.268, 23.544)),
    (631468, (8.055, 10.228, 28.350)),
    (579284, (6.890, 16.965, 26.276)),
    (591733, (2.738, 16.835, 28.135)),
    (113283, (2.306, 14.551, 21.871)),
    (414526, (4.044, 14.372, 22.815)),
    (7096, (6.830, 17.969, 26.870)),
    (906455, (2.853, 10.149, 28.846)),
    (600779, (7.283, 13.584, 23.920)),
    (783072, (1.604, 15.461, 20.912)),
    (408584, (1.268, 18.998, 23.164)),
    (164227, (9.884, 17.123, 25.336)),
    (211806, (9.984, 17.914, 24.772)),
    (806766, (2.604, 15.958, 28.528)),
    (183181, (0.973, 14.100, 21.671)),
    (887688, (4.286, 14.364, 20.430)),
    (194002, (1.385, 15.387, 22.215)),
    (802665, (6.422, 14.964, 21.323)),
    (749090, (7.483, 12.185, 20.738)),
    (988875, (1.603, 13.361, 24.127)),
    (811130, (8.225, 11.536, 22.848)),
    (628439, (4.350, 14.149, 28.656)),
    (732928, (3.339, 11.183, 24.053)),
    (416968, (5.979, 13.768, 24.363)),
    (595339, (8.007, 14.898, 22.353)),
    (892202, (3.948, 19.216, 22.867)),
    (662581, (6.882, 11.648, 26.298)),
    (141277, (8.837, 19.291, 25.098)),
    (578029, (8.550, 13.586, 28.108)),
    (54073, (4.194, 10.456, 20.678)),
    (967902, (0.615, 14.475, 26.066)),
    (836303, (3.288, 14.116, 20.870)),
    (815210, (6.773, 11.501, 21.727)),
    (333234, (5.563, 13.891, 20.205)),
    (18251, (5.024, 12.967, 21.702)),
    (896261, (7.101, 12.155, 28.642)),
    (736909, (3.987, 17.335, 26.128)),
    (395879, (4.391, 11.200, 24.432)),
    (657441, (4.284, 15.850, 26.911)),
    (884891, (5.837, 13.925, 29.297)),
    (666663, (6.072, 11.549, 21.521)),
    (393311, (6.011, 18.588, 24.344)),
    (835736, (0.980, 15.088, 28.026)),
    (180107, (2.471, 17.717, 24.349)),
    (489793, (9.608, 14.039, 23.508)),
    (868101, (5.054, 19.676, 20.036)),
    (110190, (4.471, 16.374, 24.901)),
    (276783, (8.957, 11.454, 25.504)),
    (685647, (8.977, 13.998, 26.388)),
    (569847, (8.407, 15.759, 21.043)),
    (661930, (7.155, 19.101, 20.875)),
    (836276, (9.815, 18.583, 24.025)),
    (889214, (6.527, 10.641, 23.600)),
    (439454, (3.518, 16.249, 29.462)),
    (176266, (1.799, 10.406, 21.442)),
    (847583, (2.859, 14.774, 23.467)),
    (505200, (8.684, 13.388, 25.837)),
    (24202, (2.660, 19.216, 22.251)),
    (219395, (2.014, 10.854, 28.964)),
    (185607, (8.540, 12.572, 22.783)),
    (601372, (3.875, 17.597, 26.734)),
    (921106, (8.424, 19.049, 27.213)),
    (452985, (2.291, 13.755, 27.245)),
    (973954, (5.913, 16.997, 28.187)),
    (451243, (1.261, 12.502, 25.014)),
    (787530, (7.071, 16.410, 20.366)),
    (682645, (6.293, 12.834, 28.699)),
    (977721, (4.838, 15.349, 26.003)),
    (917373, (4.776, 18.381, 24.742)),
    (847277, (7.244, 17.282, 29.713)),
    (975146, (2.649, 18.993, 29.688)),
    (665391, (0.975, 13.104, 26.736)),
    (192769, (6.475, 18.909, 29.273)),
    (662543, (9.756, 17.373, 26.267)),
    (960439, (1.091, 14.061, 25.660)),
    (323294, (3.367, 19.081, 24.076)),
    (24391, (0.722, 12.476, 20.577)),
    (878480, (5.787, 16.508, 22.138)),
    (90581, (7.488, 10.431, 25.975)),
    (45416, (9.140, 17.664, 22.587)),
    (586353, (6.420, 19.793, 23.609)),
    (90704, (5.451, 11.516, 20.277)),
    (891269, (9.906, 18.226, 24.257)),
    (586453, (8.821, 15.956, 23.344)),
    (201207, (7.068, 10.142, 28.838)),
    (499083, (4.041, 15.630, 24.710)),
    (484245, (3.538, 10.479, 21.047)),
    (839801, (3.442, 10.649, 27.982)),
    (966596, (7.974, 13.874, 28.407)),
    (797659, (3.018, 13.454, 24.276)),
    (699064, (4.830, 16.897, 21.037)),
    (595279, (8.056, 17.321, 28.610)),
    (630221, (3.855, 17.506, 29.916)),
    (791303, (6.870, 19.010, 21.710)),
    (518654, (6.440, 16.541, 23.744)),
    (558946, (6.016, 13.043, 23.601)),
    (151976, (8.584, 10.738, 25.063)),
    (994886, (2.042, 18.383, 23.322)),
    (692953, (1.531, 14.146, 26.141)),
    (761208, (0.784, 16.317, 21.096)),
    (264978, (3.536, 17.041, 25.210)),
    (196959, (1.871, 15.153, 26.909)),
    (985664, (2.747, 18.461, 26.254)),
    (245628, (3.769, 12.092, 26.967)),
    (189752, (3.080, 14.885, 20.319)),
    (55256, (0.100, 17.074, 22.243)),
    (553262, (5.530, 10.390, 24.956)),
    (638907, (8.522, 12.022, 25.510)),
    (343784, (6.090, 13.087, 23.475)),
    (566007, (4.526, 15.329, 24.419)),
    (127804, (0.732, 15.348, 24.251)),
    (953662, (2.844, 15.025, 23.939)),
    (320067, (2.911, 19.290, 20.008)),
    (476284, (1.523, 16.805, 25.117)),
    (751297, (5.323, 12.353, 22.154)),
    (717529, (3.444, 15.559, 29.602)),
    (127682, (8.228, 10.050, 27.572)),
    (980049, (9.375, 10.962, 29.152)),
    (421465, (9.238, 10.711, 20.568)),
    (935372, (4.710, 18.379, 21.166)),
    (832272, (1.672, 19.336, 24.481)),
    (192813, (0.292, 15.664, 20.541)),
    (158861, (9.433, 19.229, 26.005)),
    (422574, (5.730, 14.193, 23.676)),
    (45509, (2.645, 16.393, 27.884)),
    (365685, (4.770, 15.469, 22.044)),
    (433797, (0.278, 11.649, 22.409)),
    (982894, (2.148, 17.619, 22.149)),
    (983812, (2.119, 10.009, 28.354)),
    (870057, (6.985, 17.957, 27.282)),
    (882130, (7.885, 17.210, 20.265)),
    (522628, (6.690, 16.268, 28.731)),
    (450359, (3.666, 13.539, 28.894)),
    (897690, (3.631, 11.383, 21.668)),
    (520164, (3.622, 13.196, 22.984)),
    (498502, (8.826, 19.545, 23.741)),
    (731094, (6.760, 12.731, 29.842)),
    (347821, (7.147, 14.753, 26.443)),
    (941591, (6.382, 19.635, 24.108)),
    (97836, (8.474, 18.838, 21.293)),
    (337290, (0.382, 16.218, 23.835)),
    (956043, (8.074, 14.902, 27.655)),
    (68371, (3.071, 10.292, 22.508)),
    (543165, (4.858, 11.411, 28.457)),
    (692912, (1.777, 11.843, 25.047)),
    (929116, (4.740, 15.561, 22.713)),
    (923086, (0.821, 12.792, 24.887)),
    (535151, (6.927, 18.751, 20.291)),
    (272370, (8.891, 19.782, 23.751)),
    (765687, (8.369, 15.780, 20.393)),
    (564999, (2.702, 10.014, 23.950)),
    (840400, (9.856, 19.929, 26.186)),
    (872546, (9.987, 16.357, 27.173)),
    (536860, (2.862, 12.390, 23.445)),
    (81280, (4.381, 15.532, 28.722)),
    (929347, (6.137, 12.412, 27.256)),
    (659229, (2.463, 13.439, 29.601)),
    (476711, (5.627, 13.946, 28.591)),
    (558017, (7.885, 19.342, 21.941)),
    (168976, (9.304, 11.938, 26.642)),
    (361845, (5.781, 11.757, 22.634)),
    (9646, (7.586, 12.266, 28.442)),
    (328198, (4.461, 19.104, 29.663)),
    (823877, (8.999, 15.492, 28.764)),
    (893612, (6.839, 14.834, 25.973)),
    (789462, (6.137, 13.848, 27.014)),
    (601572, (8.834, 17.353, 25.693)),
    (924467, (0.501, 17.560, 24.151)),
    (884030, (9.325, 11.083, 24.533)),
    (107461, (0.200, 15.033, 21.679)),
    (981121, (0.063, 19.796, 22.211)),
    (646531, (4.388, 16.262, 28.123)),
    (872400, (8.882, 12.332, 20.778)),
    (640127, (8.971, 17.230, 29.430)),
    (341609, (5.065, 13.404, 23.927)),
    (516639, (9.326, 17.735, 23.434)),
    (709090, (6.753, 18.213, 25.466)),
    (730938, (3.136, 11.253, 27.076)),
    (162222, (5.654, 16.183, 22.031)),
    (804044, (0.860, 11.392, 28.773)),
    (580042, (4.848, 15.916, 26.209)),
    (779947, (9.682, 12.095, 28.294)),
    (529982, (5.138, 13.094, 26.407)),
    (471186, (9.055, 14.592, 27.259)),
    (167613, (5.452, 13.508, 26.731)),
    (549543, (2.242, 11.847, 22.475)),
    (479224, (2.708, 14.898, 24.250)),
    (444594, (2.238, 18.336, 27.880)),
    (434505, (4.644, 12.417, 24.649)),
    (809031, (5.514, 13.890, 22.342)),
    (366990, (1.186, 15.376, 25.209)),
    (785210, (5.710, 15.381, 29.412)),
    (529496, (6.566, 14.370, 26.525)),
    (444171, (1.190, 11.651, 23.586)),
    (195556, (3.873, 11.107, 20.823)),
    (260408, (0.669, 15.341, 20.600)),
    (231377, (5.086, 15.405, 25.476)),
    (216757, (3.607, 18.641, 21.696)),
    (880027, (5.857, 16.279, 26.174)),
    (457159, (8.095, 19.488, 21.186)),
    (566723, (6.634, 17.629, 21.581)),
    (16207, (3.345, 12.772, 29.409)),
    (556279, (4.215, 13.780, 27.267)),
    (927862, (4.237, 13.741, 22.172)),
    (452331, (8.274, 19.567, 26.236)),
    (314998, (1.880, 13.360, 24.913)),
    (61170, (0.816, 13.903, 26.304)),
    (462839, (4.229, 16.681, 28.691)),
    (908914, (1.304, 10.030, 27.141)),
    (549505, (9.310, 19.452, 25.788)),
    (840389, (4.657, 18.502, 29.958)),
    (342526, (0.445, 14.744, 28.687)),
    (262484, (0.092, 16.098, 27.601)),
    (665798, (6.261, 19.291, 27.505)),
    (888630, (7.706, 17.333, 25.023)),
    (25243, (6.143, 16.342, 29.525)),
    (333495, (7.669, 12.798, 29.788)),
    (464951, (6.912, 14.986, 25.365)),
    (26914, (1.664, 15.418, 21.303)),
    (846699, (7.674, 17.085, 23.128)),
    (264053, (1.910, 11.316, 29.934)),
    (436184, (4.143, 17.122, 24.132)),
    (14685, (4.695, 14.898, 26.548)),
    (565808, (1.113, 15.153, 26.171)),
    (835745, (3.027, 18.940, 25.016)),
    (76906, (9.026, 19.602, 24.837)),
    (31607, (1.108, 11.670, 28.252)),
    (632706, (3.058, 19.932, 27.447)),
    (681412, (8.004, 15.557, 22.762)),
    (633170, (9.131, 13.732, 25.589)),
    (425332, (8.715, 19.423, 21.231)),
    (723594, (8.437, 12.757, 25.463)),
    (262151, (9.713, 17.643, 26.273)),
    (673948, (4.878, 17.459, 22.947)),
    (764556, (6.269, 17.138, 28.372)),
    (904623, (5.362, 10.147, 20.294)),
    (29756, (2.616, 10.652, 22.502)),
    (662638, (5.195, 14.629, 26.089)),
    (154777, (5.182, 18.784, 28.064)),
    (898207, (0.580, 13.960, 21.842)),
    (159463, (8.803, 15.213, 26.528)),
    (117839, (5.679, 15.852, 29.134)),
    (558779, (6.341, 19.883, 23.260)),
    (517518, (0.800, 11.748, 22.041)),
    (944624, (6.551, 14.425, 28.050)),
    (891201, (8.863, 15.287, 22.285)),
    (779874, (4.000, 17.604, 23.549)),
    (893559, (7.278, 15.652, 20.743)),
    (78413, (2.034, 19.974, 27.652)),
    (900323, (4.763, 18.210, 24.496)),
    (523770, (6.106, 13.395, 28.882)),
    (321324, (3.878, 18.139, 21.125)),
    (324617, (7.548, 16.058, 28.313)),
    (916779, (8.146, 19.497, 29.153)),
    (468042, (2.443, 14.786, 23.040)),
    (80389, (7.093, 12.912, 21.465)),
    (635184, (4.467, 13.539, 21.998)),
    (282327, (4.963, 19.020, 26.158)),
    (871868, (7.751, 19.680, 25.855)),
    (838436, (1.041, 19.817, 24.753)),
    (760422, (5.919, 19.003, 25.737)),
    (359592, (7.213, 18.829, 27.856)),
    (758484, (0.609, 12.563, 20.647)),
    (204, (9.757, 18.843, 22.582)),
    (320765, (8.676, 19.707, 22.336)),
    (372152, (3.293, 14.528, 21.984)),
    (591965, (1.943, 13.430, 27.503)),
    (620607, (0.447, 15.620, 28.262)),
    (184091, (0.873, 14.303, 24.734)),
    (10339, (6.416, 19.985, 22.594)),
    (949369, (6.339, 13.658, 26.088)),
    (188000, (3.362, 18.122, 20.631)),
    (993394, (6.213, 12.207, 23.204)),
    (961112, (6.809, 18.978, 24.170)),
    (454229, (0.282, 13.389, 27.655)),
    (708888, (3.918, 15.867, 28.207)),
    (877155, (9.361, 17.987, 21.732)),
    (670315, (7.696, 15.176, 29.279)),
    (112386, (9.974, 15.175, 26.888)),
    (482907, (3.452, 12.076, 21.282)),
    (519681, (2.896, 15.961, 20.991)),
    (116796, (9.279, 19.860, 23.607)),
    (166146, (8.616, 11.212, 25.692)),
    (686528, (1.759, 14.933, 25.500)),
    (611212, (3.393, 17.015, 24.430)),
    (547686, (2.476, 12.598, 24.745)),
    (581332, (2.299, 11.795, 20.838)),
    (532678, (3.432, 16.833, 21.212)),
    (503894, (9.063, 17.806, 23.350)),
    (361818, (2.629, 13.538, 29.922)),
    (701439, (6.403, 15.946, 21.601)),
    (805109, (3.996, 13.682, 26.683)),
    (542242, (8.001, 10.824, 24.003)),
    (191421, (0.713, 17.520, 28.490)),
    (999205, (3.525, 16.214, 28.003)),
    (47148, (2.901, 15.616, 24.987)),
    (516252, (9.823, 18.824, 29.805)),
    (318197, (9.851, 19.320, 29.051)),
    (619943, (3.875, 10.739, 21.473)),
    (947373, (7.233, 17.748, 25.339)),
    (404320, (9.577, 11.533, 27.511)),
    (723561, (5.604, 13.224, 27.512)),
    (356758, (8.397, 11.708, 27.164)),
    (638003, (1.282, 14.920, 22.293)),
    (720918, (9.057, 19.873, 23.552)),
    (226236, (8.252, 15.320, 29.680)),
    (166911, (8.803, 14.468, 26.972)),
    (834329, (5.862, 11.930, 29.228)),
    (554258, (2.983, 13.347, 23.639)),
    (660511, (8.309, 19.823, 24.963)),
    (38604, (9.404, 14.290, 25.320)),
    (222832, (4.399, 10.977, 25.707)),
    (563551, (7.152, 10.912, 23.413)),
    (627253, (4.790, 16.145, 21.870)),
    (687099, (4.354, 16.286, 21.459)),
    (572429, (3.332, 17.054, 29.420)),
    (252300, (4.297, 18.766, 23.286)),
    (7947, (3.248, 18.984, 26.365)),
    (35001, (0.843, 17.103, 23.690)),
    (601077, (7.482, 14.500, 27.871)),
    (784939, (4.771, 19.365, 29.383)),
    (52971, (0.270, 18.026, 24.284)),
    (117907, (9.677, 12.510, 23.378)),
    (989398, (2.395, 17.061, 22.560)),
    (962092, (8.290, 11.321, 28.663)),
    (305377, (1.656, 12.247, 22.504)),
    (4976, (1.973, 11.888, 28.293)),
    (664771, (2.180, 18.465, 24.460)),
    (875634, (4.470, 14.590, 22.426)),
    (700516, (9.808, 14.948, 21.010)),
    (162036, (1.592, 18.945, 28.103)),
    (810384, (0.994, 15.302, 25.795)),
    (136655, (7.433, 17.891, 26.122)),
    (599177, (3.392, 10.761, 25.600)),
    (512345, (4.310, 13.430, 21.258)),
    (105306, (8.729, 11.863, 29.910)),
    (282438, (4.340, 16.803, 28.006)),
    (762306, (6.884, 12.384, 22.117)),
    (324707, (1.589, 17.252, 22.774)),
    (494307, (4.939, 19.807, 27.240)),
    (285774, (2.587, 13.493, 24.895)),
    (48593, (7.774, 13.134, 26.283)),
    (384184, (7.502, 19.816, 25.221)),
    (741232, (1.819, 18.808, 26.927)),
    (113729, (2.963, 14.038, 26.684)),
    (610881, (0.055, 14.072, 20.101)),
    (495235, (1.679, 19.588, 24.137)),
    (942962, (8.424, 12.946, 25.283)),
    (883539, (2.784, 15.949, 24.209)),
    (939173, (3.228, 10.052, 21.587)),
    (880679, (8.873, 10.084, 27.340)),
    (199998, (8.234, 10.765, 24.384)),
    (154093, (1.173, 19.240, 25.548)),
    (429960, (4.222, 11.166, 27.749)),
    (974547, (3.240, 11.667, 24.234)),
    (238295, (4.165, 17.334, 24.512)),
    (167661, (7.431, 11.926, 24.455)),
    (178020, (1.820, 11.789, 24.934)),
    (639528, (1.867, 16.318, 23.392)),
    (349944, (8.461, 14.186, 28.090)),
    (389944, (7.379, 16.620, 21.754)),
    (411669, (6.699, 19.235, 29.592)),
    (186798, (9.063, 11.819, 20.398)),
    (553467, (3.163, 17.257, 26.534)),
    (814549, (5.753, 12.999, 24.718)),
    (901693, (8.230, 19.834, 24.497)),
    (887786, (5.207, 17.733, 26.211)),
    (742001, (8.487, 18.863, 28.820)),
    (91393, (0.333, 18.872, 29.530)),
    (357314, (0.428, 12.790, 29.172)),
    (198014, (9.062, 15.676, 23.910)),
    (793802, (7.353, 18.036, 28.685)),
    (435005, (9.688, 16.763, 28.394)),
    (129003, (2.456, 19.645, 29.115)),
    (473148, (2.760, 13.878, 26.200)),
    (281385, (2.479, 14.010, 26.967)),
    (584779, (0.777, 14.721, 21.608)),
    (605854, (8.649, 10.345, 21.399)),
    (688315, (0.903, 15.206, 27.446)),
    (333365, (0.284, 11.144, 20.218)),
    (703454, (1.691, 19.531, 28.374)),
    (189515, (4.650, 11.766, 25.338)),
    (351576, (6.122, 17.378, 23.982)),
    (562586, (9.182, 15.215, 25.202)),
    (210988, (7.158, 14.783, 21.636)),
    (855885, (2.038, 13.205, 23.752)),
    (622923, (2.007, 19.576, 28.332)),
    (755179, (0.559, 18.054, 29.630)),
    (751875, (0.962, 12.781, 24.964)),
    (907662, (8.748, 13.512, 21.186)),
    (99893, (8.941, 17.513, 28.666)),
    (917783, (7.877, 16.752, 23.637)),
    (253427, (6.519, 11.895, 23.606)),
    (97967, (3.819, 10.960, 27.388)),
    (253699, (3.490, 10.022, 28.633)),
    (614802, (6.117, 19.337, 29.005)),
    (832025, (7.938, 10.022, 25.129)),
    (331530, (5.075, 18.831, 21.554)),
    (464229, (5.181, 11.075, 23.122)),
    (214315, (0.586, 12.266, 25.619)),
    (546981, (2.485, 10.800, 21.917)),
    (995210, (5.433, 16.003, 27.658)),
    (971239, (1.386, 10.257, 21.874)),
    (989411, (7.926, 15.323, 28.164)),
    (468985, (7.160, 14.435, 23.570)),
    (285882, (5.348, 12.624, 23.166)),
    (896057, (7.674, 13.379, 26.360)),
    (797505, (4.955, 17.806, 23.468)),
    (216896, (7.781, 11.282, 28.440)),
    (203024, (4.111, 13.355, 21.627)),
    (896335, (4.051, 15.107, 20.182)),
    (284656, (4.707, 14.793, 25.109)),
    (213454, (7.585, 18.551, 24.307)),
    (552216, (0.540, 12.898, 23.475)),
    (975920, (3.625, 19.221, 21.006)),
    (282400, (3.968, 11.126, 23.179)),
    (714559, (3.592, 10.940, 20.539)),
    (595959, (7.467, 10.161, 24.692)),
    (750856, (1.495, 13.148, 28.139)),
    (446464, (8.565, 18.038, 28.490)),
    (77597, (6.386, 10.515, 21.528)),
    (412944, (8.163, 14.364, 26.521)),
    (85126, (1.803, 14.211, 25.304)),
    (488968, (2.839, 17.970, 26.237)),
    (596362, (4.128, 10.852, 27.923)),
    (795170, (8.106, 13.895, 20.907)),
    (686253, (2.361, 13.316, 23.398)),
    (297591, (5.931, 16.808, 26.365)),
    (958841, (1.759, 17.439, 21.106)),
    (343503, (4.935, 16.414, 27.117)),
    (394844, (7.036, 19.672, 27.637)),
    (138998, (4.001, 15.360, 21.310)),
    (311609, (9.696, 11.877, 28.335)),
    (832043, (7.016, 17.948, 23.229)),
    (965305, (4.265, 13.931, 25.316)),
    (91640, (7.470, 10.335, 24.289)),
    (115496, (9.383, 15.377, 29.346)),
    (973039, (2.783, 17.884, 26.162)),
    (141307, (7.002, 11.598, 28.124)),
    (753905, (2.131, 18.467, 23.248)),
    (34152, (0.401, 16.035, 25.374)),
    (155073, (4.663, 17.686, 20.670)),
    (272291, (7.188, 12.179, 20.990)),
    (347478, (9.316, 12.070, 20.628)),
    (177344, (8.084, 10.580, 29.495)),
    (50423, (7.960, 15.100, 28.791)),
    (481116, (0.382, 14.749, 21.876)),
    (50537, (2.847, 16.279, 27.395)),
    (697113, (3.507, 15.258, 22.132)),
    (547360, (5.059, 19.168, 20.337)),
    (545689, (2.593, 17.639, 26.921)),
    (817112, (0.702, 15.496, 29.824)),
    (808117, (6.727, 13.763, 22.935)),
    (318129, (1.108, 16.386, 20.096)),
    (636266, (3.684, 15.297, 21.194)),
    (625347, (1.090, 11.140, 26.600)),
    (176796, (2.967, 10.153, 26.422)),
    (680616, (8.244, 10.530, 29.486)),
    (62662, (3.580, 18.824, 24.192)),
    (531541, (0.822, 15.633, 22.876)),
    (829599, (2.855, 10.666, 28.993)),
    (110161, (1.019, 17.975, 26.125)),
    (856927, (6.947, 10.459, 21.623)),
    (762195, (7.724, 11.504, 29.465)),
    (986162, (3.998, 19.184, 29.922)),
    (36376, (3.224, 18.535, 28.443)),
    (832460, (2.497, 16.616, 26.934)),
    (643174, (4.823, 14.280, 25.060)),
    (747539, (8.445, 15.627, 26.512)),
    (145087, (9.317, 15.580, 28.318)),
    (752763, (4.767, 12.263, 25.595)),
    (498470, (9.977, 17.475, 20.198)),
    (172287, (2.761, 16.004, 22.890)),
    (588994, (7.311, 14.299, 29.669)),
    (546929, (3.652, 13.886, 26.321)),
    (755769, (1.525, 18.907, 26.712)),
    (614116, (3.361, 17.818, 28.803)),
    (451665, (8.988, 18.793, 20.734)),
    (704529, (0.191, 14.858, 29.321)),
    (756454, (1.236, 17.893, 25.407)),
    (236865, (6.214, 15.962, 21.841)),
    (785523, (2.998, 15.346, 27.884)),
    (574748, (8.966, 10.441, 27.026)),
    (523414, (4.658, 19.810, 22.149)),
    (719125, (1.011, 14.039, 20.522)),
    (198354, (4.602, 14.747, 27.407)),
    (768991, (4.764, 11.207, 25.358)),
    (110141, (0.754, 11.824, 29.172)),
    (457383, (5.640, 16.766, 27.349)),
    (234297, (1.815, 11.969, 21.387)),
    (539666, (4.768, 18.549, 28.938)),
    (543759, (4.727, 12.389, 20.834)),
    (702274, (6.582, 19.996, 23.936)),
    (759022, (3.858, 16.364, 20.036)),
    (629110, (7.467, 13.992, 22.407)),
    (413731, (7.853, 11.172, 28.066)),
    (920215, (8.334, 17.207, 21.020)),
    (687973, (2.843, 17.852, 27.704)),
    (538971, (5.410, 14.223, 27.647)),
    (225467, (6.099, 17.713, 23.801)),
    (328927, (4.566, 13.528, 29.975)),
    (393249, (1.951, 13.603, 27.255)),
    (521020, (0.064, 16.373, 29.372)),
    (801430, (0.176, 11.195, 20.060)),
    (363010, (1.829, 10.967, 22.235)),
    (882603, (8.192, 14.897, 28.934)),
    (419138, (8.330, 12.780, 28.161)),
    (32566, (7.092, 19.323, 29.687)),
    (272256, (4.277, 12.920, 22.900)),
    (888056, (5.101, 13.726, 20.040)),
    (117607, (0.959, 13.928, 29.869)),
    (68055, (1.712, 12.093, 25.889)),
    (763815, (2.293, 15.290, 22.682)),
    (331040, (9.597, 13.992, 23.191)),
    (591364, (7.270, 17.610, 29.497)),
    (530524, (1.022, 16.933, 25.548)),
    (579459, (1.876, 16.573, 23.008)),
    (33833, (2.161, 15.633, 21.450)),
    (980532, (4.791, 18.490, 28.883)),
    (18320, (5.350, 16.159, 21.892)),
    (636615, (2.816, 16.664, 29.117)),
    (184260, (7.430, 14.980, 29.865)),
    (391831, (4.929, 11.410, 28.428)),
    (525308, (1.330, 19.941, 22.904)),
    (102303, (7.828, 10.066, 24.184)),
    (799195, (1.142, 19.979, 25.101)),
    (450915, (7.326, 12.765, 27.388)),
    (662008, (6.922, 13.686, 21.522)),
    (136838, (5.627, 13.792, 24.903)),
    (296299, (2.568, 11.962, 25.463)),
    (594758, (0.518, 10.738, 22.175)),
    (452883, (7.360, 11.220, 22.580)),
    (437737, (9.418, 14.698, 24.576)),
    (321006, (8.387, 17.544, 29.450)),
    (444106, (3.397, 19.814, 27.930)),
    (646204, (0.278, 10.218, 26.365)),
    (283140, (0.775, 15.690, 27.458)),
    (26791, (3.603, 19.394, 24.192)),
    (503667, (8.850, 12.693, 23.750)),
    (255794, (4.032, 10.483, 25.534)),
    (633759, (2.032, 18.893, 27.051)),
    (748603, (8.089, 14.284, 24.509)),
    (356231, (1.668, 14.776, 20.391)),
    (439669, (0.125, 17.499, 25.132)),
    (196503, (9.763, 10.528, 20.478)),
    (442391, (3.873, 18.478, 25.476)),
    (293189, (4.241, 19.754, 23.346)),
    (634772, (7.283, 18.856, 29.318)),
    (845474, (0.095, 13.657, 29.275)),
    (126503, (6.022, 10.081, 24.183)),
    (557524, (2.535, 10.618, 22.653)),
    (476584, (4.459, 15.534, 21.006)),
    (399911, (3.894, 13.357, 24.575)),
    (88322, (6.605, 16.302, 27.082)),
    (324137, (3.564, 16.333, 23.880)),
    (593609, (5.843, 18.239, 21.519)),
    (231926, (3.173, 13.939, 24.580)),
    (14879, (0.069, 11.017, 21.798)),
    (632943, (1.636, 16.878, 26.320)),
    (592437, (2.042, 11.758, 23.592)),
    (366353, (5.712, 16.028, 20.338)),
    (243161, (8.319, 16.806, 26.274)),
    (113807, (1.984, 16.416, 21.404)),
    (606490, (4.373, 18.437, 25.795)),
    (856566, (8.278, 17.561, 21.589)),
    (334591, (6.293, 17.383, 21.382)),
    (974865, (3.674, 11.901, 25.831)),
    (50223, (6.226, 13.417, 28.895)),
    (19635, (7.723, 15.281, 22.405)),
    (615132, (8.177, 13.189, 28.786)),
    (8140, (5.776, 18.415, 22.251)),
    (334352, (4.102, 11.604, 25.148)),
    (107642, (1.039, 13.236, 24.318)),
    (34222, (3.768, 12.449, 22.782)),
    (957221, (7.807, 16.012, 28.670)),
    (115966, (0.831, 16.249, 27.635)),
    (461890, (9.068, 18.709, 28.118)),
    (876653, (5.863, 13.889, 25.257)),
    (768543, (8.895, 14.935, 23.225)),
    (977191, (5.849, 14.678, 26.326)),
    (759083, (9.814, 18.422, 26.886)),
    (206799, (7.524, 13.796, 24.257)),
    (376783, (1.644, 18.875, 26.485)),
    (556096, (7.645, 14.570, 24.826)),
    (485642, (9.860, 14.357, 22.042)),
    (898557, (0.350, 13.980, 27.800)),
    (611717, (2.346, 14.079, 22.976)),
    (573803, (3.105, 15.945, 20.717)),
    (829917, (8.506, 14.456, 26.440)),
    (899568, (7.084, 14.929, 20.392)),
    (811838, (1.764, 10.421, 23.847)),
    (302221, (4.371, 14.080, 28.789)),
    (461537, (6.719, 12.051, 27.901)),
    (594809, (0.385, 17.855, 24.856)),
    (353106, (8.785, 13.130, 28.939)),
    (389854, (4.692, 11.447, 29.681)),
    (613338, (0.890, 14.306, 29.493)),
    (688235, (8.992, 11.275, 23.861)),
    (530525, (3.137, 15.098, 26.023)),
    (888089, (3.719, 10.179, 26.400)),
    (869662, (2.850, 16.650, 25.612)),
    (14716, (6.267, 19.762, 27.465)),
    (613528, (8.877, 17.726, 26.871)),
    (207701, (5.170, 12.989, 29.799)),
    (327231, (1.479, 17.019, 22.502)),
    (973914, (0.875, 16.228, 25.325)),
    (995124, (5.813, 13.416, 21.796)),
    (806484, (1.260, 11.246, 25.061)),
    (912711, (8.171, 18.071, 29.847)),
    (419559, (6.436, 15.922, 27.499)),
    (232802, (6.725, 16.354, 23.553)),
    (613018, (7.590, 15.011, 20.108)),
    (494344, (3.927, 12.048, 29.450)),
    (766967, (2.704, 19.131, 20.487)),
    (613164, (1.481, 10.040, 26.261)),
    (486531, (9.800, 15.401, 22.474)),
    (191086, (3.926, 11.753, 23.608)),
    (523850, (4.292, 16.897, 24.172)),
    (69436, (7.554, 12.728, 25.686)),
    (99558, (5.136, 11.225, 27.661)),
    (268879, (1.426, 19.221, 20.944)),
    (945197, (6.138, 12.235, 20.270)),
    (141197, (5.456, 19.440, 23.426)),
    (650412, (8.249, 13.499, 20.013)),
    (930839, (2.300, 12.072, 25.090)),
    (617994, (0.292, 19.928, 26.140)),
    (621582, (9.534, 10.118, 27.321)),
    (148278, (1.044, 10.704, 23.350)),
    (101611, (4.231, 14.833, 22.846)),
    (689214, (5.005, 11.152, 28.820)),
    (277759, (6.030, 19.624, 29.841)),
    (17196, (2.779, 18.898, 20.362)),
    (626581, (6.849, 11.155, 27.080)),
    (91490, (1.627, 13.369, 27.940)),
    (627371, (9.067, 19.997, 24.089)),
    (571287, (1.378, 11.336, 21.489)),
    (835245, (6.068, 17.662, 21.735)),
    (785822, (2.196, 16.023, 25.602)),
    (837878, (4.719, 15.201, 26.926)),
    (931338, (6.653, 12.950, 22.610)),
    (531009, (1.798, 13.386, 25.195)),
    (793343, (3.942, 13.934, 29.802)),
    (593904, (9.695, 10.063, 26.619)),
    (511754, (9.552, 13.044, 21.345)),
    (757521, (8.579, 10.899, 23.025)),
    (634484, (8.532, 18.886, 25.546)),
    (25551, (9.871, 13.190, 21.161)),
    (72891, (9.624, 14.904, 23.708)),
    (853772, (7.836, 15.528, 27.769)),
    (109276, (1.711, 14.834, 20.011)),
    (838339, (2.172, 12.112, 25.365)),
    (867532, (8.718, 10.613, 24.408)),
    (769431, (0.406, 10.107, 23.016)),
    (899605, (2.585, 15.880, 28.022)),
    (916715, (9.755, 13.891, 26.445)),
    (212547, (9.895, 14.204, 27.092)),
    (353147, (4.108, 14.974, 23.795)),
    (332989, (4.819, 10.415, 21.746)),
    (938291, (4.325, 15.355, 23.130)),
    (558934, (8.860, 13.648, 28.125)),
    (485235, (8.153, 17.675, 21.056)),
    (457299, (5.928, 16.811, 28.134)),
    (901482, (4.059, 10.029, 25.358)),
    (683052, (7.685, 11.346, 23.840)),
    (773821, (4.017, 14.466, 29.725)),
    (724345, (0.765, 14.296, 24.297)),
    (173263, (7.289, 15.605, 22.201)),
    (691421, (0.716, 17.381, 28.549)),
    (292096, (9.635, 19.450, 28.018)),
    (167205, (4.399, 10.242, 28.937)),
    (343294, (9.283, 15.606, 21.465)),
    (165401, (0.087, 10.747, 25.135)),
    (285129, (9.149, 11.762, 26.711)),
    (814435, (4.332, 15.211, 25.860)),
    (238492, (5.848, 14.967, 27.564)),
    (943388, (3.483, 10.590, 22.853)),
    (244183, (1.418, 10.441, 28.311)),
    (735943, (2.389, 10.202, 25.505)),
    (213515, (0.097, 11.300, 27.779)),
    (817755, (8.935, 16.837, 28.760)),
    (446761, (0.045, 19.613, 26.245)),
    (830532, (4.214, 16.016, 25.252)),
    (374410, (9.803, 17.486, 29.530)),
    (101416, (4.570, 15.727, 24.187)),
    (596951, (6.298, 13.974, 21.130)),
    (744020, (9.577, 19.947, 29.475)),
    (80598, (1.344, 12.268, 24.182)),
    (24656, (0.632, 18.828, 29.001)),
    (62758, (3.665, 11.594, 21.806)),
    (496569, (5.244, 15.318, 27.978)),
    (896818, (8.023, 15.977, 23.331)),
    (181652, (1.858, 17.234, 26.080)),
    (198264, (7.649, 10.804, 28.166)),
    (314041, (3.886, 14.232, 25.228)),
    (296467, (7.755, 18.479, 26.912)),
    (205956, (9.808, 19.577, 21.629)),
    (650787, (0.071, 16.165, 27.100)),
    (104184, (0.961, 17.932, 20.356)),
    (827010, (7.060, 19.557, 21.368)),
    (162985, (2.613, 17.928, 21.103)),
    (896280, (7.634, 10.378, 23.241)),
    (748996, (5.703, 19.080, 27.579)),
    (773890, (2.240, 16.044, 29.347)),
    (923838, (6.535, 16.971, 28.743)),
    (154979, (6.720, 10.623, 20.411)),
    (728257, (1.289, 12.626, 25.866)),
    (536768, (8.968, 19.286, 29.222)),
    (32504, (0.761, 14.009, 24.113)),
    (829484, (6.537, 11.484, 27.276)),
    (613674, (8.790, 13.943, 24.187)),
    (38909, (9.489, 15.358, 20.401)),
    (751289, (5.223, 19.515, 27.890)),
    (730393, (9.473, 11.219, 28.463)),
    (324026, (4.978, 10.615, 20.551)),
    (326247, (6.780, 10.863, 29.975)),
    (803324, (1.289, 10.506, 25.569)),
    (507298, (9.667, 13.524, 29.679)),
    (866247, (3.702, 11.319, 23.643)),
    (704495, (5.187, 12.574, 26.103)),
    (955556, (2.784, 13.406, 20.432)),
    (652885, (0.097, 19.504, 25.706)),
    (685546, (6.534, 15.261, 26.495)),
    (403174, (2.199, 12.587, 21.481)),
    (838705, (8.869, 12.906, 23.125)),
    (246626, (7.614, 18.685, 24.496)),
    (874326, (2.755, 18.088, 27.271)),
    (29016, (2.866, 12.520, 25.182)),
    (346637, (8.891, 17.627, 22.793)),
    (849166, (8.359, 17.701, 29.275)),
    (146334, (2.402, 14.410, 27.234)),
    (398850, (2.885, 13.127, 26.941)),
    (499687, (1.159, 19.428, 23.416)),
    (883373, (9.813, 11.764, 20.851)),
    (733937, (4.828, 17.031, 23.737)),
    (958078, (1.254, 15.752, 27.251)),
    (796579, (7.896, 15.067, 22.263)),
    (19020, (3.954, 19.179, 24.493)),
    (213449, (0.872, 13.947, 23.489)),
    (111191, (3.990, 12.441, 22.124)),
    (51220, (9.222, 15.821, 20.334)),
    (419001, (2.725, 16.803, 23.280)),
    (488465, (5.700, 10.769, 29.822)),
    (67085, (9.405, 14.175, 26.408)),
    (25048, (8.598, 12.121, 24.998)),
    (922718, (8.536, 18.011, 27.337)),
    (459883, (1.365, 12.125, 23.460)),
    (241741, (5.117, 14.001, 28.002)),
    (438139, (7.255, 10.437, 20.645)),
    (221900, (4.709, 19.525, 24.359)),
    (279219, (6.690, 13.918, 21.039)),
    (223939, (9.074, 12.715, 28.214)),
    (752198, (6.133, 16.755, 23.556)),
    (684327, (3.868, 10.169, 23.404)),
    (329068, (9.765, 10.095, 28.022)),
    (405843, (4.818, 16.228, 20.556)),
    (583119, (4.120, 11.729, 26.142)),
    (649094, (9.262, 11.301, 21.134)),
    (19085, (4.020, 14.120, 26.742)),
    (378721, (0.720, 11.794, 27.337)),
    (993492, (9.221, 18.364, 21.574)),
    (459150, (7.336, 19.049, 27.136)),
    (738355, (4.390, 19.166, 29.653)),
    (48345, (1.404, 13.406, 26.207)),
    (572931, (2.764, 12.426, 27.286)),
    (11492, (5.044, 14.745, 26.930)),
    (431406, (8.373, 12.082, 28.417)),
    (884716, (7.376, 14.265, 28.281)),
    (312782, (9.338, 12.660, 23.317)),
    (630090, (4.014, 18.059, 22.691)),
    (663522, (8.726, 18.884, 27.455)),
    (851282, (1.787, 19.650, 25.119)),
    (536353, (6.767, 19.613, 24.464)),
    (317461, (2.350, 19.802, 26.522)),
    (858677, (2.207, 13.715, 25.461)),
    (410299, (6.275, 14.960, 22.592)),
    (696495, (8.641, 12.342, 28.096)),
    (284282, (9.804, 16.500, 28.411)),
    (534878, (6.290, 13.053, 29.790)),
    (160624, (5.360, 11.306, 20.856)),
    (628687, (9.828, 18.184, 21.954)),
    (136353, (3.675, 17.206, 22.176)),
    (892595, (1.096, 12.187, 29.289)),
    (625301, (1.925, 10.104, 26.713)),
    (216706, (0.098, 19.822, 22.701)),
    (619765, (4.855, 11.802, 20.379)),
    (290822, (2.933, 18.711, 23.324)),
    (514071, (1.521, 18.091, 26.512)),
    (225090, (5.996, 16.763, 27.760)),
    (989542, (6.260, 19.468, 22.982)),
    (86861, (5.967, 17.416, 28.464)),
    (237015, (2.882, 12.149, 22.634)),
    (720103, (0.949, 16.150, 26.376)),
    (40635, (0.974, 14.443, 23.531)),
    (444498, (7.771, 15.698, 27.845)),
    (38574, (3.719, 15.632, 29.844)),
    (78487, (8.750, 14.885, 28.214)),
    (745761, (8.971, 17.472, 23.329)),
    (569287, (8.135, 15.195, 25.483)),
    (78059, (9.825, 13.928, 29.198)),
    (939451, (8.425, 15.893, 26.824)),
    (492176, (5.236, 16.969, 23.742)),
    (562826, (0.790, 12.067, 29.917)),
    (909625, (6.451, 17.594, 23.506)),
    (163561, (5.106, 12.907, 26.864)),
    (706652, (4.771, 11.731, 23.261)),
    (294818, (0.502, 15.850, 22.533)),
    (896166, (6.345, 18.843, 23.981)),
    (120924, (7.863, 12.514, 24.332)),
    (139058, (1.953, 13.167, 20.998)),
    (91475, (1.907, 14.910, 20.825)),
    (398005, (7.435, 15.413, 27.387)),
    (466182, (0.901, 12.114, 26.594)),
    (736934, (1.596, 12.112, 28.336)),
    (987656, (4.780, 14.335, 26.898)),
    (566257, (6.825, 15.326, 29.117)),
    (736026, (0.449, 17.894, 26.675)),
    (18254, (8.469, 11.866, 24.941)),
    (818103, (4.298, 10.151, 20.870)),
    (144493, (9.538, 16.804, 25.969)),
    (477695, (3.278, 13.181, 21.520)),
    (925301, (0.857, 11.387, 29.498)),
    (305486, (7.197, 12.901, 24.008)),
    (494338, (1.223, 19.353, 27.619)),
    (489215, (4.056, 14.479, 24.423)),
    (182768, (7.082, 13.660, 20.253)),
    (286208, (3.149, 15.081, 23.080)),
    (433588, (6.134, 10.356, 22.348)),
    (403272, (6.001, 18.211, 28.599)),
    (435015, (8.908, 18.822, 24.300)),
    (607713, (8.547, 11.208, 20.067)),
    (67657, (0.888, 12.832, 25.158)),
    (972042, (6.273, 12.812, 24.215)),
    (564865, (9.492, 10.213, 25.167)),
    (986041, (8.098, 13.502, 25.162)),
    (993079, (8.070, 13.915, 20.831)),
    (724276, (0.727, 12.504, 29.376)),
    (969372, (1.865, 15.874, 25.788)),
    (631807, (3.553, 18.420, 24.448)),
    (481319, (2.678, 15.180, 26.109)),
    (756807, (7.493, 13.921, 27.063)),
    (926844, (3.323, 10.429, 20.050)),
    (892757, (1.552, 14.718, 23.936)),
    (354191, (6.557, 12.139, 24.864)),
    (162275, (8.108, 10.371, 28.045)),
    (499571, (8.145, 17.563, 28.206)),
    (179519, (0.040, 16.290, 25.354)),
    (467054, (0.176, 16.078, 23.898)),
    (307037, (1.503, 14.188, 27.448)),
    (190255, (3.706, 19.418, 25.155)),
    (284562, (2.724, 11.294, 26.529)),
    (874053, (0.206, 11.904, 20.425)),
    (864468, (4.479, 16.673, 22.304)),
    (876522, (3.903, 16.003, 28.133)),
    (947782, (3.506, 18.353, 28.934)),
    (17527, (8.038, 13.928, 21.304)),
    (842589, (0.820, 15.859, 22.804)),
    (20439, (2.020, 16.198, 29.397)),
    (844205, (2.045, 15.485, 29.887)),
    (402095, (1.925, 15.680, 27.069)),
    (830404, (8.642, 12.519, 20.843)),
    (252008, (4.384, 16.539, 21.035)),
    (920675, (6.155, 19.621, 23.298)),
    (249618, (1.386, 12.211, 29.571)),
    (239853, (9.510, 11.565, 29.526)),
    (418551, (6.156, 13.514, 25.838)),
    (12990, (2.259, 17.914, 28.271)),
    (758817, (4.208, 19.368, 21.156)),
    (69872, (5.056, 19.012, 28.065)),
    (420350, (1.278, 16.500, 21.622)),
    (484563, (5.878, 16.329, 23.820)),
    (16795, (3.007, 12.697, 23.236)),
    (225741, (0.723, 19.971, 20.872)),
    (151452, (9.532, 19.290, 22.741)),
    (734279, (8.089, 18.691, 26.869)),
    (423007, (2.546, 15.864, 28.160)),
    (108082, (0.940, 16.585, 21.181)),
    (902346, (4.899, 10.831, 22.678)),
    (805435, (5.796, 12.824, 29.907)),
    (778997, (8.556, 14.240, 22.447)),
    (820179, (6.490, 11.625, 20.213)),
    (958413, (4.984, 10.905, 21.650)),
    (547159, (8.770, 18.781, 22.984)),
    (592795, (3.664, 10.260, 20.860)),
    (741175, (7.868, 14.473, 21.902)),
    (595411, (6.351, 13.519, 22.802)),
    (291456, (7.119, 14.662, 23.344)),
    (639371, (0.770, 18.409, 28.296)),
    (356196, (9.084, 19.511, 27.649)),
    (502952, (3.651, 13.254, 26.746)),
    (824020, (6.674, 15.993, 22.405)),
    (874638, (7.752, 16.124, 27.996)),
    (185488, (6.079, 13.654, 28.448)),
    (665429, (0.700, 14.975, 26.131)),
    (57245, (5.402, 18.040, 27.331)),
    (655235, (3.825, 11.765, 28.892)),
    (72634, (5.527, 12.989, 29.600)),
    (263769, (0.397, 17.398, 20.467)),
    (84874, (3.675, 10.301, 24.066)),
    (152989, (4.340, 13.566, 20.160)),
    (870500, (8.860, 10.020, 26.486)),
    (970140, (8.184, 14.083, 23.508)),
    (701622, (9.419, 16.656, 25.474)),
    (537440, (6.337, 11.020, 25.270)),
    (970233, (8.078, 14.199, 29.941)),
    (191484, (7.010, 14.566, 26.086)),
    (994213, (8.302, 10.342, 27.251)),
    (206178, (9.499, 11.999, 27.187)),
    (885874, (0.772, 14.892, 26.008)),
    (421105, (3.125, 16.543, 25.442)),
    (500471, (9.975, 19.574, 23.987)),
    (751217, (2.285, 11.511, 27.832)),
    (332062, (3.983, 14.487, 23.079)),
    (476508, (2.898, 19.435, 24.903)),
    (147996, (6.627, 13.849, 22.114)),
    (866854, (0.624, 14.542, 23.373)),
    (347299, (0.129, 13.361, 27.653)),
    (11474, (2.749, 17.298, 21.773)),
    (282633, (4.078, 17.033, 27.149)),
    (130657, (0.847, 17.338, 23.861)),
    (64217, (6.763, 14.012, 24.987)),
    (10180, (4.438, 14.482, 20.918)),
    (808581, (6.724, 10.513, 20.335)),
    (274679, (4.762, 16.054, 24.634)),
    (400672, (4.339, 19.614, 29.549)),
    (739521, (6.961, 12.624, 28.172)),
    (38626, (3.988, 12.840, 27.128)),
    (868113, (8.657, 17.104, 23.021)),
    (834277, (3.891, 15.206, 20.012)),
    (475110, (7.729, 11.377, 22.299)),
    (763429, (4.301, 10.918, 22.615)),
    (781885, (5.172, 12.974, 28.893)),
    (307695, (8.201, 17.890, 27.786)),
    (707412, (8.019, 18.124, 24.382)),
    (312663, (3.278, 10.033, 24.357)),
    (963966, (2.761, 15.219, 23.831)),
    (727036, (1.629, 12.799, 23.770)),
    (711125, (7.077, 16.357, 28.455)),
    (569567, (2.151, 16.224, 25.882)),
    (720843, (5.900, 15.443, 25.897)),
    (978722, (4.577, 12.154, 27.631)),
    (359462, (1.847, 14.443, 21.415)),
    (813895, (5.278, 17.648, 20.545)),
    (901185, (3.876, 10.971, 27.805)),
    (418208, (4.150, 14.630, 28.770)),
    (325536, (0.830, 18.295, 21.398)),
    (539546, (8.898, 18.873, 22.164)),
    (325806, (6.650, 15.861, 23.215)),
    (423901, (3.866, 10.204, 27.080)),
    (290142, (7.971, 17.098, 21.312)),
    (530009, (6.787, 12.588, 20.184)),
    (297383, (8.886, 12.061, 23.187)),
    (510611, (5.389, 11.819, 21.102)),
    (501690, (4.740, 10.640, 29.669)),
    (462292, (5.873, 14.250, 20.672)),
    (667105, (1.181, 17.152, 22.306)),
    (886409, (5.676, 16.755, 20.686)),
    (696646, (2.868, 15.975, 29.609)),
    (719621, (0.040, 11.487, 20.684)),
    (856106, (9.697, 15.072, 22.035)),
    (283928, (7.439, 17.074, 27.092)),
    (398337, (2.399, 15.717, 23.928)),
    (447062, (3.086, 18.741, 23.996)),
    (88374, (4.015, 13.474, 27.982)),
    (484891, (0.142, 13.316, 27.218)),
    (855211, (3.332, 13.775, 26.178)),
    (756686, (5.886, 18.321, 29.240)),
    (313681, (6.694, 14.575, 23.101)),
    (715666, (8.189, 15.923, 27.683)),
    (402559, (6.493, 19.624, 21.351)),
    (665491, (1.903, 16.398, 24.309)),
    (986188, (8.312, 18.926, 24.483)),
    (91466, (0.304, 16.498, 29.991)),
    (607715, (1.299, 16.680, 25.714)),
    (12577, (3.135, 17.060, 20.470)),
    (856439, (7.800, 14.512, 24.600)),
    (640911, (8.209, 19.270, 22.460)),
    (294933, (6.098, 11.490, 27.881)),
    (533276, (8.520, 13.730, 25.261)),
    (968633, (5.461, 15.250, 23.739)),
    (361617, (6.026, 16.438, 28.897)),
    (733608, (2.875, 16.433, 29.654)),
    (216655, (9.625, 11.851, 27.214)),
    (941799, (5.448, 15.078, 24.456)),
    (523413, (5.089, 16.875, 24.654)),
    (637758, (2.198, 13.476, 23.196)),
    (203215, (7.115, 15.522, 20.662)),
    (389397, (5.039, 15.199, 24.198)),
    (610863, (1.425, 10.751, 26.882)),
    (201787, (1.059, 13.294, 25.375)),
    (275651, (1.634, 11.485, 29.112)),
    (7542, (3.956, 18.082, 21.985)),
    (618430, (4.096, 17.134, 29.510)),
    (908397, (0.112, 14.964, 23.721)),
    (980001, (3.625, 16.927, 22.718)),
    (772321, (9.053, 13.453, 28.546)),
    (259044, (4.297, 15.063, 22.145)),
    (325159, (1.470, 10.661, 29.901)),
    (367554, (0.635, 12.914, 22.472)),
    (775871, (0.158, 17.969, 27.489)),
    (972888, (9.994, 13.348, 26.417)),
    (442203, (1.885, 11.210, 28.931)),
    (517826, (6.072, 17.473, 21.563)),
    (400953, (8.932, 18.647, 29.794)),
    (820411, (8.280, 16.472, 24.790)),
    (21819, (6.606, 16.939, 29.656)),
    (603982, (1.280, 14.443, 28.955)),
    (136097, (6.297, 19.073, 22.277)),
    (166090, (1.622, 14.823, 21.102)),
    (776759, (9.895, 11.446, 27.728)),
    (578804, (7.608, 18.402, 29.864)),
    (218916, (1.866, 16.223, 22.010)),
    (543885, (4.352, 17.782, 21.936)),
    (155315, (0.738, 11.019, 29.347)),
    (905975, (2.279, 18.637, 20.179)),
    (518063, (7.812, 15.731, 26.601)),
    (283411, (2.820, 11.980, 29.548)),
    (443144, (6.490, 15.645, 28.180)),
    (825180, (9.719, 10.222, 25.700)),
    (630672, (1.354, 13.939, 22.700)),
    (185264, (7.683, 11.856, 24.596)),
    (826745, (5.603, 15.912, 23.855)),
    (117474, (1.460, 10.180, 20.378)),
    (202299, (6.462, 11.028, 28.825)),
    (659278, (8.952, 16.705, 21.585)),
    (474203, (3.097, 16.023, 22.644)),
    (865868, (0.166, 14.256, 24.636)),
    (396279, (9.404, 19.831, 20.337)),
    (141720, (6.457, 13.127, 26.700)),
    (50531, (1.608, 14.432, 26.616)),
    (470903, (5.576, 18.982, 28.041)),
    (768679, (3.742, 13.830, 21.616)),
    (365856, (0.958, 14.678, 26.756)),
    (361974, (2.368, 16.131, 20.566)),
    (508455, (4.604, 19.571, 26.831)),
    (653212, (0.303, 12.540, 25.227)),
    (756127, (2.693, 15.256, 20.642)),
    (723093, (7.093, 10.077, 25.407)),
    (700932, (6.737, 18.385, 28.467)),
    (698262, (6.739, 19.280, 23.441)),
    (723942, (0.693, 10.366, 21.356)),
    (318747, (4.339, 11.683, 29.148)),
    (765831, (1.700, 18.603, 27.508)),
    (777959, (0.090, 15.351, 21.999)),
    (847820, (9.218, 10.025, 27.964)),
    (78407, (0.218, 19.865, 28.469)),
    (229557, (2.079, 10.149, 22.728)),
    (250034, (6.397, 17.997, 28.667)),
    (832115, (8.830, 19.469, 28.269)),
    (703964, (3.978, 19.306, 28.148)),
    (454753, (7.017, 12.342, 29.354)),
    (989335, (1.761, 19.696, 27.668)),
    (655290, (6.651, 16.730, 21.667)),
    (244383, (4.402, 13.981, 25.562)),
    (443549, (2.494, 13.280, 22.404)),
    (224262, (0.095, 15.524, 29.722)),
    (278696, (8.962, 17.132, 26.879)),
    (677049, (5.275, 19.705, 21.876)),
    (293958, (0.940, 10.432, 25.621)),
    (114907, (5.212, 15.223, 24.122)),
    (186834, (8.593, 19.912, 26.434)),
    (680474, (1.790, 14.049, 26.319)),
    (422649, (0.955, 14.324, 29.627)),
    (146743, (5.145, 12.353, 21.266)),
    (949142, (7.420, 12.207, 28.917)),
    (941370, (9.584, 12.100, 21.971)),
    (898856, (4.185, 14.763, 25.985)),
    (252864, (2.982, 11.632, 27.543)),
    (478932, (6.468, 18.686, 25.643)),
    (825007, (6.422, 11.444, 27.747)),
    (332378, (4.995, 19.720, 25.221)),
    (162960, (6.145, 18.283, 26.561)),
    (362358, (5.789, 16.144, 28.007)),
    (871235, (3.655, 13.413, 28.826)),
    (770939, (1.193, 18.200, 25.900)),
    (64675, (5.368, 13.435, 28.052)),
    (444805, (6.008, 19.287, 26.316)),
    (159993, (3.739, 15.393, 20.753)),
    (780710, (2.921, 13.736, 23.127)),
    (95387, (4.682, 11.689, 27.631)),
    (265263, (3.589, 14.283, 20.565)),
    (970646, (2.069, 12.464, 25.676)),
    (649010, (7.170, 12.860, 29.205)),
    (809795, (8.707, 10.167, 29.977)),
    (630752, (9.555, 13.983, 24.472)),
    (860585, (2.595, 18.769, 22.868)),
    (229254, (1.927, 16.867, 27.009)),
    (623627, (8.396, 18.032, 21.072)),
    (916688, (6.811, 12.521, 20.488)),
    (31349, (8.925, 13.309, 29.450)),
    (944489, (9.197, 10.055, 21.105)),
    (482897, (8.810, 14.305, 25.196)),
    (369208, (2.870, 14.010, 27.933)),
    (655409, (0.795, 15.367, 24.130)),
    (273184, (7.422, 10.573, 26.795)),
    (532485, (8.656, 13.396, 22.365)),
    (980724, (4.012, 15.462, 23.185)),
    (17813, (2.641, 17.036, 23.967)),
    (842979, (1.543, 18.587, 23.121)),
    (122409, (7.712, 16.933, 25.602)),
    (152765, (6.910, 12.946, 27.463)),
    (231247, (9.157, 11.486, 23.226)),
    (364016, (5.063, 13.787, 29.156)),
    (349422, (2.379, 11.202, 20.697)),
    (409678, (8.353, 11.954, 26.967)),
    (611851, (9.625, 12.735, 20.751)),
    (60809, (3.726, 11.221, 20.473)),
    (195759, (9.346, 14.610, 22.243)),
    (455771, (6.962, 17.558, 24.950)),
    (753148, (1.506, 10.118, 26.940)),
    (725826, (9.205, 13.289, 24.101)),
    (112753, (6.106, 17.794, 28.853)),
    (208550, (0.202, 10.200, 21.290)),
    (911333, (2.044, 19.789, 24.317)),
    (615091, (0.977, 16.825, 25.992)),
    (950853, (8.528, 17.892, 20.082)),
    (858063, (1.559, 12.914, 25.008)),
    (993191, (1.006, 17.429, 23.740)),
    (737782, (8.616, 18.427, 24.193)),
    (245290, (7.726, 13.716, 24.464)),
    (154110, (3.401, 13.163, 22.984)),
    (528010, (3.381, 16.858, 22.462)),
    (231589, (3.784, 11.329, 28.024)),
    (232673, (6.551, 13.105, 29.561)),
    (979378, (4.956, 18.097, 21.789)),
    (751111, (8.718, 13.785, 21.209)),
    (79490, (4.522, 12.265, 29.527)),
    (660812, (9.452, 15.673, 21.570)),
    (817431, (6.530, 13.345, 22.466)),
    (50163, (2.382, 11.666, 25.306)),
    (479757, (0.499, 15.672, 26.801)),
    (593237, (9.221, 17.862, 29.175)),
    (458935, (1.451, 12.702, 23.008)),
    (784625, (2.033, 19.332, 21.481)),
    (690546, (9.536, 12.903, 20.865)),
    (149858, (0.086, 15.995, 22.138)),
    (747300, (2.945, 15.949, 26.989)),
    (175847, (0.322, 15.451, 25.948)),
    (75882, (9.530, 16.402, 25.867)),
    (4010, (9.409, 19.684, 27.988)),
    (927355, (3.192, 18.809, 29.764)),
    (772366, (2.471, 16.440, 26.340)),
    (232184, (3.234, 13.501, 29.703)),
    (483940, (0.515, 10.162, 24.457)),
    (61773, (9.631, 17.097, 24.309)),
    (2376, (4.414, 17.429, 20.940)),
    (753181, (5.036, 11.442, 20.767)),
    (403590, (0.915, 18.592, 28.552)),
    (344848, (5.246, 17.364, 28.306)),
    (308873, (8.991, 19.865, 27.256)),
    (85897, (0.321, 10.207, 29.472)),
    (496878, (6.981, 10.826, 25.603)),
    (264991, (1.715, 11.290, 27.651)),
    (841548, (6.454, 15.740, 24.726)),
    (823140, (8.429, 18.213, 29.053)),
    (907055, (2.134, 12.789, 23.280)),
    (731872, (9.761, 11.315, 25.040)),
    (584340, (4.377, 14.802, 24.968)),
    (773153, (3.822, 13.257, 24.177)),
    (622321, (0.307, 11.093, 20.990)),
    (386513, (9.213, 10.346, 28.531)),
    (664516, (1.952, 15.067, 26.359)),
    (837818, (4.200, 16.775, 28.551)),
    (893208, (9.300, 18.918, 25.585)),
    (532627, (3.667, 11.725, 26.992)),
    (486307, (6.702, 19.611, 21.664)),
    (499936, (4.833, 18.255, 24.851)),
    (428583, (7.580, 17.962, 24.262)),
    (891507, (4.614, 17.281, 20.602)),
    (812406, (2.955, 15.377, 29.827)),
    (434484, (5.248, 15.081, 26.491)),
    (576496, (1.270, 17.075, 20.002)),
    (932950, (0.957, 15.379, 20.886)),
    (55374, (9.788, 14.589, 29.210)),
    (298223, (5.699, 17.281, 28.095)),
    (696190, (6.329, 17.860, 24.818)),
    (426108, (2.972, 11.541, 20.218)),
    (746243, (1.493, 12.810, 20.099)),
    (133070, (8.636, 10.348, 23.543)),
    (712782, (2.239, 16.372, 22.757)),
    (310415, (7.369, 13.682, 29.721)),
    (105186, (4.928, 13.876, 29.015)),
    (62591, (9.096, 10.657, 20.344)),
    (163263, (5.228, 16.382, 28.123)),
    (706104, (7.496, 14.388, 29.783)),
    (565692, (8.312, 16.305, 20.489)),
    (22211, (1.960, 10.377, 29.930)),
    (886524, (3.020, 17.454, 23.574)),
    (148597, (2.347, 18.877, 27.019)),
    (550496, (4.473, 16.902, 27.642)),
    (245784, (0.942, 14.103, 22.109)),
    (631962, (5.168, 14.425, 26.556)),
    (318271, (2.492, 16.586, 27.617)),
    (120996, (2.249, 15.072, 27.550)),
    (896285, (9.951, 14.589, 26.531)),
    (607773, (1.893, 15.785, 28.522)),
    (146712, (2.429, 11.722, 25.247)),
    (475446, (3.212, 17.581, 20.058)),
    (714365, (1.430, 12.820, 20.240)),
    (765377, (4.680, 12.589, 26.021)),
    (739514, (2.042, 13.187, 23.510)),
    (453027, (8.219, 11.953, 23.365)),
    (476125, (1.296, 18.295, 29.770)),
    (292520, (3.306, 11.235, 25.141)),
    (790193, (0.382, 11.451, 26.189)),
    (455271, (2.095, 19.443, 28.053)),
    (915484, (0.208, 19.241, 23.151)),
    (145005, (2.752, 10.079, 26.036)),
    (824837, (9.426, 16.971, 29.979)),
    (838598, (4.682, 17.318, 20.139)),
    (888083, (6.027, 11.313, 26.422)),
    (335129, (4.823, 13.369, 22.976)),
    (97321, (9.504, 11.858, 29.770)),
    (574682, (9.087, 13.057, 27.399)),
    (881338, (4.138, 16.774, 29.895)),
    (742774, (9.628, 10.017, 28.977)),
    (583843, (4.230, 14.069, 26.015)),
    (562214, (1.391, 17.539, 28.186)),
    (409194, (2.579, 18.371, 23.430)),
    (558176, (5.008, 16.244, 27.242)),
    (188382, (7.667, 11.216, 26.916)),
    (566433, (5.924, 12.939, 28.082)),
    (189214, (9.791, 18.178, 23.075)),
    (436025, (3.650, 13.346, 23.295)),
    (738267, (8.616, 13.844, 26.878)),
    (985502, (3.045, 10.902, 28.089)),
    (304505, (0.640, 18.528, 25.858)),
    (909232, (8.735, 18.588, 28.653)),
    (537083, (9.826, 17.535, 25.191)),
    (611467, (4.331, 13.339, 22.199)),
    (893234, (2.689, 19.613, 20.405)),
    (114642, (5.391, 18.565, 29.004)),
    (283541, (0.450, 12.888, 20.907)),
    (71359, (8.968, 15.958, 28.982)),
    (266542, (4.595, 11.697, 27.228)),
    (619856, (6.625, 11.609, 26.435)),
    (443549, (1.240, 14.156, 26.385)),
    (135902, (5.365, 18.187, 22.401)),
    (553045, (1.748, 17.974, 29.464)),
    (975639, (3.769, 15.282, 22.080)),
    (455654, (6.679, 14.209, 21.604)),
    (132170, (6.511, 14.619, 23.017)),
    (702241, (3.692, 18.700, 29.948)),
    (520021, (6.686, 11.810, 27.284)),
    (590766, (0.415, 12.060, 20.876)),
    (323092, (6.858, 17.316, 21.863)),
    (430665, (2.911, 11.019, 23.395)),
    (449111, (1.663, 12.320, 24.775)),
    (48313, (1.284, 11.897, 21.946)),
    (797165, (0.396, 13.357, 21.781)),
    (390918, (7.103, 16.867, 27.092)),
    (124562, (1.347, 15.399, 24.412)),
    (632343, (5.158, 17.819, 27.488)),
    (66586, (7.567, 14.484, 28.060)),
    (329164, (9.731, 14.496, 29.901)),
    (69179, (7.994, 10.646, 28.318)),
    (701866, (2.416, 18.969, 26.887)),
    (45654, (2.634, 10.530, 28.148)),
    (405957, (6.892, 18.806, 26.893)),
    (272896, (1.627, 16.782, 21.452)),
    (569371, (5.158, 13.484, 20.072)),
    (839563, (1.184, 19.535, 24.444)),
    (525050, (1.354, 12.176, 20.648)),
    (855957, (4.250, 15.983, 24.310)),
    (154002, (6.146, 12.283, 29.590)),
    (830219, (9.707, 14.675, 26.361)),
    (390707, (1.467, 15.747, 24.012)),
    (686748, (1.582, 11.749, 25.075)),
    (6369, (1.222, 17.133, 29.886)),
    (510842, (5.262, 19.842, 25.774)),
    (738380, (5.491, 13.517, 26.208)),
    (207571, (3.728, 17.479, 28.471)),
    (468735, (9.929, 17.936, 28.326)),
    (450958, (0.660, 10.070, 20.122)),
    (183816, (6.112, 19.008, 20.090)),
    (27833, (0.065, 17.456, 28.188)),
    (344376, (5.029, 15.387, 26.449)),
    (902498, (5.340, 16.867, 28.735)),
    (134262, (4.499, 12.698, 25.192)),
    (784950, (4.034, 13.098, 22.572)),
    (963212, (5.185, 17.774, 23.223)),
    (583194, (9.496, 18.505, 25.715)),
    (398926, (4.536, 13.448, 23.979)),
    (418073, (3.308, 11.239, 23.323)),
    (294316, (4.849, 13.652, 22.740)),
    (979205, (4.021, 15.304, 26.819)),
    (692437, (0.329, 15.016, 20.453)),
    (653863, (1.652, 17.747, 20.327)),
    (865624, (7.221, 16.998, 25.216)),
    (426754, (7.037, 16.308, 21.110)),
    (493061, (6.435, 17.197, 26.854)),
    (365126, (4.377, 19.353, 25.908)),
    (72484, (7.986, 19.812, 23.349)),
    (17358, (1.172, 17.939, 24.405)),
    (956934, (7.963, 11.176, 27.003)),
    (138876, (8.704, 11.674, 25.148)),
    (838163, (5.854, 10.378, 20.564)),
    (466357, (8.461, 18.329, 27.975)),
    (404307, (8.253, 19.858, 29.737)),
    (616786, (4.615, 14.250, 22.947)),
    (717966, (5.658, 16.059, 23.197)),
    (659697, (3.418, 15.358, 27.526)),
    (28341, (3.304, 12.494, 29.973)),
    (578871, (6.194, 18.102, 28.473)),
    (698735, (4.405, 15.308, 25.864)),
    (813562, (7.521, 17.176, 28.403)),
    (412783, (1.216, 13.772, 21.408)),
    (206183, (9.712, 14.810, 25.896)),
    (655817, (8.319, 17.064, 28.484)),
    (188533, (6.976, 16.730, 28.586)),
    (567737, (5.664, 15.248, 26.241)),
    (284172, (6.492, 14.867, 24.300)),
    (464467, (1.242, 17.392, 29.054)),
    (673427, (6.749, 10.187, 22.414)),
    (72117, (2.303, 13.409, 22.153)),
    (644304, (9.889, 17.939, 24.053)),
    (576253, (3.711, 10.289, 22.931)),
    (814560, (4.159, 10.850, 29.472)),
    (14076, (6.680, 10.286, 29.272)),
    (520304, (0.909, 13.846, 26.150)),
    (985933, (5.966, 17.837, 29.252)),
    (877250, (5.735, 16.627, 22.680)),
    (65549, (4.332, 15.564, 23.303)),
    (535034, (0.999, 15.934, 27.854)),
    (701224, (7.454, 12.563, 28.776)),
    (920467, (1.584, 18.870, 28.362)),
    (593845, (7.150, 14.419, 23.432)),
    (661316, (4.400, 10.100, 22.208)),
    (282540, (8.925, 17.098, 20.557)),
    (983616, (5.438, 11.164, 20.602)),
    (380879, (4.116, 14.372, 21.216)),
    (282261, (7.597, 11.803, 24.937)),
    (708560, (8.714, 15.788, 28.951)),
    (880339, (7.852, 16.938, 28.526)),
    (188492, (0.304, 11.482, 21.992)),
    (551325, (7.966, 15.108, 22.405)),
    (26347, (8.250, 16.589, 29.321)),
    (398345, (1.056, 14.069, 29.048)),
    (29809, (0.339, 17.339, 25.158)),
    (277528, (1.010, 12.393, 20.772)),
    (571745, (8.284, 18.423, 22.803)),
    (259258, (3.279, 13.298, 22.797)),
    (739712, (7.874, 17.295, 22.324)),
    (325477, (6.598, 16.505, 23.723)),
    (586526, (1.087, 17.253, 27.135)),
    (896604, (0.474, 19.930, 26.311)),
    (470689, (5.902, 10.773, 20.066)),
    (562966, (3.975, 10.944, 21.848)),
    (894040, (5.032, 10.364, 23.184)),
    (754244, (9.705, 19.971, 28.749)),
    (317072, (4.915, 11.105, 26.573)),
    (813840, (0.270, 13.893, 21.035)),
    (837336, (9.161, 11.015, 29.286)),
    (169899, (3.628, 19.856, 28.821)),
    (466165, (9.795, 18.025, 22.779)),
    (675860, (5.808, 16.784, 20.088)),
    (816170, (9.855, 15.812, 29.077)),
    (926312, (3.292, 16.662, 23.921)),
    (745204, (0.632, 10.482, 26.732)),
    (653624, (6.083, 19.905, 23.803)),
    (887377, (4.322, 12.655, 29.952)),
    (20941, (0.731, 16.731, 22.847)),
    (884826, (7.874, 12.038, 21.791)),
    (520496, (3.857, 19.334, 21.969)),
    (76248, (3.449, 11.349, 24.340)),
    (782037, (9.663, 15.481, 27.629)),
    (562970, (6.580, 19.417, 25.809)),
    (549347, (8.610, 15.504, 20.371)),
    (579602, (6.588, 10.296, 26.997)),
    (806517, (5.082, 12.035, 27.763)),
    (136331, (1.401, 17.255, 27.269)),
    (488473, (8.804, 12.802, 25.096)),
    (967859, (0.951, 12.977, 24.267)),
    (669233, (5.983, 15.067, 23.692)),
    (561799, (7.740, 13.893, 24.736)),
    (647439, (6.152, 10.735, 27.497)),
    (76305, (9.970, 10.086, 28.416)),
    (611769, (3.427, 19.996, 21.897)),
    (515668, (5.402, 16.114, 28.676)),
    (433691, (1.461, 14.637, 24.121)),
    (114625, (1.337, 14.317, 20.033)),
    (996555, (2.781, 16.299, 29.239)),
    (509096, (9.613, 15.401, 24.077)),
    (385387, (2.470, 18.773, 27.442)),
    (819680, (1.451, 10.427, 24.124)),
    (397277, (5.561, 14.575, 21.959)),
    (475446, (6.205, 18.177, 22.195)),
    (305393, (5.970, 19.606, 22.247)),
    (116003, (1.405, 18.599, 27.392)),
    (141057, (1.136, 17.005, 22.699)),
    (68023, (8.834, 14.029, 23.424)),
    (195632, (6.106, 11.278, 27.120)),
    (940635, (6.828, 16.994, 22.377)),
    (339754, (0.806, 13.588, 25.348)),
    (65174, (9.199, 13.412, 20.649)),
    (327206, (6.438, 19.510, 24.835)),
    (228674, (6.318, 10.780, 22.749)),
    (393309, (3.555, 19.245, 27.298)),
    (91174, (3.760, 15.075, 20.764)),
    (493239, (7.554, 11.558, 20.896)),
    (122112, (6.137, 18.875, 23.558)),
    (858071, (0.416, 14.500, 23.241)),
    (983938, (4.606, 18.932, 26.059)),
    (709103, (1.227, 12.125, 23.996)),
    (251462, (8.341, 10.396, 23.232)),
    (5672, (2.880, 19.965, 22.798)),
    (281855, (3.720, 14.797, 24.349)),
    (194788, (8.672, 13.020, 25.971)),
    (517653, (5.305, 17.579, 26.292)),
    (678284, (3.778, 15.399, 29.405)),
    (46283, (4.806, 11.500, 28.915)),
    (430738, (7.793, 12.175, 25.447)),
    (428506, (9.025, 17.829, 28.737)),
    (114307, (4.866, 10.662, 22.783)),
    (166513, (8.503, 19.023, 28.801)),
    (750403, (4.661, 16.258, 25.676)),
    (74714, (8.286, 12.492, 24.040)),
    (602057, (4.077, 17.885, 25.333)),
    (268667, (1.735, 18.333, 28.026)),
    (832366, (4.484, 13.531, 20.600)),
    (792643, (1.163, 15.634, 23.620)),
    (877709, (1.696, 15.834, 21.381)),
    (412751, (3.519, 13.344, 28.276)),
    (18845, (0.417, 19.626, 21.865)),
    (610960, (4.833, 17.043, 24.659)),
    (620274, (9.372, 13.533, 27.304)),
    (411638, (9.355, 18.970, 21.508)),
    (208279, (7.457, 17.622, 27.775)),
    (356004, (0.474, 10.135, 23.842)),
    (786419, (5.089, 14.448, 28.991)),
    (163862, (0.571, 10.775, 24.679)),
    (34534, (0.067, 12.895, 26.177)),
    (809415, (5.299, 13.511, 25.656)),
    (338166, (9.557, 12.935, 22.084)),
    (307926, (0.752, 19.847, 22.303)),
    (803635, (0.186, 19.702, 28.635)),
    (667305, (3.481, 15.912, 29.507)),
    (444873, (7.575, 18.106, 21.913)),
    (523970, (7.497, 17.637, 21.270)),
    (687114, (0.086, 12.628, 29.212)),
    (823681, (1.563, 17.992, 27.130)),
    (701973, (0.687, 18.371, 25.403)),
    (689811, (0.541, 10.260, 22.602)),
    (745147, (4.913, 18.693, 29.957)),
    (287714, (6.653, 10.282, 29.228)),
    (862229, (1.595, 12.983, 24.738)),
    (752851, (4.484, 10.073, 22.254)),
    (680223, (4.892, 14.004, 27.074)),
    (47142, (9.866, 10.112, 24.468)),
    (836199, (4.549, 12.878, 20.625)),
    (615010, (3.878, 14.375, 28.687)),
    (903100, (6.914, 12.517, 22.836)),
    (785650, (4.844, 11.564, 21.945)),
    (109286, (5.150, 12.759, 22.829)),
    (481518, (1.704, 18.283, 23.254)),
    (931259, (2.473, 12.967, 25.373)),
    (298711, (3.666, 17.407, 22.759)),
    (872568, (5.212, 13.842, 23.906)),
    (2786, (8.868, 16.762, 27.170)),
    (162974, (3.167, 12.606, 25.150)),
    (340352, (8.199, 11.454, 21.021)),
    (402951, (6.944, 13.482, 28.099)),
    (919293, (3.734, 19.911, 22.464)),
    (73722, (2.361, 12.551, 21.393)),
    (147796, (5.407, 19.783, 28.318)),
    (844376, (5.077, 10.264, 25.424)),
    (843512, (9.309, 16.543, 23.568)),
    (891210, (0.863, 10.374, 26.848)),
    (609233, (4.878, 12.782, 24.658)),
    (475337, (6.259, 10.409, 25.248)),
    (568305, (3.413, 16.172, 27.643)),
    (120184, (3.241, 17.318, 25.100)),
    (772784, (3.216, 14.723, 28.404)),
    (204565, (1.380, 16.889, 27.477)),
    (305717, (6.354, 18.645, 29.279)),
    (343814, (5.234, 16.964, 28.281)),
    (166855, (5.712, 12.606, 22.450)),
    (911688, (0.684, 15.939, 27.265)),
    (624899, (4.126, 16.762, 27.043)),
    (879585, (2.948, 11.382, 21.004)),
    (452967, (7.147, 10.074, 20.619)),
    (258090, (2.220, 12.022, 24.475)),
    (205021, (2.271, 18.796, 22.705)),
    (763235, (2.810, 12.342, 23.240)),
    (30434, (8.541, 19.856, 20.941)),
    (607607, (0.877, 19.538, 21.011)),
    (574521, (5.114, 16.320, 24.067)),
    (848520, (2.864, 14.617, 23.561)),
    (13547, (0.407, 17.627, 28.438)),
    (567001, (2.963, 10.223, 20.941)),
    (993409, (4.575, 17.420, 28.513)),
    (976169, (0.718, 13.923, 27.155)),
    (211906, (9.260, 18.856, 26.085)),
    (666036, (3.897, 12.189, 20.900)),
    (320567, (1.664, 15.863, 29.429)),
    (271566, (4.234, 10.167, 21.101)),
    (883616, (7.661, 17.544, 26.841)),
    (22746, (1.001, 13.151, 29.516)),
    (165671, (0.128, 17.103, 23.444)),
    (229535, (9.717, 11.016, 29.848)),
    (964668, (0.633, 14.733, 27.917)),
    (769712, (6.791, 13.253, 23.121)),
    (884440, (5.216, 17.505, 29.035)),
    (844356, (5.316, 18.138, 25.546)),
    (25736, (3.079, 18.905, 27.067)),
    (691326, (0.223, 15.994, 21.333)),
    (801735, (2.717, 14.482, 25.104)),
    (702850, (9.365, 15.967, 24.990)),
    (795143, (3.236, 16.236, 28.838)),
    (481560, (2.879, 14.815, 26.630)),
    (472105, (5.085, 10.529, 25.129)),
    (650757, (3.518, 16.739, 22.422)),
    (749379, (0.283, 13.915, 27.299)),
    (610706, (6.339, 14.304, 26.228)),
    (810274, (6.093, 19.110, 22.981)),
    (474492, (9.140, 13.306, 29.268)),
    (799171, (0.588, 15.249, 20.733)),
    (751198, (4.469, 11.011, 20.475)),
    (784645, (5.260, 15.460, 20.143)),
    (551475, (3.374, 12.089, 26.582)),
    (621398, (0.781, 14.746, 27.481)),
    (42366, (2.609, 17.807, 26.671)),
    (167377, (2.253, 19.845, 28.697)),
    (811005, (3.813, 14.349, 26.209)),
    (455262, (2.830, 16.516, 24.034)),
    (130683, (4.803, 18.613, 28.026)),
    (217311, (3.952, 10.246, 25.845)),
    (90561, (5.997, 15.899, 23.465)),
    (512665, (0.260, 13.696, 22.387)),
    (268021, (8.721, 14.439, 22.162)),
    (221731, (4.478, 16.539, 25.092)),
    (621460, (9.281, 11.779, 28.590)),
    (766406, (6.761, 11.584, 22.885)),
    (125867, (6.983, 17.836, 21.232)),
    (639249, (3.030, 12.813, 21.887)),
    (452697, (0.443, 17.183, 29.997)),
    (487998, (3.614, 17.839, 22.390)),
    (819697, (2.543, 16.597, 22.557)),
    (220338, (6.432, 16.406, 26.713)),
    (479442, (9.469, 11.604, 29.561)),
    (192861, (7.996, 12.981, 29.071)),
    (493255, (3.318, 16.095, 20.560)),
    (527722, (1.242, 16.829, 22.079)),
    (888101, (4.625, 13.436, 28.266)),
    (311616, (6.981, 16.815, 23.724)),
    (509616, (7.527, 15.557, 25.055)),
    (998193, (1.757, 17.514, 26.049)),
    (845181, (3.569, 18.792, 23.254)),
    (650327, (5.113, 19.083, 22.877)),
    (707560, (4.957, 17.649, 29.697)),
    (774693, (8.988, 12.505, 26.715)),
    (961404, (2.500, 18.623, 20.834)),
    (555050, (7.972, 11.292, 29.005)),
    (603817, (7.146, 19.689, 29.021)),
    (855403, (4.935, 17.695, 22.027)),
    (466890, (6.357, 19.686, 25.996)),
    (852191, (3.419, 13.708, 22.927)),
    (316808, (0.829, 15.331, 28.584)),
    (815353, (0.876, 15.627, 23.477)),
    (141715, (0.243, 17.105, 21.237)),
    (602789, (9.074, 18.485, 23.924)),
    (802681, (8.465, 14.547, 23.954)),
    (446696, (0.974, 19.348, 27.861)),
    (440719, (9.474, 11.629, 22.023)),
    (808684, (9.617, 17.667, 25.093)),
    (705184, (9.242, 12.508, 26.439)),
    (505617, (0.090, 16.811, 29.864)),
    (414449, (2.367, 12.441, 24.340)),
    (295972, (7.324, 12.448, 22.671)),
    (732589, (8.534, 16.734, 22.513)),
    (626507, (7.687, 15.644, 22.321)),
    (377249, (5.397, 18.669, 27.091)),
    (526740, (3.840, 14.070, 22.284)),
    (211596, (2.216, 17.474, 24.348)),
    (56847, (3.057, 12.436, 20.336)),
    (528656, (0.534, 19.793, 24.914)),
    (143232, (9.583, 13.993, 24.524)),
    (128944, (2.228, 13.815, 21.396)),
    (20735, (4.859, 18.681, 29.447)),
    (109329, (8.450, 18.566, 29.232)),
    (645865, (2.739, 14.848, 28.675)),
    (567824, (7.198, 14.074, 22.568)),
    (100726, (1.295, 11.213, 20.009)),
    (938607, (0.103, 10.205, 28.331)),
    (58774, (6.859, 19.770, 24.433)),
    (752171, (7.533, 19.956, 29.235)),
    (171425, (2.717, 17.956, 26.792)),
    (36421, (5.714, 19.424, 22.710)),
    (50683, (5.233, 10.174, 23.022)),
    (263130, (7.482, 15.454, 24.063)),
    (328220, (1.611, 16.909, 26.251)),
    (403897, (0.666, 13.774, 23.717)),
    (296243, (1.157, 13.443, 20.565)),
    (799026, (8.475, 14.599, 28.864)),
    (991523, (9.785, 13.301, 22.531)),
    (426100, (9.482, 11.638, 27.583)),
    (934220, (2.797, 18.147, 23.587)),
    (945051, (0.655, 12.960, 20.649)),
    (878840, (4.898, 17.952, 29.526)),
    (235643, (6.581, 13.286, 24.274)),
    (222734, (5.358, 14.298, 24.830)),
    (539445, (5.095, 10.446, 26.917)),
    (459008, (8.240, 14.786, 29.857)),
    (498048, (3.968, 17.158, 22.488)),
    (364667, (4.731, 14.501, 20.459)),
    (646753, (2.171, 19.030, 29.464)),
    (699728, (6.698, 14.050, 20.428)),
    (177134, (1.387, 16.438, 28.110)),
    (822604, (7.318, 16.179, 28.620)),
    (95094, (2.473, 18.360, 27.558)),
    (776477, (8.178, 12.198, 23.023)),
    (392358, (7.958, 10.486, 29.305)),
    (295788, (4.070, 14.175, 27.625)),
    (107303, (0.171, 14.116, 25.973)),
    (289998, (0.407, 15.569, 28.771)),
    (488954, (5.352, 13.462, 21.566)),
    (788637, (6.531, 17.930, 27.576)),
    (82078, (2.545, 13.411, 28.874)),
    (779397, (7.146, 16.446, 24.948)),
    (443370, (5.559, 13.784, 26.209)),
    (702457, (7.472, 17.032, 21.056)),
    (492290, (4.841, 16.776, 28.459)),
    (655513, (6.910, 10.495, 28.587)),
    (46245, (6.524, 16.034, 22.239)),
    (690695, (6.242, 15.868, 20.801)),
    (6531, (3.314, 16.571, 22.290)),
    (33239, (4.946, 11.592, 20.749)),
    (342433, (0.384, 14.854, 27.290)),
    (354189, (8.909, 10.457, 23.208)),
    (494605, (6.478, 18.515, 26.038)),
    (575091, (2.617, 15.876, 24.707)),
    (433718, (2.755, 12.483, 23.592)),
    (716701, (9.683, 12.603, 23.900)),
    (696756, (6.281, 12.705, 20.269)),
    (489530, (3.899, 16.427, 26.889)),
    (860373, (5.690, 14.993, 24.215)),
    (373051, (8.098, 12.225, 28.378)),
    (808365, (1.968, 15.819, 20.772)),
    (93017, (0.680, 13.572, 27.382)),
    (539819, (1.582, 10.530, 21.177)),
    (540406, (7.015, 17.356, 23.338)),
    (877179, (7.169, 17.118, 21.270)),
    (755304, (3.325, 11.405, 24.845)),
    (431472, (4.003, 14.367, 22.929)),
    (702345, (1.416, 14.594, 24.262)),
    (801357, (2.685, 16.303, 21.040)),
    (364917, (3.084, 13.482, 25.297)),
    (394707, (5.838, 14.357, 21.027)),
    (450042, (6.703, 10.112, 23.708)),
    (28650, (7.253, 18.214, 26.375)),
    (38161, (0.514, 16.755, 22.696)),
    (278944, (3.200, 17.479, 22.492)),
    (238637, (1.793, 15.292, 21.370)),
    (58720, (1.425, 11.060, 22.237)),
    (136240, (7.190, 17.036, 23.771)),
    (841957, (6.683, 18.697, 29.469)),
    (384870, (2.767, 10.436, 23.376)),
    (302607, (9.627, 15.012, 26.866)),
    (273557, (3.062, 19.091, 21.054)),
    (529065, (3.769, 12.065, 25.396)),
    (814252, (3.462, 15.703, 27.654)),
    (754809, (0.238, 11.896, 25.755)),
    (530140, (6.800, 13.907, 22.945)),
    (146936, (9.603, 10.573, 20.308)),
    (637396, (0.747, 17.510, 21.167)),
    (842438, (2.527, 17.236, 26.826)),
    (307231, (6.179, 17.243, 28.922)),
    (220989, (1.229, 10.046, 23.213)),
    (302011, (0.029, 18.637, 29.025)),
    (249175, (2.559, 17.141, 25.888)),
    (774960, (1.254, 14.026, 29.126)),
    (996846, (4.887, 17.280, 24.947)),
    (826926, (1.023, 11.069, 22.674)),
    (691918, (4.731, 13.527, 27.288)),
    (950865, (1.390, 18.318, 21.787)),
    (757269, (6.962, 15.724, 27.565)),
    (249438, (7.978, 19.239, 21.942)),
    (479544, (9.997, 12.420, 23.705)),
    (317164, (5.518, 18.571, 22.358)),
    (529757, (8.669, 13.613, 26.277)),
    (608847, (7.532, 18.477, 23.872)),
    (264571, (4.622, 14.633, 29.515)),
    (166489, (5.613, 14.621, 29.952)),
    (639625, (7.660, 11.063, 24.429)),
    (579794, (9.977, 17.880, 21.084)),
    (636475, (8.757, 16.237, 23.318)),
    (949383, (2.880, 17.332, 20.514)),
    (222829, (2.111, 14.068, 25.856)),
    (989908, (6.046, 13.069, 29.134)),
    (214291, (2.328, 11.758, 27.430)),
    (454849, (0.594, 16.434, 25.214)),
    (768060, (5.744, 17.577, 23.267)),
    (911028, (5.235, 19.768, 22.961)),
    (389343, (5.921, 18.663, 28.008)),
    (726636, (3.242, 10.578, 29.336)),
    (740946, (6.423, 12.798, 23.053)),
    (479371, (1.293, 19.573, 28.318)),
    (494374, (1.189, 11.560, 25.990)),
    (166982, (5.924, 16.046, 24.227)),
    (569816, (1.623, 12.620, 27.375)),
    (740535, (6.904, 15.796, 25.114)),
    (661080, (1.982, 19.023, 21.694)),
    (556124, (0.100, 16.426, 24.496)),
    (286077, (1.815, 19.254, 20.277)),
    (548093, (0.641, 18.943, 26.015)),
    (45988, (2.346, 10.719, 22.547)),
    (752228, (2.085, 16.261, 24.625)),
    (725000, (6.829, 13.076, 28.234)),
    (702810, (4.726, 17.580, 29.744)),
    (927101, (2.958, 10.049, 29.151)),
    (587006, (2.930, 19.053, 28.978)),
    (582802, (1.992, 13.302, 29.774)),
    (170172, (9.277, 11.163, 26.402)),
    (221263, (3.004, 15.681, 29.891)),
    (260015, (4.612, 19.249, 29.313)),
    (299996, (6.332, 11.629, 23.759)),
    (845083, (4.997, 10.217, 20.432)),
    (603068, (4.375, 12.086, 22.053)),
    (648196, (1.489, 17.325, 22.686)),
    (375766, (8.983, 17.898, 23.368)),
    (94624, (7.581, 10.217, 25.662)),
    (307383, (2.013, 19.330, 24.773)),
    (64838, (8.986, 10.418, 24.634)),
    (480610, (7.110, 16.679, 23.669)),
    (771874, (0.450, 15.280, 25.014)),
    (712223, (2.347, 13.686, 20.695)),
    (987, (4.046, 14.981, 24.752)),
    (428835, (3.401, 15.590, 23.970)),
    (45469, (3.937, 19.232, 22.033)),
    (878079, (5.891, 14.459, 29.904)),
    (197089, (8.737, 11.604, 24.641)),
    (659809, (9.595, 11.813, 20.889)),
    (104490, (0.007, 17.141, 23.762)),
    (40823, (9.222, 19.487, 26.823)),
    (459240, (0.119, 10.474, 22.000)),
    (888035, (0.516, 12.247, 24.759)),
    (509003, (8.525, 13.154, 26.237)),
    (79682, (8.596, 16.298, 24.943)),
    (752515, (8.079, 17.582, 26.221)),
    (850502, (0.383, 13.905, 26.598)),
    (457545, (1.798, 15.602, 24.900)),
    (13134, (1.863, 10.947, 26.359)),
    (545599, (7.299, 16.244, 29.842)),
    (377110, (9.273, 18.260, 29.430)),
    (586447, (4.583, 11.473, 27.315)),
    (89431, (6.923, 15.291, 29.656)),
    (395505, (9.615, 16.884, 26.166)),
    (599579, (0.476, 18.644, 26.282)),
    (953609, (0.965, 18.276, 26.364)),
    (325917, (8.339, 16.281, 29.199)),
    (251194, (3.624, 10.018, 22.159)),
    (662613, (1.684, 18.903, 27.912)),
    (877294, (0.158, 18.497, 21.729)),
    (358051, (1.704, 10.282, 24.266)),
    (246207, (8.024, 19.403, 27.605)),
    (237380, (9.667, 19.971, 27.051)),
    (108976, (2.976, 16.125, 25.939)),
    (524500, (6.565, 15.353, 28.800)),
    (978421, (6.550, 19.520, 21.419)),
    (140363, (2.641, 17.530, 20.254)),
    (648370, (3.049, 14.287, 21.248)),
    (376725, (0.285, 13.866, 20.264)),
    (370441, (8.051, 14.371, 25.603)),
    (9099, (3.101, 11.265, 24.880)),
    (152312, (2.377, 13.199, 26.249)),
    (227954, (1.896, 12.593, 25.609)),
    (517702, (7.034, 14.958, 24.889)),
    (517072, (7.260, 10.575, 25.401)),
    (198787, (9.922, 14.730, 21.137)),
    (841779, (2.249, 13.916, 22.189)),
    (289302, (5.967, 11.803, 21.718)),
    (159396, (6.457, 11.374, 20.107)),
    (312533, (6.426, 15.605, 26.310)),
    (708099, (3.160, 19.733, 25.281)),
    (150654, (3.474, 14.646, 29.695)),
    (413146, (1.750, 18.218, 22.153)),
    (469603, (2.005, 14.968, 24.535)),
    (741055, (7.255, 10.977, 23.231)),
    (570102, (3.967, 19.973, 27.231)),
    (730090, (2.489, 11.611, 20.584)),
    (319035, (3.805, 13.146, 23.982)),
    (539694, (1.498, 19.704, 21.389)),
    (180218, (5.144, 13.282, 24.635)),
    (790148, (3.892, 14.324, 22.577)),
    (831757, (9.910, 13.350, 28.843)),
    (98363, (1.048, 12.033, 27.313)),
    (884116, (5.122, 10.464, 29.959)),
    (921823, (3.718, 19.683, 20.069)),
    (466622, (5.022, 14.628, 21.557)),
    (73483, (7.087, 12.261, 27.441)),
    (853222, (4.118, 13.386, 24.200)),
    (692562, (3.616, 15.384, 28.294)),
    (783936, (2.200, 14.768, 22.904)),
    (655308, (9.176, 14.086, 23.039)),
    (884383, (5.632, 15.298, 24.404)),
    (236559, (4.433, 16.946, 27.553)),
    (905461, (3.794, 15.075, 26.430)),
    (494940, (2.874, 18.082, 27.237)),
    (147242, (5.548, 18.157, 21.180)),
    (371011, (0.503, 18.331, 25.921)),
    (416398, (1.682, 16.290, 27.686)),
    (154757, (7.201, 15.460, 29.715)),
    (458539, (4.366, 11.147, 20.191)),
    (665311, (4.945, 11.699, 25.313)),
    (805419, (6.337, 18.845, 25.827)),
    (36294, (8.728, 13.022, 23.917)),
    (395782, (4.834, 11.123, 20.345)),
    (934298, (5.040, 15.962, 28.738)),
    (365801, (4.756, 12.680, 25.662)),
    (270271, (5.687, 16.909, 29.035)),
    (731906, (6.839, 10.490, 22.180)),
    (664025, (1.069, 16.620, 20.266)),
    (116323, (3.556, 16.505, 25.863)),
    (18512, (1.813, 19.041, 26.189)),
    (306582, (7.765, 19.573, 24.306)),
    (742031, (9.537, 18.477, 29.276)),
    (357579, (2.594, 14.975, 28.756)),
    (959035, (9.261, 19.358, 27.507)),
    (750324, (5.326, 17.263, 23.343)),
    (772492, (7.330, 10.945, 29.891)),
    (791217, (1.218, 13.041, 23.038)),
    (264163, (7.717, 15.400, 20.305)),
    (173293, (5.621, 19.224, 25.381)),
    (66651, (0.047, 10.184, 28.207)),
    (928110, (0.452, 19.183, 25.082)),
    (484400, (7.771, 12.205, 22.359)),
    (66847, (7.407, 13.086, 21.687)),
    (490649, (3.840, 11.884, 28.757)),
    (128268, (8.213, 16.573, 23.144)),
    (24288, (2.916, 19.214, 29.573)),
    (275175, (6.291, 18.393, 28.530)),
    (836548, (1.773, 14.178, 28.351)),
    (466863, (3.083, 15.222, 21.667)),
    (730243, (0.240, 15.800, 25.980)),
    (142369, (1.292, 17.436, 29.470)),
    (714343, (3.818, 12.706, 24.569)),
    (483326, (6.507, 13.373, 26.524)),
    (617318, (6.912, 13.399, 29.804)),
    (798831, (7.492, 14.390, 29.079)),
    (353162, (5.020, 16.487, 20.184)),
    (70591, (7.405, 14.337, 25.318)),
    (801433, (7.894, 11.316, 24.773)),
    (432459, (3.619, 12.958, 20.118)),
    (468071, (9.822, 15.627, 29.818)),
    (943728, (4.478, 14.200, 22.206)),
    (828201, (5.142, 11.450, 20.185)),
    (325521, (0.826, 17.509, 26.918)),
    (677259, (8.563, 14.166, 20.189)),
    (558899, (1.847, 18.327, 27.620)),
    (493501, (5.645, 11.777, 21.003)),
    (163104, (9.782, 17.995, 29.239)),
    (770977, (3.361, 12.336, 23.785)),
    (686307, (1.220, 16.712, 26.481)),
    (189111, (2.648, 12.772, 24.672)),
    (229319, (1.692, 11.087, 22.713)),
    (167776, (2.016, 15.529, 27.403)),
    (485746, (5.176, 16.719, 20.547)),
    (720301, (3.225, 14.775, 25.592)),
    (109818, (0.970, 13.430, 25.959)),
    (94034, (0.021, 10.738, 29.264)),
    (739067, (1.032, 13.073, 23.227)),
    (335147, (0.077, 13.027, 26.075)),
    (828393, (0.782, 13.438, 26.611)),
    (186291, (1.332, 13.351, 28.257)),
    (979180, (1.953, 15.514, 21.955)),
    (976162, (6.197, 16.215, 28.220)),
    (212840, (1.769, 15.310, 25.084)),
    (856616, (8.933, 13.676, 27.887)),
    (929017, (5.951, 17.112, 29.816)),
    (371800, (5.879, 11.506, 22.504)),
    (702740, (0.680, 12.181, 24.808)),
    (934207, (3.888, 16.197, 22.415)),
    (774863, (1.497, 14.177, 20.563)),
    (889494, (6.408, 15.698, 29.588)),
    (446191, (0.431, 18.569, 26.643)),
    (505131, (3.283, 12.887, 20.876)),
    (655147, (0.060, 10.289, 27.970)),
    (349224, (0.722, 19.511, 20.278)),
    (542430, (6.011, 19.961, 21.046)),
    (654541, (3.976, 18.004, 20.500)),
    (734924, (8.396, 13.137, 27.805)),
    (518526, (2.613, 15.523, 24.860)),
    (593003, (4.365, 13.710, 23.660)),
    (441226, (4.345, 13.255, 28.961)),
    (106942, (1.614, 15.230, 20.743)),
    (40350, (6.074, 18.454, 26.122)),
    (851593, (6.112, 18.495, 28.464)),
    (862503, (1.395, 16.109, 27.981)),
    (576971, (0.126, 18.305, 28.552)),
    (442872, (4.978, 16.760, 24.526)),
    (604838, (6.842, 14.986, 25.078)),
    (322264, (0.676, 11.848, 23.537)),
    (164338, (7.002, 11.793, 24.684)),
    (224777, (6.459, 19.686, 28.613)),
    (645442, (0.899, 11.511, 23.391)),
    (605140, (3.940, 18.628, 29.767)),
    (273433, (1.621, 11.949, 26.108)),
    (520434, (0.527, 10.345, 28.996)),
    (168021, (7.240, 17.673, 20.628)),
    (206190, (5.664, 11.532, 20.203)),
    (10742, (9.430, 10.797, 23.757)),
    (768953, (3.032, 18.712, 24.481)),
    (856190, (4.480, 15.662, 20.833)),
    (116633, (3.987, 13.066, 27.405)),
    (365047, (2.334, 13.001, 28.021)),
    (322688, (4.192, 16.233, 24.227)),
    (279450, (0.821, 18.946, 23.371)),
    (665631, (4.934, 10.318, 24.484)),
    (498922, (9.182, 19.377, 21.355)),
    (934600, (4.463, 13.286, 27.418)),
    (680031, (0.370, 12.801, 21.056)),
    (85599, (2.153, 19.358, 22.500)),
    (758670, (1.292, 14.509, 28.109)),
    (163703, (5.129, 15.914, 26.101)),
    (725560, (4.385, 14.978, 28.736)),
    (806508, (7.920, 16.396, 29.967)),
    (538031, (3.564, 13.739, 26.088)),
    (491257, (1.043, 19.687, 24.455)),
    (917685, (2.706, 19.416, 28.200)),
    (613135, (1.511, 15.819, 23.289)),
    (685350, (3.130, 16.610, 26.824)),
    (588090, (0.869, 14.320, 24.455)),
    (369139, (2.563, 10.005, 27.548)),
    (95086, (0.498, 14.482, 21.940)),
    (325403, (7.687, 18.571, 27.579)),
    (153170, (9.128, 15.794, 25.789)),
    (422251, (5.444, 10.559, 24.800)),
    (624198, (8.790, 18.789, 27.973)),
    (476746, (4.680, 14.612, 24.334)),
    (54303, (3.240, 12.356, 26.190)),
    (988919, (6.002, 19.418, 26.408)),
    (527527, (3.091, 14.476, 27.751)),
    (329951, (1.801, 15.935, 22.662)),
    (332001, (0.547, 14.853, 27.959)),
    (63188, (2.481, 12.487, 23.239)),
    (776444, (4.369, 10.213, 27.636)),
    (106575, (6.572, 15.743, 22.998)),
    (412911, (6.674, 17.587, 29.069)),
    (320883, (5.184, 10.933, 28.049)),
    (138347, (3.682, 11.994, 23.678)),
    (47966, (1.927, 19.233, 25.881)),
    (672318, (5.248, 10.986, 28.358)),
    (309551, (4.556, 19.252, 28.946)),
    (655971, (3.589, 17.641, 21.426)),
    (509546, (0.655, 18.702, 26.893)),
    (347468, (1.973, 15.062, 23.341)),
    (120226, (1.408, 17.653, 26.597)),
    (436738, (8.827, 14.911, 26.764)),
    (51691, (0.302, 13.736, 28.447)),
    (513511, (0.876, 10.394, 23.154)),
    (632043, (0.263, 13.868, 27.229)),
    (729546, (6.606, 11.652, 20.088)),
    (261894, (8.948, 17.566, 28.203)),
    (863784, (0.109, 12.865, 21.873)),
    (91688, (5.458, 18.702, 23.575)),
    (121541, (6.031, 15.263, 22.326)),
    (275172, (8.876, 17.204, 29.206)),
    (922806, (9.654, 19.565, 27.505)),
    (650404, (3.382, 16.715, 21.062)),
    (17318, (9.227, 14.520, 24.653)),
    (908045, (7.660, 15.026, 21.020)),
    (214226, (6.436, 15.454, 22.545)),
    (967220, (8.247, 13.035, 27.118)),
    (217405, (5.905, 13.108, 29.603)),
    (479613, (5.174, 15.960, 29.074)),
    (570978, (2.317, 17.446, 23.645)),
    (957439, (2.963, 10.650, 29.976)),
    (594987, (8.612, 19.850, 22.568)),
    (95355, (0.721, 16.362, 27.595)),
    (929063, (7.943, 12.431, 27.247)),
    (392443, (2.458, 17.891, 27.320)),
    (838286, (4.430, 13.366, 20.989)),
    (644019, (5.136, 16.198, 25.474)),
    (695542, (7.258, 17.156, 26.226)),
    (915793, (8.873, 12.874, 20.188)),
    (963746, (7.330, 13.912, 26.289)),
    (70546, (1.331, 18.569, 22.362)),
    (867605, (5.866, 14.523, 24.593)),
    (226636, (7.316, 10.372, 29.541)),
    (955919, (1.320, 10.818, 26.666)),
    (940308, (5.820, 19.571, 24.338)),
    (712693, (7.807, 17.690, 20.805)),
    (613340, (6.507, 16.092, 22.892)),
    (374452, (6.332, 10.294, 20.261)),
    (376485, (6.050, 14.767, 24.839)),
    (514015, (1.839, 10.833, 21.120)),
    (214391, (9.533, 19.152, 28.599)),
    (632452, (2.146, 10.749, 20.553)),
    (115830, (9.480, 13.585, 28.794)),
    (750007, (6.807, 14.653, 21.595)),
    (956826, (3.209, 17.219, 27.203)),
    (125020, (2.365, 19.084, 25.241)),
    (218666, (8.137, 17.979, 21.862)),
    (443094, (2.836, 15.671, 26.525)),
    (274414, (1.536, 17.833, 27.829)),
    (344322, (5.184, 19.867, 27.035)),
    (57971, (7.491, 13.152, 20.073)),
    (407290, (7.986, 16.845, 22.921)),
    (754151, (6.306, 10.306, 27.663)),
    (648273, (6.870, 13.096, 25.917)),
    (327826, (1.371, 10.780, 20.042)),
    (456179, (5.817, 14.262, 21.557)),
    (232764, (0.678, 11.832, 23.681)),
    (337013, (4.702, 18.122, 24.757)),
    (248299, (8.238, 10.228, 21.228)),
    (778779, (4.380, 10.353, 21.261)),
    (193292, (4.802, 13.752, 21.028)),
    (369196, (8.066, 14.389, 26.086)),
    (584233, (5.299, 12.041, 25.872)),
    (916055, (0.382, 15.061, 29.275)),
    (529104, (7.234, 16.238, 28.818)),
    (94916, (5.222, 15.522, 25.877)),
    (169586, (4.173, 18.938, 20.815)),
    (241668, (0.068, 16.558, 28.839)),
    (776900, (8.253, 14.551, 26.210)),
    (867791, (4.341, 14.825, 27.049)),
    (448896, (8.217, 17.774, 22.449)),
    (420057, (9.965, 10.212, 29.882)),
    (396721, (2.733, 16.728, 27.172)),
    (960928, (4.434, 10.445, 23.431)),
    (568827, (6.432, 12.038, 21.964)),
    (206882, (1.186, 13.844, 20.633)),
    (733439, (8.870, 18.675, 21.662)),
    (38233, (4.750, 16.212, 27.752)),
    (74240, (6.179, 17.389, 20.662)),
    (547463, (9.770, 14.548, 26.291)),
    (923616, (3.098, 18.036, 29.881)),
    (910583, (4.957, 19.803, 27.419)),
    (39296, (3.464, 17.360, 29.663)),
    (649140, (2.957, 13.286, 22.134)),
    (958327, (1.395, 12.444, 20.788)),
    (22524, (9.700, 19.096, 21.470)),
    (491334, (3.867, 19.827, 21.786)),
    (508138, (7.710, 15.959, 27.126)),
    (214901, (3.436, 19.238, 26.445)),
    (140647, (2.781, 16.566, 20.022)),
    (82065, (2.267, 19.878, 23.330)),
    (321610, (1.452, 10.783, 20.092)),
    (70158, (6.724, 12.751, 23.790)),
    (621867, (5.084, 11.205, 23.035)),
    (431465, (8.964, 14.691, 28.329)),
    (985095, (6.143, 11.942, 28.585)),
    (166465, (6.227, 12.950, 24.550)),
    (470071, (0.498, 16.627, 22.599)),
    (63468, (6.535, 11.201, 21.549)),
    (992515, (3.786, 10.427, 24.410)),
    (865131, (7.871, 16.398, 28.516)),
    (684881, (0.766, 19.242, 27.970)),
    (49184, (5.678, 19.096, 22.878)),
    (295685, (4.831, 10.653, 28.357)),
    (410895, (4.953, 12.544, 25.402)),
    (441999, (4.756, 14.598, 22.673)),
    (742990, (2.084, 19.591, 27.468)),
    (629668, (8.802, 18.626, 22.362)),
    (739761, (0.177, 18.594, 25.265)),
    (546406, (5.190, 12.807, 20.722)),
    (230826, (2.859, 11.693, 22.870)),
    (893416, (6.497, 13.952, 28.277)),
    (121281, (9.529, 11.845, 25.070)),
    (273678, (4.685, 18.806, 23.991)),
    (379977, (2.016, 12.468, 28.354)),
    (33245, (7.970, 19.154, 20.731)),
    (261835, (0.459, 10.371, 23.845)),
    (314334, (7.412, 16.044, 25.825)),
    (343325, (6.834, 15.932, 29.948)),
    (263934, (2.403, 14.842, 22.642)),
    (382692, (5.292, 10.414, 28.381)),
    (564713, (9.892, 19.162, 24.003)),
    (589971, (3.138, 18.525, 22.116)),
    (572759, (3.852, 17.734, 24.917)),
    (609512, (6.196, 18.601, 26.423)),
    (72802, (2.363, 14.108, 29.694)),
    (666171, (8.856, 12.015, 23.855)),
    (874126, (2.185, 11.231, 25.473)),
    (452839, (9.371, 11.070, 24.295)),
    (144704, (4.078, 19.474, 22.224)),
    (329241, (9.596, 15.143, 26.246)),
    (836550, (6.325, 17.112, 22.772)),
    (184965, (1.043, 14.365, 21.333)),
    (726145, (5.430, 14.001, 21.672)),
    (701681, (8.322, 11.157, 28.816)),
    (33869, (0.451, 14.167, 24.983)),
    (531982, (5.178, 16.737, 23.446)),
    (739206, (0.106, 10.855, 27.453)),
    (687647, (0.917, 13.169, 26.429)),
    (921024, (7.978, 17.515, 29.902)),
    (564180, (8.435, 10.250, 26.055)),
    (371606, (1.706, 19.464, 29.866)),
    (349201, (6.792, 14.984, 26.104)),
    (713505, (5.587, 18.293, 26.546)),
    (444653, (8.822, 13.977, 24.842)),
    (238666, (4.112, 15.743, 25.439)),
    (73900, (8.341, 13.066, 22.064)),
    (256579, (5.494, 17.889, 24.131)),
    (707236, (2.134, 16.254, 28.369)),
    (238432, (0.564, 18.434, 25.064)),
    (921628, (0.253, 11.553, 26.394)),
    (889211, (0.796, 17.794, 21.957)),
    (432519, (7.952, 12.668, 27.487)),
    (871149, (8.746, 16.640, 29.625)),
    (806501, (3.310, 15.591, 22.419)),
    (192354, (4.549, 19.425, 24.517)),
    (23214, (7.837, 15.159, 24.963)),
    (751015, (2.757, 11.359, 29.491)),
    (384558, (3.305, 11.140, 23.010)),
    (716759, (0.478, 17.060, 25.717)),
    (446498, (1.620, 11.728, 26.488)),
    (145258, (4.599, 11.720, 25.995)),
    (158090, (9.767, 14.790, 20.610)),
    (918062, (6.219, 11.385, 24.047)),
    (612841, (0.459, 16.609, 24.131)),
    (238280, (1.386, 18.453, 29.406)),
    (760107, (1.166, 17.076, 26.532)),
    (807470, (4.909, 11.396, 20.651)),
    (467127, (5.460, 17.086, 20.319)),
    (263782, (3.914, 14.972, 29.485)),
    (853610, (8.151, 18.770, 24.919)),
    (112152, (7.689, 15.399, 26.510)),
    (436657, (9.004, 17.224, 27.853)),
    (961483, (5.162, 14.145, 24.338)),
    (616326, (9.741, 14.884, 22.431)),
    (557819, (5.344, 16.204, 26.849)),
    (778660, (7.642, 14.490, 25.268)),
    (779227, (0.557, 19.661, 20.247)),
    (861559, (9.235, 17.223, 28.610)),
    (861549, (3.446, 10.313, 21.986)),
    (113136, (9.769, 15.884, 21.106)),
    (432957, (0.105, 19.108, 23.526)),
    (191180, (5.591, 16.153, 26.019)),
    (327254, (8.394, 12.457, 24.875)),
    (1125, (0.954, 15.801, 26.396)),
    (41794, (5.822, 12.684, 27.120)),
    (366536, (9.684, 10.828, 24.906)),
    (870017, (1.222, 14.654, 27.509)),
    (112663, (0.940, 12.362, 27.964)),
    (512090, (1.293, 17.090, 29.997)),
    (76500, (8.737, 19.069, 26.060)),
    (40726, (8.521, 15.775, 26.841)),
    (397633, (6.999, 11.943, 22.246)),
    (516270, (6.237, 11.260, 27.157)),
    (802832, (8.825, 17.730, 23.704)),
    (537891, (7.599, 16.671, 29.728)),
    (181887, (0.842, 14.948, 24.687)),
    (794262, (8.485, 13.453, 20.268)),
    (151009, (5.728, 13.693, 27.726)),
    (315945, (6.015, 17.607, 28.294)),
    (808728, (2.717, 14.262, 21.208)),
    (720976, (5.780, 16.909, 20.519)),
    (544625, (3.395, 19.060, 24.677)),
    (362583, (2.952, 13.917, 29.784)),
    (78244, (5.826, 11.351, 27.874)),
    (310914, (4.655, 18.742, 23.008)),
    (519456, (6.445, 13.248, 21.103)),
    (448012, (8.691, 17.823, 25.641)),
    (991711, (5.654, 16.882, 23.968)),
    (896469, (7.057, 16.821, 29.327)),
    (325839, (9.307, 17.210, 28.096)),
    (215102, (5.236, 11.374, 26.726)),
    (583485, (6.090, 17.936, 24.098)),
    (111793, (7.811, 17.899, 29.632)),
    (817632, (1.194, 17.726, 24.238)),
    (650028, (6.010, 11.458, 26.334)),
    (907282, (4.037, 17.014, 21.992)),
    (804684, (0.204, 14.234, 20.891)),
    (537682, (8.547, 16.037, 27.634)),
    (31880, (3.459, 18.497, 23.940)),
    (876362, (4.452, 16.465, 27.084)),
    (706148, (9.992, 14.637, 23.507)),
    (603019, (9.058, 10.092, 25.747)),
    (425195, (4.142, 17.952, 27.740)),
    (339661, (4.073, 15.340, 22.966)),
    (670819, (3.157, 13.345, 22.863)),
    (633290, (0.606, 15.846, 21.876)),
    (642582, (1.591, 10.831, 20.726)),
    (808275, (4.569, 14.313, 21.660)),
    (390456, (3.967, 19.839, 29.724)),
    (328500, (0.089, 16.174, 20.646)),
    (809759, (9.734, 17.629, 29.506)),
    (604733, (7.395, 10.867, 28.725)),
    (290580, (1.631, 10.343, 27.471)),
    (24860, (6.653, 11.897, 26.889)),
    (598087, (0.737, 13.602, 22.455)),
    (986694, (6.296, 14.148, 24.583)),
    (992889, (1.322, 10.835, 22.111)),
    (138840, (9.002, 18.355, 29.193)),
    (924392, (4.661, 15.115, 26.607)),
    (804891, (1.795, 12.081, 20.961)),
    (891687, (0.210, 14.812, 25.818)),
    (112536, (8.440, 18.821, 24.044)),
    (520094, (8.487, 16.206, 24.854)),
    (249514, (8.235, 17.129, 28.958)),
    (418024, (8.894, 14.990, 24.055)),
    (144233, (0.328, 10.269, 21.632)),
    (437351, (7.783, 13.459, 20.644)),
    (258806, (9.584, 17.026, 29.788)),
    (699030, (1.706, 11.690, 24.244)),
    (249067, (9.504, 16.739, 25.640)),
    (329065, (1.967, 13.607, 26.838)),
    (982746, (8.057, 12.194, 25.455)),
    (686764, (8.508, 16.773, 29.301)),
    (213632, (9.636, 15.068, 28.420)),
    (546025, (6.725, 10.341, 24.067)),
    (99191, (1.720, 13.348, 24.861)),
    (124230, (5.702, 19.925, 22.978)),
    (223329, (4.350, 15.887, 20.446)),
    (630323, (0.049, 10.358, 22.544)),
    (506792, (7.952, 19.236, 22.153)),
    (811125, (9.350, 12.900, 27.394)),
    (375362, (5.316, 15.408, 29.618)),
    (162115, (8.118, 15.095, 25.733)),
    (212191, (4.482, 15.219, 21.293)),
    (541383, (2.881, 19.379, 29.730)),
    (855780, (0.832, 17.137, 25.751)),
    (561368, (0.203, 15.353, 29.982)),
    (270361, (5.042, 17.760, 27.218)),
    (523623, (8.898, 10.603, 29.480)),
    (34017, (7.495, 11.759, 22.567)),
    (835946, (0.572, 14.738, 20.447)),
    (895978, (1.374, 14.436, 29.630)),
    (739104, (6.186, 19.808, 22.871)),
    (991621, (1.813, 13.187, 29.278)),
    (704391, (0.495, 17.127, 24.979)),
    (627354, (8.900, 19.284, 25.687)),
    (595549, (3.812, 17.546, 25.530)),
    (706757, (3.944, 12.510, 22.260)),
    (411848, (2.640, 15.612, 20.182)),
    (428947, (6.984, 11.827, 26.768)),
    (315638, (9.509, 13.069, 20.358)),
    (143696, (8.182, 11.117, 25.431)),
    (433865, (5.254, 17.066, 21.533)),
    (590816, (3.903, 17.584, 26.480)),
    (896583, (2.938, 14.451, 27.162)),
    (787841, (9.056, 13.950, 23.186)),
    (786151, (2.319, 15.855, 25.871)),
    (443524, (3.958, 15.662, 23.694)),
    (947896, (3.617, 15.860, 23.189)),
    (897329, (7.512, 19.028, 22.129)),
    (520654, (9.020, 16.858, 22.255)),
    (89063, (5.523, 15.757, 23.754)),
    (272721, (3.887, 13.090, 21.949)),
    (124207, (4.419, 12.329, 22.524)),
    (256162, (2.280, 15.858, 27.436)),
    (880185, (8.758, 11.822, 21.701)),
    (970910, (0.009, 17.043, 20.045)),
    (876684, (0.431, 13.707, 23.863)),
    (792321, (8.032, 12.143, 23.452)),
    (612730, (6.830, 14.553, 27.667)),
    (70463, (0.138, 10.097, 25.731)),
    (368686, (0.412, 18.326, 27.086)),
    (441277, (3.330, 13.985, 26.531)),
    (998062, (5.340, 19.602, 24.573)),
    (802282, (1.553, 16.169, 24.104)),
    (209195, (1.088, 13.233, 25.684)),
    (917127, (3.261, 13.023, 24.551)),
    (618266, (2.525, 12.769, 20.236)),
    (743658, (2.446, 11.477, 23.826)),
    (26003, (0.603, 19.050, 24.640)),
    (881876, (1.823, 14.133, 24.239)),
    (423836, (3.519, 18.466, 25.334)),
    (787110, (4.624, 11.036, 24.833)),
    (54286, (3.887, 16.398, 28.410)),
    (106111, (3.322, 18.586, 24.369)),
    (486605, (5.285, 11.614, 21.311)),
    (197743, (9.204, 18.299, 20.172)),
    (389920, (7.256, 10.552, 24.562)),
    (789521, (4.184, 11.012, 25.405)),
    (361808, (5.350, 15.582, 27.459)),
    (979354, (4.679, 17.042, 28.300)),
    (70133, (2.249, 10.653, 25.186)),
    (215152, (9.455, 11.872, 21.880)),
    (126382, (9.270, 12.128, 24.923)),
    (231421, (3.308, 11.368, 24.950)),
    (479992, (4.878, 13.942, 20.225)),
    (452086, (7.517, 18.208, 28.707)),
    (329743, (8.016, 14.955, 22.667)),
    (400714, (0.336, 11.989, 22.042)),
    (454327, (8.448, 17.408, 28.234)),
    (758784, (8.662, 17.443, 25.415)),
    (860526, (5.685, 18.103, 24.061)),
    (936198, (3.020, 18.925, 24.281)),
    (255378, (0.489, 11.087, 22.264)),
    (527715, (5.190, 16.070, 21.642)),
    (374355, (7.123, 11.535, 23.690)),
    (530316, (1.854, 19.249, 25.502)),
    (121266, (6.645, 15.926, 23.413)),
    (300968, (4.047, 10.094, 27.036)),
    (739159, (1.240, 10.045, 27.411)),
    (6838, (4.973, 10.262, 23.154)),
    (430857, (2.102, 15.881, 22.743)),
    (360078, (3.334, 10.339, 24.540)),
    (82078, (8.264, 19.491, 27.666)),
    (470555, (1.039, 12.707, 21.648)),
    (487110, (1.208, 13.679, 20.490)),
    (480581, (9.428, 12.275, 22.812)),
    (750803, (3.566, 19.194, 27.750)),
    (351124, (4.607, 16.077, 24.030)),
    (306272, (6.766, 13.095, 29.572)),
    (249428, (6.289, 14.065, 28.755)),
    (738734, (6.776, 18.626, 28.453)),
    (419927, (3.541, 14.638, 22.755)),
    (288672, (2.995, 18.750, 23.316)),
    (540641, (0.004, 10.511, 24.984)),
    (797392, (2.963, 14.908, 27.467)),
    (944363, (5.557, 19.694, 24.841)),
    (914972, (9.270, 11.577, 21.526)),
    (456516, (1.454, 17.335, 26.245)),
    (659056, (9.397, 16.871, 23.457)),
    (335879, (8.842, 18.171, 21.246)),
    (149888, (2.274, 18.150, 27.156)),
    (453274, (7.298, 18.601, 20.614)),
    (46993, (9.086, 14.899, 27.011)),
    (245143, (4.189, 11.406, 27.753)),
    (165178, (3.097, 12.838, 27.431)),
    (975209, (4.349, 17.350, 23.243)),
    (638145, (8.621, 16.127, 20.416)),
    (629626, (7.786, 11.886, 21.154)),
    (366580, (6.493, 10.357, 24.920)),
    (253606, (2.242, 14.879, 20.380)),
    (791046, (3.364, 15.426, 29.177)),
    (166965, (0.922, 11.855, 24.882)),
    (509643, (2.915, 17.253, 21.401)),
    (437947, (3.024, 18.991, 24.026)),
    (25951, (0.757, 17.986, 27.246)),
    (675334, (2.696, 19.950, 28.234)),
    (141415, (8.055, 18.683, 26.523)),
    (881205, (0.949, 19.299, 26.888)),
    (502294, (7.811, 15.493, 20.403)),
    (272148, (9.362, 17.363, 26.946)),
    (496826, (6.082, 14.189, 28.887)),
    (812355, (1.640, 10.551, 24.584)),
    (545824, (9.937, 19.769, 22.605)),
    (780212, (5.092, 12.829, 24.312)),
    (972091, (6.047, 15.206, 25.117)),
    (366649, (8.890, 15.620, 28.225)),
    (488262, (1.126, 16.606, 27.683)),
    (553430, (0.900, 17.804, 24.879)),
    (540151, (5.345, 19.780, 29.601)),
    (121671, (6.659, 19.394, 29.110)),
    (20324, (5.541, 12.589, 24.923)),
    (698429, (3.238, 17.742, 28.739)),
    (841308, (7.557, 11.499, 21.155)),
    (149319, (4.079, 14.655, 21.055)),
    (891731, (1.861, 11.727, 29.298)),
    (179612, (4.477, 12.717, 29.028)),
    (939174, (2.744, 18.457, 29.002)),
    (382691, (8.302, 17.797, 24.570)),
    (307819, (8.941, 11.873, 28.377)),
    (118581, (5.266, 14.061, 27.403)),
    (492086, (4.859, 16.227, 29.967)),
    (171409, (3.084, 15.062, 26.597)),
    (886150, (1.157, 10.969, 29.782)),
    (272979, (1.529, 16.168, 20.763)),
    (232244, (6.341, 15.180, 26.103)),
    (625359, (4.334, 19.405, 21.193)),
    (419254, (8.167, 17.056, 26.911)),
    (294690, (5.774, 14.543, 24.738)),
    (701264, (4.627, 13.189, 20.647)),
    (905986, (0.772, 12.334, 26.511)),
    (671361, (0.222, 14.355, 21.129)),
    (974928, (8.321, 17.955, 23.033)),
    (101517, (3.244, 16.677, 29.055)),
    (481441, (9.468, 16.778, 21.822)),
    (195570, (3.714, 12.968, 28.723)),
    (782216, (6.927, 11.630, 24.390)),
    (465653, (4.671, 11.195, 22.387)),
    (61797, (6.441, 17.721, 24.357)),
    (274215, (0.627, 15.136, 25.022)),
    (561025, (7.396, 16.907, 21.463)),
    (944310, (6.869, 10.296, 23.832)),
    (955334, (3.870, 13.757, 28.275)),
    (947268, (3.596, 18.638, 22.036)),
    (581910, (3.886, 10.394, 29.358)),
    (295691, (4.835, 14.790, 25.989)),
    (614984, (4.130, 14.281, 23.783)),
    (223472, (3.015, 12.368, 24.106)),
    (1139, (6.171, 19.570, 29.243)),
    (202360, (3.109, 13.360, 23.237)),
    (425333, (4.253, 12.046, 22.141)),
    (914062, (1.000, 14.108, 22.663)),
    (298398, (7.401, 16.753, 28.214)),
    (883190, (2.832, 10.932, 26.460)),
    (461590, (7.206, 14.330, 26.284)),
    (208196, (8.549, 17.128, 28.210)),
    (349598, (4.737, 18.849, 23.712)),
    (79513, (8.086, 13.388, 25.675)),
    (307040, (2.913, 19.790, 27.201)),
    (998047, (7.096, 14.222, 26.612)),
    (879824, (6.076, 17.739, 20.388)),
    (378130, (6.023, 10.461, 21.727)),
    (983150, (6.895, 18.858, 25.592)),
    (832142, (1.579, 14.245, 25.992)),
    (923707, (9.889, 15.638, 25.143)),
    (370416, (5.843, 11.289, 23.320)),
    (121700, (4.968, 19.805, 23.347)),
    (962613, (2.035, 17.040, 27.141)),
    (860513, (8.224, 15.738, 22.588)),
    (526165, (2.565, 10.019, 25.087)),
    (624933, (1.567, 16.182, 28.100)),
    (217354, (1.566, 15.646, 21.365)),
    (119662, (0.606, 13.348, 28.860)),
    (353737, (5.776, 18.903, 22.284)),
    (907158, (9.653, 13.261, 20.213)),
    (138030, (3.736, 11.392, 20.525)),
    (27958, (6.314, 15.367, 25.560)),
    (858134, (5.106, 14.846, 24.132)),
    (671913, (2.991, 16.688, 27.439)),
    (503956, (3.292, 13.474, 23.551)),
    (653451, (6.858, 13.692, 27.876)),
    (940988, (6.888, 13.070, 27.988)),
    (830890, (4.617, 13.838, 27.441)),
    (68024, (2.716, 14.495, 22.999)),
    (930994, (9.671, 11.757, 21.335)),
    (430407, (6.826, 11.744, 25.968)),
    (838485, (3.992, 12.564, 26.745)),
    (964947, (5.653, 10.194, 26.344)),
    (688882, (1.583, 15.565, 20.050)),
    (109941, (0.085, 16.399, 28.942)),
    (501136, (9.783, 19.522, 27.646)),
    (37414, (1.470, 12.530, 27.840)),
    (632089, (8.364, 19.119, 28.420)),
    (686487, (6.977, 15.961, 20.115)),
    (744470, (2.205, 15.258, 29.823)),
    (883850, (2.082, 18.891, 26.284)),
    (826051, (3.888, 10.252, 21.368)),
    (236535, (5.755, 16.241, 25.836)),
    (924388, (2.982, 13.785, 29.906)),
    (271976, (3.237, 17.052, 20.267)),
    (148840, (2.880, 13.509, 28.131)),
    (818739, (6.961, 14.266, 21.504)),
    (700548, (4.331, 11.683, 20.697)),
    (936348, (6.516, 15.963, 27.733)),
    (436799, (0.094, 14.643, 27.243)),
    (975354, (6.075, 14.441, 21.408)),
    (816493, (8.024, 16.850, 29.947)),
    (889045, (4.828, 17.495, 20.608)),
    (170339, (7.265, 15.862, 28.373)),
    (533642, (5.126, 11.327, 24.515)),
    (295667, (9.632, 10.062, 20.108)),
    (702516, (6.923, 11.806, 24.391)),
    (507340, (6.540, 18.894, 25.190)),
    (879608, (4.362, 17.447, 22.941)),
    (190057, (8.405, 14.106, 22.345)),
    (44264, (6.758, 13.547, 20.185)),
    (768921, (7.479, 13.638, 20.929)),
    (467902, (4.604, 17.481, 22.205)),
    (200405, (5.829, 17.590, 27.243)),
    (317468, (4.313, 17.548, 29.437)),
    (508214, (9.616, 13.456, 25.305)),
    (246250, (0.305, 16.547, 22.675)),
    (79770, (3.745, 12.165, 25.611)),
    (459653, (9.358, 17.431, 25.994)),
    (632983, (9.352, 16.727, 21.837)),
    (132656, (7.085, 17.729, 20.749)),
    (236563, (7.506, 10.585, 28.348)),
    (876849, (3.134, 16.955, 22.743)),
    (206676, (2.330, 14.031, 29.088)),
    (492409, (6.722, 15.799, 22.282)),
    (944224, (5.628, 12.177, 25.661)),
    (289498, (9.674, 16.058, 29.910)),
    (406127, (5.480, 14.545, 26.282)),
    (771397, (7.234, 10.958, 21.911)),
    (976969, (5.106, 14.997, 28.413)),
    (925940, (0.057, 18.174, 29.208)),
    (138040, (5.743, 15.405, 29.210)),
    (176890, (2.069, 14.557, 22.998)),
    (876569, (2.546, 17.296, 26.157)),
    (673298, (7.203, 15.609, 25.017)),
    (12100, (7.982, 13.645, 28.097)),
    (350811, (1.010, 14.490, 28.995)),
    (864693, (4.377, 14.665, 25.014)),
    (298923, (1.762, 14.545, 24.747)),
    (42641, (2.864, 15.321, 28.899)),
    (844018, (2.095, 17.684, 26.779)),
    (896364, (9.310, 17.858, 26.815)),
    (995039, (3.243, 13.887, 28.132)),
    (512812, (5.372, 17.394, 29.918)),
    (727789, (6.686, 17.546, 27.610)),
    (415415, (2.175, 16.581, 24.848)),
    (242544, (8.858, 13.479, 23.347)),
    (214621, (7.669, 16.111, 21.281)),
    (856308, (9.877, 14.879, 27.231)),
    (121209, (5.137, 18.740, 26.573)),
    (757560, (8.542, 16.200, 23.655)),
    (432878, (4.540, 13.710, 23.195)),
    (196406, (7.679, 14.888, 29.646)),
    (992950, (0.796, 19.753, 26.448)),
    (242927, (4.093, 10.818, 26.824)),
    (990348, (8.391, 15.329, 26.241)),
    (653944, (7.329, 19.087, 26.751)),
    (245455, (9.845, 16.944, 24.647)),
    (866821, (5.343, 17.252, 27.275)),
    (354948, (7.897, 15.079, 28.374)),
    (789314, (9.673, 17.288, 20.669)),
    (237574, (3.105, 18.916, 26.718)),
    (581813, (2.172, 11.608, 20.640)),
    (582313, (2.062, 17.711, 22.618)),
    (662320, (2.435, 19.269, 20.854)),
    (518346, (8.559, 16.409, 27.806)),
    (519703, (9.142, 16.716, 27.742)),
    (81655, (8.129, 17.494, 29.352)),
    (768171, (0.691, 11.371, 22.102)),
    (55132, (7.133, 11.153, 23.967)),
    (15241, (4.208, 14.253, 29.162)),
    (76960, (3.883, 10.757, 23.513)),
    (874409, (4.853, 19.988, 25.988)),
    (727689, (4.129, 11.844, 23.128)),
    (679898, (0.421, 11.053, 29.963)),
    (644463, (1.109, 12.382, 24.656)),
    (433397, (8.625, 11.489, 27.608)),
    (194189, (0.627, 15.171, 29.605)),
    (929505, (6.113, 12.230, 26.085)),
    (895475, (6.245, 16.195, 20.529)),
    (632813, (1.990, 12.385, 29.890)),
    (471123, (8.764, 12.066, 21.984)),
    (287296, (0.212, 19.014, 24.480)),
    (732859, (0.245, 16.796, 27.403)),
    (109049, (5.893, 18.394, 25.251)),
    (466074, (0.118, 13.086, 25.106)),
    (575496, (6.754, 18.759, 21.386)),
    (593484, (1.704, 13.426, 23.689)),
    (757710, (3.349, 11.920, 24.947)),
    (339074, (4.706, 13.454, 20.108)),
    (944007, (3.992, 17.590, 28.600)),
    (820495, (1.588, 11.234, 21.485)),
    (613001, (4.432, 15.855, 29.853)),
    (977171, (0.914, 10.040, 25.725)),
    (714585, (3.417, 16.005, 24.819)),
    (660166, (4.417, 18.180, 25.490)),
    (291108, (8.254, 15.480, 27.883)),
    (155591, (3.002, 11.295, 25.747)),
    (223017, (0.166, 15.532, 22.077)),
    (861702, (2.026, 16.471, 23.004)),
    (801816, (5.972, 14.161, 29.210)),
    (166384, (2.738, 13.460, 22.787)),
    (697335, (7.521, 13.965, 28.689)),
    (25148, (1.533, 17.281, 21.699)),
    (773314, (4.548, 12.457, 21.788)),
    (439568, (5.303, 15.313, 21.906)),
    (446792, (4.803, 11.588, 20.536)),
    (910384, (8.037, 11.762, 27.220)),
    (43947, (2.318, 11.256, 28.947)),
    (43962, (5.492, 11.899, 24.348)),
    (432275, (3.808, 10.346, 22.867)),
    (72195, (1.583, 10.885, 29.462)),
    (655271, (3.790, 10.374, 23.298)),
    (164388, (2.539, 15.054, 23.632)),
    (286440, (0.726, 10.373, 29.552)),
    (59392, (5.938, 10.804, 21.141)),
    (588158, (8.967, 14.425, 25.876)),
    (5130, (0.373, 12.392, 21.556)),
    (605157, (7.161, 13.337, 29.525)),
    (638020, (4.942, 14.400, 22.833)),
    (270543, (4.150, 12.081, 24.027)),
    (944132, (0.850, 16.972, 22.125)),
    (937772, (0.387, 14.071, 22.914)),
    (788394, (8.888, 11.643, 26.692)),
    (445162, (1.125, 16.563, 25.343)),
    (256477, (7.432, 15.707, 21.158)),
    (843510, (5.526, 10.030, 28.995)),
    (893401, (2.553, 15.146, 28.842)),
    (927703, (3.003, 17.822, 22.359)),
    (53519, (3.212, 14.912, 27.280)),
    (726342, (9.159, 11.488, 22.506)),
    (465502, (9.076, 16.402, 21.554)),
    (575252, (5.491, 18.251, 24.034)),
    (523825, (6.982, 19.661, 25.052)),
    (416831, (1.725, 15.137, 20.405)),
    (771033, (2.857, 10.201, 25.176)),
    (993100, (7.451, 16.444, 20.280)),
    (648628, (3.266, 14.699, 22.378)),
    (155024, (0.655, 10.266, 28.460)),
    (548984, (9.938, 15.546, 29.066)),
    (660081, (8.846, 17.560, 21.798)),
    (973036, (2.122, 12.614, 20.401)),
    (190401, (4.698, 11.603, 26.072)),
    (348261, (4.897, 10.205, 28.768)),
    (88073, (0.388, 12.788, 25.545)),
    (529878, (2.856, 14.939, 27.800)),
    (69583, (6.632, 10.677, 20.487)),
    (398077, (7.522, 13.506, 21.563)),
    (605590, (8.383, 15.432, 29.213)),
    (92099, (4.829, 10.711, 26.263)),
    (361657, (0.436, 14.284, 24.698)),
    (740774, (2.154, 13.963, 22.457)),
    (564674, (3.967, 17.982, 24.376)),
    (548137, (5.114, 18.099, 26.663)),
    (190191, (6.987, 18.089, 25.386)),
    (485044, (7.569, 10.954, 22.812)),
    (850727, (1.312, 18.739, 25.051)),
    (509733, (3.287, 16.387, 22.965)),
    (513303, (3.483, 16.493, 25.242)),
    (62458, (8.450, 14.891, 22.419)),
    (225870, (2.410, 11.482, 21.826)),
    (72650, (0.505, 10.553, 27.082)),
    (669624, (3.389, 19.917, 23.820)),
    (438798, (5.773, 15.502, 28.650)),
    (622871, (1.405, 13.542, 22.160)),
    (114148, (0.407, 14.230, 27.350)),
    (503291, (9.211, 12.122, 24.781)),
    (897590, (7.100, 18.871, 24.634)),
    (196292, (9.741, 14.568, 27.414)),
    (238244, (8.484, 13.136, 27.017)),
    (530101, (5.414, 16.557, 25.423)),
    (696867, (8.255, 16.879, 24.137)),
    (736041, (7.863, 18.208, 26.376)),
    (669479, (1.453, 11.761, 21.713)),
    (691415, (9.426, 16.365, 27.134)),
    (870590, (0.078, 17.405, 26.142)),
    (210180, (6.018, 17.133, 25.509)),
    (733698, (2.997, 16.384, 26.523)),
    (563581, (1.935, 13.630, 23.429)),
    (886944, (4.794, 15.504, 27.771)),
    (299932, (4.690, 10.313, 21.043)),
    (421404, (3.735, 17.595, 20.200)),
    (881572, (1.395, 14.206, 23.558)),
    (356343, (0.854, 16.454, 21.749)),
    (463910, (6.092, 12.483, 24.903)),
    (280082, (1.654, 17.906, 26.149)),
    (917683, (2.492, 15.900, 28.549)),
    (625136, (6.879, 12.466, 21.274)),
    (823984, (8.392, 10.119, 27.496)),
    (130601, (7.489, 12.565, 20.609)),
    (93546, (9.131, 13.023, 24.565)),
    (139413, (9.462, 12.665, 26.873)),
    (64420, (8.918, 13.991, 26.677)),
    (305030, (5.330, 18.869, 25.045)),
    (709094, (5.801, 18.479, 24.798)),
    (95123, (2.203, 14.181, 22.955)),
    (222876, (0.925, 17.551, 29.303)),
    (801148, (9.928, 12.303, 25.339)),
    (33856, (7.746, 13.628, 24.160)),
    (147841, (0.260, 16.887, 25.742)),
    (659099, (1.016, 14.568, 27.941)),
    (761360, (9.611, 16.740, 22.049)),
    (300916, (0.191, 10.893, 23.881)),
    (904748, (6.463, 16.729, 23.233)),
    (59953, (2.087, 19.257, 27.828)),
    (944518, (2.480, 12.519, 28.106)),
    (28144, (7.846, 13.288, 28.327)),
    (711603, (0.105, 19.750, 28.296)),
    (550095, (9.084, 17.357, 29.301)),
    (595803, (0.237, 10.746, 24.157)),
    (362017, (8.543, 19.799, 27.018)),
    (864690, (8.123, 10.598, 28.296)),
    (438824, (6.190, 14.086, 26.073)),
    (299148, (3.502, 12.803, 20.456)),
    (806950, (8.376, 15.673, 29.508)),
    (899847, (9.264, 10.043, 27.774)),
    (372195, (4.598, 19.689, 26.657)),
    (801215, (0.652, 12.658, 22.345)),
    (507562, (6.880, 14.341, 23.701)),
    (640137, (8.146, 13.006, 22.269)),
    (678747, (7.358, 15.275, 26.844)),
    (17850, (1.879, 19.482, 27.540)),
    (137929, (7.356, 13.899, 28.633)),
    (696289, (6.881, 17.614, 25.490)),
    (192614, (2.205, 16.236, 28.996)),
    (407071, (5.058, 17.475, 29.787)),
    (664578, (8.338, 19.525, 26.291)),
    (297102, (3.914, 19.390, 26.629)),
    (911007, (4.146, 10.664, 21.959)),
    (505314, (6.439, 18.091, 21.973)),
    (241236, (3.597, 12.414, 25.658)),
    (909777, (3.297, 12.383, 22.026)),
    (739256, (2.883, 17.109, 23.822)),
    (371500, (6.094, 15.380, 28.540)),
    (325785, (3.529, 19.669, 27.363)),
    (519249, (9.667, 17.303, 21.866)),
    (921229, (8.089, 12.511, 20.651)),
    (492688, (1.368, 14.807, 26.202)),
    (752052, (5.122, 16.552, 26.651)),
    (721747, (3.014, 14.531, 29.516)),
    (21938, (2.800, 13.033, 24.868)),
    (523616, (7.715, 15.111, 27.684)),
    (226583, (1.614, 17.894, 20.804)),
    (963499, (8.704, 19.752, 26.146)),
    (194135, (5.585, 13.770, 25.552)),
    (329265, (8.301, 19.676, 24.898)),
    (507788, (9.115, 17.046, 26.642)),
    (117675, (0.857, 19.869, 23.721)),
    (98178, (9.072, 15.700, 23.779)),
    (141391, (9.737, 13.224, 21.336)),
    (437001, (0.158, 14.313, 28.137)),
    (951079, (4.065, 16.728, 28.078)),
    (538644, (1.253, 14.196, 28.994)),
    (91258, (4.492, 14.553, 20.479)),
    (696373, (2.923, 10.109, 24.388)),
    (150501, (1.343, 13.786, 26.730)),
    (13306, (7.484, 12.492, 20.629)),
    (137613, (7.185, 17.838, 26.226)),
    (197182, (4.424, 14.531, 26.647)),
    (467046, (9.164, 10.878, 29.823)),
    (61915, (7.372, 15.701, 29.975)),
    (980870, (3.657, 16.983, 28.241)),
    (64814, (3.210, 14.087, 26.310)),
    (403164, (3.917, 18.800, 25.598)),
    (889777, (9.633, 16.835, 23.022)),
    (682422, (9.427, 13.288, 24.848)),
    (545384, (1.908, 16.917, 24.018)),
    (325512, (6.996, 14.332, 23.668)),
    (70301, (0.066, 18.433, 29.319)),
    (383871, (9.948, 18.907, 28.074)),
    (208826, (6.005, 14.988, 24.435)),
    (761984, (1.955, 14.236, 21.696)),
    (81252, (8.679, 10.546, 21.380)),
    (478209, (2.968, 12.612, 21.417)),
    (384565, (8.405, 15.400, 23.918)),
    (48380, (4.340, 19.445, 29.296)),
    (704727, (4.825, 15.420, 24.799)),
    (967145, (2.227, 19.326, 20.464)),
    (798349, (5.290, 17.889, 27.119)),
    (592742, (0.540, 16.169, 27.728)),
    (412572, (6.759, 11.954, 29.206)),
    (71278, (8.358, 11.421, 20.269)),
    (445610, (4.540, 13.153, 24.405)),
    (134239, (1.961, 13.252, 27.560)),
    (474292, (5.583, 19.234, 25.679)),
    (601246, (4.963, 16.336, 29.988)),
    (94202, (2.864, 11.270, 23.800)),
    (965713, (6.726, 11.421, 21.999)),
    (100943, (8.787, 14.484, 20.701)),
    (402479, (7.571, 19.882, 22.792)),
    (289978, (2.401, 19.582, 24.329)),
    (513873, (5.835, 12.616, 20.004)),
    (432677, (4.308, 16.192, 24.190)),
    (206658, (5.891, 18.880, 24.217)),
    (545659, (4.022, 18.752, 28.460)),
    (987326, (9.887, 12.919, 28.214)),
    (549563, (0.009, 18.706, 22.446)),
    (19085, (8.869, 18.425, 23.009)),
    (77119, (5.084, 16.409, 23.722)),
    (419576, (5.511, 19.915, 26.771)),
    (931935, (2.408, 11.135, 24.651)),
    (213967, (8.662, 17.757, 27.575)),
    (731612, (6.636, 14.501, 29.963)),
    (306936, (3.345, 16.566, 20.641)),
    (137107, (5.761, 14.270, 29.196)),
    (573447, (4.448, 11.956, 21.022)),
    (843911, (6.428, 19.704, 21.051)),
    (901283, (6.471, 16.629, 23.818)),
    (195130, (5.758, 13.144, 29.564)),
    (286849, (2.102, 17.148, 24.695)),
    (650648, (0.785, 18.811, 26.995)),
    (215463, (5.141, 16.026, 20.187)),
    (517933, (2.334, 11.065, 20.540)),
    (486281, (6.189, 11.061, 21.246)),
    (798019, (0.748, 17.466, 29.568)),
    (529444, (7.553, 14.309, 25.579)),
    (76167, (9.787, 19.095, 28.155)),
    (559400, (3.303, 17.391, 27.610)),
    (41470, (2.002, 12.236, 20.827)),
    (714450, (6.066, 16.164, 29.991)),
    (917003, (3.327, 19.481, 23.243)),
    (518693, (4.779, 16.414, 21.944)),
    (674113, (0.499, 18.310, 27.862)),
    (522473, (1.575, 11.854, 21.440)),
    (326886, (1.891, 16.579, 21.973)),
    (788632, (6.806, 16.803, 26.281)),
    (407119, (3.741, 14.955, 29.954)),
    (246410, (6.797, 15.852, 25.288)),
    (838605, (5.182, 14.449, 25.725)),
    (843572, (7.862, 16.849, 23.666)),
    (287310, (4.908, 14.943, 26.607)),
    (266841, (3.147, 11.051, 20.625)),
    (104917, (5.452, 17.338, 20.964)),
    (89632, (5.632, 16.573, 24.741)),
    (208612, (6.050, 15.840, 29.566)),
    (842799, (4.948, 14.808, 27.984)),
    (592162, (2.440, 10.243, 25.135)),
    (452535, (4.305, 10.264, 21.531)),
    (495485, (1.919, 12.996, 27.223)),
    (805235, (4.635, 10.437, 27.267)),
    (294043, (9.761, 18.658, 29.755)),
    (114884, (2.513, 18.912, 21.369)),
    (993323, (2.127, 13.370, 24.593)),
    (727112, (5.062, 18.753, 28.038)),
    (895650, (8.214, 13.815, 28.827)),
    (82691, (3.674, 16.230, 23.824)),
    (161090, (8.467, 17.865, 21.439)),
    (564446, (8.667, 16.630, 20.177)),
    (416619, (0.836, 17.253, 24.470)),
    (718877, (4.202, 12.729, 28.821)),
    (957908, (2.104, 19.845, 21.083)),
    (492437, (2.544, 16.117, 21.693)),
    (447612, (0.418, 13.231, 20.370)),
    (724940, (7.288, 15.832, 23.282)),
    (277197, (8.954, 14.309, 27.898)),
    (558360, (4.014, 17.043, 23.090)),
    (992085, (9.823, 15.093, 28.109)),
    (912374, (3.438, 14.075, 22.622)),
    (520484, (8.731, 17.417, 23.465)),
    (297741, (9.894, 16.465, 21.098)),
    (594816, (2.203, 12.968, 29.570)),
    (845680, (6.905, 18.332, 25.530)),
    (482637, (7.372, 12.379, 26.328)),
    (8225, (1.262, 16.574, 24.457)),
    (86210, (8.381, 13.335, 22.408)),
    (24975, (5.571, 17.763, 20.654)),
    (818158, (5.254, 16.491, 25.101)),
    (307773, (5.485, 15.562, 25.124)),
    (390868, (7.357, 15.635, 24.889)),
    (676856, (2.302, 11.955, 27.779)),
    (498802, (6.636, 16.534, 24.290)),
    (670000, (6.030, 11.598, 23.088)),
    (242763, (3.217, 19.989, 26.700)),
    (38066, (2.539, 10.572, 20.693)),
    (288414, (3.417, 19.101, 21.579)),
    (640023, (9.381, 10.257, 29.622)),
    (42919, (5.570, 10.975, 25.046)),
    (306878, (4.468, 17.643, 26.051)),
    (997243, (0.486, 15.786, 28.855)),
    (650607, (4.167, 14.466, 28.034)),
    (731952, (3.744, 17.446, 21.008)),
    (443101, (5.238, 12.044, 25.975)),
    (161912, (1.397, 16.984, 23.145)),
    (829127, (3.546, 11.681, 29.707)),
    (380940, (2.714, 16.768, 24.320)),
    (866278, (5.810, 12.895, 28.064)),
    (746127, (3.038, 14.424, 20.031)),
    (139618, (9.241, 14.939, 24.166)),
    (224833, (6.544, 13.813, 23.185)),
    (887228, (2.064, 17.340, 28.880)),
    (373939, (5.530, 11.723, 26.300)),
    (567904, (7.059, 18.541, 23.731)),
    (467776, (2.116, 18.608, 24.487)),
    (935716, (4.634, 10.533, 22.403)),
    (216061, (3.101, 16.274, 24.219)),
    (517863, (7.015, 18.989, 23.846)),
    (373810, (0.829, 11.147, 28.307)),
    (737403, (5.867, 13.532, 23.409)),
    (260303, (4.453, 10.517, 29.984)),
    (373074, (0.293, 19.697, 25.355)),
    (464320, (5.044, 13.717, 26.504)),
    (27507, (6.301, 18.573, 29.286)),
    (321606, (7.118, 15.813, 27.865)),
    (36625, (6.871, 13.478, 20.253)),
    (973427, (7.504, 14.051, 21.874)),
    (119270, (5.797, 16.407, 27.665)),
    (649163, (2.628, 16.980, 26.770)),
    (270525, (2.962, 18.888, 24.266)),
    (938365, (4.293, 12.395, 20.632)),
    (408397, (7.361, 15.201, 24.898)),
    (843429, (3.771, 11.701, 24.822)),
    (15793, (9.971, 13.904, 20.920)),
    (618197, (5.835, 13.390, 21.871)),
    (846553, (0.535, 18.995, 28.899)),
    (267119, (7.674, 15.405, 24.624)),
    (903073, (7.074, 13.211, 24.345)),
    (825467, (5.409, 10.819, 22.357)),
    (679724, (9.076, 16.539, 25.175)),
    (47348, (2.405, 10.563, 23.598)),
    (794260, (8.690, 18.630, 20.260)),
    (715068, (4.300, 16.232, 29.512)),
    (59453, (3.484, 12.229, 22.696)),
    (489511, (5.682, 15.975, 27.881)),
    (76439, (6.284, 16.060, 26.312)),
    (922992, (0.658, 15.136, 29.451)),
    (643502, (2.064, 12.897, 24.199)),
    (258251, (7.141, 13.464, 22.322)),
    (345181, (9.750, 15.301, 21.188)),
    (278686, (2.538, 11.502, 20.011)),
    (71194, (8.658, 13.355, 26.188)),
    (668808, (8.691, 13.367, 25.438)),
    (139797, (2.165, 11.194, 25.379)),
    (677835, (1.194, 14.586, 23.198)),
    (242329, (1.287, 14.672, 24.835)),
    (340955, (4.789, 18.591, 27.151)),
    (510800, (9.294, 13.134, 20.853)),
    (88381, (5.609, 18.044, 20.869)),
    (386858, (8.809, 13.377, 20.195)),
    (322361, (5.558, 18.910, 21.258)),
    (642530, (0.654, 12.465, 24.093)),
    (916563, (3.700, 16.104, 27.086)),
    (920269, (7.768, 15.188, 27.822)),
    (623517, (0.964, 19.960, 22.235)),
    (963001, (4.967, 16.035, 29.685)),
    (96329, (6.660, 19.345, 20.695)),
    (512739, (7.560, 17.825, 24.916)),
    (21536, (1.540, 12.294, 29.812)),
    (787995, (0.738, 18.504, 20.456)),
    (855829, (0.401, 12.956, 24.579)),
    (372816, (0.584, 11.956, 22.539)),
    (752923, (0.492, 17.768, 23.193)),
    (946482, (8.900, 11.212, 20.610)),
    (176880, (1.256, 14.168, 25.864)),
    (693501, (2.223, 12.932, 25.977)),
    (5830, (5.177, 17.511, 24.505)),
    (723985, (5.652, 11.042, 26.891)),
    (707039, (4.219, 17.451, 22.396)),
    (711089, (8.062, 14.881, 25.847)),
    (175733, (8.146, 12.616, 28.202)),
    (489836, (8.877, 11.620, 27.769)),
    (460773, (8.180, 15.971, 20.624)),
    (762873, (8.213, 19.090, 22.709)),
    (459298, (0.283, 16.189, 20.310)),
    (440840, (3.868, 17.712, 22.999)),
    (802730, (8.074, 16.365, 29.350)),
    (800608, (8.980, 17.794, 25.103)),
    (909493, (1.069, 17.293, 20.740)),
    (308864, (7.019, 18.040, 21.228)),
    (340458, (1.287, 16.103, 29.944)),
    (275948, (2.942, 12.427, 29.217)),
    (299277, (9.652, 14.291, 28.325)),
    (983507, (4.988, 17.922, 23.165)),
    (187684, (6.018, 13.400, 28.525)),
    (894743, (6.717, 10.803, 25.997)),
    (676173, (0.174, 19.415, 21.227)),
    (557871, (3.003, 19.423, 27.531)),
    (449749, (6.877, 12.648, 25.168)),
    (135741, (3.815, 19.723, 28.002)),
    (465365, (6.703, 10.783, 22.519)),
    (150112, (9.823, 19.245, 25.450)),
    (843665, (4.247, 19.498, 27.953)),
    (323963, (6.572, 12.206, 20.379)),
    (637492, (3.021, 18.323, 28.307)),
    (947956, (5.028, 19.463, 21.335)),
    (607010, (5.409, 17.015, 28.753)),
    (895435, (7.499, 18.189, 28.293)),
    (926142, (1.263, 14.129, 29.586)),
    (456980, (9.820, 10.176, 27.250)),
    (431074, (2.388, 14.724, 28.992)),
    (612861, (3.435, 13.984, 22.201)),
    (452115, (9.864, 12.716, 21.718)),
    (959425, (3.620, 12.675, 26.096)),
    (90686, (5.042, 14.953, 24.482)),
    (801392, (1.377, 18.554, 21.981)),
    (830973, (7.920, 18.340, 29.914)),
    (51533, (8.777, 16.806, 28.954)),
    (191451, (1.795, 15.221, 27.703)),
    (809485, (4.988, 12.654, 27.106)),
    (906250, (6.026, 15.594, 26.198)),
    (334338, (6.964, 10.113, 24.524)),
    (968853, (5.197, 11.101, 22.857)),
    (936252, (5.676, 10.019, 24.953)),
    (398097, (6.982, 13.807, 26.544)),
    (680955, (7.246, 15.340, 24.017)),
    (895030, (4.317, 13.160, 22.480)),
    (426065, (0.264, 11.746, 23.923)),
    (799512, (9.565, 14.723, 25.705)),
    (765741, (4.741, 18.136, 26.035)),
    (597883, (0.105, 11.604, 22.235)),
    (460232, (6.682, 10.619, 26.747)),
    (44352, (5.954, 12.080, 24.370)),
    (396800, (7.551, 19.171, 29.509)),
    (40316, (7.984, 15.918, 28.860)),
    (850642, (9.281, 17.143, 23.715)),
    (547460, (7.306, 19.805, 24.837)),
    (324714, (5.127, 14.147, 22.786)),
    (364942, (1.101, 12.504, 27.886)),
    (525316, (7.170, 15.350, 27.266)),
    (47983, (2.891, 15.239, 21.556)),
    (809498, (8.944, 17.681, 24.003)),
    (606803, (5.411, 13.588, 27.682)),
    (857187, (7.275, 12.897, 29.241)),
    (688716, (9.027, 15.713, 24.753)),
    (208960, (7.189, 16.926, 27.319)),
    (887752, (9.909, 17.044, 20.112)),
    (425280, (4.952, 14.391, 29.022)),
    (864747, (0.264, 14.795, 29.387)),
    (363031, (2.378, 12.837, 23.547)),
    (433455, (9.515, 13.521, 29.910)),
    (796346, (1.403, 17.451, 24.765)),
    (87625, (8.211, 12.608, 20.586)),
    (750724, (2.564, 15.733, 22.982)),
    (565917, (1.123, 19.757, 29.895)),
    (374831, (4.848, 19.762, 28.709)),
    (761886, (3.915, 18.499, 21.420)),
    (14925, (5.632, 10.075, 27.495)),
    (393388, (7.747, 12.427, 25.069)),
    (859135, (9.011, 16.645, 21.965)),
    (960052, (9.186, 13.354, 27.030)),
    (293780, (3.804, 19.706, 21.076)),
    (630729, (4.737, 19.108, 21.695)),
    (958995, (1.823, 17.959, 25.705)),
    (615056, (9.112, 18.412, 21.284)),
    (840880, (9.863, 11.817, 29.211)),
    (326795, (1.521, 16.338, 21.376)),
    (793924, (4.558, 13.423, 22.852)),
    (713863, (5.707, 15.091, 25.441)),
    (242087, (6.063, 17.612, 21.549)),
    (215364, (4.767, 14.732, 25.278)),
    (125693, (8.387, 12.066, 27.134)),
    (871978, (1.247, 18.417, 21.242)),
    (361189, (6.119, 15.271, 29.130)),
    (413581, (9.211, 12.223, 22.502)),
    (931006, (2.676, 10.760, 26.949)),
    (411660, (9.621, 18.394, 21.946)),
    (823652, (8.461, 17.777, 22.434)),
    (423224, (2.225, 11.334, 28.211)),
    (946600, (8.315, 13.937, 22.873)),
    (156633, (2.871, 12.285, 22.822)),
    (92597, (7.960, 12.294, 20.549)),
    (358148, (5.454, 13.553, 22.082)),
    (801829, (0.592, 15.483, 24.437)),
    (462521, (4.438, 15.659, 22.882)),
    (91019, (6.553, 13.216, 28.609)),
    (939162, (1.518, 17.694, 20.991)),
    (509296, (0.986, 17.861, 27.291)),
    (586747, (0.180, 12.228, 27.976)),
    (297399, (5.626, 13.643, 23.352)),
    (476151, (9.681, 13.705, 27.759)),
    (964207, (3.284, 13.277, 27.959)),
    (889275, (3.489, 16.488, 23.040)),
    (76888, (7.664, 16.522, 22.163)),
    (912001, (4.032, 19.953, 22.894)),
    (282834, (8.489, 18.837, 20.382)),
    (617238, (0.748, 14.535, 22.049)),
    (450091, (8.383, 16.278, 23.590)),
    (965534, (0.134, 18.922, 23.474)),
    (700459, (6.267, 17.976, 21.316)),
    (592115, (3.590, 19.019, 24.969)),
    (112753, (8.034, 13.167, 21.731)),
    (940589, (4.675, 13.620, 27.365)),
    (74668, (3.663, 19.202, 28.587)),
    (414334, (3.990, 16.369, 29.445)),
    (798043, (5.302, 14.366, 27.054)),
    (603600, (7.542, 11.874, 27.195)),
    (274193, (8.324, 13.079, 25.095)),
    (959169, (7.398, 14.935, 24.840)),
    (408087, (9.095, 17.068, 21.985)),
    (743074, (6.628, 14.562, 23.059)),
    (594711, (2.284, 10.706, 28.146)),
    (238853, (0.832, 13.148, 24.344)),
    (719529, (8.979, 19.889, 23.693)),
    (448162, (1.108, 15.548, 24.679)),
    (945840, (2.611, 14.711, 28.125)),
    (628186, (2.478, 19.895, 20.800)),
    (137043, (8.576, 10.345, 28.638)),
    (758818, (1.045, 17.968, 26.411)),
    (404105, (1.086, 13.860, 23.066)),
    (424496, (3.743, 19.321, 24.819)),
    (134319, (1.740, 12.169, 23.720)),
    (407224, (7.096, 14.043, 23.171)),
    (585694, (0.283, 11.272, 27.308)),
    (822464, (6.055, 17.845, 24.372)),
    (278592, (2.863, 11.650, 24.658)),
    (613732, (9.586, 14.766, 26.969)),
    (611081, (3.569, 16.554, 27.638)),
    (727166, (4.435, 11.709, 22.442)),
    (963017, (3.086, 11.670, 23.162)),
    (361705, (9.468, 13.312, 24.189)),
    (240885, (7.712, 16.817, 23.713)),
    (644135, (3.059, 12.756, 20.554)),
    (835909, (5.744, 17.929, 26.968)),
    (409444, (5.625, 15.319, 26.060)),
    (750019, (7.655, 17.714, 25.540)),
    (936802, (0.325, 16.011, 29.422)),
    (17667, (8.925, 12.701, 20.394)),
    (144784, (4.963, 17.363, 25.455)),
    (399753, (6.725, 12.150, 29.255)),
    (510594, (3.910, 10.233, 25.799)),
    (950688, (0.335, 12.054, 28.350)),
    (652922, (9.247, 18.537, 22.214)),
    (534540, (8.716, 10.865, 22.699)),
    (453591, (3.708, 18.205, 23.643)),
    (568383, (1.789, 12.319, 24.554)),
    (358527, (0.932, 17.642, 23.784)),
    (807287, (1.414, 16.656, 23.972)),
    (709209, (1.676, 14.665, 20.421)),
    (63282, (7.768, 13.995, 25.493)),
    (159233, (7.045, 14.748, 20.553)),
    (907088, (4.841, 16.024, 28.064)),
    (182583, (5.226, 13.420, 23.541)),
    (677228, (2.850, 13.735, 29.695)),
    (995665, (7.004, 18.141, 27.751)),
    (513649, (9.995, 18.146, 20.207)),
    (721051, (4.089, 14.398, 28.277)),
    (101008, (1.341, 18.810, 22.415)),
    (730591, (8.494, 19.118, 24.242)),
    (472114, (1.947, 15.100, 28.025)),
    (705342, (8.141, 14.395, 20.638)),
    (810946, (9.655, 17.109, 29.191)),
    (744248, (2.454, 17.144, 21.581)),
    (836545, (8.684, 10.900, 29.328)),
    (981338, (1.612, 12.120, 29.340)),
    (675136, (0.723, 19.095, 29.052)),
    (80406, (3.069, 18.799, 22.159)),
    (362055, (4.839, 19.150, 20.796)),
    (403169, (3.677, 17.442, 26.411)),
    (670303, (3.813, 16.819, 20.951)),
    (354944, (2.353, 14.814, 26.990)),
    (533826, (3.435, 14.451, 28.533)),
    (616449, (1.373, 12.326, 25.867)),
    (69817, (4.903, 18.286, 24.517)),
    (85455, (0.542, 18.604, 28.627)),
    (94490, (5.728, 19.986, 23.883)),
    (264022, (5.605, 11.156, 26.025)),
    (643547, (7.117, 13.311, 23.339)),
    (758585, (3.119, 18.611, 26.961)),
    (814480, (5.012, 17.344, 26.605)),
    (94953, (7.320, 16.832, 24.078)),
    (486323, (3.409, 14.690, 29.531)),
    (891652, (8.235, 17.087, 28.821)),
    (318107, (8.389, 16.177, 21.089)),
    (614378, (6.143, 19.380, 27.963)),
    (901350, (0.695, 10.135, 27.947)),
    (205167, (6.314, 11.601, 27.291)),
    (231522, (1.108, 12.660, 26.593)),
    (726171, (3.461, 16.603, 22.960)),
    (479066, (8.257, 18.886, 24.908)),
    (394750, (9.595, 12.776, 28.863)),
    (854602, (4.335, 10.997, 20.632)),
    (862649, (2.475, 15.721, 21.916)),
    (197398, (8.125, 19.466, 29.812)),
    (333539, (9.231, 15.835, 23.010)),
    (599743, (1.080, 19.018, 27.983)),
    (943750, (5.497, 14.656, 24.303)),
    (8525, (3.392, 15.660, 27.308)),
    (990165, (7.634, 14.154, 23.301)),
    (784880, (0.861, 11.361, 23.368)),
    (36528, (9.024, 12.410, 28.204)),
    (885708, (3.538, 17.691, 26.704)),
    (548262, (9.770, 12.960, 27.051)),
    (216950, (2.233, 16.940, 23.747)),
    (541709, (4.270, 17.734, 27.656)),
    (779350, (6.887, 13.919, 29.857)),
    (986771, (0.090, 13.326, 25.328)),
    (837565, (1.333, 13.394, 22.973)),
    (540898, (0.000, 14.658, 22.464)),
    (981265, (7.064, 11.444, 20.474)),
    (481908, (1.190, 18.401, 22.844)),
    (13239, (6.038, 10.808, 24.966)),
    (195357, (5.685, 13.227, 22.836)),
    (294679, (5.582, 13.701, 29.017)),
    (870172, (3.459, 19.807, 26.757)),
    (906326, (2.098, 13.303, 20.115)),
    (753125, (9.238, 13.930, 21.134)),
    (565426, (7.023, 12.374, 21.051)),
    (857379, (4.554, 19.226, 27.666)),
    (476128, (9.803, 18.193, 27.582)),
    (920086, (1.471, 11.632, 20.826)),
    (52246, (6.577, 14.959, 27.099)),
    (990754, (3.846, 19.974, 27.692)),
    (349158, (7.962, 17.351, 25.837)),
    (586377, (4.647, 14.977, 27.501)),
    (341684, (2.747, 12.212, 24.097)),
    (559984, (2.926, 19.208, 27.620)),
    (991654, (5.451, 11.869, 20.622)),
    (103028, (2.838, 17.937, 22.472)),
    (114517, (3.245, 13.525, 20.865)),
    (111318, (1.768, 13.641, 20.063)),
    (871441, (5.576, 15.327, 28.231)),
    (184230, (1.758, 19.631, 28.048)),
    (810117, (4.552, 14.324, 27.046)),
    (737150, (5.765, 13.904, 23.806)),
    (975416, (6.173, 11.813, 26.710)),
    (123977, (5.507, 14.730, 24.737)),
    (715713, (3.513, 19.927, 26.910)),
    (394560, (0.147, 17.800, 28.598)),
    (848294, (1.893, 14.039, 29.548)),
    (179302, (0.363, 10.779, 23.969)),
    (367516, (4.949, 19.558, 28.795)),
    (401613, (3.551, 19.420, 24.188)),
    (775948, (0.094, 16.891, 23.129)),
    (331687, (6.027, 17.831, 29.293)),
    (638850, (1.754, 11.386, 22.584)),
    (262202, (6.927, 14.510, 20.140)),
    (804992, (6.292, 17.928, 24.410)),
    (978934, (0.501, 16.266, 29.852)),
    (851962, (6.909, 14.337, 23.210)),
    (117905, (8.685, 12.919, 20.535)),
    (798731, (7.030, 18.101, 24.594)),
    (806830, (4.728, 19.512, 26.834)),
    (186504, (9.086, 15.479, 22.448)),
    (567790, (3.186, 15.807, 23.255)),
    (728497, (2.808, 10.843, 29.825)),
    (164817, (2.987, 11.315, 20.535)),
    (829242, (1.132, 15.793, 21.249)),
    (647421, (5.945, 12.623, 25.589)),
    (900387, (7.884, 19.314, 27.929)),
    (287509, (0.751, 18.485, 29.899)),
    (862126, (0.243, 18.361, 23.257)),
    (865289, (2.841, 17.291, 27.734)),
    (425690, (6.596, 15.683, 29.746)),
    (370905, (6.345, 12.481, 21.965)),
    (616858, (5.174, 14.398, 23.860)),
    (578280, (2.047, 19.862, 29.701)),
    (264571, (8.314, 12.872, 29.223)),
    (751169, (8.657, 15.767, 25.140)),
    (626311, (9.401, 17.080, 27.801)),
    (103700, (7.616, 18.980, 20.261)),
    (66883, (1.508, 12.078, 25.354)),
    (689126, (1.659, 12.413, 26.035)),
    (552276, (0.766, 15.867, 25.338)),
    (749148, (3.477, 12.677, 28.007)),
    (557663, (5.420, 12.196, 26.314)),
    (121411, (8.753, 12.939, 27.648)),
    (452097, (8.704, 10.133, 23.274)),
    (221075, (8.077, 17.323, 26.694)),
    (396958, (9.037, 11.534, 22.827)),
    (756952, (1.757, 11.331, 27.103)),
    (648401, (0.143, 16.725, 25.653)),
    (852789, (3.022, 16.057, 29.048)),
    (753818, (6.882, 16.022, 24.370)),
    (11744, (1.287, 17.274, 27.346)),
    (198139, (8.215, 16.253, 26.169)),
    (986636, (3.125, 13.561, 21.888)),
    (322542, (8.466, 14.942, 27.817)),
    (515559, (2.705, 11.552, 21.366)),
    (237030, (4.772, 19.653, 28.688)),
    (745416, (4.119, 17.573, 24.266)),
    (88689, (6.448, 12.230, 29.022)),
    (424027, (4.273, 14.261, 25.200)),
    (781442, (9.318, 14.306, 23.379)),
    (902776, (8.819, 14.434, 20.829)),
    (913104, (3.994, 12.562, 28.905)),
    (662420, (9.134, 15.468, 20.128)),
    (962874, (8.631, 13.562, 22.625)),
    (481545, (5.218, 15.552, 23.594)),
    (340754, (3.547, 12.988, 25.111)),
    (397660, (1.858, 13.667, 23.637)),
    (847255, (9.085, 19.847, 25.196)),
    (960901, (0.268, 10.872, 26.006)),
    (245072, (1.190, 19.987, 27.791)),
    (139748, (6.443, 12.957, 20.517)),
    (432386, (1.429, 15.575, 23.527)),
    (991714, (1.275, 16.206, 23.292)),
    (49357, (9.585, 14.158, 22.379)),
    (765043, (5.539, 11.527, 25.399)),
    (3180, (5.240, 10.740, 23.861)),
    (493299, (8.046, 12.733, 22.818)),
    (482666, (3.907, 17.699, 29.688)),
    (666218, (6.403, 12.897, 20.661)),
    (7770, (9.864, 13.488, 27.964)),
    (303610, (2.866, 18.138, 23.632)),
    (156818, (0.191, 16.132, 25.408)),
    (80093, (4.686, 14.677, 28.785)),
    (460100, (8.293, 15.134, 23.448)),
    (733699, (4.814, 10.528, 27.374)),
    (737134, (1.636, 16.216, 26.134)),
    (818751, (1.640, 10.075, 20.466)),
    (383177, (6.484, 14.606, 27.964)),
    (707402, (4.571, 10.080, 29.168)),
    (435283, (4.297, 16.072, 26.703)),
    (298042, (2.869, 19.943, 29.030)),
    (918854, (7.378, 19.737, 25.377)),
    (827399, (8.530, 19.506, 23.097)),
    (908716, (1.449, 16.186, 22.508)),
    (360240, (3.228, 14.673, 27.143)),
    (703978, (8.269, 16.062, 22.777)),
    (220226, (4.244, 13.476, 24.985)),
    (527713, (5.683, 11.850, 29.297)),
    (471432, (0.295, 16.097, 26.374)),
    (962993, (9.948, 10.627, 26.380)),
    (37923, (9.973, 18.853, 23.495)),
    (761210, (9.912, 19.705, 27.728)),
    (17137, (3.663, 17.840, 27.048)),
    (648453, (0.182, 14.094, 20.681)),
    (195522, (9.235, 12.149, 24.916)),
    (675627, (9.870, 13.140, 23.879)),
    (971753, (0.429, 12.016, 24.351)),
    (566369, (1.485, 14.094, 20.920)),
    (636829, (5.712, 18.442, 27.843)),
    (670753, (3.498, 13.916, 27.375)),
    (251235, (6.809, 11.017, 26.230)),
    (903792, (4.483, 17.056, 22.402)),
    (296668, (1.625, 10.305, 27.173)),
    (684773, (6.304, 19.944, 28.477)),
    (491029, (8.738, 15.708, 22.701)),
    (439934, (0.017, 17.490, 29.829)),
    (543139, (7.062, 10.182, 22.709)),
    (935797, (4.884, 19.952, 23.961)),
    (733643, (4.610, 10.885, 23.298)),
    (490071, (1.661, 14.387, 22.913)),
    (404797, (6.145, 15.053, 20.578)),
    (707900, (1.896, 17.980, 26.531)),
    (804707, (6.651, 11.584, 27.209)),
    (412367, (3.758, 16.491, 24.215)),
    (258666, (4.287, 19.770, 25.350)),
    (153860, (5.099, 12.319, 21.891)),
    (131300, (6.255, 16.616, 27.258)),
    (346116, (4.971, 15.982, 28.949)),
    (706522, (6.033, 16.030, 29.427)),
    (387646, (5.867, 16.770, 23.048)),
    (957686, (5.363, 12.205, 24.227)),
    (206566, (1.033, 11.147, 28.434)),
    (866524, (7.349, 14.732, 20.558)),
    (992712, (0.872, 12.351, 24.992)),
    (757350, (2.043, 14.118, 24.017)),
    (554022, (8.077, 11.124, 23.745)),
    (793170, (4.275, 15.685, 26.918)),
    (854062, (7.069, 17.440, 20.401)),
    (560687, (4.968, 13.515, 28.488)),
    (283102, (5.888, 19.251, 21.088)),
    (135943, (5.170, 14.865, 24.685)),
    (626395, (0.663, 13.358, 22.276)),
    (189026, (2.751, 10.523, 27.461)),
    (251294, (7.030, 16.514, 25.941)),
    (805701, (3.536, 17.988, 26.516)),
    (119019, (7.320, 12.764, 23.752)),
    (64195, (1.975, 17.702, 25.178)),
    (155504, (9.210, 12.880, 22.894)),
    (155256, (4.842, 16.192, 23.166)),
    (875822, (4.884, 16.645, 28.530)),
    (631210, (9.103, 12.859, 20.517)),
    (815439, (1.068, 17.927, 27.590)),
    (253052, (3.655, 13.044, 27.016)),
    (358064, (8.964, 12.509, 26.383)),
    (708992, (1.453, 13.474, 28.376)),
    (915678, (1.701, 19.404, 21.631)),
    (852630, (8.181, 14.990, 27.611)),
    (434404, (0.407, 19.632, 22.792)),
    (110418, (4.869, 19.978, 20.658)),
    (136707, (7.152, 17.110, 29.631)),
    (475878, (8.651, 14.503, 25.822)),
    (397391, (1.306, 13.769, 23.825)),
    (824448, (3.065, 15.497, 21.099)),
    (820127, (3.050, 19.226, 21.586)),
    (882048, (3.168, 17.305, 26.905)),
    (38824, (2.735, 13.153, 25.797)),
    (602255, (8.881, 11.226, 21.123)),
    (775653, (2.163, 13.985, 23.058)),
    (137527, (3.493, 10.442, 22.081)),
    (120222, (9.180, 16.650, 23.169)),
    (602796, (8.977, 16.585, 25.114)),
    (111491, (7.546, 11.305, 21.667)),
    (626248, (3.044, 11.670, 21.569)),
    (724078, (4.090, 18.655, 27.535)),
    (264853, (5.196, 16.518, 26.173)),
    (578871, (7.889, 11.691, 27.985)),
    (770918, (0.794, 15.370, 27.015)),
    (493417, (8.425, 14.368, 24.213)),
    (850457, (3.243, 10.047, 29.976)),
    (82373, (1.372, 13.871, 22.232)),
    (218779, (6.241, 12.892, 29.138)),
    (15859, (0.186, 11.639, 24.745)),
    (176649, (2.369, 12.438, 20.596)),
    (226067, (1.701, 12.200, 28.844)),
    (527184, (3.790, 15.667, 27.851)),
    (969368, (0.610, 13.090, 23.591)),
    (474080, (5.717, 14.552, 21.643)),
    (180302, (9.824, 17.698, 29.934)),
    (888462, (6.852, 17.141, 22.854)),
    (345362, (4.726, 18.218, 27.088)),
    (502925, (6.708, 10.528, 27.373)),
    (495540, (6.289, 11.907, 23.686)),
    (738796, (1.699, 13.747, 22.305)),
    (160840, (3.122, 18.550, 29.309)),
    (816105, (1.143, 18.701, 21.242)),
    (328865, (6.957, 14.599, 22.189)),
    (608370, (1.340, 13.345, 29.659)),
    (51854, (2.319, 13.631, 29.873)),
    (733759, (8.201, 13.989, 20.368)),
    (573834, (4.417, 18.575, 26.929)),
    (8776, (4.594, 11.164, 25.671)),
    (479281, (8.809, 12.984, 26.102)),
    (248973, (5.544, 14.395, 28.982)),
    (52952, (0.209, 10.608, 28.393)),
    (470807, (7.184, 14.815, 21.789)),
    (292192, (3.178, 13.328, 27.921)),
    (839024, (6.456, 11.639, 26.151)),
    (526956, (2.861, 16.265, 29.647)),
    (410146, (4.704, 18.113, 24.600)),
    (380390, (7.855, 13.417, 25.800)),
    (200144, (1.586, 16.035, 27.787)),
    (132984, (2.046, 12.281, 22.905)),
    (470522, (5.729, 10.942, 26.907)),
    (497961, (1.218, 12.082, 29.504)),
    (438133, (4.557, 14.316, 23.117)),
    (347454, (0.553, 12.186, 23.244)),
    (558864, (8.517, 18.884, 27.368)),
    (463814, (4.133, 13.134, 26.520)),
    (252097, (9.647, 19.490, 20.794)),
    (751561, (7.110, 17.911, 27.815)),
    (293214, (8.695, 13.940, 26.381)),
    (589222, (4.800, 14.659, 20.175)),
    (725236, (2.678, 17.570, 26.193)),
    (557237, (3.848, 14.572, 21.170)),
    (903001, (4.057, 15.519, 24.343)),
    (143405, (0.663, 17.754, 21.824)),
    (309912, (1.094, 19.430, 24.121)),
    (235665, (2.375, 10.483, 20.749)),
    (229747, (7.396, 18.329, 26.611)),
    (186982, (3.961, 11.295, 27.158)),
    (299114, (2.777, 18.315, 22.292)),
    (803656, (9.638, 14.479, 20.691)),
    (556009, (3.798, 11.058, 24.039)),
    (269283, (4.963, 10.845, 28.696)),
    (552636, (1.018, 17.258, 27.603)),
    (517863, (4.884, 18.967, 20.411)),
    (675927, (1.258, 18.663, 28.267)),
    (241445, (7.723, 16.034, 27.874)),
    (557311, (6.051, 10.573, 25.658)),
    (271774, (9.572, 19.051, 24.255)),
    (680161, (9.144, 18.352, 26.794)),
    (737979, (0.552, 14.498, 20.949)),
    (585489, (1.161, 18.163, 24.667)),
    (450708, (1.724, 11.950, 21.494)),
    (168232, (6.060, 10.210, 27.968)),
    (509924, (8.293, 17.752, 29.713)),
    (406856, (5.243, 13.922, 22.231)),
    (679885, (4.541, 18.787, 26.300)),
    (403502, (7.719, 17.465, 21.235)),
    (269041, (4.313, 14.539, 21.878)),
    (372131, (3.105, 15.238, 26.912)),
    (822154, (0.116, 17.786, 29.197)),
    (8619, (5.107, 15.940, 22.302)),
    (366096, (1.391, 14.539, 22.455)),
    (724058, (4.550, 17.050, 26.981)),
    (914929, (6.883, 15.609, 21.605)),
    (444337, (3.296, 13.675, 23.769)),
    (113223, (2.962, 12.273, 28.703)),
    (375173, (1.336, 11.139, 25.436)),
    (564301, (0.257, 17.717, 22.429)),
    (314508, (7.023, 12.896, 24.148)),
    (618280, (0.248, 18.979, 28.640)),
    (663809, (2.928, 13.739, 25.326)),
    (178847, (0.978, 16.244, 26.783)),
    (924525, (9.674, 16.119, 29.676)),
    (693884, (6.316, 12.001, 25.409)),
    (830985, (6.852, 15.310, 21.431)),
    (796915, (6.780, 15.546, 22.183)),
    (173844, (0.233, 15.740, 21.936)),
    (924447, (3.493, 13.068, 29.562)),
    (205401, (9.211, 15.449, 27.717)),
    (499924, (6.853, 15.384, 21.451)),
    (297722, (2.148, 13.805, 25.897)),
    (744895, (1.286, 19.071, 23.442)),
    (791055, (6.222, 16.529, 25.548)),
    (684984, (2.163, 17.247, 25.401)),
    (794683, (5.208, 14.998, 25.446)),
    (310104, (3.277, 18.697, 28.206)),
    (767127, (6.237, 12.570, 21.195)),
    (810954, (5.117, 10.069, 20.634)),
    (517088, (4.500, 11.649, 24.767)),
    (560855, (3.857, 12.044, 23.126)),
    (109338, (2.940, 16.865, 27.139)),
    (428992, (2.470, 12.720, 29.287)),
    (24916, (9.838, 11.627, 25.193)),
    (654929, (6.619, 12.257, 21.498)),
    (875527, (1.468, 11.439, 28.491)),
    (782324, (7.725, 16.459, 23.098)),
    (890163, (6.501, 13.523, 28.210)),
    (774679, (8.580, 13.325, 27.971)),
    (288226, (7.171, 10.532, 23.356)),
    (19633, (1.200, 18.228, 20.962)),
    (413882, (6.642, 17.149, 25.610)),
    (234143, (2.196, 13.742, 24.957)),
    (244969, (0.384, 17.526, 24.147)),
    (991431, (7.404, 11.287, 27.835)),
    (703396, (8.645, 18.907, 28.815)),
    (53994, (7.837, 14.022, 20.065)),
    (315407, (3.597, 12.825, 21.609)),
    (287300, (9.252, 18.078, 26.107)),
    (673410, (5.787, 17.791, 26.131)),
    (773485, (6.936, 16.768, 25.073)),
    (956293, (6.322, 19.665, 20.522)),
    (781000, (0.575, 18.665, 24.965)),
    (711421, (3.822, 13.065, 29.686)),
    (138604, (9.796, 11.874, 27.184)),
    (128513, (1.967, 14.347, 24.008)),
    (577289, (9.632, 17.562, 22.761)),
    (308597, (5.573, 16.680, 28.028)),
    (225337, (8.170, 14.476, 23.924)),
    (91017, (0.353, 15.298, 25.474)),
    (636205, (5.072, 11.189, 27.968)),
    (430278, (2.757, 12.464, 24.992)),
    (268215, (5.135, 17.246, 26.575)),
    (529229, (4.452, 14.319, 21.465)),
    (206107, (1.211, 18.021, 22.308)),
    (329474, (8.378, 15.712, 26.888)),
    (575181, (2.279, 12.640, 28.575)),
    (265531, (4.100, 16.344, 20.925)),
    (613750, (6.287, 13.768, 29.753)),
    (558620, (2.233, 11.142, 24.123)),
    (10912, (5.276, 13.329, 26.963)),
    (835025, (4.201, 18.779, 23.107)),
    (643224, (9.784, 19.192, 22.454)),
    (558493, (1.682, 17.634, 28.652)),
    (394663, (0.619, 15.715, 22.612)),
    (995863, (2.066, 11.096, 25.861)),
    (568098, (6.295, 13.509, 26.020)),
    (802177, (6.851, 11.789, 25.615)),
    (363661, (6.269, 16.883, 23.995)),
    (447890, (3.772, 12.376, 20.160)),
    (963811, (4.651, 11.956, 28.893)),
    (456716, (0.878, 17.904, 23.294)),
    (323118, (2.792, 19.338, 25.936)),
    (554118, (9.273, 11.934, 24.983)),
    (397103, (1.259, 14.811, 21.152)),
    (935753, (4.111, 14.084, 22.617)),
    (488916, (1.232, 11.447, 26.183)),
    (225313, (6.397, 18.795, 28.225)),
    (624395, (2.637, 14.127, 22.929)),
    (600226, (5.723, 14.249, 24.675)),
    (225578, (1.134, 13.747, 23.925)),
    (784921, (1.499, 14.984, 24.067)),
    (145690, (9.538, 13.989, 21.731)),
    (326059, (2.592, 15.482, 25.845)),
    (105278, (6.896, 14.502, 25.276)),
    (108248, (3.063, 16.351, 21.555)),
    (618487, (9.747, 13.366, 27.586)),
    (58119, (3.828, 11.112, 26.991)),
    (736534, (2.390, 16.156, 25.923)),
    (494939, (9.270, 16.105, 22.406)),
    (562795, (5.596, 12.144, 23.208)),
    (814245, (2.852, 12.429, 25.647)),
    (892528, (1.925, 19.453, 28.623)),
    (772290, (8.813, 17.095, 21.893)),
    (362005, (4.021, 14.850, 23.106)),
    (127429, (2.650, 10.831, 28.698)),
    (378757, (3.861, 13.244, 29.308)),
    (816330, (2.357, 15.198, 29.586)),
    (422579, (3.468, 19.474, 20.248)),
    (787199, (2.325, 15.037, 22.236)),
    (214758, (1.445, 16.183, 23.997)),
    (441098, (8.168, 19.909, 20.379)),
    (169625, (8.970, 16.654, 23.855)),
    (964039, (2.045, 14.344, 29.640)),
    (701974, (8.447, 12.399, 27.884)),
    (703873, (4.496, 16.312, 28.745)),
    (944382, (6.841, 11.583, 20.976)),
    (574149, (0.642, 16.282, 24.072)),
    (835817, (9.760, 15.800, 21.419)),
    (306049, (4.376, 15.216, 27.359)),
    (983432, (3.652, 15.809, 21.220)),
    (766722, (4.215, 11.018, 24.783)),
    (359958, (4.404, 12.775, 22.224)),
    (891108, (4.410, 18.987, 28.686)),
    (50917, (8.920, 13.482, 23.418)),
    (263627, (2.874, 16.572, 25.716)),
    (753927, (5.968, 13.875, 24.717)),
    (599698, (9.322, 11.398, 29.852)),
    (820982, (1.792, 18.314, 22.098)),
    (875942, (4.217, 13.817, 23.081)),
    (717984, (0.297, 10.351, 23.345)),
    (14743, (1.151, 11.102, 29.927)),
    (292497, (1.047, 17.678, 22.620)),
    (532399, (6.228, 13.022, 20.306)),
    (445398, (6.219, 17.411, 20.127)),
    (891711, (0.647, 18.061, 21.348)),
    (631859, (4.316, 19.647, 24.331)),
    (564605, (1.284, 19.302, 27.778)),
    (622068, (3.738, 15.357, 25.382)),
    (608507, (2.151, 17.688, 29.410)),
    (331095, (0.721, 12.285, 25.977)),
    (629596, (5.852, 19.991, 21.850)),
    (917311, (3.534, 16.036, 27.685)),
    (798374, (2.643, 12.891, 23.220)),
    (613995, (3.856, 15.541, 25.566)),
    