---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, équations, 
              numérotation des équations
---

# Comment numéroter les seules équations auxquelles il est fait référence ?

En matière de numérotation d'équations, deux grandes écoles existent :

- celle qui considère que des documents qui numérotent chaque équation semblent
  désordonnés ;
- celle qui recommande de numéroter toutes les équations, au cas où 
  un lecteur voudrait faire référence à une équation sur laquelle l'auteur 
  n'a fait aucune référence croisée.

Si vous appartenez à la première école, plusieurs solutions s'offrent à vous.


## Automatiquement, avec l'extension <ctanpkg:mathtools>

L'extension <ctanpkg:mathtools> propose une option `showonlyrefs` 
pour sa commande `\mathtoolsset`. Lorsque cette option est activée, 
seules les équations auxquelles vous faites référence sont numérotées 
dans la sortie finale. La consultation de la 
[documentation](texdoc:mathtools) de l'extension est recommandée 
pour avoir plus de détails sur la façon de faire des références dans ce cas.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

  \mathtoolsset{showonlyrefs}

\begin{document}
Seule la deuxième équation nous intéresse \refeq{eq:b}. % Et non \ref{eq:b}.
\begin{align}
  x=y+1 \label{eq:a} \\
  y=x-1 \label{eq:b}
\end{align}
\end{document}
```


## Manuellement, avec les commandes de base et l'extension <ctanpkg:amsmath>

En utilisant la commande `\nonumber` sur certaines équations 
ou en utilisant les environnements non numérotés de l'extension 
<ctanpkg:amsmath> tels que `align*`, vous pouvez marquer les équations 
à ne pas numéroter. Toutefois, dans un article long ou complexe, 
cette procédure pourrait bien devenir profondément fastidieuse.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{amsmath}

\begin{document}
Voici comment ne pas numéroter la première équation :
\begin{align}
  x=y+1 \nonumber \\
  y=x-1
\end{align}

Voici comment ne pas numéroter les deux équations :
\begin{align*}
  x=y+1  \\
  y=x-1
\end{align*}
\end{document}
```

L'extension <ctanpkg:mathtools> propose une solution similaire avec la commande
`\notag`. Elle est illustrée à la question 
"[](/4_domaines_specialises/mathematiques/equations/numerotation_d_equations/ne_pas_numeroter_les_equations)".


:::{sources}
- [Numbers for referenced equations only](faquk:FAQ-mathonlyref)
:::