## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = FALSE
)

## ----setup--------------------------------------------------------------------
# library(bracketeer)

## -----------------------------------------------------------------------------
# teams <- paste("Team", LETTERS[1:16])
# 
# # ── Live tournament ───────────────────────────────────────────────────────────
# trn <- tournament(teams) |>
#   round_robin("groups")
# 
# # ── Blueprint / reusable spec ─────────────────────────────────────────────────
# my_spec <- spec() |>
#   round_robin("groups") |>
#   single_elim("finals", take = top_n(8))

## -----------------------------------------------------------------------------
# # These two are identical:
# tournament(teams) |>
#   round_robin("groups") |>
#   single_elim("finals", take = top_n(8))
# 
# tournament(teams) |>
#   round_robin("groups") |>
#   single_elim("finals", from = previous_stage(), take = top_n(8))

## -----------------------------------------------------------------------------
# trn <- tournament(teams) |>
#   round_robin("groups") |>
#   single_elim("championship", from = "groups", take = top_n(8)) |>
#   single_elim("consolation",  from = "groups", take = remaining())

## -----------------------------------------------------------------------------
# top_n(8)               # top 8 by overall standings
# bottom_n(4)            # bottom 4
# slice_range(5, 8)      # positions 5 through 8
# remaining()            # everyone not already consumed by a prior transition
# losers()               # eliminated participants
# filter_by(function(df, ...) df[df$points >= 6, ])  # custom predicate
# 
# # ── Per-group variants (require grouped source stage) ─────────────────────────
# top_per_group(2)       # top 2 from each group
# bottom_per_group(1)    # bottom 1 from each group
# slice_per_group(3, 3)  # 3rd place from each group

## -----------------------------------------------------------------------------
# my_spec <- spec() |>
#   round_robin("groups") |>
#   single_elim("finals", take = top_n(8))
# 
# validate(my_spec, n = 16)   # passes
# validate(my_spec, n = 6)    # fails — can't select top 8 from 6 teams

## -----------------------------------------------------------------------------
# my_spec <- spec() |>
#   round_robin("groups") |>
#   single_elim("finals", take = top_n(8))
# 
# trn <- my_spec |> build(teams)

## -----------------------------------------------------------------------------
# trn <- trn |> result("groups", match = 1, score = c(2, 1))

## -----------------------------------------------------------------------------
# results_df <- data.frame(
#   match  = 1:4,
#   score1 = c(2, 1, 3, 0),
#   score2 = c(1, 0, 2, 1)
# )
# 
# trn <- trn |> results("groups", results_df)

## -----------------------------------------------------------------------------
# # All group matches entered → finals stage materializes automatically.
# group_ms <- matches(trn, "groups")
# 
# for (i in seq_len(nrow(group_ms))) {
#   trn <- trn |> result("groups", match = group_ms$id[i], score = c(1, 0))
# }
# 
# stage_status(trn)  # finals is now "active"

## -----------------------------------------------------------------------------
# trn <- tournament(teams, auto_advance = FALSE) |>
#   round_robin("groups") |>
#   single_elim("finals", take = top_n(8))
# 
# # ... enter results ...
# 
# trn <- trn |> advance("groups")  # explicit trigger

## -----------------------------------------------------------------------------
# # ── Print ───────────────────────────────────────────────────────────────────
# trn
# # Tournament [2 stages]
# #   groups   in_progress   90/120 matches
# #   finals   blocked
# 
# # ── Stage overview ──────────────────────────────────────────────────────────
# stage_status(trn)
# #   stage    status        complete  total  materialized
# #   groups   in_progress         90    120          TRUE
# #   finals   blocked              0      0         FALSE
# 
# # ── Matches ─────────────────────────────────────────────────────────────────
# matches(trn)                           # all stages, pending (default)
# matches(trn, "groups")                 # one stage, pending
# matches(trn, "groups", status = "all") # one stage, all
# 
# # ── Standings ───────────────────────────────────────────────────────────────
# standings(trn, "groups")   # one stage
# standings(trn)              # all stages
# 
# # ── Outcomes ────────────────────────────────────────────────────────────────
# winner(trn)       # tournament winner (NA until complete)
# rankings(trn)     # final placement table
# routing_log(trn)  # transition audit trail

## -----------------------------------------------------------------------------
# trn <- tournament(teams) |>
#   swiss("open", rounds = 5) |>
#   single_elim("top_cut", take = top_n(8))
# 
# # ... enter all open results, top_cut materializes automatically ...
# 
# # Decide to revise an open result:
# trn <- teardown(trn, "top_cut")     # un-materializes top_cut
# trn <- result(trn, "open", match = 3, score = c(0, 2))  # overwrite now allowed
# # top_cut will re-materialize when open is completed again.

## -----------------------------------------------------------------------------
# library(bracketeer)
# 
# teams <- paste("Team", LETTERS[1:16])
# 
# # ── Define ────────────────────────────────────────────────────────────────────
# trn <- tournament(teams) |>
#   swiss("open", rounds = 5) |>
#   single_elim("top_cut", take = top_n(8))
# 
# # ── Enter results ─────────────────────────────────────────────────────────────
# open_ms <- matches(trn, "open")
# 
# for (i in seq_len(nrow(open_ms))) {
#   trn <- trn |> result("open", match = open_ms$id[i], score = c(1, 0))
# }
# 
# # top_cut auto-materialized after final open result.
# 
# # ── Inspect ───────────────────────────────────────────────────────────────────
# stage_status(trn)
# matches(trn, "top_cut")
# standings(trn, "open")
# 
# # ── Run top_cut ───────────────────────────────────────────────────────────────
# cut_ms <- matches(trn, "top_cut")
# 
# for (i in seq_len(nrow(cut_ms))) {
#   trn <- trn |> result("top_cut", match = cut_ms$id[i], score = c(1, 0))
# }
# 
# # ── Outcomes ──────────────────────────────────────────────────────────────────
# winner(trn)
# rankings(trn)
# routing_log(trn)

