/*
 * Decompiled with CFR 0.152.
 */
package usf.saav.topology.reebgraph.pairing;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.PriorityQueue;
import usf.saav.common.HashDisjointSet;
import usf.saav.common.SystemX;
import usf.saav.topology.TopoGraph;
import usf.saav.topology.TopoTreeNode;
import usf.saav.topology.merge.AbstractMergeTreeNode;
import usf.saav.topology.merge.AugmentedJoinTree;
import usf.saav.topology.merge.AugmentedMergeTree;
import usf.saav.topology.merge.AugmentedSplitTree;
import usf.saav.topology.reebgraph.ReebGraph;
import usf.saav.topology.reebgraph.ReebGraphVertex;
import usf.saav.topology.reebgraph.pairing.Pairing;

public class MergePairing
implements Pairing {
    private String output_directory = "";
    private boolean saveTrees = false;

    public MergePairing() {
        this.saveTrees = false;
    }

    public MergePairing(boolean bl, String string) {
        this.saveTrees = bl;
        this.output_directory = string;
    }

    @Override
    public String getName() {
        return "Merge Pairing";
    }

    @Override
    public void pair(ReebGraph reebGraph) {
        HashSet<TopoGraph.Vertex> hashSet = new HashSet<TopoGraph.Vertex>();
        hashSet.addAll(reebGraph);
        AugmentedJoinTree augmentedJoinTree = new AugmentedJoinTree((TopoGraph<? extends TopoGraph.Vertex>)reebGraph, true);
        if (this.saveTrees) {
            try {
                SystemX.writeStringToFile(augmentedJoinTree.toDot(), this.output_directory + "mt.dot");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        AugmentedSplitTree augmentedSplitTree = new AugmentedSplitTree((TopoGraph<? extends TopoGraph.Vertex>)reebGraph, true);
        if (this.saveTrees) {
            try {
                SystemX.writeStringToFile(augmentedSplitTree.toDot(), this.output_directory + "st.dot");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        ReebGraphVertex reebGraphVertex = this.joinTreePairing(augmentedJoinTree, reebGraph, hashSet);
        ReebGraphVertex reebGraphVertex2 = this.joinTreePairing(augmentedSplitTree, reebGraph, hashSet);
        reebGraphVertex.setPartner(reebGraphVertex2);
        reebGraphVertex2.setPartner(reebGraphVertex);
        for (TopoGraph.Vertex vertex : reebGraph) {
            ReebGraphVertex reebGraphVertex3 = (ReebGraphVertex)vertex;
            if (reebGraphVertex3.getPartner() != null || reebGraphVertex3.getType() != TopoTreeNode.NodeType.DOWNFORK) continue;
            ReebGraphVertex reebGraphVertex4 = this.downforkPairing(reebGraphVertex3);
            reebGraphVertex3.setPartner(reebGraphVertex4);
            reebGraphVertex4.setPartner(reebGraphVertex3);
        }
    }

    private ReebGraphVertex joinTreePairing(AugmentedMergeTree augmentedMergeTree, ReebGraph reebGraph, HashSet<TopoGraph.Vertex> hashSet) {
        ReebGraphVertex reebGraphVertex = null;
        for (int i = 0; i < augmentedMergeTree.size(); ++i) {
            AbstractMergeTreeNode abstractMergeTreeNode = augmentedMergeTree.getNode(i);
            TopoTreeNode topoTreeNode = abstractMergeTreeNode.getPartner();
            ReebGraphVertex reebGraphVertex2 = (ReebGraphVertex)reebGraph.get(abstractMergeTreeNode.getID());
            hashSet.remove(reebGraphVertex2);
            if (topoTreeNode == null) {
                reebGraphVertex = reebGraphVertex2;
                continue;
            }
            reebGraphVertex2.setPartner((ReebGraphVertex)reebGraph.get(topoTreeNode.getID()));
        }
        return reebGraphVertex;
    }

    private ReebGraphVertex downforkPairing(ReebGraphVertex reebGraphVertex) {
        ReebGraphVertex reebGraphVertex2 = null;
        ReebGraphVertex reebGraphVertex3 = null;
        for (ReebGraphVertex object2 : reebGraphVertex.neighbors) {
            if (!(object2.value() < reebGraphVertex.value())) continue;
            reebGraphVertex3 = reebGraphVertex2;
            reebGraphVertex2 = object2;
        }
        if (reebGraphVertex2 == reebGraphVertex3) {
            return reebGraphVertex2;
        }
        PriorityQueue<ReebGraphVertex> priorityQueue = new PriorityQueue<ReebGraphVertex>(new Comparator<ReebGraphVertex>(this){

            @Override
            public int compare(ReebGraphVertex reebGraphVertex, ReebGraphVertex reebGraphVertex2) {
                if (reebGraphVertex.value() > reebGraphVertex2.value()) {
                    return -1;
                }
                return 1;
            }
        });
        priorityQueue.add(reebGraphVertex);
        HashDisjointSet<ReebGraphVertex> hashDisjointSet = new HashDisjointSet<ReebGraphVertex>();
        HashSet<ReebGraphVertex> hashSet = new HashSet<ReebGraphVertex>();
        while (!priorityQueue.isEmpty()) {
            ReebGraphVertex reebGraphVertex4 = (ReebGraphVertex)priorityQueue.poll();
            if (hashSet.contains(reebGraphVertex4)) continue;
            hashSet.add(reebGraphVertex4);
            for (ReebGraphVertex reebGraphVertex5 : reebGraphVertex4.neighbors) {
                if (reebGraphVertex5.value() >= reebGraphVertex.value()) continue;
                if (reebGraphVertex5.value() > reebGraphVertex4.value()) {
                    hashDisjointSet.union(reebGraphVertex4, reebGraphVertex5);
                }
                if (hashSet.contains(reebGraphVertex5)) continue;
                priorityQueue.add(reebGraphVertex5);
            }
            if (hashDisjointSet.find(reebGraphVertex2) != hashDisjointSet.find(reebGraphVertex3)) continue;
            return reebGraphVertex4;
        }
        return null;
    }
}

