/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import java.util.Arrays;
import vcf.Marker;
import vcf.R2Estimator;

public final class VcfRecBuilder {
    public static final int DEFAULT_INIT_SIZE = 50;
    private static final MathContext MC2 = new MathContext(2);
    private static final BigDecimal ONE = new BigDecimal(1.0);
    private static final String[] DS_VALS = VcfRecBuilder.dsProbs();
    private static final String[] R2_VALS = VcfRecBuilder.r2Probs(DS_VALS);
    private final StringBuilder sb;
    private final R2Estimator r2Est;
    private final double[] gt3Probs;
    private Marker marker;
    private boolean printDS;
    private boolean printGP;
    private int nAlleles;
    private int nGenotypes;
    private int allele1;
    private int allele2;
    private double[] gtProbs;
    private double[] dose;
    private double[] cumAlleleProbs;

    private static String[] dsProbs() {
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        String[] stringArray = new String[201];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = decimalFormat.format((double)i / 100.0);
        }
        return stringArray;
    }

    private static String[] r2Probs(String[] stringArray) {
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        String[] stringArray2 = Arrays.copyOf(stringArray, 101);
        for (int i = 0; i < stringArray2.length; ++i) {
            if (stringArray2[i].length() == 4) continue;
            stringArray2[i] = decimalFormat.format((double)i / 100.0);
        }
        return stringArray2;
    }

    public VcfRecBuilder() {
        this(50);
    }

    public VcfRecBuilder(int n) {
        this.sb = new StringBuilder(n);
        this.r2Est = new R2Estimator();
        this.gt3Probs = new double[3];
    }

    public void reset(Marker marker, boolean bl, boolean bl2) {
        this.sb.setLength(0);
        this.r2Est.clear();
        this.marker = marker;
        this.printDS = bl;
        this.printGP = bl2;
        this.allele1 = -1;
        this.allele2 = -1;
        this.nAlleles = marker.nAlleles();
        this.nGenotypes = marker.nGenotypes();
        this.gtProbs = new double[marker.nGenotypes()];
        this.cumAlleleProbs = new double[marker.nAlleles()];
        this.dose = new double[marker.nAlleles()];
    }

    public Marker marker() {
        return this.marker;
    }

    public boolean printDS() {
        return this.printDS;
    }

    public boolean printGP() {
        return this.printGP;
    }

    public void addSampleData(double[] dArray) {
        if (this.marker == null) {
            throw new IllegalStateException();
        }
        Arrays.fill(this.gt3Probs, 0.0);
        Arrays.fill(this.dose, 0.0);
        int n = this.maxIndex(dArray, this.nGenotypes);
        int n2 = 0;
        for (int i = 0; i < this.nAlleles; ++i) {
            for (int j = 0; j <= i; ++j) {
                double d = dArray[n2];
                if (d < 0.0) {
                    throw new IllegalArgumentException(String.valueOf(d));
                }
                this.gtProbs[n2] = d;
                int n3 = j;
                this.dose[n3] = this.dose[n3] + d;
                int n4 = i;
                this.dose[n4] = this.dose[n4] + d;
                if (i == 0) {
                    this.gt3Probs[0] = this.gt3Probs[0] + d;
                } else {
                    int n5 = j == 0 ? 1 : 2;
                    this.gt3Probs[n5] = this.gt3Probs[n5] + d;
                }
                if (n2 == n) {
                    this.allele1 = j;
                    this.allele2 = i;
                }
                ++n2;
            }
        }
        this.addToCumAlleleProbs(this.dose);
        this.r2Est.addSampleData(this.gt3Probs);
        this.appendFormatData(false);
    }

    private int maxIndex(double[] dArray, int n) {
        int n2;
        if (dArray.length != n) {
            throw new IllegalArgumentException(String.valueOf(dArray.length));
        }
        int n3 = 0;
        double d = 0.0;
        for (n2 = 0; n2 < dArray.length; ++n2) {
            if (dArray[n2] < 0.0 || !Double.isFinite(dArray[n2])) {
                throw new IllegalArgumentException(String.valueOf(dArray[n2]));
            }
            d += dArray[n2];
            if (!(dArray[n2] > dArray[n3])) continue;
            n3 = n2;
        }
        if (d != 1.0) {
            n2 = 0;
            while (n2 < dArray.length) {
                int n4 = n2++;
                dArray[n4] = dArray[n4] / d;
            }
        }
        return n3;
    }

    public void addSampleData(double[] dArray, double[] dArray2) {
        int n;
        if (this.marker == null) {
            throw new IllegalStateException();
        }
        Arrays.fill(this.gt3Probs, 0.0);
        this.allele1 = this.maxIndex(dArray, this.nAlleles);
        this.allele2 = this.maxIndex(dArray2, this.nAlleles);
        this.dose[0] = dArray[0] + dArray2[0];
        this.gtProbs[0] = dArray[0] * dArray2[0];
        this.gt3Probs[0] = this.gtProbs[0];
        int n2 = 1;
        for (n = 1; n < dArray.length; ++n) {
            this.dose[n] = dArray[n] + dArray2[n];
            for (int i = 0; i <= n; ++i) {
                double d = dArray[i] * dArray2[n];
                if (i != n) {
                    d += dArray[n] * dArray2[i];
                }
                this.gtProbs[n2++] = d;
                int n3 = i == 0 ? 1 : 2;
                this.gt3Probs[n3] = this.gt3Probs[n3] + d;
            }
        }
        this.addToCumAlleleProbs(this.dose);
        this.r2Est.addSampleData(this.gt3Probs);
        n = 1;
        this.appendFormatData(n != 0);
    }

    private void addToCumAlleleProbs(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            int n = i;
            this.cumAlleleProbs[n] = this.cumAlleleProbs[n] + dArray[i];
        }
    }

    private void appendFormatData(boolean bl) {
        int n;
        this.sb.append('\t');
        this.sb.append(this.allele1);
        this.sb.append(bl ? (char)'|' : '/');
        this.sb.append(this.allele2);
        if (this.printDS) {
            for (n = 1; n < this.nAlleles; ++n) {
                this.sb.append(n == 1 ? (char)':' : ',');
                this.sb.append(DS_VALS[(int)Math.rint(100.0 * this.dose[n])]);
            }
        }
        if (this.printGP) {
            for (n = 0; n < this.gtProbs.length; ++n) {
                this.sb.append(n == 0 ? (char)':' : ',');
                this.sb.append(DS_VALS[(int)Math.rint(100.0 * this.gtProbs[n])]);
            }
        }
    }

    public void writeRec(PrintWriter printWriter, boolean bl) {
        if (this.marker != null) {
            VcfRecBuilder.printMarker(this.marker, printWriter);
            printWriter.print('\t');
            printWriter.print('.');
            printWriter.print('\t');
            printWriter.print("PASS");
            printWriter.print('\t');
            this.printInfo(printWriter, bl);
            printWriter.print('\t');
            printWriter.print(VcfRecBuilder.format(this.printDS, this.printGP));
            printWriter.println(this.sb);
        }
    }

    private void printInfo(PrintWriter printWriter, boolean bl) {
        if (this.printDS || this.printGP) {
            printWriter.print("AR2=");
            printWriter.print(R2_VALS[(int)Math.rint(100.0 * this.r2Est.allelicR2())]);
            printWriter.print(";DR2=");
            printWriter.print(R2_VALS[(int)Math.rint(100.0 * this.r2Est.doseR2())]);
            for (int i = 1; i < this.nAlleles; ++i) {
                printWriter.print(i == 1 ? ";AF=" : Character.valueOf(','));
                printWriter.print(VcfRecBuilder.formatProb(this.cumAlleleProbs[i] / (double)(2 * this.r2Est.nGenotypes())));
            }
            if (bl) {
                printWriter.print(";IMP");
            }
        } else {
            printWriter.print('.');
        }
    }

    private static String format(boolean bl, boolean bl2) {
        if (bl) {
            return bl2 ? "GT:DS:GP" : "GT:DS";
        }
        return "GT";
    }

    private static void printMarker(Marker marker, PrintWriter printWriter) {
        int n;
        printWriter.print(marker.chrom());
        printWriter.print('\t');
        printWriter.print(marker.pos());
        int n2 = marker.nIds();
        if (n2 == 0) {
            printWriter.print('\t');
            printWriter.print('.');
        } else {
            for (n = 0; n < n2; ++n) {
                printWriter.print(n == 0 ? (char)'\t' : ';');
                printWriter.print(marker.id(n));
            }
        }
        n = marker.nAlleles();
        if (n == 1) {
            printWriter.print('\t');
            printWriter.print(marker.allele(0));
            printWriter.print('\t');
            printWriter.print('.');
        } else {
            for (int i = 0; i < n; ++i) {
                printWriter.print(i < 2 ? (char)'\t' : ',');
                printWriter.print(marker.allele(i));
            }
        }
    }

    private static String formatProb(double d) {
        if (d >= 0.0 && d <= 0.5) {
            return new BigDecimal(d).round(MC2).toString();
        }
        if (d <= 1.0) {
            return new BigDecimal(d - 1.0).round(MC2).add(ONE).toString();
        }
        throw new IllegalArgumentException(String.valueOf(d));
    }
}

