## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.width = 6,
  fig.height = 4
)

## ----setup--------------------------------------------------------------------
library(neuromapr)

## ----vertices-to-parcels------------------------------------------------------
set.seed(42)
n_vertices <- 1000
vertex_data <- rnorm(n_vertices)

labels <- sample(
  c(0, 1:10), n_vertices,
  replace = TRUE, prob = c(0.1, rep(0.09, 10))
)

parcel_values <- vertices_to_parcels(vertex_data, labels)
parcel_values

## ----custom-summary-----------------------------------------------------------
parcel_sd <- vertices_to_parcels(
  vertex_data, labels, summary_func = sd
)
parcel_sd

## ----parcels-to-vertices------------------------------------------------------
vertex_filled <- parcels_to_vertices(parcel_values, labels)
head(vertex_filled, 20)

## ----custom-fill--------------------------------------------------------------
vertex_filled_zero <- parcels_to_vertices(
  parcel_values, labels, fill = 0
)
sum(vertex_filled_zero == 0)

## ----parcellate-vectors-------------------------------------------------------
parcellated <- parcellate(vertex_data, labels)
unparcellated <- unparcellate(parcellated, labels)

all.equal(
  parcels_to_vertices(parcel_values, labels),
  unparcellated
)

## ----centroids-setup----------------------------------------------------------
vertices <- matrix(rnorm(n_vertices * 3), ncol = 3)

## ----centroid-average---------------------------------------------------------
centroids_avg <- get_parcel_centroids(
  vertices, labels, method = "average"
)
head(centroids_avg)

## ----centroid-surface---------------------------------------------------------
centroids_surf <- get_parcel_centroids(
  vertices, labels, method = "surface"
)
head(centroids_surf)

## ----parcel-distmat-----------------------------------------------------------
parcel_distmat <- as.matrix(dist(centroids_avg))
dim(parcel_distmat)

## ----parcel-nulls-------------------------------------------------------------
parcel_map <- rnorm(nrow(centroids_avg))
nulls <- generate_nulls(
  parcel_map,
  method = "moran",
  distmat = parcel_distmat,
  n_perm = 100L,
  seed = 1
)
nulls

## ----parcel-spin--------------------------------------------------------------
n_lh <- 680
n_rh <- 680
sphere_coords <- list(
  lh = matrix(rnorm(n_lh * 3), ncol = 3),
  rh = matrix(rnorm(n_rh * 3), ncol = 3)
)
parcellation <- rep(1:68, each = 20)
parcel_data <- rnorm(68)

nulls_baum <- null_baum(
  parcel_data, sphere_coords, parcellation,
  n_perm = 50L, seed = 1
)
nulls_baum

