/*
 * Decompiled with CFR 0.152.
 */
package usf.saav.topology.reebgraph;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import usf.saav.cmd.MergePairingInput;
import usf.saav.topology.reebgraph.ReebGraph;
import usf.saav.topology.reebgraph.ReebGraphVertex;

public class ReebGraphLoader
extends ReebGraph {
    private static final long serialVersionUID = 7889260039234787058L;

    public static ArrayList<ReebGraph> load(MergePairingInput mergePairingInput, boolean bl, boolean bl2, boolean bl3) throws Exception {
        int n;
        HashMap<Integer, ReebGraphVertex> hashMap = new HashMap<Integer, ReebGraphVertex>();
        ReebGraph reebGraph = new ReebGraph();
        if (mergePairingInput.getVertexWeights().length != mergePairingInput.getVertexIds().length) {
            throw new Exception("ERROR: Length of vertex ID array and vertex weight array do not match!");
        }
        if (mergePairingInput.getEdgeDestinationIds().length != mergePairingInput.getEdgeOriginIds().length) {
            throw new Exception("ERROR: Edge ID array and edge origin IDs do not match!");
        }
        if (mergePairingInput.getVertexIds().length == 0 || mergePairingInput.getVertexWeights().length == 0) {
            throw new Exception("ERROR: Vertex ID array or vertex weights array have length 0");
        }
        if (mergePairingInput.getEdgeOriginIds().length == 0 || mergePairingInput.getEdgeDestinationIds().length == 0) {
            throw new Exception("ERROR: Edge ID array or edge origin IDs have length 0");
        }
        for (n = 0; n < mergePairingInput.getVertexIds().length; ++n) {
            int n2 = mergePairingInput.getVertexIds()[n];
            float f = mergePairingInput.getVertexWeights()[n];
            ReebGraphVertex reebGraphVertex = new ReebGraphVertex(f, f, n2);
            reebGraph.add(reebGraphVertex);
            hashMap.put(n2, reebGraphVertex);
        }
        for (n = 0; n < mergePairingInput.getEdgeOriginIds().length; ++n) {
            ReebGraphVertex reebGraphVertex = (ReebGraphVertex)hashMap.get(mergePairingInput.getEdgeOriginIds()[n]);
            ReebGraphVertex reebGraphVertex2 = (ReebGraphVertex)hashMap.get(mergePairingInput.getEdgeDestinationIds()[n]);
            if (reebGraphVertex == null || reebGraphVertex2 == null) {
                throw new Exception("ERROR: Edge input is invalid for edge numbered: " + n);
            }
            if (reebGraphVertex == reebGraphVertex2) {
                if (!bl3) continue;
                System.err.println("WARNING: Self referenced edge (ignored) " + String.valueOf(reebGraphVertex) + " " + String.valueOf(reebGraphVertex2));
                continue;
            }
            reebGraphVertex.addNeighbor(reebGraphVertex2);
            reebGraphVertex2.addNeighbor(reebGraphVertex);
        }
        reebGraph.resetInternalIDs();
        reebGraph.resetInternalValues();
        if (bl) {
            return ReebGraphLoader.extractConnectedGraphs(hashMap.values(), bl2);
        }
        ArrayList<ReebGraph> arrayList = new ArrayList<ReebGraph>();
        if (bl2) {
            arrayList.add(ReebGraphLoader.condition(hashMap.values(), 0.05f));
        } else {
            arrayList.add(reebGraph);
        }
        return arrayList;
    }

    public static ArrayList<ReebGraph> load(String string, boolean bl, boolean bl2, boolean bl3) throws Exception {
        Object object;
        String string2;
        HashMap<Integer, ReebGraphVertex> hashMap = new HashMap<Integer, ReebGraphVertex>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        ReebGraph reebGraph = new ReebGraph();
        while ((string2 = bufferedReader.readLine()) != null) {
            object = string2.split("\\s");
            if (((String[])object).length == 0) continue;
            if (object[0].trim().equals("v")) {
                if (((String[])object).length != 3) {
                    bufferedReader.close();
                    throw new Exception("ERROR: Invalid vertex input");
                }
                int n = Integer.parseInt(((String)object[1]).trim());
                float f = Float.parseFloat(((String)object[2]).trim());
                ReebGraphVertex reebGraphVertex = new ReebGraphVertex(f, f, n);
                reebGraph.add(reebGraphVertex);
                hashMap.put(n, reebGraphVertex);
            }
            if (!((String)object[0]).trim().equals("e")) continue;
            if (((Object)object).length != 3) {
                bufferedReader.close();
                throw new Exception("ERROR: Invalid edge input");
            }
            ReebGraphVertex reebGraphVertex = (ReebGraphVertex)hashMap.get(Integer.parseInt((String)object[1]));
            ReebGraphVertex reebGraphVertex2 = (ReebGraphVertex)hashMap.get(Integer.parseInt((String)object[2]));
            if (reebGraphVertex == null || reebGraphVertex2 == null) {
                bufferedReader.close();
                throw new Exception("ERROR: Edge not found " + (String)object[1] + " " + (String)object[2]);
            }
            if (reebGraphVertex == reebGraphVertex2) {
                if (!bl3) continue;
                System.err.println("WARNING: Self referenced edge (ignored) " + String.valueOf(reebGraphVertex) + " " + String.valueOf(reebGraphVertex2));
                continue;
            }
            reebGraphVertex.addNeighbor(reebGraphVertex2);
            reebGraphVertex2.addNeighbor(reebGraphVertex);
        }
        bufferedReader.close();
        reebGraph.resetInternalIDs();
        reebGraph.resetInternalValues();
        if (bl) {
            return ReebGraphLoader.extractConnectedGraphs(hashMap.values(), bl2);
        }
        object = new ArrayList();
        if (bl2) {
            ((ArrayList)object).add(ReebGraphLoader.condition(hashMap.values(), 0.05f));
        } else {
            ((ArrayList)object).add(reebGraph);
        }
        return object;
    }

    private static ArrayList<ReebGraph> extractConnectedGraphs(Collection<ReebGraphVertex> collection, boolean bl) {
        ArrayList<ReebGraph> arrayList = new ArrayList<ReebGraph>();
        HashSet<ReebGraphVertex> hashSet = new HashSet<ReebGraphVertex>();
        for (ReebGraphVertex reebGraphVertex : collection) {
            if (hashSet.contains(reebGraphVertex)) continue;
            ArrayList<ReebGraphVertex> arrayList2 = new ArrayList<ReebGraphVertex>();
            ReebGraphLoader.dfs(arrayList2, reebGraphVertex, hashSet);
            if (bl) {
                arrayList.add(ReebGraphLoader.condition(arrayList2, 0.05f));
                continue;
            }
            arrayList.add(new ReebGraph((Collection<ReebGraphVertex>)arrayList2));
        }
        return arrayList;
    }

    private static void dfs(ArrayList<ReebGraphVertex> arrayList, ReebGraphVertex reebGraphVertex, HashSet<ReebGraphVertex> hashSet) {
        ArrayDeque<ReebGraphVertex> arrayDeque = new ArrayDeque<ReebGraphVertex>();
        arrayDeque.add(reebGraphVertex);
        while (!arrayDeque.isEmpty()) {
            ReebGraphVertex reebGraphVertex2 = (ReebGraphVertex)arrayDeque.pop();
            if (hashSet.contains(reebGraphVertex2)) continue;
            hashSet.add(reebGraphVertex2);
            arrayList.add(reebGraphVertex2);
            for (ReebGraphVertex reebGraphVertex3 : reebGraphVertex2.neighbors) {
                if (hashSet.contains(reebGraphVertex3)) continue;
                arrayDeque.push(reebGraphVertex3);
            }
        }
    }

    private static ReebGraph condition(Collection<ReebGraphVertex> collection, float f) {
        LinkedList<ReebGraphVertex> linkedList = new LinkedList<ReebGraphVertex>(collection);
        ReebGraph reebGraph = new ReebGraph();
        while (!linkedList.isEmpty()) {
            ReebGraphVertex reebGraphVertex = (ReebGraphVertex)linkedList.poll();
            int n = 0;
            int n2 = 0;
            float f2 = Float.MAX_VALUE;
            float f3 = Float.MAX_VALUE;
            for (ReebGraphVertex reebGraphVertex2 : reebGraphVertex.neighbors) {
                if (reebGraphVertex.value() < reebGraphVertex2.value()) {
                    ++n;
                    f2 = Math.min(f2, reebGraphVertex2.value() - reebGraphVertex.value());
                }
                if (!(reebGraphVertex.value() > reebGraphVertex2.value())) continue;
                ++n2;
                f3 = Math.min(f3, reebGraphVertex.value() - reebGraphVertex2.value());
            }
            if (n == 1 && n2 == 1) {
                ReebGraphLoader.conditionNonCritical(reebGraphVertex);
                continue;
            }
            if (n >= 2 && n2 >= 2) {
                ReebGraphLoader.conditionDoubleFork(reebGraphVertex, linkedList, f2 * f);
                continue;
            }
            if (n == 0 && n2 >= 2) {
                ReebGraphLoader.conditionSaddleMax(reebGraphVertex, linkedList, f3 * f);
                continue;
            }
            if (n >= 2 && n2 == 0) {
                ReebGraphLoader.conditionSaddleMin(reebGraphVertex, linkedList, f2 * f);
                continue;
            }
            if (n == 1 && n2 > 2) {
                ReebGraphLoader.conditionMonkeyDownFork(reebGraphVertex, linkedList, f3 * f);
                continue;
            }
            if (n2 == 1 && n > 2) {
                ReebGraphLoader.conditionMonkeyUpFork(reebGraphVertex, linkedList, f2 * f);
                continue;
            }
            if (n == 1 && n2 == 2) {
                reebGraph.add(reebGraphVertex);
                continue;
            }
            if (n == 2 && n2 == 1) {
                reebGraph.add(reebGraphVertex);
                continue;
            }
            if (n == 0 && n2 == 1) {
                reebGraph.add(reebGraphVertex);
                continue;
            }
            if (n == 1 && n2 == 0) {
                reebGraph.add(reebGraphVertex);
                continue;
            }
            System.out.println("WARNING: " + n2 + " " + n);
            reebGraph.add(reebGraphVertex);
        }
        reebGraph.resetInternalIDs();
        reebGraph.resetInternalValues();
        return reebGraph;
    }

    private static void conditionNonCritical(ReebGraphVertex reebGraphVertex) {
        ReebGraphVertex reebGraphVertex2 = reebGraphVertex.neighbors.get(0);
        ReebGraphVertex reebGraphVertex3 = reebGraphVertex.neighbors.get(1);
        reebGraphVertex2.neighbors.remove(reebGraphVertex);
        reebGraphVertex3.neighbors.remove(reebGraphVertex);
        ReebGraphVertex.setNeighbors(reebGraphVertex2, reebGraphVertex3);
    }

    private static void conditionDoubleFork(ReebGraphVertex reebGraphVertex, Queue<ReebGraphVertex> queue, float f) {
        ReebGraphVertex reebGraphVertex2 = new ReebGraphVertex(reebGraphVertex.value(), reebGraphVertex.getRealValue(), reebGraphVertex.getGlobalID());
        ReebGraphVertex reebGraphVertex3 = new ReebGraphVertex(reebGraphVertex.value() + f, reebGraphVertex.getRealValue(), reebGraphVertex.getGlobalID());
        ReebGraphVertex.setNeighbors(reebGraphVertex2, reebGraphVertex3);
        for (ReebGraphVertex reebGraphVertex4 : reebGraphVertex.neighbors) {
            reebGraphVertex4.neighbors.remove(reebGraphVertex);
            if (reebGraphVertex.value() < reebGraphVertex4.value()) {
                ReebGraphVertex.setNeighbors(reebGraphVertex4, reebGraphVertex3);
                continue;
            }
            ReebGraphVertex.setNeighbors(reebGraphVertex4, reebGraphVertex2);
        }
        queue.add(reebGraphVertex2);
        queue.add(reebGraphVertex3);
    }

    private static void conditionMonkeyUpFork(ReebGraphVertex reebGraphVertex, Queue<ReebGraphVertex> queue, float f) {
        ReebGraphVertex reebGraphVertex2 = new ReebGraphVertex(reebGraphVertex.value() + f, reebGraphVertex.getRealValue(), reebGraphVertex.getGlobalID());
        ReebGraphVertex reebGraphVertex3 = new ReebGraphVertex(reebGraphVertex.value(), reebGraphVertex.getRealValue(), reebGraphVertex.getGlobalID());
        int n = 0;
        ReebGraphVertex.setNeighbors(reebGraphVertex3, reebGraphVertex2);
        for (ReebGraphVertex reebGraphVertex4 : reebGraphVertex.neighbors) {
            reebGraphVertex4.neighbors.remove(reebGraphVertex);
            if (reebGraphVertex4.value() < reebGraphVertex.value()) {
                ReebGraphVertex.setNeighbors(reebGraphVertex3, reebGraphVertex4);
                continue;
            }
            if (n == 0) {
                ReebGraphVertex.setNeighbors(reebGraphVertex3, reebGraphVertex4);
            } else {
                ReebGraphVertex.setNeighbors(reebGraphVertex2, reebGraphVertex4);
            }
            ++n;
        }
        queue.add(reebGraphVertex3);
        queue.add(reebGraphVertex2);
    }

    private static void conditionMonkeyDownFork(ReebGraphVertex reebGraphVertex, Queue<ReebGraphVertex> queue, float f) {
        ReebGraphVertex reebGraphVertex2 = new ReebGraphVertex(reebGraphVertex.value() - f, reebGraphVertex.getRealValue(), reebGraphVertex.getGlobalID());
        ReebGraphVertex reebGraphVertex3 = new ReebGraphVertex(reebGraphVertex.value(), reebGraphVertex.getRealValue(), reebGraphVertex.getGlobalID());
        int n = 0;
        ReebGraphVertex.setNeighbors(reebGraphVertex3, reebGraphVertex2);
        for (ReebGraphVertex reebGraphVertex4 : reebGraphVertex.neighbors) {
            reebGraphVertex4.neighbors.remove(reebGraphVertex);
            if (reebGraphVertex4.value() > reebGraphVertex.value()) {
                ReebGraphVertex.setNeighbors(reebGraphVertex3, reebGraphVertex4);
                continue;
            }
            if (n == 0) {
                ReebGraphVertex.setNeighbors(reebGraphVertex3, reebGraphVertex4);
            } else {
                ReebGraphVertex.setNeighbors(reebGraphVertex2, reebGraphVertex4);
            }
            ++n;
        }
        queue.add(reebGraphVertex3);
        queue.add(reebGraphVertex2);
    }

    private static void conditionSaddleMax(ReebGraphVertex reebGraphVertex, Queue<ReebGraphVertex> queue, float f) {
        ReebGraphVertex reebGraphVertex2 = new ReebGraphVertex(reebGraphVertex.value() + f, reebGraphVertex.getRealValue(), reebGraphVertex.getGlobalID());
        ReebGraphVertex.setNeighbors(reebGraphVertex, reebGraphVertex2);
        queue.add(reebGraphVertex2);
        queue.add(reebGraphVertex);
    }

    private static void conditionSaddleMin(ReebGraphVertex reebGraphVertex, Queue<ReebGraphVertex> queue, float f) {
        ReebGraphVertex reebGraphVertex2 = new ReebGraphVertex(reebGraphVertex.value() - f, reebGraphVertex.getRealValue(), reebGraphVertex.getGlobalID());
        ReebGraphVertex.setNeighbors(reebGraphVertex, reebGraphVertex2);
        queue.add(reebGraphVertex2);
        queue.add(reebGraphVertex);
    }
}

