/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.linearsystem;

import java.util.Arrays;
import jdplus.toolkit.base.api.math.Constants;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearsystem.LinearSystemSolver;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixException;

public final class LULinearSystemSolver2
implements LinearSystemSolver {
    private final double eps;

    public LULinearSystemSolver2(double eps) {
        this.eps = eps;
    }

    public LULinearSystemSolver2() {
        this.eps = Constants.getEpsilon();
    }

    @Override
    public void solve(FastMatrix A, DataBlock b) throws MatrixException {
        int n = A.getRowsCount();
        if (b.length() != n) {
            throw new MatrixException("m_err_dim");
        }
        FastMatrix col = FastMatrix.columnOf(b);
        this.solve(A, col);
        b.copy(col.column(0));
    }

    @Override
    public void solve(FastMatrix A, FastMatrix B) throws MatrixException {
        if (!A.isSquare()) {
            throw new MatrixException("m_err_dim");
        }
        int n = A.getRowsCount();
        int nl = n + B.getColumnsCount();
        if (B.getRowsCount() != n) {
            throw new MatrixException("m_err_dim");
        }
        double[] X = new double[n * nl];
        A.copyTo(X, 0);
        B.copyTo(X, n * n);
        int[] m = new int[nl];
        Arrays.fill(m, -1);
        for (int i = 0; i < n; ++i) {
            double u = Double.MIN_VALUE;
            int c = -1;
            int k = 0;
            int ik = i;
            while (k < n) {
                double a;
                double absa;
                if (m[k] == -1 && (absa = Math.abs(a = X[ik])) > u) {
                    c = k;
                    u = absa;
                }
                ++k;
                ik += n;
            }
            if (c < 0) {
                throw new MatrixException();
            }
            m[c] = i;
            int ic = i + c * n;
            double xmax = X[ic];
            if (Math.abs(xmax) < this.eps) {
                throw new MatrixException("m_err_sing");
            }
            double pivot = 1.0 / xmax;
            int j = 0;
            int jc = c * n;
            while (j < n) {
                double a;
                if (j != i && (a = X[jc]) != 0.0) {
                    double fac = pivot * a;
                    int k2 = 0;
                    int ik2 = i;
                    int jk = j;
                    while (k2 < nl) {
                        if (m[k2] == -1) {
                            double aik = X[ik2];
                            int n2 = jk;
                            X[n2] = X[n2] - fac * aik;
                        }
                        ++k2;
                        ik2 += n;
                        jk += n;
                    }
                }
                ++j;
                ++jc;
            }
            int k3 = 0;
            int ik3 = i;
            while (k3 < nl) {
                if (m[k3] == -1) {
                    int n3 = ik3;
                    X[n3] = X[n3] * pivot;
                }
                ++k3;
                ik3 += n;
            }
        }
        int kmax = n * nl;
        int l = 0;
        for (int kn = n * n; kn < kmax; kn += n) {
            for (int i = 0; i < n; ++i) {
                if (m[i] == -1) continue;
                B.set(i, l, X[m[i] + kn]);
            }
            ++l;
        }
    }
}

