/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.tramo.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jdplus.sa.base.api.SaVariable;
import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TimeSelector;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.regression.IOutlier;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.modelling.regression.AdditiveOutlierFactory;
import jdplus.toolkit.base.core.modelling.regression.IOutlierFactory;
import jdplus.toolkit.base.core.modelling.regression.LevelShiftFactory;
import jdplus.toolkit.base.core.modelling.regression.PeriodicOutlierFactory;
import jdplus.toolkit.base.core.modelling.regression.TransitoryChangeFactory;
import jdplus.toolkit.base.core.regarima.RegArimaUtility;
import jdplus.toolkit.base.core.regarima.outlier.FastOutlierDetector;
import jdplus.toolkit.base.core.regarima.outlier.SingleOutlierDetector;
import jdplus.toolkit.base.core.regsarima.ami.FastOutliersDetector;
import jdplus.toolkit.base.core.regsarima.regular.IOutliersDetectionModule;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.regsarima.regular.ProcessingResult;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.tramoseats.base.core.tramo.internal.TramoUtility;

public class OutliersDetectionModule
implements IOutliersDetectionModule {
    public static int DEF_MAXROUND = 50;
    public static int DEF_MAXOUTLIERS = 30;
    public static final double EPS = 1.0E-7;
    private final double eps;
    private final int maxOutliers;
    private final int maxRound;
    private final boolean ao;
    private final boolean ls;
    private final boolean tc;
    private final boolean so;
    private final boolean ml;
    private final double tcrate;
    private final TimeSelector span;

    public static Builder builder() {
        return new Builder();
    }

    private OutliersDetectionModule(Builder builder) {
        this.eps = builder.eps;
        this.maxOutliers = builder.maxOutliers;
        this.maxRound = builder.maxRound;
        this.ao = builder.ao;
        this.ls = builder.ls;
        this.tc = builder.tc;
        this.so = builder.so;
        this.tcrate = builder.tcrate;
        this.span = builder.span;
        this.ml = builder.ml;
    }

    private FastOutliersDetector make(ModelDescription desc, double cv) {
        TsDomain domain = desc.getEstimationDomain();
        int test = this.comatip(desc);
        if (test < 0) {
            return null;
        }
        boolean cmvx = test > 0;
        FastOutliersDetector.Builder builder = FastOutliersDetector.builder().singleOutlierDetector(this.factories(desc.getAnnualFrequency())).criticalValue(cv).maximumLikelihood(cmvx).maxOutliers(this.maxOutliers).maxRound(this.maxRound).processor(RegArimaUtility.processor((boolean)true, (double)this.eps));
        FastOutliersDetector impl = builder.build();
        TsDomain odom = domain.select(this.span);
        int start = domain.indexOf(odom.getStartPeriod());
        int end = start + odom.getLength();
        impl.prepare(domain.getLength());
        impl.setBounds(start, end);
        String[] types = impl.outlierTypes();
        int[] missing = desc.getMissingInEstimationDomain();
        if (missing != null) {
            for (int i = 0; i < missing.length; ++i) {
                for (int j = 0; j < types.length; ++j) {
                    impl.exclude(missing[i], j);
                }
            }
        }
        desc.variables().filter(var -> var.getCore() instanceof IOutlier).map(var -> (IOutlier)var.getCore()).forEach(o -> impl.exclude(domain.indexOf(o.getPosition()), OutliersDetectionModule.outlierType(types, o.getCode())));
        return impl;
    }

    private SingleOutlierDetector<SarimaModel> factories(int period) {
        FastOutlierDetector detector = new FastOutlierDetector(null);
        ArrayList<Object> factories = new ArrayList<Object>();
        if (this.ao) {
            factories.add(AdditiveOutlierFactory.FACTORY);
        }
        if (this.ls) {
            factories.add(LevelShiftFactory.FACTORY_ZEROENDED);
        }
        if (this.tc) {
            factories.add(new TransitoryChangeFactory(this.tcrate));
        }
        if (this.so && period > 1) {
            factories.add(new PeriodicOutlierFactory(period, true));
        }
        detector.setOutlierFactories((IOutlierFactory[])factories.toArray(IOutlierFactory[]::new));
        return detector;
    }

    private Map<String, String> attributes(IOutlier o) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("ami", "tramo");
        attributes.put("regeffect", SaVariable.defaultComponentTypeOf((IOutlier)o).name());
        return attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessingResult process(RegSarimaModelling context, double criticalValue) {
        ProcessingLog log = context.getLog();
        log.push("outliers selection");
        try {
            ModelDescription model = context.getDescription();
            TsDomain domain = model.getEstimationDomain();
            FastOutliersDetector impl = this.make(model, criticalValue);
            if (impl == null) {
                ProcessingResult processingResult = ProcessingResult.Failed;
                return processingResult;
            }
            boolean ok = impl.process(model.regarima(), model.mapping());
            if (!ok) {
                ProcessingResult processingResult = ProcessingResult.Failed;
                return processingResult;
            }
            int[][] outliers = impl.getOutliers();
            log.info((String)(switch (outliers.length) {
                case 0 -> "no outlier selected";
                case 1 -> " outlier selected";
                default -> outliers.length + " outliers selected";
            }), (Object)new IOutliersDetectionModule.Info(impl.outlierTypes(), outliers, criticalValue));
            if (outliers.length == 0) {
                ProcessingResult processingResult = ProcessingResult.Unchanged;
                return processingResult;
            }
            for (int i = 0; i < outliers.length; ++i) {
                int[] cur = outliers[i];
                TsPeriod pos = domain.get(cur[0]);
                IOutlier o = impl.getFactory(cur[1]).make(pos.start());
                model.addVariable(Variable.variable((String)IOutlier.defaultName((String)o.getCode(), (TsPeriod)pos), (ITsVariable)o, this.attributes(o)));
            }
            context.clearEstimation();
            ProcessingResult processingResult = ProcessingResult.Changed;
            return processingResult;
        }
        catch (RuntimeException err) {
            ProcessingResult processingResult = ProcessingResult.Failed;
            return processingResult;
        }
        finally {
            log.pop();
        }
    }

    private static int outlierType(String[] all, String cur) {
        for (int i = 0; i < all.length; ++i) {
            if (!cur.equals(all[i])) continue;
            return i;
        }
        return -1;
    }

    private int comatip(ModelDescription desc) {
        SarimaOrders spec;
        int nparm;
        int n = desc.getSeries().getValues().count(x -> Double.isFinite(x));
        if (n - (nparm = Math.max((spec = desc.specification()).getD() + spec.getP() + spec.getPeriod() * (spec.getBd() + spec.getBp()), spec.getQ() + spec.getPeriod() * spec.getBq()) + (desc.isMean() ? 1 : 0) + 15 * n / 100 + spec.getPeriod()) <= 0) {
            return -1;
        }
        if (this.ml) {
            return 1;
        }
        int ndf1 = TramoUtility.autlar(n, spec);
        int ndf2 = 0;
        if (spec.getP() + spec.getBp() > 0 && spec.getQ() + spec.getBq() > 0) {
            spec.setP(0);
            spec.setBp(0);
            ndf2 = TramoUtility.autlar(n -= spec.getP() + spec.getPeriod() * spec.getBp(), spec);
        }
        if (ndf1 < 0 || ndf2 < 0) {
            return 1;
        }
        return 0;
    }

    public static class Builder {
        private double eps = 1.0E-7;
        private int maxOutliers = DEF_MAXOUTLIERS;
        private int maxRound = DEF_MAXROUND;
        private boolean ao;
        private boolean ls;
        private boolean tc;
        private boolean so;
        private double tcrate;
        private boolean ml;
        private TimeSelector span = TimeSelector.all();

        private Builder() {
        }

        public Builder span(TimeSelector span) {
            this.span = span;
            return this;
        }

        public Builder precision(double eps) {
            this.eps = eps;
            return this;
        }

        public Builder tcrate(double tcrate) {
            this.tcrate = tcrate;
            return this;
        }

        public Builder ao(boolean ao) {
            this.ao = ao;
            return this;
        }

        public Builder ls(boolean ls) {
            this.ls = ls;
            return this;
        }

        public Builder tc(boolean tc) {
            this.tc = tc;
            return this;
        }

        public Builder so(boolean so) {
            this.so = so;
            return this;
        }

        public Builder maxOutliers(int max) {
            this.maxOutliers = max;
            return this;
        }

        public Builder maxRound(int max) {
            this.maxRound = max;
            return this;
        }

        public Builder maximumLikelihood(boolean ml) {
            this.ml = ml;
            return this;
        }

        public OutliersDetectionModule build() {
            return new OutliersDetectionModule(this);
        }
    }
}

