/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.api.x13;

import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import jdplus.x13.base.api.x13.X13;

public final class X13Loader {

    public static final class Processor {
        private final Iterable<X13.Processor> source = ServiceLoader.load(X13.Processor.class);
        private final AtomicReference<X13.Processor> resource = new AtomicReference<X13.Processor>(this.doLoad());
        private final Consumer<Iterable> cleaner = loader -> ((ServiceLoader)loader).reload();

        private X13.Processor doLoad() {
            return StreamSupport.stream(this.source.spliterator(), false).findFirst().orElseGet(() -> new X13.DefProcessor());
        }

        public X13.Processor get() {
            return this.resource.get();
        }

        public void set(X13.Processor newValue) {
            this.resource.set(Objects.requireNonNull(newValue));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reload() {
            Iterable<X13.Processor> iterable = this.source;
            synchronized (iterable) {
                this.cleaner.accept(this.source);
                this.set(this.doLoad());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            Iterable<X13.Processor> iterable = this.source;
            synchronized (iterable) {
                this.set(this.doLoad());
            }
        }
    }
}

