## ----knitr_setup, include = FALSE, echo=FALSE---------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----load_packages, message=FALSE, warning=FALSE------------------------------
library(aquacultuR)
library(magrittr)
library(dplyr)

## ----options------------------------------------------------------------------
oldopts <- options()
options(digits = 3)

## -----------------------------------------------------------------------------
digestdm

## -----------------------------------------------------------------------------
digestnut

## -----------------------------------------------------------------------------
digestingr

## ----calculate_adc_dm_short---------------------------------------------------
digestdm %>%
  group_by(diet) %>%
  summarise(`ADC DM` = adc_dm(std_diet = std_feed, std_feces = std_feces))

## ----calculate_adc_dm_additional_arguments------------------------------------
digestdm %>%
  group_by(diet) %>%
  summarise(`ADC DM` = adc_dm(
    dm = dm,
    std_diet = std_feed,
    std_feces = std_feces
  ))

## ----calculate_adc_nut--------------------------------------------------------
digestnut %>%
  group_by(diet) %>%
  summarise(
    `ADC CP` = adc_nut(
      std_diet = std_feed,
      std_feces = std_feces,
      nut_diet = N_feed,
      nut_feces = N_feces
    )
  )

## ----calculate_adc_ingr_short-------------------------------------------------
digestingr %>%
  summarise(
    `ADC Ingredient` = adc_ingr(
      adc_test = adc_test,
      adc_ref = adc_reference,
      nut_ref = CP_reference,
      nut_ingr = CP_ingr
    )
  )

## ----calculate_adc_ingr_additional_arguments----------------------------------
digestingr %>%
  summarise(
    `ADC Ingredient` = adc_ingr(
      adc_test = adc_test,
      adc_ref = adc_reference,
      nut_ref = CP_reference,
      nut_ingr = CP_ingr,
      dm_ref = dm_reference,
      dm_ingr = dm_ingr
    )
  )

## ----show_session_info--------------------------------------------------------
sessionInfo()

## ----reset_options------------------------------------------------------------
options(oldopts)

