/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.seats;

import jdplus.sa.base.api.ComponentType;
import jdplus.sa.base.api.DecompositionMode;
import jdplus.sa.base.api.SeriesDecomposition;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.modelling.ComponentInformation;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.QuadraticForm;
import jdplus.toolkit.base.core.ssf.arima.SsfUcarima;
import jdplus.toolkit.base.core.ssf.composite.CompositeSsf;
import jdplus.toolkit.base.core.ssf.dk.DkToolkit;
import jdplus.toolkit.base.core.ssf.univariate.DefaultSmoothingResults;
import jdplus.toolkit.base.core.ssf.univariate.ExtendedSsfData;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;
import jdplus.toolkit.base.core.ssf.univariate.SsfData;
import jdplus.toolkit.base.core.ucarima.UcarimaModel;
import jdplus.tramoseats.base.core.seats.IComponentsEstimator;
import jdplus.tramoseats.base.core.seats.SeatsModel;

public class KalmanEstimator
implements IComponentsEstimator {
    private final int nfcasts;
    private final int nbcasts;

    public KalmanEstimator(int nbcasts, int nfcasts) {
        this.nfcasts = nfcasts;
        this.nbcasts = nbcasts;
    }

    @Override
    public SeriesDecomposition decompose(SeatsModel model) {
        int j;
        double[] e;
        double[] a;
        TsData cmp;
        DefaultSmoothingResults srslts;
        SeriesDecomposition.Builder builder = SeriesDecomposition.builder((DecompositionMode)DecompositionMode.Additive);
        TsData s = model.getTransformedSeries();
        builder.add(s, ComponentType.Series);
        int n = s.length();
        int nf = model.extrapolationCount(this.nfcasts);
        int nb = model.extrapolationCount(this.nbcasts);
        ComponentType[] cmps = model.componentsType();
        UcarimaModel ucm = model.compactUcarimaModel(true, true);
        CompositeSsf ssf = SsfUcarima.of((UcarimaModel)ucm);
        ExtendedSsfData data = new ExtendedSsfData((ISsfData)new SsfData(s.getValues()), nb, nf);
        double mvar = model.getInnovationVariance();
        if (mvar != 0.0) {
            srslts = DkToolkit.sqrtSmooth((ISsf)ssf, (ISsfData)data, (boolean)true, (boolean)false);
            srslts.rescaleVariances(mvar);
        } else {
            srslts = DkToolkit.sqrtSmooth((ISsf)ssf, (ISsfData)data, (boolean)true, (boolean)true);
        }
        TsPeriod start = s.getStart();
        TsPeriod bstart = start.plus((long)(-nb));
        TsPeriod fstart = start.plus((long)n);
        int[] pos = ssf.componentsPosition();
        int scmp = -1;
        for (int i = 0; i < pos.length; ++i) {
            ComponentType type = cmps[i];
            if (type == ComponentType.Seasonal) {
                scmp = i;
            }
            cmp = TsData.of((TsPeriod)bstart, (DoubleSeq)srslts.getComponent(pos[i]));
            if (nb > 0) {
                builder.add(cmp.range(0, nb), type, ComponentInformation.Backcast);
            }
            if (nf > 0) {
                builder.add(cmp.extract(nb + n, nf), type, ComponentInformation.Forecast);
            }
            builder.add(cmp.extract(nb, n), type);
            cmp = TsData.of((TsPeriod)bstart, (DoubleSeq)srslts.getComponentVariance(pos[i]).fn(x -> x <= 0.0 ? 0.0 : Math.sqrt(x)));
            if (nb > 0) {
                builder.add(cmp.range(0, nb), type, ComponentInformation.StdevBackcast);
            }
            if (nf > 0) {
                builder.add(cmp.extract(nb + n, nf), type, ComponentInformation.StdevForecast);
            }
            builder.add(cmp.extract(nb, n), type, ComponentInformation.Stdev);
            if (type != ComponentType.Seasonal) continue;
            builder.add(cmp.extract(nb, n), ComponentType.SeasonallyAdjusted, ComponentInformation.Stdev);
        }
        if (scmp < 0) {
            builder.add(s, ComponentType.SeasonallyAdjusted);
        }
        DataBlock z = DataBlock.make((int)ssf.getStateDim());
        ssf.measurement().loading().Z(0, z);
        if (nb > 0) {
            a = new double[nb];
            e = new double[nb];
            for (int i = 0; i < a.length; ++i) {
                a[i] = srslts.a(i).dot(z);
                e[i] = QuadraticForm.apply((FastMatrix)srslts.P(i), (DataBlock)z);
            }
            TsData sb = TsData.ofInternal((TsPeriod)bstart, (double[])a);
            builder.add(sb, ComponentType.Series, ComponentInformation.Backcast);
            cmp = TsData.of((TsPeriod)bstart, (DoubleSeq)DoubleSeq.of((double[])e).fn(x -> x <= 0.0 ? 0.0 : Math.sqrt(x)));
            builder.add(cmp, ComponentType.Series, ComponentInformation.StdevBackcast);
            if (scmp < 0) {
                builder.add(sb, ComponentType.SeasonallyAdjusted, ComponentInformation.Backcast);
                builder.add(cmp, ComponentType.SeasonallyAdjusted, ComponentInformation.StdevBackcast);
            }
        }
        if (nf > 0) {
            a = new double[nf];
            e = new double[nf];
            int i = 0;
            j = nb + n;
            while (i < a.length) {
                a[i] = srslts.a(j).dot(z);
                e[i] = QuadraticForm.apply((FastMatrix)srslts.P(j), (DataBlock)z);
                ++i;
                ++j;
            }
            TsData sf = TsData.ofInternal((TsPeriod)fstart, (double[])a);
            builder.add(sf, ComponentType.Series, ComponentInformation.Forecast);
            cmp = TsData.of((TsPeriod)fstart, (DoubleSeq)DoubleSeq.of((double[])e).fn(x -> x <= 0.0 ? 0.0 : Math.sqrt(x)));
            builder.add(cmp, ComponentType.Series, ComponentInformation.StdevForecast);
            if (scmp < 0) {
                builder.add(sf, ComponentType.SeasonallyAdjusted, ComponentInformation.Forecast);
                builder.add(cmp, ComponentType.SeasonallyAdjusted, ComponentInformation.StdevForecast);
            }
        }
        if (scmp >= 0) {
            double[] a2;
            z.range(pos[scmp], scmp == pos.length - 1 ? ssf.getStateDim() : pos[scmp + 1]).set(0.0);
            TsData sa = TsData.of((TsPeriod)bstart, (DoubleSeq)srslts.zcomponent((DoubleSeq)z));
            builder.add(sa.range(nb, nb + n), ComponentType.SeasonallyAdjusted);
            if (nb > 0) {
                builder.add(sa.range(0, nb), ComponentType.SeasonallyAdjusted, ComponentInformation.Backcast);
                a2 = new double[nb];
                for (int i = 0; i < a2.length; ++i) {
                    a2[i] = QuadraticForm.apply((FastMatrix)srslts.P(i), (DataBlock)z);
                }
                cmp = TsData.of((TsPeriod)bstart, (DoubleSeq)DoubleSeq.of((double[])a2).fn(x -> x <= 0.0 ? 0.0 : Math.sqrt(x)));
                builder.add(cmp, ComponentType.SeasonallyAdjusted, ComponentInformation.StdevBackcast);
            }
            if (nf > 0) {
                builder.add(sa.range(nb + n, nb + n + nf), ComponentType.SeasonallyAdjusted, ComponentInformation.Forecast);
                a2 = new double[nf];
                int i = 0;
                j = n + nb;
                while (i < a2.length) {
                    a2[i] = QuadraticForm.apply((FastMatrix)srslts.P(j), (DataBlock)z);
                    ++i;
                    ++j;
                }
                cmp = TsData.of((TsPeriod)fstart, (DoubleSeq)DoubleSeq.of((double[])a2).fn(x -> x <= 0.0 ? 0.0 : Math.sqrt(x)));
                builder.add(cmp, ComponentType.SeasonallyAdjusted, ComponentInformation.StdevForecast);
            }
        }
        return builder.build();
    }
}

