/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x11.extremevaluecorrector;

import java.util.Arrays;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.Doubles;
import jdplus.x13.base.api.x11.X11Exception;
import jdplus.x13.base.core.x11.X11Context;
import jdplus.x13.base.core.x11.extremevaluecorrector.IExtremeValuesCorrector;

public class DefaultExtremeValuesCorrector
implements IExtremeValuesCorrector {
    private static final double EPS = 1.0E-15;
    private static final double EPS_STDEV = 1.0E-5;
    protected boolean mul;
    protected int period;
    protected int start;
    protected double lsigma = 1.5;
    protected double usigma = 2.5;
    protected DoubleSeq scur;
    protected DoubleSeq sweights;
    private static final int NCYCLES = 5;
    protected int forecastHorizon;
    protected int backcastHorizon;
    protected boolean excludeFcast;

    public static double[] periodAverages(DoubleSeq s, int period) {
        double[] outs = new double[period];
        int n = s.length();
        for (int i = 0; i < period; ++i) {
            double a = 0.0;
            int m = 0;
            for (int j = i; j < n; j += period) {
                a += s.get(j);
                ++m;
            }
            outs[i] = a / (double)m;
        }
        return outs;
    }

    @Override
    public void analyse(DoubleSeq s, int startPos, X11Context context) {
        this.lsigma = context.getLowerSigma();
        this.usigma = context.getUpperSigma();
        this.scur = s;
        this.start = startPos;
        this.sweights = null;
        this.period = context.getPeriod();
        this.mul = context.isMultiplicative();
        this.forecastHorizon = context.getForecastHorizon();
        this.backcastHorizon = context.getBackcastHorizon();
        this.excludeFcast = context.isExcludefcast();
        double[] stdev = this.calcStdev(this.scur);
        this.sweights = this.extremeValuesDetection(this.scur, stdev);
        if (this.sweights.anyMatch(x -> x < 1.0)) {
            DoubleSeq corr = this.removeExtremes(this.scur, this.sweights);
            stdev = this.calcStdev(corr);
            this.sweights = this.extremeValuesDetection(this.scur, stdev);
        }
    }

    @Override
    public DoubleSeq applyCorrections(DoubleSeq original, DoubleSeq corrections) {
        double[] ns = original.toArray();
        for (int i = 0; i < ns.length; ++i) {
            double x = corrections.get(i);
            if (Double.isNaN(x)) continue;
            ns[i] = x;
        }
        return DoubleSeq.of((double[])ns);
    }

    protected double[] calcStdev(DoubleSeq s) {
        int nbeg;
        int nstart = this.start;
        int n = s.length();
        int ny = 1 + (this.start + n - 1) / this.period;
        int ybeg = 0;
        int nb = 0;
        if (this.excludeFcast) {
            nb = this.backcastHorizon;
            s = s.drop(nb, this.forecastHorizon);
            if (nb > 0) {
                nstart = (this.start + nb) % this.period;
                ybeg = 1 + (this.start + nb - 1) / this.period;
                if (nstart > 0) {
                    --ybeg;
                }
            }
            n = s.length();
        }
        int nfy = 1 + (nstart + n - 1) / this.period;
        if (nstart == 0) {
            nbeg = 0;
        } else {
            nbeg = this.period - nstart;
            --nfy;
        }
        int nend = (nstart + n) % this.period;
        if (nend != 0) {
            --nfy;
        }
        if (nfy < 5) {
            return new double[]{this.calcSingleStdev(s)};
        }
        int ibeg = ybeg + 2;
        if (nbeg > 0) {
            ++ibeg;
        }
        int iend = ibeg + nfy - 5;
        double[] stdev = new double[ny];
        int pos = nbeg;
        int icur = ibeg;
        while (icur <= iend) {
            DoubleSeq cur = s.range(pos, pos + 5 * this.period);
            stdev[icur++] = this.calcSingleStdev(cur);
            pos += this.period;
        }
        double e = nbeg > 0 ? this.calcSingleStdev(s.range(0, nbeg + 5 * this.period)) : stdev[ibeg];
        for (int i = 0; i < ibeg; ++i) {
            stdev[i] = e;
        }
        if (nend > 0) {
            DoubleSeq cur = s.range(pos -= this.period, n);
            e = this.calcSingleStdev(cur);
        } else {
            e = stdev[iend];
        }
        for (int i = icur; i < stdev.length; ++i) {
            stdev[i] = e;
        }
        return stdev;
    }

    protected double calcSingleStdev(DoubleSeq data) {
        int n = data.length();
        int nm = 0;
        double e = 0.0;
        for (int i = 0; i < n; ++i) {
            double x = data.get(i);
            if (Double.isNaN(x)) {
                ++nm;
                continue;
            }
            if (this.mul) {
                x -= 1.0;
            }
            e += x * x;
        }
        return Math.sqrt(e / (double)(n - nm));
    }

    @Override
    public DoubleSeq computeCorrections(DoubleSeq s, boolean excludeFcast) {
        int i;
        int n = s.length();
        if (n != this.scur.length()) {
            throw new X11Exception("Error in extreme value corrections");
        }
        double[] ns = new double[n];
        double[] avgs = null;
        int istart = 0;
        int iend = n;
        if (excludeFcast) {
            istart = this.backcastHorizon;
            for (i = 0; i < istart; ++i) {
                ns[i] = Double.NaN;
            }
            for (i = iend = n - this.forecastHorizon; i < n; ++i) {
                ns[i] = Double.NaN;
            }
        }
        for (i = istart; i < iend; ++i) {
            double e = this.sweights.get(i);
            if (e == 1.0) {
                ns[i] = Double.NaN;
                continue;
            }
            double x = e * s.get(i);
            int[] pos = this.searchPositionsForOutlierCorrection(i, this.period);
            if (pos != null) {
                for (int k = 0; k < 4; ++k) {
                    x += s.get(pos[k]);
                }
                ns[i] = x *= 1.0 / (4.0 + e);
                continue;
            }
            if (avgs == null) {
                avgs = DefaultExtremeValuesCorrector.periodAverages(s, this.period);
            }
            ns[i] = avgs[i % this.period];
        }
        return DoubleSeq.of((double[])ns);
    }

    @Override
    public DoubleSeq getCorrectionFactors() {
        int n = this.sweights.length();
        double[] ns = new double[n];
        Arrays.fill(ns, this.mul ? 1.0 : 0.0);
        for (int i = 0; i < n; ++i) {
            double x = this.sweights.get(i);
            if (!(x < 1.0)) continue;
            double s = this.scur.get(i);
            ns[i] = this.mul ? s / (1.0 + x * (s - 1.0)) : s * (1.0 - x);
        }
        return DoubleSeq.of((double[])ns);
    }

    @Override
    public DoubleSeq getObservationWeights() {
        return this.sweights;
    }

    protected DoubleSeq extremeValuesDetection(DoubleSeq cur, double[] stdev) {
        int n = cur.length();
        if (n != this.scur.length()) {
            throw new X11Exception("Error in extreme value corrections");
        }
        double[] w = new double[n];
        Arrays.fill(w, 1.0);
        double xbar = this.mul ? 1.0 : 0.0;
        int y = 0;
        int nbeg = this.period - this.start;
        int ibeg = 0;
        int iend = nbeg;
        while (ibeg < n) {
            double uv;
            double lv;
            boolean isNullStdev = false;
            if (y > stdev.length - 1) {
                lv = stdev[stdev.length - 1] * this.lsigma;
                uv = stdev[stdev.length - 1] * this.usigma;
                if (Math.abs(stdev[stdev.length - 1]) < 1.0E-5) {
                    isNullStdev = true;
                }
            } else {
                lv = stdev[y] * this.lsigma;
                uv = stdev[y] * this.usigma;
                if (Math.abs(stdev[y]) < 1.0E-5) {
                    isNullStdev = true;
                }
            }
            if (!isNullStdev) {
                for (int i = ibeg; i < iend; ++i) {
                    double tt = Math.abs(cur.get(i) - xbar);
                    if (tt - uv > 1.0E-15) {
                        w[i] = 0.0;
                        continue;
                    }
                    if (!(tt - lv > 1.0E-15)) continue;
                    w[i] = (uv - tt) / (uv - lv);
                }
            }
            ++y;
            ibeg = iend;
            if ((iend += this.period) <= n) continue;
            iend = n;
        }
        return Doubles.of((double[])w);
    }

    private DoubleSeq removeExtremes(DoubleSeq in, DoubleSeq weights) {
        double[] cin = in.toArray();
        for (int i = 0; i < cin.length; ++i) {
            if (weights.get(i) != 0.0) continue;
            cin[i] = Double.NaN;
        }
        return Doubles.of((double[])cin);
    }

    private int[] searchPositionsForOutlierCorrection(int p, int period) {
        int lp = 0;
        int up = 0;
        int lb = p;
        int ub = p;
        int k = 0;
        int[] outs = new int[4];
        while (lb >= period && lp != 2) {
            if (this.sweights.get(lb -= period) != 1.0) continue;
            ++lp;
            outs[k++] = lb;
        }
        int len = this.sweights.length();
        while (ub < len - period && up != 2) {
            if (this.sweights.get(ub += period) != 1.0) continue;
            ++up;
            outs[k++] = ub;
        }
        if (lp < 2) {
            while (ub < len - period && k < 4) {
                if (this.sweights.get(ub += period) != 1.0) continue;
                ++lp;
                outs[k++] = ub;
            }
        } else if (up < 2) {
            while (lb >= period && k < 4) {
                if (this.sweights.get(lb -= period) != 1.0) continue;
                ++up;
                outs[k++] = lb;
            }
        }
        if (lp + up < 4) {
            return null;
        }
        return outs;
    }

    public double getLowerSigma() {
        return this.lsigma;
    }

    public double getUpperSigma() {
        return this.usigma;
    }

    @Override
    public void setSigma(double lsig, double usig) {
        if (usig <= lsig || lsig <= 0.5) {
            throw new IllegalArgumentException("Invalid sigma limits");
        }
        this.lsigma = lsig;
        this.usigma = usig;
    }
}

