/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.arima.estimation;

import internal.toolkit.base.core.arima.MaLjungBoxFilter;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.arima.estimation.ArimaForecasts;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;

public class FastArimaForecasts
implements ArimaForecasts {
    private IArimaModel arima;
    private Polynomial ar;
    private Polynomial ma;
    private double mean;

    @Override
    public boolean prepare(IArimaModel model, boolean bmean) {
        if (bmean) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        this.arima = model;
        this.ar = this.arima.getAr().asPolynomial();
        this.ma = this.arima.getMa().asPolynomial();
        this.mean = 0.0;
        return true;
    }

    @Override
    public boolean prepare(IArimaModel model, double mu) {
        this.arima = model;
        this.ar = this.arima.getAr().asPolynomial();
        this.ma = this.arima.getMa().asPolynomial();
        if (mu != 0.0 && model.getStationaryArOrder() > 0) {
            Polynomial c = model.getStationaryAr().asPolynomial();
            this.mean = mu * c.evaluateAt(1.0);
        } else {
            this.mean = mu;
        }
        return true;
    }

    @Override
    public DoubleSeq forecasts(DoubleSeq data, int nf) {
        try {
            int i;
            DataBlock res = this.residuals(data);
            double[] fcasts = new double[nf];
            int p = this.ar.degree();
            double[] y = new double[p];
            int last = data.length() - 1;
            for (int i2 = 0; i2 < p; ++i2) {
                y[i2] = data.get(last - i2);
            }
            int q = this.ma.degree();
            double[] e = new double[q];
            last = res.length() - 1;
            for (i = 0; i < q; ++i) {
                e[i] = res.get(last - i);
            }
            for (i = 0; i < nf; ++i) {
                int j;
                double s = this.mean;
                for (j = 0; j < p; ++j) {
                    s -= this.ar.get(j + 1) * y[j];
                }
                for (j = i; j < q; ++j) {
                    s += this.ma.get(j + 1) * e[j - i];
                }
                for (j = p - 1; j > 0; --j) {
                    y[j] = y[j - 1];
                }
                if (p > 0) {
                    y[0] = s;
                }
                fcasts[i] = s;
            }
            return DoubleSeq.of((double[])fcasts);
        }
        catch (Exception err) {
            return null;
        }
    }

    private DataBlock residuals(DoubleSeq data) {
        DataBlock w = DataBlock.of(data);
        try {
            DataBlock z = w;
            int p = this.ar.degree();
            int q = this.ma.degree();
            if (p > 0) {
                z = DataBlock.make(w.length() - p);
                this.arima.getAr().apply(w, z);
            }
            if (this.mean != 0.0) {
                z.sub(this.mean);
            }
            if (q > 0) {
                MaLjungBoxFilter malb = new MaLjungBoxFilter();
                int nwl = malb.prepare((IArimaModel)this.arima.stationaryTransformation().getStationaryModel(), z.length());
                DataBlock wl = DataBlock.make(nwl);
                malb.filter((DoubleSeq)z, wl);
                return wl;
            }
            return z;
        }
        catch (Exception err) {
            return w;
        }
    }

    @Override
    public double getMean() {
        return this.mean;
    }
}

