/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.seats.diagnostics;

import java.util.concurrent.atomic.AtomicReference;
import jdplus.toolkit.base.api.processing.DiagnosticsConfiguration;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class SeatsDiagnosticsConfiguration
implements DiagnosticsConfiguration {
    private static final AtomicReference<SeatsDiagnosticsConfiguration> DEFAULT = new AtomicReference<SeatsDiagnosticsConfiguration>(SeatsDiagnosticsConfiguration.builder().build());
    public static final boolean ACTIVE = true;
    private final boolean active;
    public static final double BAD = 0.005;
    public static final double UNC = 0.05;
    private final double badThreshold;
    private final double uncertainThreshold;

    public static void setDefault(SeatsDiagnosticsConfiguration config) {
        DEFAULT.set(config);
    }

    public static SeatsDiagnosticsConfiguration getDefault() {
        return DEFAULT.get();
    }

    public void check() {
        if (this.badThreshold > this.uncertainThreshold || this.uncertainThreshold > 1.0 || this.badThreshold <= 0.0) {
            throw new IllegalArgumentException("Invalid settings in Seats diagnostics");
        }
    }

    public static Builder builder() {
        return new Builder().active(true).badThreshold(0.005).uncertainThreshold(0.05);
    }

    public DiagnosticsConfiguration activate(boolean active) {
        if (this.active == active) {
            return this;
        }
        return this.toBuilder().active(active).build();
    }

    @Generated
    SeatsDiagnosticsConfiguration(boolean active, double badThreshold, double uncertainThreshold) {
        this.active = active;
        this.badThreshold = badThreshold;
        this.uncertainThreshold = uncertainThreshold;
    }

    @Generated
    public @NonNull Builder toBuilder() {
        return new Builder().active(this.active).badThreshold(this.badThreshold).uncertainThreshold(this.uncertainThreshold);
    }

    @Generated
    public boolean isActive() {
        return this.active;
    }

    @Generated
    public double getBadThreshold() {
        return this.badThreshold;
    }

    @Generated
    public double getUncertainThreshold() {
        return this.uncertainThreshold;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SeatsDiagnosticsConfiguration)) {
            return false;
        }
        SeatsDiagnosticsConfiguration other = (SeatsDiagnosticsConfiguration)o;
        if (this.isActive() != other.isActive()) {
            return false;
        }
        if (Double.compare(this.getBadThreshold(), other.getBadThreshold()) != 0) {
            return false;
        }
        return Double.compare(this.getUncertainThreshold(), other.getUncertainThreshold()) == 0;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isActive() ? 79 : 97);
        long $badThreshold = Double.doubleToLongBits(this.getBadThreshold());
        result = result * 59 + (int)($badThreshold >>> 32 ^ $badThreshold);
        long $uncertainThreshold = Double.doubleToLongBits(this.getUncertainThreshold());
        result = result * 59 + (int)($uncertainThreshold >>> 32 ^ $uncertainThreshold);
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "SeatsDiagnosticsConfiguration(active=" + this.isActive() + ", badThreshold=" + this.getBadThreshold() + ", uncertainThreshold=" + this.getUncertainThreshold() + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private boolean active;
        @Generated
        private double badThreshold;
        @Generated
        private double uncertainThreshold;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder active(boolean active) {
            this.active = active;
            return this;
        }

        @Generated
        public @NonNull Builder badThreshold(double badThreshold) {
            this.badThreshold = badThreshold;
            return this;
        }

        @Generated
        public @NonNull Builder uncertainThreshold(double uncertainThreshold) {
            this.uncertainThreshold = uncertainThreshold;
            return this;
        }

        @Generated
        public @NonNull SeatsDiagnosticsConfiguration build() {
            return new SeatsDiagnosticsConfiguration(this.active, this.badThreshold, this.uncertainThreshold);
        }

        @Generated
        public @NonNull String toString() {
            return "SeatsDiagnosticsConfiguration.Builder(active=" + this.active + ", badThreshold=" + this.badThreshold + ", uncertainThreshold=" + this.uncertainThreshold + ")";
        }
    }
}

