/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.r.timeseries;

import com.google.protobuf.InvalidProtocolBufferException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import jdplus.toolkit.base.api.data.AggregationType;
import jdplus.toolkit.base.api.timeseries.CalendarPeriodObs;
import jdplus.toolkit.base.api.timeseries.CalendarTimeSeries;
import jdplus.toolkit.base.api.timeseries.Ts;
import jdplus.toolkit.base.api.timeseries.TsCollection;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDataTable;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsFactory;
import jdplus.toolkit.base.api.timeseries.TsInformationType;
import jdplus.toolkit.base.api.timeseries.TsMoniker;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import jdplus.toolkit.base.protobuf.toolkit.ToolkitProtos;
import jdplus.toolkit.base.protobuf.toolkit.ToolkitProtosUtility;
import lombok.Generated;

public final class TsUtility {
    public static void updateProviders() {
        TsFactory nfactory = TsFactory.ofServiceLoader();
        TsFactory.setDefault((TsFactory)nfactory);
    }

    public static TsData of(int freq, int year, int start, double[] data) {
        switch (freq) {
            case 1: {
                return TsData.ofInternal((TsPeriod)TsPeriod.yearly((int)year), (double[])data);
            }
            case 12: {
                return TsData.ofInternal((TsPeriod)TsPeriod.monthly((int)year, (int)start), (double[])data);
            }
        }
        int c = 12 / freq;
        TsPeriod pstart = TsPeriod.of((TsUnit)TsUnit.ofAnnualFrequency((int)freq), (LocalDate)LocalDate.of(year, (start - 1) * c + 1, 1));
        return TsData.ofInternal((TsPeriod)pstart, (double[])data);
    }

    public static TsDomain of(int freq, int year, int start, int len) {
        switch (freq) {
            case 1: {
                return TsDomain.of((TsPeriod)TsPeriod.yearly((int)year), (int)len);
            }
            case 12: {
                return TsDomain.of((TsPeriod)TsPeriod.monthly((int)year, (int)start), (int)len);
            }
        }
        int c = 12 / freq;
        TsPeriod pstart = TsPeriod.of((TsUnit)TsUnit.ofAnnualFrequency((int)freq), (LocalDate)LocalDate.of(year, (start - 1) * c + 1, 1));
        return TsDomain.of((TsPeriod)pstart, (int)len);
    }

    public static TsData aggregate(TsData source, int nfreq, String conversion, boolean fullperiods) {
        AggregationType agg = AggregationType.valueOf((String)conversion);
        if (agg == null) {
            return null;
        }
        TsUnit unit = TsUnit.ofAnnualFrequency((int)nfreq);
        return source.aggregate(unit, agg, fullperiods);
    }

    public static int[] startPeriod(TsData s) {
        return TsUtility.of(s.getStart());
    }

    public static int[] startPeriod(TsDataTable s) {
        return TsUtility.of(s.getDomain().getStartPeriod());
    }

    public static int[] of(TsPeriod p) {
        LocalDate start = p.start().toLocalDate();
        int freq = p.getUnit().getAnnualFrequency();
        int c = 12 / freq;
        int mon = start.getMonthValue();
        int year = start.getYear();
        return new int[]{freq, year, 1 + (mon - 1) / c};
    }

    public static CalendarTimeSeries of(String[] starts, double[] data) {
        if (starts.length != data.length + 1) {
            throw new IllegalArgumentException();
        }
        ArrayList<CalendarPeriodObs> entries = new ArrayList<CalendarPeriodObs>();
        LocalDate e = LocalDate.parse(starts[0], DateTimeFormatter.ISO_DATE);
        LocalDate s = null;
        for (int i = 0; i < data.length; ++i) {
            s = e;
            entries.add(CalendarPeriodObs.of((LocalDate)s, (LocalDate)e.plusDays(1L), (double)data[i]));
        }
        return CalendarTimeSeries.of(entries);
    }

    public static CalendarTimeSeries of(String[] starts, String[] ends, double[] data) {
        if (starts.length != data.length || ends.length != data.length) {
            throw new IllegalArgumentException();
        }
        ArrayList<CalendarPeriodObs> entries = new ArrayList<CalendarPeriodObs>();
        for (int i = 0; i < data.length; ++i) {
            LocalDate s = LocalDate.parse(starts[i], DateTimeFormatter.ISO_DATE);
            LocalDate e = LocalDate.parse(ends[i], DateTimeFormatter.ISO_DATE);
            entries.add(CalendarPeriodObs.of((LocalDate)s, (LocalDate)e.plusDays(1L), (double)data[i]));
        }
        return CalendarTimeSeries.of(entries);
    }

    public static TsData cleanExtremities(TsData s) {
        return s.cleanExtremities();
    }

    public static byte[] toBuffer(Ts s) {
        return ToolkitProtosUtility.convert((Ts)s).toByteArray();
    }

    public static Ts tsOfBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return ToolkitProtosUtility.convert((ToolkitProtos.Ts)ToolkitProtos.Ts.parseFrom((byte[])bytes));
    }

    public static byte[] toBuffer(TsCollection s) {
        return ToolkitProtosUtility.convert((TsCollection)s).toByteArray();
    }

    public static TsCollection tsCollectionOfBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return ToolkitProtosUtility.convert((ToolkitProtos.TsCollection)ToolkitProtos.TsCollection.parseFrom((byte[])bytes));
    }

    private static String dayOf(TsPeriod p, int pos) {
        switch (pos) {
            case 0: {
                return p.start().toLocalDate().format(DateTimeFormatter.ISO_DATE);
            }
            case 2: {
                return p.end().toLocalDate().minusDays(1L).format(DateTimeFormatter.ISO_DATE);
            }
        }
        LocalDate d0 = p.start().toLocalDate();
        LocalDate d1 = p.end().toLocalDate();
        return d0.plusDays(d0.until(d1, ChronoUnit.DAYS) / 2L).format(DateTimeFormatter.ISO_DATE);
    }

    public static String[] daysOf(TsDomain domain, int pos) {
        String[] days = new String[domain.size()];
        for (int i = 0; i < days.length; ++i) {
            days[i] = TsUtility.dayOf(domain.get(i), pos);
        }
        return days;
    }

    public static String[] daysOf(TsData data, int pos) {
        return TsUtility.daysOf(data.getDomain(), pos);
    }

    public static Ts makeTs(TsData data, String name) {
        return Ts.of((String)name, (TsData)data);
    }

    public static Ts makeTs(TsMoniker moniker, String type) {
        return TsFactory.getDefault().makeTs(moniker, TsInformationType.valueOf((String)type));
    }

    public static TsCollection makeTsCollection(TsMoniker moniker, String type) {
        return TsFactory.getDefault().makeTsCollection(moniker, TsInformationType.valueOf((String)type));
    }

    @Generated
    private TsUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

