/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.api.seats;

import jdplus.toolkit.base.api.util.Validatable;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class DecompositionSpec
implements Validatable<DecompositionSpec> {
    public static final double DEF_XL = 0.95;
    public static final double DEF_EPSPHI = 2.0;
    public static final double DEF_RMOD = 0.5;
    public static final double DEF_SMOD1 = 0.8;
    public static final double DEF_SMOD = 0.8;
    public static final int DEF_FORECASTS = -2;
    public static final int DEF_BACKCASTS = 0;
    private final double xlBoundary;
    private final ModelApproximationMode approximationMode;
    private final double seasTolerance;
    private final double trendBoundary;
    private final double seasBoundary;
    private final double seasBoundaryAtPi;
    private final BiasCorrection biasCorrection;
    private final int backcastCount;
    private final int forecastCount;
    private final ComponentsEstimationMethod method;
    public static final DecompositionSpec DEFAULT = (DecompositionSpec)DecompositionSpec.builder().build();

    public static Builder builder() {
        return new Builder().xlBoundary(0.95).approximationMode(ModelApproximationMode.Legacy).seasTolerance(2.0).trendBoundary(0.5).seasBoundary(0.8).seasBoundaryAtPi(0.8).biasCorrection(BiasCorrection.Legacy).method(ComponentsEstimationMethod.Burman).forecastCount(-2).backcastCount(0);
    }

    public DecompositionSpec validate() throws IllegalArgumentException {
        if (this.xlBoundary < 0.9 || this.xlBoundary > 1.0) {
            throw new IllegalArgumentException("XL should belong to [0.9, 1]");
        }
        if (this.seasTolerance < 0.0 || this.seasTolerance > 10.0) {
            throw new IllegalArgumentException("EPSPHI (expressed in degrees) should belong to [0, 10]");
        }
        if (this.trendBoundary < 0.0 || this.trendBoundary > 1.0) {
            throw new IllegalArgumentException("RMOD should belong to [0, 1]");
        }
        if (this.seasBoundary < 0.0 || this.seasBoundary > 1.0) {
            throw new IllegalArgumentException("SMOD should belong to [0, 1]");
        }
        if (this.seasBoundaryAtPi < 0.0 || this.seasBoundaryAtPi > 1.0) {
            throw new IllegalArgumentException("SMOD1 should belong to [0, 1]");
        }
        return this;
    }

    public boolean isDefault() {
        return this.equals(DEFAULT);
    }

    @Generated
    DecompositionSpec(double xlBoundary, ModelApproximationMode approximationMode, double seasTolerance, double trendBoundary, double seasBoundary, double seasBoundaryAtPi, BiasCorrection biasCorrection, int backcastCount, int forecastCount, ComponentsEstimationMethod method) {
        this.xlBoundary = xlBoundary;
        this.approximationMode = approximationMode;
        this.seasTolerance = seasTolerance;
        this.trendBoundary = trendBoundary;
        this.seasBoundary = seasBoundary;
        this.seasBoundaryAtPi = seasBoundaryAtPi;
        this.biasCorrection = biasCorrection;
        this.backcastCount = backcastCount;
        this.forecastCount = forecastCount;
        this.method = method;
    }

    @Generated
    public @NonNull Builder toBuilder() {
        return new Builder().xlBoundary(this.xlBoundary).approximationMode(this.approximationMode).seasTolerance(this.seasTolerance).trendBoundary(this.trendBoundary).seasBoundary(this.seasBoundary).seasBoundaryAtPi(this.seasBoundaryAtPi).biasCorrection(this.biasCorrection).backcastCount(this.backcastCount).forecastCount(this.forecastCount).method(this.method);
    }

    @Generated
    public double getXlBoundary() {
        return this.xlBoundary;
    }

    @Generated
    public ModelApproximationMode getApproximationMode() {
        return this.approximationMode;
    }

    @Generated
    public double getSeasTolerance() {
        return this.seasTolerance;
    }

    @Generated
    public double getTrendBoundary() {
        return this.trendBoundary;
    }

    @Generated
    public double getSeasBoundary() {
        return this.seasBoundary;
    }

    @Generated
    public double getSeasBoundaryAtPi() {
        return this.seasBoundaryAtPi;
    }

    @Generated
    public BiasCorrection getBiasCorrection() {
        return this.biasCorrection;
    }

    @Generated
    public int getBackcastCount() {
        return this.backcastCount;
    }

    @Generated
    public int getForecastCount() {
        return this.forecastCount;
    }

    @Generated
    public ComponentsEstimationMethod getMethod() {
        return this.method;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DecompositionSpec)) {
            return false;
        }
        DecompositionSpec other = (DecompositionSpec)o;
        if (Double.compare(this.getXlBoundary(), other.getXlBoundary()) != 0) {
            return false;
        }
        if (Double.compare(this.getSeasTolerance(), other.getSeasTolerance()) != 0) {
            return false;
        }
        if (Double.compare(this.getTrendBoundary(), other.getTrendBoundary()) != 0) {
            return false;
        }
        if (Double.compare(this.getSeasBoundary(), other.getSeasBoundary()) != 0) {
            return false;
        }
        if (Double.compare(this.getSeasBoundaryAtPi(), other.getSeasBoundaryAtPi()) != 0) {
            return false;
        }
        if (this.getBackcastCount() != other.getBackcastCount()) {
            return false;
        }
        if (this.getForecastCount() != other.getForecastCount()) {
            return false;
        }
        ModelApproximationMode this$approximationMode = this.getApproximationMode();
        ModelApproximationMode other$approximationMode = other.getApproximationMode();
        if (this$approximationMode == null ? other$approximationMode != null : !((Object)((Object)this$approximationMode)).equals((Object)other$approximationMode)) {
            return false;
        }
        BiasCorrection this$biasCorrection = this.getBiasCorrection();
        BiasCorrection other$biasCorrection = other.getBiasCorrection();
        if (this$biasCorrection == null ? other$biasCorrection != null : !((Object)((Object)this$biasCorrection)).equals((Object)other$biasCorrection)) {
            return false;
        }
        ComponentsEstimationMethod this$method = this.getMethod();
        ComponentsEstimationMethod other$method = other.getMethod();
        return !(this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $xlBoundary = Double.doubleToLongBits(this.getXlBoundary());
        result = result * 59 + (int)($xlBoundary >>> 32 ^ $xlBoundary);
        long $seasTolerance = Double.doubleToLongBits(this.getSeasTolerance());
        result = result * 59 + (int)($seasTolerance >>> 32 ^ $seasTolerance);
        long $trendBoundary = Double.doubleToLongBits(this.getTrendBoundary());
        result = result * 59 + (int)($trendBoundary >>> 32 ^ $trendBoundary);
        long $seasBoundary = Double.doubleToLongBits(this.getSeasBoundary());
        result = result * 59 + (int)($seasBoundary >>> 32 ^ $seasBoundary);
        long $seasBoundaryAtPi = Double.doubleToLongBits(this.getSeasBoundaryAtPi());
        result = result * 59 + (int)($seasBoundaryAtPi >>> 32 ^ $seasBoundaryAtPi);
        result = result * 59 + this.getBackcastCount();
        result = result * 59 + this.getForecastCount();
        ModelApproximationMode $approximationMode = this.getApproximationMode();
        result = result * 59 + ($approximationMode == null ? 43 : ((Object)((Object)$approximationMode)).hashCode());
        BiasCorrection $biasCorrection = this.getBiasCorrection();
        result = result * 59 + ($biasCorrection == null ? 43 : ((Object)((Object)$biasCorrection)).hashCode());
        ComponentsEstimationMethod $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "DecompositionSpec(xlBoundary=" + this.getXlBoundary() + ", approximationMode=" + String.valueOf((Object)this.getApproximationMode()) + ", seasTolerance=" + this.getSeasTolerance() + ", trendBoundary=" + this.getTrendBoundary() + ", seasBoundary=" + this.getSeasBoundary() + ", seasBoundaryAtPi=" + this.getSeasBoundaryAtPi() + ", biasCorrection=" + String.valueOf((Object)this.getBiasCorrection()) + ", backcastCount=" + this.getBackcastCount() + ", forecastCount=" + this.getForecastCount() + ", method=" + String.valueOf((Object)this.getMethod()) + ")";
    }

    public static class Builder
    implements Validatable.Builder<DecompositionSpec> {
        @Generated
        private double xlBoundary;
        @Generated
        private ModelApproximationMode approximationMode;
        @Generated
        private double seasTolerance;
        @Generated
        private double trendBoundary;
        @Generated
        private double seasBoundary;
        @Generated
        private double seasBoundaryAtPi;
        @Generated
        private BiasCorrection biasCorrection;
        @Generated
        private int backcastCount;
        @Generated
        private int forecastCount;
        @Generated
        private ComponentsEstimationMethod method;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder xlBoundary(double xlBoundary) {
            this.xlBoundary = xlBoundary;
            return this;
        }

        @Generated
        public @NonNull Builder approximationMode(ModelApproximationMode approximationMode) {
            this.approximationMode = approximationMode;
            return this;
        }

        @Generated
        public @NonNull Builder seasTolerance(double seasTolerance) {
            this.seasTolerance = seasTolerance;
            return this;
        }

        @Generated
        public @NonNull Builder trendBoundary(double trendBoundary) {
            this.trendBoundary = trendBoundary;
            return this;
        }

        @Generated
        public @NonNull Builder seasBoundary(double seasBoundary) {
            this.seasBoundary = seasBoundary;
            return this;
        }

        @Generated
        public @NonNull Builder seasBoundaryAtPi(double seasBoundaryAtPi) {
            this.seasBoundaryAtPi = seasBoundaryAtPi;
            return this;
        }

        @Generated
        public @NonNull Builder biasCorrection(BiasCorrection biasCorrection) {
            this.biasCorrection = biasCorrection;
            return this;
        }

        @Generated
        public @NonNull Builder backcastCount(int backcastCount) {
            this.backcastCount = backcastCount;
            return this;
        }

        @Generated
        public @NonNull Builder forecastCount(int forecastCount) {
            this.forecastCount = forecastCount;
            return this;
        }

        @Generated
        public @NonNull Builder method(ComponentsEstimationMethod method) {
            this.method = method;
            return this;
        }

        @Generated
        public @NonNull DecompositionSpec buildWithoutValidation() {
            return new DecompositionSpec(this.xlBoundary, this.approximationMode, this.seasTolerance, this.trendBoundary, this.seasBoundary, this.seasBoundaryAtPi, this.biasCorrection, this.backcastCount, this.forecastCount, this.method);
        }

        @Generated
        public @NonNull String toString() {
            return "DecompositionSpec.Builder(xlBoundary=" + this.xlBoundary + ", approximationMode=" + String.valueOf((Object)this.approximationMode) + ", seasTolerance=" + this.seasTolerance + ", trendBoundary=" + this.trendBoundary + ", seasBoundary=" + this.seasBoundary + ", seasBoundaryAtPi=" + this.seasBoundaryAtPi + ", biasCorrection=" + String.valueOf((Object)this.biasCorrection) + ", backcastCount=" + this.backcastCount + ", forecastCount=" + this.forecastCount + ", method=" + String.valueOf((Object)this.method) + ")";
        }
    }

    public static enum ModelApproximationMode {
        None,
        Legacy,
        Noisy;

    }

    public static enum BiasCorrection {
        None,
        Legacy;

    }

    public static enum ComponentsEstimationMethod {
        Burman,
        KalmanSmoother;

    }
}

