/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.tests;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.stats.StatException;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.core.stats.linearmodel.LeastSquaresResults;
import jdplus.toolkit.base.core.stats.linearmodel.LinearModel;
import jdplus.toolkit.base.core.stats.linearmodel.Ols;
import jdplus.toolkit.base.core.stats.tests.BoxPierce;
import jdplus.toolkit.base.core.stats.tests.LjungBox;
import lombok.Generated;

public final class Arch {
    public static Lm lm(DoubleSeq res) {
        return new Lm(res.fn(z -> z * z));
    }

    public static PorteManteau porteManteau(DoubleSeq res) {
        return new PorteManteau(res.fn(z -> z * z));
    }

    @Generated
    private Arch() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class Lm {
        private DoubleSeq e2;
        private int nlags = 1;
        private LeastSquaresResults lsr;

        private Lm(DoubleSeq e2) {
            this.e2 = e2;
        }

        public Lm autoCorrelationsCount(int nlags) {
            this.nlags = nlags;
            return this;
        }

        public StatisticalTest build() {
            int n = this.e2.length() - this.nlags;
            if (n <= this.nlags + 1) {
                throw new StatException("Not enough data");
            }
            LinearModel.Builder builder = LinearModel.builder().y(this.e2.extract(this.nlags, n)).meanCorrection(true);
            for (int i = 0; i < this.nlags; ++i) {
                builder.addX(this.e2.extract(i, n));
            }
            this.lsr = Ols.compute(builder.build());
            return this.lsr == null ? null : this.lsr.Khi2Test();
        }

        public LeastSquaresResults getLeastSquaresResults() {
            return this.lsr;
        }
    }

    public static class PorteManteau {
        private final DoubleSeq e2;
        private boolean ljungbox = true;
        private int nlags = 4;

        private PorteManteau(DoubleSeq e2) {
            this.e2 = e2;
        }

        public PorteManteau useLjungBox(boolean lb) {
            this.ljungbox = lb;
            return this;
        }

        public PorteManteau autoCorrelationsCount(int nlags) {
            this.nlags = nlags;
            return this;
        }

        public StatisticalTest build() {
            return this.ljungbox ? new LjungBox(this.e2, true).autoCorrelationsCount(this.nlags).build() : new BoxPierce(this.e2, true).autoCorrelationsCount(this.nlags).build();
        }
    }
}

