.First.lib <- function (lib, pkg)
{
  library.dynam("ffnet", pkg, lib)
  if (!require (ts, quietly=TRUE))
    stop ("Package ts is needed. Stopping")
  filenm <- paste (.lib.loc, "/ffnet/DESCRIPTION", sep="")
  descidx <- file.exists (filenm)
  descfn <- paste (filenm)[descidx]
  desc <- scan (descfn, what=character(), quiet = TRUE)
  ver <- desc[which (desc=="Version:")+1]
  vertxt <- paste ("\n      `ffnet' version:", ver, "\n")
  introtxt <- paste ("\n      `ffnet' is a Fast and Flexible library for\n",
                     "       single-hidden-layer neural NETworks.\n",
                     "       See `library (help=ffnet)' for details.\n\n", sep="")
  if (interactive() || .Options$verbose)
    cat (paste (vertxt, introtxt))
}
