\name{predict.ffnet}
\title{Prediction of Examples by a Trained Single--Hidden--Layer Neural Network}
\usage{
predict (nn, x, type)
predict (nn, y, x, genuine = FALSE)
}
\alias{predict.ffnet}
\alias{predict.ffnet.ts}
\arguments{
  \item{nn}{an object of class \code{"ffnet"} or \code{"ffnet.ts"}.}
  \item{x}{for \code{predict.ffnet} a matrix, vector, or
    data frame of (input) examples. For \code{predict.ffnet.ts} the time
    series of exogenous variables.} 
  \item{y}{For \code{predict.ffnet.ts} the time series of endogenous
    variables.}
  \item{type}{a string indicating whether the prediction for targets of
    class \code{"factor"} is a factor or a coded factor. See
    \code{\link{ffnet}}.}
  \item{genuine}{a logical indicating whether for time series genuine
    predictions should be made, i.e., predictions for which there is no
    target observation available.}
}
\description{
  Computes for the trained single-hidden-layer neural network \code{nn}
  the predictions from the input examples \code{x}.
}
\details{
  This procedure calls routines from a C/C++ library.

  Missing values are not allowed.
}
\value{
  a vector, matrix, or time series containing the predictions.
}
\seealso{
  \code{\link{ffnet}}, \code{\link{hessian.ffnet}},
  \code{\link{print.ffnet}}, \code{\link{fitted.ffnet}},
  \code{\link{residuals.ffnet}}, \code{\link{plot.ffnet}},
  \code{\link{coef.ffnet}}, \code{\link{print.summary.ffnet}}
}
\references{
  C.M. Bishop (1995): \emph{Neural Networks for Pattern
  Recognition}, Clarendon Press, Oxford.

  A. Trapletti (1999): FFNET: A Fast and Flexible software
  library for single-hidden-layer neural NETworks, unpublished
  report.
}
\author{A. Trapletti}
\examples{
x <- runif (1000, -1, 1)
y <- x^2 - x^3 +0.1*rnorm(x)
plot (x, y)
rr <- lm (y~x)
summary (rr)
points (x, predict(rr,x), col="red")
nn <- ffnet (y~x, nhid=1, itmax=100, optim="DFPMIN", shortcut=T)
summary (nn)
points (x, predict(nn,x), col="green")
}
\keyword{nonlinear, neural}

