#ifndef _DBUG_H_
#define _DBUG_H_

/*
 **************************************************************************
 *                                                                        *
 *                            N O T I C E                                 *
 *                                                                        *
 *               Copyright Abandoned, 1987, Fred Fish                     *
 *                                                                        *
 *                                                                        *
 * This previously copyrighted work has been placed into the  public      *
 * domain  by  the  author  and  may be freely used for any purpose,      *
 * private or commercial.                                                 *
 *                                                                        *
 * Because of the number of inquiries I was receiving about the  use      *
 * of this product in commercially developed works I have decided to      *
 * simply make it public domain to further its unrestricted use.   I      *
 * specifically  would  be  most happy to see this material become a      *
 * part of the standard Unix distributions by AT&T and the  Berkeley      *
 * Computer  Science  Research Group, and a standard part of the GNU      *
 * system from the Free Software Foundation.                              *
 *                                                                        *
 * I would appreciate it, as a courtesy, if this notice is  left  in      *
 * all copies and derivative works.  Thank you.                           *
 *                                                                        *
 * The author makes no warranty of any kind  with  respect  to  this      *
 * product  and  explicitly disclaims any implied warranties of mer-      *
 * chantability or fitness for any particular purpose.                    *
 *                                                                        *
 **************************************************************************
 */

/*
 *  FILE
 *
 * dbug.h    user include file for programs using the dbug package
 *
 *  SYNOPSIS
 *
 * #include <local/dbug.h>
 *
 *  SCCS ID
 *
 * @(#)dbug.h 1.13 7/17/89
 *
 *  DESCRIPTION
 *
 * Programs which use the dbug package must include this file.
 * It contains the appropriate macros to call support routines
 * in the dbug runtime library.
 *
 * To disable compilation of the macro expansions define the
 * preprocessor symbol "DBUG_OFF".  This will result in null
 * macros expansions so that the resulting code will be smaller
 * and faster.  (The difference may be smaller than you think
 * so this step is recommended only when absolutely necessary).
 * In general, tradeoffs between space and efficiency are
 * decided in favor of efficiency since space is seldom a
 * problem on the new machines).
 *
 * All externally visible symbol names follow the pattern
 * "_db_xxx..xx_" to minimize the possibility of a dbug package
 * symbol colliding with a user defined symbol.
 *
 * The DBUG_<N> style macros are obsolete and should not be used
 * in new code.  Macros to map them to instances of DBUG_PRINT
 * are provided for compatibility with older code.  They may go
 * away completely in subsequent releases.
 *
 *  AUTHOR
 *
 * Fred Fish
 * (Currently employed by Motorola Computer Division, Tempe, Az.)
 * hao!noao!mcdsun!fnf
 * (602) 438-3614
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <setjmp.h>
#include <math.h>
#include <stdarg.h>
#include <assert.h>
#include <ctype.h>
#include "osinfo.h"

#if !defined(IDBUG_IMPLEMENTATION) && !defined(IDBUG_IFACE)
#	error You must define IDBUG_IFACE !
#endif

#ifdef MSS
#define IDBUG_MALLOC(_idbug,size) malloc (size)
#define IDBUG_FREE(_idbug,p) free (p)

#include <mss.h>

#else /* ! MSS */

#define IDBUG_MALLOC(_idbug,size) dbug_malloc (_idbug, size,__FILE__,__LINE__)
#define IDBUG_FREE(_idbug,p) dbug_free (_idbug, p,__FILE__,__LINE__)
#endif /* MSS */

#ifdef IDBUG_OS_W32
#define EXPORT __declspec (dllexport)
#else	/* !IDBUG_OS_W32 */
#define EXPORT
#endif /* IDBUG_OS_W32 */

#define DEBUGGING_IDBUG(a) a

enum
  {
    IDBUG_FN_REFLEN = 256             /* file name lenght */
  };

enum
  {
    IDBUG_FALSE = 0,
    IDBUG_TRUE = 1,
    /*
     * idbug flags
     */
    IDBUG_THREADED = 0x000001,
    IDBUG_AUTOS_REVERSE = 0x000002,	/* TODO: How to determine it ? */
    IDBUG_SUID = 0x000010,	/* ??? */
    _IDBUG_TRACE_ON = 0x000001,		/* Trace enabled */
    _IDBUG_DEBUG_ON = 0x000002,		/* Debug enabled */
    _IDBUG_FILE_ON = 0x000004,		/* File name print enabled */
    _IDBUG_LINE_ON = 0x000010,		/* Line number print enabled */
    _IDBUG_DEPTH_ON = 0x000020,		/* Function nest level print enabled */
    _IDBUG_PROCESS_ON = 0x000040,	/* Process name print enabled */
    _IDBUG_NUMBER_ON = 0x000100,		/* Number each line of output */
    _IDBUG_PROFILE_ON = 0x000200,	/* Print out profiling code */
    _IDBUG_PID_ON = 0x000400,		/* Identify each line with process id */
    IDBUG_SANITY = 0x001000,	/* Check something  on DBUG_ENTER */
    _IDBUG_FLUSH_ON_WRITE = 0x002000,	/* Flush on every write */
    IDBUG_ANSI_FLAGS = _IDBUG_FLUSH_ON_WRITE | _IDBUG_DEBUG_ON,
  };

/*
 * Debugging states can be pushed or popped off of a
 * stack which is implemented as a linked list.  Note
 * that the head of the list is the current state and the
 * stack is pushed by adding a new state to the head of the
 * list or popped by removing the first link.
 */

struct idbug_state
  {
    int flags;                  /* Current state flags */
    int maxdepth;               /* Current maximum trace depth */
    unsigned int  delay;                 /* Delay after each output line */
    int sub_level;              /* Sub this from code_state->level */
    FILE *out_file;             /* Current output stream */
    FILE *prof_file;            /* Current profiling stream */
    char name[IDBUG_FN_REFLEN];       /* Name of output file */
    struct link *functions;     /* List of functions */
    struct link *p_functions;   /* List of profiled functions */
    struct link *keywords;      /* List of debug keywords */
    struct link *processes;     /* List of process names */
    struct idbug_state *next_state;   /* Next state in the list */
  };

/*
 * Local variables not seen by user.
 */

struct idbug_code_state
  {
    int lineno;			/* Current debugger output line number */
    int level;			/* Current function nesting level */
    char *func;			/* Name of current user function */
    char *file;			/* Name of current user file */
    char **framep;		/* Pointer to current frame */
    int jmplevel;		/* Remember nesting level at setjmp () */
    char *jmpfunc;		/* Remember current function for setjmp */
    char *jmpfile;		/* Remember current file for setjmp */

/*
 * The following variables are used to hold the state information
 * between the call to _db_pargs_() and _db_doprnt_(), during
 * expansion of the DBUG_PRINT macro.  This is the only macro
 * that currently uses these variables.
 *
 * These variables are currently used only by _db_pargs_() and
 * _db_doprnt_().
 */

    unsigned int u_line;		/* User source code line number */
    char *u_keyword;		/* Keyword for current macro */
  };


typedef struct idbug_code_state idbug_code_state_t;

typedef int (*idbug_sanity_t) (const char *, unsigned int, void *);

struct idbug_s
  {
    int flags;
    FILE *_db_fp_;              /* Output stream, default stderr */
    char *_db_process_;         /* Pointer to process name; argv[0] */
    FILE *_db_pfp_;             /* Profile stream, 'dbugmon.out' */
    int _db_on_;                /* TRUE if debugging currently on */
    int _db_pon_;               /* TRUE if profile currently on */
    int _no_db_;                /* TRUE if no debugging at all */
    int init_done;              /* Set to TRUE when initialization done */
    jmp_buf _db_jmp_buf;				/* ??? */

    struct idbug_state _stack;
    struct idbug_state *stack;
    struct idbug_code_state _state;
    struct idbug_code_state * state;

    idbug_get_process_id_t get_process_id;
    idbug_get_thread_id_t get_thread_id;

    idbug_mutex_t *mutex;
    idbug_mutex_locker_t lock_mutex;
    idbug_mutex_unlocker_t unlock_mutex;

    idbug_sanity_t sanity;
    idbug_security_t security;

    void *opaque;
  };

typedef struct idbug_s idbug_t;

#define _db_code_state(a) ((a)->state)

#ifdef IDBUG_OFF

#define DBUG_INIT (i)
#define DBUG_DEINIT()
#define DBUG_ENTER(a1)
#define DBUG_ENTER_THREAD(a)
#define DBUG_EXIT(a1)
#define DBUG_RETURN(a1) return(a1)
#define DBUG_VOID_RETURN return
#define DBUG_EXECUTE(keyword,a1)
#define DBUG_PRINT(keyword,arglist)
#define DBUG_PUSH(a1)
#define DBUG_POP()
#define DBUG_PROCESS(a1)
#define DBUG_FILE (stderr)
#define DBUG_SETJMP setjmp
#define DBUG_LONGJMP longjmp
#define DBUG_DUMP(keyword,a1)
#define DBUG_CLONE_FOR_THREAD(dest, src)

#else

extern idbug_t *g_idbug_state;
extern idbug_thread_params_t idbug_no_thread_params;
extern idbug_process_params_t idbug_ansi_process_params;

extern EXPORT int _db_push_ (idbug_t * idbug, char *control);
extern EXPORT void _db_pop_ (idbug_t * idbug);
extern EXPORT void _db_enter_ (idbug_t * idbug, const char *_func_, const char *_file_, unsigned int _line_, char **_sfunc_, char **_sfile_, unsigned int * _slevel_, char ***_sframep_);
extern EXPORT void _db_return_ (idbug_t * idbug, unsigned int _line_, char **_sfunc_, char **_sfile_, unsigned int * _slevel_);
extern EXPORT void _db_pargs_ (idbug_t * idbug, unsigned int _line_, const char *keyword);
extern EXPORT void _db_doprnt_ (idbug_t * idbug, const char *format,...);
extern EXPORT char * _db_mprintf_ (const char *format,...);
extern EXPORT void _db_dump_ (idbug_t * idbug, unsigned int _line_, const char *keyword, const char *memory, unsigned int length);
extern EXPORT int _db_keyword_ (idbug_t * idbug, char *keyword);
extern EXPORT void _db_setjmp_ (idbug_t * idbug);
extern EXPORT void _db_longjmp_ (idbug_t * idbug);
extern EXPORT void _db_init_as_ (idbug_t * dest, idbug_t * source);

/*
 *       These macros provide a user interface into functions in the
 *       dbug runtime support library.  They isolate users from changes
 *       in the MACROS and/or runtime support.
 *
 *       The symbols "__LINE__" and "__FILE__" are expanded by the
 *       preprocessor to the current source file line number and file
 *       name respectively.
 *
 *       WARNING ---  Because the DBUG_ENTER macro allocates space on
 *       the user function's stack, it must precede any executable
 *       statements in the user function.
 *
 */

#define DBUG_INIT(doit, a, b, c, d, e) \
	auto char *_db_func_; \
	auto char *_db_file_; \
	auto unsigned int _db_level_; \
	auto char **_db_framep_; \
	doit; \
 	_db_init_ (IDBUG_IFACE, b, c, d, e); \
	_db_enter_ (IDBUG_IFACE, a,__FILE__,__LINE__,&_db_func_,&_db_file_,&_db_level_, \
		    &_db_framep_)

#define DBUG_DEINIT()
#define DBUG_ENTER(a) \
	auto char *_db_func_; \
	auto char *_db_file_; \
	auto unsigned int _db_level_; \
	auto char **_db_framep_; \
	_db_enter_ (IDBUG_IFACE, a,__FILE__,__LINE__,&_db_func_,&_db_file_,&_db_level_, \
		    &_db_framep_)

#ifdef MSS
#define DBUG_EXIT(a1) {DBUG_LEAVE; MSS_LOG_BLOCK_LIST; exit(a1); return (a1);}
#else /* !MSS */
#define DBUG_EXIT(a1) {DBUG_LEAVE; exit(a1);return (a1);}
#endif /* MSS */

#define DBUG_LEAVE \
 (_db_return_ (IDBUG_IFACE, __LINE__, &_db_func_, &_db_file_, &_db_level_))
/* #define DBUG_RETURN(a1) return (DBUG_LEAVE, (a1)) Alternate form */
#define DBUG_RETURN(a1) {DBUG_LEAVE; return(a1);}
#define DBUG_VOID_RETURN {DBUG_LEAVE; return;}
#define DBUG_EXECUTE(keyword,a1) \
	      {if (IDBUG_IFACE->_db_on_) {if (_db_keyword_ (IDBUG_IFACE, keyword)) { a1 }}}
#define DBUG_PRINT(keyword,arglist) \
	      { if (IDBUG_IFACE->_db_on_) { _db_pargs_(IDBUG_IFACE, __LINE__,keyword); _db_doprnt_ arglist;}}
#define DBUG_PUSH(a1) _db_push_ (IDBUG_IFACE, a1)
#define DBUG_POP() _db_pop_ (IDBUG_IFACE)
#define DBUG_PROCESS(a1) (IDBUG_IFACE->_db_process_ = a1)
#define DBUG_FILE (IDBUG_IFACE->_db_fp_)
#define DBUG_SETJMP(a1) (_db_setjmp_ (IDBUG_IFACE), setjmp (a1))
#define DBUG_LONGJMP(a1,a2) (_db_longjmp_ (IDBUG_IFACE), longjmp (a1, a2))
#define DBUG_DUMP(keyword,a1,a2) _db_dump_(IDBUG_IFACE, __LINE__,keyword,a1,a2)
#define DBUG_INIT_AS(dest, src) _db_init_as_ (dest, src)
#define DBUG_MPRINT(keyword,arglist) \
	{	\
		if(IDBUG_IFACE->_db_on_)\
			{\
				auto char*xxDBUG_MSG;\
				_db_pargs_(IDBUG_IFACE, __LINE__,keyword); \
				xxDBUG_MSG = _db_mprintf_ arglist;\
				if (xxDBUG_MSG != NULL) _db_doprnt_ (IDBUG_IFACE, xxDBUG_MSG); \
				else _db_doprnt_ (IDBUG_IFACE, "warning: malloc out of memory !"); \
				if (xxDBUG_MSG != NULL)	free (xxDBUG_MSG);\
			}\
	}

#endif /* ! IDBUG_OFF */

#include "sysdep.h"

#endif /* _DBUG_H_ */
