#ifdef DBUG_OFF                 /* We are testing dbug */
#undef DBUG_OFF
#endif

#include <math.h>

#define IDBUG_IFACE g_idbug_state

#include "dbug.h"

jmp_buf restart;

void
spend_some_time (void)
{
  int j = 10000;
  DBUG_ENTER ("spend_some_time");
  while (j)
    {
      pow (j, j / 2);
      j--;
    }
  DBUG_VOID_RETURN;
}


int
factorial (int value)
{
  int j = 10000;

  DBUG_ENTER ("factorial");
  DBUG_MPRINT ("find", ("find %d factorial", value));

	if (value > 13)
		DBUG_LONGJMP (restart, 2);

  if (value > 1)
    {
      value *= factorial (value - 1);
      spend_some_time ();
    }
  DBUG_MPRINT ("result", ("result is %d", value));
  DBUG_RETURN (value);
}


long unsigned int
id (void *dbug_opaque)
{
  return 1;
}

static void
init (int * i, int argc, char ** argv)
{
	int ix = *i;


  for (ix = 1; ix < argc && argv[ix][0] == '-'; ix++)
    {
      switch (argv[ix][1])
        {
        case '#':
          DBUG_PUSH (&(argv[ix][2]));
          break;
        }
    }

	*i = ix;
}

int
main (int argc, char **argv)
{
  int result, ix, foo;
  idbug_process_params_t pp;



  DBUG_INIT (pp.name = "argv[0]";
              pp.id = id;
              pp.thread_params = &idbug_no_thread_params,
              "main", 0, &pp, NULL, NULL);


  if ((foo = DBUG_SETJMP (restart)) != 0)
    {
			switch (foo)
				{
					case 1:
      			DBUG_MPRINT ("main", ("exiting because not enough parameters"));
      			fprintf (stderr, "usage: %s [debug-options] [number]\n",
							argv[0]);
      			exit (EXIT_FAILURE);
						break;
					case 2:
      			DBUG_MPRINT ("main", ("exiting because an error occurred"));
      			exit (EXIT_FAILURE);
						break;
				}
    }

  if (argc < 3)
    DBUG_LONGJMP (restart, 1);

	init (&ix, argc, argv);
  for (; ix < argc; ix++)
    {
      DBUG_MPRINT ("args", ("argv[%d] = %s", ix, argv[ix]));
      result = factorial (atoi (argv[ix]));
      printf ("%d\n", result);
    }

  DBUG_MPRINT ("push", ("pushing d:g ...\n"));
  DBUG_PUSH ("f,main:d:g");
  result = factorial (atoi (argv[2]));
  printf ("%d\n", result);

  DBUG_MPRINT ("pop", ("popping...\n"));
  DBUG_POP ();
  result = factorial (atoi (argv[2]));
  printf ("%d\n", result);

	/* clean the memory */
  DBUG_POP ();
  DBUG_EXIT (0);
}
