#ifdef  IDBUG_OS_UNIX

#define IDBUG_IMPLEMENTATION

#include "dbug.h"

void
idbug_init_security (idbug_t * idbug)
{
	idbug->security.pchown = chown;
	idbug->security.pgetuid = getuid;
	idbug->security.pgetgid = getgid;
}

/*
 * For unix systems checks that the directory is writable
 */
int
idbug_writable (idbug_t * idbug, const char *pathname)
{
  register int granted;
  register char *lastslash;

  granted = 0;
  if (access (pathname, F_OK) == 0)
    {
      if (access (pathname, W_OK) == 0)
        {
          granted = TRUE;
        }
    }
  else
    {
      lastslash = strrchr (pathname, '/');
      if (lastslash != NULL)
        {
          *lastslash = '\0';
        }
      else
        {
          pathname = ".";
        }
      if (access (pathname, W_OK) == 0)
        {
          granted = 1;
        }
      if (lastslash != NULL)
        {
          *lastslash = '/';
        }
    }
  return granted;
}

#endif /* DBUG_OS_UNIX */
