#include <windows.h>
#define IDBUG_IFACE (idbug)
#define DBUG_OS_W32

#include "dbug.h"

/*
 * $Id: test_w32.c 1.3 2000-08-09 18:55:56+02 federico Exp fede $
 * $Log: test_w32.c $
 * Revision 1.3  2000-08-09 18:55:56+02  federico
 * ?.
 *
 * Revision 1.2  2000/08/08 16:25:39  federico
 * DBUG_CLONE... -> DBUG_INIT_AS.
 *
 * Revision 1.1  2000/08/06 00:45:10  federico
 * Initial revision
 *
 *
 * TESTS:
 * - test flushing
 * - out of memory condition
 * - no profile with threads;
 * - global interface: single debug file
 * - local interface: allocated by main and shared with threads
 * - critical sections
 * - writable
 * - output to a window
 */

enum
  {
    SH_BF_SZ = 2048,
		PAUSE = 1
  };

struct thread_arguments
  {
    idbug_t *idbug;
    CRITICAL_SECTION * lpCs;
    FILE *fp;
    FILE *fpout;
    char * shared_buffer;
    unsigned int * n;
    char * done;
  };


DWORD WINAPI
Produce (LPVOID lpvThreadParam)
{
  DWORD dwResult = 0;
  struct thread_arguments *ta = (struct thread_arguments *) lpvThreadParam;
  idbug_t *idbug = ta->idbug;
  int c, n;

  DBUG_ENTER ("Produce");
  DBUG_PRINT ("done", (IDBUG_IFACE, "Entering CS to set done to zero"));

  EnterCriticalSection (ta->lpCs);
  (*ta->done) = 0;
  DBUG_PRINT ("done", (IDBUG_IFACE, "done set to zero"));
  LeaveCriticalSection (ta->lpCs);
  DBUG_PRINT ("done", (IDBUG_IFACE, "Exited CS to set done to zero"));

  c = fgetc (ta->fp);
  while (c != EOF)
    {
			Sleep (PAUSE);
      // acquire cs
      EnterCriticalSection (ta->lpCs);
      DBUG_PRINT ("buffer", (IDBUG_IFACE,
				"Entered CS to fill buffer: (n=%d)", *(ta->n)));
      if (*ta->n == 0)
        {
          // fill buffer
          for (n = 0; c != EOF && n < SH_BF_SZ; n++)
            {
              ta->shared_buffer[n] = c;
              c = fgetc (ta->fp);
            }
					*ta->n = n;
          DBUG_PRINT ("buffer", (IDBUG_IFACE,
						"buffer filled: (n=%d, ta->n=%d)", n, *ta->n));
          if (c == EOF)
            {
              DBUG_PRINT ("read", (IDBUG_IFACE, "READ OF STREAM ENDED"));
              *ta->done = 1;
            }
        }
      // release cs
      DBUG_PRINT ("buffer", (IDBUG_IFACE, "Exiting CS to fill buffer"));
      LeaveCriticalSection (ta->lpCs);
    }

	fprintf (stderr, "\nProducer has finished ... \n");
	fflush (stderr);
	fprintf (stderr, "produced state: %p\n", _db_code_state (idbug));

  DBUG_RETURN (dwResult);
}

DWORD WINAPI
Consume (LPVOID lpvThreadParam)
{
  DWORD dwResult = 0;
  struct thread_arguments *ta = (struct thread_arguments *) lpvThreadParam;
  idbug_t *idbug = ta->idbug;
  int i, done;

  DBUG_ENTER ("Consume");

  do {
      // acquire cs
      EnterCriticalSection (ta->lpCs);
      DBUG_MPRINT ("buffer", ("Entered CS to output buffer: (n=%d)", *ta->n));
			//DBUG_DUMP ("buffer", ta->shared_buffer, SH_BF_SZ);
      done = *ta->done;

      if (done)
        DBUG_PRINT ("buffer", (IDBUG_IFACE, "This is the last buffer"));

			if (*ta->n > 0)
				{
		      for (i = 0; i < *ta->n && i < SH_BF_SZ; i++)
						{
			        fputc (ta->shared_buffer[i], ta->fpout);
						}

					*ta->n = 0;
		      DBUG_PRINT ("buffer", (IDBUG_IFACE, "buffer outputted"));
				}

      DBUG_PRINT ("buffer", (IDBUG_IFACE, "Exiting CS to output buffer"));
      LeaveCriticalSection (ta->lpCs);
			Sleep (PAUSE);
    } while (!done);

	fprintf (stderr, "\nConsumer has finished ... \n");
	fprintf (stderr, "consumer state: %p\n", _db_code_state (idbug));

  DBUG_RETURN (dwResult);
}

int
myEnterCriticalSection (void *cs)
{
  return EnterCriticalSection ((CRITICAL_SECTION *) cs), 1;
}

int
myLeaveCriticalSection (void *cs)
{
  return LeaveCriticalSection ((CRITICAL_SECTION *) cs), 1;
}

long unsigned int
myGetCurrentThreadId (void *ctx)
{
	return (long unsigned int) GetCurrentThreadId ();
}

long unsigned int
myGetCurrentProcessId (void *ctx)
{
  return (long unsigned int) GetCurrentProcessId ();
}

typedef unsigned (__stdcall * PTHREAD_START) (void *);

#define chBEGINTHREADEX(lpsa, cbStack, lpStartAddr, \
   lpvThreadParm, fdwCreate, lpIDThread)            \
      ((HANDLE)_beginthreadex(                      \
         (void *) (lpsa),                           \
         (unsigned) (cbStack),                      \
         (PTHREAD_START) (lpStartAddr),             \
         (void *) (lpvThreadParm),                  \
         (unsigned) (fdwCreate),                    \
         (unsigned *) (lpIDThread)))

int
main (int argc, char **argv)
{
  idbug_t _idbug;
  idbug_t _idbugc;
  idbug_t *idbug = &_idbug;
  idbug_t *idbugc = &_idbugc;
  CRITICAL_SECTION sync_cs;
  struct thread_arguments tac, tap;
  HANDLE hThread[2];
  DWORD dwThreadId[2];
  unsigned int n;
  char done;
  char shared_buffer[SH_BF_SZ] = "";

  DBUG_INIT_W32 (1, "main");

  DBUG_PROCESS (argv[0]);
  //DBUG_PUSH ("d:t:L:o,test_w32.out");
	DBUG_PUSH (argv[1]);

	/*
	 * Here we initialize a second interface to idubg services
	 * as the first one
	 */
	DBUG_INIT_AS (idbugc, idbug);

	fprintf (stderr, "sizeof (idbug->_db_jmp_buf): %d\n",
		sizeof (idbug->_db_jmp_buf));
	fprintf (stderr, "produced state: %p\n", _db_code_state (idbug));
	fprintf (stderr, "consumer state: %p\n", _db_code_state (idbugc));

  tap.fp = tac.fp = fopen (argv[2], "rb");
  tap.fpout = tac.fpout = fopen (argv[3], "wb");
  tap.idbug = idbug;
  tac.idbug = idbugc;
  n = 0;
	done = 0;
  tap.done = tac.done = &done;
  tap.n = tac.n = &n;
	tap.shared_buffer = tac.shared_buffer = shared_buffer;

  InitializeCriticalSection (&sync_cs);

	tap.lpCs = tac.lpCs = &sync_cs;

  assert (tap.fp != NULL);
  assert (tap.fpout != NULL);

	DBUG_PRINT ("thread", (IDBUG_IFACE, "Starting Producer"));
  // start producer
  hThread[0] = chBEGINTHREADEX (NULL, 0, Produce, (LPVOID) & tap,
		0, &dwThreadId[0]);
	DBUG_PRINT ("thread", (IDBUG_IFACE, "Producer Started"));

  // start consumer
	DBUG_PRINT ("thread", (IDBUG_IFACE, "Starting Consumer"));
  hThread[1] = chBEGINTHREADEX (NULL, 0, Consume, (LPVOID) & tac,
		0, &dwThreadId[1]);
	DBUG_PRINT ("thread", (IDBUG_IFACE, "Consumer Started"));

  // produce and consume
	DBUG_PRINT ("thread", (IDBUG_IFACE, "Waiting for producer and consumer"));
  //WaitForMultipleObjects (2, hThread, TRUE, INFINITE);

	WaitForSingleObject (hThread[0], INFINITE);
	DBUG_PRINT ("thread", (IDBUG_IFACE, "Producer is finished"));
	fprintf (stderr, "produced state: %p\n", _db_code_state (idbug));
	fprintf (stderr, "consumer state: %p\n", _db_code_state (idbugc));

	WaitForSingleObject (hThread[1], INFINITE);
	DBUG_PRINT ("thread", (IDBUG_IFACE, "Consumer is finished"));

	fprintf (stderr, "produced state: %p\n", _db_code_state (idbug));
	fprintf (stderr, "consumer state: %p\n", _db_code_state (idbugc));

  // end
  fclose (tap.fp);
  fclose (tap.fpout);

  DeleteCriticalSection (&sync_cs);

	fprintf (stderr, "state: %p", _db_code_state (idbug));

  DBUG_RETURN (EXIT_SUCCESS);
}


