#include <windows.h>
#include "imem_w32.h"

enum
  {
    THREAD_NUMBER = 2,
    THIS_SIZE = 2048,
    FIRST_SIZE = 1024,
    SECOND_TIMES = 1024
  };



struct p_s
  {
    int type;
    char *name;
  };

DWORD WINAPI
FirstThread (LPVOID lpvThreadParam)
{
  DWORD dwResult = 0;
  imem_t imem1;
  int i;
  struct p_s *p;
  char *text;


  fprintf (stderr, "\nFirst Thread: memory interface ... ");
  fflush (stderr);

  assert (imem_init_w32 (&imem1) == IMEM_OK);

  fprintf (stderr, "initialized\n");
  fflush (stderr);


  imem_set_mem_space (&imem1, 1);

  __try
  {
    /* should corrupt the heap */

    /* create an object */
    p = imem_malloc (&imem1, sizeof (struct p_s), __FILE__,
                     __LINE__, "FirstThread");
	  imem_free (&imem1, p, __FILE__, __LINE__, "FisrtThread");

    p = imem_malloc (&imem1, sizeof (struct p_s), __FILE__,
                     __LINE__, "FirstThread");

    assert (p != NULL);

    p->name = imem_malloc (&imem1, FIRST_SIZE,
                           __FILE__, __LINE__, "FirstThread");

    Sleep (10);

    i = 1;
    while (i++)
      {
        int j;

        /* obtain some information on p */

        text = p->name;

        assert (text != NULL);

        /* reallocate it: this may 'invalidate' the memory address above */
        p->name = imem_realloc (&imem1, p->name,
                       i * (FIRST_SIZE), __FILE__, __LINE__, "FirstThread");

        assert (p->name != NULL);


        /* use the previous information to print something */

        sprintf (text, "Ora ho allocato %ldMB e text %s p->name",
                 i * FIRST_SIZE / 1024, text != p->name ? "!=" : "==");

        Sleep (10);

        fprintf (stderr, "\rFirst Thread: %d (%p,%p) [%s]", i,
					p, p->name, text);
        fflush (stderr);

        memset (text, 'K', i * FIRST_SIZE);
      }
  }
  __except (EXCEPTION_EXECUTE_HANDLER)
  {
    fprintf (stderr, "\nFirst Thread generated an exception!\n");
    fprintf (stderr, "First Thread: %d (%p)\n", i, p);
    fprintf (stderr, "First Thread: size: %ld\n", i * (FIRST_SIZE));
  }
  /* now go on with this Heap */

  imem_deinit_w32 (&imem1);

  fprintf (stderr, "\nFirst Thread: memory interface ... ");
  fflush (stderr);

  assert (imem_init_w32 (&imem1) == IMEM_OK);

  fprintf (stderr, "reinitialized\n");
  fflush (stderr);
  __try
  {

    /* should corrupt the heap */

    /* create an object */
    p = imem_malloc (&imem1, sizeof (struct p_s), __FILE__,
                     __LINE__, "FirstThread");

    assert (p != NULL);

    p->name = imem_malloc (&imem1, FIRST_SIZE,
                           __FILE__, __LINE__, "FirstThread");


    Sleep (10);

    i = 1;
    while (i++)
      {
        int j;

        /* obtain some information on p */

        text = p->name;

        assert (text != NULL);

        /* reallocate it: this may 'invalidate' the memory address above */
        p->name = imem_realloc (&imem1, p->name,
                       i * (FIRST_SIZE), __FILE__, __LINE__, "FirstThread");

        assert (p->name != NULL);


        /* use the previous information to print something */

        sprintf (text, "Ora ho allocato %ldMB e text %s p->name",
                 i * FIRST_SIZE / 1024, text != p->name ? "!=" : "==");

        Sleep (10);

        fprintf (stderr, "\rFirst Thread: %d (%p) [%s]", i, p, text);
        fflush (stderr);

        memset (text, 'K', i * FIRST_SIZE);
      }

  }
  __except (EXCEPTION_EXECUTE_HANDLER)
  {
    fprintf (stderr, "\nFirst Thread generated an exception!\n");
    fprintf (stderr, "First Thread: %d (%p)\n", i, p);
    fprintf (stderr, "First Thread: size: %ld\n", i * (FIRST_SIZE));
  }

  imem_deinit (&imem1, 0);

  return dwResult;
}


DWORD WINAPI
SecondThread (LPVOID lpvThreadParam)
{
  DWORD dwResult = 0;
  imem_t imem;
  unsigned char *p;
  int i;

  assert (imem_init_ansi (&imem) == IMEM_OK);

  for (i = 0; i < SECOND_TIMES; i++)
    {
      int j;
      fprintf (stderr, "\rSecond Thread: %d", i);
      p = imem_malloc (&imem, FIRST_SIZE, __FILE__, __LINE__, "FirstThread");

      for (j = 0; j < FIRST_SIZE; j++)
        p[j] = i % 255;

      Sleep (10);

      imem_free (&imem, p, __FILE__, __LINE__, "FirstThread");
    }

  imem_deinit (&imem, 0);

  return dwResult;
}

typedef unsigned (__stdcall * PTHREAD_START) (void *);

#define chBEGINTHREADEX(lpsa, cbStack, lpStartAddr, \
   lpvThreadParm, fdwCreate, lpIDThread)            \
      ((HANDLE)_beginthreadex(                      \
         (void *) (lpsa),                           \
         (unsigned) (cbStack),                      \
         (PTHREAD_START) (lpStartAddr),             \
         (void *) (lpvThreadParm),                  \
         (unsigned) (fdwCreate),                    \
         (unsigned *) (lpIDThread)))


int
main (int argc, char **argv)
{
  HANDLE hThread[THREAD_NUMBER];
  DWORD dwThreadId[THREAD_NUMBER];

  hThread[0] = chBEGINTHREADEX (NULL, 0, FirstThread,
                                NULL, 0, &dwThreadId[0]);

  assert (hThread[0] != NULL);
  fprintf (stderr, "First thread started ...\n");

  if (argc == 1)
    {
      hThread[1] = chBEGINTHREADEX (NULL, 0, SecondThread,
                                    NULL, 0, &dwThreadId[1]);
      assert (hThread[1] != NULL);
      fprintf (stderr, "Second thread started ...\n");
      WaitForMultipleObjects (THREAD_NUMBER, hThread, TRUE, INFINITE);
      fprintf (stderr, "Closing threads ...\n");

      CloseHandle (hThread[1]);
    }
  else
    {
      WaitForMultipleObjects (THREAD_NUMBER - 1, hThread, TRUE, INFINITE);
      fprintf (stderr, "Closing threads ...\n");
      CloseHandle (hThread[0]);
    }

  return 0;
}
