#ifndef _IUSER_ERROR_H_
#define _IUSER_ERROR_H_

typedef enum
  {
    IUSER_SEVERITY_NONE    = 0,
    IUSER_SEVERITY_INFO    = 1,
    IUSER_SEVERITY_WARN    = 2,
    IUSER_SEVERITY_SEVERE  = 3,
    IUSER_SEVERITY_FATAL   = 4,
    IUSER_SEVERITY_LAST
  }
iuser_severity_t;

typedef enum
  {
    IUSER_DISPATCH_EXIT     = 0x01,
    IUSER_DISPATCH_DUMP     = 0x02,
    IUSER_DISPATCH_LOG      = 0x04,
		IUSER_DISPATCH_CALLBACK = 0x08,
    IUSER_DISPATCH_ABORT    = IUSER_DISPATCH_EXIT | IUSER_DISPATCH_DUMP,
    IUSER_DISPATCH_NULL     = 0x00
  }
iuser_dispatch_t;

typedef enum
  {
    IUSER_OVERRIDE_YIELD    = 0,
    IUSER_OVERRIDE_DOMINATE = 1
  }
iuser_override_t;

typedef struct
  {
    iuser_dispatch_t _dispatch_table[IUSER_SEVERITY_LAST];
    iuser_override_t _override;
    void * opaque;	/* a FILE, a window HANDLE, maybe a socket ... */
  }
iuser_error_context_t;

struct _error_s {
	int _code;
	iuser_severity_t _severity;
	iuser_message_t _msg;
	const char * _file;
	const char_t * _name;
	size_t _line;

	iuser_error_context_t _context;
	int (* _cb) (struct _error_s*, int);

	unsigned int _flags;
	void * _opaque;

#if 0 /*IUSER_ERROR_WITH_EXCEPTION*/
	/* exception */
	except_t _except;
#endif
	};

typedef struct _error_s iuser_error_t;
typedef int (* iuser_error_callback_t) (iuser_error_t *, int);


	extern int iuser_error_init (iuser_error_t *, char_t * , iuser_error_context_t *,iuser_error_callback_t, void *);
	extern void iuser_error_deinit (iuser_error_t *);
	extern void iuser_error_clear (iuser_error_t *);
	extern iuser_error_context_t * iuser_error_set_context (iuser_error_t *,iuser_error_context_t *);
	extern iuser_error_context_t * iuser_error_get_context (iuser_error_t * );
	extern iuser_error_callback_t iuser_error_set_callback (iuser_error_t *,iuser_error_callback_t);
	extern iuser_error_callback_t iuser_error_get_callback (iuser_error_t *);
	extern void * iuser_error_set_opaque (iuser_error_t *, void *);
	extern void * iuser_error_get_opaque (iuser_error_t *);
	extern char_t * iuser_error_format_severity (iuser_error_t * ierror);
	extern char_t * iuser_error_get_message (iuser_error_t * ierror);
	extern char * iuser_error_get_file (iuser_error_t * ierror);
	extern size_t iuser_error_get_line (iuser_error_t * ierror);

/*
 * GLOBALS
 */
extern iuser_error_t * const g_iuser_error;

extern const iuser_error_context_t iuser_error_context_impl;
extern const iuser_error_context_t iuser_error_context_user;
extern const iuser_error_context_t iuser_error_context_nosey;
extern const iuser_error_context_t iuser_error_context_paranoid;

#endif /* !_IUSER_ERROR_H_ */
