/*------------------------------------------------------------------------
 Module:        PROGRESSBAR.H
 Author:        Daniel Guerrero Miralles
 Project:       TreeSize
 State:         zero
 Creation Date: 26/10/98
 Description:   Interface to progress bar common control.
                Resembles the CProgressCtrl in MFC. Don't
                forget to call "InitCommonControls()".
------------------------------------------------------------------------*/
#include <windows.h>
#include <commctrl.h>

#ifndef _PROGRESSBAR_H_
#define _PROGRESSBAR_H_

/* --- Macros --- */

#define ProgressBar_SetRange(hwnd,nLower,nUpper) \
((void)SendMessage(hwnd,PBM_SETRANGE,(WPARAM)0,MAKELPARAM(nLower,nUpper)))

#define ProgressBar_SetPos(hwnd,nPos) \
((int)SendMessage(hwnd,PBM_SETPOS,(WPARAM)nPos,(LPARAM)0))

#define ProgressBar_OffsetPos(hwnd,nIncrement) \
((int)SendMessage(hwnd,PBM_DELTAPOS,(WPARAM)nIncrement,(LPARAM)0))

#define ProgressBar_SetStep(hwnd,nStep) \
((int)SendMessage(hwnd,PBM_SETSTEP,(WPARAM)nStep,(LPARAM)0))

#define ProgressBar_StepIt(hwnd) \
((int)SendMessage(hwnd,PBM_STEPIT,(WPARAM)0,(LPARAM)0))

#define ProgressBar_Create(hwParent,hInst,nChildId,cx,cy,cw,ch) \
((HWND)CreateWindow(PROGRESS_CLASS, (LPSTR)NULL,WS_CHILD|WS_VISIBLE,\
cx,cy,cw,ch,hwParent,(HMENU)nChildId,hInst,NULL))

#define ProgressBar_Destroy(hwnd) ((void)DestroyWindow(hwnd))

/* --- Functions --- */

#endif
