% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ss_count_cond}
\alias{ss_count_cond}
\title{Compute the number or count of matching conditions}
\usage{
ss_count_cond(data, name, vars, exclude = NULL, combine = FALSE, cond, max_na)
}
\arguments{
\item{data}{tbl. Data frame containing the columns to be summarized.}

\item{name}{character. The name of the summary score.}

\item{vars}{character vector. The names of the columns to be summarized.}

\item{exclude}{character (vector). The value(s) to be excluded (Default:
NULL; all values are used).}

\item{combine}{logical. Whether to combine the summary score column with the
input data frame (Default: FALSE).}

\item{cond}{character vector. Each specified condition, involving the values
of specific input fields, gets tested for \code{1} (\code{TRUE}) or \code{0} (\code{FALSE}).
If a condition is specified as \code{"field_name"}, the numeric value
in the field is counted and could be greater than 1. Whereas other
conditions when met can get a value of \code{1} or \code{0}. The summary score
is a sum over all the values obtained from testing each condition
specified in \code{cond}.}

\item{max_na}{numeric, positive whole number. Number of
missing items allowed.}
}
\value{
tbl. The input data frame with the summary score appended as a new
column.
}
\description{
Computes the number of conditions (provided as a character vector\code{cond}),
involving the input variables \code{vars}, that were found to be \code{TRUE}.
Options available to exclude certain values from the input variables
(provided as a character vector \code{exclude}).
}
